/* rygel-media-device.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-media-device.vala, do not modify */

/*
 * Copyright (C) 2012 Openismus GmbH.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include "rygel-core.h"
#include <libgupnp/gupnp.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgssdp/gssdp.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define RYGEL_TYPE_DEVICE_CONTEXT (rygel_device_context_get_type ())
#define RYGEL_DEVICE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DEVICE_CONTEXT, RygelDeviceContext))
#define RYGEL_DEVICE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DEVICE_CONTEXT, RygelDeviceContextClass))
#define RYGEL_IS_DEVICE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DEVICE_CONTEXT))
#define RYGEL_IS_DEVICE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DEVICE_CONTEXT))
#define RYGEL_DEVICE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DEVICE_CONTEXT, RygelDeviceContextClass))

typedef struct _RygelDeviceContext RygelDeviceContext;
typedef struct _RygelDeviceContextClass RygelDeviceContextClass;
typedef struct _RygelDeviceContextPrivate RygelDeviceContextPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_device_context_unref0(var) ((var == NULL) ? NULL : (var = (rygel_device_context_unref (var), NULL)))
typedef struct _RygelParamSpecDeviceContext RygelParamSpecDeviceContext;
enum  {
	RYGEL_MEDIA_DEVICE_0_PROPERTY,
	RYGEL_MEDIA_DEVICE_PLUGIN_PROPERTY,
	RYGEL_MEDIA_DEVICE_TITLE_PROPERTY,
	RYGEL_MEDIA_DEVICE_CAPABILITIES_PROPERTY,
	RYGEL_MEDIA_DEVICE_NUM_PROPERTIES
};
static GParamSpec* rygel_media_device_properties[RYGEL_MEDIA_DEVICE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelDeviceContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelDeviceContextPrivate * priv;
	RygelRootDevice* device;
	RygelRootDeviceFactory* factory;
	GUPnPContext* context;
};

struct _RygelDeviceContextClass {
	GTypeClass parent_class;
	void (*finalize) (RygelDeviceContext *self);
};

struct _RygelParamSpecDeviceContext {
	GParamSpec parent_instance;
};

struct _RygelMediaDevicePrivate {
	GeeArrayList* interfaces;
	GeeHashMap* contexts;
	GeeHashMap* devices;
	GUPnPContextManager* manager;
	RygelPlugin* _plugin;
	gchar* _title;
	RygelPluginCapabilities _capabilities;
};

static gpointer rygel_device_context_parent_class = NULL;
static gint RygelMediaDevice_private_offset;
static gpointer rygel_media_device_parent_class = NULL;

VALA_EXTERN gpointer rygel_device_context_ref (gpointer instance);
VALA_EXTERN void rygel_device_context_unref (gpointer instance);
VALA_EXTERN GParamSpec* rygel_param_spec_device_context (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void rygel_value_set_device_context (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void rygel_value_take_device_context (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer rygel_value_get_device_context (const GValue* value);
VALA_EXTERN GType rygel_device_context_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelDeviceContext* rygel_device_context_new (GUPnPContext* context,
                                              RygelPlugin* plugin,
                                              GError** error);
VALA_EXTERN RygelDeviceContext* rygel_device_context_construct (GType object_type,
                                                    GUPnPContext* context,
                                                    RygelPlugin* plugin,
                                                    GError** error);
static void rygel_device_context_finalize (RygelDeviceContext * obj);
static GType rygel_device_context_get_type_once (void);
static void rygel_media_device_real_constructed (GObject* base);
static void rygel_media_device_on_context_available (RygelMediaDevice* self,
                                              GUPnPContext* context);
static void _rygel_media_device_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender,
                                                                                       GUPnPContext* context,
                                                                                       gpointer self);
static void rygel_media_device_on_context_unavailable (RygelMediaDevice* self,
                                                GUPnPContext* context);
static void _rygel_media_device_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender,
                                                                                           GUPnPContext* context,
                                                                                           gpointer self);
static void rygel_media_device_finalize (GObject * obj);
static GType rygel_media_device_get_type_once (void);
static void _vala_rygel_media_device_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_rygel_media_device_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelDeviceContext*
rygel_device_context_construct (GType object_type,
                                GUPnPContext* context,
                                RygelPlugin* plugin,
                                GError** error)
{
	RygelDeviceContext* self = NULL;
	GUPnPContext* _tmp0_;
	RygelRootDeviceFactory* _tmp1_ = NULL;
	RygelRootDeviceFactory* _tmp2_;
	RygelRootDeviceFactory* _tmp3_;
	RygelRootDevice* _tmp4_ = NULL;
	RygelRootDeviceFactory* _tmp5_;
	RygelRootDevice* _tmp6_;
	RygelRootDevice* _tmp7_;
	RygelRootDevice* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (plugin != NULL, NULL);
	self = (RygelDeviceContext*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (context);
	_g_object_unref0 (self->context);
	self->context = _tmp0_;
	_tmp2_ = rygel_root_device_factory_new (context, &_inner_error0_);
	_tmp1_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_rygel_device_context_unref0 (self);
		return NULL;
	}
	_tmp3_ = _tmp1_;
	_tmp1_ = NULL;
	_g_object_unref0 (self->factory);
	self->factory = _tmp3_;
	_tmp5_ = self->factory;
	_tmp6_ = rygel_root_device_factory_create (_tmp5_, plugin, &_inner_error0_);
	_tmp4_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp1_);
		_rygel_device_context_unref0 (self);
		return NULL;
	}
	_tmp7_ = _tmp4_;
	_tmp4_ = NULL;
	_g_object_unref0 (self->device);
	self->device = _tmp7_;
	_tmp8_ = self->device;
	gupnp_root_device_set_available ((GUPnPRootDevice*) _tmp8_, TRUE);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
	return self;
}

RygelDeviceContext*
rygel_device_context_new (GUPnPContext* context,
                          RygelPlugin* plugin,
                          GError** error)
{
	return rygel_device_context_construct (RYGEL_TYPE_DEVICE_CONTEXT, context, plugin, error);
}

static void
rygel_value_device_context_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
rygel_value_device_context_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		rygel_device_context_unref (value->data[0].v_pointer);
	}
}

static void
rygel_value_device_context_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_device_context_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
rygel_value_device_context_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
rygel_value_device_context_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		RygelDeviceContext * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_device_context_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
rygel_value_device_context_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	RygelDeviceContext ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_device_context_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
rygel_param_spec_device_context (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	RygelParamSpecDeviceContext* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_DEVICE_CONTEXT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
rygel_value_get_device_context (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DEVICE_CONTEXT), NULL);
	return value->data[0].v_pointer;
}

void
rygel_value_set_device_context (GValue* value,
                                gpointer v_object)
{
	RygelDeviceContext * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DEVICE_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_DEVICE_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_device_context_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_device_context_unref (old);
	}
}

void
rygel_value_take_device_context (GValue* value,
                                 gpointer v_object)
{
	RygelDeviceContext * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DEVICE_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_DEVICE_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_device_context_unref (old);
	}
}

static void
rygel_device_context_class_init (RygelDeviceContextClass * klass,
                                 gpointer klass_data)
{
	rygel_device_context_parent_class = g_type_class_peek_parent (klass);
	((RygelDeviceContextClass *) klass)->finalize = rygel_device_context_finalize;
}

static void
rygel_device_context_instance_init (RygelDeviceContext * self,
                                    gpointer klass)
{
	self->ref_count = 1;
}

static void
rygel_device_context_finalize (RygelDeviceContext * obj)
{
	RygelDeviceContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DEVICE_CONTEXT, RygelDeviceContext);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->device);
	_g_object_unref0 (self->factory);
	_g_object_unref0 (self->context);
}

 G_GNUC_NO_INLINE static GType
rygel_device_context_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { rygel_value_device_context_init, rygel_value_device_context_free_value, rygel_value_device_context_copy_value, rygel_value_device_context_peek_pointer, "p", rygel_value_device_context_collect_value, "p", rygel_value_device_context_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (RygelDeviceContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_device_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDeviceContext), 0, (GInstanceInitFunc) rygel_device_context_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType rygel_device_context_type_id;
	rygel_device_context_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelDeviceContext", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return rygel_device_context_type_id;
}

GType
rygel_device_context_get_type (void)
{
	static volatile gsize rygel_device_context_type_id__once = 0;
	if (g_once_init_enter (&rygel_device_context_type_id__once)) {
		GType rygel_device_context_type_id;
		rygel_device_context_type_id = rygel_device_context_get_type_once ();
		g_once_init_leave (&rygel_device_context_type_id__once, rygel_device_context_type_id);
	}
	return rygel_device_context_type_id__once;
}

gpointer
rygel_device_context_ref (gpointer instance)
{
	RygelDeviceContext * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
rygel_device_context_unref (gpointer instance)
{
	RygelDeviceContext * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_DEVICE_CONTEXT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
rygel_media_device_get_instance_private (RygelMediaDevice* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaDevice_private_offset);
}

static void
_rygel_media_device_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender,
                                                                                  GUPnPContext* context,
                                                                                  gpointer self)
{
	rygel_media_device_on_context_available ((RygelMediaDevice*) self, context);
}

static void
_rygel_media_device_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender,
                                                                                      GUPnPContext* context,
                                                                                      gpointer self)
{
	rygel_media_device_on_context_unavailable ((RygelMediaDevice*) self, context);
}

static void
rygel_media_device_real_constructed (GObject* base)
{
	RygelMediaDevice * self;
	gint port = 0;
	GUPnPContextManager* _tmp4_;
	GUPnPContextManager* _tmp5_;
	GUPnPContextManager* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeHashMap* _tmp8_;
	GeeHashMap* _tmp9_;
	GError* _inner_error0_ = NULL;
	self = (RygelMediaDevice*) base;
	G_OBJECT_CLASS (rygel_media_device_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	port = 0;
	{
		gint _tmp0_ = 0;
		RygelMetaConfig* _tmp1_;
		RygelMetaConfig* _tmp2_;
		gint _tmp3_;
		_tmp1_ = rygel_meta_config_get_default ();
		_tmp2_ = _tmp1_;
		_tmp3_ = rygel_configuration_get_port ((RygelConfiguration*) _tmp2_, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		port = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_debug ("rygel-media-device.vala:65: No listening port specified, using random " \
"TCP port");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = gupnp_context_manager_create ((guint) port);
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp4_;
	_tmp5_ = self->priv->manager;
	g_signal_connect_object (_tmp5_, "context-available", (GCallback) _rygel_media_device_on_context_available_gupnp_context_manager_context_available, self, 0);
	_tmp6_ = self->priv->manager;
	g_signal_connect_object (_tmp6_, "context-unavailable", (GCallback) _rygel_media_device_on_context_unavailable_gupnp_context_manager_context_unavailable, self, 0);
	_tmp7_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->interfaces);
	self->priv->interfaces = _tmp7_;
	_tmp8_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gupnp_context_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->contexts);
	self->priv->contexts = _tmp8_;
	_tmp9_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, RYGEL_TYPE_DEVICE_CONTEXT, (GBoxedCopyFunc) rygel_device_context_ref, (GDestroyNotify) rygel_device_context_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->devices);
	self->priv->devices = _tmp9_;
}

/**
     * Add a network interface the device should listen on.
     *
     * If the network interface is not already up, it will be used as soon as
     * it's ready. Otherwise it's used right away.
     *
     * @param iface Name of the network interface, e.g. eth0
     */
void
rygel_media_device_add_interface (RygelMediaDevice* self,
                                  const gchar* iface)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	_tmp0_ = self->priv->interfaces;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, iface)) {
		GeeArrayList* _tmp1_;
		GeeHashMap* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeSet* _tmp5_;
		gboolean _tmp6_;
		_tmp1_ = self->priv->interfaces;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, iface);
		_tmp2_ = self->priv->contexts;
		_tmp3_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_collection_contains ((GeeCollection*) _tmp5_, iface);
		_g_object_unref0 (_tmp5_);
		if (_tmp6_) {
			GeeHashMap* _tmp7_;
			gpointer _tmp8_;
			GUPnPContext* _tmp9_;
			_tmp7_ = self->priv->contexts;
			_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, iface);
			_tmp9_ = (GUPnPContext*) _tmp8_;
			rygel_media_device_on_context_available (self, _tmp9_);
			_g_object_unref0 (_tmp9_);
		}
	}
}

/**
     * Remove a previously added network interface from the device.
     *
     * @param iface Name of the network interface, e.g. eth0
     */
void
rygel_media_device_remove_interface (RygelMediaDevice* self,
                                     const gchar* iface)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	_tmp0_ = self->priv->interfaces;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, iface)) {
		return;
	}
	_tmp1_ = self->priv->interfaces;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp1_, iface);
	_tmp2_ = self->priv->devices;
	_tmp3_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_collection_contains ((GeeCollection*) _tmp5_, iface);
	_g_object_unref0 (_tmp5_);
	if (_tmp6_) {
		GeeHashMap* _tmp7_;
		GeeHashMap* _tmp8_;
		gpointer _tmp9_;
		RygelDeviceContext* _tmp10_;
		GUPnPContext* _tmp11_;
		GeeHashMap* _tmp12_;
		_tmp7_ = self->priv->contexts;
		_tmp8_ = self->priv->devices;
		_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, iface);
		_tmp10_ = (RygelDeviceContext*) _tmp9_;
		_tmp11_ = _tmp10_->context;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp7_, iface, _tmp11_);
		_rygel_device_context_unref0 (_tmp10_);
		_tmp12_ = self->priv->devices;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp12_, iface, NULL);
	}
}

/**
     * Get a list of the network interfaces the device is currently allowed
     * to use.
     *
     * @return list of interface names.
     */
GList*
rygel_media_device_get_interfaces (RygelMediaDevice* self)
{
	GList* _result_ = NULL;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	{
		GeeArrayList* _iface_list = NULL;
		GeeArrayList* _tmp0_;
		gint _iface_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _iface_index = 0;
		_tmp0_ = self->priv->interfaces;
		_iface_list = _tmp0_;
		_tmp1_ = _iface_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_iface_size = _tmp3_;
		_iface_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gchar* iface = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_iface_index = _iface_index + 1;
			_tmp4_ = _iface_index;
			_tmp5_ = _iface_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _iface_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _iface_index);
			iface = (gchar*) _tmp7_;
			_tmp8_ = iface;
			_tmp9_ = g_strdup (_tmp8_);
			_result_ = g_list_prepend (_result_, _tmp9_);
			_g_free0 (iface);
		}
	}
	_result_ = g_list_reverse (_result_);
	result = _result_;
	return result;
}

static void
rygel_media_device_on_context_available (RygelMediaDevice* self,
                                         GUPnPContext* context)
{
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->interfaces;
	_tmp1_ = gssdp_client_get_interface ((GSSDPClient*) context);
	_tmp2_ = _tmp1_;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp2_)) {
		{
			RygelDeviceContext* ctx = NULL;
			RygelPlugin* _tmp3_;
			RygelDeviceContext* _tmp4_;
			GeeHashMap* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			RygelDeviceContext* _tmp8_;
			_tmp3_ = self->priv->_plugin;
			_tmp4_ = rygel_device_context_new (context, _tmp3_, &_inner_error0_);
			ctx = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = self->priv->devices;
			_tmp6_ = gssdp_client_get_interface ((GSSDPClient*) context);
			_tmp7_ = _tmp6_;
			_tmp8_ = ctx;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, _tmp7_, _tmp8_);
			_rygel_device_context_unref0 (ctx);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = _error_;
			_tmp10_ = _tmp9_->message;
			g_warning ("rygel-media-device.vala:138: Failed to create device context: %s", _tmp10_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		GeeHashMap* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp11_ = self->priv->contexts;
		_tmp12_ = gssdp_client_get_interface ((GSSDPClient*) context);
		_tmp13_ = _tmp12_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, _tmp13_, context);
	}
}

static void
rygel_media_device_on_context_unavailable (RygelMediaDevice* self,
                                           GUPnPContext* context)
{
	GeeHashMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->devices;
	_tmp1_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gssdp_client_get_interface ((GSSDPClient*) context);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_collection_contains ((GeeCollection*) _tmp3_, _tmp5_);
	_g_object_unref0 (_tmp3_);
	if (_tmp6_) {
		GeeHashMap* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = self->priv->devices;
		_tmp8_ = gssdp_client_get_interface ((GSSDPClient*) context);
		_tmp9_ = _tmp8_;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, _tmp9_, NULL);
	} else {
		GeeHashMap* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = self->priv->contexts;
		_tmp11_ = gssdp_client_get_interface ((GSSDPClient*) context);
		_tmp12_ = _tmp11_;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp10_, _tmp12_, NULL);
	}
}

RygelMediaDevice*
rygel_media_device_construct (GType object_type)
{
	RygelMediaDevice * self = NULL;
	self = (RygelMediaDevice*) g_object_new (object_type, NULL);
	return self;
}

RygelPlugin*
rygel_media_device_get_plugin (RygelMediaDevice* self)
{
	RygelPlugin* result;
	RygelPlugin* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_plugin;
	result = _tmp0_;
	return result;
}

void
rygel_media_device_set_plugin (RygelMediaDevice* self,
                               RygelPlugin* value)
{
	RygelPlugin* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_device_get_plugin (self);
	if (old_value != value) {
		RygelPlugin* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_plugin);
		self->priv->_plugin = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_device_properties[RYGEL_MEDIA_DEVICE_PLUGIN_PROPERTY]);
	}
}

const gchar*
rygel_media_device_get_title (RygelMediaDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

static void
rygel_media_device_set_title (RygelMediaDevice* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_device_get_title (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_device_properties[RYGEL_MEDIA_DEVICE_TITLE_PROPERTY]);
	}
}

RygelPluginCapabilities
rygel_media_device_get_capabilities (RygelMediaDevice* self)
{
	RygelPluginCapabilities result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_capabilities;
	return result;
}

static void
rygel_media_device_set_capabilities (RygelMediaDevice* self,
                                     RygelPluginCapabilities value)
{
	RygelPluginCapabilities old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_device_get_capabilities (self);
	if (old_value != value) {
		self->priv->_capabilities = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_device_properties[RYGEL_MEDIA_DEVICE_CAPABILITIES_PROPERTY]);
	}
}

static void
rygel_media_device_class_init (RygelMediaDeviceClass * klass,
                               gpointer klass_data)
{
	rygel_media_device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaDevice_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_media_device_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_device_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_device_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_device_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_DEVICE_PLUGIN_PROPERTY, rygel_media_device_properties[RYGEL_MEDIA_DEVICE_PLUGIN_PROPERTY] = g_param_spec_object ("plugin", "plugin", "plugin", RYGEL_TYPE_PLUGIN, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_DEVICE_TITLE_PROPERTY, rygel_media_device_properties[RYGEL_MEDIA_DEVICE_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_DEVICE_CAPABILITIES_PROPERTY, rygel_media_device_properties[RYGEL_MEDIA_DEVICE_CAPABILITIES_PROPERTY] = g_param_spec_flags ("capabilities", "capabilities", "capabilities", RYGEL_TYPE_PLUGIN_CAPABILITIES, RYGEL_PLUGIN_CAPABILITIES_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
rygel_media_device_instance_init (RygelMediaDevice * self,
                                  gpointer klass)
{
	self->priv = rygel_media_device_get_instance_private (self);
	self->priv->_capabilities = RYGEL_PLUGIN_CAPABILITIES_NONE;
}

static void
rygel_media_device_finalize (GObject * obj)
{
	RygelMediaDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevice);
	_g_object_unref0 (self->priv->interfaces);
	_g_object_unref0 (self->priv->contexts);
	_g_object_unref0 (self->priv->devices);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->_plugin);
	_g_free0 (self->priv->_title);
	G_OBJECT_CLASS (rygel_media_device_parent_class)->finalize (obj);
}

/**
 * This is a base class for implementations of UPnP devices,
 * such as RygelMediaServer and RygelMediaRenderer.
 *
 * Use rygel_media_device_add_interface() to allow this
 * device to respond to UPnP messages on a network interface.
 */
 G_GNUC_NO_INLINE static GType
rygel_media_device_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelMediaDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaDevice), 0, (GInstanceInitFunc) rygel_media_device_instance_init, NULL };
	GType rygel_media_device_type_id;
	rygel_media_device_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaDevice", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	RygelMediaDevice_private_offset = g_type_add_instance_private (rygel_media_device_type_id, sizeof (RygelMediaDevicePrivate));
	return rygel_media_device_type_id;
}

GType
rygel_media_device_get_type (void)
{
	static volatile gsize rygel_media_device_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_device_type_id__once)) {
		GType rygel_media_device_type_id;
		rygel_media_device_type_id = rygel_media_device_get_type_once ();
		g_once_init_leave (&rygel_media_device_type_id__once, rygel_media_device_type_id);
	}
	return rygel_media_device_type_id__once;
}

static void
_vala_rygel_media_device_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	RygelMediaDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevice);
	switch (property_id) {
		case RYGEL_MEDIA_DEVICE_PLUGIN_PROPERTY:
		g_value_set_object (value, rygel_media_device_get_plugin (self));
		break;
		case RYGEL_MEDIA_DEVICE_TITLE_PROPERTY:
		g_value_set_string (value, rygel_media_device_get_title (self));
		break;
		case RYGEL_MEDIA_DEVICE_CAPABILITIES_PROPERTY:
		g_value_set_flags (value, rygel_media_device_get_capabilities (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_media_device_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	RygelMediaDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevice);
	switch (property_id) {
		case RYGEL_MEDIA_DEVICE_PLUGIN_PROPERTY:
		rygel_media_device_set_plugin (self, g_value_get_object (value));
		break;
		case RYGEL_MEDIA_DEVICE_TITLE_PROPERTY:
		rygel_media_device_set_title (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_DEVICE_CAPABILITIES_PROPERTY:
		rygel_media_device_set_capabilities (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

