/* rygel-visual-item.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-visual-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include "rygel-core.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define RYGEL_TYPE_THUMBNAILER (rygel_thumbnailer_get_type ())
#define RYGEL_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailer))
#define RYGEL_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))
#define RYGEL_IS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_IS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))

typedef struct _RygelThumbnailer RygelThumbnailer;
typedef struct _RygelThumbnailerClass RygelThumbnailerClass;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

VALA_EXTERN void rygel_visual_item_add_thumbnail_for_uri (RygelVisualItem* self,
                                              const gchar* uri);
VALA_EXTERN GType rygel_thumbnailer_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelThumbnailer* rygel_thumbnailer_get_default (void);
VALA_EXTERN RygelThumbnail* rygel_thumbnailer_get_thumbnail (RygelThumbnailer* self,
                                                 const gchar* uri,
                                                 const gchar* mime_type,
                                                 GError** error);
VALA_EXTERN void rygel_visual_item_set_visual_resource_properties (RygelVisualItem* self,
                                                       RygelMediaResource* res);
VALA_EXTERN void rygel_visual_item_add_thumbnail_resources (RygelVisualItem* self,
                                                RygelHTTPServer* http_server);
VALA_EXTERN gchar* rygel_media_object_get_protocol_for_uri (RygelMediaObject* self,
                                                const gchar* uri,
                                                GError** error);
VALA_EXTERN RygelMediaResource* rygel_thumbnail_get_resource (RygelThumbnail* self,
                                                  const gchar* protocol,
                                                  gint index);
VALA_EXTERN gchar* rygel_http_server_get_protocol (RygelHTTPServer* self);
VALA_EXTERN gchar* rygel_http_server_create_uri_for_object (RygelHTTPServer* self,
                                                RygelMediaObject* object,
                                                gint thumbnail_index,
                                                gint subtitle_index,
                                                const gchar* resource_name);
static GType rygel_visual_item_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

void
rygel_visual_item_add_thumbnail_for_uri (RygelVisualItem* self,
                                         const gchar* uri)
{
	RygelThumbnailer* thumbnailer = NULL;
	RygelThumbnailer* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelThumbnailer* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (uri != NULL);
	_tmp0_ = rygel_thumbnailer_get_default ();
	thumbnailer = _tmp0_;
	_tmp2_ = thumbnailer;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = rygel_media_file_item_get_mime_type ((RygelMediaFileItem*) self);
		_tmp4_ = _tmp3_;
		_tmp1_ = _tmp4_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		{
			RygelThumbnail* thumb = NULL;
			RygelThumbnailer* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			RygelThumbnail* _tmp8_;
			GeeArrayList* _tmp9_;
			GeeArrayList* _tmp10_;
			RygelThumbnail* _tmp11_;
			_tmp5_ = thumbnailer;
			_tmp6_ = rygel_media_file_item_get_mime_type ((RygelMediaFileItem*) self);
			_tmp7_ = _tmp6_;
			_tmp8_ = rygel_thumbnailer_get_thumbnail (_tmp5_, uri, _tmp7_, &_inner_error0_);
			thumb = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp9_ = rygel_visual_item_get_thumbnails (self);
			_tmp10_ = _tmp9_;
			_tmp11_ = thumb;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
			_rygel_icon_info_unref0 (thumb);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp12_;
			const gchar* _tmp13_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp12_ = err;
			_tmp13_ = _tmp12_->message;
			g_debug ("rygel-visual-item.vala:69: Failed to get thumbnail: %s", _tmp13_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (thumbnailer);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (thumbnailer);
}

void
rygel_visual_item_set_visual_resource_properties (RygelVisualItem* self,
                                                  RygelMediaResource* res)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (res != NULL);
	_tmp0_ = rygel_visual_item_get_width (self);
	_tmp1_ = _tmp0_;
	rygel_media_resource_set_width (res, _tmp1_);
	_tmp2_ = rygel_visual_item_get_height (self);
	_tmp3_ = _tmp2_;
	rygel_media_resource_set_height (res, _tmp3_);
	_tmp4_ = rygel_visual_item_get_color_depth (self);
	_tmp5_ = _tmp4_;
	rygel_media_resource_set_color_depth (res, _tmp5_);
}

void
rygel_visual_item_add_thumbnail_resources (RygelVisualItem* self,
                                           RygelHTTPServer* http_server)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (http_server != NULL);
	_tmp0_ = rygel_media_file_item_get_place_holder ((RygelMediaFileItem*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp4_;
				GeeArrayList* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				RygelThumbnail* thumbnail = NULL;
				GeeArrayList* _tmp8_;
				GeeArrayList* _tmp9_;
				gpointer _tmp10_;
				gchar* protocol = NULL;
				RygelMediaResource* thumb_res = NULL;
				RygelThumbnail* _tmp18_;
				const gchar* _tmp19_;
				RygelMediaResource* _tmp20_;
				RygelMediaResource* _tmp21_;
				RygelThumbnail* _tmp22_;
				const gchar* _tmp23_;
				GeeList* _tmp24_;
				GeeList* _tmp25_;
				RygelMediaResource* _tmp26_;
				RygelThumbnail* _tmp27_;
				const gchar* _tmp28_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = rygel_visual_item_get_thumbnails (self);
				_tmp5_ = _tmp4_;
				_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
				_tmp7_ = _tmp6_;
				if (!(i < _tmp7_)) {
					break;
				}
				_tmp8_ = rygel_visual_item_get_thumbnails (self);
				_tmp9_ = _tmp8_;
				_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, i);
				thumbnail = (RygelThumbnail*) _tmp10_;
				{
					gchar* _tmp11_ = NULL;
					RygelThumbnail* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp12_ = thumbnail;
					_tmp13_ = ((RygelIconInfo*) _tmp12_)->uri;
					_tmp14_ = rygel_media_object_get_protocol_for_uri ((RygelMediaObject*) self, _tmp13_, &_inner_error0_);
					_tmp11_ = _tmp14_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp15_ = _tmp11_;
					_tmp11_ = NULL;
					_g_free0 (protocol);
					protocol = _tmp15_;
					_g_free0 (_tmp11_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					RygelThumbnail* _tmp16_;
					const gchar* _tmp17_;
					g_clear_error (&_inner_error0_);
					_tmp16_ = thumbnail;
					_tmp17_ = ((RygelIconInfo*) _tmp16_)->uri;
					g_message ("rygel-visual-item.vala:93: Could not determine protocol for URI %s", _tmp17_);
					_g_free0 (protocol);
					_rygel_icon_info_unref0 (thumbnail);
					continue;
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (protocol);
					_rygel_icon_info_unref0 (thumbnail);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp18_ = thumbnail;
				_tmp19_ = protocol;
				_tmp20_ = rygel_thumbnail_get_resource (_tmp18_, _tmp19_, i);
				thumb_res = _tmp20_;
				_tmp21_ = thumb_res;
				_tmp22_ = thumbnail;
				_tmp23_ = ((RygelIconInfo*) _tmp22_)->uri;
				rygel_media_resource_set_uri (_tmp21_, _tmp23_);
				_tmp24_ = rygel_media_object_get_resource_list ((RygelMediaObject*) self);
				_tmp25_ = _tmp24_;
				_tmp26_ = thumb_res;
				gee_collection_add ((GeeCollection*) _tmp25_, _tmp26_);
				_g_object_unref0 (_tmp25_);
				_tmp27_ = thumbnail;
				_tmp28_ = ((RygelIconInfo*) _tmp27_)->uri;
				if (rygel_http_server_need_proxy (http_server, _tmp28_)) {
					RygelMediaResource* http_thumb_res = NULL;
					RygelThumbnail* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					RygelMediaResource* _tmp32_;
					RygelMediaResource* _tmp33_;
					gint index = 0;
					GeeArrayList* _tmp34_;
					GeeArrayList* _tmp35_;
					RygelThumbnail* _tmp36_;
					RygelMediaResource* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					GeeList* _tmp40_;
					GeeList* _tmp41_;
					RygelMediaResource* _tmp42_;
					_tmp29_ = thumbnail;
					_tmp30_ = rygel_http_server_get_protocol (http_server);
					_tmp31_ = _tmp30_;
					_tmp32_ = rygel_thumbnail_get_resource (_tmp29_, _tmp31_, i);
					_tmp33_ = _tmp32_;
					_g_free0 (_tmp31_);
					http_thumb_res = _tmp33_;
					_tmp34_ = rygel_visual_item_get_thumbnails (self);
					_tmp35_ = _tmp34_;
					_tmp36_ = thumbnail;
					index = gee_abstract_list_index_of ((GeeAbstractList*) _tmp35_, _tmp36_);
					_tmp37_ = http_thumb_res;
					_tmp38_ = rygel_http_server_create_uri_for_object (http_server, (RygelMediaObject*) self, index, -1, NULL);
					_tmp39_ = _tmp38_;
					rygel_media_resource_set_uri (_tmp37_, _tmp39_);
					_g_free0 (_tmp39_);
					_tmp40_ = rygel_media_object_get_resource_list ((RygelMediaObject*) self);
					_tmp41_ = _tmp40_;
					_tmp42_ = http_thumb_res;
					gee_collection_add ((GeeCollection*) _tmp41_, _tmp42_);
					_g_object_unref0 (_tmp41_);
					_g_object_unref0 (http_thumb_res);
				}
				_g_object_unref0 (thumb_res);
				_g_free0 (protocol);
				_rygel_icon_info_unref0 (thumbnail);
			}
		}
	}
}

gint
rygel_visual_item_get_width (RygelVisualItem* self)
{
	RygelVisualItemIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = RYGEL_VISUAL_ITEM_GET_INTERFACE (self);
	if (_iface_->get_width) {
		return _iface_->get_width (self);
	}
	return -1;
}

void
rygel_visual_item_set_width (RygelVisualItem* self,
                             gint value)
{
	RygelVisualItemIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_VISUAL_ITEM_GET_INTERFACE (self);
	if (_iface_->set_width) {
		_iface_->set_width (self, value);
	}
}

gint
rygel_visual_item_get_height (RygelVisualItem* self)
{
	RygelVisualItemIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = RYGEL_VISUAL_ITEM_GET_INTERFACE (self);
	if (_iface_->get_height) {
		return _iface_->get_height (self);
	}
	return -1;
}

void
rygel_visual_item_set_height (RygelVisualItem* self,
                              gint value)
{
	RygelVisualItemIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_VISUAL_ITEM_GET_INTERFACE (self);
	if (_iface_->set_height) {
		_iface_->set_height (self, value);
	}
}

gint
rygel_visual_item_get_color_depth (RygelVisualItem* self)
{
	RygelVisualItemIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = RYGEL_VISUAL_ITEM_GET_INTERFACE (self);
	if (_iface_->get_color_depth) {
		return _iface_->get_color_depth (self);
	}
	return -1;
}

void
rygel_visual_item_set_color_depth (RygelVisualItem* self,
                                   gint value)
{
	RygelVisualItemIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_VISUAL_ITEM_GET_INTERFACE (self);
	if (_iface_->set_color_depth) {
		_iface_->set_color_depth (self, value);
	}
}

GeeArrayList*
rygel_visual_item_get_thumbnails (RygelVisualItem* self)
{
	RygelVisualItemIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = RYGEL_VISUAL_ITEM_GET_INTERFACE (self);
	if (_iface_->get_thumbnails) {
		return _iface_->get_thumbnails (self);
	}
	return NULL;
}

void
rygel_visual_item_set_thumbnails (RygelVisualItem* self,
                                  GeeArrayList* value)
{
	RygelVisualItemIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_VISUAL_ITEM_GET_INTERFACE (self);
	if (_iface_->set_thumbnails) {
		_iface_->set_thumbnails (self, value);
	}
}

static void
rygel_visual_item_default_init (RygelVisualItemIface * iface,
                                gpointer iface_data)
{
	/**
	     * The width of the source content (this.uri) in pixels.
	     * A value of -1 means that the width is unknown
	     */
	g_object_interface_install_property (iface, g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The height of the source content (this.uri) in pixels.
	     * A value of -1 means that the height is unknown
	     */
	g_object_interface_install_property (iface, g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The number of bits per pixel in the video or image resource (this.uri).
	     * A value of -1 means that the color depth is unknown
	     */
	g_object_interface_install_property (iface, g_param_spec_int ("color-depth", "color-depth", "color-depth", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Thumbnail pictures to represent the video or image resource.
	     */
	g_object_interface_install_property (iface, g_param_spec_object ("thumbnails", "thumbnails", "thumbnails", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

/**
 * An interface representing visual properties of an item stored in a file.
 */
 G_GNUC_NO_INLINE static GType
rygel_visual_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelVisualItemIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_visual_item_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType rygel_visual_item_type_id;
	rygel_visual_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelVisualItem", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (rygel_visual_item_type_id, RYGEL_TYPE_MEDIA_FILE_ITEM);
	return rygel_visual_item_type_id;
}

GType
rygel_visual_item_get_type (void)
{
	static volatile gsize rygel_visual_item_type_id__once = 0;
	if (g_once_init_enter (&rygel_visual_item_type_id__once)) {
		GType rygel_visual_item_type_id;
		rygel_visual_item_type_id = rygel_visual_item_get_type_once ();
		g_once_init_leave (&rygel_visual_item_type_id__once, rygel_visual_item_type_id);
	}
	return rygel_visual_item_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

