/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/source3/librpc/gen_ndr/ndr_rpcd_witness.h"

#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_server_id.h"
#include "librpc/gen_ndr/ndr_security.h"
#include "librpc/gen_ndr/ndr_witness.h"
_PUBLIC_ enum ndr_err_code ndr_push_rpcd_witness_registration(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct rpcd_witness_registration *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_witness_version(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->net_name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->net_name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->net_name, ndr_charset_length(r->net_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->share_name));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->ip_address, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->ip_address, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->ip_address, ndr_charset_length(r->ip_address, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client_computer_name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client_computer_name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->client_computer_name, ndr_charset_length(r->client_computer_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_witness_RegisterEx_flags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->timeout));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->context_handle));
		NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->account_name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->account_name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->account_name, ndr_charset_length(r->account_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain_name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain_name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain_name, ndr_charset_length(r->domain_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->account_sid));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->local_address, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->local_address, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->local_address, ndr_charset_length(r->local_address, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->remote_address, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->remote_address, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->remote_address, ndr_charset_length(r->remote_address, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->registration_time));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->share_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->share_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->share_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->share_name, ndr_charset_length(r->share_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rpcd_witness_registration(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct rpcd_witness_registration *r)
{
	uint32_t size_net_name_0 = 0;
	uint32_t length_net_name_0 = 0;
	uint32_t _ptr_share_name;
	uint32_t size_share_name_1 = 0;
	uint32_t length_share_name_1 = 0;
	TALLOC_CTX *_mem_save_share_name_0 = NULL;
	uint32_t size_ip_address_0 = 0;
	uint32_t length_ip_address_0 = 0;
	uint32_t size_client_computer_name_0 = 0;
	uint32_t length_client_computer_name_0 = 0;
	uint32_t size_account_name_0 = 0;
	uint32_t length_account_name_0 = 0;
	uint32_t size_domain_name_0 = 0;
	uint32_t length_domain_name_0 = 0;
	uint32_t size_local_address_0 = 0;
	uint32_t length_local_address_0 = 0;
	uint32_t size_remote_address_0 = 0;
	uint32_t length_remote_address_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_witness_version(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->net_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->net_name));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->net_name, &size_net_name_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->net_name, &length_net_name_0));
		if (length_net_name_0 > size_net_name_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_net_name_0, length_net_name_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_net_name_0, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->net_name, length_net_name_0, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_share_name));
		if (_ptr_share_name) {
			NDR_PULL_ALLOC(ndr, r->share_name);
		} else {
			r->share_name = NULL;
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->ip_address));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->ip_address));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->ip_address, &size_ip_address_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->ip_address, &length_ip_address_0));
		if (length_ip_address_0 > size_ip_address_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_ip_address_0, length_ip_address_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_ip_address_0, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->ip_address, length_ip_address_0, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->client_computer_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->client_computer_name));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->client_computer_name, &size_client_computer_name_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->client_computer_name, &length_client_computer_name_0));
		if (length_client_computer_name_0 > size_client_computer_name_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_client_computer_name_0, length_client_computer_name_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_client_computer_name_0, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->client_computer_name, length_client_computer_name_0, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_witness_RegisterEx_flags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->timeout));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->context_handle));
		NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->account_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->account_name));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->account_name, &size_account_name_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->account_name, &length_account_name_0));
		if (length_account_name_0 > size_account_name_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_account_name_0, length_account_name_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_account_name_0, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->account_name, length_account_name_0, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->domain_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->domain_name));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->domain_name, &size_domain_name_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->domain_name, &length_domain_name_0));
		if (length_domain_name_0 > size_domain_name_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_domain_name_0, length_domain_name_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_name_0, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain_name, length_domain_name_0, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->account_sid));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->local_address));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->local_address));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->local_address, &size_local_address_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->local_address, &length_local_address_0));
		if (length_local_address_0 > size_local_address_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_local_address_0, length_local_address_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_local_address_0, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->local_address, length_local_address_0, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->remote_address));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->remote_address));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->remote_address, &size_remote_address_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->remote_address, &length_remote_address_0));
		if (length_remote_address_0 > size_remote_address_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_remote_address_0, length_remote_address_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_remote_address_0, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->remote_address, length_remote_address_0, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->registration_time));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->share_name) {
			_mem_save_share_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->share_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->share_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->share_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->share_name, &size_share_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->share_name, &length_share_name_1));
			if (length_share_name_1 > size_share_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_share_name_1, length_share_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_share_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->share_name, length_share_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_share_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_rpcd_witness_registration(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct rpcd_witness_registration *r)
{
	ndr_print_rpcd_witness_registration(ndr, name, r);
}

_PUBLIC_ void ndr_print_rpcd_witness_registration(struct ndr_print *ndr, const char *name, const struct rpcd_witness_registration *r)
{
	ndr_print_struct(ndr, name, "rpcd_witness_registration");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_witness_version(ndr, "version", r->version);
	ndr_print_string(ndr, "net_name", r->net_name);
	ndr_print_ptr(ndr, "share_name", r->share_name);
	ndr->depth++;
	if (r->share_name) {
		ndr_print_string(ndr, "share_name", r->share_name);
	}
	ndr->depth--;
	ndr_print_string(ndr, "ip_address", r->ip_address);
	ndr_print_string(ndr, "client_computer_name", r->client_computer_name);
	ndr_print_witness_RegisterEx_flags(ndr, "flags", r->flags);
	ndr_print_uint32(ndr, "timeout", r->timeout);
	ndr_print_policy_handle(ndr, "context_handle", &r->context_handle);
	ndr_print_server_id(ndr, "server_id", &r->server_id);
	ndr_print_string(ndr, "account_name", r->account_name);
	ndr_print_string(ndr, "domain_name", r->domain_name);
	ndr_print_dom_sid(ndr, "account_sid", &r->account_sid);
	ndr_print_string(ndr, "local_address", r->local_address);
	ndr_print_string(ndr, "remote_address", r->remote_address);
	ndr_print_NTTIME(ndr, "registration_time", r->registration_time);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rpcd_witness_registration_update_type(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum rpcd_witness_registration_update_type r)
{
	NDR_CHECK(ndr_push_enum_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rpcd_witness_registration_update_type(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum rpcd_witness_registration_update_type *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rpcd_witness_registration_update_type(struct ndr_print *ndr, const char *name, enum rpcd_witness_registration_update_type r)
{
	const char *val = NULL;

	switch (r) {
		case RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_NODE: val = "RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_NODE"; break;
		case RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV4: val = "RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV4"; break;
		case RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV6: val = "RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV6"; break;
		case RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_NODE: val = "RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_NODE"; break;
		case RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV4: val = "RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV4"; break;
		case RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV6: val = "RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV6"; break;
		case RPCD_WITNESS_REGISTRATION_UPDATE_FORCE_UNREGISTER: val = "RPCD_WITNESS_REGISTRATION_UPDATE_FORCE_UNREGISTER"; break;
		case RPCD_WITNESS_REGISTRATION_UPDATE_FORCE_RESPONSE: val = "RPCD_WITNESS_REGISTRATION_UPDATE_FORCE_RESPONSE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_rpcd_witness_registration_update_move_to_node(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct rpcd_witness_registration_update_move_to_node *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->new_node));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rpcd_witness_registration_update_move_to_node(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct rpcd_witness_registration_update_move_to_node *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->new_node));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rpcd_witness_registration_update_move_to_node(struct ndr_print *ndr, const char *name, const struct rpcd_witness_registration_update_move_to_node *r)
{
	ndr_print_struct(ndr, name, "rpcd_witness_registration_update_move_to_node");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "new_node", r->new_node);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rpcd_witness_registration_update_move_to_ipv4(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct rpcd_witness_registration_update_move_to_ipv4 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			libndr_flags _flags_save_ipv4address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->new_ipv4));
			ndr->flags = _flags_save_ipv4address;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rpcd_witness_registration_update_move_to_ipv4(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct rpcd_witness_registration_update_move_to_ipv4 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			libndr_flags _flags_save_ipv4address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->new_ipv4));
			ndr->flags = _flags_save_ipv4address;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rpcd_witness_registration_update_move_to_ipv4(struct ndr_print *ndr, const char *name, const struct rpcd_witness_registration_update_move_to_ipv4 *r)
{
	ndr_print_struct(ndr, name, "rpcd_witness_registration_update_move_to_ipv4");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_ipv4address = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr_print_ipv4address(ndr, "new_ipv4", r->new_ipv4);
		ndr->flags = _flags_save_ipv4address;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rpcd_witness_registration_update_move_to_ipv6(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct rpcd_witness_registration_update_move_to_ipv6 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			libndr_flags _flags_save_ipv6address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_ipv6address(ndr, NDR_SCALARS, r->new_ipv6));
			ndr->flags = _flags_save_ipv6address;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rpcd_witness_registration_update_move_to_ipv6(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct rpcd_witness_registration_update_move_to_ipv6 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			libndr_flags _flags_save_ipv6address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_ipv6address(ndr, NDR_SCALARS, &r->new_ipv6));
			ndr->flags = _flags_save_ipv6address;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rpcd_witness_registration_update_move_to_ipv6(struct ndr_print *ndr, const char *name, const struct rpcd_witness_registration_update_move_to_ipv6 *r)
{
	ndr_print_struct(ndr, name, "rpcd_witness_registration_update_move_to_ipv6");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_ipv6address = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr_print_ipv6address(ndr, "new_ipv6", r->new_ipv6);
		ndr->flags = _flags_save_ipv6address;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rpcd_witness_registration_update_force_response(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct rpcd_witness_registration_update_force_response *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->response));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->result));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->response) {
			NDR_CHECK(ndr_push_witness_notifyResponse(ndr, NDR_SCALARS|NDR_BUFFERS, r->response));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rpcd_witness_registration_update_force_response(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct rpcd_witness_registration_update_force_response *r)
{
	uint32_t _ptr_response;
	TALLOC_CTX *_mem_save_response_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_response));
		if (_ptr_response) {
			NDR_PULL_ALLOC(ndr, r->response);
		} else {
			r->response = NULL;
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->result));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->response) {
			_mem_save_response_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->response, 0);
			NDR_CHECK(ndr_pull_witness_notifyResponse(ndr, NDR_SCALARS|NDR_BUFFERS, r->response));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_response_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rpcd_witness_registration_update_force_response(struct ndr_print *ndr, const char *name, const struct rpcd_witness_registration_update_force_response *r)
{
	ndr_print_struct(ndr, name, "rpcd_witness_registration_update_force_response");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "response", r->response);
	ndr->depth++;
	if (r->response) {
		ndr_print_witness_notifyResponse(ndr, "response", r->response);
	}
	ndr->depth--;
	ndr_print_WERROR(ndr, "result", r->result);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rpcd_witness_registration_updateU(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union rpcd_witness_registration_updateU *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_rpcd_witness_registration_update_type(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_NODE: {
				NDR_CHECK(ndr_push_rpcd_witness_registration_update_move_to_node(ndr, NDR_SCALARS, &r->client_move_to_node));
			break; }

			case RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV4: {
				NDR_CHECK(ndr_push_rpcd_witness_registration_update_move_to_ipv4(ndr, NDR_SCALARS, &r->client_move_to_ipv4));
			break; }

			case RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV6: {
				NDR_CHECK(ndr_push_rpcd_witness_registration_update_move_to_ipv6(ndr, NDR_SCALARS, &r->client_move_to_ipv6));
			break; }

			case RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_NODE: {
				NDR_CHECK(ndr_push_rpcd_witness_registration_update_move_to_node(ndr, NDR_SCALARS, &r->share_move_to_node));
			break; }

			case RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV4: {
				NDR_CHECK(ndr_push_rpcd_witness_registration_update_move_to_ipv4(ndr, NDR_SCALARS, &r->share_move_to_ipv4));
			break; }

			case RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV6: {
				NDR_CHECK(ndr_push_rpcd_witness_registration_update_move_to_ipv6(ndr, NDR_SCALARS, &r->share_move_to_ipv6));
			break; }

			case RPCD_WITNESS_REGISTRATION_UPDATE_FORCE_UNREGISTER: {
			break; }

			case RPCD_WITNESS_REGISTRATION_UPDATE_FORCE_RESPONSE: {
				NDR_CHECK(ndr_push_rpcd_witness_registration_update_force_response(ndr, NDR_SCALARS, &r->force_response));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_NODE:
			break;

			case RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV4:
			break;

			case RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV6:
			break;

			case RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_NODE:
			break;

			case RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV4:
			break;

			case RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV6:
			break;

			case RPCD_WITNESS_REGISTRATION_UPDATE_FORCE_UNREGISTER:
			break;

			case RPCD_WITNESS_REGISTRATION_UPDATE_FORCE_RESPONSE:
				NDR_CHECK(ndr_push_rpcd_witness_registration_update_force_response(ndr, NDR_BUFFERS, &r->force_response));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rpcd_witness_registration_updateU(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union rpcd_witness_registration_updateU *r)
{
	uint32_t level;
	uint16_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu16" for r at %s", (uint16_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_NODE: {
				NDR_CHECK(ndr_pull_rpcd_witness_registration_update_move_to_node(ndr, NDR_SCALARS, &r->client_move_to_node));
			break; }

			case RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV4: {
				NDR_CHECK(ndr_pull_rpcd_witness_registration_update_move_to_ipv4(ndr, NDR_SCALARS, &r->client_move_to_ipv4));
			break; }

			case RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV6: {
				NDR_CHECK(ndr_pull_rpcd_witness_registration_update_move_to_ipv6(ndr, NDR_SCALARS, &r->client_move_to_ipv6));
			break; }

			case RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_NODE: {
				NDR_CHECK(ndr_pull_rpcd_witness_registration_update_move_to_node(ndr, NDR_SCALARS, &r->share_move_to_node));
			break; }

			case RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV4: {
				NDR_CHECK(ndr_pull_rpcd_witness_registration_update_move_to_ipv4(ndr, NDR_SCALARS, &r->share_move_to_ipv4));
			break; }

			case RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV6: {
				NDR_CHECK(ndr_pull_rpcd_witness_registration_update_move_to_ipv6(ndr, NDR_SCALARS, &r->share_move_to_ipv6));
			break; }

			case RPCD_WITNESS_REGISTRATION_UPDATE_FORCE_UNREGISTER: {
			break; }

			case RPCD_WITNESS_REGISTRATION_UPDATE_FORCE_RESPONSE: {
				NDR_CHECK(ndr_pull_rpcd_witness_registration_update_force_response(ndr, NDR_SCALARS, &r->force_response));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_NODE:
			break;

			case RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV4:
			break;

			case RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV6:
			break;

			case RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_NODE:
			break;

			case RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV4:
			break;

			case RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV6:
			break;

			case RPCD_WITNESS_REGISTRATION_UPDATE_FORCE_UNREGISTER:
			break;

			case RPCD_WITNESS_REGISTRATION_UPDATE_FORCE_RESPONSE:
				NDR_CHECK(ndr_pull_rpcd_witness_registration_update_force_response(ndr, NDR_BUFFERS, &r->force_response));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rpcd_witness_registration_updateU(struct ndr_print *ndr, const char *name, const union rpcd_witness_registration_updateU *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "rpcd_witness_registration_updateU");
	switch (level) {
		case RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_NODE:
			ndr_print_rpcd_witness_registration_update_move_to_node(ndr, "client_move_to_node", &r->client_move_to_node);
		break;

		case RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV4:
			ndr_print_rpcd_witness_registration_update_move_to_ipv4(ndr, "client_move_to_ipv4", &r->client_move_to_ipv4);
		break;

		case RPCD_WITNESS_REGISTRATION_UPDATE_CLIENT_MOVE_TO_IPV6:
			ndr_print_rpcd_witness_registration_update_move_to_ipv6(ndr, "client_move_to_ipv6", &r->client_move_to_ipv6);
		break;

		case RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_NODE:
			ndr_print_rpcd_witness_registration_update_move_to_node(ndr, "share_move_to_node", &r->share_move_to_node);
		break;

		case RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV4:
			ndr_print_rpcd_witness_registration_update_move_to_ipv4(ndr, "share_move_to_ipv4", &r->share_move_to_ipv4);
		break;

		case RPCD_WITNESS_REGISTRATION_UPDATE_SHARE_MOVE_TO_IPV6:
			ndr_print_rpcd_witness_registration_update_move_to_ipv6(ndr, "share_move_to_ipv6", &r->share_move_to_ipv6);
		break;

		case RPCD_WITNESS_REGISTRATION_UPDATE_FORCE_UNREGISTER:
		break;

		case RPCD_WITNESS_REGISTRATION_UPDATE_FORCE_RESPONSE:
			ndr_print_rpcd_witness_registration_update_force_response(ndr, "force_response", &r->force_response);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_rpcd_witness_registration_updateB(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct rpcd_witness_registration_updateB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->context_handle));
		NDR_CHECK(ndr_push_rpcd_witness_registration_update_type(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->update, r->type));
		NDR_CHECK(ndr_push_rpcd_witness_registration_updateU(ndr, NDR_SCALARS, &r->update));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->update, r->type));
		NDR_CHECK(ndr_push_rpcd_witness_registration_updateU(ndr, NDR_BUFFERS, &r->update));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rpcd_witness_registration_updateB(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct rpcd_witness_registration_updateB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->context_handle));
		NDR_CHECK(ndr_pull_rpcd_witness_registration_update_type(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->update, r->type));
		NDR_CHECK(ndr_pull_rpcd_witness_registration_updateU(ndr, NDR_SCALARS, &r->update));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->update, r->type));
		NDR_CHECK(ndr_pull_rpcd_witness_registration_updateU(ndr, NDR_BUFFERS, &r->update));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_rpcd_witness_registration_updateB(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct rpcd_witness_registration_updateB *r)
{
	ndr_print_rpcd_witness_registration_updateB(ndr, name, r);
}

_PUBLIC_ void ndr_print_rpcd_witness_registration_updateB(struct ndr_print *ndr, const char *name, const struct rpcd_witness_registration_updateB *r)
{
	ndr_print_struct(ndr, name, "rpcd_witness_registration_updateB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_policy_handle(ndr, "context_handle", &r->context_handle);
	ndr_print_rpcd_witness_registration_update_type(ndr, "type", r->type);
	ndr_print_set_switch_value(ndr, &r->update, r->type);
	ndr_print_rpcd_witness_registration_updateU(ndr, "update", &r->update);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rpcd_witness_registration_decode(struct ndr_push *ndr, ndr_flags_type flags, const struct rpcd_witness_registration_decode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_rpcd_witness_registration(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.reg));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rpcd_witness_registration_decode(struct ndr_pull *ndr, ndr_flags_type flags, struct rpcd_witness_registration_decode *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_rpcd_witness_registration(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.reg));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rpcd_witness_registration_decode(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct rpcd_witness_registration_decode *r)
{
	ndr_print_struct(ndr, name, "rpcd_witness_registration_decode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rpcd_witness_registration_decode");
		ndr->depth++;
		ndr_print_rpcd_witness_registration(ndr, "reg", &r->in.reg);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rpcd_witness_registration_decode");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rpcd_witness_registration_update_decode(struct ndr_push *ndr, ndr_flags_type flags, const struct rpcd_witness_registration_update_decode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_rpcd_witness_registration_updateB(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.update));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rpcd_witness_registration_update_decode(struct ndr_pull *ndr, ndr_flags_type flags, struct rpcd_witness_registration_update_decode *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_rpcd_witness_registration_updateB(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.update));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rpcd_witness_registration_update_decode(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct rpcd_witness_registration_update_decode *r)
{
	ndr_print_struct(ndr, name, "rpcd_witness_registration_update_decode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rpcd_witness_registration_update_decode");
		ndr->depth++;
		ndr_print_rpcd_witness_registration_updateB(ndr, "update", &r->in.update);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rpcd_witness_registration_update_decode");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_rpcd_witness
static const struct ndr_interface_public_struct rpcd_witness_public_structs[] = {
	{
		.name = "rpcd_witness_registration",
		.struct_size = sizeof(struct rpcd_witness_registration ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_rpcd_witness_registration,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_rpcd_witness_registration,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_rpcd_witness_registration,
	},
	{
		.name = "rpcd_witness_registration_updateB",
		.struct_size = sizeof(struct rpcd_witness_registration_updateB ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_rpcd_witness_registration_updateB,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_rpcd_witness_registration_updateB,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_rpcd_witness_registration_updateB,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call rpcd_witness_calls[] = {
	{
		"rpcd_witness_registration_decode",
		sizeof(struct rpcd_witness_registration_decode),
		(ndr_push_flags_fn_t) ndr_push_rpcd_witness_registration_decode,
		(ndr_pull_flags_fn_t) ndr_pull_rpcd_witness_registration_decode,
		(ndr_print_function_t) ndr_print_rpcd_witness_registration_decode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"rpcd_witness_registration_update_decode",
		sizeof(struct rpcd_witness_registration_update_decode),
		(ndr_push_flags_fn_t) ndr_push_rpcd_witness_registration_update_decode,
		(ndr_pull_flags_fn_t) ndr_pull_rpcd_witness_registration_update_decode,
		(ndr_print_function_t) ndr_print_rpcd_witness_registration_update_decode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ .name = NULL }
};

static const char * const rpcd_witness_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\rpcd_witness]", 
};

static const struct ndr_interface_string_array rpcd_witness_endpoints = {
	.count	= 1,
	.names	= rpcd_witness_endpoint_strings
};

static const char * const rpcd_witness_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array rpcd_witness_authservices = {
	.count	= 1,
	.names	= rpcd_witness_authservice_strings
};


const struct ndr_interface_table ndr_table_rpcd_witness = {
	.name		= "rpcd_witness",
	.syntax_id	= {
		{0xd320d080,0xa007,0x11ee,{0x9c,0xb4},{0x37,0xfa,0x94,0x2d,0x84,0xd2}},
		NDR_RPCD_WITNESS_VERSION
	},
	.helpstring	= NDR_RPCD_WITNESS_HELPSTRING,
	.num_calls	= 2,
	.calls		= rpcd_witness_calls,
	.num_public_structs	= 2,
	.public_structs		= rpcd_witness_public_structs,
	.endpoints	= &rpcd_witness_endpoints,
	.authservices	= &rpcd_witness_authservices
};

#endif /* SKIP_NDR_TABLE_rpcd_witness */
