/* item-list.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from item-list.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2019 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "seahorse-common.h"
#include <gcr/gcr-base.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SEAHORSE_ITEM_LIST_0_PROPERTY,
	SEAHORSE_ITEM_LIST_BASE_COLLECTION_PROPERTY,
	SEAHORSE_ITEM_LIST_SHOWFILTER_PROPERTY,
	SEAHORSE_ITEM_LIST_FILTER_TEXT_PROPERTY,
	SEAHORSE_ITEM_LIST_NUM_PROPERTIES
};
static GParamSpec* seahorse_item_list_properties[SEAHORSE_ITEM_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block6Data Block6Data;

struct _SeahorseItemListPrivate {
	GcrCollection* _base_collection;
	GPtrArray* items;
	SeahorseItemListShowFilter _showfilter;
	gchar* _filter_text;
};

struct _Block6Data {
	int _ref_count_;
	GPtrArray* self;
	GCompareFunc compare_func;
};

static gint SeahorseItemList_private_offset;
static gpointer seahorse_item_list_parent_class = NULL;
static GListModelInterface * seahorse_item_list_g_list_model_parent_iface = NULL;

static void _g_object_unref0_ (gpointer var);
static void seahorse_item_list_set_base_collection (SeahorseItemList* self,
                                             GcrCollection* value);
static void seahorse_item_list_on_collection_item_added (SeahorseItemList* self,
                                                  GObject* object);
static void _seahorse_item_list_on_collection_item_added_gcr_collection_added (GcrCollection* _sender,
                                                                        GObject* object,
                                                                        gpointer self);
static void seahorse_item_list_on_collection_item_removed (SeahorseItemList* self,
                                                    GObject* object);
static void _seahorse_item_list_on_collection_item_removed_gcr_collection_removed (GcrCollection* _sender,
                                                                            GObject* object,
                                                                            gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gint ___lambda0__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static gint seahorse_item_list_compare_items (GObject* gobj_a,
                                       GObject* gobj_b);
static gint _seahorse_item_list_compare_items_gcompare_func (gconstpointer a,
                                                      gconstpointer b);
static gboolean seahorse_item_list_item_matches_filters (SeahorseItemList* self,
                                                  GObject* object);
static gboolean seahorse_item_list_matches_showfilter (SeahorseItemList* self,
                                                GObject* obj);
static gboolean seahorse_item_list_object_contains_filtered_text (SeahorseItemList* self,
                                                           GObject* object,
                                                           const gchar* text);
static gint seahorse_item_list_compare_labels (const gchar* a_label,
                                        const gchar* b_label);
static GObject* seahorse_item_list_real_get_item (GListModel* base,
                                           guint position);
static GType seahorse_item_list_real_get_item_type (GListModel* base);
static guint seahorse_item_list_real_get_n_items (GListModel* base);
static void seahorse_item_list_finalize (GObject * obj);
static GType seahorse_item_list_get_type_once (void);
static void _vala_seahorse_item_list_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_seahorse_item_list_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
seahorse_item_list_get_instance_private (SeahorseItemList* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseItemList_private_offset);
}

const gchar*
seahorse_item_list_show_filter_to_string (SeahorseItemListShowFilter self)
{
	const gchar* result;
	switch (self) {
		case SEAHORSE_ITEM_LIST_SHOW_FILTER_ANY:
		{
			result = "";
			return result;
		}
		case SEAHORSE_ITEM_LIST_SHOW_FILTER_PERSONAL:
		{
			result = "personal";
			return result;
		}
		case SEAHORSE_ITEM_LIST_SHOW_FILTER_TRUSTED:
		{
			result = "trusted";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

SeahorseItemListShowFilter
seahorse_item_list_show_filter_from_string (const gchar* str)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	SeahorseItemListShowFilter result;
	_tmp0_ = str;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (NULL)))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (""))))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("any"))))) {
		switch (0) {
			default:
			{
				result = SEAHORSE_ITEM_LIST_SHOW_FILTER_ANY;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("personal")))) {
		switch (0) {
			default:
			{
				result = SEAHORSE_ITEM_LIST_SHOW_FILTER_PERSONAL;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("trusted")))) {
		switch (0) {
			default:
			{
				result = SEAHORSE_ITEM_LIST_SHOW_FILTER_TRUSTED;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_critical ("item-list.vala:68: Got unknown ShowFilter string: %s", str);
				g_assert_not_reached ();
			}
		}
	}
}

 G_GNUC_NO_INLINE static GType
seahorse_item_list_show_filter_get_type_once (void)
{
	static const GEnumValue values[] = {{SEAHORSE_ITEM_LIST_SHOW_FILTER_ANY, "SEAHORSE_ITEM_LIST_SHOW_FILTER_ANY", "any"}, {SEAHORSE_ITEM_LIST_SHOW_FILTER_PERSONAL, "SEAHORSE_ITEM_LIST_SHOW_FILTER_PERSONAL", "personal"}, {SEAHORSE_ITEM_LIST_SHOW_FILTER_TRUSTED, "SEAHORSE_ITEM_LIST_SHOW_FILTER_TRUSTED", "trusted"}, {0, NULL, NULL}};
	GType seahorse_item_list_show_filter_type_id;
	seahorse_item_list_show_filter_type_id = g_enum_register_static ("SeahorseItemListShowFilter", values);
	return seahorse_item_list_show_filter_type_id;
}

GType
seahorse_item_list_show_filter_get_type (void)
{
	static volatile gsize seahorse_item_list_show_filter_type_id__once = 0;
	if (g_once_init_enter (&seahorse_item_list_show_filter_type_id__once)) {
		GType seahorse_item_list_show_filter_type_id;
		seahorse_item_list_show_filter_type_id = seahorse_item_list_show_filter_get_type_once ();
		g_once_init_leave (&seahorse_item_list_show_filter_type_id__once, seahorse_item_list_show_filter_type_id);
	}
	return seahorse_item_list_show_filter_type_id__once;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_seahorse_item_list_on_collection_item_added_gcr_collection_added (GcrCollection* _sender,
                                                                   GObject* object,
                                                                   gpointer self)
{
	seahorse_item_list_on_collection_item_added ((SeahorseItemList*) self, object);
}

static void
_seahorse_item_list_on_collection_item_removed_gcr_collection_removed (GcrCollection* _sender,
                                                                       GObject* object,
                                                                       gpointer self)
{
	seahorse_item_list_on_collection_item_removed ((SeahorseItemList*) self, object);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		GPtrArray* self;
		self = _data6_->self;
		_g_ptr_array_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gint
__lambda0_ (Block6Data* _data6_,
            gconstpointer** a,
            gconstpointer** b)
{
	GPtrArray* self;
	gint result;
	self = _data6_->self;
	result = _data6_->compare_func ((gconstpointer**) (*a), (gconstpointer**) (*b));
	return result;
}

static gint
___lambda0__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda0_ (self, a, b);
	return result;
}

static void
vala_g_ptr_array_sort (GPtrArray* self,
                       GCompareFunc compare_func)
{
	Block6Data* _data6_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_ptr_array_ref (self);
	_data6_->compare_func = compare_func;
	g_ptr_array_sort_with_data (self, ___lambda0__gcompare_data_func, _data6_);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static gint
_seahorse_item_list_compare_items_gcompare_func (gconstpointer a,
                                                 gconstpointer b)
{
	gint result;
	result = seahorse_item_list_compare_items ((GObject*) a, (GObject*) b);
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

SeahorseItemList*
seahorse_item_list_construct (GType object_type,
                              GcrCollection* collection)
{
	SeahorseItemList * self = NULL;
	GList* _tmp0_;
	GPtrArray* _tmp4_;
	GPtrArray* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (collection != NULL, NULL);
	self = (SeahorseItemList*) g_object_new (object_type, NULL);
	seahorse_item_list_set_base_collection (self, collection);
	g_signal_connect_object (collection, "added", (GCallback) _seahorse_item_list_on_collection_item_added_gcr_collection_added, self, 0);
	g_signal_connect_object (collection, "removed", (GCallback) _seahorse_item_list_on_collection_item_removed_gcr_collection_removed, self, 0);
	_tmp0_ = gcr_collection_get_objects (collection);
	{
		GList* obj_collection = NULL;
		GList* obj_it = NULL;
		obj_collection = _tmp0_;
		for (obj_it = obj_collection; obj_it != NULL; obj_it = obj_it->next) {
			GObject* obj = NULL;
			obj = (GObject*) obj_it->data;
			{
				GPtrArray* _tmp1_;
				GObject* _tmp2_;
				GObject* _tmp3_;
				_tmp1_ = self->priv->items;
				_tmp2_ = obj;
				_tmp3_ = _g_object_ref0 (_tmp2_);
				g_ptr_array_add (_tmp1_, _tmp3_);
			}
		}
		(obj_collection == NULL) ? NULL : (obj_collection = (g_list_free (obj_collection), NULL));
	}
	_tmp4_ = self->priv->items;
	vala_g_ptr_array_sort (_tmp4_, _seahorse_item_list_compare_items_gcompare_func);
	_tmp5_ = self->priv->items;
	_tmp6_ = vala_g_ptr_array_get_length (_tmp5_);
	_tmp7_ = _tmp6_;
	g_list_model_items_changed ((GListModel*) self, (guint) 0, (guint) 0, (guint) _tmp7_);
	return self;
}

SeahorseItemList*
seahorse_item_list_new (GcrCollection* collection)
{
	return seahorse_item_list_construct (SEAHORSE_TYPE_ITEM_LIST, collection);
}

static void
seahorse_item_list_on_collection_item_added (SeahorseItemList* self,
                                             GObject* object)
{
	gint index = 0;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GPtrArray* _tmp10_;
	GObject* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	if (!seahorse_item_list_item_matches_filters (self, object)) {
		return;
	}
	_tmp0_ = self->priv->items;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	index = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				GPtrArray* _tmp8_;
				gconstpointer _tmp9_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->items;
				_tmp6_ = vala_g_ptr_array_get_length (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(i < _tmp7_)) {
					break;
				}
				_tmp8_ = self->priv->items;
				_tmp9_ = g_ptr_array_index (_tmp8_, (guint) i);
				if (seahorse_item_list_compare_items (object, (GObject*) _tmp9_) < 0) {
					index = i;
					break;
				}
			}
		}
	}
	_tmp10_ = self->priv->items;
	_tmp11_ = _g_object_ref0 (object);
	g_ptr_array_insert (_tmp10_, index, _tmp11_);
	g_list_model_items_changed ((GListModel*) self, (guint) index, (guint) 0, (guint) 1);
}

static void
seahorse_item_list_on_collection_item_removed (SeahorseItemList* self,
                                               GObject* object)
{
	guint index = 0U;
	GPtrArray* _tmp0_;
	guint _tmp1_ = 0U;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = self->priv->items;
	_tmp2_ = g_ptr_array_find (_tmp0_, object, &_tmp1_);
	index = _tmp1_;
	if (_tmp2_) {
		GPtrArray* _tmp3_;
		_tmp3_ = self->priv->items;
		g_ptr_array_remove_index (_tmp3_, index);
		g_list_model_items_changed ((GListModel*) self, index, (guint) 1, (guint) 0);
	}
}

static gboolean
seahorse_item_list_item_matches_filters (SeahorseItemList* self,
                                         GObject* object)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (object != NULL, FALSE);
	if (seahorse_item_list_matches_showfilter (self, object)) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_filter_text;
		_tmp0_ = seahorse_item_list_object_contains_filtered_text (self, object, _tmp1_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
seahorse_item_list_matches_showfilter (SeahorseItemList* self,
                                       GObject* obj)
{
	SeahorseFlags obj_flags = 0U;
	SeahorseFlags _tmp0_ = 0U;
	SeahorseItemListShowFilter _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	obj_flags = SEAHORSE_FLAG_NONE;
	g_object_get (obj, "object-flags", &_tmp0_, NULL, NULL);
	obj_flags = _tmp0_;
	_tmp1_ = self->priv->_showfilter;
	switch (_tmp1_) {
		case SEAHORSE_ITEM_LIST_SHOW_FILTER_PERSONAL:
		{
			result = (obj_flags & SEAHORSE_FLAG_PERSONAL) == SEAHORSE_FLAG_PERSONAL;
			return result;
		}
		case SEAHORSE_ITEM_LIST_SHOW_FILTER_TRUSTED:
		{
			result = (obj_flags & SEAHORSE_FLAG_TRUSTED) == SEAHORSE_FLAG_TRUSTED;
			return result;
		}
		case SEAHORSE_ITEM_LIST_SHOW_FILTER_ANY:
		{
			result = TRUE;
			return result;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
seahorse_item_list_object_contains_filtered_text (SeahorseItemList* self,
                                                  GObject* object,
                                                  const gchar* text)
{
	gboolean _tmp0_ = FALSE;
	gchar* name = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	GObjectClass* _tmp7_;
	GParamSpec* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (text == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (text, "") == 0;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	name = NULL;
	g_object_get (object, "label", &_tmp1_, NULL, NULL);
	_g_free0 (name);
	name = _tmp1_;
	_tmp3_ = name;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = name;
		_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
		_tmp6_ = _tmp5_;
		_tmp2_ = string_contains (_tmp6_, text);
		_g_free0 (_tmp6_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		_g_free0 (name);
		return result;
	}
	_tmp7_ = G_OBJECT_GET_CLASS (object);
	_tmp8_ = g_object_class_find_property (_tmp7_, "description");
	if (_tmp8_ != NULL) {
		gchar* description = NULL;
		gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_;
		description = NULL;
		g_object_get (object, "description", &_tmp9_, NULL, NULL);
		_g_free0 (description);
		description = _tmp9_;
		_tmp11_ = description;
		if (_tmp11_ != NULL) {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp12_ = description;
			_tmp13_ = g_utf8_strdown (_tmp12_, (gssize) -1);
			_tmp14_ = _tmp13_;
			_tmp10_ = string_contains (_tmp14_, text);
			_g_free0 (_tmp14_);
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			result = TRUE;
			_g_free0 (description);
			_g_free0 (name);
			return result;
		}
		_g_free0 (description);
	}
	result = FALSE;
	_g_free0 (name);
	return result;
}

static gint
seahorse_item_list_compare_items (GObject* gobj_a,
                                  GObject* gobj_b)
{
	gchar* a_label = NULL;
	gchar* b_label = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint result;
	g_return_val_if_fail (gobj_a != NULL, 0);
	g_return_val_if_fail (gobj_b != NULL, 0);
	a_label = NULL;
	b_label = NULL;
	g_object_get (gobj_a, "label", &_tmp0_, NULL, NULL);
	_g_free0 (a_label);
	a_label = _tmp0_;
	g_object_get (gobj_b, "label", &_tmp1_, NULL, NULL);
	_g_free0 (b_label);
	b_label = _tmp1_;
	_tmp3_ = a_label;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = b_label;
		_tmp2_ = _tmp4_ == NULL;
	}
	if (_tmp2_) {
		gint _tmp5_ = 0;
		const gchar* _tmp6_;
		_tmp6_ = a_label;
		if (_tmp6_ == NULL) {
			_tmp5_ = 1;
		} else {
			_tmp5_ = -1;
		}
		result = _tmp5_;
		_g_free0 (b_label);
		_g_free0 (a_label);
		return result;
	}
	_tmp7_ = a_label;
	_tmp8_ = b_label;
	result = seahorse_item_list_compare_labels (_tmp7_, _tmp8_);
	_g_free0 (b_label);
	_g_free0 (a_label);
	return result;
}

static GObject*
seahorse_item_list_real_get_item (GListModel* base,
                                  guint position)
{
	SeahorseItemList * self;
	GPtrArray* _tmp0_;
	gconstpointer _tmp1_;
	GObject* _tmp2_;
	GObject* result;
	self = (SeahorseItemList*) base;
	_tmp0_ = self->priv->items;
	_tmp1_ = g_ptr_array_index (_tmp0_, position);
	_tmp2_ = _g_object_ref0 ((GObject*) _tmp1_);
	result = _tmp2_;
	return result;
}

static GType
seahorse_item_list_real_get_item_type (GListModel* base)
{
	SeahorseItemList * self;
	GType result;
	self = (SeahorseItemList*) base;
	result = G_TYPE_OBJECT;
	return result;
}

static guint
seahorse_item_list_real_get_n_items (GListModel* base)
{
	SeahorseItemList * self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint result;
	self = (SeahorseItemList*) base;
	_tmp0_ = self->priv->items;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

/**
     * Updates the collection.
     * Automatically called when you change filter_text to another value
     */
void
seahorse_item_list_refilter (SeahorseItemList* self)
{
	gint len = 0;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GPtrArray* _tmp3_;
	GcrCollection* _tmp4_;
	GList* _tmp5_;
	GPtrArray* _tmp10_;
	GPtrArray* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GPtrArray* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GcrCollection* _tmp17_;
	const gchar* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->items;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	len = _tmp2_;
	_tmp3_ = self->priv->items;
	g_ptr_array_remove_range (_tmp3_, (guint) 0, (guint) len);
	_tmp4_ = self->priv->_base_collection;
	_tmp5_ = gcr_collection_get_objects (_tmp4_);
	{
		GList* obj_collection = NULL;
		GList* obj_it = NULL;
		obj_collection = _tmp5_;
		for (obj_it = obj_collection; obj_it != NULL; obj_it = obj_it->next) {
			GObject* obj = NULL;
			obj = (GObject*) obj_it->data;
			{
				GObject* _tmp6_;
				_tmp6_ = obj;
				if (seahorse_item_list_item_matches_filters (self, _tmp6_)) {
					GPtrArray* _tmp7_;
					GObject* _tmp8_;
					GObject* _tmp9_;
					_tmp7_ = self->priv->items;
					_tmp8_ = obj;
					_tmp9_ = _g_object_ref0 (_tmp8_);
					g_ptr_array_add (_tmp7_, _tmp9_);
				}
			}
		}
		(obj_collection == NULL) ? NULL : (obj_collection = (g_list_free (obj_collection), NULL));
	}
	_tmp10_ = self->priv->items;
	vala_g_ptr_array_sort (_tmp10_, _seahorse_item_list_compare_items_gcompare_func);
	_tmp11_ = self->priv->items;
	_tmp12_ = vala_g_ptr_array_get_length (_tmp11_);
	_tmp13_ = _tmp12_;
	g_list_model_items_changed ((GListModel*) self, (guint) 0, (guint) len, (guint) _tmp13_);
	_tmp14_ = self->priv->items;
	_tmp15_ = vala_g_ptr_array_get_length (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->_base_collection;
	_tmp18_ = self->priv->_filter_text;
	g_debug ("item-list.vala:216: %u/%u elements visible after refilter on '%s'", (guint) _tmp16_, gcr_collection_get_length (_tmp17_), _tmp18_);
}

static gint
seahorse_item_list_compare_labels (const gchar* a_label,
                                   const gchar* b_label)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	gint result;
	g_return_val_if_fail (a_label != NULL, 0);
	g_return_val_if_fail (b_label != NULL, 0);
	_tmp0_ = g_utf8_casefold (a_label, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_casefold (b_label, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_utf8_collate (_tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}

GcrCollection*
seahorse_item_list_get_base_collection (SeahorseItemList* self)
{
	GcrCollection* result;
	GcrCollection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_collection;
	result = _tmp0_;
	return result;
}

static void
seahorse_item_list_set_base_collection (SeahorseItemList* self,
                                        GcrCollection* value)
{
	GcrCollection* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_item_list_get_base_collection (self);
	if (old_value != value) {
		GcrCollection* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_base_collection);
		self->priv->_base_collection = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_item_list_properties[SEAHORSE_ITEM_LIST_BASE_COLLECTION_PROPERTY]);
	}
}

SeahorseItemListShowFilter
seahorse_item_list_get_showfilter (SeahorseItemList* self)
{
	SeahorseItemListShowFilter result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_showfilter;
	return result;
}

void
seahorse_item_list_set_showfilter (SeahorseItemList* self,
                                   SeahorseItemListShowFilter value)
{
	SeahorseItemListShowFilter old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_item_list_get_showfilter (self);
	if (old_value != value) {
		self->priv->_showfilter = value;
		g_object_notify_by_pspec ((GObject *) self, seahorse_item_list_properties[SEAHORSE_ITEM_LIST_SHOWFILTER_PROPERTY]);
	}
}

void
seahorse_item_list_set_filter_text (SeahorseItemList* self,
                                    const gchar* value)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_filter_text;
	if (g_strcmp0 (_tmp0_, value) == 0) {
		return;
	}
	_tmp1_ = g_utf8_casefold (value, (gssize) -1);
	_g_free0 (self->priv->_filter_text);
	self->priv->_filter_text = _tmp1_;
	seahorse_item_list_refilter (self);
	g_object_notify_by_pspec ((GObject *) self, seahorse_item_list_properties[SEAHORSE_ITEM_LIST_FILTER_TEXT_PROPERTY]);
}

static void
seahorse_item_list_class_init (SeahorseItemListClass * klass,
                               gpointer klass_data)
{
	seahorse_item_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseItemList_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_item_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_item_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = seahorse_item_list_finalize;
	/** The basic collection */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_ITEM_LIST_BASE_COLLECTION_PROPERTY, seahorse_item_list_properties[SEAHORSE_ITEM_LIST_BASE_COLLECTION_PROPERTY] = g_param_spec_object ("base-collection", "base-collection", "base-collection", gcr_collection_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_ITEM_LIST_SHOWFILTER_PROPERTY, seahorse_item_list_properties[SEAHORSE_ITEM_LIST_SHOWFILTER_PROPERTY] = g_param_spec_enum ("showfilter", "showfilter", "showfilter", SEAHORSE_ITEM_LIST_TYPE_SHOW_FILTER, SEAHORSE_ITEM_LIST_SHOW_FILTER_ANY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_ITEM_LIST_FILTER_TEXT_PROPERTY, seahorse_item_list_properties[SEAHORSE_ITEM_LIST_FILTER_TEXT_PROPERTY] = g_param_spec_string ("filter-text", "filter-text", "filter-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
}

static void
seahorse_item_list_g_list_model_interface_init (GListModelInterface * iface,
                                                gpointer iface_data)
{
	seahorse_item_list_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item = (GObject* (*) (GListModel*, guint)) seahorse_item_list_real_get_item;
	iface->get_item_type = (GType (*) (GListModel*)) seahorse_item_list_real_get_item_type;
	iface->get_n_items = (guint (*) (GListModel*)) seahorse_item_list_real_get_n_items;
}

static void
seahorse_item_list_instance_init (SeahorseItemList * self,
                                  gpointer klass)
{
	GPtrArray* _tmp0_;
	gchar* _tmp1_;
	self->priv = seahorse_item_list_get_instance_private (self);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	self->priv->items = _tmp0_;
	self->priv->_showfilter = SEAHORSE_ITEM_LIST_SHOW_FILTER_ANY;
	_tmp1_ = g_strdup ("");
	self->priv->_filter_text = _tmp1_;
}

static void
seahorse_item_list_finalize (GObject * obj)
{
	SeahorseItemList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_ITEM_LIST, SeahorseItemList);
	_g_object_unref0 (self->priv->_base_collection);
	_g_ptr_array_unref0 (self->priv->items);
	_g_free0 (self->priv->_filter_text);
	G_OBJECT_CLASS (seahorse_item_list_parent_class)->finalize (obj);
}

/**
 * A ItemList is a {@GLib.ListModel} which knows how to handle
 * {@link Gcr.Collection}s. These basically provide a compatibility wrapper
 * {@link GLib.ListModel}, lists that propagate changes to their listener (such
 * as a {@link Gtk.ListBox}).
 *
 * This list makes an assumption that each iten is a Seahorse.Object, or provides
 * the necessary properties like "label" and possibly "description".
 */
 G_GNUC_NO_INLINE static GType
seahorse_item_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseItemListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_item_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseItemList), 0, (GInstanceInitFunc) seahorse_item_list_instance_init, NULL };
	static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) seahorse_item_list_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType seahorse_item_list_type_id;
	seahorse_item_list_type_id = g_type_register_static (G_TYPE_OBJECT, "SeahorseItemList", &g_define_type_info, 0);
	g_type_add_interface_static (seahorse_item_list_type_id, g_list_model_get_type (), &g_list_model_info);
	SeahorseItemList_private_offset = g_type_add_instance_private (seahorse_item_list_type_id, sizeof (SeahorseItemListPrivate));
	return seahorse_item_list_type_id;
}

GType
seahorse_item_list_get_type (void)
{
	static volatile gsize seahorse_item_list_type_id__once = 0;
	if (g_once_init_enter (&seahorse_item_list_type_id__once)) {
		GType seahorse_item_list_type_id;
		seahorse_item_list_type_id = seahorse_item_list_get_type_once ();
		g_once_init_leave (&seahorse_item_list_type_id__once, seahorse_item_list_type_id);
	}
	return seahorse_item_list_type_id__once;
}

static void
_vala_seahorse_item_list_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	SeahorseItemList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_ITEM_LIST, SeahorseItemList);
	switch (property_id) {
		case SEAHORSE_ITEM_LIST_BASE_COLLECTION_PROPERTY:
		g_value_set_object (value, seahorse_item_list_get_base_collection (self));
		break;
		case SEAHORSE_ITEM_LIST_SHOWFILTER_PROPERTY:
		g_value_set_enum (value, seahorse_item_list_get_showfilter (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_item_list_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	SeahorseItemList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_ITEM_LIST, SeahorseItemList);
	switch (property_id) {
		case SEAHORSE_ITEM_LIST_BASE_COLLECTION_PROPERTY:
		seahorse_item_list_set_base_collection (self, g_value_get_object (value));
		break;
		case SEAHORSE_ITEM_LIST_SHOWFILTER_PROPERTY:
		seahorse_item_list_set_showfilter (self, g_value_get_enum (value));
		break;
		case SEAHORSE_ITEM_LIST_FILTER_TEXT_PROPERTY:
		seahorse_item_list_set_filter_text (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

