// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT
#![allow(deprecated)]

use crate::{
    ffi, Accessible, AccessibleRole, Align, Application, Buildable, ConstraintTarget,
    LayoutManager, Native, Overflow, Root, ShortcutManager, Widget, WindowGroup,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkWindow")]
    pub struct Window(Object<ffi::GtkWindow, ffi::GtkWindowClass>) @extends Widget, @implements Accessible, Buildable, ConstraintTarget, Native, Root, ShortcutManager;

    match fn {
        type_ => || ffi::gtk_window_get_type(),
    }
}

impl Window {
    pub const NONE: Option<&'static Window> = None;

    #[doc(alias = "gtk_window_new")]
    pub fn new() -> Window {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_window_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Window`] objects.
    ///
    /// This method returns an instance of [`WindowBuilder`](crate::builders::WindowBuilder) which can be used to create [`Window`] objects.
    pub fn builder() -> WindowBuilder {
        WindowBuilder::new()
    }

    #[doc(alias = "gtk_window_get_default_icon_name")]
    #[doc(alias = "get_default_icon_name")]
    pub fn default_icon_name() -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gtk_window_get_default_icon_name()) }
    }

    #[doc(alias = "gtk_window_get_toplevels")]
    #[doc(alias = "get_toplevels")]
    pub fn toplevels() -> gio::ListModel {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gtk_window_get_toplevels()) }
    }

    #[doc(alias = "gtk_window_list_toplevels")]
    pub fn list_toplevels() -> Vec<Widget> {
        assert_initialized_main_thread!();
        unsafe { FromGlibPtrContainer::from_glib_container(ffi::gtk_window_list_toplevels()) }
    }

    #[doc(alias = "gtk_window_set_auto_startup_notification")]
    pub fn set_auto_startup_notification(setting: bool) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_window_set_auto_startup_notification(setting.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_default_icon_name")]
    pub fn set_default_icon_name(name: &str) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_window_set_default_icon_name(name.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_set_interactive_debugging")]
    pub fn set_interactive_debugging(enable: bool) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_window_set_interactive_debugging(enable.into_glib());
        }
    }
}

impl Default for Window {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Window`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct WindowBuilder {
    builder: glib::object::ObjectBuilder<'static, Window>,
}

impl WindowBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn application(self, application: &impl IsA<Application>) -> Self {
        Self {
            builder: self
                .builder
                .property("application", application.clone().upcast()),
        }
    }

    pub fn child(self, child: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn decorated(self, decorated: bool) -> Self {
        Self {
            builder: self.builder.property("decorated", decorated),
        }
    }

    pub fn default_height(self, default_height: i32) -> Self {
        Self {
            builder: self.builder.property("default-height", default_height),
        }
    }

    pub fn default_widget(self, default_widget: &impl IsA<Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("default-widget", default_widget.clone().upcast()),
        }
    }

    pub fn default_width(self, default_width: i32) -> Self {
        Self {
            builder: self.builder.property("default-width", default_width),
        }
    }

    pub fn deletable(self, deletable: bool) -> Self {
        Self {
            builder: self.builder.property("deletable", deletable),
        }
    }

    pub fn destroy_with_parent(self, destroy_with_parent: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("destroy-with-parent", destroy_with_parent),
        }
    }

    pub fn display(self, display: &impl IsA<gdk::Display>) -> Self {
        Self {
            builder: self.builder.property("display", display.clone().upcast()),
        }
    }

    pub fn focus_visible(self, focus_visible: bool) -> Self {
        Self {
            builder: self.builder.property("focus-visible", focus_visible),
        }
    }

    pub fn focus_widget(self, focus_widget: &impl IsA<Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("focus-widget", focus_widget.clone().upcast()),
        }
    }

    pub fn fullscreened(self, fullscreened: bool) -> Self {
        Self {
            builder: self.builder.property("fullscreened", fullscreened),
        }
    }

    #[cfg(feature = "v4_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_2")))]
    pub fn handle_menubar_accel(self, handle_menubar_accel: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("handle-menubar-accel", handle_menubar_accel),
        }
    }

    pub fn hide_on_close(self, hide_on_close: bool) -> Self {
        Self {
            builder: self.builder.property("hide-on-close", hide_on_close),
        }
    }

    pub fn icon_name(self, icon_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("icon-name", icon_name.into()),
        }
    }

    pub fn maximized(self, maximized: bool) -> Self {
        Self {
            builder: self.builder.property("maximized", maximized),
        }
    }

    pub fn mnemonics_visible(self, mnemonics_visible: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("mnemonics-visible", mnemonics_visible),
        }
    }

    pub fn modal(self, modal: bool) -> Self {
        Self {
            builder: self.builder.property("modal", modal),
        }
    }

    pub fn resizable(self, resizable: bool) -> Self {
        Self {
            builder: self.builder.property("resizable", resizable),
        }
    }

    pub fn startup_id(self, startup_id: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("startup-id", startup_id.into()),
        }
    }

    pub fn title(self, title: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("title", title.into()),
        }
    }

    #[cfg(feature = "v4_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_6")))]
    pub fn titlebar(self, titlebar: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("titlebar", titlebar.clone().upcast()),
        }
    }

    pub fn transient_for(self, transient_for: &impl IsA<Window>) -> Self {
        Self {
            builder: self
                .builder
                .property("transient-for", transient_for.clone().upcast()),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Window`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Window {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::Window>> Sealed for T {}
}

pub trait GtkWindowExt: IsA<Window> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_window_close")]
    fn close(&self) {
        unsafe {
            ffi::gtk_window_close(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_destroy")]
    fn destroy(&self) {
        unsafe {
            ffi::gtk_window_destroy(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_fullscreen")]
    fn fullscreen(&self) {
        unsafe {
            ffi::gtk_window_fullscreen(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_fullscreen_on_monitor")]
    fn fullscreen_on_monitor(&self, monitor: &gdk::Monitor) {
        unsafe {
            ffi::gtk_window_fullscreen_on_monitor(
                self.as_ref().to_glib_none().0,
                monitor.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_get_application")]
    #[doc(alias = "get_application")]
    fn application(&self) -> Option<Application> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_application(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_child")]
    #[doc(alias = "get_child")]
    fn child(&self) -> Option<Widget> {
        unsafe { from_glib_none(ffi::gtk_window_get_child(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_get_decorated")]
    #[doc(alias = "get_decorated")]
    #[doc(alias = "decorated")]
    fn is_decorated(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_decorated(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_default_size")]
    #[doc(alias = "get_default_size")]
    fn default_size(&self) -> (i32, i32) {
        unsafe {
            let mut width = std::mem::MaybeUninit::uninit();
            let mut height = std::mem::MaybeUninit::uninit();
            ffi::gtk_window_get_default_size(
                self.as_ref().to_glib_none().0,
                width.as_mut_ptr(),
                height.as_mut_ptr(),
            );
            (width.assume_init(), height.assume_init())
        }
    }

    #[doc(alias = "gtk_window_get_default_widget")]
    #[doc(alias = "get_default_widget")]
    #[doc(alias = "default-widget")]
    fn default_widget(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_default_widget(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_deletable")]
    #[doc(alias = "get_deletable")]
    #[doc(alias = "deletable")]
    fn is_deletable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_deletable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_destroy_with_parent")]
    #[doc(alias = "get_destroy_with_parent")]
    #[doc(alias = "destroy-with-parent")]
    fn must_destroy_with_parent(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_destroy_with_parent(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_focus")]
    #[doc(alias = "get_focus")]
    #[doc(alias = "focus-widget")]
    fn focus(&self) -> Option<Widget> {
        unsafe { from_glib_none(ffi::gtk_window_get_focus(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_get_focus_visible")]
    #[doc(alias = "get_focus_visible")]
    #[doc(alias = "focus-visible")]
    fn gets_focus_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_focus_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_group")]
    #[doc(alias = "get_group")]
    fn group(&self) -> WindowGroup {
        unsafe { from_glib_none(ffi::gtk_window_get_group(self.as_ref().to_glib_none().0)) }
    }

    #[cfg(feature = "v4_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_2")))]
    #[doc(alias = "gtk_window_get_handle_menubar_accel")]
    #[doc(alias = "get_handle_menubar_accel")]
    #[doc(alias = "handle-menubar-accel")]
    fn is_handle_menubar_accel(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_handle_menubar_accel(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_hide_on_close")]
    #[doc(alias = "get_hide_on_close")]
    #[doc(alias = "hide-on-close")]
    fn hides_on_close(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_hide_on_close(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_icon_name")]
    #[doc(alias = "get_icon_name")]
    #[doc(alias = "icon-name")]
    fn icon_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_icon_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_mnemonics_visible")]
    #[doc(alias = "get_mnemonics_visible")]
    #[doc(alias = "mnemonics-visible")]
    fn is_mnemonics_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_mnemonics_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_modal")]
    #[doc(alias = "get_modal")]
    #[doc(alias = "modal")]
    fn is_modal(&self) -> bool {
        unsafe { from_glib(ffi::gtk_window_get_modal(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_get_resizable")]
    #[doc(alias = "get_resizable")]
    #[doc(alias = "resizable")]
    fn is_resizable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_resizable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_get_title")]
    #[doc(alias = "get_title")]
    fn title(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gtk_window_get_title(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_get_titlebar")]
    #[doc(alias = "get_titlebar")]
    fn titlebar(&self) -> Option<Widget> {
        unsafe { from_glib_none(ffi::gtk_window_get_titlebar(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_get_transient_for")]
    #[doc(alias = "get_transient_for")]
    #[doc(alias = "transient-for")]
    #[must_use]
    fn transient_for(&self) -> Option<Window> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_transient_for(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_has_group")]
    fn has_group(&self) -> bool {
        unsafe { from_glib(ffi::gtk_window_has_group(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_is_active")]
    #[doc(alias = "is-active")]
    fn is_active(&self) -> bool {
        unsafe { from_glib(ffi::gtk_window_is_active(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_is_fullscreen")]
    #[doc(alias = "fullscreened")]
    fn is_fullscreen(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_is_fullscreen(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_window_is_maximized")]
    #[doc(alias = "maximized")]
    fn is_maximized(&self) -> bool {
        unsafe { from_glib(ffi::gtk_window_is_maximized(self.as_ref().to_glib_none().0)) }
    }

    #[cfg(feature = "v4_12")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_12")))]
    #[doc(alias = "gtk_window_is_suspended")]
    #[doc(alias = "suspended")]
    fn is_suspended(&self) -> bool {
        unsafe { from_glib(ffi::gtk_window_is_suspended(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_window_maximize")]
    fn maximize(&self) {
        unsafe {
            ffi::gtk_window_maximize(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_minimize")]
    fn minimize(&self) {
        unsafe {
            ffi::gtk_window_minimize(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_present")]
    fn present(&self) {
        unsafe {
            ffi::gtk_window_present(self.as_ref().to_glib_none().0);
        }
    }

    #[cfg_attr(feature = "v4_14", deprecated = "Since 4.14")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_window_present_with_time")]
    fn present_with_time(&self, timestamp: u32) {
        unsafe {
            ffi::gtk_window_present_with_time(self.as_ref().to_glib_none().0, timestamp);
        }
    }

    #[doc(alias = "gtk_window_set_application")]
    #[doc(alias = "application")]
    fn set_application(&self, application: Option<&impl IsA<Application>>) {
        unsafe {
            ffi::gtk_window_set_application(
                self.as_ref().to_glib_none().0,
                application.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_set_child")]
    #[doc(alias = "child")]
    fn set_child(&self, child: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_window_set_child(
                self.as_ref().to_glib_none().0,
                child.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_set_decorated")]
    #[doc(alias = "decorated")]
    fn set_decorated(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_decorated(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_default_size")]
    fn set_default_size(&self, width: i32, height: i32) {
        unsafe {
            ffi::gtk_window_set_default_size(self.as_ref().to_glib_none().0, width, height);
        }
    }

    #[doc(alias = "gtk_window_set_default_widget")]
    #[doc(alias = "default-widget")]
    fn set_default_widget(&self, default_widget: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_window_set_default_widget(
                self.as_ref().to_glib_none().0,
                default_widget.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_set_deletable")]
    #[doc(alias = "deletable")]
    fn set_deletable(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_deletable(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_destroy_with_parent")]
    #[doc(alias = "destroy-with-parent")]
    fn set_destroy_with_parent(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_destroy_with_parent(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_window_set_display")]
    #[doc(alias = "display")]
    fn set_display(&self, display: &impl IsA<gdk::Display>) {
        unsafe {
            ffi::gtk_window_set_display(
                self.as_ref().to_glib_none().0,
                display.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_set_focus")]
    #[doc(alias = "focus-widget")]
    fn set_focus(&self, focus: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_window_set_focus(
                self.as_ref().to_glib_none().0,
                focus.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_set_focus_visible")]
    #[doc(alias = "focus-visible")]
    fn set_focus_visible(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_focus_visible(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    #[cfg(feature = "v4_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_2")))]
    #[doc(alias = "gtk_window_set_handle_menubar_accel")]
    #[doc(alias = "handle-menubar-accel")]
    fn set_handle_menubar_accel(&self, handle_menubar_accel: bool) {
        unsafe {
            ffi::gtk_window_set_handle_menubar_accel(
                self.as_ref().to_glib_none().0,
                handle_menubar_accel.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_window_set_hide_on_close")]
    #[doc(alias = "hide-on-close")]
    fn set_hide_on_close(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_hide_on_close(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_icon_name")]
    #[doc(alias = "icon-name")]
    fn set_icon_name(&self, name: Option<&str>) {
        unsafe {
            ffi::gtk_window_set_icon_name(self.as_ref().to_glib_none().0, name.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_set_mnemonics_visible")]
    #[doc(alias = "mnemonics-visible")]
    fn set_mnemonics_visible(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_mnemonics_visible(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_window_set_modal")]
    #[doc(alias = "modal")]
    fn set_modal(&self, modal: bool) {
        unsafe {
            ffi::gtk_window_set_modal(self.as_ref().to_glib_none().0, modal.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_resizable")]
    #[doc(alias = "resizable")]
    fn set_resizable(&self, resizable: bool) {
        unsafe {
            ffi::gtk_window_set_resizable(self.as_ref().to_glib_none().0, resizable.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_startup_id")]
    #[doc(alias = "startup-id")]
    fn set_startup_id(&self, startup_id: &str) {
        unsafe {
            ffi::gtk_window_set_startup_id(
                self.as_ref().to_glib_none().0,
                startup_id.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_set_title")]
    #[doc(alias = "title")]
    fn set_title(&self, title: Option<&str>) {
        unsafe {
            ffi::gtk_window_set_title(self.as_ref().to_glib_none().0, title.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_set_titlebar")]
    #[doc(alias = "titlebar")]
    fn set_titlebar(&self, titlebar: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_window_set_titlebar(
                self.as_ref().to_glib_none().0,
                titlebar.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_set_transient_for")]
    #[doc(alias = "transient-for")]
    fn set_transient_for(&self, parent: Option<&impl IsA<Window>>) {
        unsafe {
            ffi::gtk_window_set_transient_for(
                self.as_ref().to_glib_none().0,
                parent.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_window_unfullscreen")]
    fn unfullscreen(&self) {
        unsafe {
            ffi::gtk_window_unfullscreen(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_unmaximize")]
    fn unmaximize(&self) {
        unsafe {
            ffi::gtk_window_unmaximize(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_unminimize")]
    fn unminimize(&self) {
        unsafe {
            ffi::gtk_window_unminimize(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "default-height")]
    fn default_height(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "default-height")
    }

    #[doc(alias = "default-height")]
    fn set_default_height(&self, default_height: i32) {
        ObjectExt::set_property(self.as_ref(), "default-height", default_height)
    }

    #[doc(alias = "default-width")]
    fn default_width(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "default-width")
    }

    #[doc(alias = "default-width")]
    fn set_default_width(&self, default_width: i32) {
        ObjectExt::set_property(self.as_ref(), "default-width", default_width)
    }

    fn set_fullscreened(&self, fullscreened: bool) {
        ObjectExt::set_property(self.as_ref(), "fullscreened", fullscreened)
    }

    fn set_maximized(&self, maximized: bool) {
        ObjectExt::set_property(self.as_ref(), "maximized", maximized)
    }

    #[doc(alias = "activate-default")]
    fn connect_activate_default<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn activate_default_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate-default\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    activate_default_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_activate_default(&self) {
        self.emit_by_name::<()>("activate-default", &[]);
    }

    #[doc(alias = "activate-focus")]
    fn connect_activate_focus<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn activate_focus_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate-focus\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    activate_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_activate_focus(&self) {
        self.emit_by_name::<()>("activate-focus", &[]);
    }

    #[doc(alias = "close-request")]
    fn connect_close_request<F: Fn(&Self) -> glib::Propagation + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn close_request_trampoline<
            P: IsA<Window>,
            F: Fn(&P) -> glib::Propagation + 'static,
        >(
            this: *mut ffi::GtkWindow,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref()).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"close-request\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    close_request_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-debugging")]
    fn connect_enable_debugging<F: Fn(&Self, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn enable_debugging_trampoline<
            P: IsA<Window>,
            F: Fn(&P, bool) -> bool + 'static,
        >(
            this: *mut ffi::GtkWindow,
            toggle: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Window::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(toggle),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"enable-debugging\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    enable_debugging_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_enable_debugging(&self, toggle: bool) -> bool {
        self.emit_by_name("enable-debugging", &[&toggle])
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[doc(alias = "keys-changed")]
    fn connect_keys_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn keys_changed_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"keys-changed\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    keys_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "application")]
    fn connect_application_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_application_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::application\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_application_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "child")]
    fn connect_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_child_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::child\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_child_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "decorated")]
    fn connect_decorated_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_decorated_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::decorated\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_decorated_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "default-height")]
    fn connect_default_height_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_default_height_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::default-height\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_default_height_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "default-widget")]
    fn connect_default_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_default_widget_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::default-widget\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_default_widget_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "default-width")]
    fn connect_default_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_default_width_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::default-width\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_default_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "deletable")]
    fn connect_deletable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_deletable_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::deletable\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_deletable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "destroy-with-parent")]
    fn connect_destroy_with_parent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_destroy_with_parent_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::destroy-with-parent\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_destroy_with_parent_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "display")]
    fn connect_display_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_display_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::display\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_display_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "focus-visible")]
    fn connect_focus_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_focus_visible_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::focus-visible\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_focus_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "focus-widget")]
    fn connect_focus_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_focus_widget_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::focus-widget\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_focus_widget_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "fullscreened")]
    fn connect_fullscreened_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fullscreened_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fullscreened\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_fullscreened_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_2")))]
    #[doc(alias = "handle-menubar-accel")]
    fn connect_handle_menubar_accel_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_handle_menubar_accel_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::handle-menubar-accel\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_handle_menubar_accel_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "hide-on-close")]
    fn connect_hide_on_close_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hide_on_close_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hide-on-close\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_hide_on_close_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "icon-name")]
    fn connect_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_icon_name_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::icon-name\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_icon_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "is-active")]
    fn connect_is_active_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_active_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::is-active\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_is_active_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "maximized")]
    fn connect_maximized_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_maximized_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::maximized\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_maximized_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "mnemonics-visible")]
    fn connect_mnemonics_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_mnemonics_visible_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::mnemonics-visible\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_mnemonics_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "modal")]
    fn connect_modal_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_modal_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::modal\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_modal_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "resizable")]
    fn connect_resizable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_resizable_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::resizable\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_resizable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "startup-id")]
    fn connect_startup_id_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_startup_id_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::startup-id\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_startup_id_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_12")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_12")))]
    #[doc(alias = "suspended")]
    fn connect_suspended_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_suspended_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::suspended\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_suspended_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "title")]
    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::title\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_title_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_6")))]
    #[doc(alias = "titlebar")]
    fn connect_titlebar_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_titlebar_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::titlebar\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_titlebar_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "transient-for")]
    fn connect_transient_for_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_transient_for_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::transient-for\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_transient_for_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<Window>> GtkWindowExt for O {}
