/*
 * This file is part of the Sofia-SIP package
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Pekka Pessi <pekka.pessi@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

/**@CFILE sip_tag.c  SIP Tags.
 *
 * This file is automatically generated from <sip.h> by msg_parser.awk.
 *
 * @author Pekka Pessi <Pekka.Pessi@nokia.com>.
 *
 * @date Created: Fri Feb 23 12:46:42 2001 ppessi
 */

#include "config.h"

#include <assert.h>
#include <stddef.h>
#include <string.h>

#include <sofia-sip/su.h>

#define TAG_NAMESPACE "sip"

#include "sofia-sip/sip_parser.h"
#include <sofia-sip/sip_tag.h>

#include <sofia-sip/su_tag_class.h>
#include <sofia-sip/su_tag_inline.h>
#include <sofia-sip/sip_tag_class.h>

#include <sofia-sip/su_tagarg.h>

tag_typedef_t siptag_any = NSTAG_TYPEDEF(*);

tag_typedef_t siptag_sip = SIPMSGTAG_TYPEDEF(sip);

tag_typedef_t siptag_header = {{ "sip", "header", siphdrtag_class, 0 }};

tag_typedef_t siptag_header_str = STRTAG_TYPEDEF(header_str);

tag_typedef_t siptag_end = TAG_TYPEDEF(tag_end, end);


extern msg_hclass_t sip_request_class[];

/**@ingroup sip_request
 * Tag for @ref sip_request "request line" object.
 */
tag_typedef_t siptag_request = SIPHDRTAG_TYPEDEF(request);
/**@ingroup sip_request
 * Tag for string with @ref sip_request "request line" value.
 */
tag_typedef_t siptag_request_str = SIPSTRTAG_TYPEDEF(request);

extern msg_hclass_t sip_status_class[];

/**@ingroup sip_status
 * Tag for @ref sip_status "status line" object.
 */
tag_typedef_t siptag_status = SIPHDRTAG_TYPEDEF(status);
/**@ingroup sip_status
 * Tag for string with @ref sip_status "status line" value.
 */
tag_typedef_t siptag_status_str = SIPSTRTAG_TYPEDEF(status);

extern msg_hclass_t sip_via_class[];

/**@ingroup sip_via
 * Tag for @ref sip_via "Via header" object.
 */
tag_typedef_t siptag_via = SIPHDRTAG_TYPEDEF(via);
/**@ingroup sip_via
 * Tag for string with @ref sip_via "Via header" value.
 */
tag_typedef_t siptag_via_str = SIPSTRTAG_TYPEDEF(via);

extern msg_hclass_t sip_route_class[];

/**@ingroup sip_route
 * Tag for @ref sip_route "Route header" object.
 */
tag_typedef_t siptag_route = SIPHDRTAG_TYPEDEF(route);
/**@ingroup sip_route
 * Tag for string with @ref sip_route "Route header" value.
 */
tag_typedef_t siptag_route_str = SIPSTRTAG_TYPEDEF(route);

extern msg_hclass_t sip_record_route_class[];

/**@ingroup sip_record_route
 * Tag for @ref sip_record_route "Record-Route header" object.
 */
tag_typedef_t siptag_record_route = SIPHDRTAG_TYPEDEF(record_route);
/**@ingroup sip_record_route
 * Tag for string with @ref sip_record_route "Record-Route header" value.
 */
tag_typedef_t siptag_record_route_str = SIPSTRTAG_TYPEDEF(record_route);

extern msg_hclass_t sip_max_forwards_class[];

/**@ingroup sip_max_forwards
 * Tag for @ref sip_max_forwards "Max-Forwards header" object.
 */
tag_typedef_t siptag_max_forwards = SIPHDRTAG_TYPEDEF(max_forwards);
/**@ingroup sip_max_forwards
 * Tag for string with @ref sip_max_forwards "Max-Forwards header" value.
 */
tag_typedef_t siptag_max_forwards_str = SIPSTRTAG_TYPEDEF(max_forwards);

extern msg_hclass_t sip_proxy_require_class[];

/**@ingroup sip_proxy_require
 * Tag for @ref sip_proxy_require "Proxy-Require header" object.
 */
tag_typedef_t siptag_proxy_require = SIPHDRTAG_TYPEDEF(proxy_require);
/**@ingroup sip_proxy_require
 * Tag for string with @ref sip_proxy_require "Proxy-Require header" value.
 */
tag_typedef_t siptag_proxy_require_str = SIPSTRTAG_TYPEDEF(proxy_require);

extern msg_hclass_t sip_from_class[];

/**@ingroup sip_from
 * Tag for @ref sip_from "From header" object.
 */
tag_typedef_t siptag_from = SIPHDRTAG_TYPEDEF(from);
/**@ingroup sip_from
 * Tag for string with @ref sip_from "From header" value.
 */
tag_typedef_t siptag_from_str = SIPSTRTAG_TYPEDEF(from);

extern msg_hclass_t sip_to_class[];

/**@ingroup sip_to
 * Tag for @ref sip_to "To header" object.
 */
tag_typedef_t siptag_to = SIPHDRTAG_TYPEDEF(to);
/**@ingroup sip_to
 * Tag for string with @ref sip_to "To header" value.
 */
tag_typedef_t siptag_to_str = SIPSTRTAG_TYPEDEF(to);

extern msg_hclass_t sip_call_id_class[];

/**@ingroup sip_call_id
 * Tag for @ref sip_call_id "Call-ID header" object.
 */
tag_typedef_t siptag_call_id = SIPHDRTAG_TYPEDEF(call_id);
/**@ingroup sip_call_id
 * Tag for string with @ref sip_call_id "Call-ID header" value.
 */
tag_typedef_t siptag_call_id_str = SIPSTRTAG_TYPEDEF(call_id);

extern msg_hclass_t sip_cseq_class[];

/**@ingroup sip_cseq
 * Tag for @ref sip_cseq "CSeq header" object.
 */
tag_typedef_t siptag_cseq = SIPHDRTAG_TYPEDEF(cseq);
/**@ingroup sip_cseq
 * Tag for string with @ref sip_cseq "CSeq header" value.
 */
tag_typedef_t siptag_cseq_str = SIPSTRTAG_TYPEDEF(cseq);

extern msg_hclass_t sip_identity_class[];

/**@ingroup sip_identity
 * Tag for @ref sip_identity "Identity header" object.
 */
tag_typedef_t siptag_identity = SIPHDRTAG_TYPEDEF(identity);
/**@ingroup sip_identity
 * Tag for string with @ref sip_identity "Identity header" value.
 */
tag_typedef_t siptag_identity_str = SIPSTRTAG_TYPEDEF(identity);

extern msg_hclass_t sip_contact_class[];

/**@ingroup sip_contact
 * Tag for @ref sip_contact "Contact header" object.
 */
tag_typedef_t siptag_contact = SIPHDRTAG_TYPEDEF(contact);
/**@ingroup sip_contact
 * Tag for string with @ref sip_contact "Contact header" value.
 */
tag_typedef_t siptag_contact_str = SIPSTRTAG_TYPEDEF(contact);

extern msg_hclass_t sip_rseq_class[];

/**@ingroup sip_rseq
 * Tag for @ref sip_rseq "RSeq header" object.
 */
tag_typedef_t siptag_rseq = SIPHDRTAG_TYPEDEF(rseq);
/**@ingroup sip_rseq
 * Tag for string with @ref sip_rseq "RSeq header" value.
 */
tag_typedef_t siptag_rseq_str = SIPSTRTAG_TYPEDEF(rseq);

extern msg_hclass_t sip_rack_class[];

/**@ingroup sip_rack
 * Tag for @ref sip_rack "RAck header" object.
 */
tag_typedef_t siptag_rack = SIPHDRTAG_TYPEDEF(rack);
/**@ingroup sip_rack
 * Tag for string with @ref sip_rack "RAck header" value.
 */
tag_typedef_t siptag_rack_str = SIPSTRTAG_TYPEDEF(rack);

extern msg_hclass_t sip_request_disposition_class[];

/**@ingroup sip_request_disposition
 * Tag for @ref sip_request_disposition "Request-Disposition header" object.
 */
tag_typedef_t siptag_request_disposition = SIPHDRTAG_TYPEDEF(request_disposition);
/**@ingroup sip_request_disposition
 * Tag for string with @ref sip_request_disposition "Request-Disposition header" value.
 */
tag_typedef_t siptag_request_disposition_str = SIPSTRTAG_TYPEDEF(request_disposition);

extern msg_hclass_t sip_accept_contact_class[];

/**@ingroup sip_accept_contact
 * Tag for @ref sip_accept_contact "Accept-Contact header" object.
 */
tag_typedef_t siptag_accept_contact = SIPHDRTAG_TYPEDEF(accept_contact);
/**@ingroup sip_accept_contact
 * Tag for string with @ref sip_accept_contact "Accept-Contact header" value.
 */
tag_typedef_t siptag_accept_contact_str = SIPSTRTAG_TYPEDEF(accept_contact);

extern msg_hclass_t sip_reject_contact_class[];

/**@ingroup sip_reject_contact
 * Tag for @ref sip_reject_contact "Reject-Contact header" object.
 */
tag_typedef_t siptag_reject_contact = SIPHDRTAG_TYPEDEF(reject_contact);
/**@ingroup sip_reject_contact
 * Tag for string with @ref sip_reject_contact "Reject-Contact header" value.
 */
tag_typedef_t siptag_reject_contact_str = SIPSTRTAG_TYPEDEF(reject_contact);

extern msg_hclass_t sip_expires_class[];

/**@ingroup sip_expires
 * Tag for @ref sip_expires "Expires header" object.
 */
tag_typedef_t siptag_expires = SIPHDRTAG_TYPEDEF(expires);
/**@ingroup sip_expires
 * Tag for string with @ref sip_expires "Expires header" value.
 */
tag_typedef_t siptag_expires_str = SIPSTRTAG_TYPEDEF(expires);

extern msg_hclass_t sip_date_class[];

/**@ingroup sip_date
 * Tag for @ref sip_date "Date header" object.
 */
tag_typedef_t siptag_date = SIPHDRTAG_TYPEDEF(date);
/**@ingroup sip_date
 * Tag for string with @ref sip_date "Date header" value.
 */
tag_typedef_t siptag_date_str = SIPSTRTAG_TYPEDEF(date);

extern msg_hclass_t sip_retry_after_class[];

/**@ingroup sip_retry_after
 * Tag for @ref sip_retry_after "Retry-After header" object.
 */
tag_typedef_t siptag_retry_after = SIPHDRTAG_TYPEDEF(retry_after);
/**@ingroup sip_retry_after
 * Tag for string with @ref sip_retry_after "Retry-After header" value.
 */
tag_typedef_t siptag_retry_after_str = SIPSTRTAG_TYPEDEF(retry_after);

extern msg_hclass_t sip_timestamp_class[];

/**@ingroup sip_timestamp
 * Tag for @ref sip_timestamp "Timestamp header" object.
 */
tag_typedef_t siptag_timestamp = SIPHDRTAG_TYPEDEF(timestamp);
/**@ingroup sip_timestamp
 * Tag for string with @ref sip_timestamp "Timestamp header" value.
 */
tag_typedef_t siptag_timestamp_str = SIPSTRTAG_TYPEDEF(timestamp);

extern msg_hclass_t sip_min_expires_class[];

/**@ingroup sip_min_expires
 * Tag for @ref sip_min_expires "Min-Expires header" object.
 */
tag_typedef_t siptag_min_expires = SIPHDRTAG_TYPEDEF(min_expires);
/**@ingroup sip_min_expires
 * Tag for string with @ref sip_min_expires "Min-Expires header" value.
 */
tag_typedef_t siptag_min_expires_str = SIPSTRTAG_TYPEDEF(min_expires);

extern msg_hclass_t sip_subject_class[];

/**@ingroup sip_subject
 * Tag for @ref sip_subject "Subject header" object.
 */
tag_typedef_t siptag_subject = SIPHDRTAG_TYPEDEF(subject);
/**@ingroup sip_subject
 * Tag for string with @ref sip_subject "Subject header" value.
 */
tag_typedef_t siptag_subject_str = SIPSTRTAG_TYPEDEF(subject);

extern msg_hclass_t sip_priority_class[];

/**@ingroup sip_priority
 * Tag for @ref sip_priority "Priority header" object.
 */
tag_typedef_t siptag_priority = SIPHDRTAG_TYPEDEF(priority);
/**@ingroup sip_priority
 * Tag for string with @ref sip_priority "Priority header" value.
 */
tag_typedef_t siptag_priority_str = SIPSTRTAG_TYPEDEF(priority);

extern msg_hclass_t sip_call_info_class[];

/**@ingroup sip_call_info
 * Tag for @ref sip_call_info "Call-Info header" object.
 */
tag_typedef_t siptag_call_info = SIPHDRTAG_TYPEDEF(call_info);
/**@ingroup sip_call_info
 * Tag for string with @ref sip_call_info "Call-Info header" value.
 */
tag_typedef_t siptag_call_info_str = SIPSTRTAG_TYPEDEF(call_info);

extern msg_hclass_t sip_organization_class[];

/**@ingroup sip_organization
 * Tag for @ref sip_organization "Organization header" object.
 */
tag_typedef_t siptag_organization = SIPHDRTAG_TYPEDEF(organization);
/**@ingroup sip_organization
 * Tag for string with @ref sip_organization "Organization header" value.
 */
tag_typedef_t siptag_organization_str = SIPSTRTAG_TYPEDEF(organization);

extern msg_hclass_t sip_server_class[];

/**@ingroup sip_server
 * Tag for @ref sip_server "Server header" object.
 */
tag_typedef_t siptag_server = SIPHDRTAG_TYPEDEF(server);
/**@ingroup sip_server
 * Tag for string with @ref sip_server "Server header" value.
 */
tag_typedef_t siptag_server_str = SIPSTRTAG_TYPEDEF(server);

extern msg_hclass_t sip_user_agent_class[];

/**@ingroup sip_user_agent
 * Tag for @ref sip_user_agent "User-Agent header" object.
 */
tag_typedef_t siptag_user_agent = SIPHDRTAG_TYPEDEF(user_agent);
/**@ingroup sip_user_agent
 * Tag for string with @ref sip_user_agent "User-Agent header" value.
 */
tag_typedef_t siptag_user_agent_str = SIPSTRTAG_TYPEDEF(user_agent);

extern msg_hclass_t sip_in_reply_to_class[];

/**@ingroup sip_in_reply_to
 * Tag for @ref sip_in_reply_to "In-Reply-To header" object.
 */
tag_typedef_t siptag_in_reply_to = SIPHDRTAG_TYPEDEF(in_reply_to);
/**@ingroup sip_in_reply_to
 * Tag for string with @ref sip_in_reply_to "In-Reply-To header" value.
 */
tag_typedef_t siptag_in_reply_to_str = SIPSTRTAG_TYPEDEF(in_reply_to);

extern msg_hclass_t sip_accept_class[];

/**@ingroup sip_accept
 * Tag for @ref sip_accept "Accept header" object.
 */
tag_typedef_t siptag_accept = SIPHDRTAG_TYPEDEF(accept);
/**@ingroup sip_accept
 * Tag for string with @ref sip_accept "Accept header" value.
 */
tag_typedef_t siptag_accept_str = SIPSTRTAG_TYPEDEF(accept);

extern msg_hclass_t sip_accept_encoding_class[];

/**@ingroup sip_accept_encoding
 * Tag for @ref sip_accept_encoding "Accept-Encoding header" object.
 */
tag_typedef_t siptag_accept_encoding = SIPHDRTAG_TYPEDEF(accept_encoding);
/**@ingroup sip_accept_encoding
 * Tag for string with @ref sip_accept_encoding "Accept-Encoding header" value.
 */
tag_typedef_t siptag_accept_encoding_str = SIPSTRTAG_TYPEDEF(accept_encoding);

extern msg_hclass_t sip_accept_language_class[];

/**@ingroup sip_accept_language
 * Tag for @ref sip_accept_language "Accept-Language header" object.
 */
tag_typedef_t siptag_accept_language = SIPHDRTAG_TYPEDEF(accept_language);
/**@ingroup sip_accept_language
 * Tag for string with @ref sip_accept_language "Accept-Language header" value.
 */
tag_typedef_t siptag_accept_language_str = SIPSTRTAG_TYPEDEF(accept_language);

extern msg_hclass_t sip_allow_class[];

/**@ingroup sip_allow
 * Tag for @ref sip_allow "Allow header" object.
 */
tag_typedef_t siptag_allow = SIPHDRTAG_TYPEDEF(allow);
/**@ingroup sip_allow
 * Tag for string with @ref sip_allow "Allow header" value.
 */
tag_typedef_t siptag_allow_str = SIPSTRTAG_TYPEDEF(allow);

extern msg_hclass_t sip_require_class[];

/**@ingroup sip_require
 * Tag for @ref sip_require "Require header" object.
 */
tag_typedef_t siptag_require = SIPHDRTAG_TYPEDEF(require);
/**@ingroup sip_require
 * Tag for string with @ref sip_require "Require header" value.
 */
tag_typedef_t siptag_require_str = SIPSTRTAG_TYPEDEF(require);

extern msg_hclass_t sip_supported_class[];

/**@ingroup sip_supported
 * Tag for @ref sip_supported "Supported header" object.
 */
tag_typedef_t siptag_supported = SIPHDRTAG_TYPEDEF(supported);
/**@ingroup sip_supported
 * Tag for string with @ref sip_supported "Supported header" value.
 */
tag_typedef_t siptag_supported_str = SIPSTRTAG_TYPEDEF(supported);

extern msg_hclass_t sip_unsupported_class[];

/**@ingroup sip_unsupported
 * Tag for @ref sip_unsupported "Unsupported header" object.
 */
tag_typedef_t siptag_unsupported = SIPHDRTAG_TYPEDEF(unsupported);
/**@ingroup sip_unsupported
 * Tag for string with @ref sip_unsupported "Unsupported header" value.
 */
tag_typedef_t siptag_unsupported_str = SIPSTRTAG_TYPEDEF(unsupported);

extern msg_hclass_t sip_event_class[];

/**@ingroup sip_event
 * Tag for @ref sip_event "Event header" object.
 */
tag_typedef_t siptag_event = SIPHDRTAG_TYPEDEF(event);
/**@ingroup sip_event
 * Tag for string with @ref sip_event "Event header" value.
 */
tag_typedef_t siptag_event_str = SIPSTRTAG_TYPEDEF(event);

extern msg_hclass_t sip_allow_events_class[];

/**@ingroup sip_allow_events
 * Tag for @ref sip_allow_events "Allow-Events header" object.
 */
tag_typedef_t siptag_allow_events = SIPHDRTAG_TYPEDEF(allow_events);
/**@ingroup sip_allow_events
 * Tag for string with @ref sip_allow_events "Allow-Events header" value.
 */
tag_typedef_t siptag_allow_events_str = SIPSTRTAG_TYPEDEF(allow_events);

extern msg_hclass_t sip_subscription_state_class[];

/**@ingroup sip_subscription_state
 * Tag for @ref sip_subscription_state "Subscription-State header" object.
 */
tag_typedef_t siptag_subscription_state = SIPHDRTAG_TYPEDEF(subscription_state);
/**@ingroup sip_subscription_state
 * Tag for string with @ref sip_subscription_state "Subscription-State header" value.
 */
tag_typedef_t siptag_subscription_state_str = SIPSTRTAG_TYPEDEF(subscription_state);

extern msg_hclass_t sip_proxy_authenticate_class[];

/**@ingroup sip_proxy_authenticate
 * Tag for @ref sip_proxy_authenticate "Proxy-Authenticate header" object.
 */
tag_typedef_t siptag_proxy_authenticate = SIPHDRTAG_TYPEDEF(proxy_authenticate);
/**@ingroup sip_proxy_authenticate
 * Tag for string with @ref sip_proxy_authenticate "Proxy-Authenticate header" value.
 */
tag_typedef_t siptag_proxy_authenticate_str = SIPSTRTAG_TYPEDEF(proxy_authenticate);

extern msg_hclass_t sip_proxy_authentication_info_class[];

/**@ingroup sip_proxy_authentication_info
 * Tag for @ref sip_proxy_authentication_info "Proxy-Authentication-Info header" object.
 */
tag_typedef_t siptag_proxy_authentication_info = SIPHDRTAG_TYPEDEF(proxy_authentication_info);
/**@ingroup sip_proxy_authentication_info
 * Tag for string with @ref sip_proxy_authentication_info "Proxy-Authentication-Info header" value.
 */
tag_typedef_t siptag_proxy_authentication_info_str = SIPSTRTAG_TYPEDEF(proxy_authentication_info);

extern msg_hclass_t sip_proxy_authorization_class[];

/**@ingroup sip_proxy_authorization
 * Tag for @ref sip_proxy_authorization "Proxy-Authorization header" object.
 */
tag_typedef_t siptag_proxy_authorization = SIPHDRTAG_TYPEDEF(proxy_authorization);
/**@ingroup sip_proxy_authorization
 * Tag for string with @ref sip_proxy_authorization "Proxy-Authorization header" value.
 */
tag_typedef_t siptag_proxy_authorization_str = SIPSTRTAG_TYPEDEF(proxy_authorization);

extern msg_hclass_t sip_authorization_class[];

/**@ingroup sip_authorization
 * Tag for @ref sip_authorization "Authorization header" object.
 */
tag_typedef_t siptag_authorization = SIPHDRTAG_TYPEDEF(authorization);
/**@ingroup sip_authorization
 * Tag for string with @ref sip_authorization "Authorization header" value.
 */
tag_typedef_t siptag_authorization_str = SIPSTRTAG_TYPEDEF(authorization);

extern msg_hclass_t sip_www_authenticate_class[];

/**@ingroup sip_www_authenticate
 * Tag for @ref sip_www_authenticate "WWW-Authenticate header" object.
 */
tag_typedef_t siptag_www_authenticate = SIPHDRTAG_TYPEDEF(www_authenticate);
/**@ingroup sip_www_authenticate
 * Tag for string with @ref sip_www_authenticate "WWW-Authenticate header" value.
 */
tag_typedef_t siptag_www_authenticate_str = SIPSTRTAG_TYPEDEF(www_authenticate);

extern msg_hclass_t sip_authentication_info_class[];

/**@ingroup sip_authentication_info
 * Tag for @ref sip_authentication_info "Authentication-Info header" object.
 */
tag_typedef_t siptag_authentication_info = SIPHDRTAG_TYPEDEF(authentication_info);
/**@ingroup sip_authentication_info
 * Tag for string with @ref sip_authentication_info "Authentication-Info header" value.
 */
tag_typedef_t siptag_authentication_info_str = SIPSTRTAG_TYPEDEF(authentication_info);

extern msg_hclass_t sip_error_info_class[];

/**@ingroup sip_error_info
 * Tag for @ref sip_error_info "Error-Info header" object.
 */
tag_typedef_t siptag_error_info = SIPHDRTAG_TYPEDEF(error_info);
/**@ingroup sip_error_info
 * Tag for string with @ref sip_error_info "Error-Info header" value.
 */
tag_typedef_t siptag_error_info_str = SIPSTRTAG_TYPEDEF(error_info);

extern msg_hclass_t sip_warning_class[];

/**@ingroup sip_warning
 * Tag for @ref sip_warning "Warning header" object.
 */
tag_typedef_t siptag_warning = SIPHDRTAG_TYPEDEF(warning);
/**@ingroup sip_warning
 * Tag for string with @ref sip_warning "Warning header" value.
 */
tag_typedef_t siptag_warning_str = SIPSTRTAG_TYPEDEF(warning);

extern msg_hclass_t sip_refer_to_class[];

/**@ingroup sip_refer_to
 * Tag for @ref sip_refer_to "Refer-To header" object.
 */
tag_typedef_t siptag_refer_to = SIPHDRTAG_TYPEDEF(refer_to);
/**@ingroup sip_refer_to
 * Tag for string with @ref sip_refer_to "Refer-To header" value.
 */
tag_typedef_t siptag_refer_to_str = SIPSTRTAG_TYPEDEF(refer_to);

extern msg_hclass_t sip_referred_by_class[];

/**@ingroup sip_referred_by
 * Tag for @ref sip_referred_by "Referred-By header" object.
 */
tag_typedef_t siptag_referred_by = SIPHDRTAG_TYPEDEF(referred_by);
/**@ingroup sip_referred_by
 * Tag for string with @ref sip_referred_by "Referred-By header" value.
 */
tag_typedef_t siptag_referred_by_str = SIPSTRTAG_TYPEDEF(referred_by);

extern msg_hclass_t sip_replaces_class[];

/**@ingroup sip_replaces
 * Tag for @ref sip_replaces "Replaces header" object.
 */
tag_typedef_t siptag_replaces = SIPHDRTAG_TYPEDEF(replaces);
/**@ingroup sip_replaces
 * Tag for string with @ref sip_replaces "Replaces header" value.
 */
tag_typedef_t siptag_replaces_str = SIPSTRTAG_TYPEDEF(replaces);

extern msg_hclass_t sip_session_expires_class[];

/**@ingroup sip_session_expires
 * Tag for @ref sip_session_expires "Session-Expires header" object.
 */
tag_typedef_t siptag_session_expires = SIPHDRTAG_TYPEDEF(session_expires);
/**@ingroup sip_session_expires
 * Tag for string with @ref sip_session_expires "Session-Expires header" value.
 */
tag_typedef_t siptag_session_expires_str = SIPSTRTAG_TYPEDEF(session_expires);

extern msg_hclass_t sip_min_se_class[];

/**@ingroup sip_min_se
 * Tag for @ref sip_min_se "Min-SE header" object.
 */
tag_typedef_t siptag_min_se = SIPHDRTAG_TYPEDEF(min_se);
/**@ingroup sip_min_se
 * Tag for string with @ref sip_min_se "Min-SE header" value.
 */
tag_typedef_t siptag_min_se_str = SIPSTRTAG_TYPEDEF(min_se);

extern msg_hclass_t sip_path_class[];

/**@ingroup sip_path
 * Tag for @ref sip_path "Path header" object.
 */
tag_typedef_t siptag_path = SIPHDRTAG_TYPEDEF(path);
/**@ingroup sip_path
 * Tag for string with @ref sip_path "Path header" value.
 */
tag_typedef_t siptag_path_str = SIPSTRTAG_TYPEDEF(path);

extern msg_hclass_t sip_service_route_class[];

/**@ingroup sip_service_route
 * Tag for @ref sip_service_route "Service-Route header" object.
 */
tag_typedef_t siptag_service_route = SIPHDRTAG_TYPEDEF(service_route);
/**@ingroup sip_service_route
 * Tag for string with @ref sip_service_route "Service-Route header" value.
 */
tag_typedef_t siptag_service_route_str = SIPSTRTAG_TYPEDEF(service_route);

extern msg_hclass_t sip_reason_class[];

/**@ingroup sip_reason
 * Tag for @ref sip_reason "Reason header" object.
 */
tag_typedef_t siptag_reason = SIPHDRTAG_TYPEDEF(reason);
/**@ingroup sip_reason
 * Tag for string with @ref sip_reason "Reason header" value.
 */
tag_typedef_t siptag_reason_str = SIPSTRTAG_TYPEDEF(reason);

extern msg_hclass_t sip_security_client_class[];

/**@ingroup sip_security_client
 * Tag for @ref sip_security_client "Security-Client header" object.
 */
tag_typedef_t siptag_security_client = SIPHDRTAG_TYPEDEF(security_client);
/**@ingroup sip_security_client
 * Tag for string with @ref sip_security_client "Security-Client header" value.
 */
tag_typedef_t siptag_security_client_str = SIPSTRTAG_TYPEDEF(security_client);

extern msg_hclass_t sip_security_server_class[];

/**@ingroup sip_security_server
 * Tag for @ref sip_security_server "Security-Server header" object.
 */
tag_typedef_t siptag_security_server = SIPHDRTAG_TYPEDEF(security_server);
/**@ingroup sip_security_server
 * Tag for string with @ref sip_security_server "Security-Server header" value.
 */
tag_typedef_t siptag_security_server_str = SIPSTRTAG_TYPEDEF(security_server);

extern msg_hclass_t sip_security_verify_class[];

/**@ingroup sip_security_verify
 * Tag for @ref sip_security_verify "Security-Verify header" object.
 */
tag_typedef_t siptag_security_verify = SIPHDRTAG_TYPEDEF(security_verify);
/**@ingroup sip_security_verify
 * Tag for string with @ref sip_security_verify "Security-Verify header" value.
 */
tag_typedef_t siptag_security_verify_str = SIPSTRTAG_TYPEDEF(security_verify);

extern msg_hclass_t sip_privacy_class[];

/**@ingroup sip_privacy
 * Tag for @ref sip_privacy "Privacy header" object.
 */
tag_typedef_t siptag_privacy = SIPHDRTAG_TYPEDEF(privacy);
/**@ingroup sip_privacy
 * Tag for string with @ref sip_privacy "Privacy header" value.
 */
tag_typedef_t siptag_privacy_str = SIPSTRTAG_TYPEDEF(privacy);

extern msg_hclass_t sip_etag_class[];

/**@ingroup sip_etag
 * Tag for @ref sip_etag "SIP-ETag header" object.
 */
tag_typedef_t siptag_etag = SIPHDRTAG_TYPEDEF(etag);
/**@ingroup sip_etag
 * Tag for string with @ref sip_etag "SIP-ETag header" value.
 */
tag_typedef_t siptag_etag_str = SIPSTRTAG_TYPEDEF(etag);

extern msg_hclass_t sip_if_match_class[];

/**@ingroup sip_if_match
 * Tag for @ref sip_if_match "SIP-If-Match header" object.
 */
tag_typedef_t siptag_if_match = SIPHDRTAG_TYPEDEF(if_match);
/**@ingroup sip_if_match
 * Tag for string with @ref sip_if_match "SIP-If-Match header" value.
 */
tag_typedef_t siptag_if_match_str = SIPSTRTAG_TYPEDEF(if_match);

extern msg_hclass_t sip_mime_version_class[];

/**@ingroup sip_mime_version
 * Tag for @ref sip_mime_version "MIME-Version header" object.
 */
tag_typedef_t siptag_mime_version = SIPHDRTAG_TYPEDEF(mime_version);
/**@ingroup sip_mime_version
 * Tag for string with @ref sip_mime_version "MIME-Version header" value.
 */
tag_typedef_t siptag_mime_version_str = SIPSTRTAG_TYPEDEF(mime_version);

extern msg_hclass_t sip_content_type_class[];

/**@ingroup sip_content_type
 * Tag for @ref sip_content_type "Content-Type header" object.
 */
tag_typedef_t siptag_content_type = SIPHDRTAG_TYPEDEF(content_type);
/**@ingroup sip_content_type
 * Tag for string with @ref sip_content_type "Content-Type header" value.
 */
tag_typedef_t siptag_content_type_str = SIPSTRTAG_TYPEDEF(content_type);

extern msg_hclass_t sip_content_encoding_class[];

/**@ingroup sip_content_encoding
 * Tag for @ref sip_content_encoding "Content-Encoding header" object.
 */
tag_typedef_t siptag_content_encoding = SIPHDRTAG_TYPEDEF(content_encoding);
/**@ingroup sip_content_encoding
 * Tag for string with @ref sip_content_encoding "Content-Encoding header" value.
 */
tag_typedef_t siptag_content_encoding_str = SIPSTRTAG_TYPEDEF(content_encoding);

extern msg_hclass_t sip_content_language_class[];

/**@ingroup sip_content_language
 * Tag for @ref sip_content_language "Content-Language header" object.
 */
tag_typedef_t siptag_content_language = SIPHDRTAG_TYPEDEF(content_language);
/**@ingroup sip_content_language
 * Tag for string with @ref sip_content_language "Content-Language header" value.
 */
tag_typedef_t siptag_content_language_str = SIPSTRTAG_TYPEDEF(content_language);

extern msg_hclass_t sip_content_disposition_class[];

/**@ingroup sip_content_disposition
 * Tag for @ref sip_content_disposition "Content-Disposition header" object.
 */
tag_typedef_t siptag_content_disposition = SIPHDRTAG_TYPEDEF(content_disposition);
/**@ingroup sip_content_disposition
 * Tag for string with @ref sip_content_disposition "Content-Disposition header" value.
 */
tag_typedef_t siptag_content_disposition_str = SIPSTRTAG_TYPEDEF(content_disposition);

extern msg_hclass_t sip_content_length_class[];

/**@ingroup sip_content_length
 * Tag for @ref sip_content_length "Content-Length header" object.
 */
tag_typedef_t siptag_content_length = SIPHDRTAG_TYPEDEF(content_length);
/**@ingroup sip_content_length
 * Tag for string with @ref sip_content_length "Content-Length header" value.
 */
tag_typedef_t siptag_content_length_str = SIPSTRTAG_TYPEDEF(content_length);

extern msg_hclass_t sip_refer_sub_class[];

/**@ingroup sip_refer_sub
 * Tag for @ref sip_refer_sub "Refer-Sub header" object.
 */
tag_typedef_t siptag_refer_sub = SIPHDRTAG_TYPEDEF(refer_sub);
/**@ingroup sip_refer_sub
 * Tag for string with @ref sip_refer_sub "Refer-Sub header" value.
 */
tag_typedef_t siptag_refer_sub_str = SIPSTRTAG_TYPEDEF(refer_sub);

extern msg_hclass_t sip_alert_info_class[];

/**@ingroup sip_alert_info
 * Tag for @ref sip_alert_info "Alert-Info header" object.
 */
tag_typedef_t siptag_alert_info = SIPHDRTAG_TYPEDEF(alert_info);
/**@ingroup sip_alert_info
 * Tag for string with @ref sip_alert_info "Alert-Info header" value.
 */
tag_typedef_t siptag_alert_info_str = SIPSTRTAG_TYPEDEF(alert_info);

extern msg_hclass_t sip_reply_to_class[];

/**@ingroup sip_reply_to
 * Tag for @ref sip_reply_to "Reply-To header" object.
 */
tag_typedef_t siptag_reply_to = SIPHDRTAG_TYPEDEF(reply_to);
/**@ingroup sip_reply_to
 * Tag for string with @ref sip_reply_to "Reply-To header" value.
 */
tag_typedef_t siptag_reply_to_str = SIPSTRTAG_TYPEDEF(reply_to);

extern msg_hclass_t sip_remote_party_id_class[];

/**@ingroup sip_remote_party_id
 * Tag for @ref sip_remote_party_id "Remote-Party-ID header" object.
 */
tag_typedef_t siptag_remote_party_id = SIPHDRTAG_TYPEDEF(remote_party_id);
/**@ingroup sip_remote_party_id
 * Tag for string with @ref sip_remote_party_id "Remote-Party-ID header" value.
 */
tag_typedef_t siptag_remote_party_id_str = SIPSTRTAG_TYPEDEF(remote_party_id);

extern msg_hclass_t sip_p_asserted_identity_class[];

/**@ingroup sip_p_asserted_identity
 * Tag for @ref sip_p_asserted_identity "P-Asserted-Identity header" object.
 */
tag_typedef_t siptag_p_asserted_identity = SIPHDRTAG_TYPEDEF(p_asserted_identity);
/**@ingroup sip_p_asserted_identity
 * Tag for string with @ref sip_p_asserted_identity "P-Asserted-Identity header" value.
 */
tag_typedef_t siptag_p_asserted_identity_str = SIPSTRTAG_TYPEDEF(p_asserted_identity);

extern msg_hclass_t sip_p_preferred_identity_class[];

/**@ingroup sip_p_preferred_identity
 * Tag for @ref sip_p_preferred_identity "P-Preferred-Identity header" object.
 */
tag_typedef_t siptag_p_preferred_identity = SIPHDRTAG_TYPEDEF(p_preferred_identity);
/**@ingroup sip_p_preferred_identity
 * Tag for string with @ref sip_p_preferred_identity "P-Preferred-Identity header" value.
 */
tag_typedef_t siptag_p_preferred_identity_str = SIPSTRTAG_TYPEDEF(p_preferred_identity);

#if SU_HAVE_EXPERIMENTAL
extern msg_hclass_t sip_suppress_body_if_match_class[];

/**@ingroup sip_suppress_body_if_match
 * Tag for @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" object.
 */
tag_typedef_t siptag_suppress_body_if_match = SIPHDRTAG_TYPEDEF(suppress_body_if_match);
/**@ingroup sip_suppress_body_if_match
 * Tag for string with @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" value.
 */
tag_typedef_t siptag_suppress_body_if_match_str = SIPSTRTAG_TYPEDEF(suppress_body_if_match);

#endif /* SU_HAVE_EXPERIMENTAL */
#if SU_HAVE_EXPERIMENTAL
extern msg_hclass_t sip_suppress_notify_if_match_class[];

/**@ingroup sip_suppress_notify_if_match
 * Tag for @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" object.
 */
tag_typedef_t siptag_suppress_notify_if_match = SIPHDRTAG_TYPEDEF(suppress_notify_if_match);
/**@ingroup sip_suppress_notify_if_match
 * Tag for string with @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" value.
 */
tag_typedef_t siptag_suppress_notify_if_match_str = SIPSTRTAG_TYPEDEF(suppress_notify_if_match);

#endif /* SU_HAVE_EXPERIMENTAL */
extern msg_hclass_t sip_unknown_class[];

/**@ingroup sip_unknown
 * Tag for @ref sip_unknown "unknown headers" object.
 */
tag_typedef_t siptag_unknown = SIPHDRTAG_TYPEDEF(unknown);
/**@ingroup sip_unknown
 * Tag for string with @ref sip_unknown "unknown headers" value.
 */
tag_typedef_t siptag_unknown_str = SIPSTRTAG_TYPEDEF(unknown);

extern msg_hclass_t sip_error_class[];

/**@ingroup sip_error
 * Tag for @ref sip_error "erroneous headers" object.
 */
tag_typedef_t siptag_error = SIPHDRTAG_TYPEDEF(error);
/**@ingroup sip_error
 * Tag for string with @ref sip_error "erroneous headers" value.
 */
tag_typedef_t siptag_error_str = SIPSTRTAG_TYPEDEF(error);

extern msg_hclass_t sip_separator_class[];

/**@ingroup sip_separator
 * Tag for @ref sip_separator "separator line between headers and body" object.
 */
tag_typedef_t siptag_separator = SIPHDRTAG_TYPEDEF(separator);
/**@ingroup sip_separator
 * Tag for string with @ref sip_separator "separator line between headers and body" value.
 */
tag_typedef_t siptag_separator_str = SIPSTRTAG_TYPEDEF(separator);

extern msg_hclass_t sip_payload_class[];

/**@ingroup sip_payload
 * Tag for @ref sip_payload "message payload" object.
 */
tag_typedef_t siptag_payload = SIPHDRTAG_TYPEDEF(payload);
/**@ingroup sip_payload
 * Tag for string with @ref sip_payload "message payload" value.
 */
tag_typedef_t siptag_payload_str = SIPSTRTAG_TYPEDEF(payload);

/** List of all tags for SIP headers */
tag_type_t sip_tag_list[] =
{
  siptag_request,
  siptag_status,
  siptag_via,
  siptag_route,
  siptag_record_route,
  siptag_max_forwards,
  siptag_proxy_require,
  siptag_from,
  siptag_to,
  siptag_call_id,
  siptag_cseq,
  siptag_identity,
  siptag_contact,
  siptag_rseq,
  siptag_rack,
  siptag_request_disposition,
  siptag_accept_contact,
  siptag_reject_contact,
  siptag_expires,
  siptag_date,
  siptag_retry_after,
  siptag_timestamp,
  siptag_min_expires,
  siptag_subject,
  siptag_priority,
  siptag_call_info,
  siptag_organization,
  siptag_server,
  siptag_user_agent,
  siptag_in_reply_to,
  siptag_accept,
  siptag_accept_encoding,
  siptag_accept_language,
  siptag_allow,
  siptag_require,
  siptag_supported,
  siptag_unsupported,
  siptag_event,
  siptag_allow_events,
  siptag_subscription_state,
  siptag_proxy_authenticate,
  siptag_proxy_authentication_info,
  siptag_proxy_authorization,
  siptag_authorization,
  siptag_www_authenticate,
  siptag_authentication_info,
  siptag_error_info,
  siptag_warning,
  siptag_refer_to,
  siptag_referred_by,
  siptag_replaces,
  siptag_session_expires,
  siptag_min_se,
  siptag_path,
  siptag_service_route,
  siptag_reason,
  siptag_security_client,
  siptag_security_server,
  siptag_security_verify,
  siptag_privacy,
  siptag_etag,
  siptag_if_match,
  siptag_mime_version,
  siptag_content_type,
  siptag_content_encoding,
  siptag_content_language,
  siptag_content_disposition,
  siptag_content_length,
  siptag_refer_sub,
  siptag_alert_info,
  siptag_reply_to,
  siptag_remote_party_id,
  siptag_p_asserted_identity,
  siptag_p_preferred_identity,
#if SU_HAVE_EXPERIMENTAL
  siptag_suppress_body_if_match,
  siptag_suppress_notify_if_match,
#endif /* SU_HAVE_EXPERIMENTAL */
  siptag_unknown,
  siptag_error,
  siptag_separator,
  siptag_payload,
  NULL
};

/** List of all string tags for SIP headers  */
tag_type_t sip_tag_str_list[] =
{
  siptag_request_str,
  siptag_status_str,
  siptag_via_str,
  siptag_route_str,
  siptag_record_route_str,
  siptag_max_forwards_str,
  siptag_proxy_require_str,
  siptag_from_str,
  siptag_to_str,
  siptag_call_id_str,
  siptag_cseq_str,
  siptag_identity_str,
  siptag_contact_str,
  siptag_rseq_str,
  siptag_rack_str,
  siptag_request_disposition_str,
  siptag_accept_contact_str,
  siptag_reject_contact_str,
  siptag_expires_str,
  siptag_date_str,
  siptag_retry_after_str,
  siptag_timestamp_str,
  siptag_min_expires_str,
  siptag_subject_str,
  siptag_priority_str,
  siptag_call_info_str,
  siptag_organization_str,
  siptag_server_str,
  siptag_user_agent_str,
  siptag_in_reply_to_str,
  siptag_accept_str,
  siptag_accept_encoding_str,
  siptag_accept_language_str,
  siptag_allow_str,
  siptag_require_str,
  siptag_supported_str,
  siptag_unsupported_str,
  siptag_event_str,
  siptag_allow_events_str,
  siptag_subscription_state_str,
  siptag_proxy_authenticate_str,
  siptag_proxy_authentication_info_str,
  siptag_proxy_authorization_str,
  siptag_authorization_str,
  siptag_www_authenticate_str,
  siptag_authentication_info_str,
  siptag_error_info_str,
  siptag_warning_str,
  siptag_refer_to_str,
  siptag_referred_by_str,
  siptag_replaces_str,
  siptag_session_expires_str,
  siptag_min_se_str,
  siptag_path_str,
  siptag_service_route_str,
  siptag_reason_str,
  siptag_security_client_str,
  siptag_security_server_str,
  siptag_security_verify_str,
  siptag_privacy_str,
  siptag_etag_str,
  siptag_if_match_str,
  siptag_mime_version_str,
  siptag_content_type_str,
  siptag_content_encoding_str,
  siptag_content_language_str,
  siptag_content_disposition_str,
  siptag_content_length_str,
  siptag_refer_sub_str,
  siptag_alert_info_str,
  siptag_reply_to_str,
  siptag_remote_party_id_str,
  siptag_p_asserted_identity_str,
  siptag_p_preferred_identity_str,
#if SU_HAVE_EXPERIMENTAL
  siptag_suppress_body_if_match_str,
  siptag_suppress_notify_if_match_str,
#endif /* SU_HAVE_EXPERIMENTAL */
  siptag_unknown_str,
  siptag_error_str,
  siptag_separator_str,
  siptag_payload_str,
  NULL
};

