/* Settings.c generated by valac 0.56.18, the Vala compiler
 * generated from Settings.vala, do not modify */

/*
* Copyright (c) 2011-2016 Felipe Escoto (https://github.com/Philip-Scott/Notes-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <granite.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SPICE_SERVICES_TYPE_SETTINGS (spice_services_settings_get_type ())
#define SPICE_SERVICES_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_TYPE_SETTINGS, SpiceServicesSettings))
#define SPICE_SERVICES_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_TYPE_SETTINGS, SpiceServicesSettingsClass))
#define SPICE_SERVICES_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_TYPE_SETTINGS))
#define SPICE_SERVICES_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_TYPE_SETTINGS))
#define SPICE_SERVICES_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_TYPE_SETTINGS, SpiceServicesSettingsClass))

typedef struct _SpiceServicesSettings SpiceServicesSettings;
typedef struct _SpiceServicesSettingsClass SpiceServicesSettingsClass;
typedef struct _SpiceServicesSettingsPrivate SpiceServicesSettingsPrivate;
enum  {
	SPICE_SERVICES_SETTINGS_0_PROPERTY,
	SPICE_SERVICES_SETTINGS_POS_X_PROPERTY,
	SPICE_SERVICES_SETTINGS_POS_Y_PROPERTY,
	SPICE_SERVICES_SETTINGS_WINDOW_WIDTH_PROPERTY,
	SPICE_SERVICES_SETTINGS_WINDOW_HEIGHT_PROPERTY,
	SPICE_SERVICES_SETTINGS_LAST_FETCH_PROPERTY,
	SPICE_SERVICES_SETTINGS_LAST_FILES_PROPERTY,
	SPICE_SERVICES_SETTINGS_CONTROLER_CONFIG_PROPERTY,
	SPICE_SERVICES_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* spice_services_settings_properties[SPICE_SERVICES_SETTINGS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _SpiceServicesSettings {
	GraniteServicesSettings parent_instance;
	SpiceServicesSettingsPrivate * priv;
};

struct _SpiceServicesSettingsClass {
	GraniteServicesSettingsClass parent_class;
};

struct _SpiceServicesSettingsPrivate {
	gint _pos_x;
	gint _pos_y;
	gint _window_width;
	gint _window_height;
	gchar* _last_fetch;
	gchar** _last_files;
	gint _last_files_length1;
	gint __last_files_size_;
	gchar* _controler_config;
};

static gint SpiceServicesSettings_private_offset;
static gpointer spice_services_settings_parent_class = NULL;
static SpiceServicesSettings* spice_services_settings_instance;
static SpiceServicesSettings* spice_services_settings_instance = NULL;

VALA_EXTERN GType spice_services_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesSettings, g_object_unref)
VALA_EXTERN SpiceServicesSettings* spice_services_settings_get_instance (void);
static SpiceServicesSettings* spice_services_settings_new (void);
static SpiceServicesSettings* spice_services_settings_construct (GType object_type);
VALA_EXTERN void spice_services_settings_add_file (SpiceServicesSettings* self,
                                       const gchar* file);
VALA_EXTERN gchar** spice_services_settings_get_last_files (SpiceServicesSettings* self,
                                                gint* result_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
VALA_EXTERN void spice_services_settings_set_last_files (SpiceServicesSettings* self,
                                             gchar** value,
                                             gint value_length1);
VALA_EXTERN gint spice_services_settings_get_pos_x (SpiceServicesSettings* self);
VALA_EXTERN void spice_services_settings_set_pos_x (SpiceServicesSettings* self,
                                        gint value);
VALA_EXTERN gint spice_services_settings_get_pos_y (SpiceServicesSettings* self);
VALA_EXTERN void spice_services_settings_set_pos_y (SpiceServicesSettings* self,
                                        gint value);
VALA_EXTERN gint spice_services_settings_get_window_width (SpiceServicesSettings* self);
VALA_EXTERN void spice_services_settings_set_window_width (SpiceServicesSettings* self,
                                               gint value);
VALA_EXTERN gint spice_services_settings_get_window_height (SpiceServicesSettings* self);
VALA_EXTERN void spice_services_settings_set_window_height (SpiceServicesSettings* self,
                                                gint value);
VALA_EXTERN const gchar* spice_services_settings_get_last_fetch (SpiceServicesSettings* self);
VALA_EXTERN void spice_services_settings_set_last_fetch (SpiceServicesSettings* self,
                                             const gchar* value);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
VALA_EXTERN const gchar* spice_services_settings_get_controler_config (SpiceServicesSettings* self);
VALA_EXTERN void spice_services_settings_set_controler_config (SpiceServicesSettings* self,
                                                   const gchar* value);
static void spice_services_settings_finalize (GObject * obj);
static GType spice_services_settings_get_type_once (void);
static void _vala_spice_services_settings_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_spice_services_settings_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
spice_services_settings_get_instance_private (SpiceServicesSettings* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceServicesSettings_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 38 "../Spice-up-1.9.1/src/Services/Settings.vala"
	return self ? g_object_ref (self) : NULL;
#line 167 "Settings.c"
}

SpiceServicesSettings*
spice_services_settings_get_instance (void)
{
	SpiceServicesSettings* _tmp0_;
	SpiceServicesSettings* _tmp2_;
	SpiceServicesSettings* _tmp3_;
	SpiceServicesSettings* result;
#line 34 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp0_ = spice_services_settings_instance;
#line 34 "../Spice-up-1.9.1/src/Services/Settings.vala"
	if (_tmp0_ == NULL) {
#line 181 "Settings.c"
		SpiceServicesSettings* _tmp1_;
#line 35 "../Spice-up-1.9.1/src/Services/Settings.vala"
		_tmp1_ = spice_services_settings_new ();
#line 35 "../Spice-up-1.9.1/src/Services/Settings.vala"
		_g_object_unref0 (spice_services_settings_instance);
#line 35 "../Spice-up-1.9.1/src/Services/Settings.vala"
		spice_services_settings_instance = _tmp1_;
#line 189 "Settings.c"
	}
#line 38 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp2_ = spice_services_settings_instance;
#line 38 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 38 "../Spice-up-1.9.1/src/Services/Settings.vala"
	result = _tmp3_;
#line 38 "../Spice-up-1.9.1/src/Services/Settings.vala"
	return result;
#line 199 "Settings.c"
}

static SpiceServicesSettings*
spice_services_settings_construct (GType object_type)
{
	SpiceServicesSettings * self = NULL;
#line 42 "../Spice-up-1.9.1/src/Services/Settings.vala"
	self = (SpiceServicesSettings*) granite_services_settings_construct (object_type, "com.github.philip_scott.spice-up");
#line 41 "../Spice-up-1.9.1/src/Services/Settings.vala"
	return self;
#line 210 "Settings.c"
}

static SpiceServicesSettings*
spice_services_settings_new (void)
{
#line 41 "../Spice-up-1.9.1/src/Services/Settings.vala"
	return spice_services_settings_construct (SPICE_SERVICES_TYPE_SETTINGS);
#line 218 "Settings.c"
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
#line 48 "../Spice-up-1.9.1/src/Services/Settings.vala"
	if (length >= 0) {
#line 227 "Settings.c"
		gchar** result;
		gssize i;
#line 48 "../Spice-up-1.9.1/src/Services/Settings.vala"
		result = g_new0 (gchar*, length + 1);
#line 48 "../Spice-up-1.9.1/src/Services/Settings.vala"
		for (i = 0; i < length; i++) {
#line 234 "Settings.c"
			gchar* _tmp0_;
#line 48 "../Spice-up-1.9.1/src/Services/Settings.vala"
			_tmp0_ = g_strdup (self[i]);
#line 48 "../Spice-up-1.9.1/src/Services/Settings.vala"
			result[i] = _tmp0_;
#line 240 "Settings.c"
		}
#line 48 "../Spice-up-1.9.1/src/Services/Settings.vala"
		return result;
#line 244 "Settings.c"
	}
#line 48 "../Spice-up-1.9.1/src/Services/Settings.vala"
	return NULL;
#line 248 "Settings.c"
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
#line 53 "../Spice-up-1.9.1/src/Services/Settings.vala"
	for (i = 0; i < stack_length; i++) {
#line 53 "../Spice-up-1.9.1/src/Services/Settings.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 53 "../Spice-up-1.9.1/src/Services/Settings.vala"
			return TRUE;
#line 263 "Settings.c"
		}
	}
#line 53 "../Spice-up-1.9.1/src/Services/Settings.vala"
	return FALSE;
#line 268 "Settings.c"
}

void
spice_services_settings_add_file (SpiceServicesSettings* self,
                                  const gchar* file)
{
	gchar** current_files = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint current_files_length1;
	gint _current_files_size_;
	GeeList* existing_files = NULL;
	GeeArrayList* _tmp4_;
	GeeList* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GeeList* _tmp9_;
	GeeList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GeeList* _tmp15_;
	gint _tmp16_ = 0;
	gpointer* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
#line 45 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_return_if_fail (self != NULL);
#line 45 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_return_if_fail (file != NULL);
#line 46 "../Spice-up-1.9.1/src/Services/Settings.vala"
	if (!granite_services_system_history_is_enabled ()) {
#line 46 "../Spice-up-1.9.1/src/Services/Settings.vala"
		return;
#line 309 "Settings.c"
	}
#line 48 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp0_ = spice_services_settings_get_last_files (self, &_tmp1_);
#line 48 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp0__length1 = _tmp1_;
#line 48 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp2_ = _tmp0_;
#line 48 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp2__length1 = _tmp0__length1;
#line 48 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup1 (_tmp2_, _tmp2__length1) : _tmp2_;
#line 48 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp3__length1 = _tmp2__length1;
#line 48 "../Spice-up-1.9.1/src/Services/Settings.vala"
	current_files = _tmp3_;
#line 48 "../Spice-up-1.9.1/src/Services/Settings.vala"
	current_files_length1 = _tmp3__length1;
#line 48 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_current_files_size_ = current_files_length1;
#line 50 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 50 "../Spice-up-1.9.1/src/Services/Settings.vala"
	existing_files = (GeeList*) _tmp4_;
#line 51 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp5_ = existing_files;
#line 51 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp6_ = current_files;
#line 51 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp6__length1 = current_files_length1;
#line 51 "../Spice-up-1.9.1/src/Services/Settings.vala"
	gee_collection_add_all_array ((GeeCollection*) _tmp5_, _tmp6_, (gint) _tmp6__length1);
#line 53 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp7_ = current_files;
#line 53 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp7__length1 = current_files_length1;
#line 53 "../Spice-up-1.9.1/src/Services/Settings.vala"
	if (_vala_string_array_contains (_tmp7_, _tmp7__length1, file)) {
#line 347 "Settings.c"
		GeeList* _tmp8_;
#line 54 "../Spice-up-1.9.1/src/Services/Settings.vala"
		_tmp8_ = existing_files;
#line 54 "../Spice-up-1.9.1/src/Services/Settings.vala"
		gee_collection_remove ((GeeCollection*) _tmp8_, file);
#line 353 "Settings.c"
	}
#line 57 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp9_ = existing_files;
#line 57 "../Spice-up-1.9.1/src/Services/Settings.vala"
	gee_list_insert (_tmp9_, 0, file);
#line 58 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp10_ = existing_files;
#line 58 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
#line 58 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp12_ = _tmp11_;
#line 58 "../Spice-up-1.9.1/src/Services/Settings.vala"
	if (_tmp12_ > 50) {
#line 367 "Settings.c"
		GeeList* _tmp13_;
		GeeList* _tmp14_;
#line 59 "../Spice-up-1.9.1/src/Services/Settings.vala"
		_tmp13_ = existing_files;
#line 59 "../Spice-up-1.9.1/src/Services/Settings.vala"
		_tmp14_ = gee_list_slice (_tmp13_, 0, 10);
#line 59 "../Spice-up-1.9.1/src/Services/Settings.vala"
		_g_object_unref0 (existing_files);
#line 59 "../Spice-up-1.9.1/src/Services/Settings.vala"
		existing_files = _tmp14_;
#line 378 "Settings.c"
	}
#line 62 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp15_ = existing_files;
#line 62 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp17_ = gee_collection_to_array ((GeeCollection*) _tmp15_, &_tmp16_);
#line 62 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp18_ = _tmp17_;
#line 62 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp18__length1 = _tmp16_;
#line 62 "../Spice-up-1.9.1/src/Services/Settings.vala"
	spice_services_settings_set_last_files (self, _tmp18_, _tmp16_);
#line 62 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
#line 45 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_g_object_unref0 (existing_files);
#line 45 "../Spice-up-1.9.1/src/Services/Settings.vala"
	current_files = (_vala_array_free (current_files, current_files_length1, (GDestroyNotify) g_free), NULL);
#line 396 "Settings.c"
}

gint
spice_services_settings_get_pos_x (SpiceServicesSettings* self)
{
	gint result;
#line 25 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 25 "../Spice-up-1.9.1/src/Services/Settings.vala"
	result = self->priv->_pos_x;
#line 25 "../Spice-up-1.9.1/src/Services/Settings.vala"
	return result;
#line 409 "Settings.c"
}

void
spice_services_settings_set_pos_x (SpiceServicesSettings* self,
                                   gint value)
{
	gint old_value;
#line 25 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_return_if_fail (self != NULL);
#line 25 "../Spice-up-1.9.1/src/Services/Settings.vala"
	old_value = spice_services_settings_get_pos_x (self);
#line 25 "../Spice-up-1.9.1/src/Services/Settings.vala"
	if (old_value != value) {
#line 25 "../Spice-up-1.9.1/src/Services/Settings.vala"
		self->priv->_pos_x = value;
#line 25 "../Spice-up-1.9.1/src/Services/Settings.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_services_settings_properties[SPICE_SERVICES_SETTINGS_POS_X_PROPERTY]);
#line 427 "Settings.c"
	}
}

gint
spice_services_settings_get_pos_y (SpiceServicesSettings* self)
{
	gint result;
#line 26 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 26 "../Spice-up-1.9.1/src/Services/Settings.vala"
	result = self->priv->_pos_y;
#line 26 "../Spice-up-1.9.1/src/Services/Settings.vala"
	return result;
#line 441 "Settings.c"
}

void
spice_services_settings_set_pos_y (SpiceServicesSettings* self,
                                   gint value)
{
	gint old_value;
#line 26 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_return_if_fail (self != NULL);
#line 26 "../Spice-up-1.9.1/src/Services/Settings.vala"
	old_value = spice_services_settings_get_pos_y (self);
#line 26 "../Spice-up-1.9.1/src/Services/Settings.vala"
	if (old_value != value) {
#line 26 "../Spice-up-1.9.1/src/Services/Settings.vala"
		self->priv->_pos_y = value;
#line 26 "../Spice-up-1.9.1/src/Services/Settings.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_services_settings_properties[SPICE_SERVICES_SETTINGS_POS_Y_PROPERTY]);
#line 459 "Settings.c"
	}
}

gint
spice_services_settings_get_window_width (SpiceServicesSettings* self)
{
	gint result;
#line 27 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 27 "../Spice-up-1.9.1/src/Services/Settings.vala"
	result = self->priv->_window_width;
#line 27 "../Spice-up-1.9.1/src/Services/Settings.vala"
	return result;
#line 473 "Settings.c"
}

void
spice_services_settings_set_window_width (SpiceServicesSettings* self,
                                          gint value)
{
	gint old_value;
#line 27 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_return_if_fail (self != NULL);
#line 27 "../Spice-up-1.9.1/src/Services/Settings.vala"
	old_value = spice_services_settings_get_window_width (self);
#line 27 "../Spice-up-1.9.1/src/Services/Settings.vala"
	if (old_value != value) {
#line 27 "../Spice-up-1.9.1/src/Services/Settings.vala"
		self->priv->_window_width = value;
#line 27 "../Spice-up-1.9.1/src/Services/Settings.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_services_settings_properties[SPICE_SERVICES_SETTINGS_WINDOW_WIDTH_PROPERTY]);
#line 491 "Settings.c"
	}
}

gint
spice_services_settings_get_window_height (SpiceServicesSettings* self)
{
	gint result;
#line 28 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 28 "../Spice-up-1.9.1/src/Services/Settings.vala"
	result = self->priv->_window_height;
#line 28 "../Spice-up-1.9.1/src/Services/Settings.vala"
	return result;
#line 505 "Settings.c"
}

void
spice_services_settings_set_window_height (SpiceServicesSettings* self,
                                           gint value)
{
	gint old_value;
#line 28 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_return_if_fail (self != NULL);
#line 28 "../Spice-up-1.9.1/src/Services/Settings.vala"
	old_value = spice_services_settings_get_window_height (self);
#line 28 "../Spice-up-1.9.1/src/Services/Settings.vala"
	if (old_value != value) {
#line 28 "../Spice-up-1.9.1/src/Services/Settings.vala"
		self->priv->_window_height = value;
#line 28 "../Spice-up-1.9.1/src/Services/Settings.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_services_settings_properties[SPICE_SERVICES_SETTINGS_WINDOW_HEIGHT_PROPERTY]);
#line 523 "Settings.c"
	}
}

const gchar*
spice_services_settings_get_last_fetch (SpiceServicesSettings* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 29 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 29 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp0_ = self->priv->_last_fetch;
#line 29 "../Spice-up-1.9.1/src/Services/Settings.vala"
	result = _tmp0_;
#line 29 "../Spice-up-1.9.1/src/Services/Settings.vala"
	return result;
#line 540 "Settings.c"
}

void
spice_services_settings_set_last_fetch (SpiceServicesSettings* self,
                                        const gchar* value)
{
	gchar* old_value;
#line 29 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_return_if_fail (self != NULL);
#line 29 "../Spice-up-1.9.1/src/Services/Settings.vala"
	old_value = spice_services_settings_get_last_fetch (self);
#line 29 "../Spice-up-1.9.1/src/Services/Settings.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 554 "Settings.c"
		gchar* _tmp0_;
#line 29 "../Spice-up-1.9.1/src/Services/Settings.vala"
		_tmp0_ = g_strdup (value);
#line 29 "../Spice-up-1.9.1/src/Services/Settings.vala"
		_g_free0 (self->priv->_last_fetch);
#line 29 "../Spice-up-1.9.1/src/Services/Settings.vala"
		self->priv->_last_fetch = _tmp0_;
#line 29 "../Spice-up-1.9.1/src/Services/Settings.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_services_settings_properties[SPICE_SERVICES_SETTINGS_LAST_FETCH_PROPERTY]);
#line 564 "Settings.c"
	}
}

gchar**
spice_services_settings_get_last_files (SpiceServicesSettings* self,
                                        gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp0_ = self->priv->_last_files;
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp0__length1 = self->priv->_last_files_length1;
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp1_ = _tmp0_;
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp1__length1 = _tmp0__length1;
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
	if (result_length1) {
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
		*result_length1 = _tmp1__length1;
#line 591 "Settings.c"
	}
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
	result = _tmp1_;
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
	return result;
#line 597 "Settings.c"
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
	if (length >= 0) {
#line 606 "Settings.c"
		gchar** result;
		gssize i;
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
		result = g_new0 (gchar*, length + 1);
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
		for (i = 0; i < length; i++) {
#line 613 "Settings.c"
			gchar* _tmp0_;
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
			_tmp0_ = g_strdup (self[i]);
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
			result[i] = _tmp0_;
#line 619 "Settings.c"
		}
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
		return result;
#line 623 "Settings.c"
	}
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
	return NULL;
#line 627 "Settings.c"
}

void
spice_services_settings_set_last_files (SpiceServicesSettings* self,
                                        gchar** value,
                                        gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_return_if_fail (self != NULL);
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
	old_value = spice_services_settings_get_last_files (self, &old_value_length);
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
	if (old_value != value) {
#line 643 "Settings.c"
		gchar** _tmp0_;
		gint _tmp0__length1;
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
		_tmp0_ = (value != NULL) ? _vala_array_dup2 (value, value_length1) : value;
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
		_tmp0__length1 = value_length1;
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
		self->priv->_last_files = (_vala_array_free (self->priv->_last_files, self->priv->_last_files_length1, (GDestroyNotify) g_free), NULL);
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
		self->priv->_last_files = _tmp0_;
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
		self->priv->_last_files_length1 = _tmp0__length1;
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
		self->priv->__last_files_size_ = self->priv->_last_files_length1;
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_services_settings_properties[SPICE_SERVICES_SETTINGS_LAST_FILES_PROPERTY]);
#line 660 "Settings.c"
	}
}

const gchar*
spice_services_settings_get_controler_config (SpiceServicesSettings* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 31 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 31 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_tmp0_ = self->priv->_controler_config;
#line 31 "../Spice-up-1.9.1/src/Services/Settings.vala"
	result = _tmp0_;
#line 31 "../Spice-up-1.9.1/src/Services/Settings.vala"
	return result;
#line 677 "Settings.c"
}

void
spice_services_settings_set_controler_config (SpiceServicesSettings* self,
                                              const gchar* value)
{
	gchar* old_value;
#line 31 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_return_if_fail (self != NULL);
#line 31 "../Spice-up-1.9.1/src/Services/Settings.vala"
	old_value = spice_services_settings_get_controler_config (self);
#line 31 "../Spice-up-1.9.1/src/Services/Settings.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 691 "Settings.c"
		gchar* _tmp0_;
#line 31 "../Spice-up-1.9.1/src/Services/Settings.vala"
		_tmp0_ = g_strdup (value);
#line 31 "../Spice-up-1.9.1/src/Services/Settings.vala"
		_g_free0 (self->priv->_controler_config);
#line 31 "../Spice-up-1.9.1/src/Services/Settings.vala"
		self->priv->_controler_config = _tmp0_;
#line 31 "../Spice-up-1.9.1/src/Services/Settings.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_services_settings_properties[SPICE_SERVICES_SETTINGS_CONTROLER_CONFIG_PROPERTY]);
#line 701 "Settings.c"
	}
}

static void
spice_services_settings_class_init (SpiceServicesSettingsClass * klass,
                                    gpointer klass_data)
{
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
	spice_services_settings_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_type_class_adjust_private_offset (klass, &SpiceServicesSettings_private_offset);
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_services_settings_get_property;
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_services_settings_set_property;
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_services_settings_finalize;
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SERVICES_SETTINGS_POS_X_PROPERTY, spice_services_settings_properties[SPICE_SERVICES_SETTINGS_POS_X_PROPERTY] = g_param_spec_int ("pos-x", "pos-x", "pos-x", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SERVICES_SETTINGS_POS_Y_PROPERTY, spice_services_settings_properties[SPICE_SERVICES_SETTINGS_POS_Y_PROPERTY] = g_param_spec_int ("pos-y", "pos-y", "pos-y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SERVICES_SETTINGS_WINDOW_WIDTH_PROPERTY, spice_services_settings_properties[SPICE_SERVICES_SETTINGS_WINDOW_WIDTH_PROPERTY] = g_param_spec_int ("window-width", "window-width", "window-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SERVICES_SETTINGS_WINDOW_HEIGHT_PROPERTY, spice_services_settings_properties[SPICE_SERVICES_SETTINGS_WINDOW_HEIGHT_PROPERTY] = g_param_spec_int ("window-height", "window-height", "window-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SERVICES_SETTINGS_LAST_FETCH_PROPERTY, spice_services_settings_properties[SPICE_SERVICES_SETTINGS_LAST_FETCH_PROPERTY] = g_param_spec_string ("last-fetch", "last-fetch", "last-fetch", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SERVICES_SETTINGS_LAST_FILES_PROPERTY, spice_services_settings_properties[SPICE_SERVICES_SETTINGS_LAST_FILES_PROPERTY] = g_param_spec_boxed ("last-files", "last-files", "last-files", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SERVICES_SETTINGS_CONTROLER_CONFIG_PROPERTY, spice_services_settings_properties[SPICE_SERVICES_SETTINGS_CONTROLER_CONFIG_PROPERTY] = g_param_spec_string ("controler-config", "controler-config", "controler-config", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 733 "Settings.c"
}

static void
spice_services_settings_instance_init (SpiceServicesSettings * self,
                                       gpointer klass)
{
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
	self->priv = spice_services_settings_get_instance_private (self);
#line 742 "Settings.c"
}

static void
spice_services_settings_finalize (GObject * obj)
{
	SpiceServicesSettings * self;
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_SERVICES_TYPE_SETTINGS, SpiceServicesSettings);
#line 29 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_g_free0 (self->priv->_last_fetch);
#line 30 "../Spice-up-1.9.1/src/Services/Settings.vala"
	self->priv->_last_files = (_vala_array_free (self->priv->_last_files, self->priv->_last_files_length1, (GDestroyNotify) g_free), NULL);
#line 31 "../Spice-up-1.9.1/src/Services/Settings.vala"
	_g_free0 (self->priv->_controler_config);
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
	G_OBJECT_CLASS (spice_services_settings_parent_class)->finalize (obj);
#line 759 "Settings.c"
}

static GType
spice_services_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceServicesSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_services_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceServicesSettings), 0, (GInstanceInitFunc) spice_services_settings_instance_init, NULL };
	GType spice_services_settings_type_id;
	spice_services_settings_type_id = g_type_register_static (GRANITE_SERVICES_TYPE_SETTINGS, "SpiceServicesSettings", &g_define_type_info, 0);
	SpiceServicesSettings_private_offset = g_type_add_instance_private (spice_services_settings_type_id, sizeof (SpiceServicesSettingsPrivate));
	return spice_services_settings_type_id;
}

GType
spice_services_settings_get_type (void)
{
	static volatile gsize spice_services_settings_type_id__once = 0;
	if (g_once_init_enter (&spice_services_settings_type_id__once)) {
		GType spice_services_settings_type_id;
		spice_services_settings_type_id = spice_services_settings_get_type_once ();
		g_once_init_leave (&spice_services_settings_type_id__once, spice_services_settings_type_id);
	}
	return spice_services_settings_type_id__once;
}

static void
_vala_spice_services_settings_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	SpiceServicesSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_SERVICES_TYPE_SETTINGS, SpiceServicesSettings);
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		case SPICE_SERVICES_SETTINGS_POS_X_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		g_value_set_int (value, spice_services_settings_get_pos_x (self));
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		case SPICE_SERVICES_SETTINGS_POS_Y_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		g_value_set_int (value, spice_services_settings_get_pos_y (self));
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		case SPICE_SERVICES_SETTINGS_WINDOW_WIDTH_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		g_value_set_int (value, spice_services_settings_get_window_width (self));
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		case SPICE_SERVICES_SETTINGS_WINDOW_HEIGHT_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		g_value_set_int (value, spice_services_settings_get_window_height (self));
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		case SPICE_SERVICES_SETTINGS_LAST_FETCH_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		g_value_set_string (value, spice_services_settings_get_last_fetch (self));
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		case SPICE_SERVICES_SETTINGS_LAST_FILES_PROPERTY:
#line 826 "Settings.c"
		{
			int length;
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
			g_value_set_boxed (value, spice_services_settings_get_last_files (self, &length));
#line 831 "Settings.c"
		}
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		case SPICE_SERVICES_SETTINGS_CONTROLER_CONFIG_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		g_value_set_string (value, spice_services_settings_get_controler_config (self));
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		break;
#line 841 "Settings.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		break;
#line 847 "Settings.c"
	}
}

static void
_vala_spice_services_settings_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	SpiceServicesSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_SERVICES_TYPE_SETTINGS, SpiceServicesSettings);
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		case SPICE_SERVICES_SETTINGS_POS_X_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		spice_services_settings_set_pos_x (self, g_value_get_int (value));
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		case SPICE_SERVICES_SETTINGS_POS_Y_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		spice_services_settings_set_pos_y (self, g_value_get_int (value));
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		case SPICE_SERVICES_SETTINGS_WINDOW_WIDTH_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		spice_services_settings_set_window_width (self, g_value_get_int (value));
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		case SPICE_SERVICES_SETTINGS_WINDOW_HEIGHT_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		spice_services_settings_set_window_height (self, g_value_get_int (value));
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		case SPICE_SERVICES_SETTINGS_LAST_FETCH_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		spice_services_settings_set_last_fetch (self, g_value_get_string (value));
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		case SPICE_SERVICES_SETTINGS_LAST_FILES_PROPERTY:
#line 893 "Settings.c"
		{
			gpointer boxed;
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
			boxed = g_value_get_boxed (value);
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
			spice_services_settings_set_last_files (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
#line 900 "Settings.c"
		}
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		case SPICE_SERVICES_SETTINGS_CONTROLER_CONFIG_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		spice_services_settings_set_controler_config (self, g_value_get_string (value));
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		break;
#line 910 "Settings.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Services/Settings.vala"
		break;
#line 916 "Settings.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

