/* SlideManager.c generated by valac 0.56.18, the Vala compiler
 * generated from SlideManager.vala, do not modify */

/*
* Copyright (c) 2016 Felipe Escoto (https://github.com/Philip-Scott/Spice-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SPICE_TYPE_SLIDE_MANAGER (spice_slide_manager_get_type ())
#define SPICE_SLIDE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManager))
#define SPICE_SLIDE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManagerClass))
#define SPICE_IS_SLIDE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_SLIDE_MANAGER))
#define SPICE_IS_SLIDE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_SLIDE_MANAGER))
#define SPICE_SLIDE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManagerClass))

typedef struct _SpiceSlideManager SpiceSlideManager;
typedef struct _SpiceSlideManagerClass SpiceSlideManagerClass;
typedef struct _SpiceSlideManagerPrivate SpiceSlideManagerPrivate;

#define SPICE_TYPE_SLIDE (spice_slide_get_type ())
#define SPICE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_SLIDE, SpiceSlide))
#define SPICE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_SLIDE, SpiceSlideClass))
#define SPICE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_SLIDE))
#define SPICE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_SLIDE))
#define SPICE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_SLIDE, SpiceSlideClass))

typedef struct _SpiceSlide SpiceSlide;
typedef struct _SpiceSlideClass SpiceSlideClass;

#define SPICE_TYPE_WINDOW (spice_window_get_type ())
#define SPICE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_WINDOW, SpiceWindow))
#define SPICE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_WINDOW, SpiceWindowClass))
#define SPICE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_WINDOW))
#define SPICE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_WINDOW))
#define SPICE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_WINDOW, SpiceWindowClass))

typedef struct _SpiceWindow SpiceWindow;
typedef struct _SpiceWindowClass SpiceWindowClass;

#define SPICE_TYPE_CANVAS_ITEM (spice_canvas_item_get_type ())
#define SPICE_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem))
#define SPICE_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))
#define SPICE_IS_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_IS_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_CANVAS_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))

typedef struct _SpiceCanvasItem SpiceCanvasItem;
typedef struct _SpiceCanvasItemClass SpiceCanvasItemClass;
typedef enum  {
	SPICE_ASPECT_RATIO_ASPECT_4_3 = 1,
	SPICE_ASPECT_RATIO_ASPECT_16_9 = 2,
	SPICE_ASPECT_RATIO_ASPECT_16_10 = 3,
	SPICE_ASPECT_RATIO_ASPECT_3_2 = 4,
	SPICE_ASPECT_RATIO_ASPECT_5_4 = 5
} SpiceAspectRatio;

#define SPICE_TYPE_ASPECT_RATIO (spice_aspect_ratio_get_type ())
enum  {
	SPICE_SLIDE_MANAGER_0_PROPERTY,
	SPICE_SLIDE_MANAGER_WINDOW_PROPERTY,
	SPICE_SLIDE_MANAGER_SLIDESHOW_PROPERTY,
	SPICE_SLIDE_MANAGER_SLIDES_PROPERTY,
	SPICE_SLIDE_MANAGER_CURRENT_ITEM_PROPERTY,
	SPICE_SLIDE_MANAGER_PREVIEW_SLIDE_PROPERTY,
	SPICE_SLIDE_MANAGER_CURRENT_SLIDE_PROPERTY,
	SPICE_SLIDE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* spice_slide_manager_properties[SPICE_SLIDE_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SpiceSlidePrivate SpiceSlidePrivate;

#define SPICE_TYPE_CANVAS (spice_canvas_get_type ())
#define SPICE_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS, SpiceCanvas))
#define SPICE_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS, SpiceCanvasClass))
#define SPICE_IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS))
#define SPICE_IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS))
#define SPICE_CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS, SpiceCanvasClass))

typedef struct _SpiceCanvas SpiceCanvas;
typedef struct _SpiceCanvasClass SpiceCanvasClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;

#define SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION (spice_services_history_manager_history_action_get_type ())
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryAction))
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryActionClass))
#define SPICE_SERVICES_HISTORY_MANAGER_IS_HISTORY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION))
#define SPICE_SERVICES_HISTORY_MANAGER_IS_HISTORY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION))
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryActionClass))

typedef struct _SpiceServicesHistoryManagerHistoryAction SpiceServicesHistoryManagerHistoryAction;
typedef struct _SpiceServicesHistoryManagerHistoryActionClass SpiceServicesHistoryManagerHistoryActionClass;

#define SPICE_SERVICES_TYPE_HISTORY_MANAGER (spice_services_history_manager_get_type ())
#define SPICE_SERVICES_HISTORY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManager))
#define SPICE_SERVICES_HISTORY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManagerClass))
#define SPICE_SERVICES_IS_HISTORY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER))
#define SPICE_SERVICES_IS_HISTORY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_TYPE_HISTORY_MANAGER))
#define SPICE_SERVICES_HISTORY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManagerClass))

typedef struct _SpiceServicesHistoryManager SpiceServicesHistoryManager;
typedef struct _SpiceServicesHistoryManagerClass SpiceServicesHistoryManagerClass;
typedef enum  {
	SPICE_CANVAS_ITEM_TYPE_TEXT,
	SPICE_CANVAS_ITEM_TYPE_IMAGE,
	SPICE_CANVAS_ITEM_TYPE_SHAPE
} SpiceCanvasItemType;

#define SPICE_TYPE_CANVAS_ITEM_TYPE (spice_canvas_item_type_get_type ())

#define SPICE_TYPE_TEXT_ITEM (spice_text_item_get_type ())
#define SPICE_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_TEXT_ITEM, SpiceTextItem))
#define SPICE_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_TEXT_ITEM, SpiceTextItemClass))
#define SPICE_IS_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_TEXT_ITEM))
#define SPICE_IS_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_TEXT_ITEM))
#define SPICE_TEXT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_TEXT_ITEM, SpiceTextItemClass))

typedef struct _SpiceTextItem SpiceTextItem;
typedef struct _SpiceTextItemClass SpiceTextItemClass;

#define SPICE_TYPE_IMAGE_ITEM (spice_image_item_get_type ())
#define SPICE_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_IMAGE_ITEM, SpiceImageItem))
#define SPICE_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_IMAGE_ITEM, SpiceImageItemClass))
#define SPICE_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_IMAGE_ITEM))
#define SPICE_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_IMAGE_ITEM))
#define SPICE_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_IMAGE_ITEM, SpiceImageItemClass))

typedef struct _SpiceImageItem SpiceImageItem;
typedef struct _SpiceImageItemClass SpiceImageItemClass;

#define SPICE_TYPE_COLOR_ITEM (spice_color_item_get_type ())
#define SPICE_COLOR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_COLOR_ITEM, SpiceColorItem))
#define SPICE_COLOR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_COLOR_ITEM, SpiceColorItemClass))
#define SPICE_IS_COLOR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_COLOR_ITEM))
#define SPICE_IS_COLOR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_COLOR_ITEM))
#define SPICE_COLOR_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_COLOR_ITEM, SpiceColorItemClass))

typedef struct _SpiceColorItem SpiceColorItem;
typedef struct _SpiceColorItemClass SpiceColorItemClass;
enum  {
	SPICE_SLIDE_MANAGER_ASPECT_RATIO_CHANGED_SIGNAL,
	SPICE_SLIDE_MANAGER_RESETED_SIGNAL,
	SPICE_SLIDE_MANAGER_CURRENT_SLIDE_CHANGED_SIGNAL,
	SPICE_SLIDE_MANAGER_ITEM_CLICKED_SIGNAL,
	SPICE_SLIDE_MANAGER_NEW_SLIDE_CREATED_SIGNAL,
	SPICE_SLIDE_MANAGER_SLIDES_SORTED_SIGNAL,
	SPICE_SLIDE_MANAGER_NUM_SIGNALS
};
static guint spice_slide_manager_signals[SPICE_SLIDE_MANAGER_NUM_SIGNALS] = {0};

struct _SpiceSlideManager {
	GObject parent_instance;
	SpiceSlideManagerPrivate * priv;
	gboolean making_new_slide;
	SpiceSlide* end_presentation_slide;
	SpiceSlide* preview_slide_;
	SpiceSlide* checkpoint;
};

struct _SpiceSlideManagerClass {
	GObjectClass parent_class;
};

struct _SpiceSlideManagerPrivate {
	SpiceWindow* _window;
	GtkStack* _slideshow;
	GeeArrayList* _slides;
	SpiceSlide* slide_;
	SpiceCanvasItem* current_item_;
	SpiceAspectRatio current_ratio;
	gboolean propagating_ratio;
};

struct _SpiceSlide {
	GObject parent_instance;
	SpiceSlidePrivate * priv;
	JsonObject* save_data;
	SpiceCanvas* canvas;
	GtkImage* preview;
};

struct _SpiceSlideClass {
	GObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	SpiceSlideManager* self;
	SpiceSlide* slide;
};

static gint SpiceSlideManager_private_offset;
static gpointer spice_slide_manager_parent_class = NULL;
VALA_EXTERN gint spice_slide_manager_aspect_ratio_override;
gint spice_slide_manager_aspect_ratio_override = -1;
VALA_EXTERN guint spice_image_handler_FILE_ID;

VALA_EXTERN GType spice_slide_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceSlideManager, g_object_unref)
VALA_EXTERN GType spice_slide_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceSlide, g_object_unref)
VALA_EXTERN GType spice_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceWindow, g_object_unref)
VALA_EXTERN GType spice_canvas_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvasItem, g_object_unref)
VALA_EXTERN GType spice_aspect_ratio_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SpiceSlideManager* spice_slide_manager_new (SpiceWindow* window);
VALA_EXTERN SpiceSlideManager* spice_slide_manager_construct (GType object_type,
                                                  SpiceWindow* window);
static void spice_slide_manager_set_slides (SpiceSlideManager* self,
                                     GeeArrayList* value);
static void spice_slide_manager_set_slideshow (SpiceSlideManager* self,
                                        GtkStack* value);
VALA_EXTERN GtkStack* spice_slide_manager_get_slideshow (SpiceSlideManager* self);
VALA_EXTERN SpiceSlide* spice_slide_new_empty (SpiceWindow* window);
VALA_EXTERN SpiceSlide* spice_slide_construct_empty (GType object_type,
                                         SpiceWindow* window);
VALA_EXTERN GType spice_canvas_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvas, g_object_unref)
VALA_EXTERN void spice_slide_manager_next_slide (SpiceSlideManager* self);
static void _spice_slide_manager_next_slide_spice_canvas_next_slide (SpiceCanvas* _sender,
                                                              gpointer self);
VALA_EXTERN void spice_slide_manager_previous_slide (SpiceSlideManager* self);
static void _spice_slide_manager_previous_slide_spice_canvas_previous_slide (SpiceCanvas* _sender,
                                                                      gpointer self);
VALA_EXTERN void spice_slide_manager_reset (SpiceSlideManager* self);
VALA_EXTERN GeeArrayList* spice_slide_manager_get_slides (SpiceSlideManager* self);
VALA_EXTERN void spice_slide_destroy (SpiceSlide* self);
VALA_EXTERN guint spice_slide_manager_slide_count (SpiceSlideManager* self);
VALA_EXTERN gboolean spice_slide_get_visible (SpiceSlide* self);
VALA_EXTERN gchar* spice_slide_manager_serialise (SpiceSlideManager* self);
VALA_EXTERN gchar* spice_slide_serialise (SpiceSlide* self);
VALA_EXTERN SpiceSlide* spice_slide_manager_get_current_slide (SpiceSlideManager* self);
VALA_EXTERN SpiceSlide* spice_slide_manager_get_preview_slide (SpiceSlideManager* self);
VALA_EXTERN void spice_slide_manager_load_data (SpiceSlideManager* self,
                                    const gchar* data);
VALA_EXTERN SpiceAspectRatio spice_aspect_ratio_get_mode (gint* value);
VALA_EXTERN SpiceSlide* spice_slide_manager_new_slide (SpiceSlideManager* self,
                                           JsonObject* save_data,
                                           gboolean undoable_action);
VALA_EXTERN void spice_slide_manager_set_current_slide (SpiceSlideManager* self,
                                            SpiceSlide* value);
VALA_EXTERN void spice_slide_reload_preview_data (SpiceSlide* self);
VALA_EXTERN void spice_slide_manager_set_preview_slide (SpiceSlideManager* self,
                                            SpiceSlide* value);
VALA_EXTERN void spice_slide_manager_move_down (SpiceSlideManager* self,
                                    SpiceSlide* slide);
VALA_EXTERN SpiceSlide* spice_slide_manager_get_next_slide (SpiceSlideManager* self,
                                                SpiceSlide* current);
VALA_EXTERN void spice_slide_manager_move_up (SpiceSlideManager* self,
                                  SpiceSlide* slide);
static SpiceSlide* spice_slide_manager_get_previous_slide (SpiceSlideManager* self,
                                                    SpiceSlide* current);
VALA_EXTERN SpiceWindow* spice_slide_manager_get_window (SpiceSlideManager* self);
VALA_EXTERN void spice_window_set_is_presenting (SpiceWindow* self,
                                     gboolean value);
VALA_EXTERN gboolean spice_window_get_is_presenting (SpiceWindow* self);
VALA_EXTERN gint spice_slide_manager_get_slide_ammount (SpiceSlideManager* self);
VALA_EXTERN gint spice_slide_manager_get_slide_pos (SpiceSlideManager* self,
                                        SpiceSlide* current);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN SpiceSlide* spice_slide_new (SpiceWindow* window,
                             JsonObject* save_data);
VALA_EXTERN SpiceSlide* spice_slide_construct (GType object_type,
                                   SpiceWindow* window,
                                   JsonObject* save_data);
static void __lambda23_ (SpiceSlideManager* self,
                  SpiceCanvasItem* item);
VALA_EXTERN void spice_slide_manager_set_current_item (SpiceSlideManager* self,
                                           SpiceCanvasItem* value);
static void ___lambda23__spice_canvas_item_clicked (SpiceCanvas* _sender,
                                             SpiceCanvasItem* item,
                                             gpointer self);
static void __lambda24_ (SpiceSlideManager* self);
static void ___lambda24__spice_canvas_next_slide (SpiceCanvas* _sender,
                                           gpointer self);
static void __lambda25_ (SpiceSlideManager* self);
static void ___lambda25__spice_canvas_previous_slide (SpiceCanvas* _sender,
                                               gpointer self);
static void __lambda26_ (Block2Data* _data2_,
                  gdouble new_ratio);
VALA_EXTERN void spice_canvas_set_current_ratio (SpiceCanvas* self,
                                     gdouble value);
static void ___lambda26__spice_canvas_ratio_changed (SpiceCanvas* _sender,
                                              gdouble ratio,
                                              gpointer self);
VALA_EXTERN void spice_slide_set_visible (SpiceSlide* self,
                              gboolean value);
VALA_EXTERN GType spice_services_history_manager_history_action_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesHistoryManagerHistoryAction, g_object_unref)
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_new_slide_changed (GType i_type,
                                                                                                           GBoxedCopyFunc i_dup_func,
                                                                                                           GDestroyNotify i_destroy_func,
                                                                                                           GType t_type,
                                                                                                           GBoxedCopyFunc t_dup_func,
                                                                                                           GDestroyNotify t_destroy_func,
                                                                                                           gconstpointer item,
                                                                                                           const gchar* property);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_construct_slide_changed (GType object_type,
                                                                                                                 GType i_type,
                                                                                                                 GBoxedCopyFunc i_dup_func,
                                                                                                                 GDestroyNotify i_destroy_func,
                                                                                                                 GType t_type,
                                                                                                                 GBoxedCopyFunc t_dup_func,
                                                                                                                 GDestroyNotify t_destroy_func,
                                                                                                                 gconstpointer item,
                                                                                                                 const gchar* property);
VALA_EXTERN GType spice_services_history_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesHistoryManager, g_object_unref)
VALA_EXTERN SpiceServicesHistoryManager* spice_window_get_history_manager (SpiceWindow* self);
VALA_EXTERN void spice_services_history_manager_add_undoable_action (SpiceServicesHistoryManager* self,
                                                         SpiceServicesHistoryManagerHistoryAction* action,
                                                         gboolean force_add);
static void __lambda27_ (Block2Data* _data2_,
                  gboolean visible);
static void ___lambda27__spice_slide_visible_changed (SpiceSlide* _sender,
                                               gboolean val,
                                               gpointer self);
VALA_EXTERN GType spice_canvas_item_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SpiceCanvasItem* spice_slide_manager_request_new_item (SpiceSlideManager* self,
                                                       SpiceCanvasItemType type);
VALA_EXTERN SpiceTextItem* spice_text_item_new (SpiceCanvas* _canvas,
                                    JsonObject* _save_data);
VALA_EXTERN SpiceTextItem* spice_text_item_construct (GType object_type,
                                          SpiceCanvas* _canvas,
                                          JsonObject* _save_data);
VALA_EXTERN GType spice_text_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceTextItem, g_object_unref)
VALA_EXTERN GFile* spice_services_file_manager_open_image (void);
VALA_EXTERN SpiceImageItem* spice_image_item_new_from_file (SpiceCanvas* _canvas,
                                                GFile* file);
VALA_EXTERN SpiceImageItem* spice_image_item_construct_from_file (GType object_type,
                                                      SpiceCanvas* _canvas,
                                                      GFile* file);
VALA_EXTERN GType spice_image_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceImageItem, g_object_unref)
VALA_EXTERN SpiceColorItem* spice_color_item_new (SpiceCanvas* _canvas,
                                      JsonObject* _save_data);
VALA_EXTERN SpiceColorItem* spice_color_item_construct (GType object_type,
                                            SpiceCanvas* _canvas,
                                            JsonObject* _save_data);
VALA_EXTERN GType spice_color_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceColorItem, g_object_unref)
VALA_EXTERN SpiceCanvasItem* spice_canvas_add_item (SpiceCanvas* self,
                                        SpiceCanvasItem* item,
                                        gboolean undoable_action);
VALA_EXTERN void spice_slide_manager_jump_to_checkpoint (SpiceSlideManager* self);
VALA_EXTERN void spice_slide_manager_set_checkpoint (SpiceSlideManager* self);
VALA_EXTERN void spice_slide_manager_end_presentation (SpiceSlideManager* self);
VALA_EXTERN void spice_slide_manager_move_up_request (SpiceSlideManager* self);
VALA_EXTERN SpiceCanvasItem* spice_slide_manager_get_current_item (SpiceSlideManager* self);
VALA_EXTERN void spice_canvas_move_up (SpiceCanvas* self,
                           SpiceCanvasItem* item_,
                           gboolean add_undo_action);
VALA_EXTERN void spice_slide_manager_move_down_request (SpiceSlideManager* self);
VALA_EXTERN void spice_canvas_move_down (SpiceCanvas* self,
                             SpiceCanvasItem* item_,
                             gboolean add_undo_action);
static void spice_slide_manager_set_window (SpiceSlideManager* self,
                                     SpiceWindow* value);
VALA_EXTERN void spice_canvas_unselect_all (SpiceCanvas* self,
                                gboolean reset_item);
VALA_EXTERN GtkStackTransitionType spice_slide_get_transition (SpiceSlide* self);
static gboolean _spice_slide_manager_current_slide____lambda17_ (SpiceSlideManager* self);
VALA_EXTERN void spice_slide_load_slide (SpiceSlide* self);
static gboolean __spice_slide_manager_current_slide____lambda17__gsource_func (gpointer self);
static void spice_slide_manager_finalize (GObject * obj);
static GType spice_slide_manager_get_type_once (void);
static void _vala_spice_slide_manager_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_spice_slide_manager_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
spice_slide_manager_get_instance_private (SpiceSlideManager* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceSlideManager_private_offset);
}

static void
_spice_slide_manager_next_slide_spice_canvas_next_slide (SpiceCanvas* _sender,
                                                         gpointer self)
{
#line 116 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	spice_slide_manager_next_slide ((SpiceSlideManager*) self);
#line 440 "SlideManager.c"
}

static void
_spice_slide_manager_previous_slide_spice_canvas_previous_slide (SpiceCanvas* _sender,
                                                                 gpointer self)
{
#line 117 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	spice_slide_manager_previous_slide ((SpiceSlideManager*) self);
#line 449 "SlideManager.c"
}

SpiceSlideManager*
spice_slide_manager_construct (GType object_type,
                               SpiceWindow* window)
{
	SpiceSlideManager * self = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GtkStack* _tmp2_;
	GtkStack* _tmp3_;
	GtkStack* _tmp4_;
	SpiceSlide* _tmp5_;
	SpiceSlide* _tmp6_;
	SpiceCanvas* _tmp7_;
	SpiceSlide* _tmp8_;
	SpiceCanvas* _tmp9_;
	GtkStack* _tmp10_;
	SpiceSlide* _tmp11_;
	SpiceCanvas* _tmp12_;
#line 108 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_val_if_fail (window != NULL, NULL);
#line 109 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	self = (SpiceSlideManager*) g_object_new (object_type, "window", window, NULL);
#line 111 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = gee_array_list_new (SPICE_TYPE_SLIDE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 111 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp1_ = _tmp0_;
#line 111 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	spice_slide_manager_set_slides (self, _tmp1_);
#line 111 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (_tmp1_);
#line 112 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp2_ = (GtkStack*) gtk_stack_new ();
#line 112 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_object_ref_sink (_tmp2_);
#line 112 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp3_ = _tmp2_;
#line 112 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	spice_slide_manager_set_slideshow (self, _tmp3_);
#line 112 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (_tmp3_);
#line 113 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp4_ = self->priv->_slideshow;
#line 113 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	gtk_stack_set_homogeneous (_tmp4_, FALSE);
#line 115 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp5_ = spice_slide_new_empty (window);
#line 115 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (self->end_presentation_slide);
#line 115 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	self->end_presentation_slide = _tmp5_;
#line 116 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp6_ = self->end_presentation_slide;
#line 116 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp7_ = _tmp6_->canvas;
#line 116 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_signal_connect_object (_tmp7_, "next-slide", (GCallback) _spice_slide_manager_next_slide_spice_canvas_next_slide, self, 0);
#line 117 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp8_ = self->end_presentation_slide;
#line 117 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp9_ = _tmp8_->canvas;
#line 117 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_signal_connect_object (_tmp9_, "previous-slide", (GCallback) _spice_slide_manager_previous_slide_spice_canvas_previous_slide, self, 0);
#line 119 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp10_ = self->priv->_slideshow;
#line 119 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp11_ = self->end_presentation_slide;
#line 119 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp12_ = _tmp11_->canvas;
#line 119 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp12_);
#line 108 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return self;
#line 524 "SlideManager.c"
}

SpiceSlideManager*
spice_slide_manager_new (SpiceWindow* window)
{
#line 108 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return spice_slide_manager_construct (SPICE_TYPE_SLIDE_MANAGER, window);
#line 532 "SlideManager.c"
}

void
spice_slide_manager_reset (SpiceSlideManager* self)
{
	GeeArrayList* _tmp12_;
#line 122 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (self != NULL);
#line 123 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (self->priv->slide_);
#line 123 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	self->priv->slide_ = NULL;
#line 124 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (self->preview_slide_);
#line 124 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	self->preview_slide_ = NULL;
#line 549 "SlideManager.c"
	{
		GeeArrayList* _slide_list = NULL;
		GeeArrayList* _tmp0_;
		gint _slide_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _slide_index = 0;
#line 126 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp0_ = self->priv->_slides;
#line 126 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_slide_list = _tmp0_;
#line 126 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp1_ = _slide_list;
#line 126 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
#line 126 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp3_ = _tmp2_;
#line 126 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_slide_size = _tmp3_;
#line 126 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_slide_index = -1;
#line 126 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		while (TRUE) {
#line 574 "SlideManager.c"
			gint _tmp4_;
			gint _tmp5_;
			SpiceSlide* slide = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			GtkStack* _tmp8_;
			SpiceSlide* _tmp9_;
			SpiceCanvas* _tmp10_;
			SpiceSlide* _tmp11_;
#line 126 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_slide_index = _slide_index + 1;
#line 126 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp4_ = _slide_index;
#line 126 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp5_ = _slide_size;
#line 126 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (!(_tmp4_ < _tmp5_)) {
#line 126 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				break;
#line 594 "SlideManager.c"
			}
#line 126 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp6_ = _slide_list;
#line 126 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _slide_index);
#line 126 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			slide = (SpiceSlide*) _tmp7_;
#line 127 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp8_ = self->priv->_slideshow;
#line 127 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp9_ = slide;
#line 127 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp10_ = _tmp9_->canvas;
#line 127 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			gtk_container_remove ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp10_);
#line 128 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp11_ = slide;
#line 128 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			spice_slide_destroy (_tmp11_);
#line 126 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_g_object_unref0 (slide);
#line 616 "SlideManager.c"
		}
	}
#line 131 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp12_ = self->priv->_slides;
#line 131 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp12_);
#line 132 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	spice_image_handler_FILE_ID = (guint) 0;
#line 134 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_signal_emit (self, spice_slide_manager_signals[SPICE_SLIDE_MANAGER_RESETED_SIGNAL], 0);
#line 627 "SlideManager.c"
}

guint
spice_slide_manager_slide_count (SpiceSlideManager* self)
{
	guint slide_count = 0U;
	guint result;
#line 137 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 138 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	slide_count = (guint) 0;
#line 639 "SlideManager.c"
	{
		GeeArrayList* _slide_list = NULL;
		GeeArrayList* _tmp0_;
		gint _slide_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _slide_index = 0;
#line 140 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp0_ = self->priv->_slides;
#line 140 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_slide_list = _tmp0_;
#line 140 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp1_ = _slide_list;
#line 140 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
#line 140 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp3_ = _tmp2_;
#line 140 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_slide_size = _tmp3_;
#line 140 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_slide_index = -1;
#line 140 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		while (TRUE) {
#line 664 "SlideManager.c"
			gint _tmp4_;
			gint _tmp5_;
			SpiceSlide* slide = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			SpiceSlide* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
#line 140 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_slide_index = _slide_index + 1;
#line 140 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp4_ = _slide_index;
#line 140 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp5_ = _slide_size;
#line 140 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (!(_tmp4_ < _tmp5_)) {
#line 140 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				break;
#line 683 "SlideManager.c"
			}
#line 140 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp6_ = _slide_list;
#line 140 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _slide_index);
#line 140 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			slide = (SpiceSlide*) _tmp7_;
#line 141 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp8_ = slide;
#line 141 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp9_ = spice_slide_get_visible (_tmp8_);
#line 141 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp10_ = _tmp9_;
#line 141 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (_tmp10_) {
#line 699 "SlideManager.c"
				guint _tmp11_;
#line 142 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp11_ = slide_count;
#line 142 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				slide_count = _tmp11_ + 1;
#line 705 "SlideManager.c"
			}
#line 140 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_g_object_unref0 (slide);
#line 709 "SlideManager.c"
		}
	}
#line 146 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	result = slide_count;
#line 146 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return result;
#line 716 "SlideManager.c"
}

gchar*
spice_slide_manager_serialise (SpiceSlideManager* self)
{
	gchar* data = NULL;
	gchar* _tmp0_;
	gint _tmp22_ = 0;
	SpiceSlide* _tmp23_;
	SpiceSlide* _tmp24_;
	gint current_slide_index = 0;
	gint _tmp28_ = 0;
	SpiceSlide* _tmp29_;
	SpiceSlide* _tmp30_;
	gint preview_slide_index = 0;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* result;
#line 149 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 150 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = g_strdup ("");
#line 150 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	data = _tmp0_;
#line 741 "SlideManager.c"
	{
		GeeArrayList* _slide_list = NULL;
		GeeArrayList* _tmp1_;
		gint _slide_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _slide_index = 0;
#line 152 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp1_ = self->priv->_slides;
#line 152 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_slide_list = _tmp1_;
#line 152 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp2_ = _slide_list;
#line 152 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 152 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp4_ = _tmp3_;
#line 152 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_slide_size = _tmp4_;
#line 152 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_slide_index = -1;
#line 152 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		while (TRUE) {
#line 766 "SlideManager.c"
			gint _tmp5_;
			gint _tmp6_;
			SpiceSlide* slide = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			SpiceSlide* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
#line 152 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_slide_index = _slide_index + 1;
#line 152 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp5_ = _slide_index;
#line 152 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp6_ = _slide_size;
#line 152 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (!(_tmp5_ < _tmp6_)) {
#line 152 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				break;
#line 785 "SlideManager.c"
			}
#line 152 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp7_ = _slide_list;
#line 152 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _slide_index);
#line 152 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			slide = (SpiceSlide*) _tmp8_;
#line 153 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp9_ = slide;
#line 153 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp10_ = spice_slide_get_visible (_tmp9_);
#line 153 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp11_ = _tmp10_;
#line 153 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (_tmp11_) {
#line 801 "SlideManager.c"
				gchar* _tmp12_ = NULL;
				const gchar* _tmp13_;
				const gchar* _tmp20_;
				gchar* _tmp21_;
#line 154 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp13_ = data;
#line 154 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				if (g_strcmp0 (_tmp13_, "") != 0) {
#line 810 "SlideManager.c"
					SpiceSlide* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
#line 154 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_tmp14_ = slide;
#line 154 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_tmp15_ = spice_slide_serialise (_tmp14_);
#line 154 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_tmp16_ = _tmp15_;
#line 154 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_tmp17_ = g_strconcat (",", _tmp16_, NULL);
#line 154 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_g_free0 (_tmp12_);
#line 154 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_tmp12_ = _tmp17_;
#line 154 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_g_free0 (_tmp16_);
#line 829 "SlideManager.c"
				} else {
					SpiceSlide* _tmp18_;
					gchar* _tmp19_;
#line 154 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_tmp18_ = slide;
#line 154 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_tmp19_ = spice_slide_serialise (_tmp18_);
#line 154 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_g_free0 (_tmp12_);
#line 154 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_tmp12_ = _tmp19_;
#line 841 "SlideManager.c"
				}
#line 154 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp20_ = data;
#line 154 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp21_ = g_strconcat (_tmp20_, _tmp12_, NULL);
#line 154 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_g_free0 (data);
#line 154 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				data = _tmp21_;
#line 153 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_g_free0 (_tmp12_);
#line 853 "SlideManager.c"
			}
#line 152 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_g_object_unref0 (slide);
#line 857 "SlideManager.c"
		}
	}
#line 158 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp23_ = spice_slide_manager_get_current_slide (self);
#line 158 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp24_ = _tmp23_;
#line 158 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (_tmp24_ != NULL) {
#line 866 "SlideManager.c"
		GeeArrayList* _tmp25_;
		SpiceSlide* _tmp26_;
		SpiceSlide* _tmp27_;
#line 158 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp25_ = self->priv->_slides;
#line 158 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp26_ = spice_slide_manager_get_current_slide (self);
#line 158 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp27_ = _tmp26_;
#line 158 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp22_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp25_, _tmp27_);
#line 878 "SlideManager.c"
	} else {
#line 158 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp22_ = 0;
#line 882 "SlideManager.c"
	}
#line 158 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	current_slide_index = _tmp22_;
#line 159 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp29_ = spice_slide_manager_get_preview_slide (self);
#line 159 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp30_ = _tmp29_;
#line 159 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (_tmp30_ != NULL) {
#line 892 "SlideManager.c"
		GeeArrayList* _tmp31_;
		SpiceSlide* _tmp32_;
		SpiceSlide* _tmp33_;
#line 159 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp31_ = self->priv->_slides;
#line 159 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp32_ = spice_slide_manager_get_preview_slide (self);
#line 159 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp33_ = _tmp32_;
#line 159 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp28_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp31_, _tmp33_);
#line 904 "SlideManager.c"
	} else {
#line 159 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp28_ = 0;
#line 908 "SlideManager.c"
	}
#line 159 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	preview_slide_index = _tmp28_;
#line 161 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp34_ = data;
#line 161 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp35_ = g_strdup_printf ("{\"current-slide\":%d, \"preview-slide\":%d, \"aspect-ratio\":%d, \"sl" \
"ides\": [%s]}", current_slide_index, preview_slide_index, (gint) self->priv->current_ratio, _tmp34_);
#line 161 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	result = _tmp35_;
#line 161 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_free0 (data);
#line 161 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return result;
#line 922 "SlideManager.c"
}

static gpointer
_json_object_ref0 (gpointer self)
{
#line 169 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return self ? json_object_ref (self) : NULL;
#line 930 "SlideManager.c"
}

static gpointer
_json_array_ref0 (gpointer self)
{
#line 170 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return self ? json_array_ref (self) : NULL;
#line 938 "SlideManager.c"
}

void
spice_slide_manager_load_data (SpiceSlideManager* self,
                               const gchar* data)
{
	GError* _inner_error0_ = NULL;
#line 164 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (self != NULL);
#line 164 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (data != NULL);
#line 950 "SlideManager.c"
	{
		JsonParser* parser = NULL;
		JsonParser* _tmp0_;
		JsonObject* root_object = NULL;
		JsonNode* _tmp1_;
		JsonObject* _tmp2_;
		JsonObject* _tmp3_;
		JsonArray* slides_array = NULL;
		JsonObject* _tmp4_;
		JsonArray* _tmp5_;
		JsonArray* _tmp6_;
		gint ratio = 0;
		JsonObject* _tmp7_;
		JsonArray* _tmp8_;
		GList* _tmp9_;
		gint position = 0;
		JsonObject* _tmp14_;
		gboolean _tmp15_ = FALSE;
		GeeArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		JsonObject* _tmp27_;
#line 166 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp0_ = json_parser_new ();
#line 166 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		parser = _tmp0_;
#line 167 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		json_parser_load_from_data (parser, data, (gssize) -1, &_inner_error0_);
#line 167 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 167 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_g_object_unref0 (parser);
#line 983 "SlideManager.c"
			goto __catch0_g_error;
		}
#line 169 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp1_ = json_parser_get_root (parser);
#line 169 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp2_ = json_node_get_object (_tmp1_);
#line 169 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp3_ = _json_object_ref0 (_tmp2_);
#line 169 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		root_object = _tmp3_;
#line 170 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp4_ = root_object;
#line 170 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp5_ = json_object_get_array_member (_tmp4_, "slides");
#line 170 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp6_ = _json_array_ref0 (_tmp5_);
#line 170 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		slides_array = _tmp6_;
#line 172 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp7_ = root_object;
#line 172 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		ratio = (gint) json_object_get_int_member (_tmp7_, "aspect-ratio");
#line 174 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		if (spice_slide_manager_aspect_ratio_override != -1) {
#line 175 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			ratio = spice_slide_manager_aspect_ratio_override;
#line 176 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			spice_slide_manager_aspect_ratio_override = -1;
#line 1012 "SlideManager.c"
		}
#line 179 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		self->priv->current_ratio = spice_aspect_ratio_get_mode (&ratio);
#line 180 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		g_signal_emit (self, spice_slide_manager_signals[SPICE_SLIDE_MANAGER_ASPECT_RATIO_CHANGED_SIGNAL], 0, self->priv->current_ratio);
#line 182 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp8_ = slides_array;
#line 182 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp9_ = json_array_get_elements (_tmp8_);
#line 1022 "SlideManager.c"
		{
			GList* slide_object_collection = NULL;
			GList* slide_object_it = NULL;
#line 182 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			slide_object_collection = _tmp9_;
#line 182 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			for (slide_object_it = slide_object_collection; slide_object_it != NULL; slide_object_it = slide_object_it->next) {
#line 1030 "SlideManager.c"
				JsonNode* slide_object = NULL;
#line 182 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				slide_object = (JsonNode*) slide_object_it->data;
#line 1034 "SlideManager.c"
				{
					JsonNode* _tmp10_;
					JsonObject* _tmp11_;
					SpiceSlide* _tmp12_;
					SpiceSlide* _tmp13_;
#line 183 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_tmp10_ = slide_object;
#line 183 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_tmp11_ = json_node_get_object (_tmp10_);
#line 183 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_tmp12_ = spice_slide_manager_new_slide (self, _tmp11_, FALSE);
#line 183 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_tmp13_ = _tmp12_;
#line 183 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_g_object_unref0 (_tmp13_);
#line 1050 "SlideManager.c"
				}
			}
#line 182 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			(slide_object_collection == NULL) ? NULL : (slide_object_collection = (g_list_free (slide_object_collection), NULL));
#line 1055 "SlideManager.c"
		}
#line 186 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp14_ = root_object;
#line 186 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		position = (gint) json_object_get_int_member (_tmp14_, "current-slide");
#line 187 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp16_ = self->priv->_slides;
#line 187 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
#line 187 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp18_ = _tmp17_;
#line 187 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		if (_tmp18_ > position) {
#line 187 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp15_ = position >= 0;
#line 1071 "SlideManager.c"
		} else {
#line 187 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp15_ = FALSE;
#line 1075 "SlideManager.c"
		}
#line 187 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		if (_tmp15_) {
#line 1079 "SlideManager.c"
			GeeArrayList* _tmp19_;
			gpointer _tmp20_;
			SpiceSlide* _tmp21_;
			SpiceSlide* _tmp22_;
			SpiceSlide* _tmp23_;
#line 188 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp19_ = self->priv->_slides;
#line 188 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, position);
#line 188 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp21_ = (SpiceSlide*) _tmp20_;
#line 188 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			spice_slide_manager_set_current_slide (self, _tmp21_);
#line 188 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_g_object_unref0 (_tmp21_);
#line 189 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp22_ = spice_slide_manager_get_current_slide (self);
#line 189 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp23_ = _tmp22_;
#line 189 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			spice_slide_reload_preview_data (_tmp23_);
#line 1101 "SlideManager.c"
		} else {
			GeeArrayList* _tmp24_;
			gpointer _tmp25_;
			SpiceSlide* _tmp26_;
#line 191 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp24_ = self->priv->_slides;
#line 191 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, 0);
#line 191 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp26_ = (SpiceSlide*) _tmp25_;
#line 191 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			spice_slide_manager_set_current_slide (self, _tmp26_);
#line 191 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_g_object_unref0 (_tmp26_);
#line 1116 "SlideManager.c"
		}
#line 194 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp27_ = root_object;
#line 194 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		if (json_object_has_member (_tmp27_, "preview-slide")) {
#line 1122 "SlideManager.c"
			JsonObject* _tmp28_;
			gboolean _tmp29_ = FALSE;
			GeeArrayList* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
#line 195 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp28_ = root_object;
#line 195 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			position = (gint) json_object_get_int_member (_tmp28_, "preview-slide");
#line 196 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp30_ = self->priv->_slides;
#line 196 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp30_);
#line 196 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp32_ = _tmp31_;
#line 196 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (_tmp32_ > position) {
#line 196 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp29_ = position >= 0;
#line 1142 "SlideManager.c"
			} else {
#line 196 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp29_ = FALSE;
#line 1146 "SlideManager.c"
			}
#line 196 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (_tmp29_) {
#line 1150 "SlideManager.c"
				GeeArrayList* _tmp33_;
				gpointer _tmp34_;
				SpiceSlide* _tmp35_;
#line 197 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp33_ = self->priv->_slides;
#line 197 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, position);
#line 197 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp35_ = (SpiceSlide*) _tmp34_;
#line 197 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				spice_slide_manager_set_preview_slide (self, _tmp35_);
#line 197 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_g_object_unref0 (_tmp35_);
#line 1164 "SlideManager.c"
			} else {
				GeeArrayList* _tmp36_;
				gpointer _tmp37_;
				SpiceSlide* _tmp38_;
#line 199 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp36_ = self->priv->_slides;
#line 199 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, 0);
#line 199 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp38_ = (SpiceSlide*) _tmp37_;
#line 199 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				spice_slide_manager_set_preview_slide (self, _tmp38_);
#line 199 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_g_object_unref0 (_tmp38_);
#line 1179 "SlideManager.c"
			}
		}
#line 165 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_json_array_unref0 (slides_array);
#line 165 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_json_object_unref0 (root_object);
#line 165 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_g_object_unref0 (parser);
#line 1188 "SlideManager.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp39_;
#line 165 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		e = _inner_error0_;
#line 165 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_inner_error0_ = NULL;
#line 203 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp39_ = e->message;
#line 203 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		g_error ("SlideManager.vala:203: Error loading file: %s", _tmp39_);
#line 165 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_g_error_free0 (e);
#line 1205 "SlideManager.c"
	}
	__finally0:
#line 165 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 165 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 165 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		g_clear_error (&_inner_error0_);
#line 165 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		return;
#line 1216 "SlideManager.c"
	}
}

void
spice_slide_manager_move_down (SpiceSlideManager* self,
                               SpiceSlide* slide)
{
	gint index = 0;
	GeeArrayList* _tmp0_;
	SpiceSlide* next_slide = NULL;
	SpiceSlide* _tmp1_;
	SpiceSlide* _tmp2_;
#line 207 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (self != NULL);
#line 207 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (slide != NULL);
#line 208 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = self->priv->_slides;
#line 208 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	index = gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, slide);
#line 210 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp1_ = spice_slide_manager_get_next_slide (self, slide);
#line 210 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	next_slide = _tmp1_;
#line 211 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp2_ = next_slide;
#line 211 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (_tmp2_ != NULL) {
#line 1245 "SlideManager.c"
		gint next_index = 0;
		GeeArrayList* _tmp3_;
		SpiceSlide* _tmp4_;
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		SpiceSlide* _tmp7_;
#line 212 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp3_ = self->priv->_slides;
#line 212 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp4_ = next_slide;
#line 212 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		next_index = gee_abstract_list_index_of ((GeeAbstractList*) _tmp3_, _tmp4_);
#line 214 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp5_ = self->priv->_slides;
#line 214 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		gee_abstract_list_set ((GeeAbstractList*) _tmp5_, next_index, slide);
#line 215 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp6_ = self->priv->_slides;
#line 215 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp7_ = next_slide;
#line 215 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		gee_abstract_list_set ((GeeAbstractList*) _tmp6_, index, _tmp7_);
#line 217 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		g_signal_emit (self, spice_slide_manager_signals[SPICE_SLIDE_MANAGER_SLIDES_SORTED_SIGNAL], 0);
#line 1270 "SlideManager.c"
	}
#line 207 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (next_slide);
#line 1274 "SlideManager.c"
}

void
spice_slide_manager_move_up (SpiceSlideManager* self,
                             SpiceSlide* slide)
{
	gint index = 0;
	GeeArrayList* _tmp0_;
	SpiceSlide* previous_slide = NULL;
	SpiceSlide* _tmp1_;
	SpiceSlide* _tmp2_;
#line 221 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (self != NULL);
#line 221 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (slide != NULL);
#line 222 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = self->priv->_slides;
#line 222 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	index = gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, slide);
#line 224 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp1_ = spice_slide_manager_get_previous_slide (self, slide);
#line 224 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	previous_slide = _tmp1_;
#line 225 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp2_ = previous_slide;
#line 225 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (_tmp2_ != NULL) {
#line 1302 "SlideManager.c"
		gint previous_index = 0;
		GeeArrayList* _tmp3_;
		SpiceSlide* _tmp4_;
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		SpiceSlide* _tmp7_;
#line 226 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp3_ = self->priv->_slides;
#line 226 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp4_ = previous_slide;
#line 226 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		previous_index = gee_abstract_list_index_of ((GeeAbstractList*) _tmp3_, _tmp4_);
#line 228 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp5_ = self->priv->_slides;
#line 228 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		gee_abstract_list_set ((GeeAbstractList*) _tmp5_, previous_index, slide);
#line 229 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp6_ = self->priv->_slides;
#line 229 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp7_ = previous_slide;
#line 229 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		gee_abstract_list_set ((GeeAbstractList*) _tmp6_, index, _tmp7_);
#line 231 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		g_signal_emit (self, spice_slide_manager_signals[SPICE_SLIDE_MANAGER_SLIDES_SORTED_SIGNAL], 0);
#line 1327 "SlideManager.c"
	}
#line 221 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (previous_slide);
#line 1331 "SlideManager.c"
}

void
spice_slide_manager_previous_slide (SpiceSlideManager* self)
{
	SpiceSlide* previous_slide = NULL;
	SpiceSlide* _tmp0_;
	SpiceSlide* _tmp1_;
	SpiceSlide* _tmp2_;
	SpiceSlide* _tmp3_;
#line 235 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (self != NULL);
#line 236 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = spice_slide_manager_get_current_slide (self);
#line 236 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp1_ = _tmp0_;
#line 236 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp2_ = spice_slide_manager_get_previous_slide (self, _tmp1_);
#line 236 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	previous_slide = _tmp2_;
#line 238 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp3_ = previous_slide;
#line 238 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (_tmp3_ != NULL) {
#line 1356 "SlideManager.c"
		SpiceSlide* _tmp4_;
#line 239 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp4_ = previous_slide;
#line 239 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_manager_set_current_slide (self, _tmp4_);
#line 1362 "SlideManager.c"
	}
#line 235 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (previous_slide);
#line 1366 "SlideManager.c"
}

void
spice_slide_manager_next_slide (SpiceSlideManager* self)
{
	SpiceSlide* next_slide = NULL;
	SpiceSlide* _tmp0_;
	SpiceSlide* _tmp1_;
	SpiceSlide* _tmp2_;
	GtkStack* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	SpiceSlide* _tmp6_;
	SpiceCanvas* _tmp7_;
	SpiceSlide* _tmp9_;
#line 243 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (self != NULL);
#line 244 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = spice_slide_manager_get_current_slide (self);
#line 244 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp1_ = _tmp0_;
#line 244 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp2_ = spice_slide_manager_get_next_slide (self, _tmp1_);
#line 244 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	next_slide = _tmp2_;
#line 246 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp3_ = self->priv->_slideshow;
#line 246 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp4_ = gtk_stack_get_visible_child (_tmp3_);
#line 246 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp5_ = _tmp4_;
#line 246 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp6_ = self->end_presentation_slide;
#line 246 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp7_ = _tmp6_->canvas;
#line 246 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (_tmp5_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget)) {
#line 1404 "SlideManager.c"
		SpiceWindow* _tmp8_;
#line 247 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp8_ = self->priv->_window;
#line 247 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_window_set_is_presenting (_tmp8_, FALSE);
#line 248 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_g_object_unref0 (next_slide);
#line 248 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		return;
#line 1414 "SlideManager.c"
	}
#line 251 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp9_ = next_slide;
#line 251 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (_tmp9_ != NULL) {
#line 1420 "SlideManager.c"
		SpiceSlide* _tmp10_;
#line 252 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp10_ = next_slide;
#line 252 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_manager_set_current_slide (self, _tmp10_);
#line 1426 "SlideManager.c"
	}
#line 243 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (next_slide);
#line 1430 "SlideManager.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 271 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return self ? g_object_ref (self) : NULL;
#line 1438 "SlideManager.c"
}

SpiceSlide*
spice_slide_manager_get_next_slide (SpiceSlideManager* self,
                                    SpiceSlide* current)
{
	SpiceSlide* next_slide = NULL;
	gboolean found = FALSE;
	gint n = 0;
	gint current_slide_index = 0;
	GeeArrayList* _tmp0_;
	SpiceSlide* result;
#line 256 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 256 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_val_if_fail (current != NULL, NULL);
#line 257 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	next_slide = NULL;
#line 258 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	found = FALSE;
#line 259 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	n = 1;
#line 261 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = self->priv->_slides;
#line 261 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	current_slide_index = gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, current);
#line 262 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (current_slide_index == -1) {
#line 1467 "SlideManager.c"
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
#line 263 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp1_ = self->priv->_slides;
#line 263 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
#line 263 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp3_ = _tmp2_;
#line 263 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		current_slide_index = _tmp3_;
#line 1479 "SlideManager.c"
	}
	{
		gboolean _tmp4_ = FALSE;
#line 266 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp4_ = TRUE;
#line 266 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		while (TRUE) {
#line 1487 "SlideManager.c"
			gint next_index = 0;
			gint _tmp5_;
			gint _tmp6_;
			GeeArrayList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
#line 266 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (!_tmp4_) {
#line 282 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				if (!(!found)) {
#line 282 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					break;
#line 1500 "SlideManager.c"
				}
			}
#line 266 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp4_ = FALSE;
#line 267 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp5_ = current_slide_index;
#line 267 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp6_ = n;
#line 267 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			n = _tmp6_ + 1;
#line 267 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			next_index = _tmp5_ + _tmp6_;
#line 268 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp7_ = self->priv->_slides;
#line 268 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
#line 268 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp9_ = _tmp8_;
#line 268 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (next_index < _tmp9_) {
#line 1521 "SlideManager.c"
				SpiceSlide* slide = NULL;
				GeeArrayList* _tmp10_;
				gpointer _tmp11_;
				SpiceSlide* _tmp12_;
				gboolean _tmp13_;
				gboolean _tmp14_;
#line 269 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp10_ = self->priv->_slides;
#line 269 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, next_index);
#line 269 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				slide = (SpiceSlide*) _tmp11_;
#line 270 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp12_ = slide;
#line 270 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp13_ = spice_slide_get_visible (_tmp12_);
#line 270 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp14_ = _tmp13_;
#line 270 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				if (_tmp14_) {
#line 1542 "SlideManager.c"
					SpiceSlide* _tmp15_;
					SpiceSlide* _tmp16_;
#line 271 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_tmp15_ = slide;
#line 271 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_tmp16_ = _g_object_ref0 (_tmp15_);
#line 271 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_g_object_unref0 (next_slide);
#line 271 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					next_slide = _tmp16_;
#line 272 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					found = TRUE;
#line 1555 "SlideManager.c"
				}
#line 268 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_g_object_unref0 (slide);
#line 1559 "SlideManager.c"
			} else {
				SpiceWindow* _tmp17_;
				gboolean _tmp18_;
				gboolean _tmp19_;
#line 275 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp17_ = self->priv->_window;
#line 275 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp18_ = spice_window_get_is_presenting (_tmp17_);
#line 275 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp19_ = _tmp18_;
#line 275 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				if (_tmp19_) {
#line 1572 "SlideManager.c"
					SpiceSlide* _tmp20_;
					SpiceSlide* _tmp21_;
#line 276 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_tmp20_ = self->end_presentation_slide;
#line 276 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_tmp21_ = _g_object_ref0 (_tmp20_);
#line 276 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_g_object_unref0 (next_slide);
#line 276 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					next_slide = _tmp21_;
#line 1583 "SlideManager.c"
				} else {
#line 278 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_g_object_unref0 (next_slide);
#line 278 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					next_slide = NULL;
#line 1589 "SlideManager.c"
				}
#line 280 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				found = TRUE;
#line 1593 "SlideManager.c"
			}
		}
	}
#line 284 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	result = next_slide;
#line 284 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return result;
#line 1601 "SlideManager.c"
}

static SpiceSlide*
spice_slide_manager_get_previous_slide (SpiceSlideManager* self,
                                        SpiceSlide* current)
{
	SpiceSlide* previous_slide = NULL;
	gboolean found = FALSE;
	gint n = 0;
	gint current_slide_index = 0;
	GeeArrayList* _tmp0_;
	SpiceSlide* result;
#line 287 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 287 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_val_if_fail (current != NULL, NULL);
#line 288 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	previous_slide = NULL;
#line 289 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	found = FALSE;
#line 290 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	n = 1;
#line 292 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = self->priv->_slides;
#line 292 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	current_slide_index = gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, current);
#line 293 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (current_slide_index == -1) {
#line 1630 "SlideManager.c"
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
#line 294 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp1_ = self->priv->_slides;
#line 294 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
#line 294 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp3_ = _tmp2_;
#line 294 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		current_slide_index = _tmp3_;
#line 1642 "SlideManager.c"
	}
	{
		gboolean _tmp4_ = FALSE;
#line 297 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp4_ = TRUE;
#line 297 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		while (TRUE) {
#line 1650 "SlideManager.c"
			gint previous_index = 0;
			gint _tmp5_;
			gint _tmp6_;
			gboolean _tmp7_ = FALSE;
#line 297 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (!_tmp4_) {
#line 311 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				if (!(!found)) {
#line 311 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					break;
#line 1661 "SlideManager.c"
				}
			}
#line 297 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp4_ = FALSE;
#line 298 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp5_ = current_slide_index;
#line 298 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp6_ = n;
#line 298 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			n = _tmp6_ + 1;
#line 298 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			previous_index = _tmp5_ - _tmp6_;
#line 299 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (previous_index >= 0) {
#line 1676 "SlideManager.c"
				GeeArrayList* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
#line 299 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp8_ = self->priv->_slides;
#line 299 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
#line 299 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp10_ = _tmp9_;
#line 299 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp7_ = previous_index < _tmp10_;
#line 1688 "SlideManager.c"
			} else {
#line 299 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp7_ = FALSE;
#line 1692 "SlideManager.c"
			}
#line 299 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (_tmp7_) {
#line 1696 "SlideManager.c"
				SpiceSlide* slide = NULL;
				GeeArrayList* _tmp11_;
				gpointer _tmp12_;
				SpiceSlide* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
#line 300 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp11_ = self->priv->_slides;
#line 300 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, previous_index);
#line 300 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				slide = (SpiceSlide*) _tmp12_;
#line 301 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp13_ = slide;
#line 301 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp14_ = spice_slide_get_visible (_tmp13_);
#line 301 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp15_ = _tmp14_;
#line 301 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				if (_tmp15_) {
#line 1717 "SlideManager.c"
					SpiceSlide* _tmp16_;
					SpiceSlide* _tmp17_;
#line 302 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_tmp16_ = slide;
#line 302 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_tmp17_ = _g_object_ref0 (_tmp16_);
#line 302 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					_g_object_unref0 (previous_slide);
#line 302 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					previous_slide = _tmp17_;
#line 303 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
					found = TRUE;
#line 1730 "SlideManager.c"
				}
#line 299 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_g_object_unref0 (slide);
#line 1734 "SlideManager.c"
			}
#line 307 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (previous_index < 0) {
#line 308 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_g_object_unref0 (previous_slide);
#line 308 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				previous_slide = NULL;
#line 309 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				found = TRUE;
#line 1744 "SlideManager.c"
			}
		}
	}
#line 313 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	result = previous_slide;
#line 313 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return result;
#line 1752 "SlideManager.c"
}

gint
spice_slide_manager_get_slide_ammount (SpiceSlideManager* self)
{
	gint slide_count = 0;
	gint result;
#line 316 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 317 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	slide_count = 0;
#line 1764 "SlideManager.c"
	{
		GeeArrayList* _slide_list = NULL;
		GeeArrayList* _tmp0_;
		gint _slide_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _slide_index = 0;
#line 319 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp0_ = self->priv->_slides;
#line 319 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_slide_list = _tmp0_;
#line 319 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp1_ = _slide_list;
#line 319 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
#line 319 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp3_ = _tmp2_;
#line 319 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_slide_size = _tmp3_;
#line 319 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_slide_index = -1;
#line 319 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		while (TRUE) {
#line 1789 "SlideManager.c"
			gint _tmp4_;
			gint _tmp5_;
			SpiceSlide* slide = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			SpiceSlide* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
#line 319 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_slide_index = _slide_index + 1;
#line 319 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp4_ = _slide_index;
#line 319 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp5_ = _slide_size;
#line 319 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (!(_tmp4_ < _tmp5_)) {
#line 319 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				break;
#line 1808 "SlideManager.c"
			}
#line 319 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp6_ = _slide_list;
#line 319 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _slide_index);
#line 319 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			slide = (SpiceSlide*) _tmp7_;
#line 320 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp8_ = slide;
#line 320 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp9_ = spice_slide_get_visible (_tmp8_);
#line 320 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp10_ = _tmp9_;
#line 320 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (_tmp10_) {
#line 1824 "SlideManager.c"
				gint _tmp11_;
#line 321 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp11_ = slide_count;
#line 321 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				slide_count = _tmp11_ + 1;
#line 1830 "SlideManager.c"
			}
#line 319 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_g_object_unref0 (slide);
#line 1834 "SlideManager.c"
		}
	}
#line 325 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	result = slide_count;
#line 325 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return result;
#line 1841 "SlideManager.c"
}

gint
spice_slide_manager_get_slide_pos (SpiceSlideManager* self,
                                   SpiceSlide* current)
{
	gint slide_count = 0;
	gint result;
#line 328 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 328 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_val_if_fail (current != NULL, 0);
#line 329 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	slide_count = 0;
#line 1856 "SlideManager.c"
	{
		GeeArrayList* _slide_list = NULL;
		GeeArrayList* _tmp0_;
		gint _slide_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _slide_index = 0;
#line 331 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp0_ = self->priv->_slides;
#line 331 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_slide_list = _tmp0_;
#line 331 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp1_ = _slide_list;
#line 331 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
#line 331 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp3_ = _tmp2_;
#line 331 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_slide_size = _tmp3_;
#line 331 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_slide_index = -1;
#line 331 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		while (TRUE) {
#line 1881 "SlideManager.c"
			gint _tmp4_;
			gint _tmp5_;
			SpiceSlide* slide = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			gint _tmp8_;
			SpiceSlide* _tmp9_;
#line 331 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_slide_index = _slide_index + 1;
#line 331 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp4_ = _slide_index;
#line 331 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp5_ = _slide_size;
#line 331 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (!(_tmp4_ < _tmp5_)) {
#line 331 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				break;
#line 1899 "SlideManager.c"
			}
#line 331 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp6_ = _slide_list;
#line 331 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _slide_index);
#line 331 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			slide = (SpiceSlide*) _tmp7_;
#line 332 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp8_ = slide_count;
#line 332 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			slide_count = _tmp8_ + 1;
#line 333 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp9_ = slide;
#line 333 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (_tmp9_ == current) {
#line 334 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				result = slide_count;
#line 334 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_g_object_unref0 (slide);
#line 334 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				return result;
#line 1921 "SlideManager.c"
			}
#line 331 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_g_object_unref0 (slide);
#line 1925 "SlideManager.c"
		}
	}
#line 338 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	result = -1;
#line 338 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return result;
#line 1932 "SlideManager.c"
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 343 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 343 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return _data2_;
#line 1942 "SlideManager.c"
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 343 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1952 "SlideManager.c"
		SpiceSlideManager* self;
#line 343 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		self = _data2_->self;
#line 343 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_g_object_unref0 (_data2_->slide);
#line 343 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_g_object_unref0 (self);
#line 343 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		g_slice_free (Block2Data, _data2_);
#line 1962 "SlideManager.c"
	}
}

static void
__lambda23_ (SpiceSlideManager* self,
             SpiceCanvasItem* item)
{
#line 347 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	spice_slide_manager_set_current_item (self, item);
#line 1972 "SlideManager.c"
}

static void
___lambda23__spice_canvas_item_clicked (SpiceCanvas* _sender,
                                        SpiceCanvasItem* item,
                                        gpointer self)
{
#line 346 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	__lambda23_ ((SpiceSlideManager*) self, item);
#line 1982 "SlideManager.c"
}

static void
__lambda24_ (SpiceSlideManager* self)
{
#line 351 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	spice_slide_manager_next_slide (self);
#line 1990 "SlideManager.c"
}

static void
___lambda24__spice_canvas_next_slide (SpiceCanvas* _sender,
                                      gpointer self)
{
#line 350 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	__lambda24_ ((SpiceSlideManager*) self);
#line 1999 "SlideManager.c"
}

static void
__lambda25_ (SpiceSlideManager* self)
{
#line 355 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	spice_slide_manager_previous_slide (self);
#line 2007 "SlideManager.c"
}

static void
___lambda25__spice_canvas_previous_slide (SpiceCanvas* _sender,
                                          gpointer self)
{
#line 354 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	__lambda25_ ((SpiceSlideManager*) self);
#line 2016 "SlideManager.c"
}

static void
__lambda26_ (Block2Data* _data2_,
             gdouble new_ratio)
{
	SpiceSlideManager* self;
	gint w = 0;
	SpiceSlide* _tmp0_;
	SpiceCanvas* _tmp1_;
	gint h = 0;
	SpiceSlide* _tmp2_;
	SpiceCanvas* _tmp3_;
#line 358 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	self = _data2_->self;
#line 359 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (self->priv->propagating_ratio) {
#line 359 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		return;
#line 2036 "SlideManager.c"
	}
#line 360 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	self->priv->propagating_ratio = TRUE;
#line 362 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = _data2_->slide;
#line 362 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp1_ = _tmp0_->canvas;
#line 362 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	w = gtk_widget_get_allocated_width ((GtkWidget*) _tmp1_);
#line 363 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp2_ = _data2_->slide;
#line 363 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp3_ = _tmp2_->canvas;
#line 363 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	h = gtk_widget_get_allocated_height ((GtkWidget*) _tmp3_);
#line 2052 "SlideManager.c"
	{
		GeeArrayList* _s_list = NULL;
		GeeArrayList* _tmp4_;
		gint _s_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _s_index = 0;
#line 365 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp4_ = self->priv->_slides;
#line 365 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_s_list = _tmp4_;
#line 365 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp5_ = _s_list;
#line 365 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
#line 365 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp7_ = _tmp6_;
#line 365 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_s_size = _tmp7_;
#line 365 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_s_index = -1;
#line 365 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		while (TRUE) {
#line 2077 "SlideManager.c"
			gint _tmp8_;
			gint _tmp9_;
			SpiceSlide* s = NULL;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			SpiceSlide* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
#line 365 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_s_index = _s_index + 1;
#line 365 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp8_ = _s_index;
#line 365 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp9_ = _s_size;
#line 365 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 365 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				break;
#line 2096 "SlideManager.c"
			}
#line 365 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp10_ = _s_list;
#line 365 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _s_index);
#line 365 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			s = (SpiceSlide*) _tmp11_;
#line 366 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp12_ = s;
#line 366 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp13_ = spice_slide_get_visible (_tmp12_);
#line 366 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp14_ = _tmp13_;
#line 366 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (_tmp14_) {
#line 2112 "SlideManager.c"
				SpiceSlide* _tmp15_;
				SpiceCanvas* _tmp16_;
				SpiceSlide* _tmp17_;
				SpiceCanvas* _tmp18_;
				SpiceSlide* _tmp19_;
				SpiceCanvas* _tmp20_;
#line 367 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp15_ = s;
#line 367 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp16_ = _tmp15_->canvas;
#line 367 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				spice_canvas_set_current_ratio (_tmp16_, new_ratio);
#line 370 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp17_ = s;
#line 370 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp18_ = _tmp17_->canvas;
#line 370 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				gtk_widget_set_size_request ((GtkWidget*) _tmp18_, w, h);
#line 371 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp19_ = s;
#line 371 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp20_ = _tmp19_->canvas;
#line 371 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				gtk_widget_set_size_request ((GtkWidget*) _tmp20_, 500, 380);
#line 2137 "SlideManager.c"
			}
#line 365 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_g_object_unref0 (s);
#line 2141 "SlideManager.c"
		}
	}
#line 375 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	self->priv->propagating_ratio = FALSE;
#line 2146 "SlideManager.c"
}

static void
___lambda26__spice_canvas_ratio_changed (SpiceCanvas* _sender,
                                         gdouble ratio,
                                         gpointer self)
{
#line 358 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	__lambda26_ (self, ratio);
#line 2156 "SlideManager.c"
}

static void
__lambda27_ (Block2Data* _data2_,
             gboolean visible)
{
	SpiceSlideManager* self;
#line 401 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	self = _data2_->self;
#line 402 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (visible) {
#line 2168 "SlideManager.c"
		SpiceSlide* _tmp0_;
#line 403 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp0_ = _data2_->slide;
#line 403 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_manager_set_current_slide (self, _tmp0_);
#line 2174 "SlideManager.c"
	} else {
		SpiceSlide* next_slide = NULL;
		SpiceSlide* _tmp1_;
		SpiceSlide* _tmp2_;
		SpiceSlide* _tmp3_;
		SpiceSlide* _tmp6_;
#line 405 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp1_ = _data2_->slide;
#line 405 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp2_ = spice_slide_manager_get_next_slide (self, _tmp1_);
#line 405 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		next_slide = _tmp2_;
#line 407 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp3_ = next_slide;
#line 407 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		if (_tmp3_ == NULL) {
#line 2191 "SlideManager.c"
			SpiceSlide* _tmp4_;
			SpiceSlide* _tmp5_;
#line 408 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp4_ = _data2_->slide;
#line 408 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp5_ = spice_slide_manager_get_previous_slide (self, _tmp4_);
#line 408 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_g_object_unref0 (next_slide);
#line 408 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			next_slide = _tmp5_;
#line 2202 "SlideManager.c"
		}
#line 411 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp6_ = next_slide;
#line 411 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		if (_tmp6_ != NULL) {
#line 2208 "SlideManager.c"
			SpiceSlide* _tmp7_;
#line 412 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp7_ = next_slide;
#line 412 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			spice_slide_manager_set_current_slide (self, _tmp7_);
#line 2214 "SlideManager.c"
		}
#line 402 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_g_object_unref0 (next_slide);
#line 2218 "SlideManager.c"
	}
}

static void
___lambda27__spice_slide_visible_changed (SpiceSlide* _sender,
                                          gboolean val,
                                          gpointer self)
{
#line 401 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	__lambda27_ (self, val);
#line 2229 "SlideManager.c"
}

SpiceSlide*
spice_slide_manager_new_slide (SpiceSlideManager* self,
                               JsonObject* save_data,
                               gboolean undoable_action)
{
	Block2Data* _data2_;
	SpiceWindow* _tmp0_;
	SpiceSlide* _tmp1_;
	SpiceSlide* _tmp2_;
	SpiceCanvas* _tmp3_;
	SpiceSlide* _tmp4_;
	SpiceCanvas* _tmp5_;
	SpiceSlide* _tmp6_;
	SpiceCanvas* _tmp7_;
	SpiceSlide* _tmp8_;
	SpiceCanvas* _tmp9_;
	SpiceSlide* _tmp18_;
	SpiceSlide* _tmp19_;
	GtkStack* _tmp27_;
	SpiceSlide* _tmp28_;
	SpiceCanvas* _tmp29_;
	GtkStack* _tmp30_;
	SpiceSlide* _tmp31_;
	SpiceSlide* _tmp33_;
	SpiceSlide* _tmp34_;
	SpiceSlide* _tmp35_;
	SpiceSlide* result;
#line 343 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 343 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 343 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_data2_->_ref_count_ = 1;
#line 343 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_data2_->self = g_object_ref (self);
#line 344 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = self->priv->_window;
#line 344 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp1_ = spice_slide_new (_tmp0_, save_data);
#line 344 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_data2_->slide = _tmp1_;
#line 346 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp2_ = _data2_->slide;
#line 346 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp3_ = _tmp2_->canvas;
#line 346 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_signal_connect_object (_tmp3_, "item-clicked", (GCallback) ___lambda23__spice_canvas_item_clicked, self, 0);
#line 350 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp4_ = _data2_->slide;
#line 350 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp5_ = _tmp4_->canvas;
#line 350 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_signal_connect_object (_tmp5_, "next-slide", (GCallback) ___lambda24__spice_canvas_next_slide, self, 0);
#line 354 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp6_ = _data2_->slide;
#line 354 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp7_ = _tmp6_->canvas;
#line 354 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_signal_connect_object (_tmp7_, "previous-slide", (GCallback) ___lambda25__spice_canvas_previous_slide, self, 0);
#line 358 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp8_ = _data2_->slide;
#line 358 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp9_ = _tmp8_->canvas;
#line 358 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_signal_connect_data (_tmp9_, "ratio-changed", (GCallback) ___lambda26__spice_canvas_ratio_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 378 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (undoable_action) {
#line 2299 "SlideManager.c"
		SpiceSlide* _tmp10_;
		SpiceServicesHistoryManagerHistoryAction* action = NULL;
		SpiceSlide* _tmp11_;
		SpiceServicesHistoryManagerHistoryAction* _tmp12_;
		SpiceWindow* _tmp13_;
		SpiceServicesHistoryManager* _tmp14_;
		SpiceServicesHistoryManager* _tmp15_;
		SpiceServicesHistoryManagerHistoryAction* _tmp16_;
		SpiceSlide* _tmp17_;
#line 379 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp10_ = _data2_->slide;
#line 379 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_set_visible (_tmp10_, FALSE);
#line 380 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp11_ = _data2_->slide;
#line 380 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp12_ = spice_services_history_manager_history_action_new_slide_changed (SPICE_TYPE_SLIDE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_BOOLEAN, NULL, NULL, _tmp11_, "visible");
#line 380 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		action = _tmp12_;
#line 381 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp13_ = self->priv->_window;
#line 381 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp14_ = spice_window_get_history_manager (_tmp13_);
#line 381 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp15_ = _tmp14_;
#line 381 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp16_ = action;
#line 381 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_services_history_manager_add_undoable_action (_tmp15_, _tmp16_, TRUE);
#line 382 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp17_ = _data2_->slide;
#line 382 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_set_visible (_tmp17_, TRUE);
#line 378 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_g_object_unref0 (action);
#line 2335 "SlideManager.c"
	}
#line 385 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp18_ = spice_slide_manager_get_current_slide (self);
#line 385 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp19_ = _tmp18_;
#line 385 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (_tmp19_ != NULL) {
#line 2343 "SlideManager.c"
		gint index = 0;
		GeeArrayList* _tmp20_;
		SpiceSlide* _tmp21_;
		SpiceSlide* _tmp22_;
		GeeArrayList* _tmp23_;
		SpiceSlide* _tmp24_;
#line 386 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp20_ = self->priv->_slides;
#line 386 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp21_ = spice_slide_manager_get_current_slide (self);
#line 386 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp22_ = _tmp21_;
#line 386 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		index = gee_abstract_list_index_of ((GeeAbstractList*) _tmp20_, _tmp22_);
#line 387 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp23_ = self->priv->_slides;
#line 387 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp24_ = _data2_->slide;
#line 387 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		gee_abstract_list_insert ((GeeAbstractList*) _tmp23_, index + 1, _tmp24_);
#line 2364 "SlideManager.c"
	} else {
		GeeArrayList* _tmp25_;
		SpiceSlide* _tmp26_;
#line 389 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp25_ = self->priv->_slides;
#line 389 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp26_ = _data2_->slide;
#line 389 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp26_);
#line 2374 "SlideManager.c"
	}
#line 392 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp27_ = self->priv->_slideshow;
#line 392 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp28_ = _data2_->slide;
#line 392 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp29_ = _tmp28_->canvas;
#line 392 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp29_);
#line 393 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp30_ = self->priv->_slideshow;
#line 393 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp30_);
#line 395 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp31_ = _data2_->slide;
#line 395 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_signal_emit (self, spice_slide_manager_signals[SPICE_SLIDE_MANAGER_NEW_SLIDE_CREATED_SIGNAL], 0, _tmp31_);
#line 397 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (undoable_action) {
#line 2394 "SlideManager.c"
		SpiceSlide* _tmp32_;
#line 398 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp32_ = _data2_->slide;
#line 398 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_manager_set_current_slide (self, _tmp32_);
#line 2400 "SlideManager.c"
	}
#line 401 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp33_ = _data2_->slide;
#line 401 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_signal_connect_data (_tmp33_, "visible-changed", (GCallback) ___lambda27__spice_slide_visible_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 417 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp34_ = _data2_->slide;
#line 417 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp35_ = _g_object_ref0 (_tmp34_);
#line 417 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	result = _tmp35_;
#line 417 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	block2_data_unref (_data2_);
#line 417 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_data2_ = NULL;
#line 417 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return result;
#line 2418 "SlideManager.c"
}

SpiceCanvasItem*
spice_slide_manager_request_new_item (SpiceSlideManager* self,
                                      SpiceCanvasItemType type)
{
	SpiceCanvasItem* item = NULL;
	SpiceCanvasItem* _tmp17_;
	SpiceCanvasItem* result;
#line 420 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 421 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	item = NULL;
#line 423 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (type == SPICE_CANVAS_ITEM_TYPE_TEXT) {
#line 2434 "SlideManager.c"
		SpiceSlide* _tmp0_;
		SpiceSlide* _tmp1_;
		SpiceCanvas* _tmp2_;
		SpiceTextItem* _tmp3_;
#line 424 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp0_ = spice_slide_manager_get_current_slide (self);
#line 424 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp1_ = _tmp0_;
#line 424 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp2_ = _tmp1_->canvas;
#line 424 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp3_ = spice_text_item_new (_tmp2_, NULL);
#line 424 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		g_object_ref_sink (_tmp3_);
#line 424 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_g_object_unref0 (item);
#line 424 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		item = (SpiceCanvasItem*) _tmp3_;
#line 2453 "SlideManager.c"
	} else {
#line 425 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		if (type == SPICE_CANVAS_ITEM_TYPE_IMAGE) {
#line 2457 "SlideManager.c"
			GFile* file = NULL;
			GFile* _tmp4_;
			gboolean _tmp5_ = FALSE;
			GFile* _tmp6_;
#line 426 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp4_ = spice_services_file_manager_open_image ();
#line 426 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			file = _tmp4_;
#line 427 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp6_ = file;
#line 427 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (_tmp6_ != NULL) {
#line 2470 "SlideManager.c"
				GFile* _tmp7_;
#line 427 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp7_ = file;
#line 427 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp5_ = g_file_query_exists (_tmp7_, NULL);
#line 2476 "SlideManager.c"
			} else {
#line 427 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp5_ = FALSE;
#line 2480 "SlideManager.c"
			}
#line 427 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (_tmp5_) {
#line 2484 "SlideManager.c"
				SpiceSlide* _tmp8_;
				SpiceSlide* _tmp9_;
				SpiceCanvas* _tmp10_;
				GFile* _tmp11_;
				SpiceImageItem* _tmp12_;
#line 428 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp8_ = spice_slide_manager_get_current_slide (self);
#line 428 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp9_ = _tmp8_;
#line 428 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp10_ = _tmp9_->canvas;
#line 428 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp11_ = file;
#line 428 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp12_ = spice_image_item_new_from_file (_tmp10_, _tmp11_);
#line 428 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				g_object_ref_sink (_tmp12_);
#line 428 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_g_object_unref0 (item);
#line 428 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				item = (SpiceCanvasItem*) _tmp12_;
#line 2506 "SlideManager.c"
			}
#line 425 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_g_object_unref0 (file);
#line 2510 "SlideManager.c"
		} else {
#line 430 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			if (type == SPICE_CANVAS_ITEM_TYPE_SHAPE) {
#line 2514 "SlideManager.c"
				SpiceSlide* _tmp13_;
				SpiceSlide* _tmp14_;
				SpiceCanvas* _tmp15_;
				SpiceColorItem* _tmp16_;
#line 431 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp13_ = spice_slide_manager_get_current_slide (self);
#line 431 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp14_ = _tmp13_;
#line 431 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp15_ = _tmp14_->canvas;
#line 431 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_tmp16_ = spice_color_item_new (_tmp15_, NULL);
#line 431 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				g_object_ref_sink (_tmp16_);
#line 431 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				_g_object_unref0 (item);
#line 431 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
				item = (SpiceCanvasItem*) _tmp16_;
#line 2533 "SlideManager.c"
			}
		}
	}
#line 434 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp17_ = item;
#line 434 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (_tmp17_ != NULL) {
#line 2541 "SlideManager.c"
		SpiceSlide* _tmp18_;
		SpiceSlide* _tmp19_;
		SpiceCanvas* _tmp20_;
		SpiceCanvasItem* _tmp21_;
		SpiceCanvasItem* _tmp22_;
		SpiceCanvasItem* _tmp23_;
#line 435 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp18_ = spice_slide_manager_get_current_slide (self);
#line 435 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp19_ = _tmp18_;
#line 435 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp20_ = _tmp19_->canvas;
#line 435 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp21_ = item;
#line 435 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp22_ = spice_canvas_add_item (_tmp20_, _tmp21_, TRUE);
#line 435 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp23_ = _tmp22_;
#line 435 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_g_object_unref0 (_tmp23_);
#line 2562 "SlideManager.c"
	}
#line 438 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	result = item;
#line 438 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return result;
#line 2568 "SlideManager.c"
}

void
spice_slide_manager_jump_to_checkpoint (SpiceSlideManager* self)
{
	SpiceWindow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	SpiceSlide* _tmp3_;
#line 442 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (self != NULL);
#line 443 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = self->priv->_window;
#line 443 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp1_ = spice_window_get_is_presenting (_tmp0_);
#line 443 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp2_ = _tmp1_;
#line 443 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (!_tmp2_) {
#line 443 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		return;
#line 2590 "SlideManager.c"
	}
#line 445 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp3_ = self->checkpoint;
#line 445 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (_tmp3_ != NULL) {
#line 2596 "SlideManager.c"
		SpiceSlide* temp = NULL;
		SpiceSlide* _tmp4_;
		SpiceSlide* _tmp5_;
		SpiceSlide* _tmp6_;
		SpiceSlide* _tmp7_;
		SpiceSlide* _tmp8_;
		SpiceSlide* _tmp9_;
#line 446 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp4_ = self->checkpoint;
#line 446 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 446 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		temp = _tmp5_;
#line 447 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp6_ = spice_slide_manager_get_current_slide (self);
#line 447 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp7_ = _tmp6_;
#line 447 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 447 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_g_object_unref0 (self->checkpoint);
#line 447 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		self->checkpoint = _tmp8_;
#line 448 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp9_ = temp;
#line 448 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_manager_set_current_slide (self, _tmp9_);
#line 445 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_g_object_unref0 (temp);
#line 2626 "SlideManager.c"
	}
}

void
spice_slide_manager_set_checkpoint (SpiceSlideManager* self)
{
	SpiceWindow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	SpiceSlide* _tmp3_;
	SpiceSlide* _tmp4_;
	SpiceSlide* _tmp5_;
#line 452 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (self != NULL);
#line 453 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = self->priv->_window;
#line 453 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp1_ = spice_window_get_is_presenting (_tmp0_);
#line 453 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp2_ = _tmp1_;
#line 453 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (!_tmp2_) {
#line 453 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		return;
#line 2651 "SlideManager.c"
	}
#line 455 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp3_ = spice_slide_manager_get_current_slide (self);
#line 455 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp4_ = _tmp3_;
#line 455 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 455 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (self->checkpoint);
#line 455 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	self->checkpoint = _tmp5_;
#line 2663 "SlideManager.c"
}

void
spice_slide_manager_end_presentation (SpiceSlideManager* self)
{
	SpiceSlide* _tmp0_;
	SpiceSlide* _tmp1_;
	SpiceSlide* _tmp2_;
#line 458 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (self != NULL);
#line 459 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = spice_slide_manager_get_current_slide (self);
#line 459 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp1_ = _tmp0_;
#line 459 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp2_ = self->end_presentation_slide;
#line 459 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (_tmp1_ == _tmp2_) {
#line 2682 "SlideManager.c"
		SpiceSlide* _tmp3_;
		SpiceSlide* _tmp4_;
		SpiceSlide* _tmp5_;
		SpiceSlide* _tmp6_;
#line 460 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp3_ = spice_slide_manager_get_current_slide (self);
#line 460 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp4_ = _tmp3_;
#line 460 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp5_ = spice_slide_manager_get_previous_slide (self, _tmp4_);
#line 460 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp6_ = _tmp5_;
#line 460 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_manager_set_current_slide (self, _tmp6_);
#line 460 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_g_object_unref0 (_tmp6_);
#line 2699 "SlideManager.c"
	}
}

void
spice_slide_manager_move_up_request (SpiceSlideManager* self)
{
	SpiceCanvasItem* _tmp0_;
	SpiceCanvasItem* _tmp1_;
#line 464 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (self != NULL);
#line 465 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = spice_slide_manager_get_current_item (self);
#line 465 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp1_ = _tmp0_;
#line 465 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (_tmp1_ != NULL) {
#line 2716 "SlideManager.c"
		SpiceSlide* _tmp2_;
		SpiceSlide* _tmp3_;
		SpiceCanvas* _tmp4_;
		SpiceCanvasItem* _tmp5_;
		SpiceCanvasItem* _tmp6_;
#line 466 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp2_ = spice_slide_manager_get_current_slide (self);
#line 466 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp3_ = _tmp2_;
#line 466 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp4_ = _tmp3_->canvas;
#line 466 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp5_ = spice_slide_manager_get_current_item (self);
#line 466 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp6_ = _tmp5_;
#line 466 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_canvas_move_up (_tmp4_, _tmp6_, TRUE);
#line 2734 "SlideManager.c"
	} else {
		SpiceSlide* _tmp7_;
		SpiceSlide* _tmp8_;
#line 468 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp7_ = spice_slide_manager_get_current_slide (self);
#line 468 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp8_ = _tmp7_;
#line 468 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_manager_move_up (self, _tmp8_);
#line 2744 "SlideManager.c"
	}
}

void
spice_slide_manager_move_down_request (SpiceSlideManager* self)
{
	SpiceCanvasItem* _tmp0_;
	SpiceCanvasItem* _tmp1_;
#line 472 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (self != NULL);
#line 473 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = spice_slide_manager_get_current_item (self);
#line 473 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp1_ = _tmp0_;
#line 473 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (_tmp1_ != NULL) {
#line 2761 "SlideManager.c"
		SpiceSlide* _tmp2_;
		SpiceSlide* _tmp3_;
		SpiceCanvas* _tmp4_;
		SpiceCanvasItem* _tmp5_;
		SpiceCanvasItem* _tmp6_;
#line 474 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp2_ = spice_slide_manager_get_current_slide (self);
#line 474 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp3_ = _tmp2_;
#line 474 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp4_ = _tmp3_->canvas;
#line 474 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp5_ = spice_slide_manager_get_current_item (self);
#line 474 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp6_ = _tmp5_;
#line 474 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_canvas_move_down (_tmp4_, _tmp6_, TRUE);
#line 2779 "SlideManager.c"
	} else {
		SpiceSlide* _tmp7_;
		SpiceSlide* _tmp8_;
#line 476 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp7_ = spice_slide_manager_get_current_slide (self);
#line 476 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp8_ = _tmp7_;
#line 476 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_manager_move_down (self, _tmp8_);
#line 2789 "SlideManager.c"
	}
}

SpiceWindow*
spice_slide_manager_get_window (SpiceSlideManager* self)
{
	SpiceWindow* result;
	SpiceWindow* _tmp0_;
#line 23 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 23 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = self->priv->_window;
#line 23 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	result = _tmp0_;
#line 23 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return result;
#line 2806 "SlideManager.c"
}

static void
spice_slide_manager_set_window (SpiceSlideManager* self,
                                SpiceWindow* value)
{
	SpiceWindow* old_value;
#line 23 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (self != NULL);
#line 23 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	old_value = spice_slide_manager_get_window (self);
#line 23 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (old_value != value) {
#line 23 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		self->priv->_window = value;
#line 23 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_slide_manager_properties[SPICE_SLIDE_MANAGER_WINDOW_PROPERTY]);
#line 2824 "SlideManager.c"
	}
}

GtkStack*
spice_slide_manager_get_slideshow (SpiceSlideManager* self)
{
	GtkStack* result;
	GtkStack* _tmp0_;
#line 34 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 34 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = self->priv->_slideshow;
#line 34 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	result = _tmp0_;
#line 34 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return result;
#line 2841 "SlideManager.c"
}

static void
spice_slide_manager_set_slideshow (SpiceSlideManager* self,
                                   GtkStack* value)
{
	GtkStack* old_value;
#line 34 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (self != NULL);
#line 34 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	old_value = spice_slide_manager_get_slideshow (self);
#line 34 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (old_value != value) {
#line 2855 "SlideManager.c"
		GtkStack* _tmp0_;
#line 34 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 34 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_g_object_unref0 (self->priv->_slideshow);
#line 34 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		self->priv->_slideshow = _tmp0_;
#line 34 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_slide_manager_properties[SPICE_SLIDE_MANAGER_SLIDESHOW_PROPERTY]);
#line 2865 "SlideManager.c"
	}
}

GeeArrayList*
spice_slide_manager_get_slides (SpiceSlideManager* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
#line 35 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 35 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = self->priv->_slides;
#line 35 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	result = _tmp0_;
#line 35 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return result;
#line 2882 "SlideManager.c"
}

static void
spice_slide_manager_set_slides (SpiceSlideManager* self,
                                GeeArrayList* value)
{
	GeeArrayList* old_value;
#line 35 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (self != NULL);
#line 35 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	old_value = spice_slide_manager_get_slides (self);
#line 35 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (old_value != value) {
#line 2896 "SlideManager.c"
		GeeArrayList* _tmp0_;
#line 35 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 35 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_g_object_unref0 (self->priv->_slides);
#line 35 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		self->priv->_slides = _tmp0_;
#line 35 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_slide_manager_properties[SPICE_SLIDE_MANAGER_SLIDES_PROPERTY]);
#line 2906 "SlideManager.c"
	}
}

SpiceCanvasItem*
spice_slide_manager_get_current_item (SpiceSlideManager* self)
{
	SpiceCanvasItem* result;
	SpiceCanvasItem* _tmp0_;
#line 44 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 44 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = self->priv->current_item_;
#line 44 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	result = _tmp0_;
#line 44 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return result;
#line 2923 "SlideManager.c"
}

void
spice_slide_manager_set_current_item (SpiceSlideManager* self,
                                      SpiceCanvasItem* value)
{
	SpiceCanvasItem* _tmp0_;
#line 45 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (self != NULL);
#line 46 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = _g_object_ref0 (value);
#line 46 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (self->priv->current_item_);
#line 46 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	self->priv->current_item_ = _tmp0_;
#line 47 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_signal_emit (self, spice_slide_manager_signals[SPICE_SLIDE_MANAGER_ITEM_CLICKED_SIGNAL], 0, value);
#line 45 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_object_notify_by_pspec ((GObject *) self, spice_slide_manager_properties[SPICE_SLIDE_MANAGER_CURRENT_ITEM_PROPERTY]);
#line 2943 "SlideManager.c"
}

SpiceSlide*
spice_slide_manager_get_preview_slide (SpiceSlideManager* self)
{
	SpiceSlide* result;
	gboolean _tmp0_ = FALSE;
	SpiceSlide* _tmp1_;
	SpiceSlide* _tmp5_;
#line 53 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 54 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp1_ = self->preview_slide_;
#line 54 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (_tmp1_ == NULL) {
#line 54 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp0_ = TRUE;
#line 2961 "SlideManager.c"
	} else {
		SpiceSlide* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 54 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp2_ = self->preview_slide_;
#line 54 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp3_ = spice_slide_get_visible (_tmp2_);
#line 54 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp4_ = _tmp3_;
#line 54 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp0_ = _tmp4_ == FALSE;
#line 2974 "SlideManager.c"
	}
#line 54 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (_tmp0_) {
#line 55 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		result = NULL;
#line 55 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		return result;
#line 2982 "SlideManager.c"
	}
#line 58 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp5_ = self->preview_slide_;
#line 58 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	result = _tmp5_;
#line 58 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return result;
#line 2990 "SlideManager.c"
}

void
spice_slide_manager_set_preview_slide (SpiceSlideManager* self,
                                       SpiceSlide* value)
{
	SpiceSlide* _tmp0_;
#line 60 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (self != NULL);
#line 61 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = _g_object_ref0 (value);
#line 61 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (self->preview_slide_);
#line 61 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	self->preview_slide_ = _tmp0_;
#line 60 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_object_notify_by_pspec ((GObject *) self, spice_slide_manager_properties[SPICE_SLIDE_MANAGER_PREVIEW_SLIDE_PROPERTY]);
#line 3008 "SlideManager.c"
}

SpiceSlide*
spice_slide_manager_get_current_slide (SpiceSlideManager* self)
{
	SpiceSlide* result;
	SpiceSlide* _tmp0_;
#line 66 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 66 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = self->priv->slide_;
#line 66 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	result = _tmp0_;
#line 66 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return result;
#line 3024 "SlideManager.c"
}

static gboolean
_spice_slide_manager_current_slide____lambda17_ (SpiceSlideManager* self)
{
	SpiceSlide* next_slide = NULL;
	SpiceSlide* _tmp0_;
	SpiceSlide* _tmp1_;
	SpiceSlide* _tmp2_;
	SpiceSlide* _tmp3_;
	gboolean result;
#line 82 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = spice_slide_manager_get_current_slide (self);
#line 82 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp1_ = _tmp0_;
#line 82 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp2_ = spice_slide_manager_get_next_slide (self, _tmp1_);
#line 82 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	next_slide = _tmp2_;
#line 83 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp3_ = next_slide;
#line 83 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (_tmp3_ != NULL) {
#line 3048 "SlideManager.c"
		SpiceSlide* _tmp4_;
#line 84 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp4_ = next_slide;
#line 84 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_load_slide (_tmp4_);
#line 3054 "SlideManager.c"
	}
#line 86 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	result = FALSE;
#line 86 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (next_slide);
#line 86 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return result;
#line 3062 "SlideManager.c"
}

static gboolean
__spice_slide_manager_current_slide____lambda17__gsource_func (gpointer self)
{
	gboolean result;
	result = _spice_slide_manager_current_slide____lambda17_ ((SpiceSlideManager*) self);
#line 81 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	return result;
#line 3072 "SlideManager.c"
}

void
spice_slide_manager_set_current_slide (SpiceSlideManager* self,
                                       SpiceSlide* value)
{
	SpiceSlide* _tmp0_;
	gboolean _tmp3_ = FALSE;
	SpiceWindow* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	SpiceWindow* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GeeArrayList* _tmp20_;
#line 67 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_return_if_fail (self != NULL);
#line 68 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp0_ = self->priv->slide_;
#line 68 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (_tmp0_ != NULL) {
#line 3094 "SlideManager.c"
		SpiceSlide* _tmp1_;
		SpiceCanvas* _tmp2_;
#line 69 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp1_ = self->priv->slide_;
#line 69 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp2_ = _tmp1_->canvas;
#line 69 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_canvas_unselect_all (_tmp2_, TRUE);
#line 3103 "SlideManager.c"
	}
#line 72 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp4_ = self->priv->_window;
#line 72 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp5_ = spice_window_get_is_presenting (_tmp4_);
#line 72 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp6_ = _tmp5_;
#line 72 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (!_tmp6_) {
#line 3113 "SlideManager.c"
		SpiceSlide* _tmp7_;
		SpiceSlide* _tmp8_;
#line 72 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp7_ = spice_slide_manager_get_current_slide (self);
#line 72 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp8_ = _tmp7_;
#line 72 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp3_ = _tmp8_ != NULL;
#line 3122 "SlideManager.c"
	} else {
#line 72 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp3_ = FALSE;
#line 3126 "SlideManager.c"
	}
#line 72 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (_tmp3_) {
#line 3130 "SlideManager.c"
		SpiceSlide* _tmp9_;
		SpiceSlide* _tmp10_;
#line 73 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp9_ = spice_slide_manager_get_current_slide (self);
#line 73 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp10_ = _tmp9_;
#line 73 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_reload_preview_data (_tmp10_);
#line 3139 "SlideManager.c"
	}
#line 76 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp11_ = self->priv->_window;
#line 76 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp12_ = spice_window_get_is_presenting (_tmp11_);
#line 76 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp13_ = _tmp12_;
#line 76 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (_tmp13_) {
#line 3149 "SlideManager.c"
		GtkStack* _tmp14_;
		GtkStack* _tmp15_;
		GtkStackTransitionType _tmp16_;
		GtkStackTransitionType _tmp17_;
#line 77 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp14_ = self->priv->_slideshow;
#line 77 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		gtk_stack_set_transition_duration (_tmp14_, (guint) 600);
#line 78 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp15_ = self->priv->_slideshow;
#line 78 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp16_ = spice_slide_get_transition (value);
#line 78 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp17_ = _tmp16_;
#line 78 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		gtk_stack_set_transition_type (_tmp15_, (GtkStackTransitionType) _tmp17_);
#line 81 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __spice_slide_manager_current_slide____lambda17__gsource_func, g_object_ref (self), g_object_unref);
#line 3168 "SlideManager.c"
	} else {
		GtkStack* _tmp18_;
		GtkStack* _tmp19_;
#line 89 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp18_ = self->priv->_slideshow;
#line 89 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		gtk_stack_set_transition_type (_tmp18_, GTK_STACK_TRANSITION_TYPE_NONE);
#line 90 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp19_ = self->priv->_slideshow;
#line 90 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		gtk_stack_set_transition_duration (_tmp19_, (guint) 0);
#line 3180 "SlideManager.c"
	}
#line 93 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_tmp20_ = self->priv->_slides;
#line 93 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp20_, value)) {
#line 3186 "SlideManager.c"
		SpiceSlide* _tmp21_;
		GtkStack* _tmp22_;
		SpiceCanvas* _tmp23_;
#line 94 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp21_ = _g_object_ref0 (value);
#line 94 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_g_object_unref0 (self->priv->slide_);
#line 94 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		self->priv->slide_ = _tmp21_;
#line 95 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_manager_set_current_item (self, NULL);
#line 96 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_load_slide (value);
#line 97 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp22_ = self->priv->_slideshow;
#line 97 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp23_ = value->canvas;
#line 97 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		gtk_stack_set_visible_child (_tmp22_, (GtkWidget*) _tmp23_);
#line 98 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		g_signal_emit (self, spice_slide_manager_signals[SPICE_SLIDE_MANAGER_CURRENT_SLIDE_CHANGED_SIGNAL], 0, value);
#line 3208 "SlideManager.c"
	} else {
		SpiceSlide* _tmp24_;
#line 99 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		_tmp24_ = self->end_presentation_slide;
#line 99 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		if (value == _tmp24_) {
#line 3215 "SlideManager.c"
			GtkStack* _tmp25_;
			SpiceCanvas* _tmp26_;
			SpiceSlide* _tmp27_;
#line 100 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			spice_slide_load_slide (value);
#line 101 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp25_ = self->priv->_slideshow;
#line 101 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp26_ = value->canvas;
#line 101 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			gtk_stack_set_visible_child (_tmp25_, (GtkWidget*) _tmp26_);
#line 102 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			g_signal_emit (self, spice_slide_manager_signals[SPICE_SLIDE_MANAGER_CURRENT_SLIDE_CHANGED_SIGNAL], 0, value);
#line 103 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_tmp27_ = _g_object_ref0 (value);
#line 103 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			_g_object_unref0 (self->priv->slide_);
#line 103 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
			self->priv->slide_ = _tmp27_;
#line 3235 "SlideManager.c"
		}
	}
#line 67 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_object_notify_by_pspec ((GObject *) self, spice_slide_manager_properties[SPICE_SLIDE_MANAGER_CURRENT_SLIDE_PROPERTY]);
#line 3240 "SlideManager.c"
}

static void
spice_slide_manager_class_init (SpiceSlideManagerClass * klass,
                                gpointer klass_data)
{
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	spice_slide_manager_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_type_class_adjust_private_offset (klass, &SpiceSlideManager_private_offset);
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_slide_manager_get_property;
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_slide_manager_set_property;
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_slide_manager_finalize;
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SLIDE_MANAGER_WINDOW_PROPERTY, spice_slide_manager_properties[SPICE_SLIDE_MANAGER_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", SPICE_TYPE_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SLIDE_MANAGER_SLIDESHOW_PROPERTY, spice_slide_manager_properties[SPICE_SLIDE_MANAGER_SLIDESHOW_PROPERTY] = g_param_spec_object ("slideshow", "slideshow", "slideshow", gtk_stack_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SLIDE_MANAGER_SLIDES_PROPERTY, spice_slide_manager_properties[SPICE_SLIDE_MANAGER_SLIDES_PROPERTY] = g_param_spec_object ("slides", "slides", "slides", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SLIDE_MANAGER_CURRENT_ITEM_PROPERTY, spice_slide_manager_properties[SPICE_SLIDE_MANAGER_CURRENT_ITEM_PROPERTY] = g_param_spec_object ("current-item", "current-item", "current-item", SPICE_TYPE_CANVAS_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SLIDE_MANAGER_PREVIEW_SLIDE_PROPERTY, spice_slide_manager_properties[SPICE_SLIDE_MANAGER_PREVIEW_SLIDE_PROPERTY] = g_param_spec_object ("preview-slide", "preview-slide", "preview-slide", SPICE_TYPE_SLIDE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SLIDE_MANAGER_CURRENT_SLIDE_PROPERTY, spice_slide_manager_properties[SPICE_SLIDE_MANAGER_CURRENT_SLIDE_PROPERTY] = g_param_spec_object ("current-slide", "current-slide", "current-slide", SPICE_TYPE_SLIDE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	spice_slide_manager_signals[SPICE_SLIDE_MANAGER_ASPECT_RATIO_CHANGED_SIGNAL] = g_signal_new ("aspect-ratio-changed", SPICE_TYPE_SLIDE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, SPICE_TYPE_ASPECT_RATIO);
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	spice_slide_manager_signals[SPICE_SLIDE_MANAGER_RESETED_SIGNAL] = g_signal_new ("reseted", SPICE_TYPE_SLIDE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	spice_slide_manager_signals[SPICE_SLIDE_MANAGER_CURRENT_SLIDE_CHANGED_SIGNAL] = g_signal_new ("current-slide-changed", SPICE_TYPE_SLIDE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SPICE_TYPE_SLIDE);
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	spice_slide_manager_signals[SPICE_SLIDE_MANAGER_ITEM_CLICKED_SIGNAL] = g_signal_new ("item-clicked", SPICE_TYPE_SLIDE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SPICE_TYPE_CANVAS_ITEM);
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	spice_slide_manager_signals[SPICE_SLIDE_MANAGER_NEW_SLIDE_CREATED_SIGNAL] = g_signal_new ("new-slide-created", SPICE_TYPE_SLIDE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SPICE_TYPE_SLIDE);
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	spice_slide_manager_signals[SPICE_SLIDE_MANAGER_SLIDES_SORTED_SIGNAL] = g_signal_new ("slides-sorted", SPICE_TYPE_SLIDE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 3281 "SlideManager.c"
}

static void
spice_slide_manager_instance_init (SpiceSlideManager * self,
                                   gpointer klass)
{
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	self->priv = spice_slide_manager_get_instance_private (self);
#line 36 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	self->making_new_slide = FALSE;
#line 38 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	self->priv->slide_ = NULL;
#line 39 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	self->priv->current_item_ = NULL;
#line 51 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	self->preview_slide_ = NULL;
#line 341 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	self->priv->propagating_ratio = FALSE;
#line 441 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	self->checkpoint = NULL;
#line 3302 "SlideManager.c"
}

static void
spice_slide_manager_finalize (GObject * obj)
{
	SpiceSlideManager * self;
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManager);
#line 34 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (self->priv->_slideshow);
#line 35 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (self->priv->_slides);
#line 38 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (self->priv->slide_);
#line 39 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (self->priv->current_item_);
#line 41 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (self->end_presentation_slide);
#line 51 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (self->preview_slide_);
#line 441 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	_g_object_unref0 (self->checkpoint);
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	G_OBJECT_CLASS (spice_slide_manager_parent_class)->finalize (obj);
#line 3327 "SlideManager.c"
}

static GType
spice_slide_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceSlideManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_slide_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceSlideManager), 0, (GInstanceInitFunc) spice_slide_manager_instance_init, NULL };
	GType spice_slide_manager_type_id;
	spice_slide_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "SpiceSlideManager", &g_define_type_info, 0);
	SpiceSlideManager_private_offset = g_type_add_instance_private (spice_slide_manager_type_id, sizeof (SpiceSlideManagerPrivate));
	return spice_slide_manager_type_id;
}

GType
spice_slide_manager_get_type (void)
{
	static volatile gsize spice_slide_manager_type_id__once = 0;
	if (g_once_init_enter (&spice_slide_manager_type_id__once)) {
		GType spice_slide_manager_type_id;
		spice_slide_manager_type_id = spice_slide_manager_get_type_once ();
		g_once_init_leave (&spice_slide_manager_type_id__once, spice_slide_manager_type_id);
	}
	return spice_slide_manager_type_id__once;
}

static void
_vala_spice_slide_manager_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	SpiceSlideManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManager);
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		case SPICE_SLIDE_MANAGER_WINDOW_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		g_value_set_object (value, spice_slide_manager_get_window (self));
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		case SPICE_SLIDE_MANAGER_SLIDESHOW_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		g_value_set_object (value, spice_slide_manager_get_slideshow (self));
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		case SPICE_SLIDE_MANAGER_SLIDES_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		g_value_set_object (value, spice_slide_manager_get_slides (self));
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		case SPICE_SLIDE_MANAGER_CURRENT_ITEM_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		g_value_set_object (value, spice_slide_manager_get_current_item (self));
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		case SPICE_SLIDE_MANAGER_PREVIEW_SLIDE_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		g_value_set_object (value, spice_slide_manager_get_preview_slide (self));
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		case SPICE_SLIDE_MANAGER_CURRENT_SLIDE_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		g_value_set_object (value, spice_slide_manager_get_current_slide (self));
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		break;
#line 3398 "SlideManager.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		break;
#line 3404 "SlideManager.c"
	}
}

static void
_vala_spice_slide_manager_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	SpiceSlideManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManager);
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		case SPICE_SLIDE_MANAGER_WINDOW_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_manager_set_window (self, g_value_get_object (value));
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		case SPICE_SLIDE_MANAGER_SLIDESHOW_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_manager_set_slideshow (self, g_value_get_object (value));
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		case SPICE_SLIDE_MANAGER_SLIDES_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_manager_set_slides (self, g_value_get_object (value));
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		case SPICE_SLIDE_MANAGER_CURRENT_ITEM_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_manager_set_current_item (self, g_value_get_object (value));
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		case SPICE_SLIDE_MANAGER_PREVIEW_SLIDE_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_manager_set_preview_slide (self, g_value_get_object (value));
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		case SPICE_SLIDE_MANAGER_CURRENT_SLIDE_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		spice_slide_manager_set_current_slide (self, g_value_get_object (value));
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		break;
#line 3454 "SlideManager.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Services/SlideManager.vala"
		break;
#line 3460 "SlideManager.c"
	}
}

