/* Canvas.c generated by valac 0.56.18, the Vala compiler
 * generated from Canvas.vala, do not modify */

/*
* Copyright (c) 2016 Felipe Escoto (https://github.com/Philip-Scott/Spice-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <json-glib/json-glib.h>
#include <granite.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <gio/gio.h>

#define SPICE_CANVAS_CANVAS_CSS "\n        .view {\n            background: %s;\n        }\n    "
#define SPICE_CANVAS_CANVAS_GRID_PATTERN_CSS "\n" \
"            .pattern {\n" \
"                box-shadow: inset 0 0 0 2px alpha (#fff, 0.05);\n" \
"                background-image: url(\"%s\");\n" \
"                border-radius: 6px;\n" \
"            }\n" \
"        "
#define SPICE_CANVAS_CANVAS_GRID_NO_PATTERN_CSS "\n" \
"            .pattern {\n" \
"                background-image: none;\n" \
"            }\n" \
"        "
#define SPICE_WIDGETS_CANVAS_TOOLBAR_PATTERNS_DIR "resource:///com/github/philip-scott/spice-up/patterns/"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SPICE_TYPE_CANVAS (spice_canvas_get_type ())
#define SPICE_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS, SpiceCanvas))
#define SPICE_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS, SpiceCanvasClass))
#define SPICE_IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS))
#define SPICE_IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS))
#define SPICE_CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS, SpiceCanvasClass))

typedef struct _SpiceCanvas SpiceCanvas;
typedef struct _SpiceCanvasClass SpiceCanvasClass;
typedef struct _SpiceCanvasPrivate SpiceCanvasPrivate;

#define SPICE_TYPE_WINDOW (spice_window_get_type ())
#define SPICE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_WINDOW, SpiceWindow))
#define SPICE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_WINDOW, SpiceWindowClass))
#define SPICE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_WINDOW))
#define SPICE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_WINDOW))
#define SPICE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_WINDOW, SpiceWindowClass))

typedef struct _SpiceWindow SpiceWindow;
typedef struct _SpiceWindowClass SpiceWindowClass;

#define SPICE_CANVAS_TYPE_CANVAS_GRID (spice_canvas_canvas_grid_get_type ())
#define SPICE_CANVAS_CANVAS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGrid))
#define SPICE_CANVAS_CANVAS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGridClass))
#define SPICE_CANVAS_IS_CANVAS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID))
#define SPICE_CANVAS_IS_CANVAS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_CANVAS_TYPE_CANVAS_GRID))
#define SPICE_CANVAS_CANVAS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGridClass))

typedef struct _SpiceCanvasCanvasGrid SpiceCanvasCanvasGrid;
typedef struct _SpiceCanvasCanvasGridClass SpiceCanvasCanvasGridClass;
enum  {
	SPICE_CANVAS_0_PROPERTY,
	SPICE_CANVAS_CURRENT_RATIO_PROPERTY,
	SPICE_CANVAS_BACKGROUND_COLOR_PROPERTY,
	SPICE_CANVAS_BACKGROUND_PATTERN_PROPERTY,
	SPICE_CANVAS_NUM_PROPERTIES
};
static GParamSpec* spice_canvas_properties[SPICE_CANVAS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SPICE_TYPE_CANVAS_ITEM (spice_canvas_item_get_type ())
#define SPICE_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem))
#define SPICE_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))
#define SPICE_IS_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_IS_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_CANVAS_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))

typedef struct _SpiceCanvasItem SpiceCanvasItem;
typedef struct _SpiceCanvasItemClass SpiceCanvasItemClass;
typedef struct _Block11Data Block11Data;

#define SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION (spice_services_history_manager_history_action_get_type ())
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryAction))
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryActionClass))
#define SPICE_SERVICES_HISTORY_MANAGER_IS_HISTORY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION))
#define SPICE_SERVICES_HISTORY_MANAGER_IS_HISTORY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION))
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryActionClass))

typedef struct _SpiceServicesHistoryManagerHistoryAction SpiceServicesHistoryManagerHistoryAction;
typedef struct _SpiceServicesHistoryManagerHistoryActionClass SpiceServicesHistoryManagerHistoryActionClass;

#define SPICE_SERVICES_TYPE_HISTORY_MANAGER (spice_services_history_manager_get_type ())
#define SPICE_SERVICES_HISTORY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManager))
#define SPICE_SERVICES_HISTORY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManagerClass))
#define SPICE_SERVICES_IS_HISTORY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER))
#define SPICE_SERVICES_IS_HISTORY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_TYPE_HISTORY_MANAGER))
#define SPICE_SERVICES_HISTORY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManagerClass))

typedef struct _SpiceServicesHistoryManager SpiceServicesHistoryManager;
typedef struct _SpiceServicesHistoryManagerClass SpiceServicesHistoryManagerClass;
typedef struct _SpiceCanvasCanvasGridPrivate SpiceCanvasCanvasGridPrivate;
enum  {
	SPICE_CANVAS_CANVAS_GRID_0_PROPERTY,
	SPICE_CANVAS_CANVAS_GRID_NUM_PROPERTIES
};
static GParamSpec* spice_canvas_canvas_grid_properties[SPICE_CANVAS_CANVAS_GRID_NUM_PROPERTIES];
enum  {
	SPICE_CANVAS_REQUEST_DRAW_PREVIEW_SIGNAL,
	SPICE_CANVAS_ITEM_CLICKED_SIGNAL,
	SPICE_CANVAS_RATIO_CHANGED_SIGNAL,
	SPICE_CANVAS_NEXT_SLIDE_SIGNAL,
	SPICE_CANVAS_PREVIOUS_SLIDE_SIGNAL,
	SPICE_CANVAS_NUM_SIGNALS
};
static guint spice_canvas_signals[SPICE_CANVAS_NUM_SIGNALS] = {0};

struct _SpiceCanvas {
	GtkOverlay parent_instance;
	SpiceCanvasPrivate * priv;
	SpiceWindow* window;
	gdouble current_allocated_width;
	gdouble current_allocated_height;
	SpiceCanvasCanvasGrid* grid;
	JsonObject* save_data;
	GraniteDrawingBufferSurface* surface;
};

struct _SpiceCanvasClass {
	GtkOverlayClass parent_class;
};

struct _SpiceCanvasPrivate {
	gdouble _current_ratio;
	gdouble default_x_margin;
	gdouble default_y_margin;
	gchar* _background_color;
	gchar* _background_pattern;
};

struct _Block11Data {
	int _ref_count_;
	SpiceCanvas* self;
	SpiceCanvasItem* canvas_item;
};

struct _SpiceCanvasCanvasGrid {
	GtkEventBox parent_instance;
	SpiceCanvasCanvasGridPrivate * priv;
};

struct _SpiceCanvasCanvasGridClass {
	GtkEventBoxClass parent_class;
};

struct _SpiceCanvasCanvasGridPrivate {
	SpiceCanvas* canvas;
	GtkGrid* grid;
};

static gint SpiceCanvas_private_offset;
static gpointer spice_canvas_parent_class = NULL;
VALA_EXTERN gboolean spice_canvas_drawing_preview;
gboolean spice_canvas_drawing_preview = FALSE;
static gint SpiceCanvasCanvasGrid_private_offset;
static gpointer spice_canvas_canvas_grid_parent_class = NULL;

VALA_EXTERN GType spice_canvas_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvas, g_object_unref)
VALA_EXTERN GType spice_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceWindow, g_object_unref)
VALA_EXTERN GType spice_canvas_canvas_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvasCanvasGrid, g_object_unref)
VALA_EXTERN SpiceCanvas* spice_canvas_new (SpiceWindow* window,
                               JsonObject* save_data);
VALA_EXTERN SpiceCanvas* spice_canvas_construct (GType object_type,
                                     SpiceWindow* window,
                                     JsonObject* save_data);
VALA_EXTERN SpiceCanvasCanvasGrid* spice_canvas_canvas_grid_new (SpiceCanvas* canvas);
VALA_EXTERN SpiceCanvasCanvasGrid* spice_canvas_canvas_grid_construct (GType object_type,
                                                           SpiceCanvas* canvas);
static void spice_canvas_calculate_ratio (SpiceCanvas* self);
VALA_EXTERN void spice_canvas_load_data (SpiceCanvas* self);
VALA_EXTERN void spice_canvas_style (SpiceCanvas* self);
static gboolean spice_canvas_real_get_child_position (GtkOverlay* base,
                                               GtkWidget* widget,
                                               GdkRectangle* allocation);
VALA_EXTERN GType spice_canvas_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvasItem, g_object_unref)
VALA_EXTERN void spice_canvas_item_get_rectangle (SpiceCanvasItem* self,
                                      GdkRectangle * result);
VALA_EXTERN gdouble spice_canvas_get_current_ratio (SpiceCanvas* self);
VALA_EXTERN gint spice_canvas_item_get_delta_x (SpiceCanvasItem* self);
VALA_EXTERN gint spice_canvas_item_get_delta_y (SpiceCanvasItem* self);
VALA_EXTERN void spice_canvas_set_current_ratio (SpiceCanvas* self,
                                     gdouble value);
VALA_EXTERN SpiceCanvasItem* spice_canvas_add_item (SpiceCanvas* self,
                                        SpiceCanvasItem* item,
                                        gboolean undoable_action);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void _gtk_widget_queue_resize_no_redraw_spice_canvas_item_check_position (SpiceCanvasItem* _sender,
                                                                          gpointer self);
static void __lambda18_ (Block11Data* _data11_);
VALA_EXTERN void spice_canvas_unselect_all (SpiceCanvas* self,
                                gboolean reset_item);
static void ___lambda18__spice_canvas_item_clicked (SpiceCanvasItem* _sender,
                                             gpointer self);
static void __lambda19_ (Block11Data* _data11_,
                  gint delta_x,
                  gint delta_y);
VALA_EXTERN gboolean spice_window_get_is_presenting (SpiceWindow* self);
VALA_EXTERN void spice_canvas_item_set_rectangle (SpiceCanvasItem* self,
                                      GdkRectangle * value);
static void ___lambda19__spice_canvas_item_move_item (SpiceCanvasItem* _sender,
                                               gint delta_x,
                                               gint delta_y,
                                               gpointer self);
VALA_EXTERN GType spice_services_history_manager_history_action_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesHistoryManagerHistoryAction, g_object_unref)
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_new_item_changed (GType i_type,
                                                                                                          GBoxedCopyFunc i_dup_func,
                                                                                                          GDestroyNotify i_destroy_func,
                                                                                                          GType t_type,
                                                                                                          GBoxedCopyFunc t_dup_func,
                                                                                                          GDestroyNotify t_destroy_func,
                                                                                                          gconstpointer item,
                                                                                                          const gchar* property);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_construct_item_changed (GType object_type,
                                                                                                                GType i_type,
                                                                                                                GBoxedCopyFunc i_dup_func,
                                                                                                                GDestroyNotify i_destroy_func,
                                                                                                                GType t_type,
                                                                                                                GBoxedCopyFunc t_dup_func,
                                                                                                                GDestroyNotify t_destroy_func,
                                                                                                                gconstpointer item,
                                                                                                                const gchar* property);
VALA_EXTERN GType spice_services_history_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesHistoryManager, g_object_unref)
VALA_EXTERN SpiceServicesHistoryManager* spice_window_get_history_manager (SpiceWindow* self);
VALA_EXTERN void spice_services_history_manager_add_undoable_action (SpiceServicesHistoryManager* self,
                                                         SpiceServicesHistoryManagerHistoryAction* action,
                                                         gboolean force_add);
VALA_EXTERN void spice_canvas_item_unselect (SpiceCanvasItem* self);
VALA_EXTERN void spice_canvas_clear_all (SpiceCanvas* self);
VALA_EXTERN void spice_canvas_move_up (SpiceCanvas* self,
                           SpiceCanvasItem* item_,
                           gboolean add_undo_action);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_new_depth_changed (GType i_type,
                                                                                                           GBoxedCopyFunc i_dup_func,
                                                                                                           GDestroyNotify i_destroy_func,
                                                                                                           GType t_type,
                                                                                                           GBoxedCopyFunc t_dup_func,
                                                                                                           GDestroyNotify t_destroy_func,
                                                                                                           gconstpointer item,
                                                                                                           SpiceCanvas* canvas,
                                                                                                           gboolean moved_up);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_construct_depth_changed (GType object_type,
                                                                                                                 GType i_type,
                                                                                                                 GBoxedCopyFunc i_dup_func,
                                                                                                                 GDestroyNotify i_destroy_func,
                                                                                                                 GType t_type,
                                                                                                                 GBoxedCopyFunc t_dup_func,
                                                                                                                 GDestroyNotify t_destroy_func,
                                                                                                                 gconstpointer item,
                                                                                                                 SpiceCanvas* canvas,
                                                                                                                 gboolean moved_up);
VALA_EXTERN void spice_canvas_move_down (SpiceCanvas* self,
                             SpiceCanvasItem* item_,
                             gboolean add_undo_action);
static gboolean spice_canvas_real_button_press_event (GtkWidget* base,
                                               GdkEventButton* event);
VALA_EXTERN const gchar* spice_canvas_get_background_color (SpiceCanvas* self);
VALA_EXTERN void spice_canvas_set_background_color (SpiceCanvas* self,
                                        const gchar* value);
VALA_EXTERN void spice_canvas_set_background_pattern (SpiceCanvas* self,
                                          const gchar* value);
VALA_EXTERN gchar* spice_canvas_serialise (SpiceCanvas* self);
VALA_EXTERN const gchar* spice_canvas_get_background_pattern (SpiceCanvas* self);
VALA_EXTERN void spice_utils_set_style (GtkWidget* widget,
                            const gchar* css);
VALA_EXTERN void spice_canvas_canvas_grid_style (SpiceCanvasCanvasGrid* self,
                                     const gchar* pattern);
static gboolean spice_canvas_real_draw (GtkWidget* base,
                                 cairo_t* cr);
static gboolean spice_canvas_canvas_grid_real_button_press_event (GtkWidget* base,
                                                           GdkEventButton* event);
static void spice_canvas_canvas_grid_finalize (GObject * obj);
static GType spice_canvas_canvas_grid_get_type_once (void);
static void spice_canvas_finalize (GObject * obj);
static GType spice_canvas_get_type_once (void);
static void _vala_spice_canvas_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_spice_canvas_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static inline gpointer
spice_canvas_get_instance_private (SpiceCanvas* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceCanvas_private_offset);
}

static gpointer
_json_object_ref0 (gpointer self)
{
#line 68 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	return self ? json_object_ref (self) : NULL;
#line 343 "Canvas.c"
}

SpiceCanvas*
spice_canvas_construct (GType object_type,
                        SpiceWindow* window,
                        JsonObject* save_data)
{
	SpiceCanvas * self = NULL;
	GdkEventMask _tmp0_;
	GdkEventMask _tmp1_;
	JsonObject* _tmp2_;
	SpiceCanvasCanvasGrid* _tmp3_;
	GtkStyleContext* _tmp4_;
	SpiceCanvasCanvasGrid* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
#line 65 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_val_if_fail (window != NULL, NULL);
#line 65 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self = (SpiceCanvas*) g_object_new (object_type, NULL);
#line 66 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp0_ = gtk_widget_get_events ((GtkWidget*) self);
#line 66 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp1_ = _tmp0_;
#line 66 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	gtk_widget_set_events ((GtkWidget*) self, _tmp1_ | GDK_BUTTON_PRESS_MASK);
#line 67 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->window = window;
#line 68 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp2_ = _json_object_ref0 (save_data);
#line 68 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_json_object_unref0 (self->save_data);
#line 68 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->save_data = _tmp2_;
#line 70 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp3_ = spice_canvas_canvas_grid_new (self);
#line 70 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_object_ref_sink (_tmp3_);
#line 70 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_g_object_unref0 (self->grid);
#line 70 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->grid = _tmp3_;
#line 71 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, 500, 380);
#line 73 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 73 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	gtk_style_context_add_class (_tmp4_, "canvas");
#line 74 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp5_ = self->grid;
#line 74 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp5_);
#line 78 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp6_ = (GtkLabel*) gtk_label_new ("");
#line 78 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_object_ref_sink (_tmp6_);
#line 78 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp7_ = _tmp6_;
#line 78 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	gtk_overlay_add_overlay ((GtkOverlay*) self, (GtkWidget*) _tmp7_);
#line 78 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_g_object_unref0 (_tmp7_);
#line 80 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	spice_canvas_calculate_ratio (self);
#line 81 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	spice_canvas_load_data (self);
#line 82 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	spice_canvas_style (self);
#line 65 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	return self;
#line 414 "Canvas.c"
}

SpiceCanvas*
spice_canvas_new (SpiceWindow* window,
                  JsonObject* save_data)
{
#line 65 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	return spice_canvas_construct (SPICE_TYPE_CANVAS, window, save_data);
#line 423 "Canvas.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 92 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	return self ? g_object_ref (self) : NULL;
#line 431 "Canvas.c"
}

static gboolean
spice_canvas_real_get_child_position (GtkOverlay* base,
                                      GtkWidget* widget,
                                      GdkRectangle* allocation)
{
	SpiceCanvas * self;
	GdkRectangle _vala_allocation = {0};
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 85 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self = (SpiceCanvas*) base;
#line 85 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 86 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	memset (&_vala_allocation, 0, sizeof (GdkRectangle));
#line 87 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	if (self->current_allocated_width != ((gdouble) gtk_widget_get_allocated_width ((GtkWidget*) self))) {
#line 87 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp0_ = TRUE;
#line 453 "Canvas.c"
	} else {
#line 87 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp0_ = self->current_allocated_height != ((gdouble) gtk_widget_get_allocated_height ((GtkWidget*) self));
#line 457 "Canvas.c"
	}
#line 87 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	if (_tmp0_) {
#line 88 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		spice_canvas_calculate_ratio (self);
#line 463 "Canvas.c"
	}
#line 91 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	if (SPICE_IS_CANVAS_ITEM (widget)) {
#line 467 "Canvas.c"
		SpiceCanvasItem* display_widget = NULL;
		SpiceCanvasItem* _tmp1_;
		GdkRectangle r = {0};
		SpiceCanvasItem* _tmp2_;
		GdkRectangle _tmp3_ = {0};
		GdkRectangle _tmp4_;
		gint w = 0;
		gint h = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		GdkRectangle _tmp7_;
		gdouble _tmp8_;
		gdouble _tmp9_;
		GdkRectangle _tmp10_;
		gdouble _tmp11_;
		gdouble _tmp12_;
		GdkRectangle _tmp13_;
		gdouble _tmp14_;
		gdouble _tmp15_;
		SpiceCanvasItem* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		GdkRectangle _tmp19_;
		gdouble _tmp20_;
		gdouble _tmp21_;
		SpiceCanvasItem* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
#line 92 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (widget, SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem));
#line 92 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		display_widget = _tmp1_;
#line 94 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp2_ = display_widget;
#line 94 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		spice_canvas_item_get_rectangle (_tmp2_, &_tmp3_);
#line 94 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp4_ = _tmp3_;
#line 94 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		r = _tmp4_;
#line 97 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		gtk_widget_get_preferred_width (widget, &_tmp5_, NULL);
#line 97 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		w = _tmp5_;
#line 98 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		gtk_widget_get_preferred_height (widget, &_tmp6_, NULL);
#line 98 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		h = _tmp6_;
#line 100 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp7_ = r;
#line 100 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp8_ = spice_canvas_get_current_ratio (self);
#line 100 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp9_ = _tmp8_;
#line 100 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_vala_allocation.width = (gint) ((((gdouble) _tmp7_.width) * _tmp9_) + 0.5);
#line 101 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp10_ = r;
#line 101 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp11_ = spice_canvas_get_current_ratio (self);
#line 101 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp12_ = _tmp11_;
#line 101 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_vala_allocation.height = (gint) ((((gdouble) _tmp10_.height) * _tmp12_) + 0.5);
#line 102 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp13_ = r;
#line 102 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp14_ = spice_canvas_get_current_ratio (self);
#line 102 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp15_ = _tmp14_;
#line 102 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp16_ = display_widget;
#line 102 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp17_ = spice_canvas_item_get_delta_x (_tmp16_);
#line 102 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp18_ = _tmp17_;
#line 102 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_vala_allocation.x = (gint) ((self->priv->default_x_margin + ((_tmp13_.x * _tmp15_) + 0.5)) + _tmp18_);
#line 103 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp19_ = r;
#line 103 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp20_ = spice_canvas_get_current_ratio (self);
#line 103 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp21_ = _tmp20_;
#line 103 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp22_ = display_widget;
#line 103 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp23_ = spice_canvas_item_get_delta_y (_tmp22_);
#line 103 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp24_ = _tmp23_;
#line 103 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_vala_allocation.y = (gint) ((self->priv->default_y_margin + ((_tmp19_.y * _tmp21_) + 0.5)) + _tmp24_);
#line 105 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		result = TRUE;
#line 105 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_g_object_unref0 (display_widget);
#line 105 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		if (allocation) {
#line 105 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
			*allocation = _vala_allocation;
#line 568 "Canvas.c"
		}
#line 105 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		return result;
#line 572 "Canvas.c"
	}
#line 108 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	result = FALSE;
#line 108 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	if (allocation) {
#line 108 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		*allocation = _vala_allocation;
#line 580 "Canvas.c"
	}
#line 108 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	return result;
#line 584 "Canvas.c"
}

static void
spice_canvas_calculate_ratio (SpiceCanvas* self)
{
	gdouble max_width = 0.0;
	gdouble max_height = 0.0;
	gdouble ratio = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
#line 111 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_if_fail (self != NULL);
#line 112 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	max_width = 1500.0;
#line 112 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	max_height = 1500.0;
#line 114 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->current_allocated_width = (gdouble) gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 115 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->current_allocated_height = (gdouble) gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 117 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	ratio = ((gdouble) self->current_allocated_height) / 1500.0;
#line 118 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	spice_canvas_set_current_ratio (self, ratio - (ratio * 0.016));
#line 120 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp0_ = spice_canvas_get_current_ratio (self);
#line 120 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp1_ = _tmp0_;
#line 120 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->priv->default_x_margin = ((self->current_allocated_width - (max_width * _tmp1_)) / 2.0) + 0.5;
#line 121 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp2_ = spice_canvas_get_current_ratio (self);
#line 121 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp3_ = _tmp2_;
#line 121 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->priv->default_y_margin = ((self->current_allocated_height - (max_height * _tmp3_)) / 2.0) + 0.5;
#line 623 "Canvas.c"
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
#line 124 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_atomic_int_inc (&_data11_->_ref_count_);
#line 124 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	return _data11_;
#line 633 "Canvas.c"
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
#line 124 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
#line 643 "Canvas.c"
		SpiceCanvas* self;
#line 124 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		self = _data11_->self;
#line 124 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_g_object_unref0 (_data11_->canvas_item);
#line 124 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_g_object_unref0 (self);
#line 124 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		g_slice_free (Block11Data, _data11_);
#line 653 "Canvas.c"
	}
}

static void
_gtk_widget_queue_resize_no_redraw_spice_canvas_item_check_position (SpiceCanvasItem* _sender,
                                                                     gpointer self)
{
#line 130 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	gtk_widget_queue_resize_no_redraw ((GtkWidget*) self);
#line 663 "Canvas.c"
}

static void
__lambda18_ (Block11Data* _data11_)
{
	SpiceCanvas* self;
	SpiceCanvasItem* _tmp0_;
#line 132 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self = _data11_->self;
#line 133 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	spice_canvas_unselect_all (self, FALSE);
#line 134 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp0_ = _data11_->canvas_item;
#line 134 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_signal_emit (self, spice_canvas_signals[SPICE_CANVAS_ITEM_CLICKED_SIGNAL], 0, _tmp0_);
#line 679 "Canvas.c"
}

static void
___lambda18__spice_canvas_item_clicked (SpiceCanvasItem* _sender,
                                        gpointer self)
{
#line 132 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	__lambda18_ (self);
#line 688 "Canvas.c"
}

static void
__lambda19_ (Block11Data* _data11_,
             gint delta_x,
             gint delta_y)
{
	SpiceCanvas* self;
	SpiceWindow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GdkRectangle r = {0};
	SpiceCanvasItem* _tmp3_;
	GdkRectangle _tmp4_ = {0};
	GdkRectangle _tmp5_;
	SpiceCanvasItem* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	GdkRectangle _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	GdkRectangle _tmp12_;
	GdkRectangle _tmp13_;
	GdkRectangle _tmp14_;
	GdkRectangle _tmp15_ = {0};
	SpiceCanvasItem* _tmp16_;
#line 137 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self = _data11_->self;
#line 138 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp0_ = self->window;
#line 138 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp1_ = spice_window_get_is_presenting (_tmp0_);
#line 138 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp2_ = _tmp1_;
#line 138 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	if (_tmp2_) {
#line 138 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		return;
#line 727 "Canvas.c"
	}
#line 140 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp3_ = _data11_->canvas_item;
#line 140 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	spice_canvas_item_get_rectangle (_tmp3_, &_tmp4_);
#line 140 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp5_ = _tmp4_;
#line 140 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	r = _tmp5_;
#line 141 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp6_ = _data11_->canvas_item;
#line 141 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp7_ = spice_canvas_get_current_ratio (self);
#line 141 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp8_ = _tmp7_;
#line 141 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp9_ = r;
#line 141 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp10_ = spice_canvas_get_current_ratio (self);
#line 141 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp11_ = _tmp10_;
#line 141 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp12_ = r;
#line 141 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp13_ = r;
#line 141 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp14_ = r;
#line 141 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp15_.x = ((gint) (delta_x / _tmp8_)) + _tmp9_.x;
#line 141 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp15_.y = ((gint) (delta_y / _tmp11_)) + _tmp12_.y;
#line 141 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp15_.width = _tmp13_.width;
#line 141 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp15_.height = _tmp14_.height;
#line 141 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	spice_canvas_item_set_rectangle (_tmp6_, &_tmp15_);
#line 142 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp16_ = _data11_->canvas_item;
#line 142 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	gtk_widget_queue_resize_no_redraw ((GtkWidget*) _tmp16_);
#line 143 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_signal_emit (self, spice_canvas_signals[SPICE_CANVAS_REQUEST_DRAW_PREVIEW_SIGNAL], 0);
#line 771 "Canvas.c"
}

static void
___lambda19__spice_canvas_item_move_item (SpiceCanvasItem* _sender,
                                          gint delta_x,
                                          gint delta_y,
                                          gpointer self)
{
#line 137 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	__lambda19_ (self, delta_x, delta_y);
#line 782 "Canvas.c"
}

SpiceCanvasItem*
spice_canvas_add_item (SpiceCanvas* self,
                       SpiceCanvasItem* item,
                       gboolean undoable_action)
{
	Block11Data* _data11_;
	SpiceCanvasItem* _tmp0_;
	SpiceCanvasItem* _tmp1_;
	SpiceCanvasItem* _tmp2_;
	SpiceCanvasItem* _tmp3_;
	SpiceCanvasItem* _tmp4_;
	SpiceCanvasItem* _tmp5_;
	SpiceCanvasItem* _tmp6_;
	SpiceCanvasItem* _tmp15_;
	SpiceCanvasItem* _tmp16_;
	SpiceCanvasItem* result;
#line 124 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 124 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 124 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_data11_ = g_slice_new0 (Block11Data);
#line 124 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_data11_->_ref_count_ = 1;
#line 124 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_data11_->self = g_object_ref (self);
#line 125 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp0_ = _g_object_ref0 (item);
#line 125 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_data11_->canvas_item = _tmp0_;
#line 127 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp1_ = _data11_->canvas_item;
#line 127 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	gtk_overlay_add_overlay ((GtkOverlay*) self, (GtkWidget*) _tmp1_);
#line 128 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp2_ = _data11_->canvas_item;
#line 128 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp2_);
#line 130 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp3_ = _data11_->canvas_item;
#line 130 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp4_ = _data11_->canvas_item;
#line 130 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_signal_connect_object (_tmp3_, "check-position", (GCallback) _gtk_widget_queue_resize_no_redraw_spice_canvas_item_check_position, (GtkWidget*) _tmp4_, 0);
#line 132 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp5_ = _data11_->canvas_item;
#line 132 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_signal_connect_data (_tmp5_, "clicked", (GCallback) ___lambda18__spice_canvas_item_clicked, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
#line 137 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp6_ = _data11_->canvas_item;
#line 137 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_signal_connect_data (_tmp6_, "move-item", (GCallback) ___lambda19__spice_canvas_item_move_item, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
#line 146 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	if (undoable_action) {
#line 839 "Canvas.c"
		SpiceCanvasItem* _tmp7_;
		SpiceServicesHistoryManagerHistoryAction* action = NULL;
		SpiceCanvasItem* _tmp8_;
		SpiceServicesHistoryManagerHistoryAction* _tmp9_;
		SpiceWindow* _tmp10_;
		SpiceServicesHistoryManager* _tmp11_;
		SpiceServicesHistoryManager* _tmp12_;
		SpiceServicesHistoryManagerHistoryAction* _tmp13_;
		SpiceCanvasItem* _tmp14_;
#line 147 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp7_ = _data11_->canvas_item;
#line 147 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp7_, FALSE);
#line 148 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp8_ = _data11_->canvas_item;
#line 148 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp9_ = spice_services_history_manager_history_action_new_item_changed (SPICE_TYPE_CANVAS_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_BOOLEAN, NULL, NULL, _tmp8_, "visible");
#line 148 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		action = _tmp9_;
#line 149 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp10_ = self->window;
#line 149 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp11_ = spice_window_get_history_manager (_tmp10_);
#line 149 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp12_ = _tmp11_;
#line 149 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp13_ = action;
#line 149 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		spice_services_history_manager_add_undoable_action (_tmp12_, _tmp13_, FALSE);
#line 150 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp14_ = _data11_->canvas_item;
#line 150 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp14_, TRUE);
#line 146 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_g_object_unref0 (action);
#line 875 "Canvas.c"
	}
#line 153 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_signal_emit (self, spice_canvas_signals[SPICE_CANVAS_REQUEST_DRAW_PREVIEW_SIGNAL], 0);
#line 154 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp15_ = _data11_->canvas_item;
#line 154 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp16_ = _g_object_ref0 (_tmp15_);
#line 154 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	result = _tmp16_;
#line 154 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	block11_data_unref (_data11_);
#line 154 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_data11_ = NULL;
#line 154 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	return result;
#line 891 "Canvas.c"
}

void
spice_canvas_unselect_all (SpiceCanvas* self,
                           gboolean reset_item)
{
	GList* _tmp0_;
#line 157 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_if_fail (self != NULL);
#line 158 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
#line 903 "Canvas.c"
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
#line 158 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		item_collection = _tmp0_;
#line 158 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
#line 911 "Canvas.c"
			GtkWidget* item = NULL;
#line 158 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
			item = (GtkWidget*) item_it->data;
#line 915 "Canvas.c"
			{
				GtkWidget* _tmp1_;
#line 159 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
				_tmp1_ = item;
#line 159 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
				if (SPICE_IS_CANVAS_ITEM (_tmp1_)) {
#line 922 "Canvas.c"
					GtkWidget* _tmp2_;
#line 160 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
					_tmp2_ = item;
#line 160 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
					spice_canvas_item_unselect (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem));
#line 928 "Canvas.c"
				}
			}
		}
#line 158 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		(item_collection == NULL) ? NULL : (item_collection = (g_list_free (item_collection), NULL));
#line 934 "Canvas.c"
	}
#line 164 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	if (reset_item) {
#line 165 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		g_signal_emit (self, spice_canvas_signals[SPICE_CANVAS_ITEM_CLICKED_SIGNAL], 0, NULL);
#line 940 "Canvas.c"
	}
#line 168 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_signal_emit (self, spice_canvas_signals[SPICE_CANVAS_REQUEST_DRAW_PREVIEW_SIGNAL], 0);
#line 944 "Canvas.c"
}

void
spice_canvas_clear_all (SpiceCanvas* self)
{
	GList* _tmp0_;
#line 171 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_if_fail (self != NULL);
#line 172 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
#line 955 "Canvas.c"
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
#line 172 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		item_collection = _tmp0_;
#line 172 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
#line 963 "Canvas.c"
			GtkWidget* item = NULL;
#line 172 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
			item = (GtkWidget*) item_it->data;
#line 967 "Canvas.c"
			{
				GtkWidget* _tmp1_;
#line 173 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
				_tmp1_ = item;
#line 173 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
				if (SPICE_IS_CANVAS_ITEM (_tmp1_)) {
#line 974 "Canvas.c"
					GtkWidget* _tmp2_;
					GtkWidget* _tmp3_;
#line 174 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
					_tmp2_ = item;
#line 174 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
					spice_canvas_item_unselect (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem));
#line 175 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
					_tmp3_ = item;
#line 175 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
					gtk_widget_destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem));
#line 985 "Canvas.c"
				}
			}
		}
#line 172 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		(item_collection == NULL) ? NULL : (item_collection = (g_list_free (item_collection), NULL));
#line 991 "Canvas.c"
	}
}

void
spice_canvas_move_up (SpiceCanvas* self,
                      SpiceCanvasItem* item_,
                      gboolean add_undo_action)
{
	gint index = 0;
	GList* _tmp0_;
#line 180 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_if_fail (self != NULL);
#line 180 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_if_fail (item_ != NULL);
#line 181 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	index = 0;
#line 182 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
#line 1010 "Canvas.c"
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
#line 182 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		item_collection = _tmp0_;
#line 182 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
#line 1018 "Canvas.c"
			GtkWidget* item = NULL;
#line 182 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
			item = (GtkWidget*) item_it->data;
#line 1022 "Canvas.c"
			{
				GtkWidget* _tmp1_;
				gint _tmp2_;
#line 183 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
				_tmp1_ = item;
#line 183 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
				if (_tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (item_, gtk_widget_get_type (), GtkWidget)) {
#line 183 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
					break;
#line 1032 "Canvas.c"
				}
#line 184 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
				_tmp2_ = index;
#line 184 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
				index = _tmp2_ + 1;
#line 1038 "Canvas.c"
			}
		}
#line 182 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		(item_collection == NULL) ? NULL : (item_collection = (g_list_free (item_collection), NULL));
#line 1043 "Canvas.c"
	}
#line 187 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	if (add_undo_action) {
#line 1047 "Canvas.c"
		SpiceServicesHistoryManagerHistoryAction* action = NULL;
		SpiceServicesHistoryManagerHistoryAction* _tmp3_;
		SpiceWindow* _tmp4_;
		SpiceServicesHistoryManager* _tmp5_;
		SpiceServicesHistoryManager* _tmp6_;
		SpiceServicesHistoryManagerHistoryAction* _tmp7_;
#line 188 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp3_ = spice_services_history_manager_history_action_new_depth_changed (SPICE_TYPE_CANVAS_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_BOOLEAN, NULL, NULL, item_, self, TRUE);
#line 188 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		action = _tmp3_;
#line 189 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp4_ = self->window;
#line 189 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp5_ = spice_window_get_history_manager (_tmp4_);
#line 189 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp6_ = _tmp5_;
#line 189 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp7_ = action;
#line 189 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		spice_services_history_manager_add_undoable_action (_tmp6_, _tmp7_, TRUE);
#line 187 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_g_object_unref0 (action);
#line 1070 "Canvas.c"
	}
#line 192 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	gtk_overlay_reorder_overlay ((GtkOverlay*) self, (GtkWidget*) item_, index + 1);
#line 1074 "Canvas.c"
}

void
spice_canvas_move_down (SpiceCanvas* self,
                        SpiceCanvasItem* item_,
                        gboolean add_undo_action)
{
	gint index = 0;
	GList* _tmp0_;
#line 195 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_if_fail (self != NULL);
#line 195 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_if_fail (item_ != NULL);
#line 196 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	index = 0;
#line 197 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
#line 1092 "Canvas.c"
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
#line 197 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		item_collection = _tmp0_;
#line 197 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
#line 1100 "Canvas.c"
			GtkWidget* item = NULL;
#line 197 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
			item = (GtkWidget*) item_it->data;
#line 1104 "Canvas.c"
			{
				GtkWidget* _tmp1_;
				gint _tmp2_;
#line 198 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
				_tmp1_ = item;
#line 198 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
				if (_tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (item_, gtk_widget_get_type (), GtkWidget)) {
#line 198 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
					break;
#line 1114 "Canvas.c"
				}
#line 199 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
				_tmp2_ = index;
#line 199 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
				index = _tmp2_ + 1;
#line 1120 "Canvas.c"
			}
		}
#line 197 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		(item_collection == NULL) ? NULL : (item_collection = (g_list_free (item_collection), NULL));
#line 1125 "Canvas.c"
	}
#line 202 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	if ((index - 2) > -1) {
#line 203 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		gtk_overlay_reorder_overlay ((GtkOverlay*) self, (GtkWidget*) item_, index - 2);
#line 1131 "Canvas.c"
	}
#line 206 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	if (add_undo_action) {
#line 1135 "Canvas.c"
		SpiceServicesHistoryManagerHistoryAction* action = NULL;
		SpiceServicesHistoryManagerHistoryAction* _tmp3_;
		SpiceWindow* _tmp4_;
		SpiceServicesHistoryManager* _tmp5_;
		SpiceServicesHistoryManager* _tmp6_;
		SpiceServicesHistoryManagerHistoryAction* _tmp7_;
#line 207 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp3_ = spice_services_history_manager_history_action_new_depth_changed (SPICE_TYPE_CANVAS_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_BOOLEAN, NULL, NULL, item_, self, FALSE);
#line 207 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		action = _tmp3_;
#line 208 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp4_ = self->window;
#line 208 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp5_ = spice_window_get_history_manager (_tmp4_);
#line 208 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp6_ = _tmp5_;
#line 208 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp7_ = action;
#line 208 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		spice_services_history_manager_add_undoable_action (_tmp6_, _tmp7_, TRUE);
#line 206 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_g_object_unref0 (action);
#line 1158 "Canvas.c"
	}
}

static gboolean
spice_canvas_real_button_press_event (GtkWidget* base,
                                      GdkEventButton* event)
{
	SpiceCanvas * self;
	SpiceWindow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
#line 222 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self = (SpiceCanvas*) base;
#line 222 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 223 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp0_ = self->window;
#line 223 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp1_ = spice_window_get_is_presenting (_tmp0_);
#line 223 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp2_ = _tmp1_;
#line 223 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	if (_tmp2_) {
#line 224 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		if (event->button == ((guint) 1)) {
#line 225 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
			g_signal_emit (self, spice_canvas_signals[SPICE_CANVAS_NEXT_SLIDE_SIGNAL], 0);
#line 1187 "Canvas.c"
		} else {
#line 226 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
			if (event->button == ((guint) 3)) {
#line 227 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
				g_signal_emit (self, spice_canvas_signals[SPICE_CANVAS_PREVIOUS_SLIDE_SIGNAL], 0);
#line 1193 "Canvas.c"
			}
		}
	} else {
#line 230 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		spice_canvas_unselect_all (self, TRUE);
#line 1199 "Canvas.c"
	}
#line 233 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	result = TRUE;
#line 233 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	return result;
#line 1205 "Canvas.c"
}

void
spice_canvas_load_data (SpiceCanvas* self)
{
	JsonObject* _tmp0_;
	gchar* background_color_ = NULL;
	JsonObject* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* background_pattern_ = NULL;
	JsonObject* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
#line 236 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_if_fail (self != NULL);
#line 237 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp0_ = self->save_data;
#line 237 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	if (_tmp0_ == NULL) {
#line 237 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		return;
#line 1230 "Canvas.c"
	}
#line 239 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp1_ = self->save_data;
#line 239 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp2_ = json_object_get_string_member (_tmp1_, "background-color");
#line 239 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 239 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	background_color_ = _tmp3_;
#line 240 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp4_ = self->priv->_background_color;
#line 240 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	if (_tmp4_ != NULL) {
#line 1244 "Canvas.c"
		const gchar* _tmp5_;
#line 241 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp5_ = background_color_;
#line 241 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		spice_canvas_set_background_color (self, _tmp5_);
#line 1250 "Canvas.c"
	}
#line 244 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp6_ = self->save_data;
#line 244 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp7_ = json_object_get_string_member (_tmp6_, "background-pattern");
#line 244 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 244 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	background_pattern_ = _tmp8_;
#line 245 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp9_ = background_pattern_;
#line 245 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	if (_tmp9_ != NULL) {
#line 1264 "Canvas.c"
		const gchar* _tmp10_;
#line 246 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp10_ = background_pattern_;
#line 246 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		spice_canvas_set_background_pattern (self, _tmp10_);
#line 1270 "Canvas.c"
	}
#line 236 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_g_free0 (background_pattern_);
#line 236 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_g_free0 (background_color_);
#line 1276 "Canvas.c"
}

gchar*
spice_canvas_serialise (SpiceCanvas* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
#line 250 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 251 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp0_ = self->priv->_background_color;
#line 251 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp1_ = self->priv->_background_pattern;
#line 251 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp2_ = g_strdup_printf ("\"background-color\":\"%s\", \"background-pattern\":\"%s\" ", _tmp0_, _tmp1_);
#line 251 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	result = _tmp2_;
#line 251 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	return result;
#line 1298 "Canvas.c"
}

void
spice_canvas_style (SpiceCanvas* self)
{
	SpiceCanvasCanvasGrid* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	SpiceCanvasCanvasGrid* _tmp4_;
	const gchar* _tmp5_;
#line 254 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_if_fail (self != NULL);
#line 255 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp0_ = self->grid;
#line 255 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp1_ = self->priv->_background_color;
#line 255 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp2_ = g_strdup_printf (SPICE_CANVAS_CANVAS_CSS, _tmp1_);
#line 255 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp3_ = _tmp2_;
#line 255 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	spice_utils_set_style ((GtkWidget*) _tmp0_, _tmp3_);
#line 255 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_g_free0 (_tmp3_);
#line 257 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp4_ = self->grid;
#line 257 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp5_ = self->priv->_background_pattern;
#line 257 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	spice_canvas_canvas_grid_style (_tmp4_, _tmp5_);
#line 258 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_signal_emit (self, spice_canvas_signals[SPICE_CANVAS_REQUEST_DRAW_PREVIEW_SIGNAL], 0);
#line 1332 "Canvas.c"
}

static gboolean
spice_canvas_real_draw (GtkWidget* base,
                        cairo_t* cr)
{
	SpiceCanvas * self;
	GraniteDrawingBufferSurface* _tmp0_;
	GraniteDrawingBufferSurface* _tmp1_;
	cairo_t* _tmp2_;
	cairo_t* _tmp3_;
	gboolean result;
#line 262 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self = (SpiceCanvas*) base;
#line 262 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 263 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	GTK_WIDGET_CLASS (spice_canvas_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_overlay_get_type (), GtkOverlay), cr);
#line 265 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	spice_canvas_drawing_preview = TRUE;
#line 266 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp0_ = granite_drawing_buffer_surface_new ((gint) self->current_allocated_width, (gint) self->current_allocated_height);
#line 266 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_g_object_unref0 (self->surface);
#line 266 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->surface = _tmp0_;
#line 267 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp1_ = self->surface;
#line 267 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp2_ = granite_drawing_buffer_surface_get_context (_tmp1_);
#line 267 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp3_ = _tmp2_;
#line 267 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	GTK_WIDGET_CLASS (spice_canvas_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_overlay_get_type (), GtkOverlay), _tmp3_);
#line 268 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	spice_canvas_drawing_preview = FALSE;
#line 270 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	result = TRUE;
#line 270 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	return result;
#line 1373 "Canvas.c"
}

gdouble
spice_canvas_get_current_ratio (SpiceCanvas* self)
{
	gdouble result;
#line 33 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 34 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	result = self->priv->_current_ratio;
#line 34 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	return result;
#line 1386 "Canvas.c"
}

void
spice_canvas_set_current_ratio (SpiceCanvas* self,
                                gdouble value)
{
#line 37 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_if_fail (self != NULL);
#line 38 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	if (value != self->priv->_current_ratio) {
#line 1397 "Canvas.c"
		gdouble _tmp0_;
		gdouble _tmp1_;
#line 39 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		self->priv->_current_ratio = value;
#line 40 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp0_ = spice_canvas_get_current_ratio (self);
#line 40 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp1_ = _tmp0_;
#line 40 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		g_signal_emit (self, spice_canvas_signals[SPICE_CANVAS_RATIO_CHANGED_SIGNAL], 0, _tmp1_);
#line 1408 "Canvas.c"
	}
#line 37 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_object_notify_by_pspec ((GObject *) self, spice_canvas_properties[SPICE_CANVAS_CURRENT_RATIO_PROPERTY]);
#line 1412 "Canvas.c"
}

const gchar*
spice_canvas_get_background_color (SpiceCanvas* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 56 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 56 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp0_ = self->priv->_background_color;
#line 56 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	result = _tmp0_;
#line 56 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	return result;
#line 1428 "Canvas.c"
}

void
spice_canvas_set_background_color (SpiceCanvas* self,
                                   const gchar* value)
{
	gchar* old_value;
#line 56 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_if_fail (self != NULL);
#line 56 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	old_value = spice_canvas_get_background_color (self);
#line 56 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1442 "Canvas.c"
		gchar* _tmp0_;
#line 56 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp0_ = g_strdup (value);
#line 56 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_g_free0 (self->priv->_background_color);
#line 56 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		self->priv->_background_color = _tmp0_;
#line 56 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_canvas_properties[SPICE_CANVAS_BACKGROUND_COLOR_PROPERTY]);
#line 1452 "Canvas.c"
	}
}

const gchar*
spice_canvas_get_background_pattern (SpiceCanvas* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 57 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 57 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp0_ = self->priv->_background_pattern;
#line 57 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	result = _tmp0_;
#line 57 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	return result;
#line 1469 "Canvas.c"
}

void
spice_canvas_set_background_pattern (SpiceCanvas* self,
                                     const gchar* value)
{
	gchar* old_value;
#line 57 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_if_fail (self != NULL);
#line 57 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	old_value = spice_canvas_get_background_pattern (self);
#line 57 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1483 "Canvas.c"
		gchar* _tmp0_;
#line 57 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp0_ = g_strdup (value);
#line 57 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_g_free0 (self->priv->_background_pattern);
#line 57 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		self->priv->_background_pattern = _tmp0_;
#line 57 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_canvas_properties[SPICE_CANVAS_BACKGROUND_PATTERN_PROPERTY]);
#line 1493 "Canvas.c"
	}
}

static inline gpointer
spice_canvas_canvas_grid_get_instance_private (SpiceCanvasCanvasGrid* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceCanvasCanvasGrid_private_offset);
}

SpiceCanvasCanvasGrid*
spice_canvas_canvas_grid_construct (GType object_type,
                                    SpiceCanvas* canvas)
{
	SpiceCanvasCanvasGrid * self = NULL;
	GdkEventMask _tmp0_;
	GdkEventMask _tmp1_;
	SpiceCanvas* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkGrid* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkStyleContext* _tmp8_;
#line 292 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_val_if_fail (canvas != NULL, NULL);
#line 292 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self = (SpiceCanvasCanvasGrid*) g_object_new (object_type, NULL);
#line 293 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp0_ = gtk_widget_get_events ((GtkWidget*) self);
#line 293 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp1_ = _tmp0_;
#line 293 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	gtk_widget_set_events ((GtkWidget*) self, _tmp1_ | GDK_BUTTON_PRESS_MASK);
#line 294 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp2_ = _g_object_ref0 (canvas);
#line 294 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_g_object_unref0 (self->priv->canvas);
#line 294 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->priv->canvas = _tmp2_;
#line 296 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp3_ = (GtkGrid*) gtk_grid_new ();
#line 296 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_object_ref_sink (_tmp3_);
#line 296 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_g_object_unref0 (self->priv->grid);
#line 296 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->priv->grid = _tmp3_;
#line 297 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp4_ = self->priv->grid;
#line 297 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp4_);
#line 298 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp5_ = self->priv->grid;
#line 298 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
#line 298 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	gtk_style_context_add_class (_tmp6_, "pattern");
#line 300 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 300 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	gtk_style_context_add_class (_tmp7_, GTK_STYLE_CLASS_VIEW);
#line 301 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 301 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	gtk_style_context_add_class (_tmp8_, "canvas");
#line 303 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_object_set ((GtkWidget*) self, "expand", TRUE, NULL);
#line 292 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	return self;
#line 1563 "Canvas.c"
}

SpiceCanvasCanvasGrid*
spice_canvas_canvas_grid_new (SpiceCanvas* canvas)
{
#line 292 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	return spice_canvas_canvas_grid_construct (SPICE_CANVAS_TYPE_CANVAS_GRID, canvas);
#line 1571 "Canvas.c"
}

static gboolean
spice_canvas_canvas_grid_real_button_press_event (GtkWidget* base,
                                                  GdkEventButton* event)
{
	SpiceCanvasCanvasGrid * self;
	SpiceCanvas* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result;
#line 306 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self = (SpiceCanvasCanvasGrid*) base;
#line 306 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 307 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp0_ = self->priv->canvas;
#line 307 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_signal_emit_by_name ((GtkWidget*) _tmp0_, "button-press-event", event, &_tmp1_);
#line 307 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	result = _tmp1_;
#line 307 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	return result;
#line 1594 "Canvas.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 1613 "Canvas.c"
}

void
spice_canvas_canvas_grid_style (SpiceCanvasCanvasGrid* self,
                                const gchar* pattern)
{
#line 310 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_if_fail (self != NULL);
#line 310 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_return_if_fail (pattern != NULL);
#line 311 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	if (g_strcmp0 (pattern, "") != 0) {
#line 1626 "Canvas.c"
		gboolean _tmp0_ = FALSE;
#line 312 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		if (string_contains (pattern, SPICE_WIDGETS_CANVAS_TOOLBAR_PATTERNS_DIR)) {
#line 312 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
			_tmp0_ = TRUE;
#line 1632 "Canvas.c"
		} else {
			GFile* _tmp1_;
			GFile* _tmp2_;
#line 312 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
			_tmp1_ = g_file_new_for_path (pattern);
#line 312 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
			_tmp2_ = _tmp1_;
#line 312 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
			_tmp0_ = g_file_query_exists (_tmp2_, NULL);
#line 312 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
			_g_object_unref0 (_tmp2_);
#line 1644 "Canvas.c"
		}
#line 312 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		if (_tmp0_) {
#line 1648 "Canvas.c"
			GtkGrid* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
#line 313 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
			_tmp3_ = self->priv->grid;
#line 313 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
			_tmp4_ = g_strdup_printf (SPICE_CANVAS_CANVAS_GRID_PATTERN_CSS, pattern);
#line 313 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
			_tmp5_ = _tmp4_;
#line 313 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
			spice_utils_set_style ((GtkWidget*) _tmp3_, _tmp5_);
#line 313 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
			_g_free0 (_tmp5_);
#line 1662 "Canvas.c"
		} else {
			GtkGrid* _tmp6_;
#line 315 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
			_tmp6_ = self->priv->grid;
#line 315 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
			spice_utils_set_style ((GtkWidget*) _tmp6_, SPICE_CANVAS_CANVAS_GRID_NO_PATTERN_CSS);
#line 1669 "Canvas.c"
		}
	} else {
		GtkGrid* _tmp7_;
#line 318 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		_tmp7_ = self->priv->grid;
#line 318 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		spice_utils_set_style ((GtkWidget*) _tmp7_, SPICE_CANVAS_CANVAS_GRID_NO_PATTERN_CSS);
#line 1677 "Canvas.c"
	}
}

static void
spice_canvas_canvas_grid_class_init (SpiceCanvasCanvasGridClass * klass,
                                     gpointer klass_data)
{
#line 273 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	spice_canvas_canvas_grid_parent_class = g_type_class_peek_parent (klass);
#line 273 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_type_class_adjust_private_offset (klass, &SpiceCanvasCanvasGrid_private_offset);
#line 273 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) spice_canvas_canvas_grid_real_button_press_event;
#line 273 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_canvas_canvas_grid_finalize;
#line 1693 "Canvas.c"
}

static void
spice_canvas_canvas_grid_instance_init (SpiceCanvasCanvasGrid * self,
                                        gpointer klass)
{
#line 273 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->priv = spice_canvas_canvas_grid_get_instance_private (self);
#line 1702 "Canvas.c"
}

static void
spice_canvas_canvas_grid_finalize (GObject * obj)
{
	SpiceCanvasCanvasGrid * self;
#line 273 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGrid);
#line 274 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_g_object_unref0 (self->priv->canvas);
#line 276 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_g_object_unref0 (self->priv->grid);
#line 273 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	G_OBJECT_CLASS (spice_canvas_canvas_grid_parent_class)->finalize (obj);
#line 1717 "Canvas.c"
}

static GType
spice_canvas_canvas_grid_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceCanvasCanvasGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_canvas_canvas_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceCanvasCanvasGrid), 0, (GInstanceInitFunc) spice_canvas_canvas_grid_instance_init, NULL };
	GType spice_canvas_canvas_grid_type_id;
	spice_canvas_canvas_grid_type_id = g_type_register_static (gtk_event_box_get_type (), "SpiceCanvasCanvasGrid", &g_define_type_info, 0);
	SpiceCanvasCanvasGrid_private_offset = g_type_add_instance_private (spice_canvas_canvas_grid_type_id, sizeof (SpiceCanvasCanvasGridPrivate));
	return spice_canvas_canvas_grid_type_id;
}

GType
spice_canvas_canvas_grid_get_type (void)
{
	static volatile gsize spice_canvas_canvas_grid_type_id__once = 0;
	if (g_once_init_enter (&spice_canvas_canvas_grid_type_id__once)) {
		GType spice_canvas_canvas_grid_type_id;
		spice_canvas_canvas_grid_type_id = spice_canvas_canvas_grid_get_type_once ();
		g_once_init_leave (&spice_canvas_canvas_grid_type_id__once, spice_canvas_canvas_grid_type_id);
	}
	return spice_canvas_canvas_grid_type_id__once;
}

static void
spice_canvas_class_init (SpiceCanvasClass * klass,
                         gpointer klass_data)
{
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	spice_canvas_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_type_class_adjust_private_offset (klass, &SpiceCanvas_private_offset);
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	((GtkOverlayClass *) klass)->get_child_position = (gboolean (*) (GtkOverlay*, GtkWidget*, GdkRectangle*)) spice_canvas_real_get_child_position;
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) spice_canvas_real_button_press_event;
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) spice_canvas_real_draw;
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_canvas_get_property;
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_canvas_set_property;
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_canvas_finalize;
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CANVAS_CURRENT_RATIO_PROPERTY, spice_canvas_properties[SPICE_CANVAS_CURRENT_RATIO_PROPERTY] = g_param_spec_double ("current-ratio", "current-ratio", "current-ratio", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CANVAS_BACKGROUND_COLOR_PROPERTY, spice_canvas_properties[SPICE_CANVAS_BACKGROUND_COLOR_PROPERTY] = g_param_spec_string ("background-color", "background-color", "background-color", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CANVAS_BACKGROUND_PATTERN_PROPERTY, spice_canvas_properties[SPICE_CANVAS_BACKGROUND_PATTERN_PROPERTY] = g_param_spec_string ("background-pattern", "background-pattern", "background-pattern", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	spice_canvas_signals[SPICE_CANVAS_REQUEST_DRAW_PREVIEW_SIGNAL] = g_signal_new ("request-draw-preview", SPICE_TYPE_CANVAS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	spice_canvas_signals[SPICE_CANVAS_ITEM_CLICKED_SIGNAL] = g_signal_new ("item-clicked", SPICE_TYPE_CANVAS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SPICE_TYPE_CANVAS_ITEM);
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	spice_canvas_signals[SPICE_CANVAS_RATIO_CHANGED_SIGNAL] = g_signal_new ("ratio-changed", SPICE_TYPE_CANVAS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	spice_canvas_signals[SPICE_CANVAS_NEXT_SLIDE_SIGNAL] = g_signal_new ("next-slide", SPICE_TYPE_CANVAS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	spice_canvas_signals[SPICE_CANVAS_PREVIOUS_SLIDE_SIGNAL] = g_signal_new ("previous-slide", SPICE_TYPE_CANVAS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1778 "Canvas.c"
}

static void
spice_canvas_instance_init (SpiceCanvas * self,
                            gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->priv = spice_canvas_get_instance_private (self);
#line 31 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->priv->_current_ratio = (gdouble) 1.0f;
#line 47 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->current_allocated_width = (gdouble) 0;
#line 48 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->current_allocated_height = (gdouble) 0;
#line 49 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->priv->default_x_margin = (gdouble) 0;
#line 50 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->priv->default_y_margin = (gdouble) 0;
#line 55 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->save_data = NULL;
#line 56 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp0_ = g_strdup ("#383E41");
#line 56 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->priv->_background_color = _tmp0_;
#line 57 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_tmp1_ = g_strdup ("");
#line 57 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->priv->_background_pattern = _tmp1_;
#line 261 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self->surface = NULL;
#line 1811 "Canvas.c"
}

static void
spice_canvas_finalize (GObject * obj)
{
	SpiceCanvas * self;
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_CANVAS, SpiceCanvas);
#line 52 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_g_object_unref0 (self->grid);
#line 55 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_json_object_unref0 (self->save_data);
#line 56 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_g_free0 (self->priv->_background_color);
#line 57 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_g_free0 (self->priv->_background_pattern);
#line 261 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	_g_object_unref0 (self->surface);
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	G_OBJECT_CLASS (spice_canvas_parent_class)->finalize (obj);
#line 1832 "Canvas.c"
}

static GType
spice_canvas_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceCanvasClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_canvas_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceCanvas), 0, (GInstanceInitFunc) spice_canvas_instance_init, NULL };
	GType spice_canvas_type_id;
	spice_canvas_type_id = g_type_register_static (gtk_overlay_get_type (), "SpiceCanvas", &g_define_type_info, 0);
	SpiceCanvas_private_offset = g_type_add_instance_private (spice_canvas_type_id, sizeof (SpiceCanvasPrivate));
	return spice_canvas_type_id;
}

GType
spice_canvas_get_type (void)
{
	static volatile gsize spice_canvas_type_id__once = 0;
	if (g_once_init_enter (&spice_canvas_type_id__once)) {
		GType spice_canvas_type_id;
		spice_canvas_type_id = spice_canvas_get_type_once ();
		g_once_init_leave (&spice_canvas_type_id__once, spice_canvas_type_id);
	}
	return spice_canvas_type_id__once;
}

static void
_vala_spice_canvas_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	SpiceCanvas * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_CANVAS, SpiceCanvas);
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		case SPICE_CANVAS_CURRENT_RATIO_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		g_value_set_double (value, spice_canvas_get_current_ratio (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		case SPICE_CANVAS_BACKGROUND_COLOR_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		g_value_set_string (value, spice_canvas_get_background_color (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		case SPICE_CANVAS_BACKGROUND_PATTERN_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		g_value_set_string (value, spice_canvas_get_background_pattern (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		break;
#line 1885 "Canvas.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		break;
#line 1891 "Canvas.c"
	}
}

static void
_vala_spice_canvas_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	SpiceCanvas * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_CANVAS, SpiceCanvas);
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		case SPICE_CANVAS_CURRENT_RATIO_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		spice_canvas_set_current_ratio (self, g_value_get_double (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		case SPICE_CANVAS_BACKGROUND_COLOR_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		spice_canvas_set_background_color (self, g_value_get_string (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		case SPICE_CANVAS_BACKGROUND_PATTERN_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		spice_canvas_set_background_pattern (self, g_value_get_string (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		break;
#line 1923 "Canvas.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Widgets/Canvas.vala"
		break;
#line 1929 "Canvas.c"
	}
}

