/* ColorChooser.c generated by valac 0.56.18, the Vala compiler
 * generated from ColorChooser.vala, do not modify */

/*
* Copyright (c) 2018 Felipe Escoto (https://github.com/Philip-Scott/Spice-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <granite.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SPICE_TYPE_COLOR_BUTTON (spice_color_button_get_type ())
#define SPICE_COLOR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_COLOR_BUTTON, SpiceColorButton))
#define SPICE_COLOR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_COLOR_BUTTON, SpiceColorButtonClass))
#define SPICE_IS_COLOR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_COLOR_BUTTON))
#define SPICE_IS_COLOR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_COLOR_BUTTON))
#define SPICE_COLOR_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_COLOR_BUTTON, SpiceColorButtonClass))

typedef struct _SpiceColorButton SpiceColorButton;
typedef struct _SpiceColorButtonClass SpiceColorButtonClass;
typedef struct _SpiceColorButtonPrivate SpiceColorButtonPrivate;

#define SPICE_TYPE_COLOR_CHOOSER (spice_color_chooser_get_type ())
#define SPICE_COLOR_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_COLOR_CHOOSER, SpiceColorChooser))
#define SPICE_COLOR_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_COLOR_CHOOSER, SpiceColorChooserClass))
#define SPICE_IS_COLOR_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_COLOR_CHOOSER))
#define SPICE_IS_COLOR_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_COLOR_CHOOSER))
#define SPICE_COLOR_CHOOSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_COLOR_CHOOSER, SpiceColorChooserClass))

typedef struct _SpiceColorChooser SpiceColorChooser;
typedef struct _SpiceColorChooserClass SpiceColorChooserClass;
typedef struct _SpiceColorChooserPrivate SpiceColorChooserPrivate;

#define SPICE_TYPE_GRADIENT_EDITOR (spice_gradient_editor_get_type ())
#define SPICE_GRADIENT_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_GRADIENT_EDITOR, SpiceGradientEditor))
#define SPICE_GRADIENT_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_GRADIENT_EDITOR, SpiceGradientEditorClass))
#define SPICE_IS_GRADIENT_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_GRADIENT_EDITOR))
#define SPICE_IS_GRADIENT_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_GRADIENT_EDITOR))
#define SPICE_GRADIENT_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_GRADIENT_EDITOR, SpiceGradientEditorClass))

typedef struct _SpiceGradientEditor SpiceGradientEditor;
typedef struct _SpiceGradientEditorClass SpiceGradientEditorClass;
enum  {
	SPICE_COLOR_CHOOSER_0_PROPERTY,
	SPICE_COLOR_CHOOSER_GRADIENT_PROPERTY,
	SPICE_COLOR_CHOOSER_COLOR_PROPERTY,
	SPICE_COLOR_CHOOSER_USE_ALPHA_PROPERTY,
	SPICE_COLOR_CHOOSER_NUM_PROPERTIES
};
static GParamSpec* spice_color_chooser_properties[SPICE_COLOR_CHOOSER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SPICE_TYPE_PICKER_WINDOW (spice_picker_window_get_type ())
#define SPICE_PICKER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_PICKER_WINDOW, SpicePickerWindow))
#define SPICE_PICKER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_PICKER_WINDOW, SpicePickerWindowClass))
#define SPICE_IS_PICKER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_PICKER_WINDOW))
#define SPICE_IS_PICKER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_PICKER_WINDOW))
#define SPICE_PICKER_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_PICKER_WINDOW, SpicePickerWindowClass))

typedef struct _SpicePickerWindow SpicePickerWindow;
typedef struct _SpicePickerWindowClass SpicePickerWindowClass;
typedef struct _Block16Data Block16Data;

#define TYPE_EXT_RGBA (ext_rgba_get_type ())
typedef GdkRGBA ExtRGBA;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block17Data Block17Data;
typedef struct _Block18Data Block18Data;

#define SPICE_GRADIENT_TYPE_GRADIENT_STEP (spice_gradient_gradient_step_get_type ())
#define SPICE_GRADIENT_GRADIENT_STEP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_GRADIENT_TYPE_GRADIENT_STEP, SpiceGradientGradientStep))
#define SPICE_GRADIENT_GRADIENT_STEP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_GRADIENT_TYPE_GRADIENT_STEP, SpiceGradientGradientStepClass))
#define SPICE_GRADIENT_IS_GRADIENT_STEP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_GRADIENT_TYPE_GRADIENT_STEP))
#define SPICE_GRADIENT_IS_GRADIENT_STEP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_GRADIENT_TYPE_GRADIENT_STEP))
#define SPICE_GRADIENT_GRADIENT_STEP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_GRADIENT_TYPE_GRADIENT_STEP, SpiceGradientGradientStepClass))

typedef struct _SpiceGradientGradientStep SpiceGradientGradientStep;
typedef struct _SpiceGradientGradientStepClass SpiceGradientGradientStepClass;

#define SPICE_TYPE_GRADIENT (spice_gradient_get_type ())
#define SPICE_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_GRADIENT, SpiceGradient))
#define SPICE_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_GRADIENT, SpiceGradientClass))
#define SPICE_IS_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_GRADIENT))
#define SPICE_IS_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_GRADIENT))
#define SPICE_GRADIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_GRADIENT, SpiceGradientClass))

typedef struct _SpiceGradient SpiceGradient;
typedef struct _SpiceGradientClass SpiceGradientClass;
enum  {
	SPICE_COLOR_CHOOSER_COLOR_PICKED_SIGNAL,
	SPICE_COLOR_CHOOSER_NUM_SIGNALS
};
static guint spice_color_chooser_signals[SPICE_COLOR_CHOOSER_NUM_SIGNALS] = {0};

struct _SpiceColorButton {
	GtkButton parent_instance;
	SpiceColorButtonPrivate * priv;
	GtkEventBox* surface;
	GtkEventBox* checkered_bg;
	gchar* _color;
};

struct _SpiceColorButtonClass {
	GtkButtonClass parent_class;
};

struct _SpiceColorChooser {
	SpiceColorButton parent_instance;
	SpiceColorChooserPrivate * priv;
	GtkRevealer* gradient_revealer;
	SpiceGradientEditor* gradient_editor;
};

struct _SpiceColorChooserClass {
	SpiceColorButtonClass parent_class;
};

struct _SpiceColorChooserPrivate {
	gboolean setting_color;
	gboolean _use_alpha;
	gulong color_chooser_signal;
	GtkStack* colors_grid_stack;
	GtkPopover* popover;
	GtkGrid* colors_grid;
	GtkGrid* gradient_colors_grid;
	GtkColorChooserWidget* color_chooser;
	GtkToggleButton* gradient_button;
	GraniteWidgetsModeButton* mode_button;
};

struct _Block16Data {
	int _ref_count_;
	SpiceColorChooser* self;
	SpicePickerWindow* mouse_position;
	GdkRGBA previous;
};

struct _Block17Data {
	int _ref_count_;
	SpiceColorChooser* self;
	gchar* color;
};

struct _Block18Data {
	int _ref_count_;
	SpiceColorChooser* self;
	gchar* color;
};

static gint SpiceColorChooser_private_offset;
static gpointer spice_color_chooser_parent_class = NULL;

VALA_EXTERN GType spice_color_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceColorButton, g_object_unref)
VALA_EXTERN GType spice_color_chooser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceColorChooser, g_object_unref)
VALA_EXTERN GType spice_gradient_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceGradientEditor, g_object_unref)
VALA_EXTERN SpiceColorChooser* spice_color_chooser_new (gboolean use_alpha);
VALA_EXTERN SpiceColorChooser* spice_color_chooser_construct (GType object_type,
                                                  gboolean use_alpha);
VALA_EXTERN SpiceColorChooser* spice_color_chooser_new_with_gradient (gboolean use_alpha);
VALA_EXTERN SpiceColorChooser* spice_color_chooser_construct_with_gradient (GType object_type,
                                                                gboolean use_alpha);
static void spice_color_chooser_make_palette_view (SpiceColorChooser* self);
VALA_EXTERN void spice_color_chooser_generate_colors (SpiceColorChooser* self);
static void spice_color_chooser_make_custom_view (SpiceColorChooser* self);
VALA_EXTERN gboolean spice_color_chooser_get_use_alpha (SpiceColorChooser* self);
static void __lambda39_ (SpiceColorChooser* self);
VALA_EXTERN GType spice_picker_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpicePickerWindow, g_object_unref)
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
VALA_EXTERN SpicePickerWindow* spice_picker_window_new (void);
VALA_EXTERN SpicePickerWindow* spice_picker_window_construct (GType object_type);
static void __lambda40_ (SpiceColorChooser* self,
                  SpicePickerWindow* t,
                  GdkRGBA* color);
VALA_EXTERN GType ext_rgba_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ExtRGBA* ext_rgba_dup (const ExtRGBA* self);
VALA_EXTERN void ext_rgba_free (ExtRGBA* self);
VALA_EXTERN void spice_color_chooser_set_color_smart (SpiceColorChooser* self,
                                          const gchar* color,
                                          gboolean from_button,
                                          gboolean overwite_gradient,
                                          gboolean from_gradient_editor);
VALA_EXTERN gchar* ext_rgba_to_css_rgb_string (ExtRGBA *self);
static void ___lambda40__spice_picker_window_moved (SpicePickerWindow* _sender,
                                             GdkRGBA* color,
                                             gpointer self);
static void __lambda41_ (Block16Data* _data16_);
VALA_EXTERN void spice_picker_window_close (SpicePickerWindow* self);
static void ___lambda41__spice_picker_window_cancelled (SpicePickerWindow* _sender,
                                                 gpointer self);
static void __lambda42_ (Block16Data* _data16_,
                  SpicePickerWindow* t,
                  GdkRGBA* color);
static void ___lambda42__spice_picker_window_picked (SpicePickerWindow* _sender,
                                              GdkRGBA* color,
                                              gpointer self);
static void ___lambda39__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda43_ (SpiceColorChooser* self);
static void ___lambda43__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void spice_color_chooser_attach_color (SpiceColorChooser* self,
                                       const gchar* color,
                                       gint x,
                                       gint y);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
VALA_EXTERN SpiceColorButton* spice_color_button_new (const gchar* color);
VALA_EXTERN SpiceColorButton* spice_color_button_construct (GType object_type,
                                                const gchar* color);
VALA_EXTERN void spice_color_button_set_size (SpiceColorButton* self,
                                  gint x,
                                  gint y);
static void __lambda37_ (Block17Data* _data17_);
static void ___lambda37__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void spice_color_chooser_make_gradient_palete (SpiceColorChooser* self);
VALA_EXTERN void spice_color_chooser_generate_gradient_colors (SpiceColorChooser* self);
static void spice_color_chooser_attach_gradient (SpiceColorChooser* self,
                                          const gchar* color,
                                          gint x,
                                          gint y);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static void __lambda38_ (Block18Data* _data18_);
static void ___lambda38__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
VALA_EXTERN void spice_color_button_set_color (SpiceColorButton* self,
                                   const gchar* value);
VALA_EXTERN void spice_gradient_editor_set_color (SpiceGradientEditor* self,
                                      const gchar* color,
                                      gboolean override);
VALA_EXTERN gchar* spice_gradient_editor_make_gradient (SpiceGradientEditor* self);
VALA_EXTERN void spice_gradient_editor_parse_gradient (SpiceGradientEditor* self,
                                           const gchar* color,
                                           gboolean force);
VALA_EXTERN gboolean spice_color_chooser_get_gradient (SpiceColorChooser* self);
VALA_EXTERN GType spice_gradient_gradient_step_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceGradientGradientStep, g_object_unref)
VALA_EXTERN GType spice_gradient_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceGradient, g_object_unref)
VALA_EXTERN SpiceGradient* spice_gradient_editor_get_gradient (SpiceGradientEditor* self);
VALA_EXTERN SpiceGradientGradientStep* spice_gradient_get_color (SpiceGradient* self,
                                                     gint nth);
VALA_EXTERN const gchar* spice_gradient_gradient_step_get_color (SpiceGradientGradientStep* self);
static void spice_color_chooser_set_color_chooser_color (SpiceColorChooser* self,
                                                  const gchar* color);
VALA_EXTERN const gchar* spice_color_chooser_get_color (SpiceColorChooser* self);
VALA_EXTERN void spice_color_chooser_set_gradient (SpiceColorChooser* self,
                                       gboolean value);
VALA_EXTERN void spice_color_chooser_set_color (SpiceColorChooser* self,
                                    const gchar* value);
VALA_EXTERN void spice_color_chooser_set_use_alpha (SpiceColorChooser* self,
                                        gboolean value);
static GObject * spice_color_chooser_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _spice_color_chooser___lambda44_ (SpiceColorChooser* self,
                                       gint index,
                                       GtkWidget* widget);
static void __spice_color_chooser___lambda44__granite_widgets_mode_button_mode_added (GraniteWidgetsModeButton* _sender,
                                                                               gint index,
                                                                               GtkWidget* widget,
                                                                               gpointer self);
static void _spice_color_chooser___lambda45_ (SpiceColorChooser* self,
                                       GtkWidget* w);
static void __spice_color_chooser___lambda45__granite_widgets_mode_button_mode_changed (GraniteWidgetsModeButton* _sender,
                                                                                 GtkWidget* widget,
                                                                                 gpointer self);
static void _spice_color_chooser___lambda46_ (SpiceColorChooser* self);
static void __spice_color_chooser___lambda46__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self);
VALA_EXTERN SpiceGradientEditor* spice_gradient_editor_new (SpiceColorChooser* _color_picker);
VALA_EXTERN SpiceGradientEditor* spice_gradient_editor_construct (GType object_type,
                                                      SpiceColorChooser* _color_picker);
static void _spice_color_chooser___lambda47_ (SpiceColorChooser* self,
                                       gint index,
                                       const gchar* color);
static void __spice_color_chooser___lambda47__spice_gradient_editor_color_selected (SpiceGradientEditor* _sender,
                                                                             gint index,
                                                                             const gchar* color,
                                                                             gpointer self);
static void _spice_color_chooser___lambda48_ (SpiceColorChooser* self);
static void __spice_color_chooser___lambda48__spice_gradient_editor_updated (SpiceGradientEditor* _sender,
                                                                      gpointer self);
static gboolean _spice_color_chooser___lambda49_ (SpiceColorChooser* self,
                                           GtkWidget* source,
                                           GdkEventKey* key);
static gboolean __spice_color_chooser___lambda49__gtk_widget_key_press_event (GtkWidget* _sender,
                                                                       GdkEventKey* event,
                                                                       gpointer self);
static void _spice_color_chooser___lambda50_ (SpiceColorChooser* self);
static void __spice_color_chooser___lambda50__gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self);
static void spice_color_chooser_finalize (GObject * obj);
static GType spice_color_chooser_get_type_once (void);
static void _vala_spice_color_chooser_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_spice_color_chooser_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static const gchar* SPICE_COLOR_CHOOSER_COLOR_PALETTE[3][20] = {{"#ff8c82", "#ed5353", "#c6262e", "#a10705", "#7a0000", "#ffc27d", "#ffa154", "#f37329", "#cc3b02", "#a62100", "#a3907c", "#8a715e", "#715344", "#57392d", "#3d211b", "#666666", "#4d4d4d", "#333333", "#1a1a1a", "#000000"}, {"#fec2cf", "#fe9ab8", "#f46099", "#e41b79", "#c10f68", "#fff394", "#ffe16b", "#f9c440", "#d48e15", "#ad5f00", "#8cd5ff", "#64baff", "#3689e6", "#0d52bf", "#002e99", "#95a3ab", "#667885", "#485a6c", "#273445", "#0e141f"}, {"#e29ffc", "#ad65d6", "#7a36b1", "#4c158a", "#260063", "#d1ff82", "#9bdb4d", "#68b723", "#3a9104", "#206b00", "#96fce5", "#23fdd9", "#00f4d4", "#00d0bf", "#00a69c", "#ffffff", "#d4d4d4", "#abacae", "#7e8087", "#555761"}};
static const gchar* SPICE_COLOR_CHOOSER_GRADIENT_PALETTE[6][4] = {{"linear-gradient(to right, #ff8177 0%, #ff867a 0%, #ff8c7f 21%, #f99185" \
" 52%, #cf556c 78%, #b12a5b 100%)", "linear-gradient(to right, #f46b45 0%, #eea849 100%)", "linear-gradient(to right, #c79081 0%, #dfa579 100%)", "linear-gradient(to right, #232526 0%, #414345 100%)"}, {"linear-gradient(to right, #e1eec3 0%, #f05053 100%)", "linear-gradient(to right, #f12711 0%, #f5af19 100%)", "linear-gradient(to right, #d1913c 0%, #ffd194 100%)", "linear-gradient(to right, #0f2027 0%, #203a43 50%, #2c5364 100%)"}, {"linear-gradient(to right, #feada6 0%, #f5efef 100%)", "linear-gradient(to right, #fceabb 0%, #f8b500 100%)", "linear-gradient(to right, #045de9 0%, #09c6f9 74%)", "linear-gradient(to right, #606c88 0%, #3f4c6b 100%)"}, {"linear-gradient(to right, #fdcbf1 0%, #fdcbf1 5%, #e6dee9 100%)", "linear-gradient(to right, #fff293 0%, #ffe884 74%)", "linear-gradient(to right, #2980b9 0%, #6dd5fa 50%, #ffffff 100%)", "linear-gradient(to right, #757f9a 0%, #d7dde8 100%)"}, {"linear-gradient(to right, #a18cd1 0%, #fbc2eb 100%)", "linear-gradient(to right, #abecd6 0%, #fbed96 100%)", "linear-gradient(to right, #a6ffcb 0%, #12d8fa 50%, #1fa2ff 100%)", "linear-gradient(to right, #e9defa 0%, #fbfcdb 100%)"}, {"linear-gradient(to right, #7a36b1 20%, #0d52bf 100%)", "linear-gradient(to right, #43c6ac 0%, #f8ffae 100%)", "linear-gradient(to right, #3ab5b0 0%, #3D99BE 31%, #56317a 100%)", "linear-gradient(to right, #FFFEFF 0%, #D7FFFE 100%)"}};

static inline gpointer
spice_color_chooser_get_instance_private (SpiceColorChooser* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceColorChooser_private_offset);
}

SpiceColorChooser*
spice_color_chooser_construct (GType object_type,
                               gboolean use_alpha)
{
	SpiceColorChooser * self = NULL;
	GtkColorChooserWidget* _tmp0_;
#line 77 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self = (SpiceColorChooser*) g_object_new (object_type, "color", "white", "use-alpha", use_alpha, NULL);
#line 78 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = self->priv->color_chooser;
#line 78 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_color_chooser_set_use_alpha ((GtkColorChooser*) _tmp0_, use_alpha);
#line 76 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	return self;
#line 375 "ColorChooser.c"
}

SpiceColorChooser*
spice_color_chooser_new (gboolean use_alpha)
{
#line 76 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	return spice_color_chooser_construct (SPICE_TYPE_COLOR_CHOOSER, use_alpha);
#line 383 "ColorChooser.c"
}

SpiceColorChooser*
spice_color_chooser_construct_with_gradient (GType object_type,
                                             gboolean use_alpha)
{
	SpiceColorChooser * self = NULL;
	GtkColorChooserWidget* _tmp0_;
#line 82 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self = (SpiceColorChooser*) g_object_new (object_type, "color", "white", "use-alpha", use_alpha, "gradient", TRUE, NULL);
#line 83 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = self->priv->color_chooser;
#line 83 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_color_chooser_set_use_alpha ((GtkColorChooser*) _tmp0_, use_alpha);
#line 81 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	return self;
#line 400 "ColorChooser.c"
}

SpiceColorChooser*
spice_color_chooser_new_with_gradient (gboolean use_alpha)
{
#line 81 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	return spice_color_chooser_construct_with_gradient (SPICE_TYPE_COLOR_CHOOSER, use_alpha);
#line 408 "ColorChooser.c"
}

static void
spice_color_chooser_make_palette_view (SpiceColorChooser* self)
{
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStack* _tmp4_;
	GtkGrid* _tmp5_;
#line 199 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (self != NULL);
#line 200 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
#line 200 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp0_);
#line 200 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (self->priv->colors_grid);
#line 200 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self->priv->colors_grid = _tmp0_;
#line 201 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp1_ = self->priv->colors_grid;
#line 201 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_set ((GtkWidget*) _tmp1_, "margin", 6, NULL);
#line 202 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp2_ = self->priv->colors_grid;
#line 202 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
#line 202 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_style_context_add_class (_tmp3_, "card");
#line 204 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	spice_color_chooser_generate_colors (self);
#line 205 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp4_ = self->priv->colors_grid_stack;
#line 205 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp5_ = self->priv->colors_grid;
#line 205 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_stack_add_named (_tmp4_, (GtkWidget*) _tmp5_, "palete");
#line 448 "ColorChooser.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 212 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	return self ? g_object_ref (self) : NULL;
#line 456 "ColorChooser.c"
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
#line 256 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_atomic_int_inc (&_data16_->_ref_count_);
#line 256 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	return _data16_;
#line 466 "ColorChooser.c"
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
#line 256 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
#line 476 "ColorChooser.c"
		SpiceColorChooser* self;
#line 256 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		self = _data16_->self;
#line 256 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_g_object_unref0 (_data16_->mouse_position);
#line 256 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_g_object_unref0 (self);
#line 256 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		g_slice_free (Block16Data, _data16_);
#line 486 "ColorChooser.c"
	}
}

static void
__lambda40_ (SpiceColorChooser* self,
             SpicePickerWindow* t,
             GdkRGBA* color)
{
	ExtRGBA ext_color = {0};
	GdkRGBA _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 261 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (t != NULL);
#line 261 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (color != NULL);
#line 262 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = *color;
#line 262 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	ext_color = (ExtRGBA) _tmp0_;
#line 263 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp1_ = ext_rgba_to_css_rgb_string (&ext_color);
#line 263 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp2_ = _tmp1_;
#line 263 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	spice_color_chooser_set_color_smart (self, _tmp2_, TRUE, FALSE, FALSE);
#line 263 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_free0 (_tmp2_);
#line 515 "ColorChooser.c"
}

static void
___lambda40__spice_picker_window_moved (SpicePickerWindow* _sender,
                                        GdkRGBA* color,
                                        gpointer self)
{
#line 261 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	__lambda40_ ((SpiceColorChooser*) self, _sender, color);
#line 525 "ColorChooser.c"
}

static void
__lambda41_ (Block16Data* _data16_)
{
	SpiceColorChooser* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 266 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self = _data16_->self;
#line 267 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	spice_picker_window_close (_data16_->mouse_position);
#line 268 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = gdk_rgba_to_string (&_data16_->previous);
#line 268 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp1_ = _tmp0_;
#line 268 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	spice_color_chooser_set_color_smart (self, _tmp1_, TRUE, FALSE, FALSE);
#line 268 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_free0 (_tmp1_);
#line 269 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_destroy ((GtkWidget*) _data16_->mouse_position);
#line 548 "ColorChooser.c"
}

static void
___lambda41__spice_picker_window_cancelled (SpicePickerWindow* _sender,
                                            gpointer self)
{
#line 266 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	__lambda41_ (self);
#line 557 "ColorChooser.c"
}

static void
__lambda42_ (Block16Data* _data16_,
             SpicePickerWindow* t,
             GdkRGBA* color)
{
	SpiceColorChooser* self;
	ExtRGBA ext_color = {0};
	GdkRGBA _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 272 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self = _data16_->self;
#line 272 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (t != NULL);
#line 272 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (color != NULL);
#line 273 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = *color;
#line 273 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	ext_color = (ExtRGBA) _tmp0_;
#line 274 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp1_ = ext_rgba_to_css_rgb_string (&ext_color);
#line 274 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp2_ = _tmp1_;
#line 274 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	spice_color_chooser_set_color_smart (self, _tmp2_, TRUE, FALSE, FALSE);
#line 274 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_free0 (_tmp2_);
#line 276 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	spice_picker_window_close (_data16_->mouse_position);
#line 590 "ColorChooser.c"
}

static void
___lambda42__spice_picker_window_picked (SpicePickerWindow* _sender,
                                         GdkRGBA* color,
                                         gpointer self)
{
#line 272 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	__lambda42_ (self, _sender, color);
#line 600 "ColorChooser.c"
}

static void
__lambda39_ (SpiceColorChooser* self)
{
	Block16Data* _data16_;
	SpicePickerWindow* _tmp0_;
	GtkColorChooserWidget* _tmp1_;
	GdkRGBA _tmp2_ = {0};
	GdkRGBA _tmp3_;
#line 256 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_data16_ = g_slice_new0 (Block16Data);
#line 256 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_data16_->_ref_count_ = 1;
#line 256 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_data16_->self = g_object_ref (self);
#line 257 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = spice_picker_window_new ();
#line 257 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp0_);
#line 257 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_data16_->mouse_position = _tmp0_;
#line 258 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_show_all ((GtkWidget*) _data16_->mouse_position);
#line 259 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp1_ = self->priv->color_chooser;
#line 259 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp1_, &_tmp2_);
#line 259 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp3_ = _tmp2_;
#line 259 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_data16_->previous = _tmp3_;
#line 261 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_signal_connect_object (_data16_->mouse_position, "moved", (GCallback) ___lambda40__spice_picker_window_moved, self, 0);
#line 266 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_signal_connect_data (_data16_->mouse_position, "cancelled", (GCallback) ___lambda41__spice_picker_window_cancelled, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
#line 272 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_signal_connect_data (_data16_->mouse_position, "picked", (GCallback) ___lambda42__spice_picker_window_picked, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
#line 256 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	block16_data_unref (_data16_);
#line 256 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_data16_ = NULL;
#line 643 "ColorChooser.c"
}

static void
___lambda39__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 256 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	__lambda39_ ((SpiceColorChooser*) self);
#line 652 "ColorChooser.c"
}

static void
__lambda43_ (SpiceColorChooser* self)
{
	GtkColorChooserWidget* _tmp0_;
	GdkRGBA _tmp1_ = {0};
	GdkRGBA _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 283 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = self->priv->color_chooser;
#line 283 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp0_, &_tmp1_);
#line 283 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp2_ = _tmp1_;
#line 283 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp3_ = gdk_rgba_to_string (&_tmp2_);
#line 283 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp4_ = _tmp3_;
#line 283 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	spice_color_chooser_set_color_smart (self, _tmp4_, FALSE, FALSE, FALSE);
#line 283 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_free0 (_tmp4_);
#line 677 "ColorChooser.c"
}

static void
___lambda43__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 282 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	__lambda43_ ((SpiceColorChooser*) self);
#line 687 "ColorChooser.c"
}

static void
spice_color_chooser_make_custom_view (SpiceColorChooser* self)
{
	GtkColorChooserWidget* _tmp0_;
	GtkColorChooserWidget* _tmp1_;
	GtkContainer* container = NULL;
	GtkColorChooserWidget* _tmp2_;
	GtkContainer* _tmp3_;
	GtkGrid* color_chooser_grid = NULL;
	GtkGrid* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkScale* hue_scale = NULL;
	GtkScale* _tmp7_;
	GtkScale* _tmp8_;
	GtkScale* _tmp9_;
	GtkContainer* _tmp10_;
	GList* _tmp11_;
	GtkButton* color_picker_button = NULL;
	GtkButton* _tmp60_;
	GtkGrid* _tmp61_;
	GtkColorChooserWidget* _tmp62_;
	gulong _tmp63_;
	GtkStack* _tmp64_;
	GtkGrid* _tmp65_;
#line 208 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (self != NULL);
#line 209 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = (GtkColorChooserWidget*) gtk_color_chooser_widget_new ();
#line 209 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp0_);
#line 209 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (self->priv->color_chooser);
#line 209 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self->priv->color_chooser = _tmp0_;
#line 210 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp1_ = self->priv->color_chooser;
#line 210 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_set (_tmp1_, "show-editor", TRUE, NULL);
#line 212 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp2_ = self->priv->color_chooser;
#line 212 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_container_get_type ()) ? ((GtkContainer*) _tmp2_) : NULL);
#line 212 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	container = _tmp3_;
#line 214 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp4_ = (GtkGrid*) gtk_grid_new ();
#line 214 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp4_);
#line 214 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	color_chooser_grid = _tmp4_;
#line 215 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp5_ = color_chooser_grid;
#line 215 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_grid_set_row_spacing (_tmp5_, 6);
#line 216 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp6_ = color_chooser_grid;
#line 216 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp6_, 6);
#line 218 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp7_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, 0.0, 1.0, 0.000001);
#line 218 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp7_);
#line 218 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	hue_scale = _tmp7_;
#line 219 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp8_ = hue_scale;
#line 219 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_set ((GtkWidget*) _tmp8_, "expand", TRUE, NULL);
#line 220 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp9_ = hue_scale;
#line 220 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_scale_set_draw_value (_tmp9_, FALSE);
#line 222 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp10_ = container;
#line 222 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp11_ = gtk_container_get_children (_tmp10_);
#line 767 "ColorChooser.c"
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
#line 222 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		child_collection = _tmp11_;
#line 222 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 775 "ColorChooser.c"
			GtkWidget* child = NULL;
#line 222 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			child = (GtkWidget*) child_it->data;
#line 779 "ColorChooser.c"
			{
				GtkWidget* _tmp12_;
				gboolean _tmp13_;
				gboolean _tmp14_;
#line 223 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				_tmp12_ = child;
#line 223 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				_tmp13_ = gtk_widget_get_visible (_tmp12_);
#line 223 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				_tmp14_ = _tmp13_;
#line 223 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				if (_tmp14_) {
#line 792 "ColorChooser.c"
					GtkWidget* color_editor = NULL;
					GtkWidget* _tmp15_;
					GList* _tmp16_;
					GList* _tmp17_;
					gconstpointer _tmp18_;
					GtkWidget* _tmp19_;
					GtkWidget* _tmp20_;
					GtkWidget* overlay = NULL;
					GtkWidget* _tmp21_;
					GList* _tmp22_;
					GList* _tmp23_;
					gconstpointer _tmp24_;
					GtkWidget* _tmp25_;
					GtkWidget* _tmp26_;
					GtkGrid* grid = NULL;
					GtkWidget* _tmp27_;
					GList* _tmp28_;
					GList* _tmp29_;
					gconstpointer _tmp30_;
					GtkGrid* _tmp31_;
					GtkGrid* _tmp32_;
					GtkGrid* _tmp33_;
					GList* _tmp34_;
#line 224 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp15_ = child;
#line 224 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp16_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_container_get_type (), GtkContainer));
#line 224 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp17_ = _tmp16_;
#line 224 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp18_ = g_list_nth_data (_tmp17_, (guint) 0);
#line 224 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp19_ = _g_object_ref0 ((GtkWidget*) _tmp18_);
#line 224 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp20_ = _tmp19_;
#line 224 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					(_tmp17_ == NULL) ? NULL : (_tmp17_ = (g_list_free (_tmp17_), NULL));
#line 224 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					color_editor = _tmp20_;
#line 225 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp21_ = color_editor;
#line 225 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp22_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_container_get_type (), GtkContainer));
#line 225 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp23_ = _tmp22_;
#line 225 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp24_ = g_list_nth_data (_tmp23_, (guint) 0);
#line 225 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp25_ = _g_object_ref0 ((GtkWidget*) _tmp24_);
#line 225 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp26_ = _tmp25_;
#line 225 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					(_tmp23_ == NULL) ? NULL : (_tmp23_ = (g_list_free (_tmp23_), NULL));
#line 225 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					overlay = _tmp26_;
#line 226 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp27_ = overlay;
#line 226 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp28_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_container_get_type (), GtkContainer));
#line 226 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp29_ = _tmp28_;
#line 226 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp30_ = g_list_nth_data (_tmp29_, (guint) 0);
#line 226 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp30_, gtk_grid_get_type (), GtkGrid));
#line 226 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp32_ = _tmp31_;
#line 226 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					(_tmp29_ == NULL) ? NULL : (_tmp29_ = (g_list_free (_tmp29_), NULL));
#line 226 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					grid = _tmp32_;
#line 228 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp33_ = grid;
#line 228 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp34_ = gtk_container_get_children ((GtkContainer*) _tmp33_);
#line 868 "ColorChooser.c"
					{
						GList* picker_part_collection = NULL;
						GList* picker_part_it = NULL;
#line 228 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
						picker_part_collection = _tmp34_;
#line 228 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
						for (picker_part_it = picker_part_collection; picker_part_it != NULL; picker_part_it = picker_part_it->next) {
#line 876 "ColorChooser.c"
							GtkWidget* picker_part = NULL;
#line 228 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
							picker_part = (GtkWidget*) picker_part_it->data;
#line 880 "ColorChooser.c"
							{
								GtkWidget* _tmp35_;
								const gchar* _tmp36_;
								const gchar* _tmp37_;
								const gchar* _tmp38_;
								GQuark _tmp40_ = 0U;
#line 229 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
								static GQuark _tmp39_label0 = 0;
#line 229 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
								static GQuark _tmp39_label1 = 0;
#line 229 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
								_tmp35_ = picker_part;
#line 229 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
								_tmp36_ = gtk_widget_get_name (_tmp35_);
#line 229 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
								_tmp37_ = _tmp36_;
#line 229 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
								_tmp38_ = _tmp37_;
#line 229 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
								_tmp40_ = (NULL == _tmp38_) ? 0 : g_quark_from_string (_tmp38_);
#line 229 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
								if (_tmp40_ == ((0 != _tmp39_label0) ? _tmp39_label0 : (_tmp39_label0 = g_quark_from_static_string ("GtkColorPlane")))) {
#line 229 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
									switch (0) {
#line 905 "ColorChooser.c"
										default:
										{
											GtkWidget* _tmp41_;
											GtkWidget* _tmp42_;
											GtkGrid* _tmp43_;
											GtkWidget* _tmp44_;
											GtkGrid* _tmp45_;
											GtkWidget* _tmp46_;
#line 231 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											_tmp41_ = picker_part;
#line 231 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											g_object_set (_tmp41_, "height-request", 255, NULL);
#line 232 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											_tmp42_ = picker_part;
#line 232 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											g_object_set (_tmp42_, "width-request", 255, NULL);
#line 233 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											_tmp43_ = grid;
#line 233 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											_tmp44_ = picker_part;
#line 233 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											gtk_container_remove ((GtkContainer*) _tmp43_, _tmp44_);
#line 234 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											_tmp45_ = color_chooser_grid;
#line 234 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											_tmp46_ = picker_part;
#line 234 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											gtk_grid_attach (_tmp45_, _tmp46_, 0, 0, 3, 1);
#line 235 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											break;
#line 936 "ColorChooser.c"
										}
									}
								} else if (_tmp40_ == ((0 != _tmp39_label1) ? _tmp39_label1 : (_tmp39_label1 = g_quark_from_static_string ("GtkColorScale")))) {
#line 229 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
									switch (0) {
#line 942 "ColorChooser.c"
										default:
										{
											GtkScale* scale = NULL;
											GtkWidget* _tmp47_;
											GtkScale* _tmp48_;
											GtkGrid* _tmp49_;
											GtkWidget* _tmp50_;
											GtkScale* _tmp51_;
											GtkOrientation _tmp52_;
											GtkOrientation _tmp53_;
#line 237 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											_tmp47_ = picker_part;
#line 237 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											_tmp48_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, gtk_scale_get_type ()) ? ((GtkScale*) _tmp47_) : NULL);
#line 237 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											scale = _tmp48_;
#line 238 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											_tmp49_ = grid;
#line 238 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											_tmp50_ = picker_part;
#line 238 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											gtk_container_remove ((GtkContainer*) _tmp49_, _tmp50_);
#line 239 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											_tmp51_ = scale;
#line 239 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											_tmp52_ = gtk_orientable_get_orientation ((GtkOrientable*) _tmp51_);
#line 239 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											_tmp53_ = _tmp52_;
#line 239 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											if (_tmp53_ == GTK_ORIENTATION_VERTICAL) {
#line 973 "ColorChooser.c"
												GtkGrid* _tmp54_;
												GtkScale* _tmp55_;
#line 240 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
												_tmp54_ = color_chooser_grid;
#line 240 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
												_tmp55_ = scale;
#line 240 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
												gtk_grid_attach (_tmp54_, (GtkWidget*) _tmp55_, 4, 0, 1, 1);
#line 982 "ColorChooser.c"
											} else {
												gboolean _tmp56_;
#line 241 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
												_tmp56_ = self->priv->_use_alpha;
#line 241 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
												if (_tmp56_) {
#line 989 "ColorChooser.c"
													GtkWidget* _tmp57_;
													GtkGrid* _tmp58_;
													GtkWidget* _tmp59_;
#line 242 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
													_tmp57_ = picker_part;
#line 242 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
													g_object_set (_tmp57_, "expand", TRUE, NULL);
#line 243 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
													_tmp58_ = color_chooser_grid;
#line 243 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
													_tmp59_ = picker_part;
#line 243 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
													gtk_grid_attach (_tmp58_, _tmp59_, 1, 2, 1, 1);
#line 1003 "ColorChooser.c"
												}
											}
#line 245 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											_g_object_unref0 (scale);
#line 245 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
											break;
#line 1010 "ColorChooser.c"
										}
									}
								}
							}
						}
#line 228 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
						(picker_part_collection == NULL) ? NULL : (picker_part_collection = (g_list_free (picker_part_collection), NULL));
#line 1018 "ColorChooser.c"
					}
#line 223 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_g_object_unref0 (grid);
#line 223 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_g_object_unref0 (overlay);
#line 223 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_g_object_unref0 (color_editor);
#line 1026 "ColorChooser.c"
				}
			}
		}
#line 222 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
#line 1032 "ColorChooser.c"
	}
#line 251 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp60_ = (GtkButton*) gtk_button_new_from_icon_name ("color-select-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 251 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp60_);
#line 251 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	color_picker_button = _tmp60_;
#line 252 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) color_picker_button, _ ("Pick Color"));
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_margin_end ((GtkWidget*) color_picker_button, 6);
#line 254 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_halign ((GtkWidget*) color_picker_button, GTK_ALIGN_START);
#line 256 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_signal_connect_object (color_picker_button, "clicked", (GCallback) ___lambda39__gtk_button_clicked, self, 0);
#line 280 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp61_ = color_chooser_grid;
#line 280 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_grid_attach (_tmp61_, (GtkWidget*) color_picker_button, 0, 1, 1, 2);
#line 282 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp62_ = self->priv->color_chooser;
#line 282 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp63_ = g_signal_connect_object ((GObject*) _tmp62_, "notify::rgba", (GCallback) ___lambda43__g_object_notify, self, 0);
#line 282 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self->priv->color_chooser_signal = _tmp63_;
#line 286 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp64_ = self->priv->colors_grid_stack;
#line 286 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp65_ = color_chooser_grid;
#line 286 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_stack_add_named (_tmp64_, (GtkWidget*) _tmp65_, "custom");
#line 208 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (color_picker_button);
#line 208 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (hue_scale);
#line 208 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (color_chooser_grid);
#line 208 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (container);
#line 1072 "ColorChooser.c"
}

void
spice_color_chooser_generate_colors (SpiceColorChooser* self)
{
#line 289 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (self != NULL);
#line 1080 "ColorChooser.c"
	{
		gint i = 0;
#line 290 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		i = 0;
#line 1085 "ColorChooser.c"
		{
			gboolean _tmp0_ = FALSE;
#line 290 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_tmp0_ = TRUE;
#line 290 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			while (TRUE) {
#line 290 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				if (!_tmp0_) {
#line 1094 "ColorChooser.c"
					gint _tmp1_;
#line 290 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp1_ = i;
#line 290 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					i = _tmp1_ + 1;
#line 1100 "ColorChooser.c"
				}
#line 290 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				_tmp0_ = FALSE;
#line 290 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				if (!(i < 3)) {
#line 290 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					break;
#line 1108 "ColorChooser.c"
				}
				{
					gint j = 0;
#line 291 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					j = 0;
#line 1114 "ColorChooser.c"
					{
						gboolean _tmp2_ = FALSE;
#line 291 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
						_tmp2_ = TRUE;
#line 291 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
						while (TRUE) {
#line 1121 "ColorChooser.c"
							const gchar* _tmp4_;
#line 291 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
							if (!_tmp2_) {
#line 1125 "ColorChooser.c"
								gint _tmp3_;
#line 291 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
								_tmp3_ = j;
#line 291 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
								j = _tmp3_ + 1;
#line 1131 "ColorChooser.c"
							}
#line 291 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
							_tmp2_ = FALSE;
#line 291 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
							if (!(j < 20)) {
#line 291 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
								break;
#line 1139 "ColorChooser.c"
							}
#line 292 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
							_tmp4_ = SPICE_COLOR_CHOOSER_COLOR_PALETTE[i][j];
#line 292 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
							spice_color_chooser_attach_color (self, _tmp4_, j, i);
#line 1145 "ColorChooser.c"
						}
					}
				}
			}
		}
	}
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_atomic_int_inc (&_data17_->_ref_count_);
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	return _data17_;
#line 1161 "ColorChooser.c"
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
#line 1171 "ColorChooser.c"
		SpiceColorChooser* self;
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		self = _data17_->self;
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_g_free0 (_data17_->color);
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_g_object_unref0 (self);
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		g_slice_free (Block17Data, _data17_);
#line 1181 "ColorChooser.c"
	}
}

static void
__lambda37_ (Block17Data* _data17_)
{
	SpiceColorChooser* self;
#line 306 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self = _data17_->self;
#line 307 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	spice_color_chooser_set_color_smart (self, _data17_->color, TRUE, FALSE, FALSE);
#line 1193 "ColorChooser.c"
}

static void
___lambda37__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 306 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	__lambda37_ (self);
#line 1202 "ColorChooser.c"
}

static void
spice_color_chooser_attach_color (SpiceColorChooser* self,
                                  const gchar* color,
                                  gint x,
                                  gint y)
{
	Block17Data* _data17_;
	gchar* _tmp0_;
	SpiceColorButton* color_button = NULL;
	SpiceColorButton* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkGrid* _tmp3_;
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (self != NULL);
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (color != NULL);
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_data17_ = g_slice_new0 (Block17Data);
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_data17_->_ref_count_ = 1;
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_data17_->self = g_object_ref (self);
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = g_strdup (color);
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_free0 (_data17_->color);
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_data17_->color = _tmp0_;
#line 298 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp1_ = spice_color_button_new (_data17_->color);
#line 298 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp1_);
#line 298 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	color_button = _tmp1_;
#line 299 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) color_button);
#line 299 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_style_context_add_class (_tmp2_, "flat");
#line 300 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	spice_color_button_set_size (color_button, 14, 84);
#line 301 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_can_focus ((GtkWidget*) color_button, TRUE);
#line 302 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_margin_end ((GtkWidget*) color_button, 0);
#line 304 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp3_ = self->priv->colors_grid;
#line 304 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_grid_attach (_tmp3_, (GtkWidget*) color_button, x, y, 1, 1);
#line 306 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_signal_connect_data ((GtkButton*) color_button, "clicked", (GCallback) ___lambda37__gtk_button_clicked, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (color_button);
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	block17_data_unref (_data17_);
#line 297 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_data17_ = NULL;
#line 1261 "ColorChooser.c"
}

static void
spice_color_chooser_make_gradient_palete (SpiceColorChooser* self)
{
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStack* _tmp4_;
	GtkGrid* _tmp5_;
#line 311 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (self != NULL);
#line 312 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
#line 312 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp0_);
#line 312 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (self->priv->gradient_colors_grid);
#line 312 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self->priv->gradient_colors_grid = _tmp0_;
#line 313 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp1_ = self->priv->gradient_colors_grid;
#line 313 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_set ((GtkWidget*) _tmp1_, "margin", 6, NULL);
#line 314 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp2_ = self->priv->gradient_colors_grid;
#line 314 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
#line 314 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_style_context_add_class (_tmp3_, "card");
#line 316 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	spice_color_chooser_generate_gradient_colors (self);
#line 317 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp4_ = self->priv->colors_grid_stack;
#line 317 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp5_ = self->priv->gradient_colors_grid;
#line 317 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_stack_add_named (_tmp4_, (GtkWidget*) _tmp5_, "gradients");
#line 1301 "ColorChooser.c"
}

void
spice_color_chooser_generate_gradient_colors (SpiceColorChooser* self)
{
#line 320 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (self != NULL);
#line 1309 "ColorChooser.c"
	{
		gint i = 0;
#line 321 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		i = 0;
#line 1314 "ColorChooser.c"
		{
			gboolean _tmp0_ = FALSE;
#line 321 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_tmp0_ = TRUE;
#line 321 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			while (TRUE) {
#line 321 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				if (!_tmp0_) {
#line 1323 "ColorChooser.c"
					gint _tmp1_;
#line 321 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					_tmp1_ = i;
#line 321 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					i = _tmp1_ + 1;
#line 1329 "ColorChooser.c"
				}
#line 321 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				_tmp0_ = FALSE;
#line 321 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				if (!(i < 6)) {
#line 321 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					break;
#line 1337 "ColorChooser.c"
				}
				{
					gint j = 0;
#line 322 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
					j = 0;
#line 1343 "ColorChooser.c"
					{
						gboolean _tmp2_ = FALSE;
#line 322 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
						_tmp2_ = TRUE;
#line 322 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
						while (TRUE) {
#line 1350 "ColorChooser.c"
							const gchar* _tmp4_;
#line 322 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
							if (!_tmp2_) {
#line 1354 "ColorChooser.c"
								gint _tmp3_;
#line 322 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
								_tmp3_ = j;
#line 322 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
								j = _tmp3_ + 1;
#line 1360 "ColorChooser.c"
							}
#line 322 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
							_tmp2_ = FALSE;
#line 322 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
							if (!(j < 4)) {
#line 322 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
								break;
#line 1368 "ColorChooser.c"
							}
#line 323 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
							_tmp4_ = SPICE_COLOR_CHOOSER_GRADIENT_PALETTE[i][j];
#line 323 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
							spice_color_chooser_attach_gradient (self, _tmp4_, j, i);
#line 1374 "ColorChooser.c"
						}
					}
				}
			}
		}
	}
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
#line 328 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_atomic_int_inc (&_data18_->_ref_count_);
#line 328 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	return _data18_;
#line 1390 "ColorChooser.c"
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
#line 328 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
#line 1400 "ColorChooser.c"
		SpiceColorChooser* self;
#line 328 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		self = _data18_->self;
#line 328 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_g_free0 (_data18_->color);
#line 328 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_g_object_unref0 (self);
#line 328 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		g_slice_free (Block18Data, _data18_);
#line 1410 "ColorChooser.c"
	}
}

static void
__lambda38_ (Block18Data* _data18_)
{
	SpiceColorChooser* self;
#line 337 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self = _data18_->self;
#line 338 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	spice_color_chooser_set_color_smart (self, _data18_->color, TRUE, TRUE, FALSE);
#line 1422 "ColorChooser.c"
}

static void
___lambda38__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 337 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	__lambda38_ (self);
#line 1431 "ColorChooser.c"
}

static void
spice_color_chooser_attach_gradient (SpiceColorChooser* self,
                                     const gchar* color,
                                     gint x,
                                     gint y)
{
	Block18Data* _data18_;
	gchar* _tmp0_;
	SpiceColorButton* color_button = NULL;
	SpiceColorButton* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkGrid* _tmp3_;
#line 328 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (self != NULL);
#line 328 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (color != NULL);
#line 328 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_data18_ = g_slice_new0 (Block18Data);
#line 328 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_data18_->_ref_count_ = 1;
#line 328 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_data18_->self = g_object_ref (self);
#line 328 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = g_strdup (color);
#line 328 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_free0 (_data18_->color);
#line 328 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_data18_->color = _tmp0_;
#line 329 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp1_ = spice_color_button_new (_data18_->color);
#line 329 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp1_);
#line 329 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	color_button = _tmp1_;
#line 330 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_size_request ((GtkWidget*) color_button, 70, 42);
#line 331 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) color_button);
#line 331 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_style_context_add_class (_tmp2_, "flat");
#line 332 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_can_focus ((GtkWidget*) color_button, TRUE);
#line 333 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_margin_end ((GtkWidget*) color_button, 0);
#line 335 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp3_ = self->priv->gradient_colors_grid;
#line 335 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_grid_attach (_tmp3_, (GtkWidget*) color_button, x, y, 1, 1);
#line 337 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_signal_connect_data ((GtkButton*) color_button, "clicked", (GCallback) ___lambda38__gtk_button_clicked, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
#line 328 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (color_button);
#line 328 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	block18_data_unref (_data18_);
#line 328 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_data18_ = NULL;
#line 1490 "ColorChooser.c"
}

void
spice_color_chooser_set_color_smart (SpiceColorChooser* self,
                                     const gchar* color,
                                     gboolean from_button,
                                     gboolean overwite_gradient,
                                     gboolean from_gradient_editor)
{
	GtkRevealer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 342 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (self != NULL);
#line 342 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (color != NULL);
#line 343 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = self->gradient_revealer;
#line 343 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp1_ = gtk_revealer_get_reveal_child (_tmp0_);
#line 343 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp2_ = _tmp1_;
#line 343 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	if (_tmp2_) {
#line 344 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		if (from_gradient_editor) {
#line 345 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			spice_color_button_set_color (G_TYPE_CHECK_INSTANCE_CAST (self, SPICE_TYPE_COLOR_BUTTON, SpiceColorButton), color);
#line 1519 "ColorChooser.c"
		} else {
			SpiceGradientEditor* _tmp3_;
			SpiceGradientEditor* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
#line 347 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_tmp3_ = self->gradient_editor;
#line 347 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			spice_gradient_editor_set_color (_tmp3_, color, overwite_gradient);
#line 348 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_tmp4_ = self->gradient_editor;
#line 348 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_tmp5_ = spice_gradient_editor_make_gradient (_tmp4_);
#line 348 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_tmp6_ = _tmp5_;
#line 348 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			spice_color_button_set_color (G_TYPE_CHECK_INSTANCE_CAST (self, SPICE_TYPE_COLOR_BUTTON, SpiceColorButton), _tmp6_);
#line 348 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_g_free0 (_tmp6_);
#line 1539 "ColorChooser.c"
		}
	} else {
		SpiceGradientEditor* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
#line 351 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_tmp7_ = self->gradient_editor;
#line 351 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		spice_gradient_editor_parse_gradient (_tmp7_, color, FALSE);
#line 352 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_tmp8_ = spice_color_chooser_get_gradient (self);
#line 352 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_tmp9_ = _tmp8_;
#line 352 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		if (_tmp9_) {
#line 1555 "ColorChooser.c"
			SpiceGradientEditor* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
#line 353 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_tmp10_ = self->gradient_editor;
#line 353 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_tmp11_ = spice_gradient_editor_make_gradient (_tmp10_);
#line 353 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_tmp12_ = _tmp11_;
#line 353 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			spice_color_button_set_color (G_TYPE_CHECK_INSTANCE_CAST (self, SPICE_TYPE_COLOR_BUTTON, SpiceColorButton), _tmp12_);
#line 353 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_g_free0 (_tmp12_);
#line 1569 "ColorChooser.c"
		} else {
			SpiceGradientGradientStep* first_step = NULL;
			SpiceGradientEditor* _tmp13_;
			SpiceGradient* _tmp14_;
			SpiceGradient* _tmp15_;
			SpiceGradientGradientStep* _tmp16_;
			SpiceGradientGradientStep* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
#line 355 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_tmp13_ = self->gradient_editor;
#line 355 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_tmp14_ = spice_gradient_editor_get_gradient (_tmp13_);
#line 355 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_tmp15_ = _tmp14_;
#line 355 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_tmp16_ = spice_gradient_get_color (_tmp15_, 0);
#line 355 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			first_step = _tmp16_;
#line 356 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_tmp17_ = first_step;
#line 356 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_tmp18_ = spice_gradient_gradient_step_get_color (_tmp17_);
#line 356 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_tmp19_ = _tmp18_;
#line 356 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			spice_color_button_set_color (G_TYPE_CHECK_INSTANCE_CAST (self, SPICE_TYPE_COLOR_BUTTON, SpiceColorButton), _tmp19_);
#line 352 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_g_object_unref0 (first_step);
#line 1599 "ColorChooser.c"
		}
	}
#line 360 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	if (from_button) {
#line 361 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		spice_color_chooser_set_color_chooser_color (self, color);
#line 1606 "ColorChooser.c"
	}
#line 364 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	if (!self->priv->setting_color) {
#line 1610 "ColorChooser.c"
		const gchar* _tmp20_;
		const gchar* _tmp21_;
#line 365 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_tmp20_ = spice_color_chooser_get_color (self);
#line 365 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_tmp21_ = _tmp20_;
#line 365 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		g_signal_emit (self, spice_color_chooser_signals[SPICE_COLOR_CHOOSER_COLOR_PICKED_SIGNAL], 0, _tmp21_);
#line 1619 "ColorChooser.c"
	}
}

static void
spice_color_chooser_set_color_chooser_color (SpiceColorChooser* self,
                                             const gchar* color)
{
	GtkColorChooserWidget* _tmp0_;
	GdkRGBA rgba = {0};
	GtkColorChooserWidget* _tmp1_;
	GdkRGBA _tmp2_;
	GtkColorChooserWidget* _tmp3_;
#line 369 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (self != NULL);
#line 369 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (color != NULL);
#line 370 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = self->priv->color_chooser;
#line 370 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_signal_handler_block (_tmp0_, self->priv->color_chooser_signal);
#line 372 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	memset (&rgba, 0, sizeof (GdkRGBA));
#line 373 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gdk_rgba_parse (&rgba, color);
#line 374 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp1_ = self->priv->color_chooser;
#line 374 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp2_ = rgba;
#line 374 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp1_, &_tmp2_);
#line 376 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp3_ = self->priv->color_chooser;
#line 376 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_signal_handler_unblock (_tmp3_, self->priv->color_chooser_signal);
#line 1654 "ColorChooser.c"
}

gboolean
spice_color_chooser_get_gradient (SpiceColorChooser* self)
{
	gboolean result;
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 26 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 27 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = self->priv->gradient_button;
#line 27 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
#line 27 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp2_ = _tmp1_;
#line 27 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	result = _tmp2_;
#line 27 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	return result;
#line 1676 "ColorChooser.c"
}

void
spice_color_chooser_set_gradient (SpiceColorChooser* self,
                                  gboolean value)
{
	GtkToggleButton* _tmp0_;
	GtkToggleButton* _tmp1_;
	GtkRevealer* _tmp2_;
	GtkRevealer* _tmp3_;
	GtkRevealer* _tmp4_;
	gboolean _tmp5_ = FALSE;
#line 30 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (self != NULL);
#line 31 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = self->priv->gradient_button;
#line 31 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, value);
#line 32 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp1_ = self->priv->gradient_button;
#line 32 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp1_, !value);
#line 34 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp2_ = self->gradient_revealer;
#line 34 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, value);
#line 35 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp3_ = self->gradient_revealer;
#line 35 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp3_, !value);
#line 36 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp4_ = self->gradient_revealer;
#line 36 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_revealer_set_reveal_child (_tmp4_, FALSE);
#line 38 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	if (value) {
#line 1713 "ColorChooser.c"
		GtkGrid* _tmp6_;
#line 38 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_tmp6_ = self->priv->gradient_colors_grid;
#line 38 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_tmp5_ = _tmp6_ == NULL;
#line 1719 "ColorChooser.c"
	} else {
#line 38 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_tmp5_ = FALSE;
#line 1723 "ColorChooser.c"
	}
#line 38 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	if (_tmp5_) {
#line 1727 "ColorChooser.c"
		GraniteWidgetsModeButton* _tmp7_;
		GtkImage* _tmp8_;
		GtkImage* _tmp9_;
#line 39 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_tmp7_ = self->priv->mode_button;
#line 39 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_tmp8_ = (GtkImage*) gtk_image_new_from_resource ("/com/github/philip-scott/spice-up/gradient-palette-symbolic.svg");
#line 39 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		g_object_ref_sink (_tmp8_);
#line 39 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_tmp9_ = _tmp8_;
#line 39 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		granite_widgets_mode_button_append (_tmp7_, (GtkWidget*) _tmp9_);
#line 39 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_g_object_unref0 (_tmp9_);
#line 40 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		spice_color_chooser_make_gradient_palete (self);
#line 1745 "ColorChooser.c"
	}
#line 30 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_notify_by_pspec ((GObject *) self, spice_color_chooser_properties[SPICE_COLOR_CHOOSER_GRADIENT_PROPERTY]);
#line 1749 "ColorChooser.c"
}

const gchar*
spice_color_chooser_get_color (SpiceColorChooser* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 47 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 48 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = ((SpiceColorButton*) self)->_color;
#line 48 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	result = _tmp0_;
#line 48 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	return result;
#line 1765 "ColorChooser.c"
}

void
spice_color_chooser_set_color (SpiceColorChooser* self,
                               const gchar* value)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 49 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (self != NULL);
#line 50 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self->priv->setting_color = TRUE;
#line 51 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	spice_color_chooser_set_color_smart (self, value, TRUE, TRUE, FALSE);
#line 53 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = spice_color_chooser_get_gradient (self);
#line 53 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp1_ = _tmp0_;
#line 53 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	if (_tmp1_) {
#line 1786 "ColorChooser.c"
		SpiceGradientEditor* _tmp2_;
#line 54 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_tmp2_ = self->gradient_editor;
#line 54 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		spice_gradient_editor_parse_gradient (_tmp2_, value, FALSE);
#line 1792 "ColorChooser.c"
	}
#line 56 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self->priv->setting_color = FALSE;
#line 49 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_notify_by_pspec ((GObject *) self, spice_color_chooser_properties[SPICE_COLOR_CHOOSER_COLOR_PROPERTY]);
#line 1798 "ColorChooser.c"
}

gboolean
spice_color_chooser_get_use_alpha (SpiceColorChooser* self)
{
	gboolean result;
#line 60 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 60 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	result = self->priv->_use_alpha;
#line 60 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	return result;
#line 1811 "ColorChooser.c"
}

void
spice_color_chooser_set_use_alpha (SpiceColorChooser* self,
                                   gboolean value)
{
	gboolean old_value;
#line 60 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (self != NULL);
#line 60 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	old_value = spice_color_chooser_get_use_alpha (self);
#line 60 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	if (old_value != value) {
#line 60 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		self->priv->_use_alpha = value;
#line 60 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_color_chooser_properties[SPICE_COLOR_CHOOSER_USE_ALPHA_PROPERTY]);
#line 1829 "ColorChooser.c"
	}
}

static void
_spice_color_chooser___lambda44_ (SpiceColorChooser* self,
                                  gint index,
                                  GtkWidget* widget)
{
#line 102 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (widget != NULL);
#line 103 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	switch (index) {
#line 103 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		case 0:
#line 1844 "ColorChooser.c"
		{
#line 104 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			gtk_widget_set_tooltip_text (widget, _ ("Color Palette"));
#line 104 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			break;
#line 1850 "ColorChooser.c"
		}
#line 103 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		case 1:
#line 1854 "ColorChooser.c"
		{
#line 105 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			gtk_widget_set_tooltip_text (widget, _ ("Custom Color"));
#line 105 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			break;
#line 1860 "ColorChooser.c"
		}
#line 103 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		case 2:
#line 1864 "ColorChooser.c"
		{
#line 106 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			gtk_widget_set_tooltip_text (widget, _ ("Gradient Palette"));
#line 106 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			break;
#line 1870 "ColorChooser.c"
		}
		default:
#line 103 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		break;
#line 1875 "ColorChooser.c"
	}
}

static void
__spice_color_chooser___lambda44__granite_widgets_mode_button_mode_added (GraniteWidgetsModeButton* _sender,
                                                                          gint index,
                                                                          GtkWidget* widget,
                                                                          gpointer self)
{
#line 102 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_spice_color_chooser___lambda44_ ((SpiceColorChooser*) self, index, widget);
#line 1887 "ColorChooser.c"
}

static void
_spice_color_chooser___lambda45_ (SpiceColorChooser* self,
                                  GtkWidget* w)
{
	GraniteWidgetsModeButton* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 115 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (w != NULL);
#line 116 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = self->priv->mode_button;
#line 116 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp1_ = granite_widgets_mode_button_get_selected (_tmp0_);
#line 116 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp2_ = _tmp1_;
#line 116 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	switch (_tmp2_) {
#line 116 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		case 0:
#line 1909 "ColorChooser.c"
		{
			GtkStack* _tmp3_;
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_tmp3_ = self->priv->colors_grid_stack;
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			gtk_stack_set_visible_child_name (_tmp3_, "palete");
#line 119 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			break;
#line 1918 "ColorChooser.c"
		}
#line 116 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		case 1:
#line 1922 "ColorChooser.c"
		{
			GtkStack* _tmp4_;
#line 121 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_tmp4_ = self->priv->colors_grid_stack;
#line 121 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			gtk_stack_set_visible_child_name (_tmp4_, "custom");
#line 122 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			break;
#line 1931 "ColorChooser.c"
		}
#line 116 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		case 2:
#line 1935 "ColorChooser.c"
		{
			GtkStack* _tmp5_;
#line 124 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			_tmp5_ = self->priv->colors_grid_stack;
#line 124 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			gtk_stack_set_visible_child_name (_tmp5_, "gradients");
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			break;
#line 1944 "ColorChooser.c"
		}
		default:
#line 116 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		break;
#line 1949 "ColorChooser.c"
	}
}

static void
__spice_color_chooser___lambda45__granite_widgets_mode_button_mode_changed (GraniteWidgetsModeButton* _sender,
                                                                            GtkWidget* widget,
                                                                            gpointer self)
{
#line 115 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_spice_color_chooser___lambda45_ ((SpiceColorChooser*) self, widget);
#line 1960 "ColorChooser.c"
}

static void
_spice_color_chooser___lambda46_ (SpiceColorChooser* self)
{
	GtkRevealer* _tmp0_;
	GtkToggleButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
#line 136 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = self->gradient_revealer;
#line 136 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp1_ = self->priv->gradient_button;
#line 136 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
#line 136 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp3_ = _tmp2_;
#line 136 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_revealer_set_reveal_child (_tmp0_, _tmp3_);
#line 1980 "ColorChooser.c"
}

static void
__spice_color_chooser___lambda46__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                             gpointer self)
{
#line 135 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_spice_color_chooser___lambda46_ ((SpiceColorChooser*) self);
#line 1989 "ColorChooser.c"
}

static void
_spice_color_chooser___lambda47_ (SpiceColorChooser* self,
                                  gint index,
                                  const gchar* color)
{
#line 152 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_if_fail (color != NULL);
#line 153 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	spice_color_chooser_set_color_chooser_color (self, color);
#line 2001 "ColorChooser.c"
}

static void
__spice_color_chooser___lambda47__spice_gradient_editor_color_selected (SpiceGradientEditor* _sender,
                                                                        gint index,
                                                                        const gchar* color,
                                                                        gpointer self)
{
#line 152 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_spice_color_chooser___lambda47_ ((SpiceColorChooser*) self, index, color);
#line 2012 "ColorChooser.c"
}

static void
_spice_color_chooser___lambda48_ (SpiceColorChooser* self)
{
	SpiceGradientEditor* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 157 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = self->gradient_editor;
#line 157 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp1_ = spice_gradient_editor_make_gradient (_tmp0_);
#line 157 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp2_ = _tmp1_;
#line 157 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	spice_color_chooser_set_color_smart (self, _tmp2_, FALSE, FALSE, TRUE);
#line 157 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_free0 (_tmp2_);
#line 2031 "ColorChooser.c"
}

static void
__spice_color_chooser___lambda48__spice_gradient_editor_updated (SpiceGradientEditor* _sender,
                                                                 gpointer self)
{
#line 156 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_spice_color_chooser___lambda48_ ((SpiceColorChooser*) self);
#line 2040 "ColorChooser.c"
}

static gboolean
_spice_color_chooser___lambda49_ (SpiceColorChooser* self,
                                  GtkWidget* source,
                                  GdkEventKey* key)
{
	gboolean result;
#line 171 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_val_if_fail (source != NULL, FALSE);
#line 171 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 173 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	if ((key->state & GDK_CONTROL_MASK) == GDK_CONTROL_MASK) {
#line 2055 "ColorChooser.c"
		GtkClipboard* clipboard = NULL;
		GtkClipboard* _tmp0_;
		GtkClipboard* _tmp1_;
#line 174 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_tmp0_ = gtk_clipboard_get (gdk_atom_intern_static_string ("SPICE_UP_COLOR"));
#line 174 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 174 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		clipboard = _tmp1_;
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		switch (key->keyval) {
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			case 99:
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			case 120:
#line 2071 "ColorChooser.c"
			{
				GtkClipboard* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
#line 178 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				_tmp2_ = clipboard;
#line 178 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				_tmp3_ = spice_color_chooser_get_color (self);
#line 178 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				_tmp4_ = _tmp3_;
#line 178 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				gtk_clipboard_set_text (_tmp2_, _tmp4_, -1);
#line 179 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				result = TRUE;
#line 179 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				_g_object_unref0 (clipboard);
#line 179 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				return result;
#line 2090 "ColorChooser.c"
			}
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			case 118:
#line 2094 "ColorChooser.c"
			{
				GtkClipboard* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
#line 181 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				_tmp5_ = clipboard;
#line 181 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				_tmp6_ = gtk_clipboard_wait_for_text (_tmp5_);
#line 181 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				_tmp7_ = _tmp6_;
#line 181 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				spice_color_chooser_set_color_smart (self, _tmp7_, TRUE, TRUE, FALSE);
#line 181 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				_g_free0 (_tmp7_);
#line 182 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				result = TRUE;
#line 182 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				_g_object_unref0 (clipboard);
#line 182 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				return result;
#line 2115 "ColorChooser.c"
			}
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			case 65535:
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			case 65288:
#line 2121 "ColorChooser.c"
			{
#line 185 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				spice_color_chooser_set_color_smart (self, "#FFF", TRUE, TRUE, FALSE);
#line 186 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				result = TRUE;
#line 186 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				_g_object_unref0 (clipboard);
#line 186 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
				return result;
#line 2131 "ColorChooser.c"
			}
			default:
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
			break;
#line 2136 "ColorChooser.c"
		}
#line 173 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		_g_object_unref0 (clipboard);
#line 2140 "ColorChooser.c"
	}
#line 189 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	result = FALSE;
#line 189 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	return result;
#line 2146 "ColorChooser.c"
}

static gboolean
__spice_color_chooser___lambda49__gtk_widget_key_press_event (GtkWidget* _sender,
                                                              GdkEventKey* event,
                                                              gpointer self)
{
	gboolean result;
	result = _spice_color_chooser___lambda49_ ((SpiceColorChooser*) self, _sender, event);
#line 171 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	return result;
#line 2158 "ColorChooser.c"
}

static void
_spice_color_chooser___lambda50_ (SpiceColorChooser* self)
{
	GtkPopover* _tmp0_;
#line 193 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = self->priv->popover;
#line 193 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp0_);
#line 2169 "ColorChooser.c"
}

static void
__spice_color_chooser___lambda50__gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self)
{
#line 192 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_spice_color_chooser___lambda50_ ((SpiceColorChooser*) self);
#line 2178 "ColorChooser.c"
}

static GObject *
spice_color_chooser_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SpiceColorChooser * self;
	GtkStyleContext* _tmp0_;
	GtkEventBox* _tmp1_;
	GtkEventBox* _tmp2_;
	GtkEventBox* _tmp3_;
	GtkEventBox* _tmp4_;
	GtkGrid* main_grid = NULL;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkGrid* button_toolbar = NULL;
	GtkGrid* _tmp7_;
	GtkGrid* _tmp8_;
	GraniteWidgetsModeButton* _tmp9_;
	GraniteWidgetsModeButton* _tmp10_;
	GraniteWidgetsModeButton* _tmp11_;
	GtkImage* _tmp12_;
	GtkImage* _tmp13_;
	GraniteWidgetsModeButton* _tmp14_;
	GtkImage* _tmp15_;
	GtkImage* _tmp16_;
	GraniteWidgetsModeButton* _tmp17_;
	GraniteWidgetsModeButton* _tmp18_;
	GraniteWidgetsModeButton* _tmp19_;
	GtkToggleButton* _tmp20_;
	GtkToggleButton* _tmp21_;
	GtkImage* _tmp22_;
	GtkImage* _tmp23_;
	GtkToggleButton* _tmp24_;
	GtkToggleButton* _tmp25_;
	GtkToggleButton* _tmp26_;
	GtkToggleButton* _tmp27_;
	GtkToggleButton* _tmp28_;
	GtkGrid* _tmp29_;
	GraniteWidgetsModeButton* _tmp30_;
	GtkGrid* _tmp31_;
	GtkToggleButton* _tmp32_;
	GtkStack* _tmp33_;
	GtkStack* _tmp34_;
	GtkRevealer* _tmp35_;
	GtkRevealer* _tmp36_;
	GtkRevealer* _tmp37_;
	SpiceGradientEditor* _tmp38_;
	GtkRevealer* _tmp39_;
	SpiceGradientEditor* _tmp40_;
	SpiceGradientEditor* _tmp41_;
	SpiceGradientEditor* _tmp42_;
	GtkGrid* _tmp43_;
	GtkGrid* _tmp44_;
	GtkGrid* _tmp45_;
	GtkStack* _tmp46_;
	GtkGrid* _tmp47_;
	GtkRevealer* _tmp48_;
	GtkPopover* _tmp49_;
	GtkPopover* _tmp50_;
	GtkPopover* _tmp51_;
	GtkGrid* _tmp52_;
	GtkPopover* _tmp53_;
#line 86 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	parent_class = G_OBJECT_CLASS (spice_color_chooser_parent_class);
#line 86 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 86 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_COLOR_CHOOSER, SpiceColorChooser);
#line 87 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 87 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_style_context_add_class (_tmp0_, "spice");
#line 88 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp1_ = ((SpiceColorButton*) self)->surface;
#line 88 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_CENTER);
#line 89 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp2_ = ((SpiceColorButton*) self)->surface;
#line 89 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp2_, GTK_ALIGN_CENTER);
#line 90 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp3_ = ((SpiceColorButton*) self)->checkered_bg;
#line 90 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp3_, GTK_ALIGN_CENTER);
#line 91 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp4_ = ((SpiceColorButton*) self)->checkered_bg;
#line 91 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_CENTER);
#line 93 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp5_ = (GtkGrid*) gtk_grid_new ();
#line 93 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp5_);
#line 93 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	main_grid = _tmp5_;
#line 94 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp6_ = main_grid;
#line 94 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_set ((GtkWidget*) _tmp6_, "margin", 6, NULL);
#line 97 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp7_ = (GtkGrid*) gtk_grid_new ();
#line 97 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp7_);
#line 97 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	button_toolbar = _tmp7_;
#line 98 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp8_ = button_toolbar;
#line 98 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp8_, GTK_ORIENTATION_HORIZONTAL);
#line 100 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp9_ = granite_widgets_mode_button_new ();
#line 100 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp9_);
#line 100 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (self->priv->mode_button);
#line 100 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self->priv->mode_button = _tmp9_;
#line 102 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp10_ = self->priv->mode_button;
#line 102 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_signal_connect_object (_tmp10_, "mode-added", (GCallback) __spice_color_chooser___lambda44__granite_widgets_mode_button_mode_added, self, 0);
#line 110 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp11_ = self->priv->mode_button;
#line 110 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp12_ = (GtkImage*) gtk_image_new_from_resource ("/com/github/philip-scott/spice-up/color-palette-symbolic.svg");
#line 110 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp12_);
#line 110 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp13_ = _tmp12_;
#line 110 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	granite_widgets_mode_button_append (_tmp11_, (GtkWidget*) _tmp13_);
#line 110 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (_tmp13_);
#line 111 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp14_ = self->priv->mode_button;
#line 111 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp15_ = (GtkImage*) gtk_image_new_from_resource ("/com/github/philip-scott/spice-up/custom-color-symbolic.svg");
#line 111 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp15_);
#line 111 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp16_ = _tmp15_;
#line 111 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	granite_widgets_mode_button_append (_tmp14_, (GtkWidget*) _tmp16_);
#line 111 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (_tmp16_);
#line 112 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp17_ = self->priv->mode_button;
#line 112 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_can_focus ((GtkWidget*) _tmp17_, TRUE);
#line 113 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp18_ = self->priv->mode_button;
#line 113 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	granite_widgets_mode_button_set_selected (_tmp18_, 0);
#line 115 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp19_ = self->priv->mode_button;
#line 115 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_signal_connect_object (_tmp19_, "mode-changed", (GCallback) __spice_color_chooser___lambda45__granite_widgets_mode_button_mode_changed, self, 0);
#line 129 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp20_ = (GtkToggleButton*) gtk_toggle_button_new ();
#line 129 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp20_);
#line 129 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (self->priv->gradient_button);
#line 129 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self->priv->gradient_button = _tmp20_;
#line 130 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp21_ = self->priv->gradient_button;
#line 130 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp22_ = (GtkImage*) gtk_image_new_from_resource ("/com/github/philip-scott/spice-up/gradient-symbolic.svg");
#line 130 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp22_);
#line 130 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp23_ = _tmp22_;
#line 130 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp23_);
#line 130 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (_tmp23_);
#line 131 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp24_ = self->priv->gradient_button;
#line 131 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp24_, _ ("Gradient Editor"));
#line 132 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp25_ = self->priv->gradient_button;
#line 132 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_toggle_button_set_active (_tmp25_, FALSE);
#line 133 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp26_ = self->priv->gradient_button;
#line 133 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp26_, TRUE);
#line 134 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp27_ = self->priv->gradient_button;
#line 134 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp27_, GTK_ALIGN_END);
#line 135 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp28_ = self->priv->gradient_button;
#line 135 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_signal_connect_object (_tmp28_, "toggled", (GCallback) __spice_color_chooser___lambda46__gtk_toggle_button_toggled, self, 0);
#line 139 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp29_ = button_toolbar;
#line 139 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp30_ = self->priv->mode_button;
#line 139 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
#line 140 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp31_ = button_toolbar;
#line 140 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp32_ = self->priv->gradient_button;
#line 140 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp32_);
#line 142 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp33_ = (GtkStack*) gtk_stack_new ();
#line 142 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp33_);
#line 142 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (self->priv->colors_grid_stack);
#line 142 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self->priv->colors_grid_stack = _tmp33_;
#line 143 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp34_ = self->priv->colors_grid_stack;
#line 143 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_stack_set_homogeneous (_tmp34_, FALSE);
#line 145 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp35_ = (GtkRevealer*) gtk_revealer_new ();
#line 145 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp35_);
#line 145 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (self->gradient_revealer);
#line 145 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self->gradient_revealer = _tmp35_;
#line 146 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp36_ = self->gradient_revealer;
#line 146 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_revealer_set_transition_type (_tmp36_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT);
#line 147 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp37_ = self->gradient_revealer;
#line 147 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_set ((GtkWidget*) _tmp37_, "expand", TRUE, NULL);
#line 149 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp38_ = spice_gradient_editor_new (self);
#line 149 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp38_);
#line 149 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (self->gradient_editor);
#line 149 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self->gradient_editor = _tmp38_;
#line 150 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp39_ = self->gradient_revealer;
#line 150 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp40_ = self->gradient_editor;
#line 150 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
#line 152 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp41_ = self->gradient_editor;
#line 152 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_signal_connect_object (_tmp41_, "color-selected", (GCallback) __spice_color_chooser___lambda47__spice_gradient_editor_color_selected, self, 0);
#line 156 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp42_ = self->gradient_editor;
#line 156 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_signal_connect_object (_tmp42_, "updated", (GCallback) __spice_color_chooser___lambda48__spice_gradient_editor_updated, self, 0);
#line 160 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	spice_color_chooser_make_palette_view (self);
#line 161 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	spice_color_chooser_make_custom_view (self);
#line 163 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp43_ = main_grid;
#line 163 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp44_ = button_toolbar;
#line 163 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_grid_attach (_tmp43_, (GtkWidget*) _tmp44_, 0, 0, 5, 1);
#line 164 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp45_ = main_grid;
#line 164 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp46_ = self->priv->colors_grid_stack;
#line 164 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_grid_attach (_tmp45_, (GtkWidget*) _tmp46_, 0, 1, 4, 8);
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp47_ = main_grid;
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp48_ = self->gradient_revealer;
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_grid_attach (_tmp47_, (GtkWidget*) _tmp48_, 4, 1, 1, 8);
#line 167 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp49_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
#line 167 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_ref_sink (_tmp49_);
#line 167 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (self->priv->popover);
#line 167 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self->priv->popover = _tmp49_;
#line 168 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp50_ = self->priv->popover;
#line 168 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_popover_set_position (_tmp50_, GTK_POS_BOTTOM);
#line 169 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp51_ = self->priv->popover;
#line 169 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp52_ = main_grid;
#line 169 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	gtk_container_add ((GtkContainer*) _tmp51_, (GtkWidget*) _tmp52_);
#line 171 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_tmp53_ = self->priv->popover;
#line 171 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_signal_connect_object ((GtkWidget*) _tmp53_, "key-press-event", (GCallback) __spice_color_chooser___lambda49__gtk_widget_key_press_event, self, 0);
#line 192 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_signal_connect_object ((GtkButton*) self, "clicked", (GCallback) __spice_color_chooser___lambda50__gtk_button_clicked, self, 0);
#line 196 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	spice_color_chooser_set_gradient (self, FALSE);
#line 86 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (button_toolbar);
#line 86 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (main_grid);
#line 86 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	return obj;
#line 2495 "ColorChooser.c"
}

static void
spice_color_chooser_class_init (SpiceColorChooserClass * klass,
                                gpointer klass_data)
{
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	spice_color_chooser_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_type_class_adjust_private_offset (klass, &SpiceColorChooser_private_offset);
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_color_chooser_get_property;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_color_chooser_set_property;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	G_OBJECT_CLASS (klass)->constructor = spice_color_chooser_constructor;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_color_chooser_finalize;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_COLOR_CHOOSER_GRADIENT_PROPERTY, spice_color_chooser_properties[SPICE_COLOR_CHOOSER_GRADIENT_PROPERTY] = g_param_spec_boolean ("gradient", "gradient", "gradient", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_COLOR_CHOOSER_COLOR_PROPERTY, spice_color_chooser_properties[SPICE_COLOR_CHOOSER_COLOR_PROPERTY] = g_param_spec_string ("color", "color", "color", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_COLOR_CHOOSER_USE_ALPHA_PROPERTY, spice_color_chooser_properties[SPICE_COLOR_CHOOSER_USE_ALPHA_PROPERTY] = g_param_spec_boolean ("use-alpha", "use-alpha", "use-alpha", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	spice_color_chooser_signals[SPICE_COLOR_CHOOSER_COLOR_PICKED_SIGNAL] = g_signal_new ("color-picked", SPICE_TYPE_COLOR_CHOOSER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 2522 "ColorChooser.c"
}

static void
spice_color_chooser_instance_init (SpiceColorChooser * self,
                                   gpointer klass)
{
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self->priv = spice_color_chooser_get_instance_private (self);
#line 45 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self->priv->setting_color = FALSE;
#line 2533 "ColorChooser.c"
}

static void
spice_color_chooser_finalize (GObject * obj)
{
	SpiceColorChooser * self;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_COLOR_CHOOSER, SpiceColorChooser);
#line 64 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (self->priv->colors_grid_stack);
#line 66 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (self->priv->popover);
#line 67 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (self->priv->colors_grid);
#line 68 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (self->priv->gradient_colors_grid);
#line 69 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (self->gradient_revealer);
#line 70 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (self->priv->color_chooser);
#line 71 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (self->priv->gradient_button);
#line 72 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (self->priv->mode_button);
#line 74 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	_g_object_unref0 (self->gradient_editor);
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	G_OBJECT_CLASS (spice_color_chooser_parent_class)->finalize (obj);
#line 2562 "ColorChooser.c"
}

static GType
spice_color_chooser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceColorChooserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_color_chooser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceColorChooser), 0, (GInstanceInitFunc) spice_color_chooser_instance_init, NULL };
	GType spice_color_chooser_type_id;
	spice_color_chooser_type_id = g_type_register_static (SPICE_TYPE_COLOR_BUTTON, "SpiceColorChooser", &g_define_type_info, 0);
	SpiceColorChooser_private_offset = g_type_add_instance_private (spice_color_chooser_type_id, sizeof (SpiceColorChooserPrivate));
	return spice_color_chooser_type_id;
}

GType
spice_color_chooser_get_type (void)
{
	static volatile gsize spice_color_chooser_type_id__once = 0;
	if (g_once_init_enter (&spice_color_chooser_type_id__once)) {
		GType spice_color_chooser_type_id;
		spice_color_chooser_type_id = spice_color_chooser_get_type_once ();
		g_once_init_leave (&spice_color_chooser_type_id__once, spice_color_chooser_type_id);
	}
	return spice_color_chooser_type_id__once;
}

static void
_vala_spice_color_chooser_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	SpiceColorChooser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_COLOR_CHOOSER, SpiceColorChooser);
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		case SPICE_COLOR_CHOOSER_GRADIENT_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		g_value_set_boolean (value, spice_color_chooser_get_gradient (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		case SPICE_COLOR_CHOOSER_COLOR_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		g_value_set_string (value, spice_color_chooser_get_color (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		case SPICE_COLOR_CHOOSER_USE_ALPHA_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		g_value_set_boolean (value, spice_color_chooser_get_use_alpha (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		break;
#line 2615 "ColorChooser.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		break;
#line 2621 "ColorChooser.c"
	}
}

static void
_vala_spice_color_chooser_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	SpiceColorChooser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_COLOR_CHOOSER, SpiceColorChooser);
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		case SPICE_COLOR_CHOOSER_GRADIENT_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		spice_color_chooser_set_gradient (self, g_value_get_boolean (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		case SPICE_COLOR_CHOOSER_COLOR_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		spice_color_chooser_set_color (self, g_value_get_string (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		case SPICE_COLOR_CHOOSER_USE_ALPHA_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		spice_color_chooser_set_use_alpha (self, g_value_get_boolean (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		break;
#line 2653 "ColorChooser.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/ColorChooser.vala"
		break;
#line 2659 "ColorChooser.c"
	}
}

