/* Gradient.c generated by valac 0.56.18, the Vala compiler
 * generated from Gradient.vala, do not modify */

/*
* Copyright (c) 2018 Felipe Escoto (https://github.com/Philip-Scott/Spice-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SPICE_TYPE_GRADIENT (spice_gradient_get_type ())
#define SPICE_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_GRADIENT, SpiceGradient))
#define SPICE_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_GRADIENT, SpiceGradientClass))
#define SPICE_IS_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_GRADIENT))
#define SPICE_IS_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_GRADIENT))
#define SPICE_GRADIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_GRADIENT, SpiceGradientClass))

typedef struct _SpiceGradient SpiceGradient;
typedef struct _SpiceGradientClass SpiceGradientClass;
typedef struct _SpiceGradientPrivate SpiceGradientPrivate;

#define SPICE_GRADIENT_TYPE_GRADIENT_STEP (spice_gradient_gradient_step_get_type ())
#define SPICE_GRADIENT_GRADIENT_STEP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_GRADIENT_TYPE_GRADIENT_STEP, SpiceGradientGradientStep))
#define SPICE_GRADIENT_GRADIENT_STEP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_GRADIENT_TYPE_GRADIENT_STEP, SpiceGradientGradientStepClass))
#define SPICE_GRADIENT_IS_GRADIENT_STEP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_GRADIENT_TYPE_GRADIENT_STEP))
#define SPICE_GRADIENT_IS_GRADIENT_STEP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_GRADIENT_TYPE_GRADIENT_STEP))
#define SPICE_GRADIENT_GRADIENT_STEP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_GRADIENT_TYPE_GRADIENT_STEP, SpiceGradientGradientStepClass))

typedef struct _SpiceGradientGradientStep SpiceGradientGradientStep;
typedef struct _SpiceGradientGradientStepClass SpiceGradientGradientStepClass;
enum  {
	SPICE_GRADIENT_0_PROPERTY,
	SPICE_GRADIENT_NUM_PROPERTIES
};
static GParamSpec* spice_gradient_properties[SPICE_GRADIENT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block19Data Block19Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SpiceGradientGradientStepPrivate SpiceGradientGradientStepPrivate;
enum  {
	SPICE_GRADIENT_GRADIENT_STEP_0_PROPERTY,
	SPICE_GRADIENT_GRADIENT_STEP_COLOR_PROPERTY,
	SPICE_GRADIENT_GRADIENT_STEP_PERCENT_PROPERTY,
	SPICE_GRADIENT_GRADIENT_STEP_NUM_PROPERTIES
};
static GParamSpec* spice_gradient_gradient_step_properties[SPICE_GRADIENT_GRADIENT_STEP_NUM_PROPERTIES];

struct _SpiceGradient {
	GObject parent_instance;
	SpiceGradientPrivate * priv;
	GList* steps;
	gchar* direction;
};

struct _SpiceGradientClass {
	GObjectClass parent_class;
};

struct _Block19Data {
	int _ref_count_;
	SpiceGradient* self;
	gchar* colors;
};

struct _SpiceGradientGradientStep {
	GObject parent_instance;
	SpiceGradientGradientStepPrivate * priv;
};

struct _SpiceGradientGradientStepClass {
	GObjectClass parent_class;
};

struct _SpiceGradientGradientStepPrivate {
	gchar* _color;
	gchar* _percent;
};

static gpointer spice_gradient_parent_class = NULL;
VALA_EXTERN GRegex* spice_gradient_color_regex;
GRegex* spice_gradient_color_regex = NULL;
VALA_EXTERN GRegex* spice_gradient_dir_regex;
GRegex* spice_gradient_dir_regex = NULL;
static gint SpiceGradientGradientStep_private_offset;
static gpointer spice_gradient_gradient_step_parent_class = NULL;

VALA_EXTERN GType spice_gradient_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceGradient, g_object_unref)
VALA_EXTERN GType spice_gradient_gradient_step_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceGradientGradientStep, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN SpiceGradient* spice_gradient_new (void);
VALA_EXTERN SpiceGradient* spice_gradient_construct (GType object_type);
VALA_EXTERN void spice_gradient_parse (SpiceGradient* self,
                           const gchar* gradient);
VALA_EXTERN SpiceGradientGradientStep* spice_gradient_gradient_step_new (const gchar* _color,
                                                             const gchar* _percent);
VALA_EXTERN SpiceGradientGradientStep* spice_gradient_gradient_step_construct (GType object_type,
                                                                   const gchar* _color,
                                                                   const gchar* _percent);
VALA_EXTERN gchar* spice_gradient_to_string (SpiceGradient* self,
                                 gboolean force_down);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static gint __lambda30_ (SpiceGradientGradientStep* _a,
                  SpiceGradientGradientStep* _b);
VALA_EXTERN const gchar* spice_gradient_gradient_step_get_percent (SpiceGradientGradientStep* self);
static gint ___lambda30__gcompare_func (gconstpointer a,
                                 gconstpointer b);
static void __lambda31_ (Block19Data* _data19_,
                  SpiceGradientGradientStep* step);
VALA_EXTERN gchar* spice_gradient_gradient_step_to_string (SpiceGradientGradientStep* self);
static void ___lambda31__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN SpiceGradientGradientStep* spice_gradient_get_color (SpiceGradient* self,
                                                     gint nth);
VALA_EXTERN void spice_gradient_gradient_step_set_color (SpiceGradientGradientStep* self,
                                             const gchar* value);
VALA_EXTERN void spice_gradient_gradient_step_set_percent (SpiceGradientGradientStep* self,
                                               const gchar* value);
VALA_EXTERN const gchar* spice_gradient_gradient_step_get_color (SpiceGradientGradientStep* self);
VALA_EXTERN gboolean spice_gradient_gradient_step_equals (SpiceGradientGradientStep* self,
                                              SpiceGradientGradientStep* step);
static void spice_gradient_gradient_step_finalize (GObject * obj);
static GType spice_gradient_gradient_step_get_type_once (void);
static void _vala_spice_gradient_gradient_step_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_spice_gradient_gradient_step_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void spice_gradient_finalize (GObject * obj);
static GType spice_gradient_get_type_once (void);

static void
_g_object_unref0_ (gpointer var)
{
#line 23 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 184 "Gradient.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 23 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 192 "Gradient.c"
}

SpiceGradient*
spice_gradient_construct (GType object_type)
{
	SpiceGradient * self = NULL;
#line 48 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	self = (SpiceGradient*) g_object_new (object_type, NULL);
#line 48 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	return self;
#line 203 "Gradient.c"
}

SpiceGradient*
spice_gradient_new (void)
{
#line 48 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	return spice_gradient_construct (SPICE_TYPE_GRADIENT);
#line 211 "Gradient.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 230 "Gradient.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 73 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	return self ? g_object_ref (self) : NULL;
#line 238 "Gradient.c"
}

void
spice_gradient_parse (SpiceGradient* self,
                      const gchar* gradient)
{
	GMatchInfo* mi = NULL;
	GRegex* _tmp2_;
	GMatchInfo* _tmp3_ = NULL;
	gboolean _tmp4_;
	GRegex* _tmp29_;
	GMatchInfo* _tmp30_ = NULL;
	gboolean _tmp31_;
	GError* _inner_error0_ = NULL;
#line 50 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_return_if_fail (self != NULL);
#line 50 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_return_if_fail (gradient != NULL);
#line 51 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	(self->steps == NULL) ? NULL : (self->steps = (_g_list_free__g_object_unref0_ (self->steps), NULL));
#line 51 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	self->steps = NULL;
#line 53 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	if (!string_contains (gradient, "gradient")) {
#line 263 "Gradient.c"
		SpiceGradientGradientStep* _tmp0_;
		SpiceGradientGradientStep* _tmp1_;
#line 54 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp0_ = spice_gradient_gradient_step_new (gradient, "0%");
#line 54 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		self->steps = g_list_append (self->steps, _tmp0_);
#line 55 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp1_ = spice_gradient_gradient_step_new (gradient, "100%");
#line 55 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		self->steps = g_list_append (self->steps, _tmp1_);
#line 56 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		return;
#line 276 "Gradient.c"
	}
#line 60 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp2_ = spice_gradient_color_regex;
#line 60 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp4_ = g_regex_match (_tmp2_, gradient, 0, &_tmp3_);
#line 60 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_g_match_info_unref0 (mi);
#line 60 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	mi = _tmp3_;
#line 60 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	if (_tmp4_) {
#line 288 "Gradient.c"
		gint pos_start = 0;
		gint pos_end = 0;
#line 61 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		pos_start = 0;
#line 61 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		pos_end = 0;
#line 295 "Gradient.c"
		{
			{
				gboolean _tmp5_ = FALSE;
#line 64 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
				_tmp5_ = TRUE;
#line 64 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
				while (TRUE) {
#line 303 "Gradient.c"
					GMatchInfo* _tmp8_;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					gchar* step_color = NULL;
					GMatchInfo* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_ = NULL;
					GMatchInfo* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gboolean _tmp17_;
					gchar* step_percent = NULL;
					gchar* _tmp21_;
					SpiceGradientGradientStep* step = NULL;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					SpiceGradientGradientStep* _tmp24_;
					SpiceGradientGradientStep* _tmp25_;
					SpiceGradientGradientStep* _tmp26_;
#line 64 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					if (!_tmp5_) {
#line 325 "Gradient.c"
						gboolean _tmp6_ = FALSE;
						GMatchInfo* _tmp7_;
#line 74 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
						_tmp7_ = mi;
#line 74 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
						_tmp6_ = g_match_info_next (_tmp7_, &_inner_error0_);
#line 74 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 334 "Gradient.c"
							goto __catch0_g_error;
						}
#line 74 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
						if (!_tmp6_) {
#line 74 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
							break;
#line 341 "Gradient.c"
						}
					}
#line 64 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					_tmp5_ = FALSE;
#line 65 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					_tmp8_ = mi;
#line 65 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					g_match_info_fetch_pos (_tmp8_, 0, &_tmp9_, &_tmp10_);
#line 65 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					pos_start = _tmp9_;
#line 65 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					pos_end = _tmp10_;
#line 66 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					if (pos_start == pos_end) {
#line 67 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
						break;
#line 358 "Gradient.c"
					}
#line 69 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					_tmp11_ = mi;
#line 69 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					_tmp12_ = g_match_info_fetch (_tmp11_, 1);
#line 69 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					step_color = _tmp12_;
#line 70 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					_tmp14_ = mi;
#line 70 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					_tmp15_ = g_match_info_fetch (_tmp14_, 2);
#line 70 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					_tmp16_ = _tmp15_;
#line 70 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					_tmp17_ = _tmp16_ != NULL;
#line 70 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					_g_free0 (_tmp16_);
#line 70 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					if (_tmp17_) {
#line 378 "Gradient.c"
						GMatchInfo* _tmp18_;
						gchar* _tmp19_;
#line 70 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
						_tmp18_ = mi;
#line 70 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
						_tmp19_ = g_match_info_fetch (_tmp18_, 2);
#line 70 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
						_g_free0 (_tmp13_);
#line 70 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
						_tmp13_ = _tmp19_;
#line 389 "Gradient.c"
					} else {
						gchar* _tmp20_;
#line 70 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
						_tmp20_ = g_strdup ("");
#line 70 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
						_g_free0 (_tmp13_);
#line 70 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
						_tmp13_ = _tmp20_;
#line 398 "Gradient.c"
					}
#line 70 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					_tmp21_ = g_strdup (_tmp13_);
#line 70 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					step_percent = _tmp21_;
#line 72 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					_tmp22_ = step_color;
#line 72 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					_tmp23_ = step_percent;
#line 72 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					_tmp24_ = spice_gradient_gradient_step_new (_tmp22_, _tmp23_);
#line 72 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					step = _tmp24_;
#line 73 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					_tmp25_ = step;
#line 73 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					_tmp26_ = _g_object_ref0 (_tmp25_);
#line 73 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					self->steps = g_list_append (self->steps, _tmp26_);
#line 64 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					_g_object_unref0 (step);
#line 64 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					_g_free0 (step_percent);
#line 64 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					_g_free0 (_tmp13_);
#line 64 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
					_g_free0 (step_color);
#line 426 "Gradient.c"
				}
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp27_;
			const gchar* _tmp28_;
#line 63 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
			e = _inner_error0_;
#line 63 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
			_inner_error0_ = NULL;
#line 76 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
			_tmp27_ = e;
#line 76 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
			_tmp28_ = _tmp27_->message;
#line 76 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
			g_warning ("Gradient.vala:76: Could not find gradient steps: %s", _tmp28_);
#line 77 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
			_g_error_free0 (e);
#line 77 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
			_g_match_info_unref0 (mi);
#line 77 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
			return;
#line 452 "Gradient.c"
		}
		__finally0:
#line 63 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 63 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
			_g_match_info_unref0 (mi);
#line 63 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 63 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
			g_clear_error (&_inner_error0_);
#line 63 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
			return;
#line 465 "Gradient.c"
		}
	}
#line 81 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp29_ = spice_gradient_dir_regex;
#line 81 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp31_ = g_regex_match (_tmp29_, gradient, 0, &_tmp30_);
#line 81 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_g_match_info_unref0 (mi);
#line 81 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	mi = _tmp30_;
#line 81 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	if (_tmp31_) {
#line 478 "Gradient.c"
		gint pos_start = 0;
		gint pos_end = 0;
		GMatchInfo* _tmp32_;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
#line 82 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		pos_start = 0;
#line 82 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		pos_end = 0;
#line 84 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp32_ = mi;
#line 84 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		g_match_info_fetch_pos (_tmp32_, 0, &_tmp33_, &_tmp34_);
#line 84 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		pos_start = _tmp33_;
#line 84 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		pos_end = _tmp34_;
#line 85 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		if (pos_start != pos_end) {
#line 498 "Gradient.c"
			GMatchInfo* _tmp35_;
			gchar* _tmp36_;
#line 86 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
			_tmp35_ = mi;
#line 86 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
			_tmp36_ = g_match_info_fetch (_tmp35_, 1);
#line 86 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
			_g_free0 (self->direction);
#line 86 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
			self->direction = _tmp36_;
#line 509 "Gradient.c"
		}
	}
#line 50 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_g_match_info_unref0 (mi);
#line 514 "Gradient.c"
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
#line 91 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_atomic_int_inc (&_data19_->_ref_count_);
#line 91 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	return _data19_;
#line 524 "Gradient.c"
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
#line 91 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
#line 534 "Gradient.c"
		SpiceGradient* self;
#line 91 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		self = _data19_->self;
#line 91 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_g_free0 (_data19_->colors);
#line 91 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_g_object_unref0 (self);
#line 91 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		g_slice_free (Block19Data, _data19_);
#line 544 "Gradient.c"
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 567 "Gradient.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 571 "Gradient.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 577 "Gradient.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 581 "Gradient.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 585 "Gradient.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 593 "Gradient.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 621 "Gradient.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 630 "Gradient.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 644 "Gradient.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 653 "Gradient.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 667 "Gradient.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 676 "Gradient.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 685 "Gradient.c"
}

static gint
__lambda30_ (SpiceGradientGradientStep* _a,
             SpiceGradientGradientStep* _b)
{
	gint a = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	gint b = 0;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gint _tmp9_;
	gint result;
#line 94 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_return_val_if_fail (_a != NULL, 0);
#line 94 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_return_val_if_fail (_b != NULL, 0);
#line 95 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp0_ = spice_gradient_gradient_step_get_percent (_a);
#line 95 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp1_ = _tmp0_;
#line 95 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp2_ = string_replace (_tmp1_, "%", "");
#line 95 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp3_ = _tmp2_;
#line 95 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp4_ = atoi (_tmp3_);
#line 95 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_g_free0 (_tmp3_);
#line 95 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	a = _tmp4_;
#line 96 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp5_ = spice_gradient_gradient_step_get_percent (_b);
#line 96 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp6_ = _tmp5_;
#line 96 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp7_ = string_replace (_tmp6_, "%", "");
#line 96 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp8_ = _tmp7_;
#line 96 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp9_ = atoi (_tmp8_);
#line 96 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_g_free0 (_tmp8_);
#line 96 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	b = _tmp9_;
#line 97 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	result = ((gint) (a > b)) - ((gint) (a < b));
#line 97 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	return result;
#line 741 "Gradient.c"
}

static gint
___lambda30__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda30_ ((SpiceGradientGradientStep*) a, (SpiceGradientGradientStep*) b);
#line 94 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	return result;
#line 752 "Gradient.c"
}

static void
__lambda31_ (Block19Data* _data19_,
             SpiceGradientGradientStep* step)
{
	SpiceGradient* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
#line 100 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	self = _data19_->self;
#line 100 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_return_if_fail (step != NULL);
#line 101 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp0_ = _data19_->colors;
#line 101 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp1_ = spice_gradient_gradient_step_to_string (step);
#line 101 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp2_ = _tmp1_;
#line 101 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp3_ = g_strdup_printf (", %s", _tmp2_);
#line 101 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp4_ = _tmp3_;
#line 101 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp5_ = g_strconcat (_tmp0_, _tmp4_, NULL);
#line 101 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_g_free0 (_data19_->colors);
#line 101 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_data19_->colors = _tmp5_;
#line 101 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_g_free0 (_tmp4_);
#line 101 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_g_free0 (_tmp2_);
#line 790 "Gradient.c"
}

static void
___lambda31__gfunc (gconstpointer data,
                    gpointer self)
{
#line 100 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	__lambda31_ (self, (SpiceGradientGradientStep*) data);
#line 799 "Gradient.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
#line 1624 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1625 "glib-2.0.vapi"
	result = self;
#line 1625 "glib-2.0.vapi"
	return result;
#line 812 "Gradient.c"
}

gchar*
spice_gradient_to_string (SpiceGradient* self,
                          gboolean force_down)
{
	Block19Data* _data19_;
	gchar* _tmp0_;
	GList* _tmp1_;
	gchar* _result_ = NULL;
	gchar* result;
#line 91 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 91 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_data19_ = g_slice_new0 (Block19Data);
#line 91 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_data19_->_ref_count_ = 1;
#line 91 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_data19_->self = g_object_ref (self);
#line 92 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp0_ = g_strdup ("");
#line 92 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_data19_->colors = _tmp0_;
#line 94 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	self->steps = g_list_sort (self->steps, ___lambda30__gcompare_func);
#line 100 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp1_ = self->steps;
#line 100 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_list_foreach (_tmp1_, ___lambda31__gfunc, _data19_);
#line 105 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	if (force_down) {
#line 844 "Gradient.c"
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
#line 106 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp2_ = _data19_->colors;
#line 106 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp3_ = string_to_string (_tmp2_);
#line 106 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp4_ = g_strconcat ("linear-gradient(to bottom", _tmp3_, ")", NULL);
#line 106 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_g_free0 (_result_);
#line 106 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_result_ = _tmp4_;
#line 858 "Gradient.c"
	} else {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
#line 108 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp5_ = self->direction;
#line 108 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp6_ = string_to_string (_tmp5_);
#line 108 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp7_ = _data19_->colors;
#line 108 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp8_ = string_to_string (_tmp7_);
#line 108 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp9_ = g_strconcat ("linear-gradient(", _tmp6_, _tmp8_, ")", NULL);
#line 108 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_g_free0 (_result_);
#line 108 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_result_ = _tmp9_;
#line 879 "Gradient.c"
	}
#line 111 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	result = _result_;
#line 111 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	block19_data_unref (_data19_);
#line 111 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_data19_ = NULL;
#line 111 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	return result;
#line 889 "Gradient.c"
}

SpiceGradientGradientStep*
spice_gradient_get_color (SpiceGradient* self,
                          gint nth)
{
	GList* _tmp0_;
	gconstpointer _tmp1_;
	SpiceGradientGradientStep* _tmp2_;
	SpiceGradientGradientStep* result;
#line 114 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 115 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp0_ = self->steps;
#line 115 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp1_ = g_list_nth_data (_tmp0_, (guint) nth);
#line 115 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp2_ = _g_object_ref0 ((SpiceGradientGradientStep*) _tmp1_);
#line 115 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	result = _tmp2_;
#line 115 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	return result;
#line 912 "Gradient.c"
}

static inline gpointer
spice_gradient_gradient_step_get_instance_private (SpiceGradientGradientStep* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceGradientGradientStep_private_offset);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 939 "Gradient.c"
}

SpiceGradientGradientStep*
spice_gradient_gradient_step_construct (GType object_type,
                                        const gchar* _color,
                                        const gchar* _percent)
{
	SpiceGradientGradientStep * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 119 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_return_val_if_fail (_color != NULL, NULL);
#line 119 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_return_val_if_fail (_percent != NULL, NULL);
#line 119 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	self = (SpiceGradientGradientStep*) g_object_new (object_type, NULL);
#line 120 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp0_ = string_strip (_color);
#line 120 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp1_ = _tmp0_;
#line 120 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	spice_gradient_gradient_step_set_color (self, _tmp1_);
#line 120 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_g_free0 (_tmp1_);
#line 121 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp2_ = string_strip (_percent);
#line 121 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp3_ = _tmp2_;
#line 121 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	spice_gradient_gradient_step_set_percent (self, _tmp3_);
#line 121 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_g_free0 (_tmp3_);
#line 119 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	return self;
#line 976 "Gradient.c"
}

SpiceGradientGradientStep*
spice_gradient_gradient_step_new (const gchar* _color,
                                  const gchar* _percent)
{
#line 119 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	return spice_gradient_gradient_step_construct (SPICE_GRADIENT_TYPE_GRADIENT_STEP, _color, _percent);
#line 985 "Gradient.c"
}

gchar*
spice_gradient_gradient_step_to_string (SpiceGradientGradientStep* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
#line 127 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 128 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp0_ = self->priv->_color;
#line 128 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp1_ = string_to_string (_tmp0_);
#line 128 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp2_ = self->priv->_percent;
#line 128 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp3_ = string_to_string (_tmp2_);
#line 128 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp4_ = g_strconcat (_tmp1_, " ", _tmp3_, NULL);
#line 128 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp5_ = _tmp4_;
#line 128 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp6_ = string_strip (_tmp5_);
#line 128 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp7_ = _tmp6_;
#line 128 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_g_free0 (_tmp5_);
#line 128 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	result = _tmp7_;
#line 128 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	return result;
#line 1024 "Gradient.c"
}

gboolean
spice_gradient_gradient_step_equals (SpiceGradientGradientStep* self,
                                     SpiceGradientGradientStep* step)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
#line 131 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 131 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_return_val_if_fail (step != NULL, FALSE);
#line 132 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp0_ = spice_gradient_gradient_step_to_string (self);
#line 132 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp1_ = _tmp0_;
#line 132 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp2_ = spice_gradient_gradient_step_to_string (step);
#line 132 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp3_ = _tmp2_;
#line 132 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp4_ = g_strcmp0 (_tmp1_, _tmp3_) == 0;
#line 132 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_g_free0 (_tmp3_);
#line 132 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_g_free0 (_tmp1_);
#line 132 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	result = _tmp4_;
#line 132 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	return result;
#line 1059 "Gradient.c"
}

const gchar*
spice_gradient_gradient_step_get_color (SpiceGradientGradientStep* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 124 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 124 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp0_ = self->priv->_color;
#line 124 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	result = _tmp0_;
#line 124 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	return result;
#line 1075 "Gradient.c"
}

void
spice_gradient_gradient_step_set_color (SpiceGradientGradientStep* self,
                                        const gchar* value)
{
	gchar* old_value;
#line 124 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_return_if_fail (self != NULL);
#line 124 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	old_value = spice_gradient_gradient_step_get_color (self);
#line 124 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1089 "Gradient.c"
		gchar* _tmp0_;
#line 124 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp0_ = g_strdup (value);
#line 124 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_g_free0 (self->priv->_color);
#line 124 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		self->priv->_color = _tmp0_;
#line 124 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_gradient_gradient_step_properties[SPICE_GRADIENT_GRADIENT_STEP_COLOR_PROPERTY]);
#line 1099 "Gradient.c"
	}
}

const gchar*
spice_gradient_gradient_step_get_percent (SpiceGradientGradientStep* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp0_ = self->priv->_percent;
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	result = _tmp0_;
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	return result;
#line 1116 "Gradient.c"
}

void
spice_gradient_gradient_step_set_percent (SpiceGradientGradientStep* self,
                                          const gchar* value)
{
	gchar* old_value;
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_return_if_fail (self != NULL);
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	old_value = spice_gradient_gradient_step_get_percent (self);
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1130 "Gradient.c"
		gchar* _tmp0_;
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp0_ = g_strdup (value);
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_g_free0 (self->priv->_percent);
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		self->priv->_percent = _tmp0_;
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_gradient_gradient_step_properties[SPICE_GRADIENT_GRADIENT_STEP_PERCENT_PROPERTY]);
#line 1140 "Gradient.c"
	}
}

static void
spice_gradient_gradient_step_class_init (SpiceGradientGradientStepClass * klass,
                                         gpointer klass_data)
{
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	spice_gradient_gradient_step_parent_class = g_type_class_peek_parent (klass);
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_type_class_adjust_private_offset (klass, &SpiceGradientGradientStep_private_offset);
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_gradient_gradient_step_get_property;
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_gradient_gradient_step_set_property;
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_gradient_gradient_step_finalize;
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_GRADIENT_GRADIENT_STEP_COLOR_PROPERTY, spice_gradient_gradient_step_properties[SPICE_GRADIENT_GRADIENT_STEP_COLOR_PROPERTY] = g_param_spec_string ("color", "color", "color", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_GRADIENT_GRADIENT_STEP_PERCENT_PROPERTY, spice_gradient_gradient_step_properties[SPICE_GRADIENT_GRADIENT_STEP_PERCENT_PROPERTY] = g_param_spec_string ("percent", "percent", "percent", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1162 "Gradient.c"
}

static void
spice_gradient_gradient_step_instance_init (SpiceGradientGradientStep * self,
                                            gpointer klass)
{
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	self->priv = spice_gradient_gradient_step_get_instance_private (self);
#line 1171 "Gradient.c"
}

static void
spice_gradient_gradient_step_finalize (GObject * obj)
{
	SpiceGradientGradientStep * self;
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_GRADIENT_TYPE_GRADIENT_STEP, SpiceGradientGradientStep);
#line 124 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_g_free0 (self->priv->_color);
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_g_free0 (self->priv->_percent);
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	G_OBJECT_CLASS (spice_gradient_gradient_step_parent_class)->finalize (obj);
#line 1186 "Gradient.c"
}

static GType
spice_gradient_gradient_step_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceGradientGradientStepClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_gradient_gradient_step_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceGradientGradientStep), 0, (GInstanceInitFunc) spice_gradient_gradient_step_instance_init, NULL };
	GType spice_gradient_gradient_step_type_id;
	spice_gradient_gradient_step_type_id = g_type_register_static (G_TYPE_OBJECT, "SpiceGradientGradientStep", &g_define_type_info, 0);
	SpiceGradientGradientStep_private_offset = g_type_add_instance_private (spice_gradient_gradient_step_type_id, sizeof (SpiceGradientGradientStepPrivate));
	return spice_gradient_gradient_step_type_id;
}

GType
spice_gradient_gradient_step_get_type (void)
{
	static volatile gsize spice_gradient_gradient_step_type_id__once = 0;
	if (g_once_init_enter (&spice_gradient_gradient_step_type_id__once)) {
		GType spice_gradient_gradient_step_type_id;
		spice_gradient_gradient_step_type_id = spice_gradient_gradient_step_get_type_once ();
		g_once_init_leave (&spice_gradient_gradient_step_type_id__once, spice_gradient_gradient_step_type_id);
	}
	return spice_gradient_gradient_step_type_id__once;
}

static void
_vala_spice_gradient_gradient_step_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	SpiceGradientGradientStep * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_GRADIENT_TYPE_GRADIENT_STEP, SpiceGradientGradientStep);
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	switch (property_id) {
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		case SPICE_GRADIENT_GRADIENT_STEP_COLOR_PROPERTY:
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		g_value_set_string (value, spice_gradient_gradient_step_get_color (self));
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		break;
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		case SPICE_GRADIENT_GRADIENT_STEP_PERCENT_PROPERTY:
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		g_value_set_string (value, spice_gradient_gradient_step_get_percent (self));
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		break;
#line 1233 "Gradient.c"
		default:
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		break;
#line 1239 "Gradient.c"
	}
}

static void
_vala_spice_gradient_gradient_step_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	SpiceGradientGradientStep * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_GRADIENT_TYPE_GRADIENT_STEP, SpiceGradientGradientStep);
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	switch (property_id) {
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		case SPICE_GRADIENT_GRADIENT_STEP_COLOR_PROPERTY:
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		spice_gradient_gradient_step_set_color (self, g_value_get_string (value));
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		break;
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		case SPICE_GRADIENT_GRADIENT_STEP_PERCENT_PROPERTY:
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		spice_gradient_gradient_step_set_percent (self, g_value_get_string (value));
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		break;
#line 1265 "Gradient.c"
		default:
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		break;
#line 1271 "Gradient.c"
	}
}

static void
spice_gradient_class_init (SpiceGradientClass * klass,
                           gpointer klass_data)
{
	GError* _inner_error0_ = NULL;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	spice_gradient_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_gradient_finalize;
#line 1284 "Gradient.c"
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
#line 31 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp1_ = g_regex_new ("(" "#[a-zA-Z0-9]{6}|" "#[a-zA-Z0-9]{3}|" "rgb\\(\\s*[0-9]{1,3}\\s*,\\s*[0-9]{1,3}\\s*,\\s*[0-9]{1,3}\\s*\\)|" "rgba\\(\\s*[0-9]{1,3}\\s*,\\s*[0-9]{1,3}\\s*,\\s*[0-9]{1,3}\\s*,\\s*[0" \
"-9\\.]{1,}\\s*\\)" ")" "(\\s[0-9]{1,}%)?", 0, 0, &_inner_error0_);
#line 31 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp0_ = _tmp1_;
#line 31 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1298 "Gradient.c"
			goto __catch0_g_error;
		}
#line 31 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp2_ = _tmp0_;
#line 31 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp0_ = NULL;
#line 31 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_g_regex_unref0 (spice_gradient_color_regex);
#line 31 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		spice_gradient_color_regex = _tmp2_;
#line 41 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp4_ = g_regex_new ("gradient\\(([a-z0-9\\s]{1,}),", 0, 0, &_inner_error0_);
#line 41 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp3_ = _tmp4_;
#line 41 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 41 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
			_g_regex_unref0 (_tmp0_);
#line 1317 "Gradient.c"
			goto __catch0_g_error;
		}
#line 41 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp5_ = _tmp3_;
#line 41 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp3_ = NULL;
#line 41 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_g_regex_unref0 (spice_gradient_dir_regex);
#line 41 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		spice_gradient_dir_regex = _tmp5_;
#line 30 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_g_regex_unref0 (_tmp3_);
#line 30 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_g_regex_unref0 (_tmp0_);
#line 1332 "Gradient.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 30 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		e = _inner_error0_;
#line 30 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_inner_error0_ = NULL;
#line 44 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp6_ = e;
#line 44 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_tmp7_ = _tmp6_->message;
#line 44 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		g_error ("Gradient.vala:44: Regex failed: %s", _tmp7_);
#line 30 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		_g_error_free0 (e);
#line 1352 "Gradient.c"
	}
	__finally0:
#line 30 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 30 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 30 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
		g_clear_error (&_inner_error0_);
#line 1361 "Gradient.c"
	}
}

static void
spice_gradient_instance_init (SpiceGradient * self,
                              gpointer klass)
{
	gchar* _tmp0_;
#line 27 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_tmp0_ = g_strdup ("to bottom");
#line 27 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	self->direction = _tmp0_;
#line 1374 "Gradient.c"
}

static void
spice_gradient_finalize (GObject * obj)
{
	SpiceGradient * self;
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_GRADIENT, SpiceGradient);
#line 23 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	(self->steps == NULL) ? NULL : (self->steps = (_g_list_free__g_object_unref0_ (self->steps), NULL));
#line 27 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	_g_free0 (self->direction);
#line 22 "../Spice-up-1.9.1/src/Widgets/ColorPicker/Gradient.vala"
	G_OBJECT_CLASS (spice_gradient_parent_class)->finalize (obj);
#line 1389 "Gradient.c"
}

static GType
spice_gradient_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceGradientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_gradient_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceGradient), 0, (GInstanceInitFunc) spice_gradient_instance_init, NULL };
	GType spice_gradient_type_id;
	spice_gradient_type_id = g_type_register_static (G_TYPE_OBJECT, "SpiceGradient", &g_define_type_info, 0);
	return spice_gradient_type_id;
}

GType
spice_gradient_get_type (void)
{
	static volatile gsize spice_gradient_type_id__once = 0;
	if (g_once_init_enter (&spice_gradient_type_id__once)) {
		GType spice_gradient_type_id;
		spice_gradient_type_id = spice_gradient_get_type_once ();
		g_once_init_leave (&spice_gradient_type_id__once, spice_gradient_type_id);
	}
	return spice_gradient_type_id__once;
}

