/* PresenterView.c generated by valac 0.56.18, the Vala compiler
 * generated from PresenterView.vala, do not modify */

/*
* Copyright (c) 2017 Felipe Escoto (https://github.com/Philip-Scott/Spice-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <granite.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>

#define SPICE_PRESENTER_WINDOW_NOTES_CSS "\n    .view {\n        font-size: %dpx;\n    }"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SPICE_TYPE_PRESENTER_WINDOW (spice_presenter_window_get_type ())
#define SPICE_PRESENTER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_PRESENTER_WINDOW, SpicePresenterWindow))
#define SPICE_PRESENTER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_PRESENTER_WINDOW, SpicePresenterWindowClass))
#define SPICE_IS_PRESENTER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_PRESENTER_WINDOW))
#define SPICE_IS_PRESENTER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_PRESENTER_WINDOW))
#define SPICE_PRESENTER_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_PRESENTER_WINDOW, SpicePresenterWindowClass))

typedef struct _SpicePresenterWindow SpicePresenterWindow;
typedef struct _SpicePresenterWindowClass SpicePresenterWindowClass;
typedef struct _SpicePresenterWindowPrivate SpicePresenterWindowPrivate;

#define SPICE_TYPE_SLIDE_MANAGER (spice_slide_manager_get_type ())
#define SPICE_SLIDE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManager))
#define SPICE_SLIDE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManagerClass))
#define SPICE_IS_SLIDE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_SLIDE_MANAGER))
#define SPICE_IS_SLIDE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_SLIDE_MANAGER))
#define SPICE_SLIDE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManagerClass))

typedef struct _SpiceSlideManager SpiceSlideManager;
typedef struct _SpiceSlideManagerClass SpiceSlideManagerClass;

#define SPICE_TYPE_WINDOW (spice_window_get_type ())
#define SPICE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_WINDOW, SpiceWindow))
#define SPICE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_WINDOW, SpiceWindowClass))
#define SPICE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_WINDOW))
#define SPICE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_WINDOW))
#define SPICE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_WINDOW, SpiceWindowClass))

typedef struct _SpiceWindow SpiceWindow;
typedef struct _SpiceWindowClass SpiceWindowClass;

#define SPICE_TYPE_SLIDE_WIDGET (spice_slide_widget_get_type ())
#define SPICE_SLIDE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_SLIDE_WIDGET, SpiceSlideWidget))
#define SPICE_SLIDE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_SLIDE_WIDGET, SpiceSlideWidgetClass))
#define SPICE_IS_SLIDE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_SLIDE_WIDGET))
#define SPICE_IS_SLIDE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_SLIDE_WIDGET))
#define SPICE_SLIDE_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_SLIDE_WIDGET, SpiceSlideWidgetClass))

typedef struct _SpiceSlideWidget SpiceSlideWidget;
typedef struct _SpiceSlideWidgetClass SpiceSlideWidgetClass;

#define SPICE_PRESENTER_WINDOW_TYPE_CLOCK (spice_presenter_window_clock_get_type ())
#define SPICE_PRESENTER_WINDOW_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_PRESENTER_WINDOW_TYPE_CLOCK, SpicePresenterWindowClock))
#define SPICE_PRESENTER_WINDOW_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_PRESENTER_WINDOW_TYPE_CLOCK, SpicePresenterWindowClockClass))
#define SPICE_PRESENTER_WINDOW_IS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_PRESENTER_WINDOW_TYPE_CLOCK))
#define SPICE_PRESENTER_WINDOW_IS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_PRESENTER_WINDOW_TYPE_CLOCK))
#define SPICE_PRESENTER_WINDOW_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_PRESENTER_WINDOW_TYPE_CLOCK, SpicePresenterWindowClockClass))

typedef struct _SpicePresenterWindowClock SpicePresenterWindowClock;
typedef struct _SpicePresenterWindowClockClass SpicePresenterWindowClockClass;
enum  {
	SPICE_PRESENTER_WINDOW_0_PROPERTY,
	SPICE_PRESENTER_WINDOW_SLIDE_MANAGER_PROPERTY,
	SPICE_PRESENTER_WINDOW_WINDOW_PROPERTY,
	SPICE_PRESENTER_WINDOW_NUM_PROPERTIES
};
static GParamSpec* spice_presenter_window_properties[SPICE_PRESENTER_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SPICE_TYPE_SLIDE (spice_slide_get_type ())
#define SPICE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_SLIDE, SpiceSlide))
#define SPICE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_SLIDE, SpiceSlideClass))
#define SPICE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_SLIDE))
#define SPICE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_SLIDE))
#define SPICE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_SLIDE, SpiceSlideClass))

typedef struct _SpiceSlide SpiceSlide;
typedef struct _SpiceSlideClass SpiceSlideClass;
typedef struct _Block15Data Block15Data;
typedef struct _SpiceSlidePrivate SpiceSlidePrivate;

#define SPICE_TYPE_CANVAS (spice_canvas_get_type ())
#define SPICE_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS, SpiceCanvas))
#define SPICE_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS, SpiceCanvasClass))
#define SPICE_IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS))
#define SPICE_IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS))
#define SPICE_CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS, SpiceCanvasClass))

typedef struct _SpiceCanvas SpiceCanvas;
typedef struct _SpiceCanvasClass SpiceCanvasClass;
typedef struct _SpiceCanvasPrivate SpiceCanvasPrivate;

#define SPICE_CANVAS_TYPE_CANVAS_GRID (spice_canvas_canvas_grid_get_type ())
#define SPICE_CANVAS_CANVAS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGrid))
#define SPICE_CANVAS_CANVAS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGridClass))
#define SPICE_CANVAS_IS_CANVAS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID))
#define SPICE_CANVAS_IS_CANVAS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_CANVAS_TYPE_CANVAS_GRID))
#define SPICE_CANVAS_CANVAS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGridClass))

typedef struct _SpiceCanvasCanvasGrid SpiceCanvasCanvasGrid;
typedef struct _SpiceCanvasCanvasGridClass SpiceCanvasCanvasGridClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define SPICE_PRESENTER_WINDOW_TYPE_SLIDESHOW_CONTROLLER (spice_presenter_window_slideshow_controller_get_type ())
#define SPICE_PRESENTER_WINDOW_SLIDESHOW_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_PRESENTER_WINDOW_TYPE_SLIDESHOW_CONTROLLER, SpicePresenterWindowSlideshowController))
#define SPICE_PRESENTER_WINDOW_SLIDESHOW_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_PRESENTER_WINDOW_TYPE_SLIDESHOW_CONTROLLER, SpicePresenterWindowSlideshowControllerClass))
#define SPICE_PRESENTER_WINDOW_IS_SLIDESHOW_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_PRESENTER_WINDOW_TYPE_SLIDESHOW_CONTROLLER))
#define SPICE_PRESENTER_WINDOW_IS_SLIDESHOW_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_PRESENTER_WINDOW_TYPE_SLIDESHOW_CONTROLLER))
#define SPICE_PRESENTER_WINDOW_SLIDESHOW_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_PRESENTER_WINDOW_TYPE_SLIDESHOW_CONTROLLER, SpicePresenterWindowSlideshowControllerClass))

typedef struct _SpicePresenterWindowSlideshowController SpicePresenterWindowSlideshowController;
typedef struct _SpicePresenterWindowSlideshowControllerClass SpicePresenterWindowSlideshowControllerClass;
typedef struct _SpicePresenterWindowSlideshowControllerPrivate SpicePresenterWindowSlideshowControllerPrivate;
enum  {
	SPICE_PRESENTER_WINDOW_SLIDESHOW_CONTROLLER_0_PROPERTY,
	SPICE_PRESENTER_WINDOW_SLIDESHOW_CONTROLLER_SLIDE_MANAGER_PROPERTY,
	SPICE_PRESENTER_WINDOW_SLIDESHOW_CONTROLLER_SLIDE_COUNT_PROPERTY,
	SPICE_PRESENTER_WINDOW_SLIDESHOW_CONTROLLER_NUM_PROPERTIES
};
static GParamSpec* spice_presenter_window_slideshow_controller_properties[SPICE_PRESENTER_WINDOW_SLIDESHOW_CONTROLLER_NUM_PROPERTIES];
typedef struct _SpicePresenterWindowClockPrivate SpicePresenterWindowClockPrivate;
enum  {
	SPICE_PRESENTER_WINDOW_CLOCK_0_PROPERTY,
	SPICE_PRESENTER_WINDOW_CLOCK_NUM_PROPERTIES
};
static GParamSpec* spice_presenter_window_clock_properties[SPICE_PRESENTER_WINDOW_CLOCK_NUM_PROPERTIES];
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

#define SPICE_PRESENTER_WINDOW_CLOCK_TYPE_TIME (spice_presenter_window_clock_time_get_type ())
typedef struct _SpicePresenterWindowClockTime SpicePresenterWindowClockTime;
typedef struct _SpiceSlideWidgetPrivate SpiceSlideWidgetPrivate;

struct _SpicePresenterWindow {
	GtkWindow parent_instance;
	SpicePresenterWindowPrivate * priv;
};

struct _SpicePresenterWindowClass {
	GtkWindowClass parent_class;
};

struct _SpicePresenterWindowPrivate {
	SpiceSlideManager* _slide_manager;
	SpiceWindow* _window;
	GtkImage* preview;
	SpiceSlideWidget* next_preview;
	GtkTextView* notes;
	gboolean changing;
	SpicePresenterWindowClock* clock;
	gint _font_size;
};

struct _Block15Data {
	int _ref_count_;
	SpicePresenterWindow* self;
	SpiceSlide* current_slide;
};

struct _SpiceSlide {
	GObject parent_instance;
	SpiceSlidePrivate * priv;
	JsonObject* save_data;
	SpiceCanvas* canvas;
	GtkImage* preview;
};

struct _SpiceSlideClass {
	GObjectClass parent_class;
};

struct _SpiceCanvas {
	GtkOverlay parent_instance;
	SpiceCanvasPrivate * priv;
	SpiceWindow* window;
	gdouble current_allocated_width;
	gdouble current_allocated_height;
	SpiceCanvasCanvasGrid* grid;
	JsonObject* save_data;
	GraniteDrawingBufferSurface* surface;
};

struct _SpiceCanvasClass {
	GtkOverlayClass parent_class;
};

struct _SpicePresenterWindowSlideshowController {
	GtkGrid parent_instance;
	SpicePresenterWindowSlideshowControllerPrivate * priv;
};

struct _SpicePresenterWindowSlideshowControllerClass {
	GtkGridClass parent_class;
};

struct _SpicePresenterWindowSlideshowControllerPrivate {
	SpiceSlideManager* _slide_manager;
	gint _slide_count;
	GtkProgressBar* progress_bar;
};

struct _SpicePresenterWindowClock {
	GtkGrid parent_instance;
	SpicePresenterWindowClockPrivate * priv;
};

struct _SpicePresenterWindowClockClass {
	GtkGridClass parent_class;
};

struct _SpicePresenterWindowClockPrivate {
	GTimer* timer;
	gboolean started;
	GtkLabel* label;
	GtkImage* pause_image;
};

struct _SpicePresenterWindowClockTime {
	gint hours;
	gint minutes;
	gint seconds;
};

struct _SpiceSlideWidget {
	GtkEventBox parent_instance;
	SpiceSlideWidgetPrivate * priv;
	gboolean show_button;
	GtkRevealer* settings_revealer;
};

struct _SpiceSlideWidgetClass {
	GtkEventBoxClass parent_class;
};

static gint SpicePresenterWindow_private_offset;
static gpointer spice_presenter_window_parent_class = NULL;
VALA_EXTERN gint spice_slide_list_WIDTH;
VALA_EXTERN gint spice_slide_list_HEIGHT;
static gint SpicePresenterWindowSlideshowController_private_offset;
static gpointer spice_presenter_window_slideshow_controller_parent_class = NULL;
static gint SpicePresenterWindowClock_private_offset;
static gpointer spice_presenter_window_clock_parent_class = NULL;

VALA_EXTERN GType spice_presenter_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpicePresenterWindow, g_object_unref)
VALA_EXTERN GType spice_slide_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceSlideManager, g_object_unref)
VALA_EXTERN GType spice_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceWindow, g_object_unref)
VALA_EXTERN GType spice_slide_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceSlideWidget, g_object_unref)
static GType spice_presenter_window_clock_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpicePresenterWindowClock, g_object_unref)
VALA_EXTERN SpicePresenterWindow* spice_presenter_window_new (SpiceSlideManager* slide_manager,
                                                  SpiceWindow* window);
VALA_EXTERN SpicePresenterWindow* spice_presenter_window_construct (GType object_type,
                                                        SpiceSlideManager* slide_manager,
                                                        SpiceWindow* window);
VALA_EXTERN GType spice_slide_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceSlide, g_object_unref)
static void spice_presenter_window_load_previews (SpicePresenterWindow* self,
                                           SpiceSlide* current_slide);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
VALA_EXTERN const gchar* spice_slide_get_notes (SpiceSlide* self);
VALA_EXTERN SpiceSlideManager* spice_presenter_window_get_slide_manager (SpicePresenterWindow* self);
VALA_EXTERN SpiceSlide* spice_slide_manager_get_next_slide (SpiceSlideManager* self,
                                                SpiceSlide* current);
VALA_EXTERN GType spice_canvas_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvas, g_object_unref)
VALA_EXTERN void spice_slide_widget_set_pixbuf (SpiceSlideWidget* self,
                                    GdkPixbuf* value);
static gboolean __lambda10_ (Block15Data* _data15_);
VALA_EXTERN GType spice_canvas_canvas_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvasCanvasGrid, g_object_unref)
static gboolean ___lambda10__gsource_func (gpointer self);
static gboolean spice_presenter_window_on_key_pressed (SpicePresenterWindow* self,
                                                GtkWidget* source,
                                                GdkEventKey* key);
VALA_EXTERN void spice_slide_manager_next_slide (SpiceSlideManager* self);
VALA_EXTERN void spice_slide_manager_previous_slide (SpiceSlideManager* self);
VALA_EXTERN void spice_presenter_window_end_presentation (SpicePresenterWindow* self);
static gint spice_presenter_window_get_font_size (SpicePresenterWindow* self);
static void spice_presenter_window_set_font_size (SpicePresenterWindow* self,
                                           gint value);
VALA_EXTERN SpiceWindow* spice_presenter_window_get_window (SpicePresenterWindow* self);
VALA_EXTERN void spice_window_set_is_presenting (SpiceWindow* self,
                                     gboolean value);
static void spice_presenter_window_style (SpicePresenterWindow* self);
VALA_EXTERN void spice_utils_set_style (GtkWidget* widget,
                            const gchar* css);
VALA_EXTERN void spice_presenter_window_set_slide_manager (SpicePresenterWindow* self,
                                               SpiceSlideManager* value);
VALA_EXTERN void spice_presenter_window_set_window (SpicePresenterWindow* self,
                                        SpiceWindow* value);
static GType spice_presenter_window_slideshow_controller_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpicePresenterWindowSlideshowController, g_object_unref)
static SpicePresenterWindowSlideshowController* spice_presenter_window_slideshow_controller_new (SpiceSlideManager* slide_manager);
static SpicePresenterWindowSlideshowController* spice_presenter_window_slideshow_controller_construct (GType object_type,
                                                                                                SpiceSlideManager* slide_manager);
VALA_EXTERN gint spice_slide_manager_get_slide_ammount (SpiceSlideManager* self);
static void spice_presenter_window_slideshow_controller_update (SpicePresenterWindowSlideshowController* self,
                                                         SpiceSlide* slide);
static SpiceSlideManager* spice_presenter_window_slideshow_controller_get_slide_manager (SpicePresenterWindowSlideshowController* self);
VALA_EXTERN gint spice_slide_manager_get_slide_pos (SpiceSlideManager* self,
                                        SpiceSlide* current);
static gint spice_presenter_window_slideshow_controller_get_slide_count (SpicePresenterWindowSlideshowController* self);
static void spice_presenter_window_slideshow_controller_set_slide_manager (SpicePresenterWindowSlideshowController* self,
                                                                    SpiceSlideManager* value);
static void spice_presenter_window_slideshow_controller_set_slide_count (SpicePresenterWindowSlideshowController* self,
                                                                  gint value);
static GObject * spice_presenter_window_slideshow_controller_constructor (GType type,
                                                                   guint n_construct_properties,
                                                                   GObjectConstructParam * construct_properties);
static void _spice_slide_manager_next_slide_gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self);
static void _spice_slide_manager_previous_slide_gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static void _spice_presenter_window_slideshow_controller_update_spice_slide_manager_current_slide_changed (SpiceSlideManager* _sender,
                                                                                                    SpiceSlide* slide,
                                                                                                    gpointer self);
VALA_EXTERN SpiceSlide* spice_slide_manager_get_current_slide (SpiceSlideManager* self);
static void spice_presenter_window_slideshow_controller_finalize (GObject * obj);
static GType spice_presenter_window_slideshow_controller_get_type_once (void);
static void _vala_spice_presenter_window_slideshow_controller_get_property (GObject * object,
                                                                     guint property_id,
                                                                     GValue * value,
                                                                     GParamSpec * pspec);
static void _vala_spice_presenter_window_slideshow_controller_set_property (GObject * object,
                                                                     guint property_id,
                                                                     const GValue * value,
                                                                     GParamSpec * pspec);
static void spice_presenter_window_clock_update (SpicePresenterWindowClock* self);
static GType spice_presenter_window_clock_time_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SpicePresenterWindowClockTime* spice_presenter_window_clock_time_dup (const SpicePresenterWindowClockTime* self);
static void spice_presenter_window_clock_time_free (SpicePresenterWindowClockTime* self);
static void spice_presenter_window_clock_parse_time (SpicePresenterWindowClock* self,
                                              gint time,
                                              SpicePresenterWindowClockTime* result);
static gchar* spice_presenter_window_clock_get_part (SpicePresenterWindowClock* self,
                                              gint number);
static void spice_presenter_window_clock_start (SpicePresenterWindowClock* self);
static gboolean __lambda8_ (SpicePresenterWindowClock* self);
static gboolean ___lambda8__gsource_func (gpointer self);
static void spice_presenter_window_clock_stop (SpicePresenterWindowClock* self);
static void spice_presenter_window_clock_reset (SpicePresenterWindowClock* self);
static SpicePresenterWindowClock* spice_presenter_window_clock_new (void);
static SpicePresenterWindowClock* spice_presenter_window_clock_construct (GType object_type);
static GObject * spice_presenter_window_clock_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void _spice_presenter_window_clock_reset_gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static void _spice_presenter_window_clock___lambda9_ (SpicePresenterWindowClock* self);
static void __spice_presenter_window_clock___lambda9__gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void spice_presenter_window_clock_finalize (GObject * obj);
static GType spice_presenter_window_clock_get_type_once (void);
static GObject * spice_presenter_window_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
VALA_EXTERN SpiceSlideWidget* spice_slide_widget_new (void);
VALA_EXTERN SpiceSlideWidget* spice_slide_widget_construct (GType object_type);
static gboolean _spice_presenter_window___lambda92_ (SpicePresenterWindow* self);
static gboolean __spice_presenter_window___lambda92__gsource_func (gpointer self);
static gboolean _spice_presenter_window_on_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                            GdkEventKey* event,
                                                                            gpointer self);
static void _spice_presenter_window_load_previews_spice_slide_manager_current_slide_changed (SpiceSlideManager* _sender,
                                                                                      SpiceSlide* slide,
                                                                                      gpointer self);
static void _spice_presenter_window___lambda93_ (SpicePresenterWindow* self);
VALA_EXTERN void spice_slide_set_notes (SpiceSlide* self,
                            const gchar* value);
static void __spice_presenter_window___lambda93__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                                   gpointer self);
static void spice_presenter_window_finalize (GObject * obj);
static GType spice_presenter_window_get_type_once (void);
static void _vala_spice_presenter_window_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_spice_presenter_window_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
spice_presenter_window_get_instance_private (SpicePresenterWindow* self)
{
	return G_STRUCT_MEMBER_P (self, SpicePresenterWindow_private_offset);
}

SpicePresenterWindow*
spice_presenter_window_construct (GType object_type,
                                  SpiceSlideManager* slide_manager,
                                  SpiceWindow* window)
{
	SpicePresenterWindow * self = NULL;
#line 47 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_val_if_fail (slide_manager != NULL, NULL);
#line 47 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_val_if_fail (window != NULL, NULL);
#line 48 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self = (SpicePresenterWindow*) g_object_new (object_type, "slide-manager", slide_manager, "window", window, NULL);
#line 47 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return self;
#line 455 "PresenterView.c"
}

SpicePresenterWindow*
spice_presenter_window_new (SpiceSlideManager* slide_manager,
                            SpiceWindow* window)
{
#line 47 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return spice_presenter_window_construct (SPICE_TYPE_PRESENTER_WINDOW, slide_manager, window);
#line 464 "PresenterView.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 138 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return self ? g_object_ref (self) : NULL;
#line 472 "PresenterView.c"
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
#line 138 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_atomic_int_inc (&_data15_->_ref_count_);
#line 138 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return _data15_;
#line 482 "PresenterView.c"
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
#line 138 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
#line 492 "PresenterView.c"
		SpicePresenterWindow* self;
#line 138 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		self = _data15_->self;
#line 138 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_g_object_unref0 (_data15_->current_slide);
#line 138 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_g_object_unref0 (self);
#line 138 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		g_slice_free (Block15Data, _data15_);
#line 502 "PresenterView.c"
	}
}

static gboolean
__lambda10_ (Block15Data* _data15_)
{
	SpicePresenterWindow* self;
	SpiceCanvas* _tmp0_;
	GraniteDrawingBufferSurface* _tmp1_;
	gboolean result;
#line 148 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self = _data15_->self;
#line 149 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp0_ = _data15_->current_slide->canvas;
#line 149 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp1_ = _tmp0_->surface;
#line 149 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	if (_tmp1_ != NULL) {
#line 521 "PresenterView.c"
		GdkPixbuf* pixbuf = NULL;
		SpiceCanvas* _tmp2_;
		GraniteDrawingBufferSurface* _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		GtkImage* _tmp7_;
		GdkPixbuf* _tmp8_;
#line 150 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp2_ = _data15_->current_slide->canvas;
#line 150 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp3_ = _tmp2_->surface;
#line 150 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp4_ = granite_drawing_buffer_surface_load_to_pixbuf (_tmp3_);
#line 150 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		pixbuf = _tmp4_;
#line 151 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp5_ = pixbuf;
#line 151 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp6_ = gdk_pixbuf_scale_simple (_tmp5_, spice_slide_list_WIDTH * 2, spice_slide_list_HEIGHT * 2, GDK_INTERP_BILINEAR);
#line 151 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_g_object_unref0 (pixbuf);
#line 151 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		pixbuf = _tmp6_;
#line 152 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp7_ = self->priv->preview;
#line 152 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp8_ = pixbuf;
#line 152 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		gtk_image_set_from_pixbuf (_tmp7_, _tmp8_);
#line 153 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		result = FALSE;
#line 153 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_g_object_unref0 (pixbuf);
#line 153 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		return result;
#line 558 "PresenterView.c"
	}
#line 157 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	result = TRUE;
#line 157 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return result;
#line 564 "PresenterView.c"
}

static gboolean
___lambda10__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda10_ (self);
#line 148 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return result;
#line 574 "PresenterView.c"
}

static void
spice_presenter_window_load_previews (SpicePresenterWindow* self,
                                      SpiceSlide* current_slide)
{
	Block15Data* _data15_;
	SpiceSlide* _tmp0_;
	GtkTextView* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	SpiceSlide* next_slide = NULL;
	SpiceSlideManager* _tmp6_;
	SpiceSlide* _tmp7_;
	SpiceSlide* _tmp8_;
#line 138 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_if_fail (self != NULL);
#line 138 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_if_fail (current_slide != NULL);
#line 138 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_data15_ = g_slice_new0 (Block15Data);
#line 138 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_data15_->_ref_count_ = 1;
#line 138 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_data15_->self = g_object_ref (self);
#line 138 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp0_ = _g_object_ref0 (current_slide);
#line 138 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (_data15_->current_slide);
#line 138 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_data15_->current_slide = _tmp0_;
#line 139 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv->changing = TRUE;
#line 140 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp1_ = self->priv->notes;
#line 140 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp2_ = gtk_text_view_get_buffer (_tmp1_);
#line 140 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp3_ = _tmp2_;
#line 140 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp4_ = spice_slide_get_notes (_data15_->current_slide);
#line 140 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp5_ = _tmp4_;
#line 140 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_set (_tmp3_, "text", _tmp5_, NULL);
#line 142 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp6_ = self->priv->_slide_manager;
#line 142 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp7_ = spice_slide_manager_get_next_slide (_tmp6_, _data15_->current_slide);
#line 142 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	next_slide = _tmp7_;
#line 144 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp8_ = next_slide;
#line 144 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	if (_tmp8_ != NULL) {
#line 632 "PresenterView.c"
		SpiceSlideWidget* _tmp9_;
		SpiceSlide* _tmp10_;
		GtkImage* _tmp11_;
		GdkPixbuf* _tmp12_;
		GdkPixbuf* _tmp13_;
		GdkPixbuf* _tmp14_;
#line 145 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp9_ = self->priv->next_preview;
#line 145 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp10_ = next_slide;
#line 145 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp11_ = _tmp10_->preview;
#line 145 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		g_object_get (_tmp11_, "pixbuf", &_tmp12_, NULL);
#line 145 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp13_ = _tmp12_;
#line 145 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp14_ = _tmp13_;
#line 145 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		spice_slide_widget_set_pixbuf (_tmp9_, _tmp14_);
#line 145 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_g_object_unref0 (_tmp14_);
#line 655 "PresenterView.c"
	}
#line 148 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 30, ___lambda10__gsource_func, block15_data_ref (_data15_), block15_data_unref);
#line 160 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv->changing = FALSE;
#line 138 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (next_slide);
#line 138 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	block15_data_unref (_data15_);
#line 138 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_data15_ = NULL;
#line 667 "PresenterView.c"
}

static gboolean
spice_presenter_window_on_key_pressed (SpicePresenterWindow* self,
                                       GtkWidget* source,
                                       GdkEventKey* key)
{
	const gchar* _tmp0_;
	GtkTextView* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
#line 163 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 163 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_val_if_fail (source != NULL, FALSE);
#line 163 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 164 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp0_ = key->string;
#line 164 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_debug ("PresenterView.vala:164: Key on presenter view: %s %u", _tmp0_, key->keyval);
#line 165 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp1_ = self->priv->notes;
#line 165 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_get ((GtkWidget*) _tmp1_, "has-focus", &_tmp2_, NULL);
#line 165 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp3_ = _tmp2_;
#line 165 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	if (_tmp3_) {
#line 165 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		result = FALSE;
#line 165 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		return result;
#line 702 "PresenterView.c"
	}
#line 166 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	switch (key->keyval) {
#line 166 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case 32:
#line 166 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case 65363:
#line 166 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case 65364:
#line 166 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case 65293:
#line 166 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case 65366:
#line 716 "PresenterView.c"
		{
			SpiceSlideManager* _tmp4_;
#line 173 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			_tmp4_ = self->priv->_slide_manager;
#line 173 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			spice_slide_manager_next_slide (_tmp4_);
#line 174 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			result = TRUE;
#line 174 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			return result;
#line 727 "PresenterView.c"
		}
#line 166 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case 65361:
#line 166 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case 65362:
#line 166 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case 65365:
#line 735 "PresenterView.c"
		{
			SpiceSlideManager* _tmp5_;
#line 180 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			_tmp5_ = self->priv->_slide_manager;
#line 180 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			spice_slide_manager_previous_slide (_tmp5_);
#line 181 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			result = TRUE;
#line 181 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			return result;
#line 746 "PresenterView.c"
		}
#line 166 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case 65307:
#line 750 "PresenterView.c"
		{
#line 184 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			spice_presenter_window_end_presentation (self);
#line 185 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			result = TRUE;
#line 185 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			return result;
#line 758 "PresenterView.c"
		}
#line 166 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case 61:
#line 166 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case 43:
#line 764 "PresenterView.c"
		{
			gint _tmp6_;
			gint _tmp7_;
#line 188 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			_tmp6_ = spice_presenter_window_get_font_size (self);
#line 188 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			_tmp7_ = _tmp6_;
#line 188 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			spice_presenter_window_set_font_size (self, _tmp7_ + 2);
#line 189 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			result = TRUE;
#line 189 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			return result;
#line 778 "PresenterView.c"
		}
#line 166 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case 45:
#line 782 "PresenterView.c"
		{
			gint _tmp8_;
			gint _tmp9_;
#line 191 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			_tmp8_ = spice_presenter_window_get_font_size (self);
#line 191 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			_tmp9_ = _tmp8_;
#line 191 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			spice_presenter_window_set_font_size (self, _tmp9_ - 2);
#line 192 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			result = TRUE;
#line 192 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
			return result;
#line 796 "PresenterView.c"
		}
		default:
#line 166 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		break;
#line 801 "PresenterView.c"
	}
#line 195 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	result = FALSE;
#line 195 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return result;
#line 807 "PresenterView.c"
}

void
spice_presenter_window_end_presentation (SpicePresenterWindow* self)
{
	SpiceWindow* _tmp0_;
#line 198 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_if_fail (self != NULL);
#line 199 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp0_ = self->priv->_window;
#line 199 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	spice_window_set_is_presenting (_tmp0_, FALSE);
#line 820 "PresenterView.c"
}

static void
spice_presenter_window_style (SpicePresenterWindow* self)
{
	gchar* notes_css = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	GtkTextView* _tmp3_;
#line 202 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_if_fail (self != NULL);
#line 203 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp0_ = spice_presenter_window_get_font_size (self);
#line 203 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp1_ = _tmp0_;
#line 203 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp2_ = g_strdup_printf (SPICE_PRESENTER_WINDOW_NOTES_CSS, _tmp1_);
#line 203 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	notes_css = _tmp2_;
#line 204 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp3_ = self->priv->notes;
#line 204 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	spice_utils_set_style ((GtkWidget*) _tmp3_, notes_css);
#line 202 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_free0 (notes_css);
#line 847 "PresenterView.c"
}

SpiceSlideManager*
spice_presenter_window_get_slide_manager (SpicePresenterWindow* self)
{
	SpiceSlideManager* result;
	SpiceSlideManager* _tmp0_;
#line 23 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 23 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp0_ = self->priv->_slide_manager;
#line 23 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	result = _tmp0_;
#line 23 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return result;
#line 863 "PresenterView.c"
}

void
spice_presenter_window_set_slide_manager (SpicePresenterWindow* self,
                                          SpiceSlideManager* value)
{
	SpiceSlideManager* old_value;
#line 23 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_if_fail (self != NULL);
#line 23 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	old_value = spice_presenter_window_get_slide_manager (self);
#line 23 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	if (old_value != value) {
#line 23 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		self->priv->_slide_manager = value;
#line 23 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_presenter_window_properties[SPICE_PRESENTER_WINDOW_SLIDE_MANAGER_PROPERTY]);
#line 881 "PresenterView.c"
	}
}

SpiceWindow*
spice_presenter_window_get_window (SpicePresenterWindow* self)
{
	SpiceWindow* result;
	SpiceWindow* _tmp0_;
#line 24 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 24 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp0_ = self->priv->_window;
#line 24 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	result = _tmp0_;
#line 24 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return result;
#line 898 "PresenterView.c"
}

void
spice_presenter_window_set_window (SpicePresenterWindow* self,
                                   SpiceWindow* value)
{
	SpiceWindow* old_value;
#line 24 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_if_fail (self != NULL);
#line 24 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	old_value = spice_presenter_window_get_window (self);
#line 24 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	if (old_value != value) {
#line 24 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		self->priv->_window = value;
#line 24 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_presenter_window_properties[SPICE_PRESENTER_WINDOW_WINDOW_PROPERTY]);
#line 916 "PresenterView.c"
	}
}

static gint
spice_presenter_window_get_font_size (SpicePresenterWindow* self)
{
	gint result;
#line 36 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 37 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	result = self->priv->_font_size;
#line 37 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return result;
#line 930 "PresenterView.c"
}

static void
spice_presenter_window_set_font_size (SpicePresenterWindow* self,
                                      gint value)
{
	gboolean _tmp0_ = FALSE;
#line 39 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_if_fail (self != NULL);
#line 40 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	if (value >= 12) {
#line 40 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp0_ = value <= 50;
#line 944 "PresenterView.c"
	} else {
#line 40 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp0_ = FALSE;
#line 948 "PresenterView.c"
	}
#line 40 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	if (_tmp0_) {
#line 41 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		self->priv->_font_size = value;
#line 42 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		spice_presenter_window_style (self);
#line 956 "PresenterView.c"
	}
}

static inline gpointer
spice_presenter_window_slideshow_controller_get_instance_private (SpicePresenterWindowSlideshowController* self)
{
	return G_STRUCT_MEMBER_P (self, SpicePresenterWindowSlideshowController_private_offset);
}

static SpicePresenterWindowSlideshowController*
spice_presenter_window_slideshow_controller_construct (GType object_type,
                                                       SpiceSlideManager* slide_manager)
{
	SpicePresenterWindowSlideshowController * self = NULL;
#line 219 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_val_if_fail (slide_manager != NULL, NULL);
#line 220 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self = (SpicePresenterWindowSlideshowController*) g_object_new (object_type, "slide-manager", slide_manager, "slide-count", spice_slide_manager_get_slide_ammount (slide_manager), "column-spacing", 3, NULL);
#line 219 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return self;
#line 977 "PresenterView.c"
}

static SpicePresenterWindowSlideshowController*
spice_presenter_window_slideshow_controller_new (SpiceSlideManager* slide_manager)
{
#line 219 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return spice_presenter_window_slideshow_controller_construct (SPICE_PRESENTER_WINDOW_TYPE_SLIDESHOW_CONTROLLER, slide_manager);
#line 985 "PresenterView.c"
}

static void
spice_presenter_window_slideshow_controller_update (SpicePresenterWindowSlideshowController* self,
                                                    SpiceSlide* slide)
{
	SpiceSlideManager* _tmp0_;
	gint slide_pos = 0;
	SpiceSlideManager* _tmp1_;
#line 254 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_if_fail (self != NULL);
#line 254 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_if_fail (slide != NULL);
#line 255 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp0_ = self->priv->_slide_manager;
#line 255 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	spice_slide_manager_get_slide_pos (_tmp0_, slide);
#line 257 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp1_ = self->priv->_slide_manager;
#line 257 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	slide_pos = spice_slide_manager_get_slide_pos (_tmp1_, slide);
#line 259 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	if (slide_pos != -1) {
#line 1009 "PresenterView.c"
		GtkProgressBar* _tmp2_;
		gint _tmp3_;
		GtkProgressBar* _tmp4_;
		gint _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
#line 260 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp2_ = self->priv->progress_bar;
#line 260 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp3_ = self->priv->_slide_count;
#line 260 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		gtk_progress_bar_set_fraction (_tmp2_, ((gdouble) slide_pos) / ((gdouble) _tmp3_));
#line 261 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp4_ = self->priv->progress_bar;
#line 261 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp5_ = self->priv->_slide_count;
#line 261 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp6_ = g_strdup_printf (_ ("%d of %d"), slide_pos, _tmp5_);
#line 261 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp7_ = _tmp6_;
#line 261 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		gtk_progress_bar_set_text (_tmp4_, _tmp7_);
#line 261 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_g_free0 (_tmp7_);
#line 1034 "PresenterView.c"
	} else {
		GtkProgressBar* _tmp8_;
#line 263 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp8_ = self->priv->progress_bar;
#line 263 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		gtk_progress_bar_set_text (_tmp8_, _ ("End"));
#line 1041 "PresenterView.c"
	}
}

static SpiceSlideManager*
spice_presenter_window_slideshow_controller_get_slide_manager (SpicePresenterWindowSlideshowController* self)
{
	SpiceSlideManager* result;
	SpiceSlideManager* _tmp0_;
#line 213 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 213 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp0_ = self->priv->_slide_manager;
#line 213 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	result = _tmp0_;
#line 213 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return result;
#line 1058 "PresenterView.c"
}

static void
spice_presenter_window_slideshow_controller_set_slide_manager (SpicePresenterWindowSlideshowController* self,
                                                               SpiceSlideManager* value)
{
	SpiceSlideManager* old_value;
#line 213 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_if_fail (self != NULL);
#line 213 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	old_value = spice_presenter_window_slideshow_controller_get_slide_manager (self);
#line 213 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	if (old_value != value) {
#line 213 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		self->priv->_slide_manager = value;
#line 213 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_presenter_window_slideshow_controller_properties[SPICE_PRESENTER_WINDOW_SLIDESHOW_CONTROLLER_SLIDE_MANAGER_PROPERTY]);
#line 1076 "PresenterView.c"
	}
}

static gint
spice_presenter_window_slideshow_controller_get_slide_count (SpicePresenterWindowSlideshowController* self)
{
	gint result;
#line 215 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 215 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	result = self->priv->_slide_count;
#line 215 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return result;
#line 1090 "PresenterView.c"
}

static void
spice_presenter_window_slideshow_controller_set_slide_count (SpicePresenterWindowSlideshowController* self,
                                                             gint value)
{
	gint old_value;
#line 215 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_if_fail (self != NULL);
#line 215 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	old_value = spice_presenter_window_slideshow_controller_get_slide_count (self);
#line 215 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	if (old_value != value) {
#line 215 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		self->priv->_slide_count = value;
#line 215 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_presenter_window_slideshow_controller_properties[SPICE_PRESENTER_WINDOW_SLIDESHOW_CONTROLLER_SLIDE_COUNT_PROPERTY]);
#line 1108 "PresenterView.c"
	}
}

static void
_spice_slide_manager_next_slide_gtk_button_clicked (GtkButton* _sender,
                                                    gpointer self)
{
#line 227 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	spice_slide_manager_next_slide ((SpiceSlideManager*) self);
#line 1118 "PresenterView.c"
}

static void
_spice_slide_manager_previous_slide_gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
#line 228 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	spice_slide_manager_previous_slide ((SpiceSlideManager*) self);
#line 1127 "PresenterView.c"
}

static void
_spice_presenter_window_slideshow_controller_update_spice_slide_manager_current_slide_changed (SpiceSlideManager* _sender,
                                                                                               SpiceSlide* slide,
                                                                                               gpointer self)
{
#line 236 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	spice_presenter_window_slideshow_controller_update ((SpicePresenterWindowSlideshowController*) self, slide);
#line 1137 "PresenterView.c"
}

static GObject *
spice_presenter_window_slideshow_controller_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SpicePresenterWindowSlideshowController * self;
	GtkButton* next_button = NULL;
	GtkButton* _tmp0_;
	GtkButton* back_button = NULL;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	SpiceSlideManager* _tmp3_;
	GtkButton* _tmp4_;
	SpiceSlideManager* _tmp5_;
	GtkButton* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkButton* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	SpiceSlideManager* _tmp12_;
	GtkProgressBar* _tmp13_;
	GtkProgressBar* _tmp14_;
	GtkProgressBar* _tmp15_;
	GtkStyleContext* _tmp16_;
	GtkProgressBar* _tmp17_;
	GtkProgressBar* _tmp18_;
	GtkProgressBar* _tmp19_;
	GtkButton* _tmp20_;
	GtkProgressBar* _tmp21_;
	GtkButton* _tmp22_;
	SpiceSlideManager* _tmp23_;
	SpiceSlide* _tmp24_;
	SpiceSlide* _tmp25_;
#line 223 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	parent_class = G_OBJECT_CLASS (spice_presenter_window_slideshow_controller_parent_class);
#line 223 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 223 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_PRESENTER_WINDOW_TYPE_SLIDESHOW_CONTROLLER, SpicePresenterWindowSlideshowController);
#line 224 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp0_ = (GtkButton*) gtk_button_new_from_icon_name ("go-next-symbolic", (GtkIconSize) GTK_ICON_SIZE_DND);
#line 224 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp0_);
#line 224 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	next_button = _tmp0_;
#line 225 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp1_ = (GtkButton*) gtk_button_new_from_icon_name ("go-previous-symbolic", (GtkIconSize) GTK_ICON_SIZE_DND);
#line 225 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp1_);
#line 225 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	back_button = _tmp1_;
#line 227 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp2_ = next_button;
#line 227 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp3_ = self->priv->_slide_manager;
#line 227 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_signal_connect_object (_tmp2_, "clicked", (GCallback) _spice_slide_manager_next_slide_gtk_button_clicked, _tmp3_, 0);
#line 228 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp4_ = back_button;
#line 228 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp5_ = self->priv->_slide_manager;
#line 228 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_signal_connect_object (_tmp4_, "clicked", (GCallback) _spice_slide_manager_previous_slide_gtk_button_clicked, _tmp5_, 0);
#line 230 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp6_ = next_button;
#line 230 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
#line 230 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_style_context_add_class (_tmp7_, "circular");
#line 231 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp8_ = back_button;
#line 231 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
#line 231 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_style_context_add_class (_tmp9_, "circular");
#line 233 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp10_ = next_button;
#line 233 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp10_, GTK_ALIGN_CENTER);
#line 234 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp11_ = back_button;
#line 234 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp11_, GTK_ALIGN_CENTER);
#line 236 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp12_ = self->priv->_slide_manager;
#line 236 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_signal_connect_object (_tmp12_, "current-slide-changed", (GCallback) _spice_presenter_window_slideshow_controller_update_spice_slide_manager_current_slide_changed, self, 0);
#line 238 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp13_ = (GtkProgressBar*) gtk_progress_bar_new ();
#line 238 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp13_);
#line 238 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (self->priv->progress_bar);
#line 238 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv->progress_bar = _tmp13_;
#line 239 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp14_ = self->priv->progress_bar;
#line 239 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_progress_bar_set_ellipsize (_tmp14_, PANGO_ELLIPSIZE_MIDDLE);
#line 240 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp15_ = self->priv->progress_bar;
#line 240 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) _tmp15_);
#line 240 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_style_context_add_class (_tmp16_, "h2");
#line 241 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp17_ = self->priv->progress_bar;
#line 241 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp17_, GTK_ALIGN_CENTER);
#line 242 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp18_ = self->priv->progress_bar;
#line 242 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_progress_bar_set_show_text (_tmp18_, TRUE);
#line 243 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp19_ = self->priv->progress_bar;
#line 243 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_set ((GtkWidget*) _tmp19_, "expand", TRUE, NULL);
#line 245 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_END);
#line 247 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp20_ = back_button;
#line 247 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp20_);
#line 248 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp21_ = self->priv->progress_bar;
#line 248 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp21_);
#line 249 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp22_ = next_button;
#line 249 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp22_);
#line 251 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp23_ = self->priv->_slide_manager;
#line 251 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp24_ = spice_slide_manager_get_current_slide (_tmp23_);
#line 251 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp25_ = _tmp24_;
#line 251 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	spice_presenter_window_slideshow_controller_update (self, _tmp25_);
#line 223 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (back_button);
#line 223 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (next_button);
#line 223 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return obj;
#line 1288 "PresenterView.c"
}

static void
spice_presenter_window_slideshow_controller_class_init (SpicePresenterWindowSlideshowControllerClass * klass,
                                                        gpointer klass_data)
{
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	spice_presenter_window_slideshow_controller_parent_class = g_type_class_peek_parent (klass);
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_type_class_adjust_private_offset (klass, &SpicePresenterWindowSlideshowController_private_offset);
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_presenter_window_slideshow_controller_get_property;
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_presenter_window_slideshow_controller_set_property;
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	G_OBJECT_CLASS (klass)->constructor = spice_presenter_window_slideshow_controller_constructor;
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_presenter_window_slideshow_controller_finalize;
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_PRESENTER_WINDOW_SLIDESHOW_CONTROLLER_SLIDE_MANAGER_PROPERTY, spice_presenter_window_slideshow_controller_properties[SPICE_PRESENTER_WINDOW_SLIDESHOW_CONTROLLER_SLIDE_MANAGER_PROPERTY] = g_param_spec_object ("slide-manager", "slide-manager", "slide-manager", SPICE_TYPE_SLIDE_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_PRESENTER_WINDOW_SLIDESHOW_CONTROLLER_SLIDE_COUNT_PROPERTY, spice_presenter_window_slideshow_controller_properties[SPICE_PRESENTER_WINDOW_SLIDESHOW_CONTROLLER_SLIDE_COUNT_PROPERTY] = g_param_spec_int ("slide-count", "slide-count", "slide-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 1311 "PresenterView.c"
}

static void
spice_presenter_window_slideshow_controller_instance_init (SpicePresenterWindowSlideshowController * self,
                                                           gpointer klass)
{
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv = spice_presenter_window_slideshow_controller_get_instance_private (self);
#line 1320 "PresenterView.c"
}

static void
spice_presenter_window_slideshow_controller_finalize (GObject * obj)
{
	SpicePresenterWindowSlideshowController * self;
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_PRESENTER_WINDOW_TYPE_SLIDESHOW_CONTROLLER, SpicePresenterWindowSlideshowController);
#line 217 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (self->priv->progress_bar);
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	G_OBJECT_CLASS (spice_presenter_window_slideshow_controller_parent_class)->finalize (obj);
#line 1333 "PresenterView.c"
}

static GType
spice_presenter_window_slideshow_controller_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpicePresenterWindowSlideshowControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_presenter_window_slideshow_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpicePresenterWindowSlideshowController), 0, (GInstanceInitFunc) spice_presenter_window_slideshow_controller_instance_init, NULL };
	GType spice_presenter_window_slideshow_controller_type_id;
	spice_presenter_window_slideshow_controller_type_id = g_type_register_static (gtk_grid_get_type (), "SpicePresenterWindowSlideshowController", &g_define_type_info, 0);
	SpicePresenterWindowSlideshowController_private_offset = g_type_add_instance_private (spice_presenter_window_slideshow_controller_type_id, sizeof (SpicePresenterWindowSlideshowControllerPrivate));
	return spice_presenter_window_slideshow_controller_type_id;
}

static GType
spice_presenter_window_slideshow_controller_get_type (void)
{
	static volatile gsize spice_presenter_window_slideshow_controller_type_id__once = 0;
	if (g_once_init_enter (&spice_presenter_window_slideshow_controller_type_id__once)) {
		GType spice_presenter_window_slideshow_controller_type_id;
		spice_presenter_window_slideshow_controller_type_id = spice_presenter_window_slideshow_controller_get_type_once ();
		g_once_init_leave (&spice_presenter_window_slideshow_controller_type_id__once, spice_presenter_window_slideshow_controller_type_id);
	}
	return spice_presenter_window_slideshow_controller_type_id__once;
}

static void
_vala_spice_presenter_window_slideshow_controller_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec)
{
	SpicePresenterWindowSlideshowController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_PRESENTER_WINDOW_TYPE_SLIDESHOW_CONTROLLER, SpicePresenterWindowSlideshowController);
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	switch (property_id) {
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case SPICE_PRESENTER_WINDOW_SLIDESHOW_CONTROLLER_SLIDE_MANAGER_PROPERTY:
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		g_value_set_object (value, spice_presenter_window_slideshow_controller_get_slide_manager (self));
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		break;
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case SPICE_PRESENTER_WINDOW_SLIDESHOW_CONTROLLER_SLIDE_COUNT_PROPERTY:
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		g_value_set_int (value, spice_presenter_window_slideshow_controller_get_slide_count (self));
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		break;
#line 1380 "PresenterView.c"
		default:
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		break;
#line 1386 "PresenterView.c"
	}
}

static void
_vala_spice_presenter_window_slideshow_controller_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec)
{
	SpicePresenterWindowSlideshowController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_PRESENTER_WINDOW_TYPE_SLIDESHOW_CONTROLLER, SpicePresenterWindowSlideshowController);
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	switch (property_id) {
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case SPICE_PRESENTER_WINDOW_SLIDESHOW_CONTROLLER_SLIDE_MANAGER_PROPERTY:
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		spice_presenter_window_slideshow_controller_set_slide_manager (self, g_value_get_object (value));
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		break;
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case SPICE_PRESENTER_WINDOW_SLIDESHOW_CONTROLLER_SLIDE_COUNT_PROPERTY:
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		spice_presenter_window_slideshow_controller_set_slide_count (self, g_value_get_int (value));
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		break;
#line 1412 "PresenterView.c"
		default:
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 212 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		break;
#line 1418 "PresenterView.c"
	}
}

static inline gpointer
spice_presenter_window_clock_get_instance_private (SpicePresenterWindowClock* self)
{
	return G_STRUCT_MEMBER_P (self, SpicePresenterWindowClock_private_offset);
}

static void
spice_presenter_window_clock_update (SpicePresenterWindowClock* self)
{
	SpicePresenterWindowClockTime t = {0};
	GTimer* _tmp0_;
	SpicePresenterWindowClockTime _tmp1_ = {0};
	gchar* time = NULL;
	SpicePresenterWindowClockTime _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	SpicePresenterWindowClockTime _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	SpicePresenterWindowClockTime _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkLabel* _tmp13_;
#line 315 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_if_fail (self != NULL);
#line 316 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp0_ = self->priv->timer;
#line 316 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	spice_presenter_window_clock_parse_time (self, (gint) g_timer_elapsed (_tmp0_, NULL), &_tmp1_);
#line 316 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	t = _tmp1_;
#line 317 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp2_ = t;
#line 317 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp3_ = spice_presenter_window_clock_get_part (self, _tmp2_.hours);
#line 317 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp4_ = _tmp3_;
#line 317 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp5_ = t;
#line 317 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp6_ = spice_presenter_window_clock_get_part (self, _tmp5_.minutes);
#line 317 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp7_ = _tmp6_;
#line 317 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp8_ = t;
#line 317 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp9_ = spice_presenter_window_clock_get_part (self, _tmp8_.seconds);
#line 317 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp10_ = _tmp9_;
#line 317 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp11_ = g_strdup_printf ("%s:%s:%s", _tmp4_, _tmp7_, _tmp10_);
#line 317 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp12_ = _tmp11_;
#line 317 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_free0 (_tmp10_);
#line 317 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_free0 (_tmp7_);
#line 317 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_free0 (_tmp4_);
#line 317 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	time = _tmp12_;
#line 318 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp13_ = self->priv->label;
#line 318 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_label_set_label (_tmp13_, time);
#line 315 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_free0 (time);
#line 1491 "PresenterView.c"
}

static gchar*
spice_presenter_window_clock_get_part (SpicePresenterWindowClock* self,
                                       gint number)
{
	gchar* _tmp0_ = NULL;
	gchar* result;
#line 321 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 322 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	if (number > 9) {
#line 1504 "PresenterView.c"
		gchar* _tmp1_;
#line 322 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp1_ = g_strdup_printf ("%d", number);
#line 322 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_g_free0 (_tmp0_);
#line 322 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp0_ = _tmp1_;
#line 1512 "PresenterView.c"
	} else {
		gchar* _tmp2_;
#line 322 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp2_ = g_strdup_printf ("0%d", number);
#line 322 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_g_free0 (_tmp0_);
#line 322 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp0_ = _tmp2_;
#line 1521 "PresenterView.c"
	}
#line 322 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	result = _tmp0_;
#line 322 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return result;
#line 1527 "PresenterView.c"
}

static void
spice_presenter_window_clock_parse_time (SpicePresenterWindowClock* self,
                                         gint time,
                                         SpicePresenterWindowClockTime* result)
{
	SpicePresenterWindowClockTime t = {0};
#line 325 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_if_fail (self != NULL);
#line 326 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	memset (&t, 0, sizeof (SpicePresenterWindowClockTime));
#line 327 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	t.seconds = time % 60;
#line 329 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	time = time / 60;
#line 330 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	t.minutes = time % 60;
#line 332 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	time = time / 60;
#line 333 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	t.hours = time / 60;
#line 335 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	*result = t;
#line 335 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return;
#line 1554 "PresenterView.c"
}

static gboolean
__lambda8_ (SpicePresenterWindowClock* self)
{
	gboolean result;
#line 348 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	spice_presenter_window_clock_update (self);
#line 349 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	result = self->priv->started;
#line 349 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return result;
#line 1567 "PresenterView.c"
}

static gboolean
___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda8_ ((SpicePresenterWindowClock*) self);
#line 347 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return result;
#line 1577 "PresenterView.c"
}

static void
spice_presenter_window_clock_start (SpicePresenterWindowClock* self)
{
	GTimer* _tmp0_;
	GtkImage* _tmp4_;
#line 338 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_if_fail (self != NULL);
#line 339 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp0_ = self->priv->timer;
#line 339 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	if (_tmp0_ == NULL) {
#line 1591 "PresenterView.c"
		GTimer* _tmp1_;
		GTimer* _tmp2_;
#line 340 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp1_ = g_timer_new ();
#line 340 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_g_timer_destroy0 (self->priv->timer);
#line 340 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		self->priv->timer = _tmp1_;
#line 341 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp2_ = self->priv->timer;
#line 341 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		g_timer_start (_tmp2_);
#line 1604 "PresenterView.c"
	} else {
		GTimer* _tmp3_;
#line 343 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp3_ = self->priv->timer;
#line 343 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		g_timer_continue (_tmp3_);
#line 1611 "PresenterView.c"
	}
#line 346 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv->started = TRUE;
#line 347 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, ___lambda8__gsource_func, g_object_ref (self), g_object_unref);
#line 352 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp4_ = self->priv->pause_image;
#line 352 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_set (_tmp4_, "icon-name", "media-playback-pause-symbolic", NULL);
#line 1621 "PresenterView.c"
}

static void
spice_presenter_window_clock_stop (SpicePresenterWindowClock* self)
{
	GTimer* _tmp0_;
	GtkImage* _tmp1_;
#line 355 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_if_fail (self != NULL);
#line 356 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv->started = FALSE;
#line 357 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp0_ = self->priv->timer;
#line 357 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_timer_stop (_tmp0_);
#line 358 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp1_ = self->priv->pause_image;
#line 358 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_set (_tmp1_, "icon-name", "media-playback-start-symbolic", NULL);
#line 1641 "PresenterView.c"
}

static void
spice_presenter_window_clock_reset (SpicePresenterWindowClock* self)
{
	GtkLabel* _tmp0_;
	GtkImage* _tmp1_;
#line 361 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_return_if_fail (self != NULL);
#line 362 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_timer_destroy0 (self->priv->timer);
#line 362 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv->timer = NULL;
#line 363 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv->started = FALSE;
#line 364 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp0_ = self->priv->label;
#line 364 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_label_set_label (_tmp0_, "00:00:00");
#line 365 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp1_ = self->priv->pause_image;
#line 365 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_set (_tmp1_, "icon-name", "media-playback-start-symbolic", NULL);
#line 1665 "PresenterView.c"
}

static SpicePresenterWindowClock*
spice_presenter_window_clock_construct (GType object_type)
{
	SpicePresenterWindowClock * self = NULL;
#line 268 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self = (SpicePresenterWindowClock*) g_object_new (object_type, NULL);
#line 268 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return self;
#line 1676 "PresenterView.c"
}

static SpicePresenterWindowClock*
spice_presenter_window_clock_new (void)
{
#line 268 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return spice_presenter_window_clock_construct (SPICE_PRESENTER_WINDOW_TYPE_CLOCK);
#line 1684 "PresenterView.c"
}

static SpicePresenterWindowClockTime*
spice_presenter_window_clock_time_dup (const SpicePresenterWindowClockTime* self)
{
	SpicePresenterWindowClockTime* dup;
#line 269 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	dup = g_new0 (SpicePresenterWindowClockTime, 1);
#line 269 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	memcpy (dup, self, sizeof (SpicePresenterWindowClockTime));
#line 269 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return dup;
#line 1697 "PresenterView.c"
}

static void
spice_presenter_window_clock_time_free (SpicePresenterWindowClockTime* self)
{
#line 269 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_free (self);
#line 1705 "PresenterView.c"
}

static GType
spice_presenter_window_clock_time_get_type_once (void)
{
	GType spice_presenter_window_clock_time_type_id;
	spice_presenter_window_clock_time_type_id = g_boxed_type_register_static ("SpicePresenterWindowClockTime", (GBoxedCopyFunc) spice_presenter_window_clock_time_dup, (GBoxedFreeFunc) spice_presenter_window_clock_time_free);
	return spice_presenter_window_clock_time_type_id;
}

static GType
spice_presenter_window_clock_time_get_type (void)
{
	static volatile gsize spice_presenter_window_clock_time_type_id__once = 0;
	if (g_once_init_enter (&spice_presenter_window_clock_time_type_id__once)) {
		GType spice_presenter_window_clock_time_type_id;
		spice_presenter_window_clock_time_type_id = spice_presenter_window_clock_time_get_type_once ();
		g_once_init_leave (&spice_presenter_window_clock_time_type_id__once, spice_presenter_window_clock_time_type_id);
	}
	return spice_presenter_window_clock_time_type_id__once;
}

static void
_spice_presenter_window_clock_reset_gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
#line 297 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	spice_presenter_window_clock_reset ((SpicePresenterWindowClock*) self);
#line 1734 "PresenterView.c"
}

static void
_spice_presenter_window_clock___lambda9_ (SpicePresenterWindowClock* self)
{
#line 299 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	if (self->priv->started) {
#line 300 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		spice_presenter_window_clock_stop (self);
#line 1744 "PresenterView.c"
	} else {
#line 302 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		spice_presenter_window_clock_start (self);
#line 1748 "PresenterView.c"
	}
}

static void
__spice_presenter_window_clock___lambda9__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
#line 298 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_spice_presenter_window_clock___lambda9_ ((SpicePresenterWindowClock*) self);
#line 1758 "PresenterView.c"
}

static GObject *
spice_presenter_window_clock_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SpicePresenterWindowClock * self;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkImage* _tmp3_;
	GtkImage* reset_image = NULL;
	GtkImage* _tmp4_;
	GtkButton* reset_button = NULL;
	GtkButton* _tmp5_;
	GtkButton* pause_button = NULL;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkImage* _tmp8_;
	GtkButton* _tmp9_;
	GtkImage* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	GtkBox* box = NULL;
	GtkBox* _tmp13_;
	GtkBox* _tmp14_;
	GtkBox* _tmp15_;
	GtkButton* _tmp16_;
	GtkBox* _tmp17_;
	GtkButton* _tmp18_;
	GtkLabel* _tmp19_;
	GtkBox* _tmp20_;
#line 280 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	parent_class = G_OBJECT_CLASS (spice_presenter_window_clock_parent_class);
#line 280 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 280 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_PRESENTER_WINDOW_TYPE_CLOCK, SpicePresenterWindowClock);
#line 281 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
#line 282 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_CENTER);
#line 283 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_grid_set_column_spacing ((GtkGrid*) self, 6);
#line 285 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp0_ = (GtkLabel*) gtk_label_new ("00:00:00");
#line 285 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp0_);
#line 285 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (self->priv->label);
#line 285 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv->label = _tmp0_;
#line 286 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp1_ = self->priv->label;
#line 286 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
#line 286 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_style_context_add_class (_tmp2_, "h1");
#line 288 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playback-pause-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
#line 288 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp3_);
#line 288 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (self->priv->pause_image);
#line 288 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv->pause_image = _tmp3_;
#line 289 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp4_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playback-stop-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
#line 289 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp4_);
#line 289 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	reset_image = _tmp4_;
#line 291 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp5_ = (GtkButton*) gtk_button_new ();
#line 291 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp5_);
#line 291 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	reset_button = _tmp5_;
#line 292 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp6_ = (GtkButton*) gtk_button_new ();
#line 292 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp6_);
#line 292 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	pause_button = _tmp6_;
#line 294 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp7_ = reset_button;
#line 294 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp8_ = reset_image;
#line 294 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
#line 295 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp9_ = pause_button;
#line 295 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp10_ = self->priv->pause_image;
#line 295 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
#line 297 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp11_ = reset_button;
#line 297 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_signal_connect_object (_tmp11_, "clicked", (GCallback) _spice_presenter_window_clock_reset_gtk_button_clicked, self, 0);
#line 298 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp12_ = pause_button;
#line 298 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_signal_connect_object (_tmp12_, "clicked", (GCallback) __spice_presenter_window_clock___lambda9__gtk_button_clicked, self, 0);
#line 306 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp13_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 3);
#line 306 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp13_);
#line 306 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	box = _tmp13_;
#line 307 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp14_ = box;
#line 307 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_set ((GtkWidget*) _tmp14_, "margin", 6, NULL);
#line 309 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp15_ = box;
#line 309 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp16_ = pause_button;
#line 309 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
#line 310 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp17_ = box;
#line 310 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp18_ = reset_button;
#line 310 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
#line 311 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp19_ = self->priv->label;
#line 311 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp19_);
#line 312 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp20_ = box;
#line 312 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp20_);
#line 280 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (box);
#line 280 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (pause_button);
#line 280 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (reset_button);
#line 280 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (reset_image);
#line 280 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return obj;
#line 1906 "PresenterView.c"
}

static void
spice_presenter_window_clock_class_init (SpicePresenterWindowClockClass * klass,
                                         gpointer klass_data)
{
#line 268 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	spice_presenter_window_clock_parent_class = g_type_class_peek_parent (klass);
#line 268 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_type_class_adjust_private_offset (klass, &SpicePresenterWindowClock_private_offset);
#line 268 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	G_OBJECT_CLASS (klass)->constructor = spice_presenter_window_clock_constructor;
#line 268 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_presenter_window_clock_finalize;
#line 1921 "PresenterView.c"
}

static void
spice_presenter_window_clock_instance_init (SpicePresenterWindowClock * self,
                                            gpointer klass)
{
#line 268 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv = spice_presenter_window_clock_get_instance_private (self);
#line 275 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv->timer = NULL;
#line 276 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv->started = FALSE;
#line 1934 "PresenterView.c"
}

static void
spice_presenter_window_clock_finalize (GObject * obj)
{
	SpicePresenterWindowClock * self;
#line 268 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_PRESENTER_WINDOW_TYPE_CLOCK, SpicePresenterWindowClock);
#line 275 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_timer_destroy0 (self->priv->timer);
#line 277 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (self->priv->label);
#line 278 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (self->priv->pause_image);
#line 268 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	G_OBJECT_CLASS (spice_presenter_window_clock_parent_class)->finalize (obj);
#line 1951 "PresenterView.c"
}

static GType
spice_presenter_window_clock_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpicePresenterWindowClockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_presenter_window_clock_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpicePresenterWindowClock), 0, (GInstanceInitFunc) spice_presenter_window_clock_instance_init, NULL };
	GType spice_presenter_window_clock_type_id;
	spice_presenter_window_clock_type_id = g_type_register_static (gtk_grid_get_type (), "SpicePresenterWindowClock", &g_define_type_info, 0);
	SpicePresenterWindowClock_private_offset = g_type_add_instance_private (spice_presenter_window_clock_type_id, sizeof (SpicePresenterWindowClockPrivate));
	return spice_presenter_window_clock_type_id;
}

static GType
spice_presenter_window_clock_get_type (void)
{
	static volatile gsize spice_presenter_window_clock_type_id__once = 0;
	if (g_once_init_enter (&spice_presenter_window_clock_type_id__once)) {
		GType spice_presenter_window_clock_type_id;
		spice_presenter_window_clock_type_id = spice_presenter_window_clock_get_type_once ();
		g_once_init_leave (&spice_presenter_window_clock_type_id__once, spice_presenter_window_clock_type_id);
	}
	return spice_presenter_window_clock_type_id__once;
}

static gboolean
_spice_presenter_window___lambda92_ (SpicePresenterWindow* self)
{
	SpiceSlideManager* _tmp0_;
	SpiceSlide* _tmp1_;
	SpiceSlide* _tmp2_;
	gboolean result;
#line 121 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp0_ = self->priv->_slide_manager;
#line 121 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp1_ = spice_slide_manager_get_current_slide (_tmp0_);
#line 121 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp2_ = _tmp1_;
#line 121 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	spice_presenter_window_load_previews (self, _tmp2_);
#line 122 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	result = FALSE;
#line 122 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return result;
#line 1995 "PresenterView.c"
}

static gboolean
__spice_presenter_window___lambda92__gsource_func (gpointer self)
{
	gboolean result;
	result = _spice_presenter_window___lambda92_ ((SpicePresenterWindow*) self);
#line 120 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return result;
#line 2005 "PresenterView.c"
}

static gboolean
_spice_presenter_window_on_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                   GdkEventKey* event,
                                                                   gpointer self)
{
	gboolean result;
	result = spice_presenter_window_on_key_pressed ((SpicePresenterWindow*) self, _sender, event);
#line 125 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return result;
#line 2017 "PresenterView.c"
}

static void
_spice_presenter_window_load_previews_spice_slide_manager_current_slide_changed (SpiceSlideManager* _sender,
                                                                                 SpiceSlide* slide,
                                                                                 gpointer self)
{
#line 127 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	spice_presenter_window_load_previews ((SpicePresenterWindow*) self, slide);
#line 2027 "PresenterView.c"
}

static void
_spice_presenter_window___lambda93_ (SpicePresenterWindow* self)
{
#line 130 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	if (!self->priv->changing) {
#line 2035 "PresenterView.c"
		SpiceSlideManager* _tmp0_;
		SpiceSlide* _tmp1_;
		SpiceSlide* _tmp2_;
		GtkTextView* _tmp3_;
		GtkTextBuffer* _tmp4_;
		GtkTextBuffer* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
#line 131 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp0_ = self->priv->_slide_manager;
#line 131 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp1_ = spice_slide_manager_get_current_slide (_tmp0_);
#line 131 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp2_ = _tmp1_;
#line 131 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp3_ = self->priv->notes;
#line 131 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp4_ = gtk_text_view_get_buffer (_tmp3_);
#line 131 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp5_ = _tmp4_;
#line 131 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		g_object_get (_tmp5_, "text", &_tmp6_, NULL);
#line 131 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp7_ = _tmp6_;
#line 131 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_tmp8_ = _tmp7_;
#line 131 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		spice_slide_set_notes (_tmp2_, _tmp8_);
#line 131 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		_g_free0 (_tmp8_);
#line 2067 "PresenterView.c"
	}
}

static void
__spice_presenter_window___lambda93__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                              gpointer self)
{
#line 129 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_spice_presenter_window___lambda93_ ((SpicePresenterWindow*) self);
#line 2077 "PresenterView.c"
}

static GObject *
spice_presenter_window_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SpicePresenterWindow * self;
	SpicePresenterWindowClock* _tmp0_;
	SpicePresenterWindowClock* _tmp1_;
	GtkImage* _tmp2_;
	GtkImage* _tmp3_;
	GtkButton* preview_button = NULL;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkButton* _tmp7_;
	GtkStyleContext* _tmp8_;
	GtkButton* _tmp9_;
	GtkImage* _tmp10_;
	SpiceSlideWidget* _tmp11_;
	SpiceSlideWidget* _tmp12_;
	SpiceSlideWidget* _tmp13_;
	GtkButton* next_preview_button = NULL;
	GtkButton* _tmp14_;
	GtkButton* _tmp15_;
	GtkStyleContext* _tmp16_;
	GtkButton* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkButton* _tmp19_;
	GtkButton* _tmp20_;
	GtkButton* _tmp21_;
	SpiceSlideWidget* _tmp22_;
	GtkTextView* _tmp23_;
	GtkTextView* _tmp24_;
	GtkStyleContext* _tmp25_;
	GtkTextView* _tmp26_;
	GtkTextView* _tmp27_;
	GtkTextView* _tmp28_;
	GtkScrolledWindow* notes_scrolled = NULL;
	GtkScrolledWindow* _tmp29_;
	GtkScrolledWindow* _tmp30_;
	GtkScrolledWindow* _tmp31_;
	GtkScrolledWindow* _tmp32_;
	GtkTextView* _tmp33_;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp34_;
	GtkFrame* _tmp35_;
	GtkScrolledWindow* _tmp36_;
	GtkFrame* _tmp37_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp38_;
	GtkGrid* _tmp39_;
	GtkGrid* _tmp40_;
	GtkGrid* _tmp41_;
	GtkSeparator* separator = NULL;
	GtkSeparator* _tmp42_;
	SpicePresenterWindowClock* timer = NULL;
	SpicePresenterWindowClock* _tmp43_;
	SpicePresenterWindowClock* _tmp44_;
	SpicePresenterWindowSlideshowController* controller = NULL;
	SpiceSlideManager* _tmp45_;
	SpicePresenterWindowSlideshowController* _tmp46_;
	GtkGrid* _tmp47_;
	GtkButton* _tmp48_;
	GtkGrid* _tmp49_;
	GtkButton* _tmp50_;
	GtkGrid* _tmp51_;
	GtkSeparator* _tmp52_;
	GtkGrid* _tmp53_;
	GtkFrame* _tmp54_;
	GtkGrid* _tmp55_;
	SpicePresenterWindowClock* _tmp56_;
	GtkGrid* _tmp57_;
	SpicePresenterWindowSlideshowController* _tmp58_;
	GtkGrid* _tmp59_;
	SpiceSlideManager* _tmp60_;
	SpiceSlide* _tmp61_;
	SpiceSlide* _tmp62_;
	SpiceSlideManager* _tmp63_;
	GtkTextView* _tmp64_;
	GtkTextBuffer* _tmp65_;
	GtkTextBuffer* _tmp66_;
	GtkButton* _tmp67_;
	SpiceSlideManager* _tmp68_;
#line 51 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	parent_class = G_OBJECT_CLASS (spice_presenter_window_parent_class);
#line 51 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 51 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_PRESENTER_WINDOW, SpicePresenterWindow);
#line 52 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_window_set_title ((GtkWindow*) self, "Spice-Up - Presenter View");
#line 54 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
#line 55 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_window_stick ((GtkWindow*) self);
#line 57 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp0_ = spice_presenter_window_clock_new ();
#line 57 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp0_);
#line 57 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (self->priv->clock);
#line 57 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv->clock = _tmp0_;
#line 58 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp1_ = self->priv->clock;
#line 58 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	spice_presenter_window_clock_start (_tmp1_);
#line 60 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp2_ = (GtkImage*) gtk_image_new ();
#line 60 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp2_);
#line 60 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (self->priv->preview);
#line 60 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv->preview = _tmp2_;
#line 61 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp3_ = self->priv->preview;
#line 61 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_START);
#line 63 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp4_ = (GtkButton*) gtk_button_new ();
#line 63 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp4_);
#line 63 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	preview_button = _tmp4_;
#line 64 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp5_ = preview_button;
#line 64 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
#line 64 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_style_context_remove_class (_tmp6_, "button");
#line 65 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp7_ = preview_button;
#line 65 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
#line 65 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_style_context_add_class (_tmp8_, "flat");
#line 66 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp9_ = preview_button;
#line 66 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp10_ = self->priv->preview;
#line 66 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
#line 68 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp11_ = spice_slide_widget_new ();
#line 68 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp11_);
#line 68 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (self->priv->next_preview);
#line 68 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv->next_preview = _tmp11_;
#line 69 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp12_ = self->priv->next_preview;
#line 69 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp12_, GTK_ALIGN_START);
#line 70 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp13_ = self->priv->next_preview;
#line 70 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp13_->show_button = FALSE;
#line 72 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp14_ = (GtkButton*) gtk_button_new ();
#line 72 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp14_);
#line 72 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	next_preview_button = _tmp14_;
#line 73 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp15_ = next_preview_button;
#line 73 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) _tmp15_);
#line 73 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_style_context_add_class (_tmp16_, "padding-none");
#line 74 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp17_ = next_preview_button;
#line 74 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
#line 74 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_style_context_add_class (_tmp18_, "flat");
#line 75 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp19_ = next_preview_button;
#line 75 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp19_, GTK_ALIGN_START);
#line 76 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp20_ = next_preview_button;
#line 76 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp20_, GTK_ALIGN_CENTER);
#line 78 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp21_ = next_preview_button;
#line 78 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp22_ = self->priv->next_preview;
#line 78 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
#line 80 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp23_ = (GtkTextView*) gtk_text_view_new ();
#line 80 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp23_);
#line 80 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (self->priv->notes);
#line 80 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv->notes = _tmp23_;
#line 81 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp24_ = self->priv->notes;
#line 81 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp25_ = gtk_widget_get_style_context ((GtkWidget*) _tmp24_);
#line 81 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_style_context_add_class (_tmp25_, "h3");
#line 82 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp26_ = self->priv->notes;
#line 82 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_text_view_set_wrap_mode (_tmp26_, GTK_WRAP_WORD_CHAR);
#line 83 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp27_ = self->priv->notes;
#line 83 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp27_, GTK_ALIGN_FILL);
#line 84 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp28_ = self->priv->notes;
#line 84 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_text_view_set_indent (_tmp28_, 6);
#line 86 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	spice_presenter_window_set_font_size (self, 12);
#line 88 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp29_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 88 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp29_);
#line 88 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	notes_scrolled = _tmp29_;
#line 89 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp30_ = notes_scrolled;
#line 89 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_set (_tmp30_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
#line 90 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp31_ = notes_scrolled;
#line 90 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_set ((GtkWidget*) _tmp31_, "height-request", 130, NULL);
#line 91 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp32_ = notes_scrolled;
#line 91 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp33_ = self->priv->notes;
#line 91 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_container_add ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp33_);
#line 93 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp34_ = (GtkFrame*) gtk_frame_new (NULL);
#line 93 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp34_);
#line 93 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	frame = _tmp34_;
#line 94 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp35_ = frame;
#line 94 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp36_ = notes_scrolled;
#line 94 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) _tmp36_);
#line 95 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp37_ = frame;
#line 95 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_set ((GtkWidget*) _tmp37_, "expand", TRUE, NULL);
#line 97 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp38_ = (GtkGrid*) gtk_grid_new ();
#line 97 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp38_);
#line 97 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	grid = _tmp38_;
#line 98 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp39_ = grid;
#line 98 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_set ((GtkWidget*) _tmp39_, "margin", 6, NULL);
#line 99 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp40_ = grid;
#line 99 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_grid_set_row_spacing (_tmp40_, 6);
#line 100 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp41_ = grid;
#line 100 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_grid_set_column_spacing (_tmp41_, 6);
#line 102 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp42_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_VERTICAL);
#line 102 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp42_);
#line 102 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	separator = _tmp42_;
#line 104 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp43_ = spice_presenter_window_clock_new ();
#line 104 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp43_);
#line 104 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	timer = _tmp43_;
#line 105 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp44_ = timer;
#line 105 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	spice_presenter_window_clock_start (_tmp44_);
#line 107 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp45_ = self->priv->_slide_manager;
#line 107 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp46_ = spice_presenter_window_slideshow_controller_new (_tmp45_);
#line 107 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_ref_sink (_tmp46_);
#line 107 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	controller = _tmp46_;
#line 109 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp47_ = grid;
#line 109 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp48_ = preview_button;
#line 109 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_grid_attach (_tmp47_, (GtkWidget*) _tmp48_, 0, 0, 1, 2);
#line 110 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp49_ = grid;
#line 110 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp50_ = next_preview_button;
#line 110 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_grid_attach (_tmp49_, (GtkWidget*) _tmp50_, 2, 0, 1, 1);
#line 111 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp51_ = grid;
#line 111 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp52_ = separator;
#line 111 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_grid_attach (_tmp51_, (GtkWidget*) _tmp52_, 1, 0, 1, 3);
#line 112 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp53_ = grid;
#line 112 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp54_ = frame;
#line 112 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_grid_attach (_tmp53_, (GtkWidget*) _tmp54_, 0, 2, 1, 1);
#line 113 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp55_ = grid;
#line 113 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp56_ = timer;
#line 113 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_grid_attach (_tmp55_, (GtkWidget*) _tmp56_, 2, 1, 1, 1);
#line 114 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp57_ = grid;
#line 114 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp58_ = controller;
#line 114 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_grid_attach (_tmp57_, (GtkWidget*) _tmp58_, 2, 2, 1, 1);
#line 116 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp59_ = grid;
#line 116 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp59_);
#line 117 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 119 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp60_ = self->priv->_slide_manager;
#line 119 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp61_ = spice_slide_manager_get_current_slide (_tmp60_);
#line 119 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp62_ = _tmp61_;
#line 119 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	spice_presenter_window_load_previews (self, _tmp62_);
#line 120 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, __spice_presenter_window___lambda92__gsource_func, g_object_ref (self), g_object_unref);
#line 125 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) _spice_presenter_window_on_key_pressed_gtk_widget_key_press_event, self, 0);
#line 127 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp63_ = self->priv->_slide_manager;
#line 127 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_signal_connect_object (_tmp63_, "current-slide-changed", (GCallback) _spice_presenter_window_load_previews_spice_slide_manager_current_slide_changed, self, 0);
#line 129 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp64_ = self->priv->notes;
#line 129 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp65_ = gtk_text_view_get_buffer (_tmp64_);
#line 129 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp66_ = _tmp65_;
#line 129 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_signal_connect_object (_tmp66_, "changed", (GCallback) __spice_presenter_window___lambda93__gtk_text_buffer_changed, self, 0);
#line 135 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp67_ = next_preview_button;
#line 135 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_tmp68_ = self->priv->_slide_manager;
#line 135 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_signal_connect_object (_tmp67_, "clicked", (GCallback) _spice_slide_manager_next_slide_gtk_button_clicked, _tmp68_, 0);
#line 51 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (controller);
#line 51 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (timer);
#line 51 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (separator);
#line 51 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (grid);
#line 51 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (frame);
#line 51 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (notes_scrolled);
#line 51 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (next_preview_button);
#line 51 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (preview_button);
#line 51 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	return obj;
#line 2469 "PresenterView.c"
}

static void
spice_presenter_window_class_init (SpicePresenterWindowClass * klass,
                                   gpointer klass_data)
{
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	spice_presenter_window_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_type_class_adjust_private_offset (klass, &SpicePresenterWindow_private_offset);
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_presenter_window_get_property;
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_presenter_window_set_property;
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	G_OBJECT_CLASS (klass)->constructor = spice_presenter_window_constructor;
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_presenter_window_finalize;
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_PRESENTER_WINDOW_SLIDE_MANAGER_PROPERTY, spice_presenter_window_properties[SPICE_PRESENTER_WINDOW_SLIDE_MANAGER_PROPERTY] = g_param_spec_object ("slide-manager", "slide-manager", "slide-manager", SPICE_TYPE_SLIDE_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_PRESENTER_WINDOW_WINDOW_PROPERTY, spice_presenter_window_properties[SPICE_PRESENTER_WINDOW_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", SPICE_TYPE_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 2492 "PresenterView.c"
}

static void
spice_presenter_window_instance_init (SpicePresenterWindow * self,
                                      gpointer klass)
{
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv = spice_presenter_window_get_instance_private (self);
#line 30 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv->changing = FALSE;
#line 34 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self->priv->_font_size = 12;
#line 2505 "PresenterView.c"
}

static void
spice_presenter_window_finalize (GObject * obj)
{
	SpicePresenterWindow * self;
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_PRESENTER_WINDOW, SpicePresenterWindow);
#line 26 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (self->priv->preview);
#line 27 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (self->priv->next_preview);
#line 28 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (self->priv->notes);
#line 32 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	_g_object_unref0 (self->priv->clock);
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	G_OBJECT_CLASS (spice_presenter_window_parent_class)->finalize (obj);
#line 2524 "PresenterView.c"
}

static GType
spice_presenter_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpicePresenterWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_presenter_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpicePresenterWindow), 0, (GInstanceInitFunc) spice_presenter_window_instance_init, NULL };
	GType spice_presenter_window_type_id;
	spice_presenter_window_type_id = g_type_register_static (gtk_window_get_type (), "SpicePresenterWindow", &g_define_type_info, 0);
	SpicePresenterWindow_private_offset = g_type_add_instance_private (spice_presenter_window_type_id, sizeof (SpicePresenterWindowPrivate));
	return spice_presenter_window_type_id;
}

GType
spice_presenter_window_get_type (void)
{
	static volatile gsize spice_presenter_window_type_id__once = 0;
	if (g_once_init_enter (&spice_presenter_window_type_id__once)) {
		GType spice_presenter_window_type_id;
		spice_presenter_window_type_id = spice_presenter_window_get_type_once ();
		g_once_init_leave (&spice_presenter_window_type_id__once, spice_presenter_window_type_id);
	}
	return spice_presenter_window_type_id__once;
}

static void
_vala_spice_presenter_window_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SpicePresenterWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_PRESENTER_WINDOW, SpicePresenterWindow);
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case SPICE_PRESENTER_WINDOW_SLIDE_MANAGER_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		g_value_set_object (value, spice_presenter_window_get_slide_manager (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case SPICE_PRESENTER_WINDOW_WINDOW_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		g_value_set_object (value, spice_presenter_window_get_window (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		break;
#line 2571 "PresenterView.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		break;
#line 2577 "PresenterView.c"
	}
}

static void
_vala_spice_presenter_window_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SpicePresenterWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_PRESENTER_WINDOW, SpicePresenterWindow);
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case SPICE_PRESENTER_WINDOW_SLIDE_MANAGER_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		spice_presenter_window_set_slide_manager (self, g_value_get_object (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		case SPICE_PRESENTER_WINDOW_WINDOW_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		spice_presenter_window_set_window (self, g_value_get_object (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		break;
#line 2603 "PresenterView.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Widgets/PresenterView.vala"
		break;
#line 2609 "PresenterView.c"
	}
}

