/*
* Copyright(c) 2018 Intel Corporation
* SPDX - License - Identifier: BSD - 2 - Clause - Patent
*/


#ifndef EbModeDecisionConfiguration_h
#define EbModeDecisionConfiguration_h

#include "EbModeDecisionConfigurationProcess.h"
#include "EbSequenceControlSet.h"
#include "EbPictureControlSet.h"
#ifdef __cplusplus
extern "C" {
#endif

/*******************************************
 * EarlyModeDecisionLcu 
 *   predicts candidates (LCU)
 *******************************************/
extern EB_ERRORTYPE EarlyModeDecisionLcu(
	SequenceControlSet_t                   *sequenceControlSetPtr,
	PictureControlSet_t                    *pictureControlSetPtr,
	LargestCodingUnit_t                    *lcuPtr,
	EB_U32                                  lcuIndex,
	ModeDecisionConfigurationContext_t     *contextPtr);


/*******************************************
* DeriveDeltaQPForEachLeafLcu
*   Derive Lcu For Each Leaf (LCU)
*******************************************/
extern EB_ERRORTYPE DeriveDeltaQPForEachLeafLcu(
	SequenceControlSet_t                   *sequenceControlSetPtr,
	PictureControlSet_t                    *pictureControlSetPtr,
	LargestCodingUnit_t                    *lcuPtr,
	EB_U32                                  lcuIndex,
	EB_S32                                  intraMinDistance,
	EB_S32                                  intraMaxDistance,
	EB_S32                                  interMinDistance,
	EB_S32                                  interMaxDistance,
	ModeDecisionConfigurationContext_t     *contextPtr);

extern EB_U8 DeriveContouringClass(
    PictureParentControlSet_t   *parentPcsPtr,
    EB_U16                       lcuIndex,
    EB_U8                        leafIndex);  
/**************************************
* Function Ptrs Definitions
**************************************/
typedef EB_ERRORTYPE(*EB_MDC_FUNC)(
    MdcpLocalCodingUnit_t                   *localCuArray,
    EB_U32                                   cuIndex,
    EB_U32                                   depth,
    EB_BOOL                                 *mdcPrediction64);

#define Pred        0x01
#define Predp1      0x02
#define Predp2      0x04
#define Predp3      0x08
#define Predm1      0x10
#define Predm2      0x20
#define Predm3      0x40
#define ALL64       0x0F
#define ALL32       0x17
#define ALL16       0x33
#define ALL8        0x71
#define AllD        0x80

EB_ALIGN(16) static const EB_U8 NdpRefinementControlNREF[MAX_TEMPORAL_LAYERS/*temporal layer*/][4/*cu Size*/] =
{
                            //   64                         32                              16                  8  
    /* layer-0 */      { Pred + Predp1+Predp2     , Pred + Predp1                  ,Pred +Predp1          ,Pred+Predm1         },  
    /* layer-1 */      { Pred + Predp1+Predp2     , Pred + Predp1                  ,Pred +Predp1          ,Pred+Predm1         },
    /* layer-2 */      { Pred + Predp1+Predp2     , Pred + Predp1                  ,Pred +Predp1          ,Pred+Predm1         },
	/* layer-3 */      { Pred + Predp1            , Pred + Predp1                  , Pred + Predp1        , Pred + Predm1      },
	/* layer-4 */      { Pred + Predp1            , Pred + Predp1                  , Pred + Predp1        , Pred + Predm1      },
	/* layer-5 */      { Pred + Predp1            , Pred + Predp1                  , Pred + Predp1        , Pred + Predm1      },
  }; 



EB_ALIGN(16) static const EB_U8 NdpRefinementControl_FAST[MAX_TEMPORAL_LAYERS/*temporal layer*/][4/*cu Size*/] =
{
                            //   64                         32                              16                  8  
    /* layer-0 */      { Pred + Predp1+Predp2       , Pred + Predp1                  ,Pred +Predp1          ,Pred+Predm1         },  
    /* layer-1 */      { Pred                       , Pred + Predp1                  ,Pred +Predp1          ,Pred+Predm1         },
    /* layer-2 */      { Pred                       , Pred + Predp1                  ,Pred +Predp1          ,Pred+Predm1         }, 
	/* layer-3 */	   { Pred                       , Pred                           , Pred                 , Pred + Predm1      },
	/* layer-4 */	   { Pred                       , Pred                           , Pred                 , Pred + Predm1      },
	/* layer-5 */	   { Pred                       , Pred                           , Pred                 , Pred + Predm1      },
  }; 



EB_ALIGN(16) static const EB_U8 NdpRefinementControl_ISLICE[4/*cu Size*/] =
{
    Predp1, Pred + Predp1 + Predp2, Predm1 + Pred + Predp1, Predm1 + Pred 
};

// Max FullCandidates Settings For Intra Frame
EB_ALIGN(16) static const EB_U8 NdpRefinementControl_ISLICE_Sub4K[4/*cu Size*/] =
{ 
    Predp1+Predp2             ,Pred+Predp1+Predp2         ,Predm1+Pred+Predp1     ,Predm1+Pred 
};


EB_ALIGN(32)  static const EB_U32 mvBitTable[500][500] = {

	{ 73744, 128728, 203592, 203592, 269128, 269128, 269128, 269128, 334664, 334664, 334664, 334664, 334664, 334664, 334664, 334664, 400200, 400200, 400200, 400200, 400200, 400200, 400200, 400200, 400200, 400200, 400200, 400200, 400200, 400200, 400200, 400200, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 465736, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 531272, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 596808, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344, 662344 }, // 0
	{ 130975, 178780, 253644, 253644, 319180, 319180, 319180, 319180, 384716, 384716, 384716, 384716, 384716, 384716, 384716, 384716, 450252, 450252, 450252, 450252, 450252, 450252, 450252, 450252, 450252, 450252, 450252, 450252, 450252, 450252, 450252, 450252, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 515788, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 581324, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 646860, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396, 712396 }, // 1
	{ 202683, 253623, 321933, 321933, 387469, 387469, 387469, 387469, 453005, 453005, 453005, 453005, 453005, 453005, 453005, 453005, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685 }, // 2
	{ 202683, 253623, 321933, 321933, 387469, 387469, 387469, 387469, 453005, 453005, 453005, 453005, 453005, 453005, 453005, 453005, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685 }, // 3
	{ 268219, 319159, 387469, 387469, 453005, 453005, 453005, 453005, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221 }, // 4
	{ 268219, 319159, 387469, 387469, 453005, 453005, 453005, 453005, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221 }, // 5
	{ 268219, 319159, 387469, 387469, 453005, 453005, 453005, 453005, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221 }, // 6
	{ 268219, 319159, 387469, 387469, 453005, 453005, 453005, 453005, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 518541, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221 }, // 7
	{ 333755, 384695, 453005, 453005, 518541, 518541, 518541, 518541, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757 }, // 8
	{ 333755, 384695, 453005, 453005, 518541, 518541, 518541, 518541, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757 }, // 9
	{ 333755, 384695, 453005, 453005, 518541, 518541, 518541, 518541, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757 }, // 10
	{ 333755, 384695, 453005, 453005, 518541, 518541, 518541, 518541, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757 }, // 11
	{ 333755, 384695, 453005, 453005, 518541, 518541, 518541, 518541, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757 }, // 12
	{ 333755, 384695, 453005, 453005, 518541, 518541, 518541, 518541, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757 }, // 13
	{ 333755, 384695, 453005, 453005, 518541, 518541, 518541, 518541, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757 }, // 14
	{ 333755, 384695, 453005, 453005, 518541, 518541, 518541, 518541, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757 }, // 15
	{ 399291, 450231, 518541, 518541, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293 }, // 16
	{ 399291, 450231, 518541, 518541, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293 }, // 17
	{ 399291, 450231, 518541, 518541, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293 }, // 18
	{ 399291, 450231, 518541, 518541, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293 }, // 19
	{ 399291, 450231, 518541, 518541, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293 }, // 20
	{ 399291, 450231, 518541, 518541, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293 }, // 21
	{ 399291, 450231, 518541, 518541, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293 }, // 22
	{ 399291, 450231, 518541, 518541, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293 }, // 23
	{ 399291, 450231, 518541, 518541, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293 }, // 24
	{ 399291, 450231, 518541, 518541, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293 }, // 25
	{ 399291, 450231, 518541, 518541, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293 }, // 26
	{ 399291, 450231, 518541, 518541, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293 }, // 27
	{ 399291, 450231, 518541, 518541, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293 }, // 28
	{ 399291, 450231, 518541, 518541, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293 }, // 29
	{ 399291, 450231, 518541, 518541, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293 }, // 30
	{ 399291, 450231, 518541, 518541, 584077, 584077, 584077, 584077, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293 }, // 31
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 32
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 33
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 34
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 35
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 36
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 37
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 38
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 39
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 40
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 41
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 42
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 43
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 44
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 45
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 46
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 47
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 48
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 49
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 50
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 51
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 52
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 53
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 54
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 55
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 56
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 57
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 58
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 59
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 60
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 61
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 62
	{ 464827, 515767, 584077, 584077, 649613, 649613, 649613, 649613, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829 }, // 63
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 64
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 65
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 66
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 67
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 68
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 69
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 70
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 71
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 72
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 73
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 74
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 75
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 76
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 77
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 78
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 79
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 80
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 81
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 82
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 83
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 84
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 85
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 86
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 87
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 88
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 89
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 90
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 91
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 92
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 93
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 94
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 95
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 96
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 97
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 98
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 99
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 100
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 101
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 102
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 103
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 104
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 105
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 106
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 107
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 108
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 109
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 110
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 111
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 112
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 113
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 114
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 115
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 116
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 117
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 118
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 119
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 120
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 121
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 122
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 123
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 124
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 125
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 126
	{ 530363, 581303, 649613, 649613, 715149, 715149, 715149, 715149, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365 }, // 127
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 128
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 129
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 130
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 131
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 132
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 133
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 134
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 135
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 136
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 137
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 138
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 139
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 140
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 141
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 142
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 143
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 144
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 145
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 146
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 147
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 148
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 149
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 150
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 151
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 152
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 153
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 154
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 155
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 156
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 157
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 158
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 159
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 160
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 161
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 162
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 163
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 164
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 165
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 166
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 167
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 168
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 169
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 170
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 171
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 172
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 173
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 174
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 175
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 176
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 177
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 178
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 179
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 180
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 181
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 182
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 183
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 184
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 185
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 186
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 187
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 188
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 189
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 190
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 191
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 192
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 193
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 194
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 195
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 196
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 197
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 198
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 199
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 200
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 201
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 202
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 203
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 204
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 205
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 206
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 207
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 208
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 209
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 210
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 211
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 212
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 213
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 214
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 215
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 216
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 217
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 218
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 219
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 220
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 221
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 222
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 223
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 224
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 225
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 226
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 227
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1108365, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901, 1173901 }, // 228
	{ 595899, 646839, 715149, 715149, 780685, 780685, 780685, 780685, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 846221, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 911757, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 977293, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 1042829, 10428