// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// This file is autogenerated. Do not edit it!

use std::fmt;

/// List of values for presentation attributes.
#[derive(Copy,Clone,Eq,PartialEq,Ord,PartialOrd,Hash)]
#[allow(missing_docs)]
pub enum ValueId {
    N100,
    N200,
    N300,
    N400,
    N500,
    N600,
    N700,
    N800,
    N900,
    Accumulate,
    AfterEdge,
    All,
    Alphabetic,
    Auto,
    Baseline,
    BeforeEdge,
    Bevel,
    BidiOverride,
    Blink,
    Block,
    Bold,
    Bolder,
    Butt,
    Central,
    Collapse,
    Compact,
    Condensed,
    CrispEdges,
    Crosshair,
    CurrentColor,
    Default,
    EResize,
    Embed,
    End,
    Evenodd,
    Expanded,
    ExtraCondensed,
    ExtraExpanded,
    Fill,
    GeometricPrecision,
    Hanging,
    Help,
    Hidden,
    Ideographic,
    Inherit,
    Inline,
    InlineTable,
    Italic,
    Large,
    Larger,
    Lighter,
    LineThrough,
    LinearRGB,
    ListItem,
    Lr,
    LrTb,
    Ltr,
    Marker,
    Mathematical,
    Medium,
    Middle,
    Miter,
    Move,
    NResize,
    Narrower,
    NeResize,
    NoChange,
    None,
    Nonzero,
    Normal,
    NwResize,
    ObjectBoundingBox,
    Oblique,
    OptimizeLegibility,
    OptimizeQuality,
    OptimizeSpeed,
    Overline,
    Pad,
    Painted,
    Pointer,
    Reflect,
    Repeat,
    ResetSize,
    Rl,
    RlTb,
    Round,
    Rtl,
    RunIn,
    SResize,
    Scroll,
    SeResize,
    SemiCondensed,
    SemiExpanded,
    Small,
    SmallCaps,
    Smaller,
    Square,
    SRGB,
    Start,
    Stroke,
    Sub,
    Super,
    SwResize,
    Table,
    TableCaption,
    TableCell,
    TableColumn,
    TableColumnGroup,
    TableFooterGroup,
    TableHeaderGroup,
    TableRow,
    TableRowGroup,
    Tb,
    TbRl,
    Text,
    TextAfterEdge,
    TextBeforeEdge,
    UltraCondensed,
    UltraExpanded,
    Underline,
    UseScript,
    UserSpaceOnUse,
    Visible,
    VisibleFill,
    VisiblePainted,
    VisibleStroke,
    WResize,
    Wait,
    Wider,
    XLarge,
    XSmall,
    XxLarge,
    XxSmall
}

static VALUES: ::phf::Map<&'static str, ValueId> = ::phf::Map {
    key: 9603444721912725599,
    disps: ::phf::Slice::Static(&[
        (2, 1),
        (0, 14),
        (0, 10),
        (0, 59),
        (0, 25),
        (0, 43),
        (1, 87),
        (2, 12),
        (0, 0),
        (0, 79),
        (1, 35),
        (1, 32),
        (2, 3),
        (3, 83),
        (0, 45),
        (1, 0),
        (0, 0),
        (8, 52),
        (3, 33),
        (6, 2),
        (1, 116),
        (0, 85),
        (1, 97),
        (1, 3),
        (0, 7),
        (0, 61),
        (11, 82),
    ]),
    entries: ::phf::Slice::Static(&[
        ("200", ValueId::N200),
        ("bolder", ValueId::Bolder),
        ("text-before-edge", ValueId::TextBeforeEdge),
        ("table-column-group", ValueId::TableColumnGroup),
        ("rl", ValueId::Rl),
        ("scroll", ValueId::Scroll),
        ("reset-size", ValueId::ResetSize),
        ("800", ValueId::N800),
        ("embed", ValueId::Embed),
        ("lighter", ValueId::Lighter),
        ("stroke", ValueId::Stroke),
        ("hanging", ValueId::Hanging),
        ("table", ValueId::Table),
        ("compact", ValueId::Compact),
        ("square", ValueId::Square),
        ("rl-tb", ValueId::RlTb),
        ("table-row", ValueId::TableRow),
        ("bevel", ValueId::Bevel),
        ("700", ValueId::N700),
        ("overline", ValueId::Overline),
        ("currentColor", ValueId::CurrentColor),
        ("w-resize", ValueId::WResize),
        ("table-caption", ValueId::TableCaption),
        ("evenodd", ValueId::Evenodd),
        ("semi-expanded", ValueId::SemiExpanded),
        ("large", ValueId::Large),
        ("userSpaceOnUse", ValueId::UserSpaceOnUse),
        ("collapse", ValueId::Collapse),
        ("extra-condensed", ValueId::ExtraCondensed),
        ("nw-resize", ValueId::NwResize),
        ("hidden", ValueId::Hidden),
        ("objectBoundingBox", ValueId::ObjectBoundingBox),
        ("help", ValueId::Help),
        ("x-small", ValueId::XSmall),
        ("crispEdges", ValueId::CrispEdges),
        ("auto", ValueId::Auto),
        ("painted", ValueId::Painted),
        ("italic", ValueId::Italic),
        ("start", ValueId::Start),
        ("expanded", ValueId::Expanded),
        ("condensed", ValueId::Condensed),
        ("tb", ValueId::Tb),
        ("inherit", ValueId::Inherit),
        ("use-script", ValueId::UseScript),
        ("wait", ValueId::Wait),
        ("alphabetic", ValueId::Alphabetic),
        ("ideographic", ValueId::Ideographic),
        ("crosshair", ValueId::Crosshair),
        ("ultra-condensed", ValueId::UltraCondensed),
        ("marker", ValueId::Marker),
        ("optimizeQuality", ValueId::OptimizeQuality),
        ("after-edge", ValueId::AfterEdge),
        ("visibleStroke", ValueId::VisibleStroke),
        ("extra-expanded", ValueId::ExtraExpanded),
        ("inline", ValueId::Inline),
        ("miter", ValueId::Miter),
        ("accumulate", ValueId::Accumulate),
        ("text", ValueId::Text),
        ("sw-resize", ValueId::SwResize),
        ("line-through", ValueId::LineThrough),
        ("round", ValueId::Round),
        ("e-resize", ValueId::EResize),
        ("xx-large", ValueId::XxLarge),
        ("end", ValueId::End),
        ("tb-rl", ValueId::TbRl),
        ("super", ValueId::Super),
        ("butt", ValueId::Butt),
        ("ne-resize", ValueId::NeResize),
        ("visible", ValueId::Visible),
        ("geometricPrecision", ValueId::GeometricPrecision),
        ("100", ValueId::N100),
        ("400", ValueId::N400),
        ("xx-small", ValueId::XxSmall),
        ("central", ValueId::Central),
        ("text-after-edge", ValueId::TextAfterEdge),
        ("visibleFill", ValueId::VisibleFill),
        ("bold", ValueId::Bold),
        ("optimizeSpeed", ValueId::OptimizeSpeed),
        ("n-resize", ValueId::NResize),
        ("bidi-override", ValueId::BidiOverride),
        ("run-in", ValueId::RunIn),
        ("list-item", ValueId::ListItem),
        ("none", ValueId::None),
        ("repeat", ValueId::Repeat),
        ("table-column", ValueId::TableColumn),
        ("small-caps", ValueId::SmallCaps),
        ("visiblePainted", ValueId::VisiblePainted),
        ("sRGB", ValueId::SRGB),
        ("nonzero", ValueId::Nonzero),
        ("no-change", ValueId::NoChange),
        ("table-row-group", ValueId::TableRowGroup),
        ("larger", ValueId::Larger),
        ("oblique", ValueId::Oblique),
        ("reflect", ValueId::Reflect),
        ("se-resize", ValueId::SeResize),
        ("s-resize", ValueId::SResize),
        ("table-cell", ValueId::TableCell),
        ("sub", ValueId::Sub),
        ("lr", ValueId::Lr),
        ("block", ValueId::Block),
        ("table-footer-group", ValueId::TableFooterGroup),
        ("small", ValueId::Small),
        ("middle", ValueId::Middle),
        ("optimizeLegibility", ValueId::OptimizeLegibility),
        ("x-large", ValueId::XLarge),
        ("linearRGB", ValueId::LinearRGB),
        ("medium", ValueId::Medium),
        ("underline", ValueId::Underline),
        ("inline-table", ValueId::InlineTable),
        ("500", ValueId::N500),
        ("900", ValueId::N900),
        ("move", ValueId::Move),
        ("lr-tb", ValueId::LrTb),
        ("smaller", ValueId::Smaller),
        ("narrower", ValueId::Narrower),
        ("ultra-expanded", ValueId::UltraExpanded),
        ("all", ValueId::All),
        ("table-header-group", ValueId::TableHeaderGroup),
        ("before-edge", ValueId::BeforeEdge),
        ("pointer", ValueId::Pointer),
        ("default", ValueId::Default),
        ("normal", ValueId::Normal),
        ("fill", ValueId::Fill),
        ("ltr", ValueId::Ltr),
        ("blink", ValueId::Blink),
        ("300", ValueId::N300),
        ("600", ValueId::N600),
        ("mathematical", ValueId::Mathematical),
        ("wider", ValueId::Wider),
        ("baseline", ValueId::Baseline),
        ("rtl", ValueId::Rtl),
        ("pad", ValueId::Pad),
        ("semi-condensed", ValueId::SemiCondensed),
    ]),
};

impl ValueId {
    /// Converts name into id.
    pub fn from_name(text: &str) -> Option<ValueId> {
        VALUES.get(text).cloned()
    }

    /// Converts id into name.
    pub fn name(&self) -> &str {
        match *self {
            ValueId::N100 => "100",
            ValueId::N200 => "200",
            ValueId::N300 => "300",
            ValueId::N400 => "400",
            ValueId::N500 => "500",
            ValueId::N600 => "600",
            ValueId::N700 => "700",
            ValueId::N800 => "800",
            ValueId::N900 => "900",
            ValueId::Accumulate => "accumulate",
            ValueId::AfterEdge => "after-edge",
            ValueId::All => "all",
            ValueId::Alphabetic => "alphabetic",
            ValueId::Auto => "auto",
            ValueId::Baseline => "baseline",
            ValueId::BeforeEdge => "before-edge",
            ValueId::Bevel => "bevel",
            ValueId::BidiOverride => "bidi-override",
            ValueId::Blink => "blink",
            ValueId::Block => "block",
            ValueId::Bold => "bold",
            ValueId::Bolder => "bolder",
            ValueId::Butt => "butt",
            ValueId::Central => "central",
            ValueId::Collapse => "collapse",
            ValueId::Compact => "compact",
            ValueId::Condensed => "condensed",
            ValueId::CrispEdges => "crispEdges",
            ValueId::Crosshair => "crosshair",
            ValueId::CurrentColor => "currentColor",
            ValueId::Default => "default",
            ValueId::EResize => "e-resize",
            ValueId::Embed => "embed",
            ValueId::End => "end",
            ValueId::Evenodd => "evenodd",
            ValueId::Expanded => "expanded",
            ValueId::ExtraCondensed => "extra-condensed",
            ValueId::ExtraExpanded => "extra-expanded",
            ValueId::Fill => "fill",
            ValueId::GeometricPrecision => "geometricPrecision",
            ValueId::Hanging => "hanging",
            ValueId::Help => "help",
            ValueId::Hidden => "hidden",
            ValueId::Ideographic => "ideographic",
            ValueId::Inherit => "inherit",
            ValueId::Inline => "inline",
            ValueId::InlineTable => "inline-table",
            ValueId::Italic => "italic",
            ValueId::Large => "large",
            ValueId::Larger => "larger",
            ValueId::Lighter => "lighter",
            ValueId::LineThrough => "line-through",
            ValueId::LinearRGB => "linearRGB",
            ValueId::ListItem => "list-item",
            ValueId::Lr => "lr",
            ValueId::LrTb => "lr-tb",
            ValueId::Ltr => "ltr",
            ValueId::Marker => "marker",
            ValueId::Mathematical => "mathematical",
            ValueId::Medium => "medium",
            ValueId::Middle => "middle",
            ValueId::Miter => "miter",
            ValueId::Move => "move",
            ValueId::NResize => "n-resize",
            ValueId::Narrower => "narrower",
            ValueId::NeResize => "ne-resize",
            ValueId::NoChange => "no-change",
            ValueId::None => "none",
            ValueId::Nonzero => "nonzero",
            ValueId::Normal => "normal",
            ValueId::NwResize => "nw-resize",
            ValueId::ObjectBoundingBox => "objectBoundingBox",
            ValueId::Oblique => "oblique",
            ValueId::OptimizeLegibility => "optimizeLegibility",
            ValueId::OptimizeQuality => "optimizeQuality",
            ValueId::OptimizeSpeed => "optimizeSpeed",
            ValueId::Overline => "overline",
            ValueId::Pad => "pad",
            ValueId::Painted => "painted",
            ValueId::Pointer => "pointer",
            ValueId::Reflect => "reflect",
            ValueId::Repeat => "repeat",
            ValueId::ResetSize => "reset-size",
            ValueId::Rl => "rl",
            ValueId::RlTb => "rl-tb",
            ValueId::Round => "round",
            ValueId::Rtl => "rtl",
            ValueId::RunIn => "run-in",
            ValueId::SResize => "s-resize",
            ValueId::Scroll => "scroll",
            ValueId::SeResize => "se-resize",
            ValueId::SemiCondensed => "semi-condensed",
            ValueId::SemiExpanded => "semi-expanded",
            ValueId::Small => "small",
            ValueId::SmallCaps => "small-caps",
            ValueId::Smaller => "smaller",
            ValueId::Square => "square",
            ValueId::SRGB => "sRGB",
            ValueId::Start => "start",
            ValueId::Stroke => "stroke",
            ValueId::Sub => "sub",
            ValueId::Super => "super",
            ValueId::SwResize => "sw-resize",
            ValueId::Table => "table",
            ValueId::TableCaption => "table-caption",
            ValueId::TableCell => "table-cell",
            ValueId::TableColumn => "table-column",
            ValueId::TableColumnGroup => "table-column-group",
            ValueId::TableFooterGroup => "table-footer-group",
            ValueId::TableHeaderGroup => "table-header-group",
            ValueId::TableRow => "table-row",
            ValueId::TableRowGroup => "table-row-group",
            ValueId::Tb => "tb",
            ValueId::TbRl => "tb-rl",
            ValueId::Text => "text",
            ValueId::TextAfterEdge => "text-after-edge",
            ValueId::TextBeforeEdge => "text-before-edge",
            ValueId::UltraCondensed => "ultra-condensed",
            ValueId::UltraExpanded => "ultra-expanded",
            ValueId::Underline => "underline",
            ValueId::UseScript => "use-script",
            ValueId::UserSpaceOnUse => "userSpaceOnUse",
            ValueId::Visible => "visible",
            ValueId::VisibleFill => "visibleFill",
            ValueId::VisiblePainted => "visiblePainted",
            ValueId::VisibleStroke => "visibleStroke",
            ValueId::WResize => "w-resize",
            ValueId::Wait => "wait",
            ValueId::Wider => "wider",
            ValueId::XLarge => "x-large",
            ValueId::XSmall => "x-small",
            ValueId::XxLarge => "xx-large",
            ValueId::XxSmall => "xx-small"
        }
    }
}

impl fmt::Debug for ValueId {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{}", self.name())
    }
}

impl fmt::Display for ValueId {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{}", self.name())
    }
}
