/* DateTime.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DateTime.vala, do not modify */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TUBA_UTILS_TYPE_DATE_TIME (tuba_utils_date_time_get_type ())
#define TUBA_UTILS_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_UTILS_TYPE_DATE_TIME, TubaUtilsDateTime))
#define TUBA_UTILS_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_UTILS_TYPE_DATE_TIME, TubaUtilsDateTimeClass))
#define TUBA_UTILS_IS_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_UTILS_TYPE_DATE_TIME))
#define TUBA_UTILS_IS_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_UTILS_TYPE_DATE_TIME))
#define TUBA_UTILS_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_UTILS_TYPE_DATE_TIME, TubaUtilsDateTimeClass))

typedef struct _TubaUtilsDateTime TubaUtilsDateTime;
typedef struct _TubaUtilsDateTimeClass TubaUtilsDateTimeClass;
typedef struct _TubaUtilsDateTimePrivate TubaUtilsDateTimePrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
typedef struct _TubaUtilsParamSpecDateTime TubaUtilsParamSpecDateTime;

struct _TubaUtilsDateTime {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TubaUtilsDateTimePrivate * priv;
};

struct _TubaUtilsDateTimeClass {
	GTypeClass parent_class;
	void (*finalize) (TubaUtilsDateTime *self);
};

struct _TubaUtilsParamSpecDateTime {
	GParamSpec parent_instance;
};

static gpointer tuba_utils_date_time_parent_class = NULL;

VALA_EXTERN gpointer tuba_utils_date_time_ref (gpointer instance);
VALA_EXTERN void tuba_utils_date_time_unref (gpointer instance);
VALA_EXTERN GParamSpec* tuba_utils_param_spec_date_time (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void tuba_utils_value_set_date_time (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void tuba_utils_value_take_date_time (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer tuba_utils_value_get_date_time (const GValue* value);
VALA_EXTERN GType tuba_utils_date_time_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaUtilsDateTime, tuba_utils_date_time_unref)
VALA_EXTERN gchar* tuba_utils_date_time_humanize_left (const gchar* iso8601);
VALA_EXTERN gchar* tuba_utils_date_time_humanize (const gchar* iso8601);
VALA_EXTERN gchar* tuba_utils_date_time_humanize_ago (const gchar* iso8601);
VALA_EXTERN gboolean tuba_utils_date_time_is_same_day (GDateTime* d1,
                                           GDateTime* d2);
VALA_EXTERN gchar* tuba_utils_date_time_humanize_aria (const gchar* iso8601);
VALA_EXTERN gchar* tuba_utils_date_time_format_full (const gchar* iso8601);
VALA_EXTERN gchar* tuba_utils_date_time_humanize_old (const gchar* iso8601);
VALA_EXTERN gboolean tuba_utils_date_time_is_3_months_old (const gchar* iso8601);
VALA_EXTERN TubaUtilsDateTime* tuba_utils_date_time_new (void);
VALA_EXTERN TubaUtilsDateTime* tuba_utils_date_time_construct (GType object_type);
static void tuba_utils_date_time_finalize (TubaUtilsDateTime * obj);
static GType tuba_utils_date_time_get_type_once (void);

gchar*
tuba_utils_date_time_humanize_left (const gchar* iso8601)
{
	GDateTime* date = NULL;
	GDateTime* _tmp1_;
	GDateTime* now = NULL;
	GDateTime* _tmp2_;
	GTimeSpan delta = 0LL;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	gchar* result;
	if (iso8601 == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_date_time_new_from_iso8601 (iso8601, NULL);
	date = _tmp1_;
	_tmp2_ = g_date_time_new_now_local ();
	now = _tmp2_;
	_tmp3_ = date;
	_tmp4_ = now;
	delta = g_date_time_difference (_tmp3_, _tmp4_);
	if (delta < ((GTimeSpan) 0)) {
		gchar* _tmp5_;
		_tmp5_ = tuba_utils_date_time_humanize (iso8601);
		result = _tmp5_;
		_g_date_time_unref0 (now);
		_g_date_time_unref0 (date);
		return result;
	} else {
		if (delta <= G_TIME_SPAN_MINUTE) {
			gchar* _tmp6_;
			_tmp6_ = g_strdup (_ ("expires soon"));
			result = _tmp6_;
			_g_date_time_unref0 (now);
			_g_date_time_unref0 (date);
			return result;
		} else {
			if (delta < G_TIME_SPAN_HOUR) {
				GTimeSpan minutes = 0LL;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				minutes = delta / G_TIME_SPAN_MINUTE;
				_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) minutes);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strdup_printf (_ ("%sm left"), _tmp8_);
				_tmp10_ = _tmp9_;
				_g_free0 (_tmp8_);
				result = _tmp10_;
				_g_date_time_unref0 (now);
				_g_date_time_unref0 (date);
				return result;
			} else {
				if (delta <= G_TIME_SPAN_DAY) {
					GTimeSpan hours = 0LL;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					hours = delta / G_TIME_SPAN_HOUR;
					_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) hours);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_strdup_printf (_ ("%sh left"), _tmp12_);
					_tmp14_ = _tmp13_;
					_g_free0 (_tmp12_);
					result = _tmp14_;
					_g_date_time_unref0 (now);
					_g_date_time_unref0 (date);
					return result;
				} else {
					if (delta <= (G_TIME_SPAN_DAY * 60)) {
						GTimeSpan days = 0LL;
						gchar* _tmp15_;
						gchar* _tmp16_;
						gchar* _tmp17_;
						gchar* _tmp18_;
						days = delta / G_TIME_SPAN_DAY;
						_tmp15_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) days);
						_tmp16_ = _tmp15_;
						_tmp17_ = g_strdup_printf (_ ("%sd left"), _tmp16_);
						_tmp18_ = _tmp17_;
						_g_free0 (_tmp16_);
						result = _tmp18_;
						_g_date_time_unref0 (now);
						_g_date_time_unref0 (date);
						return result;
					} else {
						GDateTime* _tmp19_;
						GTimeZone* _tmp20_;
						GTimeZone* _tmp21_;
						GDateTime* _tmp22_;
						GDateTime* _tmp23_;
						gchar* _tmp24_;
						gchar* _tmp25_;
						_tmp19_ = date;
						_tmp20_ = g_time_zone_new_local ();
						_tmp21_ = _tmp20_;
						_tmp22_ = g_date_time_to_timezone (_tmp19_, _tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = g_date_time_format (_tmp23_, _ ("expires on %b %-e, %Y"));
						_tmp25_ = _tmp24_;
						_g_date_time_unref0 (_tmp23_);
						_g_time_zone_unref0 (_tmp21_);
						result = _tmp25_;
						_g_date_time_unref0 (now);
						_g_date_time_unref0 (date);
						return result;
					}
				}
			}
		}
	}
}

gchar*
tuba_utils_date_time_humanize_ago (const gchar* iso8601)
{
	GDateTime* date = NULL;
	GDateTime* _tmp0_;
	GDateTime* now = NULL;
	GDateTime* _tmp1_;
	GTimeSpan delta = 0LL;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gchar* result;
	g_return_val_if_fail (iso8601 != NULL, NULL);
	_tmp0_ = g_date_time_new_from_iso8601 (iso8601, NULL);
	date = _tmp0_;
	_tmp1_ = g_date_time_new_now_local ();
	now = _tmp1_;
	_tmp2_ = now;
	_tmp3_ = date;
	delta = g_date_time_difference (_tmp2_, _tmp3_);
	if (delta < ((GTimeSpan) 0)) {
		GDateTime* _tmp4_;
		GTimeZone* _tmp5_;
		GTimeZone* _tmp6_;
		GDateTime* _tmp7_;
		GDateTime* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = date;
		_tmp5_ = g_time_zone_new_local ();
		_tmp6_ = _tmp5_;
		_tmp7_ = g_date_time_to_timezone (_tmp4_, _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_date_time_format (_tmp8_, _ ("expires on %b %-e, %Y %H:%M"));
		_tmp10_ = _tmp9_;
		_g_date_time_unref0 (_tmp8_);
		_g_time_zone_unref0 (_tmp6_);
		result = _tmp10_;
		_g_date_time_unref0 (now);
		_g_date_time_unref0 (date);
		return result;
	} else {
		if (delta <= G_TIME_SPAN_MINUTE) {
			gchar* _tmp11_;
			_tmp11_ = g_strdup (_ ("expired on just now"));
			result = _tmp11_;
			_g_date_time_unref0 (now);
			_g_date_time_unref0 (date);
			return result;
		} else {
			if (delta < G_TIME_SPAN_HOUR) {
				GTimeSpan minutes = 0LL;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				minutes = delta / G_TIME_SPAN_MINUTE;
				_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) minutes);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strdup_printf (_ ("expired %sm ago"), _tmp13_);
				_tmp15_ = _tmp14_;
				_g_free0 (_tmp13_);
				result = _tmp15_;
				_g_date_time_unref0 (now);
				_g_date_time_unref0 (date);
				return result;
			} else {
				if (delta <= G_TIME_SPAN_DAY) {
					GTimeSpan hours = 0LL;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					hours = delta / G_TIME_SPAN_HOUR;
					_tmp16_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) hours);
					_tmp17_ = _tmp16_;
					_tmp18_ = g_strdup_printf (_ ("expired %sh ago"), _tmp17_);
					_tmp19_ = _tmp18_;
					_g_free0 (_tmp17_);
					result = _tmp19_;
					_g_date_time_unref0 (now);
					_g_date_time_unref0 (date);
					return result;
				} else {
					GDateTime* _tmp20_;
					GDateTime* _tmp21_;
					GDateTime* _tmp22_;
					GDateTime* _tmp23_;
					gboolean _tmp24_;
					_tmp20_ = now;
					_tmp21_ = date;
					_tmp22_ = g_date_time_add_days (_tmp21_, 1);
					_tmp23_ = _tmp22_;
					_tmp24_ = tuba_utils_date_time_is_same_day (_tmp20_, _tmp23_);
					_g_date_time_unref0 (_tmp23_);
					if (_tmp24_) {
						gchar* _tmp25_;
						_tmp25_ = g_strdup (_ ("expired yesterday"));
						result = _tmp25_;
						_g_date_time_unref0 (now);
						_g_date_time_unref0 (date);
						return result;
					} else {
						GDateTime* _tmp26_;
						GDateTime* _tmp27_;
						_tmp26_ = date;
						_tmp27_ = now;
						if (g_date_time_get_year (_tmp26_) == g_date_time_get_year (_tmp27_)) {
							GDateTime* _tmp28_;
							GTimeZone* _tmp29_;
							GTimeZone* _tmp30_;
							GDateTime* _tmp31_;
							GDateTime* _tmp32_;
							gchar* _tmp33_;
							gchar* _tmp34_;
							_tmp28_ = date;
							_tmp29_ = g_time_zone_new_local ();
							_tmp30_ = _tmp29_;
							_tmp31_ = g_date_time_to_timezone (_tmp28_, _tmp30_);
							_tmp32_ = _tmp31_;
							_tmp33_ = g_date_time_format (_tmp32_, _ ("expired on %b %-e"));
							_tmp34_ = _tmp33_;
							_g_date_time_unref0 (_tmp32_);
							_g_time_zone_unref0 (_tmp30_);
							result = _tmp34_;
							_g_date_time_unref0 (now);
							_g_date_time_unref0 (date);
							return result;
						} else {
							GDateTime* _tmp35_;
							GTimeZone* _tmp36_;
							GTimeZone* _tmp37_;
							GDateTime* _tmp38_;
							GDateTime* _tmp39_;
							gchar* _tmp40_;
							gchar* _tmp41_;
							_tmp35_ = date;
							_tmp36_ = g_time_zone_new_local ();
							_tmp37_ = _tmp36_;
							_tmp38_ = g_date_time_to_timezone (_tmp35_, _tmp37_);
							_tmp39_ = _tmp38_;
							_tmp40_ = g_date_time_format (_tmp39_, _ ("expired on %b %-e, %Y"));
							_tmp41_ = _tmp40_;
							_g_date_time_unref0 (_tmp39_);
							_g_time_zone_unref0 (_tmp37_);
							result = _tmp41_;
							_g_date_time_unref0 (now);
							_g_date_time_unref0 (date);
							return result;
						}
					}
				}
			}
		}
	}
}

gchar*
tuba_utils_date_time_humanize (const gchar* iso8601)
{
	GDateTime* date = NULL;
	GDateTime* _tmp0_;
	GDateTime* now = NULL;
	GDateTime* _tmp1_;
	GTimeSpan delta = 0LL;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gchar* result;
	g_return_val_if_fail (iso8601 != NULL, NULL);
	_tmp0_ = g_date_time_new_from_iso8601 (iso8601, NULL);
	date = _tmp0_;
	_tmp1_ = g_date_time_new_now_local ();
	now = _tmp1_;
	_tmp2_ = now;
	_tmp3_ = date;
	delta = g_date_time_difference (_tmp2_, _tmp3_);
	if (delta < ((GTimeSpan) 0)) {
		GDateTime* _tmp4_;
		GTimeZone* _tmp5_;
		GTimeZone* _tmp6_;
		GDateTime* _tmp7_;
		GDateTime* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = date;
		_tmp5_ = g_time_zone_new_local ();
		_tmp6_ = _tmp5_;
		_tmp7_ = g_date_time_to_timezone (_tmp4_, _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_date_time_format (_tmp8_, _ ("%b %-e, %Y %H:%M"));
		_tmp10_ = _tmp9_;
		_g_date_time_unref0 (_tmp8_);
		_g_time_zone_unref0 (_tmp6_);
		result = _tmp10_;
		_g_date_time_unref0 (now);
		_g_date_time_unref0 (date);
		return result;
	} else {
		if (delta <= G_TIME_SPAN_MINUTE) {
			gchar* _tmp11_;
			_tmp11_ = g_strdup (_ ("Just now"));
			result = _tmp11_;
			_g_date_time_unref0 (now);
			_g_date_time_unref0 (date);
			return result;
		} else {
			if (delta < G_TIME_SPAN_HOUR) {
				GTimeSpan minutes = 0LL;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				minutes = delta / G_TIME_SPAN_MINUTE;
				_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) minutes);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strdup_printf (_ ("%sm"), _tmp13_);
				_tmp15_ = _tmp14_;
				_g_free0 (_tmp13_);
				result = _tmp15_;
				_g_date_time_unref0 (now);
				_g_date_time_unref0 (date);
				return result;
			} else {
				if (delta <= G_TIME_SPAN_DAY) {
					GTimeSpan hours = 0LL;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					hours = delta / G_TIME_SPAN_HOUR;
					_tmp16_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) hours);
					_tmp17_ = _tmp16_;
					_tmp18_ = g_strdup_printf (_ ("%sh"), _tmp17_);
					_tmp19_ = _tmp18_;
					_g_free0 (_tmp17_);
					result = _tmp19_;
					_g_date_time_unref0 (now);
					_g_date_time_unref0 (date);
					return result;
				} else {
					GDateTime* _tmp20_;
					GDateTime* _tmp21_;
					GDateTime* _tmp22_;
					GDateTime* _tmp23_;
					gboolean _tmp24_;
					_tmp20_ = now;
					_tmp21_ = date;
					_tmp22_ = g_date_time_add_days (_tmp21_, 1);
					_tmp23_ = _tmp22_;
					_tmp24_ = tuba_utils_date_time_is_same_day (_tmp20_, _tmp23_);
					_g_date_time_unref0 (_tmp23_);
					if (_tmp24_) {
						gchar* _tmp25_;
						_tmp25_ = g_strdup (_ ("Yesterday"));
						result = _tmp25_;
						_g_date_time_unref0 (now);
						_g_date_time_unref0 (date);
						return result;
					} else {
						GDateTime* _tmp26_;
						GDateTime* _tmp27_;
						_tmp26_ = date;
						_tmp27_ = now;
						if (g_date_time_get_year (_tmp26_) == g_date_time_get_year (_tmp27_)) {
							GDateTime* _tmp28_;
							GTimeZone* _tmp29_;
							GTimeZone* _tmp30_;
							GDateTime* _tmp31_;
							GDateTime* _tmp32_;
							gchar* _tmp33_;
							gchar* _tmp34_;
							_tmp28_ = date;
							_tmp29_ = g_time_zone_new_local ();
							_tmp30_ = _tmp29_;
							_tmp31_ = g_date_time_to_timezone (_tmp28_, _tmp30_);
							_tmp32_ = _tmp31_;
							_tmp33_ = g_date_time_format (_tmp32_, _ ("%b %-e"));
							_tmp34_ = _tmp33_;
							_g_date_time_unref0 (_tmp32_);
							_g_time_zone_unref0 (_tmp30_);
							result = _tmp34_;
							_g_date_time_unref0 (now);
							_g_date_time_unref0 (date);
							return result;
						} else {
							GDateTime* _tmp35_;
							GTimeZone* _tmp36_;
							GTimeZone* _tmp37_;
							GDateTime* _tmp38_;
							GDateTime* _tmp39_;
							gchar* _tmp40_;
							gchar* _tmp41_;
							_tmp35_ = date;
							_tmp36_ = g_time_zone_new_local ();
							_tmp37_ = _tmp36_;
							_tmp38_ = g_date_time_to_timezone (_tmp35_, _tmp37_);
							_tmp39_ = _tmp38_;
							_tmp40_ = g_date_time_format (_tmp39_, _ ("%b %-e, %Y"));
							_tmp41_ = _tmp40_;
							_g_date_time_unref0 (_tmp39_);
							_g_time_zone_unref0 (_tmp37_);
							result = _tmp41_;
							_g_date_time_unref0 (now);
							_g_date_time_unref0 (date);
							return result;
						}
					}
				}
			}
		}
	}
}

gchar*
tuba_utils_date_time_humanize_aria (const gchar* iso8601)
{
	GDateTime* date = NULL;
	GDateTime* _tmp0_;
	GDateTime* now = NULL;
	GDateTime* _tmp1_;
	GTimeSpan delta = 0LL;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gchar* result;
	g_return_val_if_fail (iso8601 != NULL, NULL);
	_tmp0_ = g_date_time_new_from_iso8601 (iso8601, NULL);
	date = _tmp0_;
	_tmp1_ = g_date_time_new_now_local ();
	now = _tmp1_;
	_tmp2_ = now;
	_tmp3_ = date;
	delta = g_date_time_difference (_tmp2_, _tmp3_);
	if (delta < ((GTimeSpan) 0)) {
		GDateTime* _tmp4_;
		GTimeZone* _tmp5_;
		GTimeZone* _tmp6_;
		GDateTime* _tmp7_;
		GDateTime* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = date;
		_tmp5_ = g_time_zone_new_local ();
		_tmp6_ = _tmp5_;
		_tmp7_ = g_date_time_to_timezone (_tmp4_, _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_date_time_format (_tmp8_, _ ("%b %-e, %Y %H:%M"));
		_tmp10_ = _tmp9_;
		_g_date_time_unref0 (_tmp8_);
		_g_time_zone_unref0 (_tmp6_);
		result = _tmp10_;
		_g_date_time_unref0 (now);
		_g_date_time_unref0 (date);
		return result;
	} else {
		if (delta <= G_TIME_SPAN_MINUTE) {
			gchar* _tmp11_;
			_tmp11_ = g_strdup (_ ("just now"));
			result = _tmp11_;
			_g_date_time_unref0 (now);
			_g_date_time_unref0 (date);
			return result;
		} else {
			if (delta < G_TIME_SPAN_HOUR) {
				GTimeSpan minutes = 0LL;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				minutes = delta / G_TIME_SPAN_MINUTE;
				_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) minutes);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strdup_printf (_ ("%s minutes ago"), _tmp13_);
				_tmp15_ = _tmp14_;
				_g_free0 (_tmp13_);
				result = _tmp15_;
				_g_date_time_unref0 (now);
				_g_date_time_unref0 (date);
				return result;
			} else {
				if (delta <= G_TIME_SPAN_DAY) {
					GTimeSpan hours = 0LL;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					hours = delta / G_TIME_SPAN_HOUR;
					_tmp16_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) hours);
					_tmp17_ = _tmp16_;
					_tmp18_ = g_strdup_printf (_ ("%s hours ago"), _tmp17_);
					_tmp19_ = _tmp18_;
					_g_free0 (_tmp17_);
					result = _tmp19_;
					_g_date_time_unref0 (now);
					_g_date_time_unref0 (date);
					return result;
				} else {
					GDateTime* _tmp20_;
					GDateTime* _tmp21_;
					GDateTime* _tmp22_;
					GDateTime* _tmp23_;
					gboolean _tmp24_;
					_tmp20_ = now;
					_tmp21_ = date;
					_tmp22_ = g_date_time_add_days (_tmp21_, 1);
					_tmp23_ = _tmp22_;
					_tmp24_ = tuba_utils_date_time_is_same_day (_tmp20_, _tmp23_);
					_g_date_time_unref0 (_tmp23_);
					if (_tmp24_) {
						gchar* _tmp25_;
						_tmp25_ = g_strdup (_ ("yesterday"));
						result = _tmp25_;
						_g_date_time_unref0 (now);
						_g_date_time_unref0 (date);
						return result;
					} else {
						GDateTime* _tmp26_;
						GDateTime* _tmp27_;
						_tmp26_ = date;
						_tmp27_ = now;
						if (g_date_time_get_year (_tmp26_) == g_date_time_get_year (_tmp27_)) {
							GDateTime* _tmp28_;
							GTimeZone* _tmp29_;
							GTimeZone* _tmp30_;
							GDateTime* _tmp31_;
							GDateTime* _tmp32_;
							gchar* _tmp33_;
							gchar* _tmp34_;
							_tmp28_ = date;
							_tmp29_ = g_time_zone_new_local ();
							_tmp30_ = _tmp29_;
							_tmp31_ = g_date_time_to_timezone (_tmp28_, _tmp30_);
							_tmp32_ = _tmp31_;
							_tmp33_ = g_date_time_format (_tmp32_, _ ("%b %-e"));
							_tmp34_ = _tmp33_;
							_g_date_time_unref0 (_tmp32_);
							_g_time_zone_unref0 (_tmp30_);
							result = _tmp34_;
							_g_date_time_unref0 (now);
							_g_date_time_unref0 (date);
							return result;
						} else {
							GDateTime* _tmp35_;
							GTimeZone* _tmp36_;
							GTimeZone* _tmp37_;
							GDateTime* _tmp38_;
							GDateTime* _tmp39_;
							gchar* _tmp40_;
							gchar* _tmp41_;
							_tmp35_ = date;
							_tmp36_ = g_time_zone_new_local ();
							_tmp37_ = _tmp36_;
							_tmp38_ = g_date_time_to_timezone (_tmp35_, _tmp37_);
							_tmp39_ = _tmp38_;
							_tmp40_ = g_date_time_format (_tmp39_, _ ("%b %-e, %Y"));
							_tmp41_ = _tmp40_;
							_g_date_time_unref0 (_tmp39_);
							_g_time_zone_unref0 (_tmp37_);
							result = _tmp41_;
							_g_date_time_unref0 (now);
							_g_date_time_unref0 (date);
							return result;
						}
					}
				}
			}
		}
	}
}

gchar*
tuba_utils_date_time_format_full (const gchar* iso8601)
{
	GDateTime* date = NULL;
	GDateTime* _tmp0_;
	GTimeZone* _tmp1_;
	GTimeZone* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (iso8601 != NULL, NULL);
	_tmp0_ = g_date_time_new_from_iso8601 (iso8601, NULL);
	date = _tmp0_;
	_tmp1_ = g_time_zone_new_local ();
	_tmp2_ = _tmp1_;
	_tmp3_ = g_date_time_to_timezone (date, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_date_time_format (_tmp4_, _ ("%b %-e, %Y"));
	_tmp6_ = _tmp5_;
	_g_date_time_unref0 (_tmp4_);
	_g_time_zone_unref0 (_tmp2_);
	result = _tmp6_;
	_g_date_time_unref0 (date);
	return result;
}

gchar*
tuba_utils_date_time_humanize_old (const gchar* iso8601)
{
	GDateTime* date = NULL;
	GDateTime* _tmp0_;
	GDateTime* now = NULL;
	GDateTime* _tmp1_;
	GTimeSpan delta = 0LL;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gint date_day_oty = 0;
	GDateTime* _tmp13_;
	gint now_day_oty = 0;
	GDateTime* _tmp14_;
	gint date_month = 0;
	GDateTime* _tmp15_;
	gint now_month = 0;
	GDateTime* _tmp16_;
	gint date_year = 0;
	GDateTime* _tmp17_;
	gint now_year = 0;
	GDateTime* _tmp18_;
	gchar* result;
	g_return_val_if_fail (iso8601 != NULL, NULL);
	_tmp0_ = g_date_time_new_from_iso8601 (iso8601, NULL);
	date = _tmp0_;
	_tmp1_ = g_date_time_new_now_local ();
	now = _tmp1_;
	_tmp2_ = now;
	_tmp3_ = date;
	delta = g_date_time_difference (_tmp2_, _tmp3_);
	if (delta < ((GTimeSpan) 0)) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("in the future");
		result = _tmp4_;
		_g_date_time_unref0 (now);
		_g_date_time_unref0 (date);
		return result;
	} else {
		if (delta < G_TIME_SPAN_HOUR) {
			GTimeSpan minutes = 0LL;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			minutes = delta / G_TIME_SPAN_MINUTE;
			if (minutes == ((GTimeSpan) 0)) {
				minutes = (GTimeSpan) 1;
			}
			_tmp5_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) minutes);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strdup_printf (ngettext ("less than a minute old", "%s minutes old", (gulong) minutes), _tmp6_);
			_tmp8_ = _tmp7_;
			_g_free0 (_tmp6_);
			result = _tmp8_;
			_g_date_time_unref0 (now);
			_g_date_time_unref0 (date);
			return result;
		} else {
			if (delta <= G_TIME_SPAN_DAY) {
				GTimeSpan hours = 0LL;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				hours = delta / G_TIME_SPAN_HOUR;
				if (hours == ((GTimeSpan) 0)) {
					hours = (GTimeSpan) 1;
				}
				_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) hours);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strdup_printf (ngettext ("an hour old", "%s hours old", (gulong) hours), _tmp10_);
				_tmp12_ = _tmp11_;
				_g_free0 (_tmp10_);
				result = _tmp12_;
				_g_date_time_unref0 (now);
				_g_date_time_unref0 (date);
				return result;
			}
		}
	}
	_tmp13_ = date;
	date_day_oty = g_date_time_get_day_of_year (_tmp13_);
	_tmp14_ = now;
	now_day_oty = g_date_time_get_day_of_year (_tmp14_);
	_tmp15_ = date;
	date_month = g_date_time_get_month (_tmp15_);
	_tmp16_ = now;
	now_month = g_date_time_get_month (_tmp16_);
	_tmp17_ = date;
	date_year = g_date_time_get_year (_tmp17_);
	_tmp18_ = now;
	now_year = g_date_time_get_year (_tmp18_);
	if (date_year == now_year) {
		gint day_diff = 0;
		gchar* _tmp20_;
		if (now_month > date_month) {
			gint diff = 0;
			gchar* _tmp19_;
			diff = now_month - date_month;
			_tmp19_ = g_strdup_printf (ngettext ("a month old", "%d months old", (gulong) diff), diff);
			result = _tmp19_;
			_g_date_time_unref0 (now);
			_g_date_time_unref0 (date);
			return result;
		}
		day_diff = now_day_oty - date_day_oty;
		if (day_diff == 0) {
			day_diff = 1;
		}
		_tmp20_ = g_strdup_printf (ngettext ("a day old", "%d days old", (gulong) day_diff), day_diff);
		result = _tmp20_;
		_g_date_time_unref0 (now);
		_g_date_time_unref0 (date);
		return result;
	} else {
		gint year_diff = 0;
		year_diff = now_year - date_year;
		if (year_diff > 1) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup_printf (ngettext ("a year old", "%d years old", (gulong) year_diff), year_diff);
			result = _tmp21_;
			_g_date_time_unref0 (now);
			_g_date_time_unref0 (date);
			return result;
		} else {
			gint diff = 0;
			gchar* _tmp22_;
			diff = (now_month + 12) - date_month;
			_tmp22_ = g_strdup_printf (ngettext ("a month old", "%d months old", (gulong) diff), diff);
			result = _tmp22_;
			_g_date_time_unref0 (now);
			_g_date_time_unref0 (date);
			return result;
		}
	}
}

gboolean
tuba_utils_date_time_is_3_months_old (const gchar* iso8601)
{
	GDateTime* date = NULL;
	GDateTime* _tmp0_;
	GDateTime* now = NULL;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	gboolean result;
	g_return_val_if_fail (iso8601 != NULL, FALSE);
	_tmp0_ = g_date_time_new_from_iso8601 (iso8601, NULL);
	date = _tmp0_;
	_tmp1_ = g_date_time_new_now_local ();
	now = _tmp1_;
	_tmp2_ = now;
	_tmp3_ = date;
	if (g_date_time_difference (_tmp2_, _tmp3_) < ((GTimeSpan) 0)) {
		result = FALSE;
		_g_date_time_unref0 (now);
		_g_date_time_unref0 (date);
		return result;
	}
	_tmp4_ = now;
	_tmp5_ = now;
	_tmp6_ = date;
	_tmp7_ = date;
	result = ((g_date_time_get_month (_tmp4_) + (12 * (g_date_time_get_year (_tmp5_) - g_date_time_get_year (_tmp6_)))) - g_date_time_get_month (_tmp7_)) > 3;
	_g_date_time_unref0 (now);
	_g_date_time_unref0 (date);
	return result;
}

gboolean
tuba_utils_date_time_is_same_day (GDateTime* d1,
                                  GDateTime* d2)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (d1 != NULL, FALSE);
	g_return_val_if_fail (d2 != NULL, FALSE);
	if (g_date_time_get_day_of_year (d1) == g_date_time_get_day_of_year (d2)) {
		_tmp0_ = g_date_time_get_year (d1) == g_date_time_get_year (d2);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

TubaUtilsDateTime*
tuba_utils_date_time_construct (GType object_type)
{
	TubaUtilsDateTime* self = NULL;
	self = (TubaUtilsDateTime*) g_type_create_instance (object_type);
	return self;
}

TubaUtilsDateTime*
tuba_utils_date_time_new (void)
{
	return tuba_utils_date_time_construct (TUBA_UTILS_TYPE_DATE_TIME);
}

static void
tuba_utils_value_date_time_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
tuba_utils_value_date_time_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		tuba_utils_date_time_unref (value->data[0].v_pointer);
	}
}

static void
tuba_utils_value_date_time_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tuba_utils_date_time_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
tuba_utils_value_date_time_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
tuba_utils_value_date_time_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TubaUtilsDateTime * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tuba_utils_date_time_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
tuba_utils_value_date_time_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	TubaUtilsDateTime ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tuba_utils_date_time_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
tuba_utils_param_spec_date_time (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	TubaUtilsParamSpecDateTime* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TUBA_UTILS_TYPE_DATE_TIME), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
tuba_utils_value_get_date_time (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TUBA_UTILS_TYPE_DATE_TIME), NULL);
	return value->data[0].v_pointer;
}

void
tuba_utils_value_set_date_time (GValue* value,
                                gpointer v_object)
{
	TubaUtilsDateTime * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TUBA_UTILS_TYPE_DATE_TIME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TUBA_UTILS_TYPE_DATE_TIME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tuba_utils_date_time_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tuba_utils_date_time_unref (old);
	}
}

void
tuba_utils_value_take_date_time (GValue* value,
                                 gpointer v_object)
{
	TubaUtilsDateTime * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TUBA_UTILS_TYPE_DATE_TIME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TUBA_UTILS_TYPE_DATE_TIME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tuba_utils_date_time_unref (old);
	}
}

static void
tuba_utils_date_time_class_init (TubaUtilsDateTimeClass * klass,
                                 gpointer klass_data)
{
	tuba_utils_date_time_parent_class = g_type_class_peek_parent (klass);
	((TubaUtilsDateTimeClass *) klass)->finalize = tuba_utils_date_time_finalize;
}

static void
tuba_utils_date_time_instance_init (TubaUtilsDateTime * self,
                                    gpointer klass)
{
	self->ref_count = 1;
}

static void
tuba_utils_date_time_finalize (TubaUtilsDateTime * obj)
{
	TubaUtilsDateTime * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_UTILS_TYPE_DATE_TIME, TubaUtilsDateTime);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
tuba_utils_date_time_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { tuba_utils_value_date_time_init, tuba_utils_value_date_time_free_value, tuba_utils_value_date_time_copy_value, tuba_utils_value_date_time_peek_pointer, "p", tuba_utils_value_date_time_collect_value, "p", tuba_utils_value_date_time_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TubaUtilsDateTimeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_utils_date_time_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaUtilsDateTime), 0, (GInstanceInitFunc) tuba_utils_date_time_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType tuba_utils_date_time_type_id;
	tuba_utils_date_time_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TubaUtilsDateTime", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return tuba_utils_date_time_type_id;
}

GType
tuba_utils_date_time_get_type (void)
{
	static gsize tuba_utils_date_time_type_id__once = 0;
	if (g_once_init_enter (&tuba_utils_date_time_type_id__once)) {
		GType tuba_utils_date_time_type_id;
		tuba_utils_date_time_type_id = tuba_utils_date_time_get_type_once ();
		g_once_init_leave (&tuba_utils_date_time_type_id__once, tuba_utils_date_time_type_id);
	}
	return tuba_utils_date_time_type_id__once;
}

gpointer
tuba_utils_date_time_ref (gpointer instance)
{
	TubaUtilsDateTime * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
tuba_utils_date_time_unref (gpointer instance)
{
	TubaUtilsDateTime * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TUBA_UTILS_DATE_TIME_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

