// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modifies a resource discovery. A resource discovery is an IPAM component that
// enables IPAM to manage and monitor resources that belong to the owning account.
func (c *Client) ModifyIpamResourceDiscovery(ctx context.Context, params *ModifyIpamResourceDiscoveryInput, optFns ...func(*Options)) (*ModifyIpamResourceDiscoveryOutput, error) {
	if params == nil {
		params = &ModifyIpamResourceDiscoveryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ModifyIpamResourceDiscovery", params, optFns, c.addOperationModifyIpamResourceDiscoveryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ModifyIpamResourceDiscoveryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ModifyIpamResourceDiscoveryInput struct {

	// A resource discovery ID.
	//
	// This member is required.
	IpamResourceDiscoveryId *string

	// Add operating Regions to the resource discovery. Operating Regions are Amazon
	// Web Services Regions where the IPAM is allowed to manage IP address CIDRs. IPAM
	// only discovers and monitors resources in the Amazon Web Services Regions you
	// select as operating Regions.
	AddOperatingRegions []types.AddIpamOperatingRegion

	// Add an Organizational Unit (OU) exclusion to your IPAM. If your IPAM is
	// integrated with Amazon Web Services Organizations and you add an organizational
	// unit (OU) exclusion, IPAM will not manage the IP addresses in accounts in that
	// OU exclusion. There is a limit on the number of exclusions you can create. For
	// more information, see [Quotas for your IPAM]in the Amazon VPC IPAM User Guide.
	//
	// [Quotas for your IPAM]: https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html
	AddOrganizationalUnitExclusions []types.AddIpamOrganizationalUnitExclusion

	// A resource discovery description.
	Description *string

	// A check for whether you have the required permissions for the action without
	// actually making the request and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// Remove operating Regions.
	RemoveOperatingRegions []types.RemoveIpamOperatingRegion

	// Remove an Organizational Unit (OU) exclusion to your IPAM. If your IPAM is
	// integrated with Amazon Web Services Organizations and you add an organizational
	// unit (OU) exclusion, IPAM will not manage the IP addresses in accounts in that
	// OU exclusion. There is a limit on the number of exclusions you can create. For
	// more information, see [Quotas for your IPAM]in the Amazon VPC IPAM User Guide.
	//
	// [Quotas for your IPAM]: https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html
	RemoveOrganizationalUnitExclusions []types.RemoveIpamOrganizationalUnitExclusion

	noSmithyDocumentSerde
}

type ModifyIpamResourceDiscoveryOutput struct {

	// A resource discovery.
	IpamResourceDiscovery *types.IpamResourceDiscovery

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationModifyIpamResourceDiscoveryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpModifyIpamResourceDiscovery{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpModifyIpamResourceDiscovery{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ModifyIpamResourceDiscovery"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpModifyIpamResourceDiscoveryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opModifyIpamResourceDiscovery(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opModifyIpamResourceDiscovery(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ModifyIpamResourceDiscovery",
	}
}
