/* MainWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/*
 * MainWindow.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>

#define AppName "Timeshift-gtk"
#define ICON_MANAGER_SHIELD_HIGH "timeshift-shield-high"
#define ICON_MANAGER_SHIELD_ICON_SIZE 64
#define AppAuthorEmail "teejeetech@gmail.com"
#define CONSTANTS_VERSION "25.12.2"
#define AppVersion CONSTANTS_VERSION
#define ICON_MANAGER_SHIELD_LIVE "media-optical"
#define ICON_MANAGER_SHIELD_LOW "timeshift-shield-low"
#define ICON_MANAGER_SHIELD_MED "timeshift-shield-med"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_SNAPSHOT_LIST_BOX (snapshot_list_box_get_type ())
#define SNAPSHOT_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_LIST_BOX, SnapshotListBox))
#define SNAPSHOT_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_LIST_BOX, SnapshotListBoxClass))
#define IS_SNAPSHOT_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_LIST_BOX))
#define IS_SNAPSHOT_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_LIST_BOX))
#define SNAPSHOT_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_LIST_BOX, SnapshotListBoxClass))

typedef struct _SnapshotListBox SnapshotListBox;
typedef struct _SnapshotListBoxClass SnapshotListBoxClass;
enum  {
	MAIN_WINDOW_0_PROPERTY,
	MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* main_window_properties[MAIN_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;

#define TYPE_APP_EXCLUDE_ENTRY (app_exclude_entry_get_type ())
#define APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntry))
#define APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))
#define IS_APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_EXCLUDE_ENTRY))
#define IS_APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_EXCLUDE_ENTRY))
#define APP_EXCLUDE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))

typedef struct _AppExcludeEntry AppExcludeEntry;
typedef struct _AppExcludeEntryClass AppExcludeEntryClass;

#define TYPE_MOUNT_ENTRY (mount_entry_get_type ())
#define MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ENTRY, MountEntry))
#define MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ENTRY, MountEntryClass))
#define IS_MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ENTRY))
#define IS_MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ENTRY))
#define MOUNT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ENTRY, MountEntryClass))

typedef struct _MountEntry MountEntry;
typedef struct _MountEntryClass MountEntryClass;

#define TYPE_SNAPSHOT_REPO (snapshot_repo_get_type ())
#define SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepo))
#define SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))
#define IS_SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_REPO))
#define IS_SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_REPO))
#define SNAPSHOT_REPO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))

typedef struct _SnapshotRepo SnapshotRepo;
typedef struct _SnapshotRepoClass SnapshotRepoClass;

#define TYPE_SUBVOLUME (subvolume_get_type ())
#define SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUBVOLUME, Subvolume))
#define SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUBVOLUME, SubvolumeClass))
#define IS_SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUBVOLUME))
#define IS_SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUBVOLUME))
#define SUBVOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUBVOLUME, SubvolumeClass))

typedef struct _Subvolume Subvolume;
typedef struct _SubvolumeClass SubvolumeClass;

#define TYPE_LINUX_DISTRO (linux_distro_get_type ())
#define LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINUX_DISTRO, LinuxDistro))
#define LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINUX_DISTRO, LinuxDistroClass))
#define IS_LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINUX_DISTRO))
#define IS_LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINUX_DISTRO))
#define LINUX_DISTRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINUX_DISTRO, LinuxDistroClass))

typedef struct _LinuxDistro LinuxDistro;
typedef struct _LinuxDistroClass LinuxDistroClass;

#define TYPE_APP_LOCK (app_lock_get_type ())
#define APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_LOCK, AppLock))
#define APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_LOCK, AppLockClass))
#define IS_APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_LOCK))
#define IS_APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_LOCK))
#define APP_LOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_LOCK, AppLockClass))

typedef struct _AppLock AppLock;
typedef struct _AppLockClass AppLockClass;

#define TYPE_SNAPSHOT (snapshot_get_type ())
#define SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT, Snapshot))
#define SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT, SnapshotClass))
#define IS_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT))
#define IS_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT))
#define SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT, SnapshotClass))

typedef struct _Snapshot Snapshot;
typedef struct _SnapshotClass SnapshotClass;

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;

#define TYPE_RSYNC_TASK (rsync_task_get_type ())
#define RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_TASK, RsyncTask))
#define RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_TASK, RsyncTaskClass))
#define IS_RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_TASK))
#define IS_RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_TASK))
#define RSYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_TASK, RsyncTaskClass))

typedef struct _RsyncTask RsyncTask;
typedef struct _RsyncTaskClass RsyncTaskClass;

#define TYPE_DELETE_FILE_TASK (delete_file_task_get_type ())
#define DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTask))
#define DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))
#define IS_DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_FILE_TASK))
#define IS_DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_FILE_TASK))
#define DELETE_FILE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))

typedef struct _DeleteFileTask DeleteFileTask;
typedef struct _DeleteFileTaskClass DeleteFileTaskClass;

#define TYPE_RSYNC_SPACE_CHECK_TASK (rsync_space_check_task_get_type ())
#define RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTask))
#define RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))
#define IS_RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_SPACE_CHECK_TASK))
#define IS_RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_SPACE_CHECK_TASK))
#define RSYNC_SPACE_CHECK_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))

typedef struct _RsyncSpaceCheckTask RsyncSpaceCheckTask;
typedef struct _RsyncSpaceCheckTaskClass RsyncSpaceCheckTaskClass;

#define TYPE_SYSTEM_USER (system_user_get_type ())
#define SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_USER, SystemUser))
#define SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYSTEM_USER, SystemUserClass))
#define IS_SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_USER))
#define IS_SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYSTEM_USER))
#define SYSTEM_USER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYSTEM_USER, SystemUserClass))

typedef struct _SystemUser SystemUser;
typedef struct _SystemUserClass SystemUserClass;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _AsyncTaskPrivate AsyncTaskPrivate;
typedef enum  {
	APP_STATUS_NOT_STARTED,
	APP_STATUS_RUNNING,
	APP_STATUS_PAUSED,
	APP_STATUS_FINISHED,
	APP_STATUS_CANCELLED,
	APP_STATUS_PASSWORD_REQUIRED
} AppStatus;

#define TYPE_APP_STATUS (app_status_get_type ())
typedef struct _SnapshotRepoPrivate SnapshotRepoPrivate;
typedef enum  {
	SNAPSHOT_LOCATION_STATUS_NOT_SELECTED = -2,
	SNAPSHOT_LOCATION_STATUS_NOT_AVAILABLE = -1,
	SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_HAS_SPACE = 0,
	SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_NO_SPACE = 1,
	SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_NO_SPACE = 2,
	SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_HAS_SPACE = 3,
	SNAPSHOT_LOCATION_STATUS_READ_ONLY_FS = 4,
	SNAPSHOT_LOCATION_STATUS_HARDLINKS_NOT_SUPPORTED = 5,
	SNAPSHOT_LOCATION_STATUS_NO_BTRFS_SYSTEM = 6
} SnapshotLocationStatus;

#define TYPE_SNAPSHOT_LOCATION_STATUS (snapshot_location_status_get_type ())

#define TYPE_CUSTOM_MESSAGE_DIALOG (custom_message_dialog_get_type ())
#define CUSTOM_MESSAGE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_MESSAGE_DIALOG, CustomMessageDialog))
#define CUSTOM_MESSAGE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_MESSAGE_DIALOG, CustomMessageDialogClass))
#define IS_CUSTOM_MESSAGE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_MESSAGE_DIALOG))
#define IS_CUSTOM_MESSAGE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_MESSAGE_DIALOG))
#define CUSTOM_MESSAGE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_MESSAGE_DIALOG, CustomMessageDialogClass))

typedef struct _CustomMessageDialog CustomMessageDialog;
typedef struct _CustomMessageDialogClass CustomMessageDialogClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BACKUP_WINDOW (backup_window_get_type ())
#define BACKUP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKUP_WINDOW, BackupWindow))
#define BACKUP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKUP_WINDOW, BackupWindowClass))
#define IS_BACKUP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKUP_WINDOW))
#define IS_BACKUP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKUP_WINDOW))
#define BACKUP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKUP_WINDOW, BackupWindowClass))

typedef struct _BackupWindow BackupWindow;
typedef struct _BackupWindowClass BackupWindowClass;
typedef struct _SnapshotPrivate SnapshotPrivate;

#define TYPE_FS_TAB_ENTRY (fs_tab_entry_get_type ())
#define FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FS_TAB_ENTRY, FsTabEntry))
#define FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FS_TAB_ENTRY, FsTabEntryClass))
#define IS_FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FS_TAB_ENTRY))
#define IS_FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FS_TAB_ENTRY))
#define FS_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FS_TAB_ENTRY, FsTabEntryClass))

typedef struct _FsTabEntry FsTabEntry;
typedef struct _FsTabEntryClass FsTabEntryClass;

#define TYPE_CRYPT_TAB_ENTRY (crypt_tab_entry_get_type ())
#define CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntry))
#define CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))
#define IS_CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CRYPT_TAB_ENTRY))
#define IS_CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CRYPT_TAB_ENTRY))
#define CRYPT_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))

typedef struct _CryptTabEntry CryptTabEntry;
typedef struct _CryptTabEntryClass CryptTabEntryClass;

#define TYPE_DELETE_WINDOW (delete_window_get_type ())
#define DELETE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_WINDOW, DeleteWindow))
#define DELETE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_WINDOW, DeleteWindowClass))
#define IS_DELETE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_WINDOW))
#define IS_DELETE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_WINDOW))
#define DELETE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_WINDOW, DeleteWindowClass))

typedef struct _DeleteWindow DeleteWindow;
typedef struct _DeleteWindowClass DeleteWindowClass;
typedef struct _SnapshotListBoxPrivate SnapshotListBoxPrivate;

#define TYPE_RSYNC_LOG_WINDOW (rsync_log_window_get_type ())
#define RSYNC_LOG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_LOG_WINDOW, RsyncLogWindow))
#define RSYNC_LOG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_LOG_WINDOW, RsyncLogWindowClass))
#define IS_RSYNC_LOG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_LOG_WINDOW))
#define IS_RSYNC_LOG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_LOG_WINDOW))
#define RSYNC_LOG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_LOG_WINDOW, RsyncLogWindowClass))

typedef struct _RsyncLogWindow RsyncLogWindow;
typedef struct _RsyncLogWindowClass RsyncLogWindowClass;

#define TYPE_RESTORE_WINDOW (restore_window_get_type ())
#define RESTORE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESTORE_WINDOW, RestoreWindow))
#define RESTORE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RESTORE_WINDOW, RestoreWindowClass))
#define IS_RESTORE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESTORE_WINDOW))
#define IS_RESTORE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RESTORE_WINDOW))
#define RESTORE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RESTORE_WINDOW, RestoreWindowClass))

typedef struct _RestoreWindow RestoreWindow;
typedef struct _RestoreWindowClass RestoreWindowClass;
typedef struct _Block4Data Block4Data;

#define TYPE_SETTINGS_WINDOW (settings_window_get_type ())
#define SETTINGS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_WINDOW, SettingsWindow))
#define SETTINGS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_WINDOW, SettingsWindowClass))
#define IS_SETTINGS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_WINDOW))
#define IS_SETTINGS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_WINDOW))
#define SETTINGS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_WINDOW, SettingsWindowClass))

typedef struct _SettingsWindow SettingsWindow;
typedef struct _SettingsWindowClass SettingsWindowClass;
typedef struct _Block5Data Block5Data;

#define TYPE_SETUP_WIZARD_WINDOW (setup_wizard_window_get_type ())
#define SETUP_WIZARD_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETUP_WIZARD_WINDOW, SetupWizardWindow))
#define SETUP_WIZARD_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETUP_WIZARD_WINDOW, SetupWizardWindowClass))
#define IS_SETUP_WIZARD_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETUP_WIZARD_WINDOW))
#define IS_SETUP_WIZARD_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETUP_WIZARD_WINDOW))
#define SETUP_WIZARD_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETUP_WIZARD_WINDOW, SetupWizardWindowClass))

typedef struct _SetupWizardWindow SetupWizardWindow;
typedef struct _SetupWizardWindowClass SetupWizardWindowClass;
typedef struct _DevicePrivate DevicePrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _MainWindow {
	GtkWindow parent_instance;
	MainWindowPrivate * priv;
};

struct _MainWindowClass {
	GtkWindowClass parent_class;
};

struct _MainWindowPrivate {
	GtkBox* vbox_main;
	GtkToolbar* toolbar;
	GtkToolButton* btn_backup;
	GtkToolButton* btn_restore;
	GtkToolButton* btn_delete_snapshot;
	GtkToolButton* btn_browse_snapshot;
	GtkToolButton* btn_settings;
	GtkToolButton* btn_wizard;
	GtkMenu* menu_extra;
	SnapshotListBox* snapshot_list_box;
	GtkScrolledWindow* statusbar;
	GtkImage* img_shield;
	GtkLabel* lbl_shield;
	GtkLabel* lbl_shield_subnote;
	GtkLabel* lbl_snap_count;
	GtkLabel* lbl_snap_count_subnote;
	GtkLabel* lbl_free_space;
	GtkLabel* lbl_free_space_subnote;
	GtkScrolledWindow* scrolled_snap_count;
	GtkScrolledWindow* scrolled_free_space;
	guint tmr_init;
	gint def_width;
	gint def_height;
};

struct _Main {
	GObject parent_instance;
	MainPrivate * priv;
	gchar* app_path;
	gchar* share_folder;
	gchar* rsnapshot_conf_path;
	gchar* app_conf_path;
	gchar* app_conf_path_old;
	gchar* app_conf_path_default;
	gboolean first_run;
	gchar* backup_uuid;
	gchar* backup_parent_uuid;
	gboolean btrfs_mode;
	gboolean include_btrfs_home_for_backup;
	gboolean include_btrfs_home_for_restore;
	gboolean stop_cron_emails;
	GeeArrayList* partitions;
	GeeArrayList* exclude_list_user;
	GeeArrayList* exclude_list_default;
	GeeArrayList* exclude_list_default_extra;
	GeeArrayList* exclude_list_home;
	GeeArrayList* exclude_list_restore;
	GeeArrayList* exclude_list_apps;
	GeeArrayList* mount_list;
	GeeArrayList* exclude_app_names;
	SnapshotRepo* repo;
	Device* sys_root;
	Device* sys_boot;
	Device* sys_efi;
	Device* sys_home;
	GeeHashMap* sys_subvolumes;
	gchar* mount_point_restore;
	gchar* mount_point_app;
	LinuxDistro* current_distro;
	gboolean mirror_system;
	gboolean schedule_monthly;
	gboolean schedule_weekly;
	gboolean schedule_daily;
	gboolean schedule_hourly;
	gboolean schedule_boot;
	gint count_monthly;
	gint count_weekly;
	gint count_daily;
	gint count_hourly;
	gint count_boot;
	gchar* app_mode;
	gboolean dry_run;
	gboolean thr_success;
	gboolean thread_restore_running;
	gboolean thread_restore_success;
	gboolean thread_delete_running;
	gboolean thread_delete_success;
	gboolean thread_subvol_info_running;
	gboolean thread_subvol_info_success;
	gint thr_retval;
	gchar* thr_arg1;
	gboolean thr_timeout_active;
	gchar* thr_timeout_cmd;
	gint startup_delay_interval_mins;
	gint retain_snapshots_max_days;
	gchar* log_dir;
	gchar* log_file;
	AppLock* app_lock;
	gchar* date_format;
	GeeArrayList* delete_list;
	Snapshot* snapshot_to_delete;
	Snapshot* snapshot_to_restore;
	gboolean reinstall_grub2;
	gboolean update_initramfs;
	gboolean update_grub;
	gchar* grub_device;
	gboolean use_option_raw;
	gboolean cmd_skip_grub;
	gchar* cmd_grub_device;
	gchar* cmd_target_device;
	gchar* cmd_backup_device;
	gchar* cmd_snapshot;
	gboolean cmd_confirm;
	gboolean cmd_verbose;
	gboolean cmd_scripted;
	gchar* cmd_comments;
	gchar* cmd_tags;
	gboolean* cmd_btrfs_mode;
	gchar* progress_text;
	GtkWindow* parent_window;
	RsyncTask* task;
	DeleteFileTask* delete_file_task;
	RsyncSpaceCheckTask* space_check_task;
	GeeHashMap* current_system_users;
	gchar* users_with_encrypted_home;
	gchar* encrypted_home_dirs;
	gboolean encrypted_home_warning_shown;
	gchar* encrypted_private_dirs;
	gboolean encrypted_private_warning_shown;
};

struct _MainClass {
	GObjectClass parent_class;
};

struct _AsyncTask {
	GObject parent_instance;
	AsyncTaskPrivate * priv;
	GDataOutputStream* dos_log;
	GPid child_pid;
	gchar* script_file;
	gchar* working_dir;
	AppStatus status;
	GMutex status_line_mutex;
	gint exit_code;
	GTimer* timer;
	gdouble progress;
	gdouble percent;
	gint64 prg_count;
	gint64 prg_count_total;
};

struct _AsyncTaskClass {
	GObjectClass parent_class;
	void (*prepare) (AsyncTask* self);
	gchar* (*build_script) (AsyncTask* self);
	gboolean (*begin) (AsyncTask* self);
	void (*execute) (AsyncTask* self);
	void (*parse_stdout_line) (AsyncTask* self, const gchar* out_line);
	void (*parse_stderr_line) (AsyncTask* self, const gchar* err_line);
	void (*finish_task) (AsyncTask* self);
};

struct _SnapshotRepo {
	GObject parent_instance;
	SnapshotRepoPrivate * priv;
	Device* device;
	Device* device_home;
	gchar* mount_path;
	GeeHashMap* mount_paths;
	gboolean btrfs_mode;
	GeeArrayList* snapshots;
	GeeArrayList* invalid_snapshots;
	gchar* status_message;
	gchar* status_details;
	SnapshotLocationStatus status_code;
	gboolean last_snapshot_failed_space;
};

struct _SnapshotRepoClass {
	GObjectClass parent_class;
};

struct _Snapshot {
	GObject parent_instance;
	SnapshotPrivate * priv;
	gchar* path;
	gchar* name;
	GDateTime* date;
	gchar* sys_uuid;
	gchar* sys_distro;
	gchar* app_version;
	gchar* description;
	gint64 file_count;
	GeeArrayList* tags;
	GeeArrayList* exclude_list;
	GeeHashMap* subvolumes;
	GeeArrayList* fstab_list;
	GeeArrayList* cryttab_list;
	gboolean valid;
	gboolean live;
	gboolean marked_for_deletion;
	LinuxDistro* distro;
	SnapshotRepo* repo;
	gboolean btrfs_mode;
	GeeHashMap* paths;
	gchar* mount_path_root;
	gchar* mount_path_home;
	DeleteFileTask* delete_file_task;
};

struct _SnapshotClass {
	GObjectClass parent_class;
};

struct _SnapshotListBox {
	GtkBox parent_instance;
	SnapshotListBoxPrivate * priv;
	GtkTreeView* treeview;
};

struct _SnapshotListBoxClass {
	GtkBoxClass parent_class;
};

struct _Block4Data {
	int _ref_count_;
	MainWindow* self;
	gboolean btrfs_mode_prev;
};

struct _Block5Data {
	int _ref_count_;
	MainWindow* self;
	gboolean btrfs_mode_prev;
};

struct _Device {
	GObject parent_instance;
	DevicePrivate * priv;
	gchar* device;
	gchar* name;
	gchar* kname;
	gchar* pkname;
	gchar* pkname_toplevel;
	gchar* mapped_name;
	gchar* uuid;
	gchar* label;
	gchar* partuuid;
	gchar* partlabel;
	gint major;
	gint minor;
	gchar* device_mapper;
	gchar* device_by_uuid;
	gchar* device_by_label;
	gchar* device_by_partuuid;
	gchar* device_by_partlabel;
	gchar* type;
	gchar* fstype;
	gint order;
	gchar* vendor;
	gchar* model;
	gchar* serial;
	gchar* revision;
	gboolean removable;
	gboolean read_only;
	guint64 size_bytes;
	guint64 used_bytes;
	guint64 available_bytes;
	gchar* used_percent;
	gchar* dist_info;
	GeeArrayList* mount_points;
	GeeArrayList* symlinks;
	Device* parent;
	GeeArrayList* children;
};

struct _DeviceClass {
	GObjectClass parent_class;
};

static gint MainWindow_private_offset;
static gpointer main_window_parent_class = NULL;
VALA_EXTERN Main* App;

VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN GType snapshot_list_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotListBox, g_object_unref)
VALA_EXTERN MainWindow* main_window_new (void);
VALA_EXTERN MainWindow* main_window_construct (GType object_type);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
static gboolean main_window_on_delete_event (MainWindow* self,
                                      GdkEventAny* event);
static gboolean _main_window_on_delete_event_gtk_widget_delete_event (GtkWidget* _sender,
                                                               GdkEventAny* event,
                                                               gpointer self);
VALA_EXTERN GdkPixbuf* icon_manager_lookup (const gchar* icon_name,
                                gint icon_size,
                                gboolean symbolic,
                                gboolean use_hardcoded,
                                gint scale);
static void main_window_init_ui_toolbar (MainWindow* self);
static void main_window_init_ui_snapshot_list (MainWindow* self);
static void main_window_init_ui_statusbar (MainWindow* self);
VALA_EXTERN GType main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Main, g_object_unref)
VALA_EXTERN gboolean main_live_system (Main* self);
static gboolean main_window_init_delayed (MainWindow* self);
static gboolean _main_window_init_delayed_gsource_func (gpointer self);
VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN GType app_exclude_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppExcludeEntry, g_object_unref)
VALA_EXTERN GType mount_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountEntry, g_object_unref)
VALA_EXTERN GType snapshot_repo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotRepo, g_object_unref)
VALA_EXTERN GType subvolume_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Subvolume, g_object_unref)
VALA_EXTERN GType linux_distro_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinuxDistro, g_object_unref)
VALA_EXTERN GType app_lock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppLock, g_object_unref)
VALA_EXTERN GType snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Snapshot, g_object_unref)
VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType rsync_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncTask, g_object_unref)
VALA_EXTERN GType delete_file_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteFileTask, g_object_unref)
VALA_EXTERN GType rsync_space_check_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncSpaceCheckTask, g_object_unref)
VALA_EXTERN GType system_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SystemUser, g_object_unref)
VALA_EXTERN gboolean snapshot_repo_available (SnapshotRepo* self);
VALA_EXTERN SnapshotRepo* snapshot_repo_new_from_uuid (const gchar* uuid,
                                           GtkWindow* parent_win,
                                           gboolean btrfs_repo);
VALA_EXTERN SnapshotRepo* snapshot_repo_construct_from_uuid (GType object_type,
                                                 const gchar* uuid,
                                                 GtkWindow* parent_win,
                                                 gboolean btrfs_repo);
static gboolean main_window_refresh_all (MainWindow* self);
static void main_window_btn_wizard_clicked (MainWindow* self);
VALA_EXTERN void main_window_create_snapshot (MainWindow* self);
static void _main_window_create_snapshot_gtk_tool_button_clicked (GtkToolButton* _sender,
                                                           gpointer self);
static void main_window_btn_restore_clicked (MainWindow* self);
static void _main_window_btn_restore_clicked_gtk_tool_button_clicked (GtkToolButton* _sender,
                                                               gpointer self);
VALA_EXTERN void main_window_delete_selected (MainWindow* self);
static void _main_window_delete_selected_gtk_tool_button_clicked (GtkToolButton* _sender,
                                                           gpointer self);
VALA_EXTERN void main_window_browse_selected (MainWindow* self);
static void _main_window_browse_selected_gtk_tool_button_clicked (GtkToolButton* _sender,
                                                           gpointer self);
static void main_window_btn_settings_clicked (MainWindow* self);
static void _main_window_btn_settings_clicked_gtk_tool_button_clicked (GtkToolButton* _sender,
                                                                gpointer self);
static void _main_window_btn_wizard_clicked_gtk_tool_button_clicked (GtkToolButton* _sender,
                                                              gpointer self);
static void __lambda142_ (MainWindow* self);
static gboolean main_window_menu_extra_popup (MainWindow* self,
                                       GdkEventButton* event);
static void ___lambda142__gtk_tool_button_clicked (GtkToolButton* _sender,
                                            gpointer self);
VALA_EXTERN SnapshotListBox* snapshot_list_box_new (GtkWindow* _parent_window);
VALA_EXTERN SnapshotListBox* snapshot_list_box_construct (GType object_type,
                                              GtkWindow* _parent_window);
static void _main_window_delete_selected_snapshot_list_box_delete_selected (SnapshotListBox* _sender,
                                                                     gpointer self);
VALA_EXTERN void main_window_mark_selected (MainWindow* self);
static void _main_window_mark_selected_snapshot_list_box_mark_selected (SnapshotListBox* _sender,
                                                                 gpointer self);
static void _main_window_browse_selected_snapshot_list_box_browse_selected (SnapshotListBox* _sender,
                                                                     gpointer self);
VALA_EXTERN void main_window_view_snapshot_log (MainWindow* self,
                                    gboolean view_restore_log);
static void _main_window_view_snapshot_log_snapshot_list_box_view_snapshot_log (SnapshotListBox* _sender,
                                                                         gboolean show_restore_log,
                                                                         gpointer self);
VALA_EXTERN cairo_surface_t* icon_manager_lookup_surface (const gchar* icon_name,
                                              gint icon_size,
                                              gint scale,
                                              gboolean symbolic,
                                              gboolean use_hardcoded);
VALA_EXTERN GtkLabel* tee_jee_gtk_helper_add_label (GtkBox* box,
                                        const gchar* text,
                                        gboolean bold,
                                        gboolean italic,
                                        gboolean large);
static GtkMenuItem* main_window_create_menu_item (MainWindow* self,
                                           const gchar* label_text,
                                           const gchar* icon_name_stock,
                                           const gchar* icon_name_custom,
                                           gint icon_size,
                                           const gchar* tooltip_text);
static void main_window_btn_view_app_logs_clicked (MainWindow* self);
static void _main_window_btn_view_app_logs_clicked_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                    gpointer self);
static void main_window_btn_about_clicked (MainWindow* self);
static void _main_window_btn_about_clicked_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                            gpointer self);
static void main_window_ui_sensitive (MainWindow* self,
                               gboolean enable);
VALA_EXTERN void snapshot_list_box_refresh (SnapshotListBox* self);
static void main_window_update_statusbar (MainWindow* self);
VALA_EXTERN GType app_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN void async_task_stop (AsyncTask* self,
                      AppStatus status_to_update);
VALA_EXTERN gboolean snapshot_repo_has_space (SnapshotRepo* self,
                                  guint64 needed);
VALA_EXTERN GType snapshot_location_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType custom_message_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CustomMessageDialog, g_object_unref)
VALA_EXTERN CustomMessageDialog* custom_message_dialog_new (const gchar* _msg_title,
                                                const gchar* _msg_body,
                                                GtkMessageType _msg_type,
                                                GtkWindow* parent,
                                                GtkButtonsType _buttons_type);
VALA_EXTERN CustomMessageDialog* custom_message_dialog_construct (GType object_type,
                                                      const gchar* _msg_title,
                                                      const gchar* _msg_body,
                                                      GtkMessageType _msg_type,
                                                      GtkWindow* parent,
                                                      GtkButtonsType _buttons_type);
VALA_EXTERN void main_exit_app (Main* self,
                    gint exit_code);
static gboolean main_window_check_if_deletion_running (MainWindow* self);
VALA_EXTERN gboolean main_check_btrfs_layout_system (Main* self,
                                         GtkWindow* win);
VALA_EXTERN void tee_jee_gtk_helper_gtk_messagebox (const gchar* title,
                                        const gchar* message,
                                        GtkWindow* parent_win,
                                        gboolean is_error);
VALA_EXTERN GType backup_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackupWindow, g_object_unref)
VALA_EXTERN BackupWindow* backup_window_new (void);
VALA_EXTERN BackupWindow* backup_window_construct (GType object_type);
static void __lambda100_ (MainWindow* self);
static void ___lambda100__gtk_widget_destroy (GtkWidget* _sender,
                                       gpointer self);
VALA_EXTERN gboolean snapshot_repo_has_snapshots (SnapshotRepo* self);
VALA_EXTERN GeeArrayList* snapshot_list_box_selected_snapshots (SnapshotListBox* self);
VALA_EXTERN GType fs_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FsTabEntry, g_object_unref)
VALA_EXTERN GType crypt_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CryptTabEntry, g_object_unref)
VALA_EXTERN gchar* snapshot_get_date_formatted (Snapshot* self);
VALA_EXTERN GType delete_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteWindow, g_object_unref)
VALA_EXTERN DeleteWindow* delete_window_new (void);
VALA_EXTERN DeleteWindow* delete_window_construct (GType object_type);
static void __lambda135_ (MainWindow* self);
static void ___lambda135__gtk_widget_destroy (GtkWidget* _sender,
                                       gpointer self);
VALA_EXTERN void snapshot_mark_for_deletion (Snapshot* self);
VALA_EXTERN gboolean snapshot_repo_load_snapshots (SnapshotRepo* self);
VALA_EXTERN gchar* snapshot_repo_get_snapshots_path (SnapshotRepo* self);
VALA_EXTERN gboolean tee_jee_system_exo_open_folder (const gchar* dir_path,
                                         gboolean xdg_open_try_first);
VALA_EXTERN gchar* snapshot_get_rsync_log_file (Snapshot* self);
VALA_EXTERN gchar* snapshot_get_rsync_restore_log_file (Snapshot* self);
VALA_EXTERN gboolean tee_jee_file_system_file_exists (const gchar* file_path);
VALA_EXTERN GType rsync_log_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncLogWindow, g_object_unref)
VALA_EXTERN RsyncLogWindow* rsync_log_window_new (const gchar* _rsync_log_file);
VALA_EXTERN RsyncLogWindow* rsync_log_window_construct (GType object_type,
                                            const gchar* _rsync_log_file);
static void _____lambda143_ (MainWindow* self);
static void ______lambda143__gtk_widget_destroy (GtkWidget* _sender,
                                          gpointer self);
static void main_window_restore (MainWindow* self);
static void ___lambda92_ (MainWindow* self);
static void ____lambda92__gtk_widget_destroy (GtkWidget* _sender,
                                       gpointer self);
VALA_EXTERN void main_init_mount_list (Main* self);
VALA_EXTERN GType restore_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RestoreWindow, g_object_unref)
VALA_EXTERN RestoreWindow* restore_window_new (void);
VALA_EXTERN RestoreWindow* restore_window_construct (GType object_type);
static void __lambda134_ (MainWindow* self);
static void ___lambda134__gtk_widget_destroy (GtkWidget* _sender,
                                       gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN GType settings_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsWindow, g_object_unref)
VALA_EXTERN SettingsWindow* settings_window_new (void);
VALA_EXTERN SettingsWindow* settings_window_construct (GType object_type);
static void __lambda141_ (Block4Data* _data4_);
static void main_window_settings_changed (MainWindow* self,
                                   gboolean btrfs_mode_prev);
static void ___lambda141__gtk_widget_destroy (GtkWidget* _sender,
                                       gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
VALA_EXTERN GType setup_wizard_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SetupWizardWindow, g_object_unref)
VALA_EXTERN SetupWizardWindow* setup_wizard_window_new (void);
VALA_EXTERN SetupWizardWindow* setup_wizard_window_construct (GType object_type);
static void __lambda86_ (Block5Data* _data5_);
static void ___lambda86__gtk_widget_destroy (GtkWidget* _sender,
                                      gpointer self);
VALA_EXTERN SnapshotRepo* snapshot_repo_new_from_null (void);
VALA_EXTERN SnapshotRepo* snapshot_repo_construct_from_null (GType object_type);
VALA_EXTERN void main_save_app_config (Main* self);
VALA_EXTERN gboolean tee_jee_system_xdg_open (const gchar* file);
static gboolean _tee_jee_system_xdg_open_gtk_about_dialog_activate_link (GtkAboutDialog* _sender,
                                                                  const gchar* uri,
                                                                  gpointer self);
VALA_EXTERN void tee_jee_gtk_helper_gtk_set_busy (gboolean busy,
                                      GtkWindow* win);
VALA_EXTERN void snapshot_repo_check_status (SnapshotRepo* self);
VALA_EXTERN Snapshot* snapshot_repo_get_latest_snapshot (SnapshotRepo* self,
                                             const gchar* tag,
                                             const gchar* sys_uuid);
VALA_EXTERN Snapshot* snapshot_repo_get_oldest_snapshot (SnapshotRepo* self,
                                             const gchar* tag,
                                             const gchar* sys_uuid);
static void main_window_set_shield_label (MainWindow* self,
                                   const gchar* text,
                                   gboolean is_bold,
                                   gboolean is_italic,
                                   gboolean is_large);
static void main_window_set_shield_subnote (MainWindow* self,
                                     const gchar* text,
                                     gboolean is_bold,
                                     gboolean is_italic,
                                     gboolean is_large);
VALA_EXTERN gboolean main_get_scheduled (Main* self);
static gchar* main_window_format_text_large (MainWindow* self,
                                      const gchar* text);
VALA_EXTERN gchar* tee_jee_gtk_helper_format_text (const gchar* text,
                                       gboolean bold,
                                       gboolean italic,
                                       gboolean large);
VALA_EXTERN gchar* tee_jee_file_system_format_file_size (guint64 size,
                                             gboolean binary_units,
                                             const gchar* unit,
                                             gboolean show_units,
                                             gint decimals);
VALA_EXTERN guint64 device_get_free_bytes (Device* self);
VALA_EXTERN gchar* tee_jee_misc_escape_html (const gchar* html);
static void main_window_finalize (GObject * obj);
static GType main_window_get_type_once (void);

static inline gpointer
main_window_get_instance_private (MainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, MainWindow_private_offset);
}

static gboolean
_main_window_on_delete_event_gtk_widget_delete_event (GtkWidget* _sender,
                                                      GdkEventAny* event,
                                                      gpointer self)
{
	gboolean result;
	result = main_window_on_delete_event ((MainWindow*) self, event);
	return result;
}

static gboolean
_main_window_init_delayed_gsource_func (gpointer self)
{
	gboolean result;
	result = main_window_init_delayed ((MainWindow*) self);
	return result;
}

MainWindow*
main_window_construct (GType object_type)
{
	MainWindow * self = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	Main* _tmp5_;
	self = (MainWindow*) g_object_new (object_type, NULL);
	tee_jee_logging_log_debug ("MainWindow: MainWindow()");
	gtk_window_set_title ((GtkWindow*) self, AppName);
	g_object_set ((GtkWindow*) self, "window-position", GTK_WIN_POS_CENTER, NULL);
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	gtk_window_set_default_size ((GtkWindow*) self, self->priv->def_width, self->priv->def_height);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) _main_window_on_delete_event_gtk_widget_delete_event, self, 0);
	_tmp0_ = icon_manager_lookup ("timeshift", 16, FALSE, FALSE, 1);
	_tmp1_ = _tmp0_;
	gtk_window_set_icon ((GtkWindow*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->vbox_main);
	self->priv->vbox_main = _tmp2_;
	_tmp3_ = self->priv->vbox_main;
	g_object_set ((GtkWidget*) _tmp3_, "margin", 0, NULL);
	_tmp4_ = self->priv->vbox_main;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp4_);
	main_window_init_ui_toolbar (self);
	main_window_init_ui_snapshot_list (self);
	main_window_init_ui_statusbar (self);
	_tmp5_ = App;
	if (main_live_system (_tmp5_)) {
		GtkToolButton* _tmp6_;
		GtkToolButton* _tmp7_;
		_tmp6_ = self->priv->btn_backup;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, FALSE);
		_tmp7_ = self->priv->btn_settings;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, FALSE);
	}
	self->priv->tmr_init = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _main_window_init_delayed_gsource_func, g_object_ref (self), g_object_unref);
	tee_jee_logging_log_debug ("MainWindow: MainWindow(): exit");
	return self;
}

MainWindow*
main_window_new (void)
{
	return main_window_construct (TYPE_MAIN_WINDOW);
}

static gboolean
main_window_init_delayed (MainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	Main* _tmp1_;
	SnapshotRepo* _tmp2_;
	Main* _tmp14_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->tmr_init > ((guint) 0)) {
		g_source_remove (self->priv->tmr_init);
		self->priv->tmr_init = (guint) 0;
	}
	tee_jee_logging_log_debug ("MainWindow(): init_delayed()");
	_tmp1_ = App;
	_tmp2_ = _tmp1_->repo;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Main* _tmp3_;
		SnapshotRepo* _tmp4_;
		_tmp3_ = App;
		_tmp4_ = _tmp3_->repo;
		_tmp0_ = !snapshot_repo_available (_tmp4_);
	}
	if (_tmp0_) {
		Main* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp5_ = App;
		_tmp6_ = _tmp5_->backup_parent_uuid;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_ > 0) {
			Main* _tmp9_;
			Main* _tmp10_;
			const gchar* _tmp11_;
			Main* _tmp12_;
			SnapshotRepo* _tmp13_;
			tee_jee_logging_log_debug ("repo: creating from parent uuid");
			_tmp9_ = App;
			_tmp10_ = App;
			_tmp11_ = _tmp10_->backup_parent_uuid;
			_tmp12_ = App;
			_tmp13_ = snapshot_repo_new_from_uuid (_tmp11_, (GtkWindow*) self, _tmp12_->btrfs_mode);
			_g_object_unref0 (_tmp9_->repo);
			_tmp9_->repo = _tmp13_;
		}
	}
	main_window_refresh_all (self);
	_tmp14_ = App;
	if (_tmp14_->first_run) {
		main_window_btn_wizard_clicked (self);
	}
	tee_jee_logging_log_debug ("MainWindow(): init_delayed(): exit");
	result = FALSE;
	return result;
}

static void
_main_window_create_snapshot_gtk_tool_button_clicked (GtkToolButton* _sender,
                                                      gpointer self)
{
	main_window_create_snapshot ((MainWindow*) self);
}

static void
_main_window_btn_restore_clicked_gtk_tool_button_clicked (GtkToolButton* _sender,
                                                          gpointer self)
{
	main_window_btn_restore_clicked ((MainWindow*) self);
}

static void
_main_window_delete_selected_gtk_tool_button_clicked (GtkToolButton* _sender,
                                                      gpointer self)
{
	main_window_delete_selected ((MainWindow*) self);
}

static void
_main_window_browse_selected_gtk_tool_button_clicked (GtkToolButton* _sender,
                                                      gpointer self)
{
	main_window_browse_selected ((MainWindow*) self);
}

static void
_main_window_btn_settings_clicked_gtk_tool_button_clicked (GtkToolButton* _sender,
                                                           gpointer self)
{
	main_window_btn_settings_clicked ((MainWindow*) self);
}

static void
_main_window_btn_wizard_clicked_gtk_tool_button_clicked (GtkToolButton* _sender,
                                                         gpointer self)
{
	main_window_btn_wizard_clicked ((MainWindow*) self);
}

static void
__lambda142_ (MainWindow* self)
{
	main_window_menu_extra_popup (self, NULL);
}

static void
___lambda142__gtk_tool_button_clicked (GtkToolButton* _sender,
                                       gpointer self)
{
	__lambda142_ ((MainWindow*) self);
}

static void
main_window_init_ui_toolbar (MainWindow* self)
{
	GtkToolbar* _tmp0_;
	GtkToolbar* _tmp1_;
	GtkToolbar* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkBox* _tmp4_;
	GtkToolbar* _tmp5_;
	GtkImage* img = NULL;
	GtkImage* _tmp6_;
	GtkImage* _tmp7_;
	GtkToolButton* _tmp8_;
	GtkToolButton* _tmp9_;
	GtkToolButton* _tmp10_;
	GtkToolButton* _tmp11_;
	GtkToolbar* _tmp12_;
	GtkToolButton* _tmp13_;
	GtkToolButton* _tmp14_;
	GtkImage* _tmp15_;
	GtkImage* _tmp16_;
	GtkToolButton* _tmp17_;
	GtkToolButton* _tmp18_;
	GtkToolButton* _tmp19_;
	GtkToolButton* _tmp20_;
	GtkToolbar* _tmp21_;
	GtkToolButton* _tmp22_;
	GtkToolButton* _tmp23_;
	GtkImage* _tmp24_;
	GtkImage* _tmp25_;
	GtkToolButton* _tmp26_;
	GtkToolButton* _tmp27_;
	GtkToolButton* _tmp28_;
	GtkToolButton* _tmp29_;
	GtkToolbar* _tmp30_;
	GtkToolButton* _tmp31_;
	GtkToolButton* _tmp32_;
	GtkImage* _tmp33_;
	GtkImage* _tmp34_;
	GtkToolButton* _tmp35_;
	GtkToolButton* _tmp36_;
	GtkToolButton* _tmp37_;
	GtkToolButton* _tmp38_;
	GtkToolbar* _tmp39_;
	GtkToolButton* _tmp40_;
	GtkToolButton* _tmp41_;
	GtkImage* _tmp42_;
	GtkImage* _tmp43_;
	GtkToolButton* _tmp44_;
	GtkToolButton* _tmp45_;
	GtkToolButton* _tmp46_;
	GtkToolButton* _tmp47_;
	GtkToolbar* _tmp48_;
	GtkToolButton* _tmp49_;
	GtkToolButton* _tmp50_;
	GtkImage* _tmp51_;
	GtkImage* _tmp52_;
	GtkToolButton* _tmp53_;
	GtkToolButton* _tmp54_;
	GtkToolButton* _tmp55_;
	GtkToolButton* _tmp56_;
	GtkToolbar* _tmp57_;
	GtkToolButton* _tmp58_;
	GtkToolButton* _tmp59_;
	GtkSeparatorToolItem* separator = NULL;
	GtkSeparatorToolItem* _tmp60_;
	GtkToolbar* _tmp61_;
	GtkImage* _tmp62_;
	GtkToolButton* button = NULL;
	GtkImage* _tmp63_;
	GtkToolButton* _tmp64_;
	GtkToolbar* _tmp65_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->toolbar);
	self->priv->toolbar = _tmp0_;
	_tmp1_ = self->priv->toolbar;
	g_object_set (_tmp1_, "toolbar-style", GTK_TOOLBAR_BOTH, NULL);
	_tmp2_ = self->priv->toolbar;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_add_class (_tmp3_, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
	_tmp4_ = self->priv->vbox_main;
	_tmp5_ = self->priv->toolbar;
	gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = (GtkImage*) gtk_image_new_from_icon_name ("document-save-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp6_);
	img = _tmp6_;
	_tmp7_ = img;
	_tmp8_ = (GtkToolButton*) gtk_tool_button_new ((GtkWidget*) _tmp7_, NULL);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->btn_backup);
	self->priv->btn_backup = _tmp8_;
	_tmp9_ = self->priv->btn_backup;
	gtk_tool_item_set_is_important ((GtkToolItem*) _tmp9_, TRUE);
	_tmp10_ = self->priv->btn_backup;
	gtk_tool_button_set_label (_tmp10_, _ ("Create"));
	_tmp11_ = self->priv->btn_backup;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp11_, _ ("Create snapshot of current system"));
	_tmp12_ = self->priv->toolbar;
	_tmp13_ = self->priv->btn_backup;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->btn_backup;
	g_signal_connect_object (_tmp14_, "clicked", (GCallback) _main_window_create_snapshot_gtk_tool_button_clicked, self, 0);
	_tmp15_ = (GtkImage*) gtk_image_new_from_icon_name ("document-open-recent-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (img);
	img = _tmp15_;
	_tmp16_ = img;
	_tmp17_ = (GtkToolButton*) gtk_tool_button_new ((GtkWidget*) _tmp16_, NULL);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->btn_restore);
	self->priv->btn_restore = _tmp17_;
	_tmp18_ = self->priv->btn_restore;
	gtk_tool_item_set_is_important ((GtkToolItem*) _tmp18_, TRUE);
	_tmp19_ = self->priv->btn_restore;
	gtk_tool_button_set_label (_tmp19_, _ ("Restore"));
	_tmp20_ = self->priv->btn_restore;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp20_, _ ("Restore selected snapshot"));
	_tmp21_ = self->priv->toolbar;
	_tmp22_ = self->priv->btn_restore;
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = self->priv->btn_restore;
	g_signal_connect_object (_tmp23_, "clicked", (GCallback) _main_window_btn_restore_clicked_gtk_tool_button_clicked, self, 0);
	_tmp24_ = (GtkImage*) gtk_image_new_from_icon_name ("edit-delete-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (img);
	img = _tmp24_;
	_tmp25_ = img;
	_tmp26_ = (GtkToolButton*) gtk_tool_button_new ((GtkWidget*) _tmp25_, NULL);
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->btn_delete_snapshot);
	self->priv->btn_delete_snapshot = _tmp26_;
	_tmp27_ = self->priv->btn_delete_snapshot;
	gtk_tool_item_set_is_important ((GtkToolItem*) _tmp27_, TRUE);
	_tmp28_ = self->priv->btn_delete_snapshot;
	gtk_tool_button_set_label (_tmp28_, _ ("Delete"));
	_tmp29_ = self->priv->btn_delete_snapshot;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp29_, _ ("Delete selected snapshot"));
	_tmp30_ = self->priv->toolbar;
	_tmp31_ = self->priv->btn_delete_snapshot;
	gtk_container_add ((GtkContainer*) _tmp30_, (GtkWidget*) _tmp31_);
	_tmp32_ = self->priv->btn_delete_snapshot;
	g_signal_connect_object (_tmp32_, "clicked", (GCallback) _main_window_delete_selected_gtk_tool_button_clicked, self, 0);
	_tmp33_ = (GtkImage*) gtk_image_new_from_icon_name ("folder-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (img);
	img = _tmp33_;
	_tmp34_ = img;
	_tmp35_ = (GtkToolButton*) gtk_tool_button_new ((GtkWidget*) _tmp34_, NULL);
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->priv->btn_browse_snapshot);
	self->priv->btn_browse_snapshot = _tmp35_;
	_tmp36_ = self->priv->btn_browse_snapshot;
	gtk_tool_item_set_is_important ((GtkToolItem*) _tmp36_, TRUE);
	_tmp37_ = self->priv->btn_browse_snapshot;
	gtk_tool_button_set_label (_tmp37_, _ ("Browse"));
	_tmp38_ = self->priv->btn_browse_snapshot;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp38_, _ ("Browse selected snapshot"));
	_tmp39_ = self->priv->toolbar;
	_tmp40_ = self->priv->btn_browse_snapshot;
	gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = self->priv->btn_browse_snapshot;
	g_signal_connect_object (_tmp41_, "clicked", (GCallback) _main_window_browse_selected_gtk_tool_button_clicked, self, 0);
	_tmp42_ = (GtkImage*) gtk_image_new_from_icon_name ("preferences-system-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp42_);
	_g_object_unref0 (img);
	img = _tmp42_;
	_tmp43_ = img;
	_tmp44_ = (GtkToolButton*) gtk_tool_button_new ((GtkWidget*) _tmp43_, NULL);
	g_object_ref_sink (_tmp44_);
	_g_object_unref0 (self->priv->btn_settings);
	self->priv->btn_settings = _tmp44_;
	_tmp45_ = self->priv->btn_settings;
	gtk_tool_item_set_is_important ((GtkToolItem*) _tmp45_, TRUE);
	_tmp46_ = self->priv->btn_settings;
	gtk_tool_button_set_label (_tmp46_, _ ("Settings"));
	_tmp47_ = self->priv->btn_settings;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp47_, _ ("Settings"));
	_tmp48_ = self->priv->toolbar;
	_tmp49_ = self->priv->btn_settings;
	gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _tmp49_);
	_tmp50_ = self->priv->btn_settings;
	g_signal_connect_object (_tmp50_, "clicked", (GCallback) _main_window_btn_settings_clicked_gtk_tool_button_clicked, self, 0);
	_tmp51_ = (GtkImage*) gtk_image_new_from_icon_name ("emblem-default-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp51_);
	_g_object_unref0 (img);
	img = _tmp51_;
	_tmp52_ = img;
	_tmp53_ = (GtkToolButton*) gtk_tool_button_new ((GtkWidget*) _tmp52_, NULL);
	g_object_ref_sink (_tmp53_);
	_g_object_unref0 (self->priv->btn_wizard);
	self->priv->btn_wizard = _tmp53_;
	_tmp54_ = self->priv->btn_wizard;
	gtk_tool_item_set_is_important ((GtkToolItem*) _tmp54_, TRUE);
	_tmp55_ = self->priv->btn_wizard;
	gtk_tool_button_set_label (_tmp55_, _ ("Wizard"));
	_tmp56_ = self->priv->btn_wizard;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp56_, _ ("Settings wizard"));
	_tmp57_ = self->priv->toolbar;
	_tmp58_ = self->priv->btn_wizard;
	gtk_container_add ((GtkContainer*) _tmp57_, (GtkWidget*) _tmp58_);
	_tmp59_ = self->priv->btn_wizard;
	g_signal_connect_object (_tmp59_, "clicked", (GCallback) _main_window_btn_wizard_clicked_gtk_tool_button_clicked, self, 0);
	_tmp60_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	g_object_ref_sink (_tmp60_);
	separator = _tmp60_;
	gtk_separator_tool_item_set_draw (separator, FALSE);
	gtk_tool_item_set_expand ((GtkToolItem*) separator, TRUE);
	_tmp61_ = self->priv->toolbar;
	gtk_container_add ((GtkContainer*) _tmp61_, (GtkWidget*) separator);
	_tmp62_ = (GtkImage*) gtk_image_new_from_icon_name ("open-menu-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp62_);
	_g_object_unref0 (img);
	img = _tmp62_;
	_tmp63_ = img;
	_tmp64_ = (GtkToolButton*) gtk_tool_button_new ((GtkWidget*) _tmp63_, NULL);
	g_object_ref_sink (_tmp64_);
	button = _tmp64_;
	gtk_tool_button_set_label (button, _ ("Menu"));
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) button, _ ("Open Menu"));
	_tmp65_ = self->priv->toolbar;
	gtk_container_add ((GtkContainer*) _tmp65_, (GtkWidget*) button);
	g_signal_connect_object (button, "clicked", (GCallback) ___lambda142__gtk_tool_button_clicked, self, 0);
	_g_object_unref0 (button);
	_g_object_unref0 (separator);
	_g_object_unref0 (img);
}

static void
_main_window_delete_selected_snapshot_list_box_delete_selected (SnapshotListBox* _sender,
                                                                gpointer self)
{
	main_window_delete_selected ((MainWindow*) self);
}

static void
_main_window_mark_selected_snapshot_list_box_mark_selected (SnapshotListBox* _sender,
                                                            gpointer self)
{
	main_window_mark_selected ((MainWindow*) self);
}

static void
_main_window_browse_selected_snapshot_list_box_browse_selected (SnapshotListBox* _sender,
                                                                gpointer self)
{
	main_window_browse_selected ((MainWindow*) self);
}

static void
_main_window_view_snapshot_log_snapshot_list_box_view_snapshot_log (SnapshotListBox* _sender,
                                                                    gboolean show_restore_log,
                                                                    gpointer self)
{
	main_window_view_snapshot_log ((MainWindow*) self, show_restore_log);
}

static void
main_window_init_ui_snapshot_list (MainWindow* self)
{
	SnapshotListBox* _tmp0_;
	SnapshotListBox* _tmp1_;
	GtkBox* _tmp2_;
	SnapshotListBox* _tmp3_;
	SnapshotListBox* _tmp4_;
	SnapshotListBox* _tmp5_;
	SnapshotListBox* _tmp6_;
	SnapshotListBox* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = snapshot_list_box_new ((GtkWindow*) self);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->snapshot_list_box);
	self->priv->snapshot_list_box = _tmp0_;
	_tmp1_ = self->priv->snapshot_list_box;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->vbox_main;
	_tmp3_ = self->priv->snapshot_list_box;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->snapshot_list_box;
	g_signal_connect_object (_tmp4_, "delete-selected", (GCallback) _main_window_delete_selected_snapshot_list_box_delete_selected, self, 0);
	_tmp5_ = self->priv->snapshot_list_box;
	g_signal_connect_object (_tmp5_, "mark-selected", (GCallback) _main_window_mark_selected_snapshot_list_box_mark_selected, self, 0);
	_tmp6_ = self->priv->snapshot_list_box;
	g_signal_connect_object (_tmp6_, "browse-selected", (GCallback) _main_window_browse_selected_snapshot_list_box_browse_selected, self, 0);
	_tmp7_ = self->priv->snapshot_list_box;
	g_signal_connect_object (_tmp7_, "view-snapshot-log", (GCallback) _main_window_view_snapshot_log_snapshot_list_box_view_snapshot_log, self, 0);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
main_window_init_ui_statusbar (MainWindow* self)
{
	GtkBox* hbox_status = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkScrolledWindow* scrolled = NULL;
	GtkScrolledWindow* _tmp2_;
	GtkScrolledWindow* _tmp3_;
	GtkScrolledWindow* _tmp4_;
	GtkScrolledWindow* _tmp5_;
	GtkScrolledWindow* _tmp6_;
	GtkScrolledWindow* _tmp7_;
	GtkBox* box = NULL;
	GtkBox* _tmp8_;
	GtkScrolledWindow* _tmp9_;
	GtkImage* _tmp10_;
	GtkImage* _tmp11_;
	GtkImage* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	cairo_surface_t* _tmp15_;
	cairo_surface_t* _tmp16_;
	GtkImage* _tmp17_;
	GtkBox* vbox = NULL;
	GtkBox* _tmp18_;
	GtkBox* _tmp19_;
	GtkBox* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkBox* _tmp24_;
	GtkLabel* _tmp25_;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	GtkLabel* _tmp28_;
	GtkLabel* _tmp29_;
	GtkScrolledWindow* _tmp30_;
	GtkScrolledWindow* _tmp31_;
	GtkScrolledWindow* _tmp32_;
	GtkScrolledWindow* _tmp33_;
	GtkScrolledWindow* _tmp34_;
	GtkBox* _tmp35_;
	GtkBox* _tmp36_;
	GtkBox* _tmp37_;
	GtkBox* _tmp38_;
	GtkScrolledWindow* _tmp39_;
	GtkBox* _tmp40_;
	GtkScrolledWindow* _tmp41_;
	GtkScrolledWindow* _tmp42_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp43_;
	GtkLabel* _tmp44_;
	GtkLabel* _tmp45_;
	GtkBox* _tmp46_;
	GtkLabel* _tmp47_;
	GtkLabel* _tmp48_;
	GtkLabel* _tmp49_;
	GtkLabel* _tmp50_;
	GtkLabel* _tmp51_;
	GtkBox* _tmp52_;
	GtkLabel* _tmp53_;
	GtkLabel* _tmp54_;
	GtkLabel* _tmp55_;
	GtkLabel* _tmp56_;
	GtkBox* _tmp57_;
	GtkLabel* _tmp58_;
	GtkLabel* _tmp59_;
	GtkLabel* _tmp60_;
	GtkScrolledWindow* _tmp61_;
	GtkScrolledWindow* _tmp62_;
	GtkScrolledWindow* _tmp63_;
	GtkScrolledWindow* _tmp64_;
	GtkScrolledWindow* _tmp65_;
	GtkBox* _tmp66_;
	GtkBox* _tmp67_;
	GtkBox* _tmp68_;
	GtkBox* _tmp69_;
	GtkScrolledWindow* _tmp70_;
	GtkBox* _tmp71_;
	GtkScrolledWindow* _tmp72_;
	GtkScrolledWindow* _tmp73_;
	GtkLabel* _tmp74_;
	GtkLabel* _tmp75_;
	GtkLabel* _tmp76_;
	GtkBox* _tmp77_;
	GtkLabel* _tmp78_;
	GtkLabel* _tmp79_;
	GtkLabel* _tmp80_;
	GtkLabel* _tmp81_;
	GtkLabel* _tmp82_;
	GtkBox* _tmp83_;
	GtkLabel* _tmp84_;
	GtkLabel* _tmp85_;
	GtkLabel* _tmp86_;
	GtkLabel* _tmp87_;
	GtkBox* _tmp88_;
	GtkLabel* _tmp89_;
	GtkLabel* _tmp90_;
	GtkLabel* _tmp91_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp0_);
	hbox_status = _tmp0_;
	g_object_set ((GtkWidget*) hbox_status, "margin", 6, NULL);
	gtk_widget_set_margin_top ((GtkWidget*) hbox_status, 0);
	_tmp1_ = self->priv->vbox_main;
	gtk_container_add ((GtkContainer*) _tmp1_, (GtkWidget*) hbox_status);
	_tmp2_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp2_);
	scrolled = _tmp2_;
	_tmp3_ = scrolled;
	g_object_set (_tmp3_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	_tmp4_ = scrolled;
	g_object_set (_tmp4_, "vscrollbar-policy", GTK_POLICY_NEVER, NULL);
	_tmp5_ = scrolled;
	gtk_container_add ((GtkContainer*) hbox_status, (GtkWidget*) _tmp5_);
	_tmp6_ = scrolled;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->statusbar);
	self->priv->statusbar = _tmp7_;
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp8_);
	box = _tmp8_;
	g_object_set ((GtkWidget*) box, "margin", 6, NULL);
	_tmp9_ = scrolled;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) box);
	_tmp10_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->img_shield);
	self->priv->img_shield = _tmp10_;
	_tmp11_ = self->priv->img_shield;
	_tmp12_ = self->priv->img_shield;
	_tmp13_ = gtk_widget_get_scale_factor ((GtkWidget*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = icon_manager_lookup_surface (ICON_MANAGER_SHIELD_HIGH, ICON_MANAGER_SHIELD_ICON_SIZE, _tmp14_, FALSE, FALSE);
	_tmp16_ = _tmp15_;
	g_object_set (_tmp11_, "surface", _tmp16_, NULL);
	_cairo_surface_destroy0 (_tmp16_);
	_tmp17_ = self->priv->img_shield;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp17_);
	_tmp18_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp18_);
	vbox = _tmp18_;
	_tmp19_ = vbox;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp19_);
	_tmp20_ = vbox;
	_tmp21_ = tee_jee_gtk_helper_add_label (_tmp20_, "", FALSE, FALSE, FALSE);
	_g_object_unref0 (self->priv->lbl_shield);
	self->priv->lbl_shield = _tmp21_;
	_tmp22_ = self->priv->lbl_shield;
	gtk_label_set_yalign (_tmp22_, 0.5f);
	_tmp23_ = self->priv->lbl_shield;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp23_, TRUE);
	_tmp24_ = vbox;
	_tmp25_ = tee_jee_gtk_helper_add_label (_tmp24_, "", FALSE, FALSE, FALSE);
	_g_object_unref0 (self->priv->lbl_shield_subnote);
	self->priv->lbl_shield_subnote = _tmp25_;
	_tmp26_ = self->priv->lbl_shield_subnote;
	gtk_label_set_yalign (_tmp26_, 0.5f);
	_tmp27_ = self->priv->lbl_shield_subnote;
	g_object_set (_tmp27_, "wrap", TRUE, NULL);
	_tmp28_ = self->priv->lbl_shield_subnote;
	g_object_set (_tmp28_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	_tmp29_ = self->priv->lbl_shield_subnote;
	gtk_label_set_max_width_chars (_tmp29_, 50);
	_tmp30_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (scrolled);
	scrolled = _tmp30_;
	_tmp31_ = scrolled;
	g_object_set (_tmp31_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	_tmp32_ = scrolled;
	g_object_set (_tmp32_, "vscrollbar-policy", GTK_POLICY_NEVER, NULL);
	_tmp33_ = scrolled;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp33_, TRUE);
	_tmp34_ = scrolled;
	gtk_container_add ((GtkContainer*) hbox_status, (GtkWidget*) _tmp34_);
	_tmp35_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (vbox);
	vbox = _tmp35_;
	_tmp36_ = vbox;
	g_object_set ((GtkWidget*) _tmp36_, "margin", 6, NULL);
	_tmp37_ = vbox;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp37_, 12);
	_tmp38_ = vbox;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp38_, 12);
	_tmp39_ = scrolled;
	_tmp40_ = vbox;
	gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = scrolled;
	_tmp42_ = _g_object_ref0 (_tmp41_);
	_g_object_unref0 (self->priv->scrolled_snap_count);
	self->priv->scrolled_snap_count = _tmp42_;
	_tmp43_ = (GtkLabel*) gtk_label_new ("<b>" "0.0%" "</b>");
	g_object_ref_sink (_tmp43_);
	label = _tmp43_;
	_tmp44_ = label;
	gtk_label_set_use_markup (_tmp44_, TRUE);
	_tmp45_ = label;
	gtk_label_set_justify (_tmp45_, GTK_JUSTIFY_CENTER);
	_tmp46_ = vbox;
	_tmp47_ = label;
	gtk_box_pack_start (_tmp46_, (GtkWidget*) _tmp47_, TRUE, TRUE, (guint) 0);
	_tmp48_ = label;
	_tmp49_ = _g_object_ref0 (_tmp48_);
	_g_object_unref0 (self->priv->lbl_snap_count);
	self->priv->lbl_snap_count = _tmp49_;
	_tmp50_ = (GtkLabel*) gtk_label_new (_ ("Snapshots"));
	g_object_ref_sink (_tmp50_);
	_g_object_unref0 (label);
	label = _tmp50_;
	_tmp51_ = label;
	gtk_label_set_justify (_tmp51_, GTK_JUSTIFY_CENTER);
	_tmp52_ = vbox;
	_tmp53_ = label;
	gtk_box_pack_start (_tmp52_, (GtkWidget*) _tmp53_, FALSE, FALSE, (guint) 0);
	_tmp54_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp54_);
	_g_object_unref0 (label);
	label = _tmp54_;
	_tmp55_ = label;
	gtk_label_set_use_markup (_tmp55_, TRUE);
	_tmp56_ = label;
	gtk_label_set_justify (_tmp56_, GTK_JUSTIFY_CENTER);
	_tmp57_ = vbox;
	_tmp58_ = label;
	gtk_box_pack_start (_tmp57_, (GtkWidget*) _tmp58_, FALSE, FALSE, (guint) 0);
	_tmp59_ = label;
	_tmp60_ = _g_object_ref0 (_tmp59_);
	_g_object_unref0 (self->priv->lbl_snap_count_subnote);
	self->priv->lbl_snap_count_subnote = _tmp60_;
	_tmp61_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp61_);
	_g_object_unref0 (scrolled);
	scrolled = _tmp61_;
	_tmp62_ = scrolled;
	g_object_set (_tmp62_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	_tmp63_ = scrolled;
	g_object_set (_tmp63_, "vscrollbar-policy", GTK_POLICY_NEVER, NULL);
	_tmp64_ = scrolled;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp64_, TRUE);
	_tmp65_ = scrolled;
	gtk_container_add ((GtkContainer*) hbox_status, (GtkWidget*) _tmp65_);
	_tmp66_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp66_);
	_g_object_unref0 (vbox);
	vbox = _tmp66_;
	_tmp67_ = vbox;
	g_object_set ((GtkWidget*) _tmp67_, "margin", 6, NULL);
	_tmp68_ = vbox;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp68_, 12);
	_tmp69_ = vbox;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp69_, 12);
	_tmp70_ = scrolled;
	_tmp71_ = vbox;
	gtk_container_add ((GtkContainer*) _tmp70_, (GtkWidget*) _tmp71_);
	_tmp72_ = scrolled;
	_tmp73_ = _g_object_ref0 (_tmp72_);
	_g_object_unref0 (self->priv->scrolled_free_space);
	self->priv->scrolled_free_space = _tmp73_;
	_tmp74_ = (GtkLabel*) gtk_label_new ("<b>" "0.0%" "</b>");
	g_object_ref_sink (_tmp74_);
	_g_object_unref0 (label);
	label = _tmp74_;
	_tmp75_ = label;
	gtk_label_set_use_markup (_tmp75_, TRUE);
	_tmp76_ = label;
	gtk_label_set_justify (_tmp76_, GTK_JUSTIFY_CENTER);
	_tmp77_ = vbox;
	_tmp78_ = label;
	gtk_box_pack_start (_tmp77_, (GtkWidget*) _tmp78_, TRUE, TRUE, (guint) 0);
	_tmp79_ = label;
	_tmp80_ = _g_object_ref0 (_tmp79_);
	_g_object_unref0 (self->priv->lbl_free_space);
	self->priv->lbl_free_space = _tmp80_;
	_tmp81_ = (GtkLabel*) gtk_label_new (_ ("Available"));
	g_object_ref_sink (_tmp81_);
	_g_object_unref0 (label);
	label = _tmp81_;
	_tmp82_ = label;
	gtk_label_set_justify (_tmp82_, GTK_JUSTIFY_CENTER);
	_tmp83_ = vbox;
	_tmp84_ = label;
	gtk_box_pack_start (_tmp83_, (GtkWidget*) _tmp84_, FALSE, FALSE, (guint) 0);
	_tmp85_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp85_);
	_g_object_unref0 (label);
	label = _tmp85_;
	_tmp86_ = label;
	gtk_label_set_use_markup (_tmp86_, TRUE);
	_tmp87_ = label;
	gtk_label_set_justify (_tmp87_, GTK_JUSTIFY_CENTER);
	_tmp88_ = vbox;
	_tmp89_ = label;
	gtk_box_pack_start (_tmp88_, (GtkWidget*) _tmp89_, FALSE, FALSE, (guint) 0);
	_tmp90_ = label;
	_tmp91_ = _g_object_ref0 (_tmp90_);
	_g_object_unref0 (self->priv->lbl_free_space_subnote);
	self->priv->lbl_free_space_subnote = _tmp91_;
	_g_object_unref0 (label);
	_g_object_unref0 (vbox);
	_g_object_unref0 (box);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (hbox_status);
}

static void
_main_window_btn_view_app_logs_clicked_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                               gpointer self)
{
	main_window_btn_view_app_logs_clicked ((MainWindow*) self);
}

static void
_main_window_btn_about_clicked_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                       gpointer self)
{
	main_window_btn_about_clicked ((MainWindow*) self);
}

static gboolean
main_window_menu_extra_popup (MainWindow* self,
                              GdkEventButton* event)
{
	GtkMenu* _tmp0_;
	GtkMenu* _tmp1_;
	GtkMenuItem* menu_item = NULL;
	Main* _tmp2_;
	GtkMenuItem* _tmp7_;
	GtkMenu* _tmp8_;
	GtkMenuItem* _tmp9_;
	GtkMenuItem* _tmp10_;
	GtkMenu* _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->menu_extra);
	self->priv->menu_extra = _tmp0_;
	_tmp1_ = self->priv->menu_extra;
	gtk_menu_set_reserve_toggle_size (_tmp1_, FALSE);
	menu_item = NULL;
	_tmp2_ = App;
	if (!main_live_system (_tmp2_)) {
		GtkMenuItem* _tmp3_;
		GtkMenu* _tmp4_;
		GtkMenuItem* _tmp5_;
		GtkMenuItem* _tmp6_;
		_tmp3_ = main_window_create_menu_item (self, _ ("View TimeShift Logs"), "", "", 16, "");
		_g_object_unref0 (menu_item);
		menu_item = _tmp3_;
		_tmp4_ = self->priv->menu_extra;
		_tmp5_ = menu_item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp4_, _tmp5_);
		_tmp6_ = menu_item;
		g_signal_connect_object (_tmp6_, "activate", (GCallback) _main_window_btn_view_app_logs_clicked_gtk_menu_item_activate, self, 0);
	}
	_tmp7_ = main_window_create_menu_item (self, _ ("About"), "", "", 16, "");
	_g_object_unref0 (menu_item);
	menu_item = _tmp7_;
	_tmp8_ = self->priv->menu_extra;
	_tmp9_ = menu_item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp8_, _tmp9_);
	_tmp10_ = menu_item;
	g_signal_connect_object (_tmp10_, "activate", (GCallback) _main_window_btn_about_clicked_gtk_menu_item_activate, self, 0);
	_tmp11_ = self->priv->menu_extra;
	gtk_widget_show_all ((GtkWidget*) _tmp11_);
	if (event != NULL) {
		GtkMenu* _tmp12_;
		_tmp12_ = self->priv->menu_extra;
		gtk_menu_popup (_tmp12_, NULL, NULL, NULL, NULL, event->button, event->time);
	} else {
		GtkMenu* _tmp13_;
		_tmp13_ = self->priv->menu_extra;
		gtk_menu_popup (_tmp13_, NULL, NULL, NULL, NULL, (guint) 0, gtk_get_current_event_time ());
	}
	result = TRUE;
	_g_object_unref0 (menu_item);
	return result;
}

static GtkMenuItem*
main_window_create_menu_item (MainWindow* self,
                              const gchar* label_text,
                              const gchar* icon_name_stock,
                              const gchar* icon_name_custom,
                              gint icon_size,
                              const gchar* tooltip_text)
{
	GtkMenuItem* menu_item = NULL;
	GtkMenuItem* _tmp0_;
	GtkBox* box = NULL;
	GtkBox* _tmp1_;
	GtkMenuItem* _tmp2_;
	GtkBox* _tmp3_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gint _tmp8_;
	gint _tmp9_;
	GtkLabel* _tmp10_;
	GtkBox* _tmp11_;
	GtkLabel* _tmp12_;
	GtkMenuItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label_text != NULL, NULL);
	g_return_val_if_fail (icon_name_stock != NULL, NULL);
	g_return_val_if_fail (icon_name_custom != NULL, NULL);
	g_return_val_if_fail (tooltip_text != NULL, NULL);
	_tmp0_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp0_);
	menu_item = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
	g_object_ref_sink (_tmp1_);
	box = _tmp1_;
	_tmp2_ = menu_item;
	_tmp3_ = box;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp3_);
	_tmp4_ = (GtkLabel*) gtk_label_new (label_text);
	g_object_ref_sink (_tmp4_);
	label = _tmp4_;
	_tmp5_ = label;
	gtk_label_set_xalign (_tmp5_, (gfloat) 0.0);
	_tmp6_ = label;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp6_, 6);
	_tmp8_ = strlen (tooltip_text);
	_tmp9_ = _tmp8_;
	if (_tmp9_ > 0) {
		_tmp7_ = tooltip_text;
	} else {
		_tmp7_ = label_text;
	}
	_tmp10_ = label;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp10_, _tmp7_);
	_tmp11_ = box;
	_tmp12_ = label;
	gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
	result = menu_item;
	_g_object_unref0 (label);
	_g_object_unref0 (box);
	return result;
}

static gboolean
main_window_refresh_all (MainWindow* self)
{
	SnapshotListBox* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	main_window_ui_sensitive (self, FALSE);
	_tmp0_ = self->priv->snapshot_list_box;
	snapshot_list_box_refresh (_tmp0_);
	main_window_update_statusbar (self);
	main_window_ui_sensitive (self, TRUE);
	result = FALSE;
	return result;
}

static gboolean
main_window_on_delete_event (MainWindow* self,
                             GdkEventAny* event)
{
	guint _tmp0_;
	Main* _tmp1_;
	RsyncTask* _tmp2_;
	Main* _tmp5_;
	Main* _tmp12_;
	Main* _tmp28_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	g_signal_parse_name ("delete-event", gtk_widget_get_type (), &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _main_window_on_delete_event_gtk_widget_delete_event, self);
	_tmp1_ = App;
	_tmp2_ = _tmp1_->task;
	if (((AsyncTask*) _tmp2_)->status == APP_STATUS_RUNNING) {
		Main* _tmp3_;
		RsyncTask* _tmp4_;
		tee_jee_logging_log_error (_ ("Main window closed by user"), FALSE, FALSE);
		_tmp3_ = App;
		_tmp4_ = _tmp3_->task;
		async_task_stop ((AsyncTask*) _tmp4_, APP_STATUS_CANCELLED);
	}
	_tmp5_ = App;
	if (_tmp5_->thread_delete_running) {
		Main* _tmp6_;
		GeeArrayList* _tmp7_;
		Main* _tmp8_;
		DeleteFileTask* _tmp9_;
		_tmp6_ = App;
		_tmp7_ = _tmp6_->delete_list;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp7_);
		_tmp8_ = App;
		_tmp9_ = _tmp8_->delete_file_task;
		if (_tmp9_ != NULL) {
			Main* _tmp10_;
			DeleteFileTask* _tmp11_;
			_tmp10_ = App;
			_tmp11_ = _tmp10_->delete_file_task;
			async_task_stop ((AsyncTask*) _tmp11_, APP_STATUS_CANCELLED);
		}
	}
	_tmp12_ = App;
	if (!main_live_system (_tmp12_)) {
		gboolean _tmp13_ = FALSE;
		Main* _tmp14_;
		SnapshotRepo* _tmp15_;
		_tmp14_ = App;
		_tmp15_ = _tmp14_->repo;
		if (!snapshot_repo_available (_tmp15_)) {
			_tmp13_ = TRUE;
		} else {
			Main* _tmp16_;
			SnapshotRepo* _tmp17_;
			_tmp16_ = App;
			_tmp17_ = _tmp16_->repo;
			_tmp13_ = !snapshot_repo_has_space (_tmp17_, (guint64) 0);
		}
		if (_tmp13_) {
			gchar* title = NULL;
			Main* _tmp18_;
			SnapshotRepo* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* msg = NULL;
			gchar* _tmp22_;
			GtkMessageType type = 0;
			CustomMessageDialog* dlg = NULL;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			CustomMessageDialog* _tmp25_;
			gint response = 0;
			CustomMessageDialog* _tmp26_;
			CustomMessageDialog* _tmp27_;
			_tmp18_ = App;
			_tmp19_ = _tmp18_->repo;
			_tmp20_ = _tmp19_->status_message;
			_tmp21_ = g_strdup (_tmp20_);
			title = _tmp21_;
			_tmp22_ = g_strdup (_ ("Select another device?"));
			msg = _tmp22_;
			type = GTK_MESSAGE_ERROR;
			_tmp23_ = title;
			_tmp24_ = msg;
			_tmp25_ = custom_message_dialog_new (_tmp23_, _tmp24_, type, (GtkWindow*) self, GTK_BUTTONS_YES_NO);
			g_object_ref_sink (_tmp25_);
			dlg = _tmp25_;
			_tmp26_ = dlg;
			response = gtk_dialog_run ((GtkDialog*) _tmp26_);
			_tmp27_ = dlg;
			gtk_widget_destroy ((GtkWidget*) _tmp27_);
			if (response == ((gint) GTK_RESPONSE_YES)) {
				g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) _main_window_on_delete_event_gtk_widget_delete_event, self, 0);
				main_window_btn_wizard_clicked (self);
				result = TRUE;
				_g_object_unref0 (dlg);
				_g_free0 (msg);
				_g_free0 (title);
				return result;
			} else {
				result = FALSE;
				_g_object_unref0 (dlg);
				_g_free0 (msg);
				_g_free0 (title);
				return result;
			}
			_g_object_unref0 (dlg);
			_g_free0 (msg);
			_g_free0 (title);
		}
	}
	_tmp28_ = App;
	main_exit_app (_tmp28_, 0);
	result = FALSE;
	return result;
}

static void
__lambda100_ (MainWindow* self)
{
	main_window_refresh_all (self);
	main_window_ui_sensitive (self, TRUE);
}

static void
___lambda100__gtk_widget_destroy (GtkWidget* _sender,
                                  gpointer self)
{
	__lambda100_ ((MainWindow*) self);
}

void
main_window_create_snapshot (MainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	Main* _tmp1_;
	Main* _tmp3_;
	SnapshotRepo* _tmp4_;
	BackupWindow* win = NULL;
	BackupWindow* _tmp11_;
	BackupWindow* _tmp12_;
	BackupWindow* _tmp13_;
	g_return_if_fail (self != NULL);
	if (main_window_check_if_deletion_running (self)) {
		return;
	}
	main_window_ui_sensitive (self, FALSE);
	_tmp1_ = App;
	if (_tmp1_->btrfs_mode) {
		Main* _tmp2_;
		_tmp2_ = App;
		_tmp0_ = main_check_btrfs_layout_system (_tmp2_, (GtkWindow*) self) == FALSE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		main_window_ui_sensitive (self, TRUE);
		return;
	}
	_tmp3_ = App;
	_tmp4_ = _tmp3_->repo;
	if (!snapshot_repo_available (_tmp4_)) {
		Main* _tmp5_;
		SnapshotRepo* _tmp6_;
		const gchar* _tmp7_;
		Main* _tmp8_;
		SnapshotRepo* _tmp9_;
		const gchar* _tmp10_;
		_tmp5_ = App;
		_tmp6_ = _tmp5_->repo;
		_tmp7_ = _tmp6_->status_message;
		_tmp8_ = App;
		_tmp9_ = _tmp8_->repo;
		_tmp10_ = _tmp9_->status_details;
		tee_jee_gtk_helper_gtk_messagebox (_tmp7_, _tmp10_, (GtkWindow*) self, TRUE);
	}
	_tmp11_ = backup_window_new ();
	g_object_ref_sink (_tmp11_);
	win = _tmp11_;
	_tmp12_ = win;
	gtk_window_set_transient_for ((GtkWindow*) _tmp12_, (GtkWindow*) self);
	_tmp13_ = win;
	g_signal_connect_object ((GtkWidget*) _tmp13_, "destroy", (GCallback) ___lambda100__gtk_widget_destroy, self, 0);
	_g_object_unref0 (win);
}

static void
__lambda135_ (MainWindow* self)
{
	main_window_refresh_all (self);
	main_window_ui_sensitive (self, TRUE);
}

static void
___lambda135__gtk_widget_destroy (GtkWidget* _sender,
                                  gpointer self)
{
	__lambda135_ ((MainWindow*) self);
}

void
main_window_delete_selected (MainWindow* self)
{
	Main* _tmp0_;
	SnapshotRepo* _tmp1_;
	GtkMessageDialog* confirm_dialog = NULL;
	GtkMessageDialog* _tmp26_;
	gint confirm_response = 0;
	GtkMessageDialog* _tmp27_;
	GtkMessageDialog* _tmp28_;
	Main* _tmp29_;
	Main* _tmp55_;
	GeeArrayList* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	DeleteWindow* win = NULL;
	DeleteWindow* _tmp61_;
	DeleteWindow* _tmp62_;
	DeleteWindow* _tmp63_;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("main window: delete_selected()");
	_tmp0_ = App;
	_tmp1_ = _tmp0_->repo;
	if (!snapshot_repo_available (_tmp1_)) {
		Main* _tmp2_;
		SnapshotRepo* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = App;
		_tmp3_ = _tmp2_->repo;
		_tmp4_ = _tmp3_->status_message;
		tee_jee_gtk_helper_gtk_messagebox (_tmp4_, _ ("Select another device to delete snasphots"), (GtkWindow*) self, FALSE);
		return;
	} else {
		Main* _tmp5_;
		SnapshotRepo* _tmp6_;
		_tmp5_ = App;
		_tmp6_ = _tmp5_->repo;
		if (!snapshot_repo_has_snapshots (_tmp6_)) {
			tee_jee_gtk_helper_gtk_messagebox (_ ("No snapshots on device"), _ ("Select another device to delete snasphots"), (GtkWindow*) self, FALSE);
			return;
		}
	}
	{
		GeeArrayList* _bak_list = NULL;
		SnapshotListBox* _tmp7_;
		GeeArrayList* _tmp8_;
		gint _bak_size = 0;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _bak_index = 0;
		_tmp7_ = self->priv->snapshot_list_box;
		_tmp8_ = snapshot_list_box_selected_snapshots (_tmp7_);
		_bak_list = _tmp8_;
		_tmp9_ = _bak_list;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_bak_size = _tmp11_;
		_bak_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			Snapshot* bak = NULL;
			GeeArrayList* _tmp14_;
			gpointer _tmp15_;
			Snapshot* _tmp16_;
			_bak_index = _bak_index + 1;
			_tmp12_ = _bak_index;
			_tmp13_ = _bak_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _bak_list;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _bak_index);
			bak = (Snapshot*) _tmp15_;
			_tmp16_ = bak;
			if (_tmp16_->live) {
				gchar* title = NULL;
				gchar* _tmp17_;
				gchar* msg = NULL;
				Snapshot* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				_tmp17_ = g_strdup (_ ("Cannot Delete Live Snapshot"));
				title = _tmp17_;
				_tmp18_ = bak;
				_tmp19_ = snapshot_get_date_formatted (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strdup_printf (_ ("Snapshot '%s' is being used by the system and cannot be deleted. Resta" \
"rt the system to activate the restored snapshot."), _tmp21_);
				_tmp23_ = _tmp22_;
				_g_free0 (_tmp21_);
				msg = _tmp23_;
				_tmp24_ = title;
				_tmp25_ = msg;
				tee_jee_gtk_helper_gtk_messagebox (_tmp24_, _tmp25_, (GtkWindow*) self, FALSE);
				_g_free0 (msg);
				_g_free0 (title);
				_g_object_unref0 (bak);
				_g_object_unref0 (_bak_list);
				return;
			}
			_g_object_unref0 (bak);
		}
		_g_object_unref0 (_bak_list);
	}
	_tmp26_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, "%s", _ ("Are you sure you want to delete this snapshot?"));
	g_object_ref_sink (_tmp26_);
	confirm_dialog = _tmp26_;
	_tmp27_ = confirm_dialog;
	confirm_response = gtk_dialog_run ((GtkDialog*) _tmp27_);
	_tmp28_ = confirm_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp28_);
	if (confirm_response != ((gint) GTK_RESPONSE_YES)) {
		_g_object_unref0 (confirm_dialog);
		return;
	}
	_tmp29_ = App;
	if (!_tmp29_->thread_delete_running) {
		{
			GeeArrayList* _item_list = NULL;
			SnapshotListBox* _tmp30_;
			GeeArrayList* _tmp31_;
			gint _item_size = 0;
			GeeArrayList* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gint _item_index = 0;
			_tmp30_ = self->priv->snapshot_list_box;
			_tmp31_ = snapshot_list_box_selected_snapshots (_tmp30_);
			_item_list = _tmp31_;
			_tmp32_ = _item_list;
			_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp32_);
			_tmp34_ = _tmp33_;
			_item_size = _tmp34_;
			_item_index = -1;
			while (TRUE) {
				gint _tmp35_;
				gint _tmp36_;
				Snapshot* item = NULL;
				GeeArrayList* _tmp37_;
				gpointer _tmp38_;
				gboolean already_in_list = FALSE;
				_item_index = _item_index + 1;
				_tmp35_ = _item_index;
				_tmp36_ = _item_size;
				if (!(_tmp35_ < _tmp36_)) {
					break;
				}
				_tmp37_ = _item_list;
				_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, _item_index);
				item = (Snapshot*) _tmp38_;
				already_in_list = FALSE;
				{
					GeeArrayList* _bak_list = NULL;
					Main* _tmp39_;
					GeeArrayList* _tmp40_;
					gint _bak_size = 0;
					GeeArrayList* _tmp41_;
					gint _tmp42_;
					gint _tmp43_;
					gint _bak_index = 0;
					_tmp39_ = App;
					_tmp40_ = _tmp39_->delete_list;
					_bak_list = _tmp40_;
					_tmp41_ = _bak_list;
					_tmp42_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp41_);
					_tmp43_ = _tmp42_;
					_bak_size = _tmp43_;
					_bak_index = -1;
					while (TRUE) {
						gint _tmp44_;
						gint _tmp45_;
						Snapshot* bak = NULL;
						GeeArrayList* _tmp46_;
						gpointer _tmp47_;
						Snapshot* _tmp48_;
						const gchar* _tmp49_;
						Snapshot* _tmp50_;
						const gchar* _tmp51_;
						_bak_index = _bak_index + 1;
						_tmp44_ = _bak_index;
						_tmp45_ = _bak_size;
						if (!(_tmp44_ < _tmp45_)) {
							break;
						}
						_tmp46_ = _bak_list;
						_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, _bak_index);
						bak = (Snapshot*) _tmp47_;
						_tmp48_ = bak;
						_tmp49_ = _tmp48_->name;
						_tmp50_ = item;
						_tmp51_ = _tmp50_->name;
						if (g_strcmp0 (_tmp49_, _tmp51_) == 0) {
							already_in_list = TRUE;
							_g_object_unref0 (bak);
							break;
						}
						_g_object_unref0 (bak);
					}
				}
				if (!already_in_list) {
					Main* _tmp52_;
					GeeArrayList* _tmp53_;
					Snapshot* _tmp54_;
					_tmp52_ = App;
					_tmp53_ = _tmp52_->delete_list;
					_tmp54_ = item;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp53_, _tmp54_);
				}
				_g_object_unref0 (item);
			}
			_g_object_unref0 (_item_list);
		}
	}
	_tmp55_ = App;
	_tmp56_ = _tmp55_->delete_list;
	_tmp57_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = g_strdup_printf ("main window: delete_selected(): count=%d", _tmp58_);
	_tmp60_ = _tmp59_;
	tee_jee_logging_log_debug (_tmp60_);
	_g_free0 (_tmp60_);
	main_window_ui_sensitive (self, FALSE);
	_tmp61_ = delete_window_new ();
	g_object_ref_sink (_tmp61_);
	win = _tmp61_;
	_tmp62_ = win;
	gtk_window_set_transient_for ((GtkWindow*) _tmp62_, (GtkWindow*) self);
	_tmp63_ = win;
	g_signal_connect_object ((GtkWidget*) _tmp63_, "destroy", (GCallback) ___lambda135__gtk_widget_destroy, self, 0);
	_g_object_unref0 (win);
	_g_object_unref0 (confirm_dialog);
}

void
main_window_mark_selected (MainWindow* self)
{
	GtkTreeIter iter = {0};
	gboolean is_success = FALSE;
	GtkTreeSelection* sel = NULL;
	SnapshotListBox* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* _tmp3_;
	GtkTreeSelection* _tmp4_;
	GtkListStore* store = NULL;
	SnapshotListBox* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeModel* _tmp8_;
	GtkListStore* _tmp9_;
	gboolean iterExists = FALSE;
	GtkListStore* _tmp10_;
	GtkTreeIter _tmp11_ = {0};
	gboolean _tmp12_;
	gboolean marked = FALSE;
	Main* _tmp24_;
	SnapshotRepo* _tmp25_;
	const gchar* _tmp26_ = NULL;
	gchar* title = NULL;
	gchar* _tmp27_;
	const gchar* _tmp28_ = NULL;
	gchar* message = NULL;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	SnapshotListBox* _tmp32_;
	g_return_if_fail (self != NULL);
	is_success = TRUE;
	_tmp0_ = self->priv->snapshot_list_box;
	_tmp1_ = _tmp0_->treeview;
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	sel = _tmp3_;
	_tmp4_ = sel;
	if (gtk_tree_selection_count_selected_rows (_tmp4_) == 0) {
		tee_jee_gtk_helper_gtk_messagebox (_ ("No Snapshots Selected"), _ ("Select the snapshots to mark for deletion"), (GtkWindow*) self, FALSE);
		_g_object_unref0 (sel);
		return;
	}
	_tmp5_ = self->priv->snapshot_list_box;
	_tmp6_ = _tmp5_->treeview;
	_tmp7_ = gtk_tree_view_get_model (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_list_store_get_type (), GtkListStore));
	store = _tmp9_;
	_tmp10_ = store;
	_tmp12_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp10_, &_tmp11_);
	iter = _tmp11_;
	iterExists = _tmp12_;
	marked = FALSE;
	while (TRUE) {
		gboolean _tmp13_ = FALSE;
		GtkTreeSelection* _tmp14_;
		GtkTreeIter _tmp15_;
		GtkListStore* _tmp22_;
		gboolean _tmp23_;
		if (iterExists) {
			_tmp13_ = is_success;
		} else {
			_tmp13_ = FALSE;
		}
		if (!_tmp13_) {
			break;
		}
		_tmp14_ = sel;
		_tmp15_ = iter;
		if (gtk_tree_selection_iter_is_selected (_tmp14_, &_tmp15_)) {
			Snapshot* bak = NULL;
			GtkListStore* _tmp16_;
			GtkTreeIter _tmp17_;
			Snapshot* _tmp18_ = NULL;
			Snapshot* _tmp19_;
			gboolean _tmp20_ = FALSE;
			_tmp16_ = store;
			_tmp17_ = iter;
			gtk_tree_model_get ((GtkTreeModel*) _tmp16_, &_tmp17_, 0, &_tmp18_, -1);
			_g_object_unref0 (bak);
			bak = _tmp18_;
			_tmp19_ = bak;
			snapshot_mark_for_deletion (_tmp19_);
			if (marked) {
				_tmp20_ = TRUE;
			} else {
				Snapshot* _tmp21_;
				_tmp21_ = bak;
				_tmp20_ = _tmp21_->marked_for_deletion;
			}
			marked = _tmp20_;
			_g_object_unref0 (bak);
		}
		_tmp22_ = store;
		_tmp23_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp22_, &iter);
		iterExists = _tmp23_;
	}
	_tmp24_ = App;
	_tmp25_ = _tmp24_->repo;
	snapshot_repo_load_snapshots (_tmp25_);
	if (marked) {
		_tmp26_ = "Marked ";
	} else {
		_tmp26_ = "Unmarked ";
	}
	_tmp27_ = g_strconcat (_tmp26_, "for deletion", NULL);
	title = _tmp27_;
	if (marked) {
		_tmp28_ = "Snapshots will ";
	} else {
		_tmp28_ = "Snapshots will not ";
	}
	_tmp29_ = g_strconcat (_tmp28_, "be removed during the next scheduled run", NULL);
	message = _tmp29_;
	_tmp30_ = title;
	_tmp31_ = message;
	tee_jee_gtk_helper_gtk_messagebox (_ (_tmp30_), _ (_tmp31_), (GtkWindow*) self, FALSE);
	_tmp32_ = self->priv->snapshot_list_box;
	snapshot_list_box_refresh (_tmp32_);
	_g_free0 (message);
	_g_free0 (title);
	_g_object_unref0 (store);
	_g_object_unref0 (sel);
}

void
main_window_browse_selected (MainWindow* self)
{
	GtkTreeSelection* sel = NULL;
	SnapshotListBox* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* _tmp3_;
	GtkTreeSelection* _tmp4_;
	GtkTreeIter iter = {0};
	GtkListStore* store = NULL;
	SnapshotListBox* _tmp21_;
	GtkTreeView* _tmp22_;
	GtkTreeModel* _tmp23_;
	GtkTreeModel* _tmp24_;
	GtkListStore* _tmp25_;
	gboolean iterExists = FALSE;
	GtkListStore* _tmp26_;
	GtkTreeIter _tmp27_ = {0};
	gboolean _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->snapshot_list_box;
	_tmp1_ = _tmp0_->treeview;
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	sel = _tmp3_;
	_tmp4_ = sel;
	if (gtk_tree_selection_count_selected_rows (_tmp4_) == 0) {
		GFile* f = NULL;
		Main* _tmp5_;
		SnapshotRepo* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GFile* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		_tmp5_ = App;
		_tmp6_ = _tmp5_->repo;
		_tmp7_ = snapshot_repo_get_snapshots_path (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = g_file_new_for_path (_tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		f = _tmp11_;
		_tmp12_ = f;
		if (g_file_query_exists (_tmp12_, NULL)) {
			Main* _tmp13_;
			SnapshotRepo* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp13_ = App;
			_tmp14_ = _tmp13_->repo;
			_tmp15_ = snapshot_repo_get_snapshots_path (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_;
			tee_jee_system_exo_open_folder (_tmp17_, TRUE);
			_g_free0 (_tmp17_);
		} else {
			Main* _tmp18_;
			SnapshotRepo* _tmp19_;
			const gchar* _tmp20_;
			_tmp18_ = App;
			_tmp19_ = _tmp18_->repo;
			_tmp20_ = _tmp19_->mount_path;
			tee_jee_system_exo_open_folder (_tmp20_, TRUE);
		}
		_g_object_unref0 (f);
		_g_object_unref0 (sel);
		return;
	}
	_tmp21_ = self->priv->snapshot_list_box;
	_tmp22_ = _tmp21_->treeview;
	_tmp23_ = gtk_tree_view_get_model (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_list_store_get_type (), GtkListStore));
	store = _tmp25_;
	_tmp26_ = store;
	_tmp28_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp26_, &_tmp27_);
	iter = _tmp27_;
	iterExists = _tmp28_;
	while (TRUE) {
		GtkTreeSelection* _tmp29_;
		GtkTreeIter _tmp30_;
		GtkListStore* _tmp41_;
		gboolean _tmp42_;
		if (!iterExists) {
			break;
		}
		_tmp29_ = sel;
		_tmp30_ = iter;
		if (gtk_tree_selection_iter_is_selected (_tmp29_, &_tmp30_)) {
			Snapshot* bak = NULL;
			GtkListStore* _tmp31_;
			GtkTreeIter _tmp32_;
			Snapshot* _tmp33_ = NULL;
			Main* _tmp34_;
			_tmp31_ = store;
			_tmp32_ = iter;
			gtk_tree_model_get ((GtkTreeModel*) _tmp31_, &_tmp32_, 0, &_tmp33_, -1);
			_g_object_unref0 (bak);
			bak = _tmp33_;
			_tmp34_ = App;
			if (_tmp34_->btrfs_mode) {
				Snapshot* _tmp35_;
				const gchar* _tmp36_;
				_tmp35_ = bak;
				_tmp36_ = _tmp35_->path;
				tee_jee_system_exo_open_folder (_tmp36_, FALSE);
			} else {
				Snapshot* _tmp37_;
				const gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				_tmp37_ = bak;
				_tmp38_ = _tmp37_->path;
				_tmp39_ = g_strconcat (_tmp38_, "/localhost", NULL);
				_tmp40_ = _tmp39_;
				tee_jee_system_exo_open_folder (_tmp40_, FALSE);
				_g_free0 (_tmp40_);
			}
			_g_object_unref0 (bak);
			_g_object_unref0 (store);
			_g_object_unref0 (sel);
			return;
		}
		_tmp41_ = store;
		_tmp42_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp41_, &iter);
		iterExists = _tmp42_;
	}
	_g_object_unref0 (store);
	_g_object_unref0 (sel);
}

static void
_____lambda143_ (MainWindow* self)
{
	gtk_widget_show ((GtkWidget*) self);
}

static void
______lambda143__gtk_widget_destroy (GtkWidget* _sender,
                                     gpointer self)
{
	_____lambda143_ ((MainWindow*) self);
}

void
main_window_view_snapshot_log (MainWindow* self,
                               gboolean view_restore_log)
{
	GtkTreeSelection* sel = NULL;
	SnapshotListBox* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* _tmp3_;
	GtkTreeSelection* _tmp4_;
	GtkTreeIter iter = {0};
	GtkListStore* store = NULL;
	SnapshotListBox* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeModel* _tmp8_;
	GtkListStore* _tmp9_;
	gboolean iterExists = FALSE;
	GtkListStore* _tmp10_;
	GtkTreeIter _tmp11_ = {0};
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->snapshot_list_box;
	_tmp1_ = _tmp0_->treeview;
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	sel = _tmp3_;
	_tmp4_ = sel;
	if (gtk_tree_selection_count_selected_rows (_tmp4_) == 0) {
		tee_jee_gtk_helper_gtk_messagebox (_ ("Select Snapshot"), _ ("Please select a snapshot to view the log!"), (GtkWindow*) self, FALSE);
		_g_object_unref0 (sel);
		return;
	}
	_tmp5_ = self->priv->snapshot_list_box;
	_tmp6_ = _tmp5_->treeview;
	_tmp7_ = gtk_tree_view_get_model (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_list_store_get_type (), GtkListStore));
	store = _tmp9_;
	_tmp10_ = store;
	_tmp12_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp10_, &_tmp11_);
	iter = _tmp11_;
	iterExists = _tmp12_;
	while (TRUE) {
		GtkTreeSelection* _tmp13_;
		GtkTreeIter _tmp14_;
		GtkListStore* _tmp33_;
		gboolean _tmp34_;
		if (!iterExists) {
			break;
		}
		_tmp13_ = sel;
		_tmp14_ = iter;
		if (gtk_tree_selection_iter_is_selected (_tmp13_, &_tmp14_)) {
			Snapshot* bak = NULL;
			GtkListStore* _tmp15_;
			GtkTreeIter _tmp16_;
			Snapshot* _tmp17_ = NULL;
			gchar* log_file_name = NULL;
			Snapshot* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gboolean _tmp24_ = FALSE;
			const gchar* _tmp25_;
			_tmp15_ = store;
			_tmp16_ = iter;
			gtk_tree_model_get ((GtkTreeModel*) _tmp15_, &_tmp16_, 0, &_tmp17_, -1);
			_g_object_unref0 (bak);
			bak = _tmp17_;
			_tmp18_ = bak;
			_tmp19_ = snapshot_get_rsync_log_file (_tmp18_);
			_tmp20_ = _tmp19_;
			log_file_name = _tmp20_;
			if (view_restore_log) {
				Snapshot* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				_tmp21_ = bak;
				_tmp22_ = snapshot_get_rsync_restore_log_file (_tmp21_);
				_tmp23_ = _tmp22_;
				_g_free0 (log_file_name);
				log_file_name = _tmp23_;
			}
			_tmp25_ = log_file_name;
			if (tee_jee_file_system_file_exists (_tmp25_)) {
				_tmp24_ = TRUE;
			} else {
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				_tmp26_ = log_file_name;
				_tmp27_ = g_strconcat (_tmp26_, "-changes", NULL);
				_tmp28_ = _tmp27_;
				_tmp24_ = tee_jee_file_system_file_exists (_tmp28_);
				_g_free0 (_tmp28_);
			}
			if (_tmp24_) {
				RsyncLogWindow* win = NULL;
				const gchar* _tmp29_;
				RsyncLogWindow* _tmp30_;
				RsyncLogWindow* _tmp31_;
				RsyncLogWindow* _tmp32_;
				gtk_widget_hide ((GtkWidget*) self);
				_tmp29_ = log_file_name;
				_tmp30_ = rsync_log_window_new (_tmp29_);
				g_object_ref_sink (_tmp30_);
				win = _tmp30_;
				_tmp31_ = win;
				gtk_window_set_transient_for ((GtkWindow*) _tmp31_, (GtkWindow*) self);
				_tmp32_ = win;
				g_signal_connect_object ((GtkWidget*) _tmp32_, "destroy", (GCallback) ______lambda143__gtk_widget_destroy, self, 0);
				_g_object_unref0 (win);
			}
			_g_free0 (log_file_name);
			_g_object_unref0 (bak);
			_g_object_unref0 (store);
			_g_object_unref0 (sel);
			return;
		}
		_tmp33_ = store;
		_tmp34_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp33_, &iter);
		iterExists = _tmp34_;
	}
	_g_object_unref0 (store);
	_g_object_unref0 (sel);
}

static void
main_window_btn_restore_clicked (MainWindow* self)
{
	Main* _tmp0_;
	g_return_if_fail (self != NULL);
	if (main_window_check_if_deletion_running (self)) {
		return;
	}
	_tmp0_ = App;
	_tmp0_->mirror_system = FALSE;
	main_window_restore (self);
}

static void
___lambda92_ (MainWindow* self)
{
	main_window_refresh_all (self);
	main_window_ui_sensitive (self, TRUE);
}

static void
____lambda92__gtk_widget_destroy (GtkWidget* _sender,
                                  gpointer self)
{
	___lambda92_ ((MainWindow*) self);
}

static gboolean
main_window_check_if_deletion_running (MainWindow* self)
{
	Main* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = App;
	if (_tmp0_->thread_delete_running) {
		DeleteWindow* win = NULL;
		DeleteWindow* _tmp1_;
		DeleteWindow* _tmp2_;
		DeleteWindow* _tmp3_;
		main_window_ui_sensitive (self, TRUE);
		tee_jee_gtk_helper_gtk_messagebox (_ ("Snapshot deletion in progress..."), _ ("Please wait for snapshots to be deleted."), (GtkWindow*) self, TRUE);
		main_window_ui_sensitive (self, FALSE);
		_tmp1_ = delete_window_new ();
		g_object_ref_sink (_tmp1_);
		win = _tmp1_;
		_tmp2_ = win;
		gtk_window_set_transient_for ((GtkWindow*) _tmp2_, (GtkWindow*) self);
		_tmp3_ = win;
		g_signal_connect_object ((GtkWidget*) _tmp3_, "destroy", (GCallback) ____lambda92__gtk_widget_destroy, self, 0);
		result = TRUE;
		_g_object_unref0 (win);
		return result;
	}
	result = FALSE;
	return result;
}

static void
__lambda134_ (MainWindow* self)
{
	Main* _tmp0_;
	Main* _tmp1_;
	SnapshotRepo* _tmp2_;
	_tmp0_ = App;
	_tmp0_->dry_run = FALSE;
	_tmp1_ = App;
	_tmp2_ = _tmp1_->repo;
	snapshot_repo_load_snapshots (_tmp2_);
	main_window_refresh_all (self);
}

static void
___lambda134__gtk_widget_destroy (GtkWidget* _sender,
                                  gpointer self)
{
	__lambda134_ ((MainWindow*) self);
}

static void
main_window_restore (MainWindow* self)
{
	GtkTreeIter iter = {0};
	GtkTreeSelection* sel = NULL;
	Main* _tmp0_;
	Main* _tmp29_;
	RestoreWindow* window = NULL;
	RestoreWindow* _tmp30_;
	RestoreWindow* _tmp31_;
	RestoreWindow* _tmp32_;
	g_return_if_fail (self != NULL);
	_tmp0_ = App;
	if (!_tmp0_->mirror_system) {
		SnapshotListBox* _tmp1_;
		GtkTreeView* _tmp2_;
		GtkTreeSelection* _tmp3_;
		GtkTreeSelection* _tmp4_;
		GtkTreeSelection* _tmp5_;
		Snapshot* snapshot_to_restore = NULL;
		GtkListStore* store = NULL;
		SnapshotListBox* _tmp7_;
		GtkTreeView* _tmp8_;
		GtkTreeModel* _tmp9_;
		GtkTreeModel* _tmp10_;
		GtkListStore* _tmp11_;
		gboolean iterExists = FALSE;
		GtkListStore* _tmp12_;
		GtkTreeIter _tmp13_ = {0};
		gboolean _tmp14_;
		gboolean _tmp22_ = FALSE;
		Snapshot* _tmp23_;
		Main* _tmp25_;
		Snapshot* _tmp26_;
		Snapshot* _tmp27_;
		_tmp1_ = self->priv->snapshot_list_box;
		_tmp2_ = _tmp1_->treeview;
		_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (sel);
		sel = _tmp4_;
		_tmp5_ = sel;
		if (gtk_tree_selection_count_selected_rows (_tmp5_) == 0) {
			tee_jee_gtk_helper_gtk_messagebox (_ ("No snapshots selected"), _ ("Select the snapshot to restore"), (GtkWindow*) self, FALSE);
			_g_object_unref0 (sel);
			return;
		} else {
			GtkTreeSelection* _tmp6_;
			_tmp6_ = sel;
			if (gtk_tree_selection_count_selected_rows (_tmp6_) > 1) {
				tee_jee_gtk_helper_gtk_messagebox (_ ("Multiple snapshots selected"), _ ("Select a single snapshot to restore"), (GtkWindow*) self, FALSE);
				_g_object_unref0 (sel);
				return;
			}
		}
		snapshot_to_restore = NULL;
		_tmp7_ = self->priv->snapshot_list_box;
		_tmp8_ = _tmp7_->treeview;
		_tmp9_ = gtk_tree_view_get_model (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_list_store_get_type (), GtkListStore));
		store = _tmp11_;
		_tmp12_ = store;
		_tmp14_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp12_, &_tmp13_);
		iter = _tmp13_;
		iterExists = _tmp14_;
		while (TRUE) {
			GtkTreeSelection* _tmp15_;
			GtkTreeIter _tmp16_;
			GtkListStore* _tmp20_;
			gboolean _tmp21_;
			if (!iterExists) {
				break;
			}
			_tmp15_ = sel;
			_tmp16_ = iter;
			if (gtk_tree_selection_iter_is_selected (_tmp15_, &_tmp16_)) {
				GtkListStore* _tmp17_;
				GtkTreeIter _tmp18_;
				Snapshot* _tmp19_ = NULL;
				_tmp17_ = store;
				_tmp18_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp17_, &_tmp18_, 0, &_tmp19_, -1);
				_g_object_unref0 (snapshot_to_restore);
				snapshot_to_restore = _tmp19_;
				break;
			}
			_tmp20_ = store;
			_tmp21_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp20_, &iter);
			iterExists = _tmp21_;
		}
		_tmp23_ = snapshot_to_restore;
		if (_tmp23_ != NULL) {
			Snapshot* _tmp24_;
			_tmp24_ = snapshot_to_restore;
			_tmp22_ = _tmp24_->marked_for_deletion;
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			tee_jee_gtk_helper_gtk_messagebox (_ ("Invalid snapshot"), _ ("Selected snapshot is marked for deletion and cannot be restored"), (GtkWindow*) self, FALSE);
			_g_object_unref0 (store);
			_g_object_unref0 (snapshot_to_restore);
			_g_object_unref0 (sel);
			return;
		}
		_tmp25_ = App;
		_tmp26_ = snapshot_to_restore;
		_tmp27_ = _g_object_ref0 (_tmp26_);
		_g_object_unref0 (_tmp25_->snapshot_to_restore);
		_tmp25_->snapshot_to_restore = _tmp27_;
		_g_object_unref0 (store);
		_g_object_unref0 (snapshot_to_restore);
	} else {
		Main* _tmp28_;
		_tmp28_ = App;
		_g_object_unref0 (_tmp28_->snapshot_to_restore);
		_tmp28_->snapshot_to_restore = NULL;
	}
	_tmp29_ = App;
	main_init_mount_list (_tmp29_);
	_tmp30_ = restore_window_new ();
	g_object_ref_sink (_tmp30_);
	window = _tmp30_;
	_tmp31_ = window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp31_, (GtkWindow*) self);
	_tmp32_ = window;
	g_signal_connect_object ((GtkWidget*) _tmp32_, "destroy", (GCallback) ___lambda134__gtk_widget_destroy, self, 0);
	_g_object_unref0 (window);
	_g_object_unref0 (sel);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		MainWindow* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda141_ (Block4Data* _data4_)
{
	MainWindow* self;
	GtkToolButton* _tmp0_;
	GtkToolButton* _tmp1_;
	self = _data4_->self;
	_tmp0_ = self->priv->btn_settings;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = self->priv->btn_wizard;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, TRUE);
	main_window_settings_changed (self, _data4_->btrfs_mode_prev);
}

static void
___lambda141__gtk_widget_destroy (GtkWidget* _sender,
                                  gpointer self)
{
	__lambda141_ (self);
}

static void
main_window_btn_settings_clicked (MainWindow* self)
{
	Block4Data* _data4_;
	GtkToolButton* _tmp0_;
	GtkToolButton* _tmp1_;
	Main* _tmp2_;
	SettingsWindow* win = NULL;
	SettingsWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	tee_jee_logging_log_debug ("MainWindow: btn_settings_clicked()");
	_tmp0_ = self->priv->btn_settings;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, FALSE);
	_tmp1_ = self->priv->btn_wizard;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp2_ = App;
	_data4_->btrfs_mode_prev = _tmp2_->btrfs_mode;
	_tmp3_ = settings_window_new ();
	g_object_ref_sink (_tmp3_);
	win = _tmp3_;
	gtk_window_set_transient_for ((GtkWindow*) win, (GtkWindow*) self);
	g_signal_connect_data ((GtkWidget*) win, "destroy", (GCallback) ___lambda141__gtk_widget_destroy, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_g_object_unref0 (win);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		MainWindow* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda86_ (Block5Data* _data5_)
{
	MainWindow* self;
	GtkToolButton* _tmp0_;
	GtkToolButton* _tmp1_;
	self = _data5_->self;
	_tmp0_ = self->priv->btn_settings;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = self->priv->btn_wizard;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, TRUE);
	main_window_settings_changed (self, _data5_->btrfs_mode_prev);
}

static void
___lambda86__gtk_widget_destroy (GtkWidget* _sender,
                                 gpointer self)
{
	__lambda86_ (self);
}

static void
main_window_btn_wizard_clicked (MainWindow* self)
{
	Block5Data* _data5_;
	GtkToolButton* _tmp0_;
	GtkToolButton* _tmp1_;
	Main* _tmp2_;
	SetupWizardWindow* win = NULL;
	SetupWizardWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	tee_jee_logging_log_debug ("MainWindow: btn_wizard_clicked()");
	_tmp0_ = self->priv->btn_settings;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, FALSE);
	_tmp1_ = self->priv->btn_wizard;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp2_ = App;
	_data5_->btrfs_mode_prev = _tmp2_->btrfs_mode;
	_tmp3_ = setup_wizard_window_new ();
	g_object_ref_sink (_tmp3_);
	win = _tmp3_;
	gtk_window_set_transient_for ((GtkWindow*) win, (GtkWindow*) self);
	g_signal_connect_data ((GtkWidget*) win, "destroy", (GCallback) ___lambda86__gtk_widget_destroy, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_g_object_unref0 (win);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
main_window_settings_changed (MainWindow* self,
                              gboolean btrfs_mode_prev)
{
	Main* _tmp0_;
	Main* _tmp35_;
	Main* _tmp36_;
	SnapshotRepo* _tmp37_;
	g_return_if_fail (self != NULL);
	_tmp0_ = App;
	if (btrfs_mode_prev != _tmp0_->btrfs_mode) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		Main* _tmp3_;
		SnapshotRepo* _tmp4_;
		_tmp3_ = App;
		_tmp4_ = _tmp3_->repo;
		if (_tmp4_ != NULL) {
			Main* _tmp5_;
			SnapshotRepo* _tmp6_;
			Device* _tmp7_;
			_tmp5_ = App;
			_tmp6_ = _tmp5_->repo;
			_tmp7_ = _tmp6_->device;
			_tmp2_ = _tmp7_ != NULL;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			Main* _tmp8_;
			SnapshotRepo* _tmp9_;
			Device* _tmp10_;
			const gchar* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			_tmp8_ = App;
			_tmp9_ = _tmp8_->repo;
			_tmp10_ = _tmp9_->device;
			_tmp11_ = _tmp10_->uuid;
			_tmp12_ = strlen (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp1_ = _tmp13_ > 0;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			Main* _tmp14_;
			Main* _tmp15_;
			SnapshotRepo* _tmp16_;
			Device* _tmp17_;
			const gchar* _tmp18_;
			Main* _tmp19_;
			SnapshotRepo* _tmp20_;
			_tmp14_ = App;
			_tmp15_ = App;
			_tmp16_ = _tmp15_->repo;
			_tmp17_ = _tmp16_->device;
			_tmp18_ = _tmp17_->uuid;
			_tmp19_ = App;
			_tmp20_ = snapshot_repo_new_from_uuid (_tmp18_, (GtkWindow*) self, _tmp19_->btrfs_mode);
			_g_object_unref0 (_tmp14_->repo);
			_tmp14_->repo = _tmp20_;
		} else {
			gboolean _tmp21_ = FALSE;
			Main* _tmp22_;
			Device* _tmp23_;
			_tmp22_ = App;
			_tmp23_ = _tmp22_->sys_root;
			if (_tmp23_ != NULL) {
				Main* _tmp24_;
				Device* _tmp25_;
				const gchar* _tmp26_;
				_tmp24_ = App;
				_tmp25_ = _tmp24_->sys_root;
				_tmp26_ = _tmp25_->fstype;
				_tmp21_ = g_strcmp0 (_tmp26_, "btrfs") == 0;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				Main* _tmp27_;
				Main* _tmp28_;
				Device* _tmp29_;
				const gchar* _tmp30_;
				Main* _tmp31_;
				SnapshotRepo* _tmp32_;
				_tmp27_ = App;
				_tmp28_ = App;
				_tmp29_ = _tmp28_->sys_root;
				_tmp30_ = _tmp29_->uuid;
				_tmp31_ = App;
				_tmp32_ = snapshot_repo_new_from_uuid (_tmp30_, (GtkWindow*) self, _tmp31_->btrfs_mode);
				_g_object_unref0 (_tmp27_->repo);
				_tmp27_->repo = _tmp32_;
			} else {
				Main* _tmp33_;
				SnapshotRepo* _tmp34_;
				_tmp33_ = App;
				_tmp34_ = snapshot_repo_new_from_null ();
				_g_object_unref0 (_tmp33_->repo);
				_tmp33_->repo = _tmp34_;
			}
		}
	}
	_tmp35_ = App;
	main_save_app_config (_tmp35_);
	_tmp36_ = App;
	_tmp37_ = _tmp36_->repo;
	snapshot_repo_load_snapshots (_tmp37_);
	main_window_refresh_all (self);
	gtk_widget_show ((GtkWidget*) self);
}

static void
main_window_btn_view_app_logs_clicked (MainWindow* self)
{
	Main* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = App;
	_tmp1_ = _tmp0_->log_dir;
	tee_jee_system_exo_open_folder (_tmp1_, TRUE);
}

static gboolean
_tee_jee_system_xdg_open_gtk_about_dialog_activate_link (GtkAboutDialog* _sender,
                                                         const gchar* uri,
                                                         gpointer self)
{
	gboolean result;
	result = tee_jee_system_xdg_open (uri);
	return result;
}

static void
main_window_btn_about_clicked (MainWindow* self)
{
	GtkAboutDialog* dialog = NULL;
	GtkAboutDialog* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkAboutDialog*) gtk_about_dialog_new ();
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	gtk_window_set_transient_for ((GtkWindow*) dialog, (GtkWindow*) self);
	gtk_about_dialog_set_program_name (dialog, AppName);
	gtk_about_dialog_set_comments (dialog, _ ("System Restore Utility"));
	_tmp1_ = g_strdup_printf ("Copyright © 2012-21 Tony George (%s)", AppAuthorEmail);
	_tmp2_ = _tmp1_;
	gtk_about_dialog_set_copyright (dialog, _tmp2_);
	_g_free0 (_tmp2_);
	gtk_about_dialog_set_version (dialog, AppVersion);
	gtk_about_dialog_set_logo_icon_name (dialog, "timeshift");
	gtk_about_dialog_set_license_type (dialog, GTK_LICENSE_GPL_2_0);
	gtk_about_dialog_set_website_label (dialog, "https://github.com/linuxmint/timeshift");
	gtk_about_dialog_set_website (dialog, "https://github.com/linuxmint/timeshift");
	g_signal_connect (dialog, "activate-link", (GCallback) _tee_jee_system_xdg_open_gtk_about_dialog_activate_link, NULL);
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}

static void
main_window_ui_sensitive (MainWindow* self,
                          gboolean enable)
{
	GtkToolbar* _tmp0_;
	SnapshotListBox* _tmp1_;
	GtkTreeView* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->toolbar;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, enable);
	_tmp1_ = self->priv->snapshot_list_box;
	_tmp2_ = _tmp1_->treeview;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, enable);
	tee_jee_gtk_helper_gtk_set_busy (!enable, (GtkWindow*) self);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static void
main_window_update_statusbar (MainWindow* self)
{
	Main* _tmp0_;
	SnapshotRepo* _tmp1_;
	gchar* message = NULL;
	Main* _tmp2_;
	SnapshotRepo* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* details = NULL;
	Main* _tmp6_;
	SnapshotRepo* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gint status_code = 0;
	Main* _tmp10_;
	SnapshotRepo* _tmp11_;
	GDateTime* last_snapshot_date = NULL;
	GDateTime* oldest_snapshot_date = NULL;
	Main* _tmp12_;
	SnapshotRepo* _tmp13_;
	Main* _tmp39_;
	g_return_if_fail (self != NULL);
	_tmp0_ = App;
	_tmp1_ = _tmp0_->repo;
	snapshot_repo_check_status (_tmp1_);
	_tmp2_ = App;
	_tmp3_ = _tmp2_->repo;
	_tmp4_ = _tmp3_->status_message;
	_tmp5_ = g_strdup (_tmp4_);
	message = _tmp5_;
	_tmp6_ = App;
	_tmp7_ = _tmp6_->repo;
	_tmp8_ = _tmp7_->status_details;
	_tmp9_ = g_strdup (_tmp8_);
	details = _tmp9_;
	_tmp10_ = App;
	_tmp11_ = _tmp10_->repo;
	status_code = (gint) _tmp11_->status_code;
	last_snapshot_date = NULL;
	oldest_snapshot_date = NULL;
	_tmp12_ = App;
	_tmp13_ = _tmp12_->repo;
	if (snapshot_repo_has_snapshots (_tmp13_)) {
		const gchar* _tmp14_ = NULL;
		Main* _tmp15_;
		Device* _tmp16_;
		gchar* sys_uuid = NULL;
		gchar* _tmp20_;
		Snapshot* last_snapshot = NULL;
		Main* _tmp21_;
		SnapshotRepo* _tmp22_;
		const gchar* _tmp23_;
		Snapshot* _tmp24_;
		GDateTime* _tmp25_ = NULL;
		Snapshot* _tmp26_;
		GDateTime* _tmp29_;
		Snapshot* oldest_snapshot = NULL;
		Main* _tmp30_;
		SnapshotRepo* _tmp31_;
		const gchar* _tmp32_;
		Snapshot* _tmp33_;
		GDateTime* _tmp34_ = NULL;
		Snapshot* _tmp35_;
		GDateTime* _tmp38_;
		_tmp15_ = App;
		_tmp16_ = _tmp15_->sys_root;
		if (_tmp16_ == NULL) {
			_tmp14_ = "";
		} else {
			Main* _tmp17_;
			Device* _tmp18_;
			const gchar* _tmp19_;
			_tmp17_ = App;
			_tmp18_ = _tmp17_->sys_root;
			_tmp19_ = _tmp18_->uuid;
			_tmp14_ = _tmp19_;
		}
		_tmp20_ = g_strdup (_tmp14_);
		sys_uuid = _tmp20_;
		_tmp21_ = App;
		_tmp22_ = _tmp21_->repo;
		_tmp23_ = sys_uuid;
		_tmp24_ = snapshot_repo_get_latest_snapshot (_tmp22_, "", _tmp23_);
		last_snapshot = _tmp24_;
		_tmp26_ = last_snapshot;
		if (_tmp26_ == NULL) {
			_tmp25_ = NULL;
		} else {
			Snapshot* _tmp27_;
			GDateTime* _tmp28_;
			_tmp27_ = last_snapshot;
			_tmp28_ = _tmp27_->date;
			_tmp25_ = _tmp28_;
		}
		_tmp29_ = _g_date_time_ref0 (_tmp25_);
		_g_date_time_unref0 (last_snapshot_date);
		last_snapshot_date = _tmp29_;
		_tmp30_ = App;
		_tmp31_ = _tmp30_->repo;
		_tmp32_ = sys_uuid;
		_tmp33_ = snapshot_repo_get_oldest_snapshot (_tmp31_, "", _tmp32_);
		oldest_snapshot = _tmp33_;
		_tmp35_ = oldest_snapshot;
		if (_tmp35_ == NULL) {
			_tmp34_ = NULL;
		} else {
			Snapshot* _tmp36_;
			GDateTime* _tmp37_;
			_tmp36_ = oldest_snapshot;
			_tmp37_ = _tmp36_->date;
			_tmp34_ = _tmp37_;
		}
		_tmp38_ = _g_date_time_ref0 (_tmp34_);
		_g_date_time_unref0 (oldest_snapshot_date);
		oldest_snapshot_date = _tmp38_;
		_g_object_unref0 (oldest_snapshot);
		_g_object_unref0 (last_snapshot);
		_g_free0 (sys_uuid);
	}
	_tmp39_ = App;
	if (main_live_system (_tmp39_)) {
		GtkScrolledWindow* _tmp40_;
		GtkScrolledWindow* _tmp41_;
		GtkImage* _tmp42_;
		GtkImage* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		cairo_surface_t* _tmp46_;
		cairo_surface_t* _tmp47_;
		_tmp40_ = self->priv->statusbar;
		gtk_widget_set_visible ((GtkWidget*) _tmp40_, TRUE);
		_tmp41_ = self->priv->statusbar;
		gtk_widget_show_all ((GtkWidget*) _tmp41_);
		_tmp42_ = self->priv->img_shield;
		_tmp43_ = self->priv->img_shield;
		_tmp44_ = gtk_widget_get_scale_factor ((GtkWidget*) _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = icon_manager_lookup_surface (ICON_MANAGER_SHIELD_LIVE, ICON_MANAGER_SHIELD_ICON_SIZE, _tmp45_, FALSE, FALSE);
		_tmp47_ = _tmp46_;
		g_object_set (_tmp42_, "surface", _tmp47_, NULL);
		_cairo_surface_destroy0 (_tmp47_);
		main_window_set_shield_label (self, _ ("Live USB Mode (Restore Only)"), TRUE, FALSE, TRUE);
		main_window_set_shield_subnote (self, "", FALSE, TRUE, FALSE);
		switch (status_code) {
			case SNAPSHOT_LOCATION_STATUS_NOT_SELECTED:
			case SNAPSHOT_LOCATION_STATUS_NOT_AVAILABLE:
			case SNAPSHOT_LOCATION_STATUS_NO_BTRFS_SYSTEM:
			{
				const gchar* _tmp48_;
				_tmp48_ = details;
				main_window_set_shield_subnote (self, _tmp48_, FALSE, TRUE, FALSE);
				break;
			}
			case SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_NO_SPACE:
			case SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_HAS_SPACE:
			{
				main_window_set_shield_subnote (self, _ ("Snapshots available for restore"), FALSE, TRUE, FALSE);
				break;
			}
			case SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_NO_SPACE:
			case SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_HAS_SPACE:
			{
				main_window_set_shield_subnote (self, _ ("No snapshots found"), FALSE, TRUE, FALSE);
				break;
			}
			default:
			break;
		}
	} else {
		GtkScrolledWindow* _tmp49_;
		GtkScrolledWindow* _tmp50_;
		GtkScrolledWindow* _tmp106_;
		GtkScrolledWindow* _tmp107_;
		_tmp49_ = self->priv->statusbar;
		gtk_widget_set_visible ((GtkWidget*) _tmp49_, TRUE);
		_tmp50_ = self->priv->statusbar;
		gtk_widget_show_all ((GtkWidget*) _tmp50_);
		switch (status_code) {
			case SNAPSHOT_LOCATION_STATUS_READ_ONLY_FS:
			case SNAPSHOT_LOCATION_STATUS_HARDLINKS_NOT_SUPPORTED:
			case SNAPSHOT_LOCATION_STATUS_NOT_SELECTED:
			case SNAPSHOT_LOCATION_STATUS_NOT_AVAILABLE:
			case SNAPSHOT_LOCATION_STATUS_NO_BTRFS_SYSTEM:
			case SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_NO_SPACE:
			case SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_NO_SPACE:
			{
				GtkImage* _tmp51_;
				GtkImage* _tmp52_;
				gint _tmp53_;
				gint _tmp54_;
				cairo_surface_t* _tmp55_;
				cairo_surface_t* _tmp56_;
				const gchar* _tmp57_;
				const gchar* _tmp58_;
				_tmp51_ = self->priv->img_shield;
				_tmp52_ = self->priv->img_shield;
				_tmp53_ = gtk_widget_get_scale_factor ((GtkWidget*) _tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = icon_manager_lookup_surface (ICON_MANAGER_SHIELD_LOW, ICON_MANAGER_SHIELD_ICON_SIZE, _tmp54_, FALSE, FALSE);
				_tmp56_ = _tmp55_;
				g_object_set (_tmp51_, "surface", _tmp56_, NULL);
				_cairo_surface_destroy0 (_tmp56_);
				_tmp57_ = message;
				main_window_set_shield_label (self, _tmp57_, TRUE, FALSE, TRUE);
				_tmp58_ = details;
				main_window_set_shield_subnote (self, _tmp58_, FALSE, TRUE, FALSE);
				break;
			}
			case SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_HAS_SPACE:
			case SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_HAS_SPACE:
			{
				Main* _tmp59_;
				gboolean _tmp60_;
				gboolean _tmp61_;
				_tmp59_ = App;
				_tmp60_ = main_get_scheduled (_tmp59_);
				_tmp61_ = _tmp60_;
				if (_tmp61_) {
					Main* _tmp62_;
					SnapshotRepo* _tmp63_;
					_tmp62_ = App;
					_tmp63_ = _tmp62_->repo;
					if (snapshot_repo_has_snapshots (_tmp63_)) {
						GtkImage* _tmp64_;
						GtkImage* _tmp65_;
						gint _tmp66_;
						gint _tmp67_;
						cairo_surface_t* _tmp68_;
						cairo_surface_t* _tmp69_;
						gchar* _tmp70_ = NULL;
						GDateTime* _tmp71_;
						gchar* _tmp77_ = NULL;
						GDateTime* _tmp78_;
						gchar* _tmp84_;
						gchar* _tmp85_;
						_tmp64_ = self->priv->img_shield;
						_tmp65_ = self->priv->img_shield;
						_tmp66_ = gtk_widget_get_scale_factor ((GtkWidget*) _tmp65_);
						_tmp67_ = _tmp66_;
						_tmp68_ = icon_manager_lookup_surface (ICON_MANAGER_SHIELD_HIGH, ICON_MANAGER_SHIELD_ICON_SIZE, _tmp67_, FALSE, FALSE);
						_tmp69_ = _tmp68_;
						g_object_set (_tmp64_, "surface", _tmp69_, NULL);
						_cairo_surface_destroy0 (_tmp69_);
						main_window_set_shield_label (self, _ ("Timeshift is active"), TRUE, FALSE, TRUE);
						_tmp71_ = last_snapshot_date;
						if (_tmp71_ == NULL) {
							gchar* _tmp72_;
							_tmp72_ = g_strdup (_ ("None"));
							_g_free0 (_tmp70_);
							_tmp70_ = _tmp72_;
						} else {
							GDateTime* _tmp73_;
							Main* _tmp74_;
							const gchar* _tmp75_;
							gchar* _tmp76_;
							_tmp73_ = last_snapshot_date;
							_tmp74_ = App;
							_tmp75_ = _tmp74_->date_format;
							_tmp76_ = g_date_time_format (_tmp73_, _tmp75_);
							_g_free0 (_tmp70_);
							_tmp70_ = _tmp76_;
						}
						_tmp78_ = oldest_snapshot_date;
						if (_tmp78_ == NULL) {
							gchar* _tmp79_;
							_tmp79_ = g_strdup (_ ("None"));
							_g_free0 (_tmp77_);
							_tmp77_ = _tmp79_;
						} else {
							GDateTime* _tmp80_;
							Main* _tmp81_;
							const gchar* _tmp82_;
							gchar* _tmp83_;
							_tmp80_ = oldest_snapshot_date;
							_tmp81_ = App;
							_tmp82_ = _tmp81_->date_format;
							_tmp83_ = g_date_time_format (_tmp80_, _tmp82_);
							_g_free0 (_tmp77_);
							_tmp77_ = _tmp83_;
						}
						_tmp84_ = g_strdup_printf ("%s: %s\n%s: %s", _ ("Latest snapshot"), _tmp70_, _ ("Oldest snapshot"), _tmp77_);
						_tmp85_ = _tmp84_;
						main_window_set_shield_subnote (self, _tmp85_, FALSE, TRUE, FALSE);
						_g_free0 (_tmp85_);
						_g_free0 (_tmp77_);
						_g_free0 (_tmp70_);
					} else {
						GtkImage* _tmp86_;
						GtkImage* _tmp87_;
						gint _tmp88_;
						gint _tmp89_;
						cairo_surface_t* _tmp90_;
						cairo_surface_t* _tmp91_;
						_tmp86_ = self->priv->img_shield;
						_tmp87_ = self->priv->img_shield;
						_tmp88_ = gtk_widget_get_scale_factor ((GtkWidget*) _tmp87_);
						_tmp89_ = _tmp88_;
						_tmp90_ = icon_manager_lookup_surface (ICON_MANAGER_SHIELD_HIGH, ICON_MANAGER_SHIELD_ICON_SIZE, _tmp89_, FALSE, FALSE);
						_tmp91_ = _tmp90_;
						g_object_set (_tmp86_, "surface", _tmp91_, NULL);
						_cairo_surface_destroy0 (_tmp91_);
						main_window_set_shield_label (self, _ ("Timeshift is active"), TRUE, FALSE, TRUE);
						main_window_set_shield_subnote (self, _ ("Snapshots will be created at selected intervals"), FALSE, TRUE, FALSE);
					}
				} else {
					Main* _tmp92_;
					SnapshotRepo* _tmp93_;
					_tmp92_ = App;
					_tmp93_ = _tmp92_->repo;
					if (snapshot_repo_has_snapshots (_tmp93_)) {
						GtkImage* _tmp94_;
						GtkImage* _tmp95_;
						gint _tmp96_;
						gint _tmp97_;
						cairo_surface_t* _tmp98_;
						cairo_surface_t* _tmp99_;
						_tmp94_ = self->priv->img_shield;
						_tmp95_ = self->priv->img_shield;
						_tmp96_ = gtk_widget_get_scale_factor ((GtkWidget*) _tmp95_);
						_tmp97_ = _tmp96_;
						_tmp98_ = icon_manager_lookup_surface (ICON_MANAGER_SHIELD_MED, ICON_MANAGER_SHIELD_ICON_SIZE, _tmp97_, FALSE, FALSE);
						_tmp99_ = _tmp98_;
						g_object_set (_tmp94_, "surface", _tmp99_, NULL);
						_cairo_surface_destroy0 (_tmp99_);
						main_window_set_shield_label (self, _ ("Scheduled snapshots are disabled"), TRUE, FALSE, TRUE);
						main_window_set_shield_subnote (self, _ ("Enable scheduled snapshots to protect your system"), FALSE, TRUE, FALSE);
					} else {
						GtkImage* _tmp100_;
						GtkImage* _tmp101_;
						gint _tmp102_;
						gint _tmp103_;
						cairo_surface_t* _tmp104_;
						cairo_surface_t* _tmp105_;
						_tmp100_ = self->priv->img_shield;
						_tmp101_ = self->priv->img_shield;
						_tmp102_ = gtk_widget_get_scale_factor ((GtkWidget*) _tmp101_);
						_tmp103_ = _tmp102_;
						_tmp104_ = icon_manager_lookup_surface (ICON_MANAGER_SHIELD_LOW, ICON_MANAGER_SHIELD_ICON_SIZE, _tmp103_, FALSE, FALSE);
						_tmp105_ = _tmp104_;
						g_object_set (_tmp100_, "surface", _tmp105_, NULL);
						_cairo_surface_destroy0 (_tmp105_);
						main_window_set_shield_label (self, _ ("No snapshots available"), TRUE, FALSE, TRUE);
						main_window_set_shield_subnote (self, _ ("Create snapshots manually or enable scheduled snapshots to protect you" \
"r system"), FALSE, TRUE, FALSE);
					}
				}
				break;
			}
			default:
			break;
		}
		_tmp106_ = self->priv->scrolled_snap_count;
		gtk_widget_hide ((GtkWidget*) _tmp106_);
		_tmp107_ = self->priv->scrolled_free_space;
		gtk_widget_hide ((GtkWidget*) _tmp107_);
		switch (status_code) {
			case SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_NO_SPACE:
			case SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_HAS_SPACE:
			case SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_NO_SPACE:
			case SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_HAS_SPACE:
			{
				GtkScrolledWindow* _tmp108_;
				GtkScrolledWindow* _tmp109_;
				GtkLabel* _tmp110_;
				Main* _tmp111_;
				SnapshotRepo* _tmp112_;
				GeeArrayList* _tmp113_;
				gint _tmp114_;
				gint _tmp115_;
				gchar* _tmp116_;
				gchar* _tmp117_;
				gchar* _tmp118_;
				gchar* _tmp119_;
				const gchar* _tmp120_ = NULL;
				Main* _tmp121_;
				gchar* mode = NULL;
				gchar* _tmp122_;
				GtkLabel* _tmp123_;
				const gchar* _tmp124_;
				gchar* _tmp125_;
				gchar* _tmp126_;
				GtkScrolledWindow* _tmp127_;
				GtkScrolledWindow* _tmp128_;
				GtkLabel* _tmp129_;
				Main* _tmp130_;
				SnapshotRepo* _tmp131_;
				Device* _tmp132_;
				guint64 _tmp133_;
				guint64 _tmp134_;
				gchar* _tmp135_;
				gchar* _tmp136_;
				gchar* _tmp137_;
				gchar* _tmp138_;
				gchar* _tmp139_;
				gchar* _tmp140_;
				gchar* devname = NULL;
				gchar* _tmp141_;
				gboolean _tmp142_ = FALSE;
				Main* _tmp143_;
				SnapshotRepo* _tmp144_;
				GtkLabel* _tmp153_;
				const gchar* _tmp154_;
				gchar* _tmp155_;
				gchar* _tmp156_;
				_tmp108_ = self->priv->scrolled_snap_count;
				gtk_widget_set_no_show_all ((GtkWidget*) _tmp108_, FALSE);
				_tmp109_ = self->priv->scrolled_snap_count;
				gtk_widget_show_all ((GtkWidget*) _tmp109_);
				_tmp110_ = self->priv->lbl_snap_count;
				_tmp111_ = App;
				_tmp112_ = _tmp111_->repo;
				_tmp113_ = _tmp112_->snapshots;
				_tmp114_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp113_);
				_tmp115_ = _tmp114_;
				_tmp116_ = g_strdup_printf ("%0d", _tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = main_window_format_text_large (self, _tmp117_);
				_tmp119_ = _tmp118_;
				gtk_label_set_label (_tmp110_, _tmp119_);
				_g_free0 (_tmp119_);
				_g_free0 (_tmp117_);
				_tmp121_ = App;
				if (_tmp121_->btrfs_mode) {
					_tmp120_ = "btrfs";
				} else {
					_tmp120_ = "rsync";
				}
				_tmp122_ = g_strdup (_tmp120_);
				mode = _tmp122_;
				_tmp123_ = self->priv->lbl_snap_count_subnote;
				_tmp124_ = mode;
				_tmp125_ = tee_jee_gtk_helper_format_text (_tmp124_, FALSE, TRUE, FALSE);
				_tmp126_ = _tmp125_;
				gtk_label_set_label (_tmp123_, _tmp126_);
				_g_free0 (_tmp126_);
				_tmp127_ = self->priv->scrolled_free_space;
				gtk_widget_set_no_show_all ((GtkWidget*) _tmp127_, FALSE);
				_tmp128_ = self->priv->scrolled_free_space;
				gtk_widget_show_all ((GtkWidget*) _tmp128_);
				_tmp129_ = self->priv->lbl_free_space;
				_tmp130_ = App;
				_tmp131_ = _tmp130_->repo;
				_tmp132_ = _tmp131_->device;
				_tmp133_ = device_get_free_bytes (_tmp132_);
				_tmp134_ = _tmp133_;
				_tmp135_ = tee_jee_file_system_format_file_size (_tmp134_, FALSE, "", TRUE, 1);
				_tmp136_ = _tmp135_;
				_tmp137_ = g_strdup_printf ("%s", _tmp136_);
				_tmp138_ = _tmp137_;
				_tmp139_ = main_window_format_text_large (self, _tmp138_);
				_tmp140_ = _tmp139_;
				gtk_label_set_label (_tmp129_, _tmp140_);
				_g_free0 (_tmp140_);
				_g_free0 (_tmp138_);
				_g_free0 (_tmp136_);
				_tmp141_ = g_strdup ("(??)");
				devname = _tmp141_;
				_tmp143_ = App;
				_tmp144_ = _tmp143_->repo;
				if (_tmp144_ != NULL) {
					Main* _tmp145_;
					SnapshotRepo* _tmp146_;
					Device* _tmp147_;
					_tmp145_ = App;
					_tmp146_ = _tmp145_->repo;
					_tmp147_ = _tmp146_->device;
					_tmp142_ = _tmp147_ != NULL;
				} else {
					_tmp142_ = FALSE;
				}
				if (_tmp142_) {
					Main* _tmp148_;
					SnapshotRepo* _tmp149_;
					Device* _tmp150_;
					const gchar* _tmp151_;
					gchar* _tmp152_;
					_tmp148_ = App;
					_tmp149_ = _tmp148_->repo;
					_tmp150_ = _tmp149_->device;
					_tmp151_ = _tmp150_->device;
					_tmp152_ = g_strdup_printf ("%s", _tmp151_);
					_g_free0 (devname);
					devname = _tmp152_;
				}
				_tmp153_ = self->priv->lbl_free_space_subnote;
				_tmp154_ = devname;
				_tmp155_ = tee_jee_gtk_helper_format_text (_tmp154_, FALSE, TRUE, FALSE);
				_tmp156_ = _tmp155_;
				gtk_label_set_label (_tmp153_, _tmp156_);
				_g_free0 (_tmp156_);
				_g_free0 (devname);
				_g_free0 (mode);
				break;
			}
			default:
			break;
		}
	}
	_g_date_time_unref0 (oldest_snapshot_date);
	_g_date_time_unref0 (last_snapshot_date);
	_g_free0 (details);
	_g_free0 (message);
}

static gchar*
main_window_format_text_large (MainWindow* self,
                               const gchar* text)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = g_strconcat ("<span size='xx-large'><b>", text, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "</b></span>", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static void
main_window_set_shield_label (MainWindow* self,
                              const gchar* text,
                              gboolean is_bold,
                              gboolean is_italic,
                              gboolean is_large)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* msg = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkLabel* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (is_bold) {
		_tmp0_ = " weight=\"bold\"";
	} else {
		_tmp0_ = "";
	}
	if (is_italic) {
		_tmp1_ = " style=\"italic\"";
	} else {
		_tmp1_ = "";
	}
	if (is_large) {
		_tmp2_ = " size=\"x-large\"";
	} else {
		_tmp2_ = "";
	}
	_tmp3_ = tee_jee_misc_escape_html (text);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("<span%s%s%s>%s</span>", _tmp0_, _tmp1_, _tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	msg = _tmp6_;
	_tmp7_ = self->priv->lbl_shield;
	gtk_label_set_label (_tmp7_, msg);
	_g_free0 (msg);
}

static void
main_window_set_shield_subnote (MainWindow* self,
                                const gchar* text,
                                gboolean is_bold,
                                gboolean is_italic,
                                gboolean is_large)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* msg = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkLabel* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (is_bold) {
		_tmp0_ = " weight=\"bold\"";
	} else {
		_tmp0_ = "";
	}
	if (is_italic) {
		_tmp1_ = " style=\"italic\"";
	} else {
		_tmp1_ = "";
	}
	if (is_large) {
		_tmp2_ = " size=\"x-large\"";
	} else {
		_tmp2_ = "";
	}
	_tmp3_ = tee_jee_misc_escape_html (text);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("<span%s%s%s>%s</span>", _tmp0_, _tmp1_, _tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	msg = _tmp6_;
	_tmp7_ = self->priv->lbl_shield_subnote;
	gtk_label_set_label (_tmp7_, msg);
	_g_free0 (msg);
}

static void
main_window_class_init (MainWindowClass * klass,
                        gpointer klass_data)
{
	main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MainWindow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = main_window_finalize;
}

static void
main_window_instance_init (MainWindow * self,
                           gpointer klass)
{
	self->priv = main_window_get_instance_private (self);
	self->priv->def_width = 800;
	self->priv->def_height = 600;
}

static void
main_window_finalize (GObject * obj)
{
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW, MainWindow);
	_g_object_unref0 (self->priv->vbox_main);
	_g_object_unref0 (self->priv->toolbar);
	_g_object_unref0 (self->priv->btn_backup);
	_g_object_unref0 (self->priv->btn_restore);
	_g_object_unref0 (self->priv->btn_delete_snapshot);
	_g_object_unref0 (self->priv->btn_browse_snapshot);
	_g_object_unref0 (self->priv->btn_settings);
	_g_object_unref0 (self->priv->btn_wizard);
	_g_object_unref0 (self->priv->menu_extra);
	_g_object_unref0 (self->priv->snapshot_list_box);
	_g_object_unref0 (self->priv->statusbar);
	_g_object_unref0 (self->priv->img_shield);
	_g_object_unref0 (self->priv->lbl_shield);
	_g_object_unref0 (self->priv->lbl_shield_subnote);
	_g_object_unref0 (self->priv->lbl_snap_count);
	_g_object_unref0 (self->priv->lbl_snap_count_subnote);
	_g_object_unref0 (self->priv->lbl_free_space);
	_g_object_unref0 (self->priv->lbl_free_space_subnote);
	_g_object_unref0 (self->priv->scrolled_snap_count);
	_g_object_unref0 (self->priv->scrolled_free_space);
	G_OBJECT_CLASS (main_window_parent_class)->finalize (obj);
}

static GType
main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindow), 0, (GInstanceInitFunc) main_window_instance_init, NULL };
	GType main_window_type_id;
	main_window_type_id = g_type_register_static (gtk_window_get_type (), "MainWindow", &g_define_type_info, 0);
	MainWindow_private_offset = g_type_add_instance_private (main_window_type_id, sizeof (MainWindowPrivate));
	return main_window_type_id;
}

GType
main_window_get_type (void)
{
	static volatile gsize main_window_type_id__once = 0;
	if (g_once_init_enter (&main_window_type_id__once)) {
		GType main_window_type_id;
		main_window_type_id = main_window_get_type_once ();
		g_once_init_leave (&main_window_type_id__once, main_window_type_id);
	}
	return main_window_type_id__once;
}

