// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "CornersPropertyGroup.h"

#include <QQmlEngine>

#include "QuickStyle.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

CornersPropertyGroup::CornersPropertyGroup(QuickStyle *style)
    : QObject()
    , m_style(style)
{
    m_topLeft = std::make_unique<CornerPropertyGroup>(m_style);
    m_topRight = std::make_unique<CornerPropertyGroup>(m_style);
    m_bottomLeft = std::make_unique<CornerPropertyGroup>(m_style);
    m_bottomRight = std::make_unique<CornerPropertyGroup>(m_style);
}

void CornersPropertyGroup::update(const std::optional<CornersProperty> &newState)
{
    m_state = newState;

    if (!newState) {
        m_topLeft->update(std::nullopt);
        m_topRight->update(std::nullopt);
        m_bottomLeft->update(std::nullopt);
        m_bottomRight->update(std::nullopt);
    } else {
        m_topLeft->update(newState.value().topLeft());
        m_topRight->update(newState.value().topRight());
        m_bottomLeft->update(newState.value().bottomLeft());
        m_bottomRight->update(newState.value().bottomRight());
    }

    Q_EMIT updated();
}

CornerPropertyGroup *CornersPropertyGroup::topLeft() const
{
    return m_topLeft.get();
}

CornerPropertyGroup *CornersPropertyGroup::topRight() const
{
    return m_topRight.get();
}

CornerPropertyGroup *CornersPropertyGroup::bottomLeft() const
{
    return m_bottomLeft.get();
}

CornerPropertyGroup *CornersPropertyGroup::bottomRight() const
{
    return m_bottomRight.get();
}

#include "moc_CornersPropertyGroup.cpp"