// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off
#include <QJSValue>
#include <QObject>
#include <QProperty>
#include <qqmlregistration.h>


#include <properties/OutlineProperty.h>

#include "LinePropertyGroup.h"
#include "LinePropertyGroup.h"
#include "LinePropertyGroup.h"
#include "LinePropertyGroup.h"
// clang-format on

class QuickStyle;

/*!
 * \qmltype OutlinePropertyGroup
 * \inqmlmodule org.kde.union.impl
 * \ingroup qtquick-properties
 *
 * \brief A group object exposing the properties of OutlineProperty to QML.
 */
class OutlinePropertyGroup : public QObject
{
    Q_OBJECT
    QML_ANONYMOUS

public:
    explicit OutlinePropertyGroup(QuickStyle *style);

    void update(const std::optional<Union::Properties::OutlineProperty> &newState);
    Q_SIGNAL void updated();

    /*!
     * \qmlproperty LinePropertyGroup OutlinePropertyGroup::left
     *
     * Exposes OutlineProperty::LineProperty to QML.
     */
    Q_PROPERTY(LinePropertyGroup *left READ left CONSTANT)
    LinePropertyGroup *left() const;

    /*!
     * \qmlproperty LinePropertyGroup OutlinePropertyGroup::right
     *
     * Exposes OutlineProperty::LineProperty to QML.
     */
    Q_PROPERTY(LinePropertyGroup *right READ right CONSTANT)
    LinePropertyGroup *right() const;

    /*!
     * \qmlproperty LinePropertyGroup OutlinePropertyGroup::top
     *
     * Exposes OutlineProperty::LineProperty to QML.
     */
    Q_PROPERTY(LinePropertyGroup *top READ top CONSTANT)
    LinePropertyGroup *top() const;

    /*!
     * \qmlproperty LinePropertyGroup OutlinePropertyGroup::bottom
     *
     * Exposes OutlineProperty::LineProperty to QML.
     */
    Q_PROPERTY(LinePropertyGroup *bottom READ bottom CONSTANT)
    LinePropertyGroup *bottom() const;

private:
    QuickStyle *m_style = nullptr;
    std::unique_ptr<LinePropertyGroup> m_left;
    std::unique_ptr<LinePropertyGroup> m_right;
    std::unique_ptr<LinePropertyGroup> m_top;
    std::unique_ptr<LinePropertyGroup> m_bottom;

    inline static std::optional<Union::Properties::OutlineProperty> nullValue = std::nullopt;
    std::optional<Union::Properties::OutlineProperty> &m_state = nullValue;
};