# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by  *
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

AC_DEFUN([AC_CHECK_DIETLIBC],
[AC_BEFORE([$0], [AC_PROG_CC])
AC_REQUIRE([AC_CANONICAL_HOST])
AC_ARG_ENABLE([dietlibc],
              [AS_HELP_STRING([--enable-dietlibc],
                              [Enable linking to dielibc [no]])],
              [DIETLIBC=$enableval], [DIETLIBC=no])

if test "X$DIETLIBC" != "Xno"; then
	AC_CHECK_PROGS([DIET], [diet], [no])

	if test "${host_alias}" != "${build_alias}"; then
		AC_CHECK_PROGS([DIET], [${host_alias}-diet], [no])
	else
		AC_CHECK_PROGS([DIET], [diet], [no])
	fi
	if test "X$DIET" = Xno; then
		AC_MSG_ERROR([cannot find dietlibc frontend 'diet'!])
	fi

	CC="$DIET -0s $CC"

	AC_LANG_PUSH(C)
	AC_COMPILE_IFELSE([AC_LANG_SOURCE([[
#ifndef __dietlibc__
#error
#endif
int main(void) { return 0; }
	]])],
	[have_dietlibc=yes],
	[have_dietlibc=no])
	AC_LANG_POP

	if test "$have_dietlibc" = "no"; then
		AC_MSG_ERROR([dietlibc is missing! please install dietlibc and try again])
	fi
	AC_SUBST(DIETLIBC)
fi
]) # AC_CHECK_DIETLIBC
