/*
    parseblock: parse a block device node name.  Made for
        early userspace under klibc.  Most of this code is taken
        from the kernel init/ and kinit source.
    Copyright (C) 2006, Aaron Griffin <aaronmgriffin@gmail.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include "name_to_dev_t.h"

int main(int argc, char *argv[])
{
    dev_t rootdev = 0;

    if (argc != 2) {
        fprintf(stderr, "Usage: %s [device]\n", argv[0]);
    }
    else {
        rootdev = name_to_dev_t(argv[1]);

        if (rootdev && rootdev != Root_NFS) {
            printf("%d %d",major(rootdev),minor(rootdev));
            return 0;
        }
    }
    return 1;
}
