// ********************************************************************
// *** BT 747 ***
// *** April 14, 2007 ***
// *** (c)2007 Mario De Weerd ***
// *** seesite@bt747.org ***
// *** ********************************************************** ***
// *** Software is provided "AS IS," without a warranty of any ***
// *** kind. ALL EXPRESS OR IMPLIED REPRESENTATIONS AND WARRANTIES,***
// *** INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS ***
// *** FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY ***
// *** EXCLUDED. THE ENTIRE RISK ARISING OUT OF USING THE SOFTWARE ***
// *** IS ASSUMED BY THE USER. ***
// *** See the GNU General Public License Version 3 for details. ***
// *** *********************************************************** ***
package bt747.j2se_view;

import gps.log.GPSRecord;

import java.awt.FontMetrics;
import java.util.List;

import javax.swing.JTable;
import javax.swing.table.TableColumn;

import bt747.j2se_view.model.PositionTableModel;

/**
 * 
 * @author Mario De Weerd
 */
public class PositionTablePanel extends javax.swing.JPanel {

    private PositionTableModel tableModel;

    /**
     * 
     */
    private static final long serialVersionUID = -5504685586657168617L;

    /** Creates new form PositionTablePanel */
    public PositionTablePanel() {
        initComponents();
        tableModel = new PositionTableModel();
        tblValues.setModel(tableModel);
        tblValues.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        final FontMetrics fm = tblValues.getFontMetrics(tblValues.getFont());
        for (int i = tblValues.getColumnCount() - 1; i >= 0; i--) {
            final TableColumn col = tblValues.getColumnModel().getColumn(i);
            col.setPreferredWidth(tableModel.getPreferredWidth(fm, i) + 4);
        }
    }

    public void setGpsRecords(final GPSRecord[] records) {
        tableModel.setGpsData(records);
    }

    public void setGpsRecords(final List<List<GPSRecord>> records) {
        tableModel.setGpsData(records);
    }

    // Was used for debug.
    // @SuppressWarnings("serial")
    // private class MyJTable extends javax.swing.JTable {
    // /* (non-Javadoc)
    // * @see
    // javax.swing.JTable#prepareRenderer(javax.swing.table.TableCellRenderer,
    // int, int)
    // */
    // @Override
    // public Component prepareRenderer(TableCellRenderer renderer, int row,
    // int column) {
    // Component r = null;
    // try {
    // r = super.prepareRenderer(renderer, row, column);
    // } catch (Exception e) {
    // Generic.debug("prepareRenderer", e);
    // }
    // return r;
    // }
    // }

    // public java.util.List<List<GPSRecord>> getGpsRecords() {
    // return tableModel.getGpsData();
    // }

    /**
     * This method is called from within the constructor to initialize the
     * form. WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    private void initComponents() {// GEN-BEGIN:initComponents

        jScrollPane1 = new javax.swing.JScrollPane();
        tblValues = new javax.swing.JTable();

        tblValues.setModel(new javax.swing.table.DefaultTableModel(
                new Object[][] { { null, null, null, null },
                        { null, null, null, null },
                        { null, null, null, null },
                        { null, null, null, null } }, new String[] {
                        "Title 1", "Title 2", "Title 3", "Title 4" }));
        tblValues.setColumnSelectionAllowed(true);
        jScrollPane1.setViewportView(tblValues);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(
                this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(0, 398,
                Short.MAX_VALUE).add(
                layout.createParallelGroup(
                        org.jdesktop.layout.GroupLayout.LEADING).add(
                        org.jdesktop.layout.GroupLayout.TRAILING,
                        layout.createSequentialGroup().addContainerGap().add(
                                jScrollPane1,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                378, Short.MAX_VALUE).addContainerGap())));
        layout.setVerticalGroup(layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(0, 288,
                Short.MAX_VALUE).add(
                layout.createParallelGroup(
                        org.jdesktop.layout.GroupLayout.LEADING).add(
                        layout.createSequentialGroup().add(12, 12, 12).add(
                                jScrollPane1,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                265, Short.MAX_VALUE).addContainerGap())));
    }// GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable tblValues;
    // End of variables declaration//GEN-END:variables

}
