/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.cmd.EditSingleFieldCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Field;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.edit.PointEdit;

public class AddAltitudeOffset
extends GenericFunction {
    private JDialog _dialog = null;
    private JLabel _descLabel = null;
    private JTextField _editField = null;
    private JButton _okButton = null;
    private Unit _altUnit = null;

    public AddAltitudeOffset(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.addaltitudeoffset";
    }

    @Override
    public void begin() {
        int n = this._app.getTrackInfo().getSelection().getStart();
        int n2 = this._app.getTrackInfo().getSelection().getEnd();
        if (!this._app.getTrackInfo().getTrack().hasData(Field.ALTITUDE, n, n2)) {
            this._app.showErrorMessage(this.getNameKey(), "dialog.addaltitude.noaltitudes");
            return;
        }
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this.setLabelText();
        this._editField.selectAll();
        this._dialog.setVisible(true);
    }

    private JPanel makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this._descLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.addaltitude.desc")) + " (ft)");
        jPanel2.add(this._descLabel);
        this._editField = new JTextField("0", 6);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                AddAltitudeOffset.this._okButton.setEnabled(Math.abs(AddAltitudeOffset.this.getOffset()) > 0.001);
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                AddAltitudeOffset.this._okButton.setEnabled(Math.abs(AddAltitudeOffset.this.getOffset()) > 0.001);
            }
        };
        this._editField.addKeyListener(keyAdapter);
        this._editField.addMouseListener(mouseAdapter);
        jPanel2.add(this._editField);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = actionEvent -> this.finish();
        this._okButton.addActionListener(actionListener);
        this._okButton.setEnabled(false);
        this._editField.addActionListener(actionListener);
        jPanel3.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private double getOffset() {
        double d = 0.0;
        try {
            d = Double.parseDouble(this._editField.getText());
        }
        catch (Exception exception) {}
        return d;
    }

    private void setLabelText() {
        this._altUnit = UnitSetLibrary.UNITS_FEET;
        if (this.getConfig().getUnitSet().getAltitudeUnit().isStandard()) {
            this._altUnit = UnitSetLibrary.UNITS_METRES;
        }
        String string = this._altUnit.getShortnameKey();
        this._descLabel.setText(String.valueOf(I18nManager.getText("dialog.addaltitude.desc")) + " (" + I18nManager.getText(string) + ")");
    }

    private void finish() {
        double d = this.getOffset();
        if (d == 0.0) {
            return;
        }
        ArrayList<PointEdit> arrayList = new ArrayList<PointEdit>();
        int n = this._app.getTrackInfo().getSelection().getStart();
        int n2 = this._app.getTrackInfo().getSelection().getEnd();
        int n3 = n;
        while (n3 <= n2) {
            DataPoint dataPoint = this._app.getTrackInfo().getTrack().getPoint(n3);
            if (dataPoint.hasAltitude()) {
                Unit unit = dataPoint.getAltitude().getUnit();
                double d2 = Distance.convertBetweenUnits(d, this._altUnit, unit);
                double d3 = dataPoint.getAltitude().getValue(unit) + d2;
                arrayList.add(new PointEdit(n3, Double.toString(d3)));
            }
            ++n3;
        }
        if (!arrayList.isEmpty()) {
            EditSingleFieldCmd editSingleFieldCmd = new EditSingleFieldCmd(Field.ALTITUDE, arrayList, this.getConfig().getUnitSet());
            editSingleFieldCmd.setDescription(this.getName());
            editSingleFieldCmd.setConfirmText(I18nManager.getText("confirm.addaltitudeoffset"));
            this._app.execute(editSingleFieldCmd);
            this._dialog.dispose();
        }
    }
}

