// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import (
	"context"
	"fmt"
	"io/ioutil"
	"net/http"

	"github.com/yaegashi/msgraph.go/jsonx"
)

// GroupCollectionEvaluateDynamicMembershipRequestParameter undocumented
type GroupCollectionEvaluateDynamicMembershipRequestParameter struct {
	// MemberID undocumented
	MemberID *string `json:"memberId,omitempty"`
	// MembershipRule undocumented
	MembershipRule *string `json:"membershipRule,omitempty"`
}

// GroupLifecyclePolicyCollectionRenewGroupRequestParameter undocumented
type GroupLifecyclePolicyCollectionRenewGroupRequestParameter struct {
	// GroupID undocumented
	GroupID *string `json:"groupId,omitempty"`
}

// GroupPolicyMigrationReportCollectionCreateMigrationReportRequestParameter undocumented
type GroupPolicyMigrationReportCollectionCreateMigrationReportRequestParameter struct {
	// GroupPolicyObjectFile undocumented
	GroupPolicyObjectFile *GroupPolicyObjectFile `json:"groupPolicyObjectFile,omitempty"`
}

// GroupValidatePropertiesRequestParameter undocumented
type GroupValidatePropertiesRequestParameter struct {
	// DisplayName undocumented
	DisplayName *string `json:"displayName,omitempty"`
	// MailNickname undocumented
	MailNickname *string `json:"mailNickname,omitempty"`
	// OnBehalfOfUserID undocumented
	OnBehalfOfUserID *UUID `json:"onBehalfOfUserId,omitempty"`
}

// GroupCheckGrantedPermissionsForAppRequestParameter undocumented
type GroupCheckGrantedPermissionsForAppRequestParameter struct {
}

// GroupAssignLicenseRequestParameter undocumented
type GroupAssignLicenseRequestParameter struct {
	// AddLicenses undocumented
	AddLicenses []AssignedLicense `json:"addLicenses,omitempty"`
	// RemoveLicenses undocumented
	RemoveLicenses []UUID `json:"removeLicenses,omitempty"`
}

// GroupSubscribeByMailRequestParameter undocumented
type GroupSubscribeByMailRequestParameter struct {
}

// GroupUnsubscribeByMailRequestParameter undocumented
type GroupUnsubscribeByMailRequestParameter struct {
}

// GroupAddFavoriteRequestParameter undocumented
type GroupAddFavoriteRequestParameter struct {
}

// GroupRemoveFavoriteRequestParameter undocumented
type GroupRemoveFavoriteRequestParameter struct {
}

// GroupResetUnseenCountRequestParameter undocumented
type GroupResetUnseenCountRequestParameter struct {
}

// GroupRenewRequestParameter undocumented
type GroupRenewRequestParameter struct {
}

// GroupEvaluateDynamicMembershipRequestParameter undocumented
type GroupEvaluateDynamicMembershipRequestParameter struct {
	// MemberID undocumented
	MemberID *string `json:"memberId,omitempty"`
}

// GroupLifecyclePolicyAddGroupRequestParameter undocumented
type GroupLifecyclePolicyAddGroupRequestParameter struct {
	// GroupID undocumented
	GroupID *string `json:"groupId,omitempty"`
}

// GroupLifecyclePolicyRemoveGroupRequestParameter undocumented
type GroupLifecyclePolicyRemoveGroupRequestParameter struct {
	// GroupID undocumented
	GroupID *string `json:"groupId,omitempty"`
}

// GroupPolicyConfigurationAssignRequestParameter undocumented
type GroupPolicyConfigurationAssignRequestParameter struct {
	// Assignments undocumented
	Assignments []GroupPolicyConfigurationAssignment `json:"assignments,omitempty"`
}

// GroupPolicyConfigurationUpdateDefinitionValuesRequestParameter undocumented
type GroupPolicyConfigurationUpdateDefinitionValuesRequestParameter struct {
	// Added undocumented
	Added []GroupPolicyDefinitionValue `json:"added,omitempty"`
	// Updated undocumented
	Updated []GroupPolicyDefinitionValue `json:"updated,omitempty"`
	// DeletedIDs undocumented
	DeletedIDs []string `json:"deletedIds,omitempty"`
}

// AcceptedSenders returns request builder for DirectoryObject collection
func (b *GroupRequestBuilder) AcceptedSenders() *GroupAcceptedSendersCollectionRequestBuilder {
	bb := &GroupAcceptedSendersCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/acceptedSenders"
	return bb
}

// GroupAcceptedSendersCollectionRequestBuilder is request builder for DirectoryObject collection
type GroupAcceptedSendersCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectoryObject collection
func (b *GroupAcceptedSendersCollectionRequestBuilder) Request() *GroupAcceptedSendersCollectionRequest {
	return &GroupAcceptedSendersCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectoryObject item
func (b *GroupAcceptedSendersCollectionRequestBuilder) ID(id string) *DirectoryObjectRequestBuilder {
	bb := &DirectoryObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupAcceptedSendersCollectionRequest is request for DirectoryObject collection
type GroupAcceptedSendersCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectoryObject collection
func (r *GroupAcceptedSendersCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectoryObject collection, max N pages
func (r *GroupAcceptedSendersCollectionRequest) GetN(ctx context.Context, n int) ([]DirectoryObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectoryObject collection
func (r *GroupAcceptedSendersCollectionRequest) Get(ctx context.Context) ([]DirectoryObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectoryObject collection
func (r *GroupAcceptedSendersCollectionRequest) Add(ctx context.Context, reqObj *DirectoryObject) (resObj *DirectoryObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AppRoleAssignments returns request builder for AppRoleAssignment collection
func (b *GroupRequestBuilder) AppRoleAssignments() *GroupAppRoleAssignmentsCollectionRequestBuilder {
	bb := &GroupAppRoleAssignmentsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/appRoleAssignments"
	return bb
}

// GroupAppRoleAssignmentsCollectionRequestBuilder is request builder for AppRoleAssignment collection
type GroupAppRoleAssignmentsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AppRoleAssignment collection
func (b *GroupAppRoleAssignmentsCollectionRequestBuilder) Request() *GroupAppRoleAssignmentsCollectionRequest {
	return &GroupAppRoleAssignmentsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AppRoleAssignment item
func (b *GroupAppRoleAssignmentsCollectionRequestBuilder) ID(id string) *AppRoleAssignmentRequestBuilder {
	bb := &AppRoleAssignmentRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupAppRoleAssignmentsCollectionRequest is request for AppRoleAssignment collection
type GroupAppRoleAssignmentsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AppRoleAssignment collection
func (r *GroupAppRoleAssignmentsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AppRoleAssignment, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AppRoleAssignment
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AppRoleAssignment
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AppRoleAssignment collection, max N pages
func (r *GroupAppRoleAssignmentsCollectionRequest) GetN(ctx context.Context, n int) ([]AppRoleAssignment, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AppRoleAssignment collection
func (r *GroupAppRoleAssignmentsCollectionRequest) Get(ctx context.Context) ([]AppRoleAssignment, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AppRoleAssignment collection
func (r *GroupAppRoleAssignmentsCollectionRequest) Add(ctx context.Context, reqObj *AppRoleAssignment) (resObj *AppRoleAssignment, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Calendar is navigation property
func (b *GroupRequestBuilder) Calendar() *CalendarRequestBuilder {
	bb := &CalendarRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/calendar"
	return bb
}

// CalendarView returns request builder for Event collection
func (b *GroupRequestBuilder) CalendarView() *GroupCalendarViewCollectionRequestBuilder {
	bb := &GroupCalendarViewCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/calendarView"
	return bb
}

// GroupCalendarViewCollectionRequestBuilder is request builder for Event collection
type GroupCalendarViewCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Event collection
func (b *GroupCalendarViewCollectionRequestBuilder) Request() *GroupCalendarViewCollectionRequest {
	return &GroupCalendarViewCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Event item
func (b *GroupCalendarViewCollectionRequestBuilder) ID(id string) *EventRequestBuilder {
	bb := &EventRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupCalendarViewCollectionRequest is request for Event collection
type GroupCalendarViewCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Event collection
func (r *GroupCalendarViewCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Event, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Event
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Event
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Event collection, max N pages
func (r *GroupCalendarViewCollectionRequest) GetN(ctx context.Context, n int) ([]Event, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Event collection
func (r *GroupCalendarViewCollectionRequest) Get(ctx context.Context) ([]Event, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Event collection
func (r *GroupCalendarViewCollectionRequest) Add(ctx context.Context, reqObj *Event) (resObj *Event, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Conversations returns request builder for Conversation collection
func (b *GroupRequestBuilder) Conversations() *GroupConversationsCollectionRequestBuilder {
	bb := &GroupConversationsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/conversations"
	return bb
}

// GroupConversationsCollectionRequestBuilder is request builder for Conversation collection
type GroupConversationsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Conversation collection
func (b *GroupConversationsCollectionRequestBuilder) Request() *GroupConversationsCollectionRequest {
	return &GroupConversationsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Conversation item
func (b *GroupConversationsCollectionRequestBuilder) ID(id string) *ConversationRequestBuilder {
	bb := &ConversationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupConversationsCollectionRequest is request for Conversation collection
type GroupConversationsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Conversation collection
func (r *GroupConversationsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Conversation, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Conversation
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Conversation
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Conversation collection, max N pages
func (r *GroupConversationsCollectionRequest) GetN(ctx context.Context, n int) ([]Conversation, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Conversation collection
func (r *GroupConversationsCollectionRequest) Get(ctx context.Context) ([]Conversation, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Conversation collection
func (r *GroupConversationsCollectionRequest) Add(ctx context.Context, reqObj *Conversation) (resObj *Conversation, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// CreatedOnBehalfOf is navigation property
func (b *GroupRequestBuilder) CreatedOnBehalfOf() *DirectoryObjectRequestBuilder {
	bb := &DirectoryObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/createdOnBehalfOf"
	return bb
}

// Drive is navigation property
func (b *GroupRequestBuilder) Drive() *DriveRequestBuilder {
	bb := &DriveRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/drive"
	return bb
}

// Drives returns request builder for Drive collection
func (b *GroupRequestBuilder) Drives() *GroupDrivesCollectionRequestBuilder {
	bb := &GroupDrivesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/drives"
	return bb
}

// GroupDrivesCollectionRequestBuilder is request builder for Drive collection
type GroupDrivesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Drive collection
func (b *GroupDrivesCollectionRequestBuilder) Request() *GroupDrivesCollectionRequest {
	return &GroupDrivesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Drive item
func (b *GroupDrivesCollectionRequestBuilder) ID(id string) *DriveRequestBuilder {
	bb := &DriveRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupDrivesCollectionRequest is request for Drive collection
type GroupDrivesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Drive collection
func (r *GroupDrivesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Drive, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Drive
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Drive
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Drive collection, max N pages
func (r *GroupDrivesCollectionRequest) GetN(ctx context.Context, n int) ([]Drive, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Drive collection
func (r *GroupDrivesCollectionRequest) Get(ctx context.Context) ([]Drive, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Drive collection
func (r *GroupDrivesCollectionRequest) Add(ctx context.Context, reqObj *Drive) (resObj *Drive, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Endpoints returns request builder for Endpoint collection
func (b *GroupRequestBuilder) Endpoints() *GroupEndpointsCollectionRequestBuilder {
	bb := &GroupEndpointsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/endpoints"
	return bb
}

// GroupEndpointsCollectionRequestBuilder is request builder for Endpoint collection
type GroupEndpointsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Endpoint collection
func (b *GroupEndpointsCollectionRequestBuilder) Request() *GroupEndpointsCollectionRequest {
	return &GroupEndpointsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Endpoint item
func (b *GroupEndpointsCollectionRequestBuilder) ID(id string) *EndpointRequestBuilder {
	bb := &EndpointRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupEndpointsCollectionRequest is request for Endpoint collection
type GroupEndpointsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Endpoint collection
func (r *GroupEndpointsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Endpoint, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Endpoint
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Endpoint
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Endpoint collection, max N pages
func (r *GroupEndpointsCollectionRequest) GetN(ctx context.Context, n int) ([]Endpoint, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Endpoint collection
func (r *GroupEndpointsCollectionRequest) Get(ctx context.Context) ([]Endpoint, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Endpoint collection
func (r *GroupEndpointsCollectionRequest) Add(ctx context.Context, reqObj *Endpoint) (resObj *Endpoint, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Events returns request builder for Event collection
func (b *GroupRequestBuilder) Events() *GroupEventsCollectionRequestBuilder {
	bb := &GroupEventsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/events"
	return bb
}

// GroupEventsCollectionRequestBuilder is request builder for Event collection
type GroupEventsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Event collection
func (b *GroupEventsCollectionRequestBuilder) Request() *GroupEventsCollectionRequest {
	return &GroupEventsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Event item
func (b *GroupEventsCollectionRequestBuilder) ID(id string) *EventRequestBuilder {
	bb := &EventRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupEventsCollectionRequest is request for Event collection
type GroupEventsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Event collection
func (r *GroupEventsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Event, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Event
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Event
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Event collection, max N pages
func (r *GroupEventsCollectionRequest) GetN(ctx context.Context, n int) ([]Event, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Event collection
func (r *GroupEventsCollectionRequest) Get(ctx context.Context) ([]Event, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Event collection
func (r *GroupEventsCollectionRequest) Add(ctx context.Context, reqObj *Event) (resObj *Event, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Extensions returns request builder for Extension collection
func (b *GroupRequestBuilder) Extensions() *GroupExtensionsCollectionRequestBuilder {
	bb := &GroupExtensionsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/extensions"
	return bb
}

// GroupExtensionsCollectionRequestBuilder is request builder for Extension collection
type GroupExtensionsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Extension collection
func (b *GroupExtensionsCollectionRequestBuilder) Request() *GroupExtensionsCollectionRequest {
	return &GroupExtensionsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Extension item
func (b *GroupExtensionsCollectionRequestBuilder) ID(id string) *ExtensionRequestBuilder {
	bb := &ExtensionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupExtensionsCollectionRequest is request for Extension collection
type GroupExtensionsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Extension collection
func (r *GroupExtensionsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Extension, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Extension
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Extension
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Extension collection, max N pages
func (r *GroupExtensionsCollectionRequest) GetN(ctx context.Context, n int) ([]Extension, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Extension collection
func (r *GroupExtensionsCollectionRequest) Get(ctx context.Context) ([]Extension, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Extension collection
func (r *GroupExtensionsCollectionRequest) Add(ctx context.Context, reqObj *Extension) (resObj *Extension, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// GroupLifecyclePolicies returns request builder for GroupLifecyclePolicy collection
func (b *GroupRequestBuilder) GroupLifecyclePolicies() *GroupGroupLifecyclePoliciesCollectionRequestBuilder {
	bb := &GroupGroupLifecyclePoliciesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/groupLifecyclePolicies"
	return bb
}

// GroupGroupLifecyclePoliciesCollectionRequestBuilder is request builder for GroupLifecyclePolicy collection
type GroupGroupLifecyclePoliciesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for GroupLifecyclePolicy collection
func (b *GroupGroupLifecyclePoliciesCollectionRequestBuilder) Request() *GroupGroupLifecyclePoliciesCollectionRequest {
	return &GroupGroupLifecyclePoliciesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for GroupLifecyclePolicy item
func (b *GroupGroupLifecyclePoliciesCollectionRequestBuilder) ID(id string) *GroupLifecyclePolicyRequestBuilder {
	bb := &GroupLifecyclePolicyRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupGroupLifecyclePoliciesCollectionRequest is request for GroupLifecyclePolicy collection
type GroupGroupLifecyclePoliciesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for GroupLifecyclePolicy collection
func (r *GroupGroupLifecyclePoliciesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]GroupLifecyclePolicy, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []GroupLifecyclePolicy
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []GroupLifecyclePolicy
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for GroupLifecyclePolicy collection, max N pages
func (r *GroupGroupLifecyclePoliciesCollectionRequest) GetN(ctx context.Context, n int) ([]GroupLifecyclePolicy, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for GroupLifecyclePolicy collection
func (r *GroupGroupLifecyclePoliciesCollectionRequest) Get(ctx context.Context) ([]GroupLifecyclePolicy, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for GroupLifecyclePolicy collection
func (r *GroupGroupLifecyclePoliciesCollectionRequest) Add(ctx context.Context, reqObj *GroupLifecyclePolicy) (resObj *GroupLifecyclePolicy, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// MemberOf returns request builder for DirectoryObject collection
func (b *GroupRequestBuilder) MemberOf() *GroupMemberOfCollectionRequestBuilder {
	bb := &GroupMemberOfCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/memberOf"
	return bb
}

// GroupMemberOfCollectionRequestBuilder is request builder for DirectoryObject collection
type GroupMemberOfCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectoryObject collection
func (b *GroupMemberOfCollectionRequestBuilder) Request() *GroupMemberOfCollectionRequest {
	return &GroupMemberOfCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectoryObject item
func (b *GroupMemberOfCollectionRequestBuilder) ID(id string) *DirectoryObjectRequestBuilder {
	bb := &DirectoryObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupMemberOfCollectionRequest is request for DirectoryObject collection
type GroupMemberOfCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectoryObject collection
func (r *GroupMemberOfCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectoryObject collection, max N pages
func (r *GroupMemberOfCollectionRequest) GetN(ctx context.Context, n int) ([]DirectoryObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectoryObject collection
func (r *GroupMemberOfCollectionRequest) Get(ctx context.Context) ([]DirectoryObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectoryObject collection
func (r *GroupMemberOfCollectionRequest) Add(ctx context.Context, reqObj *DirectoryObject) (resObj *DirectoryObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Members returns request builder for DirectoryObject collection
func (b *GroupRequestBuilder) Members() *GroupMembersCollectionRequestBuilder {
	bb := &GroupMembersCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/members"
	return bb
}

// GroupMembersCollectionRequestBuilder is request builder for DirectoryObject collection
type GroupMembersCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectoryObject collection
func (b *GroupMembersCollectionRequestBuilder) Request() *GroupMembersCollectionRequest {
	return &GroupMembersCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectoryObject item
func (b *GroupMembersCollectionRequestBuilder) ID(id string) *DirectoryObjectRequestBuilder {
	bb := &DirectoryObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupMembersCollectionRequest is request for DirectoryObject collection
type GroupMembersCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectoryObject collection
func (r *GroupMembersCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectoryObject collection, max N pages
func (r *GroupMembersCollectionRequest) GetN(ctx context.Context, n int) ([]DirectoryObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectoryObject collection
func (r *GroupMembersCollectionRequest) Get(ctx context.Context) ([]DirectoryObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectoryObject collection
func (r *GroupMembersCollectionRequest) Add(ctx context.Context, reqObj *DirectoryObject) (resObj *DirectoryObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// MembersWithLicenseErrors returns request builder for DirectoryObject collection
func (b *GroupRequestBuilder) MembersWithLicenseErrors() *GroupMembersWithLicenseErrorsCollectionRequestBuilder {
	bb := &GroupMembersWithLicenseErrorsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/membersWithLicenseErrors"
	return bb
}

// GroupMembersWithLicenseErrorsCollectionRequestBuilder is request builder for DirectoryObject collection
type GroupMembersWithLicenseErrorsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectoryObject collection
func (b *GroupMembersWithLicenseErrorsCollectionRequestBuilder) Request() *GroupMembersWithLicenseErrorsCollectionRequest {
	return &GroupMembersWithLicenseErrorsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectoryObject item
func (b *GroupMembersWithLicenseErrorsCollectionRequestBuilder) ID(id string) *DirectoryObjectRequestBuilder {
	bb := &DirectoryObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupMembersWithLicenseErrorsCollectionRequest is request for DirectoryObject collection
type GroupMembersWithLicenseErrorsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectoryObject collection
func (r *GroupMembersWithLicenseErrorsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectoryObject collection, max N pages
func (r *GroupMembersWithLicenseErrorsCollectionRequest) GetN(ctx context.Context, n int) ([]DirectoryObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectoryObject collection
func (r *GroupMembersWithLicenseErrorsCollectionRequest) Get(ctx context.Context) ([]DirectoryObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectoryObject collection
func (r *GroupMembersWithLicenseErrorsCollectionRequest) Add(ctx context.Context, reqObj *DirectoryObject) (resObj *DirectoryObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Onenote is navigation property
func (b *GroupRequestBuilder) Onenote() *OnenoteRequestBuilder {
	bb := &OnenoteRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/onenote"
	return bb
}

// Owners returns request builder for DirectoryObject collection
func (b *GroupRequestBuilder) Owners() *GroupOwnersCollectionRequestBuilder {
	bb := &GroupOwnersCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/owners"
	return bb
}

// GroupOwnersCollectionRequestBuilder is request builder for DirectoryObject collection
type GroupOwnersCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectoryObject collection
func (b *GroupOwnersCollectionRequestBuilder) Request() *GroupOwnersCollectionRequest {
	return &GroupOwnersCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectoryObject item
func (b *GroupOwnersCollectionRequestBuilder) ID(id string) *DirectoryObjectRequestBuilder {
	bb := &DirectoryObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupOwnersCollectionRequest is request for DirectoryObject collection
type GroupOwnersCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectoryObject collection
func (r *GroupOwnersCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectoryObject collection, max N pages
func (r *GroupOwnersCollectionRequest) GetN(ctx context.Context, n int) ([]DirectoryObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectoryObject collection
func (r *GroupOwnersCollectionRequest) Get(ctx context.Context) ([]DirectoryObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectoryObject collection
func (r *GroupOwnersCollectionRequest) Add(ctx context.Context, reqObj *DirectoryObject) (resObj *DirectoryObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// PermissionGrants returns request builder for ResourceSpecificPermissionGrant collection
func (b *GroupRequestBuilder) PermissionGrants() *GroupPermissionGrantsCollectionRequestBuilder {
	bb := &GroupPermissionGrantsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/permissionGrants"
	return bb
}

// GroupPermissionGrantsCollectionRequestBuilder is request builder for ResourceSpecificPermissionGrant collection
type GroupPermissionGrantsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ResourceSpecificPermissionGrant collection
func (b *GroupPermissionGrantsCollectionRequestBuilder) Request() *GroupPermissionGrantsCollectionRequest {
	return &GroupPermissionGrantsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ResourceSpecificPermissionGrant item
func (b *GroupPermissionGrantsCollectionRequestBuilder) ID(id string) *ResourceSpecificPermissionGrantRequestBuilder {
	bb := &ResourceSpecificPermissionGrantRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupPermissionGrantsCollectionRequest is request for ResourceSpecificPermissionGrant collection
type GroupPermissionGrantsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ResourceSpecificPermissionGrant collection
func (r *GroupPermissionGrantsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ResourceSpecificPermissionGrant, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ResourceSpecificPermissionGrant
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ResourceSpecificPermissionGrant
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ResourceSpecificPermissionGrant collection, max N pages
func (r *GroupPermissionGrantsCollectionRequest) GetN(ctx context.Context, n int) ([]ResourceSpecificPermissionGrant, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ResourceSpecificPermissionGrant collection
func (r *GroupPermissionGrantsCollectionRequest) Get(ctx context.Context) ([]ResourceSpecificPermissionGrant, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ResourceSpecificPermissionGrant collection
func (r *GroupPermissionGrantsCollectionRequest) Add(ctx context.Context, reqObj *ResourceSpecificPermissionGrant) (resObj *ResourceSpecificPermissionGrant, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Photo is navigation property
func (b *GroupRequestBuilder) Photo() *ProfilePhotoRequestBuilder {
	bb := &ProfilePhotoRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/photo"
	return bb
}

// Photos returns request builder for ProfilePhoto collection
func (b *GroupRequestBuilder) Photos() *GroupPhotosCollectionRequestBuilder {
	bb := &GroupPhotosCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/photos"
	return bb
}

// GroupPhotosCollectionRequestBuilder is request builder for ProfilePhoto collection
type GroupPhotosCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ProfilePhoto collection
func (b *GroupPhotosCollectionRequestBuilder) Request() *GroupPhotosCollectionRequest {
	return &GroupPhotosCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ProfilePhoto item
func (b *GroupPhotosCollectionRequestBuilder) ID(id string) *ProfilePhotoRequestBuilder {
	bb := &ProfilePhotoRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupPhotosCollectionRequest is request for ProfilePhoto collection
type GroupPhotosCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ProfilePhoto collection
func (r *GroupPhotosCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ProfilePhoto, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ProfilePhoto
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ProfilePhoto
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ProfilePhoto collection, max N pages
func (r *GroupPhotosCollectionRequest) GetN(ctx context.Context, n int) ([]ProfilePhoto, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ProfilePhoto collection
func (r *GroupPhotosCollectionRequest) Get(ctx context.Context) ([]ProfilePhoto, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ProfilePhoto collection
func (r *GroupPhotosCollectionRequest) Add(ctx context.Context, reqObj *ProfilePhoto) (resObj *ProfilePhoto, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Planner is navigation property
func (b *GroupRequestBuilder) Planner() *PlannerGroupRequestBuilder {
	bb := &PlannerGroupRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/planner"
	return bb
}

// RejectedSenders returns request builder for DirectoryObject collection
func (b *GroupRequestBuilder) RejectedSenders() *GroupRejectedSendersCollectionRequestBuilder {
	bb := &GroupRejectedSendersCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/rejectedSenders"
	return bb
}

// GroupRejectedSendersCollectionRequestBuilder is request builder for DirectoryObject collection
type GroupRejectedSendersCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectoryObject collection
func (b *GroupRejectedSendersCollectionRequestBuilder) Request() *GroupRejectedSendersCollectionRequest {
	return &GroupRejectedSendersCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectoryObject item
func (b *GroupRejectedSendersCollectionRequestBuilder) ID(id string) *DirectoryObjectRequestBuilder {
	bb := &DirectoryObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupRejectedSendersCollectionRequest is request for DirectoryObject collection
type GroupRejectedSendersCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectoryObject collection
func (r *GroupRejectedSendersCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectoryObject collection, max N pages
func (r *GroupRejectedSendersCollectionRequest) GetN(ctx context.Context, n int) ([]DirectoryObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectoryObject collection
func (r *GroupRejectedSendersCollectionRequest) Get(ctx context.Context) ([]DirectoryObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectoryObject collection
func (r *GroupRejectedSendersCollectionRequest) Add(ctx context.Context, reqObj *DirectoryObject) (resObj *DirectoryObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Settings returns request builder for DirectorySetting collection
func (b *GroupRequestBuilder) Settings() *GroupSettingsCollectionRequestBuilder {
	bb := &GroupSettingsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/settings"
	return bb
}

// GroupSettingsCollectionRequestBuilder is request builder for DirectorySetting collection
type GroupSettingsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectorySetting collection
func (b *GroupSettingsCollectionRequestBuilder) Request() *GroupSettingsCollectionRequest {
	return &GroupSettingsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectorySetting item
func (b *GroupSettingsCollectionRequestBuilder) ID(id string) *DirectorySettingRequestBuilder {
	bb := &DirectorySettingRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupSettingsCollectionRequest is request for DirectorySetting collection
type GroupSettingsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectorySetting collection
func (r *GroupSettingsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectorySetting, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectorySetting
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectorySetting
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectorySetting collection, max N pages
func (r *GroupSettingsCollectionRequest) GetN(ctx context.Context, n int) ([]DirectorySetting, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectorySetting collection
func (r *GroupSettingsCollectionRequest) Get(ctx context.Context) ([]DirectorySetting, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectorySetting collection
func (r *GroupSettingsCollectionRequest) Add(ctx context.Context, reqObj *DirectorySetting) (resObj *DirectorySetting, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Sites returns request builder for Site collection
func (b *GroupRequestBuilder) Sites() *GroupSitesCollectionRequestBuilder {
	bb := &GroupSitesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/sites"
	return bb
}

// GroupSitesCollectionRequestBuilder is request builder for Site collection
type GroupSitesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Site collection
func (b *GroupSitesCollectionRequestBuilder) Request() *GroupSitesCollectionRequest {
	return &GroupSitesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Site item
func (b *GroupSitesCollectionRequestBuilder) ID(id string) *SiteRequestBuilder {
	bb := &SiteRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupSitesCollectionRequest is request for Site collection
type GroupSitesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Site collection
func (r *GroupSitesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Site, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Site
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Site
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Site collection, max N pages
func (r *GroupSitesCollectionRequest) GetN(ctx context.Context, n int) ([]Site, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Site collection
func (r *GroupSitesCollectionRequest) Get(ctx context.Context) ([]Site, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Site collection
func (r *GroupSitesCollectionRequest) Add(ctx context.Context, reqObj *Site) (resObj *Site, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Team is navigation property
func (b *GroupRequestBuilder) Team() *TeamRequestBuilder {
	bb := &TeamRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/team"
	return bb
}

// Threads returns request builder for ConversationThread collection
func (b *GroupRequestBuilder) Threads() *GroupThreadsCollectionRequestBuilder {
	bb := &GroupThreadsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/threads"
	return bb
}

// GroupThreadsCollectionRequestBuilder is request builder for ConversationThread collection
type GroupThreadsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ConversationThread collection
func (b *GroupThreadsCollectionRequestBuilder) Request() *GroupThreadsCollectionRequest {
	return &GroupThreadsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ConversationThread item
func (b *GroupThreadsCollectionRequestBuilder) ID(id string) *ConversationThreadRequestBuilder {
	bb := &ConversationThreadRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupThreadsCollectionRequest is request for ConversationThread collection
type GroupThreadsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ConversationThread collection
func (r *GroupThreadsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ConversationThread, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ConversationThread
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ConversationThread
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ConversationThread collection, max N pages
func (r *GroupThreadsCollectionRequest) GetN(ctx context.Context, n int) ([]ConversationThread, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ConversationThread collection
func (r *GroupThreadsCollectionRequest) Get(ctx context.Context) ([]ConversationThread, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ConversationThread collection
func (r *GroupThreadsCollectionRequest) Add(ctx context.Context, reqObj *ConversationThread) (resObj *ConversationThread, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// TransitiveMemberOf returns request builder for DirectoryObject collection
func (b *GroupRequestBuilder) TransitiveMemberOf() *GroupTransitiveMemberOfCollectionRequestBuilder {
	bb := &GroupTransitiveMemberOfCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/transitiveMemberOf"
	return bb
}

// GroupTransitiveMemberOfCollectionRequestBuilder is request builder for DirectoryObject collection
type GroupTransitiveMemberOfCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectoryObject collection
func (b *GroupTransitiveMemberOfCollectionRequestBuilder) Request() *GroupTransitiveMemberOfCollectionRequest {
	return &GroupTransitiveMemberOfCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectoryObject item
func (b *GroupTransitiveMemberOfCollectionRequestBuilder) ID(id string) *DirectoryObjectRequestBuilder {
	bb := &DirectoryObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupTransitiveMemberOfCollectionRequest is request for DirectoryObject collection
type GroupTransitiveMemberOfCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectoryObject collection
func (r *GroupTransitiveMemberOfCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectoryObject collection, max N pages
func (r *GroupTransitiveMemberOfCollectionRequest) GetN(ctx context.Context, n int) ([]DirectoryObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectoryObject collection
func (r *GroupTransitiveMemberOfCollectionRequest) Get(ctx context.Context) ([]DirectoryObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectoryObject collection
func (r *GroupTransitiveMemberOfCollectionRequest) Add(ctx context.Context, reqObj *DirectoryObject) (resObj *DirectoryObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// TransitiveMembers returns request builder for DirectoryObject collection
func (b *GroupRequestBuilder) TransitiveMembers() *GroupTransitiveMembersCollectionRequestBuilder {
	bb := &GroupTransitiveMembersCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/transitiveMembers"
	return bb
}

// GroupTransitiveMembersCollectionRequestBuilder is request builder for DirectoryObject collection
type GroupTransitiveMembersCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DirectoryObject collection
func (b *GroupTransitiveMembersCollectionRequestBuilder) Request() *GroupTransitiveMembersCollectionRequest {
	return &GroupTransitiveMembersCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DirectoryObject item
func (b *GroupTransitiveMembersCollectionRequestBuilder) ID(id string) *DirectoryObjectRequestBuilder {
	bb := &DirectoryObjectRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupTransitiveMembersCollectionRequest is request for DirectoryObject collection
type GroupTransitiveMembersCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DirectoryObject collection
func (r *GroupTransitiveMembersCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DirectoryObject collection, max N pages
func (r *GroupTransitiveMembersCollectionRequest) GetN(ctx context.Context, n int) ([]DirectoryObject, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DirectoryObject collection
func (r *GroupTransitiveMembersCollectionRequest) Get(ctx context.Context) ([]DirectoryObject, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DirectoryObject collection
func (r *GroupTransitiveMembersCollectionRequest) Add(ctx context.Context, reqObj *DirectoryObject) (resObj *DirectoryObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Assignments returns request builder for GroupPolicyConfigurationAssignment collection
func (b *GroupPolicyConfigurationRequestBuilder) Assignments() *GroupPolicyConfigurationAssignmentsCollectionRequestBuilder {
	bb := &GroupPolicyConfigurationAssignmentsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/assignments"
	return bb
}

// GroupPolicyConfigurationAssignmentsCollectionRequestBuilder is request builder for GroupPolicyConfigurationAssignment collection
type GroupPolicyConfigurationAssignmentsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for GroupPolicyConfigurationAssignment collection
func (b *GroupPolicyConfigurationAssignmentsCollectionRequestBuilder) Request() *GroupPolicyConfigurationAssignmentsCollectionRequest {
	return &GroupPolicyConfigurationAssignmentsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for GroupPolicyConfigurationAssignment item
func (b *GroupPolicyConfigurationAssignmentsCollectionRequestBuilder) ID(id string) *GroupPolicyConfigurationAssignmentRequestBuilder {
	bb := &GroupPolicyConfigurationAssignmentRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupPolicyConfigurationAssignmentsCollectionRequest is request for GroupPolicyConfigurationAssignment collection
type GroupPolicyConfigurationAssignmentsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for GroupPolicyConfigurationAssignment collection
func (r *GroupPolicyConfigurationAssignmentsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]GroupPolicyConfigurationAssignment, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []GroupPolicyConfigurationAssignment
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []GroupPolicyConfigurationAssignment
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for GroupPolicyConfigurationAssignment collection, max N pages
func (r *GroupPolicyConfigurationAssignmentsCollectionRequest) GetN(ctx context.Context, n int) ([]GroupPolicyConfigurationAssignment, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for GroupPolicyConfigurationAssignment collection
func (r *GroupPolicyConfigurationAssignmentsCollectionRequest) Get(ctx context.Context) ([]GroupPolicyConfigurationAssignment, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for GroupPolicyConfigurationAssignment collection
func (r *GroupPolicyConfigurationAssignmentsCollectionRequest) Add(ctx context.Context, reqObj *GroupPolicyConfigurationAssignment) (resObj *GroupPolicyConfigurationAssignment, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// DefinitionValues returns request builder for GroupPolicyDefinitionValue collection
func (b *GroupPolicyConfigurationRequestBuilder) DefinitionValues() *GroupPolicyConfigurationDefinitionValuesCollectionRequestBuilder {
	bb := &GroupPolicyConfigurationDefinitionValuesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/definitionValues"
	return bb
}

// GroupPolicyConfigurationDefinitionValuesCollectionRequestBuilder is request builder for GroupPolicyDefinitionValue collection
type GroupPolicyConfigurationDefinitionValuesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for GroupPolicyDefinitionValue collection
func (b *GroupPolicyConfigurationDefinitionValuesCollectionRequestBuilder) Request() *GroupPolicyConfigurationDefinitionValuesCollectionRequest {
	return &GroupPolicyConfigurationDefinitionValuesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for GroupPolicyDefinitionValue item
func (b *GroupPolicyConfigurationDefinitionValuesCollectionRequestBuilder) ID(id string) *GroupPolicyDefinitionValueRequestBuilder {
	bb := &GroupPolicyDefinitionValueRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupPolicyConfigurationDefinitionValuesCollectionRequest is request for GroupPolicyDefinitionValue collection
type GroupPolicyConfigurationDefinitionValuesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for GroupPolicyDefinitionValue collection
func (r *GroupPolicyConfigurationDefinitionValuesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]GroupPolicyDefinitionValue, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []GroupPolicyDefinitionValue
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []GroupPolicyDefinitionValue
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for GroupPolicyDefinitionValue collection, max N pages
func (r *GroupPolicyConfigurationDefinitionValuesCollectionRequest) GetN(ctx context.Context, n int) ([]GroupPolicyDefinitionValue, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for GroupPolicyDefinitionValue collection
func (r *GroupPolicyConfigurationDefinitionValuesCollectionRequest) Get(ctx context.Context) ([]GroupPolicyDefinitionValue, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for GroupPolicyDefinitionValue collection
func (r *GroupPolicyConfigurationDefinitionValuesCollectionRequest) Add(ctx context.Context, reqObj *GroupPolicyDefinitionValue) (resObj *GroupPolicyDefinitionValue, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// DefinitionFile is navigation property
func (b *GroupPolicyDefinitionRequestBuilder) DefinitionFile() *GroupPolicyDefinitionFileRequestBuilder {
	bb := &GroupPolicyDefinitionFileRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/definitionFile"
	return bb
}

// Presentations returns request builder for GroupPolicyPresentation collection
func (b *GroupPolicyDefinitionRequestBuilder) Presentations() *GroupPolicyDefinitionPresentationsCollectionRequestBuilder {
	bb := &GroupPolicyDefinitionPresentationsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/presentations"
	return bb
}

// GroupPolicyDefinitionPresentationsCollectionRequestBuilder is request builder for GroupPolicyPresentation collection
type GroupPolicyDefinitionPresentationsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for GroupPolicyPresentation collection
func (b *GroupPolicyDefinitionPresentationsCollectionRequestBuilder) Request() *GroupPolicyDefinitionPresentationsCollectionRequest {
	return &GroupPolicyDefinitionPresentationsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for GroupPolicyPresentation item
func (b *GroupPolicyDefinitionPresentationsCollectionRequestBuilder) ID(id string) *GroupPolicyPresentationRequestBuilder {
	bb := &GroupPolicyPresentationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupPolicyDefinitionPresentationsCollectionRequest is request for GroupPolicyPresentation collection
type GroupPolicyDefinitionPresentationsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for GroupPolicyPresentation collection
func (r *GroupPolicyDefinitionPresentationsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]GroupPolicyPresentation, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []GroupPolicyPresentation
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []GroupPolicyPresentation
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for GroupPolicyPresentation collection, max N pages
func (r *GroupPolicyDefinitionPresentationsCollectionRequest) GetN(ctx context.Context, n int) ([]GroupPolicyPresentation, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for GroupPolicyPresentation collection
func (r *GroupPolicyDefinitionPresentationsCollectionRequest) Get(ctx context.Context) ([]GroupPolicyPresentation, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for GroupPolicyPresentation collection
func (r *GroupPolicyDefinitionPresentationsCollectionRequest) Add(ctx context.Context, reqObj *GroupPolicyPresentation) (resObj *GroupPolicyPresentation, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Definitions returns request builder for GroupPolicyDefinition collection
func (b *GroupPolicyDefinitionFileRequestBuilder) Definitions() *GroupPolicyDefinitionFileDefinitionsCollectionRequestBuilder {
	bb := &GroupPolicyDefinitionFileDefinitionsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/definitions"
	return bb
}

// GroupPolicyDefinitionFileDefinitionsCollectionRequestBuilder is request builder for GroupPolicyDefinition collection
type GroupPolicyDefinitionFileDefinitionsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for GroupPolicyDefinition collection
func (b *GroupPolicyDefinitionFileDefinitionsCollectionRequestBuilder) Request() *GroupPolicyDefinitionFileDefinitionsCollectionRequest {
	return &GroupPolicyDefinitionFileDefinitionsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for GroupPolicyDefinition item
func (b *GroupPolicyDefinitionFileDefinitionsCollectionRequestBuilder) ID(id string) *GroupPolicyDefinitionRequestBuilder {
	bb := &GroupPolicyDefinitionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupPolicyDefinitionFileDefinitionsCollectionRequest is request for GroupPolicyDefinition collection
type GroupPolicyDefinitionFileDefinitionsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for GroupPolicyDefinition collection
func (r *GroupPolicyDefinitionFileDefinitionsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]GroupPolicyDefinition, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []GroupPolicyDefinition
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []GroupPolicyDefinition
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for GroupPolicyDefinition collection, max N pages
func (r *GroupPolicyDefinitionFileDefinitionsCollectionRequest) GetN(ctx context.Context, n int) ([]GroupPolicyDefinition, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for GroupPolicyDefinition collection
func (r *GroupPolicyDefinitionFileDefinitionsCollectionRequest) Get(ctx context.Context) ([]GroupPolicyDefinition, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for GroupPolicyDefinition collection
func (r *GroupPolicyDefinitionFileDefinitionsCollectionRequest) Add(ctx context.Context, reqObj *GroupPolicyDefinition) (resObj *GroupPolicyDefinition, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Definition is navigation property
func (b *GroupPolicyDefinitionValueRequestBuilder) Definition() *GroupPolicyDefinitionRequestBuilder {
	bb := &GroupPolicyDefinitionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/definition"
	return bb
}

// PresentationValues returns request builder for GroupPolicyPresentationValue collection
func (b *GroupPolicyDefinitionValueRequestBuilder) PresentationValues() *GroupPolicyDefinitionValuePresentationValuesCollectionRequestBuilder {
	bb := &GroupPolicyDefinitionValuePresentationValuesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/presentationValues"
	return bb
}

// GroupPolicyDefinitionValuePresentationValuesCollectionRequestBuilder is request builder for GroupPolicyPresentationValue collection
type GroupPolicyDefinitionValuePresentationValuesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for GroupPolicyPresentationValue collection
func (b *GroupPolicyDefinitionValuePresentationValuesCollectionRequestBuilder) Request() *GroupPolicyDefinitionValuePresentationValuesCollectionRequest {
	return &GroupPolicyDefinitionValuePresentationValuesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for GroupPolicyPresentationValue item
func (b *GroupPolicyDefinitionValuePresentationValuesCollectionRequestBuilder) ID(id string) *GroupPolicyPresentationValueRequestBuilder {
	bb := &GroupPolicyPresentationValueRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupPolicyDefinitionValuePresentationValuesCollectionRequest is request for GroupPolicyPresentationValue collection
type GroupPolicyDefinitionValuePresentationValuesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for GroupPolicyPresentationValue collection
func (r *GroupPolicyDefinitionValuePresentationValuesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]GroupPolicyPresentationValue, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []GroupPolicyPresentationValue
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []GroupPolicyPresentationValue
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for GroupPolicyPresentationValue collection, max N pages
func (r *GroupPolicyDefinitionValuePresentationValuesCollectionRequest) GetN(ctx context.Context, n int) ([]GroupPolicyPresentationValue, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for GroupPolicyPresentationValue collection
func (r *GroupPolicyDefinitionValuePresentationValuesCollectionRequest) Get(ctx context.Context) ([]GroupPolicyPresentationValue, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for GroupPolicyPresentationValue collection
func (r *GroupPolicyDefinitionValuePresentationValuesCollectionRequest) Add(ctx context.Context, reqObj *GroupPolicyPresentationValue) (resObj *GroupPolicyPresentationValue, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// GroupPolicySettingMappings returns request builder for GroupPolicySettingMapping collection
func (b *GroupPolicyMigrationReportRequestBuilder) GroupPolicySettingMappings() *GroupPolicyMigrationReportGroupPolicySettingMappingsCollectionRequestBuilder {
	bb := &GroupPolicyMigrationReportGroupPolicySettingMappingsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/groupPolicySettingMappings"
	return bb
}

// GroupPolicyMigrationReportGroupPolicySettingMappingsCollectionRequestBuilder is request builder for GroupPolicySettingMapping collection
type GroupPolicyMigrationReportGroupPolicySettingMappingsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for GroupPolicySettingMapping collection
func (b *GroupPolicyMigrationReportGroupPolicySettingMappingsCollectionRequestBuilder) Request() *GroupPolicyMigrationReportGroupPolicySettingMappingsCollectionRequest {
	return &GroupPolicyMigrationReportGroupPolicySettingMappingsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for GroupPolicySettingMapping item
func (b *GroupPolicyMigrationReportGroupPolicySettingMappingsCollectionRequestBuilder) ID(id string) *GroupPolicySettingMappingRequestBuilder {
	bb := &GroupPolicySettingMappingRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// GroupPolicyMigrationReportGroupPolicySettingMappingsCollectionRequest is request for GroupPolicySettingMapping collection
type GroupPolicyMigrationReportGroupPolicySettingMappingsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for GroupPolicySettingMapping collection
func (r *GroupPolicyMigrationReportGroupPolicySettingMappingsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]GroupPolicySettingMapping, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []GroupPolicySettingMapping
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []GroupPolicySettingMapping
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for GroupPolicySettingMapping collection, max N pages
func (r *GroupPolicyMigrationReportGroupPolicySettingMappingsCollectionRequest) GetN(ctx context.Context, n int) ([]GroupPolicySettingMapping, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for GroupPolicySettingMapping collection
func (r *GroupPolicyMigrationReportGroupPolicySettingMappingsCollectionRequest) Get(ctx context.Context) ([]GroupPolicySettingMapping, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for GroupPolicySettingMapping collection
func (r *GroupPolicyMigrationReportGroupPolicySettingMappingsCollectionRequest) Add(ctx context.Context, reqObj *GroupPolicySettingMapping) (resObj *GroupPolicySettingMapping, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Definition is navigation property
func (b *GroupPolicyPresentationRequestBuilder) Definition() *GroupPolicyDefinitionRequestBuilder {
	bb := &GroupPolicyDefinitionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/definition"
	return bb
}

// DefinitionValue is navigation property
func (b *GroupPolicyPresentationValueRequestBuilder) DefinitionValue() *GroupPolicyDefinitionValueRequestBuilder {
	bb := &GroupPolicyDefinitionValueRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/definitionValue"
	return bb
}

// Presentation is navigation property
func (b *GroupPolicyPresentationValueRequestBuilder) Presentation() *GroupPolicyPresentationRequestBuilder {
	bb := &GroupPolicyPresentationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/presentation"
	return bb
}
