// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import (
	"context"
	"fmt"
	"io/ioutil"
	"net/http"

	"github.com/yaegashi/msgraph.go/jsonx"
)

// WindowsAutopilotDeploymentProfileCollectionHasPayloadLinksRequestParameter undocumented
type WindowsAutopilotDeploymentProfileCollectionHasPayloadLinksRequestParameter struct {
	// PayloadIDs undocumented
	PayloadIDs []string `json:"payloadIds,omitempty"`
}

// WindowsAutopilotDeploymentProfileAssignRequestParameter undocumented
type WindowsAutopilotDeploymentProfileAssignRequestParameter struct {
	// DeviceIDs undocumented
	DeviceIDs []string `json:"deviceIds,omitempty"`
}

// WindowsAutopilotDeviceIdentityAssignUserToDeviceRequestParameter undocumented
type WindowsAutopilotDeviceIdentityAssignUserToDeviceRequestParameter struct {
	// UserPrincipalName undocumented
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// AddressableUserName undocumented
	AddressableUserName *string `json:"addressableUserName,omitempty"`
}

// WindowsAutopilotDeviceIdentityUnassignUserFromDeviceRequestParameter undocumented
type WindowsAutopilotDeviceIdentityUnassignUserFromDeviceRequestParameter struct {
}

// WindowsAutopilotDeviceIdentityUpdateDevicePropertiesRequestParameter undocumented
type WindowsAutopilotDeviceIdentityUpdateDevicePropertiesRequestParameter struct {
	// UserPrincipalName undocumented
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// AddressableUserName undocumented
	AddressableUserName *string `json:"addressableUserName,omitempty"`
	// GroupTag undocumented
	GroupTag *string `json:"groupTag,omitempty"`
	// DisplayName undocumented
	DisplayName *string `json:"displayName,omitempty"`
}

// WindowsAutopilotDeviceIdentityAssignResourceAccountToDeviceRequestParameter undocumented
type WindowsAutopilotDeviceIdentityAssignResourceAccountToDeviceRequestParameter struct {
	// UserPrincipalName undocumented
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// AddressableUserName undocumented
	AddressableUserName *string `json:"addressableUserName,omitempty"`
	// ResourceAccountName undocumented
	ResourceAccountName *string `json:"resourceAccountName,omitempty"`
}

// WindowsAutopilotDeviceIdentityUnassignResourceAccountFromDeviceRequestParameter undocumented
type WindowsAutopilotDeviceIdentityUnassignResourceAccountFromDeviceRequestParameter struct {
}

// WindowsAutopilotSettingsSyncRequestParameter undocumented
type WindowsAutopilotSettingsSyncRequestParameter struct {
}

// WindowsDefenderApplicationControlSupplementalPolicyAssignRequestParameter undocumented
type WindowsDefenderApplicationControlSupplementalPolicyAssignRequestParameter struct {
	// WdacPolicyAssignments undocumented
	WdacPolicyAssignments []WindowsDefenderApplicationControlSupplementalPolicyAssignment `json:"wdacPolicyAssignments,omitempty"`
}

// WindowsFeatureUpdateProfileAssignRequestParameter undocumented
type WindowsFeatureUpdateProfileAssignRequestParameter struct {
	// Assignments undocumented
	Assignments []WindowsFeatureUpdateProfileAssignment `json:"assignments,omitempty"`
}

// WindowsInformationProtectionAssignRequestParameter undocumented
type WindowsInformationProtectionAssignRequestParameter struct {
	// Assignments undocumented
	Assignments []TargetedManagedAppPolicyAssignment `json:"assignments,omitempty"`
}

// WindowsInformationProtectionDeviceRegistrationWipeRequestParameter undocumented
type WindowsInformationProtectionDeviceRegistrationWipeRequestParameter struct {
}

// WindowsUpdateForBusinessConfigurationExtendFeatureUpdatesPauseRequestParameter undocumented
type WindowsUpdateForBusinessConfigurationExtendFeatureUpdatesPauseRequestParameter struct {
}

// WindowsUpdateForBusinessConfigurationExtendQualityUpdatesPauseRequestParameter undocumented
type WindowsUpdateForBusinessConfigurationExtendQualityUpdatesPauseRequestParameter struct {
}

// AssignedDevices returns request builder for WindowsAutopilotDeviceIdentity collection
func (b *WindowsAutopilotDeploymentProfileRequestBuilder) AssignedDevices() *WindowsAutopilotDeploymentProfileAssignedDevicesCollectionRequestBuilder {
	bb := &WindowsAutopilotDeploymentProfileAssignedDevicesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/assignedDevices"
	return bb
}

// WindowsAutopilotDeploymentProfileAssignedDevicesCollectionRequestBuilder is request builder for WindowsAutopilotDeviceIdentity collection
type WindowsAutopilotDeploymentProfileAssignedDevicesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for WindowsAutopilotDeviceIdentity collection
func (b *WindowsAutopilotDeploymentProfileAssignedDevicesCollectionRequestBuilder) Request() *WindowsAutopilotDeploymentProfileAssignedDevicesCollectionRequest {
	return &WindowsAutopilotDeploymentProfileAssignedDevicesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for WindowsAutopilotDeviceIdentity item
func (b *WindowsAutopilotDeploymentProfileAssignedDevicesCollectionRequestBuilder) ID(id string) *WindowsAutopilotDeviceIdentityRequestBuilder {
	bb := &WindowsAutopilotDeviceIdentityRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// WindowsAutopilotDeploymentProfileAssignedDevicesCollectionRequest is request for WindowsAutopilotDeviceIdentity collection
type WindowsAutopilotDeploymentProfileAssignedDevicesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for WindowsAutopilotDeviceIdentity collection
func (r *WindowsAutopilotDeploymentProfileAssignedDevicesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]WindowsAutopilotDeviceIdentity, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []WindowsAutopilotDeviceIdentity
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []WindowsAutopilotDeviceIdentity
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for WindowsAutopilotDeviceIdentity collection, max N pages
func (r *WindowsAutopilotDeploymentProfileAssignedDevicesCollectionRequest) GetN(ctx context.Context, n int) ([]WindowsAutopilotDeviceIdentity, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for WindowsAutopilotDeviceIdentity collection
func (r *WindowsAutopilotDeploymentProfileAssignedDevicesCollectionRequest) Get(ctx context.Context) ([]WindowsAutopilotDeviceIdentity, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for WindowsAutopilotDeviceIdentity collection
func (r *WindowsAutopilotDeploymentProfileAssignedDevicesCollectionRequest) Add(ctx context.Context, reqObj *WindowsAutopilotDeviceIdentity) (resObj *WindowsAutopilotDeviceIdentity, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Assignments returns request builder for WindowsAutopilotDeploymentProfileAssignment collection
func (b *WindowsAutopilotDeploymentProfileRequestBuilder) Assignments() *WindowsAutopilotDeploymentProfileAssignmentsCollectionRequestBuilder {
	bb := &WindowsAutopilotDeploymentProfileAssignmentsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/assignments"
	return bb
}

// WindowsAutopilotDeploymentProfileAssignmentsCollectionRequestBuilder is request builder for WindowsAutopilotDeploymentProfileAssignment collection
type WindowsAutopilotDeploymentProfileAssignmentsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for WindowsAutopilotDeploymentProfileAssignment collection
func (b *WindowsAutopilotDeploymentProfileAssignmentsCollectionRequestBuilder) Request() *WindowsAutopilotDeploymentProfileAssignmentsCollectionRequest {
	return &WindowsAutopilotDeploymentProfileAssignmentsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for WindowsAutopilotDeploymentProfileAssignment item
func (b *WindowsAutopilotDeploymentProfileAssignmentsCollectionRequestBuilder) ID(id string) *WindowsAutopilotDeploymentProfileAssignmentRequestBuilder {
	bb := &WindowsAutopilotDeploymentProfileAssignmentRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// WindowsAutopilotDeploymentProfileAssignmentsCollectionRequest is request for WindowsAutopilotDeploymentProfileAssignment collection
type WindowsAutopilotDeploymentProfileAssignmentsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for WindowsAutopilotDeploymentProfileAssignment collection
func (r *WindowsAutopilotDeploymentProfileAssignmentsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]WindowsAutopilotDeploymentProfileAssignment, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []WindowsAutopilotDeploymentProfileAssignment
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []WindowsAutopilotDeploymentProfileAssignment
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for WindowsAutopilotDeploymentProfileAssignment collection, max N pages
func (r *WindowsAutopilotDeploymentProfileAssignmentsCollectionRequest) GetN(ctx context.Context, n int) ([]WindowsAutopilotDeploymentProfileAssignment, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for WindowsAutopilotDeploymentProfileAssignment collection
func (r *WindowsAutopilotDeploymentProfileAssignmentsCollectionRequest) Get(ctx context.Context) ([]WindowsAutopilotDeploymentProfileAssignment, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for WindowsAutopilotDeploymentProfileAssignment collection
func (r *WindowsAutopilotDeploymentProfileAssignmentsCollectionRequest) Add(ctx context.Context, reqObj *WindowsAutopilotDeploymentProfileAssignment) (resObj *WindowsAutopilotDeploymentProfileAssignment, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// DeploymentProfile is navigation property
func (b *WindowsAutopilotDeviceIdentityRequestBuilder) DeploymentProfile() *WindowsAutopilotDeploymentProfileRequestBuilder {
	bb := &WindowsAutopilotDeploymentProfileRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/deploymentProfile"
	return bb
}

// IntendedDeploymentProfile is navigation property
func (b *WindowsAutopilotDeviceIdentityRequestBuilder) IntendedDeploymentProfile() *WindowsAutopilotDeploymentProfileRequestBuilder {
	bb := &WindowsAutopilotDeploymentProfileRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/intendedDeploymentProfile"
	return bb
}

// Assignments returns request builder for WindowsDefenderApplicationControlSupplementalPolicyAssignment collection
func (b *WindowsDefenderApplicationControlSupplementalPolicyRequestBuilder) Assignments() *WindowsDefenderApplicationControlSupplementalPolicyAssignmentsCollectionRequestBuilder {
	bb := &WindowsDefenderApplicationControlSupplementalPolicyAssignmentsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/assignments"
	return bb
}

// WindowsDefenderApplicationControlSupplementalPolicyAssignmentsCollectionRequestBuilder is request builder for WindowsDefenderApplicationControlSupplementalPolicyAssignment collection
type WindowsDefenderApplicationControlSupplementalPolicyAssignmentsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for WindowsDefenderApplicationControlSupplementalPolicyAssignment collection
func (b *WindowsDefenderApplicationControlSupplementalPolicyAssignmentsCollectionRequestBuilder) Request() *WindowsDefenderApplicationControlSupplementalPolicyAssignmentsCollectionRequest {
	return &WindowsDefenderApplicationControlSupplementalPolicyAssignmentsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for WindowsDefenderApplicationControlSupplementalPolicyAssignment item
func (b *WindowsDefenderApplicationControlSupplementalPolicyAssignmentsCollectionRequestBuilder) ID(id string) *WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequestBuilder {
	bb := &WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// WindowsDefenderApplicationControlSupplementalPolicyAssignmentsCollectionRequest is request for WindowsDefenderApplicationControlSupplementalPolicyAssignment collection
type WindowsDefenderApplicationControlSupplementalPolicyAssignmentsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for WindowsDefenderApplicationControlSupplementalPolicyAssignment collection
func (r *WindowsDefenderApplicationControlSupplementalPolicyAssignmentsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]WindowsDefenderApplicationControlSupplementalPolicyAssignment, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []WindowsDefenderApplicationControlSupplementalPolicyAssignment
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []WindowsDefenderApplicationControlSupplementalPolicyAssignment
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for WindowsDefenderApplicationControlSupplementalPolicyAssignment collection, max N pages
func (r *WindowsDefenderApplicationControlSupplementalPolicyAssignmentsCollectionRequest) GetN(ctx context.Context, n int) ([]WindowsDefenderApplicationControlSupplementalPolicyAssignment, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for WindowsDefenderApplicationControlSupplementalPolicyAssignment collection
func (r *WindowsDefenderApplicationControlSupplementalPolicyAssignmentsCollectionRequest) Get(ctx context.Context) ([]WindowsDefenderApplicationControlSupplementalPolicyAssignment, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for WindowsDefenderApplicationControlSupplementalPolicyAssignment collection
func (r *WindowsDefenderApplicationControlSupplementalPolicyAssignmentsCollectionRequest) Add(ctx context.Context, reqObj *WindowsDefenderApplicationControlSupplementalPolicyAssignment) (resObj *WindowsDefenderApplicationControlSupplementalPolicyAssignment, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// DeploySummary is navigation property
func (b *WindowsDefenderApplicationControlSupplementalPolicyRequestBuilder) DeploySummary() *WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummaryRequestBuilder {
	bb := &WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummaryRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/deploySummary"
	return bb
}

// DeviceStatuses returns request builder for WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus collection
func (b *WindowsDefenderApplicationControlSupplementalPolicyRequestBuilder) DeviceStatuses() *WindowsDefenderApplicationControlSupplementalPolicyDeviceStatusesCollectionRequestBuilder {
	bb := &WindowsDefenderApplicationControlSupplementalPolicyDeviceStatusesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/deviceStatuses"
	return bb
}

// WindowsDefenderApplicationControlSupplementalPolicyDeviceStatusesCollectionRequestBuilder is request builder for WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus collection
type WindowsDefenderApplicationControlSupplementalPolicyDeviceStatusesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus collection
func (b *WindowsDefenderApplicationControlSupplementalPolicyDeviceStatusesCollectionRequestBuilder) Request() *WindowsDefenderApplicationControlSupplementalPolicyDeviceStatusesCollectionRequest {
	return &WindowsDefenderApplicationControlSupplementalPolicyDeviceStatusesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus item
func (b *WindowsDefenderApplicationControlSupplementalPolicyDeviceStatusesCollectionRequestBuilder) ID(id string) *WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequestBuilder {
	bb := &WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// WindowsDefenderApplicationControlSupplementalPolicyDeviceStatusesCollectionRequest is request for WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus collection
type WindowsDefenderApplicationControlSupplementalPolicyDeviceStatusesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus collection
func (r *WindowsDefenderApplicationControlSupplementalPolicyDeviceStatusesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus collection, max N pages
func (r *WindowsDefenderApplicationControlSupplementalPolicyDeviceStatusesCollectionRequest) GetN(ctx context.Context, n int) ([]WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus collection
func (r *WindowsDefenderApplicationControlSupplementalPolicyDeviceStatusesCollectionRequest) Get(ctx context.Context) ([]WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus collection
func (r *WindowsDefenderApplicationControlSupplementalPolicyDeviceStatusesCollectionRequest) Add(ctx context.Context, reqObj *WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus) (resObj *WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Policy is navigation property
func (b *WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequestBuilder) Policy() *WindowsDefenderApplicationControlSupplementalPolicyRequestBuilder {
	bb := &WindowsDefenderApplicationControlSupplementalPolicyRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/policy"
	return bb
}

// NetworkAccessConfigurations returns request builder for DeviceConfiguration collection
func (b *WindowsDomainJoinConfigurationRequestBuilder) NetworkAccessConfigurations() *WindowsDomainJoinConfigurationNetworkAccessConfigurationsCollectionRequestBuilder {
	bb := &WindowsDomainJoinConfigurationNetworkAccessConfigurationsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/networkAccessConfigurations"
	return bb
}

// WindowsDomainJoinConfigurationNetworkAccessConfigurationsCollectionRequestBuilder is request builder for DeviceConfiguration collection
type WindowsDomainJoinConfigurationNetworkAccessConfigurationsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DeviceConfiguration collection
func (b *WindowsDomainJoinConfigurationNetworkAccessConfigurationsCollectionRequestBuilder) Request() *WindowsDomainJoinConfigurationNetworkAccessConfigurationsCollectionRequest {
	return &WindowsDomainJoinConfigurationNetworkAccessConfigurationsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DeviceConfiguration item
func (b *WindowsDomainJoinConfigurationNetworkAccessConfigurationsCollectionRequestBuilder) ID(id string) *DeviceConfigurationRequestBuilder {
	bb := &DeviceConfigurationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// WindowsDomainJoinConfigurationNetworkAccessConfigurationsCollectionRequest is request for DeviceConfiguration collection
type WindowsDomainJoinConfigurationNetworkAccessConfigurationsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DeviceConfiguration collection
func (r *WindowsDomainJoinConfigurationNetworkAccessConfigurationsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DeviceConfiguration, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DeviceConfiguration
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DeviceConfiguration
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DeviceConfiguration collection, max N pages
func (r *WindowsDomainJoinConfigurationNetworkAccessConfigurationsCollectionRequest) GetN(ctx context.Context, n int) ([]DeviceConfiguration, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DeviceConfiguration collection
func (r *WindowsDomainJoinConfigurationNetworkAccessConfigurationsCollectionRequest) Get(ctx context.Context) ([]DeviceConfiguration, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DeviceConfiguration collection
func (r *WindowsDomainJoinConfigurationNetworkAccessConfigurationsCollectionRequest) Add(ctx context.Context, reqObj *DeviceConfiguration) (resObj *DeviceConfiguration, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Assignments returns request builder for WindowsFeatureUpdateProfileAssignment collection
func (b *WindowsFeatureUpdateProfileRequestBuilder) Assignments() *WindowsFeatureUpdateProfileAssignmentsCollectionRequestBuilder {
	bb := &WindowsFeatureUpdateProfileAssignmentsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/assignments"
	return bb
}

// WindowsFeatureUpdateProfileAssignmentsCollectionRequestBuilder is request builder for WindowsFeatureUpdateProfileAssignment collection
type WindowsFeatureUpdateProfileAssignmentsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for WindowsFeatureUpdateProfileAssignment collection
func (b *WindowsFeatureUpdateProfileAssignmentsCollectionRequestBuilder) Request() *WindowsFeatureUpdateProfileAssignmentsCollectionRequest {
	return &WindowsFeatureUpdateProfileAssignmentsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for WindowsFeatureUpdateProfileAssignment item
func (b *WindowsFeatureUpdateProfileAssignmentsCollectionRequestBuilder) ID(id string) *WindowsFeatureUpdateProfileAssignmentRequestBuilder {
	bb := &WindowsFeatureUpdateProfileAssignmentRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// WindowsFeatureUpdateProfileAssignmentsCollectionRequest is request for WindowsFeatureUpdateProfileAssignment collection
type WindowsFeatureUpdateProfileAssignmentsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for WindowsFeatureUpdateProfileAssignment collection
func (r *WindowsFeatureUpdateProfileAssignmentsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]WindowsFeatureUpdateProfileAssignment, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []WindowsFeatureUpdateProfileAssignment
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []WindowsFeatureUpdateProfileAssignment
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for WindowsFeatureUpdateProfileAssignment collection, max N pages
func (r *WindowsFeatureUpdateProfileAssignmentsCollectionRequest) GetN(ctx context.Context, n int) ([]WindowsFeatureUpdateProfileAssignment, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for WindowsFeatureUpdateProfileAssignment collection
func (r *WindowsFeatureUpdateProfileAssignmentsCollectionRequest) Get(ctx context.Context) ([]WindowsFeatureUpdateProfileAssignment, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for WindowsFeatureUpdateProfileAssignment collection
func (r *WindowsFeatureUpdateProfileAssignmentsCollectionRequest) Add(ctx context.Context, reqObj *WindowsFeatureUpdateProfileAssignment) (resObj *WindowsFeatureUpdateProfileAssignment, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// DeviceUpdateStates returns request builder for WindowsUpdateState collection
func (b *WindowsFeatureUpdateProfileRequestBuilder) DeviceUpdateStates() *WindowsFeatureUpdateProfileDeviceUpdateStatesCollectionRequestBuilder {
	bb := &WindowsFeatureUpdateProfileDeviceUpdateStatesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/deviceUpdateStates"
	return bb
}

// WindowsFeatureUpdateProfileDeviceUpdateStatesCollectionRequestBuilder is request builder for WindowsUpdateState collection
type WindowsFeatureUpdateProfileDeviceUpdateStatesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for WindowsUpdateState collection
func (b *WindowsFeatureUpdateProfileDeviceUpdateStatesCollectionRequestBuilder) Request() *WindowsFeatureUpdateProfileDeviceUpdateStatesCollectionRequest {
	return &WindowsFeatureUpdateProfileDeviceUpdateStatesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for WindowsUpdateState item
func (b *WindowsFeatureUpdateProfileDeviceUpdateStatesCollectionRequestBuilder) ID(id string) *WindowsUpdateStateRequestBuilder {
	bb := &WindowsUpdateStateRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// WindowsFeatureUpdateProfileDeviceUpdateStatesCollectionRequest is request for WindowsUpdateState collection
type WindowsFeatureUpdateProfileDeviceUpdateStatesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for WindowsUpdateState collection
func (r *WindowsFeatureUpdateProfileDeviceUpdateStatesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]WindowsUpdateState, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []WindowsUpdateState
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []WindowsUpdateState
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for WindowsUpdateState collection, max N pages
func (r *WindowsFeatureUpdateProfileDeviceUpdateStatesCollectionRequest) GetN(ctx context.Context, n int) ([]WindowsUpdateState, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for WindowsUpdateState collection
func (r *WindowsFeatureUpdateProfileDeviceUpdateStatesCollectionRequest) Get(ctx context.Context) ([]WindowsUpdateState, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for WindowsUpdateState collection
func (r *WindowsFeatureUpdateProfileDeviceUpdateStatesCollectionRequest) Add(ctx context.Context, reqObj *WindowsUpdateState) (resObj *WindowsUpdateState, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Assignments returns request builder for TargetedManagedAppPolicyAssignment collection
func (b *WindowsInformationProtectionRequestBuilder) Assignments() *WindowsInformationProtectionAssignmentsCollectionRequestBuilder {
	bb := &WindowsInformationProtectionAssignmentsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/assignments"
	return bb
}

// WindowsInformationProtectionAssignmentsCollectionRequestBuilder is request builder for TargetedManagedAppPolicyAssignment collection
type WindowsInformationProtectionAssignmentsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for TargetedManagedAppPolicyAssignment collection
func (b *WindowsInformationProtectionAssignmentsCollectionRequestBuilder) Request() *WindowsInformationProtectionAssignmentsCollectionRequest {
	return &WindowsInformationProtectionAssignmentsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for TargetedManagedAppPolicyAssignment item
func (b *WindowsInformationProtectionAssignmentsCollectionRequestBuilder) ID(id string) *TargetedManagedAppPolicyAssignmentRequestBuilder {
	bb := &TargetedManagedAppPolicyAssignmentRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// WindowsInformationProtectionAssignmentsCollectionRequest is request for TargetedManagedAppPolicyAssignment collection
type WindowsInformationProtectionAssignmentsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for TargetedManagedAppPolicyAssignment collection
func (r *WindowsInformationProtectionAssignmentsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]TargetedManagedAppPolicyAssignment, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []TargetedManagedAppPolicyAssignment
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []TargetedManagedAppPolicyAssignment
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for TargetedManagedAppPolicyAssignment collection, max N pages
func (r *WindowsInformationProtectionAssignmentsCollectionRequest) GetN(ctx context.Context, n int) ([]TargetedManagedAppPolicyAssignment, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for TargetedManagedAppPolicyAssignment collection
func (r *WindowsInformationProtectionAssignmentsCollectionRequest) Get(ctx context.Context) ([]TargetedManagedAppPolicyAssignment, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for TargetedManagedAppPolicyAssignment collection
func (r *WindowsInformationProtectionAssignmentsCollectionRequest) Add(ctx context.Context, reqObj *TargetedManagedAppPolicyAssignment) (resObj *TargetedManagedAppPolicyAssignment, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ExemptAppLockerFiles returns request builder for WindowsInformationProtectionAppLockerFile collection
func (b *WindowsInformationProtectionRequestBuilder) ExemptAppLockerFiles() *WindowsInformationProtectionExemptAppLockerFilesCollectionRequestBuilder {
	bb := &WindowsInformationProtectionExemptAppLockerFilesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/exemptAppLockerFiles"
	return bb
}

// WindowsInformationProtectionExemptAppLockerFilesCollectionRequestBuilder is request builder for WindowsInformationProtectionAppLockerFile collection
type WindowsInformationProtectionExemptAppLockerFilesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for WindowsInformationProtectionAppLockerFile collection
func (b *WindowsInformationProtectionExemptAppLockerFilesCollectionRequestBuilder) Request() *WindowsInformationProtectionExemptAppLockerFilesCollectionRequest {
	return &WindowsInformationProtectionExemptAppLockerFilesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for WindowsInformationProtectionAppLockerFile item
func (b *WindowsInformationProtectionExemptAppLockerFilesCollectionRequestBuilder) ID(id string) *WindowsInformationProtectionAppLockerFileRequestBuilder {
	bb := &WindowsInformationProtectionAppLockerFileRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// WindowsInformationProtectionExemptAppLockerFilesCollectionRequest is request for WindowsInformationProtectionAppLockerFile collection
type WindowsInformationProtectionExemptAppLockerFilesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for WindowsInformationProtectionAppLockerFile collection
func (r *WindowsInformationProtectionExemptAppLockerFilesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]WindowsInformationProtectionAppLockerFile, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []WindowsInformationProtectionAppLockerFile
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []WindowsInformationProtectionAppLockerFile
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for WindowsInformationProtectionAppLockerFile collection, max N pages
func (r *WindowsInformationProtectionExemptAppLockerFilesCollectionRequest) GetN(ctx context.Context, n int) ([]WindowsInformationProtectionAppLockerFile, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for WindowsInformationProtectionAppLockerFile collection
func (r *WindowsInformationProtectionExemptAppLockerFilesCollectionRequest) Get(ctx context.Context) ([]WindowsInformationProtectionAppLockerFile, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for WindowsInformationProtectionAppLockerFile collection
func (r *WindowsInformationProtectionExemptAppLockerFilesCollectionRequest) Add(ctx context.Context, reqObj *WindowsInformationProtectionAppLockerFile) (resObj *WindowsInformationProtectionAppLockerFile, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ProtectedAppLockerFiles returns request builder for WindowsInformationProtectionAppLockerFile collection
func (b *WindowsInformationProtectionRequestBuilder) ProtectedAppLockerFiles() *WindowsInformationProtectionProtectedAppLockerFilesCollectionRequestBuilder {
	bb := &WindowsInformationProtectionProtectedAppLockerFilesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/protectedAppLockerFiles"
	return bb
}

// WindowsInformationProtectionProtectedAppLockerFilesCollectionRequestBuilder is request builder for WindowsInformationProtectionAppLockerFile collection
type WindowsInformationProtectionProtectedAppLockerFilesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for WindowsInformationProtectionAppLockerFile collection
func (b *WindowsInformationProtectionProtectedAppLockerFilesCollectionRequestBuilder) Request() *WindowsInformationProtectionProtectedAppLockerFilesCollectionRequest {
	return &WindowsInformationProtectionProtectedAppLockerFilesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for WindowsInformationProtectionAppLockerFile item
func (b *WindowsInformationProtectionProtectedAppLockerFilesCollectionRequestBuilder) ID(id string) *WindowsInformationProtectionAppLockerFileRequestBuilder {
	bb := &WindowsInformationProtectionAppLockerFileRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// WindowsInformationProtectionProtectedAppLockerFilesCollectionRequest is request for WindowsInformationProtectionAppLockerFile collection
type WindowsInformationProtectionProtectedAppLockerFilesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for WindowsInformationProtectionAppLockerFile collection
func (r *WindowsInformationProtectionProtectedAppLockerFilesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]WindowsInformationProtectionAppLockerFile, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []WindowsInformationProtectionAppLockerFile
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []WindowsInformationProtectionAppLockerFile
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for WindowsInformationProtectionAppLockerFile collection, max N pages
func (r *WindowsInformationProtectionProtectedAppLockerFilesCollectionRequest) GetN(ctx context.Context, n int) ([]WindowsInformationProtectionAppLockerFile, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for WindowsInformationProtectionAppLockerFile collection
func (r *WindowsInformationProtectionProtectedAppLockerFilesCollectionRequest) Get(ctx context.Context) ([]WindowsInformationProtectionAppLockerFile, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for WindowsInformationProtectionAppLockerFile collection
func (r *WindowsInformationProtectionProtectedAppLockerFilesCollectionRequest) Add(ctx context.Context, reqObj *WindowsInformationProtectionAppLockerFile) (resObj *WindowsInformationProtectionAppLockerFile, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// WindowsDevicesProtectionState returns request builder for WindowsProtectionState collection
func (b *WindowsMalwareInformationRequestBuilder) WindowsDevicesProtectionState() *WindowsMalwareInformationWindowsDevicesProtectionStateCollectionRequestBuilder {
	bb := &WindowsMalwareInformationWindowsDevicesProtectionStateCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/windowsDevicesProtectionState"
	return bb
}

// WindowsMalwareInformationWindowsDevicesProtectionStateCollectionRequestBuilder is request builder for WindowsProtectionState collection
type WindowsMalwareInformationWindowsDevicesProtectionStateCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for WindowsProtectionState collection
func (b *WindowsMalwareInformationWindowsDevicesProtectionStateCollectionRequestBuilder) Request() *WindowsMalwareInformationWindowsDevicesProtectionStateCollectionRequest {
	return &WindowsMalwareInformationWindowsDevicesProtectionStateCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for WindowsProtectionState item
func (b *WindowsMalwareInformationWindowsDevicesProtectionStateCollectionRequestBuilder) ID(id string) *WindowsProtectionStateRequestBuilder {
	bb := &WindowsProtectionStateRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// WindowsMalwareInformationWindowsDevicesProtectionStateCollectionRequest is request for WindowsProtectionState collection
type WindowsMalwareInformationWindowsDevicesProtectionStateCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for WindowsProtectionState collection
func (r *WindowsMalwareInformationWindowsDevicesProtectionStateCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]WindowsProtectionState, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []WindowsProtectionState
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []WindowsProtectionState
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for WindowsProtectionState collection, max N pages
func (r *WindowsMalwareInformationWindowsDevicesProtectionStateCollectionRequest) GetN(ctx context.Context, n int) ([]WindowsProtectionState, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for WindowsProtectionState collection
func (r *WindowsMalwareInformationWindowsDevicesProtectionStateCollectionRequest) Get(ctx context.Context) ([]WindowsProtectionState, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for WindowsProtectionState collection
func (r *WindowsMalwareInformationWindowsDevicesProtectionStateCollectionRequest) Add(ctx context.Context, reqObj *WindowsProtectionState) (resObj *WindowsProtectionState, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// HealthStates returns request builder for WindowsManagementAppHealthState collection
func (b *WindowsManagementAppRequestBuilder) HealthStates() *WindowsManagementAppHealthStatesCollectionRequestBuilder {
	bb := &WindowsManagementAppHealthStatesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/healthStates"
	return bb
}

// WindowsManagementAppHealthStatesCollectionRequestBuilder is request builder for WindowsManagementAppHealthState collection
type WindowsManagementAppHealthStatesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for WindowsManagementAppHealthState collection
func (b *WindowsManagementAppHealthStatesCollectionRequestBuilder) Request() *WindowsManagementAppHealthStatesCollectionRequest {
	return &WindowsManagementAppHealthStatesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for WindowsManagementAppHealthState item
func (b *WindowsManagementAppHealthStatesCollectionRequestBuilder) ID(id string) *WindowsManagementAppHealthStateRequestBuilder {
	bb := &WindowsManagementAppHealthStateRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// WindowsManagementAppHealthStatesCollectionRequest is request for WindowsManagementAppHealthState collection
type WindowsManagementAppHealthStatesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for WindowsManagementAppHealthState collection
func (r *WindowsManagementAppHealthStatesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]WindowsManagementAppHealthState, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []WindowsManagementAppHealthState
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []WindowsManagementAppHealthState
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for WindowsManagementAppHealthState collection, max N pages
func (r *WindowsManagementAppHealthStatesCollectionRequest) GetN(ctx context.Context, n int) ([]WindowsManagementAppHealthState, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for WindowsManagementAppHealthState collection
func (r *WindowsManagementAppHealthStatesCollectionRequest) Get(ctx context.Context) ([]WindowsManagementAppHealthState, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for WindowsManagementAppHealthState collection
func (r *WindowsManagementAppHealthStatesCollectionRequest) Add(ctx context.Context, reqObj *WindowsManagementAppHealthState) (resObj *WindowsManagementAppHealthState, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ManagedDeviceCertificateStates returns request builder for ManagedDeviceCertificateState collection
func (b *WindowsPhone81ImportedPFXCertificateProfileRequestBuilder) ManagedDeviceCertificateStates() *WindowsPhone81ImportedPFXCertificateProfileManagedDeviceCertificateStatesCollectionRequestBuilder {
	bb := &WindowsPhone81ImportedPFXCertificateProfileManagedDeviceCertificateStatesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/managedDeviceCertificateStates"
	return bb
}

// WindowsPhone81ImportedPFXCertificateProfileManagedDeviceCertificateStatesCollectionRequestBuilder is request builder for ManagedDeviceCertificateState collection
type WindowsPhone81ImportedPFXCertificateProfileManagedDeviceCertificateStatesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ManagedDeviceCertificateState collection
func (b *WindowsPhone81ImportedPFXCertificateProfileManagedDeviceCertificateStatesCollectionRequestBuilder) Request() *WindowsPhone81ImportedPFXCertificateProfileManagedDeviceCertificateStatesCollectionRequest {
	return &WindowsPhone81ImportedPFXCertificateProfileManagedDeviceCertificateStatesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ManagedDeviceCertificateState item
func (b *WindowsPhone81ImportedPFXCertificateProfileManagedDeviceCertificateStatesCollectionRequestBuilder) ID(id string) *ManagedDeviceCertificateStateRequestBuilder {
	bb := &ManagedDeviceCertificateStateRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// WindowsPhone81ImportedPFXCertificateProfileManagedDeviceCertificateStatesCollectionRequest is request for ManagedDeviceCertificateState collection
type WindowsPhone81ImportedPFXCertificateProfileManagedDeviceCertificateStatesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ManagedDeviceCertificateState collection
func (r *WindowsPhone81ImportedPFXCertificateProfileManagedDeviceCertificateStatesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ManagedDeviceCertificateState, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ManagedDeviceCertificateState
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ManagedDeviceCertificateState
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ManagedDeviceCertificateState collection, max N pages
func (r *WindowsPhone81ImportedPFXCertificateProfileManagedDeviceCertificateStatesCollectionRequest) GetN(ctx context.Context, n int) ([]ManagedDeviceCertificateState, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ManagedDeviceCertificateState collection
func (r *WindowsPhone81ImportedPFXCertificateProfileManagedDeviceCertificateStatesCollectionRequest) Get(ctx context.Context) ([]ManagedDeviceCertificateState, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ManagedDeviceCertificateState collection
func (r *WindowsPhone81ImportedPFXCertificateProfileManagedDeviceCertificateStatesCollectionRequest) Add(ctx context.Context, reqObj *ManagedDeviceCertificateState) (resObj *ManagedDeviceCertificateState, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ManagedDeviceCertificateStates returns request builder for ManagedDeviceCertificateState collection
func (b *WindowsPhone81SCEPCertificateProfileRequestBuilder) ManagedDeviceCertificateStates() *WindowsPhone81SCEPCertificateProfileManagedDeviceCertificateStatesCollectionRequestBuilder {
	bb := &WindowsPhone81SCEPCertificateProfileManagedDeviceCertificateStatesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/managedDeviceCertificateStates"
	return bb
}

// WindowsPhone81SCEPCertificateProfileManagedDeviceCertificateStatesCollectionRequestBuilder is request builder for ManagedDeviceCertificateState collection
type WindowsPhone81SCEPCertificateProfileManagedDeviceCertificateStatesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ManagedDeviceCertificateState collection
func (b *WindowsPhone81SCEPCertificateProfileManagedDeviceCertificateStatesCollectionRequestBuilder) Request() *WindowsPhone81SCEPCertificateProfileManagedDeviceCertificateStatesCollectionRequest {
	return &WindowsPhone81SCEPCertificateProfileManagedDeviceCertificateStatesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ManagedDeviceCertificateState item
func (b *WindowsPhone81SCEPCertificateProfileManagedDeviceCertificateStatesCollectionRequestBuilder) ID(id string) *ManagedDeviceCertificateStateRequestBuilder {
	bb := &ManagedDeviceCertificateStateRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// WindowsPhone81SCEPCertificateProfileManagedDeviceCertificateStatesCollectionRequest is request for ManagedDeviceCertificateState collection
type WindowsPhone81SCEPCertificateProfileManagedDeviceCertificateStatesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ManagedDeviceCertificateState collection
func (r *WindowsPhone81SCEPCertificateProfileManagedDeviceCertificateStatesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ManagedDeviceCertificateState, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ManagedDeviceCertificateState
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ManagedDeviceCertificateState
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ManagedDeviceCertificateState collection, max N pages
func (r *WindowsPhone81SCEPCertificateProfileManagedDeviceCertificateStatesCollectionRequest) GetN(ctx context.Context, n int) ([]ManagedDeviceCertificateState, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ManagedDeviceCertificateState collection
func (r *WindowsPhone81SCEPCertificateProfileManagedDeviceCertificateStatesCollectionRequest) Get(ctx context.Context) ([]ManagedDeviceCertificateState, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ManagedDeviceCertificateState collection
func (r *WindowsPhone81SCEPCertificateProfileManagedDeviceCertificateStatesCollectionRequest) Add(ctx context.Context, reqObj *ManagedDeviceCertificateState) (resObj *ManagedDeviceCertificateState, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// RootCertificate is navigation property
func (b *WindowsPhone81SCEPCertificateProfileRequestBuilder) RootCertificate() *WindowsPhone81TrustedRootCertificateRequestBuilder {
	bb := &WindowsPhone81TrustedRootCertificateRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/rootCertificate"
	return bb
}

// IdentityCertificate is navigation property
func (b *WindowsPhone81VpnConfigurationRequestBuilder) IdentityCertificate() *WindowsPhone81CertificateProfileBaseRequestBuilder {
	bb := &WindowsPhone81CertificateProfileBaseRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/identityCertificate"
	return bb
}

// DetectedMalwareState returns request builder for WindowsDeviceMalwareState collection
func (b *WindowsProtectionStateRequestBuilder) DetectedMalwareState() *WindowsProtectionStateDetectedMalwareStateCollectionRequestBuilder {
	bb := &WindowsProtectionStateDetectedMalwareStateCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/detectedMalwareState"
	return bb
}

// WindowsProtectionStateDetectedMalwareStateCollectionRequestBuilder is request builder for WindowsDeviceMalwareState collection
type WindowsProtectionStateDetectedMalwareStateCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for WindowsDeviceMalwareState collection
func (b *WindowsProtectionStateDetectedMalwareStateCollectionRequestBuilder) Request() *WindowsProtectionStateDetectedMalwareStateCollectionRequest {
	return &WindowsProtectionStateDetectedMalwareStateCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for WindowsDeviceMalwareState item
func (b *WindowsProtectionStateDetectedMalwareStateCollectionRequestBuilder) ID(id string) *WindowsDeviceMalwareStateRequestBuilder {
	bb := &WindowsDeviceMalwareStateRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// WindowsProtectionStateDetectedMalwareStateCollectionRequest is request for WindowsDeviceMalwareState collection
type WindowsProtectionStateDetectedMalwareStateCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for WindowsDeviceMalwareState collection
func (r *WindowsProtectionStateDetectedMalwareStateCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]WindowsDeviceMalwareState, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []WindowsDeviceMalwareState
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []WindowsDeviceMalwareState
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for WindowsDeviceMalwareState collection, max N pages
func (r *WindowsProtectionStateDetectedMalwareStateCollectionRequest) GetN(ctx context.Context, n int) ([]WindowsDeviceMalwareState, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for WindowsDeviceMalwareState collection
func (r *WindowsProtectionStateDetectedMalwareStateCollectionRequest) Get(ctx context.Context) ([]WindowsDeviceMalwareState, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for WindowsDeviceMalwareState collection
func (r *WindowsProtectionStateDetectedMalwareStateCollectionRequest) Add(ctx context.Context, reqObj *WindowsDeviceMalwareState) (resObj *WindowsDeviceMalwareState, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// CommittedContainedApps returns request builder for MobileContainedApp collection
func (b *WindowsUniversalAppXRequestBuilder) CommittedContainedApps() *WindowsUniversalAppXCommittedContainedAppsCollectionRequestBuilder {
	bb := &WindowsUniversalAppXCommittedContainedAppsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/committedContainedApps"
	return bb
}

// WindowsUniversalAppXCommittedContainedAppsCollectionRequestBuilder is request builder for MobileContainedApp collection
type WindowsUniversalAppXCommittedContainedAppsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for MobileContainedApp collection
func (b *WindowsUniversalAppXCommittedContainedAppsCollectionRequestBuilder) Request() *WindowsUniversalAppXCommittedContainedAppsCollectionRequest {
	return &WindowsUniversalAppXCommittedContainedAppsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for MobileContainedApp item
func (b *WindowsUniversalAppXCommittedContainedAppsCollectionRequestBuilder) ID(id string) *MobileContainedAppRequestBuilder {
	bb := &MobileContainedAppRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// WindowsUniversalAppXCommittedContainedAppsCollectionRequest is request for MobileContainedApp collection
type WindowsUniversalAppXCommittedContainedAppsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for MobileContainedApp collection
func (r *WindowsUniversalAppXCommittedContainedAppsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]MobileContainedApp, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []MobileContainedApp
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []MobileContainedApp
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for MobileContainedApp collection, max N pages
func (r *WindowsUniversalAppXCommittedContainedAppsCollectionRequest) GetN(ctx context.Context, n int) ([]MobileContainedApp, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for MobileContainedApp collection
func (r *WindowsUniversalAppXCommittedContainedAppsCollectionRequest) Get(ctx context.Context) ([]MobileContainedApp, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for MobileContainedApp collection
func (r *WindowsUniversalAppXCommittedContainedAppsCollectionRequest) Add(ctx context.Context, reqObj *MobileContainedApp) (resObj *MobileContainedApp, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// DeviceUpdateStates returns request builder for WindowsUpdateState collection
func (b *WindowsUpdateForBusinessConfigurationRequestBuilder) DeviceUpdateStates() *WindowsUpdateForBusinessConfigurationDeviceUpdateStatesCollectionRequestBuilder {
	bb := &WindowsUpdateForBusinessConfigurationDeviceUpdateStatesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/deviceUpdateStates"
	return bb
}

// WindowsUpdateForBusinessConfigurationDeviceUpdateStatesCollectionRequestBuilder is request builder for WindowsUpdateState collection
type WindowsUpdateForBusinessConfigurationDeviceUpdateStatesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for WindowsUpdateState collection
func (b *WindowsUpdateForBusinessConfigurationDeviceUpdateStatesCollectionRequestBuilder) Request() *WindowsUpdateForBusinessConfigurationDeviceUpdateStatesCollectionRequest {
	return &WindowsUpdateForBusinessConfigurationDeviceUpdateStatesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for WindowsUpdateState item
func (b *WindowsUpdateForBusinessConfigurationDeviceUpdateStatesCollectionRequestBuilder) ID(id string) *WindowsUpdateStateRequestBuilder {
	bb := &WindowsUpdateStateRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// WindowsUpdateForBusinessConfigurationDeviceUpdateStatesCollectionRequest is request for WindowsUpdateState collection
type WindowsUpdateForBusinessConfigurationDeviceUpdateStatesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for WindowsUpdateState collection
func (r *WindowsUpdateForBusinessConfigurationDeviceUpdateStatesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]WindowsUpdateState, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []WindowsUpdateState
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []WindowsUpdateState
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for WindowsUpdateState collection, max N pages
func (r *WindowsUpdateForBusinessConfigurationDeviceUpdateStatesCollectionRequest) GetN(ctx context.Context, n int) ([]WindowsUpdateState, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for WindowsUpdateState collection
func (r *WindowsUpdateForBusinessConfigurationDeviceUpdateStatesCollectionRequest) Get(ctx context.Context) ([]WindowsUpdateState, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for WindowsUpdateState collection
func (r *WindowsUpdateForBusinessConfigurationDeviceUpdateStatesCollectionRequest) Add(ctx context.Context, reqObj *WindowsUpdateState) (resObj *WindowsUpdateState, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// IdentityCertificateForClientAuthentication is navigation property
func (b *WindowsWiFiEnterpriseEAPConfigurationRequestBuilder) IdentityCertificateForClientAuthentication() *WindowsCertificateProfileBaseRequestBuilder {
	bb := &WindowsCertificateProfileBaseRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/identityCertificateForClientAuthentication"
	return bb
}

// RootCertificatesForServerValidation returns request builder for Windows81TrustedRootCertificate collection
func (b *WindowsWiFiEnterpriseEAPConfigurationRequestBuilder) RootCertificatesForServerValidation() *WindowsWiFiEnterpriseEAPConfigurationRootCertificatesForServerValidationCollectionRequestBuilder {
	bb := &WindowsWiFiEnterpriseEAPConfigurationRootCertificatesForServerValidationCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/rootCertificatesForServerValidation"
	return bb
}

// WindowsWiFiEnterpriseEAPConfigurationRootCertificatesForServerValidationCollectionRequestBuilder is request builder for Windows81TrustedRootCertificate collection
type WindowsWiFiEnterpriseEAPConfigurationRootCertificatesForServerValidationCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Windows81TrustedRootCertificate collection
func (b *WindowsWiFiEnterpriseEAPConfigurationRootCertificatesForServerValidationCollectionRequestBuilder) Request() *WindowsWiFiEnterpriseEAPConfigurationRootCertificatesForServerValidationCollectionRequest {
	return &WindowsWiFiEnterpriseEAPConfigurationRootCertificatesForServerValidationCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Windows81TrustedRootCertificate item
func (b *WindowsWiFiEnterpriseEAPConfigurationRootCertificatesForServerValidationCollectionRequestBuilder) ID(id string) *Windows81TrustedRootCertificateRequestBuilder {
	bb := &Windows81TrustedRootCertificateRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// WindowsWiFiEnterpriseEAPConfigurationRootCertificatesForServerValidationCollectionRequest is request for Windows81TrustedRootCertificate collection
type WindowsWiFiEnterpriseEAPConfigurationRootCertificatesForServerValidationCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Windows81TrustedRootCertificate collection
func (r *WindowsWiFiEnterpriseEAPConfigurationRootCertificatesForServerValidationCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Windows81TrustedRootCertificate, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Windows81TrustedRootCertificate
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Windows81TrustedRootCertificate
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Windows81TrustedRootCertificate collection, max N pages
func (r *WindowsWiFiEnterpriseEAPConfigurationRootCertificatesForServerValidationCollectionRequest) GetN(ctx context.Context, n int) ([]Windows81TrustedRootCertificate, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Windows81TrustedRootCertificate collection
func (r *WindowsWiFiEnterpriseEAPConfigurationRootCertificatesForServerValidationCollectionRequest) Get(ctx context.Context) ([]Windows81TrustedRootCertificate, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Windows81TrustedRootCertificate collection
func (r *WindowsWiFiEnterpriseEAPConfigurationRootCertificatesForServerValidationCollectionRequest) Add(ctx context.Context, reqObj *Windows81TrustedRootCertificate) (resObj *Windows81TrustedRootCertificate, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}
