// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import "time"

// IOSBookmark undocumented
type IOSBookmark struct {
	// Object is the base model of IOSBookmark
	Object
	// URL URL allowed to access
	URL *string `json:"url,omitempty"`
	// BookmarkFolder The folder into which the bookmark should be added in Safari
	BookmarkFolder *string `json:"bookmarkFolder,omitempty"`
	// DisplayName The display name of the bookmark
	DisplayName *string `json:"displayName,omitempty"`
}

// IOSCertificateProfile Device Configuration.
type IOSCertificateProfile struct {
	// DeviceConfiguration is the base model of IOSCertificateProfile
	DeviceConfiguration
}

// IOSCertificateProfileBase iOS certificate profile base.
type IOSCertificateProfileBase struct {
	// IOSCertificateProfile is the base model of IOSCertificateProfileBase
	IOSCertificateProfile
	// RenewalThresholdPercentage Certificate renewal threshold percentage. Valid values 1 to 99
	RenewalThresholdPercentage *int `json:"renewalThresholdPercentage,omitempty"`
	// SubjectNameFormat Certificate Subject Name Format.
	SubjectNameFormat *AppleSubjectNameFormat `json:"subjectNameFormat,omitempty"`
	// SubjectAlternativeNameType Certificate Subject Alternative Name type.
	SubjectAlternativeNameType *SubjectAlternativeNameType `json:"subjectAlternativeNameType,omitempty"`
	// CertificateValidityPeriodValue Value for the Certificate Validity Period.
	CertificateValidityPeriodValue *int `json:"certificateValidityPeriodValue,omitempty"`
	// CertificateValidityPeriodScale Scale for the Certificate Validity Period.
	CertificateValidityPeriodScale *CertificateValidityPeriodScale `json:"certificateValidityPeriodScale,omitempty"`
}

// IOSCompliancePolicy This class contains compliance settings for IOS.
type IOSCompliancePolicy struct {
	// DeviceCompliancePolicy is the base model of IOSCompliancePolicy
	DeviceCompliancePolicy
	// PasscodeBlockSimple Indicates whether or not to block simple passcodes.
	PasscodeBlockSimple *bool `json:"passcodeBlockSimple,omitempty"`
	// PasscodeExpirationDays Number of days before the passcode expires. Valid values 1 to 65535
	PasscodeExpirationDays *int `json:"passcodeExpirationDays,omitempty"`
	// PasscodeMinimumLength Minimum length of passcode. Valid values 4 to 14
	PasscodeMinimumLength *int `json:"passcodeMinimumLength,omitempty"`
	// PasscodeMinutesOfInactivityBeforeLock Minutes of inactivity before a passcode is required.
	PasscodeMinutesOfInactivityBeforeLock *int `json:"passcodeMinutesOfInactivityBeforeLock,omitempty"`
	// PasscodeMinutesOfInactivityBeforeScreenTimeout Minutes of inactivity before the screen times out.
	PasscodeMinutesOfInactivityBeforeScreenTimeout *int `json:"passcodeMinutesOfInactivityBeforeScreenTimeout,omitempty"`
	// PasscodePreviousPasscodeBlockCount Number of previous passcodes to block. Valid values 1 to 24
	PasscodePreviousPasscodeBlockCount *int `json:"passcodePreviousPasscodeBlockCount,omitempty"`
	// PasscodeMinimumCharacterSetCount The number of character sets required in the password.
	PasscodeMinimumCharacterSetCount *int `json:"passcodeMinimumCharacterSetCount,omitempty"`
	// PasscodeRequiredType The required passcode type.
	PasscodeRequiredType *RequiredPasswordType `json:"passcodeRequiredType,omitempty"`
	// PasscodeRequired Indicates whether or not to require a passcode.
	PasscodeRequired *bool `json:"passcodeRequired,omitempty"`
	// OsMinimumVersion Minimum IOS version.
	OsMinimumVersion *string `json:"osMinimumVersion,omitempty"`
	// OsMaximumVersion Maximum IOS version.
	OsMaximumVersion *string `json:"osMaximumVersion,omitempty"`
	// OsMinimumBuildVersion Minimum IOS build version.
	OsMinimumBuildVersion *string `json:"osMinimumBuildVersion,omitempty"`
	// OsMaximumBuildVersion Maximum IOS build version.
	OsMaximumBuildVersion *string `json:"osMaximumBuildVersion,omitempty"`
	// SecurityBlockJailbrokenDevices Devices must not be jailbroken or rooted.
	SecurityBlockJailbrokenDevices *bool `json:"securityBlockJailbrokenDevices,omitempty"`
	// DeviceThreatProtectionEnabled Require that devices have enabled device threat protection .
	DeviceThreatProtectionEnabled *bool `json:"deviceThreatProtectionEnabled,omitempty"`
	// DeviceThreatProtectionRequiredSecurityLevel Require Mobile Threat Protection minimum risk level to report noncompliance.
	DeviceThreatProtectionRequiredSecurityLevel *DeviceThreatProtectionLevel `json:"deviceThreatProtectionRequiredSecurityLevel,omitempty"`
	// ManagedEmailProfileRequired Indicates whether or not to require a managed email profile.
	ManagedEmailProfileRequired *bool `json:"managedEmailProfileRequired,omitempty"`
	// RestrictedApps Require the device to not have the specified apps installed. This collection can contain a maximum of 100 elements.
	RestrictedApps []AppListItem `json:"restrictedApps,omitempty"`
}

// IOSCustomConfiguration This topic provides descriptions of the declared methods, properties and relationships exposed by the iosCustomConfiguration resource.
type IOSCustomConfiguration struct {
	// DeviceConfiguration is the base model of IOSCustomConfiguration
	DeviceConfiguration
	// PayloadName Name that is displayed to the user.
	PayloadName *string `json:"payloadName,omitempty"`
	// PayloadFileName Payload file name (*.mobileconfig | *.xml).
	PayloadFileName *string `json:"payloadFileName,omitempty"`
	// Payload Payload. (UTF8 encoded byte array)
	Payload *Binary `json:"payload,omitempty"`
}

// IOSDerivedCredentialAuthenticationConfiguration iOS Derived Credential profile.
type IOSDerivedCredentialAuthenticationConfiguration struct {
	// DeviceConfiguration is the base model of IOSDerivedCredentialAuthenticationConfiguration
	DeviceConfiguration
	// DerivedCredentialSettings undocumented
	DerivedCredentialSettings *DeviceManagementDerivedCredentialSettings `json:"derivedCredentialSettings,omitempty"`
}

// IOSDeviceFeaturesConfiguration iOS Device Features Configuration Profile.
type IOSDeviceFeaturesConfiguration struct {
	// AppleDeviceFeaturesConfigurationBase is the base model of IOSDeviceFeaturesConfiguration
	AppleDeviceFeaturesConfigurationBase
	// AssetTagTemplate Asset tag information for the device, displayed on the login window and lock screen.
	AssetTagTemplate *string `json:"assetTagTemplate,omitempty"`
	// ContentFilterSettings Gets or sets iOS Web Content Filter settings, supervised mode only
	ContentFilterSettings *IOSWebContentFilterBase `json:"contentFilterSettings,omitempty"`
	// LockScreenFootnote A footnote displayed on the login window and lock screen. Available in iOS 9.3.1 and later.
	LockScreenFootnote *string `json:"lockScreenFootnote,omitempty"`
	// HomeScreenDockIcons A list of app and folders to appear on the Home Screen Dock. This collection can contain a maximum of 500 elements.
	HomeScreenDockIcons []IOSHomeScreenItem `json:"homeScreenDockIcons,omitempty"`
	// HomeScreenPages A list of pages on the Home Screen. This collection can contain a maximum of 500 elements.
	HomeScreenPages []IOSHomeScreenPage `json:"homeScreenPages,omitempty"`
	// NotificationSettings Notification settings for each bundle id. Applicable to devices in supervised mode only (iOS 9.3 and later). This collection can contain a maximum of 500 elements.
	NotificationSettings []IOSNotificationSettings `json:"notificationSettings,omitempty"`
	// SingleSignOnSettings The Kerberos login settings that enable apps on receiving devices to authenticate smoothly.
	SingleSignOnSettings *IOSSingleSignOnSettings `json:"singleSignOnSettings,omitempty"`
	// WallpaperDisplayLocation A wallpaper display location specifier.
	WallpaperDisplayLocation *IOSWallpaperDisplayLocation `json:"wallpaperDisplayLocation,omitempty"`
	// WallpaperImage A wallpaper image must be in either PNG or JPEG format. It requires a supervised device with iOS 8 or later version.
	WallpaperImage *MimeContent `json:"wallpaperImage,omitempty"`
	// SingleSignOnExtension Gets or sets a single sign-on extension profile.
	SingleSignOnExtension *SingleSignOnExtension `json:"singleSignOnExtension,omitempty"`
	// IdentityCertificateForClientAuthentication undocumented
	IdentityCertificateForClientAuthentication *IOSCertificateProfileBase `json:"identityCertificateForClientAuthentication,omitempty"`
	// SingleSignOnExtensionPkinitCertificate undocumented
	SingleSignOnExtensionPkinitCertificate *IOSCertificateProfileBase `json:"singleSignOnExtensionPkinitCertificate,omitempty"`
}

// IOSDeviceType undocumented
type IOSDeviceType struct {
	// Object is the base model of IOSDeviceType
	Object
	// IPad Whether the app should run on iPads.
	IPad *bool `json:"iPad,omitempty"`
	// IPhoneAndIPod Whether the app should run on iPhones and iPods.
	IPhoneAndIPod *bool `json:"iPhoneAndIPod,omitempty"`
}

// IOSEasEmailProfileConfiguration By providing configurations in this profile you can instruct the native email client on iOS devices to communicate with an Exchange server and get email, contacts, calendar, reminders, and notes. Furthermore, you can also specify how much email to sync and how often the device should sync.
type IOSEasEmailProfileConfiguration struct {
	// EasEmailProfileConfigurationBase is the base model of IOSEasEmailProfileConfiguration
	EasEmailProfileConfigurationBase
	// AccountName Account name.
	AccountName *string `json:"accountName,omitempty"`
	// AuthenticationMethod Authentication method for this Email profile.
	AuthenticationMethod *EasAuthenticationMethod `json:"authenticationMethod,omitempty"`
	// BlockMovingMessagesToOtherEmailAccounts Indicates whether or not to block moving messages to other email accounts.
	BlockMovingMessagesToOtherEmailAccounts *bool `json:"blockMovingMessagesToOtherEmailAccounts,omitempty"`
	// BlockSendingEmailFromThirdPartyApps Indicates whether or not to block sending email from third party apps.
	BlockSendingEmailFromThirdPartyApps *bool `json:"blockSendingEmailFromThirdPartyApps,omitempty"`
	// BlockSyncingRecentlyUsedEmailAddresses Indicates whether or not to block syncing recently used email addresses, for instance - when composing new email.
	BlockSyncingRecentlyUsedEmailAddresses *bool `json:"blockSyncingRecentlyUsedEmailAddresses,omitempty"`
	// DurationOfEmailToSync Duration of time email should be synced back to.
	DurationOfEmailToSync *EmailSyncDuration `json:"durationOfEmailToSync,omitempty"`
	// EmailAddressSource Email attribute that is picked from AAD and injected into this profile before installing on the device.
	EmailAddressSource *UserEmailSource `json:"emailAddressSource,omitempty"`
	// EasServices Exchange data to sync.
	EasServices *EasServices `json:"easServices,omitempty"`
	// EasServicesUserOverrideEnabled Allow users to change sync settings.
	EasServicesUserOverrideEnabled *bool `json:"easServicesUserOverrideEnabled,omitempty"`
	// HostName Exchange location that (URL) that the native mail app connects to.
	HostName *string `json:"hostName,omitempty"`
	// RequireSmime Indicates whether or not to use S/MIME certificate.
	RequireSmime *bool `json:"requireSmime,omitempty"`
	// SmimeEnablePerMessageSwitch Indicates whether or not to allow unencrypted emails.
	SmimeEnablePerMessageSwitch *bool `json:"smimeEnablePerMessageSwitch,omitempty"`
	// SmimeEncryptByDefaultEnabled If set to true S/MIME encryption is enabled by default.
	SmimeEncryptByDefaultEnabled *bool `json:"smimeEncryptByDefaultEnabled,omitempty"`
	// SmimeSigningEnabled If set to true S/MIME signing is enabled for this account
	SmimeSigningEnabled *bool `json:"smimeSigningEnabled,omitempty"`
	// SmimeSigningUserOverrideEnabled If set to true, the user can toggle S/MIME signing on or off.
	SmimeSigningUserOverrideEnabled *bool `json:"smimeSigningUserOverrideEnabled,omitempty"`
	// SmimeEncryptByDefaultUserOverrideEnabled If set to true, the user can toggle the encryption by default setting.
	SmimeEncryptByDefaultUserOverrideEnabled *bool `json:"smimeEncryptByDefaultUserOverrideEnabled,omitempty"`
	// SmimeSigningCertificateUserOverrideEnabled If set to true, the user can select the signing identity.
	SmimeSigningCertificateUserOverrideEnabled *bool `json:"smimeSigningCertificateUserOverrideEnabled,omitempty"`
	// SmimeEncryptionCertificateUserOverrideEnabled If set to true the user can select the S/MIME encryption identity.
	SmimeEncryptionCertificateUserOverrideEnabled *bool `json:"smimeEncryptionCertificateUserOverrideEnabled,omitempty"`
	// RequireSsl Indicates whether or not to use SSL.
	RequireSsl *bool `json:"requireSsl,omitempty"`
	// UseOAuth Specifies whether the connection should use OAuth for authentication.
	UseOAuth *bool `json:"useOAuth,omitempty"`
	// SigningCertificateType Signing Certificate type for this Email profile.
	SigningCertificateType *EmailCertificateType `json:"signingCertificateType,omitempty"`
	// EncryptionCertificateType Encryption Certificate type for this Email profile.
	EncryptionCertificateType *EmailCertificateType `json:"encryptionCertificateType,omitempty"`
	// IdentityCertificate undocumented
	IdentityCertificate *IOSCertificateProfileBase `json:"identityCertificate,omitempty"`
	// SmimeSigningCertificate undocumented
	SmimeSigningCertificate *IOSCertificateProfile `json:"smimeSigningCertificate,omitempty"`
	// SmimeEncryptionCertificate undocumented
	SmimeEncryptionCertificate *IOSCertificateProfile `json:"smimeEncryptionCertificate,omitempty"`
	// DerivedCredentialSettings undocumented
	DerivedCredentialSettings *DeviceManagementDerivedCredentialSettings `json:"derivedCredentialSettings,omitempty"`
}

// IOSEduCertificateSettings undocumented
type IOSEduCertificateSettings struct {
	// Object is the base model of IOSEduCertificateSettings
	Object
	// TrustedRootCertificate Trusted Root Certificate.
	TrustedRootCertificate *Binary `json:"trustedRootCertificate,omitempty"`
	// CertFileName File name to display in UI.
	CertFileName *string `json:"certFileName,omitempty"`
	// CertificationAuthority PKCS Certification Authority.
	CertificationAuthority *string `json:"certificationAuthority,omitempty"`
	// CertificationAuthorityName PKCS Certification Authority Name.
	CertificationAuthorityName *string `json:"certificationAuthorityName,omitempty"`
	// CertificateTemplateName PKCS Certificate Template Name.
	CertificateTemplateName *string `json:"certificateTemplateName,omitempty"`
	// RenewalThresholdPercentage Certificate renewal threshold percentage. Valid values 1 to 99
	RenewalThresholdPercentage *int `json:"renewalThresholdPercentage,omitempty"`
	// CertificateValidityPeriodValue Value for the Certificate Validity Period.
	CertificateValidityPeriodValue *int `json:"certificateValidityPeriodValue,omitempty"`
	// CertificateValidityPeriodScale Scale for the Certificate Validity Period.
	CertificateValidityPeriodScale *CertificateValidityPeriodScale `json:"certificateValidityPeriodScale,omitempty"`
}

// IOSEduDeviceConfiguration iOS Education device configuration
type IOSEduDeviceConfiguration struct {
	// DeviceConfiguration is the base model of IOSEduDeviceConfiguration
	DeviceConfiguration
	// TeacherCertificateSettings The Trusted Root and PFX certificates for Teacher
	TeacherCertificateSettings *IOSEduCertificateSettings `json:"teacherCertificateSettings,omitempty"`
	// StudentCertificateSettings The Trusted Root and PFX certificates for Student
	StudentCertificateSettings *IOSEduCertificateSettings `json:"studentCertificateSettings,omitempty"`
	// DeviceCertificateSettings The Trusted Root and PFX certificates for Device
	DeviceCertificateSettings *IOSEduCertificateSettings `json:"deviceCertificateSettings,omitempty"`
}

// IOSEducationDeviceConfiguration iOS Education configuration profile
type IOSEducationDeviceConfiguration struct {
	// DeviceConfiguration is the base model of IOSEducationDeviceConfiguration
	DeviceConfiguration
}

// IOSEnterpriseWiFiConfiguration By providing the configurations in this profile you can instruct the iOS device to connect to desired Wi-Fi endpoint. By specifying the authentication method and security types expected by Wi-Fi endpoint you can make the Wi-Fi connection seamless for end user.
type IOSEnterpriseWiFiConfiguration struct {
	// IOSWiFiConfiguration is the base model of IOSEnterpriseWiFiConfiguration
	IOSWiFiConfiguration
	// EapType Extensible Authentication Protocol (EAP). Indicates the type of EAP protocol set on the Wi-Fi endpoint (router).
	EapType *EapType `json:"eapType,omitempty"`
	// EapFastConfiguration EAP-FAST Configuration Option when EAP-FAST is the selected EAP Type.
	EapFastConfiguration *EapFastConfiguration `json:"eapFastConfiguration,omitempty"`
	// TrustedServerCertificateNames Trusted server certificate names when EAP Type is configured to EAP-TLS/TTLS/FAST or PEAP. This is the common name used in the certificates issued by your trusted certificate authority (CA). If you provide this information, you can bypass the dynamic trust dialog that is displayed on end users' devices when they connect to this Wi-Fi network.
	TrustedServerCertificateNames []string `json:"trustedServerCertificateNames,omitempty"`
	// AuthenticationMethod Authentication Method when EAP Type is configured to PEAP or EAP-TTLS.
	AuthenticationMethod *WiFiAuthenticationMethod `json:"authenticationMethod,omitempty"`
	// InnerAuthenticationProtocolForEapTtls Non-EAP Method for Authentication when EAP Type is EAP-TTLS and Authenticationmethod is Username and Password.
	InnerAuthenticationProtocolForEapTtls *NonEapAuthenticationMethodForEapTtlsType `json:"innerAuthenticationProtocolForEapTtls,omitempty"`
	// OuterIdentityPrivacyTemporaryValue Enable identity privacy (Outer Identity) when EAP Type is configured to EAP - TTLS, EAP - FAST or PEAP. This property masks usernames with the text you enter. For example, if you use 'anonymous', each user that authenticates with this Wi-Fi connection using their real username is displayed as 'anonymous'.
	OuterIdentityPrivacyTemporaryValue *string `json:"outerIdentityPrivacyTemporaryValue,omitempty"`
	// UsernameFormatString Username format string used to build the username to connect to wifi
	UsernameFormatString *string `json:"usernameFormatString,omitempty"`
	// PasswordFormatString Password format string used to build the password to connect to wifi
	PasswordFormatString *string `json:"passwordFormatString,omitempty"`
	// RootCertificatesForServerValidation undocumented
	RootCertificatesForServerValidation []IOSTrustedRootCertificate `json:"rootCertificatesForServerValidation,omitempty"`
	// IdentityCertificateForClientAuthentication undocumented
	IdentityCertificateForClientAuthentication *IOSCertificateProfileBase `json:"identityCertificateForClientAuthentication,omitempty"`
	// DerivedCredentialSettings undocumented
	DerivedCredentialSettings *DeviceManagementDerivedCredentialSettings `json:"derivedCredentialSettings,omitempty"`
}

// IOSGeneralDeviceConfiguration This topic provides descriptions of the declared methods, properties and relationships exposed by the iosGeneralDeviceConfiguration resource.
type IOSGeneralDeviceConfiguration struct {
	// DeviceConfiguration is the base model of IOSGeneralDeviceConfiguration
	DeviceConfiguration
	// AccountBlockModification Indicates whether or not to allow account modification when the device is in supervised mode.
	AccountBlockModification *bool `json:"accountBlockModification,omitempty"`
	// ActivationLockAllowWhenSupervised Indicates whether or not to allow activation lock when the device is in the supervised mode.
	ActivationLockAllowWhenSupervised *bool `json:"activationLockAllowWhenSupervised,omitempty"`
	// AirDropBlocked Indicates whether or not to allow AirDrop when the device is in supervised mode.
	AirDropBlocked *bool `json:"airDropBlocked,omitempty"`
	// AirDropForceUnmanagedDropTarget Indicates whether or not to cause AirDrop to be considered an unmanaged drop target (iOS 9.0 and later).
	AirDropForceUnmanagedDropTarget *bool `json:"airDropForceUnmanagedDropTarget,omitempty"`
	// AirPlayForcePairingPasswordForOutgoingRequests Indicates whether or not to enforce all devices receiving AirPlay requests from this device to use a pairing password.
	AirPlayForcePairingPasswordForOutgoingRequests *bool `json:"airPlayForcePairingPasswordForOutgoingRequests,omitempty"`
	// AppleWatchBlockPairing Indicates whether or not to allow Apple Watch pairing when the device is in supervised mode (iOS 9.0 and later).
	AppleWatchBlockPairing *bool `json:"appleWatchBlockPairing,omitempty"`
	// AppleWatchForceWristDetection Indicates whether or not to force a paired Apple Watch to use Wrist Detection (iOS 8.2 and later).
	AppleWatchForceWristDetection *bool `json:"appleWatchForceWristDetection,omitempty"`
	// AppleNewsBlocked Indicates whether or not to block the user from using News when the device is in supervised mode (iOS 9.0 and later).
	AppleNewsBlocked *bool `json:"appleNewsBlocked,omitempty"`
	// AppsSingleAppModeList Gets or sets the list of iOS apps allowed to autonomously enter Single App Mode. Supervised only. iOS 7.0 and later. This collection can contain a maximum of 500 elements.
	AppsSingleAppModeList []AppListItem `json:"appsSingleAppModeList,omitempty"`
	// AppsVisibilityList List of apps in the visibility list (either visible/launchable apps list or hidden/unlaunchable apps list, controlled by AppsVisibilityListType) (iOS 9.3 and later). This collection can contain a maximum of 10000 elements.
	AppsVisibilityList []AppListItem `json:"appsVisibilityList,omitempty"`
	// AppsVisibilityListType Type of list that is in the AppsVisibilityList.
	AppsVisibilityListType *AppListType `json:"appsVisibilityListType,omitempty"`
	// AppStoreBlockAutomaticDownloads Indicates whether or not to block the automatic downloading of apps purchased on other devices when the device is in supervised mode (iOS 9.0 and later).
	AppStoreBlockAutomaticDownloads *bool `json:"appStoreBlockAutomaticDownloads,omitempty"`
	// AppStoreBlocked Indicates whether or not to block the user from using the App Store. Requires a supervised device for iOS 13 and later.
	AppStoreBlocked *bool `json:"appStoreBlocked,omitempty"`
	// AppStoreBlockInAppPurchases Indicates whether or not to block the user from making in app purchases.
	AppStoreBlockInAppPurchases *bool `json:"appStoreBlockInAppPurchases,omitempty"`
	// AppStoreBlockUIAppInstallation Indicates whether or not to block the App Store app, not restricting installation through Host apps. Applies to supervised mode only (iOS 9.0 and later).
	AppStoreBlockUIAppInstallation *bool `json:"appStoreBlockUIAppInstallation,omitempty"`
	// AppStoreRequirePassword Indicates whether or not to require a password when using the app store.
	AppStoreRequirePassword *bool `json:"appStoreRequirePassword,omitempty"`
	// AutoFillForceAuthentication Indicates whether or not to force user authentication before autofilling passwords and credit card information in Safari and other apps on supervised devices.
	AutoFillForceAuthentication *bool `json:"autoFillForceAuthentication,omitempty"`
	// BluetoothBlockModification Indicates whether or not to allow modification of Bluetooth settings when the device is in supervised mode (iOS 10.0 and later).
	BluetoothBlockModification *bool `json:"bluetoothBlockModification,omitempty"`
	// CameraBlocked Indicates whether or not to block the user from accessing the camera of the device. Requires a supervised device for iOS 13 and later.
	CameraBlocked *bool `json:"cameraBlocked,omitempty"`
	// CellularBlockDataRoaming Indicates whether or not to block data roaming.
	CellularBlockDataRoaming *bool `json:"cellularBlockDataRoaming,omitempty"`
	// CellularBlockGlobalBackgroundFetchWhileRoaming Indicates whether or not to block global background fetch while roaming.
	CellularBlockGlobalBackgroundFetchWhileRoaming *bool `json:"cellularBlockGlobalBackgroundFetchWhileRoaming,omitempty"`
	// CellularBlockPerAppDataModification Indicates whether or not to allow changes to cellular app data usage settings when the device is in supervised mode.
	CellularBlockPerAppDataModification *bool `json:"cellularBlockPerAppDataModification,omitempty"`
	// CellularBlockPersonalHotspot Indicates whether or not to block Personal Hotspot.
	CellularBlockPersonalHotspot *bool `json:"cellularBlockPersonalHotspot,omitempty"`
	// CellularBlockPlanModification Indicates whether or not to allow users to change the settings of the cellular plan on a supervised device.
	CellularBlockPlanModification *bool `json:"cellularBlockPlanModification,omitempty"`
	// CellularBlockVoiceRoaming Indicates whether or not to block voice roaming.
	CellularBlockVoiceRoaming *bool `json:"cellularBlockVoiceRoaming,omitempty"`
	// CertificatesBlockUntrustedTLSCertificates Indicates whether or not to block untrusted TLS certificates.
	CertificatesBlockUntrustedTLSCertificates *bool `json:"certificatesBlockUntrustedTlsCertificates,omitempty"`
	// ClassroomAppBlockRemoteScreenObservation Indicates whether or not to allow remote screen observation by Classroom app when the device is in supervised mode (iOS 9.3 and later).
	ClassroomAppBlockRemoteScreenObservation *bool `json:"classroomAppBlockRemoteScreenObservation,omitempty"`
	// ClassroomAppForceUnpromptedScreenObservation Indicates whether or not to automatically give permission to the teacher of a managed course on the Classroom app to view a student's screen without prompting when the device is in supervised mode.
	ClassroomAppForceUnpromptedScreenObservation *bool `json:"classroomAppForceUnpromptedScreenObservation,omitempty"`
	// ClassroomForceAutomaticallyJoinClasses Indicates whether or not to automatically give permission to the teacher's requests, without prompting the student, when the device is in supervised mode.
	ClassroomForceAutomaticallyJoinClasses *bool `json:"classroomForceAutomaticallyJoinClasses,omitempty"`
	// ClassroomForceUnpromptedAppAndDeviceLock Indicates whether or not to allow the teacher to lock apps or the device without prompting the student. Supervised only.
	ClassroomForceUnpromptedAppAndDeviceLock *bool `json:"classroomForceUnpromptedAppAndDeviceLock,omitempty"`
	// CompliantAppsList List of apps in the compliance (either allow list or block list, controlled by CompliantAppListType). This collection can contain a maximum of 10000 elements.
	CompliantAppsList []AppListItem `json:"compliantAppsList,omitempty"`
	// CompliantAppListType List that is in the AppComplianceList.
	CompliantAppListType *AppListType `json:"compliantAppListType,omitempty"`
	// ConfigurationProfileBlockChanges Indicates whether or not to block the user from installing configuration profiles and certificates interactively when the device is in supervised mode.
	ConfigurationProfileBlockChanges *bool `json:"configurationProfileBlockChanges,omitempty"`
	// DefinitionLookupBlocked Indicates whether or not to block definition lookup when the device is in supervised mode (iOS 8.1.3 and later ).
	DefinitionLookupBlocked *bool `json:"definitionLookupBlocked,omitempty"`
	// DeviceBlockEnableRestrictions Indicates whether or not to allow the user to enables restrictions in the device settings when the device is in supervised mode.
	DeviceBlockEnableRestrictions *bool `json:"deviceBlockEnableRestrictions,omitempty"`
	// DeviceBlockEraseContentAndSettings Indicates whether or not to allow the use of the 'Erase all content and settings' option on the device when the device is in supervised mode.
	DeviceBlockEraseContentAndSettings *bool `json:"deviceBlockEraseContentAndSettings,omitempty"`
	// DeviceBlockNameModification Indicates whether or not to allow device name modification when the device is in supervised mode (iOS 9.0 and later).
	DeviceBlockNameModification *bool `json:"deviceBlockNameModification,omitempty"`
	// DiagnosticDataBlockSubmission Indicates whether or not to block diagnostic data submission.
	DiagnosticDataBlockSubmission *bool `json:"diagnosticDataBlockSubmission,omitempty"`
	// DiagnosticDataBlockSubmissionModification Indicates whether or not to allow diagnostics submission settings modification when the device is in supervised mode (iOS 9.3.2 and later).
	DiagnosticDataBlockSubmissionModification *bool `json:"diagnosticDataBlockSubmissionModification,omitempty"`
	// DocumentsBlockManagedDocumentsInUnmanagedApps Indicates whether or not to block the user from viewing managed documents in unmanaged apps.
	DocumentsBlockManagedDocumentsInUnmanagedApps *bool `json:"documentsBlockManagedDocumentsInUnmanagedApps,omitempty"`
	// DocumentsBlockUnmanagedDocumentsInManagedApps Indicates whether or not to block the user from viewing unmanaged documents in managed apps.
	DocumentsBlockUnmanagedDocumentsInManagedApps *bool `json:"documentsBlockUnmanagedDocumentsInManagedApps,omitempty"`
	// EmailInDomainSuffixes An email address lacking a suffix that matches any of these strings will be considered out-of-domain.
	EmailInDomainSuffixes []string `json:"emailInDomainSuffixes,omitempty"`
	// EnterpriseAppBlockTrust Indicates whether or not to block the user from trusting an enterprise app.
	EnterpriseAppBlockTrust *bool `json:"enterpriseAppBlockTrust,omitempty"`
	// EnterpriseAppBlockTrustModification Indicates whether or not to block the user from modifying the enterprise app trust settings.
	EnterpriseAppBlockTrustModification *bool `json:"enterpriseAppBlockTrustModification,omitempty"`
	// EsimBlockModification Indicates whether or not to allow the addition or removal of cellular plans on the eSIM of a supervised device.
	EsimBlockModification *bool `json:"esimBlockModification,omitempty"`
	// FaceTimeBlocked Indicates whether or not to block the user from using FaceTime. Requires a supervised device for iOS 13 and later.
	FaceTimeBlocked *bool `json:"faceTimeBlocked,omitempty"`
	// FindMyFriendsBlocked Indicates whether or not to block changes to Find My Friends when the device is in supervised mode.
	FindMyFriendsBlocked *bool `json:"findMyFriendsBlocked,omitempty"`
	// GamingBlockGameCenterFriends Indicates whether or not to block the user from having friends in Game Center. Requires a supervised device for iOS 13 and later.
	GamingBlockGameCenterFriends *bool `json:"gamingBlockGameCenterFriends,omitempty"`
	// GamingBlockMultiplayer Indicates whether or not to block the user from using multiplayer gaming. Requires a supervised device for iOS 13 and later.
	GamingBlockMultiplayer *bool `json:"gamingBlockMultiplayer,omitempty"`
	// GameCenterBlocked Indicates whether or not to block the user from using Game Center when the device is in supervised mode.
	GameCenterBlocked *bool `json:"gameCenterBlocked,omitempty"`
	// HostPairingBlocked indicates whether or not to allow host pairing to control the devices an iOS device can pair with when the iOS device is in supervised mode.
	HostPairingBlocked *bool `json:"hostPairingBlocked,omitempty"`
	// IBooksStoreBlocked Indicates whether or not to block the user from using the iBooks Store when the device is in supervised mode.
	IBooksStoreBlocked *bool `json:"iBooksStoreBlocked,omitempty"`
	// IBooksStoreBlockErotica Indicates whether or not to block the user from downloading media from the iBookstore that has been tagged as erotica.
	IBooksStoreBlockErotica *bool `json:"iBooksStoreBlockErotica,omitempty"`
	// ICloudBlockActivityContinuation Indicates whether or not to block the user from continuing work they started on iOS device to another iOS or macOS device.
	ICloudBlockActivityContinuation *bool `json:"iCloudBlockActivityContinuation,omitempty"`
	// ICloudBlockBackup Indicates whether or not to block iCloud backup. Requires a supervised device for iOS 13 and later.
	ICloudBlockBackup *bool `json:"iCloudBlockBackup,omitempty"`
	// ICloudBlockDocumentSync Indicates whether or not to block iCloud document sync. Requires a supervised device for iOS 13 and later.
	ICloudBlockDocumentSync *bool `json:"iCloudBlockDocumentSync,omitempty"`
	// ICloudBlockManagedAppsSync Indicates whether or not to block Managed Apps Cloud Sync.
	ICloudBlockManagedAppsSync *bool `json:"iCloudBlockManagedAppsSync,omitempty"`
	// ICloudBlockPhotoLibrary Indicates whether or not to block iCloud Photo Library.
	ICloudBlockPhotoLibrary *bool `json:"iCloudBlockPhotoLibrary,omitempty"`
	// ICloudBlockPhotoStreamSync Indicates whether or not to block iCloud Photo Stream Sync.
	ICloudBlockPhotoStreamSync *bool `json:"iCloudBlockPhotoStreamSync,omitempty"`
	// ICloudBlockSharedPhotoStream Indicates whether or not to block Shared Photo Stream.
	ICloudBlockSharedPhotoStream *bool `json:"iCloudBlockSharedPhotoStream,omitempty"`
	// ICloudRequireEncryptedBackup Indicates whether or not to require backups to iCloud be encrypted.
	ICloudRequireEncryptedBackup *bool `json:"iCloudRequireEncryptedBackup,omitempty"`
	// ITunesBlockExplicitContent Indicates whether or not to block the user from accessing explicit content in iTunes and the App Store. Requires a supervised device for iOS 13 and later.
	ITunesBlockExplicitContent *bool `json:"iTunesBlockExplicitContent,omitempty"`
	// ITunesBlockMusicService Indicates whether or not to block Music service and revert Music app to classic mode when the device is in supervised mode (iOS 9.3 and later and macOS 10.12 and later).
	ITunesBlockMusicService *bool `json:"iTunesBlockMusicService,omitempty"`
	// ITunesBlockRadio Indicates whether or not to block the user from using iTunes Radio when the device is in supervised mode (iOS 9.3 and later).
	ITunesBlockRadio *bool `json:"iTunesBlockRadio,omitempty"`
	// KeyboardBlockAutoCorrect Indicates whether or not to block keyboard auto-correction when the device is in supervised mode (iOS 8.1.3 and later).
	KeyboardBlockAutoCorrect *bool `json:"keyboardBlockAutoCorrect,omitempty"`
	// KeyboardBlockDictation Indicates whether or not to block the user from using dictation input when the device is in supervised mode.
	KeyboardBlockDictation *bool `json:"keyboardBlockDictation,omitempty"`
	// KeyboardBlockPredictive Indicates whether or not to block predictive keyboards when device is in supervised mode (iOS 8.1.3 and later).
	KeyboardBlockPredictive *bool `json:"keyboardBlockPredictive,omitempty"`
	// KeyboardBlockShortcuts Indicates whether or not to block keyboard shortcuts when the device is in supervised mode (iOS 9.0 and later).
	KeyboardBlockShortcuts *bool `json:"keyboardBlockShortcuts,omitempty"`
	// KeyboardBlockSpellCheck Indicates whether or not to block keyboard spell-checking when the device is in supervised mode (iOS 8.1.3 and later).
	KeyboardBlockSpellCheck *bool `json:"keyboardBlockSpellCheck,omitempty"`
	// KioskModeAllowAssistiveSpeak Indicates whether or not to allow assistive speak while in kiosk mode.
	KioskModeAllowAssistiveSpeak *bool `json:"kioskModeAllowAssistiveSpeak,omitempty"`
	// KioskModeAllowAssistiveTouchSettings Indicates whether or not to allow access to the Assistive Touch Settings while in kiosk mode.
	KioskModeAllowAssistiveTouchSettings *bool `json:"kioskModeAllowAssistiveTouchSettings,omitempty"`
	// KioskModeAllowAutoLock Indicates whether or not to allow device auto lock while in kiosk mode. This property's functionality is redundant with the OS default and is deprecated. Use KioskModeBlockAutoLock instead.
	KioskModeAllowAutoLock *bool `json:"kioskModeAllowAutoLock,omitempty"`
	// KioskModeBlockAutoLock Indicates whether or not to block device auto lock while in kiosk mode.
	KioskModeBlockAutoLock *bool `json:"kioskModeBlockAutoLock,omitempty"`
	// KioskModeAllowColorInversionSettings Indicates whether or not to allow access to the Color Inversion Settings while in kiosk mode.
	KioskModeAllowColorInversionSettings *bool `json:"kioskModeAllowColorInversionSettings,omitempty"`
	// KioskModeAllowRingerSwitch Indicates whether or not to allow use of the ringer switch while in kiosk mode. This property's functionality is redundant with the OS default and is deprecated. Use KioskModeBlockRingerSwitch instead.
	KioskModeAllowRingerSwitch *bool `json:"kioskModeAllowRingerSwitch,omitempty"`
	// KioskModeBlockRingerSwitch Indicates whether or not to block use of the ringer switch while in kiosk mode.
	KioskModeBlockRingerSwitch *bool `json:"kioskModeBlockRingerSwitch,omitempty"`
	// KioskModeAllowScreenRotation Indicates whether or not to allow screen rotation while in kiosk mode. This property's functionality is redundant with the OS default and is deprecated. Use KioskModeBlockScreenRotation instead.
	KioskModeAllowScreenRotation *bool `json:"kioskModeAllowScreenRotation,omitempty"`
	// KioskModeBlockScreenRotation Indicates whether or not to block screen rotation while in kiosk mode.
	KioskModeBlockScreenRotation *bool `json:"kioskModeBlockScreenRotation,omitempty"`
	// KioskModeAllowSleepButton Indicates whether or not to allow use of the sleep button while in kiosk mode. This property's functionality is redundant with the OS default and is deprecated. Use KioskModeBlockSleepButton instead.
	KioskModeAllowSleepButton *bool `json:"kioskModeAllowSleepButton,omitempty"`
	// KioskModeBlockSleepButton Indicates whether or not to block use of the sleep button while in kiosk mode.
	KioskModeBlockSleepButton *bool `json:"kioskModeBlockSleepButton,omitempty"`
	// KioskModeAllowTouchscreen Indicates whether or not to allow use of the touchscreen while in kiosk mode. This property's functionality is redundant with the OS default and is deprecated. Use KioskModeBlockTouchscreen instead.
	KioskModeAllowTouchscreen *bool `json:"kioskModeAllowTouchscreen,omitempty"`
	// KioskModeBlockTouchscreen Indicates whether or not to block use of the touchscreen while in kiosk mode.
	KioskModeBlockTouchscreen *bool `json:"kioskModeBlockTouchscreen,omitempty"`
	// KioskModeEnableVoiceControl Indicates whether or not to enable voice control in kiosk mode.
	KioskModeEnableVoiceControl *bool `json:"kioskModeEnableVoiceControl,omitempty"`
	// KioskModeAllowVoiceControlModification Indicates whether or not to allow the user to toggle voice control in kiosk mode.
	KioskModeAllowVoiceControlModification *bool `json:"kioskModeAllowVoiceControlModification,omitempty"`
	// KioskModeAllowVoiceOverSettings Indicates whether or not to allow access to the voice over settings while in kiosk mode.
	KioskModeAllowVoiceOverSettings *bool `json:"kioskModeAllowVoiceOverSettings,omitempty"`
	// KioskModeAllowVolumeButtons Indicates whether or not to allow use of the volume buttons while in kiosk mode. This property's functionality is redundant with the OS default and is deprecated. Use KioskModeBlockVolumeButtons instead.
	KioskModeAllowVolumeButtons *bool `json:"kioskModeAllowVolumeButtons,omitempty"`
	// KioskModeBlockVolumeButtons Indicates whether or not to block the volume buttons while in Kiosk Mode.
	KioskModeBlockVolumeButtons *bool `json:"kioskModeBlockVolumeButtons,omitempty"`
	// KioskModeAllowZoomSettings Indicates whether or not to allow access to the zoom settings while in kiosk mode.
	KioskModeAllowZoomSettings *bool `json:"kioskModeAllowZoomSettings,omitempty"`
	// KioskModeAppStoreURL URL in the app store to the app to use for kiosk mode. Use if KioskModeManagedAppId is not known.
	KioskModeAppStoreURL *string `json:"kioskModeAppStoreUrl,omitempty"`
	// KioskModeBuiltInAppID ID for built-in apps to use for kiosk mode. Used when KioskModeManagedAppId and KioskModeAppStoreUrl are not set.
	KioskModeBuiltInAppID *string `json:"kioskModeBuiltInAppId,omitempty"`
	// KioskModeRequireAssistiveTouch Indicates whether or not to require assistive touch while in kiosk mode.
	KioskModeRequireAssistiveTouch *bool `json:"kioskModeRequireAssistiveTouch,omitempty"`
	// KioskModeRequireColorInversion Indicates whether or not to require color inversion while in kiosk mode.
	KioskModeRequireColorInversion *bool `json:"kioskModeRequireColorInversion,omitempty"`
	// KioskModeRequireMonoAudio Indicates whether or not to require mono audio while in kiosk mode.
	KioskModeRequireMonoAudio *bool `json:"kioskModeRequireMonoAudio,omitempty"`
	// KioskModeRequireVoiceOver Indicates whether or not to require voice over while in kiosk mode.
	KioskModeRequireVoiceOver *bool `json:"kioskModeRequireVoiceOver,omitempty"`
	// KioskModeRequireZoom Indicates whether or not to require zoom while in kiosk mode.
	KioskModeRequireZoom *bool `json:"kioskModeRequireZoom,omitempty"`
	// KioskModeManagedAppID Managed app id of the app to use for kiosk mode. If KioskModeManagedAppId is specified then KioskModeAppStoreUrl will be ignored.
	KioskModeManagedAppID *string `json:"kioskModeManagedAppId,omitempty"`
	// LockScreenBlockControlCenter Indicates whether or not to block the user from using control center on the lock screen.
	LockScreenBlockControlCenter *bool `json:"lockScreenBlockControlCenter,omitempty"`
	// LockScreenBlockNotificationView Indicates whether or not to block the user from using the notification view on the lock screen.
	LockScreenBlockNotificationView *bool `json:"lockScreenBlockNotificationView,omitempty"`
	// LockScreenBlockPassbook Indicates whether or not to block the user from using passbook when the device is locked.
	LockScreenBlockPassbook *bool `json:"lockScreenBlockPassbook,omitempty"`
	// LockScreenBlockTodayView Indicates whether or not to block the user from using the Today View on the lock screen.
	LockScreenBlockTodayView *bool `json:"lockScreenBlockTodayView,omitempty"`
	// MediaContentRatingAustralia Media content rating settings for Australia
	MediaContentRatingAustralia *MediaContentRatingAustralia `json:"mediaContentRatingAustralia,omitempty"`
	// MediaContentRatingCanada Media content rating settings for Canada
	MediaContentRatingCanada *MediaContentRatingCanada `json:"mediaContentRatingCanada,omitempty"`
	// MediaContentRatingFrance Media content rating settings for France
	MediaContentRatingFrance *MediaContentRatingFrance `json:"mediaContentRatingFrance,omitempty"`
	// MediaContentRatingGermany Media content rating settings for Germany
	MediaContentRatingGermany *MediaContentRatingGermany `json:"mediaContentRatingGermany,omitempty"`
	// MediaContentRatingIreland Media content rating settings for Ireland
	MediaContentRatingIreland *MediaContentRatingIreland `json:"mediaContentRatingIreland,omitempty"`
	// MediaContentRatingJapan Media content rating settings for Japan
	MediaContentRatingJapan *MediaContentRatingJapan `json:"mediaContentRatingJapan,omitempty"`
	// MediaContentRatingNewZealand Media content rating settings for New Zealand
	MediaContentRatingNewZealand *MediaContentRatingNewZealand `json:"mediaContentRatingNewZealand,omitempty"`
	// MediaContentRatingUnitedKingdom Media content rating settings for United Kingdom
	MediaContentRatingUnitedKingdom *MediaContentRatingUnitedKingdom `json:"mediaContentRatingUnitedKingdom,omitempty"`
	// MediaContentRatingUnitedStates Media content rating settings for United States
	MediaContentRatingUnitedStates *MediaContentRatingUnitedStates `json:"mediaContentRatingUnitedStates,omitempty"`
	// NetworkUsageRules List of managed apps and the network rules that applies to them. This collection can contain a maximum of 1000 elements.
	NetworkUsageRules []IOSNetworkUsageRule `json:"networkUsageRules,omitempty"`
	// MediaContentRatingApps Media content rating settings for Apps
	MediaContentRatingApps *RatingAppsType `json:"mediaContentRatingApps,omitempty"`
	// MessagesBlocked Indicates whether or not to block the user from using the Messages app on the supervised device.
	MessagesBlocked *bool `json:"messagesBlocked,omitempty"`
	// NotificationsBlockSettingsModification Indicates whether or not to allow notifications settings modification (iOS 9.3 and later).
	NotificationsBlockSettingsModification *bool `json:"notificationsBlockSettingsModification,omitempty"`
	// PasscodeBlockFingerprintUnlock Indicates whether or not to block fingerprint unlock.
	PasscodeBlockFingerprintUnlock *bool `json:"passcodeBlockFingerprintUnlock,omitempty"`
	// PasscodeBlockFingerprintModification Block modification of registered Touch ID fingerprints when in supervised mode.
	PasscodeBlockFingerprintModification *bool `json:"passcodeBlockFingerprintModification,omitempty"`
	// PasscodeBlockModification Indicates whether or not to allow passcode modification on the supervised device (iOS 9.0 and later).
	PasscodeBlockModification *bool `json:"passcodeBlockModification,omitempty"`
	// PasscodeBlockSimple Indicates whether or not to block simple passcodes.
	PasscodeBlockSimple *bool `json:"passcodeBlockSimple,omitempty"`
	// PasscodeExpirationDays Number of days before the passcode expires. Valid values 1 to 65535
	PasscodeExpirationDays *int `json:"passcodeExpirationDays,omitempty"`
	// PasscodeMinimumLength Minimum length of passcode. Valid values 4 to 14
	PasscodeMinimumLength *int `json:"passcodeMinimumLength,omitempty"`
	// PasscodeMinutesOfInactivityBeforeLock Minutes of inactivity before a passcode is required.
	PasscodeMinutesOfInactivityBeforeLock *int `json:"passcodeMinutesOfInactivityBeforeLock,omitempty"`
	// PasscodeMinutesOfInactivityBeforeScreenTimeout Minutes of inactivity before the screen times out.
	PasscodeMinutesOfInactivityBeforeScreenTimeout *int `json:"passcodeMinutesOfInactivityBeforeScreenTimeout,omitempty"`
	// PasscodeMinimumCharacterSetCount Number of character sets a passcode must contain. Valid values 0 to 4
	PasscodeMinimumCharacterSetCount *int `json:"passcodeMinimumCharacterSetCount,omitempty"`
	// PasscodePreviousPasscodeBlockCount Number of previous passcodes to block. Valid values 1 to 24
	PasscodePreviousPasscodeBlockCount *int `json:"passcodePreviousPasscodeBlockCount,omitempty"`
	// PasscodeSignInFailureCountBeforeWipe Number of sign in failures allowed before wiping the device. Valid values 4 to 11
	PasscodeSignInFailureCountBeforeWipe *int `json:"passcodeSignInFailureCountBeforeWipe,omitempty"`
	// PasscodeRequiredType Type of passcode that is required.
	PasscodeRequiredType *RequiredPasswordType `json:"passcodeRequiredType,omitempty"`
	// PasscodeRequired Indicates whether or not to require a passcode.
	PasscodeRequired *bool `json:"passcodeRequired,omitempty"`
	// PodcastsBlocked Indicates whether or not to block the user from using podcasts on the supervised device (iOS 8.0 and later).
	PodcastsBlocked *bool `json:"podcastsBlocked,omitempty"`
	// ProximityBlockSetupToNewDevice Indicates whether or not to enable the prompt to setup nearby devices with a supervised device.
	ProximityBlockSetupToNewDevice *bool `json:"proximityBlockSetupToNewDevice,omitempty"`
	// SafariBlockAutofill Indicates whether or not to block the user from using Auto fill in Safari. Requires a supervised device for iOS 13 and later.
	SafariBlockAutofill *bool `json:"safariBlockAutofill,omitempty"`
	// SafariBlockJavaScript Indicates whether or not to block JavaScript in Safari.
	SafariBlockJavaScript *bool `json:"safariBlockJavaScript,omitempty"`
	// SafariBlockPopups Indicates whether or not to block popups in Safari.
	SafariBlockPopups *bool `json:"safariBlockPopups,omitempty"`
	// SafariBlocked Indicates whether or not to block the user from using Safari. Requires a supervised device for iOS 13 and later.
	SafariBlocked *bool `json:"safariBlocked,omitempty"`
	// SafariCookieSettings Cookie settings for Safari.
	SafariCookieSettings *WebBrowserCookieSettings `json:"safariCookieSettings,omitempty"`
	// SafariManagedDomains URLs matching the patterns listed here will be considered managed.
	SafariManagedDomains []string `json:"safariManagedDomains,omitempty"`
	// SafariPasswordAutoFillDomains Users can save passwords in Safari only from URLs matching the patterns listed here. Applies to devices in supervised mode (iOS 9.3 and later).
	SafariPasswordAutoFillDomains []string `json:"safariPasswordAutoFillDomains,omitempty"`
	// SafariRequireFraudWarning Indicates whether or not to require fraud warning in Safari.
	SafariRequireFraudWarning *bool `json:"safariRequireFraudWarning,omitempty"`
	// ScreenCaptureBlocked Indicates whether or not to block the user from taking Screenshots.
	ScreenCaptureBlocked *bool `json:"screenCaptureBlocked,omitempty"`
	// SiriBlocked Indicates whether or not to block the user from using Siri.
	SiriBlocked *bool `json:"siriBlocked,omitempty"`
	// SiriBlockedWhenLocked Indicates whether or not to block the user from using Siri when locked.
	SiriBlockedWhenLocked *bool `json:"siriBlockedWhenLocked,omitempty"`
	// SiriBlockUserGeneratedContent Indicates whether or not to block Siri from querying user-generated content when used on a supervised device.
	SiriBlockUserGeneratedContent *bool `json:"siriBlockUserGeneratedContent,omitempty"`
	// SiriRequireProfanityFilter Indicates whether or not to prevent Siri from dictating, or speaking profane language on supervised device.
	SiriRequireProfanityFilter *bool `json:"siriRequireProfanityFilter,omitempty"`
	// SoftwareUpdatesEnforcedDelayInDays Sets how many days a software update will be delyed for a supervised device. Valid values 0 to 90
	SoftwareUpdatesEnforcedDelayInDays *int `json:"softwareUpdatesEnforcedDelayInDays,omitempty"`
	// SoftwareUpdatesForceDelayed Indicates whether or not to delay user visibility of software updates when the device is in supervised mode.
	SoftwareUpdatesForceDelayed *bool `json:"softwareUpdatesForceDelayed,omitempty"`
	// SpotlightBlockInternetResults Indicates whether or not to block Spotlight search from returning internet results on supervised device.
	SpotlightBlockInternetResults *bool `json:"spotlightBlockInternetResults,omitempty"`
	// VoiceDialingBlocked Indicates whether or not to block voice dialing.
	VoiceDialingBlocked *bool `json:"voiceDialingBlocked,omitempty"`
	// WallpaperBlockModification Indicates whether or not to allow wallpaper modification on supervised device (iOS 9.0 and later) .
	WallpaperBlockModification *bool `json:"wallpaperBlockModification,omitempty"`
	// WiFiConnectOnlyToConfiguredNetworks Indicates whether or not to force the device to use only Wi-Fi networks from configuration profiles when the device is in supervised mode.
	WiFiConnectOnlyToConfiguredNetworks *bool `json:"wiFiConnectOnlyToConfiguredNetworks,omitempty"`
	// ClassroomForceRequestPermissionToLeaveClasses Indicates whether a student enrolled in an unmanaged course via Classroom will request permission from the teacher when attempting to leave the course (iOS 11.3 and later).
	ClassroomForceRequestPermissionToLeaveClasses *bool `json:"classroomForceRequestPermissionToLeaveClasses,omitempty"`
	// KeychainBlockCloudSync Indicates whether or not iCloud keychain synchronization is blocked. Requires a supervised device for iOS 13 and later.
	KeychainBlockCloudSync *bool `json:"keychainBlockCloudSync,omitempty"`
	// PkiBlockOTAUpdates Indicates whether or not over-the-air PKI updates are blocked. Setting this restriction to false does not disable CRL and OCSP checks (iOS 7.0 and later).
	PkiBlockOTAUpdates *bool `json:"pkiBlockOTAUpdates,omitempty"`
	// PrivacyForceLimitAdTracking Indicates if ad tracking is limited.(iOS 7.0 and later).
	PrivacyForceLimitAdTracking *bool `json:"privacyForceLimitAdTracking,omitempty"`
	// EnterpriseBookBlockBackup Indicates whether or not Enterprise book back up is blocked.
	EnterpriseBookBlockBackup *bool `json:"enterpriseBookBlockBackup,omitempty"`
	// EnterpriseBookBlockMetadataSync Indicates whether or not Enterprise book notes and highlights sync is blocked.
	EnterpriseBookBlockMetadataSync *bool `json:"enterpriseBookBlockMetadataSync,omitempty"`
	// AirPrintBlocked Indicates whether or not AirPrint is blocked (iOS 11.0 and later).
	AirPrintBlocked *bool `json:"airPrintBlocked,omitempty"`
	// AirPrintBlockCredentialsStorage Indicates whether or not keychain storage of username and password for Airprint is blocked (iOS 11.0 and later).
	AirPrintBlockCredentialsStorage *bool `json:"airPrintBlockCredentialsStorage,omitempty"`
	// AirPrintForceTrustedTLS Indicates if trusted certificates are required for TLS printing communication (iOS 11.0 and later).
	AirPrintForceTrustedTLS *bool `json:"airPrintForceTrustedTLS,omitempty"`
	// AirPrintBlockiBeaconDiscovery Indicates whether or not iBeacon discovery of AirPrint printers is blocked. This prevents spurious AirPrint Bluetooth beacons from phishing for network traffic (iOS 11.0 and later).
	AirPrintBlockiBeaconDiscovery *bool `json:"airPrintBlockiBeaconDiscovery,omitempty"`
	// FilesNetworkDriveAccessBlocked Indicates if devices can access files or other resources on a network server using the Server Message Block (SMB) protocol. Available for devices running iOS and iPadOS, versions 13.0 and later.
	FilesNetworkDriveAccessBlocked *bool `json:"filesNetworkDriveAccessBlocked,omitempty"`
	// FilesUsbDriveAccessBlocked Indicates if sevices with access can connect to and open files on a USB drive. Available for devices running iOS and iPadOS, versions 13.0 and later.
	FilesUsbDriveAccessBlocked *bool `json:"filesUsbDriveAccessBlocked,omitempty"`
	// WiFiPowerOnForced Indicates whether or not Wi-Fi remains on, even when device is in airplane mode. Available for devices running iOS and iPadOS, versions 13.0 and later.
	WiFiPowerOnForced *bool `json:"wifiPowerOnForced,omitempty"`
	// BlockSystemAppRemoval Indicates whether or not the removal of system apps from the device is blocked on a supervised device (iOS 11.0 and later).
	BlockSystemAppRemoval *bool `json:"blockSystemAppRemoval,omitempty"`
	// VPNBlockCreation Indicates whether or not the creation of VPN configurations is blocked (iOS 11.0 and later).
	VPNBlockCreation *bool `json:"vpnBlockCreation,omitempty"`
	// AppRemovalBlocked Indicates if the removal of apps is allowed.
	AppRemovalBlocked *bool `json:"appRemovalBlocked,omitempty"`
	// UsbRestrictedModeBlocked Indicates if connecting to USB accessories while the device is locked is allowed (iOS 11.4.1 and later).
	UsbRestrictedModeBlocked *bool `json:"usbRestrictedModeBlocked,omitempty"`
	// PasswordBlockAutoFill Indicates if the AutoFill passwords feature is allowed (iOS 12.0 and later).
	PasswordBlockAutoFill *bool `json:"passwordBlockAutoFill,omitempty"`
	// PasswordBlockProximityRequests Indicates whether or not to block requesting passwords from nearby devices (iOS 12.0 and later).
	PasswordBlockProximityRequests *bool `json:"passwordBlockProximityRequests,omitempty"`
	// PasswordBlockAirDropSharing Indicates whether or not to block sharing passwords with the AirDrop passwords feature iOS 12.0 and later).
	PasswordBlockAirDropSharing *bool `json:"passwordBlockAirDropSharing,omitempty"`
	// DateAndTimeForceSetAutomatically Indicates whether or not the Date and Time "Set Automatically" feature is enabled and cannot be turned off by the user (iOS 12.0 and later).
	DateAndTimeForceSetAutomatically *bool `json:"dateAndTimeForceSetAutomatically,omitempty"`
	// ContactsAllowManagedToUnmanagedWrite Indicates whether or not managed apps can write contacts to unmanaged contacts accounts (iOS 12.0 and later).
	ContactsAllowManagedToUnmanagedWrite *bool `json:"contactsAllowManagedToUnmanagedWrite,omitempty"`
	// ContactsAllowUnmanagedToManagedRead Indicates whether or not unmanaged apps can read from managed contacts accounts (iOS 12.0 or later).
	ContactsAllowUnmanagedToManagedRead *bool `json:"contactsAllowUnmanagedToManagedRead,omitempty"`
	// CellularBlockPersonalHotspotModification Indicates whether or not to block the user from modifying the personal hotspot setting (iOS 12.2 or later).
	CellularBlockPersonalHotspotModification *bool `json:"cellularBlockPersonalHotspotModification,omitempty"`
	// ContinuousPathKeyboardBlocked Indicates whether or not to block the continuous path keyboard when the device is supervised (iOS 13 or later).
	ContinuousPathKeyboardBlocked *bool `json:"continuousPathKeyboardBlocked,omitempty"`
	// FindMyDeviceInFindMyAppBlocked Indicates whether or not to block Find My Device when the device is supervised (iOS 13 or later).
	FindMyDeviceInFindMyAppBlocked *bool `json:"findMyDeviceInFindMyAppBlocked,omitempty"`
	// FindMyFriendsInFindMyAppBlocked Indicates whether or not to block Find My Friends when the device is supervised (iOS 13 or later).
	FindMyFriendsInFindMyAppBlocked *bool `json:"findMyFriendsInFindMyAppBlocked,omitempty"`
	// ITunesBlocked Indicates whether or not to block the iTunes app. Requires a supervised device for iOS 13 and later.
	ITunesBlocked *bool `json:"iTunesBlocked,omitempty"`
}

// IOSHomeScreenApp undocumented
type IOSHomeScreenApp struct {
	// IOSHomeScreenItem is the base model of IOSHomeScreenApp
	IOSHomeScreenItem
	// BundleID BundleID of app
	BundleID *string `json:"bundleID,omitempty"`
}

// IOSHomeScreenFolder undocumented
type IOSHomeScreenFolder struct {
	// IOSHomeScreenItem is the base model of IOSHomeScreenFolder
	IOSHomeScreenItem
	// Pages Pages of Home Screen Layout Icons which must be Application Type. This collection can contain a maximum of 500 elements.
	Pages []IOSHomeScreenFolderPage `json:"pages,omitempty"`
}

// IOSHomeScreenFolderPage undocumented
type IOSHomeScreenFolderPage struct {
	// Object is the base model of IOSHomeScreenFolderPage
	Object
	// DisplayName Name of the folder page
	DisplayName *string `json:"displayName,omitempty"`
	// Apps A list of apps to appear on a page within a folder. This collection can contain a maximum of 500 elements.
	Apps []IOSHomeScreenApp `json:"apps,omitempty"`
}

// IOSHomeScreenItem undocumented
type IOSHomeScreenItem struct {
	// Object is the base model of IOSHomeScreenItem
	Object
	// DisplayName Name of the app
	DisplayName *string `json:"displayName,omitempty"`
}

// IOSHomeScreenPage undocumented
type IOSHomeScreenPage struct {
	// Object is the base model of IOSHomeScreenPage
	Object
	// DisplayName Name of the page
	DisplayName *string `json:"displayName,omitempty"`
	// Icons A list of apps and folders to appear on a page. This collection can contain a maximum of 500 elements.
	Icons []IOSHomeScreenItem `json:"icons,omitempty"`
}

// IOSImportedPFXCertificateProfile iOS PFX Import certificate profile
type IOSImportedPFXCertificateProfile struct {
	// IOSCertificateProfile is the base model of IOSImportedPFXCertificateProfile
	IOSCertificateProfile
	// IntendedPurpose Intended Purpose of the Certificate Profile - which could be Unassigned, SmimeEncryption, SmimeSigning etc.
	IntendedPurpose *IntendedPurpose `json:"intendedPurpose,omitempty"`
	// ManagedDeviceCertificateStates undocumented
	ManagedDeviceCertificateStates []ManagedDeviceCertificateState `json:"managedDeviceCertificateStates,omitempty"`
}

// IOSKerberosSingleSignOnExtension undocumented
type IOSKerberosSingleSignOnExtension struct {
	// KerberosSingleSignOnExtension is the base model of IOSKerberosSingleSignOnExtension
	KerberosSingleSignOnExtension
}

// IOSLobApp Contains properties and inherited properties for iOS Line Of Business apps.
type IOSLobApp struct {
	// MobileLobApp is the base model of IOSLobApp
	MobileLobApp
	// BundleID The Identity Name.
	BundleID *string `json:"bundleId,omitempty"`
	// ApplicableDeviceType The iOS architecture for which this app can run on.
	ApplicableDeviceType *IOSDeviceType `json:"applicableDeviceType,omitempty"`
	// MinimumSupportedOperatingSystem The value for the minimum applicable operating system.
	MinimumSupportedOperatingSystem *IOSMinimumOperatingSystem `json:"minimumSupportedOperatingSystem,omitempty"`
	// ExpirationDateTime The expiration time.
	ExpirationDateTime *time.Time `json:"expirationDateTime,omitempty"`
	// VersionNumber The version number of iOS Line of Business (LoB) app.
	VersionNumber *string `json:"versionNumber,omitempty"`
	// BuildNumber The build number of iOS Line of Business (LoB) app.
	BuildNumber *string `json:"buildNumber,omitempty"`
	// IdentityVersion The identity version.
	IdentityVersion *string `json:"identityVersion,omitempty"`
}

// IOSLobAppAssignmentSettings undocumented
type IOSLobAppAssignmentSettings struct {
	// MobileAppAssignmentSettings is the base model of IOSLobAppAssignmentSettings
	MobileAppAssignmentSettings
	// VPNConfigurationID The VPN Configuration Id to apply for this app.
	VPNConfigurationID *string `json:"vpnConfigurationId,omitempty"`
	// UninstallOnDeviceRemoval Whether or not to uninstall the app when device is removed from Intune.
	UninstallOnDeviceRemoval *bool `json:"uninstallOnDeviceRemoval,omitempty"`
}

// IOSLobAppProvisioningConfiguration This topic provides descriptions of the declared methods, properties and relationships exposed by the iOS Lob App Provisioning Configuration resource.
type IOSLobAppProvisioningConfiguration struct {
	// Entity is the base model of IOSLobAppProvisioningConfiguration
	Entity
	// ExpirationDateTime Optional profile expiration date and time.
	ExpirationDateTime *time.Time `json:"expirationDateTime,omitempty"`
	// PayloadFileName Payload file name (*.mobileprovision | *.xml).
	PayloadFileName *string `json:"payloadFileName,omitempty"`
	// Payload Payload. (UTF8 encoded byte array)
	Payload *Binary `json:"payload,omitempty"`
	// RoleScopeTagIDs List of Scope Tags for this iOS LOB app provisioning configuration entity.
	RoleScopeTagIDs []string `json:"roleScopeTagIds,omitempty"`
	// CreatedDateTime DateTime the object was created.
	CreatedDateTime *time.Time `json:"createdDateTime,omitempty"`
	// Description Admin provided description of the Device Configuration.
	Description *string `json:"description,omitempty"`
	// LastModifiedDateTime DateTime the object was last modified.
	LastModifiedDateTime *time.Time `json:"lastModifiedDateTime,omitempty"`
	// DisplayName Admin provided name of the device configuration.
	DisplayName *string `json:"displayName,omitempty"`
	// Version Version of the device configuration.
	Version *int `json:"version,omitempty"`
	// GroupAssignments undocumented
	GroupAssignments []MobileAppProvisioningConfigGroupAssignment `json:"groupAssignments,omitempty"`
	// Assignments undocumented
	Assignments []IOSLobAppProvisioningConfigurationAssignment `json:"assignments,omitempty"`
	// DeviceStatuses undocumented
	DeviceStatuses []ManagedDeviceMobileAppConfigurationDeviceStatus `json:"deviceStatuses,omitempty"`
	// UserStatuses undocumented
	UserStatuses []ManagedDeviceMobileAppConfigurationUserStatus `json:"userStatuses,omitempty"`
}

// IOSLobAppProvisioningConfigurationAssignment A class containing the properties used for Group Assignment of an iOS LOB App Provisioning and Configuration.
type IOSLobAppProvisioningConfigurationAssignment struct {
	// Entity is the base model of IOSLobAppProvisioningConfigurationAssignment
	Entity
	// Target The target group assignment defined by the admin.
	Target *DeviceAndAppManagementAssignmentTarget `json:"target,omitempty"`
}

// IOSLobAppProvisioningConfigurationPolicySetItem A class containing the properties used for iOS lob app provisioning configuration PolicySetItem.
type IOSLobAppProvisioningConfigurationPolicySetItem struct {
	// PolicySetItem is the base model of IOSLobAppProvisioningConfigurationPolicySetItem
	PolicySetItem
}

// IOSManagedAppProtection Policy used to configure detailed management settings targeted to specific security groups and for a specified set of apps on an iOS device
type IOSManagedAppProtection struct {
	// TargetedManagedAppProtection is the base model of IOSManagedAppProtection
	TargetedManagedAppProtection
	// AppDataEncryptionType Type of encryption which should be used for data in a managed app.
	AppDataEncryptionType *ManagedAppDataEncryptionType `json:"appDataEncryptionType,omitempty"`
	// MinimumRequiredSdkVersion Versions less than the specified version will block the managed app from accessing company data.
	MinimumRequiredSdkVersion *string `json:"minimumRequiredSdkVersion,omitempty"`
	// DeployedAppCount Count of apps to which the current policy is deployed.
	DeployedAppCount *int `json:"deployedAppCount,omitempty"`
	// FaceIDBlocked Indicates whether use of the FaceID is allowed in place of a pin if PinRequired is set to True.
	FaceIDBlocked *bool `json:"faceIdBlocked,omitempty"`
	// ExemptedAppProtocols Apps in this list will be exempt from the policy and will be able to receive data from managed apps.
	ExemptedAppProtocols []KeyValuePair `json:"exemptedAppProtocols,omitempty"`
	// MinimumWipeSdkVersion Versions less than the specified version will block the managed app from accessing company data.
	MinimumWipeSdkVersion *string `json:"minimumWipeSdkVersion,omitempty"`
	// AllowedIOSDeviceModels Semicolon seperated list of device models allowed, as a string, for the managed app to work.
	AllowedIOSDeviceModels *string `json:"allowedIosDeviceModels,omitempty"`
	// AppActionIfIOSDeviceModelNotAllowed Defines a managed app behavior, either block or wipe, if the specified device model is not allowed.
	AppActionIfIOSDeviceModelNotAllowed *ManagedAppRemediationAction `json:"appActionIfIosDeviceModelNotAllowed,omitempty"`
	// ThirdPartyKeyboardsBlocked Defines if third party keyboards are allowed while accessing a managed app
	ThirdPartyKeyboardsBlocked *bool `json:"thirdPartyKeyboardsBlocked,omitempty"`
	// FilterOpenInToOnlyManagedApps Defines if open-in operation is supported from the managed app to the filesharing locations selected. This setting only applies when AllowedOutboundDataTransferDestinations is set to ManagedApps and DisableProtectionOfManagedOutboundOpenInData is set to False.
	FilterOpenInToOnlyManagedApps *bool `json:"filterOpenInToOnlyManagedApps,omitempty"`
	// DisableProtectionOfManagedOutboundOpenInData Disable protection of data transferred to other apps through IOS OpenIn option. This setting is only allowed to be True when AllowedOutboundDataTransferDestinations is set to ManagedApps.
	DisableProtectionOfManagedOutboundOpenInData *bool `json:"disableProtectionOfManagedOutboundOpenInData,omitempty"`
	// ProtectInboundDataFromUnknownSources Protect incoming data from unknown source. This setting is only allowed to be True when AllowedInboundDataTransferSources is set to AllApps.
	ProtectInboundDataFromUnknownSources *bool `json:"protectInboundDataFromUnknownSources,omitempty"`
	// CustomBrowserProtocol A custom browser protocol to open weblink on iOS.
	CustomBrowserProtocol *string `json:"customBrowserProtocol,omitempty"`
	// Apps undocumented
	Apps []ManagedMobileApp `json:"apps,omitempty"`
	// DeploymentSummary undocumented
	DeploymentSummary *ManagedAppPolicyDeploymentSummary `json:"deploymentSummary,omitempty"`
}

// IOSManagedAppRegistration Represents the synchronization details of an ios app, with management capabilities, for a specific user.
type IOSManagedAppRegistration struct {
	// ManagedAppRegistration is the base model of IOSManagedAppRegistration
	ManagedAppRegistration
}

// IOSMinimumOperatingSystem undocumented
type IOSMinimumOperatingSystem struct {
	// Object is the base model of IOSMinimumOperatingSystem
	Object
	// V8_0 Version 8.0 or later.
	V8_0 *bool `json:"v8_0,omitempty"`
	// V9_0 Version 9.0 or later.
	V9_0 *bool `json:"v9_0,omitempty"`
	// V10_0 Version 10.0 or later.
	V10_0 *bool `json:"v10_0,omitempty"`
	// V11_0 Version 11.0 or later.
	V11_0 *bool `json:"v11_0,omitempty"`
	// V12_0 Version 12.0 or later.
	V12_0 *bool `json:"v12_0,omitempty"`
	// V13_0 Version 13.0 or later.
	V13_0 *bool `json:"v13_0,omitempty"`
}

// IOSMobileAppConfiguration Contains properties, inherited properties and actions for iOS mobile app configurations.
type IOSMobileAppConfiguration struct {
	// ManagedDeviceMobileAppConfiguration is the base model of IOSMobileAppConfiguration
	ManagedDeviceMobileAppConfiguration
	// EncodedSettingXML mdm app configuration Base64 binary.
	EncodedSettingXML *Binary `json:"encodedSettingXml,omitempty"`
	// Settings app configuration setting items.
	Settings []AppConfigurationSettingItem `json:"settings,omitempty"`
}

// IOSMobileAppIdentifier undocumented
type IOSMobileAppIdentifier struct {
	// MobileAppIdentifier is the base model of IOSMobileAppIdentifier
	MobileAppIdentifier
	// BundleID The identifier for an app, as specified in the app store.
	BundleID *string `json:"bundleId,omitempty"`
}

// IOSNetworkUsageRule undocumented
type IOSNetworkUsageRule struct {
	// Object is the base model of IOSNetworkUsageRule
	Object
	// ManagedApps Information about the managed apps that this rule is going to apply to. This collection can contain a maximum of 500 elements.
	ManagedApps []AppListItem `json:"managedApps,omitempty"`
	// CellularDataBlockWhenRoaming If set to true, corresponding managed apps will not be allowed to use cellular data when roaming.
	CellularDataBlockWhenRoaming *bool `json:"cellularDataBlockWhenRoaming,omitempty"`
	// CellularDataBlocked If set to true, corresponding managed apps will not be allowed to use cellular data at any time.
	CellularDataBlocked *bool `json:"cellularDataBlocked,omitempty"`
}

// IOSNotificationSettings undocumented
type IOSNotificationSettings struct {
	// Object is the base model of IOSNotificationSettings
	Object
	// BundleID Bundle id of app to which to apply these notification settings.
	BundleID *string `json:"bundleID,omitempty"`
	// AppName Application name to be associated with the bundleID.
	AppName *string `json:"appName,omitempty"`
	// Publisher Publisher to be associated with the bundleID.
	Publisher *string `json:"publisher,omitempty"`
	// Enabled Indicates whether notifications are allowed for this app.
	Enabled *bool `json:"enabled,omitempty"`
	// ShowInNotificationCenter Indicates whether notifications can be shown in notification center.
	ShowInNotificationCenter *bool `json:"showInNotificationCenter,omitempty"`
	// ShowOnLockScreen Indicates whether notifications can be shown on the lock screen.
	ShowOnLockScreen *bool `json:"showOnLockScreen,omitempty"`
	// AlertType Indicates the type of alert for notifications for this app.
	AlertType *IOSNotificationAlertType `json:"alertType,omitempty"`
	// BadgesEnabled Indicates whether badges are allowed for this app.
	BadgesEnabled *bool `json:"badgesEnabled,omitempty"`
	// SoundsEnabled Indicates whether sounds are allowed for this app.
	SoundsEnabled *bool `json:"soundsEnabled,omitempty"`
}

// IOSPkcsCertificateProfile iOS PKCS certificate profile.
type IOSPkcsCertificateProfile struct {
	// IOSCertificateProfileBase is the base model of IOSPkcsCertificateProfile
	IOSCertificateProfileBase
	// CertificationAuthority PKCS Certification Authority.
	CertificationAuthority *string `json:"certificationAuthority,omitempty"`
	// CertificationAuthorityName PKCS Certification Authority Name.
	CertificationAuthorityName *string `json:"certificationAuthorityName,omitempty"`
	// CertificateTemplateName PKCS Certificate Template Name.
	CertificateTemplateName *string `json:"certificateTemplateName,omitempty"`
	// SubjectAlternativeNameFormatString Custom String that defines the AAD Attribute.
	SubjectAlternativeNameFormatString *string `json:"subjectAlternativeNameFormatString,omitempty"`
	// ManagedDeviceCertificateStates undocumented
	ManagedDeviceCertificateStates []ManagedDeviceCertificateState `json:"managedDeviceCertificateStates,omitempty"`
}

// IOSScepCertificateProfile iOS SCEP certificate profile.
type IOSScepCertificateProfile struct {
	// IOSCertificateProfileBase is the base model of IOSScepCertificateProfile
	IOSCertificateProfileBase
	// ScepServerUrls SCEP Server Url(s).
	ScepServerUrls []string `json:"scepServerUrls,omitempty"`
	// SubjectNameFormatString Custom format to use with SubjectNameFormat = Custom. Example: CN={{EmailAddress}},E={{EmailAddress}},OU=Enterprise Users,O=Contoso Corporation,L=Redmond,ST=WA,C=US
	SubjectNameFormatString *string `json:"subjectNameFormatString,omitempty"`
	// KeyUsage SCEP Key Usage.
	KeyUsage *KeyUsages `json:"keyUsage,omitempty"`
	// KeySize SCEP Key Size.
	KeySize *KeySize `json:"keySize,omitempty"`
	// ExtendedKeyUsages Extended Key Usage (EKU) settings. This collection can contain a maximum of 500 elements.
	ExtendedKeyUsages []ExtendedKeyUsage `json:"extendedKeyUsages,omitempty"`
	// SubjectAlternativeNameFormatString Custom String that defines the AAD Attribute.
	SubjectAlternativeNameFormatString *string `json:"subjectAlternativeNameFormatString,omitempty"`
	// CertificateStore Target store certificate
	CertificateStore *CertificateStore `json:"certificateStore,omitempty"`
	// CustomSubjectAlternativeNames Custom Subject Alternative Name Settings. This collection can contain a maximum of 500 elements.
	CustomSubjectAlternativeNames []CustomSubjectAlternativeName `json:"customSubjectAlternativeNames,omitempty"`
	// RootCertificate undocumented
	RootCertificate *IOSTrustedRootCertificate `json:"rootCertificate,omitempty"`
	// ManagedDeviceCertificateStates undocumented
	ManagedDeviceCertificateStates []ManagedDeviceCertificateState `json:"managedDeviceCertificateStates,omitempty"`
}

// IOSSingleSignOnSettings undocumented
type IOSSingleSignOnSettings struct {
	// Object is the base model of IOSSingleSignOnSettings
	Object
	// AllowedAppsList List of app identifiers that are allowed to use this login. If this field is omitted, the login applies to all applications on the device. This collection can contain a maximum of 500 elements.
	AllowedAppsList []AppListItem `json:"allowedAppsList,omitempty"`
	// AllowedUrls List of HTTP URLs that must be matched in order to use this login. With iOS 9.0 or later, a wildcard characters may be used.
	AllowedUrls []string `json:"allowedUrls,omitempty"`
	// DisplayName The display name of login settings shown on the receiving device.
	DisplayName *string `json:"displayName,omitempty"`
	// KerberosPrincipalName A Kerberos principal name. If not provided, the user is prompted for one during profile installation.
	KerberosPrincipalName *string `json:"kerberosPrincipalName,omitempty"`
	// KerberosRealm A Kerberos realm name. Case sensitive.
	KerberosRealm *string `json:"kerberosRealm,omitempty"`
}

// IOSStoreApp Contains properties and inherited properties for iOS store apps.
type IOSStoreApp struct {
	// MobileApp is the base model of IOSStoreApp
	MobileApp
	// BundleID The Identity Name.
	BundleID *string `json:"bundleId,omitempty"`
	// AppStoreURL The Apple App Store URL
	AppStoreURL *string `json:"appStoreUrl,omitempty"`
	// ApplicableDeviceType The iOS architecture for which this app can run on.
	ApplicableDeviceType *IOSDeviceType `json:"applicableDeviceType,omitempty"`
	// MinimumSupportedOperatingSystem The value for the minimum applicable operating system.
	MinimumSupportedOperatingSystem *IOSMinimumOperatingSystem `json:"minimumSupportedOperatingSystem,omitempty"`
}

// IOSStoreAppAssignmentSettings undocumented
type IOSStoreAppAssignmentSettings struct {
	// MobileAppAssignmentSettings is the base model of IOSStoreAppAssignmentSettings
	MobileAppAssignmentSettings
	// VPNConfigurationID The VPN Configuration Id to apply for this app.
	VPNConfigurationID *string `json:"vpnConfigurationId,omitempty"`
	// UninstallOnDeviceRemoval Whether or not to uninstall the app when device is removed from Intune.
	UninstallOnDeviceRemoval *bool `json:"uninstallOnDeviceRemoval,omitempty"`
}

// IOSTrustedRootCertificate iOS Trusted Root Certificate configuration profile.
type IOSTrustedRootCertificate struct {
	// DeviceConfiguration is the base model of IOSTrustedRootCertificate
	DeviceConfiguration
	// TrustedRootCertificate Trusted Root Certificate.
	TrustedRootCertificate *Binary `json:"trustedRootCertificate,omitempty"`
	// CertFileName File name to display in UI.
	CertFileName *string `json:"certFileName,omitempty"`
}

// IOSUpdateConfiguration IOS Update Configuration, allows you to configure time window within week to install iOS updates
type IOSUpdateConfiguration struct {
	// DeviceConfiguration is the base model of IOSUpdateConfiguration
	DeviceConfiguration
	// IsEnabled Is setting enabled in UI
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// ActiveHoursStart Active Hours Start (active hours mean the time window when updates install should not happen)
	ActiveHoursStart *TimeOfDay `json:"activeHoursStart,omitempty"`
	// ActiveHoursEnd Active Hours End (active hours mean the time window when updates install should not happen)
	ActiveHoursEnd *TimeOfDay `json:"activeHoursEnd,omitempty"`
	// ScheduledInstallDays Days in week for which active hours are configured. This collection can contain a maximum of 7 elements.
	ScheduledInstallDays []DayOfWeek `json:"scheduledInstallDays,omitempty"`
	// UtcTimeOffsetInMinutes UTC Time Offset indicated in minutes
	UtcTimeOffsetInMinutes *int `json:"utcTimeOffsetInMinutes,omitempty"`
	// EnforcedSoftwareUpdateDelayInDays Days before software updates are visible to iOS devices ranging from 0 to 90 inclusive
	EnforcedSoftwareUpdateDelayInDays *int `json:"enforcedSoftwareUpdateDelayInDays,omitempty"`
}

// IOSUpdateDeviceStatus undocumented
type IOSUpdateDeviceStatus struct {
	// Entity is the base model of IOSUpdateDeviceStatus
	Entity
	// InstallStatus The installation status of the policy report.
	InstallStatus *IOSUpdatesInstallStatus `json:"installStatus,omitempty"`
	// OsVersion The device version that is being reported.
	OsVersion *string `json:"osVersion,omitempty"`
	// DeviceID The device id that is being reported.
	DeviceID *string `json:"deviceId,omitempty"`
	// UserID The User id that is being reported.
	UserID *string `json:"userId,omitempty"`
	// DeviceDisplayName Device name of the DevicePolicyStatus.
	DeviceDisplayName *string `json:"deviceDisplayName,omitempty"`
	// UserName The User Name that is being reported
	UserName *string `json:"userName,omitempty"`
	// DeviceModel The device model that is being reported
	DeviceModel *string `json:"deviceModel,omitempty"`
	// Platform Platform of the device that is being reported
	Platform *int `json:"platform,omitempty"`
	// ComplianceGracePeriodExpirationDateTime The DateTime when device compliance grace period expires
	ComplianceGracePeriodExpirationDateTime *time.Time `json:"complianceGracePeriodExpirationDateTime,omitempty"`
	// Status Compliance status of the policy report.
	Status *ComplianceStatus `json:"status,omitempty"`
	// LastReportedDateTime Last modified date time of the policy report.
	LastReportedDateTime *time.Time `json:"lastReportedDateTime,omitempty"`
	// UserPrincipalName UserPrincipalName.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
}

// IOSVPNConfiguration By providing the configurations in this profile you can instruct the iOS device to connect to desired VPN endpoint. By specifying the authentication method and security types expected by VPN endpoint you can make the VPN connection seamless for end user.
type IOSVPNConfiguration struct {
	// AppleVPNConfiguration is the base model of IOSVPNConfiguration
	AppleVPNConfiguration
	// ProviderType Provider type for per-app VPN.
	ProviderType *VPNProviderType `json:"providerType,omitempty"`
	// UserDomain Zscaler only. Enter a static domain to pre-populate the login field with in the Zscaler app. If this is left empty, the user's Azure Active Directory domain will be used instead.
	UserDomain *string `json:"userDomain,omitempty"`
	// StrictEnforcement Zscaler only. Blocks network traffic until the user signs into Zscaler app. "True" means traffic is blocked.
	StrictEnforcement *bool `json:"strictEnforcement,omitempty"`
	// CloudName Zscaler only. Zscaler cloud which the user is assigned to.
	CloudName *string `json:"cloudName,omitempty"`
	// ExcludeList Zscaler only. List of network addresses which are not sent through the Zscaler cloud.
	ExcludeList []string `json:"excludeList,omitempty"`
	// IdentityCertificate undocumented
	IdentityCertificate *IOSCertificateProfileBase `json:"identityCertificate,omitempty"`
	// DerivedCredentialSettings undocumented
	DerivedCredentialSettings *DeviceManagementDerivedCredentialSettings `json:"derivedCredentialSettings,omitempty"`
}

// IOSVPNSecurityAssociationParameters undocumented
type IOSVPNSecurityAssociationParameters struct {
	// Object is the base model of IOSVPNSecurityAssociationParameters
	Object
	// SecurityEncryptionAlgorithm Encryption algorithm
	SecurityEncryptionAlgorithm *VPNEncryptionAlgorithmType `json:"securityEncryptionAlgorithm,omitempty"`
	// SecurityIntegrityAlgorithm Integrity algorithm
	SecurityIntegrityAlgorithm *VPNIntegrityAlgorithmType `json:"securityIntegrityAlgorithm,omitempty"`
	// SecurityDiffieHellmanGroup Diffie-Hellman Group
	SecurityDiffieHellmanGroup *int `json:"securityDiffieHellmanGroup,omitempty"`
	// LifetimeInMinutes Lifetime (minutes)
	LifetimeInMinutes *int `json:"lifetimeInMinutes,omitempty"`
}

// IOSVPPApp Contains properties and inherited properties for iOS Volume-Purchased Program (VPP) Apps.
type IOSVPPApp struct {
	// MobileApp is the base model of IOSVPPApp
	MobileApp
	// UsedLicenseCount The number of VPP licenses in use.
	UsedLicenseCount *int `json:"usedLicenseCount,omitempty"`
	// TotalLicenseCount The total number of VPP licenses.
	TotalLicenseCount *int `json:"totalLicenseCount,omitempty"`
	// ReleaseDateTime The VPP application release date and time.
	ReleaseDateTime *time.Time `json:"releaseDateTime,omitempty"`
	// AppStoreURL The store URL.
	AppStoreURL *string `json:"appStoreUrl,omitempty"`
	// LicensingType The supported License Type.
	LicensingType *VPPLicensingType `json:"licensingType,omitempty"`
	// ApplicableDeviceType The applicable iOS Device Type.
	ApplicableDeviceType *IOSDeviceType `json:"applicableDeviceType,omitempty"`
	// VPPTokenOrganizationName The organization associated with the Apple Volume Purchase Program Token
	VPPTokenOrganizationName *string `json:"vppTokenOrganizationName,omitempty"`
	// VPPTokenAccountType The type of volume purchase program which the given Apple Volume Purchase Program Token is associated with. Possible values are: `business`, `education`.
	VPPTokenAccountType *VPPTokenAccountType `json:"vppTokenAccountType,omitempty"`
	// VPPTokenAppleID The Apple Id associated with the given Apple Volume Purchase Program Token.
	VPPTokenAppleID *string `json:"vppTokenAppleId,omitempty"`
	// BundleID The Identity Name.
	BundleID *string `json:"bundleId,omitempty"`
	// VPPTokenID Identifier of the VPP token associated with this app.
	VPPTokenID *string `json:"vppTokenId,omitempty"`
	// RevokeLicenseActionResults Results of revoke license actions on this app.
	RevokeLicenseActionResults []IOSVPPAppRevokeLicensesActionResult `json:"revokeLicenseActionResults,omitempty"`
	// AssignedLicenses undocumented
	AssignedLicenses []IOSVPPAppAssignedLicense `json:"assignedLicenses,omitempty"`
}

// IOSVPPAppAssignedDeviceLicense iOS Volume Purchase Program device license assignment. This class does not support Create, Delete, or Update.
type IOSVPPAppAssignedDeviceLicense struct {
	// IOSVPPAppAssignedLicense is the base model of IOSVPPAppAssignedDeviceLicense
	IOSVPPAppAssignedLicense
	// ManagedDeviceID The managed device ID.
	ManagedDeviceID *string `json:"managedDeviceId,omitempty"`
	// DeviceName The device name.
	DeviceName *string `json:"deviceName,omitempty"`
}

// IOSVPPAppAssignedLicense iOS Volume Purchase Program license assignment. This class does not support Create, Delete, or Update.
type IOSVPPAppAssignedLicense struct {
	// Entity is the base model of IOSVPPAppAssignedLicense
	Entity
	// UserEmailAddress The user email address.
	UserEmailAddress *string `json:"userEmailAddress,omitempty"`
	// UserID The user ID.
	UserID *string `json:"userId,omitempty"`
	// UserName The user name.
	UserName *string `json:"userName,omitempty"`
	// UserPrincipalName The user principal name.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
}

// IOSVPPAppAssignedUserLicense iOS Volume Purchase Program user license assignment. This class does not support Create, Delete, or Update.
type IOSVPPAppAssignedUserLicense struct {
	// IOSVPPAppAssignedLicense is the base model of IOSVPPAppAssignedUserLicense
	IOSVPPAppAssignedLicense
}

// IOSVPPAppAssignmentSettings undocumented
type IOSVPPAppAssignmentSettings struct {
	// MobileAppAssignmentSettings is the base model of IOSVPPAppAssignmentSettings
	MobileAppAssignmentSettings
	// UseDeviceLicensing Whether or not to use device licensing.
	UseDeviceLicensing *bool `json:"useDeviceLicensing,omitempty"`
	// VPNConfigurationID The VPN Configuration Id to apply for this app.
	VPNConfigurationID *string `json:"vpnConfigurationId,omitempty"`
	// UninstallOnDeviceRemoval Whether or not to uninstall the app when device is removed from Intune.
	UninstallOnDeviceRemoval *bool `json:"uninstallOnDeviceRemoval,omitempty"`
}

// IOSVPPAppRevokeLicensesActionResult undocumented
type IOSVPPAppRevokeLicensesActionResult struct {
	// Object is the base model of IOSVPPAppRevokeLicensesActionResult
	Object
	// UserID UserId associated with the action.
	UserID *string `json:"userId,omitempty"`
	// ManagedDeviceID DeviceId associated with the action.
	ManagedDeviceID *string `json:"managedDeviceId,omitempty"`
	// TotalLicensesCount A count of the number of licenses for which revoke was attempted.
	TotalLicensesCount *int `json:"totalLicensesCount,omitempty"`
	// FailedLicensesCount A count of the number of licenses for which revoke failed.
	FailedLicensesCount *int `json:"failedLicensesCount,omitempty"`
	// ActionFailureReason The reason for the revoke licenses action failure.
	ActionFailureReason *VPPTokenActionFailureReason `json:"actionFailureReason,omitempty"`
	// ActionName Action name
	ActionName *string `json:"actionName,omitempty"`
	// ActionState State of the action
	ActionState *ActionState `json:"actionState,omitempty"`
	// StartDateTime Time the action was initiated
	StartDateTime *time.Time `json:"startDateTime,omitempty"`
	// LastUpdatedDateTime Time the action state was last updated
	LastUpdatedDateTime *time.Time `json:"lastUpdatedDateTime,omitempty"`
}

// IOSVPPEBook A class containing the properties for iOS Vpp eBook.
type IOSVPPEBook struct {
	// ManagedEBook is the base model of IOSVPPEBook
	ManagedEBook
	// VPPTokenID The Vpp token ID.
	VPPTokenID *UUID `json:"vppTokenId,omitempty"`
	// AppleID The Apple ID associated with Vpp token.
	AppleID *string `json:"appleId,omitempty"`
	// VPPOrganizationName The Vpp token's organization name.
	VPPOrganizationName *string `json:"vppOrganizationName,omitempty"`
	// Genres Genres.
	Genres []string `json:"genres,omitempty"`
	// Language Language.
	Language *string `json:"language,omitempty"`
	// Seller Seller.
	Seller *string `json:"seller,omitempty"`
	// TotalLicenseCount Total license count.
	TotalLicenseCount *int `json:"totalLicenseCount,omitempty"`
	// UsedLicenseCount Used license count.
	UsedLicenseCount *int `json:"usedLicenseCount,omitempty"`
	// RoleScopeTagIDs List of Scope Tags for this Entity instance.
	RoleScopeTagIDs []string `json:"roleScopeTagIds,omitempty"`
}

// IOSVPPEBookAssignment Contains properties used to assign an iOS VPP EBook to a group.
type IOSVPPEBookAssignment struct {
	// ManagedEBookAssignment is the base model of IOSVPPEBookAssignment
	ManagedEBookAssignment
}

// IOSWebContentFilterAutoFilter undocumented
type IOSWebContentFilterAutoFilter struct {
	// IOSWebContentFilterBase is the base model of IOSWebContentFilterAutoFilter
	IOSWebContentFilterBase
	// AllowedUrls Additional URLs allowed for access
	AllowedUrls []string `json:"allowedUrls,omitempty"`
	// BlockedUrls Additional URLs blocked for access
	BlockedUrls []string `json:"blockedUrls,omitempty"`
}

// IOSWebContentFilterBase undocumented
type IOSWebContentFilterBase struct {
	// Object is the base model of IOSWebContentFilterBase
	Object
}

// IOSWebContentFilterSpecificWebsitesAccess undocumented
type IOSWebContentFilterSpecificWebsitesAccess struct {
	// IOSWebContentFilterBase is the base model of IOSWebContentFilterSpecificWebsitesAccess
	IOSWebContentFilterBase
	// SpecificWebsitesOnly URL bookmarks which will be installed into built-in browser and user is only allowed to access websites through bookmarks. This collection can contain a maximum of 500 elements.
	SpecificWebsitesOnly []IOSBookmark `json:"specificWebsitesOnly,omitempty"`
	// WebsiteList URL bookmarks which will be installed into built-in browser and user is only allowed to access websites through bookmarks. This collection can contain a maximum of 500 elements.
	WebsiteList []IOSBookmark `json:"websiteList,omitempty"`
}

// IOSWiFiConfiguration By providing the configurations in this profile you can instruct the iOS device to connect to desired Wi-Fi endpoint. By specifying the authentication method and security types expected by Wi-Fi endpoint you can make the Wi-Fi connection seamless for end user. This profile provides limited and simpler security types than Enterprise Wi-Fi profile.
type IOSWiFiConfiguration struct {
	// DeviceConfiguration is the base model of IOSWiFiConfiguration
	DeviceConfiguration
	// NetworkName Network Name
	NetworkName *string `json:"networkName,omitempty"`
	// Ssid This is the name of the Wi-Fi network that is broadcast to all devices.
	Ssid *string `json:"ssid,omitempty"`
	// ConnectAutomatically Connect automatically when this network is in range. Setting this to true will skip the user prompt and automatically connect the device to Wi-Fi network.
	ConnectAutomatically *bool `json:"connectAutomatically,omitempty"`
	// ConnectWhenNetworkNameIsHidden Connect when the network is not broadcasting its name (SSID). When set to true, this profile forces the device to connect to a network that doesn't broadcast its SSID to all devices.
	ConnectWhenNetworkNameIsHidden *bool `json:"connectWhenNetworkNameIsHidden,omitempty"`
	// WiFiSecurityType Indicates whether Wi-Fi endpoint uses an EAP based security type.
	WiFiSecurityType *WiFiSecurityType `json:"wiFiSecurityType,omitempty"`
	// ProxySettings Proxy Type for this Wi-Fi connection
	ProxySettings *WiFiProxySetting `json:"proxySettings,omitempty"`
	// ProxyManualAddress IP Address or DNS hostname of the proxy server when manual configuration is selected.
	ProxyManualAddress *string `json:"proxyManualAddress,omitempty"`
	// ProxyManualPort Port of the proxy server when manual configuration is selected.
	ProxyManualPort *int `json:"proxyManualPort,omitempty"`
	// ProxyAutomaticConfigurationURL URL of the proxy server automatic configuration script when automatic configuration is selected. This URL is typically the location of PAC (Proxy Auto Configuration) file.
	ProxyAutomaticConfigurationURL *string `json:"proxyAutomaticConfigurationUrl,omitempty"`
	// PreSharedKey This is the pre-shared key for WPA Personal Wi-Fi network.
	PreSharedKey *string `json:"preSharedKey,omitempty"`
}
