// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import "time"

// MacManagedAppProtection undocumented
type MacManagedAppProtection struct {
	// Entity is the base model of MacManagedAppProtection
	Entity
}

// MacOSCertificateProfileBase Mac OS certificate profile.
type MacOSCertificateProfileBase struct {
	// DeviceConfiguration is the base model of MacOSCertificateProfileBase
	DeviceConfiguration
	// RenewalThresholdPercentage Certificate renewal threshold percentage.
	RenewalThresholdPercentage *int `json:"renewalThresholdPercentage,omitempty"`
	// SubjectNameFormat Certificate Subject Name Format.
	SubjectNameFormat *AppleSubjectNameFormat `json:"subjectNameFormat,omitempty"`
	// SubjectAlternativeNameType Certificate Subject Alternative Name Type.
	SubjectAlternativeNameType *SubjectAlternativeNameType `json:"subjectAlternativeNameType,omitempty"`
	// CertificateValidityPeriodValue Value for the Certificate Validity Period.
	CertificateValidityPeriodValue *int `json:"certificateValidityPeriodValue,omitempty"`
	// CertificateValidityPeriodScale Scale for the Certificate Validity Period.
	CertificateValidityPeriodScale *CertificateValidityPeriodScale `json:"certificateValidityPeriodScale,omitempty"`
}

// MacOSCompliancePolicy This class contains compliance settings for Mac OS.
type MacOSCompliancePolicy struct {
	// DeviceCompliancePolicy is the base model of MacOSCompliancePolicy
	DeviceCompliancePolicy
	// PasswordRequired Whether or not to require a password.
	PasswordRequired *bool `json:"passwordRequired,omitempty"`
	// PasswordBlockSimple Indicates whether or not to block simple passwords.
	PasswordBlockSimple *bool `json:"passwordBlockSimple,omitempty"`
	// PasswordExpirationDays Number of days before the password expires. Valid values 1 to 65535
	PasswordExpirationDays *int `json:"passwordExpirationDays,omitempty"`
	// PasswordMinimumLength Minimum length of password. Valid values 4 to 14
	PasswordMinimumLength *int `json:"passwordMinimumLength,omitempty"`
	// PasswordMinutesOfInactivityBeforeLock Minutes of inactivity before a password is required.
	PasswordMinutesOfInactivityBeforeLock *int `json:"passwordMinutesOfInactivityBeforeLock,omitempty"`
	// PasswordPreviousPasswordBlockCount Number of previous passwords to block. Valid values 1 to 24
	PasswordPreviousPasswordBlockCount *int `json:"passwordPreviousPasswordBlockCount,omitempty"`
	// PasswordMinimumCharacterSetCount The number of character sets required in the password.
	PasswordMinimumCharacterSetCount *int `json:"passwordMinimumCharacterSetCount,omitempty"`
	// PasswordRequiredType The required password type.
	PasswordRequiredType *RequiredPasswordType `json:"passwordRequiredType,omitempty"`
	// OsMinimumVersion Minimum MacOS version.
	OsMinimumVersion *string `json:"osMinimumVersion,omitempty"`
	// OsMaximumVersion Maximum MacOS version.
	OsMaximumVersion *string `json:"osMaximumVersion,omitempty"`
	// OsMinimumBuildVersion Minimum MacOS build version.
	OsMinimumBuildVersion *string `json:"osMinimumBuildVersion,omitempty"`
	// OsMaximumBuildVersion Maximum MacOS build version.
	OsMaximumBuildVersion *string `json:"osMaximumBuildVersion,omitempty"`
	// SystemIntegrityProtectionEnabled Require that devices have enabled system integrity protection.
	SystemIntegrityProtectionEnabled *bool `json:"systemIntegrityProtectionEnabled,omitempty"`
	// DeviceThreatProtectionEnabled Require that devices have enabled device threat protection.
	DeviceThreatProtectionEnabled *bool `json:"deviceThreatProtectionEnabled,omitempty"`
	// DeviceThreatProtectionRequiredSecurityLevel Require Mobile Threat Protection minimum risk level to report noncompliance.
	DeviceThreatProtectionRequiredSecurityLevel *DeviceThreatProtectionLevel `json:"deviceThreatProtectionRequiredSecurityLevel,omitempty"`
	// StorageRequireEncryption Require encryption on Mac OS devices.
	StorageRequireEncryption *bool `json:"storageRequireEncryption,omitempty"`
	// GatekeeperAllowedAppSource System and Privacy setting that determines which download locations apps can be run from on a macOS device.
	GatekeeperAllowedAppSource *MacOSGatekeeperAppSources `json:"gatekeeperAllowedAppSource,omitempty"`
	// FirewallEnabled Whether the firewall should be enabled or not.
	FirewallEnabled *bool `json:"firewallEnabled,omitempty"`
	// FirewallBlockAllIncoming Corresponds to the “Block all incoming connections” option.
	FirewallBlockAllIncoming *bool `json:"firewallBlockAllIncoming,omitempty"`
	// FirewallEnableStealthMode Corresponds to “Enable stealth mode.”
	FirewallEnableStealthMode *bool `json:"firewallEnableStealthMode,omitempty"`
}

// MacOSCustomAppConfiguration This topic provides descriptions of the declared methods, properties and relationships exposed by the macOSCustomAppConfiguration resource.
type MacOSCustomAppConfiguration struct {
	// DeviceConfiguration is the base model of MacOSCustomAppConfiguration
	DeviceConfiguration
	// BundleID Bundle id for targeting.
	BundleID *string `json:"bundleId,omitempty"`
	// FileName Configuration file name (*.plist | *.xml).
	FileName *string `json:"fileName,omitempty"`
	// ConfigurationXML Configuration xml. (UTF8 encoded byte array)
	ConfigurationXML *Binary `json:"configurationXml,omitempty"`
}

// MacOSCustomConfiguration This topic provides descriptions of the declared methods, properties and relationships exposed by the macOSCustomConfiguration resource.
type MacOSCustomConfiguration struct {
	// DeviceConfiguration is the base model of MacOSCustomConfiguration
	DeviceConfiguration
	// PayloadName Name that is displayed to the user.
	PayloadName *string `json:"payloadName,omitempty"`
	// PayloadFileName Payload file name (*.mobileconfig | *.xml).
	PayloadFileName *string `json:"payloadFileName,omitempty"`
	// Payload Payload. (UTF8 encoded byte array)
	Payload *Binary `json:"payload,omitempty"`
}

// MacOSDeviceFeaturesConfiguration MacOS device features configuration profile.
type MacOSDeviceFeaturesConfiguration struct {
	// AppleDeviceFeaturesConfigurationBase is the base model of MacOSDeviceFeaturesConfiguration
	AppleDeviceFeaturesConfigurationBase
	// AutoLaunchItems List of applications, files, folders, and other items to launch when the user logs in. This collection can contain a maximum of 500 elements.
	AutoLaunchItems []MacOSLaunchItem `json:"autoLaunchItems,omitempty"`
	// AdminShowHostInfo Whether to show admin host information on the login window.
	AdminShowHostInfo *bool `json:"adminShowHostInfo,omitempty"`
	// LoginWindowText Custom text to be displayed on the login window.
	LoginWindowText *string `json:"loginWindowText,omitempty"`
	// AuthorizedUsersListHidden Whether to show the name and password dialog or a list of users on the login window.
	AuthorizedUsersListHidden *bool `json:"authorizedUsersListHidden,omitempty"`
	// AuthorizedUsersListHideLocalUsers Whether to show only network and system users in the authorized users list on the login window.
	AuthorizedUsersListHideLocalUsers *bool `json:"authorizedUsersListHideLocalUsers,omitempty"`
	// AuthorizedUsersListHideMobileAccounts Whether to hide mobile users in the authorized users list on the login window.
	AuthorizedUsersListHideMobileAccounts *bool `json:"authorizedUsersListHideMobileAccounts,omitempty"`
	// AuthorizedUsersListIncludeNetworkUsers Whether to show network users in the authorized users list on the login window.
	AuthorizedUsersListIncludeNetworkUsers *bool `json:"authorizedUsersListIncludeNetworkUsers,omitempty"`
	// AuthorizedUsersListHideAdminUsers Whether to hide admin users in the authorized users list on the login window.
	AuthorizedUsersListHideAdminUsers *bool `json:"authorizedUsersListHideAdminUsers,omitempty"`
	// AuthorizedUsersListShowOtherManagedUsers Whether to show other users in the authorized users list on the login window.
	AuthorizedUsersListShowOtherManagedUsers *bool `json:"authorizedUsersListShowOtherManagedUsers,omitempty"`
	// ShutDownDisabled Whether to hide the Shut Down button item on the login window.
	ShutDownDisabled *bool `json:"shutDownDisabled,omitempty"`
	// RestartDisabled Whether to hide the Restart button item on the login window.
	RestartDisabled *bool `json:"restartDisabled,omitempty"`
	// SleepDisabled Whether to hide the Sleep menu item on the login window.
	SleepDisabled *bool `json:"sleepDisabled,omitempty"`
	// ConsoleAccessDisabled Whether the Other user will disregard use of the `>console> special user name.
	ConsoleAccessDisabled *bool `json:"consoleAccessDisabled,omitempty"`
	// ShutDownDisabledWhileLoggedIn Whether the Shut Down menu item on the login window will be disabled while the user is logged in.
	ShutDownDisabledWhileLoggedIn *bool `json:"shutDownDisabledWhileLoggedIn,omitempty"`
	// RestartDisabledWhileLoggedIn Whether the Restart menu item on the login window will be disabled while the user is logged in.
	RestartDisabledWhileLoggedIn *bool `json:"restartDisabledWhileLoggedIn,omitempty"`
	// PowerOffDisabledWhileLoggedIn Whether the Power Off menu item on the login window will be disabled while the user is logged in.
	PowerOffDisabledWhileLoggedIn *bool `json:"powerOffDisabledWhileLoggedIn,omitempty"`
	// LogOutDisabledWhileLoggedIn Whether the Log Out menu item on the login window will be disabled while the user is logged in.
	LogOutDisabledWhileLoggedIn *bool `json:"logOutDisabledWhileLoggedIn,omitempty"`
	// ScreenLockDisableImmediate Whether to disable the immediate screen lock functions.
	ScreenLockDisableImmediate *bool `json:"screenLockDisableImmediate,omitempty"`
	// AssociatedDomains Gets or sets a list that maps apps to their associated domains. The key should match the app's ID, and the value should be a string in the form of "service:domain" where domain is a fully qualified hostname (e.g. webcredentials:example.com). This collection can contain a maximum of 500 elements.
	AssociatedDomains []KeyValuePair `json:"associatedDomains,omitempty"`
	// SingleSignOnExtension Gets or sets a single sign-on extension profile.
	SingleSignOnExtension *SingleSignOnExtension `json:"singleSignOnExtension,omitempty"`
	// SingleSignOnExtensionPkinitCertificate undocumented
	SingleSignOnExtensionPkinitCertificate *MacOSCertificateProfileBase `json:"singleSignOnExtensionPkinitCertificate,omitempty"`
}

// MacOSEndpointProtectionConfiguration MacOS endpoint protection configuration profile.
type MacOSEndpointProtectionConfiguration struct {
	// DeviceConfiguration is the base model of MacOSEndpointProtectionConfiguration
	DeviceConfiguration
	// GatekeeperAllowedAppSource System and Privacy setting that determines which download locations apps can be run from on a macOS device.
	GatekeeperAllowedAppSource *MacOSGatekeeperAppSources `json:"gatekeeperAllowedAppSource,omitempty"`
	// GatekeeperBlockOverride If set to true, the user override for Gatekeeper will be disabled.
	GatekeeperBlockOverride *bool `json:"gatekeeperBlockOverride,omitempty"`
	// FirewallEnabled Whether the firewall should be enabled or not.
	FirewallEnabled *bool `json:"firewallEnabled,omitempty"`
	// FirewallBlockAllIncoming Corresponds to the “Block all incoming connections” option.
	FirewallBlockAllIncoming *bool `json:"firewallBlockAllIncoming,omitempty"`
	// FirewallEnableStealthMode Corresponds to “Enable stealth mode.”
	FirewallEnableStealthMode *bool `json:"firewallEnableStealthMode,omitempty"`
	// FirewallApplications List of applications with firewall settings. Firewall settings for applications not on this list are determined by the user. This collection can contain a maximum of 500 elements.
	FirewallApplications []MacOSFirewallApplication `json:"firewallApplications,omitempty"`
	// FileVaultEnabled Whether FileVault should be enabled or not.
	FileVaultEnabled *bool `json:"fileVaultEnabled,omitempty"`
	// FileVaultSelectedRecoveryKeyTypes Required if FileVault is enabled, determines the type(s) of recovery key to use.
	FileVaultSelectedRecoveryKeyTypes *MacOSFileVaultRecoveryKeyTypes `json:"fileVaultSelectedRecoveryKeyTypes,omitempty"`
	// FileVaultInstitutionalRecoveryKeyCertificate Required if selected recovery key type(s) include InstitutionalRecoveryKey. The DER Encoded certificate file used to set an institutional recovery key.
	FileVaultInstitutionalRecoveryKeyCertificate *Binary `json:"fileVaultInstitutionalRecoveryKeyCertificate,omitempty"`
	// FileVaultInstitutionalRecoveryKeyCertificateFileName File name of the institutional recovery key certificate to display in UI. (*.der).
	FileVaultInstitutionalRecoveryKeyCertificateFileName *string `json:"fileVaultInstitutionalRecoveryKeyCertificateFileName,omitempty"`
	// FileVaultPersonalRecoveryKeyHelpMessage Required if selected recovery key type(s) include PersonalRecoveryKey. A short message displayed to the user that explains how they can retrieve their personal recovery key.
	FileVaultPersonalRecoveryKeyHelpMessage *string `json:"fileVaultPersonalRecoveryKeyHelpMessage,omitempty"`
	// FileVaultAllowDeferralUntilSignOut Optional. If set to true, the user can defer the enabling of FileVault until they sign out.
	FileVaultAllowDeferralUntilSignOut *bool `json:"fileVaultAllowDeferralUntilSignOut,omitempty"`
	// FileVaultNumberOfTimesUserCanIgnore Optional. When using the Defer option, this is the maximum number of times the user can ignore prompts to enable FileVault before FileVault will be required for the user to sign in. If set to -1, it will always prompt to enable FileVault until FileVault is enabled, though it will allow the user to bypass enabling FileVault. Setting this to 0 will disable the feature.
	FileVaultNumberOfTimesUserCanIgnore *int `json:"fileVaultNumberOfTimesUserCanIgnore,omitempty"`
	// FileVaultDisablePromptAtSignOut Optional. When using the Defer option, if set to true, the user is not prompted to enable FileVault at sign-out.
	FileVaultDisablePromptAtSignOut *bool `json:"fileVaultDisablePromptAtSignOut,omitempty"`
	// FileVaultPersonalRecoveryKeyRotationInMonths Optional. If selected recovery key type(s) include PersonalRecoveryKey, the frequency to rotate that key, in months.
	FileVaultPersonalRecoveryKeyRotationInMonths *int `json:"fileVaultPersonalRecoveryKeyRotationInMonths,omitempty"`
}

// MacOSEnterpriseWiFiConfiguration MacOS Wi-Fi WPA-Enterprise/WPA2-Enterprise configuration profile.
type MacOSEnterpriseWiFiConfiguration struct {
	// MacOSWiFiConfiguration is the base model of MacOSEnterpriseWiFiConfiguration
	MacOSWiFiConfiguration
	// EapType Extensible Authentication Protocol (EAP). Indicates the type of EAP protocol set on the Wi-Fi endpoint (router).
	EapType *EapType `json:"eapType,omitempty"`
	// EapFastConfiguration EAP-FAST Configuration Option when EAP-FAST is the selected EAP Type.
	EapFastConfiguration *EapFastConfiguration `json:"eapFastConfiguration,omitempty"`
	// TrustedServerCertificateNames Trusted server certificate names when EAP Type is configured to EAP-TLS/TTLS/FAST or PEAP. This is the common name used in the certificates issued by your trusted certificate authority (CA). If you provide this information, you can bypass the dynamic trust dialog that is displayed on end users devices when they connect to this Wi-Fi network.
	TrustedServerCertificateNames []string `json:"trustedServerCertificateNames,omitempty"`
	// AuthenticationMethod Authentication Method when EAP Type is configured to PEAP or EAP-TTLS.
	AuthenticationMethod *WiFiAuthenticationMethod `json:"authenticationMethod,omitempty"`
	// InnerAuthenticationProtocolForEapTtls Non-EAP Method for Authentication (Inner Identity) when EAP Type is EAP-TTLS and Authenticationmethod is Username and Password.
	InnerAuthenticationProtocolForEapTtls *NonEapAuthenticationMethodForEapTtlsType `json:"innerAuthenticationProtocolForEapTtls,omitempty"`
	// OuterIdentityPrivacyTemporaryValue Enable identity privacy (Outer Identity) when EAP Type is configured to EAP-TTLS, EAP-FAST or PEAP. This property masks usernames with the text you enter. For example, if you use 'anonymous', each user that authenticates with this Wi-Fi connection using their real username is displayed as 'anonymous'.
	OuterIdentityPrivacyTemporaryValue *string `json:"outerIdentityPrivacyTemporaryValue,omitempty"`
	// RootCertificateForServerValidation undocumented
	RootCertificateForServerValidation *MacOSTrustedRootCertificate `json:"rootCertificateForServerValidation,omitempty"`
	// IdentityCertificateForClientAuthentication undocumented
	IdentityCertificateForClientAuthentication *MacOSCertificateProfileBase `json:"identityCertificateForClientAuthentication,omitempty"`
}

// MacOSExtensionsConfiguration MacOS extensions configuration profile.
type MacOSExtensionsConfiguration struct {
	// DeviceConfiguration is the base model of MacOSExtensionsConfiguration
	DeviceConfiguration
	// KernelExtensionOverridesAllowed If set to true, users can approve additional kernel extensions not explicitly allowed by configurations profiles.
	KernelExtensionOverridesAllowed *bool `json:"kernelExtensionOverridesAllowed,omitempty"`
	// KernelExtensionAllowedTeamIdentifiers All kernel extensions validly signed by the team identifiers in this list will be allowed to load.
	KernelExtensionAllowedTeamIdentifiers []string `json:"kernelExtensionAllowedTeamIdentifiers,omitempty"`
	// KernelExtensionsAllowed A list of kernel extensions that will be allowed to load. . This collection can contain a maximum of 500 elements.
	KernelExtensionsAllowed []MacOSKernelExtension `json:"kernelExtensionsAllowed,omitempty"`
}

// MacOSFirewallApplication undocumented
type MacOSFirewallApplication struct {
	// Object is the base model of MacOSFirewallApplication
	Object
	// BundleID BundleId of the application.
	BundleID *string `json:"bundleId,omitempty"`
	// AllowsIncomingConnections Whether or not incoming connections are allowed.
	AllowsIncomingConnections *bool `json:"allowsIncomingConnections,omitempty"`
}

// MacOSGeneralDeviceConfiguration This topic provides descriptions of the declared methods, properties and relationships exposed by the macOSGeneralDeviceConfiguration resource.
type MacOSGeneralDeviceConfiguration struct {
	// DeviceConfiguration is the base model of MacOSGeneralDeviceConfiguration
	DeviceConfiguration
	// CompliantAppsList List of apps in the compliance (either allow list or block list, controlled by CompliantAppListType). This collection can contain a maximum of 10000 elements.
	CompliantAppsList []AppListItem `json:"compliantAppsList,omitempty"`
	// CompliantAppListType List that is in the CompliantAppsList.
	CompliantAppListType *AppListType `json:"compliantAppListType,omitempty"`
	// EmailInDomainSuffixes An email address lacking a suffix that matches any of these strings will be considered out-of-domain.
	EmailInDomainSuffixes []string `json:"emailInDomainSuffixes,omitempty"`
	// PasswordBlockSimple Block simple passwords.
	PasswordBlockSimple *bool `json:"passwordBlockSimple,omitempty"`
	// PasswordExpirationDays Number of days before the password expires.
	PasswordExpirationDays *int `json:"passwordExpirationDays,omitempty"`
	// PasswordMinimumCharacterSetCount Number of character sets a password must contain. Valid values 0 to 4
	PasswordMinimumCharacterSetCount *int `json:"passwordMinimumCharacterSetCount,omitempty"`
	// PasswordMinimumLength Minimum length of passwords.
	PasswordMinimumLength *int `json:"passwordMinimumLength,omitempty"`
	// PasswordMinutesOfInactivityBeforeLock Minutes of inactivity required before a password is required.
	PasswordMinutesOfInactivityBeforeLock *int `json:"passwordMinutesOfInactivityBeforeLock,omitempty"`
	// PasswordMinutesOfInactivityBeforeScreenTimeout Minutes of inactivity required before the screen times out.
	PasswordMinutesOfInactivityBeforeScreenTimeout *int `json:"passwordMinutesOfInactivityBeforeScreenTimeout,omitempty"`
	// PasswordPreviousPasswordBlockCount Number of previous passwords to block.
	PasswordPreviousPasswordBlockCount *int `json:"passwordPreviousPasswordBlockCount,omitempty"`
	// PasswordRequiredType Type of password that is required.
	PasswordRequiredType *RequiredPasswordType `json:"passwordRequiredType,omitempty"`
	// PasswordRequired Whether or not to require a password.
	PasswordRequired *bool `json:"passwordRequired,omitempty"`
	// KeychainBlockCloudSync Indicates whether or not iCloud keychain synchronization is blocked (macOS 10.12 and later).
	KeychainBlockCloudSync *bool `json:"keychainBlockCloudSync,omitempty"`
	// AirPrintBlocked Indicates whether or not AirPrint is blocked (macOS 10.12 and later).
	AirPrintBlocked *bool `json:"airPrintBlocked,omitempty"`
	// AirPrintForceTrustedTLS Indicates if trusted certificates are required for TLS printing communication (macOS 10.13 and later).
	AirPrintForceTrustedTLS *bool `json:"airPrintForceTrustedTLS,omitempty"`
	// AirPrintBlockiBeaconDiscovery Indicates whether or not iBeacon discovery of AirPrint printers is blocked. This prevents spurious AirPrint Bluetooth beacons from phishing for network traffic (macOS 10.3 and later).
	AirPrintBlockiBeaconDiscovery *bool `json:"airPrintBlockiBeaconDiscovery,omitempty"`
	// SafariBlockAutofill Indicates whether or not to block the user from using Auto fill in Safari.
	SafariBlockAutofill *bool `json:"safariBlockAutofill,omitempty"`
	// CameraBlocked Indicates whether or not to block the user from accessing the camera of the device.
	CameraBlocked *bool `json:"cameraBlocked,omitempty"`
	// ITunesBlockMusicService Indicates whether or not to block Music service and revert Music app to classic mode.
	ITunesBlockMusicService *bool `json:"iTunesBlockMusicService,omitempty"`
	// SpotlightBlockInternetResults Indicates whether or not to block Spotlight from returning any results from an Internet search.
	SpotlightBlockInternetResults *bool `json:"spotlightBlockInternetResults,omitempty"`
	// KeyboardBlockDictation Indicates whether or not to block the user from using dictation input.
	KeyboardBlockDictation *bool `json:"keyboardBlockDictation,omitempty"`
	// DefinitionLookupBlocked Indicates whether or not to block definition lookup.
	DefinitionLookupBlocked *bool `json:"definitionLookupBlocked,omitempty"`
	// AppleWatchBlockAutoUnlock Indicates whether or to block users from unlocking their Mac with Apple Watch.
	AppleWatchBlockAutoUnlock *bool `json:"appleWatchBlockAutoUnlock,omitempty"`
	// ITunesBlockFileSharing Indicates whether or not to block files from being transferred using iTunes.
	ITunesBlockFileSharing *bool `json:"iTunesBlockFileSharing,omitempty"`
	// ICloudBlockDocumentSync Indicates whether or not to block iCloud document sync.
	ICloudBlockDocumentSync *bool `json:"iCloudBlockDocumentSync,omitempty"`
	// ICloudBlockMail Indicates whether or not to block iCloud from syncing mail.
	ICloudBlockMail *bool `json:"iCloudBlockMail,omitempty"`
	// ICloudBlockAddressBook Indicates whether or not to block iCloud from syncing contacts.
	ICloudBlockAddressBook *bool `json:"iCloudBlockAddressBook,omitempty"`
	// ICloudBlockCalendar Indicates whether or not to block iCloud from syncing calendars.
	ICloudBlockCalendar *bool `json:"iCloudBlockCalendar,omitempty"`
	// ICloudBlockReminders Indicates whether or not to block iCloud from syncing reminders.
	ICloudBlockReminders *bool `json:"iCloudBlockReminders,omitempty"`
	// ICloudBlockBookmarks Indicates whether or not to block iCloud from syncing bookmarks.
	ICloudBlockBookmarks *bool `json:"iCloudBlockBookmarks,omitempty"`
	// ICloudBlockNotes Indicates whether or not to block iCloud from syncing notes.
	ICloudBlockNotes *bool `json:"iCloudBlockNotes,omitempty"`
	// AirDropBlocked Indicates whether or not to allow AirDrop.
	AirDropBlocked *bool `json:"airDropBlocked,omitempty"`
	// PasswordBlockModification Indicates whether or not to allow passcode modification.
	PasswordBlockModification *bool `json:"passwordBlockModification,omitempty"`
	// PasswordBlockFingerprintUnlock Indicates whether or not to block fingerprint unlock.
	PasswordBlockFingerprintUnlock *bool `json:"passwordBlockFingerprintUnlock,omitempty"`
	// PasswordBlockAutoFill Indicates whether or not to block the AutoFill Passwords feature.
	PasswordBlockAutoFill *bool `json:"passwordBlockAutoFill,omitempty"`
	// PasswordBlockProximityRequests Indicates whether or not to block requesting passwords from nearby devices.
	PasswordBlockProximityRequests *bool `json:"passwordBlockProximityRequests,omitempty"`
	// PasswordBlockAirDropSharing Indicates whether or not to block sharing passwords with the AirDrop passwords feature.
	PasswordBlockAirDropSharing *bool `json:"passwordBlockAirDropSharing,omitempty"`
	// SoftwareUpdatesEnforcedDelayInDays Sets how many days a software update will be delyed for a supervised device. Valid values 0 to 90
	SoftwareUpdatesEnforcedDelayInDays *int `json:"softwareUpdatesEnforcedDelayInDays,omitempty"`
	// SoftwareUpdatesForceDelayed Indicates whether or not to delay user visibility of software updates when the device is in supervised mode.
	SoftwareUpdatesForceDelayed *bool `json:"softwareUpdatesForceDelayed,omitempty"`
	// ContentCachingBlocked Indicates whether or not to allow content caching.
	ContentCachingBlocked *bool `json:"contentCachingBlocked,omitempty"`
	// ICloudBlockPhotoLibrary Indicates whether or not to block iCloud Photo Library.
	ICloudBlockPhotoLibrary *bool `json:"iCloudBlockPhotoLibrary,omitempty"`
	// ScreenCaptureBlocked Indicates whether or not to block the user from taking Screenshots.
	ScreenCaptureBlocked *bool `json:"screenCaptureBlocked,omitempty"`
	// ClassroomAppBlockRemoteScreenObservation Indicates whether or not to allow remote screen observation by Classroom app. Requires MDM enrollment via Apple School Manager or Apple Business Manager.
	ClassroomAppBlockRemoteScreenObservation *bool `json:"classroomAppBlockRemoteScreenObservation,omitempty"`
	// ClassroomAppForceUnpromptedScreenObservation Indicates whether or not to automatically give permission to the teacher of a managed course on the Classroom app to view a student's screen without prompting. Requires MDM enrollment via Apple School Manager or Apple Business Manager.
	ClassroomAppForceUnpromptedScreenObservation *bool `json:"classroomAppForceUnpromptedScreenObservation,omitempty"`
	// ClassroomForceAutomaticallyJoinClasses Indicates whether or not to automatically give permission to the teacher's requests, without prompting the student. Requires MDM enrollment via Apple School Manager or Apple Business Manager.
	ClassroomForceAutomaticallyJoinClasses *bool `json:"classroomForceAutomaticallyJoinClasses,omitempty"`
	// ClassroomForceRequestPermissionToLeaveClasses Indicates whether a student enrolled in an unmanaged course via Classroom will be required to request permission from the teacher when attempting to leave the course. Requires MDM enrollment via Apple School Manager or Apple Business Manager.
	ClassroomForceRequestPermissionToLeaveClasses *bool `json:"classroomForceRequestPermissionToLeaveClasses,omitempty"`
	// ClassroomForceUnpromptedAppAndDeviceLock Indicates whether or not to allow the teacher to lock apps or the device without prompting the student. Requires MDM enrollment via Apple School Manager or Apple Business Manager.
	ClassroomForceUnpromptedAppAndDeviceLock *bool `json:"classroomForceUnpromptedAppAndDeviceLock,omitempty"`
	// ICloudBlockActivityContinuation Indicates whether or not to block the user from continuing work that they started on a MacOS device on another iOS or MacOS device (MacOS 10.15 or later).
	ICloudBlockActivityContinuation *bool `json:"iCloudBlockActivityContinuation,omitempty"`
}

// MacOSImportedPFXCertificateProfile MacOS PFX Import certificate profile
type MacOSImportedPFXCertificateProfile struct {
	// MacOSCertificateProfileBase is the base model of MacOSImportedPFXCertificateProfile
	MacOSCertificateProfileBase
	// IntendedPurpose Intended Purpose of the Certificate Profile - which could be Unassigned, SmimeEncryption, SmimeSigning etc.
	IntendedPurpose *IntendedPurpose `json:"intendedPurpose,omitempty"`
	// ManagedDeviceCertificateStates undocumented
	ManagedDeviceCertificateStates []ManagedDeviceCertificateState `json:"managedDeviceCertificateStates,omitempty"`
}

// MacOSKerberosSingleSignOnExtension undocumented
type MacOSKerberosSingleSignOnExtension struct {
	// KerberosSingleSignOnExtension is the base model of MacOSKerberosSingleSignOnExtension
	KerberosSingleSignOnExtension
}

// MacOSKernelExtension undocumented
type MacOSKernelExtension struct {
	// Object is the base model of MacOSKernelExtension
	Object
	// TeamIdentifier The team identifier that was used to sign the kernel extension.
	TeamIdentifier *string `json:"teamIdentifier,omitempty"`
	// BundleID Bundle ID of the kernel extension.
	BundleID *string `json:"bundleId,omitempty"`
}

// MacOSLaunchItem undocumented
type MacOSLaunchItem struct {
	// Object is the base model of MacOSLaunchItem
	Object
	// Path Path to the launch item.
	Path *string `json:"path,omitempty"`
	// Hide Whether or not to hide the item from the Users and Groups List.
	Hide *bool `json:"hide,omitempty"`
}

// MacOSLobApp Contains properties and inherited properties for the MacOS LOB App.
type MacOSLobApp struct {
	// MobileLobApp is the base model of MacOSLobApp
	MobileLobApp
	// BundleID The bundle id.
	BundleID *string `json:"bundleId,omitempty"`
	// MinimumSupportedOperatingSystem The value for the minimum applicable operating system.
	MinimumSupportedOperatingSystem *MacOSMinimumOperatingSystem `json:"minimumSupportedOperatingSystem,omitempty"`
	// BuildNumber The build number of MacOS Line of Business (LoB) app.
	BuildNumber *string `json:"buildNumber,omitempty"`
	// VersionNumber The version number of MacOS Line of Business (LoB) app.
	VersionNumber *string `json:"versionNumber,omitempty"`
	// ChildApps The app list in this bundle package
	ChildApps []MacOSLobChildApp `json:"childApps,omitempty"`
	// IdentityVersion The identity version.
	IdentityVersion *string `json:"identityVersion,omitempty"`
	// Md5HashChunkSize The chunk size for MD5 hash
	Md5HashChunkSize *int `json:"md5HashChunkSize,omitempty"`
	// Md5Hash The MD5 hash codes
	Md5Hash []string `json:"md5Hash,omitempty"`
	// IgnoreVersionDetection A boolean to control whether the app's version will be used to detect the app after it is installed on a device. Set this to true for macOS Line of Business (LoB) apps that use a self update feature.
	IgnoreVersionDetection *bool `json:"ignoreVersionDetection,omitempty"`
}

// MacOSLobChildApp undocumented
type MacOSLobChildApp struct {
	// Object is the base model of MacOSLobChildApp
	Object
	// BundleID The Identity Name.
	BundleID *string `json:"bundleId,omitempty"`
	// BuildNumber The build number of MacOS Line of Business (LoB) app.
	BuildNumber *string `json:"buildNumber,omitempty"`
	// VersionNumber The version number of MacOS Line of Business (LoB) app.
	VersionNumber *string `json:"versionNumber,omitempty"`
}

// MacOSMicrosoftEdgeApp Contains properties and inherited properties for the MacOS Microsoft Edge App.
type MacOSMicrosoftEdgeApp struct {
	// MobileApp is the base model of MacOSMicrosoftEdgeApp
	MobileApp
}

// MacOSMinimumOperatingSystem undocumented
type MacOSMinimumOperatingSystem struct {
	// Object is the base model of MacOSMinimumOperatingSystem
	Object
	// V10_7 Mac OS 10.7 or later.
	V10_7 *bool `json:"v10_7,omitempty"`
	// V10_8 Mac OS 10.8 or later.
	V10_8 *bool `json:"v10_8,omitempty"`
	// V10_9 Mac OS 10.9 or later.
	V10_9 *bool `json:"v10_9,omitempty"`
	// V10_10 Mac OS 10.10 or later.
	V10_10 *bool `json:"v10_10,omitempty"`
	// V10_11 Mac OS 10.11 or later.
	V10_11 *bool `json:"v10_11,omitempty"`
	// V10_12 Mac OS 10.12 or later.
	V10_12 *bool `json:"v10_12,omitempty"`
	// V10_13 Mac OS 10.13 or later.
	V10_13 *bool `json:"v10_13,omitempty"`
	// V10_14 Mac OS 10.14 or later.
	V10_14 *bool `json:"v10_14,omitempty"`
	// V10_15 Mac OS 10.15 or later.
	V10_15 *bool `json:"v10_15,omitempty"`
}

// MacOSOfficeSuiteApp Contains properties and inherited properties for the MacOS Office Suite App.
type MacOSOfficeSuiteApp struct {
	// MobileApp is the base model of MacOSOfficeSuiteApp
	MobileApp
}

// MacOSPkcsCertificateProfile MacOS PKCS certificate profile.
type MacOSPkcsCertificateProfile struct {
	// MacOSCertificateProfileBase is the base model of MacOSPkcsCertificateProfile
	MacOSCertificateProfileBase
	// CertificationAuthority PKCS certification authority FQDN.
	CertificationAuthority *string `json:"certificationAuthority,omitempty"`
	// CertificationAuthorityName PKCS certification authority Name.
	CertificationAuthorityName *string `json:"certificationAuthorityName,omitempty"`
	// CertificateTemplateName PKCS certificate template name.
	CertificateTemplateName *string `json:"certificateTemplateName,omitempty"`
	// SubjectAlternativeNameFormatString Format string that defines the subject alternative name.
	SubjectAlternativeNameFormatString *string `json:"subjectAlternativeNameFormatString,omitempty"`
	// SubjectNameFormatString Format string that defines the subject name. Example: CN={{EmailAddress}},E={{EmailAddress}},OU=Enterprise Users,O=Contoso Corporation,L=Redmond,ST=WA,C=US
	SubjectNameFormatString *string `json:"subjectNameFormatString,omitempty"`
	// CertificateStore Target store certificate
	CertificateStore *CertificateStore `json:"certificateStore,omitempty"`
	// CustomSubjectAlternativeNames Custom Subject Alternative Name Settings. This collection can contain a maximum of 500 elements.
	CustomSubjectAlternativeNames []CustomSubjectAlternativeName `json:"customSubjectAlternativeNames,omitempty"`
	// AllowAllAppsAccess AllowAllAppsAccess setting
	AllowAllAppsAccess *bool `json:"allowAllAppsAccess,omitempty"`
	// ManagedDeviceCertificateStates undocumented
	ManagedDeviceCertificateStates []ManagedDeviceCertificateState `json:"managedDeviceCertificateStates,omitempty"`
}

// MacOSScepCertificateProfile Mac OS SCEP certificate profile.
type MacOSScepCertificateProfile struct {
	// MacOSCertificateProfileBase is the base model of MacOSScepCertificateProfile
	MacOSCertificateProfileBase
	// ScepServerUrls SCEP Server Url(s).
	ScepServerUrls []string `json:"scepServerUrls,omitempty"`
	// SubjectNameFormatString Custom format to use with SubjectNameFormat = Custom. Example: CN={{EmailAddress}},E={{EmailAddress}},OU=Enterprise Users,O=Contoso Corporation,L=Redmond,ST=WA,C=US
	SubjectNameFormatString *string `json:"subjectNameFormatString,omitempty"`
	// KeyUsage SCEP Key Usage.
	KeyUsage *KeyUsages `json:"keyUsage,omitempty"`
	// KeySize SCEP Key Size.
	KeySize *KeySize `json:"keySize,omitempty"`
	// HashAlgorithm SCEP Hash Algorithm.
	HashAlgorithm *HashAlgorithms `json:"hashAlgorithm,omitempty"`
	// ExtendedKeyUsages Extended Key Usage (EKU) settings. This collection can contain a maximum of 500 elements.
	ExtendedKeyUsages []ExtendedKeyUsage `json:"extendedKeyUsages,omitempty"`
	// SubjectAlternativeNameFormatString Custom String that defines the AAD Attribute.
	SubjectAlternativeNameFormatString *string `json:"subjectAlternativeNameFormatString,omitempty"`
	// CertificateStore Target store certificate
	CertificateStore *CertificateStore `json:"certificateStore,omitempty"`
	// CustomSubjectAlternativeNames Custom Subject Alternative Name Settings. This collection can contain a maximum of 500 elements.
	CustomSubjectAlternativeNames []CustomSubjectAlternativeName `json:"customSubjectAlternativeNames,omitempty"`
	// RootCertificate undocumented
	RootCertificate *MacOSTrustedRootCertificate `json:"rootCertificate,omitempty"`
	// ManagedDeviceCertificateStates undocumented
	ManagedDeviceCertificateStates []ManagedDeviceCertificateState `json:"managedDeviceCertificateStates,omitempty"`
}

// MacOSTrustedRootCertificate OS X Trusted Root Certificate configuration profile.
type MacOSTrustedRootCertificate struct {
	// DeviceConfiguration is the base model of MacOSTrustedRootCertificate
	DeviceConfiguration
	// TrustedRootCertificate Trusted Root Certificate.
	TrustedRootCertificate *Binary `json:"trustedRootCertificate,omitempty"`
	// CertFileName File name to display in UI.
	CertFileName *string `json:"certFileName,omitempty"`
}

// MacOSVpnConfiguration By providing the configurations in this profile you can instruct the Mac device to connect to desired VPN endpoint. By specifying the authentication method and security types expected by VPN endpoint you can make the VPN connection seamless for end user.
type MacOSVpnConfiguration struct {
	// AppleVPNConfiguration is the base model of MacOSVpnConfiguration
	AppleVPNConfiguration
	// IdentityCertificate undocumented
	IdentityCertificate *MacOSCertificateProfileBase `json:"identityCertificate,omitempty"`
}

// MacOSWiFiConfiguration By providing the configurations in this profile you can instruct the macOS device to connect to desired Wi-Fi endpoint. By specifying the authentication method and security types expected by Wi-Fi endpoint you can make the Wi-Fi connection seamless for end user.
type MacOSWiFiConfiguration struct {
	// DeviceConfiguration is the base model of MacOSWiFiConfiguration
	DeviceConfiguration
	// NetworkName Network Name
	NetworkName *string `json:"networkName,omitempty"`
	// Ssid This is the name of the Wi-Fi network that is broadcast to all devices.
	Ssid *string `json:"ssid,omitempty"`
	// ConnectAutomatically Connect automatically when this network is in range. Setting this to true will skip the user prompt and automatically connect the device to Wi-Fi network.
	ConnectAutomatically *bool `json:"connectAutomatically,omitempty"`
	// ConnectWhenNetworkNameIsHidden Connect when the network is not broadcasting its name (SSID). When set to true, this profile forces the device to connect to a network that doesn't broadcast its SSID to all devices.
	ConnectWhenNetworkNameIsHidden *bool `json:"connectWhenNetworkNameIsHidden,omitempty"`
	// WiFiSecurityType Indicates whether Wi-Fi endpoint uses an EAP based security type.
	WiFiSecurityType *WiFiSecurityType `json:"wiFiSecurityType,omitempty"`
	// ProxySettings Proxy Type for this Wi-Fi connection
	ProxySettings *WiFiProxySetting `json:"proxySettings,omitempty"`
	// ProxyManualAddress IP Address or DNS hostname of the proxy server when manual configuration is selected.
	ProxyManualAddress *string `json:"proxyManualAddress,omitempty"`
	// ProxyManualPort Port of the proxy server when manual configuration is selected.
	ProxyManualPort *int `json:"proxyManualPort,omitempty"`
	// ProxyAutomaticConfigurationURL URL of the proxy server automatic configuration script when automatic configuration is selected. This URL is typically the location of PAC (Proxy Auto Configuration) file.
	ProxyAutomaticConfigurationURL *string `json:"proxyAutomaticConfigurationUrl,omitempty"`
	// PreSharedKey This is the pre-shared key for WPA Personal Wi-Fi network.
	PreSharedKey *string `json:"preSharedKey,omitempty"`
}

// MacOSWiredNetworkConfiguration MacOS wired network configuration profile.
type MacOSWiredNetworkConfiguration struct {
	// DeviceConfiguration is the base model of MacOSWiredNetworkConfiguration
	DeviceConfiguration
	// NetworkName Network Name
	NetworkName *string `json:"networkName,omitempty"`
	// NetworkInterface Network interface.
	NetworkInterface *WiredNetworkInterface `json:"networkInterface,omitempty"`
	// EapType Extensible Authentication Protocol (EAP). Indicates the type of EAP protocol set on the wired network.
	EapType *EapType `json:"eapType,omitempty"`
	// EapFastConfiguration EAP-FAST Configuration Option when EAP-FAST is the selected EAP Type.
	EapFastConfiguration *EapFastConfiguration `json:"eapFastConfiguration,omitempty"`
	// TrustedServerCertificateNames Trusted server certificate names when EAP Type is configured to EAP-TLS/TTLS/FAST or PEAP. This is the common name used in the certificates issued by your trusted certificate authority (CA). If you provide this information, you can bypass the dynamic trust dialog that is displayed on end users devices when they connect to this wired network.
	TrustedServerCertificateNames []string `json:"trustedServerCertificateNames,omitempty"`
	// AuthenticationMethod Authentication Method when EAP Type is configured to PEAP or EAP-TTLS.
	AuthenticationMethod *WiFiAuthenticationMethod `json:"authenticationMethod,omitempty"`
	// NonEapAuthenticationMethodForEapTtls Non-EAP Method for Authentication (Inner Identity) when EAP Type is EAP-TTLS and Authenticationmethod is Username and Password.
	NonEapAuthenticationMethodForEapTtls *NonEapAuthenticationMethodForEapTtlsType `json:"nonEapAuthenticationMethodForEapTtls,omitempty"`
	// EnableOuterIdentityPrivacy Enable identity privacy (Outer Identity) when EAP Type is configured to EAP-TTLS, EAP-FAST or PEAP. This property masks usernames with the text you enter. For example, if you use 'anonymous', each user that authenticates with this wired network using their real username is displayed as 'anonymous'.
	EnableOuterIdentityPrivacy *string `json:"enableOuterIdentityPrivacy,omitempty"`
	// RootCertificateForServerValidation undocumented
	RootCertificateForServerValidation *MacOSTrustedRootCertificate `json:"rootCertificateForServerValidation,omitempty"`
	// IdentityCertificateForClientAuthentication undocumented
	IdentityCertificateForClientAuthentication *MacOSCertificateProfileBase `json:"identityCertificateForClientAuthentication,omitempty"`
}

// MacOsVPPApp Contains properties and inherited properties for MacOS Volume-Purchased Program (VPP) Apps.
type MacOsVPPApp struct {
	// MobileApp is the base model of MacOsVPPApp
	MobileApp
	// UsedLicenseCount The number of VPP licenses in use.
	UsedLicenseCount *int `json:"usedLicenseCount,omitempty"`
	// TotalLicenseCount The total number of VPP licenses.
	TotalLicenseCount *int `json:"totalLicenseCount,omitempty"`
	// ReleaseDateTime The VPP application release date and time.
	ReleaseDateTime *time.Time `json:"releaseDateTime,omitempty"`
	// AppStoreURL The store URL.
	AppStoreURL *string `json:"appStoreUrl,omitempty"`
	// LicensingType The supported License Type.
	LicensingType *VPPLicensingType `json:"licensingType,omitempty"`
	// VPPTokenOrganizationName The organization associated with the Apple Volume Purchase Program Token
	VPPTokenOrganizationName *string `json:"vppTokenOrganizationName,omitempty"`
	// VPPTokenAccountType The type of volume purchase program which the given Apple Volume Purchase Program Token is associated with. Possible values are: `business`, `education`.
	VPPTokenAccountType *VPPTokenAccountType `json:"vppTokenAccountType,omitempty"`
	// VPPTokenAppleID The Apple Id associated with the given Apple Volume Purchase Program Token.
	VPPTokenAppleID *string `json:"vppTokenAppleId,omitempty"`
	// BundleID The Identity Name.
	BundleID *string `json:"bundleId,omitempty"`
	// VPPTokenID Identifier of the VPP token associated with this app.
	VPPTokenID *string `json:"vppTokenId,omitempty"`
	// RevokeLicenseActionResults Results of revoke license actions on this app.
	RevokeLicenseActionResults []MacOsVPPAppRevokeLicensesActionResult `json:"revokeLicenseActionResults,omitempty"`
	// AssignedLicenses undocumented
	AssignedLicenses []MacOsVPPAppAssignedLicense `json:"assignedLicenses,omitempty"`
}

// MacOsVPPAppAssignedLicense MacOS Volume Purchase Program license assignment. This class does not support Create, Delete, or Update.
type MacOsVPPAppAssignedLicense struct {
	// Entity is the base model of MacOsVPPAppAssignedLicense
	Entity
	// UserEmailAddress The user email address.
	UserEmailAddress *string `json:"userEmailAddress,omitempty"`
	// UserID The user ID.
	UserID *string `json:"userId,omitempty"`
	// UserName The user name.
	UserName *string `json:"userName,omitempty"`
	// UserPrincipalName The user principal name.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
}

// MacOsVPPAppAssignmentSettings undocumented
type MacOsVPPAppAssignmentSettings struct {
	// MobileAppAssignmentSettings is the base model of MacOsVPPAppAssignmentSettings
	MobileAppAssignmentSettings
	// UseDeviceLicensing Whether or not to use device licensing.
	UseDeviceLicensing *bool `json:"useDeviceLicensing,omitempty"`
}

// MacOsVPPAppRevokeLicensesActionResult undocumented
type MacOsVPPAppRevokeLicensesActionResult struct {
	// Object is the base model of MacOsVPPAppRevokeLicensesActionResult
	Object
	// UserID UserId associated with the action.
	UserID *string `json:"userId,omitempty"`
	// ManagedDeviceID DeviceId associated with the action.
	ManagedDeviceID *string `json:"managedDeviceId,omitempty"`
	// TotalLicensesCount A count of the number of licenses for which revoke was attempted.
	TotalLicensesCount *int `json:"totalLicensesCount,omitempty"`
	// FailedLicensesCount A count of the number of licenses for which revoke failed.
	FailedLicensesCount *int `json:"failedLicensesCount,omitempty"`
	// ActionFailureReason The reason for the revoke licenses action failure.
	ActionFailureReason *VPPTokenActionFailureReason `json:"actionFailureReason,omitempty"`
	// ActionName Action name
	ActionName *string `json:"actionName,omitempty"`
	// ActionState State of the action
	ActionState *ActionState `json:"actionState,omitempty"`
	// StartDateTime Time the action was initiated
	StartDateTime *time.Time `json:"startDateTime,omitempty"`
	// LastUpdatedDateTime Time the action state was last updated
	LastUpdatedDateTime *time.Time `json:"lastUpdatedDateTime,omitempty"`
}
