// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import "time"

// Windows10AppsForceUpdateSchedule undocumented
type Windows10AppsForceUpdateSchedule struct {
	// Object is the base model of Windows10AppsForceUpdateSchedule
	Object
	// StartDateTime The start time for the force restart.
	StartDateTime *time.Time `json:"startDateTime,omitempty"`
	// Recurrence Recurrence schedule.
	Recurrence *Windows10AppsUpdateRecurrence `json:"recurrence,omitempty"`
	// RunImmediatelyIfAfterStartDateTime If true, runs the task immediately if StartDateTime is in the past, else, runs at the next recurrence.
	RunImmediatelyIfAfterStartDateTime *bool `json:"runImmediatelyIfAfterStartDateTime,omitempty"`
}

// Windows10AssociatedApps undocumented
type Windows10AssociatedApps struct {
	// Object is the base model of Windows10AssociatedApps
	Object
	// AppType Application type.
	AppType *Windows10AppType `json:"appType,omitempty"`
	// Identifier Identifier.
	Identifier *string `json:"identifier,omitempty"`
}

// Windows10CertificateProfileBase Base class for Windows 10 certificate profile.
type Windows10CertificateProfileBase struct {
	// WindowsCertificateProfileBase is the base model of Windows10CertificateProfileBase
	WindowsCertificateProfileBase
}

// Windows10CompliancePolicy This class contains compliance settings for Windows 10.
type Windows10CompliancePolicy struct {
	// DeviceCompliancePolicy is the base model of Windows10CompliancePolicy
	DeviceCompliancePolicy
	// PasswordRequired Require a password to unlock Windows device.
	PasswordRequired *bool `json:"passwordRequired,omitempty"`
	// PasswordBlockSimple Indicates whether or not to block simple password.
	PasswordBlockSimple *bool `json:"passwordBlockSimple,omitempty"`
	// PasswordRequiredToUnlockFromIdle Require a password to unlock an idle device.
	PasswordRequiredToUnlockFromIdle *bool `json:"passwordRequiredToUnlockFromIdle,omitempty"`
	// PasswordMinutesOfInactivityBeforeLock Minutes of inactivity before a password is required.
	PasswordMinutesOfInactivityBeforeLock *int `json:"passwordMinutesOfInactivityBeforeLock,omitempty"`
	// PasswordExpirationDays The password expiration in days.
	PasswordExpirationDays *int `json:"passwordExpirationDays,omitempty"`
	// PasswordMinimumLength The minimum password length.
	PasswordMinimumLength *int `json:"passwordMinimumLength,omitempty"`
	// PasswordMinimumCharacterSetCount The number of character sets required in the password.
	PasswordMinimumCharacterSetCount *int `json:"passwordMinimumCharacterSetCount,omitempty"`
	// PasswordRequiredType The required password type.
	PasswordRequiredType *RequiredPasswordType `json:"passwordRequiredType,omitempty"`
	// PasswordPreviousPasswordBlockCount The number of previous passwords to prevent re-use of.
	PasswordPreviousPasswordBlockCount *int `json:"passwordPreviousPasswordBlockCount,omitempty"`
	// RequireHealthyDeviceReport Require devices to be reported as healthy by Windows Device Health Attestation.
	RequireHealthyDeviceReport *bool `json:"requireHealthyDeviceReport,omitempty"`
	// OsMinimumVersion Minimum Windows 10 version.
	OsMinimumVersion *string `json:"osMinimumVersion,omitempty"`
	// OsMaximumVersion Maximum Windows 10 version.
	OsMaximumVersion *string `json:"osMaximumVersion,omitempty"`
	// MobileOsMinimumVersion Minimum Windows Phone version.
	MobileOsMinimumVersion *string `json:"mobileOsMinimumVersion,omitempty"`
	// MobileOsMaximumVersion Maximum Windows Phone version.
	MobileOsMaximumVersion *string `json:"mobileOsMaximumVersion,omitempty"`
	// EarlyLaunchAntiMalwareDriverEnabled Require devices to be reported as healthy by Windows Device Health Attestation - early launch antimalware driver is enabled.
	EarlyLaunchAntiMalwareDriverEnabled *bool `json:"earlyLaunchAntiMalwareDriverEnabled,omitempty"`
	// BitLockerEnabled Require devices to be reported healthy by Windows Device Health Attestation - bit locker is enabled
	BitLockerEnabled *bool `json:"bitLockerEnabled,omitempty"`
	// SecureBootEnabled Require devices to be reported as healthy by Windows Device Health Attestation - secure boot is enabled.
	SecureBootEnabled *bool `json:"secureBootEnabled,omitempty"`
	// CodeIntegrityEnabled Require devices to be reported as healthy by Windows Device Health Attestation.
	CodeIntegrityEnabled *bool `json:"codeIntegrityEnabled,omitempty"`
	// StorageRequireEncryption Require encryption on windows devices.
	StorageRequireEncryption *bool `json:"storageRequireEncryption,omitempty"`
	// ActiveFirewallRequired Require active firewall on Windows devices.
	ActiveFirewallRequired *bool `json:"activeFirewallRequired,omitempty"`
	// DefenderEnabled Require Windows Defender Antimalware on Windows devices.
	DefenderEnabled *bool `json:"defenderEnabled,omitempty"`
	// DefenderVersion Require Windows Defender Antimalware minimum version on Windows devices.
	DefenderVersion *string `json:"defenderVersion,omitempty"`
	// SignatureOutOfDate Require Windows Defender Antimalware Signature to be up to date on Windows devices.
	SignatureOutOfDate *bool `json:"signatureOutOfDate,omitempty"`
	// RtpEnabled Require Windows Defender Antimalware Real-Time Protection on Windows devices.
	RtpEnabled *bool `json:"rtpEnabled,omitempty"`
	// AntivirusRequired Require any Antivirus solution registered with Windows Decurity Center to be on and monitoring (e.g. Symantec, Windows Defender).
	AntivirusRequired *bool `json:"antivirusRequired,omitempty"`
	// AntiSpywareRequired Require any AntiSpyware solution registered with Windows Decurity Center to be on and monitoring (e.g. Symantec, Windows Defender).
	AntiSpywareRequired *bool `json:"antiSpywareRequired,omitempty"`
	// ValidOperatingSystemBuildRanges The valid operating system build ranges on Windows devices. This collection can contain a maximum of 10000 elements.
	ValidOperatingSystemBuildRanges []OperatingSystemVersionRange `json:"validOperatingSystemBuildRanges,omitempty"`
	// DeviceThreatProtectionEnabled Require that devices have enabled device threat protection.
	DeviceThreatProtectionEnabled *bool `json:"deviceThreatProtectionEnabled,omitempty"`
	// DeviceThreatProtectionRequiredSecurityLevel Require Device Threat Protection minimum risk level to report noncompliance.
	DeviceThreatProtectionRequiredSecurityLevel *DeviceThreatProtectionLevel `json:"deviceThreatProtectionRequiredSecurityLevel,omitempty"`
	// ConfigurationManagerComplianceRequired Require to consider SCCM Compliance state into consideration for Intune Compliance State.
	ConfigurationManagerComplianceRequired *bool `json:"configurationManagerComplianceRequired,omitempty"`
	// TpmRequired Require Trusted Platform Module(TPM) to be present.
	TpmRequired *bool `json:"tpmRequired,omitempty"`
}

// Windows10CustomConfiguration This topic provides descriptions of the declared methods, properties and relationships exposed by the windows10CustomConfiguration resource.
type Windows10CustomConfiguration struct {
	// DeviceConfiguration is the base model of Windows10CustomConfiguration
	DeviceConfiguration
	// OMASettings OMA settings. This collection can contain a maximum of 1000 elements.
	OMASettings []OMASetting `json:"omaSettings,omitempty"`
}

// Windows10DeviceFirmwareConfigurationInterface Graph properties for Device Firmware Configuration Interface
type Windows10DeviceFirmwareConfigurationInterface struct {
	// DeviceConfiguration is the base model of Windows10DeviceFirmwareConfigurationInterface
	DeviceConfiguration
	// ChangeUefiSettingsPermission Defines the permission level granted to users to change UEFI settings.
	ChangeUefiSettingsPermission *ChangeUefiSettingsPermission `json:"changeUefiSettingsPermission,omitempty"`
	// VirtualizationOfCPUAndIO Defines whether CPU and IO virtualization is enabled.
	VirtualizationOfCPUAndIO *Enablement `json:"virtualizationOfCpuAndIO,omitempty"`
	// Cameras Defines whether built-in cameras are enabled.
	Cameras *Enablement `json:"cameras,omitempty"`
	// MicrophonesAndSpeakers Defines whether built-in microphones or speakers are enabled.
	MicrophonesAndSpeakers *Enablement `json:"microphonesAndSpeakers,omitempty"`
	// Radios Defines whether built-in radios e.g. WIFI, NFC, Bluetooth, are enabled.
	Radios *Enablement `json:"radios,omitempty"`
	// BootFromExternalMedia Defines whether a user is allowed to boot from external media.
	BootFromExternalMedia *Enablement `json:"bootFromExternalMedia,omitempty"`
	// BootFromBuiltInNetworkAdapters Defines whether a user is allowed to boot from built-in network adapters.
	BootFromBuiltInNetworkAdapters *Enablement `json:"bootFromBuiltInNetworkAdapters,omitempty"`
}

// Windows10EasEmailProfileConfiguration By providing configurations in this profile you can instruct the native email client (Outlook) on Windows 10 devices to communicate with an Exchange server and get email, contacts, calendar, and tasks. Furthermore, you can also specify how much email to sync and how often the device should sync.
type Windows10EasEmailProfileConfiguration struct {
	// EasEmailProfileConfigurationBase is the base model of Windows10EasEmailProfileConfiguration
	EasEmailProfileConfigurationBase
	// AccountName Account name.
	AccountName *string `json:"accountName,omitempty"`
	// SyncCalendar Whether or not to sync the calendar.
	SyncCalendar *bool `json:"syncCalendar,omitempty"`
	// SyncContacts Whether or not to sync contacts.
	SyncContacts *bool `json:"syncContacts,omitempty"`
	// SyncTasks Whether or not to sync tasks.
	SyncTasks *bool `json:"syncTasks,omitempty"`
	// DurationOfEmailToSync Duration of email to sync.
	DurationOfEmailToSync *EmailSyncDuration `json:"durationOfEmailToSync,omitempty"`
	// EmailAddressSource Email attribute that is picked from AAD and injected into this profile before installing on the device.
	EmailAddressSource *UserEmailSource `json:"emailAddressSource,omitempty"`
	// EmailSyncSchedule Email sync schedule.
	EmailSyncSchedule *EmailSyncSchedule `json:"emailSyncSchedule,omitempty"`
	// HostName Exchange location that (URL) that the native mail app connects to.
	HostName *string `json:"hostName,omitempty"`
	// RequireSsl Indicates whether or not to use SSL.
	RequireSsl *bool `json:"requireSsl,omitempty"`
}

// Windows10EndpointProtectionConfiguration This topic provides descriptions of the declared methods, properties and relationships exposed by the Windows10EndpointProtectionConfiguration resource.
type Windows10EndpointProtectionConfiguration struct {
	// DeviceConfiguration is the base model of Windows10EndpointProtectionConfiguration
	DeviceConfiguration
	// DMAGuardDeviceEnumerationPolicy undocumented
	DMAGuardDeviceEnumerationPolicy *DMAGuardDeviceEnumerationPolicyType `json:"dmaGuardDeviceEnumerationPolicy,omitempty"`
	// FirewallRules Configures the firewall rule settings. This collection can contain a maximum of 150 elements.
	FirewallRules []WindowsFirewallRule `json:"firewallRules,omitempty"`
	// UserRightsAccessCredentialManagerAsTrustedCaller This user right is used by Credential Manager during Backup/Restore. Users' saved credentials might be compromised if this privilege is given to other entities. Only states NotConfigured and Allowed are supported
	UserRightsAccessCredentialManagerAsTrustedCaller *DeviceManagementUserRightsSetting `json:"userRightsAccessCredentialManagerAsTrustedCaller,omitempty"`
	// UserRightsAllowAccessFromNetwork This user right determines which users and groups are allowed to connect to the computer over the network. State Allowed is supported.
	UserRightsAllowAccessFromNetwork *DeviceManagementUserRightsSetting `json:"userRightsAllowAccessFromNetwork,omitempty"`
	// UserRightsBlockAccessFromNetwork This user right determines which users and groups are block from connecting to the computer over the network. State Block is supported.
	UserRightsBlockAccessFromNetwork *DeviceManagementUserRightsSetting `json:"userRightsBlockAccessFromNetwork,omitempty"`
	// UserRightsActAsPartOfTheOperatingSystem This user right allows a process to impersonate any user without authentication. The process can therefore gain access to the same local resources as that user. Only states NotConfigured and Allowed are supported
	UserRightsActAsPartOfTheOperatingSystem *DeviceManagementUserRightsSetting `json:"userRightsActAsPartOfTheOperatingSystem,omitempty"`
	// UserRightsLocalLogOn This user right determines which users can log on to the computer. States NotConfigured, Allowed are supported
	UserRightsLocalLogOn *DeviceManagementUserRightsSetting `json:"userRightsLocalLogOn,omitempty"`
	// UserRightsDenyLocalLogOn This user right determines which users cannot log on to the computer. States NotConfigured, Blocked are supported
	UserRightsDenyLocalLogOn *DeviceManagementUserRightsSetting `json:"userRightsDenyLocalLogOn,omitempty"`
	// UserRightsBackupData This user right determines which users can bypass file, directory, registry, and other persistent objects permissions when backing up files and directories. Only states NotConfigured and Allowed are supported
	UserRightsBackupData *DeviceManagementUserRightsSetting `json:"userRightsBackupData,omitempty"`
	// UserRightsChangeSystemTime This user right determines which users and groups can change the time and date on the internal clock of the computer. Only states NotConfigured and Allowed are supported
	UserRightsChangeSystemTime *DeviceManagementUserRightsSetting `json:"userRightsChangeSystemTime,omitempty"`
	// UserRightsCreateGlobalObjects This security setting determines whether users can create global objects that are available to all sessions. Users who can create global objects could affect processes that run under other users' sessions, which could lead to application failure or data corruption. Only states NotConfigured and Allowed are supported
	UserRightsCreateGlobalObjects *DeviceManagementUserRightsSetting `json:"userRightsCreateGlobalObjects,omitempty"`
	// UserRightsCreatePageFile This user right determines which users and groups can call an internal API to create and change the size of a page file. Only states NotConfigured and Allowed are supported
	UserRightsCreatePageFile *DeviceManagementUserRightsSetting `json:"userRightsCreatePageFile,omitempty"`
	// UserRightsCreatePermanentSharedObjects This user right determines which accounts can be used by processes to create a directory object using the object manager. Only states NotConfigured and Allowed are supported
	UserRightsCreatePermanentSharedObjects *DeviceManagementUserRightsSetting `json:"userRightsCreatePermanentSharedObjects,omitempty"`
	// UserRightsCreateSymbolicLinks This user right determines if the user can create a symbolic link from the computer to which they are logged on. Only states NotConfigured and Allowed are supported
	UserRightsCreateSymbolicLinks *DeviceManagementUserRightsSetting `json:"userRightsCreateSymbolicLinks,omitempty"`
	// UserRightsCreateToken This user right determines which users/groups can be used by processes to create a token that can then be used to get access to any local resources when the process uses an internal API to create an access token. Only states NotConfigured and Allowed are supported
	UserRightsCreateToken *DeviceManagementUserRightsSetting `json:"userRightsCreateToken,omitempty"`
	// UserRightsDebugPrograms This user right determines which users can attach a debugger to any process or to the kernel. Only states NotConfigured and Allowed are supported
	UserRightsDebugPrograms *DeviceManagementUserRightsSetting `json:"userRightsDebugPrograms,omitempty"`
	// UserRightsRemoteDesktopServicesLogOn This user right determines which users and groups are prohibited from logging on as a Remote Desktop Services client. Only states NotConfigured and Blocked are supported
	UserRightsRemoteDesktopServicesLogOn *DeviceManagementUserRightsSetting `json:"userRightsRemoteDesktopServicesLogOn,omitempty"`
	// UserRightsDelegation This user right determines which users can set the Trusted for Delegation setting on a user or computer object. Only states NotConfigured and Allowed are supported.
	UserRightsDelegation *DeviceManagementUserRightsSetting `json:"userRightsDelegation,omitempty"`
	// UserRightsGenerateSecurityAudits This user right determines which accounts can be used by a process to add entries to the security log. The security log is used to trace unauthorized system access.  Only states NotConfigured and Allowed are supported.
	UserRightsGenerateSecurityAudits *DeviceManagementUserRightsSetting `json:"userRightsGenerateSecurityAudits,omitempty"`
	// UserRightsImpersonateClient Assigning this user right to a user allows programs running on behalf of that user to impersonate a client. Requiring this user right for this kind of impersonation prevents an unauthorized user from convincing a client to connect to a service that they have created and then impersonating that client, which can elevate the unauthorized user's permissions to administrative or system levels. Only states NotConfigured and Allowed are supported.
	UserRightsImpersonateClient *DeviceManagementUserRightsSetting `json:"userRightsImpersonateClient,omitempty"`
	// UserRightsIncreaseSchedulingPriority This user right determines which accounts can use a process with Write Property access to another process to increase the execution priority assigned to the other process. Only states NotConfigured and Allowed are supported.
	UserRightsIncreaseSchedulingPriority *DeviceManagementUserRightsSetting `json:"userRightsIncreaseSchedulingPriority,omitempty"`
	// UserRightsLoadUnloadDrivers This user right determines which users can dynamically load and unload device drivers or other code in to kernel mode. Only states NotConfigured and Allowed are supported.
	UserRightsLoadUnloadDrivers *DeviceManagementUserRightsSetting `json:"userRightsLoadUnloadDrivers,omitempty"`
	// UserRightsLockMemory This user right determines which accounts can use a process to keep data in physical memory, which prevents the system from paging the data to virtual memory on disk. Only states NotConfigured and Allowed are supported.
	UserRightsLockMemory *DeviceManagementUserRightsSetting `json:"userRightsLockMemory,omitempty"`
	// UserRightsManageAuditingAndSecurityLogs This user right determines which users can specify object access auditing options for individual resources, such as files, Active Directory objects, and registry keys. Only states NotConfigured and Allowed are supported.
	UserRightsManageAuditingAndSecurityLogs *DeviceManagementUserRightsSetting `json:"userRightsManageAuditingAndSecurityLogs,omitempty"`
	// UserRightsManageVolumes This user right determines which users and groups can run maintenance tasks on a volume, such as remote defragmentation. Only states NotConfigured and Allowed are supported.
	UserRightsManageVolumes *DeviceManagementUserRightsSetting `json:"userRightsManageVolumes,omitempty"`
	// UserRightsModifyFirmwareEnvironment This user right determines who can modify firmware environment values. Only states NotConfigured and Allowed are supported.
	UserRightsModifyFirmwareEnvironment *DeviceManagementUserRightsSetting `json:"userRightsModifyFirmwareEnvironment,omitempty"`
	// UserRightsModifyObjectLabels This user right determines which user accounts can modify the integrity label of objects, such as files, registry keys, or processes owned by other users. Only states NotConfigured and Allowed are supported.
	UserRightsModifyObjectLabels *DeviceManagementUserRightsSetting `json:"userRightsModifyObjectLabels,omitempty"`
	// UserRightsProfileSingleProcess This user right determines which users can use performance monitoring tools to monitor the performance of system processes. Only states NotConfigured and Allowed are supported.
	UserRightsProfileSingleProcess *DeviceManagementUserRightsSetting `json:"userRightsProfileSingleProcess,omitempty"`
	// UserRightsRemoteShutdown This user right determines which users are allowed to shut down a computer from a remote location on the network. Misuse of this user right can result in a denial of service. Only states NotConfigured and Allowed are supported.
	UserRightsRemoteShutdown *DeviceManagementUserRightsSetting `json:"userRightsRemoteShutdown,omitempty"`
	// UserRightsRestoreData This user right determines which users can bypass file, directory, registry, and other persistent objects permissions when restoring backed up files and directories, and determines which users can set any valid security principal as the owner of an object. Only states NotConfigured and Allowed are supported.
	UserRightsRestoreData *DeviceManagementUserRightsSetting `json:"userRightsRestoreData,omitempty"`
	// UserRightsTakeOwnership This user right determines which users can take ownership of any securable object in the system, including Active Directory objects, files and folders, printers, registry keys, processes, and threads. Only states NotConfigured and Allowed are supported.
	UserRightsTakeOwnership *DeviceManagementUserRightsSetting `json:"userRightsTakeOwnership,omitempty"`
	// XboxServicesEnableXboxGameSaveTask This setting determines whether xbox game save is enabled (1) or disabled (0).
	XboxServicesEnableXboxGameSaveTask *bool `json:"xboxServicesEnableXboxGameSaveTask,omitempty"`
	// XboxServicesAccessoryManagementServiceStartupMode This setting determines whether the Accessory management service's start type is Automatic(2), Manual(3), Disabled(4). Default: Manual.
	XboxServicesAccessoryManagementServiceStartupMode *ServiceStartType `json:"xboxServicesAccessoryManagementServiceStartupMode,omitempty"`
	// XboxServicesLiveAuthManagerServiceStartupMode This setting determines whether Live Auth Manager service's start type is Automatic(2), Manual(3), Disabled(4). Default: Manual.
	XboxServicesLiveAuthManagerServiceStartupMode *ServiceStartType `json:"xboxServicesLiveAuthManagerServiceStartupMode,omitempty"`
	// XboxServicesLiveGameSaveServiceStartupMode This setting determines whether Live Game save service's start type is Automatic(2), Manual(3), Disabled(4). Default: Manual.
	XboxServicesLiveGameSaveServiceStartupMode *ServiceStartType `json:"xboxServicesLiveGameSaveServiceStartupMode,omitempty"`
	// XboxServicesLiveNetworkingServiceStartupMode This setting determines whether Networking service's start type is Automatic(2), Manual(3), Disabled(4). Default: Manual.
	XboxServicesLiveNetworkingServiceStartupMode *ServiceStartType `json:"xboxServicesLiveNetworkingServiceStartupMode,omitempty"`
	// LocalSecurityOptionsBlockMicrosoftAccounts Prevent users from adding new Microsoft accounts to this computer.
	LocalSecurityOptionsBlockMicrosoftAccounts *bool `json:"localSecurityOptionsBlockMicrosoftAccounts,omitempty"`
	// LocalSecurityOptionsBlockRemoteLogonWithBlankPassword Enable Local accounts that are not password protected to log on from locations other than the physical device.Default is enabled
	LocalSecurityOptionsBlockRemoteLogonWithBlankPassword *bool `json:"localSecurityOptionsBlockRemoteLogonWithBlankPassword,omitempty"`
	// LocalSecurityOptionsDisableAdministratorAccount Determines whether the Local Administrator account is enabled or disabled.
	LocalSecurityOptionsDisableAdministratorAccount *bool `json:"localSecurityOptionsDisableAdministratorAccount,omitempty"`
	// LocalSecurityOptionsAdministratorAccountName Define a different account name to be associated with the security identifier (SID) for the account “Administrator”.
	LocalSecurityOptionsAdministratorAccountName *string `json:"localSecurityOptionsAdministratorAccountName,omitempty"`
	// LocalSecurityOptionsDisableGuestAccount Determines if the Guest account is enabled or disabled.
	LocalSecurityOptionsDisableGuestAccount *bool `json:"localSecurityOptionsDisableGuestAccount,omitempty"`
	// LocalSecurityOptionsGuestAccountName Define a different account name to be associated with the security identifier (SID) for the account “Guest”.
	LocalSecurityOptionsGuestAccountName *string `json:"localSecurityOptionsGuestAccountName,omitempty"`
	// LocalSecurityOptionsAllowUndockWithoutHavingToLogon Prevent a portable computer from being undocked without having to log in.
	LocalSecurityOptionsAllowUndockWithoutHavingToLogon *bool `json:"localSecurityOptionsAllowUndockWithoutHavingToLogon,omitempty"`
	// LocalSecurityOptionsBlockUsersInstallingPrinterDrivers Restrict installing printer drivers as part of connecting to a shared printer to admins only.
	LocalSecurityOptionsBlockUsersInstallingPrinterDrivers *bool `json:"localSecurityOptionsBlockUsersInstallingPrinterDrivers,omitempty"`
	// LocalSecurityOptionsBlockRemoteOpticalDriveAccess Enabling this settings allows only interactively logged on user to access CD-ROM media.
	LocalSecurityOptionsBlockRemoteOpticalDriveAccess *bool `json:"localSecurityOptionsBlockRemoteOpticalDriveAccess,omitempty"`
	// LocalSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser Define who is allowed to format and eject removable NTFS media.
	LocalSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser *LocalSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUserType `json:"localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser,omitempty"`
	// LocalSecurityOptionsMachineInactivityLimit Define maximum minutes of inactivity on the interactive desktop’s login screen until the screen saver runs. Valid values 0 to 9999
	LocalSecurityOptionsMachineInactivityLimit *int `json:"localSecurityOptionsMachineInactivityLimit,omitempty"`
	// LocalSecurityOptionsMachineInactivityLimitInMinutes Define maximum minutes of inactivity on the interactive desktop’s login screen until the screen saver runs. Valid values 0 to 9999
	LocalSecurityOptionsMachineInactivityLimitInMinutes *int `json:"localSecurityOptionsMachineInactivityLimitInMinutes,omitempty"`
	// LocalSecurityOptionsDoNotRequireCtrlAltDel Require CTRL+ALT+DEL to be pressed before a user can log on.
	LocalSecurityOptionsDoNotRequireCtrlAltDel *bool `json:"localSecurityOptionsDoNotRequireCtrlAltDel,omitempty"`
	// LocalSecurityOptionsHideLastSignedInUser Do not display the username of the last person who signed in on this device.
	LocalSecurityOptionsHideLastSignedInUser *bool `json:"localSecurityOptionsHideLastSignedInUser,omitempty"`
	// LocalSecurityOptionsHideUsernameAtSignIn Do not display the username of the person signing in to this device after credentials are entered and before the device’s desktop is shown.
	LocalSecurityOptionsHideUsernameAtSignIn *bool `json:"localSecurityOptionsHideUsernameAtSignIn,omitempty"`
	// LocalSecurityOptionsLogOnMessageTitle Set message title for users attempting to log in.
	LocalSecurityOptionsLogOnMessageTitle *string `json:"localSecurityOptionsLogOnMessageTitle,omitempty"`
	// LocalSecurityOptionsLogOnMessageText Set message text for users attempting to log in.
	LocalSecurityOptionsLogOnMessageText *string `json:"localSecurityOptionsLogOnMessageText,omitempty"`
	// LocalSecurityOptionsAllowPKU2UAuthenticationRequests Block PKU2U authentication requests to this device to use online identities.
	LocalSecurityOptionsAllowPKU2UAuthenticationRequests *bool `json:"localSecurityOptionsAllowPKU2UAuthenticationRequests,omitempty"`
	// LocalSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool UI helper boolean for LocalSecurityOptionsAllowRemoteCallsToSecurityAccountsManager entity
	LocalSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool *bool `json:"localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool,omitempty"`
	// LocalSecurityOptionsAllowRemoteCallsToSecurityAccountsManager Edit the default Security Descriptor Definition Language string to allow or deny users and groups to make remote calls to the SAM.
	LocalSecurityOptionsAllowRemoteCallsToSecurityAccountsManager *string `json:"localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager,omitempty"`
	// LocalSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients This security setting allows a client to require the negotiation of 128-bit encryption and/or NTLMv2 session security.
	LocalSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients *LocalSecurityOptionsMinimumSessionSecurity `json:"localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients,omitempty"`
	// LocalSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers This security setting allows a server to require the negotiation of 128-bit encryption and/or NTLMv2 session security.
	LocalSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers *LocalSecurityOptionsMinimumSessionSecurity `json:"localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers,omitempty"`
	// LanManagerAuthenticationLevel This security setting determines which challenge/response authentication protocol is used for network logons.
	LanManagerAuthenticationLevel *LanManagerAuthenticationLevel `json:"lanManagerAuthenticationLevel,omitempty"`
	// LanManagerWorkstationDisableInsecureGuestLogons If enabled,the SMB client will allow insecure guest logons. If not configured, the SMB client will reject insecure guest logons.
	LanManagerWorkstationDisableInsecureGuestLogons *bool `json:"lanManagerWorkstationDisableInsecureGuestLogons,omitempty"`
	// LocalSecurityOptionsClearVirtualMemoryPageFile This security setting determines whether the virtual memory pagefile is cleared when the system is shut down.
	LocalSecurityOptionsClearVirtualMemoryPageFile *bool `json:"localSecurityOptionsClearVirtualMemoryPageFile,omitempty"`
	// LocalSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn This security setting determines whether a computer can be shut down without having to log on to Windows.
	LocalSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn *bool `json:"localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn,omitempty"`
	// LocalSecurityOptionsAllowUIAccessApplicationElevation Allow UIAccess apps to prompt for elevation without using the secure desktop.
	LocalSecurityOptionsAllowUIAccessApplicationElevation *bool `json:"localSecurityOptionsAllowUIAccessApplicationElevation,omitempty"`
	// LocalSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations Virtualize file and registry write failures to per user locations
	LocalSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations *bool `json:"localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations,omitempty"`
	// LocalSecurityOptionsOnlyElevateSignedExecutables Enforce PKI certification path validation for a given executable file before it is permitted to run.
	LocalSecurityOptionsOnlyElevateSignedExecutables *bool `json:"localSecurityOptionsOnlyElevateSignedExecutables,omitempty"`
	// LocalSecurityOptionsAdministratorElevationPromptBehavior Define the behavior of the elevation prompt for admins in Admin Approval Mode.
	LocalSecurityOptionsAdministratorElevationPromptBehavior *LocalSecurityOptionsAdministratorElevationPromptBehaviorType `json:"localSecurityOptionsAdministratorElevationPromptBehavior,omitempty"`
	// LocalSecurityOptionsStandardUserElevationPromptBehavior Define the behavior of the elevation prompt for standard users.
	LocalSecurityOptionsStandardUserElevationPromptBehavior *LocalSecurityOptionsStandardUserElevationPromptBehaviorType `json:"localSecurityOptionsStandardUserElevationPromptBehavior,omitempty"`
	// LocalSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation Enable all elevation requests to go to the interactive user's desktop rather than the secure desktop. Prompt behavior policy settings for admins and standard users are used.
	LocalSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation *bool `json:"localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation,omitempty"`
	// LocalSecurityOptionsDetectApplicationInstallationsAndPromptForElevation App installations requiring elevated privileges will prompt for admin credentials.Default is enabled
	LocalSecurityOptionsDetectApplicationInstallationsAndPromptForElevation *bool `json:"localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation,omitempty"`
	// LocalSecurityOptionsAllowUIAccessApplicationsForSecureLocations Allow UIAccess apps to prompt for elevation without using the secure desktop.Default is enabled
	LocalSecurityOptionsAllowUIAccessApplicationsForSecureLocations *bool `json:"localSecurityOptionsAllowUIAccessApplicationsForSecureLocations,omitempty"`
	// LocalSecurityOptionsUseAdminApprovalMode Defines whether the built-in admin account uses Admin Approval Mode or runs all apps with full admin privileges.Default is enabled
	LocalSecurityOptionsUseAdminApprovalMode *bool `json:"localSecurityOptionsUseAdminApprovalMode,omitempty"`
	// LocalSecurityOptionsUseAdminApprovalModeForAdministrators Define whether Admin Approval Mode and all UAC policy settings are enabled, default is enabled
	LocalSecurityOptionsUseAdminApprovalModeForAdministrators *bool `json:"localSecurityOptionsUseAdminApprovalModeForAdministrators,omitempty"`
	// LocalSecurityOptionsInformationShownOnLockScreen Configure the user information that is displayed when the session is locked. If not configured, user display name, domain and username are shown
	LocalSecurityOptionsInformationShownOnLockScreen *LocalSecurityOptionsInformationShownOnLockScreenType `json:"localSecurityOptionsInformationShownOnLockScreen,omitempty"`
	// LocalSecurityOptionsInformationDisplayedOnLockScreen Configure the user information that is displayed when the session is locked. If not configured, user display name, domain and username are shown
	LocalSecurityOptionsInformationDisplayedOnLockScreen *LocalSecurityOptionsInformationDisplayedOnLockScreenType `json:"localSecurityOptionsInformationDisplayedOnLockScreen,omitempty"`
	// LocalSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees This security setting determines whether the SMB client attempts to negotiate SMB packet signing.
	LocalSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees *bool `json:"localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees,omitempty"`
	// LocalSecurityOptionsClientDigitallySignCommunicationsAlways This security setting determines whether packet signing is required by the SMB client component.
	LocalSecurityOptionsClientDigitallySignCommunicationsAlways *bool `json:"localSecurityOptionsClientDigitallySignCommunicationsAlways,omitempty"`
	// LocalSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers If this security setting is enabled, the Server Message Block (SMB) redirector is allowed to send plaintext passwords to non-Microsoft SMB servers that do not support password encryption during authentication.
	LocalSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers *bool `json:"localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers,omitempty"`
	// LocalSecurityOptionsDisableServerDigitallySignCommunicationsAlways This security setting determines whether packet signing is required by the SMB server component.
	LocalSecurityOptionsDisableServerDigitallySignCommunicationsAlways *bool `json:"localSecurityOptionsDisableServerDigitallySignCommunicationsAlways,omitempty"`
	// LocalSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees This security setting determines whether the SMB server will negotiate SMB packet signing with clients that request it.
	LocalSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees *bool `json:"localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees,omitempty"`
	// LocalSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares By default, this security setting restricts anonymous access to shares and pipes to the settings for named pipes that can be accessed anonymously and Shares that can be accessed anonymously
	LocalSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares *bool `json:"localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares,omitempty"`
	// LocalSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts This security setting determines what additional permissions will be granted for anonymous connections to the computer.
	LocalSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts *bool `json:"localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts,omitempty"`
	// LocalSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares This security setting determines whether to allows anonymous users to perform certain activities, such as enumerating the names of domain accounts and network shares.
	LocalSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares *bool `json:"localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares,omitempty"`
	// LocalSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange This security setting determines if, at the next password change, the LAN Manager (LM) hash value for the new password is stored. It’s not stored by default.
	LocalSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange *bool `json:"localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange,omitempty"`
	// LocalSecurityOptionsSmartCardRemovalBehavior This security setting determines what happens when the smart card for a logged-on user is removed from the smart card reader.
	LocalSecurityOptionsSmartCardRemovalBehavior *LocalSecurityOptionsSmartCardRemovalBehaviorType `json:"localSecurityOptionsSmartCardRemovalBehavior,omitempty"`
	// DefenderSecurityCenterDisableAppBrowserUI Used to disable the display of the app and browser protection area.
	DefenderSecurityCenterDisableAppBrowserUI *bool `json:"defenderSecurityCenterDisableAppBrowserUI,omitempty"`
	// DefenderSecurityCenterDisableFamilyUI Used to disable the display of the family options area.
	DefenderSecurityCenterDisableFamilyUI *bool `json:"defenderSecurityCenterDisableFamilyUI,omitempty"`
	// DefenderSecurityCenterDisableHealthUI Used to disable the display of the device performance and health area.
	DefenderSecurityCenterDisableHealthUI *bool `json:"defenderSecurityCenterDisableHealthUI,omitempty"`
	// DefenderSecurityCenterDisableNetworkUI Used to disable the display of the firewall and network protection area.
	DefenderSecurityCenterDisableNetworkUI *bool `json:"defenderSecurityCenterDisableNetworkUI,omitempty"`
	// DefenderSecurityCenterDisableVirusUI Used to disable the display of the virus and threat protection area.
	DefenderSecurityCenterDisableVirusUI *bool `json:"defenderSecurityCenterDisableVirusUI,omitempty"`
	// DefenderSecurityCenterDisableAccountUI Used to disable the display of the account protection area.
	DefenderSecurityCenterDisableAccountUI *bool `json:"defenderSecurityCenterDisableAccountUI,omitempty"`
	// DefenderSecurityCenterDisableClearTpmUI Used to disable the display of the Clear TPM button.
	DefenderSecurityCenterDisableClearTpmUI *bool `json:"defenderSecurityCenterDisableClearTpmUI,omitempty"`
	// DefenderSecurityCenterDisableHardwareUI Used to disable the display of the hardware protection area.
	DefenderSecurityCenterDisableHardwareUI *bool `json:"defenderSecurityCenterDisableHardwareUI,omitempty"`
	// DefenderSecurityCenterDisableNotificationAreaUI Used to disable the display of the notification area control. The user needs to either sign out and sign in or reboot the computer for this setting to take effect.
	DefenderSecurityCenterDisableNotificationAreaUI *bool `json:"defenderSecurityCenterDisableNotificationAreaUI,omitempty"`
	// DefenderSecurityCenterDisableRansomwareUI Used to disable the display of the ransomware protection area.
	DefenderSecurityCenterDisableRansomwareUI *bool `json:"defenderSecurityCenterDisableRansomwareUI,omitempty"`
	// DefenderSecurityCenterDisableSecureBootUI Used to disable the display of the secure boot area under Device security.
	DefenderSecurityCenterDisableSecureBootUI *bool `json:"defenderSecurityCenterDisableSecureBootUI,omitempty"`
	// DefenderSecurityCenterDisableTroubleshootingUI Used to disable the display of the security process troubleshooting under Device security.
	DefenderSecurityCenterDisableTroubleshootingUI *bool `json:"defenderSecurityCenterDisableTroubleshootingUI,omitempty"`
	// DefenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI Used to disable the display of update TPM Firmware when a vulnerable firmware is detected.
	DefenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI *bool `json:"defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI,omitempty"`
	// DefenderSecurityCenterOrganizationDisplayName The company name that is displayed to the users.
	DefenderSecurityCenterOrganizationDisplayName *string `json:"defenderSecurityCenterOrganizationDisplayName,omitempty"`
	// DefenderSecurityCenterHelpEmail The email address that is displayed to users.
	DefenderSecurityCenterHelpEmail *string `json:"defenderSecurityCenterHelpEmail,omitempty"`
	// DefenderSecurityCenterHelpPhone The phone number or Skype ID that is displayed to users.
	DefenderSecurityCenterHelpPhone *string `json:"defenderSecurityCenterHelpPhone,omitempty"`
	// DefenderSecurityCenterHelpURL The help portal URL this is displayed to users.
	DefenderSecurityCenterHelpURL *string `json:"defenderSecurityCenterHelpURL,omitempty"`
	// DefenderSecurityCenterNotificationsFromApp Notifications to show from the displayed areas of app
	DefenderSecurityCenterNotificationsFromApp *DefenderSecurityCenterNotificationsFromAppType `json:"defenderSecurityCenterNotificationsFromApp,omitempty"`
	// DefenderSecurityCenterITContactDisplay Configure where to display IT contact information to end users.
	DefenderSecurityCenterITContactDisplay *DefenderSecurityCenterITContactDisplayType `json:"defenderSecurityCenterITContactDisplay,omitempty"`
	// WindowsDefenderTamperProtection Configure windows defender TamperProtection settings
	WindowsDefenderTamperProtection *WindowsDefenderTamperProtectionOptions `json:"windowsDefenderTamperProtection,omitempty"`
	// FirewallBlockStatefulFTP Blocks stateful FTP connections to the device
	FirewallBlockStatefulFTP *bool `json:"firewallBlockStatefulFTP,omitempty"`
	// FirewallIdleTimeoutForSecurityAssociationInSeconds Configures the idle timeout for security associations, in seconds, from 300 to 3600 inclusive. This is the period after which security associations will expire and be deleted. Valid values 300 to 3600
	FirewallIdleTimeoutForSecurityAssociationInSeconds *int `json:"firewallIdleTimeoutForSecurityAssociationInSeconds,omitempty"`
	// FirewallPreSharedKeyEncodingMethod Select the preshared key encoding to be used
	FirewallPreSharedKeyEncodingMethod *FirewallPreSharedKeyEncodingMethodType `json:"firewallPreSharedKeyEncodingMethod,omitempty"`
	// FirewallIPSecExemptionsAllowNeighborDiscovery Configures IPSec exemptions to allow neighbor discovery IPv6 ICMP type-codes
	FirewallIPSecExemptionsAllowNeighborDiscovery *bool `json:"firewallIPSecExemptionsAllowNeighborDiscovery,omitempty"`
	// FirewallIPSecExemptionsAllowICMP Configures IPSec exemptions to allow ICMP
	FirewallIPSecExemptionsAllowICMP *bool `json:"firewallIPSecExemptionsAllowICMP,omitempty"`
	// FirewallIPSecExemptionsAllowRouterDiscovery Configures IPSec exemptions to allow router discovery IPv6 ICMP type-codes
	FirewallIPSecExemptionsAllowRouterDiscovery *bool `json:"firewallIPSecExemptionsAllowRouterDiscovery,omitempty"`
	// FirewallIPSecExemptionsAllowDHCP Configures IPSec exemptions to allow both IPv4 and IPv6 DHCP traffic
	FirewallIPSecExemptionsAllowDHCP *bool `json:"firewallIPSecExemptionsAllowDHCP,omitempty"`
	// FirewallCertificateRevocationListCheckMethod Specify how the certificate revocation list is to be enforced
	FirewallCertificateRevocationListCheckMethod *FirewallCertificateRevocationListCheckMethodType `json:"firewallCertificateRevocationListCheckMethod,omitempty"`
	// FirewallMergeKeyingModuleSettings If an authentication set is not fully supported by a keying module, direct the module to ignore only unsupported authentication suites rather than the entire set
	FirewallMergeKeyingModuleSettings *bool `json:"firewallMergeKeyingModuleSettings,omitempty"`
	// FirewallPacketQueueingMethod Configures how packet queueing should be applied in the tunnel gateway scenario
	FirewallPacketQueueingMethod *FirewallPacketQueueingMethodType `json:"firewallPacketQueueingMethod,omitempty"`
	// FirewallProfileDomain Configures the firewall profile settings for domain networks
	FirewallProfileDomain *WindowsFirewallNetworkProfile `json:"firewallProfileDomain,omitempty"`
	// FirewallProfilePublic Configures the firewall profile settings for public networks
	FirewallProfilePublic *WindowsFirewallNetworkProfile `json:"firewallProfilePublic,omitempty"`
	// FirewallProfilePrivate Configures the firewall profile settings for private networks
	FirewallProfilePrivate *WindowsFirewallNetworkProfile `json:"firewallProfilePrivate,omitempty"`
	// DefenderAdobeReaderLaunchChildProcess Value indicating the behavior of Adobe Reader from creating child processes
	DefenderAdobeReaderLaunchChildProcess *DefenderProtectionType `json:"defenderAdobeReaderLaunchChildProcess,omitempty"`
	// DefenderAttackSurfaceReductionExcludedPaths List of exe files and folders to be excluded from attack surface reduction rules
	DefenderAttackSurfaceReductionExcludedPaths []string `json:"defenderAttackSurfaceReductionExcludedPaths,omitempty"`
	// DefenderOfficeAppsOtherProcessInjectionType Value indicating the behavior of Office applications injecting into other processes
	DefenderOfficeAppsOtherProcessInjectionType *DefenderAttackSurfaceType `json:"defenderOfficeAppsOtherProcessInjectionType,omitempty"`
	// DefenderOfficeAppsOtherProcessInjection Value indicating the behavior of  Office applications injecting into other processes
	DefenderOfficeAppsOtherProcessInjection *DefenderProtectionType `json:"defenderOfficeAppsOtherProcessInjection,omitempty"`
	// DefenderOfficeCommunicationAppsLaunchChildProcess Value indicating the behavior of Office communication applications, including Microsoft Outlook, from creating child processes
	DefenderOfficeCommunicationAppsLaunchChildProcess *DefenderProtectionType `json:"defenderOfficeCommunicationAppsLaunchChildProcess,omitempty"`
	// DefenderOfficeAppsExecutableContentCreationOrLaunchType Value indicating the behavior of Office applications/macros creating or launching executable content
	DefenderOfficeAppsExecutableContentCreationOrLaunchType *DefenderAttackSurfaceType `json:"defenderOfficeAppsExecutableContentCreationOrLaunchType,omitempty"`
	// DefenderOfficeAppsExecutableContentCreationOrLaunch Value indicating the behavior of Office applications/macros creating or launching executable content
	DefenderOfficeAppsExecutableContentCreationOrLaunch *DefenderProtectionType `json:"defenderOfficeAppsExecutableContentCreationOrLaunch,omitempty"`
	// DefenderOfficeAppsLaunchChildProcessType Value indicating the behavior of Office application launching child processes
	DefenderOfficeAppsLaunchChildProcessType *DefenderAttackSurfaceType `json:"defenderOfficeAppsLaunchChildProcessType,omitempty"`
	// DefenderOfficeAppsLaunchChildProcess Value indicating the behavior of Office application launching child processes
	DefenderOfficeAppsLaunchChildProcess *DefenderProtectionType `json:"defenderOfficeAppsLaunchChildProcess,omitempty"`
	// DefenderOfficeMacroCodeAllowWin32ImportsType Value indicating the behavior of Win32 imports from Macro code in Office
	DefenderOfficeMacroCodeAllowWin32ImportsType *DefenderAttackSurfaceType `json:"defenderOfficeMacroCodeAllowWin32ImportsType,omitempty"`
	// DefenderOfficeMacroCodeAllowWin32Imports Value indicating the behavior of Win32 imports from Macro code in Office
	DefenderOfficeMacroCodeAllowWin32Imports *DefenderProtectionType `json:"defenderOfficeMacroCodeAllowWin32Imports,omitempty"`
	// DefenderScriptObfuscatedMacroCodeType Value indicating the behavior of obfuscated js/vbs/ps/macro code
	DefenderScriptObfuscatedMacroCodeType *DefenderAttackSurfaceType `json:"defenderScriptObfuscatedMacroCodeType,omitempty"`
	// DefenderScriptObfuscatedMacroCode Value indicating the behavior of obfuscated js/vbs/ps/macro code
	DefenderScriptObfuscatedMacroCode *DefenderProtectionType `json:"defenderScriptObfuscatedMacroCode,omitempty"`
	// DefenderScriptDownloadedPayloadExecutionType Value indicating the behavior of js/vbs executing payload downloaded from Internet
	DefenderScriptDownloadedPayloadExecutionType *DefenderAttackSurfaceType `json:"defenderScriptDownloadedPayloadExecutionType,omitempty"`
	// DefenderScriptDownloadedPayloadExecution Value indicating the behavior of js/vbs executing payload downloaded from Internet
	DefenderScriptDownloadedPayloadExecution *DefenderProtectionType `json:"defenderScriptDownloadedPayloadExecution,omitempty"`
	// DefenderPreventCredentialStealingType Value indicating if credential stealing from the Windows local security authority subsystem is permitted
	DefenderPreventCredentialStealingType *DefenderProtectionType `json:"defenderPreventCredentialStealingType,omitempty"`
	// DefenderProcessCreationType Value indicating response to process creations originating from PSExec and WMI commands
	DefenderProcessCreationType *DefenderAttackSurfaceType `json:"defenderProcessCreationType,omitempty"`
	// DefenderProcessCreation Value indicating response to process creations originating from PSExec and WMI commands
	DefenderProcessCreation *DefenderProtectionType `json:"defenderProcessCreation,omitempty"`
	// DefenderUntrustedUSBProcessType Value indicating response to untrusted and unsigned processes that run from USB
	DefenderUntrustedUSBProcessType *DefenderAttackSurfaceType `json:"defenderUntrustedUSBProcessType,omitempty"`
	// DefenderUntrustedUSBProcess Value indicating response to untrusted and unsigned processes that run from USB
	DefenderUntrustedUSBProcess *DefenderProtectionType `json:"defenderUntrustedUSBProcess,omitempty"`
	// DefenderUntrustedExecutableType Value indicating response to executables that don't meet a prevalence, age, or trusted list criteria
	DefenderUntrustedExecutableType *DefenderAttackSurfaceType `json:"defenderUntrustedExecutableType,omitempty"`
	// DefenderUntrustedExecutable Value indicating response to executables that don't meet a prevalence, age, or trusted list criteria
	DefenderUntrustedExecutable *DefenderProtectionType `json:"defenderUntrustedExecutable,omitempty"`
	// DefenderEmailContentExecutionType Value indicating if execution of executable content (exe, dll, ps, js, vbs, etc) should be dropped from email (webmail/mail-client)
	DefenderEmailContentExecutionType *DefenderAttackSurfaceType `json:"defenderEmailContentExecutionType,omitempty"`
	// DefenderEmailContentExecution Value indicating if execution of executable content (exe, dll, ps, js, vbs, etc) should be dropped from email (webmail/mail-client)
	DefenderEmailContentExecution *DefenderProtectionType `json:"defenderEmailContentExecution,omitempty"`
	// DefenderAdvancedRansomewareProtectionType Value indicating use of advanced protection against ransomeware
	DefenderAdvancedRansomewareProtectionType *DefenderProtectionType `json:"defenderAdvancedRansomewareProtectionType,omitempty"`
	// DefenderGuardMyFoldersType Value indicating the behavior of protected folders
	DefenderGuardMyFoldersType *FolderProtectionType `json:"defenderGuardMyFoldersType,omitempty"`
	// DefenderGuardedFoldersAllowedAppPaths List of paths to exe that are allowed to access protected folders
	DefenderGuardedFoldersAllowedAppPaths []string `json:"defenderGuardedFoldersAllowedAppPaths,omitempty"`
	// DefenderAdditionalGuardedFolders List of folder paths to be added to the list of protected folders
	DefenderAdditionalGuardedFolders []string `json:"defenderAdditionalGuardedFolders,omitempty"`
	// DefenderNetworkProtectionType Value indicating the behavior of NetworkProtection
	DefenderNetworkProtectionType *DefenderProtectionType `json:"defenderNetworkProtectionType,omitempty"`
	// DefenderExploitProtectionXML Xml content containing information regarding exploit protection details.
	DefenderExploitProtectionXML *Binary `json:"defenderExploitProtectionXml,omitempty"`
	// DefenderExploitProtectionXMLFileName Name of the file from which DefenderExploitProtectionXml was obtained.
	DefenderExploitProtectionXMLFileName *string `json:"defenderExploitProtectionXmlFileName,omitempty"`
	// DefenderSecurityCenterBlockExploitProtectionOverride Indicates whether or not to block user from overriding Exploit Protection settings.
	DefenderSecurityCenterBlockExploitProtectionOverride *bool `json:"defenderSecurityCenterBlockExploitProtectionOverride,omitempty"`
	// AppLockerApplicationControl Enables the Admin to choose what types of app to allow on devices.
	AppLockerApplicationControl *AppLockerApplicationControlType `json:"appLockerApplicationControl,omitempty"`
	// DeviceGuardLocalSystemAuthorityCredentialGuardSettings Turn on Credential Guard when Platform Security Level with Secure Boot and Virtualization Based Security are both enabled.
	DeviceGuardLocalSystemAuthorityCredentialGuardSettings *DeviceGuardLocalSystemAuthorityCredentialGuardType `json:"deviceGuardLocalSystemAuthorityCredentialGuardSettings,omitempty"`
	// DeviceGuardEnableVirtualizationBasedSecurity Turns On Virtualization Based Security(VBS).
	DeviceGuardEnableVirtualizationBasedSecurity *bool `json:"deviceGuardEnableVirtualizationBasedSecurity,omitempty"`
	// DeviceGuardEnableSecureBootWithDMA This property will be deprecated in May 2019 and will be replaced with property DeviceGuardSecureBootWithDMA. Specifies whether Platform Security Level is enabled at next reboot.
	DeviceGuardEnableSecureBootWithDMA *bool `json:"deviceGuardEnableSecureBootWithDMA,omitempty"`
	// DeviceGuardSecureBootWithDMA Specifies whether Platform Security Level is enabled at next reboot.
	DeviceGuardSecureBootWithDMA *SecureBootWithDMAType `json:"deviceGuardSecureBootWithDMA,omitempty"`
	// DeviceGuardLaunchSystemGuard Allows the IT admin to configure the launch of System Guard.
	DeviceGuardLaunchSystemGuard *Enablement `json:"deviceGuardLaunchSystemGuard,omitempty"`
	// SmartScreenEnableInShell Allows IT Admins to configure SmartScreen for Windows.
	SmartScreenEnableInShell *bool `json:"smartScreenEnableInShell,omitempty"`
	// SmartScreenBlockOverrideForFiles Allows IT Admins to control whether users can can ignore SmartScreen warnings and run malicious files.
	SmartScreenBlockOverrideForFiles *bool `json:"smartScreenBlockOverrideForFiles,omitempty"`
	// ApplicationGuardEnabled Enable Windows Defender Application Guard
	ApplicationGuardEnabled *bool `json:"applicationGuardEnabled,omitempty"`
	// ApplicationGuardEnabledOptions Enable Windows Defender Application Guard for newer Windows builds
	ApplicationGuardEnabledOptions *ApplicationGuardEnabledOptions `json:"applicationGuardEnabledOptions,omitempty"`
	// ApplicationGuardBlockFileTransfer Block clipboard to transfer image file, text file or neither of them
	ApplicationGuardBlockFileTransfer *ApplicationGuardBlockFileTransferType `json:"applicationGuardBlockFileTransfer,omitempty"`
	// ApplicationGuardBlockNonEnterpriseContent Block enterprise sites to load non-enterprise content, such as third party plug-ins
	ApplicationGuardBlockNonEnterpriseContent *bool `json:"applicationGuardBlockNonEnterpriseContent,omitempty"`
	// ApplicationGuardAllowPersistence Allow persisting user generated data inside the App Guard Containter (favorites, cookies, web passwords, etc.)
	ApplicationGuardAllowPersistence *bool `json:"applicationGuardAllowPersistence,omitempty"`
	// ApplicationGuardForceAuditing Force auditing will persist Windows logs and events to meet security/compliance criteria (sample events are user login-logoff, use of privilege rights, software installation, system changes, etc.)
	ApplicationGuardForceAuditing *bool `json:"applicationGuardForceAuditing,omitempty"`
	// ApplicationGuardBlockClipboardSharing Block clipboard to share data from Host to Container, or from Container to Host, or both ways, or neither ways.
	ApplicationGuardBlockClipboardSharing *ApplicationGuardBlockClipboardSharingType `json:"applicationGuardBlockClipboardSharing,omitempty"`
	// ApplicationGuardAllowPrintToPDF Allow printing to PDF from Container
	ApplicationGuardAllowPrintToPDF *bool `json:"applicationGuardAllowPrintToPDF,omitempty"`
	// ApplicationGuardAllowPrintToXPS Allow printing to XPS from Container
	ApplicationGuardAllowPrintToXPS *bool `json:"applicationGuardAllowPrintToXPS,omitempty"`
	// ApplicationGuardAllowPrintToLocalPrinters Allow printing to Local Printers from Container
	ApplicationGuardAllowPrintToLocalPrinters *bool `json:"applicationGuardAllowPrintToLocalPrinters,omitempty"`
	// ApplicationGuardAllowPrintToNetworkPrinters Allow printing to Network Printers from Container
	ApplicationGuardAllowPrintToNetworkPrinters *bool `json:"applicationGuardAllowPrintToNetworkPrinters,omitempty"`
	// ApplicationGuardAllowVirtualGPU Allow application guard to use virtual GPU
	ApplicationGuardAllowVirtualGPU *bool `json:"applicationGuardAllowVirtualGPU,omitempty"`
	// ApplicationGuardAllowFileSaveOnHost Allow users to download files from Edge in the application guard container and save them on the host file system
	ApplicationGuardAllowFileSaveOnHost *bool `json:"applicationGuardAllowFileSaveOnHost,omitempty"`
	// BitLockerAllowStandardUserEncryption Allows the admin to allow standard users to enable encrpytion during Azure AD Join.
	BitLockerAllowStandardUserEncryption *bool `json:"bitLockerAllowStandardUserEncryption,omitempty"`
	// BitLockerDisableWarningForOtherDiskEncryption Allows the Admin to disable the warning prompt for other disk encryption on the user machines.
	BitLockerDisableWarningForOtherDiskEncryption *bool `json:"bitLockerDisableWarningForOtherDiskEncryption,omitempty"`
	// BitLockerEnableStorageCardEncryptionOnMobile Allows the admin to require encryption to be turned on using BitLocker. This policy is valid only for a mobile SKU.
	BitLockerEnableStorageCardEncryptionOnMobile *bool `json:"bitLockerEnableStorageCardEncryptionOnMobile,omitempty"`
	// BitLockerEncryptDevice Allows the admin to require encryption to be turned on using BitLocker.
	BitLockerEncryptDevice *bool `json:"bitLockerEncryptDevice,omitempty"`
	// BitLockerSystemDrivePolicy BitLocker System Drive Policy.
	BitLockerSystemDrivePolicy *BitLockerSystemDrivePolicy `json:"bitLockerSystemDrivePolicy,omitempty"`
	// BitLockerFixedDrivePolicy BitLocker Fixed Drive Policy.
	BitLockerFixedDrivePolicy *BitLockerFixedDrivePolicy `json:"bitLockerFixedDrivePolicy,omitempty"`
	// BitLockerRemovableDrivePolicy BitLocker Removable Drive Policy.
	BitLockerRemovableDrivePolicy *BitLockerRemovableDrivePolicy `json:"bitLockerRemovableDrivePolicy,omitempty"`
	// BitLockerRecoveryPasswordRotation This setting initiates a client-driven recovery password rotation after an OS drive recovery (either by using bootmgr or WinRE).
	BitLockerRecoveryPasswordRotation *BitLockerRecoveryPasswordRotationType `json:"bitLockerRecoveryPasswordRotation,omitempty"`
}

// Windows10EnrollmentCompletionPageConfiguration Windows 10 Enrollment Status Page Configuration
type Windows10EnrollmentCompletionPageConfiguration struct {
	// DeviceEnrollmentConfiguration is the base model of Windows10EnrollmentCompletionPageConfiguration
	DeviceEnrollmentConfiguration
	// ShowInstallationProgress Show or hide installation progress to user
	ShowInstallationProgress *bool `json:"showInstallationProgress,omitempty"`
	// BlockDeviceSetupRetryByUser Allow the user to retry the setup on installation failure
	BlockDeviceSetupRetryByUser *bool `json:"blockDeviceSetupRetryByUser,omitempty"`
	// AllowDeviceResetOnInstallFailure Allow or block device reset on installation failure
	AllowDeviceResetOnInstallFailure *bool `json:"allowDeviceResetOnInstallFailure,omitempty"`
	// AllowLogCollectionOnInstallFailure Allow or block log collection on installation failure
	AllowLogCollectionOnInstallFailure *bool `json:"allowLogCollectionOnInstallFailure,omitempty"`
	// CustomErrorMessage Set custom error message to show upon installation failure
	CustomErrorMessage *string `json:"customErrorMessage,omitempty"`
	// InstallProgressTimeoutInMinutes Set installation progress timeout in minutes
	InstallProgressTimeoutInMinutes *int `json:"installProgressTimeoutInMinutes,omitempty"`
	// AllowDeviceUseOnInstallFailure Allow the user to continue using the device on installation failure
	AllowDeviceUseOnInstallFailure *bool `json:"allowDeviceUseOnInstallFailure,omitempty"`
	// SelectedMobileAppIDs Selected applications to track the installation status
	SelectedMobileAppIDs []string `json:"selectedMobileAppIds,omitempty"`
	// TrackInstallProgressForAutopilotOnly Only show installation progress for Autopilot enrollment scenarios
	TrackInstallProgressForAutopilotOnly *bool `json:"trackInstallProgressForAutopilotOnly,omitempty"`
	// DisableUserStatusTrackingAfterFirstUser Only show installation progress for first user post enrollment
	DisableUserStatusTrackingAfterFirstUser *bool `json:"disableUserStatusTrackingAfterFirstUser,omitempty"`
}

// Windows10EnrollmentCompletionPageConfigurationPolicySetItem A class containing the properties used for Windows10EnrollmentCompletionPageConfiguration PolicySetItem.
type Windows10EnrollmentCompletionPageConfigurationPolicySetItem struct {
	// PolicySetItem is the base model of Windows10EnrollmentCompletionPageConfigurationPolicySetItem
	PolicySetItem
	// Priority Priority of the Windows10EnrollmentCompletionPageConfigurationPolicySetItem.
	Priority *int `json:"priority,omitempty"`
}

// Windows10EnterpriseModernAppManagementConfiguration Windows10 Enterprise Modern App Management Configuration.
type Windows10EnterpriseModernAppManagementConfiguration struct {
	// DeviceConfiguration is the base model of Windows10EnterpriseModernAppManagementConfiguration
	DeviceConfiguration
	// UninstallBuiltInApps Indicates whether or not to uninstall a fixed list of built-in Windows apps.
	UninstallBuiltInApps *bool `json:"uninstallBuiltInApps,omitempty"`
}

// Windows10GeneralConfiguration This topic provides descriptions of the declared methods, properties and relationships exposed by the windows10GeneralConfiguration resource.
type Windows10GeneralConfiguration struct {
	// DeviceConfiguration is the base model of Windows10GeneralConfiguration
	DeviceConfiguration
	// TaskManagerBlockEndTask Specify whether non-administrators can use Task Manager to end tasks.
	TaskManagerBlockEndTask *bool `json:"taskManagerBlockEndTask,omitempty"`
	// EnergySaverOnBatteryThresholdPercentage This setting allows you to specify battery charge level at which Energy Saver is turned on. While on battery, Energy Saver is automatically turned on at (and below) the specified battery charge level. Valid input range (0-100). Valid values 0 to 100
	EnergySaverOnBatteryThresholdPercentage *int `json:"energySaverOnBatteryThresholdPercentage,omitempty"`
	// EnergySaverPluggedInThresholdPercentage This setting allows you to specify battery charge level at which Energy Saver is turned on. While plugged in, Energy Saver is automatically turned on at (and below) the specified battery charge level. Valid input range (0-100). Valid values 0 to 100
	EnergySaverPluggedInThresholdPercentage *int `json:"energySaverPluggedInThresholdPercentage,omitempty"`
	// PowerLidCloseActionOnBattery This setting specifies the action that Windows takes when a user closes the lid on a mobile PC while on battery.
	PowerLidCloseActionOnBattery *PowerActionType `json:"powerLidCloseActionOnBattery,omitempty"`
	// PowerLidCloseActionPluggedIn This setting specifies the action that Windows takes when a user closes the lid on a mobile PC while plugged in.
	PowerLidCloseActionPluggedIn *PowerActionType `json:"powerLidCloseActionPluggedIn,omitempty"`
	// PowerButtonActionOnBattery This setting specifies the action that Windows takes when a user presses the Power button while on battery.
	PowerButtonActionOnBattery *PowerActionType `json:"powerButtonActionOnBattery,omitempty"`
	// PowerButtonActionPluggedIn This setting specifies the action that Windows takes when a user presses the Power button while plugged in.
	PowerButtonActionPluggedIn *PowerActionType `json:"powerButtonActionPluggedIn,omitempty"`
	// PowerSleepButtonActionOnBattery This setting specifies the action that Windows takes when a user presses the Sleep button while on battery.
	PowerSleepButtonActionOnBattery *PowerActionType `json:"powerSleepButtonActionOnBattery,omitempty"`
	// PowerSleepButtonActionPluggedIn This setting specifies the action that Windows takes when a user presses the Sleep button while plugged in.
	PowerSleepButtonActionPluggedIn *PowerActionType `json:"powerSleepButtonActionPluggedIn,omitempty"`
	// PowerHybridSleepOnBattery This setting allows you to turn off hybrid sleep while on battery. If you set this setting to disable, a hiberfile is not generated when the system transitions to sleep (Stand By). If you set this setting to enable or do not configure this policy setting, users control this setting.
	PowerHybridSleepOnBattery *Enablement `json:"powerHybridSleepOnBattery,omitempty"`
	// PowerHybridSleepPluggedIn This setting allows you to turn off hybrid sleep while plugged in. If you set this setting to disable, a hiberfile is not generated when the system transitions to sleep (Stand By). If you set this setting to enable or do not configure this policy setting, users control this setting.
	PowerHybridSleepPluggedIn *Enablement `json:"powerHybridSleepPluggedIn,omitempty"`
	// Windows10AppsForceUpdateSchedule Windows 10 force update schedule for Apps.
	Windows10AppsForceUpdateSchedule *Windows10AppsForceUpdateSchedule `json:"windows10AppsForceUpdateSchedule,omitempty"`
	// EnableAutomaticRedeployment Allow users with administrative rights to delete all user data and settings using CTRL + Win + R at the device lock screen so that the device can be automatically re-configured and re-enrolled into management.
	EnableAutomaticRedeployment *bool `json:"enableAutomaticRedeployment,omitempty"`
	// MicrosoftAccountSignInAssistantSettings Controls the Microsoft Account Sign-In Assistant (wlidsvc) NT service.
	MicrosoftAccountSignInAssistantSettings *SignInAssistantOptions `json:"microsoftAccountSignInAssistantSettings,omitempty"`
	// AuthenticationAllowSecondaryDevice Allows secondary authentication devices to work with Windows.
	AuthenticationAllowSecondaryDevice *bool `json:"authenticationAllowSecondaryDevice,omitempty"`
	// AuthenticationWebSignIn Indicates whether or not Web Credential Provider will be enabled.
	AuthenticationWebSignIn *Enablement `json:"authenticationWebSignIn,omitempty"`
	// AuthenticationPreferredAzureADTenantDomainName Specifies the preferred domain among available domains in the Azure AD tenant.
	AuthenticationPreferredAzureADTenantDomainName *string `json:"authenticationPreferredAzureADTenantDomainName,omitempty"`
	// CryptographyAllowFipsAlgorithmPolicy Specify whether to allow or disallow the Federal Information Processing Standard (FIPS) policy.
	CryptographyAllowFipsAlgorithmPolicy *bool `json:"cryptographyAllowFipsAlgorithmPolicy,omitempty"`
	// DisplayAppListWithGdiDPIScalingTurnedOn List of legacy applications that have GDI DPI Scaling turned on.
	DisplayAppListWithGdiDPIScalingTurnedOn []string `json:"displayAppListWithGdiDPIScalingTurnedOn,omitempty"`
	// DisplayAppListWithGdiDPIScalingTurnedOff List of legacy applications that have GDI DPI Scaling turned off.
	DisplayAppListWithGdiDPIScalingTurnedOff []string `json:"displayAppListWithGdiDPIScalingTurnedOff,omitempty"`
	// EnterpriseCloudPrintDiscoveryEndPoint Endpoint for discovering cloud printers.
	EnterpriseCloudPrintDiscoveryEndPoint *string `json:"enterpriseCloudPrintDiscoveryEndPoint,omitempty"`
	// EnterpriseCloudPrintOAuthAuthority Authentication endpoint for acquiring OAuth tokens.
	EnterpriseCloudPrintOAuthAuthority *string `json:"enterpriseCloudPrintOAuthAuthority,omitempty"`
	// EnterpriseCloudPrintOAuthClientIdentifier GUID of a client application authorized to retrieve OAuth tokens from the OAuth Authority.
	EnterpriseCloudPrintOAuthClientIdentifier *string `json:"enterpriseCloudPrintOAuthClientIdentifier,omitempty"`
	// EnterpriseCloudPrintResourceIdentifier OAuth resource URI for print service as configured in the Azure portal.
	EnterpriseCloudPrintResourceIdentifier *string `json:"enterpriseCloudPrintResourceIdentifier,omitempty"`
	// EnterpriseCloudPrintDiscoveryMaxLimit Maximum number of printers that should be queried from a discovery endpoint. This is a mobile only setting. Valid values 1 to 65535
	EnterpriseCloudPrintDiscoveryMaxLimit *int `json:"enterpriseCloudPrintDiscoveryMaxLimit,omitempty"`
	// EnterpriseCloudPrintMopriaDiscoveryResourceIdentifier OAuth resource URI for printer discovery service as configured in Azure portal.
	EnterpriseCloudPrintMopriaDiscoveryResourceIdentifier *string `json:"enterpriseCloudPrintMopriaDiscoveryResourceIdentifier,omitempty"`
	// ExperienceDoNotSyncBrowserSettings Allow or prevent the syncing of Microsoft Edge Browser settings. Option for IT admins to prevent syncing across devices, but allow user override.
	ExperienceDoNotSyncBrowserSettings *BrowserSyncSetting `json:"experienceDoNotSyncBrowserSettings,omitempty"`
	// MessagingBlockSync Indicates whether or not to block text message back up and restore and Messaging Everywhere.
	MessagingBlockSync *bool `json:"messagingBlockSync,omitempty"`
	// MessagingBlockMMS Indicates whether or not to block the MMS send/receive functionality on the device.
	MessagingBlockMMS *bool `json:"messagingBlockMMS,omitempty"`
	// MessagingBlockRichCommunicationServices Indicates whether or not to block the RCS send/receive functionality on the device.
	MessagingBlockRichCommunicationServices *bool `json:"messagingBlockRichCommunicationServices,omitempty"`
	// PrinterNames Automatically provision printers based on their names (network host names).
	PrinterNames []string `json:"printerNames,omitempty"`
	// PrinterDefaultName Name (network host name) of an installed printer.
	PrinterDefaultName *string `json:"printerDefaultName,omitempty"`
	// PrinterBlockAddition Prevent user installation of additional printers from printers settings.
	PrinterBlockAddition *bool `json:"printerBlockAddition,omitempty"`
	// SearchBlockDiacritics Specifies if search can use diacritics.
	SearchBlockDiacritics *bool `json:"searchBlockDiacritics,omitempty"`
	// SearchDisableAutoLanguageDetection Specifies whether to use automatic language detection when indexing content and properties.
	SearchDisableAutoLanguageDetection *bool `json:"searchDisableAutoLanguageDetection,omitempty"`
	// SearchDisableIndexingEncryptedItems Indicates whether or not to block indexing of WIP-protected items to prevent them from appearing in search results for Cortana or Explorer.
	SearchDisableIndexingEncryptedItems *bool `json:"searchDisableIndexingEncryptedItems,omitempty"`
	// SearchEnableRemoteQueries Indicates whether or not to block remote queries of this computer’s index.
	SearchEnableRemoteQueries *bool `json:"searchEnableRemoteQueries,omitempty"`
	// SearchDisableUseLocation Specifies if search can use location information.
	SearchDisableUseLocation *bool `json:"searchDisableUseLocation,omitempty"`
	// SearchDisableLocation Specifies if search can use location information.
	SearchDisableLocation *bool `json:"searchDisableLocation,omitempty"`
	// SearchDisableIndexerBackoff Indicates whether or not to disable the search indexer backoff feature.
	SearchDisableIndexerBackoff *bool `json:"searchDisableIndexerBackoff,omitempty"`
	// SearchDisableIndexingRemovableDrive Indicates whether or not to allow users to add locations on removable drives to libraries and to be indexed.
	SearchDisableIndexingRemovableDrive *bool `json:"searchDisableIndexingRemovableDrive,omitempty"`
	// SearchEnableAutomaticIndexSizeManangement Specifies minimum amount of hard drive space on the same drive as the index location before indexing stops.
	SearchEnableAutomaticIndexSizeManangement *bool `json:"searchEnableAutomaticIndexSizeManangement,omitempty"`
	// SearchBlockWebResults Indicates whether or not to block the web search.
	SearchBlockWebResults *bool `json:"searchBlockWebResults,omitempty"`
	// SecurityBlockAzureADJoinedDevicesAutoEncryption Specify whether to allow automatic device encryption during OOBE when the device is Azure AD joined (desktop only).
	SecurityBlockAzureADJoinedDevicesAutoEncryption *bool `json:"securityBlockAzureADJoinedDevicesAutoEncryption,omitempty"`
	// DiagnosticsDataSubmissionMode Gets or sets a value allowing the device to send diagnostic and usage telemetry data, such as Watson.
	DiagnosticsDataSubmissionMode *DiagnosticDataSubmissionMode `json:"diagnosticsDataSubmissionMode,omitempty"`
	// OneDriveDisableFileSync Gets or sets a value allowing IT admins to prevent apps and features from working with files on OneDrive.
	OneDriveDisableFileSync *bool `json:"oneDriveDisableFileSync,omitempty"`
	// SystemTelemetryProxyServer Gets or sets the fully qualified domain name (FQDN) or IP address of a proxy server to forward Connected User Experiences and Telemetry requests.
	SystemTelemetryProxyServer *string `json:"systemTelemetryProxyServer,omitempty"`
	// EdgeTelemetryForMicrosoft365Analytics Specifies what type of telemetry data (none, intranet, internet, both) is sent to Microsoft 365 Analytics
	EdgeTelemetryForMicrosoft365Analytics *EdgeTelemetryMode `json:"edgeTelemetryForMicrosoft365Analytics,omitempty"`
	// InkWorkspaceAccess Controls the user access to the ink workspace, from the desktop and from above the lock screen.
	InkWorkspaceAccess *InkAccessSetting `json:"inkWorkspaceAccess,omitempty"`
	// InkWorkspaceAccessState Controls the user access to the ink workspace, from the desktop and from above the lock screen.
	InkWorkspaceAccessState *StateManagementSetting `json:"inkWorkspaceAccessState,omitempty"`
	// InkWorkspaceBlockSuggestedApps Specify whether to show recommended app suggestions in the ink workspace.
	InkWorkspaceBlockSuggestedApps *bool `json:"inkWorkspaceBlockSuggestedApps,omitempty"`
	// SmartScreenEnableAppInstallControl This property will be deprecated in July 2019 and will be replaced by property SmartScreenAppInstallControl. Allows IT Admins to control whether users are allowed to install apps from places other than the Store.
	SmartScreenEnableAppInstallControl *bool `json:"smartScreenEnableAppInstallControl,omitempty"`
	// SmartScreenAppInstallControl Added in Windows 10, version 1703. Allows IT Admins to control whether users are allowed to install apps from places other than the Store.
	SmartScreenAppInstallControl *AppInstallControlType `json:"smartScreenAppInstallControl,omitempty"`
	// PersonalizationDesktopImageURL A http or https Url to a jpg, jpeg or png image that needs to be downloaded and used as the Desktop Image or a file Url to a local image on the file system that needs to used as the Desktop Image.
	PersonalizationDesktopImageURL *string `json:"personalizationDesktopImageUrl,omitempty"`
	// PersonalizationLockScreenImageURL A http or https Url to a jpg, jpeg or png image that neeeds to be downloaded and used as the Lock Screen Image or a file Url to a local image on the file system that needs to be used as the Lock Screen Image.
	PersonalizationLockScreenImageURL *string `json:"personalizationLockScreenImageUrl,omitempty"`
	// BluetoothAllowedServices Specify a list of allowed Bluetooth services and profiles in hex formatted strings.
	BluetoothAllowedServices []string `json:"bluetoothAllowedServices,omitempty"`
	// BluetoothBlockAdvertising Whether or not to Block the user from using bluetooth advertising.
	BluetoothBlockAdvertising *bool `json:"bluetoothBlockAdvertising,omitempty"`
	// BluetoothBlockPromptedProximalConnections Whether or not to block the users from using Swift Pair and other proximity based scenarios.
	BluetoothBlockPromptedProximalConnections *bool `json:"bluetoothBlockPromptedProximalConnections,omitempty"`
	// BluetoothBlockDiscoverableMode Whether or not to Block the user from using bluetooth discoverable mode.
	BluetoothBlockDiscoverableMode *bool `json:"bluetoothBlockDiscoverableMode,omitempty"`
	// BluetoothBlockPrePairing Whether or not to block specific bundled Bluetooth peripherals to automatically pair with the host device.
	BluetoothBlockPrePairing *bool `json:"bluetoothBlockPrePairing,omitempty"`
	// EdgeBlockAutofill Indicates whether or not to block auto fill.
	EdgeBlockAutofill *bool `json:"edgeBlockAutofill,omitempty"`
	// EdgeBlocked Indicates whether or not to Block the user from using the Edge browser.
	EdgeBlocked *bool `json:"edgeBlocked,omitempty"`
	// EdgeCookiePolicy Indicates which cookies to block in the Edge browser.
	EdgeCookiePolicy *EdgeCookiePolicy `json:"edgeCookiePolicy,omitempty"`
	// EdgeBlockDeveloperTools Indicates whether or not to block developer tools in the Edge browser.
	EdgeBlockDeveloperTools *bool `json:"edgeBlockDeveloperTools,omitempty"`
	// EdgeBlockSendingDoNotTrackHeader Indicates whether or not to Block the user from sending the do not track header.
	EdgeBlockSendingDoNotTrackHeader *bool `json:"edgeBlockSendingDoNotTrackHeader,omitempty"`
	// EdgeBlockExtensions Indicates whether or not to block extensions in the Edge browser.
	EdgeBlockExtensions *bool `json:"edgeBlockExtensions,omitempty"`
	// EdgeBlockInPrivateBrowsing Indicates whether or not to block InPrivate browsing on corporate networks, in the Edge browser.
	EdgeBlockInPrivateBrowsing *bool `json:"edgeBlockInPrivateBrowsing,omitempty"`
	// EdgeBlockJavaScript Indicates whether or not to Block the user from using JavaScript.
	EdgeBlockJavaScript *bool `json:"edgeBlockJavaScript,omitempty"`
	// EdgeBlockPasswordManager Indicates whether or not to Block password manager.
	EdgeBlockPasswordManager *bool `json:"edgeBlockPasswordManager,omitempty"`
	// EdgeBlockAddressBarDropdown Block the address bar dropdown functionality in Microsoft Edge. Disable this settings to minimize network connections from Microsoft Edge to Microsoft services.
	EdgeBlockAddressBarDropdown *bool `json:"edgeBlockAddressBarDropdown,omitempty"`
	// EdgeBlockCompatibilityList Block Microsoft compatibility list in Microsoft Edge. This list from Microsoft helps Edge properly display sites with known compatibility issues.
	EdgeBlockCompatibilityList *bool `json:"edgeBlockCompatibilityList,omitempty"`
	// EdgeClearBrowsingDataOnExit Clear browsing data on exiting Microsoft Edge.
	EdgeClearBrowsingDataOnExit *bool `json:"edgeClearBrowsingDataOnExit,omitempty"`
	// EdgeAllowStartPagesModification Allow users to change Start pages on Edge. Use the EdgeHomepageUrls to specify the Start pages that the user would see by default when they open Edge.
	EdgeAllowStartPagesModification *bool `json:"edgeAllowStartPagesModification,omitempty"`
	// EdgeDisableFirstRunPage Block the Microsoft web page that opens on the first use of Microsoft Edge. This policy allows enterprises, like those enrolled in zero emissions configurations, to block this page.
	EdgeDisableFirstRunPage *bool `json:"edgeDisableFirstRunPage,omitempty"`
	// EdgeBlockLiveTileDataCollection Block the collection of information by Microsoft for live tile creation when users pin a site to Start from Microsoft Edge.
	EdgeBlockLiveTileDataCollection *bool `json:"edgeBlockLiveTileDataCollection,omitempty"`
	// EdgeSyncFavoritesWithInternetExplorer Enable favorites sync between Internet Explorer and Microsoft Edge. Additions, deletions, modifications and order changes to favorites are shared between browsers.
	EdgeSyncFavoritesWithInternetExplorer *bool `json:"edgeSyncFavoritesWithInternetExplorer,omitempty"`
	// EdgeFavoritesListLocation The location of the favorites list to provision. Could be a local file, local network or http location.
	EdgeFavoritesListLocation *string `json:"edgeFavoritesListLocation,omitempty"`
	// EdgeBlockEditFavorites Indicates whether or not to Block the user from making changes to Favorites.
	EdgeBlockEditFavorites *bool `json:"edgeBlockEditFavorites,omitempty"`
	// EdgeNewTabPageURL Specify the page opened when new tabs are created.
	EdgeNewTabPageURL *string `json:"edgeNewTabPageURL,omitempty"`
	// EdgeHomeButtonConfiguration Causes the Home button to either hide, load the default Start page, load a New tab page, or a custom URL
	EdgeHomeButtonConfiguration *EdgeHomeButtonConfiguration `json:"edgeHomeButtonConfiguration,omitempty"`
	// EdgeHomeButtonConfigurationEnabled Enable the Home button configuration.
	EdgeHomeButtonConfigurationEnabled *bool `json:"edgeHomeButtonConfigurationEnabled,omitempty"`
	// EdgeOpensWith Specify what kind of pages are open at start.
	EdgeOpensWith *EdgeOpenOptions `json:"edgeOpensWith,omitempty"`
	// EdgeBlockSideloadingExtensions Indicates whether the user can sideload extensions.
	EdgeBlockSideloadingExtensions *bool `json:"edgeBlockSideloadingExtensions,omitempty"`
	// EdgeRequiredExtensionPackageFamilyNames Specify the list of package family names of browser extensions that are required and cannot be turned off by the user.
	EdgeRequiredExtensionPackageFamilyNames []string `json:"edgeRequiredExtensionPackageFamilyNames,omitempty"`
	// EdgeBlockPrinting Configure Edge to allow or block printing.
	EdgeBlockPrinting *bool `json:"edgeBlockPrinting,omitempty"`
	// EdgeFavoritesBarVisibility Get or set a value that specifies whether to set the favorites bar to always be visible or hidden on any page.
	EdgeFavoritesBarVisibility *VisibilitySetting `json:"edgeFavoritesBarVisibility,omitempty"`
	// EdgeBlockSavingHistory Configure Edge to allow browsing history to be saved or to never save browsing history.
	EdgeBlockSavingHistory *bool `json:"edgeBlockSavingHistory,omitempty"`
	// EdgeBlockFullScreenMode Allow or prevent Edge from entering the full screen mode.
	EdgeBlockFullScreenMode *bool `json:"edgeBlockFullScreenMode,omitempty"`
	// EdgeBlockWebContentOnNewTabPage Configure to load a blank page in Edge instead of the default New tab page and prevent users from changing it.
	EdgeBlockWebContentOnNewTabPage *bool `json:"edgeBlockWebContentOnNewTabPage,omitempty"`
	// EdgeBlockTabPreloading Configure whether Edge preloads the new tab page at Windows startup.
	EdgeBlockTabPreloading *bool `json:"edgeBlockTabPreloading,omitempty"`
	// EdgeBlockPrelaunch Decide whether Microsoft Edge is prelaunched at Windows startup.
	EdgeBlockPrelaunch *bool `json:"edgeBlockPrelaunch,omitempty"`
	// EdgeShowMessageWhenOpeningInternetExplorerSites Controls the message displayed by Edge before switching to Internet Explorer.
	EdgeShowMessageWhenOpeningInternetExplorerSites *InternetExplorerMessageSetting `json:"edgeShowMessageWhenOpeningInternetExplorerSites,omitempty"`
	// EdgePreventCertificateErrorOverride Allow or prevent users from overriding certificate errors.
	EdgePreventCertificateErrorOverride *bool `json:"edgePreventCertificateErrorOverride,omitempty"`
	// EdgeKioskModeRestriction Controls how the Microsoft Edge settings are restricted based on the configure kiosk mode.
	EdgeKioskModeRestriction *EdgeKioskModeRestrictionType `json:"edgeKioskModeRestriction,omitempty"`
	// EdgeKioskResetAfterIdleTimeInMinutes Specifies the time in minutes from the last user activity before Microsoft Edge kiosk resets.  Valid values are 0-1440. The default is 5. 0 indicates no reset. Valid values 0 to 1440
	EdgeKioskResetAfterIdleTimeInMinutes *int `json:"edgeKioskResetAfterIdleTimeInMinutes,omitempty"`
	// CellularBlockDataWhenRoaming Whether or not to Block the user from using data over cellular while roaming.
	CellularBlockDataWhenRoaming *bool `json:"cellularBlockDataWhenRoaming,omitempty"`
	// CellularBlockVPN Whether or not to Block the user from using VPN over cellular.
	CellularBlockVPN *bool `json:"cellularBlockVpn,omitempty"`
	// CellularBlockVPNWhenRoaming Whether or not to Block the user from using VPN when roaming over cellular.
	CellularBlockVPNWhenRoaming *bool `json:"cellularBlockVpnWhenRoaming,omitempty"`
	// CellularData Whether or not to allow the cellular data channel on the device. If not configured, the cellular data channel is allowed and the user can turn it off.
	CellularData *ConfigurationUsage `json:"cellularData,omitempty"`
	// DefenderBlockEndUserAccess Whether or not to block end user access to Defender.
	DefenderBlockEndUserAccess *bool `json:"defenderBlockEndUserAccess,omitempty"`
	// DefenderDaysBeforeDeletingQuarantinedMalware Number of days before deleting quarantined malware. Valid values 0 to 90
	DefenderDaysBeforeDeletingQuarantinedMalware *int `json:"defenderDaysBeforeDeletingQuarantinedMalware,omitempty"`
	// DefenderDetectedMalwareActions Gets or sets Defender’s actions to take on detected Malware per threat level.
	DefenderDetectedMalwareActions *DefenderDetectedMalwareActions `json:"defenderDetectedMalwareActions,omitempty"`
	// DefenderSystemScanSchedule Defender day of the week for the system scan.
	DefenderSystemScanSchedule *WeeklySchedule `json:"defenderSystemScanSchedule,omitempty"`
	// DefenderFilesAndFoldersToExclude Files and folder to exclude from scans and real time protection.
	DefenderFilesAndFoldersToExclude []string `json:"defenderFilesAndFoldersToExclude,omitempty"`
	// DefenderFileExtensionsToExclude File extensions to exclude from scans and real time protection.
	DefenderFileExtensionsToExclude []string `json:"defenderFileExtensionsToExclude,omitempty"`
	// DefenderScanMaxCPU Max CPU usage percentage during scan. Valid values 0 to 100
	DefenderScanMaxCPU *int `json:"defenderScanMaxCpu,omitempty"`
	// DefenderMonitorFileActivity Value for monitoring file activity.
	DefenderMonitorFileActivity *DefenderMonitorFileActivity `json:"defenderMonitorFileActivity,omitempty"`
	// DefenderPotentiallyUnwantedAppAction Gets or sets Defender’s action to take on Potentially Unwanted Application (PUA), which includes software with behaviors of ad-injection, software bundling, persistent solicitation for payment or subscription, etc. Defender alerts user when PUA is being downloaded or attempts to install itself. Added in Windows 10 for desktop.
	DefenderPotentiallyUnwantedAppAction *DefenderPotentiallyUnwantedAppAction `json:"defenderPotentiallyUnwantedAppAction,omitempty"`
	// DefenderPotentiallyUnwantedAppActionSetting Gets or sets Defender’s action to take on Potentially Unwanted Application (PUA), which includes software with behaviors of ad-injection, software bundling, persistent solicitation for payment or subscription, etc. Defender alerts user when PUA is being downloaded or attempts to install itself. Added in Windows 10 for desktop.
	DefenderPotentiallyUnwantedAppActionSetting *DefenderProtectionType `json:"defenderPotentiallyUnwantedAppActionSetting,omitempty"`
	// DefenderProcessesToExclude Processes to exclude from scans and real time protection.
	DefenderProcessesToExclude []string `json:"defenderProcessesToExclude,omitempty"`
	// DefenderPromptForSampleSubmission The configuration for how to prompt user for sample submission.
	DefenderPromptForSampleSubmission *DefenderPromptForSampleSubmission `json:"defenderPromptForSampleSubmission,omitempty"`
	// DefenderRequireBehaviorMonitoring Indicates whether or not to require behavior monitoring.
	DefenderRequireBehaviorMonitoring *bool `json:"defenderRequireBehaviorMonitoring,omitempty"`
	// DefenderRequireCloudProtection Indicates whether or not to require cloud protection.
	DefenderRequireCloudProtection *bool `json:"defenderRequireCloudProtection,omitempty"`
	// DefenderRequireNetworkInspectionSystem Indicates whether or not to require network inspection system.
	DefenderRequireNetworkInspectionSystem *bool `json:"defenderRequireNetworkInspectionSystem,omitempty"`
	// DefenderRequireRealTimeMonitoring Indicates whether or not to require real time monitoring.
	DefenderRequireRealTimeMonitoring *bool `json:"defenderRequireRealTimeMonitoring,omitempty"`
	// DefenderScanArchiveFiles Indicates whether or not to scan archive files.
	DefenderScanArchiveFiles *bool `json:"defenderScanArchiveFiles,omitempty"`
	// DefenderScanDownloads Indicates whether or not to scan downloads.
	DefenderScanDownloads *bool `json:"defenderScanDownloads,omitempty"`
	// DefenderScheduleScanEnableLowCPUPriority When enabled, low CPU priority will be used during scheduled scans.
	DefenderScheduleScanEnableLowCPUPriority *bool `json:"defenderScheduleScanEnableLowCpuPriority,omitempty"`
	// DefenderDisableCatchupQuickScan When blocked, catch-up scans for scheduled quick scans will be turned off.
	DefenderDisableCatchupQuickScan *bool `json:"defenderDisableCatchupQuickScan,omitempty"`
	// DefenderDisableCatchupFullScan When blocked, catch-up scans for scheduled full scans will be turned off.
	DefenderDisableCatchupFullScan *bool `json:"defenderDisableCatchupFullScan,omitempty"`
	// DefenderScanNetworkFiles Indicates whether or not to scan files opened from a network folder.
	DefenderScanNetworkFiles *bool `json:"defenderScanNetworkFiles,omitempty"`
	// DefenderScanIncomingMail Indicates whether or not to scan incoming mail messages.
	DefenderScanIncomingMail *bool `json:"defenderScanIncomingMail,omitempty"`
	// DefenderScanMappedNetworkDrivesDuringFullScan Indicates whether or not to scan mapped network drives during full scan.
	DefenderScanMappedNetworkDrivesDuringFullScan *bool `json:"defenderScanMappedNetworkDrivesDuringFullScan,omitempty"`
	// DefenderScanRemovableDrivesDuringFullScan Indicates whether or not to scan removable drives during full scan.
	DefenderScanRemovableDrivesDuringFullScan *bool `json:"defenderScanRemovableDrivesDuringFullScan,omitempty"`
	// DefenderScanScriptsLoadedInInternetExplorer Indicates whether or not to scan scripts loaded in Internet Explorer browser.
	DefenderScanScriptsLoadedInInternetExplorer *bool `json:"defenderScanScriptsLoadedInInternetExplorer,omitempty"`
	// DefenderSignatureUpdateIntervalInHours The signature update interval in hours. Specify 0 not to check. Valid values 0 to 24
	DefenderSignatureUpdateIntervalInHours *int `json:"defenderSignatureUpdateIntervalInHours,omitempty"`
	// DefenderScanType The defender system scan type.
	DefenderScanType *DefenderScanType `json:"defenderScanType,omitempty"`
	// DefenderScheduledScanTime The defender time for the system scan.
	DefenderScheduledScanTime *TimeOfDay `json:"defenderScheduledScanTime,omitempty"`
	// DefenderScheduledQuickScanTime The time to perform a daily quick scan.
	DefenderScheduledQuickScanTime *TimeOfDay `json:"defenderScheduledQuickScanTime,omitempty"`
	// DefenderCloudBlockLevel Specifies the level of cloud-delivered protection.
	DefenderCloudBlockLevel *DefenderCloudBlockLevelType `json:"defenderCloudBlockLevel,omitempty"`
	// DefenderCloudExtendedTimeout Timeout extension for file scanning by the cloud. Valid values 0 to 50
	DefenderCloudExtendedTimeout *int `json:"defenderCloudExtendedTimeout,omitempty"`
	// DefenderCloudExtendedTimeoutInSeconds Timeout extension for file scanning by the cloud. Valid values 0 to 50
	DefenderCloudExtendedTimeoutInSeconds *int `json:"defenderCloudExtendedTimeoutInSeconds,omitempty"`
	// DefenderBlockOnAccessProtection Allows or disallows Windows Defender On Access Protection functionality.
	DefenderBlockOnAccessProtection *bool `json:"defenderBlockOnAccessProtection,omitempty"`
	// DefenderSubmitSamplesConsentType Checks for the user consent level in Windows Defender to send data.
	DefenderSubmitSamplesConsentType *DefenderSubmitSamplesConsentType `json:"defenderSubmitSamplesConsentType,omitempty"`
	// LockScreenAllowTimeoutConfiguration Specify whether to show a user-configurable setting to control the screen timeout while on the lock screen of Windows 10 Mobile devices. If this policy is set to Allow, the value set by lockScreenTimeoutInSeconds is ignored.
	LockScreenAllowTimeoutConfiguration *bool `json:"lockScreenAllowTimeoutConfiguration,omitempty"`
	// LockScreenBlockActionCenterNotifications Indicates whether or not to block action center notifications over lock screen.
	LockScreenBlockActionCenterNotifications *bool `json:"lockScreenBlockActionCenterNotifications,omitempty"`
	// LockScreenBlockCortana Indicates whether or not the user can interact with Cortana using speech while the system is locked.
	LockScreenBlockCortana *bool `json:"lockScreenBlockCortana,omitempty"`
	// LockScreenBlockToastNotifications Indicates whether to allow toast notifications above the device lock screen.
	LockScreenBlockToastNotifications *bool `json:"lockScreenBlockToastNotifications,omitempty"`
	// LockScreenTimeoutInSeconds Set the duration (in seconds) from the screen locking to the screen turning off for Windows 10 Mobile devices. Supported values are 11-1800. Valid values 11 to 1800
	LockScreenTimeoutInSeconds *int `json:"lockScreenTimeoutInSeconds,omitempty"`
	// LockScreenActivateAppsWithVoice This policy setting specifies whether Windows apps can be activated by voice while the system is locked.
	LockScreenActivateAppsWithVoice *Enablement `json:"lockScreenActivateAppsWithVoice,omitempty"`
	// PasswordBlockSimple Specify whether PINs or passwords such as "1111" or "1234" are allowed. For Windows 10 desktops, it also controls the use of picture passwords.
	PasswordBlockSimple *bool `json:"passwordBlockSimple,omitempty"`
	// PasswordExpirationDays The password expiration in days. Valid values 0 to 730
	PasswordExpirationDays *int `json:"passwordExpirationDays,omitempty"`
	// PasswordMinimumLength The minimum password length. Valid values 4 to 16
	PasswordMinimumLength *int `json:"passwordMinimumLength,omitempty"`
	// PasswordMinutesOfInactivityBeforeScreenTimeout The minutes of inactivity before the screen times out.
	PasswordMinutesOfInactivityBeforeScreenTimeout *int `json:"passwordMinutesOfInactivityBeforeScreenTimeout,omitempty"`
	// PasswordMinimumCharacterSetCount The number of character sets required in the password.
	PasswordMinimumCharacterSetCount *int `json:"passwordMinimumCharacterSetCount,omitempty"`
	// PasswordPreviousPasswordBlockCount The number of previous passwords to prevent reuse of. Valid values 0 to 50
	PasswordPreviousPasswordBlockCount *int `json:"passwordPreviousPasswordBlockCount,omitempty"`
	// PasswordRequired Indicates whether or not to require the user to have a password.
	PasswordRequired *bool `json:"passwordRequired,omitempty"`
	// PasswordRequireWhenResumeFromIdleState Indicates whether or not to require a password upon resuming from an idle state.
	PasswordRequireWhenResumeFromIdleState *bool `json:"passwordRequireWhenResumeFromIdleState,omitempty"`
	// PasswordRequiredType The required password type.
	PasswordRequiredType *RequiredPasswordType `json:"passwordRequiredType,omitempty"`
	// PasswordSignInFailureCountBeforeFactoryReset The number of sign in failures before factory reset. Valid values 0 to 999
	PasswordSignInFailureCountBeforeFactoryReset *int `json:"passwordSignInFailureCountBeforeFactoryReset,omitempty"`
	// PasswordMinimumAgeInDays This security setting determines the period of time (in days) that a password must be used before the user can change it. Valid values 0 to 998
	PasswordMinimumAgeInDays *int `json:"passwordMinimumAgeInDays,omitempty"`
	// PrivacyAdvertisingID Enables or disables the use of advertising ID. Added in Windows 10, version 1607.
	PrivacyAdvertisingID *StateManagementSetting `json:"privacyAdvertisingId,omitempty"`
	// PrivacyAutoAcceptPairingAndConsentPrompts Indicates whether or not to allow the automatic acceptance of the pairing and privacy user consent dialog when launching apps.
	PrivacyAutoAcceptPairingAndConsentPrompts *bool `json:"privacyAutoAcceptPairingAndConsentPrompts,omitempty"`
	// PrivacyDisableLaunchExperience This policy prevents the privacy experience from launching during user logon for new and upgraded users.​
	PrivacyDisableLaunchExperience *bool `json:"privacyDisableLaunchExperience,omitempty"`
	// PrivacyBlockInputPersonalization Indicates whether or not to block the usage of cloud based speech services for Cortana, Dictation, or Store applications.
	PrivacyBlockInputPersonalization *bool `json:"privacyBlockInputPersonalization,omitempty"`
	// PrivacyBlockPublishUserActivities Blocks the shared experiences/discovery of recently used resources in task switcher etc.
	PrivacyBlockPublishUserActivities *bool `json:"privacyBlockPublishUserActivities,omitempty"`
	// PrivacyBlockActivityFeed Blocks the usage of cloud based speech services for Cortana, Dictation, or Store applications.
	PrivacyBlockActivityFeed *bool `json:"privacyBlockActivityFeed,omitempty"`
	// StartBlockUnpinningAppsFromTaskbar Indicates whether or not to block the user from unpinning apps from taskbar.
	StartBlockUnpinningAppsFromTaskbar *bool `json:"startBlockUnpinningAppsFromTaskbar,omitempty"`
	// StartMenuAppListVisibility Setting the value of this collapses the app list, removes the app list entirely, or disables the corresponding toggle in the Settings app.
	StartMenuAppListVisibility *WindowsStartMenuAppListVisibilityType `json:"startMenuAppListVisibility,omitempty"`
	// StartMenuHideChangeAccountSettings Enabling this policy hides the change account setting from appearing in the user tile in the start menu.
	StartMenuHideChangeAccountSettings *bool `json:"startMenuHideChangeAccountSettings,omitempty"`
	// StartMenuHideFrequentlyUsedApps Enabling this policy hides the most used apps from appearing on the start menu and disables the corresponding toggle in the Settings app.
	StartMenuHideFrequentlyUsedApps *bool `json:"startMenuHideFrequentlyUsedApps,omitempty"`
	// StartMenuHideHibernate Enabling this policy hides hibernate from appearing in the power button in the start menu.
	StartMenuHideHibernate *bool `json:"startMenuHideHibernate,omitempty"`
	// StartMenuHideLock Enabling this policy hides lock from appearing in the user tile in the start menu.
	StartMenuHideLock *bool `json:"startMenuHideLock,omitempty"`
	// StartMenuHidePowerButton Enabling this policy hides the power button from appearing in the start menu.
	StartMenuHidePowerButton *bool `json:"startMenuHidePowerButton,omitempty"`
	// StartMenuHideRecentJumpLists Enabling this policy hides recent jump lists from appearing on the start menu/taskbar and disables the corresponding toggle in the Settings app.
	StartMenuHideRecentJumpLists *bool `json:"startMenuHideRecentJumpLists,omitempty"`
	// StartMenuHideRecentlyAddedApps Enabling this policy hides recently added apps from appearing on the start menu and disables the corresponding toggle in the Settings app.
	StartMenuHideRecentlyAddedApps *bool `json:"startMenuHideRecentlyAddedApps,omitempty"`
	// StartMenuHideRestartOptions Enabling this policy hides “Restart/Update and Restart” from appearing in the power button in the start menu.
	StartMenuHideRestartOptions *bool `json:"startMenuHideRestartOptions,omitempty"`
	// StartMenuHideShutDown Enabling this policy hides shut down/update and shut down from appearing in the power button in the start menu.
	StartMenuHideShutDown *bool `json:"startMenuHideShutDown,omitempty"`
	// StartMenuHideSignOut Enabling this policy hides sign out from appearing in the user tile in the start menu.
	StartMenuHideSignOut *bool `json:"startMenuHideSignOut,omitempty"`
	// StartMenuHideSleep Enabling this policy hides sleep from appearing in the power button in the start menu.
	StartMenuHideSleep *bool `json:"startMenuHideSleep,omitempty"`
	// StartMenuHideSwitchAccount Enabling this policy hides switch account from appearing in the user tile in the start menu.
	StartMenuHideSwitchAccount *bool `json:"startMenuHideSwitchAccount,omitempty"`
	// StartMenuHideUserTile Enabling this policy hides the user tile from appearing in the start menu.
	StartMenuHideUserTile *bool `json:"startMenuHideUserTile,omitempty"`
	// StartMenuLayoutEdgeAssetsXML This policy setting allows you to import Edge assets to be used with startMenuLayoutXml policy. Start layout can contain secondary tile from Edge app which looks for Edge local asset file. Edge local asset would not exist and cause Edge secondary tile to appear empty in this case. This policy only gets applied when startMenuLayoutXml policy is modified. The value should be a UTF-8 Base64 encoded byte array.
	StartMenuLayoutEdgeAssetsXML *Binary `json:"startMenuLayoutEdgeAssetsXml,omitempty"`
	// StartMenuLayoutXML Allows admins to override the default Start menu layout and prevents the user from changing it. The layout is modified by specifying an XML file based on a layout modification schema. XML needs to be in a UTF8 encoded byte array format.
	StartMenuLayoutXML *Binary `json:"startMenuLayoutXml,omitempty"`
	// StartMenuMode Allows admins to decide how the Start menu is displayed.
	StartMenuMode *WindowsStartMenuModeType `json:"startMenuMode,omitempty"`
	// StartMenuPinnedFolderDocuments Enforces the visibility (Show/Hide) of the Documents folder shortcut on the Start menu.
	StartMenuPinnedFolderDocuments *VisibilitySetting `json:"startMenuPinnedFolderDocuments,omitempty"`
	// StartMenuPinnedFolderDownloads Enforces the visibility (Show/Hide) of the Downloads folder shortcut on the Start menu.
	StartMenuPinnedFolderDownloads *VisibilitySetting `json:"startMenuPinnedFolderDownloads,omitempty"`
	// StartMenuPinnedFolderFileExplorer Enforces the visibility (Show/Hide) of the FileExplorer shortcut on the Start menu.
	StartMenuPinnedFolderFileExplorer *VisibilitySetting `json:"startMenuPinnedFolderFileExplorer,omitempty"`
	// StartMenuPinnedFolderHomeGroup Enforces the visibility (Show/Hide) of the HomeGroup folder shortcut on the Start menu.
	StartMenuPinnedFolderHomeGroup *VisibilitySetting `json:"startMenuPinnedFolderHomeGroup,omitempty"`
	// StartMenuPinnedFolderMusic Enforces the visibility (Show/Hide) of the Music folder shortcut on the Start menu.
	StartMenuPinnedFolderMusic *VisibilitySetting `json:"startMenuPinnedFolderMusic,omitempty"`
	// StartMenuPinnedFolderNetwork Enforces the visibility (Show/Hide) of the Network folder shortcut on the Start menu.
	StartMenuPinnedFolderNetwork *VisibilitySetting `json:"startMenuPinnedFolderNetwork,omitempty"`
	// StartMenuPinnedFolderPersonalFolder Enforces the visibility (Show/Hide) of the PersonalFolder shortcut on the Start menu.
	StartMenuPinnedFolderPersonalFolder *VisibilitySetting `json:"startMenuPinnedFolderPersonalFolder,omitempty"`
	// StartMenuPinnedFolderPictures Enforces the visibility (Show/Hide) of the Pictures folder shortcut on the Start menu.
	StartMenuPinnedFolderPictures *VisibilitySetting `json:"startMenuPinnedFolderPictures,omitempty"`
	// StartMenuPinnedFolderSettings Enforces the visibility (Show/Hide) of the Settings folder shortcut on the Start menu.
	StartMenuPinnedFolderSettings *VisibilitySetting `json:"startMenuPinnedFolderSettings,omitempty"`
	// StartMenuPinnedFolderVideos Enforces the visibility (Show/Hide) of the Videos folder shortcut on the Start menu.
	StartMenuPinnedFolderVideos *VisibilitySetting `json:"startMenuPinnedFolderVideos,omitempty"`
	// SettingsBlockSettingsApp Indicates whether or not to block access to Settings app.
	SettingsBlockSettingsApp *bool `json:"settingsBlockSettingsApp,omitempty"`
	// SettingsBlockSystemPage Indicates whether or not to block access to System in Settings app.
	SettingsBlockSystemPage *bool `json:"settingsBlockSystemPage,omitempty"`
	// SettingsBlockDevicesPage Indicates whether or not to block access to Devices in Settings app.
	SettingsBlockDevicesPage *bool `json:"settingsBlockDevicesPage,omitempty"`
	// SettingsBlockNetworkInternetPage Indicates whether or not to block access to Network & Internet in Settings app.
	SettingsBlockNetworkInternetPage *bool `json:"settingsBlockNetworkInternetPage,omitempty"`
	// SettingsBlockPersonalizationPage Indicates whether or not to block access to Personalization in Settings app.
	SettingsBlockPersonalizationPage *bool `json:"settingsBlockPersonalizationPage,omitempty"`
	// SettingsBlockAccountsPage Indicates whether or not to block access to Accounts in Settings app.
	SettingsBlockAccountsPage *bool `json:"settingsBlockAccountsPage,omitempty"`
	// SettingsBlockTimeLanguagePage Indicates whether or not to block access to Time & Language in Settings app.
	SettingsBlockTimeLanguagePage *bool `json:"settingsBlockTimeLanguagePage,omitempty"`
	// SettingsBlockEaseOfAccessPage Indicates whether or not to block access to Ease of Access in Settings app.
	SettingsBlockEaseOfAccessPage *bool `json:"settingsBlockEaseOfAccessPage,omitempty"`
	// SettingsBlockPrivacyPage Indicates whether or not to block access to Privacy in Settings app.
	SettingsBlockPrivacyPage *bool `json:"settingsBlockPrivacyPage,omitempty"`
	// SettingsBlockUpdateSecurityPage Indicates whether or not to block access to Update & Security in Settings app.
	SettingsBlockUpdateSecurityPage *bool `json:"settingsBlockUpdateSecurityPage,omitempty"`
	// SettingsBlockAppsPage Indicates whether or not to block access to Apps in Settings app.
	SettingsBlockAppsPage *bool `json:"settingsBlockAppsPage,omitempty"`
	// SettingsBlockGamingPage Indicates whether or not to block access to Gaming in Settings app.
	SettingsBlockGamingPage *bool `json:"settingsBlockGamingPage,omitempty"`
	// WindowsSpotlightBlockConsumerSpecificFeatures Allows IT admins to block experiences that are typically for consumers only, such as Start suggestions, Membership notifications, Post-OOBE app install and redirect tiles.
	WindowsSpotlightBlockConsumerSpecificFeatures *bool `json:"windowsSpotlightBlockConsumerSpecificFeatures,omitempty"`
	// WindowsSpotlightBlocked Allows IT admins to turn off all Windows Spotlight features
	WindowsSpotlightBlocked *bool `json:"windowsSpotlightBlocked,omitempty"`
	// WindowsSpotlightBlockOnActionCenter Block suggestions from Microsoft that show after each OS clean install, upgrade or in an on-going basis to introduce users to what is new or changed
	WindowsSpotlightBlockOnActionCenter *bool `json:"windowsSpotlightBlockOnActionCenter,omitempty"`
	// WindowsSpotlightBlockTailoredExperiences Block personalized content in Windows spotlight based on user’s device usage.
	WindowsSpotlightBlockTailoredExperiences *bool `json:"windowsSpotlightBlockTailoredExperiences,omitempty"`
	// WindowsSpotlightBlockThirdPartyNotifications Block third party content delivered via Windows Spotlight
	WindowsSpotlightBlockThirdPartyNotifications *bool `json:"windowsSpotlightBlockThirdPartyNotifications,omitempty"`
	// WindowsSpotlightBlockWelcomeExperience Block Windows Spotlight Windows welcome experience
	WindowsSpotlightBlockWelcomeExperience *bool `json:"windowsSpotlightBlockWelcomeExperience,omitempty"`
	// WindowsSpotlightBlockWindowsTips Allows IT admins to turn off the popup of Windows Tips.
	WindowsSpotlightBlockWindowsTips *bool `json:"windowsSpotlightBlockWindowsTips,omitempty"`
	// WindowsSpotlightConfigureOnLockScreen Specifies the type of Spotlight
	WindowsSpotlightConfigureOnLockScreen *WindowsSpotlightEnablementSettings `json:"windowsSpotlightConfigureOnLockScreen,omitempty"`
	// NetworkProxyApplySettingsDeviceWide If set, proxy settings will be applied to all processes and accounts in the device. Otherwise, it will be applied to the user account that’s enrolled into MDM.
	NetworkProxyApplySettingsDeviceWide *bool `json:"networkProxyApplySettingsDeviceWide,omitempty"`
	// NetworkProxyDisableAutoDetect Disable automatic detection of settings. If enabled, the system will try to find the path to a proxy auto-config (PAC) script.
	NetworkProxyDisableAutoDetect *bool `json:"networkProxyDisableAutoDetect,omitempty"`
	// NetworkProxyAutomaticConfigurationURL Address to the proxy auto-config (PAC) script you want to use.
	NetworkProxyAutomaticConfigurationURL *string `json:"networkProxyAutomaticConfigurationUrl,omitempty"`
	// NetworkProxyServer Specifies manual proxy server settings.
	NetworkProxyServer *Windows10NetworkProxyServer `json:"networkProxyServer,omitempty"`
	// AccountsBlockAddingNonMicrosoftAccountEmail Indicates whether or not to Block the user from adding email accounts to the device that are not associated with a Microsoft account.
	AccountsBlockAddingNonMicrosoftAccountEmail *bool `json:"accountsBlockAddingNonMicrosoftAccountEmail,omitempty"`
	// AntiTheftModeBlocked Indicates whether or not to block the user from selecting an AntiTheft mode preference (Windows 10 Mobile only).
	AntiTheftModeBlocked *bool `json:"antiTheftModeBlocked,omitempty"`
	// BluetoothBlocked Whether or not to Block the user from using bluetooth.
	BluetoothBlocked *bool `json:"bluetoothBlocked,omitempty"`
	// CameraBlocked Whether or not to Block the user from accessing the camera of the device.
	CameraBlocked *bool `json:"cameraBlocked,omitempty"`
	// ConnectedDevicesServiceBlocked Whether or not to block Connected Devices Service which enables discovery and connection to other devices, remote messaging, remote app sessions and other cross-device experiences.
	ConnectedDevicesServiceBlocked *bool `json:"connectedDevicesServiceBlocked,omitempty"`
	// CertificatesBlockManualRootCertificateInstallation Whether or not to Block the user from doing manual root certificate installation.
	CertificatesBlockManualRootCertificateInstallation *bool `json:"certificatesBlockManualRootCertificateInstallation,omitempty"`
	// CopyPasteBlocked Whether or not to Block the user from using copy paste.
	CopyPasteBlocked *bool `json:"copyPasteBlocked,omitempty"`
	// CortanaBlocked Whether or not to Block the user from using Cortana.
	CortanaBlocked *bool `json:"cortanaBlocked,omitempty"`
	// DeviceManagementBlockFactoryResetOnMobile Indicates whether or not to Block the user from resetting their phone.
	DeviceManagementBlockFactoryResetOnMobile *bool `json:"deviceManagementBlockFactoryResetOnMobile,omitempty"`
	// DeviceManagementBlockManualUnenroll Indicates whether or not to Block the user from doing manual un-enrollment from device management.
	DeviceManagementBlockManualUnenroll *bool `json:"deviceManagementBlockManualUnenroll,omitempty"`
	// SafeSearchFilter Specifies what filter level of safe search is required.
	SafeSearchFilter *SafeSearchFilterType `json:"safeSearchFilter,omitempty"`
	// EdgeBlockPopups Indicates whether or not to block popups.
	EdgeBlockPopups *bool `json:"edgeBlockPopups,omitempty"`
	// EdgeBlockSearchSuggestions Indicates whether or not to block the user from using the search suggestions in the address bar.
	EdgeBlockSearchSuggestions *bool `json:"edgeBlockSearchSuggestions,omitempty"`
	// EdgeBlockSearchEngineCustomization Indicates whether or not to block the user from adding new search engine or changing the default search engine.
	EdgeBlockSearchEngineCustomization *bool `json:"edgeBlockSearchEngineCustomization,omitempty"`
	// EdgeBlockSendingIntranetTrafficToInternetExplorer Indicates whether or not to switch the intranet traffic from Edge to Internet Explorer. Note: the name of this property is misleading; the property is obsolete, use EdgeSendIntranetTrafficToInternetExplorer instead.
	EdgeBlockSendingIntranetTrafficToInternetExplorer *bool `json:"edgeBlockSendingIntranetTrafficToInternetExplorer,omitempty"`
	// EdgeSendIntranetTrafficToInternetExplorer Indicates whether or not to switch the intranet traffic from Edge to Internet Explorer.
	EdgeSendIntranetTrafficToInternetExplorer *bool `json:"edgeSendIntranetTrafficToInternetExplorer,omitempty"`
	// EdgeRequireSmartScreen Indicates whether or not to Require the user to use the smart screen filter.
	EdgeRequireSmartScreen *bool `json:"edgeRequireSmartScreen,omitempty"`
	// EdgeEnterpriseModeSiteListLocation Indicates the enterprise mode site list location. Could be a local file, local network or http location.
	EdgeEnterpriseModeSiteListLocation *string `json:"edgeEnterpriseModeSiteListLocation,omitempty"`
	// EdgeFirstRunURL The first run URL for when Edge browser is opened for the first time.
	EdgeFirstRunURL *string `json:"edgeFirstRunUrl,omitempty"`
	// EdgeSearchEngine Allows IT admins to set a default search engine for MDM-Controlled devices. Users can override this and change their default search engine provided the AllowSearchEngineCustomization policy is not set.
	EdgeSearchEngine *EdgeSearchEngineBase `json:"edgeSearchEngine,omitempty"`
	// EdgeHomepageUrls The list of URLs for homepages shodwn on MDM-enrolled devices on Edge browser.
	EdgeHomepageUrls []string `json:"edgeHomepageUrls,omitempty"`
	// EdgeBlockAccessToAboutFlags Indicates whether or not to prevent access to about flags on Edge browser.
	EdgeBlockAccessToAboutFlags *bool `json:"edgeBlockAccessToAboutFlags,omitempty"`
	// SmartScreenBlockPromptOverride Indicates whether or not users can override SmartScreen Filter warnings about potentially malicious websites.
	SmartScreenBlockPromptOverride *bool `json:"smartScreenBlockPromptOverride,omitempty"`
	// SmartScreenBlockPromptOverrideForFiles Indicates whether or not users can override the SmartScreen Filter warnings about downloading unverified files
	SmartScreenBlockPromptOverrideForFiles *bool `json:"smartScreenBlockPromptOverrideForFiles,omitempty"`
	// WebRtcBlockLocalhostIPAddress Indicates whether or not user's localhost IP address is displayed while making phone calls using the WebRTC
	WebRtcBlockLocalhostIPAddress *bool `json:"webRtcBlockLocalhostIpAddress,omitempty"`
	// InternetSharingBlocked Indicates whether or not to Block the user from using internet sharing.
	InternetSharingBlocked *bool `json:"internetSharingBlocked,omitempty"`
	// SettingsBlockAddProvisioningPackage Indicates whether or not to block the user from installing provisioning packages.
	SettingsBlockAddProvisioningPackage *bool `json:"settingsBlockAddProvisioningPackage,omitempty"`
	// SettingsBlockRemoveProvisioningPackage Indicates whether or not to block the runtime configuration agent from removing provisioning packages.
	SettingsBlockRemoveProvisioningPackage *bool `json:"settingsBlockRemoveProvisioningPackage,omitempty"`
	// SettingsBlockChangeSystemTime Indicates whether or not to block the user from changing date and time settings.
	SettingsBlockChangeSystemTime *bool `json:"settingsBlockChangeSystemTime,omitempty"`
	// SettingsBlockEditDeviceName Indicates whether or not to block the user from editing the device name.
	SettingsBlockEditDeviceName *bool `json:"settingsBlockEditDeviceName,omitempty"`
	// SettingsBlockChangeRegion Indicates whether or not to block the user from changing the region settings.
	SettingsBlockChangeRegion *bool `json:"settingsBlockChangeRegion,omitempty"`
	// SettingsBlockChangeLanguage Indicates whether or not to block the user from changing the language settings.
	SettingsBlockChangeLanguage *bool `json:"settingsBlockChangeLanguage,omitempty"`
	// SettingsBlockChangePowerSleep Indicates whether or not to block the user from changing power and sleep settings.
	SettingsBlockChangePowerSleep *bool `json:"settingsBlockChangePowerSleep,omitempty"`
	// LocationServicesBlocked Indicates whether or not to Block the user from location services.
	LocationServicesBlocked *bool `json:"locationServicesBlocked,omitempty"`
	// MicrosoftAccountBlocked Indicates whether or not to Block a Microsoft account.
	MicrosoftAccountBlocked *bool `json:"microsoftAccountBlocked,omitempty"`
	// MicrosoftAccountBlockSettingsSync Indicates whether or not to Block Microsoft account settings sync.
	MicrosoftAccountBlockSettingsSync *bool `json:"microsoftAccountBlockSettingsSync,omitempty"`
	// NfcBlocked Indicates whether or not to Block the user from using near field communication.
	NfcBlocked *bool `json:"nfcBlocked,omitempty"`
	// ResetProtectionModeBlocked Indicates whether or not to Block the user from reset protection mode.
	ResetProtectionModeBlocked *bool `json:"resetProtectionModeBlocked,omitempty"`
	// ScreenCaptureBlocked Indicates whether or not to Block the user from taking Screenshots.
	ScreenCaptureBlocked *bool `json:"screenCaptureBlocked,omitempty"`
	// StorageBlockRemovableStorage Indicates whether or not to Block the user from using removable storage.
	StorageBlockRemovableStorage *bool `json:"storageBlockRemovableStorage,omitempty"`
	// StorageRequireMobileDeviceEncryption Indicating whether or not to require encryption on a mobile device.
	StorageRequireMobileDeviceEncryption *bool `json:"storageRequireMobileDeviceEncryption,omitempty"`
	// UsbBlocked Indicates whether or not to Block the user from USB connection.
	UsbBlocked *bool `json:"usbBlocked,omitempty"`
	// VoiceRecordingBlocked Indicates whether or not to Block the user from voice recording.
	VoiceRecordingBlocked *bool `json:"voiceRecordingBlocked,omitempty"`
	// WiFiBlockAutomaticConnectHotspots Indicating whether or not to block automatically connecting to Wi-Fi hotspots. Has no impact if Wi-Fi is blocked.
	WiFiBlockAutomaticConnectHotspots *bool `json:"wiFiBlockAutomaticConnectHotspots,omitempty"`
	// WiFiBlocked Indicates whether or not to Block the user from using Wi-Fi.
	WiFiBlocked *bool `json:"wiFiBlocked,omitempty"`
	// WiFiBlockManualConfiguration Indicates whether or not to Block the user from using Wi-Fi manual configuration.
	WiFiBlockManualConfiguration *bool `json:"wiFiBlockManualConfiguration,omitempty"`
	// WiFiScanInterval Specify how often devices scan for Wi-Fi networks. Supported values are 1-500, where 100 = default, and 500 = low frequency. Valid values 1 to 500
	WiFiScanInterval *int `json:"wiFiScanInterval,omitempty"`
	// WirelessDisplayBlockProjectionToThisDevice Indicates whether or not to allow other devices from discovering this PC for projection.
	WirelessDisplayBlockProjectionToThisDevice *bool `json:"wirelessDisplayBlockProjectionToThisDevice,omitempty"`
	// WirelessDisplayBlockUserInputFromReceiver Indicates whether or not to allow user input from wireless display receiver.
	WirelessDisplayBlockUserInputFromReceiver *bool `json:"wirelessDisplayBlockUserInputFromReceiver,omitempty"`
	// WirelessDisplayRequirePinForPairing Indicates whether or not to require a PIN for new devices to initiate pairing.
	WirelessDisplayRequirePinForPairing *bool `json:"wirelessDisplayRequirePinForPairing,omitempty"`
	// WindowsStoreBlocked Indicates whether or not to Block the user from using the Windows store.
	WindowsStoreBlocked *bool `json:"windowsStoreBlocked,omitempty"`
	// AppsAllowTrustedAppsSideloading Indicates whether apps from AppX packages signed with a trusted certificate can be side loaded.
	AppsAllowTrustedAppsSideloading *StateManagementSetting `json:"appsAllowTrustedAppsSideloading,omitempty"`
	// WindowsStoreBlockAutoUpdate Indicates whether or not to block automatic update of apps from Windows Store.
	WindowsStoreBlockAutoUpdate *bool `json:"windowsStoreBlockAutoUpdate,omitempty"`
	// DeveloperUnlockSetting Indicates whether or not to allow developer unlock.
	DeveloperUnlockSetting *StateManagementSetting `json:"developerUnlockSetting,omitempty"`
	// SharedUserAppDataAllowed Indicates whether or not to block multiple users of the same app to share data.
	SharedUserAppDataAllowed *bool `json:"sharedUserAppDataAllowed,omitempty"`
	// AppsBlockWindowsStoreOriginatedApps Indicates whether or not to disable the launch of all apps from Windows Store that came pre-installed or were downloaded.
	AppsBlockWindowsStoreOriginatedApps *bool `json:"appsBlockWindowsStoreOriginatedApps,omitempty"`
	// WindowsStoreEnablePrivateStoreOnly Indicates whether or not to enable Private Store Only.
	WindowsStoreEnablePrivateStoreOnly *bool `json:"windowsStoreEnablePrivateStoreOnly,omitempty"`
	// StorageRestrictAppDataToSystemVolume Indicates whether application data is restricted to the system drive.
	StorageRestrictAppDataToSystemVolume *bool `json:"storageRestrictAppDataToSystemVolume,omitempty"`
	// StorageRestrictAppInstallToSystemVolume Indicates whether the installation of applications is restricted to the system drive.
	StorageRestrictAppInstallToSystemVolume *bool `json:"storageRestrictAppInstallToSystemVolume,omitempty"`
	// GameDvrBlocked Indicates whether or not to block DVR and broadcasting.
	GameDvrBlocked *bool `json:"gameDvrBlocked,omitempty"`
	// ExperienceBlockDeviceDiscovery Indicates whether or not to enable device discovery UX.
	ExperienceBlockDeviceDiscovery *bool `json:"experienceBlockDeviceDiscovery,omitempty"`
	// ExperienceBlockErrorDialogWhenNoSIM Indicates whether or not to allow the error dialog from displaying if no SIM card is detected.
	ExperienceBlockErrorDialogWhenNoSIM *bool `json:"experienceBlockErrorDialogWhenNoSIM,omitempty"`
	// ExperienceBlockTaskSwitcher Indicates whether or not to enable task switching on the device.
	ExperienceBlockTaskSwitcher *bool `json:"experienceBlockTaskSwitcher,omitempty"`
	// LogonBlockFastUserSwitching Disables the ability to quickly switch between users that are logged on simultaneously without logging off.
	LogonBlockFastUserSwitching *bool `json:"logonBlockFastUserSwitching,omitempty"`
	// TenantLockdownRequireNetworkDuringOutOfBoxExperience Whether the device is required to connect to the network.
	TenantLockdownRequireNetworkDuringOutOfBoxExperience *bool `json:"tenantLockdownRequireNetworkDuringOutOfBoxExperience,omitempty"`
	// AppManagementMSIAllowUserControlOverInstall This policy setting permits users to change installation options that typically are available only to system administrators.
	AppManagementMSIAllowUserControlOverInstall *bool `json:"appManagementMSIAllowUserControlOverInstall,omitempty"`
	// AppManagementMSIAlwaysInstallWithElevatedPrivileges This policy setting directs Windows Installer to use elevated permissions when it installs any program on the system.
	AppManagementMSIAlwaysInstallWithElevatedPrivileges *bool `json:"appManagementMSIAlwaysInstallWithElevatedPrivileges,omitempty"`
	// DataProtectionBlockDirectMemoryAccess This policy setting allows you to block direct memory access (DMA) for all hot pluggable PCI downstream ports until a user logs into Windows.
	DataProtectionBlockDirectMemoryAccess *bool `json:"dataProtectionBlockDirectMemoryAccess,omitempty"`
	// AppManagementPackageFamilyNamesToLaunchAfterLogOn List of semi-colon delimited Package Family Names of Windows apps. Listed Windows apps are to be launched after logon.​
	AppManagementPackageFamilyNamesToLaunchAfterLogOn []string `json:"appManagementPackageFamilyNamesToLaunchAfterLogOn,omitempty"`
	// PrivacyAccessControls undocumented
	PrivacyAccessControls []WindowsPrivacyDataAccessControlItem `json:"privacyAccessControls,omitempty"`
}

// Windows10ImportedPFXCertificateProfile Windows 10 Desktop and Mobile PFX Import certificate profile
type Windows10ImportedPFXCertificateProfile struct {
	// WindowsCertificateProfileBase is the base model of Windows10ImportedPFXCertificateProfile
	WindowsCertificateProfileBase
	// IntendedPurpose Intended Purpose of the Certificate Profile - which could be Unassigned, SmimeEncryption, SmimeSigning etc.
	IntendedPurpose *IntendedPurpose `json:"intendedPurpose,omitempty"`
	// ManagedDeviceCertificateStates undocumented
	ManagedDeviceCertificateStates []ManagedDeviceCertificateState `json:"managedDeviceCertificateStates,omitempty"`
}

// Windows10MobileCompliancePolicy This class contains compliance settings for Windows 10 Mobile.
type Windows10MobileCompliancePolicy struct {
	// DeviceCompliancePolicy is the base model of Windows10MobileCompliancePolicy
	DeviceCompliancePolicy
	// PasswordRequired Require a password to unlock Windows Phone device.
	PasswordRequired *bool `json:"passwordRequired,omitempty"`
	// PasswordBlockSimple Whether or not to block syncing the calendar.
	PasswordBlockSimple *bool `json:"passwordBlockSimple,omitempty"`
	// PasswordMinimumLength Minimum password length. Valid values 4 to 16
	PasswordMinimumLength *int `json:"passwordMinimumLength,omitempty"`
	// PasswordMinimumCharacterSetCount The number of character sets required in the password.
	PasswordMinimumCharacterSetCount *int `json:"passwordMinimumCharacterSetCount,omitempty"`
	// PasswordRequiredType The required password type.
	PasswordRequiredType *RequiredPasswordType `json:"passwordRequiredType,omitempty"`
	// PasswordPreviousPasswordBlockCount The number of previous passwords to prevent re-use of.
	PasswordPreviousPasswordBlockCount *int `json:"passwordPreviousPasswordBlockCount,omitempty"`
	// PasswordExpirationDays Number of days before password expiration. Valid values 1 to 255
	PasswordExpirationDays *int `json:"passwordExpirationDays,omitempty"`
	// PasswordMinutesOfInactivityBeforeLock Minutes of inactivity before a password is required.
	PasswordMinutesOfInactivityBeforeLock *int `json:"passwordMinutesOfInactivityBeforeLock,omitempty"`
	// PasswordRequireToUnlockFromIdle Require a password to unlock an idle device.
	PasswordRequireToUnlockFromIdle *bool `json:"passwordRequireToUnlockFromIdle,omitempty"`
	// OsMinimumVersion Minimum Windows Phone version.
	OsMinimumVersion *string `json:"osMinimumVersion,omitempty"`
	// OsMaximumVersion Maximum Windows Phone version.
	OsMaximumVersion *string `json:"osMaximumVersion,omitempty"`
	// EarlyLaunchAntiMalwareDriverEnabled Require devices to be reported as healthy by Windows Device Health Attestation - early launch antimalware driver is enabled.
	EarlyLaunchAntiMalwareDriverEnabled *bool `json:"earlyLaunchAntiMalwareDriverEnabled,omitempty"`
	// BitLockerEnabled Require devices to be reported healthy by Windows Device Health Attestation - bit locker is enabled
	BitLockerEnabled *bool `json:"bitLockerEnabled,omitempty"`
	// SecureBootEnabled Require devices to be reported as healthy by Windows Device Health Attestation - secure boot is enabled.
	SecureBootEnabled *bool `json:"secureBootEnabled,omitempty"`
	// CodeIntegrityEnabled Require devices to be reported as healthy by Windows Device Health Attestation.
	CodeIntegrityEnabled *bool `json:"codeIntegrityEnabled,omitempty"`
	// StorageRequireEncryption Require encryption on windows devices.
	StorageRequireEncryption *bool `json:"storageRequireEncryption,omitempty"`
	// ActiveFirewallRequired Require active firewall on Windows devices.
	ActiveFirewallRequired *bool `json:"activeFirewallRequired,omitempty"`
	// ValidOperatingSystemBuildRanges The valid operating system build ranges on Windows devices. This collection can contain a maximum of 10000 elements.
	ValidOperatingSystemBuildRanges []OperatingSystemVersionRange `json:"validOperatingSystemBuildRanges,omitempty"`
}

// Windows10NetworkBoundaryConfiguration Windows10 Network Boundary Configuration
type Windows10NetworkBoundaryConfiguration struct {
	// DeviceConfiguration is the base model of Windows10NetworkBoundaryConfiguration
	DeviceConfiguration
	// WindowsNetworkIsolationPolicy Windows Network Isolation Policy
	WindowsNetworkIsolationPolicy *WindowsNetworkIsolationPolicy `json:"windowsNetworkIsolationPolicy,omitempty"`
}

// Windows10NetworkProxyServer undocumented
type Windows10NetworkProxyServer struct {
	// Object is the base model of Windows10NetworkProxyServer
	Object
	// Address Address to the proxy server. Specify an address in the format <server>[“:”<port>]
	Address *string `json:"address,omitempty"`
	// Exceptions Addresses that should not use the proxy server. The system will not use the proxy server for addresses beginning with what is specified in this node.
	Exceptions []string `json:"exceptions,omitempty"`
	// UseForLocalAddresses Specifies whether the proxy server should be used for local (intranet) addresses.
	UseForLocalAddresses *bool `json:"useForLocalAddresses,omitempty"`
}

// Windows10PFXImportCertificateProfile Deprecated
type Windows10PFXImportCertificateProfile struct {
	// DeviceConfiguration is the base model of Windows10PFXImportCertificateProfile
	DeviceConfiguration
	// KeyStorageProvider undocumented
	KeyStorageProvider *KeyStorageProviderOption `json:"keyStorageProvider,omitempty"`
}

// Windows10PkcsCertificateProfile Windows 10 Desktop and Mobile PKCS certificate profile
type Windows10PkcsCertificateProfile struct {
	// Windows10CertificateProfileBase is the base model of Windows10PkcsCertificateProfile
	Windows10CertificateProfileBase
	// CertificationAuthority PKCS Certification Authority
	CertificationAuthority *string `json:"certificationAuthority,omitempty"`
	// CertificationAuthorityName PKCS Certification Authority Name
	CertificationAuthorityName *string `json:"certificationAuthorityName,omitempty"`
	// CertificateTemplateName PKCS Certificate Template Name
	CertificateTemplateName *string `json:"certificateTemplateName,omitempty"`
	// SubjectAlternativeNameFormatString Custom String that defines the AAD Attribute.
	SubjectAlternativeNameFormatString *string `json:"subjectAlternativeNameFormatString,omitempty"`
	// ExtendedKeyUsages Extended Key Usage (EKU) settings. This collection can contain a maximum of 500 elements.
	ExtendedKeyUsages []ExtendedKeyUsage `json:"extendedKeyUsages,omitempty"`
	// ManagedDeviceCertificateStates undocumented
	ManagedDeviceCertificateStates []ManagedDeviceCertificateState `json:"managedDeviceCertificateStates,omitempty"`
}

// Windows10SecureAssessmentConfiguration This topic provides descriptions of the declared methods, properties and relationships exposed by the secureAssessment resource.
type Windows10SecureAssessmentConfiguration struct {
	// DeviceConfiguration is the base model of Windows10SecureAssessmentConfiguration
	DeviceConfiguration
	// LaunchURI Url link to an assessment that's automatically loaded when the secure assessment browser is launched. It has to be a valid Url (http[s]://msdn.microsoft.com/).
	LaunchURI *string `json:"launchUri,omitempty"`
	// ConfigurationAccount The account used to configure the Windows device for taking the test. The user can be a domain account (domain\user), an AAD account (username@tenant.com) or a local account (username).
	ConfigurationAccount *string `json:"configurationAccount,omitempty"`
	// ConfigurationAccountType The account type used to by ConfigurationAccount.
	ConfigurationAccountType *SecureAssessmentAccountType `json:"configurationAccountType,omitempty"`
	// AllowPrinting Indicates whether or not to allow the app from printing during the test.
	AllowPrinting *bool `json:"allowPrinting,omitempty"`
	// AllowScreenCapture Indicates whether or not to allow screen capture capability during a test.
	AllowScreenCapture *bool `json:"allowScreenCapture,omitempty"`
	// AllowTextSuggestion Indicates whether or not to allow text suggestions during the test.
	AllowTextSuggestion *bool `json:"allowTextSuggestion,omitempty"`
	// LocalGuestAccountName Specifies the display text for the local guest account shown on the sign-in screen. Typically is the name of an assessment. When the user clicks the local guest account on the sign-in screen, an assessment app is launched with a specified assessment URL. Secure assessments can only be configured with local guest account sign-in on devices running Windows 10, version 1903 or later. Important notice: this property must be set with assessmentAppUserModelID in order to make the local guest account sign-in experience work properly for secure assessments.
	LocalGuestAccountName *string `json:"localGuestAccountName,omitempty"`
	// AssessmentAppUserModelID Specifies the application user model ID of the assessment app launched when a user signs in to a secure assessment with a local guest account. Important notice: this property must be set with localGuestAccountName in order to make the local guest account sign-in experience work properly for secure assessments.
	AssessmentAppUserModelID *string `json:"assessmentAppUserModelId,omitempty"`
}

// Windows10TeamGeneralConfiguration This topic provides descriptions of the declared methods, properties and relationships exposed by the windows10TeamGeneralConfiguration resource.
type Windows10TeamGeneralConfiguration struct {
	// DeviceConfiguration is the base model of Windows10TeamGeneralConfiguration
	DeviceConfiguration
	// AzureOperationalInsightsBlockTelemetry Indicates whether or not to Block Azure Operational Insights.
	AzureOperationalInsightsBlockTelemetry *bool `json:"azureOperationalInsightsBlockTelemetry,omitempty"`
	// AzureOperationalInsightsWorkspaceID The Azure Operational Insights workspace id.
	AzureOperationalInsightsWorkspaceID *string `json:"azureOperationalInsightsWorkspaceId,omitempty"`
	// AzureOperationalInsightsWorkspaceKey The Azure Operational Insights Workspace key.
	AzureOperationalInsightsWorkspaceKey *string `json:"azureOperationalInsightsWorkspaceKey,omitempty"`
	// ConnectAppBlockAutoLaunch Specifies whether to automatically launch the Connect app whenever a projection is initiated.
	ConnectAppBlockAutoLaunch *bool `json:"connectAppBlockAutoLaunch,omitempty"`
	// MaintenanceWindowBlocked Indicates whether or not to Block setting a maintenance window for device updates.
	MaintenanceWindowBlocked *bool `json:"maintenanceWindowBlocked,omitempty"`
	// MaintenanceWindowDurationInHours Maintenance window duration for device updates. Valid values 0 to 5
	MaintenanceWindowDurationInHours *int `json:"maintenanceWindowDurationInHours,omitempty"`
	// MaintenanceWindowStartTime Maintenance window start time for device updates.
	MaintenanceWindowStartTime *TimeOfDay `json:"maintenanceWindowStartTime,omitempty"`
	// MiracastChannel The channel.
	MiracastChannel *MiracastChannel `json:"miracastChannel,omitempty"`
	// MiracastBlocked Indicates whether or not to Block wireless projection.
	MiracastBlocked *bool `json:"miracastBlocked,omitempty"`
	// MiracastRequirePin Indicates whether or not to require a pin for wireless projection.
	MiracastRequirePin *bool `json:"miracastRequirePin,omitempty"`
	// SettingsBlockMyMeetingsAndFiles Specifies whether to disable the "My meetings and files" feature in the Start menu, which shows the signed-in user's meetings and files from Office 365.
	SettingsBlockMyMeetingsAndFiles *bool `json:"settingsBlockMyMeetingsAndFiles,omitempty"`
	// SettingsBlockSessionResume Specifies whether to allow the ability to resume a session when the session times out.
	SettingsBlockSessionResume *bool `json:"settingsBlockSessionResume,omitempty"`
	// SettingsBlockSigninSuggestions Specifies whether to disable auto-populating of the sign-in dialog with invitees from scheduled meetings.
	SettingsBlockSigninSuggestions *bool `json:"settingsBlockSigninSuggestions,omitempty"`
	// SettingsDefaultVolume Specifies the default volume value for a new session. Permitted values are 0-100. The default is 45. Valid values 0 to 100
	SettingsDefaultVolume *int `json:"settingsDefaultVolume,omitempty"`
	// SettingsScreenTimeoutInMinutes Specifies the number of minutes until the Hub screen turns off.
	SettingsScreenTimeoutInMinutes *int `json:"settingsScreenTimeoutInMinutes,omitempty"`
	// SettingsSessionTimeoutInMinutes Specifies the number of minutes until the session times out.
	SettingsSessionTimeoutInMinutes *int `json:"settingsSessionTimeoutInMinutes,omitempty"`
	// SettingsSleepTimeoutInMinutes Specifies the number of minutes until the Hub enters sleep mode.
	SettingsSleepTimeoutInMinutes *int `json:"settingsSleepTimeoutInMinutes,omitempty"`
	// WelcomeScreenBlockAutomaticWakeUp Indicates whether or not to Block the welcome screen from waking up automatically when someone enters the room.
	WelcomeScreenBlockAutomaticWakeUp *bool `json:"welcomeScreenBlockAutomaticWakeUp,omitempty"`
	// WelcomeScreenBackgroundImageURL The welcome screen background image URL. The URL must use the HTTPS protocol and return a PNG image.
	WelcomeScreenBackgroundImageURL *string `json:"welcomeScreenBackgroundImageUrl,omitempty"`
	// WelcomeScreenMeetingInformation The welcome screen meeting information shown.
	WelcomeScreenMeetingInformation *WelcomeScreenMeetingInformation `json:"welcomeScreenMeetingInformation,omitempty"`
}

// Windows10VpnConfiguration By providing the configurations in this profile you can instruct the Windows 10 device (desktop or mobile) to connect to desired VPN endpoint. By specifying the authentication method and security types expected by VPN endpoint you can make the VPN connection seamless for end user.
type Windows10VpnConfiguration struct {
	// WindowsVPNConfiguration is the base model of Windows10VpnConfiguration
	WindowsVPNConfiguration
	// ProfileTarget Profile target type.
	ProfileTarget *Windows10VpnProfileTarget `json:"profileTarget,omitempty"`
	// ConnectionType Connection type.
	ConnectionType *Windows10VpnConnectionType `json:"connectionType,omitempty"`
	// EnableSplitTunneling Enable split tunneling.
	EnableSplitTunneling *bool `json:"enableSplitTunneling,omitempty"`
	// EnableAlwaysOn Enable Always On mode.
	EnableAlwaysOn *bool `json:"enableAlwaysOn,omitempty"`
	// EnableDeviceTunnel Enable device tunnel.
	EnableDeviceTunnel *bool `json:"enableDeviceTunnel,omitempty"`
	// EnableDNSRegistration Enable IP address registration with internal DNS.
	EnableDNSRegistration *bool `json:"enableDnsRegistration,omitempty"`
	// DNSSuffixes Specify DNS suffixes to add to the DNS search list to properly route short names.
	DNSSuffixes []string `json:"dnsSuffixes,omitempty"`
	// AuthenticationMethod Authentication method.
	AuthenticationMethod *Windows10VpnAuthenticationMethod `json:"authenticationMethod,omitempty"`
	// RememberUserCredentials Remember user credentials.
	RememberUserCredentials *bool `json:"rememberUserCredentials,omitempty"`
	// EnableConditionalAccess Enable conditional access.
	EnableConditionalAccess *bool `json:"enableConditionalAccess,omitempty"`
	// EnableSingleSignOnWithAlternateCertificate Enable single sign-on (SSO) with alternate certificate.
	EnableSingleSignOnWithAlternateCertificate *bool `json:"enableSingleSignOnWithAlternateCertificate,omitempty"`
	// SingleSignOnEku Single sign-on Extended Key Usage (EKU).
	SingleSignOnEku *ExtendedKeyUsage `json:"singleSignOnEku,omitempty"`
	// SingleSignOnIssuerHash Single sign-on issuer hash.
	SingleSignOnIssuerHash *string `json:"singleSignOnIssuerHash,omitempty"`
	// EapXML Extensible Authentication Protocol (EAP) XML. (UTF8 encoded byte array)
	EapXML *Binary `json:"eapXml,omitempty"`
	// ProxyServer Proxy Server.
	ProxyServer *Windows10VpnProxyServer `json:"proxyServer,omitempty"`
	// AssociatedApps Associated Apps. This collection can contain a maximum of 10000 elements.
	AssociatedApps []Windows10AssociatedApps `json:"associatedApps,omitempty"`
	// OnlyAssociatedAppsCanUseConnection Only associated Apps can use connection (per-app VPN).
	OnlyAssociatedAppsCanUseConnection *bool `json:"onlyAssociatedAppsCanUseConnection,omitempty"`
	// WindowsInformationProtectionDomain Windows Information Protection (WIP) domain to associate with this connection.
	WindowsInformationProtectionDomain *string `json:"windowsInformationProtectionDomain,omitempty"`
	// TrafficRules Traffic rules. This collection can contain a maximum of 1000 elements.
	TrafficRules []VPNTrafficRule `json:"trafficRules,omitempty"`
	// Routes Routes (optional for third-party providers). This collection can contain a maximum of 1000 elements.
	Routes []VPNRoute `json:"routes,omitempty"`
	// DNSRules DNS rules. This collection can contain a maximum of 1000 elements.
	DNSRules []VPNDNSRule `json:"dnsRules,omitempty"`
	// TrustedNetworkDomains Trusted Network Domains
	TrustedNetworkDomains []string `json:"trustedNetworkDomains,omitempty"`
	// IdentityCertificate undocumented
	IdentityCertificate *WindowsCertificateProfileBase `json:"identityCertificate,omitempty"`
}

// Windows10VpnProxyServer undocumented
type Windows10VpnProxyServer struct {
	// VPNProxyServer is the base model of Windows10VpnProxyServer
	VPNProxyServer
	// BypassProxyServerForLocalAddress Bypass proxy server for local address.
	BypassProxyServerForLocalAddress *bool `json:"bypassProxyServerForLocalAddress,omitempty"`
}
