// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import (
	"context"
	"fmt"
	"io/ioutil"
	"net/http"

	"github.com/yaegashi/msgraph.go/jsonx"
)

// DeviceRequestBuilder is request builder for Device
type DeviceRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceRequest
func (b *DeviceRequestBuilder) Request() *DeviceRequest {
	return &DeviceRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceRequest is request for Device
type DeviceRequest struct{ BaseRequest }

// Get performs GET request for Device
func (r *DeviceRequest) Get(ctx context.Context) (resObj *Device, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for Device
func (r *DeviceRequest) Update(ctx context.Context, reqObj *Device) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for Device
func (r *DeviceRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceAndAppManagementRoleAssignmentRequestBuilder is request builder for DeviceAndAppManagementRoleAssignment
type DeviceAndAppManagementRoleAssignmentRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceAndAppManagementRoleAssignmentRequest
func (b *DeviceAndAppManagementRoleAssignmentRequestBuilder) Request() *DeviceAndAppManagementRoleAssignmentRequest {
	return &DeviceAndAppManagementRoleAssignmentRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceAndAppManagementRoleAssignmentRequest is request for DeviceAndAppManagementRoleAssignment
type DeviceAndAppManagementRoleAssignmentRequest struct{ BaseRequest }

// Get performs GET request for DeviceAndAppManagementRoleAssignment
func (r *DeviceAndAppManagementRoleAssignmentRequest) Get(ctx context.Context) (resObj *DeviceAndAppManagementRoleAssignment, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceAndAppManagementRoleAssignment
func (r *DeviceAndAppManagementRoleAssignmentRequest) Update(ctx context.Context, reqObj *DeviceAndAppManagementRoleAssignment) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceAndAppManagementRoleAssignment
func (r *DeviceAndAppManagementRoleAssignmentRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceAppManagementRequestBuilder is request builder for DeviceAppManagement
type DeviceAppManagementRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceAppManagementRequest
func (b *DeviceAppManagementRequestBuilder) Request() *DeviceAppManagementRequest {
	return &DeviceAppManagementRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceAppManagementRequest is request for DeviceAppManagement
type DeviceAppManagementRequest struct{ BaseRequest }

// Get performs GET request for DeviceAppManagement
func (r *DeviceAppManagementRequest) Get(ctx context.Context) (resObj *DeviceAppManagement, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceAppManagement
func (r *DeviceAppManagementRequest) Update(ctx context.Context, reqObj *DeviceAppManagement) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceAppManagement
func (r *DeviceAppManagementRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceAppManagementTaskRequestBuilder is request builder for DeviceAppManagementTask
type DeviceAppManagementTaskRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceAppManagementTaskRequest
func (b *DeviceAppManagementTaskRequestBuilder) Request() *DeviceAppManagementTaskRequest {
	return &DeviceAppManagementTaskRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceAppManagementTaskRequest is request for DeviceAppManagementTask
type DeviceAppManagementTaskRequest struct{ BaseRequest }

// Get performs GET request for DeviceAppManagementTask
func (r *DeviceAppManagementTaskRequest) Get(ctx context.Context) (resObj *DeviceAppManagementTask, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceAppManagementTask
func (r *DeviceAppManagementTaskRequest) Update(ctx context.Context, reqObj *DeviceAppManagementTask) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceAppManagementTask
func (r *DeviceAppManagementTaskRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceCategoryRequestBuilder is request builder for DeviceCategory
type DeviceCategoryRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceCategoryRequest
func (b *DeviceCategoryRequestBuilder) Request() *DeviceCategoryRequest {
	return &DeviceCategoryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceCategoryRequest is request for DeviceCategory
type DeviceCategoryRequest struct{ BaseRequest }

// Get performs GET request for DeviceCategory
func (r *DeviceCategoryRequest) Get(ctx context.Context) (resObj *DeviceCategory, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceCategory
func (r *DeviceCategoryRequest) Update(ctx context.Context, reqObj *DeviceCategory) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceCategory
func (r *DeviceCategoryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceComplianceActionItemRequestBuilder is request builder for DeviceComplianceActionItem
type DeviceComplianceActionItemRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceComplianceActionItemRequest
func (b *DeviceComplianceActionItemRequestBuilder) Request() *DeviceComplianceActionItemRequest {
	return &DeviceComplianceActionItemRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceComplianceActionItemRequest is request for DeviceComplianceActionItem
type DeviceComplianceActionItemRequest struct{ BaseRequest }

// Get performs GET request for DeviceComplianceActionItem
func (r *DeviceComplianceActionItemRequest) Get(ctx context.Context) (resObj *DeviceComplianceActionItem, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceComplianceActionItem
func (r *DeviceComplianceActionItemRequest) Update(ctx context.Context, reqObj *DeviceComplianceActionItem) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceComplianceActionItem
func (r *DeviceComplianceActionItemRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceComplianceDeviceOverviewRequestBuilder is request builder for DeviceComplianceDeviceOverview
type DeviceComplianceDeviceOverviewRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceComplianceDeviceOverviewRequest
func (b *DeviceComplianceDeviceOverviewRequestBuilder) Request() *DeviceComplianceDeviceOverviewRequest {
	return &DeviceComplianceDeviceOverviewRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceComplianceDeviceOverviewRequest is request for DeviceComplianceDeviceOverview
type DeviceComplianceDeviceOverviewRequest struct{ BaseRequest }

// Get performs GET request for DeviceComplianceDeviceOverview
func (r *DeviceComplianceDeviceOverviewRequest) Get(ctx context.Context) (resObj *DeviceComplianceDeviceOverview, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceComplianceDeviceOverview
func (r *DeviceComplianceDeviceOverviewRequest) Update(ctx context.Context, reqObj *DeviceComplianceDeviceOverview) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceComplianceDeviceOverview
func (r *DeviceComplianceDeviceOverviewRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceComplianceDeviceStatusRequestBuilder is request builder for DeviceComplianceDeviceStatus
type DeviceComplianceDeviceStatusRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceComplianceDeviceStatusRequest
func (b *DeviceComplianceDeviceStatusRequestBuilder) Request() *DeviceComplianceDeviceStatusRequest {
	return &DeviceComplianceDeviceStatusRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceComplianceDeviceStatusRequest is request for DeviceComplianceDeviceStatus
type DeviceComplianceDeviceStatusRequest struct{ BaseRequest }

// Get performs GET request for DeviceComplianceDeviceStatus
func (r *DeviceComplianceDeviceStatusRequest) Get(ctx context.Context) (resObj *DeviceComplianceDeviceStatus, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceComplianceDeviceStatus
func (r *DeviceComplianceDeviceStatusRequest) Update(ctx context.Context, reqObj *DeviceComplianceDeviceStatus) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceComplianceDeviceStatus
func (r *DeviceComplianceDeviceStatusRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceCompliancePolicyRequestBuilder is request builder for DeviceCompliancePolicy
type DeviceCompliancePolicyRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceCompliancePolicyRequest
func (b *DeviceCompliancePolicyRequestBuilder) Request() *DeviceCompliancePolicyRequest {
	return &DeviceCompliancePolicyRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceCompliancePolicyRequest is request for DeviceCompliancePolicy
type DeviceCompliancePolicyRequest struct{ BaseRequest }

// Get performs GET request for DeviceCompliancePolicy
func (r *DeviceCompliancePolicyRequest) Get(ctx context.Context) (resObj *DeviceCompliancePolicy, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceCompliancePolicy
func (r *DeviceCompliancePolicyRequest) Update(ctx context.Context, reqObj *DeviceCompliancePolicy) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceCompliancePolicy
func (r *DeviceCompliancePolicyRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceCompliancePolicyAssignmentRequestBuilder is request builder for DeviceCompliancePolicyAssignment
type DeviceCompliancePolicyAssignmentRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceCompliancePolicyAssignmentRequest
func (b *DeviceCompliancePolicyAssignmentRequestBuilder) Request() *DeviceCompliancePolicyAssignmentRequest {
	return &DeviceCompliancePolicyAssignmentRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceCompliancePolicyAssignmentRequest is request for DeviceCompliancePolicyAssignment
type DeviceCompliancePolicyAssignmentRequest struct{ BaseRequest }

// Get performs GET request for DeviceCompliancePolicyAssignment
func (r *DeviceCompliancePolicyAssignmentRequest) Get(ctx context.Context) (resObj *DeviceCompliancePolicyAssignment, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceCompliancePolicyAssignment
func (r *DeviceCompliancePolicyAssignmentRequest) Update(ctx context.Context, reqObj *DeviceCompliancePolicyAssignment) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceCompliancePolicyAssignment
func (r *DeviceCompliancePolicyAssignmentRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceCompliancePolicyDeviceStateSummaryRequestBuilder is request builder for DeviceCompliancePolicyDeviceStateSummary
type DeviceCompliancePolicyDeviceStateSummaryRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceCompliancePolicyDeviceStateSummaryRequest
func (b *DeviceCompliancePolicyDeviceStateSummaryRequestBuilder) Request() *DeviceCompliancePolicyDeviceStateSummaryRequest {
	return &DeviceCompliancePolicyDeviceStateSummaryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceCompliancePolicyDeviceStateSummaryRequest is request for DeviceCompliancePolicyDeviceStateSummary
type DeviceCompliancePolicyDeviceStateSummaryRequest struct{ BaseRequest }

// Get performs GET request for DeviceCompliancePolicyDeviceStateSummary
func (r *DeviceCompliancePolicyDeviceStateSummaryRequest) Get(ctx context.Context) (resObj *DeviceCompliancePolicyDeviceStateSummary, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceCompliancePolicyDeviceStateSummary
func (r *DeviceCompliancePolicyDeviceStateSummaryRequest) Update(ctx context.Context, reqObj *DeviceCompliancePolicyDeviceStateSummary) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceCompliancePolicyDeviceStateSummary
func (r *DeviceCompliancePolicyDeviceStateSummaryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceCompliancePolicyGroupAssignmentRequestBuilder is request builder for DeviceCompliancePolicyGroupAssignment
type DeviceCompliancePolicyGroupAssignmentRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceCompliancePolicyGroupAssignmentRequest
func (b *DeviceCompliancePolicyGroupAssignmentRequestBuilder) Request() *DeviceCompliancePolicyGroupAssignmentRequest {
	return &DeviceCompliancePolicyGroupAssignmentRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceCompliancePolicyGroupAssignmentRequest is request for DeviceCompliancePolicyGroupAssignment
type DeviceCompliancePolicyGroupAssignmentRequest struct{ BaseRequest }

// Get performs GET request for DeviceCompliancePolicyGroupAssignment
func (r *DeviceCompliancePolicyGroupAssignmentRequest) Get(ctx context.Context) (resObj *DeviceCompliancePolicyGroupAssignment, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceCompliancePolicyGroupAssignment
func (r *DeviceCompliancePolicyGroupAssignmentRequest) Update(ctx context.Context, reqObj *DeviceCompliancePolicyGroupAssignment) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceCompliancePolicyGroupAssignment
func (r *DeviceCompliancePolicyGroupAssignmentRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceCompliancePolicySettingStateSummaryRequestBuilder is request builder for DeviceCompliancePolicySettingStateSummary
type DeviceCompliancePolicySettingStateSummaryRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceCompliancePolicySettingStateSummaryRequest
func (b *DeviceCompliancePolicySettingStateSummaryRequestBuilder) Request() *DeviceCompliancePolicySettingStateSummaryRequest {
	return &DeviceCompliancePolicySettingStateSummaryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceCompliancePolicySettingStateSummaryRequest is request for DeviceCompliancePolicySettingStateSummary
type DeviceCompliancePolicySettingStateSummaryRequest struct{ BaseRequest }

// Get performs GET request for DeviceCompliancePolicySettingStateSummary
func (r *DeviceCompliancePolicySettingStateSummaryRequest) Get(ctx context.Context) (resObj *DeviceCompliancePolicySettingStateSummary, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceCompliancePolicySettingStateSummary
func (r *DeviceCompliancePolicySettingStateSummaryRequest) Update(ctx context.Context, reqObj *DeviceCompliancePolicySettingStateSummary) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceCompliancePolicySettingStateSummary
func (r *DeviceCompliancePolicySettingStateSummaryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceCompliancePolicyStateRequestBuilder is request builder for DeviceCompliancePolicyState
type DeviceCompliancePolicyStateRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceCompliancePolicyStateRequest
func (b *DeviceCompliancePolicyStateRequestBuilder) Request() *DeviceCompliancePolicyStateRequest {
	return &DeviceCompliancePolicyStateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceCompliancePolicyStateRequest is request for DeviceCompliancePolicyState
type DeviceCompliancePolicyStateRequest struct{ BaseRequest }

// Get performs GET request for DeviceCompliancePolicyState
func (r *DeviceCompliancePolicyStateRequest) Get(ctx context.Context) (resObj *DeviceCompliancePolicyState, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceCompliancePolicyState
func (r *DeviceCompliancePolicyStateRequest) Update(ctx context.Context, reqObj *DeviceCompliancePolicyState) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceCompliancePolicyState
func (r *DeviceCompliancePolicyStateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceComplianceScheduledActionForRuleRequestBuilder is request builder for DeviceComplianceScheduledActionForRule
type DeviceComplianceScheduledActionForRuleRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceComplianceScheduledActionForRuleRequest
func (b *DeviceComplianceScheduledActionForRuleRequestBuilder) Request() *DeviceComplianceScheduledActionForRuleRequest {
	return &DeviceComplianceScheduledActionForRuleRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceComplianceScheduledActionForRuleRequest is request for DeviceComplianceScheduledActionForRule
type DeviceComplianceScheduledActionForRuleRequest struct{ BaseRequest }

// Get performs GET request for DeviceComplianceScheduledActionForRule
func (r *DeviceComplianceScheduledActionForRuleRequest) Get(ctx context.Context) (resObj *DeviceComplianceScheduledActionForRule, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceComplianceScheduledActionForRule
func (r *DeviceComplianceScheduledActionForRuleRequest) Update(ctx context.Context, reqObj *DeviceComplianceScheduledActionForRule) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceComplianceScheduledActionForRule
func (r *DeviceComplianceScheduledActionForRuleRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceComplianceSettingStateRequestBuilder is request builder for DeviceComplianceSettingState
type DeviceComplianceSettingStateRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceComplianceSettingStateRequest
func (b *DeviceComplianceSettingStateRequestBuilder) Request() *DeviceComplianceSettingStateRequest {
	return &DeviceComplianceSettingStateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceComplianceSettingStateRequest is request for DeviceComplianceSettingState
type DeviceComplianceSettingStateRequest struct{ BaseRequest }

// Get performs GET request for DeviceComplianceSettingState
func (r *DeviceComplianceSettingStateRequest) Get(ctx context.Context) (resObj *DeviceComplianceSettingState, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceComplianceSettingState
func (r *DeviceComplianceSettingStateRequest) Update(ctx context.Context, reqObj *DeviceComplianceSettingState) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceComplianceSettingState
func (r *DeviceComplianceSettingStateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceComplianceUserOverviewRequestBuilder is request builder for DeviceComplianceUserOverview
type DeviceComplianceUserOverviewRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceComplianceUserOverviewRequest
func (b *DeviceComplianceUserOverviewRequestBuilder) Request() *DeviceComplianceUserOverviewRequest {
	return &DeviceComplianceUserOverviewRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceComplianceUserOverviewRequest is request for DeviceComplianceUserOverview
type DeviceComplianceUserOverviewRequest struct{ BaseRequest }

// Get performs GET request for DeviceComplianceUserOverview
func (r *DeviceComplianceUserOverviewRequest) Get(ctx context.Context) (resObj *DeviceComplianceUserOverview, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceComplianceUserOverview
func (r *DeviceComplianceUserOverviewRequest) Update(ctx context.Context, reqObj *DeviceComplianceUserOverview) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceComplianceUserOverview
func (r *DeviceComplianceUserOverviewRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceComplianceUserStatusRequestBuilder is request builder for DeviceComplianceUserStatus
type DeviceComplianceUserStatusRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceComplianceUserStatusRequest
func (b *DeviceComplianceUserStatusRequestBuilder) Request() *DeviceComplianceUserStatusRequest {
	return &DeviceComplianceUserStatusRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceComplianceUserStatusRequest is request for DeviceComplianceUserStatus
type DeviceComplianceUserStatusRequest struct{ BaseRequest }

// Get performs GET request for DeviceComplianceUserStatus
func (r *DeviceComplianceUserStatusRequest) Get(ctx context.Context) (resObj *DeviceComplianceUserStatus, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceComplianceUserStatus
func (r *DeviceComplianceUserStatusRequest) Update(ctx context.Context, reqObj *DeviceComplianceUserStatus) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceComplianceUserStatus
func (r *DeviceComplianceUserStatusRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceConfigurationRequestBuilder is request builder for DeviceConfiguration
type DeviceConfigurationRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceConfigurationRequest
func (b *DeviceConfigurationRequestBuilder) Request() *DeviceConfigurationRequest {
	return &DeviceConfigurationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceConfigurationRequest is request for DeviceConfiguration
type DeviceConfigurationRequest struct{ BaseRequest }

// Get performs GET request for DeviceConfiguration
func (r *DeviceConfigurationRequest) Get(ctx context.Context) (resObj *DeviceConfiguration, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceConfiguration
func (r *DeviceConfigurationRequest) Update(ctx context.Context, reqObj *DeviceConfiguration) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceConfiguration
func (r *DeviceConfigurationRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceConfigurationAssignmentRequestBuilder is request builder for DeviceConfigurationAssignment
type DeviceConfigurationAssignmentRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceConfigurationAssignmentRequest
func (b *DeviceConfigurationAssignmentRequestBuilder) Request() *DeviceConfigurationAssignmentRequest {
	return &DeviceConfigurationAssignmentRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceConfigurationAssignmentRequest is request for DeviceConfigurationAssignment
type DeviceConfigurationAssignmentRequest struct{ BaseRequest }

// Get performs GET request for DeviceConfigurationAssignment
func (r *DeviceConfigurationAssignmentRequest) Get(ctx context.Context) (resObj *DeviceConfigurationAssignment, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceConfigurationAssignment
func (r *DeviceConfigurationAssignmentRequest) Update(ctx context.Context, reqObj *DeviceConfigurationAssignment) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceConfigurationAssignment
func (r *DeviceConfigurationAssignmentRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceConfigurationConflictSummaryRequestBuilder is request builder for DeviceConfigurationConflictSummary
type DeviceConfigurationConflictSummaryRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceConfigurationConflictSummaryRequest
func (b *DeviceConfigurationConflictSummaryRequestBuilder) Request() *DeviceConfigurationConflictSummaryRequest {
	return &DeviceConfigurationConflictSummaryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceConfigurationConflictSummaryRequest is request for DeviceConfigurationConflictSummary
type DeviceConfigurationConflictSummaryRequest struct{ BaseRequest }

// Get performs GET request for DeviceConfigurationConflictSummary
func (r *DeviceConfigurationConflictSummaryRequest) Get(ctx context.Context) (resObj *DeviceConfigurationConflictSummary, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceConfigurationConflictSummary
func (r *DeviceConfigurationConflictSummaryRequest) Update(ctx context.Context, reqObj *DeviceConfigurationConflictSummary) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceConfigurationConflictSummary
func (r *DeviceConfigurationConflictSummaryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceConfigurationDeviceOverviewRequestBuilder is request builder for DeviceConfigurationDeviceOverview
type DeviceConfigurationDeviceOverviewRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceConfigurationDeviceOverviewRequest
func (b *DeviceConfigurationDeviceOverviewRequestBuilder) Request() *DeviceConfigurationDeviceOverviewRequest {
	return &DeviceConfigurationDeviceOverviewRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceConfigurationDeviceOverviewRequest is request for DeviceConfigurationDeviceOverview
type DeviceConfigurationDeviceOverviewRequest struct{ BaseRequest }

// Get performs GET request for DeviceConfigurationDeviceOverview
func (r *DeviceConfigurationDeviceOverviewRequest) Get(ctx context.Context) (resObj *DeviceConfigurationDeviceOverview, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceConfigurationDeviceOverview
func (r *DeviceConfigurationDeviceOverviewRequest) Update(ctx context.Context, reqObj *DeviceConfigurationDeviceOverview) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceConfigurationDeviceOverview
func (r *DeviceConfigurationDeviceOverviewRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceConfigurationDeviceStateSummaryRequestBuilder is request builder for DeviceConfigurationDeviceStateSummary
type DeviceConfigurationDeviceStateSummaryRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceConfigurationDeviceStateSummaryRequest
func (b *DeviceConfigurationDeviceStateSummaryRequestBuilder) Request() *DeviceConfigurationDeviceStateSummaryRequest {
	return &DeviceConfigurationDeviceStateSummaryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceConfigurationDeviceStateSummaryRequest is request for DeviceConfigurationDeviceStateSummary
type DeviceConfigurationDeviceStateSummaryRequest struct{ BaseRequest }

// Get performs GET request for DeviceConfigurationDeviceStateSummary
func (r *DeviceConfigurationDeviceStateSummaryRequest) Get(ctx context.Context) (resObj *DeviceConfigurationDeviceStateSummary, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceConfigurationDeviceStateSummary
func (r *DeviceConfigurationDeviceStateSummaryRequest) Update(ctx context.Context, reqObj *DeviceConfigurationDeviceStateSummary) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceConfigurationDeviceStateSummary
func (r *DeviceConfigurationDeviceStateSummaryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceConfigurationDeviceStatusRequestBuilder is request builder for DeviceConfigurationDeviceStatus
type DeviceConfigurationDeviceStatusRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceConfigurationDeviceStatusRequest
func (b *DeviceConfigurationDeviceStatusRequestBuilder) Request() *DeviceConfigurationDeviceStatusRequest {
	return &DeviceConfigurationDeviceStatusRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceConfigurationDeviceStatusRequest is request for DeviceConfigurationDeviceStatus
type DeviceConfigurationDeviceStatusRequest struct{ BaseRequest }

// Get performs GET request for DeviceConfigurationDeviceStatus
func (r *DeviceConfigurationDeviceStatusRequest) Get(ctx context.Context) (resObj *DeviceConfigurationDeviceStatus, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceConfigurationDeviceStatus
func (r *DeviceConfigurationDeviceStatusRequest) Update(ctx context.Context, reqObj *DeviceConfigurationDeviceStatus) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceConfigurationDeviceStatus
func (r *DeviceConfigurationDeviceStatusRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceConfigurationGroupAssignmentRequestBuilder is request builder for DeviceConfigurationGroupAssignment
type DeviceConfigurationGroupAssignmentRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceConfigurationGroupAssignmentRequest
func (b *DeviceConfigurationGroupAssignmentRequestBuilder) Request() *DeviceConfigurationGroupAssignmentRequest {
	return &DeviceConfigurationGroupAssignmentRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceConfigurationGroupAssignmentRequest is request for DeviceConfigurationGroupAssignment
type DeviceConfigurationGroupAssignmentRequest struct{ BaseRequest }

// Get performs GET request for DeviceConfigurationGroupAssignment
func (r *DeviceConfigurationGroupAssignmentRequest) Get(ctx context.Context) (resObj *DeviceConfigurationGroupAssignment, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceConfigurationGroupAssignment
func (r *DeviceConfigurationGroupAssignmentRequest) Update(ctx context.Context, reqObj *DeviceConfigurationGroupAssignment) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceConfigurationGroupAssignment
func (r *DeviceConfigurationGroupAssignmentRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceConfigurationStateRequestBuilder is request builder for DeviceConfigurationState
type DeviceConfigurationStateRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceConfigurationStateRequest
func (b *DeviceConfigurationStateRequestBuilder) Request() *DeviceConfigurationStateRequest {
	return &DeviceConfigurationStateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceConfigurationStateRequest is request for DeviceConfigurationState
type DeviceConfigurationStateRequest struct{ BaseRequest }

// Get performs GET request for DeviceConfigurationState
func (r *DeviceConfigurationStateRequest) Get(ctx context.Context) (resObj *DeviceConfigurationState, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceConfigurationState
func (r *DeviceConfigurationStateRequest) Update(ctx context.Context, reqObj *DeviceConfigurationState) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceConfigurationState
func (r *DeviceConfigurationStateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceConfigurationUserOverviewRequestBuilder is request builder for DeviceConfigurationUserOverview
type DeviceConfigurationUserOverviewRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceConfigurationUserOverviewRequest
func (b *DeviceConfigurationUserOverviewRequestBuilder) Request() *DeviceConfigurationUserOverviewRequest {
	return &DeviceConfigurationUserOverviewRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceConfigurationUserOverviewRequest is request for DeviceConfigurationUserOverview
type DeviceConfigurationUserOverviewRequest struct{ BaseRequest }

// Get performs GET request for DeviceConfigurationUserOverview
func (r *DeviceConfigurationUserOverviewRequest) Get(ctx context.Context) (resObj *DeviceConfigurationUserOverview, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceConfigurationUserOverview
func (r *DeviceConfigurationUserOverviewRequest) Update(ctx context.Context, reqObj *DeviceConfigurationUserOverview) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceConfigurationUserOverview
func (r *DeviceConfigurationUserOverviewRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceConfigurationUserStateSummaryRequestBuilder is request builder for DeviceConfigurationUserStateSummary
type DeviceConfigurationUserStateSummaryRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceConfigurationUserStateSummaryRequest
func (b *DeviceConfigurationUserStateSummaryRequestBuilder) Request() *DeviceConfigurationUserStateSummaryRequest {
	return &DeviceConfigurationUserStateSummaryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceConfigurationUserStateSummaryRequest is request for DeviceConfigurationUserStateSummary
type DeviceConfigurationUserStateSummaryRequest struct{ BaseRequest }

// Get performs GET request for DeviceConfigurationUserStateSummary
func (r *DeviceConfigurationUserStateSummaryRequest) Get(ctx context.Context) (resObj *DeviceConfigurationUserStateSummary, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceConfigurationUserStateSummary
func (r *DeviceConfigurationUserStateSummaryRequest) Update(ctx context.Context, reqObj *DeviceConfigurationUserStateSummary) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceConfigurationUserStateSummary
func (r *DeviceConfigurationUserStateSummaryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceConfigurationUserStatusRequestBuilder is request builder for DeviceConfigurationUserStatus
type DeviceConfigurationUserStatusRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceConfigurationUserStatusRequest
func (b *DeviceConfigurationUserStatusRequestBuilder) Request() *DeviceConfigurationUserStatusRequest {
	return &DeviceConfigurationUserStatusRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceConfigurationUserStatusRequest is request for DeviceConfigurationUserStatus
type DeviceConfigurationUserStatusRequest struct{ BaseRequest }

// Get performs GET request for DeviceConfigurationUserStatus
func (r *DeviceConfigurationUserStatusRequest) Get(ctx context.Context) (resObj *DeviceConfigurationUserStatus, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceConfigurationUserStatus
func (r *DeviceConfigurationUserStatusRequest) Update(ctx context.Context, reqObj *DeviceConfigurationUserStatus) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceConfigurationUserStatus
func (r *DeviceConfigurationUserStatusRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceEnrollmentConfigurationRequestBuilder is request builder for DeviceEnrollmentConfiguration
type DeviceEnrollmentConfigurationRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceEnrollmentConfigurationRequest
func (b *DeviceEnrollmentConfigurationRequestBuilder) Request() *DeviceEnrollmentConfigurationRequest {
	return &DeviceEnrollmentConfigurationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceEnrollmentConfigurationRequest is request for DeviceEnrollmentConfiguration
type DeviceEnrollmentConfigurationRequest struct{ BaseRequest }

// Get performs GET request for DeviceEnrollmentConfiguration
func (r *DeviceEnrollmentConfigurationRequest) Get(ctx context.Context) (resObj *DeviceEnrollmentConfiguration, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceEnrollmentConfiguration
func (r *DeviceEnrollmentConfigurationRequest) Update(ctx context.Context, reqObj *DeviceEnrollmentConfiguration) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceEnrollmentConfiguration
func (r *DeviceEnrollmentConfigurationRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceHealthScriptRequestBuilder is request builder for DeviceHealthScript
type DeviceHealthScriptRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceHealthScriptRequest
func (b *DeviceHealthScriptRequestBuilder) Request() *DeviceHealthScriptRequest {
	return &DeviceHealthScriptRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceHealthScriptRequest is request for DeviceHealthScript
type DeviceHealthScriptRequest struct{ BaseRequest }

// Get performs GET request for DeviceHealthScript
func (r *DeviceHealthScriptRequest) Get(ctx context.Context) (resObj *DeviceHealthScript, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceHealthScript
func (r *DeviceHealthScriptRequest) Update(ctx context.Context, reqObj *DeviceHealthScript) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceHealthScript
func (r *DeviceHealthScriptRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceHealthScriptAssignmentRequestBuilder is request builder for DeviceHealthScriptAssignment
type DeviceHealthScriptAssignmentRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceHealthScriptAssignmentRequest
func (b *DeviceHealthScriptAssignmentRequestBuilder) Request() *DeviceHealthScriptAssignmentRequest {
	return &DeviceHealthScriptAssignmentRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceHealthScriptAssignmentRequest is request for DeviceHealthScriptAssignment
type DeviceHealthScriptAssignmentRequest struct{ BaseRequest }

// Get performs GET request for DeviceHealthScriptAssignment
func (r *DeviceHealthScriptAssignmentRequest) Get(ctx context.Context) (resObj *DeviceHealthScriptAssignment, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceHealthScriptAssignment
func (r *DeviceHealthScriptAssignmentRequest) Update(ctx context.Context, reqObj *DeviceHealthScriptAssignment) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceHealthScriptAssignment
func (r *DeviceHealthScriptAssignmentRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceHealthScriptDeviceStateRequestBuilder is request builder for DeviceHealthScriptDeviceState
type DeviceHealthScriptDeviceStateRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceHealthScriptDeviceStateRequest
func (b *DeviceHealthScriptDeviceStateRequestBuilder) Request() *DeviceHealthScriptDeviceStateRequest {
	return &DeviceHealthScriptDeviceStateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceHealthScriptDeviceStateRequest is request for DeviceHealthScriptDeviceState
type DeviceHealthScriptDeviceStateRequest struct{ BaseRequest }

// Get performs GET request for DeviceHealthScriptDeviceState
func (r *DeviceHealthScriptDeviceStateRequest) Get(ctx context.Context) (resObj *DeviceHealthScriptDeviceState, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceHealthScriptDeviceState
func (r *DeviceHealthScriptDeviceStateRequest) Update(ctx context.Context, reqObj *DeviceHealthScriptDeviceState) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceHealthScriptDeviceState
func (r *DeviceHealthScriptDeviceStateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceHealthScriptRunSummaryRequestBuilder is request builder for DeviceHealthScriptRunSummary
type DeviceHealthScriptRunSummaryRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceHealthScriptRunSummaryRequest
func (b *DeviceHealthScriptRunSummaryRequestBuilder) Request() *DeviceHealthScriptRunSummaryRequest {
	return &DeviceHealthScriptRunSummaryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceHealthScriptRunSummaryRequest is request for DeviceHealthScriptRunSummary
type DeviceHealthScriptRunSummaryRequest struct{ BaseRequest }

// Get performs GET request for DeviceHealthScriptRunSummary
func (r *DeviceHealthScriptRunSummaryRequest) Get(ctx context.Context) (resObj *DeviceHealthScriptRunSummary, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceHealthScriptRunSummary
func (r *DeviceHealthScriptRunSummaryRequest) Update(ctx context.Context, reqObj *DeviceHealthScriptRunSummary) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceHealthScriptRunSummary
func (r *DeviceHealthScriptRunSummaryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceInstallStateRequestBuilder is request builder for DeviceInstallState
type DeviceInstallStateRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceInstallStateRequest
func (b *DeviceInstallStateRequestBuilder) Request() *DeviceInstallStateRequest {
	return &DeviceInstallStateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceInstallStateRequest is request for DeviceInstallState
type DeviceInstallStateRequest struct{ BaseRequest }

// Get performs GET request for DeviceInstallState
func (r *DeviceInstallStateRequest) Get(ctx context.Context) (resObj *DeviceInstallState, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceInstallState
func (r *DeviceInstallStateRequest) Update(ctx context.Context, reqObj *DeviceInstallState) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceInstallState
func (r *DeviceInstallStateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementRequestBuilder is request builder for DeviceManagement
type DeviceManagementRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementRequest
func (b *DeviceManagementRequestBuilder) Request() *DeviceManagementRequest {
	return &DeviceManagementRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementRequest is request for DeviceManagement
type DeviceManagementRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagement
func (r *DeviceManagementRequest) Get(ctx context.Context) (resObj *DeviceManagement, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagement
func (r *DeviceManagementRequest) Update(ctx context.Context, reqObj *DeviceManagement) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagement
func (r *DeviceManagementRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementAbstractComplexSettingInstanceRequestBuilder is request builder for DeviceManagementAbstractComplexSettingInstance
type DeviceManagementAbstractComplexSettingInstanceRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementAbstractComplexSettingInstanceRequest
func (b *DeviceManagementAbstractComplexSettingInstanceRequestBuilder) Request() *DeviceManagementAbstractComplexSettingInstanceRequest {
	return &DeviceManagementAbstractComplexSettingInstanceRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementAbstractComplexSettingInstanceRequest is request for DeviceManagementAbstractComplexSettingInstance
type DeviceManagementAbstractComplexSettingInstanceRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementAbstractComplexSettingInstance
func (r *DeviceManagementAbstractComplexSettingInstanceRequest) Get(ctx context.Context) (resObj *DeviceManagementAbstractComplexSettingInstance, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementAbstractComplexSettingInstance
func (r *DeviceManagementAbstractComplexSettingInstanceRequest) Update(ctx context.Context, reqObj *DeviceManagementAbstractComplexSettingInstance) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementAbstractComplexSettingInstance
func (r *DeviceManagementAbstractComplexSettingInstanceRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementAutopilotEventRequestBuilder is request builder for DeviceManagementAutopilotEvent
type DeviceManagementAutopilotEventRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementAutopilotEventRequest
func (b *DeviceManagementAutopilotEventRequestBuilder) Request() *DeviceManagementAutopilotEventRequest {
	return &DeviceManagementAutopilotEventRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementAutopilotEventRequest is request for DeviceManagementAutopilotEvent
type DeviceManagementAutopilotEventRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementAutopilotEvent
func (r *DeviceManagementAutopilotEventRequest) Get(ctx context.Context) (resObj *DeviceManagementAutopilotEvent, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementAutopilotEvent
func (r *DeviceManagementAutopilotEventRequest) Update(ctx context.Context, reqObj *DeviceManagementAutopilotEvent) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementAutopilotEvent
func (r *DeviceManagementAutopilotEventRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementCachedReportConfigurationRequestBuilder is request builder for DeviceManagementCachedReportConfiguration
type DeviceManagementCachedReportConfigurationRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementCachedReportConfigurationRequest
func (b *DeviceManagementCachedReportConfigurationRequestBuilder) Request() *DeviceManagementCachedReportConfigurationRequest {
	return &DeviceManagementCachedReportConfigurationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementCachedReportConfigurationRequest is request for DeviceManagementCachedReportConfiguration
type DeviceManagementCachedReportConfigurationRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementCachedReportConfiguration
func (r *DeviceManagementCachedReportConfigurationRequest) Get(ctx context.Context) (resObj *DeviceManagementCachedReportConfiguration, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementCachedReportConfiguration
func (r *DeviceManagementCachedReportConfigurationRequest) Update(ctx context.Context, reqObj *DeviceManagementCachedReportConfiguration) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementCachedReportConfiguration
func (r *DeviceManagementCachedReportConfigurationRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementCollectionSettingInstanceRequestBuilder is request builder for DeviceManagementCollectionSettingInstance
type DeviceManagementCollectionSettingInstanceRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementCollectionSettingInstanceRequest
func (b *DeviceManagementCollectionSettingInstanceRequestBuilder) Request() *DeviceManagementCollectionSettingInstanceRequest {
	return &DeviceManagementCollectionSettingInstanceRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementCollectionSettingInstanceRequest is request for DeviceManagementCollectionSettingInstance
type DeviceManagementCollectionSettingInstanceRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementCollectionSettingInstance
func (r *DeviceManagementCollectionSettingInstanceRequest) Get(ctx context.Context) (resObj *DeviceManagementCollectionSettingInstance, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementCollectionSettingInstance
func (r *DeviceManagementCollectionSettingInstanceRequest) Update(ctx context.Context, reqObj *DeviceManagementCollectionSettingInstance) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementCollectionSettingInstance
func (r *DeviceManagementCollectionSettingInstanceRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementComplexSettingInstanceRequestBuilder is request builder for DeviceManagementComplexSettingInstance
type DeviceManagementComplexSettingInstanceRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementComplexSettingInstanceRequest
func (b *DeviceManagementComplexSettingInstanceRequestBuilder) Request() *DeviceManagementComplexSettingInstanceRequest {
	return &DeviceManagementComplexSettingInstanceRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementComplexSettingInstanceRequest is request for DeviceManagementComplexSettingInstance
type DeviceManagementComplexSettingInstanceRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementComplexSettingInstance
func (r *DeviceManagementComplexSettingInstanceRequest) Get(ctx context.Context) (resObj *DeviceManagementComplexSettingInstance, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementComplexSettingInstance
func (r *DeviceManagementComplexSettingInstanceRequest) Update(ctx context.Context, reqObj *DeviceManagementComplexSettingInstance) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementComplexSettingInstance
func (r *DeviceManagementComplexSettingInstanceRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementDerivedCredentialSettingsRequestBuilder is request builder for DeviceManagementDerivedCredentialSettings
type DeviceManagementDerivedCredentialSettingsRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementDerivedCredentialSettingsRequest
func (b *DeviceManagementDerivedCredentialSettingsRequestBuilder) Request() *DeviceManagementDerivedCredentialSettingsRequest {
	return &DeviceManagementDerivedCredentialSettingsRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementDerivedCredentialSettingsRequest is request for DeviceManagementDerivedCredentialSettings
type DeviceManagementDerivedCredentialSettingsRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementDerivedCredentialSettings
func (r *DeviceManagementDerivedCredentialSettingsRequest) Get(ctx context.Context) (resObj *DeviceManagementDerivedCredentialSettings, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementDerivedCredentialSettings
func (r *DeviceManagementDerivedCredentialSettingsRequest) Update(ctx context.Context, reqObj *DeviceManagementDerivedCredentialSettings) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementDerivedCredentialSettings
func (r *DeviceManagementDerivedCredentialSettingsRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementDomainJoinConnectorRequestBuilder is request builder for DeviceManagementDomainJoinConnector
type DeviceManagementDomainJoinConnectorRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementDomainJoinConnectorRequest
func (b *DeviceManagementDomainJoinConnectorRequestBuilder) Request() *DeviceManagementDomainJoinConnectorRequest {
	return &DeviceManagementDomainJoinConnectorRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementDomainJoinConnectorRequest is request for DeviceManagementDomainJoinConnector
type DeviceManagementDomainJoinConnectorRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementDomainJoinConnector
func (r *DeviceManagementDomainJoinConnectorRequest) Get(ctx context.Context) (resObj *DeviceManagementDomainJoinConnector, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementDomainJoinConnector
func (r *DeviceManagementDomainJoinConnectorRequest) Update(ctx context.Context, reqObj *DeviceManagementDomainJoinConnector) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementDomainJoinConnector
func (r *DeviceManagementDomainJoinConnectorRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementExchangeConnectorRequestBuilder is request builder for DeviceManagementExchangeConnector
type DeviceManagementExchangeConnectorRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementExchangeConnectorRequest
func (b *DeviceManagementExchangeConnectorRequestBuilder) Request() *DeviceManagementExchangeConnectorRequest {
	return &DeviceManagementExchangeConnectorRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementExchangeConnectorRequest is request for DeviceManagementExchangeConnector
type DeviceManagementExchangeConnectorRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementExchangeConnector
func (r *DeviceManagementExchangeConnectorRequest) Get(ctx context.Context) (resObj *DeviceManagementExchangeConnector, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementExchangeConnector
func (r *DeviceManagementExchangeConnectorRequest) Update(ctx context.Context, reqObj *DeviceManagementExchangeConnector) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementExchangeConnector
func (r *DeviceManagementExchangeConnectorRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementExchangeOnPremisesPolicyRequestBuilder is request builder for DeviceManagementExchangeOnPremisesPolicy
type DeviceManagementExchangeOnPremisesPolicyRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementExchangeOnPremisesPolicyRequest
func (b *DeviceManagementExchangeOnPremisesPolicyRequestBuilder) Request() *DeviceManagementExchangeOnPremisesPolicyRequest {
	return &DeviceManagementExchangeOnPremisesPolicyRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementExchangeOnPremisesPolicyRequest is request for DeviceManagementExchangeOnPremisesPolicy
type DeviceManagementExchangeOnPremisesPolicyRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementExchangeOnPremisesPolicy
func (r *DeviceManagementExchangeOnPremisesPolicyRequest) Get(ctx context.Context) (resObj *DeviceManagementExchangeOnPremisesPolicy, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementExchangeOnPremisesPolicy
func (r *DeviceManagementExchangeOnPremisesPolicyRequest) Update(ctx context.Context, reqObj *DeviceManagementExchangeOnPremisesPolicy) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementExchangeOnPremisesPolicy
func (r *DeviceManagementExchangeOnPremisesPolicyRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementExportJobRequestBuilder is request builder for DeviceManagementExportJob
type DeviceManagementExportJobRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementExportJobRequest
func (b *DeviceManagementExportJobRequestBuilder) Request() *DeviceManagementExportJobRequest {
	return &DeviceManagementExportJobRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementExportJobRequest is request for DeviceManagementExportJob
type DeviceManagementExportJobRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementExportJob
func (r *DeviceManagementExportJobRequest) Get(ctx context.Context) (resObj *DeviceManagementExportJob, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementExportJob
func (r *DeviceManagementExportJobRequest) Update(ctx context.Context, reqObj *DeviceManagementExportJob) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementExportJob
func (r *DeviceManagementExportJobRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementIntentRequestBuilder is request builder for DeviceManagementIntent
type DeviceManagementIntentRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementIntentRequest
func (b *DeviceManagementIntentRequestBuilder) Request() *DeviceManagementIntentRequest {
	return &DeviceManagementIntentRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementIntentRequest is request for DeviceManagementIntent
type DeviceManagementIntentRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementIntent
func (r *DeviceManagementIntentRequest) Get(ctx context.Context) (resObj *DeviceManagementIntent, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementIntent
func (r *DeviceManagementIntentRequest) Update(ctx context.Context, reqObj *DeviceManagementIntent) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementIntent
func (r *DeviceManagementIntentRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementIntentAssignmentRequestBuilder is request builder for DeviceManagementIntentAssignment
type DeviceManagementIntentAssignmentRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementIntentAssignmentRequest
func (b *DeviceManagementIntentAssignmentRequestBuilder) Request() *DeviceManagementIntentAssignmentRequest {
	return &DeviceManagementIntentAssignmentRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementIntentAssignmentRequest is request for DeviceManagementIntentAssignment
type DeviceManagementIntentAssignmentRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementIntentAssignment
func (r *DeviceManagementIntentAssignmentRequest) Get(ctx context.Context) (resObj *DeviceManagementIntentAssignment, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementIntentAssignment
func (r *DeviceManagementIntentAssignmentRequest) Update(ctx context.Context, reqObj *DeviceManagementIntentAssignment) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementIntentAssignment
func (r *DeviceManagementIntentAssignmentRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementIntentDeviceSettingStateSummaryRequestBuilder is request builder for DeviceManagementIntentDeviceSettingStateSummary
type DeviceManagementIntentDeviceSettingStateSummaryRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementIntentDeviceSettingStateSummaryRequest
func (b *DeviceManagementIntentDeviceSettingStateSummaryRequestBuilder) Request() *DeviceManagementIntentDeviceSettingStateSummaryRequest {
	return &DeviceManagementIntentDeviceSettingStateSummaryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementIntentDeviceSettingStateSummaryRequest is request for DeviceManagementIntentDeviceSettingStateSummary
type DeviceManagementIntentDeviceSettingStateSummaryRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementIntentDeviceSettingStateSummary
func (r *DeviceManagementIntentDeviceSettingStateSummaryRequest) Get(ctx context.Context) (resObj *DeviceManagementIntentDeviceSettingStateSummary, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementIntentDeviceSettingStateSummary
func (r *DeviceManagementIntentDeviceSettingStateSummaryRequest) Update(ctx context.Context, reqObj *DeviceManagementIntentDeviceSettingStateSummary) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementIntentDeviceSettingStateSummary
func (r *DeviceManagementIntentDeviceSettingStateSummaryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementIntentDeviceStateRequestBuilder is request builder for DeviceManagementIntentDeviceState
type DeviceManagementIntentDeviceStateRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementIntentDeviceStateRequest
func (b *DeviceManagementIntentDeviceStateRequestBuilder) Request() *DeviceManagementIntentDeviceStateRequest {
	return &DeviceManagementIntentDeviceStateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementIntentDeviceStateRequest is request for DeviceManagementIntentDeviceState
type DeviceManagementIntentDeviceStateRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementIntentDeviceState
func (r *DeviceManagementIntentDeviceStateRequest) Get(ctx context.Context) (resObj *DeviceManagementIntentDeviceState, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementIntentDeviceState
func (r *DeviceManagementIntentDeviceStateRequest) Update(ctx context.Context, reqObj *DeviceManagementIntentDeviceState) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementIntentDeviceState
func (r *DeviceManagementIntentDeviceStateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementIntentDeviceStateSummaryRequestBuilder is request builder for DeviceManagementIntentDeviceStateSummary
type DeviceManagementIntentDeviceStateSummaryRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementIntentDeviceStateSummaryRequest
func (b *DeviceManagementIntentDeviceStateSummaryRequestBuilder) Request() *DeviceManagementIntentDeviceStateSummaryRequest {
	return &DeviceManagementIntentDeviceStateSummaryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementIntentDeviceStateSummaryRequest is request for DeviceManagementIntentDeviceStateSummary
type DeviceManagementIntentDeviceStateSummaryRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementIntentDeviceStateSummary
func (r *DeviceManagementIntentDeviceStateSummaryRequest) Get(ctx context.Context) (resObj *DeviceManagementIntentDeviceStateSummary, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementIntentDeviceStateSummary
func (r *DeviceManagementIntentDeviceStateSummaryRequest) Update(ctx context.Context, reqObj *DeviceManagementIntentDeviceStateSummary) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementIntentDeviceStateSummary
func (r *DeviceManagementIntentDeviceStateSummaryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementIntentSettingCategoryRequestBuilder is request builder for DeviceManagementIntentSettingCategory
type DeviceManagementIntentSettingCategoryRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementIntentSettingCategoryRequest
func (b *DeviceManagementIntentSettingCategoryRequestBuilder) Request() *DeviceManagementIntentSettingCategoryRequest {
	return &DeviceManagementIntentSettingCategoryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementIntentSettingCategoryRequest is request for DeviceManagementIntentSettingCategory
type DeviceManagementIntentSettingCategoryRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementIntentSettingCategory
func (r *DeviceManagementIntentSettingCategoryRequest) Get(ctx context.Context) (resObj *DeviceManagementIntentSettingCategory, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementIntentSettingCategory
func (r *DeviceManagementIntentSettingCategoryRequest) Update(ctx context.Context, reqObj *DeviceManagementIntentSettingCategory) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementIntentSettingCategory
func (r *DeviceManagementIntentSettingCategoryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementIntentUserStateRequestBuilder is request builder for DeviceManagementIntentUserState
type DeviceManagementIntentUserStateRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementIntentUserStateRequest
func (b *DeviceManagementIntentUserStateRequestBuilder) Request() *DeviceManagementIntentUserStateRequest {
	return &DeviceManagementIntentUserStateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementIntentUserStateRequest is request for DeviceManagementIntentUserState
type DeviceManagementIntentUserStateRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementIntentUserState
func (r *DeviceManagementIntentUserStateRequest) Get(ctx context.Context) (resObj *DeviceManagementIntentUserState, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementIntentUserState
func (r *DeviceManagementIntentUserStateRequest) Update(ctx context.Context, reqObj *DeviceManagementIntentUserState) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementIntentUserState
func (r *DeviceManagementIntentUserStateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementIntentUserStateSummaryRequestBuilder is request builder for DeviceManagementIntentUserStateSummary
type DeviceManagementIntentUserStateSummaryRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementIntentUserStateSummaryRequest
func (b *DeviceManagementIntentUserStateSummaryRequestBuilder) Request() *DeviceManagementIntentUserStateSummaryRequest {
	return &DeviceManagementIntentUserStateSummaryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementIntentUserStateSummaryRequest is request for DeviceManagementIntentUserStateSummary
type DeviceManagementIntentUserStateSummaryRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementIntentUserStateSummary
func (r *DeviceManagementIntentUserStateSummaryRequest) Get(ctx context.Context) (resObj *DeviceManagementIntentUserStateSummary, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementIntentUserStateSummary
func (r *DeviceManagementIntentUserStateSummaryRequest) Update(ctx context.Context, reqObj *DeviceManagementIntentUserStateSummary) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementIntentUserStateSummary
func (r *DeviceManagementIntentUserStateSummaryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementPartnerRequestBuilder is request builder for DeviceManagementPartner
type DeviceManagementPartnerRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementPartnerRequest
func (b *DeviceManagementPartnerRequestBuilder) Request() *DeviceManagementPartnerRequest {
	return &DeviceManagementPartnerRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementPartnerRequest is request for DeviceManagementPartner
type DeviceManagementPartnerRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementPartner
func (r *DeviceManagementPartnerRequest) Get(ctx context.Context) (resObj *DeviceManagementPartner, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementPartner
func (r *DeviceManagementPartnerRequest) Update(ctx context.Context, reqObj *DeviceManagementPartner) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementPartner
func (r *DeviceManagementPartnerRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementReportScheduleRequestBuilder is request builder for DeviceManagementReportSchedule
type DeviceManagementReportScheduleRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementReportScheduleRequest
func (b *DeviceManagementReportScheduleRequestBuilder) Request() *DeviceManagementReportScheduleRequest {
	return &DeviceManagementReportScheduleRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementReportScheduleRequest is request for DeviceManagementReportSchedule
type DeviceManagementReportScheduleRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementReportSchedule
func (r *DeviceManagementReportScheduleRequest) Get(ctx context.Context) (resObj *DeviceManagementReportSchedule, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementReportSchedule
func (r *DeviceManagementReportScheduleRequest) Update(ctx context.Context, reqObj *DeviceManagementReportSchedule) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementReportSchedule
func (r *DeviceManagementReportScheduleRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementReportsRequestBuilder is request builder for DeviceManagementReports
type DeviceManagementReportsRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementReportsRequest
func (b *DeviceManagementReportsRequestBuilder) Request() *DeviceManagementReportsRequest {
	return &DeviceManagementReportsRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementReportsRequest is request for DeviceManagementReports
type DeviceManagementReportsRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementReports
func (r *DeviceManagementReportsRequest) Get(ctx context.Context) (resObj *DeviceManagementReports, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementReports
func (r *DeviceManagementReportsRequest) Update(ctx context.Context, reqObj *DeviceManagementReports) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementReports
func (r *DeviceManagementReportsRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementScriptRequestBuilder is request builder for DeviceManagementScript
type DeviceManagementScriptRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementScriptRequest
func (b *DeviceManagementScriptRequestBuilder) Request() *DeviceManagementScriptRequest {
	return &DeviceManagementScriptRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementScriptRequest is request for DeviceManagementScript
type DeviceManagementScriptRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementScript
func (r *DeviceManagementScriptRequest) Get(ctx context.Context) (resObj *DeviceManagementScript, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementScript
func (r *DeviceManagementScriptRequest) Update(ctx context.Context, reqObj *DeviceManagementScript) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementScript
func (r *DeviceManagementScriptRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementScriptAssignmentRequestBuilder is request builder for DeviceManagementScriptAssignment
type DeviceManagementScriptAssignmentRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementScriptAssignmentRequest
func (b *DeviceManagementScriptAssignmentRequestBuilder) Request() *DeviceManagementScriptAssignmentRequest {
	return &DeviceManagementScriptAssignmentRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementScriptAssignmentRequest is request for DeviceManagementScriptAssignment
type DeviceManagementScriptAssignmentRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementScriptAssignment
func (r *DeviceManagementScriptAssignmentRequest) Get(ctx context.Context) (resObj *DeviceManagementScriptAssignment, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementScriptAssignment
func (r *DeviceManagementScriptAssignmentRequest) Update(ctx context.Context, reqObj *DeviceManagementScriptAssignment) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementScriptAssignment
func (r *DeviceManagementScriptAssignmentRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementScriptDeviceStateRequestBuilder is request builder for DeviceManagementScriptDeviceState
type DeviceManagementScriptDeviceStateRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementScriptDeviceStateRequest
func (b *DeviceManagementScriptDeviceStateRequestBuilder) Request() *DeviceManagementScriptDeviceStateRequest {
	return &DeviceManagementScriptDeviceStateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementScriptDeviceStateRequest is request for DeviceManagementScriptDeviceState
type DeviceManagementScriptDeviceStateRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementScriptDeviceState
func (r *DeviceManagementScriptDeviceStateRequest) Get(ctx context.Context) (resObj *DeviceManagementScriptDeviceState, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementScriptDeviceState
func (r *DeviceManagementScriptDeviceStateRequest) Update(ctx context.Context, reqObj *DeviceManagementScriptDeviceState) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementScriptDeviceState
func (r *DeviceManagementScriptDeviceStateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementScriptGroupAssignmentRequestBuilder is request builder for DeviceManagementScriptGroupAssignment
type DeviceManagementScriptGroupAssignmentRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementScriptGroupAssignmentRequest
func (b *DeviceManagementScriptGroupAssignmentRequestBuilder) Request() *DeviceManagementScriptGroupAssignmentRequest {
	return &DeviceManagementScriptGroupAssignmentRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementScriptGroupAssignmentRequest is request for DeviceManagementScriptGroupAssignment
type DeviceManagementScriptGroupAssignmentRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementScriptGroupAssignment
func (r *DeviceManagementScriptGroupAssignmentRequest) Get(ctx context.Context) (resObj *DeviceManagementScriptGroupAssignment, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementScriptGroupAssignment
func (r *DeviceManagementScriptGroupAssignmentRequest) Update(ctx context.Context, reqObj *DeviceManagementScriptGroupAssignment) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementScriptGroupAssignment
func (r *DeviceManagementScriptGroupAssignmentRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementScriptRunSummaryRequestBuilder is request builder for DeviceManagementScriptRunSummary
type DeviceManagementScriptRunSummaryRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementScriptRunSummaryRequest
func (b *DeviceManagementScriptRunSummaryRequestBuilder) Request() *DeviceManagementScriptRunSummaryRequest {
	return &DeviceManagementScriptRunSummaryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementScriptRunSummaryRequest is request for DeviceManagementScriptRunSummary
type DeviceManagementScriptRunSummaryRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementScriptRunSummary
func (r *DeviceManagementScriptRunSummaryRequest) Get(ctx context.Context) (resObj *DeviceManagementScriptRunSummary, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementScriptRunSummary
func (r *DeviceManagementScriptRunSummaryRequest) Update(ctx context.Context, reqObj *DeviceManagementScriptRunSummary) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementScriptRunSummary
func (r *DeviceManagementScriptRunSummaryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementScriptUserStateRequestBuilder is request builder for DeviceManagementScriptUserState
type DeviceManagementScriptUserStateRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementScriptUserStateRequest
func (b *DeviceManagementScriptUserStateRequestBuilder) Request() *DeviceManagementScriptUserStateRequest {
	return &DeviceManagementScriptUserStateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementScriptUserStateRequest is request for DeviceManagementScriptUserState
type DeviceManagementScriptUserStateRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementScriptUserState
func (r *DeviceManagementScriptUserStateRequest) Get(ctx context.Context) (resObj *DeviceManagementScriptUserState, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementScriptUserState
func (r *DeviceManagementScriptUserStateRequest) Update(ctx context.Context, reqObj *DeviceManagementScriptUserState) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementScriptUserState
func (r *DeviceManagementScriptUserStateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementSettingCategoryRequestBuilder is request builder for DeviceManagementSettingCategory
type DeviceManagementSettingCategoryRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementSettingCategoryRequest
func (b *DeviceManagementSettingCategoryRequestBuilder) Request() *DeviceManagementSettingCategoryRequest {
	return &DeviceManagementSettingCategoryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementSettingCategoryRequest is request for DeviceManagementSettingCategory
type DeviceManagementSettingCategoryRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementSettingCategory
func (r *DeviceManagementSettingCategoryRequest) Get(ctx context.Context) (resObj *DeviceManagementSettingCategory, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementSettingCategory
func (r *DeviceManagementSettingCategoryRequest) Update(ctx context.Context, reqObj *DeviceManagementSettingCategory) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementSettingCategory
func (r *DeviceManagementSettingCategoryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementSettingDefinitionRequestBuilder is request builder for DeviceManagementSettingDefinition
type DeviceManagementSettingDefinitionRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementSettingDefinitionRequest
func (b *DeviceManagementSettingDefinitionRequestBuilder) Request() *DeviceManagementSettingDefinitionRequest {
	return &DeviceManagementSettingDefinitionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementSettingDefinitionRequest is request for DeviceManagementSettingDefinition
type DeviceManagementSettingDefinitionRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementSettingDefinition
func (r *DeviceManagementSettingDefinitionRequest) Get(ctx context.Context) (resObj *DeviceManagementSettingDefinition, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementSettingDefinition
func (r *DeviceManagementSettingDefinitionRequest) Update(ctx context.Context, reqObj *DeviceManagementSettingDefinition) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementSettingDefinition
func (r *DeviceManagementSettingDefinitionRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementSettingInstanceRequestBuilder is request builder for DeviceManagementSettingInstance
type DeviceManagementSettingInstanceRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementSettingInstanceRequest
func (b *DeviceManagementSettingInstanceRequestBuilder) Request() *DeviceManagementSettingInstanceRequest {
	return &DeviceManagementSettingInstanceRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementSettingInstanceRequest is request for DeviceManagementSettingInstance
type DeviceManagementSettingInstanceRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementSettingInstance
func (r *DeviceManagementSettingInstanceRequest) Get(ctx context.Context) (resObj *DeviceManagementSettingInstance, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementSettingInstance
func (r *DeviceManagementSettingInstanceRequest) Update(ctx context.Context, reqObj *DeviceManagementSettingInstance) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementSettingInstance
func (r *DeviceManagementSettingInstanceRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementTemplateRequestBuilder is request builder for DeviceManagementTemplate
type DeviceManagementTemplateRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementTemplateRequest
func (b *DeviceManagementTemplateRequestBuilder) Request() *DeviceManagementTemplateRequest {
	return &DeviceManagementTemplateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementTemplateRequest is request for DeviceManagementTemplate
type DeviceManagementTemplateRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementTemplate
func (r *DeviceManagementTemplateRequest) Get(ctx context.Context) (resObj *DeviceManagementTemplate, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementTemplate
func (r *DeviceManagementTemplateRequest) Update(ctx context.Context, reqObj *DeviceManagementTemplate) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementTemplate
func (r *DeviceManagementTemplateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementTemplateSettingCategoryRequestBuilder is request builder for DeviceManagementTemplateSettingCategory
type DeviceManagementTemplateSettingCategoryRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementTemplateSettingCategoryRequest
func (b *DeviceManagementTemplateSettingCategoryRequestBuilder) Request() *DeviceManagementTemplateSettingCategoryRequest {
	return &DeviceManagementTemplateSettingCategoryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementTemplateSettingCategoryRequest is request for DeviceManagementTemplateSettingCategory
type DeviceManagementTemplateSettingCategoryRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementTemplateSettingCategory
func (r *DeviceManagementTemplateSettingCategoryRequest) Get(ctx context.Context) (resObj *DeviceManagementTemplateSettingCategory, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementTemplateSettingCategory
func (r *DeviceManagementTemplateSettingCategoryRequest) Update(ctx context.Context, reqObj *DeviceManagementTemplateSettingCategory) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementTemplateSettingCategory
func (r *DeviceManagementTemplateSettingCategoryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DeviceManagementTroubleshootingEventRequestBuilder is request builder for DeviceManagementTroubleshootingEvent
type DeviceManagementTroubleshootingEventRequestBuilder struct{ BaseRequestBuilder }

// Request returns DeviceManagementTroubleshootingEventRequest
func (b *DeviceManagementTroubleshootingEventRequestBuilder) Request() *DeviceManagementTroubleshootingEventRequest {
	return &DeviceManagementTroubleshootingEventRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DeviceManagementTroubleshootingEventRequest is request for DeviceManagementTroubleshootingEvent
type DeviceManagementTroubleshootingEventRequest struct{ BaseRequest }

// Get performs GET request for DeviceManagementTroubleshootingEvent
func (r *DeviceManagementTroubleshootingEventRequest) Get(ctx context.Context) (resObj *DeviceManagementTroubleshootingEvent, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DeviceManagementTroubleshootingEvent
func (r *DeviceManagementTroubleshootingEventRequest) Update(ctx context.Context, reqObj *DeviceManagementTroubleshootingEvent) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DeviceManagementTroubleshootingEvent
func (r *DeviceManagementTroubleshootingEventRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

//
type DeviceCompliancePolicyCollectionHasPayloadLinksRequestBuilder struct{ BaseRequestBuilder }

// HasPayloadLinks action undocumented
func (b *DeviceManagementDeviceCompliancePoliciesCollectionRequestBuilder) HasPayloadLinks(reqObj *DeviceCompliancePolicyCollectionHasPayloadLinksRequestParameter) *DeviceCompliancePolicyCollectionHasPayloadLinksRequestBuilder {
	bb := &DeviceCompliancePolicyCollectionHasPayloadLinksRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/hasPayloadLinks"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceCompliancePolicyCollectionHasPayloadLinksRequest struct{ BaseRequest }

//
func (b *DeviceCompliancePolicyCollectionHasPayloadLinksRequestBuilder) Request() *DeviceCompliancePolicyCollectionHasPayloadLinksRequest {
	return &DeviceCompliancePolicyCollectionHasPayloadLinksRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceCompliancePolicyCollectionHasPayloadLinksRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]HasPayloadLinkResultItem, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []HasPayloadLinkResultItem
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []HasPayloadLinkResultItem
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

//
func (r *DeviceCompliancePolicyCollectionHasPayloadLinksRequest) PostN(ctx context.Context, n int) ([]HasPayloadLinkResultItem, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, n)
}

//
func (r *DeviceCompliancePolicyCollectionHasPayloadLinksRequest) Post(ctx context.Context) ([]HasPayloadLinkResultItem, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, 0)
}

//
type DeviceCompliancePolicyCollectionRefreshDeviceComplianceReportSummarizationRequestBuilder struct{ BaseRequestBuilder }

// RefreshDeviceComplianceReportSummarization action undocumented
func (b *DeviceManagementDeviceCompliancePoliciesCollectionRequestBuilder) RefreshDeviceComplianceReportSummarization(reqObj *DeviceCompliancePolicyCollectionRefreshDeviceComplianceReportSummarizationRequestParameter) *DeviceCompliancePolicyCollectionRefreshDeviceComplianceReportSummarizationRequestBuilder {
	bb := &DeviceCompliancePolicyCollectionRefreshDeviceComplianceReportSummarizationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/refreshDeviceComplianceReportSummarization"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceCompliancePolicyCollectionRefreshDeviceComplianceReportSummarizationRequest struct{ BaseRequest }

//
func (b *DeviceCompliancePolicyCollectionRefreshDeviceComplianceReportSummarizationRequestBuilder) Request() *DeviceCompliancePolicyCollectionRefreshDeviceComplianceReportSummarizationRequest {
	return &DeviceCompliancePolicyCollectionRefreshDeviceComplianceReportSummarizationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceCompliancePolicyCollectionRefreshDeviceComplianceReportSummarizationRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type DeviceConfigurationCollectionHasPayloadLinksRequestBuilder struct{ BaseRequestBuilder }

// HasPayloadLinks action undocumented
func (b *DeviceManagementDeviceConfigurationsCollectionRequestBuilder) HasPayloadLinks(reqObj *DeviceConfigurationCollectionHasPayloadLinksRequestParameter) *DeviceConfigurationCollectionHasPayloadLinksRequestBuilder {
	bb := &DeviceConfigurationCollectionHasPayloadLinksRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/hasPayloadLinks"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// HasPayloadLinks action undocumented
func (b *WindowsDomainJoinConfigurationNetworkAccessConfigurationsCollectionRequestBuilder) HasPayloadLinks(reqObj *DeviceConfigurationCollectionHasPayloadLinksRequestParameter) *DeviceConfigurationCollectionHasPayloadLinksRequestBuilder {
	bb := &DeviceConfigurationCollectionHasPayloadLinksRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/hasPayloadLinks"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceConfigurationCollectionHasPayloadLinksRequest struct{ BaseRequest }

//
func (b *DeviceConfigurationCollectionHasPayloadLinksRequestBuilder) Request() *DeviceConfigurationCollectionHasPayloadLinksRequest {
	return &DeviceConfigurationCollectionHasPayloadLinksRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceConfigurationCollectionHasPayloadLinksRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]HasPayloadLinkResultItem, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []HasPayloadLinkResultItem
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []HasPayloadLinkResultItem
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

//
func (r *DeviceConfigurationCollectionHasPayloadLinksRequest) PostN(ctx context.Context, n int) ([]HasPayloadLinkResultItem, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, n)
}

//
func (r *DeviceConfigurationCollectionHasPayloadLinksRequest) Post(ctx context.Context) ([]HasPayloadLinkResultItem, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, 0)
}

//
type DeviceConfigurationCollectionGetTargetedUsersAndDevicesRequestBuilder struct{ BaseRequestBuilder }

// GetTargetedUsersAndDevices action undocumented
func (b *DeviceManagementDeviceConfigurationsCollectionRequestBuilder) GetTargetedUsersAndDevices(reqObj *DeviceConfigurationCollectionGetTargetedUsersAndDevicesRequestParameter) *DeviceConfigurationCollectionGetTargetedUsersAndDevicesRequestBuilder {
	bb := &DeviceConfigurationCollectionGetTargetedUsersAndDevicesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getTargetedUsersAndDevices"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetTargetedUsersAndDevices action undocumented
func (b *WindowsDomainJoinConfigurationNetworkAccessConfigurationsCollectionRequestBuilder) GetTargetedUsersAndDevices(reqObj *DeviceConfigurationCollectionGetTargetedUsersAndDevicesRequestParameter) *DeviceConfigurationCollectionGetTargetedUsersAndDevicesRequestBuilder {
	bb := &DeviceConfigurationCollectionGetTargetedUsersAndDevicesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getTargetedUsersAndDevices"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceConfigurationCollectionGetTargetedUsersAndDevicesRequest struct{ BaseRequest }

//
func (b *DeviceConfigurationCollectionGetTargetedUsersAndDevicesRequestBuilder) Request() *DeviceConfigurationCollectionGetTargetedUsersAndDevicesRequest {
	return &DeviceConfigurationCollectionGetTargetedUsersAndDevicesRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceConfigurationCollectionGetTargetedUsersAndDevicesRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DeviceConfigurationTargetedUserAndDevice, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DeviceConfigurationTargetedUserAndDevice
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DeviceConfigurationTargetedUserAndDevice
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

//
func (r *DeviceConfigurationCollectionGetTargetedUsersAndDevicesRequest) PostN(ctx context.Context, n int) ([]DeviceConfigurationTargetedUserAndDevice, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, n)
}

//
func (r *DeviceConfigurationCollectionGetTargetedUsersAndDevicesRequest) Post(ctx context.Context) ([]DeviceConfigurationTargetedUserAndDevice, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, 0)
}

//
type DeviceEnrollmentConfigurationCollectionHasPayloadLinksRequestBuilder struct{ BaseRequestBuilder }

// HasPayloadLinks action undocumented
func (b *DeviceManagementDeviceEnrollmentConfigurationsCollectionRequestBuilder) HasPayloadLinks(reqObj *DeviceEnrollmentConfigurationCollectionHasPayloadLinksRequestParameter) *DeviceEnrollmentConfigurationCollectionHasPayloadLinksRequestBuilder {
	bb := &DeviceEnrollmentConfigurationCollectionHasPayloadLinksRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/hasPayloadLinks"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// HasPayloadLinks action undocumented
func (b *UserDeviceEnrollmentConfigurationsCollectionRequestBuilder) HasPayloadLinks(reqObj *DeviceEnrollmentConfigurationCollectionHasPayloadLinksRequestParameter) *DeviceEnrollmentConfigurationCollectionHasPayloadLinksRequestBuilder {
	bb := &DeviceEnrollmentConfigurationCollectionHasPayloadLinksRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/hasPayloadLinks"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceEnrollmentConfigurationCollectionHasPayloadLinksRequest struct{ BaseRequest }

//
func (b *DeviceEnrollmentConfigurationCollectionHasPayloadLinksRequestBuilder) Request() *DeviceEnrollmentConfigurationCollectionHasPayloadLinksRequest {
	return &DeviceEnrollmentConfigurationCollectionHasPayloadLinksRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceEnrollmentConfigurationCollectionHasPayloadLinksRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]HasPayloadLinkResultItem, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []HasPayloadLinkResultItem
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []HasPayloadLinkResultItem
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

//
func (r *DeviceEnrollmentConfigurationCollectionHasPayloadLinksRequest) PostN(ctx context.Context, n int) ([]HasPayloadLinkResultItem, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, n)
}

//
func (r *DeviceEnrollmentConfigurationCollectionHasPayloadLinksRequest) Post(ctx context.Context) ([]HasPayloadLinkResultItem, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, 0)
}

//
type DeviceManagementScriptCollectionHasPayloadLinksRequestBuilder struct{ BaseRequestBuilder }

// HasPayloadLinks action undocumented
func (b *DeviceManagementDeviceManagementScriptsCollectionRequestBuilder) HasPayloadLinks(reqObj *DeviceManagementScriptCollectionHasPayloadLinksRequestParameter) *DeviceManagementScriptCollectionHasPayloadLinksRequestBuilder {
	bb := &DeviceManagementScriptCollectionHasPayloadLinksRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/hasPayloadLinks"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceManagementScriptCollectionHasPayloadLinksRequest struct{ BaseRequest }

//
func (b *DeviceManagementScriptCollectionHasPayloadLinksRequestBuilder) Request() *DeviceManagementScriptCollectionHasPayloadLinksRequest {
	return &DeviceManagementScriptCollectionHasPayloadLinksRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceManagementScriptCollectionHasPayloadLinksRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]HasPayloadLinkResultItem, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []HasPayloadLinkResultItem
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []HasPayloadLinkResultItem
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

//
func (r *DeviceManagementScriptCollectionHasPayloadLinksRequest) PostN(ctx context.Context, n int) ([]HasPayloadLinkResultItem, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, n)
}

//
func (r *DeviceManagementScriptCollectionHasPayloadLinksRequest) Post(ctx context.Context) ([]HasPayloadLinkResultItem, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, 0)
}

//
type DeviceAppManagementSyncMicrosoftStoreForBusinessAppsRequestBuilder struct{ BaseRequestBuilder }

// SyncMicrosoftStoreForBusinessApps action undocumented
func (b *DeviceAppManagementRequestBuilder) SyncMicrosoftStoreForBusinessApps(reqObj *DeviceAppManagementSyncMicrosoftStoreForBusinessAppsRequestParameter) *DeviceAppManagementSyncMicrosoftStoreForBusinessAppsRequestBuilder {
	bb := &DeviceAppManagementSyncMicrosoftStoreForBusinessAppsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/syncMicrosoftStoreForBusinessApps"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceAppManagementSyncMicrosoftStoreForBusinessAppsRequest struct{ BaseRequest }

//
func (b *DeviceAppManagementSyncMicrosoftStoreForBusinessAppsRequestBuilder) Request() *DeviceAppManagementSyncMicrosoftStoreForBusinessAppsRequest {
	return &DeviceAppManagementSyncMicrosoftStoreForBusinessAppsRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceAppManagementSyncMicrosoftStoreForBusinessAppsRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type DeviceAppManagementTaskUpdateStatusRequestBuilder struct{ BaseRequestBuilder }

// UpdateStatus action undocumented
func (b *DeviceAppManagementTaskRequestBuilder) UpdateStatus(reqObj *DeviceAppManagementTaskUpdateStatusRequestParameter) *DeviceAppManagementTaskUpdateStatusRequestBuilder {
	bb := &DeviceAppManagementTaskUpdateStatusRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/updateStatus"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceAppManagementTaskUpdateStatusRequest struct{ BaseRequest }

//
func (b *DeviceAppManagementTaskUpdateStatusRequestBuilder) Request() *DeviceAppManagementTaskUpdateStatusRequest {
	return &DeviceAppManagementTaskUpdateStatusRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceAppManagementTaskUpdateStatusRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type DeviceCompliancePolicyAssignRequestBuilder struct{ BaseRequestBuilder }

// Assign action undocumented
func (b *DeviceCompliancePolicyRequestBuilder) Assign(reqObj *DeviceCompliancePolicyAssignRequestParameter) *DeviceCompliancePolicyAssignRequestBuilder {
	bb := &DeviceCompliancePolicyAssignRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/assign"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceCompliancePolicyAssignRequest struct{ BaseRequest }

//
func (b *DeviceCompliancePolicyAssignRequestBuilder) Request() *DeviceCompliancePolicyAssignRequest {
	return &DeviceCompliancePolicyAssignRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceCompliancePolicyAssignRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DeviceCompliancePolicyAssignment, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DeviceCompliancePolicyAssignment
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DeviceCompliancePolicyAssignment
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

//
func (r *DeviceCompliancePolicyAssignRequest) PostN(ctx context.Context, n int) ([]DeviceCompliancePolicyAssignment, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, n)
}

//
func (r *DeviceCompliancePolicyAssignRequest) Post(ctx context.Context) ([]DeviceCompliancePolicyAssignment, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, 0)
}

//
type DeviceCompliancePolicyScheduleActionsForRulesRequestBuilder struct{ BaseRequestBuilder }

// ScheduleActionsForRules action undocumented
func (b *DeviceCompliancePolicyRequestBuilder) ScheduleActionsForRules(reqObj *DeviceCompliancePolicyScheduleActionsForRulesRequestParameter) *DeviceCompliancePolicyScheduleActionsForRulesRequestBuilder {
	bb := &DeviceCompliancePolicyScheduleActionsForRulesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/scheduleActionsForRules"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceCompliancePolicyScheduleActionsForRulesRequest struct{ BaseRequest }

//
func (b *DeviceCompliancePolicyScheduleActionsForRulesRequestBuilder) Request() *DeviceCompliancePolicyScheduleActionsForRulesRequest {
	return &DeviceCompliancePolicyScheduleActionsForRulesRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceCompliancePolicyScheduleActionsForRulesRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type DeviceConfigurationAssignRequestBuilder struct{ BaseRequestBuilder }

// Assign action undocumented
func (b *DeviceConfigurationRequestBuilder) Assign(reqObj *DeviceConfigurationAssignRequestParameter) *DeviceConfigurationAssignRequestBuilder {
	bb := &DeviceConfigurationAssignRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/assign"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceConfigurationAssignRequest struct{ BaseRequest }

//
func (b *DeviceConfigurationAssignRequestBuilder) Request() *DeviceConfigurationAssignRequest {
	return &DeviceConfigurationAssignRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceConfigurationAssignRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DeviceConfigurationAssignment, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DeviceConfigurationAssignment
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DeviceConfigurationAssignment
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

//
func (r *DeviceConfigurationAssignRequest) PostN(ctx context.Context, n int) ([]DeviceConfigurationAssignment, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, n)
}

//
func (r *DeviceConfigurationAssignRequest) Post(ctx context.Context) ([]DeviceConfigurationAssignment, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, 0)
}

//
type DeviceConfigurationWindowsPrivacyAccessControlsRequestBuilder struct{ BaseRequestBuilder }

// WindowsPrivacyAccessControls action undocumented
func (b *DeviceConfigurationRequestBuilder) WindowsPrivacyAccessControls(reqObj *DeviceConfigurationWindowsPrivacyAccessControlsRequestParameter) *DeviceConfigurationWindowsPrivacyAccessControlsRequestBuilder {
	bb := &DeviceConfigurationWindowsPrivacyAccessControlsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/windowsPrivacyAccessControls"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceConfigurationWindowsPrivacyAccessControlsRequest struct{ BaseRequest }

//
func (b *DeviceConfigurationWindowsPrivacyAccessControlsRequestBuilder) Request() *DeviceConfigurationWindowsPrivacyAccessControlsRequest {
	return &DeviceConfigurationWindowsPrivacyAccessControlsRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceConfigurationWindowsPrivacyAccessControlsRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type DeviceConfigurationAssignedAccessMultiModeProfilesRequestBuilder struct{ BaseRequestBuilder }

// AssignedAccessMultiModeProfiles action undocumented
func (b *DeviceConfigurationRequestBuilder) AssignedAccessMultiModeProfiles(reqObj *DeviceConfigurationAssignedAccessMultiModeProfilesRequestParameter) *DeviceConfigurationAssignedAccessMultiModeProfilesRequestBuilder {
	bb := &DeviceConfigurationAssignedAccessMultiModeProfilesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/assignedAccessMultiModeProfiles"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceConfigurationAssignedAccessMultiModeProfilesRequest struct{ BaseRequest }

//
func (b *DeviceConfigurationAssignedAccessMultiModeProfilesRequestBuilder) Request() *DeviceConfigurationAssignedAccessMultiModeProfilesRequest {
	return &DeviceConfigurationAssignedAccessMultiModeProfilesRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceConfigurationAssignedAccessMultiModeProfilesRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type DeviceEnrollmentConfigurationSetPriorityRequestBuilder struct{ BaseRequestBuilder }

// SetPriority action undocumented
func (b *DeviceEnrollmentConfigurationRequestBuilder) SetPriority(reqObj *DeviceEnrollmentConfigurationSetPriorityRequestParameter) *DeviceEnrollmentConfigurationSetPriorityRequestBuilder {
	bb := &DeviceEnrollmentConfigurationSetPriorityRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/setPriority"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceEnrollmentConfigurationSetPriorityRequest struct{ BaseRequest }

//
func (b *DeviceEnrollmentConfigurationSetPriorityRequestBuilder) Request() *DeviceEnrollmentConfigurationSetPriorityRequest {
	return &DeviceEnrollmentConfigurationSetPriorityRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceEnrollmentConfigurationSetPriorityRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type DeviceEnrollmentConfigurationAssignRequestBuilder struct{ BaseRequestBuilder }

// Assign action undocumented
func (b *DeviceEnrollmentConfigurationRequestBuilder) Assign(reqObj *DeviceEnrollmentConfigurationAssignRequestParameter) *DeviceEnrollmentConfigurationAssignRequestBuilder {
	bb := &DeviceEnrollmentConfigurationAssignRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/assign"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceEnrollmentConfigurationAssignRequest struct{ BaseRequest }

//
func (b *DeviceEnrollmentConfigurationAssignRequestBuilder) Request() *DeviceEnrollmentConfigurationAssignRequest {
	return &DeviceEnrollmentConfigurationAssignRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceEnrollmentConfigurationAssignRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type DeviceHealthScriptAssignRequestBuilder struct{ BaseRequestBuilder }

// Assign action undocumented
func (b *DeviceHealthScriptRequestBuilder) Assign(reqObj *DeviceHealthScriptAssignRequestParameter) *DeviceHealthScriptAssignRequestBuilder {
	bb := &DeviceHealthScriptAssignRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/assign"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceHealthScriptAssignRequest struct{ BaseRequest }

//
func (b *DeviceHealthScriptAssignRequestBuilder) Request() *DeviceHealthScriptAssignRequest {
	return &DeviceHealthScriptAssignRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceHealthScriptAssignRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type DeviceManagementEnableLegacyPcManagementRequestBuilder struct{ BaseRequestBuilder }

// EnableLegacyPcManagement action undocumented
func (b *DeviceManagementRequestBuilder) EnableLegacyPcManagement(reqObj *DeviceManagementEnableLegacyPcManagementRequestParameter) *DeviceManagementEnableLegacyPcManagementRequestBuilder {
	bb := &DeviceManagementEnableLegacyPcManagementRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/enableLegacyPcManagement"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceManagementEnableLegacyPcManagementRequest struct{ BaseRequest }

//
func (b *DeviceManagementEnableLegacyPcManagementRequestBuilder) Request() *DeviceManagementEnableLegacyPcManagementRequest {
	return &DeviceManagementEnableLegacyPcManagementRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceManagementEnableLegacyPcManagementRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type DeviceManagementEnableAndroidDeviceAdministratorEnrollmentRequestBuilder struct{ BaseRequestBuilder }

// EnableAndroidDeviceAdministratorEnrollment action undocumented
func (b *DeviceManagementRequestBuilder) EnableAndroidDeviceAdministratorEnrollment(reqObj *DeviceManagementEnableAndroidDeviceAdministratorEnrollmentRequestParameter) *DeviceManagementEnableAndroidDeviceAdministratorEnrollmentRequestBuilder {
	bb := &DeviceManagementEnableAndroidDeviceAdministratorEnrollmentRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/enableAndroidDeviceAdministratorEnrollment"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceManagementEnableAndroidDeviceAdministratorEnrollmentRequest struct{ BaseRequest }

//
func (b *DeviceManagementEnableAndroidDeviceAdministratorEnrollmentRequestBuilder) Request() *DeviceManagementEnableAndroidDeviceAdministratorEnrollmentRequest {
	return &DeviceManagementEnableAndroidDeviceAdministratorEnrollmentRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceManagementEnableAndroidDeviceAdministratorEnrollmentRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type DeviceManagementSendCustomNotificationToCompanyPortalRequestBuilder struct{ BaseRequestBuilder }

// SendCustomNotificationToCompanyPortal action undocumented
func (b *DeviceManagementRequestBuilder) SendCustomNotificationToCompanyPortal(reqObj *DeviceManagementSendCustomNotificationToCompanyPortalRequestParameter) *DeviceManagementSendCustomNotificationToCompanyPortalRequestBuilder {
	bb := &DeviceManagementSendCustomNotificationToCompanyPortalRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/sendCustomNotificationToCompanyPortal"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceManagementSendCustomNotificationToCompanyPortalRequest struct{ BaseRequest }

//
func (b *DeviceManagementSendCustomNotificationToCompanyPortalRequestBuilder) Request() *DeviceManagementSendCustomNotificationToCompanyPortalRequest {
	return &DeviceManagementSendCustomNotificationToCompanyPortalRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceManagementSendCustomNotificationToCompanyPortalRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type DeviceManagementExchangeConnectorSyncRequestBuilder struct{ BaseRequestBuilder }

// Sync action undocumented
func (b *DeviceManagementExchangeConnectorRequestBuilder) Sync(reqObj *DeviceManagementExchangeConnectorSyncRequestParameter) *DeviceManagementExchangeConnectorSyncRequestBuilder {
	bb := &DeviceManagementExchangeConnectorSyncRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/sync"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceManagementExchangeConnectorSyncRequest struct{ BaseRequest }

//
func (b *DeviceManagementExchangeConnectorSyncRequestBuilder) Request() *DeviceManagementExchangeConnectorSyncRequest {
	return &DeviceManagementExchangeConnectorSyncRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceManagementExchangeConnectorSyncRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type DeviceManagementIntentUpdateSettingsRequestBuilder struct{ BaseRequestBuilder }

// UpdateSettings action undocumented
func (b *DeviceManagementIntentRequestBuilder) UpdateSettings(reqObj *DeviceManagementIntentUpdateSettingsRequestParameter) *DeviceManagementIntentUpdateSettingsRequestBuilder {
	bb := &DeviceManagementIntentUpdateSettingsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/updateSettings"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceManagementIntentUpdateSettingsRequest struct{ BaseRequest }

//
func (b *DeviceManagementIntentUpdateSettingsRequestBuilder) Request() *DeviceManagementIntentUpdateSettingsRequest {
	return &DeviceManagementIntentUpdateSettingsRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceManagementIntentUpdateSettingsRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type DeviceManagementIntentMigrateToTemplateRequestBuilder struct{ BaseRequestBuilder }

// MigrateToTemplate action undocumented
func (b *DeviceManagementIntentRequestBuilder) MigrateToTemplate(reqObj *DeviceManagementIntentMigrateToTemplateRequestParameter) *DeviceManagementIntentMigrateToTemplateRequestBuilder {
	bb := &DeviceManagementIntentMigrateToTemplateRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/migrateToTemplate"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceManagementIntentMigrateToTemplateRequest struct{ BaseRequest }

//
func (b *DeviceManagementIntentMigrateToTemplateRequestBuilder) Request() *DeviceManagementIntentMigrateToTemplateRequest {
	return &DeviceManagementIntentMigrateToTemplateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceManagementIntentMigrateToTemplateRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type DeviceManagementIntentAssignRequestBuilder struct{ BaseRequestBuilder }

// Assign action undocumented
func (b *DeviceManagementIntentRequestBuilder) Assign(reqObj *DeviceManagementIntentAssignRequestParameter) *DeviceManagementIntentAssignRequestBuilder {
	bb := &DeviceManagementIntentAssignRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/assign"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceManagementIntentAssignRequest struct{ BaseRequest }

//
func (b *DeviceManagementIntentAssignRequestBuilder) Request() *DeviceManagementIntentAssignRequest {
	return &DeviceManagementIntentAssignRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceManagementIntentAssignRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type DeviceManagementReportsGetDeviceNonComplianceReportRequestBuilder struct{ BaseRequestBuilder }

// GetDeviceNonComplianceReport action undocumented
func (b *DeviceManagementReportsRequestBuilder) GetDeviceNonComplianceReport(reqObj *DeviceManagementReportsGetDeviceNonComplianceReportRequestParameter) *DeviceManagementReportsGetDeviceNonComplianceReportRequestBuilder {
	bb := &DeviceManagementReportsGetDeviceNonComplianceReportRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getDeviceNonComplianceReport"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceManagementReportsGetDeviceNonComplianceReportRequest struct{ BaseRequest }

//
func (b *DeviceManagementReportsGetDeviceNonComplianceReportRequestBuilder) Request() *DeviceManagementReportsGetDeviceNonComplianceReportRequest {
	return &DeviceManagementReportsGetDeviceNonComplianceReportRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceManagementReportsGetDeviceNonComplianceReportRequest) Post(ctx context.Context) (resObj *Stream, err error) {
	err = r.JSONRequest(ctx, "POST", "", r.requestObject, &resObj)
	return
}

//
type DeviceManagementReportsGetPolicyNonComplianceReportRequestBuilder struct{ BaseRequestBuilder }

// GetPolicyNonComplianceReport action undocumented
func (b *DeviceManagementReportsRequestBuilder) GetPolicyNonComplianceReport(reqObj *DeviceManagementReportsGetPolicyNonComplianceReportRequestParameter) *DeviceManagementReportsGetPolicyNonComplianceReportRequestBuilder {
	bb := &DeviceManagementReportsGetPolicyNonComplianceReportRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getPolicyNonComplianceReport"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceManagementReportsGetPolicyNonComplianceReportRequest struct{ BaseRequest }

//
func (b *DeviceManagementReportsGetPolicyNonComplianceReportRequestBuilder) Request() *DeviceManagementReportsGetPolicyNonComplianceReportRequest {
	return &DeviceManagementReportsGetPolicyNonComplianceReportRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceManagementReportsGetPolicyNonComplianceReportRequest) Post(ctx context.Context) (resObj *Stream, err error) {
	err = r.JSONRequest(ctx, "POST", "", r.requestObject, &resObj)
	return
}

//
type DeviceManagementReportsGetPolicyNonComplianceMetadataRequestBuilder struct{ BaseRequestBuilder }

// GetPolicyNonComplianceMetadata action undocumented
func (b *DeviceManagementReportsRequestBuilder) GetPolicyNonComplianceMetadata(reqObj *DeviceManagementReportsGetPolicyNonComplianceMetadataRequestParameter) *DeviceManagementReportsGetPolicyNonComplianceMetadataRequestBuilder {
	bb := &DeviceManagementReportsGetPolicyNonComplianceMetadataRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getPolicyNonComplianceMetadata"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceManagementReportsGetPolicyNonComplianceMetadataRequest struct{ BaseRequest }

//
func (b *DeviceManagementReportsGetPolicyNonComplianceMetadataRequestBuilder) Request() *DeviceManagementReportsGetPolicyNonComplianceMetadataRequest {
	return &DeviceManagementReportsGetPolicyNonComplianceMetadataRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceManagementReportsGetPolicyNonComplianceMetadataRequest) Post(ctx context.Context) (resObj *Stream, err error) {
	err = r.JSONRequest(ctx, "POST", "", r.requestObject, &resObj)
	return
}

//
type DeviceManagementReportsGetHistoricalReportRequestBuilder struct{ BaseRequestBuilder }

// GetHistoricalReport action undocumented
func (b *DeviceManagementReportsRequestBuilder) GetHistoricalReport(reqObj *DeviceManagementReportsGetHistoricalReportRequestParameter) *DeviceManagementReportsGetHistoricalReportRequestBuilder {
	bb := &DeviceManagementReportsGetHistoricalReportRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getHistoricalReport"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceManagementReportsGetHistoricalReportRequest struct{ BaseRequest }

//
func (b *DeviceManagementReportsGetHistoricalReportRequestBuilder) Request() *DeviceManagementReportsGetHistoricalReportRequest {
	return &DeviceManagementReportsGetHistoricalReportRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceManagementReportsGetHistoricalReportRequest) Post(ctx context.Context) (resObj *Stream, err error) {
	err = r.JSONRequest(ctx, "POST", "", r.requestObject, &resObj)
	return
}

//
type DeviceManagementReportsGetCachedReportRequestBuilder struct{ BaseRequestBuilder }

// GetCachedReport action undocumented
func (b *DeviceManagementReportsRequestBuilder) GetCachedReport(reqObj *DeviceManagementReportsGetCachedReportRequestParameter) *DeviceManagementReportsGetCachedReportRequestBuilder {
	bb := &DeviceManagementReportsGetCachedReportRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getCachedReport"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceManagementReportsGetCachedReportRequest struct{ BaseRequest }

//
func (b *DeviceManagementReportsGetCachedReportRequestBuilder) Request() *DeviceManagementReportsGetCachedReportRequest {
	return &DeviceManagementReportsGetCachedReportRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceManagementReportsGetCachedReportRequest) Post(ctx context.Context) (resObj *Stream, err error) {
	err = r.JSONRequest(ctx, "POST", "", r.requestObject, &resObj)
	return
}

//
type DeviceManagementScriptAssignRequestBuilder struct{ BaseRequestBuilder }

// Assign action undocumented
func (b *DeviceManagementScriptRequestBuilder) Assign(reqObj *DeviceManagementScriptAssignRequestParameter) *DeviceManagementScriptAssignRequestBuilder {
	bb := &DeviceManagementScriptAssignRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/assign"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceManagementScriptAssignRequest struct{ BaseRequest }

//
func (b *DeviceManagementScriptAssignRequestBuilder) Request() *DeviceManagementScriptAssignRequest {
	return &DeviceManagementScriptAssignRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceManagementScriptAssignRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type DeviceManagementTemplateCreateInstanceRequestBuilder struct{ BaseRequestBuilder }

// CreateInstance action undocumented
func (b *DeviceManagementTemplateRequestBuilder) CreateInstance(reqObj *DeviceManagementTemplateCreateInstanceRequestParameter) *DeviceManagementTemplateCreateInstanceRequestBuilder {
	bb := &DeviceManagementTemplateCreateInstanceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/createInstance"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DeviceManagementTemplateCreateInstanceRequest struct{ BaseRequest }

//
func (b *DeviceManagementTemplateCreateInstanceRequestBuilder) Request() *DeviceManagementTemplateCreateInstanceRequest {
	return &DeviceManagementTemplateCreateInstanceRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DeviceManagementTemplateCreateInstanceRequest) Post(ctx context.Context) (resObj *DeviceManagementIntent, err error) {
	err = r.JSONRequest(ctx, "POST", "", r.requestObject, &resObj)
	return
}
