// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import (
	"context"
	"fmt"
	"io/ioutil"
	"net/http"

	"github.com/yaegashi/msgraph.go/jsonx"
)

// DirectoryRequestBuilder is request builder for Directory
type DirectoryRequestBuilder struct{ BaseRequestBuilder }

// Request returns DirectoryRequest
func (b *DirectoryRequestBuilder) Request() *DirectoryRequest {
	return &DirectoryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DirectoryRequest is request for Directory
type DirectoryRequest struct{ BaseRequest }

// Get performs GET request for Directory
func (r *DirectoryRequest) Get(ctx context.Context) (resObj *Directory, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for Directory
func (r *DirectoryRequest) Update(ctx context.Context, reqObj *Directory) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for Directory
func (r *DirectoryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DirectoryAuditRequestBuilder is request builder for DirectoryAudit
type DirectoryAuditRequestBuilder struct{ BaseRequestBuilder }

// Request returns DirectoryAuditRequest
func (b *DirectoryAuditRequestBuilder) Request() *DirectoryAuditRequest {
	return &DirectoryAuditRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DirectoryAuditRequest is request for DirectoryAudit
type DirectoryAuditRequest struct{ BaseRequest }

// Get performs GET request for DirectoryAudit
func (r *DirectoryAuditRequest) Get(ctx context.Context) (resObj *DirectoryAudit, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DirectoryAudit
func (r *DirectoryAuditRequest) Update(ctx context.Context, reqObj *DirectoryAudit) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DirectoryAudit
func (r *DirectoryAuditRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DirectoryDefinitionRequestBuilder is request builder for DirectoryDefinition
type DirectoryDefinitionRequestBuilder struct{ BaseRequestBuilder }

// Request returns DirectoryDefinitionRequest
func (b *DirectoryDefinitionRequestBuilder) Request() *DirectoryDefinitionRequest {
	return &DirectoryDefinitionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DirectoryDefinitionRequest is request for DirectoryDefinition
type DirectoryDefinitionRequest struct{ BaseRequest }

// Get performs GET request for DirectoryDefinition
func (r *DirectoryDefinitionRequest) Get(ctx context.Context) (resObj *DirectoryDefinition, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DirectoryDefinition
func (r *DirectoryDefinitionRequest) Update(ctx context.Context, reqObj *DirectoryDefinition) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DirectoryDefinition
func (r *DirectoryDefinitionRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DirectoryObjectRequestBuilder is request builder for DirectoryObject
type DirectoryObjectRequestBuilder struct{ BaseRequestBuilder }

// Request returns DirectoryObjectRequest
func (b *DirectoryObjectRequestBuilder) Request() *DirectoryObjectRequest {
	return &DirectoryObjectRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DirectoryObjectRequest is request for DirectoryObject
type DirectoryObjectRequest struct{ BaseRequest }

// Get performs GET request for DirectoryObject
func (r *DirectoryObjectRequest) Get(ctx context.Context) (resObj *DirectoryObject, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DirectoryObject
func (r *DirectoryObjectRequest) Update(ctx context.Context, reqObj *DirectoryObject) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DirectoryObject
func (r *DirectoryObjectRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DirectoryRoleRequestBuilder is request builder for DirectoryRole
type DirectoryRoleRequestBuilder struct{ BaseRequestBuilder }

// Request returns DirectoryRoleRequest
func (b *DirectoryRoleRequestBuilder) Request() *DirectoryRoleRequest {
	return &DirectoryRoleRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DirectoryRoleRequest is request for DirectoryRole
type DirectoryRoleRequest struct{ BaseRequest }

// Get performs GET request for DirectoryRole
func (r *DirectoryRoleRequest) Get(ctx context.Context) (resObj *DirectoryRole, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DirectoryRole
func (r *DirectoryRoleRequest) Update(ctx context.Context, reqObj *DirectoryRole) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DirectoryRole
func (r *DirectoryRoleRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DirectoryRoleTemplateRequestBuilder is request builder for DirectoryRoleTemplate
type DirectoryRoleTemplateRequestBuilder struct{ BaseRequestBuilder }

// Request returns DirectoryRoleTemplateRequest
func (b *DirectoryRoleTemplateRequestBuilder) Request() *DirectoryRoleTemplateRequest {
	return &DirectoryRoleTemplateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DirectoryRoleTemplateRequest is request for DirectoryRoleTemplate
type DirectoryRoleTemplateRequest struct{ BaseRequest }

// Get performs GET request for DirectoryRoleTemplate
func (r *DirectoryRoleTemplateRequest) Get(ctx context.Context) (resObj *DirectoryRoleTemplate, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DirectoryRoleTemplate
func (r *DirectoryRoleTemplateRequest) Update(ctx context.Context, reqObj *DirectoryRoleTemplate) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DirectoryRoleTemplate
func (r *DirectoryRoleTemplateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DirectorySettingRequestBuilder is request builder for DirectorySetting
type DirectorySettingRequestBuilder struct{ BaseRequestBuilder }

// Request returns DirectorySettingRequest
func (b *DirectorySettingRequestBuilder) Request() *DirectorySettingRequest {
	return &DirectorySettingRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DirectorySettingRequest is request for DirectorySetting
type DirectorySettingRequest struct{ BaseRequest }

// Get performs GET request for DirectorySetting
func (r *DirectorySettingRequest) Get(ctx context.Context) (resObj *DirectorySetting, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DirectorySetting
func (r *DirectorySettingRequest) Update(ctx context.Context, reqObj *DirectorySetting) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DirectorySetting
func (r *DirectorySettingRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// DirectorySettingTemplateRequestBuilder is request builder for DirectorySettingTemplate
type DirectorySettingTemplateRequestBuilder struct{ BaseRequestBuilder }

// Request returns DirectorySettingTemplateRequest
func (b *DirectorySettingTemplateRequestBuilder) Request() *DirectorySettingTemplateRequest {
	return &DirectorySettingTemplateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// DirectorySettingTemplateRequest is request for DirectorySettingTemplate
type DirectorySettingTemplateRequest struct{ BaseRequest }

// Get performs GET request for DirectorySettingTemplate
func (r *DirectorySettingTemplateRequest) Get(ctx context.Context) (resObj *DirectorySettingTemplate, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for DirectorySettingTemplate
func (r *DirectorySettingTemplateRequest) Update(ctx context.Context, reqObj *DirectorySettingTemplate) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for DirectorySettingTemplate
func (r *DirectorySettingTemplateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

//
type DirectoryObjectCollectionGetByIDsRequestBuilder struct{ BaseRequestBuilder }

// GetByIDs action undocumented
func (b *AdministrativeUnitMembersCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *ApplicationOwnersCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *ApplicationPoliciesCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *DeviceMemberOfCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *DeviceRegisteredOwnersCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *DeviceRegisteredUsersCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *DeviceTransitiveMemberOfCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *DirectoryDeletedItemsCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *DirectoryRoleMembersCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *DomainDomainNameReferencesCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *FeatureRolloutPolicyAppliesToCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *GroupAcceptedSendersCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *GroupMemberOfCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *GroupMembersCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *GroupMembersWithLicenseErrorsCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *GroupOwnersCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *GroupRejectedSendersCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *GroupTransitiveMemberOfCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *GroupTransitiveMembersCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *OrgContactDirectReportsCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *OrgContactMemberOfCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *OrgContactTransitiveMemberOfCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *PolicyAppliesToCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *ServicePrincipalCreatedObjectsCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *ServicePrincipalMemberOfCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *ServicePrincipalOwnedObjectsCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *ServicePrincipalOwnersCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *ServicePrincipalPoliciesCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *ServicePrincipalTransitiveMemberOfCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *UserCreatedObjectsCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *UserDirectReportsCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *UserMemberOfCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *UserOwnedDevicesCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *UserOwnedObjectsCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *UserRegisteredDevicesCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetByIDs action undocumented
func (b *UserTransitiveMemberOfCollectionRequestBuilder) GetByIDs(reqObj *DirectoryObjectCollectionGetByIDsRequestParameter) *DirectoryObjectCollectionGetByIDsRequestBuilder {
	bb := &DirectoryObjectCollectionGetByIDsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getByIds"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DirectoryObjectCollectionGetByIDsRequest struct{ BaseRequest }

//
func (b *DirectoryObjectCollectionGetByIDsRequestBuilder) Request() *DirectoryObjectCollectionGetByIDsRequest {
	return &DirectoryObjectCollectionGetByIDsRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DirectoryObjectCollectionGetByIDsRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DirectoryObject, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DirectoryObject
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DirectoryObject
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

//
func (r *DirectoryObjectCollectionGetByIDsRequest) PostN(ctx context.Context, n int) ([]DirectoryObject, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, n)
}

//
func (r *DirectoryObjectCollectionGetByIDsRequest) Post(ctx context.Context) ([]DirectoryObject, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, 0)
}

//
type DirectoryObjectCollectionValidatePropertiesRequestBuilder struct{ BaseRequestBuilder }

// ValidateProperties action undocumented
func (b *AdministrativeUnitMembersCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *ApplicationOwnersCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *ApplicationPoliciesCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *DeviceMemberOfCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *DeviceRegisteredOwnersCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *DeviceRegisteredUsersCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *DeviceTransitiveMemberOfCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *DirectoryDeletedItemsCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *DirectoryRoleMembersCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *DomainDomainNameReferencesCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *FeatureRolloutPolicyAppliesToCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *GroupAcceptedSendersCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *GroupMemberOfCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *GroupMembersCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *GroupMembersWithLicenseErrorsCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *GroupOwnersCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *GroupRejectedSendersCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *GroupTransitiveMemberOfCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *GroupTransitiveMembersCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *OrgContactDirectReportsCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *OrgContactMemberOfCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *OrgContactTransitiveMemberOfCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *PolicyAppliesToCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *ServicePrincipalCreatedObjectsCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *ServicePrincipalMemberOfCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *ServicePrincipalOwnedObjectsCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *ServicePrincipalOwnersCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *ServicePrincipalPoliciesCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *ServicePrincipalTransitiveMemberOfCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *UserCreatedObjectsCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *UserDirectReportsCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *UserMemberOfCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *UserOwnedDevicesCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *UserOwnedObjectsCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *UserRegisteredDevicesCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// ValidateProperties action undocumented
func (b *UserTransitiveMemberOfCollectionRequestBuilder) ValidateProperties(reqObj *DirectoryObjectCollectionValidatePropertiesRequestParameter) *DirectoryObjectCollectionValidatePropertiesRequestBuilder {
	bb := &DirectoryObjectCollectionValidatePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/validateProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DirectoryObjectCollectionValidatePropertiesRequest struct{ BaseRequest }

//
func (b *DirectoryObjectCollectionValidatePropertiesRequestBuilder) Request() *DirectoryObjectCollectionValidatePropertiesRequest {
	return &DirectoryObjectCollectionValidatePropertiesRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DirectoryObjectCollectionValidatePropertiesRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder struct{ BaseRequestBuilder }

// GetUserOwnedObjects action undocumented
func (b *AdministrativeUnitMembersCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *ApplicationOwnersCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *ApplicationPoliciesCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *DeviceMemberOfCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *DeviceRegisteredOwnersCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *DeviceRegisteredUsersCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *DeviceTransitiveMemberOfCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *DirectoryDeletedItemsCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *DirectoryRoleMembersCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *DomainDomainNameReferencesCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *FeatureRolloutPolicyAppliesToCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *GroupAcceptedSendersCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *GroupMemberOfCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *GroupMembersCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *GroupMembersWithLicenseErrorsCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *GroupOwnersCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *GroupRejectedSendersCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *GroupTransitiveMemberOfCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *GroupTransitiveMembersCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *OrgContactDirectReportsCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *OrgContactMemberOfCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *OrgContactTransitiveMemberOfCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *PolicyAppliesToCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *ServicePrincipalCreatedObjectsCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *ServicePrincipalMemberOfCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *ServicePrincipalOwnedObjectsCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *ServicePrincipalOwnersCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *ServicePrincipalPoliciesCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *ServicePrincipalTransitiveMemberOfCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *UserCreatedObjectsCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *UserDirectReportsCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *UserMemberOfCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *UserOwnedDevicesCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *UserOwnedObjectsCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *UserRegisteredDevicesCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

// GetUserOwnedObjects action undocumented
func (b *UserTransitiveMemberOfCollectionRequestBuilder) GetUserOwnedObjects(reqObj *DirectoryObjectCollectionGetUserOwnedObjectsRequestParameter) *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder {
	bb := &DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getUserOwnedObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DirectoryObjectCollectionGetUserOwnedObjectsRequest struct{ BaseRequest }

//
func (b *DirectoryObjectCollectionGetUserOwnedObjectsRequestBuilder) Request() *DirectoryObjectCollectionGetUserOwnedObjectsRequest {
	return &DirectoryObjectCollectionGetUserOwnedObjectsRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DirectoryObjectCollectionGetUserOwnedObjectsRequest) Post(ctx context.Context) (resObj *DirectoryObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", r.requestObject, &resObj)
	return
}

//
type DirectoryDefinitionDiscoverRequestBuilder struct{ BaseRequestBuilder }

// Discover action undocumented
func (b *DirectoryDefinitionRequestBuilder) Discover(reqObj *DirectoryDefinitionDiscoverRequestParameter) *DirectoryDefinitionDiscoverRequestBuilder {
	bb := &DirectoryDefinitionDiscoverRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/discover"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DirectoryDefinitionDiscoverRequest struct{ BaseRequest }

//
func (b *DirectoryDefinitionDiscoverRequestBuilder) Request() *DirectoryDefinitionDiscoverRequest {
	return &DirectoryDefinitionDiscoverRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DirectoryDefinitionDiscoverRequest) Post(ctx context.Context) (resObj *DirectoryDefinition, err error) {
	err = r.JSONRequest(ctx, "POST", "", r.requestObject, &resObj)
	return
}

//
type DirectoryObjectCheckMemberGroupsRequestBuilder struct{ BaseRequestBuilder }

// CheckMemberGroups action undocumented
func (b *DirectoryObjectRequestBuilder) CheckMemberGroups(reqObj *DirectoryObjectCheckMemberGroupsRequestParameter) *DirectoryObjectCheckMemberGroupsRequestBuilder {
	bb := &DirectoryObjectCheckMemberGroupsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/checkMemberGroups"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DirectoryObjectCheckMemberGroupsRequest struct{ BaseRequest }

//
func (b *DirectoryObjectCheckMemberGroupsRequestBuilder) Request() *DirectoryObjectCheckMemberGroupsRequest {
	return &DirectoryObjectCheckMemberGroupsRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DirectoryObjectCheckMemberGroupsRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]string, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []string
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []string
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

//
func (r *DirectoryObjectCheckMemberGroupsRequest) PostN(ctx context.Context, n int) ([]string, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, n)
}

//
func (r *DirectoryObjectCheckMemberGroupsRequest) Post(ctx context.Context) ([]string, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, 0)
}

//
type DirectoryObjectCheckMemberObjectsRequestBuilder struct{ BaseRequestBuilder }

// CheckMemberObjects action undocumented
func (b *DirectoryObjectRequestBuilder) CheckMemberObjects(reqObj *DirectoryObjectCheckMemberObjectsRequestParameter) *DirectoryObjectCheckMemberObjectsRequestBuilder {
	bb := &DirectoryObjectCheckMemberObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/checkMemberObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DirectoryObjectCheckMemberObjectsRequest struct{ BaseRequest }

//
func (b *DirectoryObjectCheckMemberObjectsRequestBuilder) Request() *DirectoryObjectCheckMemberObjectsRequest {
	return &DirectoryObjectCheckMemberObjectsRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DirectoryObjectCheckMemberObjectsRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]string, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []string
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []string
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

//
func (r *DirectoryObjectCheckMemberObjectsRequest) PostN(ctx context.Context, n int) ([]string, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, n)
}

//
func (r *DirectoryObjectCheckMemberObjectsRequest) Post(ctx context.Context) ([]string, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, 0)
}

//
type DirectoryObjectGetMemberGroupsRequestBuilder struct{ BaseRequestBuilder }

// GetMemberGroups action undocumented
func (b *DirectoryObjectRequestBuilder) GetMemberGroups(reqObj *DirectoryObjectGetMemberGroupsRequestParameter) *DirectoryObjectGetMemberGroupsRequestBuilder {
	bb := &DirectoryObjectGetMemberGroupsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getMemberGroups"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DirectoryObjectGetMemberGroupsRequest struct{ BaseRequest }

//
func (b *DirectoryObjectGetMemberGroupsRequestBuilder) Request() *DirectoryObjectGetMemberGroupsRequest {
	return &DirectoryObjectGetMemberGroupsRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DirectoryObjectGetMemberGroupsRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]string, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []string
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []string
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

//
func (r *DirectoryObjectGetMemberGroupsRequest) PostN(ctx context.Context, n int) ([]string, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, n)
}

//
func (r *DirectoryObjectGetMemberGroupsRequest) Post(ctx context.Context) ([]string, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, 0)
}

//
type DirectoryObjectGetMemberObjectsRequestBuilder struct{ BaseRequestBuilder }

// GetMemberObjects action undocumented
func (b *DirectoryObjectRequestBuilder) GetMemberObjects(reqObj *DirectoryObjectGetMemberObjectsRequestParameter) *DirectoryObjectGetMemberObjectsRequestBuilder {
	bb := &DirectoryObjectGetMemberObjectsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/getMemberObjects"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DirectoryObjectGetMemberObjectsRequest struct{ BaseRequest }

//
func (b *DirectoryObjectGetMemberObjectsRequestBuilder) Request() *DirectoryObjectGetMemberObjectsRequest {
	return &DirectoryObjectGetMemberObjectsRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DirectoryObjectGetMemberObjectsRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]string, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []string
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []string
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

//
func (r *DirectoryObjectGetMemberObjectsRequest) PostN(ctx context.Context, n int) ([]string, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, n)
}

//
func (r *DirectoryObjectGetMemberObjectsRequest) Post(ctx context.Context) ([]string, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, 0)
}

//
type DirectoryObjectRestoreRequestBuilder struct{ BaseRequestBuilder }

// Restore action undocumented
func (b *DirectoryObjectRequestBuilder) Restore(reqObj *DirectoryObjectRestoreRequestParameter) *DirectoryObjectRestoreRequestBuilder {
	bb := &DirectoryObjectRestoreRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/restore"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type DirectoryObjectRestoreRequest struct{ BaseRequest }

//
func (b *DirectoryObjectRestoreRequestBuilder) Request() *DirectoryObjectRestoreRequest {
	return &DirectoryObjectRestoreRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *DirectoryObjectRestoreRequest) Post(ctx context.Context) (resObj *DirectoryObject, err error) {
	err = r.JSONRequest(ctx, "POST", "", r.requestObject, &resObj)
	return
}
