// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import "context"

// MessageRequestBuilder is request builder for Message
type MessageRequestBuilder struct{ BaseRequestBuilder }

// Request returns MessageRequest
func (b *MessageRequestBuilder) Request() *MessageRequest {
	return &MessageRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// MessageRequest is request for Message
type MessageRequest struct{ BaseRequest }

// Get performs GET request for Message
func (r *MessageRequest) Get(ctx context.Context) (resObj *Message, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for Message
func (r *MessageRequest) Update(ctx context.Context, reqObj *Message) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for Message
func (r *MessageRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// MessageRuleRequestBuilder is request builder for MessageRule
type MessageRuleRequestBuilder struct{ BaseRequestBuilder }

// Request returns MessageRuleRequest
func (b *MessageRuleRequestBuilder) Request() *MessageRuleRequest {
	return &MessageRuleRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// MessageRuleRequest is request for MessageRule
type MessageRuleRequest struct{ BaseRequest }

// Get performs GET request for MessageRule
func (r *MessageRuleRequest) Get(ctx context.Context) (resObj *MessageRule, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for MessageRule
func (r *MessageRuleRequest) Update(ctx context.Context, reqObj *MessageRule) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for MessageRule
func (r *MessageRuleRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

//
type MessageCreateReplyRequestBuilder struct{ BaseRequestBuilder }

// CreateReply action undocumented
func (b *MessageRequestBuilder) CreateReply(reqObj *MessageCreateReplyRequestParameter) *MessageCreateReplyRequestBuilder {
	bb := &MessageCreateReplyRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/createReply"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type MessageCreateReplyRequest struct{ BaseRequest }

//
func (b *MessageCreateReplyRequestBuilder) Request() *MessageCreateReplyRequest {
	return &MessageCreateReplyRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *MessageCreateReplyRequest) Post(ctx context.Context) (resObj *Message, err error) {
	err = r.JSONRequest(ctx, "POST", "", r.requestObject, &resObj)
	return
}

//
type MessageCreateReplyAllRequestBuilder struct{ BaseRequestBuilder }

// CreateReplyAll action undocumented
func (b *MessageRequestBuilder) CreateReplyAll(reqObj *MessageCreateReplyAllRequestParameter) *MessageCreateReplyAllRequestBuilder {
	bb := &MessageCreateReplyAllRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/createReplyAll"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type MessageCreateReplyAllRequest struct{ BaseRequest }

//
func (b *MessageCreateReplyAllRequestBuilder) Request() *MessageCreateReplyAllRequest {
	return &MessageCreateReplyAllRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *MessageCreateReplyAllRequest) Post(ctx context.Context) (resObj *Message, err error) {
	err = r.JSONRequest(ctx, "POST", "", r.requestObject, &resObj)
	return
}

//
type MessageCreateForwardRequestBuilder struct{ BaseRequestBuilder }

// CreateForward action undocumented
func (b *MessageRequestBuilder) CreateForward(reqObj *MessageCreateForwardRequestParameter) *MessageCreateForwardRequestBuilder {
	bb := &MessageCreateForwardRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/createForward"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type MessageCreateForwardRequest struct{ BaseRequest }

//
func (b *MessageCreateForwardRequestBuilder) Request() *MessageCreateForwardRequest {
	return &MessageCreateForwardRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *MessageCreateForwardRequest) Post(ctx context.Context) (resObj *Message, err error) {
	err = r.JSONRequest(ctx, "POST", "", r.requestObject, &resObj)
	return
}

//
type MessageSendRequestBuilder struct{ BaseRequestBuilder }

// Send action undocumented
func (b *MessageRequestBuilder) Send(reqObj *MessageSendRequestParameter) *MessageSendRequestBuilder {
	bb := &MessageSendRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/send"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type MessageSendRequest struct{ BaseRequest }

//
func (b *MessageSendRequestBuilder) Request() *MessageSendRequest {
	return &MessageSendRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *MessageSendRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type MessageCopyRequestBuilder struct{ BaseRequestBuilder }

// Copy action undocumented
func (b *MessageRequestBuilder) Copy(reqObj *MessageCopyRequestParameter) *MessageCopyRequestBuilder {
	bb := &MessageCopyRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/copy"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type MessageCopyRequest struct{ BaseRequest }

//
func (b *MessageCopyRequestBuilder) Request() *MessageCopyRequest {
	return &MessageCopyRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *MessageCopyRequest) Post(ctx context.Context) (resObj *Message, err error) {
	err = r.JSONRequest(ctx, "POST", "", r.requestObject, &resObj)
	return
}

//
type MessageMoveRequestBuilder struct{ BaseRequestBuilder }

// Move action undocumented
func (b *MessageRequestBuilder) Move(reqObj *MessageMoveRequestParameter) *MessageMoveRequestBuilder {
	bb := &MessageMoveRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/move"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type MessageMoveRequest struct{ BaseRequest }

//
func (b *MessageMoveRequestBuilder) Request() *MessageMoveRequest {
	return &MessageMoveRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *MessageMoveRequest) Post(ctx context.Context) (resObj *Message, err error) {
	err = r.JSONRequest(ctx, "POST", "", r.requestObject, &resObj)
	return
}

//
type MessageReplyRequestBuilder struct{ BaseRequestBuilder }

// Reply action undocumented
func (b *MessageRequestBuilder) Reply(reqObj *MessageReplyRequestParameter) *MessageReplyRequestBuilder {
	bb := &MessageReplyRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/reply"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type MessageReplyRequest struct{ BaseRequest }

//
func (b *MessageReplyRequestBuilder) Request() *MessageReplyRequest {
	return &MessageReplyRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *MessageReplyRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type MessageReplyAllRequestBuilder struct{ BaseRequestBuilder }

// ReplyAll action undocumented
func (b *MessageRequestBuilder) ReplyAll(reqObj *MessageReplyAllRequestParameter) *MessageReplyAllRequestBuilder {
	bb := &MessageReplyAllRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/replyAll"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type MessageReplyAllRequest struct{ BaseRequest }

//
func (b *MessageReplyAllRequestBuilder) Request() *MessageReplyAllRequest {
	return &MessageReplyAllRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *MessageReplyAllRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type MessageForwardRequestBuilder struct{ BaseRequestBuilder }

// Forward action undocumented
func (b *MessageRequestBuilder) Forward(reqObj *MessageForwardRequestParameter) *MessageForwardRequestBuilder {
	bb := &MessageForwardRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/forward"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type MessageForwardRequest struct{ BaseRequest }

//
func (b *MessageForwardRequestBuilder) Request() *MessageForwardRequest {
	return &MessageForwardRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *MessageForwardRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type MessageUnsubscribeRequestBuilder struct{ BaseRequestBuilder }

// Unsubscribe action undocumented
func (b *MessageRequestBuilder) Unsubscribe(reqObj *MessageUnsubscribeRequestParameter) *MessageUnsubscribeRequestBuilder {
	bb := &MessageUnsubscribeRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/unsubscribe"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type MessageUnsubscribeRequest struct{ BaseRequest }

//
func (b *MessageUnsubscribeRequestBuilder) Request() *MessageUnsubscribeRequest {
	return &MessageUnsubscribeRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *MessageUnsubscribeRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}
