// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import (
	"context"
	"fmt"
	"io/ioutil"
	"net/http"

	"github.com/yaegashi/msgraph.go/jsonx"
)

// MobileAppRequestBuilder is request builder for MobileApp
type MobileAppRequestBuilder struct{ BaseRequestBuilder }

// Request returns MobileAppRequest
func (b *MobileAppRequestBuilder) Request() *MobileAppRequest {
	return &MobileAppRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// MobileAppRequest is request for MobileApp
type MobileAppRequest struct{ BaseRequest }

// Get performs GET request for MobileApp
func (r *MobileAppRequest) Get(ctx context.Context) (resObj *MobileApp, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for MobileApp
func (r *MobileAppRequest) Update(ctx context.Context, reqObj *MobileApp) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for MobileApp
func (r *MobileAppRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// MobileAppAssignmentRequestBuilder is request builder for MobileAppAssignment
type MobileAppAssignmentRequestBuilder struct{ BaseRequestBuilder }

// Request returns MobileAppAssignmentRequest
func (b *MobileAppAssignmentRequestBuilder) Request() *MobileAppAssignmentRequest {
	return &MobileAppAssignmentRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// MobileAppAssignmentRequest is request for MobileAppAssignment
type MobileAppAssignmentRequest struct{ BaseRequest }

// Get performs GET request for MobileAppAssignment
func (r *MobileAppAssignmentRequest) Get(ctx context.Context) (resObj *MobileAppAssignment, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for MobileAppAssignment
func (r *MobileAppAssignmentRequest) Update(ctx context.Context, reqObj *MobileAppAssignment) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for MobileAppAssignment
func (r *MobileAppAssignmentRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// MobileAppCategoryRequestBuilder is request builder for MobileAppCategory
type MobileAppCategoryRequestBuilder struct{ BaseRequestBuilder }

// Request returns MobileAppCategoryRequest
func (b *MobileAppCategoryRequestBuilder) Request() *MobileAppCategoryRequest {
	return &MobileAppCategoryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// MobileAppCategoryRequest is request for MobileAppCategory
type MobileAppCategoryRequest struct{ BaseRequest }

// Get performs GET request for MobileAppCategory
func (r *MobileAppCategoryRequest) Get(ctx context.Context) (resObj *MobileAppCategory, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for MobileAppCategory
func (r *MobileAppCategoryRequest) Update(ctx context.Context, reqObj *MobileAppCategory) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for MobileAppCategory
func (r *MobileAppCategoryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// MobileAppContentRequestBuilder is request builder for MobileAppContent
type MobileAppContentRequestBuilder struct{ BaseRequestBuilder }

// Request returns MobileAppContentRequest
func (b *MobileAppContentRequestBuilder) Request() *MobileAppContentRequest {
	return &MobileAppContentRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// MobileAppContentRequest is request for MobileAppContent
type MobileAppContentRequest struct{ BaseRequest }

// Get performs GET request for MobileAppContent
func (r *MobileAppContentRequest) Get(ctx context.Context) (resObj *MobileAppContent, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for MobileAppContent
func (r *MobileAppContentRequest) Update(ctx context.Context, reqObj *MobileAppContent) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for MobileAppContent
func (r *MobileAppContentRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// MobileAppContentFileRequestBuilder is request builder for MobileAppContentFile
type MobileAppContentFileRequestBuilder struct{ BaseRequestBuilder }

// Request returns MobileAppContentFileRequest
func (b *MobileAppContentFileRequestBuilder) Request() *MobileAppContentFileRequest {
	return &MobileAppContentFileRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// MobileAppContentFileRequest is request for MobileAppContentFile
type MobileAppContentFileRequest struct{ BaseRequest }

// Get performs GET request for MobileAppContentFile
func (r *MobileAppContentFileRequest) Get(ctx context.Context) (resObj *MobileAppContentFile, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for MobileAppContentFile
func (r *MobileAppContentFileRequest) Update(ctx context.Context, reqObj *MobileAppContentFile) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for MobileAppContentFile
func (r *MobileAppContentFileRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// MobileAppInstallStatusRequestBuilder is request builder for MobileAppInstallStatus
type MobileAppInstallStatusRequestBuilder struct{ BaseRequestBuilder }

// Request returns MobileAppInstallStatusRequest
func (b *MobileAppInstallStatusRequestBuilder) Request() *MobileAppInstallStatusRequest {
	return &MobileAppInstallStatusRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// MobileAppInstallStatusRequest is request for MobileAppInstallStatus
type MobileAppInstallStatusRequest struct{ BaseRequest }

// Get performs GET request for MobileAppInstallStatus
func (r *MobileAppInstallStatusRequest) Get(ctx context.Context) (resObj *MobileAppInstallStatus, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for MobileAppInstallStatus
func (r *MobileAppInstallStatusRequest) Update(ctx context.Context, reqObj *MobileAppInstallStatus) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for MobileAppInstallStatus
func (r *MobileAppInstallStatusRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// MobileAppInstallSummaryRequestBuilder is request builder for MobileAppInstallSummary
type MobileAppInstallSummaryRequestBuilder struct{ BaseRequestBuilder }

// Request returns MobileAppInstallSummaryRequest
func (b *MobileAppInstallSummaryRequestBuilder) Request() *MobileAppInstallSummaryRequest {
	return &MobileAppInstallSummaryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// MobileAppInstallSummaryRequest is request for MobileAppInstallSummary
type MobileAppInstallSummaryRequest struct{ BaseRequest }

// Get performs GET request for MobileAppInstallSummary
func (r *MobileAppInstallSummaryRequest) Get(ctx context.Context) (resObj *MobileAppInstallSummary, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for MobileAppInstallSummary
func (r *MobileAppInstallSummaryRequest) Update(ctx context.Context, reqObj *MobileAppInstallSummary) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for MobileAppInstallSummary
func (r *MobileAppInstallSummaryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// MobileAppIntentAndStateRequestBuilder is request builder for MobileAppIntentAndState
type MobileAppIntentAndStateRequestBuilder struct{ BaseRequestBuilder }

// Request returns MobileAppIntentAndStateRequest
func (b *MobileAppIntentAndStateRequestBuilder) Request() *MobileAppIntentAndStateRequest {
	return &MobileAppIntentAndStateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// MobileAppIntentAndStateRequest is request for MobileAppIntentAndState
type MobileAppIntentAndStateRequest struct{ BaseRequest }

// Get performs GET request for MobileAppIntentAndState
func (r *MobileAppIntentAndStateRequest) Get(ctx context.Context) (resObj *MobileAppIntentAndState, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for MobileAppIntentAndState
func (r *MobileAppIntentAndStateRequest) Update(ctx context.Context, reqObj *MobileAppIntentAndState) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for MobileAppIntentAndState
func (r *MobileAppIntentAndStateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// MobileAppProvisioningConfigGroupAssignmentRequestBuilder is request builder for MobileAppProvisioningConfigGroupAssignment
type MobileAppProvisioningConfigGroupAssignmentRequestBuilder struct{ BaseRequestBuilder }

// Request returns MobileAppProvisioningConfigGroupAssignmentRequest
func (b *MobileAppProvisioningConfigGroupAssignmentRequestBuilder) Request() *MobileAppProvisioningConfigGroupAssignmentRequest {
	return &MobileAppProvisioningConfigGroupAssignmentRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// MobileAppProvisioningConfigGroupAssignmentRequest is request for MobileAppProvisioningConfigGroupAssignment
type MobileAppProvisioningConfigGroupAssignmentRequest struct{ BaseRequest }

// Get performs GET request for MobileAppProvisioningConfigGroupAssignment
func (r *MobileAppProvisioningConfigGroupAssignmentRequest) Get(ctx context.Context) (resObj *MobileAppProvisioningConfigGroupAssignment, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for MobileAppProvisioningConfigGroupAssignment
func (r *MobileAppProvisioningConfigGroupAssignmentRequest) Update(ctx context.Context, reqObj *MobileAppProvisioningConfigGroupAssignment) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for MobileAppProvisioningConfigGroupAssignment
func (r *MobileAppProvisioningConfigGroupAssignmentRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// MobileAppRelationshipRequestBuilder is request builder for MobileAppRelationship
type MobileAppRelationshipRequestBuilder struct{ BaseRequestBuilder }

// Request returns MobileAppRelationshipRequest
func (b *MobileAppRelationshipRequestBuilder) Request() *MobileAppRelationshipRequest {
	return &MobileAppRelationshipRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// MobileAppRelationshipRequest is request for MobileAppRelationship
type MobileAppRelationshipRequest struct{ BaseRequest }

// Get performs GET request for MobileAppRelationship
func (r *MobileAppRelationshipRequest) Get(ctx context.Context) (resObj *MobileAppRelationship, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for MobileAppRelationship
func (r *MobileAppRelationshipRequest) Update(ctx context.Context, reqObj *MobileAppRelationship) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for MobileAppRelationship
func (r *MobileAppRelationshipRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// MobileAppTroubleshootingEventRequestBuilder is request builder for MobileAppTroubleshootingEvent
type MobileAppTroubleshootingEventRequestBuilder struct{ BaseRequestBuilder }

// Request returns MobileAppTroubleshootingEventRequest
func (b *MobileAppTroubleshootingEventRequestBuilder) Request() *MobileAppTroubleshootingEventRequest {
	return &MobileAppTroubleshootingEventRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// MobileAppTroubleshootingEventRequest is request for MobileAppTroubleshootingEvent
type MobileAppTroubleshootingEventRequest struct{ BaseRequest }

// Get performs GET request for MobileAppTroubleshootingEvent
func (r *MobileAppTroubleshootingEventRequest) Get(ctx context.Context) (resObj *MobileAppTroubleshootingEvent, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for MobileAppTroubleshootingEvent
func (r *MobileAppTroubleshootingEventRequest) Update(ctx context.Context, reqObj *MobileAppTroubleshootingEvent) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for MobileAppTroubleshootingEvent
func (r *MobileAppTroubleshootingEventRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// MobileContainedAppRequestBuilder is request builder for MobileContainedApp
type MobileContainedAppRequestBuilder struct{ BaseRequestBuilder }

// Request returns MobileContainedAppRequest
func (b *MobileContainedAppRequestBuilder) Request() *MobileContainedAppRequest {
	return &MobileContainedAppRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// MobileContainedAppRequest is request for MobileContainedApp
type MobileContainedAppRequest struct{ BaseRequest }

// Get performs GET request for MobileContainedApp
func (r *MobileContainedAppRequest) Get(ctx context.Context) (resObj *MobileContainedApp, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for MobileContainedApp
func (r *MobileContainedAppRequest) Update(ctx context.Context, reqObj *MobileContainedApp) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for MobileContainedApp
func (r *MobileContainedAppRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// MobileLobAppRequestBuilder is request builder for MobileLobApp
type MobileLobAppRequestBuilder struct{ BaseRequestBuilder }

// Request returns MobileLobAppRequest
func (b *MobileLobAppRequestBuilder) Request() *MobileLobAppRequest {
	return &MobileLobAppRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// MobileLobAppRequest is request for MobileLobApp
type MobileLobAppRequest struct{ BaseRequest }

// Get performs GET request for MobileLobApp
func (r *MobileLobAppRequest) Get(ctx context.Context) (resObj *MobileLobApp, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for MobileLobApp
func (r *MobileLobAppRequest) Update(ctx context.Context, reqObj *MobileLobApp) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for MobileLobApp
func (r *MobileLobAppRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// MobileThreatDefenseConnectorRequestBuilder is request builder for MobileThreatDefenseConnector
type MobileThreatDefenseConnectorRequestBuilder struct{ BaseRequestBuilder }

// Request returns MobileThreatDefenseConnectorRequest
func (b *MobileThreatDefenseConnectorRequestBuilder) Request() *MobileThreatDefenseConnectorRequest {
	return &MobileThreatDefenseConnectorRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// MobileThreatDefenseConnectorRequest is request for MobileThreatDefenseConnector
type MobileThreatDefenseConnectorRequest struct{ BaseRequest }

// Get performs GET request for MobileThreatDefenseConnector
func (r *MobileThreatDefenseConnectorRequest) Get(ctx context.Context) (resObj *MobileThreatDefenseConnector, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for MobileThreatDefenseConnector
func (r *MobileThreatDefenseConnectorRequest) Update(ctx context.Context, reqObj *MobileThreatDefenseConnector) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for MobileThreatDefenseConnector
func (r *MobileThreatDefenseConnectorRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

//
type MobileAppCollectionHasPayloadLinksRequestBuilder struct{ BaseRequestBuilder }

// HasPayloadLinks action undocumented
func (b *DeviceAppManagementMobileAppsCollectionRequestBuilder) HasPayloadLinks(reqObj *MobileAppCollectionHasPayloadLinksRequestParameter) *MobileAppCollectionHasPayloadLinksRequestBuilder {
	bb := &MobileAppCollectionHasPayloadLinksRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/hasPayloadLinks"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type MobileAppCollectionHasPayloadLinksRequest struct{ BaseRequest }

//
func (b *MobileAppCollectionHasPayloadLinksRequestBuilder) Request() *MobileAppCollectionHasPayloadLinksRequest {
	return &MobileAppCollectionHasPayloadLinksRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *MobileAppCollectionHasPayloadLinksRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]HasPayloadLinkResultItem, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []HasPayloadLinkResultItem
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []HasPayloadLinkResultItem
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

//
func (r *MobileAppCollectionHasPayloadLinksRequest) PostN(ctx context.Context, n int) ([]HasPayloadLinkResultItem, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, n)
}

//
func (r *MobileAppCollectionHasPayloadLinksRequest) Post(ctx context.Context) ([]HasPayloadLinkResultItem, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, 0)
}

//
type MobileAppAssignRequestBuilder struct{ BaseRequestBuilder }

// Assign action undocumented
func (b *MobileAppRequestBuilder) Assign(reqObj *MobileAppAssignRequestParameter) *MobileAppAssignRequestBuilder {
	bb := &MobileAppAssignRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/assign"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type MobileAppAssignRequest struct{ BaseRequest }

//
func (b *MobileAppAssignRequestBuilder) Request() *MobileAppAssignRequest {
	return &MobileAppAssignRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *MobileAppAssignRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type MobileAppUpdateRelationshipsRequestBuilder struct{ BaseRequestBuilder }

// UpdateRelationships action undocumented
func (b *MobileAppRequestBuilder) UpdateRelationships(reqObj *MobileAppUpdateRelationshipsRequestParameter) *MobileAppUpdateRelationshipsRequestBuilder {
	bb := &MobileAppUpdateRelationshipsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/updateRelationships"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type MobileAppUpdateRelationshipsRequest struct{ BaseRequest }

//
func (b *MobileAppUpdateRelationshipsRequestBuilder) Request() *MobileAppUpdateRelationshipsRequest {
	return &MobileAppUpdateRelationshipsRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *MobileAppUpdateRelationshipsRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type MobileAppContentFileCommitRequestBuilder struct{ BaseRequestBuilder }

// Commit action undocumented
func (b *MobileAppContentFileRequestBuilder) Commit(reqObj *MobileAppContentFileCommitRequestParameter) *MobileAppContentFileCommitRequestBuilder {
	bb := &MobileAppContentFileCommitRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/commit"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type MobileAppContentFileCommitRequest struct{ BaseRequest }

//
func (b *MobileAppContentFileCommitRequestBuilder) Request() *MobileAppContentFileCommitRequest {
	return &MobileAppContentFileCommitRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *MobileAppContentFileCommitRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type MobileAppContentFileRenewUploadRequestBuilder struct{ BaseRequestBuilder }

// RenewUpload action undocumented
func (b *MobileAppContentFileRequestBuilder) RenewUpload(reqObj *MobileAppContentFileRenewUploadRequestParameter) *MobileAppContentFileRenewUploadRequestBuilder {
	bb := &MobileAppContentFileRenewUploadRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/renewUpload"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type MobileAppContentFileRenewUploadRequest struct{ BaseRequest }

//
func (b *MobileAppContentFileRenewUploadRequestBuilder) Request() *MobileAppContentFileRenewUploadRequest {
	return &MobileAppContentFileRenewUploadRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *MobileAppContentFileRenewUploadRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}
