/*
 * Copyright (c) 2010 Mike Qin <mikeandmore@gmail.com>
 *
 * The contents of this file are subject to the terms of either the GNU Lesser
 * General Public License Version 2.1 only ("LGPL") or the Common Development and
 * Distribution License ("CDDL")(collectively, the "License"). You may not use this
 * file except in compliance with the License. You can obtain a copy of the CDDL at
 * http://www.opensource.org/licenses/cddl1.php and a copy of the LGPLv2.1 at
 * http://www.opensource.org/licenses/lgpl-license.php. See the License for the
 * specific language governing permissions and limitations under the License. When
 * distributing the software, include this License Header Notice in each file and
 * include the full text of the License in the License file as well as the
 * following notice:
 *
 * NOTICE PURSUANT TO SECTION 9 OF THE COMMON DEVELOPMENT AND DISTRIBUTION LICENSE
 * (CDDL)
 * For Covered Software in this distribution, this License shall be governed by the
 * laws of the State of California (excluding conflict-of-law provisions).
 * Any litigation relating to this License shall be subject to the jurisdiction of
 * the Federal Courts of the Northern District of California and the state courts
 * of the State of California, with venue lying in Santa Clara County, California.
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or only
 * the LGPL Version 2.1, indicate your decision by adding "[Contributor]" elects to
 * include this software in this distribution under the [CDDL or LGPL Version 2.1]
 * license." If you don't indicate a single choice of license, a recipient has the
 * option to distribute your version of this file under either the CDDL or the LGPL
 * Version 2.1, or to extend the choice of license to its licensees as provided
 * above. However, if you add LGPL Version 2.1 code and therefore, elected the LGPL
 * Version 2 license, then the option applies only if the new code is made subject
 * to such option by the copyright holder.
 */

#ifndef _IC_H_
#define _IC_H_

#include <gtk/gtk.h>
#include <X11/Xproto.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>

#include "common.h"

__BEGIN_DECLS


#define MAX_IC_NUM 0x7fff
#define GC_THRESHOLD 4096

/* input context */
typedef struct _IC {
    Window client_window;
    bool   is_enabled;
    bool   is_english;
    bool   is_full;
    bool   is_chn_punc;
    int    icid;
    int    connect_id;
    int    offset_x;
    int    offset_y;
} IC;

typedef struct _IC_UI {
    gboolean (*init)    (const char* name);
    void (*refresh) (void);
    void (*dispose) (void);
    const char* (*get_name) (void);
} IC_UI;

/* input context manager */

void icmgr_init       (void);
void icmgr_finalize   (void);

IC*  icmgr_create_ic  (int connect_id);
void icmgr_destroy_ic (int icid);
bool icmgr_set_current(int icid);
IC*  icmgr_get        (int icid);

void icmgr_toggle_english (void);
void icmgr_toggle_full    (void);
void icmgr_toggle_punc    (void);

IC*  icmgr_get_current  (void);
void icmgr_clear_current(void);
void icmgr_refresh      (void);

void icmgr_ui_init      (void);
void icmgr_ui_refresh   (void);

__END_DECLS

#endif /* _IC_H_ */

// -*- indent-tabs-mode: nil -*- vim:et:ts=4
