/*
Copyright (c) 2010 by Drake Justice <djustice.kde@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
*/

#ifndef COPYTHREAD_H
#define COPYTHREAD_H

#include <QProcess>
#include <QString>
#include <QThread>
#include <QTimer>

#include <solid/opticaldisc.h>

class CopyThread : public QThread
{
    Q_OBJECT

    public:
        CopyThread(QObject* parent, const QString &device, Solid::OpticalDisc::ContentTypes disctype);
        void run();

    private slots:
        void processFinished(int);
        void processError(QProcess::ProcessError);
        void updateProgress();
        void cancelProcess();
        void blankDiscInserted();

    signals:
        void discCapacity(int);
        void progressMonitor(int);
        void ejectTray();

    private:
        QString m_device;
        QString m_filename;

        QProcess m_process;

        QTimer m_timer;

        Solid::OpticalDisc::ContentTypes m_discType;

        bool m_hadError;
        bool m_wasCanceled;

        int m_pid;
};

#endif // COPYTHREAD_H
