/***************************************************************************
                          character.h  -  description
                             -------------------
    begin                : 11. December 2010
    copyright            : (c) 2007 by Iven Wold - 526f6c616e642053756368616e
    email                : hour.glass2@yahoo.com
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/

#ifndef CHARACTER_H
#define CHARACTER_H

#include <QDialog>
#include <QWidget>

#include <QComboBox>
#include <QFontComboBox>
#include <QScrollArea>
#include <QLineEdit>
#include <QClipboard>
#include <QCheckBox>

#include "qtrans.h"
#include "character_widget.h"


class Character : public QDialog
{
    Q_OBJECT

public:
	Character(QTrans *parent = 0);
	~Character();
	
	QTrans *Par;
    
public slots:
	void findStyles(const QFont &font);
	void findSizes(const QFont &font);
	void insertCharacter(const QString &character);
	void updateClipboard();
  
private:
	Character_widget *characterWidget;
	QClipboard *clipboard;
	QComboBox *styleCombo;
	QComboBox *sizeCombo;
	QFontComboBox *fontCombo;
	QLineEdit *lineEdit;
	QScrollArea *scrollArea;
	QCheckBox *fontMerging;
	void closeEvent(QCloseEvent *event);
    
};

#endif

