/***************************************************************************
                          character_widget.h  -  description
                             -------------------
    begin                : 11. December 2010
    copyright            : (c) 2007 by Iven Wold - 526f6c616e642053756368616e
    email                : hour.glass2@yahoo.com
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/ 

#ifndef CHARACTER_WIDGET_H
#define CHARACTER_WIDGET_H

#include <QFont>
#include <QWidget>
#include <QPaintEvent>
#include <QSize>

class Character_widget : public QWidget
{
	Q_OBJECT

public:
	Character_widget(QWidget *parent = 0);
	~Character_widget();
	QWidget *Par;			//ooo		
	QSize sizeHint() const;
	QFont displayFont;		//ooo
	
public slots:
	void updateFont(const QFont &font);
	void updateSize(const QString &fontSize);
	void updateStyle(const QString &fontStyle);
	void updateFontMerging(bool enable);
	
signals:
	void characterSelected(const QString &character);
  
protected:
	void mouseMoveEvent(QMouseEvent *event);
	void mousePressEvent(QMouseEvent *event);
	void paintEvent(QPaintEvent *event);
  
private:
	//QFont displayFont;
	int columns;
	int lastKey;
	int squareSize;
	
};

#endif

