 
/***************************************************************************
                          dictd.h  -  description

                             -------------------
    begin                : 28. November 2010
    copyright            : (c) 2007 by Iven Wold - 526f6c616e642053756368616e
    email                : hour.glass2@yahoo.com
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/

#ifndef DICTD_H
#define DICTD_H

#include <QFile>
#include <QString>
#include <QList>

#define BUFFERSIZE 10240	//ooo

class Dictd {
  public:
	Dictd( const QString & );
	~Dictd();
	
	QString search( const QString & );
	char* Inflate(unsigned char *data, unsigned long size);	//ooo
	//char* Inflate(const QByteArray &data);	//ooo
 
  protected:
	void readExtraField();
	void readFileName();
	unsigned long b64_decode( const char * );
	
	int headerLength;	//ooo
	
	bool m_isOk;
	
	bool isCompressed;
	QFile *dictFile;
	QFile *idxFile;
	bool FEXTRA;
	bool FNAME;
	char FLAGS;
	bool FTEXT;
	bool FHCRC;
	bool FCOMMENT;
	unsigned long MTIME;
	unsigned long XLEN;
	char SI1, SI2;
	unsigned long LEN, VER, CHLEN, CHCNT;
	QList<unsigned long> offsets;
	QList<unsigned long> offsetsWithHeader;		//ooo
	QString m_filename;
	
	char *crc16[2];
	unsigned long offset;
	unsigned long offsetAdditional;			//ooo
	
	char c;
	int type;					//ooo
	char buffer[BUFFERSIZE];			//ooo
	char *byte;					//ooo

	struct entry{
		QString headword;
		unsigned long position;
		unsigned long size;
	};
	
};

#endif // DICTD_H
