/***************************************************************************
                          utils.h  -  description
                             -------------------
    begin                : December 2007
    copyright            : (c) 2007 by Iven Wold - 526f6c616e642053756368616e
    email                : hour.glass2@yahoo.com
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/

#ifndef UTILS_H
#define UTILS_H

#define Q_NAME        "QTrans"
#define Q_VERSION     "0.2.2.6 - release 7"
#define Q_DESCRIPTION "QTrans - Instant translator for KDE based on Babylon"

#include <fstream>
#include <iostream>
#include <KLocale>
#include <string>

#include <QString>
#include <QSettings>

using namespace std;

	QString str(string);
	QString str_2(QString);
	QString tr_str(QString);
	QString reverseString(QString s);

const QString Flag[] = {
	"<0>",			"flag-be.png",		"flag-bg.png",		"flag-br.png",		"flag-ca.png",
	"flag-cs.png",		"flag-cy.png",		"flag-da.png",		"flag-de.png",		"flag-el.png",
	"flag-en.png",		"flag-eo.png",		"flag-es.png",		"flag-et.png",		"flag-eu.png",
	"flag-fi.png",		"flag-fr.png",		"flag-ga.png",		"flag-gl.png",		"flag-he.png",
	"flag-hr.png",		"flag-hu.png",		"flag-hy.png",		"flag-id.png",		"flag-is.png",
	"flag-it.png",		"flag-ja.png",		"flag-ko.png",		"flag-lt.png",		"flag-lv.png",
	"flag-mi.png",		"flag-mk.png",		"flag-nl.png",		"flag-no.png",		"flag-ph.png",
	"flag-pl.png",		"flag-pt.png",		"flag-pt_BR.png",	"flag-ro.png",		"flag-ru.png",
	"flag-sk.png",		"flag-sl.png",		"flag-sp.png",		"flag-sr.png",		"flag-sv.png",
	"flag-th.png",		"flag-tl.png",		"flag-tr.png",		"flag-uk.png",		"flag-ur.png",
	"flag-vi.png",		"flag-wa.png",		"flag-zh_CN.GB2312.png","flag-zh_CN.png",	"flag-zh_TW.Big5.png",
	"flag-zh_TW.png",	0L
};

const QString Language[] = {
	i18n(" "),		i18n("Belarusian "),	i18n("Bulgarian "),	i18n(" "),		i18n(" "),
	i18n("Czech"),		i18n(" "),		i18n("Danish"),		i18n("German"),		i18n("Greek"),
	i18n("English"),	i18n(" "),		i18n("Spanish"),	i18n("Estonian"),	i18n(" "),
	i18n("Finnish"),	i18n("French"),		i18n(" "),		i18n(" "),		i18n("Hebrew"),
	i18n("Croatian"),	i18n("Hungarian"),	i18n(" "),		i18n("Indonesian"),	i18n("Icelandic"),
	i18n("Italian"),	i18n("Japanese"),	i18n("Korean"),		i18n("Lithuanian"),	i18n("Latvian"),
	i18n(" "),		i18n(" "),		i18n("Dutch"),		i18n("Norvegian"),	i18n("Philippines"),
	i18n("Polish"),		i18n("Portuguese"),	i18n("Brazilian"),	i18n("Romanian"),	i18n("Russian"),
	i18n("Slovakian"),	i18n("Slovenian"),	i18n(" "),		i18n("Serbian"),	i18n("Swedish"),
	i18n("Thai"),		i18n(" "),		i18n("Turkish"),	i18n("Ukrainian"),	i18n("Pakistani"),
	i18n("Vietnamese"),	i18n(" "),		i18n(" "),		i18n("Chinese"),	i18n(" "),
	i18n(" "),		0L
};

const QString Codec[] = {
	"",
	"cp-1256",	/*Arabic*/
	"iso-8859-6",	/*Arabic*/
	"cp-1257",	/*Baltic*/
	"iso-8859-13",	/*Baltic*/
	"iso-8859-2",	/*Central European*/
	"iso-8859-3",	/*Central European*/
	"cp-1250",	/*Central European*/
	"gbk",		/*Chinese Simplified*/
	"iso-8859-15",	/*Chinese Simplified*/
	"big5",		/*Chinese Traditional*/
	"iso-8859-14",	/*Chinese Traditional*/
	"cp-1251",	/*Cyrillic*/
	"ibm866",	/*Cyrillic*/

	"iso-8859-5",	/*Cyrillic*/
	"koi8-r",	/*Cyrillic*/
	"koi8-u",	/*Cyrillic*/
	"cp-1253",	/*Greek*/
	"iso-8859-7",	/*Greek*/
	"cp-1255",	/*Hebrew*/
	"iso-8859-8",	/*Hebrew*/

	"eucjp",	/*Japanese*/
	"sjis",		/*Japanese*/
	"euckr",	/*Korean*/

	"iso-8859-16",	/*South European*/
	"cp-874",	/*Thai*/
	"iso-8859-11",	/*Thai*/
	"cp-1254",	/*Turkish*/
	"iso-8859-9",	/*Turkish*/
	"utf-8",
	"utf-16",

	"cp-1258",	/*Vietnamese*/
	"cp-1252",	/*Western European*/
	"iso-8859-1",	/*Western European*/
	0L
};

const QString codecLanguage[] = {
	"",
	"Arabic",
	"Arabic",
	"Baltic",
	"Baltic",
	"Central European",
	"Central European",
	"Central European",
	"Chinese Simplified",
	"Chinese Simplified",
	"Chinese Traditional",
	"Chinese Traditional",
	"Cyrillic",
	"Cyrillic",

	"Cyrillic",
	"Cyrillic",
	"Cyrillic",
	"Greek",
	"Greek",
	"Hebrew",
	"Hebrew",

	"Japanese",
	"Japanese",
	"Korean",

	"South European",
	"Thai",
	"Thai",
	"Turkish",
	"Turkish",
	"Unicode",
	"Unicode",

	"Vietnamese",
	"Western European",
	"Western European",
	0L
};

const QString right_to_left_Direction[] = {
	"",          "Yes",         0L
};


const QString disable_enable[] = {
	"",          "Yes",         0L
};


const QString encoding[] = {
	"",          "Yes",         0L
};

#endif
