"""
File:		Help.py
Purpose:	Help menu handler

Author:		Copyright 2006-2010 Xavion

License:	This file is part of Q7Z.

			Q7Z is free software: you can redistribute it and/or modify
			it under the terms of the GNU Lesser General Public License as published by
			the Free Software Foundation, either version 3 of the License, or
			(at your option) any later version.

			Q7Z is distributed in the hope that it will be useful,
			but WITHOUT ANY WARRANTY; without even the implied warranty of
			MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
			GNU Lesser General Public License for more details.

			You should have received a copy of the GNU Lesser General Public License
			along with Q7Z.  If not, see <http://www.gnu.org/licenses/>.
"""


### Imports

# App 1
import	Import

# Python
try :
	import	random
except :
	Import.slException("Python")

# PyQt4
try :
	from	PyQt4	import QtCore, QtNetwork
	# Visible?
	if not Import.Init.bInvisible :
		from	PyQt4	import QtGui
except :
	Import.slException("PyQt4")

# App 2
import	Display, Main, Settings


### Slots

# About Qt4
def slAboutQt4() :
	QtGui.QApplication.aboutQt()

# About Q7Z
def slAboutQ7Z() :

	# Replacements
	sMessage = (Settings.Application.sAbout1 + Settings.Application.sAbout2).replace("\n", "<br>")

	# Message
	QtGui.QMessageBox.about(Main.uiMain.cwMain, Settings.Application.sName + " - About", sMessage)


# Open URL
def slUOpen(uURL) :

	Display.slMessage(Settings.Message.iStatus, "Launching the URL handler ...")

	# Visible?
	if not Import.Init.bInvisible :
		QtGui.QDesktopServices.openUrl(uURL)


# UIsNewer
def slUIsNewer(sLocal, sRemote) :

	bNewer = False

	# Compare
	if len(sLocal) and len(sRemote) :

		# Major
		if int(sLocal[0]) < int(sRemote[0]) :
			bNewer = True
		elif int(sLocal[0]) == int(sRemote[0]) :
			# Minor
			if int(sLocal[2]) < int(sRemote[2]) :
				bNewer = True
			elif int(sLocal[2]) == int(sRemote[2]) :
				# Point
				if int(sLocal[4]) < int(sRemote[4]) :
					bNewer = True

	return bNewer


# Variables
Update = QtCore.QObject()
Update.bAuto = False
Update.hCurrent = QtNetwork.QHttp()

# Done
def slUDone(bError) :
#def slUDone(iID, bError) :

	# Prevent recalls
	Update.hCurrent.disconnect(Update.hCurrent, QtCore.SIGNAL("done(bool)"), slUDone)

	if not bError :

		bGet = False
		bFound = False

		sData = bytes.decode(bytes(Update.hCurrent.readAll()))

		if not len(sData) :

			slUBegin()

		elif sData.count("<HTML>") :

			# Messages
			#if not Update.bAuto :
			Display.slMessage(Settings.Message.iError, "The updates server can't be contacted.  Check your network settings and try again.")

		else :

			slLines = sData.splitlines()
			sReqVer = ""
			sRecVer = ""

			while len(slLines) :
				sLine = slLines.pop(0)
				slElems = sLine.split()

				if len(slElems) == 3 :

					if slElems[0] == "Required" :
						sReqVer = slElems[2]
						bFound = True
					elif slElems[0] == "Recommended" :
						sRecVer = slElems[2]
						bFound = True

		if bFound :

			# Compare
			try :

				# Stable
				if slUIsNewer(Settings.Application.sVersion, sReqVer) :
					bGet = Display.slMessage(Settings.Message.iQuestion, Settings.Application.sName + " v" + sReqVer + " (stable) is available.<br><br>Would you like to visit the website now?")

				# Beta
				elif slUIsNewer(Settings.Application.sVersion, sRecVer) and not Update.bAuto :
					bGet = Display.slMessage(Settings.Message.iQuestion, Settings.Application.sName + " v" + sRecVer + " (beta) is available.<br><br>Would you like to visit the website now?")

				# None
				elif not Update.bAuto :
					Display.slMessage(Settings.Message.iInformation, "You're already using the latest release.")

				# Get
				if bGet == QtGui.QMessageBox.Yes :

					# Launch
					slUOpen(QtCore.QUrl(Settings.Application.sWebsite))

					# Quit
					#Main.uiMain.aAQuit.trigger()
					Display.slQuit()

			except :

				# Messages
				#if not Update.bAuto :
				Display.slMessage(Settings.Message.iError, "Can't compare the local and remote version numbers.")

	else :

		# Messages
		#if not Update.bAuto :
		Display.slMessage(Settings.Message.iError, "The updates server can't be contacted.  Check your network settings and try again.")

	Update.bAuto = False

	# Clear
	Display.slMessage(Settings.Message.iClear, "")

# Begin
def slUBegin() :

	# Check
	#Display.slMessage(Settings.Message.iTitle, "Checking ...")
	Display.slMessage(Settings.Message.iStatus, "Checking for newer release ...")

	Update.hCurrent = QtNetwork.QHttp()
	Update.hCurrent.setHost(Settings.Application.sDomain)
	if len(Settings.Path.Proxy.hostName()) :
		Update.hCurrent.setProxy(Settings.Path.Proxy)
	Update.hCurrent.connect(Update.hCurrent, QtCore.SIGNAL("done(bool)"), slUDone)
	#Update.hCurrent.connect(Update.hCurrent, QtCore.SIGNAL("requestFinished(int,bool)"), slUDone)

	if not Update.hCurrent.get(Settings.Application.sCurrent) :
	#and not Update.bAuto :
		Display.slMessage(Settings.Message.iError, "The updates server can't be contacted.  Check your network settings and try again.")

# Begin
def slUCheck() :

	# Auto-Update
	if Settings.Init.bAutoUpdate and not Import.Init.bInvisible :

		if random.randint(0, 10) == 5 :
		#if random.randint(0, 0) == 0 :

			# Silent
			Update.bAuto = True

			slUBegin()


# Feedback: Bad
def slFBBad() :

	# Set URL
	uURL = QtCore.QUrl("mailto:" + Settings.Author.Email.sUser + Settings.Author.Email.sDomain + "?subject=" + Settings.Application.sName + " v" + Settings.Application.sVersion + ": Feedback: Bad")

	slUOpen(uURL)

# Feedback: Good
def slFBGood() :

	# Set URL
	uURL = QtCore.QUrl("mailto:" + Settings.Author.Email.sUser + Settings.Author.Email.sDomain + "?subject=" + Settings.Application.sName + " v" + Settings.Application.sVersion + ": Feedback: Good")

	slUOpen(uURL)

# Feedback: Idea
def slFBIdea() :

	# Set URL
	uURL = QtCore.QUrl("mailto:" + Settings.Author.Email.sUser + Settings.Author.Email.sDomain + "?subject=" + Settings.Application.sName + " v" + Settings.Application.sVersion + ": Feedback: Idea")

	slUOpen(uURL)


# URL: Q7Z
def slUQ7Z() :

	# Set URL
	slUOpen(QtCore.QUrl(Settings.Application.sWebsite))

# URL: P7Zip
def slUP7Zip() :

	# Set URL
	slUOpen(QtCore.QUrl(Settings.URL.sP7Zip))

# URL: Qt4
def slUQt4() :

	# Set URL
	slUOpen(QtCore.QUrl(Settings.URL.sQt))

# URL: PyQt4
def slUPyQt4() :

	# Set URL
	slUOpen(QtCore.QUrl(Settings.URL.sPyQt))

# URL: Python
def slUPython() :

	# Set URL
	slUOpen(QtCore.QUrl(Settings.URL.sPython))

# URL: Tar
def slUTar() :

	# Set URL
	slUOpen(QtCore.QUrl(Settings.URL.sTar))

# URL: Make
def slUMake() :

	# Set URL
	slUOpen(QtCore.QUrl(Settings.URL.sMake))

# URL: Eric
def slUEric() :

	# Set URL
	slUOpen(QtCore.QUrl(Settings.URL.sEric))


# Lic: Q7Z
def slLicQ7Z() :

	# Set URL
	slUOpen(QtCore.QUrl("file:" + Settings.Path.App.sPrefix + Settings.Path.App.sInstall + "/License/Q7Z"))

# Lic: GPL
def slLicGPL() :

	# Set URL
	slUOpen(QtCore.QUrl("file:" + Settings.Path.App.sPrefix + Settings.Path.App.sInstall + "/License/GPL"))

# Lic: LGPL
def slLicLGPL() :

	# Set URL
	slUOpen(QtCore.QUrl("file:" + Settings.Path.App.sPrefix + Settings.Path.App.sInstall + "/License/LGPL"))

# Documentation
def slDoc() :

	# Set URL
	slUOpen(QtCore.QUrl(Settings.URL.sDoc))
