#! /bin/sh

date=20110409

# check G-HAL's anthy
if [ -f ../sample/conf ];
then
	printf "\nApply patches to G-HAL's anthy...\n\n"
else
	printf "\nYou need to use G-HAL's anthy.\n"
	printf "Check anthy-*.tar.lzma in\n"
	printf "http://www.fenix.ne.jp/~G-HAL/soft/nosettle/#anthy\n\n"
	exit
fi

# update config
cd ..
cat anthy-conf.in anthy-ut-patches-$date/conf/conf-ut > anthy-conf.in.new
rm -f anthy-conf.in
mv anthy-conf.in.new anthy-conf.in
cd -

# install new dictionaries
cp -f dictionaries/* ../alt-cannadic/
cp zipcode/zipcode.t ../mkworddic/
cp mkworddic/dict.args.in ../mkworddic/dict.args.in

# update calctrans
cd ../calctrans/
cp -f corpus.0.txt corpus.1.txt
cp -f corpus.0.txt corpus.2.txt
cp -f corpus.0.txt corpus.3.txt
cp -f corpus.0.txt corpus.4.txt
cp -f corpus.0.txt corpus.5.txt
cp -f corpus.0.txt corpus.x.txt
rm -f *.HID*
rm -f *.IDI*
rm -f *.IID*
cd -
cp -f calctrans/* ../calctrans/

# install docs
mkdir -p ../doc-ut
cp AUTHORS ../doc-ut
cp ChangeLog.* ../doc-ut
cp README* ../doc-ut
cp THANKS ../doc-ut

# re-generate configure
cd ..
autoreconf -fiv
cd -
