#!/bin/sh

# 一時ファイルを削除
rm -f */*.done
rm -f */*/*.done
rm -f */0*.txt.*
rm -f */1*.txt.*
rm -f */*.order
rm -f */*.var
rm -f */*-all
rm -f chimei/KEN_ALL*

# 郵便番号辞書を作る
cd yuubin
ruby yuubin-generate-dic.rb KEN_ALL.CSV
mv KEN_ALL.CSV.done zipcode.t
ruby sortdic.rb zipcode.t
ruby euc-contents-converter.rb zipcode.t
mv zipcode.t ../dictionaries/
cd ..

# 地名辞書を作る
cp yuubin/KEN_ALL.CSV chimei/
cd chimei

printf "Change the encoding to utf-8...\n"
ruby 01* KEN_ALL.CSV

printf "Get chimei entries from KEN_ALL.CSV...\n"
ruby 02* *.002

printf "Remove duplicates...\n"
ruby 03* *.003

printf "Remove short chimei entries...\n"
ruby 04* *.004

printf "Convert Katakana to Hiragana...\n"
ruby 05* *.005

printf "Generate a cannadic format dictionary...\n"
ruby 06* *.006

mv *.done ../dictionaries/chimei.ctd
cd ..


# 一時ファイルを削除
rm -f */*.done
rm -f */*/*.done
rm -f */0*.txt.*
rm -f */1*.txt.*
rm -f */*.order
rm -f */*.var
rm -f */*-all
rm -f chimei/KEN_ALL*
