/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gmodule.h>


#define GNOME_SCAN_TYPE_MODULE_MANAGER (gnome_scan_module_manager_get_type ())
#define GNOME_SCAN_MODULE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_MODULE_MANAGER, GnomeScanModuleManager))
#define GNOME_SCAN_MODULE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_MODULE_MANAGER, GnomeScanModuleManagerClass))
#define GNOME_SCAN_IS_MODULE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_MODULE_MANAGER))
#define GNOME_SCAN_IS_MODULE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_MODULE_MANAGER))
#define GNOME_SCAN_MODULE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_MODULE_MANAGER, GnomeScanModuleManagerClass))

typedef struct _GnomeScanModuleManager GnomeScanModuleManager;
typedef struct _GnomeScanModuleManagerClass GnomeScanModuleManagerClass;
typedef struct _GnomeScanModuleManagerPrivate GnomeScanModuleManagerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GNOME_SCAN_TYPE_MODULE (gnome_scan_module_get_type ())
#define GNOME_SCAN_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_MODULE, GnomeScanModule))
#define GNOME_SCAN_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_MODULE, GnomeScanModuleClass))
#define GNOME_SCAN_IS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_MODULE))
#define GNOME_SCAN_IS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_MODULE))
#define GNOME_SCAN_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_MODULE, GnomeScanModuleClass))

typedef struct _GnomeScanModule GnomeScanModule;
typedef struct _GnomeScanModuleClass GnomeScanModuleClass;
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_slist_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_free (var), NULL)))

typedef enum  {
	MODULE_ERROR_NONAME,
	MODULE_ERROR_INVALID,
	MODULE_ERROR_LOADED,
	MODULE_ERROR_FAIL
} ModuleError;
#define MODULE_ERROR module_error_quark ()
struct _GnomeScanModuleManager {
	GObject parent_instance;
	GnomeScanModuleManagerPrivate * priv;
};

struct _GnomeScanModuleManagerClass {
	GObjectClass parent_class;
};

struct _GnomeScanModuleManagerPrivate {
	char* _path;
	GSList* modules;
};


static gpointer gnome_scan_module_manager_parent_class = NULL;

GQuark module_error_quark (void);
GType gnome_scan_module_manager_get_type (void);
#define GNOME_SCAN_MODULE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_MODULE_MANAGER, GnomeScanModuleManagerPrivate))
enum  {
	GNOME_SCAN_MODULE_MANAGER_DUMMY_PROPERTY,
	GNOME_SCAN_MODULE_MANAGER_PATH
};
static void _g_slist_free_g_object_unref (GSList* self);
void gnome_scan_module_manager_set_path (GnomeScanModuleManager* self, const char* value);
GnomeScanModuleManager* gnome_scan_module_manager_new (const char* path);
GnomeScanModuleManager* gnome_scan_module_manager_construct (GType object_type, const char* path);
static char* gnome_scan_module_manager_module_name_from_filename (GnomeScanModuleManager* self, const char* filename, GError** error);
GType gnome_scan_module_get_type (void);
const char* gnome_scan_module_manager_get_path (GnomeScanModuleManager* self);
static void _g_slist_free_g_free (GSList* self);
static gboolean gnome_scan_module_manager_is_valid_module_name (const char* name);
GnomeScanModule* gnome_scan_module_new (const char* filename);
GnomeScanModule* gnome_scan_module_construct (GType object_type, const char* filename);
void gnome_scan_module_manager_query_modules (GnomeScanModuleManager* self);
void gnome_scan_module_manager_unload_modules (GnomeScanModuleManager* self);
static void gnome_scan_module_manager_finalize (GObject* obj);
static void gnome_scan_module_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gnome_scan_module_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark module_error_quark (void) {
	return g_quark_from_static_string ("module_error-quark");
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


GnomeScanModuleManager* gnome_scan_module_manager_construct (GType object_type, const char* path) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanModuleManager * self;
	g_return_val_if_fail (path != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "path";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, path);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanModuleManager* gnome_scan_module_manager_new (const char* path) {
	return gnome_scan_module_manager_construct (GNOME_SCAN_TYPE_MODULE_MANAGER, path);
}


static char* gnome_scan_module_manager_module_name_from_filename (GnomeScanModuleManager* self, const char* filename, GError** error) {
	char* result;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_inner_error_ = NULL;
	{
		char* name;
		GRegex* regex;
		GMatchInfo* match;
		GMatchInfo* _tmp2_;
		gboolean _tmp1_;
		GMatchInfo* _tmp0_;
		char* _tmp3_;
		name = NULL;
		regex = g_regex_new ("lib(.*)\\..*$", 0, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (name);
			goto __catch0_g_error;
			goto __finally0;
		}
		match = NULL;
		_tmp0_ = NULL;
		if (!(_tmp1_ = g_regex_match (regex, filename, 0, &_tmp0_), match = (_tmp2_ = _tmp0_, _g_match_info_free0 (match), _tmp2_), _tmp1_)) {
			_inner_error_ = g_error_new_literal (MODULE_ERROR, MODULE_ERROR_NONAME, "No name matched");
			if (_inner_error_ != NULL) {
				_g_free0 (name);
				_g_regex_unref0 (regex);
				_g_match_info_free0 (match);
				goto __catch0_g_error;
				goto __finally0;
			}
		}
		name = (_tmp3_ = g_match_info_fetch (match, 1), _g_free0 (name), _tmp3_);
		if (name == NULL) {
			_inner_error_ = g_error_new_literal (MODULE_ERROR, MODULE_ERROR_NONAME, "No name fetched");
			if (_inner_error_ != NULL) {
				_g_free0 (name);
				_g_regex_unref0 (regex);
				_g_match_info_free0 (match);
				goto __catch0_g_error;
				goto __finally0;
			}
		}
		result = name;
		_g_regex_unref0 (regex);
		_g_match_info_free0 (match);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* message;
			message = g_strdup_printf ("Unable to determine %s module name: %s", filename, e->message);
			_inner_error_ = g_error_new_literal (MODULE_ERROR, MODULE_ERROR_NONAME, message);
			if (_inner_error_ != NULL) {
				_g_error_free0 (e);
				_g_free0 (message);
				goto __finally0;
			}
			_g_error_free0 (e);
			_g_free0 (message);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == MODULE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
}


static void _g_slist_free_g_free (GSList* self) {
	g_slist_foreach (self, (GFunc) g_free, NULL);
	g_slist_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void gnome_scan_module_manager_query_modules (GnomeScanModuleManager* self) {
	GError * _inner_error_;
	GnomeScanModule* module;
	GDir* dir;
	char** _tmp1_;
	gint paths_size;
	gint paths_length1;
	char** _tmp0_;
	char** paths;
	GSList* loaded;
	char* name;
	char* module_name;
	char* filename;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	module = NULL;
	dir = NULL;
	paths = (_tmp1_ = _tmp0_ = g_strsplit (self->priv->_path, G_SEARCHPATH_SEPARATOR_S, 0), paths_length1 = _vala_array_length (_tmp0_), paths_size = paths_length1, _tmp1_);
	loaded = NULL;
	name = NULL;
	module_name = NULL;
	filename = NULL;
	{
		char** path_collection;
		int path_collection_length1;
		int path_it;
		path_collection = paths;
		path_collection_length1 = paths_length1;
		for (path_it = 0; path_it < paths_length1; path_it = path_it + 1) {
			char* path;
			path = g_strdup (path_collection[path_it]);
			{
				{
					GDir* _tmp2_;
					GDir* _tmp3_;
					_tmp2_ = g_dir_open (path, (guint) 0, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch1_g_error;
						goto __finally1;
					}
					dir = (_tmp3_ = _tmp2_, _g_dir_close0 (dir), _tmp3_);
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError * _error_;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					{
						if (g_utf8_get_char (g_utf8_offset_to_pointer (path, 0)) == '/') {
							g_warning ("gnome-scan-module-manager.vala:108: %s", _error_->message);
						}
						_g_error_free0 (_error_);
					}
				}
				__finally1:
				if (_inner_error_ != NULL) {
					_g_free0 (path);
					_g_object_unref0 (module);
					_g_dir_close0 (dir);
					paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
					__g_slist_free_g_free0 (loaded);
					_g_free0 (name);
					_g_free0 (module_name);
					_g_free0 (filename);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
				if (dir == NULL) {
					_g_free0 (path);
					continue;
				}
				while (TRUE) {
					char* _tmp4_;
					if (!((name = (_tmp4_ = g_strdup (g_dir_read_name (dir)), _g_free0 (name), _tmp4_)) != NULL)) {
						break;
					}
					{
						char* _tmp7_;
						char* _tmp8_;
						char* _tmp11_;
						GnomeScanModule* _tmp12_;
						if (!gnome_scan_module_manager_is_valid_module_name (name)) {
							char* _tmp5_;
							GError* _tmp6_;
							_inner_error_ = (_tmp6_ = g_error_new_literal (MODULE_ERROR, MODULE_ERROR_INVALID, _tmp5_ = g_strdup_printf ("%s: File not a module", name)), _g_free0 (_tmp5_), _tmp6_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == MODULE_ERROR) {
									goto __catch2_module_error;
								}
								goto __finally2;
							}
						}
						_tmp7_ = gnome_scan_module_manager_module_name_from_filename (self, name, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == MODULE_ERROR) {
								goto __catch2_module_error;
							}
							goto __finally2;
						}
						module_name = (_tmp8_ = _tmp7_, _g_free0 (module_name), _tmp8_);
						{
							GSList* lname_collection;
							GSList* lname_it;
							lname_collection = loaded;
							for (lname_it = lname_collection; lname_it != NULL; lname_it = lname_it->next) {
								char* lname;
								lname = g_strdup ((const char*) lname_it->data);
								{
									if (_vala_strcmp0 (module_name, lname) == 0) {
										char* _tmp9_;
										GError* _tmp10_;
										_inner_error_ = (_tmp10_ = g_error_new_literal (MODULE_ERROR, MODULE_ERROR_LOADED, _tmp9_ = g_strdup_printf ("%s: Module already loaded", name)), _g_free0 (_tmp9_), _tmp10_);
										if (_inner_error_ != NULL) {
											_g_free0 (lname);
											if (_inner_error_->domain == MODULE_ERROR) {
												goto __catch2_module_error;
											}
											goto __finally2;
										}
									}
									_g_free0 (lname);
								}
							}
						}
						filename = (_tmp11_ = g_build_filename (path, name, NULL), _g_free0 (filename), _tmp11_);
						module = (_tmp12_ = gnome_scan_module_new (filename), _g_object_unref0 (module), _tmp12_);
						if (!g_type_module_use ((GTypeModule*) module)) {
							_inner_error_ = g_error_new_literal (MODULE_ERROR, MODULE_ERROR_FAIL, g_module_error ());
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == MODULE_ERROR) {
									goto __catch2_module_error;
								}
								goto __finally2;
							}
						}
						self->priv->modules = g_slist_append (self->priv->modules, _g_object_ref0 ((GTypeModule*) module));
						loaded = g_slist_append (loaded, g_strdup (module_name));
					}
					goto __finally2;
					__catch2_module_error:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						{
							if (g_error_matches (e, MODULE_ERROR, MODULE_ERROR_FAIL)) {
								g_warning (e->message);
							}
							_g_error_free0 (e);
						}
					}
					__finally2:
					if (_inner_error_ != NULL) {
						_g_free0 (path);
						_g_object_unref0 (module);
						_g_dir_close0 (dir);
						paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
						__g_slist_free_g_free0 (loaded);
						_g_free0 (name);
						_g_free0 (module_name);
						_g_free0 (filename);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_g_free0 (path);
			}
		}
	}
	_g_object_unref0 (module);
	_g_dir_close0 (dir);
	paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
	__g_slist_free_g_free0 (loaded);
	_g_free0 (name);
	_g_free0 (module_name);
	_g_free0 (filename);
}


void gnome_scan_module_manager_unload_modules (GnomeScanModuleManager* self) {
	g_return_if_fail (self != NULL);
	{
		GSList* module_collection;
		GSList* module_it;
		module_collection = self->priv->modules;
		for (module_it = module_collection; module_it != NULL; module_it = module_it->next) {
			GTypeModule* module;
			module = _g_object_ref0 ((GTypeModule*) module_it->data);
			{
				g_type_module_unuse (module);
				_g_object_unref0 (module);
			}
		}
	}
}


static gboolean gnome_scan_module_manager_is_valid_module_name (const char* name) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = FALSE;
	if (g_str_has_prefix (name, "lib")) {
		gboolean _tmp1_;
		_tmp1_ = FALSE;
		if (g_str_has_suffix (name, G_MODULE_SUFFIX)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = g_str_has_suffix (name, ".la");
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


const char* gnome_scan_module_manager_get_path (GnomeScanModuleManager* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_path;
	return result;
}


void gnome_scan_module_manager_set_path (GnomeScanModuleManager* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_path = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_path), _tmp0_);
	g_object_notify ((GObject *) self, "path");
}


static void gnome_scan_module_manager_class_init (GnomeScanModuleManagerClass * klass) {
	gnome_scan_module_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanModuleManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_module_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_module_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_module_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_MODULE_MANAGER_PATH, g_param_spec_string ("path", "Path", "Module path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void gnome_scan_module_manager_instance_init (GnomeScanModuleManager * self) {
	self->priv = GNOME_SCAN_MODULE_MANAGER_GET_PRIVATE (self);
}


static void gnome_scan_module_manager_finalize (GObject* obj) {
	GnomeScanModuleManager * self;
	self = GNOME_SCAN_MODULE_MANAGER (obj);
	_g_free0 (self->priv->_path);
	__g_slist_free_g_object_unref0 (self->priv->modules);
	G_OBJECT_CLASS (gnome_scan_module_manager_parent_class)->finalize (obj);
}


GType gnome_scan_module_manager_get_type (void) {
	static GType gnome_scan_module_manager_type_id = 0;
	if (gnome_scan_module_manager_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanModuleManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_module_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanModuleManager), 0, (GInstanceInitFunc) gnome_scan_module_manager_instance_init, NULL };
		gnome_scan_module_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GnomeScanModuleManager", &g_define_type_info, 0);
	}
	return gnome_scan_module_manager_type_id;
}


static void gnome_scan_module_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanModuleManager * self;
	self = GNOME_SCAN_MODULE_MANAGER (object);
	switch (property_id) {
		case GNOME_SCAN_MODULE_MANAGER_PATH:
		g_value_set_string (value, gnome_scan_module_manager_get_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_module_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanModuleManager * self;
	self = GNOME_SCAN_MODULE_MANAGER (object);
	switch (property_id) {
		case GNOME_SCAN_MODULE_MANAGER_PATH:
		gnome_scan_module_manager_set_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




