/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2009  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define GNOME_SCAN_TYPE_PRESELECTION (gnome_scan_preselection_get_type ())
#define GNOME_SCAN_PRESELECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_PRESELECTION, GnomeScanPreselection))
#define GNOME_SCAN_PRESELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_PRESELECTION, GnomeScanPreselectionClass))
#define GNOME_SCAN_IS_PRESELECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_PRESELECTION))
#define GNOME_SCAN_IS_PRESELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_PRESELECTION))
#define GNOME_SCAN_PRESELECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_PRESELECTION, GnomeScanPreselectionClass))

typedef struct _GnomeScanPreselection GnomeScanPreselection;
typedef struct _GnomeScanPreselectionClass GnomeScanPreselectionClass;
typedef struct _GnomeScanPreselectionPrivate GnomeScanPreselectionPrivate;

#define GNOME_SCAN_TYPE_OPTION (gnome_scan_option_get_type ())
#define GNOME_SCAN_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOption))
#define GNOME_SCAN_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))
#define GNOME_SCAN_IS_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_IS_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))

typedef struct _GnomeScanOption GnomeScanOption;
typedef struct _GnomeScanOptionClass GnomeScanOptionClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GNOME_SCAN_TYPE_PRESEL_VALUE (gnome_scan_presel_value_get_type ())
#define GNOME_SCAN_PRESEL_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_PRESEL_VALUE, GnomeScanPreselValue))
#define GNOME_SCAN_PRESEL_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_PRESEL_VALUE, GnomeScanPreselValueClass))
#define GNOME_SCAN_IS_PRESEL_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_PRESEL_VALUE))
#define GNOME_SCAN_IS_PRESEL_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_PRESEL_VALUE))
#define GNOME_SCAN_PRESEL_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_PRESEL_VALUE, GnomeScanPreselValueClass))

typedef struct _GnomeScanPreselValue GnomeScanPreselValue;
typedef struct _GnomeScanPreselValueClass GnomeScanPreselValueClass;
typedef struct _GnomeScanPreselValuePrivate GnomeScanPreselValuePrivate;

#define GNOME_SCAN_TYPE_PRESEL_ENUM_VALUES (gnome_scan_presel_enum_values_get_type ())
#define GNOME_SCAN_PRESEL_ENUM_VALUES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_PRESEL_ENUM_VALUES, GnomeScanPreselEnumValues))
#define GNOME_SCAN_PRESEL_ENUM_VALUES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_PRESEL_ENUM_VALUES, GnomeScanPreselEnumValuesClass))
#define GNOME_SCAN_IS_PRESEL_ENUM_VALUES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_PRESEL_ENUM_VALUES))
#define GNOME_SCAN_IS_PRESEL_ENUM_VALUES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_PRESEL_ENUM_VALUES))
#define GNOME_SCAN_PRESEL_ENUM_VALUES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_PRESEL_ENUM_VALUES, GnomeScanPreselEnumValuesClass))

typedef struct _GnomeScanPreselEnumValues GnomeScanPreselEnumValues;
typedef struct _GnomeScanPreselEnumValuesClass GnomeScanPreselEnumValuesClass;
typedef struct _GnomeScanPreselEnumValuesPrivate GnomeScanPreselEnumValuesPrivate;

#define GNOME_SCAN_TYPE_ENUM_VALUE (gnome_scan_enum_value_get_type ())
typedef struct _GnomeScanEnumValue GnomeScanEnumValue;

#define GNOME_SCAN_TYPE_OPTION_ENUM (gnome_scan_option_enum_get_type ())
#define GNOME_SCAN_OPTION_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnum))
#define GNOME_SCAN_OPTION_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnumClass))
#define GNOME_SCAN_IS_OPTION_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_ENUM))
#define GNOME_SCAN_IS_OPTION_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_ENUM))
#define GNOME_SCAN_OPTION_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnumClass))

typedef struct _GnomeScanOptionEnum GnomeScanOptionEnum;
typedef struct _GnomeScanOptionEnumClass GnomeScanOptionEnumClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GnomeScanPreselection {
	GObject parent_instance;
	GnomeScanPreselectionPrivate * priv;
};

struct _GnomeScanPreselectionClass {
	GObjectClass parent_class;
	void (*apply) (GnomeScanPreselection* self, GnomeScanOption* option);
};

struct _GnomeScanPreselectionPrivate {
	char* _option_name;
};

struct _GnomeScanPreselValue {
	GnomeScanPreselection parent_instance;
	GnomeScanPreselValuePrivate * priv;
};

struct _GnomeScanPreselValueClass {
	GnomeScanPreselectionClass parent_class;
};

struct _GnomeScanPreselValuePrivate {
	GValue _value;
};

struct _GnomeScanPreselEnumValues {
	GnomeScanPreselection parent_instance;
	GnomeScanPreselEnumValuesPrivate * priv;
};

struct _GnomeScanPreselEnumValuesClass {
	GnomeScanPreselectionClass parent_class;
};

struct _GnomeScanEnumValue {
	GValue value;
	char* label;
	char* domain;
};

struct _GnomeScanPreselEnumValuesPrivate {
	GSList* _values;
};


static gpointer gnome_scan_preselection_parent_class = NULL;
static gpointer gnome_scan_presel_value_parent_class = NULL;
static gpointer gnome_scan_presel_enum_values_parent_class = NULL;

GType gnome_scan_preselection_get_type (void);
GType gnome_scan_option_get_type (void);
#define GNOME_SCAN_PRESELECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_PRESELECTION, GnomeScanPreselectionPrivate))
enum  {
	GNOME_SCAN_PRESELECTION_DUMMY_PROPERTY,
	GNOME_SCAN_PRESELECTION_OPTION_NAME
};
const char* gnome_scan_option_get_name (GnomeScanOption* self);
void gnome_scan_preselection_apply (GnomeScanPreselection* self, GnomeScanOption* option);
static void gnome_scan_preselection_real_apply (GnomeScanPreselection* self, GnomeScanOption* option);
GnomeScanPreselection* gnome_scan_preselection_construct (GType object_type);
const char* gnome_scan_preselection_get_option_name (GnomeScanPreselection* self);
void gnome_scan_preselection_set_option_name (GnomeScanPreselection* self, const char* value);
static void gnome_scan_preselection_finalize (GObject* obj);
static void gnome_scan_preselection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gnome_scan_preselection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType gnome_scan_presel_value_get_type (void);
#define GNOME_SCAN_PRESEL_VALUE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_PRESEL_VALUE, GnomeScanPreselValuePrivate))
enum  {
	GNOME_SCAN_PRESEL_VALUE_DUMMY_PROPERTY,
	GNOME_SCAN_PRESEL_VALUE_VALUE
};
void gnome_scan_presel_value_set_value (GnomeScanPreselValue* self, GValue* value);
GnomeScanPreselValue* gnome_scan_presel_value_new (const char* option_name, const GValue* value);
GnomeScanPreselValue* gnome_scan_presel_value_construct (GType object_type, const char* option_name, const GValue* value);
void gnome_scan_option_set_g_value (GnomeScanOption* self, const GValue* value);
void gnome_scan_presel_value_get_value (GnomeScanPreselValue* self, GValue* result);
static void gnome_scan_presel_value_real_apply (GnomeScanPreselection* base, GnomeScanOption* option);
static void gnome_scan_presel_value_finalize (GObject* obj);
static void gnome_scan_presel_value_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gnome_scan_presel_value_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType gnome_scan_presel_enum_values_get_type (void);
GType gnome_scan_enum_value_get_type (void);
GnomeScanEnumValue* gnome_scan_enum_value_dup (const GnomeScanEnumValue* self);
void gnome_scan_enum_value_free (GnomeScanEnumValue* self);
void gnome_scan_enum_value_copy (const GnomeScanEnumValue* self, GnomeScanEnumValue* dest);
void gnome_scan_enum_value_destroy (GnomeScanEnumValue* self);
#define GNOME_SCAN_PRESEL_ENUM_VALUES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_PRESEL_ENUM_VALUES, GnomeScanPreselEnumValuesPrivate))
enum  {
	GNOME_SCAN_PRESEL_ENUM_VALUES_DUMMY_PROPERTY,
	GNOME_SCAN_PRESEL_ENUM_VALUES_VALUES
};
void gnome_scan_presel_enum_values_set_values (GnomeScanPreselEnumValues* self, GSList* value);
GnomeScanPreselEnumValues* gnome_scan_presel_enum_values_new (const char* option_name, GSList* values);
GnomeScanPreselEnumValues* gnome_scan_presel_enum_values_construct (GType object_type, const char* option_name, GSList* values);
GType gnome_scan_option_enum_get_type (void);
GSList* gnome_scan_presel_enum_values_get_values (GnomeScanPreselEnumValues* self);
void gnome_scan_option_enum_append (GnomeScanOptionEnum* self, const GnomeScanEnumValue* value);
static void gnome_scan_presel_enum_values_real_apply (GnomeScanPreselection* base, GnomeScanOption* option);
static void gnome_scan_presel_enum_values_finalize (GObject* obj);
static void gnome_scan_presel_enum_values_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gnome_scan_presel_enum_values_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static void gnome_scan_preselection_real_apply (GnomeScanPreselection* self, GnomeScanOption* option) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	g_message ("gnome-scan-preselection.vala:30: %s does not implement apply, asked for option %s %s", g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) self)), g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) option)), gnome_scan_option_get_name (option));
}


void gnome_scan_preselection_apply (GnomeScanPreselection* self, GnomeScanOption* option) {
	GNOME_SCAN_PRESELECTION_GET_CLASS (self)->apply (self, option);
}


GnomeScanPreselection* gnome_scan_preselection_construct (GType object_type) {
	GnomeScanPreselection * self;
	self = (GnomeScanPreselection*) g_object_new (object_type, NULL);
	return self;
}


const char* gnome_scan_preselection_get_option_name (GnomeScanPreselection* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_option_name;
	return result;
}


void gnome_scan_preselection_set_option_name (GnomeScanPreselection* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_option_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_option_name), _tmp0_);
	g_object_notify ((GObject *) self, "option-name");
}


static void gnome_scan_preselection_class_init (GnomeScanPreselectionClass * klass) {
	gnome_scan_preselection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanPreselectionPrivate));
	GNOME_SCAN_PRESELECTION_CLASS (klass)->apply = gnome_scan_preselection_real_apply;
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_preselection_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_preselection_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_preselection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_PRESELECTION_OPTION_NAME, g_param_spec_string ("option-name", "option-name", "option-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void gnome_scan_preselection_instance_init (GnomeScanPreselection * self) {
	self->priv = GNOME_SCAN_PRESELECTION_GET_PRIVATE (self);
}


static void gnome_scan_preselection_finalize (GObject* obj) {
	GnomeScanPreselection * self;
	self = GNOME_SCAN_PRESELECTION (obj);
	_g_free0 (self->priv->_option_name);
	G_OBJECT_CLASS (gnome_scan_preselection_parent_class)->finalize (obj);
}


GType gnome_scan_preselection_get_type (void) {
	static GType gnome_scan_preselection_type_id = 0;
	if (gnome_scan_preselection_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanPreselectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_preselection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanPreselection), 0, (GInstanceInitFunc) gnome_scan_preselection_instance_init, NULL };
		gnome_scan_preselection_type_id = g_type_register_static (G_TYPE_OBJECT, "GnomeScanPreselection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return gnome_scan_preselection_type_id;
}


static void gnome_scan_preselection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanPreselection * self;
	self = GNOME_SCAN_PRESELECTION (object);
	switch (property_id) {
		case GNOME_SCAN_PRESELECTION_OPTION_NAME:
		g_value_set_string (value, gnome_scan_preselection_get_option_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_preselection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanPreselection * self;
	self = GNOME_SCAN_PRESELECTION (object);
	switch (property_id) {
		case GNOME_SCAN_PRESELECTION_OPTION_NAME:
		gnome_scan_preselection_set_option_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GnomeScanPreselValue* gnome_scan_presel_value_construct (GType object_type, const char* option_name, const GValue* value) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanPreselValue * self;
	g_return_val_if_fail (option_name != NULL, NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "option-name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, option_name);
	__params_it++;
	__params_it->name = "value";
	g_value_init (&__params_it->value, G_TYPE_VALUE);
	g_value_set_boxed (&__params_it->value, &(*value));
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanPreselValue* gnome_scan_presel_value_new (const char* option_name, const GValue* value) {
	return gnome_scan_presel_value_construct (GNOME_SCAN_TYPE_PRESEL_VALUE, option_name, value);
}


static void gnome_scan_presel_value_real_apply (GnomeScanPreselection* base, GnomeScanOption* option) {
	GnomeScanPreselValue * self;
	self = (GnomeScanPreselValue*) base;
	g_return_if_fail (option != NULL);
	gnome_scan_option_set_g_value (option, &self->priv->_value);
}


void gnome_scan_presel_value_get_value (GnomeScanPreselValue* self, GValue* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_value;
	return;
}


void gnome_scan_presel_value_set_value (GnomeScanPreselValue* self, GValue* value) {
	GValue _tmp1_;
	GValue _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	self->priv->_value = (_tmp1_ = G_IS_VALUE (&(*value)) ? (g_value_init (&_tmp0_, G_VALUE_TYPE (&(*value))), g_value_copy (&(*value), &_tmp0_), _tmp0_) : (*value), G_IS_VALUE (&self->priv->_value) ? (g_value_unset (&self->priv->_value), NULL) : NULL, _tmp1_);
	g_object_notify ((GObject *) self, "value");
}


static void gnome_scan_presel_value_class_init (GnomeScanPreselValueClass * klass) {
	gnome_scan_presel_value_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanPreselValuePrivate));
	GNOME_SCAN_PRESELECTION_CLASS (klass)->apply = gnome_scan_presel_value_real_apply;
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_presel_value_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_presel_value_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_presel_value_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_PRESEL_VALUE_VALUE, g_param_spec_boxed ("value", "value", "value", G_TYPE_VALUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void gnome_scan_presel_value_instance_init (GnomeScanPreselValue * self) {
	self->priv = GNOME_SCAN_PRESEL_VALUE_GET_PRIVATE (self);
}


static void gnome_scan_presel_value_finalize (GObject* obj) {
	GnomeScanPreselValue * self;
	self = GNOME_SCAN_PRESEL_VALUE (obj);
	G_IS_VALUE (&self->priv->_value) ? (g_value_unset (&self->priv->_value), NULL) : NULL;
	G_OBJECT_CLASS (gnome_scan_presel_value_parent_class)->finalize (obj);
}


GType gnome_scan_presel_value_get_type (void) {
	static GType gnome_scan_presel_value_type_id = 0;
	if (gnome_scan_presel_value_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanPreselValueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_presel_value_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanPreselValue), 0, (GInstanceInitFunc) gnome_scan_presel_value_instance_init, NULL };
		gnome_scan_presel_value_type_id = g_type_register_static (GNOME_SCAN_TYPE_PRESELECTION, "GnomeScanPreselValue", &g_define_type_info, 0);
	}
	return gnome_scan_presel_value_type_id;
}


static void gnome_scan_presel_value_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanPreselValue * self;
	gpointer boxed;
	self = GNOME_SCAN_PRESEL_VALUE (object);
	switch (property_id) {
		case GNOME_SCAN_PRESEL_VALUE_VALUE:
		boxed = g_new0 (GValue, 1);
		gnome_scan_presel_value_get_value (self, boxed);
		g_value_take_boxed (value, boxed);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_presel_value_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanPreselValue * self;
	self = GNOME_SCAN_PRESEL_VALUE (object);
	switch (property_id) {
		case GNOME_SCAN_PRESEL_VALUE_VALUE:
		gnome_scan_presel_value_set_value (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GnomeScanPreselEnumValues* gnome_scan_presel_enum_values_construct (GType object_type, const char* option_name, GSList* values) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanPreselEnumValues * self;
	g_return_val_if_fail (option_name != NULL, NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "option-name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, option_name);
	__params_it++;
	__params_it->name = "values";
	g_value_init (&__params_it->value, G_TYPE_POINTER);
	g_value_set_pointer (&__params_it->value, values);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanPreselEnumValues* gnome_scan_presel_enum_values_new (const char* option_name, GSList* values) {
	return gnome_scan_presel_enum_values_construct (GNOME_SCAN_TYPE_PRESEL_ENUM_VALUES, option_name, values);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gnome_scan_presel_enum_values_real_apply (GnomeScanPreselection* base, GnomeScanOption* option) {
	GnomeScanPreselEnumValues * self;
	GnomeScanOption* _tmp0_;
	GnomeScanOptionEnum* opt;
	self = (GnomeScanPreselEnumValues*) base;
	g_return_if_fail (option != NULL);
	if (!GNOME_SCAN_IS_OPTION_ENUM (option)) {
		return;
	}
	opt = _g_object_ref0 ((_tmp0_ = option, GNOME_SCAN_IS_OPTION_ENUM (_tmp0_) ? ((GnomeScanOptionEnum*) _tmp0_) : NULL));
	{
		GSList* value_collection;
		GSList* value_it;
		value_collection = self->priv->_values;
		for (value_it = value_collection; value_it != NULL; value_it = value_it->next) {
			GnomeScanEnumValue value;
			value = *((GnomeScanEnumValue*) value_it->data);
			{
				gnome_scan_option_enum_append (opt, &value);
			}
		}
	}
	_g_object_unref0 (opt);
}


GSList* gnome_scan_presel_enum_values_get_values (GnomeScanPreselEnumValues* self) {
	GSList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_values;
	return result;
}


void gnome_scan_presel_enum_values_set_values (GnomeScanPreselEnumValues* self, GSList* value) {
	g_return_if_fail (self != NULL);
	self->priv->_values = value;
	g_object_notify ((GObject *) self, "values");
}


static void gnome_scan_presel_enum_values_class_init (GnomeScanPreselEnumValuesClass * klass) {
	gnome_scan_presel_enum_values_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanPreselEnumValuesPrivate));
	GNOME_SCAN_PRESELECTION_CLASS (klass)->apply = gnome_scan_presel_enum_values_real_apply;
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_presel_enum_values_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_presel_enum_values_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_presel_enum_values_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_PRESEL_ENUM_VALUES_VALUES, g_param_spec_pointer ("values", "values", "values", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void gnome_scan_presel_enum_values_instance_init (GnomeScanPreselEnumValues * self) {
	self->priv = GNOME_SCAN_PRESEL_ENUM_VALUES_GET_PRIVATE (self);
}


static void gnome_scan_presel_enum_values_finalize (GObject* obj) {
	GnomeScanPreselEnumValues * self;
	self = GNOME_SCAN_PRESEL_ENUM_VALUES (obj);
	G_OBJECT_CLASS (gnome_scan_presel_enum_values_parent_class)->finalize (obj);
}


GType gnome_scan_presel_enum_values_get_type (void) {
	static GType gnome_scan_presel_enum_values_type_id = 0;
	if (gnome_scan_presel_enum_values_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanPreselEnumValuesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_presel_enum_values_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanPreselEnumValues), 0, (GInstanceInitFunc) gnome_scan_presel_enum_values_instance_init, NULL };
		gnome_scan_presel_enum_values_type_id = g_type_register_static (GNOME_SCAN_TYPE_PRESELECTION, "GnomeScanPreselEnumValues", &g_define_type_info, 0);
	}
	return gnome_scan_presel_enum_values_type_id;
}


static void gnome_scan_presel_enum_values_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanPreselEnumValues * self;
	self = GNOME_SCAN_PRESEL_ENUM_VALUES (object);
	switch (property_id) {
		case GNOME_SCAN_PRESEL_ENUM_VALUES_VALUES:
		g_value_set_pointer (value, gnome_scan_presel_enum_values_get_values (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_presel_enum_values_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanPreselEnumValues * self;
	self = GNOME_SCAN_PRESEL_ENUM_VALUES (object);
	switch (property_id) {
		case GNOME_SCAN_PRESEL_ENUM_VALUES_VALUES:
		gnome_scan_presel_enum_values_set_values (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




