
#ifndef __GNOME_SCAN_H__
#define __GNOME_SCAN_H__

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gegl.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS


#define GNOME_SCAN_TYPE_UNIT (gnome_scan_unit_get_type ())

#define GNOME_SCAN_TYPE_STATUS (gnome_scan_status_get_type ())

#define GNOME_SCAN_TYPE_POINT (gnome_scan_point_get_type ())
typedef struct _GnomeScanPoint GnomeScanPoint;

#define GNOME_SCAN_TYPE_EXTENT (gnome_scan_extent_get_type ())
typedef struct _GnomeScanExtent GnomeScanExtent;

#define GNOME_SCAN_TYPE_RANGE (gnome_scan_range_get_type ())
typedef struct _GnomeScanRange GnomeScanRange;

#define GNOME_SCAN_TYPE_FORMAT (gnome_scan_format_get_type ())
#define GNOME_SCAN_FORMAT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_FORMAT, GnomeScanFormat))
#define GNOME_SCAN_FORMAT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_FORMAT, GnomeScanFormatClass))
#define GNOME_SCAN_IS_FORMAT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_FORMAT))
#define GNOME_SCAN_IS_FORMAT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_FORMAT))
#define GNOME_SCAN_FORMAT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_FORMAT, GnomeScanFormatClass))

typedef struct _GnomeScanFormat GnomeScanFormat;
typedef struct _GnomeScanFormatClass GnomeScanFormatClass;
typedef struct _GnomeScanFormatPrivate GnomeScanFormatPrivate;

#define GNOME_SCAN_TYPE_ENUM_VALUE (gnome_scan_enum_value_get_type ())
typedef struct _GnomeScanEnumValue GnomeScanEnumValue;
typedef struct _GnomeScanRectangle GnomeScanRectangle;

#define GNOME_SCAN_TYPE_MODULE (gnome_scan_module_get_type ())
#define GNOME_SCAN_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_MODULE, GnomeScanModule))
#define GNOME_SCAN_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_MODULE, GnomeScanModuleClass))
#define GNOME_SCAN_IS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_MODULE))
#define GNOME_SCAN_IS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_MODULE))
#define GNOME_SCAN_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_MODULE, GnomeScanModuleClass))

typedef struct _GnomeScanModule GnomeScanModule;
typedef struct _GnomeScanModuleClass GnomeScanModuleClass;
typedef struct _GnomeScanModulePrivate GnomeScanModulePrivate;

#define GNOME_SCAN_TYPE_MODULE_MANAGER (gnome_scan_module_manager_get_type ())
#define GNOME_SCAN_MODULE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_MODULE_MANAGER, GnomeScanModuleManager))
#define GNOME_SCAN_MODULE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_MODULE_MANAGER, GnomeScanModuleManagerClass))
#define GNOME_SCAN_IS_MODULE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_MODULE_MANAGER))
#define GNOME_SCAN_IS_MODULE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_MODULE_MANAGER))
#define GNOME_SCAN_MODULE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_MODULE_MANAGER, GnomeScanModuleManagerClass))

typedef struct _GnomeScanModuleManager GnomeScanModuleManager;
typedef struct _GnomeScanModuleManagerClass GnomeScanModuleManagerClass;
typedef struct _GnomeScanModuleManagerPrivate GnomeScanModuleManagerPrivate;

#define GNOME_SCAN_TYPE_OPTION_HINT (gnome_scan_option_hint_get_type ())

#define GNOME_SCAN_TYPE_OPTION (gnome_scan_option_get_type ())
#define GNOME_SCAN_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOption))
#define GNOME_SCAN_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))
#define GNOME_SCAN_IS_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_IS_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))

typedef struct _GnomeScanOption GnomeScanOption;
typedef struct _GnomeScanOptionClass GnomeScanOptionClass;
typedef struct _GnomeScanOptionPrivate GnomeScanOptionPrivate;

#define GNOME_SCAN_TYPE_OPTION_BOOL (gnome_scan_option_bool_get_type ())
#define GNOME_SCAN_OPTION_BOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_BOOL, GnomeScanOptionBool))
#define GNOME_SCAN_OPTION_BOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_BOOL, GnomeScanOptionBoolClass))
#define GNOME_SCAN_IS_OPTION_BOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_BOOL))
#define GNOME_SCAN_IS_OPTION_BOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_BOOL))
#define GNOME_SCAN_OPTION_BOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_BOOL, GnomeScanOptionBoolClass))

typedef struct _GnomeScanOptionBool GnomeScanOptionBool;
typedef struct _GnomeScanOptionBoolClass GnomeScanOptionBoolClass;
typedef struct _GnomeScanOptionBoolPrivate GnomeScanOptionBoolPrivate;

#define GNOME_SCAN_TYPE_OPTION_NUMBER (gnome_scan_option_number_get_type ())
#define GNOME_SCAN_OPTION_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_NUMBER, GnomeScanOptionNumber))
#define GNOME_SCAN_OPTION_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_NUMBER, GnomeScanOptionNumberClass))
#define GNOME_SCAN_IS_OPTION_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_NUMBER))
#define GNOME_SCAN_IS_OPTION_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_NUMBER))
#define GNOME_SCAN_OPTION_NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_NUMBER, GnomeScanOptionNumberClass))

typedef struct _GnomeScanOptionNumber GnomeScanOptionNumber;
typedef struct _GnomeScanOptionNumberClass GnomeScanOptionNumberClass;
typedef struct _GnomeScanOptionNumberPrivate GnomeScanOptionNumberPrivate;

#define GNOME_SCAN_TYPE_OPTION_STRING (gnome_scan_option_string_get_type ())
#define GNOME_SCAN_OPTION_STRING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_STRING, GnomeScanOptionString))
#define GNOME_SCAN_OPTION_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_STRING, GnomeScanOptionStringClass))
#define GNOME_SCAN_IS_OPTION_STRING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_STRING))
#define GNOME_SCAN_IS_OPTION_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_STRING))
#define GNOME_SCAN_OPTION_STRING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_STRING, GnomeScanOptionStringClass))

typedef struct _GnomeScanOptionString GnomeScanOptionString;
typedef struct _GnomeScanOptionStringClass GnomeScanOptionStringClass;
typedef struct _GnomeScanOptionStringPrivate GnomeScanOptionStringPrivate;

#define GNOME_SCAN_TYPE_OPTION_ENUM (gnome_scan_option_enum_get_type ())
#define GNOME_SCAN_OPTION_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnum))
#define GNOME_SCAN_OPTION_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnumClass))
#define GNOME_SCAN_IS_OPTION_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_ENUM))
#define GNOME_SCAN_IS_OPTION_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_ENUM))
#define GNOME_SCAN_OPTION_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnumClass))

typedef struct _GnomeScanOptionEnum GnomeScanOptionEnum;
typedef struct _GnomeScanOptionEnumClass GnomeScanOptionEnumClass;
typedef struct _GnomeScanOptionEnumPrivate GnomeScanOptionEnumPrivate;

#define GNOME_SCAN_TYPE_OPTION_PAPER_SIZE (gnome_scan_option_paper_size_get_type ())
#define GNOME_SCAN_OPTION_PAPER_SIZE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_PAPER_SIZE, GnomeScanOptionPaperSize))
#define GNOME_SCAN_OPTION_PAPER_SIZE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_PAPER_SIZE, GnomeScanOptionPaperSizeClass))
#define GNOME_SCAN_IS_OPTION_PAPER_SIZE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_PAPER_SIZE))
#define GNOME_SCAN_IS_OPTION_PAPER_SIZE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_PAPER_SIZE))
#define GNOME_SCAN_OPTION_PAPER_SIZE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_PAPER_SIZE, GnomeScanOptionPaperSizeClass))

typedef struct _GnomeScanOptionPaperSize GnomeScanOptionPaperSize;
typedef struct _GnomeScanOptionPaperSizeClass GnomeScanOptionPaperSizeClass;
typedef struct _GnomeScanOptionPaperSizePrivate GnomeScanOptionPaperSizePrivate;

#define GNOME_SCAN_TYPE_OPTION_BOXED (gnome_scan_option_boxed_get_type ())
#define GNOME_SCAN_OPTION_BOXED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_BOXED, GnomeScanOptionBoxed))
#define GNOME_SCAN_OPTION_BOXED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_BOXED, GnomeScanOptionBoxedClass))
#define GNOME_SCAN_IS_OPTION_BOXED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_BOXED))
#define GNOME_SCAN_IS_OPTION_BOXED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_BOXED))
#define GNOME_SCAN_OPTION_BOXED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_BOXED, GnomeScanOptionBoxedClass))

typedef struct _GnomeScanOptionBoxed GnomeScanOptionBoxed;
typedef struct _GnomeScanOptionBoxedClass GnomeScanOptionBoxedClass;
typedef struct _GnomeScanOptionBoxedPrivate GnomeScanOptionBoxedPrivate;

#define GNOME_SCAN_TYPE_OPTION_POINTER (gnome_scan_option_pointer_get_type ())
#define GNOME_SCAN_OPTION_POINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_POINTER, GnomeScanOptionPointer))
#define GNOME_SCAN_OPTION_POINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_POINTER, GnomeScanOptionPointerClass))
#define GNOME_SCAN_IS_OPTION_POINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_POINTER))
#define GNOME_SCAN_IS_OPTION_POINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_POINTER))
#define GNOME_SCAN_OPTION_POINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_POINTER, GnomeScanOptionPointerClass))

typedef struct _GnomeScanOptionPointer GnomeScanOptionPointer;
typedef struct _GnomeScanOptionPointerClass GnomeScanOptionPointerClass;
typedef struct _GnomeScanOptionPointerPrivate GnomeScanOptionPointerPrivate;

#define GNOME_SCAN_TYPE_NODE (gnome_scan_node_get_type ())
#define GNOME_SCAN_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_NODE, GnomeScanNode))
#define GNOME_SCAN_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_NODE, GnomeScanNodeClass))
#define GNOME_SCAN_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_NODE))
#define GNOME_SCAN_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_NODE))
#define GNOME_SCAN_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_NODE, GnomeScanNodeClass))

typedef struct _GnomeScanNode GnomeScanNode;
typedef struct _GnomeScanNodeClass GnomeScanNodeClass;
typedef struct _GnomeScanNodePrivate GnomeScanNodePrivate;

#define GNOME_SCAN_TYPE_SCANNER (gnome_scan_scanner_get_type ())
#define GNOME_SCAN_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_SCANNER, GnomeScanScanner))
#define GNOME_SCAN_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_SCANNER, GnomeScanScannerClass))
#define GNOME_SCAN_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_SCANNER))
#define GNOME_SCAN_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_SCANNER))
#define GNOME_SCAN_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_SCANNER, GnomeScanScannerClass))

typedef struct _GnomeScanScanner GnomeScanScanner;
typedef struct _GnomeScanScannerClass GnomeScanScannerClass;
typedef struct _GnomeScanScannerPrivate GnomeScanScannerPrivate;

#define GNOME_SCAN_TYPE_SINK (gnome_scan_sink_get_type ())
#define GNOME_SCAN_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_SINK, GnomeScanSink))
#define GNOME_SCAN_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_SINK, GnomeScanSinkClass))
#define GNOME_SCAN_IS_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_SINK))
#define GNOME_SCAN_IS_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_SINK))
#define GNOME_SCAN_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_SINK, GnomeScanSinkClass))

typedef struct _GnomeScanSink GnomeScanSink;
typedef struct _GnomeScanSinkClass GnomeScanSinkClass;
typedef struct _GnomeScanSinkPrivate GnomeScanSinkPrivate;

#define GNOME_SCAN_TYPE_PRESELECTION (gnome_scan_preselection_get_type ())
#define GNOME_SCAN_PRESELECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_PRESELECTION, GnomeScanPreselection))
#define GNOME_SCAN_PRESELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_PRESELECTION, GnomeScanPreselectionClass))
#define GNOME_SCAN_IS_PRESELECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_PRESELECTION))
#define GNOME_SCAN_IS_PRESELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_PRESELECTION))
#define GNOME_SCAN_PRESELECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_PRESELECTION, GnomeScanPreselectionClass))

typedef struct _GnomeScanPreselection GnomeScanPreselection;
typedef struct _GnomeScanPreselectionClass GnomeScanPreselectionClass;
typedef struct _GnomeScanPreselectionPrivate GnomeScanPreselectionPrivate;

#define GNOME_SCAN_TYPE_PRESEL_VALUE (gnome_scan_presel_value_get_type ())
#define GNOME_SCAN_PRESEL_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_PRESEL_VALUE, GnomeScanPreselValue))
#define GNOME_SCAN_PRESEL_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_PRESEL_VALUE, GnomeScanPreselValueClass))
#define GNOME_SCAN_IS_PRESEL_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_PRESEL_VALUE))
#define GNOME_SCAN_IS_PRESEL_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_PRESEL_VALUE))
#define GNOME_SCAN_PRESEL_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_PRESEL_VALUE, GnomeScanPreselValueClass))

typedef struct _GnomeScanPreselValue GnomeScanPreselValue;
typedef struct _GnomeScanPreselValueClass GnomeScanPreselValueClass;
typedef struct _GnomeScanPreselValuePrivate GnomeScanPreselValuePrivate;

#define GNOME_SCAN_TYPE_PRESEL_ENUM_VALUES (gnome_scan_presel_enum_values_get_type ())
#define GNOME_SCAN_PRESEL_ENUM_VALUES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_PRESEL_ENUM_VALUES, GnomeScanPreselEnumValues))
#define GNOME_SCAN_PRESEL_ENUM_VALUES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_PRESEL_ENUM_VALUES, GnomeScanPreselEnumValuesClass))
#define GNOME_SCAN_IS_PRESEL_ENUM_VALUES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_PRESEL_ENUM_VALUES))
#define GNOME_SCAN_IS_PRESEL_ENUM_VALUES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_PRESEL_ENUM_VALUES))
#define GNOME_SCAN_PRESEL_ENUM_VALUES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_PRESEL_ENUM_VALUES, GnomeScanPreselEnumValuesClass))

typedef struct _GnomeScanPreselEnumValues GnomeScanPreselEnumValues;
typedef struct _GnomeScanPreselEnumValuesClass GnomeScanPreselEnumValuesClass;
typedef struct _GnomeScanPreselEnumValuesPrivate GnomeScanPreselEnumValuesPrivate;

#define GNOME_SCAN_TYPE_JOB (gnome_scan_job_get_type ())
#define GNOME_SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_JOB, GnomeScanJob))
#define GNOME_SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_JOB, GnomeScanJobClass))
#define GNOME_SCAN_IS_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_JOB))
#define GNOME_SCAN_IS_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_JOB))
#define GNOME_SCAN_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_JOB, GnomeScanJobClass))

typedef struct _GnomeScanJob GnomeScanJob;
typedef struct _GnomeScanJobClass GnomeScanJobClass;
typedef struct _GnomeScanJobPrivate GnomeScanJobPrivate;

#define GNOME_SCAN_TYPE_BACKEND (gnome_scan_backend_get_type ())
#define GNOME_SCAN_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_BACKEND, GnomeScanBackend))
#define GNOME_SCAN_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_BACKEND, GnomeScanBackendClass))
#define GNOME_SCAN_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_BACKEND))
#define GNOME_SCAN_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_BACKEND))
#define GNOME_SCAN_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_BACKEND, GnomeScanBackendClass))

typedef struct _GnomeScanBackend GnomeScanBackend;
typedef struct _GnomeScanBackendClass GnomeScanBackendClass;
typedef struct _GnomeScanBackendPrivate GnomeScanBackendPrivate;

#define GNOME_SCAN_TYPE_OPTION_MANAGER (gnome_scan_option_manager_get_type ())
#define GNOME_SCAN_OPTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_MANAGER, GnomeScanOptionManager))
#define GNOME_SCAN_OPTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_MANAGER, GnomeScanOptionManagerClass))
#define GNOME_SCAN_IS_OPTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_MANAGER))
#define GNOME_SCAN_IS_OPTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_MANAGER))
#define GNOME_SCAN_OPTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_MANAGER, GnomeScanOptionManagerClass))

typedef struct _GnomeScanOptionManager GnomeScanOptionManager;
typedef struct _GnomeScanOptionManagerClass GnomeScanOptionManagerClass;
typedef struct _GnomeScanOptionManagerPrivate GnomeScanOptionManagerPrivate;

#define GNOME_SCAN_TYPE_OPTION_WIDGET (gnome_scan_option_widget_get_type ())
#define GNOME_SCAN_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidget))
#define GNOME_SCAN_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))
#define GNOME_SCAN_IS_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_IS_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_OPTION_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))

typedef struct _GnomeScanOptionWidget GnomeScanOptionWidget;
typedef struct _GnomeScanOptionWidgetClass GnomeScanOptionWidgetClass;
typedef struct _GnomeScanOptionWidgetPrivate GnomeScanOptionWidgetPrivate;

#define GNOME_SCAN_TYPE_CHECKBOX_WIDGET (gnome_scan_checkbox_widget_get_type ())
#define GNOME_SCAN_CHECKBOX_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_CHECKBOX_WIDGET, GnomeScanCheckboxWidget))
#define GNOME_SCAN_CHECKBOX_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_CHECKBOX_WIDGET, GnomeScanCheckboxWidgetClass))
#define GNOME_SCAN_IS_CHECKBOX_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_CHECKBOX_WIDGET))
#define GNOME_SCAN_IS_CHECKBOX_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_CHECKBOX_WIDGET))
#define GNOME_SCAN_CHECKBOX_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_CHECKBOX_WIDGET, GnomeScanCheckboxWidgetClass))

typedef struct _GnomeScanCheckboxWidget GnomeScanCheckboxWidget;
typedef struct _GnomeScanCheckboxWidgetClass GnomeScanCheckboxWidgetClass;
typedef struct _GnomeScanCheckboxWidgetPrivate GnomeScanCheckboxWidgetPrivate;

#define GNOME_SCAN_TYPE_SCALE_WIDGET (gnome_scan_scale_widget_get_type ())
#define GNOME_SCAN_SCALE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_SCALE_WIDGET, GnomeScanScaleWidget))
#define GNOME_SCAN_SCALE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_SCALE_WIDGET, GnomeScanScaleWidgetClass))
#define GNOME_SCAN_IS_SCALE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_SCALE_WIDGET))
#define GNOME_SCAN_IS_SCALE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_SCALE_WIDGET))
#define GNOME_SCAN_SCALE_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_SCALE_WIDGET, GnomeScanScaleWidgetClass))

typedef struct _GnomeScanScaleWidget GnomeScanScaleWidget;
typedef struct _GnomeScanScaleWidgetClass GnomeScanScaleWidgetClass;
typedef struct _GnomeScanScaleWidgetPrivate GnomeScanScaleWidgetPrivate;

#define GNOME_SCAN_TYPE_ENTRY_WIDGET (gnome_scan_entry_widget_get_type ())
#define GNOME_SCAN_ENTRY_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_ENTRY_WIDGET, GnomeScanEntryWidget))
#define GNOME_SCAN_ENTRY_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_ENTRY_WIDGET, GnomeScanEntryWidgetClass))
#define GNOME_SCAN_IS_ENTRY_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_ENTRY_WIDGET))
#define GNOME_SCAN_IS_ENTRY_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_ENTRY_WIDGET))
#define GNOME_SCAN_ENTRY_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_ENTRY_WIDGET, GnomeScanEntryWidgetClass))

typedef struct _GnomeScanEntryWidget GnomeScanEntryWidget;
typedef struct _GnomeScanEntryWidgetClass GnomeScanEntryWidgetClass;
typedef struct _GnomeScanEntryWidgetPrivate GnomeScanEntryWidgetPrivate;

#define GNOME_SCAN_TYPE_COMBO_BOX_WIDGET (gnome_scan_combo_box_widget_get_type ())
#define GNOME_SCAN_COMBO_BOX_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_COMBO_BOX_WIDGET, GnomeScanComboBoxWidget))
#define GNOME_SCAN_COMBO_BOX_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_COMBO_BOX_WIDGET, GnomeScanComboBoxWidgetClass))
#define GNOME_SCAN_IS_COMBO_BOX_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_COMBO_BOX_WIDGET))
#define GNOME_SCAN_IS_COMBO_BOX_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_COMBO_BOX_WIDGET))
#define GNOME_SCAN_COMBO_BOX_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_COMBO_BOX_WIDGET, GnomeScanComboBoxWidgetClass))

typedef struct _GnomeScanComboBoxWidget GnomeScanComboBoxWidget;
typedef struct _GnomeScanComboBoxWidgetClass GnomeScanComboBoxWidgetClass;
typedef struct _GnomeScanComboBoxWidgetPrivate GnomeScanComboBoxWidgetPrivate;

#define GNOME_SCAN_TYPE_PAPER_SIZE_WIDGET (gnome_scan_paper_size_widget_get_type ())
#define GNOME_SCAN_PAPER_SIZE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_PAPER_SIZE_WIDGET, GnomeScanPaperSizeWidget))
#define GNOME_SCAN_PAPER_SIZE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_PAPER_SIZE_WIDGET, GnomeScanPaperSizeWidgetClass))
#define GNOME_SCAN_IS_PAPER_SIZE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_PAPER_SIZE_WIDGET))
#define GNOME_SCAN_IS_PAPER_SIZE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_PAPER_SIZE_WIDGET))
#define GNOME_SCAN_PAPER_SIZE_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_PAPER_SIZE_WIDGET, GnomeScanPaperSizeWidgetClass))

typedef struct _GnomeScanPaperSizeWidget GnomeScanPaperSizeWidget;
typedef struct _GnomeScanPaperSizeWidgetClass GnomeScanPaperSizeWidgetClass;
typedef struct _GnomeScanPaperSizeWidgetPrivate GnomeScanPaperSizeWidgetPrivate;

#define GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET (gnome_scan_page_orientation_widget_get_type ())
#define GNOME_SCAN_PAGE_ORIENTATION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET, GnomeScanPageOrientationWidget))
#define GNOME_SCAN_PAGE_ORIENTATION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET, GnomeScanPageOrientationWidgetClass))
#define GNOME_SCAN_IS_PAGE_ORIENTATION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET))
#define GNOME_SCAN_IS_PAGE_ORIENTATION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET))
#define GNOME_SCAN_PAGE_ORIENTATION_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET, GnomeScanPageOrientationWidgetClass))

typedef struct _GnomeScanPageOrientationWidget GnomeScanPageOrientationWidget;
typedef struct _GnomeScanPageOrientationWidgetClass GnomeScanPageOrientationWidgetClass;
typedef struct _GnomeScanPageOrientationWidgetPrivate GnomeScanPageOrientationWidgetPrivate;

#define GNOME_SCAN_TYPE_OPTION_BOX (gnome_scan_option_box_get_type ())
#define GNOME_SCAN_OPTION_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_BOX, GnomeScanOptionBox))
#define GNOME_SCAN_OPTION_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_BOX, GnomeScanOptionBoxClass))
#define GNOME_SCAN_IS_OPTION_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_BOX))
#define GNOME_SCAN_IS_OPTION_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_BOX))
#define GNOME_SCAN_OPTION_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_BOX, GnomeScanOptionBoxClass))

typedef struct _GnomeScanOptionBox GnomeScanOptionBox;
typedef struct _GnomeScanOptionBoxClass GnomeScanOptionBoxClass;
typedef struct _GnomeScanOptionBoxPrivate GnomeScanOptionBoxPrivate;

#define GNOME_SCAN_TYPE_OPTION_PAGE (gnome_scan_option_page_get_type ())
#define GNOME_SCAN_OPTION_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_PAGE, GnomeScanOptionPage))
#define GNOME_SCAN_OPTION_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_PAGE, GnomeScanOptionPageClass))
#define GNOME_SCAN_IS_OPTION_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_PAGE))
#define GNOME_SCAN_IS_OPTION_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_PAGE))
#define GNOME_SCAN_OPTION_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_PAGE, GnomeScanOptionPageClass))

typedef struct _GnomeScanOptionPage GnomeScanOptionPage;
typedef struct _GnomeScanOptionPageClass GnomeScanOptionPageClass;
typedef struct _GnomeScanOptionPagePrivate GnomeScanOptionPagePrivate;

#define GNOME_SCAN_TYPE_OPTION_VPAGE (gnome_scan_option_vpage_get_type ())
#define GNOME_SCAN_OPTION_VPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_VPAGE, GnomeScanOptionVPage))
#define GNOME_SCAN_OPTION_VPAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_VPAGE, GnomeScanOptionVPageClass))
#define GNOME_SCAN_IS_OPTION_VPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_VPAGE))
#define GNOME_SCAN_IS_OPTION_VPAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_VPAGE))
#define GNOME_SCAN_OPTION_VPAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_VPAGE, GnomeScanOptionVPageClass))

typedef struct _GnomeScanOptionVPage GnomeScanOptionVPage;
typedef struct _GnomeScanOptionVPageClass GnomeScanOptionVPageClass;
typedef struct _GnomeScanOptionVPagePrivate GnomeScanOptionVPagePrivate;

#define GNOME_SCAN_TYPE_OPTION_HPAGE (gnome_scan_option_hpage_get_type ())
#define GNOME_SCAN_OPTION_HPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_HPAGE, GnomeScanOptionHPage))
#define GNOME_SCAN_OPTION_HPAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_HPAGE, GnomeScanOptionHPageClass))
#define GNOME_SCAN_IS_OPTION_HPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_HPAGE))
#define GNOME_SCAN_IS_OPTION_HPAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_HPAGE))
#define GNOME_SCAN_OPTION_HPAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_HPAGE, GnomeScanOptionHPageClass))

typedef struct _GnomeScanOptionHPage GnomeScanOptionHPage;
typedef struct _GnomeScanOptionHPageClass GnomeScanOptionHPageClass;
typedef struct _GnomeScanOptionHPagePrivate GnomeScanOptionHPagePrivate;

#define GNOME_SCAN_TYPE_SCANNER_SELECTOR (gnome_scan_scanner_selector_get_type ())
#define GNOME_SCAN_SCANNER_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_SCANNER_SELECTOR, GnomeScanScannerSelector))
#define GNOME_SCAN_SCANNER_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_SCANNER_SELECTOR, GnomeScanScannerSelectorClass))
#define GNOME_SCAN_IS_SCANNER_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_SCANNER_SELECTOR))
#define GNOME_SCAN_IS_SCANNER_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_SCANNER_SELECTOR))
#define GNOME_SCAN_SCANNER_SELECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_SCANNER_SELECTOR, GnomeScanScannerSelectorClass))

typedef struct _GnomeScanScannerSelector GnomeScanScannerSelector;
typedef struct _GnomeScanScannerSelectorClass GnomeScanScannerSelectorClass;
typedef struct _GnomeScanScannerSelectorPrivate GnomeScanScannerSelectorPrivate;

#define GNOME_SCAN_TYPE_ACQUISITION_WIDGET (gnome_scan_acquisition_widget_get_type ())
#define GNOME_SCAN_ACQUISITION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_ACQUISITION_WIDGET, GnomeScanAcquisitionWidget))
#define GNOME_SCAN_ACQUISITION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_ACQUISITION_WIDGET, GnomeScanAcquisitionWidgetClass))
#define GNOME_SCAN_IS_ACQUISITION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_ACQUISITION_WIDGET))
#define GNOME_SCAN_IS_ACQUISITION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_ACQUISITION_WIDGET))
#define GNOME_SCAN_ACQUISITION_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_ACQUISITION_WIDGET, GnomeScanAcquisitionWidgetClass))

typedef struct _GnomeScanAcquisitionWidget GnomeScanAcquisitionWidget;
typedef struct _GnomeScanAcquisitionWidgetClass GnomeScanAcquisitionWidgetClass;
typedef struct _GnomeScanAcquisitionWidgetPrivate GnomeScanAcquisitionWidgetPrivate;

#define GNOME_SCAN_TYPE_DIALOG (gnome_scan_dialog_get_type ())
#define GNOME_SCAN_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_DIALOG, GnomeScanDialog))
#define GNOME_SCAN_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_DIALOG, GnomeScanDialogClass))
#define GNOME_SCAN_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_DIALOG))
#define GNOME_SCAN_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_DIALOG))
#define GNOME_SCAN_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_DIALOG, GnomeScanDialogClass))

typedef struct _GnomeScanDialog GnomeScanDialog;
typedef struct _GnomeScanDialogClass GnomeScanDialogClass;
typedef struct _GnomeScanDialogPrivate GnomeScanDialogPrivate;

typedef enum  {
	GNOME_SCAN_UNIT_NONE = -1,
	GNOME_SCAN_UNIT_PIXEL,
	GNOME_SCAN_UNIT_POINTS,
	GNOME_SCAN_UNIT_INCH,
	GNOME_SCAN_UNIT_MM,
	GNOME_SCAN_UNIT_BIT,
	GNOME_SCAN_UNIT_DPI,
	GNOME_SCAN_UNIT_PERCENT,
	GNOME_SCAN_UNIT_MICROSECOND
} GnomeScanUnit;

typedef enum  {
	GNOME_SCAN_STATUS_UNKNOWN = 0,
	GNOME_SCAN_STATUS_FAILED = 100,
	GNOME_SCAN_STATUS_INITIALIZING = 200,
	GNOME_SCAN_STATUS_BUSY = 300,
	GNOME_SCAN_STATUS_UNCONFIGURED = 400,
	GNOME_SCAN_STATUS_READY = 500,
	GNOME_SCAN_STATUS_PROCESSING = 600,
	GNOME_SCAN_STATUS_DONE = 700
} GnomeScanStatus;

struct _GnomeScanPoint {
	double x;
	double y;
};

struct _GnomeScanExtent {
	double width;
	double height;
};

struct _GnomeScanRange {
	double min;
	double step;
	double max;
};

struct _GnomeScanFormat {
	GObject parent_instance;
	GnomeScanFormatPrivate * priv;
	const char* name;
	const char* desc;
	const char* domain;
	const char* icon_name;
	char** mime_types;
	gint mime_types_length1;
	char** suffixes;
	gint suffixes_length1;
};

struct _GnomeScanFormatClass {
	GObjectClass parent_class;
};

struct _GnomeScanEnumValue {
	GValue value;
	char* label;
	char* domain;
};

struct _GnomeScanRectangle {
	double x;
	double y;
	double width;
	double height;
};

struct _GnomeScanModule {
	GTypeModule parent_instance;
	GnomeScanModulePrivate * priv;
};

struct _GnomeScanModuleClass {
	GTypeModuleClass parent_class;
};

typedef void (*GnomeScanModuleInitFunc) (GnomeScanModule* module, void* user_data);
typedef void (*GnomeScanModuleFinalizeFunc) (void* user_data);
struct _GnomeScanModuleManager {
	GObject parent_instance;
	GnomeScanModuleManagerPrivate * priv;
};

struct _GnomeScanModuleManagerClass {
	GObjectClass parent_class;
};

typedef enum  {
	GNOME_SCAN_OPTION_HINT_HIDDEN,
	GNOME_SCAN_OPTION_HINT_PRIMARY,
	GNOME_SCAN_OPTION_HINT_SECONDARY,
	GNOME_SCAN_OPTION_HINT_PREVIEW,
	GNOME_SCAN_OPTION_HINT_REPEAT
} GnomeScanOptionHint;

struct _GnomeScanOption {
	GObject parent_instance;
	GnomeScanOptionPrivate * priv;
};

struct _GnomeScanOptionClass {
	GObjectClass parent_class;
	void (*set_g_value) (GnomeScanOption* self, const GValue* value);
};

struct _GnomeScanOptionBool {
	GnomeScanOption parent_instance;
	GnomeScanOptionBoolPrivate * priv;
};

struct _GnomeScanOptionBoolClass {
	GnomeScanOptionClass parent_class;
};

struct _GnomeScanOptionNumber {
	GnomeScanOption parent_instance;
	GnomeScanOptionNumberPrivate * priv;
};

struct _GnomeScanOptionNumberClass {
	GnomeScanOptionClass parent_class;
};

struct _GnomeScanOptionString {
	GnomeScanOption parent_instance;
	GnomeScanOptionStringPrivate * priv;
};

struct _GnomeScanOptionStringClass {
	GnomeScanOptionClass parent_class;
};

struct _GnomeScanOptionEnum {
	GnomeScanOption parent_instance;
	GnomeScanOptionEnumPrivate * priv;
};

struct _GnomeScanOptionEnumClass {
	GnomeScanOptionClass parent_class;
	void (*append) (GnomeScanOptionEnum* self, const GnomeScanEnumValue* value);
};

struct _GnomeScanOptionPaperSize {
	GnomeScanOptionEnum parent_instance;
	GnomeScanOptionPaperSizePrivate * priv;
};

struct _GnomeScanOptionPaperSizeClass {
	GnomeScanOptionEnumClass parent_class;
};

struct _GnomeScanOptionBoxed {
	GnomeScanOption parent_instance;
	GnomeScanOptionBoxedPrivate * priv;
};

struct _GnomeScanOptionBoxedClass {
	GnomeScanOptionClass parent_class;
};

struct _GnomeScanOptionPointer {
	GnomeScanOption parent_instance;
	GnomeScanOptionPointerPrivate * priv;
};

struct _GnomeScanOptionPointerClass {
	GnomeScanOptionClass parent_class;
};

struct _GnomeScanNode {
	GObject parent_instance;
	GnomeScanNodePrivate * priv;
};

struct _GnomeScanNodeClass {
	GObjectClass parent_class;
	void (*start_scan) (GnomeScanNode* self);
	gboolean (*start_image) (GnomeScanNode* self);
	void (*end_image) (GnomeScanNode* self);
	void (*end_scan) (GnomeScanNode* self);
};

struct _GnomeScanScanner {
	GnomeScanNode parent_instance;
	GnomeScanScannerPrivate * priv;
};

struct _GnomeScanScannerClass {
	GnomeScanNodeClass parent_class;
	gboolean (*work) (GnomeScanScanner* self, double* progress);
};

struct _GnomeScanSink {
	GnomeScanNode parent_instance;
	GnomeScanSinkPrivate * priv;
};

struct _GnomeScanSinkClass {
	GnomeScanNodeClass parent_class;
	void (*finalize_process) (GnomeScanSink* self);
};

struct _GnomeScanPreselection {
	GObject parent_instance;
	GnomeScanPreselectionPrivate * priv;
};

struct _GnomeScanPreselectionClass {
	GObjectClass parent_class;
	void (*apply) (GnomeScanPreselection* self, GnomeScanOption* option);
};

struct _GnomeScanPreselValue {
	GnomeScanPreselection parent_instance;
	GnomeScanPreselValuePrivate * priv;
};

struct _GnomeScanPreselValueClass {
	GnomeScanPreselectionClass parent_class;
};

struct _GnomeScanPreselEnumValues {
	GnomeScanPreselection parent_instance;
	GnomeScanPreselEnumValuesPrivate * priv;
};

struct _GnomeScanPreselEnumValuesClass {
	GnomeScanPreselectionClass parent_class;
};

struct _GnomeScanJob {
	GObject parent_instance;
	GnomeScanJobPrivate * priv;
};

struct _GnomeScanJobClass {
	GObjectClass parent_class;
};

struct _GnomeScanBackend {
	GObject parent_instance;
	GnomeScanBackendPrivate * priv;
};

struct _GnomeScanBackendClass {
	GObjectClass parent_class;
	void* (*probe_scanners) (GnomeScanBackend* self);
};

struct _GnomeScanOptionManager {
	GObject parent_instance;
	GnomeScanOptionManagerPrivate * priv;
};

struct _GnomeScanOptionManagerClass {
	GObjectClass parent_class;
};

struct _GnomeScanOptionWidget {
	GtkHBox parent_instance;
	GnomeScanOptionWidgetPrivate * priv;
};

struct _GnomeScanOptionWidgetClass {
	GtkHBoxClass parent_class;
};

struct _GnomeScanCheckboxWidget {
	GnomeScanOptionWidget parent_instance;
	GnomeScanCheckboxWidgetPrivate * priv;
};

struct _GnomeScanCheckboxWidgetClass {
	GnomeScanOptionWidgetClass parent_class;
};

struct _GnomeScanScaleWidget {
	GnomeScanOptionWidget parent_instance;
	GnomeScanScaleWidgetPrivate * priv;
};

struct _GnomeScanScaleWidgetClass {
	GnomeScanOptionWidgetClass parent_class;
};

struct _GnomeScanEntryWidget {
	GnomeScanOptionWidget parent_instance;
	GnomeScanEntryWidgetPrivate * priv;
};

struct _GnomeScanEntryWidgetClass {
	GnomeScanOptionWidgetClass parent_class;
};

struct _GnomeScanComboBoxWidget {
	GnomeScanOptionWidget parent_instance;
	GnomeScanComboBoxWidgetPrivate * priv;
};

struct _GnomeScanComboBoxWidgetClass {
	GnomeScanOptionWidgetClass parent_class;
};

struct _GnomeScanPaperSizeWidget {
	GnomeScanOptionWidget parent_instance;
	GnomeScanPaperSizeWidgetPrivate * priv;
};

struct _GnomeScanPaperSizeWidgetClass {
	GnomeScanOptionWidgetClass parent_class;
};

struct _GnomeScanPageOrientationWidget {
	GnomeScanOptionWidget parent_instance;
	GnomeScanPageOrientationWidgetPrivate * priv;
};

struct _GnomeScanPageOrientationWidgetClass {
	GnomeScanOptionWidgetClass parent_class;
};

struct _GnomeScanOptionBox {
	GtkVBox parent_instance;
	GnomeScanOptionBoxPrivate * priv;
};

struct _GnomeScanOptionBoxClass {
	GtkVBoxClass parent_class;
};

struct _GnomeScanOptionPage {
	GtkAlignment parent_instance;
	GnomeScanOptionPagePrivate * priv;
};

struct _GnomeScanOptionPageClass {
	GtkAlignmentClass parent_class;
};

struct _GnomeScanOptionVPage {
	GnomeScanOptionPage parent_instance;
	GnomeScanOptionVPagePrivate * priv;
};

struct _GnomeScanOptionVPageClass {
	GnomeScanOptionPageClass parent_class;
};

struct _GnomeScanOptionHPage {
	GnomeScanOptionPage parent_instance;
	GnomeScanOptionHPagePrivate * priv;
};

struct _GnomeScanOptionHPageClass {
	GnomeScanOptionPageClass parent_class;
};

struct _GnomeScanScannerSelector {
	GtkScrolledWindow parent_instance;
	GnomeScanScannerSelectorPrivate * priv;
};

struct _GnomeScanScannerSelectorClass {
	GtkScrolledWindowClass parent_class;
};

struct _GnomeScanAcquisitionWidget {
	GtkAlignment parent_instance;
	GnomeScanAcquisitionWidgetPrivate * priv;
};

struct _GnomeScanAcquisitionWidgetClass {
	GtkAlignmentClass parent_class;
};

struct _GnomeScanDialog {
	GtkWindow parent_instance;
	GnomeScanDialogPrivate * priv;
};

struct _GnomeScanDialogClass {
	GtkWindowClass parent_class;
};


GType gnome_scan_unit_get_type (void);
char* gnome_scan_unit_to_string (GnomeScanUnit unit);
GType gnome_scan_status_get_type (void);
GType gnome_scan_point_get_type (void);
GnomeScanPoint* gnome_scan_point_dup (const GnomeScanPoint* self);
void gnome_scan_point_free (GnomeScanPoint* self);
GType gnome_scan_extent_get_type (void);
GnomeScanExtent* gnome_scan_extent_dup (const GnomeScanExtent* self);
void gnome_scan_extent_free (GnomeScanExtent* self);
void gnome_scan_extent_init (GnomeScanExtent *self, double width, double height);
GType gnome_scan_range_get_type (void);
GnomeScanRange* gnome_scan_range_dup (const GnomeScanRange* self);
void gnome_scan_range_free (GnomeScanRange* self);
GType gnome_scan_format_get_type (void);
GnomeScanFormat* gnome_scan_format_new (const char* name, const char* desc, const char* domain, const char* icon_name, char** mime_types, int mime_types_length1, char** suffixes, int suffixes_length1);
GnomeScanFormat* gnome_scan_format_construct (GType object_type, const char* name, const char* desc, const char* domain, const char* icon_name, char** mime_types, int mime_types_length1, char** suffixes, int suffixes_length1);
GType gnome_scan_enum_value_get_type (void);
GnomeScanEnumValue* gnome_scan_enum_value_dup (const GnomeScanEnumValue* self);
void gnome_scan_enum_value_free (GnomeScanEnumValue* self);
void gnome_scan_enum_value_copy (const GnomeScanEnumValue* self, GnomeScanEnumValue* dest);
void gnome_scan_enum_value_destroy (GnomeScanEnumValue* self);
void gnome_scan_enum_value_init (GnomeScanEnumValue *self, const GValue* value, const char* label, const char* domain);
char* gnome_scan_enum_get_nick (GType enum_type, gint value);
char* gnome_scan_flags_get_nicks (GType flags_type, gint value);
double gnome_scan_convert (double val, GnomeScanUnit from, GnomeScanUnit to, double res);
double gnome_scan_convert_from_mm (double val, GnomeScanUnit to, double res);
double gnome_scan_convert_to_mm (double val, GnomeScanUnit from, double res);
void gnome_scan_rectangle_rotate (GnomeScanRectangle* self, GnomeScanRectangle* area, gint angle);
void gnome_scan_rectangle_convert (GnomeScanRectangle* self, GnomeScanUnit from, GnomeScanUnit to, double res);
void gnome_scan_rectangle_convert_to_mm (GnomeScanRectangle* self, GnomeScanUnit from, double res);
void gnome_scan_rectangle_convert_from_mm (GnomeScanRectangle* self, GnomeScanUnit to, double res);
GnomeScanRectangle* gnome_scan_rectangle_new (void);
GnomeScanRectangle* gnome_scan_rectangle_new (void);
GType gnome_scan_module_get_type (void);
GnomeScanModule* gnome_scan_module_new (const char* filename);
GnomeScanModule* gnome_scan_module_construct (GType object_type, const char* filename);
const char* gnome_scan_module_get_filename (GnomeScanModule* self);
void gnome_scan_module_set_filename (GnomeScanModule* self, const char* value);
GType gnome_scan_module_manager_get_type (void);
GnomeScanModuleManager* gnome_scan_module_manager_new (const char* path);
GnomeScanModuleManager* gnome_scan_module_manager_construct (GType object_type, const char* path);
void gnome_scan_module_manager_query_modules (GnomeScanModuleManager* self);
void gnome_scan_module_manager_unload_modules (GnomeScanModuleManager* self);
const char* gnome_scan_module_manager_get_path (GnomeScanModuleManager* self);
void gnome_scan_module_manager_set_path (GnomeScanModuleManager* self, const char* value);
#define GNOME_SCAN_OPTION_GROUP_SCANNER N_ ("Scan Options")
#define GNOME_SCAN_OPTION_GROUP_SINK N_ ("Output Options")
#define GNOME_SCAN_OPTION_GROUP_FORMAT N_ ("Format")
GType gnome_scan_option_hint_get_type (void);
GType gnome_scan_option_get_type (void);
void gnome_scan_option_set_g_value (GnomeScanOption* self, const GValue* value);
gboolean gnome_scan_option_copy_or_transform_g_value (GnomeScanOption* self, const GValue* src, GValue* dest);
GnomeScanOption* gnome_scan_option_construct (GType object_type);
const char* gnome_scan_option_get_name (GnomeScanOption* self);
void gnome_scan_option_set_name (GnomeScanOption* self, const char* value);
const char* gnome_scan_option_get_title (GnomeScanOption* self);
void gnome_scan_option_set_title (GnomeScanOption* self, const char* value);
const char* gnome_scan_option_get_desc (GnomeScanOption* self);
void gnome_scan_option_set_desc (GnomeScanOption* self, const char* value);
const char* gnome_scan_option_get_group (GnomeScanOption* self);
void gnome_scan_option_set_group (GnomeScanOption* self, const char* value);
const char* gnome_scan_option_get_domain (GnomeScanOption* self);
void gnome_scan_option_set_domain (GnomeScanOption* self, const char* value);
GnomeScanUnit gnome_scan_option_get_unit (GnomeScanOption* self);
void gnome_scan_option_set_unit (GnomeScanOption* self, GnomeScanUnit value);
GnomeScanOptionHint gnome_scan_option_get_hint (GnomeScanOption* self);
void gnome_scan_option_set_hint (GnomeScanOption* self, GnomeScanOptionHint value);
gboolean gnome_scan_option_get_active (GnomeScanOption* self);
void gnome_scan_option_set_active (GnomeScanOption* self, gboolean value);
GType gnome_scan_option_bool_get_type (void);
GnomeScanOptionBool* gnome_scan_option_bool_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, gboolean value, GnomeScanOptionHint hint);
GnomeScanOptionBool* gnome_scan_option_bool_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, gboolean value, GnomeScanOptionHint hint);
gboolean gnome_scan_option_bool_get_value (GnomeScanOptionBool* self);
void gnome_scan_option_bool_set_value (GnomeScanOptionBool* self, gboolean value);
GType gnome_scan_option_number_get_type (void);
GnomeScanOptionNumber* gnome_scan_option_number_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, double value, const GnomeScanRange* range, GnomeScanUnit unit, GnomeScanOptionHint hint);
GnomeScanOptionNumber* gnome_scan_option_number_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, double value, const GnomeScanRange* range, GnomeScanUnit unit, GnomeScanOptionHint hint);
double gnome_scan_option_number_get_value (GnomeScanOptionNumber* self);
void gnome_scan_option_number_set_value (GnomeScanOptionNumber* self, double value);
void gnome_scan_option_number_get_range (GnomeScanOptionNumber* self, GnomeScanRange* result);
void gnome_scan_option_number_set_range (GnomeScanOptionNumber* self, GnomeScanRange* value);
GType gnome_scan_option_string_get_type (void);
GnomeScanOptionString* gnome_scan_option_string_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, const char* value, GnomeScanOptionHint hint);
GnomeScanOptionString* gnome_scan_option_string_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, const char* value, GnomeScanOptionHint hint);
const char* gnome_scan_option_string_get_value (GnomeScanOptionString* self);
void gnome_scan_option_string_set_value (GnomeScanOptionString* self, const char* value);
GType gnome_scan_option_enum_get_type (void);
GnomeScanOptionEnum* gnome_scan_option_enum_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, const GnomeScanEnumValue* value, GSList* values, GnomeScanOptionHint hint);
GnomeScanOptionEnum* gnome_scan_option_enum_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, const GnomeScanEnumValue* value, GSList* values, GnomeScanOptionHint hint);
void gnome_scan_option_enum_append (GnomeScanOptionEnum* self, const GnomeScanEnumValue* value);
void gnome_scan_option_enum_get_value (GnomeScanOptionEnum* self, GnomeScanEnumValue* result);
void gnome_scan_option_enum_set_value (GnomeScanOptionEnum* self, GnomeScanEnumValue* value);
GSList* gnome_scan_option_enum_get_values (GnomeScanOptionEnum* self);
void gnome_scan_option_enum_set_values (GnomeScanOptionEnum* self, GSList* value);
GType gnome_scan_option_paper_size_get_type (void);
GnomeScanOptionPaperSize* gnome_scan_option_paper_size_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, const GnomeScanExtent* extent, const GnomeScanEnumValue* value, GSList* values, GnomeScanOptionHint hint);
GnomeScanOptionPaperSize* gnome_scan_option_paper_size_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, const GnomeScanExtent* extent, const GnomeScanEnumValue* value, GSList* values, GnomeScanOptionHint hint);
void gnome_scan_option_paper_size_get_extent (GnomeScanOptionPaperSize* self, GnomeScanExtent* result);
void gnome_scan_option_paper_size_set_extent (GnomeScanOptionPaperSize* self, GnomeScanExtent* value);
GType gnome_scan_option_boxed_get_type (void);
GnomeScanOptionBoxed* gnome_scan_option_boxed_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, const GValue* value, GnomeScanOptionHint hint);
GnomeScanOptionBoxed* gnome_scan_option_boxed_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, const GValue* value, GnomeScanOptionHint hint);
GType gnome_scan_option_pointer_get_type (void);
GnomeScanOptionPointer* gnome_scan_option_pointer_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, void* value, GnomeScanOptionHint hint);
GnomeScanOptionPointer* gnome_scan_option_pointer_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, void* value, GnomeScanOptionHint hint);
void* gnome_scan_option_pointer_get_value (GnomeScanOptionPointer* self);
void gnome_scan_option_pointer_set_value (GnomeScanOptionPointer* self, void* value);
GType gnome_scan_node_get_type (void);
void gnome_scan_node_start_scan (GnomeScanNode* self);
gboolean gnome_scan_node_start_image (GnomeScanNode* self);
void gnome_scan_node_end_image (GnomeScanNode* self);
void gnome_scan_node_end_scan (GnomeScanNode* self);
void gnome_scan_node_update_status (GnomeScanNode* self, GnomeScanStatus status, const char* message);
void gnome_scan_node_install_option (GnomeScanNode* self, GnomeScanOption* option);
GnomeScanOption* gnome_scan_node_lookup_option (GnomeScanNode* self, const char* name);
void gnome_scan_node_append_node (GnomeScanNode* self, GeglNode* node);
void gnome_scan_node_remove_node (GnomeScanNode* self, GeglNode* node);
GnomeScanNode* gnome_scan_node_construct (GType object_type);
GnomeScanStatus gnome_scan_node_get_status (GnomeScanNode* self);
void gnome_scan_node_set_status (GnomeScanNode* self, GnomeScanStatus value);
const char* gnome_scan_node_get_message (GnomeScanNode* self);
void gnome_scan_node_set_message (GnomeScanNode* self, const char* value);
GSList* gnome_scan_node_get_options (GnomeScanNode* self);
GSList* gnome_scan_node_get_nodes (GnomeScanNode* self);
GType gnome_scan_scanner_get_type (void);
gboolean gnome_scan_scanner_work (GnomeScanScanner* self, double* progress);
GnomeScanScanner* gnome_scan_scanner_construct (GType object_type);
const char* gnome_scan_scanner_get_name (GnomeScanScanner* self);
void gnome_scan_scanner_set_name (GnomeScanScanner* self, const char* value);
const char* gnome_scan_scanner_get_blurb (GnomeScanScanner* self);
void gnome_scan_scanner_set_blurb (GnomeScanScanner* self, const char* value);
const char* gnome_scan_scanner_get_icon_name (GnomeScanScanner* self);
void gnome_scan_scanner_set_icon_name (GnomeScanScanner* self, const char* value);
GeglBuffer* gnome_scan_scanner_get_buffer (GnomeScanScanner* self);
void gnome_scan_scanner_set_buffer (GnomeScanScanner* self, GeglBuffer* value);
void gnome_scan_scanner_get_extent (GnomeScanScanner* self, GnomeScanExtent* result);
void gnome_scan_scanner_set_extent (GnomeScanScanner* self, GnomeScanExtent* value);
GType gnome_scan_sink_get_type (void);
void gnome_scan_sink_finalize_process (GnomeScanSink* self);
GnomeScanSink* gnome_scan_sink_new (void);
GnomeScanSink* gnome_scan_sink_construct (GType object_type);
GType gnome_scan_preselection_get_type (void);
void gnome_scan_preselection_apply (GnomeScanPreselection* self, GnomeScanOption* option);
GnomeScanPreselection* gnome_scan_preselection_construct (GType object_type);
const char* gnome_scan_preselection_get_option_name (GnomeScanPreselection* self);
void gnome_scan_preselection_set_option_name (GnomeScanPreselection* self, const char* value);
GType gnome_scan_presel_value_get_type (void);
GnomeScanPreselValue* gnome_scan_presel_value_new (const char* option_name, const GValue* value);
GnomeScanPreselValue* gnome_scan_presel_value_construct (GType object_type, const char* option_name, const GValue* value);
void gnome_scan_presel_value_get_value (GnomeScanPreselValue* self, GValue* result);
void gnome_scan_presel_value_set_value (GnomeScanPreselValue* self, GValue* value);
GType gnome_scan_presel_enum_values_get_type (void);
GnomeScanPreselEnumValues* gnome_scan_presel_enum_values_new (const char* option_name, GSList* values);
GnomeScanPreselEnumValues* gnome_scan_presel_enum_values_construct (GType object_type, const char* option_name, GSList* values);
GSList* gnome_scan_presel_enum_values_get_values (GnomeScanPreselEnumValues* self);
void gnome_scan_presel_enum_values_set_values (GnomeScanPreselEnumValues* self, GSList* value);
GType gnome_scan_job_get_type (void);
GnomeScanJob* gnome_scan_job_new (GnomeScanSink* sink);
GnomeScanJob* gnome_scan_job_construct (GType object_type, GnomeScanSink* sink);
void gnome_scan_job_register_preselection (GnomeScanJob* self, GnomeScanPreselection* preselection);
gboolean gnome_scan_job_is_running (GnomeScanJob* self);
void gnome_scan_job_run (GnomeScanJob* self);
void gnome_scan_job_end (GnomeScanJob* self);
void gnome_scan_job_cancel (GnomeScanJob* self);
gboolean gnome_scan_job_run_once (GnomeScanJob* self);
GnomeScanStatus gnome_scan_job_get_status (GnomeScanJob* self);
void gnome_scan_job_set_status (GnomeScanJob* self, GnomeScanStatus value);
GnomeScanScanner* gnome_scan_job_get_scanner (GnomeScanJob* self);
void gnome_scan_job_set_scanner (GnomeScanJob* self, GnomeScanScanner* value);
GnomeScanSink* gnome_scan_job_get_sink (GnomeScanJob* self);
void gnome_scan_job_set_sink (GnomeScanJob* self, GnomeScanSink* value);
double gnome_scan_job_get_progress (GnomeScanJob* self);
GType gnome_scan_backend_get_type (void);
void* gnome_scan_backend_probe_scanners (GnomeScanBackend* self);
GnomeScanBackend* gnome_scan_backend_construct (GType object_type);
GType gnome_scan_option_manager_get_type (void);
extern GnomeScanOptionManager* gnome_scan_option_manager;
void gnome_scan_option_manager_register_option (GnomeScanOptionManager* self, GnomeScanOption* option);
void gnome_scan_option_manager_register_rule_by_name (GnomeScanOptionManager* self, const char* option_name, GType handler_type);
void gnome_scan_option_manager_register_rule_by_type (GnomeScanOptionManager* self, GType option_type, GType handler_type);
GType gnome_scan_option_manager_get_widget_type_for (GnomeScanOptionManager* self, GnomeScanOption* option);
GnomeScanOptionManager* gnome_scan_option_manager_new (void);
GnomeScanOptionManager* gnome_scan_option_manager_construct (GType object_type);
extern GnomeScanModuleManager* gnome_scan_module_manager;
void gnome_scan_init (int* argv_length1, char*** argv);
void gnome_scan_exit (void);
GType gnome_scan_option_widget_get_type (void);
GnomeScanOptionWidget* gnome_scan_option_widget_construct (GType object_type, GnomeScanOption* option);
GnomeScanOption* gnome_scan_option_widget_get_option (GnomeScanOptionWidget* self);
void gnome_scan_option_widget_set_option (GnomeScanOptionWidget* self, GnomeScanOption* value);
gboolean gnome_scan_option_widget_get_no_label (GnomeScanOptionWidget* self);
void gnome_scan_option_widget_set_no_label (GnomeScanOptionWidget* self, gboolean value);
gboolean gnome_scan_option_widget_get_expand (GnomeScanOptionWidget* self);
void gnome_scan_option_widget_set_expand (GnomeScanOptionWidget* self, gboolean value);
GType gnome_scan_checkbox_widget_get_type (void);
GnomeScanCheckboxWidget* gnome_scan_checkbox_widget_new (void);
GnomeScanCheckboxWidget* gnome_scan_checkbox_widget_construct (GType object_type);
GType gnome_scan_scale_widget_get_type (void);
GnomeScanScaleWidget* gnome_scan_scale_widget_new (void);
GnomeScanScaleWidget* gnome_scan_scale_widget_construct (GType object_type);
GType gnome_scan_entry_widget_get_type (void);
GnomeScanEntryWidget* gnome_scan_entry_widget_new (void);
GnomeScanEntryWidget* gnome_scan_entry_widget_construct (GType object_type);
GType gnome_scan_combo_box_widget_get_type (void);
GnomeScanComboBoxWidget* gnome_scan_combo_box_widget_new (void);
GnomeScanComboBoxWidget* gnome_scan_combo_box_widget_construct (GType object_type);
GType gnome_scan_paper_size_widget_get_type (void);
GnomeScanPaperSizeWidget* gnome_scan_paper_size_widget_new (void);
GnomeScanPaperSizeWidget* gnome_scan_paper_size_widget_construct (GType object_type);
GType gnome_scan_page_orientation_widget_get_type (void);
GnomeScanPageOrientationWidget* gnome_scan_page_orientation_widget_new (void);
GnomeScanPageOrientationWidget* gnome_scan_page_orientation_widget_construct (GType object_type);
GType gnome_scan_option_box_get_type (void);
GnomeScanOptionBox* gnome_scan_option_box_new (const char* label);
GnomeScanOptionBox* gnome_scan_option_box_construct (GType object_type, const char* label);
void gnome_scan_option_box_pack_option (GnomeScanOptionBox* self, GnomeScanOption* option);
gboolean gnome_scan_option_box_unpack_option (GnomeScanOptionBox* self, GnomeScanOption* option);
const char* gnome_scan_option_box_get_label (GnomeScanOptionBox* self);
void gnome_scan_option_box_set_label (GnomeScanOptionBox* self, const char* value);
gboolean gnome_scan_option_box_get_expand (GnomeScanOptionBox* self);
void gnome_scan_option_box_set_expand (GnomeScanOptionBox* self, gboolean value);
GType gnome_scan_option_page_get_type (void);
void gnome_scan_option_page_pack_option (GnomeScanOptionPage* self, GnomeScanOption* option);
void gnome_scan_option_page_unpack_option (GnomeScanOptionPage* self, GnomeScanOption* option);
GnomeScanOptionPage* gnome_scan_option_page_construct (GType object_type);
gboolean gnome_scan_option_page_get_scrolled (GnomeScanOptionPage* self);
void gnome_scan_option_page_set_scrolled (GnomeScanOptionPage* self, gboolean value);
GtkBox* gnome_scan_option_page_get_container (GnomeScanOptionPage* self);
void gnome_scan_option_page_set_container (GnomeScanOptionPage* self, GtkBox* value);
GType gnome_scan_option_vpage_get_type (void);
GnomeScanOptionVPage* gnome_scan_option_vpage_new (gboolean scrolled);
GnomeScanOptionVPage* gnome_scan_option_vpage_construct (GType object_type, gboolean scrolled);
GType gnome_scan_option_hpage_get_type (void);
GnomeScanOptionHPage* gnome_scan_option_hpage_new (void);
GnomeScanOptionHPage* gnome_scan_option_hpage_construct (GType object_type);
GType gnome_scan_scanner_selector_get_type (void);
GnomeScanScannerSelector* gnome_scan_scanner_selector_new (GnomeScanJob* job);
GnomeScanScannerSelector* gnome_scan_scanner_selector_construct (GType object_type, GnomeScanJob* job);
void gnome_scan_scanner_selector_probe_scanners (GnomeScanScannerSelector* self);
GnomeScanJob* gnome_scan_scanner_selector_get_job (GnomeScanScannerSelector* self);
void gnome_scan_scanner_selector_set_job (GnomeScanScannerSelector* self, GnomeScanJob* value);
GType gnome_scan_acquisition_widget_get_type (void);
GnomeScanAcquisitionWidget* gnome_scan_acquisition_widget_new (GnomeScanJob* job, const char* primary, const char* secondary, const char* icon_name);
GnomeScanAcquisitionWidget* gnome_scan_acquisition_widget_construct (GType object_type, GnomeScanJob* job, const char* primary, const char* secondary, const char* icon_name);
gboolean gnome_scan_acquisition_widget_monitor_job (GnomeScanAcquisitionWidget* self);
GnomeScanJob* gnome_scan_acquisition_widget_get_job (GnomeScanAcquisitionWidget* self);
void gnome_scan_acquisition_widget_set_job (GnomeScanAcquisitionWidget* self, GnomeScanJob* value);
const char* gnome_scan_acquisition_widget_get_primary (GnomeScanAcquisitionWidget* self);
void gnome_scan_acquisition_widget_set_primary (GnomeScanAcquisitionWidget* self, const char* value);
const char* gnome_scan_acquisition_widget_get_secondary (GnomeScanAcquisitionWidget* self);
void gnome_scan_acquisition_widget_set_secondary (GnomeScanAcquisitionWidget* self, const char* value);
const char* gnome_scan_acquisition_widget_get_icon_name (GnomeScanAcquisitionWidget* self);
void gnome_scan_acquisition_widget_set_icon_name (GnomeScanAcquisitionWidget* self, const char* value);
GType gnome_scan_dialog_get_type (void);
GnomeScanDialog* gnome_scan_dialog_new (GtkWindow* parent, GnomeScanJob* job);
GnomeScanDialog* gnome_scan_dialog_construct (GType object_type, GtkWindow* parent, GnomeScanJob* job);
void gnome_scan_dialog_run (GnomeScanDialog* self);
GnomeScanJob* gnome_scan_dialog_get_job (GnomeScanDialog* self);
void gnome_scan_dialog_set_job (GnomeScanDialog* self, GnomeScanJob* value);


G_END_DECLS

#endif
