/* Flegita - Scanner utility
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * Flegita is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Flegita is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Flegita. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gnome-scan.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>


#define FLEGITA_TYPE_SINK (flegita_sink_get_type ())
#define FLEGITA_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FLEGITA_TYPE_SINK, FlegitaSink))
#define FLEGITA_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FLEGITA_TYPE_SINK, FlegitaSinkClass))
#define FLEGITA_IS_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FLEGITA_TYPE_SINK))
#define FLEGITA_IS_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FLEGITA_TYPE_SINK))
#define FLEGITA_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FLEGITA_TYPE_SINK, FlegitaSinkClass))

typedef struct _FlegitaSink FlegitaSink;
typedef struct _FlegitaSinkClass FlegitaSinkClass;

#define FLEGITA_TYPE_OPTION_OUTPUT_FILENAME (flegita_option_output_filename_get_type ())
#define FLEGITA_OPTION_OUTPUT_FILENAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, FlegitaOptionOutputFilename))
#define FLEGITA_OPTION_OUTPUT_FILENAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, FlegitaOptionOutputFilenameClass))
#define FLEGITA_IS_OPTION_OUTPUT_FILENAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME))
#define FLEGITA_IS_OPTION_OUTPUT_FILENAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME))
#define FLEGITA_OPTION_OUTPUT_FILENAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, FlegitaOptionOutputFilenameClass))

typedef struct _FlegitaOptionOutputFilename FlegitaOptionOutputFilename;
typedef struct _FlegitaOptionOutputFilenameClass FlegitaOptionOutputFilenameClass;

#define FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET (flegita_output_filename_widget_get_type ())
#define FLEGITA_OUTPUT_FILENAME_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET, FlegitaOutputFilenameWidget))
#define FLEGITA_OUTPUT_FILENAME_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET, FlegitaOutputFilenameWidgetClass))
#define FLEGITA_IS_OUTPUT_FILENAME_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET))
#define FLEGITA_IS_OUTPUT_FILENAME_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET))
#define FLEGITA_OUTPUT_FILENAME_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET, FlegitaOutputFilenameWidgetClass))

typedef struct _FlegitaOutputFilenameWidget FlegitaOutputFilenameWidget;
typedef struct _FlegitaOutputFilenameWidgetClass FlegitaOutputFilenameWidgetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gtk_paper_size_free0(var) ((var == NULL) ? NULL : (var = (gtk_paper_size_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_free (var), NULL)))



GType flegita_sink_get_type (void);
GType flegita_option_output_filename_get_type (void);
GType flegita_output_filename_widget_get_type (void);
FlegitaSink* flegita_sink_new (void);
FlegitaSink* flegita_sink_construct (GType object_type);
static GnomeScanEnumValue* _gnome_scan_enum_value_dup (GnomeScanEnumValue* self);
static void _g_slist_free_g_free (GSList* self);
gint _main (char** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GnomeScanEnumValue* _gnome_scan_enum_value_dup (GnomeScanEnumValue* self) {
	GnomeScanEnumValue* dup;
	dup = g_new0 (GnomeScanEnumValue, 1);
	gnome_scan_enum_value_copy (self, dup);
	return dup;
}


static gpointer __gnome_scan_enum_value_dup0 (gpointer self) {
	return self ? _gnome_scan_enum_value_dup (self) : NULL;
}


static void _g_slist_free_g_free (GSList* self) {
	g_slist_foreach (self, (GFunc) g_free, NULL);
	g_slist_free (self);
}


gint _main (char** args, int args_length1) {
	gint result;
	GnomeScanJob* job;
	GnomeScanDialog* dialog;
	FlegitaSink* sink;
	GdkScreen* screen;
	double screen_resolution;
	GValue default_res = {0};
	GtkPaperSize* ps;
	GValue value = {0};
	GnomeScanEnumValue evalue = {0};
	GSList* ps_list;
	FlegitaSink* _tmp0_;
	GnomeScanJob* _tmp1_;
	GValue _tmp3_;
	GValue _tmp2_ = {0};
	GdkScreen* _tmp4_;
	GnomeScanPreselValue* _tmp5_;
	char** _tmp7_;
	gint formats_size;
	gint formats_length1;
	char** _tmp6_;
	char** formats;
	GnomeScanPreselEnumValues* _tmp13_;
	GnomeScanDialog* _tmp14_;
	job = NULL;
	dialog = NULL;
	sink = NULL;
	screen = NULL;
	screen_resolution = 0.0;
	ps = NULL;
	ps_list = NULL;
	g_set_prgname ("flegita");
	g_set_application_name (_ ("Scanner Utility"));
	gnome_scan_init (&args_length1, &args);
	gtk_init (&args_length1, &args);
	gnome_scan_option_manager_register_rule_by_type (gnome_scan_option_manager, FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET);
	sink = (_tmp0_ = flegita_sink_new (), _g_object_unref0 (sink), _tmp0_);
	job = (_tmp1_ = gnome_scan_job_new ((GnomeScanSink*) sink), _g_object_unref0 (job), _tmp1_);
	default_res = (_tmp3_ = (g_value_init (&_tmp2_, G_TYPE_DOUBLE), _tmp2_), G_IS_VALUE (&default_res) ? (g_value_unset (&default_res), NULL) : NULL, _tmp3_);
	screen = (_tmp4_ = _g_object_ref0 (gdk_screen_get_default ()), _g_object_unref0 (screen), _tmp4_);
	screen_resolution = gdk_screen_get_resolution (screen);
	if (screen_resolution != (-1)) {
		g_value_set_double (&default_res, gdk_screen_get_resolution (screen));
	} else {
		g_value_set_double (&default_res, (double) 150);
	}
	gnome_scan_job_register_preselection (job, (GnomeScanPreselection*) (_tmp5_ = gnome_scan_presel_value_new ("resolution", &default_res)));
	_g_object_unref0 (_tmp5_);
	_tmp6_ = NULL;
	formats = (_tmp7_ = (_tmp6_ = g_new0 (char*, 2 + 1), _tmp6_[0] = g_strdup ("om_small-photo"), _tmp6_[1] = g_strdup ("iso_dl"), _tmp6_), formats_length1 = 2, formats_size = formats_length1, _tmp7_);
	{
		char** format_collection;
		int format_collection_length1;
		int format_it;
		format_collection = formats;
		format_collection_length1 = formats_length1;
		for (format_it = 0; format_it < formats_length1; format_it = format_it + 1) {
			char* format;
			format = g_strdup (format_collection[format_it]);
			{
				GtkPaperSize* _tmp8_;
				GValue _tmp10_;
				GValue _tmp9_ = {0};
				GnomeScanEnumValue _tmp12_;
				GnomeScanEnumValue _tmp11_ = {0};
				ps = (_tmp8_ = gtk_paper_size_new (format), _gtk_paper_size_free0 (ps), _tmp8_);
				value = (_tmp10_ = (g_value_init (&_tmp9_, GTK_TYPE_PAPER_SIZE), _tmp9_), G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp10_);
				g_value_set_boxed (&value, ps);
				evalue = (_tmp12_ = (gnome_scan_enum_value_init (&_tmp11_, &value, gtk_paper_size_get_display_name (ps), NULL), _tmp11_), gnome_scan_enum_value_destroy (&evalue), _tmp12_);
				ps_list = g_slist_append (ps_list, __gnome_scan_enum_value_dup0 (&evalue));
				_g_free0 (format);
			}
		}
	}
	gnome_scan_job_register_preselection (job, (GnomeScanPreselection*) (_tmp13_ = gnome_scan_presel_enum_values_new ("paper-size", ps_list)));
	_g_object_unref0 (_tmp13_);
	dialog = (_tmp14_ = g_object_ref_sink (gnome_scan_dialog_new (NULL, job)), _g_object_unref0 (dialog), _tmp14_);
	gnome_scan_dialog_run (dialog);
	result = 0;
	_g_object_unref0 (job);
	_g_object_unref0 (dialog);
	_g_object_unref0 (sink);
	_g_object_unref0 (screen);
	G_IS_VALUE (&default_res) ? (g_value_unset (&default_res), NULL) : NULL;
	_gtk_paper_size_free0 (ps);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	gnome_scan_enum_value_destroy (&evalue);
	__g_slist_free_g_free0 (ps_list);
	formats = (_vala_array_free (formats, formats_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	return _main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




