/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PRIMEPREDICTION_H
#define PRIMEPREDICTION_H


#define Uses_SCIM_CONFIG_BASE
#define Uses_SCIM_ICONV


#include <predictor.h>
#include <honokasetupcore.h>

#include <cstdio>
#include <cstdlib>
#include <vector>
#include <set>
#include <map>
#include <scim.h>
#include <scim_iconv.h>
#include <scim_attribute.h>
#include <sys/types.h>
#include <sys/ipc.h>

#define HONOKA_CONFIG_PRIME_PREDICTION_LM           "/IMEngine/Honoka/Prime/LookupMethod"
#define HONOKA_DEFAULT_PRIME_PREDICTION_LM         "lookup_hybrid"


/**
@author TAM (Teppei Tamra)
*/
namespace Honoka {

class PrimePrediction : public Predictor {
public:
    PrimePrediction(ConfigPointer cfg);

    ~PrimePrediction();
    virtual ResultList getPredictionList(const WideString &str);
    virtual void disconnect();
    virtual bool connect();
    virtual bool isConnected();
    virtual String getPropertyName();
    virtual String getName();
    virtual void update(const WideString str,const WideString yomi);
    static HonokaSetupCorePage *setup();

protected:
    String lookup_method;
    int ifd;
    int ofd;
    bool *con;
    IConvert m_iconv;
    int mid;
    pid_t prime_pid;
protected:
    ResultEntry parser(const String &str);
};
}
#endif
