/***************************************************************************
 *   Copyright (C) 2005 Sebastian Kratzert                                 *
 *   Sebastian Kratzert <krase (at) in-chemnitz.de>                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <qtoolbutton.h>
#include <qapplication.h>
#include <qlayout.h>

#include <kiconloader.h>
#include <kparts/part.h>
#include <kdeversion.h>

#if KDE_IS_VERSION(3, 3, 0)
#include <klistviewsearchline.h>
#endif

#include "DTreeListView.h"
#include "TreeListViewFrame.h"

TreeListViewFrame::TreeListViewFrame( QWidget *parent, const char* name ): 
	QWidget( parent, name ), m_tree( 0L )
{
	QVBoxLayout* vlayout = new QVBoxLayout( this, 6, 6, "vlayout");
	m_tree = new DTreeListView( this, "tree list" );

#if KDE_IS_VERSION(3, 3, 0)
	QHBoxLayout* hlayout = new QHBoxLayout( 0, 0, 6, "hlayout"); 
	clearButton = new QToolButton( this, "clearButton" );
	hlayout->addWidget( clearButton );

	m_searchLine = new KListViewSearchLine( this, m_tree, "kListViewSearchLine1" );
	hlayout->addWidget( m_searchLine );
	vlayout->addLayout( hlayout );

	QIconSet icon = SmallIconSet(QApplication::reverseLayout() ? "clear_left" : "locationbar_erase");
	clearButton->setIconSet( icon );
	connect( clearButton, SIGNAL(clicked()), m_searchLine, SLOT(clear()) );
#endif

	vlayout->addWidget( m_tree );
}

TreeListViewFrame::~TreeListViewFrame() { }

