/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qregexp.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qdatastream.h>

#include <kiconloader.h>
#include <kmdcodec.h>
#include <klocale.h>
#include <kdebug.h>

#include "kkdpaper.h"
#include "kkdtextitem.h"
#include "kkdaddressee.h"
#include "kkdaddress.h"
#include "kkdzipcode.h"

using namespace KKDesigner;

KKDPaper::KKDPaper( const QPoint& l, const QSize& s, QObject* parent )
	: KKDImageItem( l, s, parent )
	, m_imagePrint( false )
{
	setAutoDelete( false );
}

KKDPaper::KKDPaper( QDomElement e, QObject* parent )
	: KKDImageItem( e, parent )
	, m_imagePrint( e.hasAttribute( "imageprint" ) )
{
	for( QDomNode n = e.lastChild(); !n.isNull(); n = n.previousSibling() )
	{
		QDomElement elem = n.toElement();
		if( elem.tagName() == KKDImageItem::tagName() )
		{
			append( new KKDImageItem( elem, this ) );
		}
		else if( elem.tagName() == KKDTextItem::tagName() )
		{
			append( new KKDTextItem( elem, this ) );
		}
		else if( elem.tagName() == KKDAddressee::tagName() )
		{
			append( new KKDAddressee( elem, this ) );
		}
		else if( elem.tagName() == KKDAddress::tagName() )
		{
			append( new KKDAddress( elem, this ) );
		}
		else if( elem.tagName() == KKDZipcode::tagName() )
		{
			append( new KKDZipcode( elem, this ) );
		}
		else
		{
			kdError( i18n( "unknown tagname %1." ).arg( elem.tagName() ) );
		}
	}
	setAutoDelete( false );
}

KKDPaper::KKDPaper( KKDPaper* paper, QObject* parent )
	: KKDImageItem( paper, parent )
	, m_imagePrint( paper->m_imagePrint )
{
	for( KKDItemBase* item = paper->first(); item; item = paper->next() )
	{
		switch( item->type() )
		{
			case TextItem:
				append( new KKDTextItem( (KKDTextItem*)item, this ) );
				break;
			case ImageItem:
				append( new KKDImageItem( (KKDImageItem*)item, this ) );
				break;
			case Addressee:
				append( new KKDAddressee( (KKDAddressee*)item, this ) );
				break;
			case Address:
				append( new KKDAddress( (KKDAddress*)item, this ) );
				break;
			case Zipcode:
				append( new KKDZipcode( (KKDZipcode*)item, this ) );
				break;
			default:
				kdError( i18n( "unknown tagname %1." ).arg( item->tagName() ) );
				break;
		}
	}
	setAutoDelete( false );
}

KKDPaper::~KKDPaper()
{
}

//BEGIN Properties
void KKDPaper::setImagePrint( bool p )
{
	if( locked() ) return;
	if( p == m_imagePrint ) return;
	m_imagePrint = p;
	emit imagePrintChanged();
}
//END   Properties

QDomElement KKDPaper::toElement( QDomDocument& doc, const QString& t )
{
	QDomElement elem = KKDImageItem::toElement( doc, t );
	for( KKDItemBase* item = last(); item; item = prev() )
	{
		elem.appendChild( item->toElement( doc ) );
	}

	if( m_imagePrint ) elem.setAttribute( "imageprint", 1 );
	return elem;
}

void KKDPaper::drawItemBefore( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d )
{
	KKDImageItem::drawItemBefore( r, p, m, d );
	if( image().isNull() && m != PrintMode )
	{
		p.fillRect( r, QBrush( white ) );
	}
}

void KKDPaper::drawItemAfter( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d )
{
	KKDImageItem::drawItemAfter( r, p, m, d );
}

KKDPaper::PrintType KKDPaper::printType()
{
	for( KKDItemBase* item = first(); item; item = next() )
	{
		switch( item->type() )
		{
			case Addressee:
			case Address:
			case Zipcode:
				return Insert;
				break;
			default:
				break;
		}
	}
	return Plain;
}
