/* Automatically generated from ../src/remote/remote_protocol.x by gendispatch.pl.
 * Do not edit this file.  Any changes you make will be lost.
 */
static int remoteDispatchAuthList(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_auth_list_ret *ret);
static int remoteDispatchAuthListHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchAuthList");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchAuthList(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchAuthList body has to be implemented manually */



static int remoteDispatchAuthPolkit(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_auth_polkit_ret *ret);
static int remoteDispatchAuthPolkitHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchAuthPolkit");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchAuthPolkit(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchAuthPolkit body has to be implemented manually */



static int remoteDispatchAuthSaslInit(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_auth_sasl_init_ret *ret);
static int remoteDispatchAuthSaslInitHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchAuthSaslInit");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchAuthSaslInit(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchAuthSaslInit body has to be implemented manually */



static int remoteDispatchAuthSaslStart(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_auth_sasl_start_args *args,
    remote_auth_sasl_start_ret *ret);
static int remoteDispatchAuthSaslStartHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchAuthSaslStart");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchAuthSaslStart(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchAuthSaslStart body has to be implemented manually */



static int remoteDispatchAuthSaslStep(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_auth_sasl_step_args *args,
    remote_auth_sasl_step_ret *ret);
static int remoteDispatchAuthSaslStepHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchAuthSaslStep");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchAuthSaslStep(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchAuthSaslStep body has to be implemented manually */



static int remoteDispatchConnectBaselineCPU(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_baseline_cpu_args *args,
    remote_connect_baseline_cpu_ret *ret);
static int remoteDispatchConnectBaselineCPUHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectBaselineCPU");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectBaselineCPU(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectBaselineCPU(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_baseline_cpu_args *args,
    remote_connect_baseline_cpu_ret *ret)
{
    int rv = -1;
    char *cpu;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((cpu = virConnectBaselineCPU(priv->conn, (const char **) args->xmlCPUs.xmlCPUs_val, args->xmlCPUs.xmlCPUs_len, args->flags)) == NULL)
        goto cleanup;

    ret->cpu = cpu;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectClose(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr);
static int remoteDispatchConnectCloseHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectClose");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectClose(server, client, msg, rerr);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectClose body has to be implemented manually */



static int remoteDispatchConnectCompareCPU(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_compare_cpu_args *args,
    remote_connect_compare_cpu_ret *ret);
static int remoteDispatchConnectCompareCPUHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectCompareCPU");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectCompareCPU(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectCompareCPU(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_compare_cpu_args *args,
    remote_connect_compare_cpu_ret *ret)
{
    int rv = -1;
    int result;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((result = virConnectCompareCPU(priv->conn, args->xml, args->flags)) < 0)
        goto cleanup;

    ret->result = result;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectDomainEventCallbackDeregisterAny(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_domain_event_callback_deregister_any_args *args);
static int remoteDispatchConnectDomainEventCallbackDeregisterAnyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectDomainEventCallbackDeregisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectDomainEventCallbackDeregisterAny(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectDomainEventCallbackDeregisterAny body has to be implemented manually */



static int remoteDispatchConnectDomainEventCallbackRegisterAny(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_domain_event_callback_register_any_args *args,
    remote_connect_domain_event_callback_register_any_ret *ret);
static int remoteDispatchConnectDomainEventCallbackRegisterAnyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectDomainEventCallbackRegisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectDomainEventCallbackRegisterAny(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectDomainEventCallbackRegisterAny body has to be implemented manually */



static int remoteDispatchConnectDomainEventDeregister(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_domain_event_deregister_ret *ret);
static int remoteDispatchConnectDomainEventDeregisterHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectDomainEventDeregister");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectDomainEventDeregister(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectDomainEventDeregister body has to be implemented manually */



static int remoteDispatchConnectDomainEventDeregisterAny(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_domain_event_deregister_any_args *args);
static int remoteDispatchConnectDomainEventDeregisterAnyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectDomainEventDeregisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectDomainEventDeregisterAny(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectDomainEventDeregisterAny body has to be implemented manually */



static int remoteDispatchConnectDomainEventRegister(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_domain_event_register_ret *ret);
static int remoteDispatchConnectDomainEventRegisterHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectDomainEventRegister");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectDomainEventRegister(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectDomainEventRegister body has to be implemented manually */



static int remoteDispatchConnectDomainEventRegisterAny(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_domain_event_register_any_args *args);
static int remoteDispatchConnectDomainEventRegisterAnyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectDomainEventRegisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectDomainEventRegisterAny(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectDomainEventRegisterAny body has to be implemented manually */



static int remoteDispatchConnectDomainXMLFromNative(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_domain_xml_from_native_args *args,
    remote_connect_domain_xml_from_native_ret *ret);
static int remoteDispatchConnectDomainXMLFromNativeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectDomainXMLFromNative");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectDomainXMLFromNative(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectDomainXMLFromNative(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_domain_xml_from_native_args *args,
    remote_connect_domain_xml_from_native_ret *ret)
{
    int rv = -1;
    char *domainXml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((domainXml = virConnectDomainXMLFromNative(priv->conn, args->nativeFormat, args->nativeConfig, args->flags)) == NULL)
        goto cleanup;

    ret->domainXml = domainXml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectDomainXMLToNative(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_domain_xml_to_native_args *args,
    remote_connect_domain_xml_to_native_ret *ret);
static int remoteDispatchConnectDomainXMLToNativeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectDomainXMLToNative");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectDomainXMLToNative(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectDomainXMLToNative(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_domain_xml_to_native_args *args,
    remote_connect_domain_xml_to_native_ret *ret)
{
    int rv = -1;
    char *nativeConfig;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((nativeConfig = virConnectDomainXMLToNative(priv->conn, args->nativeFormat, args->domainXml, args->flags)) == NULL)
        goto cleanup;

    ret->nativeConfig = nativeConfig;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectFindStoragePoolSources(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_find_storage_pool_sources_args *args,
    remote_connect_find_storage_pool_sources_ret *ret);
static int remoteDispatchConnectFindStoragePoolSourcesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectFindStoragePoolSources");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectFindStoragePoolSources(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectFindStoragePoolSources(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_find_storage_pool_sources_args *args,
    remote_connect_find_storage_pool_sources_ret *ret)
{
    int rv = -1;
    char *srcSpec;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    srcSpec = args->srcSpec ? *args->srcSpec : NULL;

    if ((xml = virConnectFindStoragePoolSources(priv->conn, args->type, srcSpec, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectGetAllDomainStats(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_get_all_domain_stats_args *args,
    remote_connect_get_all_domain_stats_ret *ret);
static int remoteDispatchConnectGetAllDomainStatsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetAllDomainStats");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetAllDomainStats(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectGetAllDomainStats body has to be implemented manually */



static int remoteDispatchConnectGetCapabilities(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_get_capabilities_ret *ret);
static int remoteDispatchConnectGetCapabilitiesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetCapabilities");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetCapabilities(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectGetCapabilities(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_get_capabilities_ret *ret)
{
    int rv = -1;
    char *capabilities;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((capabilities = virConnectGetCapabilities(priv->conn)) == NULL)
        goto cleanup;

    ret->capabilities = capabilities;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectGetCPUModelNames(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_get_cpu_model_names_args *args,
    remote_connect_get_cpu_model_names_ret *ret);
static int remoteDispatchConnectGetCPUModelNamesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetCPUModelNames");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetCPUModelNames(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectGetCPUModelNames body has to be implemented manually */



static int remoteDispatchConnectGetDomainCapabilities(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_get_domain_capabilities_args *args,
    remote_connect_get_domain_capabilities_ret *ret);
static int remoteDispatchConnectGetDomainCapabilitiesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetDomainCapabilities");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetDomainCapabilities(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectGetDomainCapabilities(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_get_domain_capabilities_args *args,
    remote_connect_get_domain_capabilities_ret *ret)
{
    int rv = -1;
    char *emulatorbin;
    char *arch;
    char *machine;
    char *virttype;
    char *capabilities;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    emulatorbin = args->emulatorbin ? *args->emulatorbin : NULL;
    arch = args->arch ? *args->arch : NULL;
    machine = args->machine ? *args->machine : NULL;
    virttype = args->virttype ? *args->virttype : NULL;

    if ((capabilities = virConnectGetDomainCapabilities(priv->conn, emulatorbin, arch, machine, virttype, args->flags)) == NULL)
        goto cleanup;

    ret->capabilities = capabilities;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectGetHostname(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_get_hostname_ret *ret);
static int remoteDispatchConnectGetHostnameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetHostname");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetHostname(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectGetHostname(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_get_hostname_ret *ret)
{
    int rv = -1;
    char *hostname;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((hostname = virConnectGetHostname(priv->conn)) == NULL)
        goto cleanup;

    ret->hostname = hostname;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectGetLibVersion(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_get_lib_version_ret *ret);
static int remoteDispatchConnectGetLibVersionHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetLibVersion");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetLibVersion(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectGetLibVersion(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_get_lib_version_ret *ret)
{
    int rv = -1;
    unsigned long lib_ver;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virConnectGetLibVersion(priv->conn, &lib_ver) < 0)
        goto cleanup;

    HYPER_TO_ULONG(ret->lib_ver, lib_ver);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectGetMaxVcpus(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_get_max_vcpus_args *args,
    remote_connect_get_max_vcpus_ret *ret);
static int remoteDispatchConnectGetMaxVcpusHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetMaxVcpus");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetMaxVcpus(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectGetMaxVcpus(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_get_max_vcpus_args *args,
    remote_connect_get_max_vcpus_ret *ret)
{
    int rv = -1;
    char *type;
    int max_vcpus;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    type = args->type ? *args->type : NULL;

    if ((max_vcpus = virConnectGetMaxVcpus(priv->conn, type)) < 0)
        goto cleanup;

    ret->max_vcpus = max_vcpus;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectGetSysinfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_get_sysinfo_args *args,
    remote_connect_get_sysinfo_ret *ret);
static int remoteDispatchConnectGetSysinfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetSysinfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetSysinfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectGetSysinfo(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_get_sysinfo_args *args,
    remote_connect_get_sysinfo_ret *ret)
{
    int rv = -1;
    char *sysinfo;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((sysinfo = virConnectGetSysinfo(priv->conn, args->flags)) == NULL)
        goto cleanup;

    ret->sysinfo = sysinfo;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectGetType(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_get_type_ret *ret);
static int remoteDispatchConnectGetTypeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetType");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetType(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectGetType(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_get_type_ret *ret)
{
    int rv = -1;
    const char *type;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((type = virConnectGetType(priv->conn)) == NULL)
        goto cleanup;

    /* We have to VIR_STRDUP because remoteDispatchClientRequest will
     * free this string after it's been serialised. */
    if (VIR_STRDUP(ret->type, type) < 0)
        goto cleanup;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectGetURI(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_get_uri_ret *ret);
static int remoteDispatchConnectGetURIHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetURI");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetURI(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectGetURI(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_get_uri_ret *ret)
{
    int rv = -1;
    char *uri;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((uri = virConnectGetURI(priv->conn)) == NULL)
        goto cleanup;

    ret->uri = uri;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectGetVersion(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_get_version_ret *ret);
static int remoteDispatchConnectGetVersionHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectGetVersion");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectGetVersion(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectGetVersion(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_get_version_ret *ret)
{
    int rv = -1;
    unsigned long hv_ver;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virConnectGetVersion(priv->conn, &hv_ver) < 0)
        goto cleanup;

    HYPER_TO_ULONG(ret->hv_ver, hv_ver);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectIsSecure(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_is_secure_ret *ret);
static int remoteDispatchConnectIsSecureHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectIsSecure");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectIsSecure(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectIsSecure(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_is_secure_ret *ret)
{
    int rv = -1;
    int secure;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((secure = virConnectIsSecure(priv->conn)) < 0)
        goto cleanup;

    ret->secure = secure;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectListAllDomains(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_list_all_domains_args *args,
    remote_connect_list_all_domains_ret *ret);
static int remoteDispatchConnectListAllDomainsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListAllDomains");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListAllDomains(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListAllDomains(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_list_all_domains_args *args,
    remote_connect_list_all_domains_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virDomainPtr *result = NULL;
    int nresults = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((nresults = 
            virConnectListAllDomains(priv->conn,
                                     args->need_results ? &result : NULL,
                                     args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_DOMAIN_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many domains '%d' for limit '%d'"),
                       nresults, REMOTE_DOMAIN_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        if (VIR_ALLOC_N(ret->domains.domains_val, nresults) < 0)
            goto cleanup;

        ret->domains.domains_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_domain(ret->domains.domains_val + i, result[i]);
    } else {
        ret->domains.domains_len = 0;
        ret->domains.domains_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchConnectListAllInterfaces(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_list_all_interfaces_args *args,
    remote_connect_list_all_interfaces_ret *ret);
static int remoteDispatchConnectListAllInterfacesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListAllInterfaces");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListAllInterfaces(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListAllInterfaces(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_list_all_interfaces_args *args,
    remote_connect_list_all_interfaces_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virInterfacePtr *result = NULL;
    int nresults = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((nresults = 
            virConnectListAllInterfaces(priv->conn,
                                        args->need_results ? &result : NULL,
                                        args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_INTERFACE_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many interfaces '%d' for limit '%d'"),
                       nresults, REMOTE_INTERFACE_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        if (VIR_ALLOC_N(ret->ifaces.ifaces_val, nresults) < 0)
            goto cleanup;

        ret->ifaces.ifaces_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_interface(ret->ifaces.ifaces_val + i, result[i]);
    } else {
        ret->ifaces.ifaces_len = 0;
        ret->ifaces.ifaces_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchConnectListAllNetworks(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_list_all_networks_args *args,
    remote_connect_list_all_networks_ret *ret);
static int remoteDispatchConnectListAllNetworksHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListAllNetworks");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListAllNetworks(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListAllNetworks(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_list_all_networks_args *args,
    remote_connect_list_all_networks_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virNetworkPtr *result = NULL;
    int nresults = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((nresults = 
            virConnectListAllNetworks(priv->conn,
                                      args->need_results ? &result : NULL,
                                      args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_NETWORK_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many networks '%d' for limit '%d'"),
                       nresults, REMOTE_NETWORK_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        if (VIR_ALLOC_N(ret->nets.nets_val, nresults) < 0)
            goto cleanup;

        ret->nets.nets_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_network(ret->nets.nets_val + i, result[i]);
    } else {
        ret->nets.nets_len = 0;
        ret->nets.nets_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchConnectListAllNodeDevices(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_list_all_node_devices_args *args,
    remote_connect_list_all_node_devices_ret *ret);
static int remoteDispatchConnectListAllNodeDevicesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListAllNodeDevices");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListAllNodeDevices(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListAllNodeDevices(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_list_all_node_devices_args *args,
    remote_connect_list_all_node_devices_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virNodeDevicePtr *result = NULL;
    int nresults = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((nresults = 
            virConnectListAllNodeDevices(priv->conn,
                                         args->need_results ? &result : NULL,
                                         args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_NODE_DEVICE_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many node_devices '%d' for limit '%d'"),
                       nresults, REMOTE_NODE_DEVICE_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        if (VIR_ALLOC_N(ret->devices.devices_val, nresults) < 0)
            goto cleanup;

        ret->devices.devices_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_node_device(ret->devices.devices_val + i, result[i]);
    } else {
        ret->devices.devices_len = 0;
        ret->devices.devices_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchConnectListAllNWFilters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_list_all_nwfilters_args *args,
    remote_connect_list_all_nwfilters_ret *ret);
static int remoteDispatchConnectListAllNWFiltersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListAllNWFilters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListAllNWFilters(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListAllNWFilters(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_list_all_nwfilters_args *args,
    remote_connect_list_all_nwfilters_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virNWFilterPtr *result = NULL;
    int nresults = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((nresults = 
            virConnectListAllNWFilters(priv->conn,
                                       args->need_results ? &result : NULL,
                                       args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_NWFILTER_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many nwfilters '%d' for limit '%d'"),
                       nresults, REMOTE_NWFILTER_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        if (VIR_ALLOC_N(ret->filters.filters_val, nresults) < 0)
            goto cleanup;

        ret->filters.filters_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_nwfilter(ret->filters.filters_val + i, result[i]);
    } else {
        ret->filters.filters_len = 0;
        ret->filters.filters_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchConnectListAllSecrets(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_list_all_secrets_args *args,
    remote_connect_list_all_secrets_ret *ret);
static int remoteDispatchConnectListAllSecretsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListAllSecrets");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListAllSecrets(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListAllSecrets(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_list_all_secrets_args *args,
    remote_connect_list_all_secrets_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virSecretPtr *result = NULL;
    int nresults = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((nresults = 
            virConnectListAllSecrets(priv->conn,
                                     args->need_results ? &result : NULL,
                                     args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_SECRET_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many secrets '%d' for limit '%d'"),
                       nresults, REMOTE_SECRET_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        if (VIR_ALLOC_N(ret->secrets.secrets_val, nresults) < 0)
            goto cleanup;

        ret->secrets.secrets_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_secret(ret->secrets.secrets_val + i, result[i]);
    } else {
        ret->secrets.secrets_len = 0;
        ret->secrets.secrets_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchConnectListAllStoragePools(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_list_all_storage_pools_args *args,
    remote_connect_list_all_storage_pools_ret *ret);
static int remoteDispatchConnectListAllStoragePoolsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListAllStoragePools");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListAllStoragePools(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListAllStoragePools(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_list_all_storage_pools_args *args,
    remote_connect_list_all_storage_pools_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virStoragePoolPtr *result = NULL;
    int nresults = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((nresults = 
            virConnectListAllStoragePools(priv->conn,
                                          args->need_results ? &result : NULL,
                                          args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_STORAGE_POOL_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many storage_pools '%d' for limit '%d'"),
                       nresults, REMOTE_STORAGE_POOL_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        if (VIR_ALLOC_N(ret->pools.pools_val, nresults) < 0)
            goto cleanup;

        ret->pools.pools_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_storage_pool(ret->pools.pools_val + i, result[i]);
    } else {
        ret->pools.pools_len = 0;
        ret->pools.pools_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchConnectListDefinedDomains(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_list_defined_domains_args *args,
    remote_connect_list_defined_domains_ret *ret);
static int remoteDispatchConnectListDefinedDomainsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListDefinedDomains");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListDefinedDomains(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListDefinedDomains(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_list_defined_domains_args *args,
    remote_connect_list_defined_domains_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_DOMAIN_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_DOMAIN_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0)
        goto cleanup;

    if ((len = virConnectListDefinedDomains(priv->conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchConnectListDefinedInterfaces(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_list_defined_interfaces_args *args,
    remote_connect_list_defined_interfaces_ret *ret);
static int remoteDispatchConnectListDefinedInterfacesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListDefinedInterfaces");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListDefinedInterfaces(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListDefinedInterfaces(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_list_defined_interfaces_args *args,
    remote_connect_list_defined_interfaces_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_INTERFACE_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_INTERFACE_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0)
        goto cleanup;

    if ((len = virConnectListDefinedInterfaces(priv->conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchConnectListDefinedNetworks(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_list_defined_networks_args *args,
    remote_connect_list_defined_networks_ret *ret);
static int remoteDispatchConnectListDefinedNetworksHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListDefinedNetworks");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListDefinedNetworks(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListDefinedNetworks(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_list_defined_networks_args *args,
    remote_connect_list_defined_networks_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_NETWORK_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_NETWORK_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0)
        goto cleanup;

    if ((len = virConnectListDefinedNetworks(priv->conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchConnectListDefinedStoragePools(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_list_defined_storage_pools_args *args,
    remote_connect_list_defined_storage_pools_ret *ret);
static int remoteDispatchConnectListDefinedStoragePoolsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListDefinedStoragePools");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListDefinedStoragePools(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListDefinedStoragePools(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_list_defined_storage_pools_args *args,
    remote_connect_list_defined_storage_pools_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_STORAGE_POOL_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_STORAGE_POOL_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0)
        goto cleanup;

    if ((len = virConnectListDefinedStoragePools(priv->conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchConnectListDomains(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_list_domains_args *args,
    remote_connect_list_domains_ret *ret);
static int remoteDispatchConnectListDomainsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListDomains");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListDomains(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListDomains(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_list_domains_args *args,
    remote_connect_list_domains_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxids > REMOTE_DOMAIN_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxids > REMOTE_DOMAIN_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->ids.ids_val, args->maxids) < 0)
        goto cleanup;

    if ((len = virConnectListDomains(priv->conn, ret->ids.ids_val, args->maxids)) < 0)
        goto cleanup;

    ret->ids.ids_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->ids.ids_val);
    }
    return rv;
}



static int remoteDispatchConnectListInterfaces(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_list_interfaces_args *args,
    remote_connect_list_interfaces_ret *ret);
static int remoteDispatchConnectListInterfacesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListInterfaces");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListInterfaces(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListInterfaces(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_list_interfaces_args *args,
    remote_connect_list_interfaces_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_INTERFACE_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_INTERFACE_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0)
        goto cleanup;

    if ((len = virConnectListInterfaces(priv->conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchConnectListNetworks(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_list_networks_args *args,
    remote_connect_list_networks_ret *ret);
static int remoteDispatchConnectListNetworksHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListNetworks");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListNetworks(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListNetworks(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_list_networks_args *args,
    remote_connect_list_networks_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_NETWORK_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_NETWORK_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0)
        goto cleanup;

    if ((len = virConnectListNetworks(priv->conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchConnectListNWFilters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_list_nwfilters_args *args,
    remote_connect_list_nwfilters_ret *ret);
static int remoteDispatchConnectListNWFiltersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListNWFilters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListNWFilters(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListNWFilters(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_list_nwfilters_args *args,
    remote_connect_list_nwfilters_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_NWFILTER_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_NWFILTER_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0)
        goto cleanup;

    if ((len = virConnectListNWFilters(priv->conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchConnectListSecrets(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_list_secrets_args *args,
    remote_connect_list_secrets_ret *ret);
static int remoteDispatchConnectListSecretsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListSecrets");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListSecrets(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListSecrets(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_list_secrets_args *args,
    remote_connect_list_secrets_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxuuids > REMOTE_SECRET_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxuuids > REMOTE_SECRET_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->uuids.uuids_val, args->maxuuids) < 0)
        goto cleanup;

    if ((len = virConnectListSecrets(priv->conn, ret->uuids.uuids_val, args->maxuuids)) < 0)
        goto cleanup;

    ret->uuids.uuids_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->uuids.uuids_val);
    }
    return rv;
}



static int remoteDispatchConnectListStoragePools(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_list_storage_pools_args *args,
    remote_connect_list_storage_pools_ret *ret);
static int remoteDispatchConnectListStoragePoolsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectListStoragePools");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectListStoragePools(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectListStoragePools(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_list_storage_pools_args *args,
    remote_connect_list_storage_pools_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_STORAGE_POOL_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_STORAGE_POOL_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0)
        goto cleanup;

    if ((len = virConnectListStoragePools(priv->conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchConnectNetworkEventDeregisterAny(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_network_event_deregister_any_args *args);
static int remoteDispatchConnectNetworkEventDeregisterAnyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNetworkEventDeregisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNetworkEventDeregisterAny(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectNetworkEventDeregisterAny body has to be implemented manually */



static int remoteDispatchConnectNetworkEventRegisterAny(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_network_event_register_any_args *args,
    remote_connect_network_event_register_any_ret *ret);
static int remoteDispatchConnectNetworkEventRegisterAnyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNetworkEventRegisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNetworkEventRegisterAny(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectNetworkEventRegisterAny body has to be implemented manually */



static int remoteDispatchConnectNodeDeviceEventDeregisterAny(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_node_device_event_deregister_any_args *args);
static int remoteDispatchConnectNodeDeviceEventDeregisterAnyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNodeDeviceEventDeregisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNodeDeviceEventDeregisterAny(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectNodeDeviceEventDeregisterAny body has to be implemented manually */



static int remoteDispatchConnectNodeDeviceEventRegisterAny(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_node_device_event_register_any_args *args,
    remote_connect_node_device_event_register_any_ret *ret);
static int remoteDispatchConnectNodeDeviceEventRegisterAnyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNodeDeviceEventRegisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNodeDeviceEventRegisterAny(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectNodeDeviceEventRegisterAny body has to be implemented manually */



static int remoteDispatchConnectNumOfDefinedDomains(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_defined_domains_ret *ret);
static int remoteDispatchConnectNumOfDefinedDomainsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfDefinedDomains");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfDefinedDomains(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfDefinedDomains(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_defined_domains_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfDefinedDomains(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectNumOfDefinedInterfaces(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_defined_interfaces_ret *ret);
static int remoteDispatchConnectNumOfDefinedInterfacesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfDefinedInterfaces");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfDefinedInterfaces(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfDefinedInterfaces(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_defined_interfaces_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfDefinedInterfaces(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectNumOfDefinedNetworks(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_defined_networks_ret *ret);
static int remoteDispatchConnectNumOfDefinedNetworksHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfDefinedNetworks");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfDefinedNetworks(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfDefinedNetworks(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_defined_networks_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfDefinedNetworks(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectNumOfDefinedStoragePools(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_defined_storage_pools_ret *ret);
static int remoteDispatchConnectNumOfDefinedStoragePoolsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfDefinedStoragePools");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfDefinedStoragePools(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfDefinedStoragePools(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_defined_storage_pools_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfDefinedStoragePools(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectNumOfDomains(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_domains_ret *ret);
static int remoteDispatchConnectNumOfDomainsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfDomains");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfDomains(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfDomains(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_domains_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfDomains(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectNumOfInterfaces(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_interfaces_ret *ret);
static int remoteDispatchConnectNumOfInterfacesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfInterfaces");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfInterfaces(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfInterfaces(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_interfaces_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfInterfaces(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectNumOfNetworks(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_networks_ret *ret);
static int remoteDispatchConnectNumOfNetworksHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfNetworks");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfNetworks(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfNetworks(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_networks_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfNetworks(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectNumOfNWFilters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_nwfilters_ret *ret);
static int remoteDispatchConnectNumOfNWFiltersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfNWFilters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfNWFilters(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfNWFilters(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_nwfilters_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfNWFilters(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectNumOfSecrets(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_secrets_ret *ret);
static int remoteDispatchConnectNumOfSecretsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfSecrets");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfSecrets(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfSecrets(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_secrets_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfSecrets(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectNumOfStoragePools(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_storage_pools_ret *ret);
static int remoteDispatchConnectNumOfStoragePoolsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectNumOfStoragePools");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectNumOfStoragePools(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchConnectNumOfStoragePools(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_connect_num_of_storage_pools_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfStoragePools(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchConnectOpen(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_open_args *args);
static int remoteDispatchConnectOpenHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectOpen");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectOpen(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectOpen body has to be implemented manually */



static int remoteDispatchConnectRegisterCloseCallback(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr);
static int remoteDispatchConnectRegisterCloseCallbackHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectRegisterCloseCallback");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectRegisterCloseCallback(server, client, msg, rerr);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectRegisterCloseCallback body has to be implemented manually */



static int remoteDispatchConnectSecretEventDeregisterAny(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_secret_event_deregister_any_args *args);
static int remoteDispatchConnectSecretEventDeregisterAnyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectSecretEventDeregisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectSecretEventDeregisterAny(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectSecretEventDeregisterAny body has to be implemented manually */



static int remoteDispatchConnectSecretEventRegisterAny(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_secret_event_register_any_args *args,
    remote_connect_secret_event_register_any_ret *ret);
static int remoteDispatchConnectSecretEventRegisterAnyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectSecretEventRegisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectSecretEventRegisterAny(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectSecretEventRegisterAny body has to be implemented manually */



static int remoteDispatchConnectStoragePoolEventDeregisterAny(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_storage_pool_event_deregister_any_args *args);
static int remoteDispatchConnectStoragePoolEventDeregisterAnyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectStoragePoolEventDeregisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectStoragePoolEventDeregisterAny(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectStoragePoolEventDeregisterAny body has to be implemented manually */



static int remoteDispatchConnectStoragePoolEventRegisterAny(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_storage_pool_event_register_any_args *args,
    remote_connect_storage_pool_event_register_any_ret *ret);
static int remoteDispatchConnectStoragePoolEventRegisterAnyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectStoragePoolEventRegisterAny");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectStoragePoolEventRegisterAny(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectStoragePoolEventRegisterAny body has to be implemented manually */



static int remoteDispatchConnectSupportsFeature(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_connect_supports_feature_args *args,
    remote_connect_supports_feature_ret *ret);
static int remoteDispatchConnectSupportsFeatureHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectSupportsFeature");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectSupportsFeature(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectSupportsFeature body has to be implemented manually */



static int remoteDispatchConnectUnregisterCloseCallback(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr);
static int remoteDispatchConnectUnregisterCloseCallbackHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchConnectUnregisterCloseCallback");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchConnectUnregisterCloseCallback(server, client, msg, rerr);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchConnectUnregisterCloseCallback body has to be implemented manually */



static int remoteDispatchDomainAbortJob(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_abort_job_args *args);
static int remoteDispatchDomainAbortJobHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainAbortJob");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainAbortJob(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainAbortJob(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_abort_job_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainAbortJob(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainAddIOThread(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_add_iothread_args *args);
static int remoteDispatchDomainAddIOThreadHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainAddIOThread");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainAddIOThread(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainAddIOThread(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_add_iothread_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainAddIOThread(dom, args->iothread_id, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainAttachDevice(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_attach_device_args *args);
static int remoteDispatchDomainAttachDeviceHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainAttachDevice");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainAttachDevice(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainAttachDevice(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_attach_device_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainAttachDevice(dom, args->xml) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainAttachDeviceFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_attach_device_flags_args *args);
static int remoteDispatchDomainAttachDeviceFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainAttachDeviceFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainAttachDeviceFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainAttachDeviceFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_attach_device_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainAttachDeviceFlags(dom, args->xml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainBlockCommit(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_block_commit_args *args);
static int remoteDispatchDomainBlockCommitHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockCommit");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockCommit(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainBlockCommit(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_block_commit_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *base;
    char *top;
    unsigned long bandwidth;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(bandwidth, args->bandwidth);

    base = args->base ? *args->base : NULL;
    top = args->top ? *args->top : NULL;

    if (virDomainBlockCommit(dom, args->disk, base, top, bandwidth, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainBlockCopy(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_block_copy_args *args);
static int remoteDispatchDomainBlockCopyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockCopy");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockCopy(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainBlockCopy(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_block_copy_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((virTypedParameterRemotePtr) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_BLOCK_COPY_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainBlockCopy(dom, args->path, args->destxml, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainBlockJobAbort(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_block_job_abort_args *args);
static int remoteDispatchDomainBlockJobAbortHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockJobAbort");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockJobAbort(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainBlockJobAbort(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_block_job_abort_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainBlockJobAbort(dom, args->path, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainBlockJobSetSpeed(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_block_job_set_speed_args *args);
static int remoteDispatchDomainBlockJobSetSpeedHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockJobSetSpeed");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockJobSetSpeed(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainBlockJobSetSpeed(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_block_job_set_speed_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long bandwidth;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(bandwidth, args->bandwidth);

    if (virDomainBlockJobSetSpeed(dom, args->path, bandwidth, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainBlockPeek(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_block_peek_args *args,
    remote_domain_block_peek_ret *ret);
static int remoteDispatchDomainBlockPeekHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockPeek");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockPeek(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainBlockPeek body has to be implemented manually */



static int remoteDispatchDomainBlockPull(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_block_pull_args *args);
static int remoteDispatchDomainBlockPullHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockPull");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockPull(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainBlockPull(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_block_pull_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long bandwidth;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(bandwidth, args->bandwidth);

    if (virDomainBlockPull(dom, args->path, bandwidth, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainBlockRebase(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_block_rebase_args *args);
static int remoteDispatchDomainBlockRebaseHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockRebase");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockRebase(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainBlockRebase(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_block_rebase_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *base;
    unsigned long bandwidth;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(bandwidth, args->bandwidth);

    base = args->base ? *args->base : NULL;

    if (virDomainBlockRebase(dom, args->path, base, bandwidth, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainBlockResize(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_block_resize_args *args);
static int remoteDispatchDomainBlockResizeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockResize");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockResize(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainBlockResize(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_block_resize_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainBlockResize(dom, args->disk, args->size, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainBlockStats(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_block_stats_args *args,
    remote_domain_block_stats_ret *ret);
static int remoteDispatchDomainBlockStatsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockStats");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockStats(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainBlockStats(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_block_stats_args *args,
    remote_domain_block_stats_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainBlockStatsStruct tmp;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainBlockStats(dom, args->path, &tmp, sizeof(tmp)) < 0)
        goto cleanup;

    ret->rd_req = tmp.rd_req;
    ret->rd_bytes = tmp.rd_bytes;
    ret->wr_req = tmp.wr_req;
    ret->wr_bytes = tmp.wr_bytes;
    ret->errs = tmp.errs;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainBlockStatsFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_block_stats_flags_args *args,
    remote_domain_block_stats_flags_ret *ret);
static int remoteDispatchDomainBlockStatsFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainBlockStatsFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainBlockStatsFlags(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainBlockStatsFlags body has to be implemented manually */



static int remoteDispatchDomainCoreDump(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_core_dump_args *args);
static int remoteDispatchDomainCoreDumpHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCoreDump");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCoreDump(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainCoreDump(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_core_dump_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainCoreDump(dom, args->to, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainCoreDumpWithFormat(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_core_dump_with_format_args *args);
static int remoteDispatchDomainCoreDumpWithFormatHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCoreDumpWithFormat");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCoreDumpWithFormat(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainCoreDumpWithFormat(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_core_dump_with_format_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainCoreDumpWithFormat(dom, args->to, args->dumpformat, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainCreate(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_create_args *args);
static int remoteDispatchDomainCreateHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCreate");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCreate(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainCreate(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_create_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainCreate(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainCreateWithFiles(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_create_with_files_args *args,
    remote_domain_create_with_files_ret *ret);
static int remoteDispatchDomainCreateWithFilesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCreateWithFiles");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCreateWithFiles(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainCreateWithFiles body has to be implemented manually */



static int remoteDispatchDomainCreateWithFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_create_with_flags_args *args,
    remote_domain_create_with_flags_ret *ret);
static int remoteDispatchDomainCreateWithFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCreateWithFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCreateWithFlags(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainCreateWithFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_create_with_flags_args *args,
    remote_domain_create_with_flags_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainCreateWithFlags(dom, args->flags) < 0)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainCreateXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_create_xml_args *args,
    remote_domain_create_xml_ret *ret);
static int remoteDispatchDomainCreateXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCreateXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCreateXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainCreateXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_create_xml_args *args,
    remote_domain_create_xml_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dom = virDomainCreateXML(priv->conn, args->xml_desc, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainCreateXMLWithFiles(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_create_xml_with_files_args *args,
    remote_domain_create_xml_with_files_ret *ret);
static int remoteDispatchDomainCreateXMLWithFilesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainCreateXMLWithFiles");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainCreateXMLWithFiles(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainCreateXMLWithFiles body has to be implemented manually */



static int remoteDispatchDomainDefineXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_define_xml_args *args,
    remote_domain_define_xml_ret *ret);
static int remoteDispatchDomainDefineXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainDefineXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainDefineXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainDefineXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_define_xml_args *args,
    remote_domain_define_xml_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dom = virDomainDefineXML(priv->conn, args->xml)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainDefineXMLFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_define_xml_flags_args *args,
    remote_domain_define_xml_flags_ret *ret);
static int remoteDispatchDomainDefineXMLFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainDefineXMLFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainDefineXMLFlags(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainDefineXMLFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_define_xml_flags_args *args,
    remote_domain_define_xml_flags_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dom = virDomainDefineXMLFlags(priv->conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainDelIOThread(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_del_iothread_args *args);
static int remoteDispatchDomainDelIOThreadHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainDelIOThread");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainDelIOThread(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainDelIOThread(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_del_iothread_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainDelIOThread(dom, args->iothread_id, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainDestroy(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_destroy_args *args);
static int remoteDispatchDomainDestroyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainDestroy");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainDestroy(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainDestroy(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_destroy_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainDestroy(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainDestroyFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_destroy_flags_args *args);
static int remoteDispatchDomainDestroyFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainDestroyFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainDestroyFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainDestroyFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_destroy_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainDestroyFlags(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainDetachDevice(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_detach_device_args *args);
static int remoteDispatchDomainDetachDeviceHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainDetachDevice");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainDetachDevice(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainDetachDevice(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_detach_device_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainDetachDevice(dom, args->xml) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainDetachDeviceFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_detach_device_flags_args *args);
static int remoteDispatchDomainDetachDeviceFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainDetachDeviceFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainDetachDeviceFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainDetachDeviceFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_detach_device_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainDetachDeviceFlags(dom, args->xml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainFSFreeze(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_fsfreeze_args *args,
    remote_domain_fsfreeze_ret *ret);
static int remoteDispatchDomainFSFreezeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainFSFreeze");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainFSFreeze(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainFSFreeze(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_fsfreeze_args *args,
    remote_domain_fsfreeze_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int filesystems;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((filesystems = virDomainFSFreeze(dom, (const char **) args->mountpoints.mountpoints_val, args->mountpoints.mountpoints_len, args->flags)) < 0)
        goto cleanup;

    ret->filesystems = filesystems;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainFSThaw(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_fsthaw_args *args,
    remote_domain_fsthaw_ret *ret);
static int remoteDispatchDomainFSThawHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainFSThaw");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainFSThaw(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainFSThaw(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_fsthaw_args *args,
    remote_domain_fsthaw_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int filesystems;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((filesystems = virDomainFSThaw(dom, (const char **) args->mountpoints.mountpoints_val, args->mountpoints.mountpoints_len, args->flags)) < 0)
        goto cleanup;

    ret->filesystems = filesystems;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainFSTrim(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_fstrim_args *args);
static int remoteDispatchDomainFSTrimHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainFSTrim");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainFSTrim(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainFSTrim(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_fstrim_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *mountPoint;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    mountPoint = args->mountPoint ? *args->mountPoint : NULL;

    if (virDomainFSTrim(dom, mountPoint, args->minimum, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetAutostart(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_autostart_args *args,
    remote_domain_get_autostart_ret *ret);
static int remoteDispatchDomainGetAutostartHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetAutostart");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetAutostart(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetAutostart(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_autostart_args *args,
    remote_domain_get_autostart_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int autostart;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainGetAutostart(dom, &autostart) < 0)
        goto cleanup;

    ret->autostart = autostart;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetBlkioParameters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_blkio_parameters_args *args,
    remote_domain_get_blkio_parameters_ret *ret);
static int remoteDispatchDomainGetBlkioParametersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetBlkioParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetBlkioParameters(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetBlkioParameters body has to be implemented manually */



static int remoteDispatchDomainGetBlockInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_block_info_args *args,
    remote_domain_get_block_info_ret *ret);
static int remoteDispatchDomainGetBlockInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetBlockInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetBlockInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetBlockInfo(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_block_info_args *args,
    remote_domain_get_block_info_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainBlockInfo tmp;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainGetBlockInfo(dom, args->path, &tmp, args->flags) < 0)
        goto cleanup;

    ret->allocation = tmp.allocation;
    ret->capacity = tmp.capacity;
    ret->physical = tmp.physical;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetBlockIoTune(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_block_io_tune_args *args,
    remote_domain_get_block_io_tune_ret *ret);
static int remoteDispatchDomainGetBlockIoTuneHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetBlockIoTune");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetBlockIoTune(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetBlockIoTune body has to be implemented manually */



static int remoteDispatchDomainGetBlockJobInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_block_job_info_args *args,
    remote_domain_get_block_job_info_ret *ret);
static int remoteDispatchDomainGetBlockJobInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetBlockJobInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetBlockJobInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetBlockJobInfo body has to be implemented manually */



static int remoteDispatchDomainGetControlInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_control_info_args *args,
    remote_domain_get_control_info_ret *ret);
static int remoteDispatchDomainGetControlInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetControlInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetControlInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetControlInfo(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_control_info_args *args,
    remote_domain_get_control_info_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainControlInfo tmp;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainGetControlInfo(dom, &tmp, args->flags) < 0)
        goto cleanup;

    ret->state = tmp.state;
    ret->details = tmp.details;
    ret->stateTime = tmp.stateTime;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetCPUStats(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_cpu_stats_args *args,
    remote_domain_get_cpu_stats_ret *ret);
static int remoteDispatchDomainGetCPUStatsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetCPUStats");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetCPUStats(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetCPUStats body has to be implemented manually */



static int remoteDispatchDomainGetDiskErrors(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_disk_errors_args *args,
    remote_domain_get_disk_errors_ret *ret);
static int remoteDispatchDomainGetDiskErrorsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetDiskErrors");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetDiskErrors(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetDiskErrors body has to be implemented manually */



static int remoteDispatchDomainGetEmulatorPinInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_emulator_pin_info_args *args,
    remote_domain_get_emulator_pin_info_ret *ret);
static int remoteDispatchDomainGetEmulatorPinInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetEmulatorPinInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetEmulatorPinInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetEmulatorPinInfo body has to be implemented manually */



static int remoteDispatchDomainGetFSInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_fsinfo_args *args,
    remote_domain_get_fsinfo_ret *ret);
static int remoteDispatchDomainGetFSInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetFSInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetFSInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetFSInfo body has to be implemented manually */



static int remoteDispatchDomainGetGuestVcpus(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_guest_vcpus_args *args,
    remote_domain_get_guest_vcpus_ret *ret);
static int remoteDispatchDomainGetGuestVcpusHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetGuestVcpus");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetGuestVcpus(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetGuestVcpus(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_guest_vcpus_args *args,
    remote_domain_get_guest_vcpus_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    unsigned int params_len = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainGetGuestVcpus(dom, &params, &params_len, args->flags) < 0)
        goto cleanup;

    if (virTypedParamsSerialize(params, params_len,
                                (virTypedParameterRemotePtr *) &ret->params.params_val,
                                &ret->params.params_len,
                                VIR_TYPED_PARAM_STRING_OKAY) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        virTypedParamsRemoteFree((virTypedParameterRemotePtr) ret->params.params_val,
                                 ret->params.params_len);

    }
    virObjectUnref(dom);
    virTypedParamsFree(params, params_len);
    return rv;
}



static int remoteDispatchDomainGetHostname(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_hostname_args *args,
    remote_domain_get_hostname_ret *ret);
static int remoteDispatchDomainGetHostnameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetHostname");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetHostname(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetHostname(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_hostname_args *args,
    remote_domain_get_hostname_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *hostname;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((hostname = virDomainGetHostname(dom, args->flags)) == NULL)
        goto cleanup;

    ret->hostname = hostname;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_info_args *args,
    remote_domain_get_info_ret *ret);
static int remoteDispatchDomainGetInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetInfo(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_info_args *args,
    remote_domain_get_info_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainInfo tmp;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainGetInfo(dom, &tmp) < 0)
        goto cleanup;

    ret->state = tmp.state;
    ret->maxMem = tmp.maxMem;
    ret->memory = tmp.memory;
    ret->nrVirtCpu = tmp.nrVirtCpu;
    ret->cpuTime = tmp.cpuTime;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetInterfaceParameters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_interface_parameters_args *args,
    remote_domain_get_interface_parameters_ret *ret);
static int remoteDispatchDomainGetInterfaceParametersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetInterfaceParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetInterfaceParameters(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetInterfaceParameters body has to be implemented manually */



static int remoteDispatchDomainGetIOThreadInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_iothread_info_args *args,
    remote_domain_get_iothread_info_ret *ret);
static int remoteDispatchDomainGetIOThreadInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetIOThreadInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetIOThreadInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetIOThreadInfo body has to be implemented manually */



static int remoteDispatchDomainGetJobInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_job_info_args *args,
    remote_domain_get_job_info_ret *ret);
static int remoteDispatchDomainGetJobInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetJobInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetJobInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetJobInfo(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_job_info_args *args,
    remote_domain_get_job_info_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainJobInfo tmp;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainGetJobInfo(dom, &tmp) < 0)
        goto cleanup;

    ret->type = tmp.type;
    ret->timeElapsed = tmp.timeElapsed;
    ret->timeRemaining = tmp.timeRemaining;
    ret->dataTotal = tmp.dataTotal;
    ret->dataProcessed = tmp.dataProcessed;
    ret->dataRemaining = tmp.dataRemaining;
    ret->memTotal = tmp.memTotal;
    ret->memProcessed = tmp.memProcessed;
    ret->memRemaining = tmp.memRemaining;
    ret->fileTotal = tmp.fileTotal;
    ret->fileProcessed = tmp.fileProcessed;
    ret->fileRemaining = tmp.fileRemaining;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetJobStats(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_job_stats_args *args,
    remote_domain_get_job_stats_ret *ret);
static int remoteDispatchDomainGetJobStatsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetJobStats");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetJobStats(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetJobStats body has to be implemented manually */



static int remoteDispatchDomainGetMaxMemory(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_max_memory_args *args,
    remote_domain_get_max_memory_ret *ret);
static int remoteDispatchDomainGetMaxMemoryHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetMaxMemory");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetMaxMemory(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetMaxMemory(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_max_memory_args *args,
    remote_domain_get_max_memory_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long long memory;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((memory = virDomainGetMaxMemory(dom)) == 0)
        goto cleanup;

    ret->memory = memory;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetMaxVcpus(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_max_vcpus_args *args,
    remote_domain_get_max_vcpus_ret *ret);
static int remoteDispatchDomainGetMaxVcpusHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetMaxVcpus");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetMaxVcpus(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetMaxVcpus(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_max_vcpus_args *args,
    remote_domain_get_max_vcpus_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((num = virDomainGetMaxVcpus(dom)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetMemoryParameters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_memory_parameters_args *args,
    remote_domain_get_memory_parameters_ret *ret);
static int remoteDispatchDomainGetMemoryParametersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetMemoryParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetMemoryParameters(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetMemoryParameters body has to be implemented manually */



static int remoteDispatchDomainGetMetadata(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_metadata_args *args,
    remote_domain_get_metadata_ret *ret);
static int remoteDispatchDomainGetMetadataHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetMetadata");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetMetadata(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetMetadata(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_metadata_args *args,
    remote_domain_get_metadata_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *uri;
    char *metadata;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    uri = args->uri ? *args->uri : NULL;

    if ((metadata = virDomainGetMetadata(dom, args->type, uri, args->flags)) == NULL)
        goto cleanup;

    ret->metadata = metadata;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetNumaParameters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_numa_parameters_args *args,
    remote_domain_get_numa_parameters_ret *ret);
static int remoteDispatchDomainGetNumaParametersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetNumaParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetNumaParameters(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetNumaParameters body has to be implemented manually */



static int remoteDispatchDomainGetOSType(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_os_type_args *args,
    remote_domain_get_os_type_ret *ret);
static int remoteDispatchDomainGetOSTypeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetOSType");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetOSType(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetOSType(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_os_type_args *args,
    remote_domain_get_os_type_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *type;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((type = virDomainGetOSType(dom)) == NULL)
        goto cleanup;

    ret->type = type;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetPerfEvents(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_perf_events_args *args,
    remote_domain_get_perf_events_ret *ret);
static int remoteDispatchDomainGetPerfEventsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetPerfEvents");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetPerfEvents(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetPerfEvents body has to be implemented manually */



static int remoteDispatchDomainGetSchedulerParameters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_scheduler_parameters_args *args,
    remote_domain_get_scheduler_parameters_ret *ret);
static int remoteDispatchDomainGetSchedulerParametersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetSchedulerParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetSchedulerParameters(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetSchedulerParameters body has to be implemented manually */



static int remoteDispatchDomainGetSchedulerParametersFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_scheduler_parameters_flags_args *args,
    remote_domain_get_scheduler_parameters_flags_ret *ret);
static int remoteDispatchDomainGetSchedulerParametersFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetSchedulerParametersFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetSchedulerParametersFlags(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetSchedulerParametersFlags body has to be implemented manually */



static int remoteDispatchDomainGetSchedulerType(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_scheduler_type_args *args,
    remote_domain_get_scheduler_type_ret *ret);
static int remoteDispatchDomainGetSchedulerTypeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetSchedulerType");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetSchedulerType(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetSchedulerType body has to be implemented manually */



static int remoteDispatchDomainGetSecurityLabel(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_security_label_args *args,
    remote_domain_get_security_label_ret *ret);
static int remoteDispatchDomainGetSecurityLabelHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetSecurityLabel");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetSecurityLabel(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetSecurityLabel body has to be implemented manually */



static int remoteDispatchDomainGetSecurityLabelList(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_security_label_list_args *args,
    remote_domain_get_security_label_list_ret *ret);
static int remoteDispatchDomainGetSecurityLabelListHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetSecurityLabelList");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetSecurityLabelList(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetSecurityLabelList body has to be implemented manually */



static int remoteDispatchDomainGetState(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_state_args *args,
    remote_domain_get_state_ret *ret);
static int remoteDispatchDomainGetStateHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetState");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetState(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetState body has to be implemented manually */



static int remoteDispatchDomainGetTime(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_time_args *args,
    remote_domain_get_time_ret *ret);
static int remoteDispatchDomainGetTimeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetTime");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetTime(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetTime body has to be implemented manually */



static int remoteDispatchDomainGetVcpuPinInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_vcpu_pin_info_args *args,
    remote_domain_get_vcpu_pin_info_ret *ret);
static int remoteDispatchDomainGetVcpuPinInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetVcpuPinInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetVcpuPinInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetVcpuPinInfo body has to be implemented manually */



static int remoteDispatchDomainGetVcpus(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_vcpus_args *args,
    remote_domain_get_vcpus_ret *ret);
static int remoteDispatchDomainGetVcpusHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetVcpus");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetVcpus(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainGetVcpus body has to be implemented manually */



static int remoteDispatchDomainGetVcpusFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_vcpus_flags_args *args,
    remote_domain_get_vcpus_flags_ret *ret);
static int remoteDispatchDomainGetVcpusFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetVcpusFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetVcpusFlags(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetVcpusFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_vcpus_flags_args *args,
    remote_domain_get_vcpus_flags_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((num = virDomainGetVcpusFlags(dom, args->flags)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_get_xml_desc_args *args,
    remote_domain_get_xml_desc_ret *ret);
static int remoteDispatchDomainGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_xml_desc_args *args,
    remote_domain_get_xml_desc_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((xml = virDomainGetXMLDesc(dom, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainHasCurrentSnapshot(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_has_current_snapshot_args *args,
    remote_domain_has_current_snapshot_ret *ret);
static int remoteDispatchDomainHasCurrentSnapshotHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainHasCurrentSnapshot");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainHasCurrentSnapshot(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainHasCurrentSnapshot(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_has_current_snapshot_args *args,
    remote_domain_has_current_snapshot_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int result;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((result = virDomainHasCurrentSnapshot(dom, args->flags)) < 0)
        goto cleanup;

    ret->result = result;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainHasManagedSaveImage(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_has_managed_save_image_args *args,
    remote_domain_has_managed_save_image_ret *ret);
static int remoteDispatchDomainHasManagedSaveImageHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainHasManagedSaveImage");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainHasManagedSaveImage(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainHasManagedSaveImage(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_has_managed_save_image_args *args,
    remote_domain_has_managed_save_image_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int result;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((result = virDomainHasManagedSaveImage(dom, args->flags)) < 0)
        goto cleanup;

    ret->result = result;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainInjectNMI(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_inject_nmi_args *args);
static int remoteDispatchDomainInjectNMIHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainInjectNMI");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainInjectNMI(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainInjectNMI(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_inject_nmi_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainInjectNMI(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainInterfaceAddresses(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_interface_addresses_args *args,
    remote_domain_interface_addresses_ret *ret);
static int remoteDispatchDomainInterfaceAddressesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainInterfaceAddresses");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainInterfaceAddresses(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainInterfaceAddresses body has to be implemented manually */



static int remoteDispatchDomainInterfaceStats(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_interface_stats_args *args,
    remote_domain_interface_stats_ret *ret);
static int remoteDispatchDomainInterfaceStatsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainInterfaceStats");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainInterfaceStats(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainInterfaceStats(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_interface_stats_args *args,
    remote_domain_interface_stats_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainInterfaceStatsStruct tmp;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainInterfaceStats(dom, args->path, &tmp, sizeof(tmp)) < 0)
        goto cleanup;

    ret->rx_bytes = tmp.rx_bytes;
    ret->rx_packets = tmp.rx_packets;
    ret->rx_errs = tmp.rx_errs;
    ret->rx_drop = tmp.rx_drop;
    ret->tx_bytes = tmp.tx_bytes;
    ret->tx_packets = tmp.tx_packets;
    ret->tx_errs = tmp.tx_errs;
    ret->tx_drop = tmp.tx_drop;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainIsActive(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_is_active_args *args,
    remote_domain_is_active_ret *ret);
static int remoteDispatchDomainIsActiveHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainIsActive");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainIsActive(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainIsActive(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_is_active_args *args,
    remote_domain_is_active_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int active;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((active = virDomainIsActive(dom)) < 0)
        goto cleanup;

    ret->active = active;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainIsPersistent(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_is_persistent_args *args,
    remote_domain_is_persistent_ret *ret);
static int remoteDispatchDomainIsPersistentHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainIsPersistent");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainIsPersistent(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainIsPersistent(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_is_persistent_args *args,
    remote_domain_is_persistent_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int persistent;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((persistent = virDomainIsPersistent(dom)) < 0)
        goto cleanup;

    ret->persistent = persistent;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainIsUpdated(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_is_updated_args *args,
    remote_domain_is_updated_ret *ret);
static int remoteDispatchDomainIsUpdatedHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainIsUpdated");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainIsUpdated(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainIsUpdated(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_is_updated_args *args,
    remote_domain_is_updated_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int updated;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((updated = virDomainIsUpdated(dom)) < 0)
        goto cleanup;

    ret->updated = updated;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainListAllSnapshots(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_list_all_snapshots_args *args,
    remote_domain_list_all_snapshots_ret *ret);
static int remoteDispatchDomainListAllSnapshotsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainListAllSnapshots");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainListAllSnapshots(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainListAllSnapshots(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_list_all_snapshots_args *args,
    remote_domain_list_all_snapshots_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr *result = NULL;
    int nresults = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((nresults = 
            virDomainListAllSnapshots(dom,
                                      args->need_results ? &result : NULL,
                                      args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_DOMAIN_SNAPSHOT_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many domain_snapshots '%d' for limit '%d'"),
                       nresults, REMOTE_DOMAIN_SNAPSHOT_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        if (VIR_ALLOC_N(ret->snapshots.snapshots_val, nresults) < 0)
            goto cleanup;

        ret->snapshots.snapshots_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_domain_snapshot(ret->snapshots.snapshots_val + i, result[i]);
    } else {
        ret->snapshots.snapshots_len = 0;
        ret->snapshots.snapshots_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchDomainLookupByID(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_lookup_by_id_args *args,
    remote_domain_lookup_by_id_ret *ret);
static int remoteDispatchDomainLookupByIDHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainLookupByID");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainLookupByID(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainLookupByID(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_lookup_by_id_args *args,
    remote_domain_lookup_by_id_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dom = virDomainLookupByID(priv->conn, args->id)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainLookupByName(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_lookup_by_name_args *args,
    remote_domain_lookup_by_name_ret *ret);
static int remoteDispatchDomainLookupByNameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainLookupByName");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainLookupByName(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainLookupByName(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_lookup_by_name_args *args,
    remote_domain_lookup_by_name_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dom = virDomainLookupByName(priv->conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainLookupByUUID(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_lookup_by_uuid_args *args,
    remote_domain_lookup_by_uuid_ret *ret);
static int remoteDispatchDomainLookupByUUIDHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainLookupByUUID");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainLookupByUUID(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainLookupByUUID(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_lookup_by_uuid_args *args,
    remote_domain_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dom = virDomainLookupByUUID(priv->conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainManagedSave(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_managed_save_args *args);
static int remoteDispatchDomainManagedSaveHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainManagedSave");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainManagedSave(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainManagedSave(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_managed_save_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainManagedSave(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainManagedSaveDefineXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_managed_save_define_xml_args *args);
static int remoteDispatchDomainManagedSaveDefineXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainManagedSaveDefineXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainManagedSaveDefineXML(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainManagedSaveDefineXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_managed_save_define_xml_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *dxml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    dxml = args->dxml ? *args->dxml : NULL;

    if (virDomainManagedSaveDefineXML(dom, dxml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainManagedSaveGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_managed_save_get_xml_desc_args *args,
    remote_domain_managed_save_get_xml_desc_ret *ret);
static int remoteDispatchDomainManagedSaveGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainManagedSaveGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainManagedSaveGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainManagedSaveGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_managed_save_get_xml_desc_args *args,
    remote_domain_managed_save_get_xml_desc_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((xml = virDomainManagedSaveGetXMLDesc(dom, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainManagedSaveRemove(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_managed_save_remove_args *args);
static int remoteDispatchDomainManagedSaveRemoveHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainManagedSaveRemove");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainManagedSaveRemove(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainManagedSaveRemove(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_managed_save_remove_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainManagedSaveRemove(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainMemoryPeek(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_memory_peek_args *args,
    remote_domain_memory_peek_ret *ret);
static int remoteDispatchDomainMemoryPeekHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMemoryPeek");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMemoryPeek(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMemoryPeek body has to be implemented manually */



static int remoteDispatchDomainMemoryStats(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_memory_stats_args *args,
    remote_domain_memory_stats_ret *ret);
static int remoteDispatchDomainMemoryStatsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMemoryStats");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMemoryStats(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMemoryStats body has to be implemented manually */



static int remoteDispatchDomainMigrateBegin3(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_begin3_args *args,
    remote_domain_migrate_begin3_ret *ret);
static int remoteDispatchDomainMigrateBegin3Helper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateBegin3");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateBegin3(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigrateBegin3 body has to be implemented manually */



static int remoteDispatchDomainMigrateBegin3Params(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_begin3_params_args *args,
    remote_domain_migrate_begin3_params_ret *ret);
static int remoteDispatchDomainMigrateBegin3ParamsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateBegin3Params");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateBegin3Params(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigrateBegin3Params body has to be implemented manually */



static int remoteDispatchDomainMigrateConfirm3(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_confirm3_args *args);
static int remoteDispatchDomainMigrateConfirm3Helper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateConfirm3");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateConfirm3(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigrateConfirm3 body has to be implemented manually */



static int remoteDispatchDomainMigrateConfirm3Params(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_confirm3_params_args *args);
static int remoteDispatchDomainMigrateConfirm3ParamsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateConfirm3Params");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateConfirm3Params(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigrateConfirm3Params body has to be implemented manually */



static int remoteDispatchDomainMigrateFinish(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_finish_args *args,
    remote_domain_migrate_finish_ret *ret);
static int remoteDispatchDomainMigrateFinishHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateFinish");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateFinish(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigrateFinish(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_finish_args *args,
    remote_domain_migrate_finish_ret *ret)
{
    int rv = -1;
    unsigned long flags;
    virDomainPtr ddom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    HYPER_TO_ULONG(flags, args->flags);

    if ((ddom = virDomainMigrateFinish(priv->conn, args->dname, args->cookie.cookie_val, args->cookie.cookie_len, args->uri, flags)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->ddom, ddom);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(ddom);
    return rv;
}



static int remoteDispatchDomainMigrateFinish2(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_finish2_args *args,
    remote_domain_migrate_finish2_ret *ret);
static int remoteDispatchDomainMigrateFinish2Helper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateFinish2");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateFinish2(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigrateFinish2(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_finish2_args *args,
    remote_domain_migrate_finish2_ret *ret)
{
    int rv = -1;
    unsigned long flags;
    virDomainPtr ddom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    HYPER_TO_ULONG(flags, args->flags);

    if ((ddom = virDomainMigrateFinish2(priv->conn, args->dname, args->cookie.cookie_val, args->cookie.cookie_len, args->uri, flags, args->retcode)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->ddom, ddom);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(ddom);
    return rv;
}



static int remoteDispatchDomainMigrateFinish3(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_finish3_args *args,
    remote_domain_migrate_finish3_ret *ret);
static int remoteDispatchDomainMigrateFinish3Helper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateFinish3");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateFinish3(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigrateFinish3 body has to be implemented manually */



static int remoteDispatchDomainMigrateFinish3Params(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_finish3_params_args *args,
    remote_domain_migrate_finish3_params_ret *ret);
static int remoteDispatchDomainMigrateFinish3ParamsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateFinish3Params");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateFinish3Params(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigrateFinish3Params body has to be implemented manually */



static int remoteDispatchDomainMigrateGetCompressionCache(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_get_compression_cache_args *args,
    remote_domain_migrate_get_compression_cache_ret *ret);
static int remoteDispatchDomainMigrateGetCompressionCacheHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateGetCompressionCache");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateGetCompressionCache(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigrateGetCompressionCache(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_get_compression_cache_args *args,
    remote_domain_migrate_get_compression_cache_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long long cacheSize;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainMigrateGetCompressionCache(dom, &cacheSize, args->flags) < 0)
        goto cleanup;

    ret->cacheSize = cacheSize;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainMigrateGetMaxDowntime(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_get_max_downtime_args *args,
    remote_domain_migrate_get_max_downtime_ret *ret);
static int remoteDispatchDomainMigrateGetMaxDowntimeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateGetMaxDowntime");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateGetMaxDowntime(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigrateGetMaxDowntime(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_get_max_downtime_args *args,
    remote_domain_migrate_get_max_downtime_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long long downtime;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainMigrateGetMaxDowntime(dom, &downtime, args->flags) < 0)
        goto cleanup;

    ret->downtime = downtime;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainMigrateGetMaxSpeed(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_get_max_speed_args *args,
    remote_domain_migrate_get_max_speed_ret *ret);
static int remoteDispatchDomainMigrateGetMaxSpeedHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateGetMaxSpeed");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateGetMaxSpeed(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigrateGetMaxSpeed(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_get_max_speed_args *args,
    remote_domain_migrate_get_max_speed_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long bandwidth;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainMigrateGetMaxSpeed(dom, &bandwidth, args->flags) < 0)
        goto cleanup;

    HYPER_TO_ULONG(ret->bandwidth, bandwidth);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainMigratePerform(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_perform_args *args);
static int remoteDispatchDomainMigratePerformHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePerform");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePerform(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigratePerform(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_perform_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long flags;
    char *dname;
    unsigned long resource;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(flags, args->flags);

    HYPER_TO_ULONG(resource, args->resource);

    dname = args->dname ? *args->dname : NULL;

    if (virDomainMigratePerform(dom, args->cookie.cookie_val, args->cookie.cookie_len, args->uri, flags, dname, resource) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainMigratePerform3(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_perform3_args *args,
    remote_domain_migrate_perform3_ret *ret);
static int remoteDispatchDomainMigratePerform3Helper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePerform3");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePerform3(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigratePerform3 body has to be implemented manually */



static int remoteDispatchDomainMigratePerform3Params(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_perform3_params_args *args,
    remote_domain_migrate_perform3_params_ret *ret);
static int remoteDispatchDomainMigratePerform3ParamsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePerform3Params");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePerform3Params(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigratePerform3Params body has to be implemented manually */



static int remoteDispatchDomainMigratePrepare(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_prepare_args *args,
    remote_domain_migrate_prepare_ret *ret);
static int remoteDispatchDomainMigratePrepareHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePrepare");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePrepare(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigratePrepare body has to be implemented manually */



static int remoteDispatchDomainMigratePrepare2(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_prepare2_args *args,
    remote_domain_migrate_prepare2_ret *ret);
static int remoteDispatchDomainMigratePrepare2Helper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePrepare2");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePrepare2(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigratePrepare2 body has to be implemented manually */



static int remoteDispatchDomainMigratePrepare3(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_prepare3_args *args,
    remote_domain_migrate_prepare3_ret *ret);
static int remoteDispatchDomainMigratePrepare3Helper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePrepare3");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePrepare3(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigratePrepare3 body has to be implemented manually */



static int remoteDispatchDomainMigratePrepare3Params(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_prepare3_params_args *args,
    remote_domain_migrate_prepare3_params_ret *ret);
static int remoteDispatchDomainMigratePrepare3ParamsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePrepare3Params");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePrepare3Params(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigratePrepare3Params body has to be implemented manually */



static int remoteDispatchDomainMigratePrepareTunnel(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_prepare_tunnel_args *args);
static int remoteDispatchDomainMigratePrepareTunnelHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePrepareTunnel");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePrepareTunnel(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigratePrepareTunnel(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_prepare_tunnel_args *args)
{
    int rv = -1;
    unsigned long flags;
    char *dname;
    unsigned long resource;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);
    virStreamPtr st = NULL;
    daemonClientStreamPtr stream = NULL;
    const bool sparse = false;

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    HYPER_TO_ULONG(flags, args->flags);

    HYPER_TO_ULONG(resource, args->resource);

    dname = args->dname ? *args->dname : NULL;

    if (!(st = virStreamNew(priv->conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, &msg->header, sparse)))
        goto cleanup;

    if (virDomainMigratePrepareTunnel(priv->conn, st, flags, dname, resource, args->dom_xml) < 0)
        goto cleanup;

    if (daemonAddClientStream(client, stream, false) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virObjectUnref(st);
        }
    }
    return rv;
}



static int remoteDispatchDomainMigratePrepareTunnel3(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_prepare_tunnel3_args *args,
    remote_domain_migrate_prepare_tunnel3_ret *ret);
static int remoteDispatchDomainMigratePrepareTunnel3Helper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePrepareTunnel3");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePrepareTunnel3(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigratePrepareTunnel3(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_prepare_tunnel3_args *args,
    remote_domain_migrate_prepare_tunnel3_ret *ret)
{
    int rv = -1;
    unsigned long flags;
    char *dname;
    unsigned long resource;
    char *cookie_out = NULL;
    int cookie_out_len = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);
    virStreamPtr st = NULL;
    daemonClientStreamPtr stream = NULL;
    const bool sparse = false;

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    HYPER_TO_ULONG(flags, args->flags);

    HYPER_TO_ULONG(resource, args->resource);

    dname = args->dname ? *args->dname : NULL;

    if (!(st = virStreamNew(priv->conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, &msg->header, sparse)))
        goto cleanup;

    if (virDomainMigratePrepareTunnel3(priv->conn, st, args->cookie_in.cookie_in_val, args->cookie_in.cookie_in_len, &cookie_out, &cookie_out_len, flags, dname, resource, args->dom_xml) < 0)
        goto cleanup;

    if (daemonAddClientStream(client, stream, false) < 0)
        goto cleanup;

    ret->cookie_out.cookie_out_val = cookie_out;
    ret->cookie_out.cookie_out_len = cookie_out_len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(cookie_out);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virObjectUnref(st);
        }
    }
    return rv;
}



static int remoteDispatchDomainMigratePrepareTunnel3Params(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_prepare_tunnel3_params_args *args,
    remote_domain_migrate_prepare_tunnel3_params_ret *ret);
static int remoteDispatchDomainMigratePrepareTunnel3ParamsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigratePrepareTunnel3Params");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigratePrepareTunnel3Params(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainMigratePrepareTunnel3Params body has to be implemented manually */



static int remoteDispatchDomainMigrateSetCompressionCache(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_set_compression_cache_args *args);
static int remoteDispatchDomainMigrateSetCompressionCacheHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateSetCompressionCache");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateSetCompressionCache(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigrateSetCompressionCache(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_set_compression_cache_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainMigrateSetCompressionCache(dom, args->cacheSize, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainMigrateSetMaxDowntime(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_set_max_downtime_args *args);
static int remoteDispatchDomainMigrateSetMaxDowntimeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateSetMaxDowntime");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateSetMaxDowntime(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigrateSetMaxDowntime(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_set_max_downtime_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainMigrateSetMaxDowntime(dom, args->downtime, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainMigrateSetMaxSpeed(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_set_max_speed_args *args);
static int remoteDispatchDomainMigrateSetMaxSpeedHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateSetMaxSpeed");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateSetMaxSpeed(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigrateSetMaxSpeed(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_set_max_speed_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long bandwidth;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(bandwidth, args->bandwidth);

    if (virDomainMigrateSetMaxSpeed(dom, bandwidth, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainMigrateStartPostCopy(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_start_post_copy_args *args);
static int remoteDispatchDomainMigrateStartPostCopyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainMigrateStartPostCopy");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainMigrateStartPostCopy(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainMigrateStartPostCopy(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_start_post_copy_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainMigrateStartPostCopy(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainOpenChannel(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_open_channel_args *args);
static int remoteDispatchDomainOpenChannelHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainOpenChannel");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainOpenChannel(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainOpenChannel(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_open_channel_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *name;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);
    virStreamPtr st = NULL;
    daemonClientStreamPtr stream = NULL;
    const bool sparse = false;

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    name = args->name ? *args->name : NULL;

    if (!(st = virStreamNew(priv->conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, &msg->header, sparse)))
        goto cleanup;

    if (virDomainOpenChannel(dom, name, st, args->flags) < 0)
        goto cleanup;

    if (daemonAddClientStream(client, stream, true) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virObjectUnref(st);
        }
    }
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainOpenConsole(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_open_console_args *args);
static int remoteDispatchDomainOpenConsoleHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainOpenConsole");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainOpenConsole(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainOpenConsole(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_open_console_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *dev_name;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);
    virStreamPtr st = NULL;
    daemonClientStreamPtr stream = NULL;
    const bool sparse = false;

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    dev_name = args->dev_name ? *args->dev_name : NULL;

    if (!(st = virStreamNew(priv->conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, &msg->header, sparse)))
        goto cleanup;

    if (virDomainOpenConsole(dom, dev_name, st, args->flags) < 0)
        goto cleanup;

    if (daemonAddClientStream(client, stream, true) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virObjectUnref(st);
        }
    }
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainOpenGraphics(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_open_graphics_args *args);
static int remoteDispatchDomainOpenGraphicsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainOpenGraphics");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainOpenGraphics(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainOpenGraphics body has to be implemented manually */



static int remoteDispatchDomainOpenGraphicsFd(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_open_graphics_fd_args *args);
static int remoteDispatchDomainOpenGraphicsFdHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainOpenGraphicsFd");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainOpenGraphicsFd(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainOpenGraphicsFd body has to be implemented manually */



static int remoteDispatchDomainPinEmulator(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_pin_emulator_args *args);
static int remoteDispatchDomainPinEmulatorHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainPinEmulator");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainPinEmulator(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchDomainPinEmulator body has to be implemented manually */



static int remoteDispatchDomainPinIOThread(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_pin_iothread_args *args);
static int remoteDispatchDomainPinIOThreadHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainPinIOThread");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainPinIOThread(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainPinIOThread(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_pin_iothread_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainPinIOThread(dom, args->iothreads_id, (unsigned char *) args->cpumap.cpumap_val, args->cpumap.cpumap_len, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainPinVcpu(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_pin_vcpu_args *args);
static int remoteDispatchDomainPinVcpuHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainPinVcpu");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainPinVcpu(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainPinVcpu(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_pin_vcpu_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainPinVcpu(dom, args->vcpu, (unsigned char *) args->cpumap.cpumap_val, args->cpumap.cpumap_len) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainPinVcpuFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_pin_vcpu_flags_args *args);
static int remoteDispatchDomainPinVcpuFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainPinVcpuFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainPinVcpuFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainPinVcpuFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_pin_vcpu_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainPinVcpuFlags(dom, args->vcpu, (unsigned char *) args->cpumap.cpumap_val, args->cpumap.cpumap_len, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainPMSuspendForDuration(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_pm_suspend_for_duration_args *args);
static int remoteDispatchDomainPMSuspendForDurationHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainPMSuspendForDuration");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainPMSuspendForDuration(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainPMSuspendForDuration(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_pm_suspend_for_duration_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainPMSuspendForDuration(dom, args->target, args->duration, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainPMWakeup(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_pm_wakeup_args *args);
static int remoteDispatchDomainPMWakeupHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainPMWakeup");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainPMWakeup(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainPMWakeup(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_pm_wakeup_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainPMWakeup(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainReboot(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_reboot_args *args);
static int remoteDispatchDomainRebootHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainReboot");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainReboot(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainReboot(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_reboot_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainReboot(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainRename(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_rename_args *args,
    remote_domain_rename_ret *ret);
static int remoteDispatchDomainRenameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainRename");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainRename(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainRename(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_rename_args *args,
    remote_domain_rename_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *new_name;
    int retcode;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    new_name = args->new_name ? *args->new_name : NULL;

    if ((retcode = virDomainRename(dom, new_name, args->flags)) < 0)
        goto cleanup;

    ret->retcode = retcode;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainReset(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_reset_args *args);
static int remoteDispatchDomainResetHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainReset");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainReset(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainReset(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_reset_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainReset(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainRestore(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_restore_args *args);
static int remoteDispatchDomainRestoreHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainRestore");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainRestore(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainRestore(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_restore_args *args)
{
    int rv = -1;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virDomainRestore(priv->conn, args->from) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchDomainRestoreFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_restore_flags_args *args);
static int remoteDispatchDomainRestoreFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainRestoreFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainRestoreFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainRestoreFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_restore_flags_args *args)
{
    int rv = -1;
    char *dxml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    dxml = args->dxml ? *args->dxml : NULL;

    if (virDomainRestoreFlags(priv->conn, args->from, dxml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchDomainResume(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_resume_args *args);
static int remoteDispatchDomainResumeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainResume");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainResume(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainResume(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_resume_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainResume(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainRevertToSnapshot(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_revert_to_snapshot_args *args);
static int remoteDispatchDomainRevertToSnapshotHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainRevertToSnapshot");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainRevertToSnapshot(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainRevertToSnapshot(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_revert_to_snapshot_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if (virDomainRevertToSnapshot(snapshot, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(snapshot);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSave(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_save_args *args);
static int remoteDispatchDomainSaveHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSave");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSave(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSave(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_save_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainSave(dom, args->to) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSaveFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_save_flags_args *args);
static int remoteDispatchDomainSaveFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSaveFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSaveFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSaveFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_save_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *dxml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    dxml = args->dxml ? *args->dxml : NULL;

    if (virDomainSaveFlags(dom, args->to, dxml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSaveImageDefineXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_save_image_define_xml_args *args);
static int remoteDispatchDomainSaveImageDefineXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSaveImageDefineXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSaveImageDefineXML(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSaveImageDefineXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_save_image_define_xml_args *args)
{
    int rv = -1;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virDomainSaveImageDefineXML(priv->conn, args->file, args->dxml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchDomainSaveImageGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_save_image_get_xml_desc_args *args,
    remote_domain_save_image_get_xml_desc_ret *ret);
static int remoteDispatchDomainSaveImageGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSaveImageGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSaveImageGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSaveImageGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_save_image_get_xml_desc_args *args,
    remote_domain_save_image_get_xml_desc_ret *ret)
{
    int rv = -1;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((xml = virDomainSaveImageGetXMLDesc(priv->conn, args->file, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchDomainScreenshot(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_screenshot_args *args,
    remote_domain_screenshot_ret *ret);
static int remoteDispatchDomainScreenshotHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainScreenshot");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainScreenshot(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainScreenshot(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_screenshot_args *args,
    remote_domain_screenshot_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *mime = NULL;
    char **mime_p = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);
    virStreamPtr st = NULL;
    daemonClientStreamPtr stream = NULL;
    const bool sparse = false;

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (!(st = virStreamNew(priv->conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, &msg->header, sparse)))
        goto cleanup;

    if ((mime = virDomainScreenshot(dom, st, args->screen, args->flags)) == NULL)
        goto cleanup;

    if (daemonAddClientStream(client, stream, true) < 0)
        goto cleanup;

    if (VIR_ALLOC(mime_p) < 0)
        goto cleanup;

    if (VIR_STRDUP(*mime_p, mime) < 0)
        goto cleanup;

    ret->mime = mime_p;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(mime_p);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virObjectUnref(st);
        }
    }
    virObjectUnref(dom);
    VIR_FREE(mime);
    return rv;
}



static int remoteDispatchDomainSendKey(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_send_key_args *args);
static int remoteDispatchDomainSendKeyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSendKey");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSendKey(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSendKey(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_send_key_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainSendKey(dom, args->codeset, args->holdtime, args->keycodes.keycodes_val, args->keycodes.keycodes_len, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSendProcessSignal(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_send_process_signal_args *args);
static int remoteDispatchDomainSendProcessSignalHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSendProcessSignal");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSendProcessSignal(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSendProcessSignal(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_send_process_signal_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainSendProcessSignal(dom, args->pid_value, args->signum, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetAutostart(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_autostart_args *args);
static int remoteDispatchDomainSetAutostartHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetAutostart");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetAutostart(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetAutostart(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_autostart_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainSetAutostart(dom, args->autostart) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetBlkioParameters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_blkio_parameters_args *args);
static int remoteDispatchDomainSetBlkioParametersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetBlkioParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetBlkioParameters(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetBlkioParameters(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_blkio_parameters_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((virTypedParameterRemotePtr) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_BLKIO_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSetBlkioParameters(dom, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainSetBlockIoTune(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_block_io_tune_args *args);
static int remoteDispatchDomainSetBlockIoTuneHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetBlockIoTune");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetBlockIoTune(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetBlockIoTune(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_block_io_tune_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((virTypedParameterRemotePtr) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_BLOCK_IO_TUNE_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSetBlockIoTune(dom, args->disk, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainSetBlockThreshold(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_block_threshold_args *args);
static int remoteDispatchDomainSetBlockThresholdHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetBlockThreshold");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetBlockThreshold(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetBlockThreshold(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_block_threshold_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainSetBlockThreshold(dom, args->dev, args->threshold, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetGuestVcpus(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_guest_vcpus_args *args);
static int remoteDispatchDomainSetGuestVcpusHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetGuestVcpus");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetGuestVcpus(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetGuestVcpus(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_guest_vcpus_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainSetGuestVcpus(dom, args->cpumap, args->state, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetInterfaceParameters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_interface_parameters_args *args);
static int remoteDispatchDomainSetInterfaceParametersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetInterfaceParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetInterfaceParameters(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetInterfaceParameters(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_interface_parameters_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((virTypedParameterRemotePtr) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_INTERFACE_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSetInterfaceParameters(dom, args->device, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainSetMaxMemory(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_max_memory_args *args);
static int remoteDispatchDomainSetMaxMemoryHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetMaxMemory");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetMaxMemory(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetMaxMemory(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_max_memory_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long memory;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(memory, args->memory);

    if (virDomainSetMaxMemory(dom, memory) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetMemory(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_memory_args *args);
static int remoteDispatchDomainSetMemoryHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetMemory");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetMemory(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetMemory(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_memory_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long memory;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(memory, args->memory);

    if (virDomainSetMemory(dom, memory) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetMemoryFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_memory_flags_args *args);
static int remoteDispatchDomainSetMemoryFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetMemoryFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetMemoryFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetMemoryFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_memory_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long memory;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(memory, args->memory);

    if (virDomainSetMemoryFlags(dom, memory, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetMemoryParameters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_memory_parameters_args *args);
static int remoteDispatchDomainSetMemoryParametersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetMemoryParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetMemoryParameters(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetMemoryParameters(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_memory_parameters_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((virTypedParameterRemotePtr) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_MEMORY_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSetMemoryParameters(dom, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainSetMemoryStatsPeriod(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_memory_stats_period_args *args);
static int remoteDispatchDomainSetMemoryStatsPeriodHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetMemoryStatsPeriod");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetMemoryStatsPeriod(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetMemoryStatsPeriod(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_memory_stats_period_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainSetMemoryStatsPeriod(dom, args->period, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetMetadata(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_metadata_args *args);
static int remoteDispatchDomainSetMetadataHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetMetadata");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetMetadata(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetMetadata(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_metadata_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *metadata;
    char *key;
    char *uri;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    metadata = args->metadata ? *args->metadata : NULL;
    key = args->key ? *args->key : NULL;
    uri = args->uri ? *args->uri : NULL;

    if (virDomainSetMetadata(dom, args->type, metadata, key, uri, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetNumaParameters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_numa_parameters_args *args);
static int remoteDispatchDomainSetNumaParametersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetNumaParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetNumaParameters(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetNumaParameters(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_numa_parameters_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((virTypedParameterRemotePtr) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_NUMA_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSetNumaParameters(dom, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainSetPerfEvents(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_perf_events_args *args);
static int remoteDispatchDomainSetPerfEventsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetPerfEvents");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetPerfEvents(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetPerfEvents(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_perf_events_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((virTypedParameterRemotePtr) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_PERF_EVENTS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSetPerfEvents(dom, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainSetSchedulerParameters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_scheduler_parameters_args *args);
static int remoteDispatchDomainSetSchedulerParametersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetSchedulerParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetSchedulerParameters(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetSchedulerParameters(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_scheduler_parameters_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((virTypedParameterRemotePtr) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_SCHEDULER_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSetSchedulerParameters(dom, params, nparams) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainSetSchedulerParametersFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_scheduler_parameters_flags_args *args);
static int remoteDispatchDomainSetSchedulerParametersFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetSchedulerParametersFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetSchedulerParametersFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetSchedulerParametersFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_scheduler_parameters_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virTypedParamsDeserialize((virTypedParameterRemotePtr) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_DOMAIN_SCHEDULER_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virDomainSetSchedulerParametersFlags(dom, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchDomainSetTime(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_time_args *args);
static int remoteDispatchDomainSetTimeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetTime");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetTime(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetTime(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_time_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainSetTime(dom, args->seconds, args->nseconds, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetUserPassword(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_user_password_args *args);
static int remoteDispatchDomainSetUserPasswordHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetUserPassword");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetUserPassword(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetUserPassword(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_user_password_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *user;
    char *password;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    user = args->user ? *args->user : NULL;
    password = args->password ? *args->password : NULL;

    if (virDomainSetUserPassword(dom, user, password, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetVcpu(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_vcpu_args *args);
static int remoteDispatchDomainSetVcpuHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetVcpu");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetVcpu(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetVcpu(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_vcpu_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainSetVcpu(dom, args->cpumap, args->state, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetVcpus(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_vcpus_args *args);
static int remoteDispatchDomainSetVcpusHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetVcpus");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetVcpus(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetVcpus(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_vcpus_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainSetVcpus(dom, args->nvcpus) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSetVcpusFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_set_vcpus_flags_args *args);
static int remoteDispatchDomainSetVcpusFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSetVcpusFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSetVcpusFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSetVcpusFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_vcpus_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainSetVcpusFlags(dom, args->nvcpus, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainShutdown(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_shutdown_args *args);
static int remoteDispatchDomainShutdownHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainShutdown");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainShutdown(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainShutdown(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_shutdown_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainShutdown(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainShutdownFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_shutdown_flags_args *args);
static int remoteDispatchDomainShutdownFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainShutdownFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainShutdownFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainShutdownFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_shutdown_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainShutdownFlags(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotCreateXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_create_xml_args *args,
    remote_domain_snapshot_create_xml_ret *ret);
static int remoteDispatchDomainSnapshotCreateXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotCreateXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotCreateXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotCreateXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_create_xml_args *args,
    remote_domain_snapshot_create_xml_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snap = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((snap = virDomainSnapshotCreateXML(dom, args->xml_desc, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain_snapshot(&ret->snap, snap);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virObjectUnref(snap);
    return rv;
}



static int remoteDispatchDomainSnapshotCurrent(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_current_args *args,
    remote_domain_snapshot_current_ret *ret);
static int remoteDispatchDomainSnapshotCurrentHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotCurrent");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotCurrent(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotCurrent(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_current_args *args,
    remote_domain_snapshot_current_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snap = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((snap = virDomainSnapshotCurrent(dom, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain_snapshot(&ret->snap, snap);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virObjectUnref(snap);
    return rv;
}



static int remoteDispatchDomainSnapshotDelete(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_delete_args *args);
static int remoteDispatchDomainSnapshotDeleteHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotDelete");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotDelete(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotDelete(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_delete_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if (virDomainSnapshotDelete(snapshot, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(snapshot);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotGetParent(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_get_parent_args *args,
    remote_domain_snapshot_get_parent_ret *ret);
static int remoteDispatchDomainSnapshotGetParentHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotGetParent");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotGetParent(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotGetParent(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_get_parent_args *args,
    remote_domain_snapshot_get_parent_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    virDomainSnapshotPtr snap = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if ((snap = virDomainSnapshotGetParent(snapshot, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain_snapshot(&ret->snap, snap);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(snapshot);
    virObjectUnref(dom);
    virObjectUnref(snap);
    return rv;
}



static int remoteDispatchDomainSnapshotGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_get_xml_desc_args *args,
    remote_domain_snapshot_get_xml_desc_ret *ret);
static int remoteDispatchDomainSnapshotGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_get_xml_desc_args *args,
    remote_domain_snapshot_get_xml_desc_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if ((xml = virDomainSnapshotGetXMLDesc(snapshot, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(snapshot);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotHasMetadata(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_has_metadata_args *args,
    remote_domain_snapshot_has_metadata_ret *ret);
static int remoteDispatchDomainSnapshotHasMetadataHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotHasMetadata");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotHasMetadata(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotHasMetadata(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_has_metadata_args *args,
    remote_domain_snapshot_has_metadata_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    int metadata;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if ((metadata = virDomainSnapshotHasMetadata(snapshot, args->flags)) < 0)
        goto cleanup;

    ret->metadata = metadata;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(snapshot);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotIsCurrent(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_is_current_args *args,
    remote_domain_snapshot_is_current_ret *ret);
static int remoteDispatchDomainSnapshotIsCurrentHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotIsCurrent");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotIsCurrent(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotIsCurrent(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_is_current_args *args,
    remote_domain_snapshot_is_current_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    int current;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if ((current = virDomainSnapshotIsCurrent(snapshot, args->flags)) < 0)
        goto cleanup;

    ret->current = current;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(snapshot);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotListAllChildren(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_list_all_children_args *args,
    remote_domain_snapshot_list_all_children_ret *ret);
static int remoteDispatchDomainSnapshotListAllChildrenHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotListAllChildren");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotListAllChildren(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotListAllChildren(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_list_all_children_args *args,
    remote_domain_snapshot_list_all_children_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    virDomainSnapshotPtr *result = NULL;
    int nresults = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->snapshot.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snapshot)))
        goto cleanup;

    if ((nresults = 
            virDomainSnapshotListAllChildren(snapshot,
                                             args->need_results ? &result : NULL,
                                             args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_DOMAIN_SNAPSHOT_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many domain_snapshots '%d' for limit '%d'"),
                       nresults, REMOTE_DOMAIN_SNAPSHOT_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        if (VIR_ALLOC_N(ret->snapshots.snapshots_val, nresults) < 0)
            goto cleanup;

        ret->snapshots.snapshots_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_domain_snapshot(ret->snapshots.snapshots_val + i, result[i]);
    } else {
        ret->snapshots.snapshots_len = 0;
        ret->snapshots.snapshots_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(snapshot);
    virObjectUnref(dom);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchDomainSnapshotListChildrenNames(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_list_children_names_args *args,
    remote_domain_snapshot_list_children_names_ret *ret);
static int remoteDispatchDomainSnapshotListChildrenNamesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotListChildrenNames");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotListChildrenNames(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotListChildrenNames(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_list_children_names_args *args,
    remote_domain_snapshot_list_children_names_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_DOMAIN_SNAPSHOT_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_DOMAIN_SNAPSHOT_LIST_MAX"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0)
        goto cleanup;

    if ((len = virDomainSnapshotListChildrenNames(snapshot, ret->names.names_val, args->maxnames, args->flags)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    virObjectUnref(snapshot);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotListNames(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_list_names_args *args,
    remote_domain_snapshot_list_names_ret *ret);
static int remoteDispatchDomainSnapshotListNamesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotListNames");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotListNames(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotListNames(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_list_names_args *args,
    remote_domain_snapshot_list_names_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_DOMAIN_SNAPSHOT_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_DOMAIN_SNAPSHOT_LIST_MAX"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0)
        goto cleanup;

    if ((len = virDomainSnapshotListNames(dom, ret->names.names_val, args->maxnames, args->flags)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotLookupByName(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_lookup_by_name_args *args,
    remote_domain_snapshot_lookup_by_name_ret *ret);
static int remoteDispatchDomainSnapshotLookupByNameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotLookupByName");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotLookupByName(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotLookupByName(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_lookup_by_name_args *args,
    remote_domain_snapshot_lookup_by_name_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snap = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((snap = virDomainSnapshotLookupByName(dom, args->name, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain_snapshot(&ret->snap, snap);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    virObjectUnref(snap);
    return rv;
}



static int remoteDispatchDomainSnapshotNum(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_num_args *args,
    remote_domain_snapshot_num_ret *ret);
static int remoteDispatchDomainSnapshotNumHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotNum");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotNum(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotNum(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_num_args *args,
    remote_domain_snapshot_num_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((num = virDomainSnapshotNum(dom, args->flags)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotNumChildren(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_num_children_args *args,
    remote_domain_snapshot_num_children_ret *ret);
static int remoteDispatchDomainSnapshotNumChildrenHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSnapshotNumChildren");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSnapshotNumChildren(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSnapshotNumChildren(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_num_children_args *args,
    remote_domain_snapshot_num_children_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if ((num = virDomainSnapshotNumChildren(snapshot, args->flags)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(snapshot);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainSuspend(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_suspend_args *args);
static int remoteDispatchDomainSuspendHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainSuspend");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainSuspend(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainSuspend(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_suspend_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainSuspend(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainUndefine(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_undefine_args *args);
static int remoteDispatchDomainUndefineHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainUndefine");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainUndefine(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainUndefine(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_undefine_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainUndefine(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainUndefineFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_undefine_flags_args *args);
static int remoteDispatchDomainUndefineFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainUndefineFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainUndefineFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainUndefineFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_undefine_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainUndefineFlags(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchDomainUpdateDeviceFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_domain_update_device_flags_args *args);
static int remoteDispatchDomainUpdateDeviceFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchDomainUpdateDeviceFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchDomainUpdateDeviceFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchDomainUpdateDeviceFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_update_device_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainUpdateDeviceFlags(dom, args->xml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dom);
    return rv;
}



static int remoteDispatchInterfaceChangeBegin(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_interface_change_begin_args *args);
static int remoteDispatchInterfaceChangeBeginHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceChangeBegin");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceChangeBegin(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceChangeBegin(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_change_begin_args *args)
{
    int rv = -1;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virInterfaceChangeBegin(priv->conn, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchInterfaceChangeCommit(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_interface_change_commit_args *args);
static int remoteDispatchInterfaceChangeCommitHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceChangeCommit");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceChangeCommit(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceChangeCommit(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_change_commit_args *args)
{
    int rv = -1;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virInterfaceChangeCommit(priv->conn, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchInterfaceChangeRollback(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_interface_change_rollback_args *args);
static int remoteDispatchInterfaceChangeRollbackHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceChangeRollback");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceChangeRollback(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceChangeRollback(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_change_rollback_args *args)
{
    int rv = -1;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virInterfaceChangeRollback(priv->conn, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchInterfaceCreate(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_interface_create_args *args);
static int remoteDispatchInterfaceCreateHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceCreate");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceCreate(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceCreate(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_create_args *args)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(iface = get_nonnull_interface(priv->conn, args->iface)))
        goto cleanup;

    if (virInterfaceCreate(iface, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(iface);
    return rv;
}



static int remoteDispatchInterfaceDefineXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_interface_define_xml_args *args,
    remote_interface_define_xml_ret *ret);
static int remoteDispatchInterfaceDefineXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceDefineXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceDefineXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceDefineXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_define_xml_args *args,
    remote_interface_define_xml_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((iface = virInterfaceDefineXML(priv->conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_interface(&ret->iface, iface);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(iface);
    return rv;
}



static int remoteDispatchInterfaceDestroy(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_interface_destroy_args *args);
static int remoteDispatchInterfaceDestroyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceDestroy");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceDestroy(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceDestroy(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_destroy_args *args)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(iface = get_nonnull_interface(priv->conn, args->iface)))
        goto cleanup;

    if (virInterfaceDestroy(iface, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(iface);
    return rv;
}



static int remoteDispatchInterfaceGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_interface_get_xml_desc_args *args,
    remote_interface_get_xml_desc_ret *ret);
static int remoteDispatchInterfaceGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_get_xml_desc_args *args,
    remote_interface_get_xml_desc_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(iface = get_nonnull_interface(priv->conn, args->iface)))
        goto cleanup;

    if ((xml = virInterfaceGetXMLDesc(iface, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(iface);
    return rv;
}



static int remoteDispatchInterfaceIsActive(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_interface_is_active_args *args,
    remote_interface_is_active_ret *ret);
static int remoteDispatchInterfaceIsActiveHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceIsActive");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceIsActive(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceIsActive(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_is_active_args *args,
    remote_interface_is_active_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    int active;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(iface = get_nonnull_interface(priv->conn, args->iface)))
        goto cleanup;

    if ((active = virInterfaceIsActive(iface)) < 0)
        goto cleanup;

    ret->active = active;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(iface);
    return rv;
}



static int remoteDispatchInterfaceLookupByMACString(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_interface_lookup_by_mac_string_args *args,
    remote_interface_lookup_by_mac_string_ret *ret);
static int remoteDispatchInterfaceLookupByMACStringHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceLookupByMACString");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceLookupByMACString(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceLookupByMACString(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_lookup_by_mac_string_args *args,
    remote_interface_lookup_by_mac_string_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((iface = virInterfaceLookupByMACString(priv->conn, args->mac)) == NULL)
        goto cleanup;

    make_nonnull_interface(&ret->iface, iface);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(iface);
    return rv;
}



static int remoteDispatchInterfaceLookupByName(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_interface_lookup_by_name_args *args,
    remote_interface_lookup_by_name_ret *ret);
static int remoteDispatchInterfaceLookupByNameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceLookupByName");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceLookupByName(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceLookupByName(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_lookup_by_name_args *args,
    remote_interface_lookup_by_name_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((iface = virInterfaceLookupByName(priv->conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_interface(&ret->iface, iface);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(iface);
    return rv;
}



static int remoteDispatchInterfaceUndefine(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_interface_undefine_args *args);
static int remoteDispatchInterfaceUndefineHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchInterfaceUndefine");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchInterfaceUndefine(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchInterfaceUndefine(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_undefine_args *args)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(iface = get_nonnull_interface(priv->conn, args->iface)))
        goto cleanup;

    if (virInterfaceUndefine(iface) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(iface);
    return rv;
}



static int remoteDispatchNetworkCreate(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_network_create_args *args);
static int remoteDispatchNetworkCreateHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkCreate");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkCreate(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkCreate(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_create_args *args)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(priv->conn, args->net)))
        goto cleanup;

    if (virNetworkCreate(net) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkCreateXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_network_create_xml_args *args,
    remote_network_create_xml_ret *ret);
static int remoteDispatchNetworkCreateXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkCreateXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkCreateXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkCreateXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_create_xml_args *args,
    remote_network_create_xml_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((net = virNetworkCreateXML(priv->conn, args->xml)) == NULL)
        goto cleanup;

    make_nonnull_network(&ret->net, net);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkDefineXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_network_define_xml_args *args,
    remote_network_define_xml_ret *ret);
static int remoteDispatchNetworkDefineXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkDefineXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkDefineXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkDefineXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_define_xml_args *args,
    remote_network_define_xml_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((net = virNetworkDefineXML(priv->conn, args->xml)) == NULL)
        goto cleanup;

    make_nonnull_network(&ret->net, net);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkDestroy(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_network_destroy_args *args);
static int remoteDispatchNetworkDestroyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkDestroy");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkDestroy(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkDestroy(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_destroy_args *args)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(priv->conn, args->net)))
        goto cleanup;

    if (virNetworkDestroy(net) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkGetAutostart(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_network_get_autostart_args *args,
    remote_network_get_autostart_ret *ret);
static int remoteDispatchNetworkGetAutostartHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkGetAutostart");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkGetAutostart(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkGetAutostart(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_get_autostart_args *args,
    remote_network_get_autostart_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    int autostart;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(priv->conn, args->net)))
        goto cleanup;

    if (virNetworkGetAutostart(net, &autostart) < 0)
        goto cleanup;

    ret->autostart = autostart;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkGetBridgeName(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_network_get_bridge_name_args *args,
    remote_network_get_bridge_name_ret *ret);
static int remoteDispatchNetworkGetBridgeNameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkGetBridgeName");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkGetBridgeName(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkGetBridgeName(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_get_bridge_name_args *args,
    remote_network_get_bridge_name_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    char *name;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(priv->conn, args->net)))
        goto cleanup;

    if ((name = virNetworkGetBridgeName(net)) == NULL)
        goto cleanup;

    ret->name = name;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkGetDHCPLeases(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_network_get_dhcp_leases_args *args,
    remote_network_get_dhcp_leases_ret *ret);
static int remoteDispatchNetworkGetDHCPLeasesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkGetDHCPLeases");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkGetDHCPLeases(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNetworkGetDHCPLeases body has to be implemented manually */



static int remoteDispatchNetworkGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_network_get_xml_desc_args *args,
    remote_network_get_xml_desc_ret *ret);
static int remoteDispatchNetworkGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_get_xml_desc_args *args,
    remote_network_get_xml_desc_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(priv->conn, args->net)))
        goto cleanup;

    if ((xml = virNetworkGetXMLDesc(net, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkIsActive(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_network_is_active_args *args,
    remote_network_is_active_ret *ret);
static int remoteDispatchNetworkIsActiveHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkIsActive");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkIsActive(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkIsActive(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_is_active_args *args,
    remote_network_is_active_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    int active;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(priv->conn, args->net)))
        goto cleanup;

    if ((active = virNetworkIsActive(net)) < 0)
        goto cleanup;

    ret->active = active;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkIsPersistent(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_network_is_persistent_args *args,
    remote_network_is_persistent_ret *ret);
static int remoteDispatchNetworkIsPersistentHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkIsPersistent");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkIsPersistent(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkIsPersistent(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_is_persistent_args *args,
    remote_network_is_persistent_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    int persistent;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(priv->conn, args->net)))
        goto cleanup;

    if ((persistent = virNetworkIsPersistent(net)) < 0)
        goto cleanup;

    ret->persistent = persistent;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkLookupByName(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_network_lookup_by_name_args *args,
    remote_network_lookup_by_name_ret *ret);
static int remoteDispatchNetworkLookupByNameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkLookupByName");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkLookupByName(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkLookupByName(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_lookup_by_name_args *args,
    remote_network_lookup_by_name_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((net = virNetworkLookupByName(priv->conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_network(&ret->net, net);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkLookupByUUID(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_network_lookup_by_uuid_args *args,
    remote_network_lookup_by_uuid_ret *ret);
static int remoteDispatchNetworkLookupByUUIDHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkLookupByUUID");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkLookupByUUID(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkLookupByUUID(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_lookup_by_uuid_args *args,
    remote_network_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((net = virNetworkLookupByUUID(priv->conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_network(&ret->net, net);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkSetAutostart(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_network_set_autostart_args *args);
static int remoteDispatchNetworkSetAutostartHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkSetAutostart");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkSetAutostart(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkSetAutostart(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_set_autostart_args *args)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(priv->conn, args->net)))
        goto cleanup;

    if (virNetworkSetAutostart(net, args->autostart) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkUndefine(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_network_undefine_args *args);
static int remoteDispatchNetworkUndefineHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkUndefine");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkUndefine(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkUndefine(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_undefine_args *args)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(priv->conn, args->net)))
        goto cleanup;

    if (virNetworkUndefine(net) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNetworkUpdate(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_network_update_args *args);
static int remoteDispatchNetworkUpdateHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNetworkUpdate");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNetworkUpdate(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNetworkUpdate(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_update_args *args)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(priv->conn, args->net)))
        goto cleanup;

    if (virNetworkUpdate(net, args->command, args->section, args->parentIndex, args->xml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(net);
    return rv;
}



static int remoteDispatchNodeAllocPages(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_alloc_pages_args *args,
    remote_node_alloc_pages_ret *ret);
static int remoteDispatchNodeAllocPagesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeAllocPages");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeAllocPages(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNodeAllocPages body has to be implemented manually */



static int remoteDispatchNodeDeviceCreateXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_device_create_xml_args *args,
    remote_node_device_create_xml_ret *ret);
static int remoteDispatchNodeDeviceCreateXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceCreateXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceCreateXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceCreateXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_create_xml_args *args,
    remote_node_device_create_xml_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dev = virNodeDeviceCreateXML(priv->conn, args->xml_desc, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_node_device(&ret->dev, dev);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceDestroy(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_device_destroy_args *args);
static int remoteDispatchNodeDeviceDestroyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceDestroy");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceDestroy(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceDestroy(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_destroy_args *args)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(priv->conn, args->name)))
        goto cleanup;

    if (virNodeDeviceDestroy(dev) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceDetachFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_device_detach_flags_args *args);
static int remoteDispatchNodeDeviceDetachFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceDetachFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceDetachFlags(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceDetachFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_detach_flags_args *args)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    char *driverName;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(priv->conn, args->name)))
        goto cleanup;

    driverName = args->driverName ? *args->driverName : NULL;

    if (virNodeDeviceDetachFlags(dev, driverName, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceDettach(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_device_dettach_args *args);
static int remoteDispatchNodeDeviceDettachHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceDettach");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceDettach(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceDettach(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_dettach_args *args)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(priv->conn, args->name)))
        goto cleanup;

    if (virNodeDeviceDettach(dev) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceGetParent(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_device_get_parent_args *args,
    remote_node_device_get_parent_ret *ret);
static int remoteDispatchNodeDeviceGetParentHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceGetParent");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceGetParent(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNodeDeviceGetParent body has to be implemented manually */



static int remoteDispatchNodeDeviceGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_device_get_xml_desc_args *args,
    remote_node_device_get_xml_desc_ret *ret);
static int remoteDispatchNodeDeviceGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_get_xml_desc_args *args,
    remote_node_device_get_xml_desc_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(priv->conn, args->name)))
        goto cleanup;

    if ((xml = virNodeDeviceGetXMLDesc(dev, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceListCaps(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_device_list_caps_args *args,
    remote_node_device_list_caps_ret *ret);
static int remoteDispatchNodeDeviceListCapsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceListCaps");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceListCaps(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceListCaps(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_list_caps_args *args,
    remote_node_device_list_caps_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_NODE_DEVICE_CAPS_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_NODE_DEVICE_CAPS_LIST_MAX"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(priv->conn, args->name)))
        goto cleanup;

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0)
        goto cleanup;

    if ((len = virNodeDeviceListCaps(dev, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceLookupByName(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_device_lookup_by_name_args *args,
    remote_node_device_lookup_by_name_ret *ret);
static int remoteDispatchNodeDeviceLookupByNameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceLookupByName");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceLookupByName(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceLookupByName(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_lookup_by_name_args *args,
    remote_node_device_lookup_by_name_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dev = virNodeDeviceLookupByName(priv->conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_node_device(&ret->dev, dev);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceLookupSCSIHostByWWN(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_device_lookup_scsi_host_by_wwn_args *args,
    remote_node_device_lookup_scsi_host_by_wwn_ret *ret);
static int remoteDispatchNodeDeviceLookupSCSIHostByWWNHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceLookupSCSIHostByWWN");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceLookupSCSIHostByWWN(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceLookupSCSIHostByWWN(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_lookup_scsi_host_by_wwn_args *args,
    remote_node_device_lookup_scsi_host_by_wwn_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dev = virNodeDeviceLookupSCSIHostByWWN(priv->conn, args->wwnn, args->wwpn, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_node_device(&ret->dev, dev);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceNumOfCaps(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_device_num_of_caps_args *args,
    remote_node_device_num_of_caps_ret *ret);
static int remoteDispatchNodeDeviceNumOfCapsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceNumOfCaps");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceNumOfCaps(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceNumOfCaps(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_num_of_caps_args *args,
    remote_node_device_num_of_caps_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(priv->conn, args->name)))
        goto cleanup;

    if ((num = virNodeDeviceNumOfCaps(dev)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceReAttach(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_device_re_attach_args *args);
static int remoteDispatchNodeDeviceReAttachHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceReAttach");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceReAttach(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceReAttach(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_re_attach_args *args)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(priv->conn, args->name)))
        goto cleanup;

    if (virNodeDeviceReAttach(dev) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeDeviceReset(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_device_reset_args *args);
static int remoteDispatchNodeDeviceResetHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeDeviceReset");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeDeviceReset(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeDeviceReset(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_reset_args *args)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(priv->conn, args->name)))
        goto cleanup;

    if (virNodeDeviceReset(dev) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(dev);
    return rv;
}



static int remoteDispatchNodeGetCellsFreeMemory(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_get_cells_free_memory_args *args,
    remote_node_get_cells_free_memory_ret *ret);
static int remoteDispatchNodeGetCellsFreeMemoryHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeGetCellsFreeMemory");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeGetCellsFreeMemory(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeGetCellsFreeMemory(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_get_cells_free_memory_args *args,
    remote_node_get_cells_free_memory_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxcells > REMOTE_NODE_MAX_CELLS) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxcells > REMOTE_NODE_MAX_CELLS"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->cells.cells_val, args->maxcells) < 0)
        goto cleanup;

    if ((len = virNodeGetCellsFreeMemory(priv->conn, (unsigned long long *)ret->cells.cells_val, args->startCell, args->maxcells)) <= 0)
        goto cleanup;

    ret->cells.cells_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->cells.cells_val);
    }
    return rv;
}



static int remoteDispatchNodeGetCPUMap(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_get_cpu_map_args *args,
    remote_node_get_cpu_map_ret *ret);
static int remoteDispatchNodeGetCPUMapHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeGetCPUMap");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeGetCPUMap(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNodeGetCPUMap body has to be implemented manually */



static int remoteDispatchNodeGetCPUStats(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_get_cpu_stats_args *args,
    remote_node_get_cpu_stats_ret *ret);
static int remoteDispatchNodeGetCPUStatsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeGetCPUStats");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeGetCPUStats(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNodeGetCPUStats body has to be implemented manually */



static int remoteDispatchNodeGetFreeMemory(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_get_free_memory_ret *ret);
static int remoteDispatchNodeGetFreeMemoryHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeGetFreeMemory");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeGetFreeMemory(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeGetFreeMemory(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_get_free_memory_ret *ret)
{
    int rv = -1;
    unsigned long long freeMem;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((freeMem = virNodeGetFreeMemory(priv->conn)) == 0)
        goto cleanup;

    ret->freeMem = freeMem;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNodeGetFreePages(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_get_free_pages_args *args,
    remote_node_get_free_pages_ret *ret);
static int remoteDispatchNodeGetFreePagesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeGetFreePages");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeGetFreePages(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNodeGetFreePages body has to be implemented manually */



static int remoteDispatchNodeGetInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_get_info_ret *ret);
static int remoteDispatchNodeGetInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeGetInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeGetInfo(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeGetInfo(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_get_info_ret *ret)
{
    int rv = -1;
    virNodeInfo tmp;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virNodeGetInfo(priv->conn, &tmp) < 0)
        goto cleanup;

    memcpy(ret->model, tmp.model, sizeof(ret->model));
    ret->memory = tmp.memory;
    ret->cpus = tmp.cpus;
    ret->mhz = tmp.mhz;
    ret->nodes = tmp.nodes;
    ret->sockets = tmp.sockets;
    ret->cores = tmp.cores;
    ret->threads = tmp.threads;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNodeGetMemoryParameters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_get_memory_parameters_args *args,
    remote_node_get_memory_parameters_ret *ret);
static int remoteDispatchNodeGetMemoryParametersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeGetMemoryParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeGetMemoryParameters(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNodeGetMemoryParameters body has to be implemented manually */



static int remoteDispatchNodeGetMemoryStats(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_get_memory_stats_args *args,
    remote_node_get_memory_stats_ret *ret);
static int remoteDispatchNodeGetMemoryStatsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeGetMemoryStats");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeGetMemoryStats(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNodeGetMemoryStats body has to be implemented manually */



static int remoteDispatchNodeGetSecurityModel(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_get_security_model_ret *ret);
static int remoteDispatchNodeGetSecurityModelHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeGetSecurityModel");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeGetSecurityModel(server, client, msg, rerr, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchNodeGetSecurityModel body has to be implemented manually */



static int remoteDispatchNodeListDevices(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_list_devices_args *args,
    remote_node_list_devices_ret *ret);
static int remoteDispatchNodeListDevicesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeListDevices");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeListDevices(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeListDevices(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_list_devices_args *args,
    remote_node_list_devices_ret *ret)
{
    int rv = -1;
    char *cap;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_NODE_DEVICE_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_NODE_DEVICE_LIST_MAX"));
        goto cleanup;
    }

    cap = args->cap ? *args->cap : NULL;

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0)
        goto cleanup;

    if ((len = virNodeListDevices(priv->conn, cap, ret->names.names_val, args->maxnames, args->flags)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchNodeNumOfDevices(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_num_of_devices_args *args,
    remote_node_num_of_devices_ret *ret);
static int remoteDispatchNodeNumOfDevicesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeNumOfDevices");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeNumOfDevices(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeNumOfDevices(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_num_of_devices_args *args,
    remote_node_num_of_devices_ret *ret)
{
    int rv = -1;
    char *cap;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    cap = args->cap ? *args->cap : NULL;

    if ((num = virNodeNumOfDevices(priv->conn, cap, args->flags)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNodeSetMemoryParameters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_set_memory_parameters_args *args);
static int remoteDispatchNodeSetMemoryParametersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeSetMemoryParameters");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeSetMemoryParameters(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeSetMemoryParameters(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_set_memory_parameters_args *args)
{
    int rv = -1;
    virTypedParameterPtr params = NULL;
    int nparams = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virTypedParamsDeserialize((virTypedParameterRemotePtr) args->params.params_val,
                                  args->params.params_len,
                                  REMOTE_NODE_MEMORY_PARAMETERS_MAX,
                                  &params,
                                  &nparams) < 0)
        goto cleanup;

    if (virNodeSetMemoryParameters(priv->conn, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virTypedParamsFree(params, nparams);
    return rv;
}



static int remoteDispatchNodeSuspendForDuration(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_node_suspend_for_duration_args *args);
static int remoteDispatchNodeSuspendForDurationHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNodeSuspendForDuration");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNodeSuspendForDuration(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNodeSuspendForDuration(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_suspend_for_duration_args *args)
{
    int rv = -1;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virNodeSuspendForDuration(priv->conn, args->target, args->duration, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNWFilterDefineXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_define_xml_args *args,
    remote_nwfilter_define_xml_ret *ret);
static int remoteDispatchNWFilterDefineXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNWFilterDefineXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNWFilterDefineXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNWFilterDefineXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_define_xml_args *args,
    remote_nwfilter_define_xml_ret *ret)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((nwfilter = virNWFilterDefineXML(priv->conn, args->xml)) == NULL)
        goto cleanup;

    make_nonnull_nwfilter(&ret->nwfilter, nwfilter);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(nwfilter);
    return rv;
}



static int remoteDispatchNWFilterGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_get_xml_desc_args *args,
    remote_nwfilter_get_xml_desc_ret *ret);
static int remoteDispatchNWFilterGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNWFilterGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNWFilterGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNWFilterGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_get_xml_desc_args *args,
    remote_nwfilter_get_xml_desc_ret *ret)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(nwfilter = get_nonnull_nwfilter(priv->conn, args->nwfilter)))
        goto cleanup;

    if ((xml = virNWFilterGetXMLDesc(nwfilter, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(nwfilter);
    return rv;
}



static int remoteDispatchNWFilterLookupByName(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_lookup_by_name_args *args,
    remote_nwfilter_lookup_by_name_ret *ret);
static int remoteDispatchNWFilterLookupByNameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNWFilterLookupByName");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNWFilterLookupByName(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNWFilterLookupByName(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_lookup_by_name_args *args,
    remote_nwfilter_lookup_by_name_ret *ret)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((nwfilter = virNWFilterLookupByName(priv->conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_nwfilter(&ret->nwfilter, nwfilter);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(nwfilter);
    return rv;
}



static int remoteDispatchNWFilterLookupByUUID(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_lookup_by_uuid_args *args,
    remote_nwfilter_lookup_by_uuid_ret *ret);
static int remoteDispatchNWFilterLookupByUUIDHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchNWFilterLookupByUUID");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNWFilterLookupByUUID(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNWFilterLookupByUUID(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_lookup_by_uuid_args *args,
    remote_nwfilter_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((nwfilter = virNWFilterLookupByUUID(priv->conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_nwfilter(&ret->nwfilter, nwfilter);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(nwfilter);
    return rv;
}



static int remoteDispatchNWFilterUndefine(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_undefine_args *args);
static int remoteDispatchNWFilterUndefineHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchNWFilterUndefine");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchNWFilterUndefine(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchNWFilterUndefine(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_undefine_args *args)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(nwfilter = get_nonnull_nwfilter(priv->conn, args->nwfilter)))
        goto cleanup;

    if (virNWFilterUndefine(nwfilter) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(nwfilter);
    return rv;
}



static int remoteDispatchSecretDefineXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_secret_define_xml_args *args,
    remote_secret_define_xml_ret *ret);
static int remoteDispatchSecretDefineXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchSecretDefineXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchSecretDefineXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchSecretDefineXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_secret_define_xml_args *args,
    remote_secret_define_xml_ret *ret)
{
    int rv = -1;
    virSecretPtr secret = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((secret = virSecretDefineXML(priv->conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_secret(&ret->secret, secret);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(secret);
    return rv;
}



static int remoteDispatchSecretGetValue(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_secret_get_value_args *args,
    remote_secret_get_value_ret *ret);
static int remoteDispatchSecretGetValueHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchSecretGetValue");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchSecretGetValue(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchSecretGetValue body has to be implemented manually */



static int remoteDispatchSecretGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_secret_get_xml_desc_args *args,
    remote_secret_get_xml_desc_ret *ret);
static int remoteDispatchSecretGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchSecretGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchSecretGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchSecretGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_secret_get_xml_desc_args *args,
    remote_secret_get_xml_desc_ret *ret)
{
    int rv = -1;
    virSecretPtr secret = NULL;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(secret = get_nonnull_secret(priv->conn, args->secret)))
        goto cleanup;

    if ((xml = virSecretGetXMLDesc(secret, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(secret);
    return rv;
}



static int remoteDispatchSecretLookupByUsage(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_secret_lookup_by_usage_args *args,
    remote_secret_lookup_by_usage_ret *ret);
static int remoteDispatchSecretLookupByUsageHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchSecretLookupByUsage");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchSecretLookupByUsage(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchSecretLookupByUsage(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_secret_lookup_by_usage_args *args,
    remote_secret_lookup_by_usage_ret *ret)
{
    int rv = -1;
    virSecretPtr secret = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((secret = virSecretLookupByUsage(priv->conn, args->usageType, args->usageID)) == NULL)
        goto cleanup;

    make_nonnull_secret(&ret->secret, secret);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(secret);
    return rv;
}



static int remoteDispatchSecretLookupByUUID(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_secret_lookup_by_uuid_args *args,
    remote_secret_lookup_by_uuid_ret *ret);
static int remoteDispatchSecretLookupByUUIDHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchSecretLookupByUUID");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchSecretLookupByUUID(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchSecretLookupByUUID(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_secret_lookup_by_uuid_args *args,
    remote_secret_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virSecretPtr secret = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((secret = virSecretLookupByUUID(priv->conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_secret(&ret->secret, secret);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(secret);
    return rv;
}



static int remoteDispatchSecretSetValue(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_secret_set_value_args *args);
static int remoteDispatchSecretSetValueHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchSecretSetValue");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchSecretSetValue(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchSecretSetValue(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_secret_set_value_args *args)
{
    int rv = -1;
    virSecretPtr secret = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(secret = get_nonnull_secret(priv->conn, args->secret)))
        goto cleanup;

    if (virSecretSetValue(secret, (const unsigned char *) args->value.value_val, args->value.value_len, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(secret);
    return rv;
}



static int remoteDispatchSecretUndefine(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_secret_undefine_args *args);
static int remoteDispatchSecretUndefineHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchSecretUndefine");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchSecretUndefine(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchSecretUndefine(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_secret_undefine_args *args)
{
    int rv = -1;
    virSecretPtr secret = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(secret = get_nonnull_secret(priv->conn, args->secret)))
        goto cleanup;

    if (virSecretUndefine(secret) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(secret);
    return rv;
}



static int remoteDispatchStoragePoolBuild(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_build_args *args);
static int remoteDispatchStoragePoolBuildHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolBuild");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolBuild(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolBuild(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_build_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (virStoragePoolBuild(pool, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolCreate(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_create_args *args);
static int remoteDispatchStoragePoolCreateHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolCreate");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolCreate(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolCreate(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_create_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (virStoragePoolCreate(pool, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolCreateXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_create_xml_args *args,
    remote_storage_pool_create_xml_ret *ret);
static int remoteDispatchStoragePoolCreateXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolCreateXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolCreateXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolCreateXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_create_xml_args *args,
    remote_storage_pool_create_xml_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((pool = virStoragePoolCreateXML(priv->conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolDefineXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_define_xml_args *args,
    remote_storage_pool_define_xml_ret *ret);
static int remoteDispatchStoragePoolDefineXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolDefineXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolDefineXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolDefineXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_define_xml_args *args,
    remote_storage_pool_define_xml_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((pool = virStoragePoolDefineXML(priv->conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolDelete(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_delete_args *args);
static int remoteDispatchStoragePoolDeleteHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolDelete");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolDelete(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolDelete(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_delete_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (virStoragePoolDelete(pool, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolDestroy(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_destroy_args *args);
static int remoteDispatchStoragePoolDestroyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolDestroy");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolDestroy(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolDestroy(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_destroy_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (virStoragePoolDestroy(pool) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolGetAutostart(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_get_autostart_args *args,
    remote_storage_pool_get_autostart_ret *ret);
static int remoteDispatchStoragePoolGetAutostartHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolGetAutostart");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolGetAutostart(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolGetAutostart(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_get_autostart_args *args,
    remote_storage_pool_get_autostart_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int autostart;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (virStoragePoolGetAutostart(pool, &autostart) < 0)
        goto cleanup;

    ret->autostart = autostart;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolGetInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_get_info_args *args,
    remote_storage_pool_get_info_ret *ret);
static int remoteDispatchStoragePoolGetInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolGetInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolGetInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolGetInfo(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_get_info_args *args,
    remote_storage_pool_get_info_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    virStoragePoolInfo tmp;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (virStoragePoolGetInfo(pool, &tmp) < 0)
        goto cleanup;

    ret->state = tmp.state;
    ret->capacity = tmp.capacity;
    ret->allocation = tmp.allocation;
    ret->available = tmp.available;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_get_xml_desc_args *args,
    remote_storage_pool_get_xml_desc_ret *ret);
static int remoteDispatchStoragePoolGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_get_xml_desc_args *args,
    remote_storage_pool_get_xml_desc_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if ((xml = virStoragePoolGetXMLDesc(pool, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolIsActive(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_is_active_args *args,
    remote_storage_pool_is_active_ret *ret);
static int remoteDispatchStoragePoolIsActiveHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolIsActive");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolIsActive(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolIsActive(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_is_active_args *args,
    remote_storage_pool_is_active_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int active;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if ((active = virStoragePoolIsActive(pool)) < 0)
        goto cleanup;

    ret->active = active;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolIsPersistent(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_is_persistent_args *args,
    remote_storage_pool_is_persistent_ret *ret);
static int remoteDispatchStoragePoolIsPersistentHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolIsPersistent");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolIsPersistent(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolIsPersistent(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_is_persistent_args *args,
    remote_storage_pool_is_persistent_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int persistent;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if ((persistent = virStoragePoolIsPersistent(pool)) < 0)
        goto cleanup;

    ret->persistent = persistent;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolListAllVolumes(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_list_all_volumes_args *args,
    remote_storage_pool_list_all_volumes_ret *ret);
static int remoteDispatchStoragePoolListAllVolumesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolListAllVolumes");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolListAllVolumes(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolListAllVolumes(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_list_all_volumes_args *args,
    remote_storage_pool_list_all_volumes_ret *ret)
{
    int rv = -1;
    ssize_t i;
    virStoragePoolPtr pool = NULL;
    virStorageVolPtr *result = NULL;
    int nresults = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if ((nresults = 
            virStoragePoolListAllVolumes(pool,
                                         args->need_results ? &result : NULL,
                                         args->flags)) < 0)
        goto cleanup;

    if (nresults > REMOTE_STORAGE_VOL_LIST_MAX) {
        virReportError(VIR_ERR_INTERNAL_ERROR,
                       _("Too many storage_vols '%d' for limit '%d'"),
                       nresults, REMOTE_STORAGE_VOL_LIST_MAX);
        goto cleanup;
    }

    if (result && nresults) {
        if (VIR_ALLOC_N(ret->vols.vols_val, nresults) < 0)
            goto cleanup;

        ret->vols.vols_len = nresults;
        for (i = 0; i < nresults; i++)
            make_nonnull_storage_vol(ret->vols.vols_val + i, result[i]);
    } else {
        ret->vols.vols_len = 0;
        ret->vols.vols_val = NULL;
    }

    ret->ret = nresults;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    if (result) {
        for (i = 0; i < nresults; i++)
            virObjectUnref(result[i]);
    }
    VIR_FREE(result);
    return rv;
}



static int remoteDispatchStoragePoolListVolumes(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_list_volumes_args *args,
    remote_storage_pool_list_volumes_ret *ret);
static int remoteDispatchStoragePoolListVolumesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolListVolumes");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolListVolumes(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolListVolumes(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_list_volumes_args *args,
    remote_storage_pool_list_volumes_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_STORAGE_VOL_LIST_MAX) {
        virReportError(VIR_ERR_RPC,
                       "%s", _("maxnames > REMOTE_STORAGE_VOL_LIST_MAX"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0)
        goto cleanup;

    if ((len = virStoragePoolListVolumes(pool, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolLookupByName(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_lookup_by_name_args *args,
    remote_storage_pool_lookup_by_name_ret *ret);
static int remoteDispatchStoragePoolLookupByNameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolLookupByName");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolLookupByName(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolLookupByName(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_lookup_by_name_args *args,
    remote_storage_pool_lookup_by_name_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((pool = virStoragePoolLookupByName(priv->conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolLookupByUUID(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_lookup_by_uuid_args *args,
    remote_storage_pool_lookup_by_uuid_ret *ret);
static int remoteDispatchStoragePoolLookupByUUIDHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolLookupByUUID");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolLookupByUUID(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolLookupByUUID(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_lookup_by_uuid_args *args,
    remote_storage_pool_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((pool = virStoragePoolLookupByUUID(priv->conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolLookupByVolume(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_lookup_by_volume_args *args,
    remote_storage_pool_lookup_by_volume_ret *ret);
static int remoteDispatchStoragePoolLookupByVolumeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolLookupByVolume");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolLookupByVolume(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolLookupByVolume(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_lookup_by_volume_args *args,
    remote_storage_pool_lookup_by_volume_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(priv->conn, args->vol)))
        goto cleanup;

    if ((pool = virStoragePoolLookupByVolume(vol)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolNumOfVolumes(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_num_of_volumes_args *args,
    remote_storage_pool_num_of_volumes_ret *ret);
static int remoteDispatchStoragePoolNumOfVolumesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolNumOfVolumes");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolNumOfVolumes(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolNumOfVolumes(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_num_of_volumes_args *args,
    remote_storage_pool_num_of_volumes_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if ((num = virStoragePoolNumOfVolumes(pool)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolRefresh(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_refresh_args *args);
static int remoteDispatchStoragePoolRefreshHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolRefresh");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolRefresh(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolRefresh(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_refresh_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (virStoragePoolRefresh(pool, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolSetAutostart(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_set_autostart_args *args);
static int remoteDispatchStoragePoolSetAutostartHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolSetAutostart");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolSetAutostart(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolSetAutostart(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_set_autostart_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (virStoragePoolSetAutostart(pool, args->autostart) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStoragePoolUndefine(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_undefine_args *args);
static int remoteDispatchStoragePoolUndefineHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStoragePoolUndefine");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStoragePoolUndefine(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStoragePoolUndefine(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_undefine_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (virStoragePoolUndefine(pool) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    return rv;
}



static int remoteDispatchStorageVolCreateXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_create_xml_args *args,
    remote_storage_vol_create_xml_ret *ret);
static int remoteDispatchStorageVolCreateXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolCreateXML");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolCreateXML(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolCreateXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_create_xml_args *args,
    remote_storage_vol_create_xml_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if ((vol = virStorageVolCreateXML(pool, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolCreateXMLFrom(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_create_xml_from_args *args,
    remote_storage_vol_create_xml_from_ret *ret);
static int remoteDispatchStorageVolCreateXMLFromHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolCreateXMLFrom");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolCreateXMLFrom(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolCreateXMLFrom(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_create_xml_from_args *args,
    remote_storage_vol_create_xml_from_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    virStorageVolPtr clonevol = NULL;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (!(clonevol = get_nonnull_storage_vol(priv->conn, args->clonevol)))
        goto cleanup;

    if ((vol = virStorageVolCreateXMLFrom(pool, args->xml, clonevol, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    virObjectUnref(clonevol);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolDelete(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_delete_args *args);
static int remoteDispatchStorageVolDeleteHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolDelete");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolDelete(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolDelete(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_delete_args *args)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(priv->conn, args->vol)))
        goto cleanup;

    if (virStorageVolDelete(vol, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolDownload(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_download_args *args);
static int remoteDispatchStorageVolDownloadHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolDownload");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolDownload(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolDownload(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_download_args *args)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);
    virStreamPtr st = NULL;
    daemonClientStreamPtr stream = NULL;
    const bool sparse = args->flags & VIR_STORAGE_VOL_DOWNLOAD_SPARSE_STREAM;

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(priv->conn, args->vol)))
        goto cleanup;

    if (!(st = virStreamNew(priv->conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, &msg->header, sparse)))
        goto cleanup;

    if (virStorageVolDownload(vol, st, args->offset, args->length, args->flags) < 0)
        goto cleanup;

    if (daemonAddClientStream(client, stream, true) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virObjectUnref(st);
        }
    }
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolGetInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_get_info_args *args,
    remote_storage_vol_get_info_ret *ret);
static int remoteDispatchStorageVolGetInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolGetInfo");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolGetInfo(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolGetInfo(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_get_info_args *args,
    remote_storage_vol_get_info_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    virStorageVolInfo tmp;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(priv->conn, args->vol)))
        goto cleanup;

    if (virStorageVolGetInfo(vol, &tmp) < 0)
        goto cleanup;

    ret->type = tmp.type;
    ret->capacity = tmp.capacity;
    ret->allocation = tmp.allocation;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolGetInfoFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_get_info_flags_args *args,
    remote_storage_vol_get_info_flags_ret *ret);
static int remoteDispatchStorageVolGetInfoFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolGetInfoFlags");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolGetInfoFlags(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
/* remoteDispatchStorageVolGetInfoFlags body has to be implemented manually */



static int remoteDispatchStorageVolGetPath(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_get_path_args *args,
    remote_storage_vol_get_path_ret *ret);
static int remoteDispatchStorageVolGetPathHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolGetPath");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolGetPath(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolGetPath(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_get_path_args *args,
    remote_storage_vol_get_path_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    char *name;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(priv->conn, args->vol)))
        goto cleanup;

    if ((name = virStorageVolGetPath(vol)) == NULL)
        goto cleanup;

    ret->name = name;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_get_xml_desc_args *args,
    remote_storage_vol_get_xml_desc_ret *ret);
static int remoteDispatchStorageVolGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolGetXMLDesc");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolGetXMLDesc(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_get_xml_desc_args *args,
    remote_storage_vol_get_xml_desc_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(priv->conn, args->vol)))
        goto cleanup;

    if ((xml = virStorageVolGetXMLDesc(vol, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolLookupByKey(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_lookup_by_key_args *args,
    remote_storage_vol_lookup_by_key_ret *ret);
static int remoteDispatchStorageVolLookupByKeyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolLookupByKey");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolLookupByKey(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolLookupByKey(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_lookup_by_key_args *args,
    remote_storage_vol_lookup_by_key_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((vol = virStorageVolLookupByKey(priv->conn, args->key)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolLookupByName(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_lookup_by_name_args *args,
    remote_storage_vol_lookup_by_name_ret *ret);
static int remoteDispatchStorageVolLookupByNameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolLookupByName");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolLookupByName(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolLookupByName(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_lookup_by_name_args *args,
    remote_storage_vol_lookup_by_name_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if ((vol = virStorageVolLookupByName(pool, args->name)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(pool);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolLookupByPath(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_lookup_by_path_args *args,
    remote_storage_vol_lookup_by_path_ret *ret);
static int remoteDispatchStorageVolLookupByPathHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolLookupByPath");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolLookupByPath(server, client, msg, rerr, args, ret);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolLookupByPath(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_lookup_by_path_args *args,
    remote_storage_vol_lookup_by_path_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((vol = virStorageVolLookupByPath(priv->conn, args->path)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolResize(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_resize_args *args);
static int remoteDispatchStorageVolResizeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolResize");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolResize(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolResize(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_resize_args *args)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(priv->conn, args->vol)))
        goto cleanup;

    if (virStorageVolResize(vol, args->capacity, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolUpload(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_upload_args *args);
static int remoteDispatchStorageVolUploadHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolUpload");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolUpload(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolUpload(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_upload_args *args)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);
    virStreamPtr st = NULL;
    daemonClientStreamPtr stream = NULL;
    const bool sparse = args->flags & VIR_STORAGE_VOL_UPLOAD_SPARSE_STREAM;

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(priv->conn, args->vol)))
        goto cleanup;

    if (!(st = virStreamNew(priv->conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, &msg->header, sparse)))
        goto cleanup;

    if (virStorageVolUpload(vol, st, args->offset, args->length, args->flags) < 0)
        goto cleanup;

    if (daemonAddClientStream(client, stream, false) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virObjectUnref(st);
        }
    }
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolWipe(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_wipe_args *args);
static int remoteDispatchStorageVolWipeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolWipe");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolWipe(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolWipe(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_wipe_args *args)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(priv->conn, args->vol)))
        goto cleanup;

    if (virStorageVolWipe(vol, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    return rv;
}



static int remoteDispatchStorageVolWipePattern(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_wipe_pattern_args *args);
static int remoteDispatchStorageVolWipePatternHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  int rv;
  virThreadJobSet("remoteDispatchStorageVolWipePattern");
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p",
            server, client, msg, rerr, args, ret);
  rv = remoteDispatchStorageVolWipePattern(server, client, msg, rerr, args);
  virThreadJobClear(rv);
  return rv;
}
static int remoteDispatchStorageVolWipePattern(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_wipe_pattern_args *args)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(priv->conn, args->vol)))
        goto cleanup;

    if (virStorageVolWipePattern(vol, args->algorithm, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    virObjectUnref(vol);
    return rv;
}



virNetServerProgramProc remoteProcs[] = {
{ /* Unused 0 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectOpen => 1 */
   remoteDispatchConnectOpenHelper,
   sizeof(remote_connect_open_args),
   (xdrproc_t)xdr_remote_connect_open_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method ConnectClose => 2 */
   remoteDispatchConnectCloseHelper,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method ConnectGetType => 3 */
   remoteDispatchConnectGetTypeHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_get_type_ret),
   (xdrproc_t)xdr_remote_connect_get_type_ret,
   true,
   1
},
{ /* Method ConnectGetVersion => 4 */
   remoteDispatchConnectGetVersionHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_get_version_ret),
   (xdrproc_t)xdr_remote_connect_get_version_ret,
   true,
   1
},
{ /* Method ConnectGetMaxVcpus => 5 */
   remoteDispatchConnectGetMaxVcpusHelper,
   sizeof(remote_connect_get_max_vcpus_args),
   (xdrproc_t)xdr_remote_connect_get_max_vcpus_args,
   sizeof(remote_connect_get_max_vcpus_ret),
   (xdrproc_t)xdr_remote_connect_get_max_vcpus_ret,
   true,
   1
},
{ /* Method NodeGetInfo => 6 */
   remoteDispatchNodeGetInfoHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_node_get_info_ret),
   (xdrproc_t)xdr_remote_node_get_info_ret,
   true,
   1
},
{ /* Method ConnectGetCapabilities => 7 */
   remoteDispatchConnectGetCapabilitiesHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_get_capabilities_ret),
   (xdrproc_t)xdr_remote_connect_get_capabilities_ret,
   true,
   0
},
{ /* Method DomainAttachDevice => 8 */
   remoteDispatchDomainAttachDeviceHelper,
   sizeof(remote_domain_attach_device_args),
   (xdrproc_t)xdr_remote_domain_attach_device_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainCreate => 9 */
   remoteDispatchDomainCreateHelper,
   sizeof(remote_domain_create_args),
   (xdrproc_t)xdr_remote_domain_create_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainCreateXML => 10 */
   remoteDispatchDomainCreateXMLHelper,
   sizeof(remote_domain_create_xml_args),
   (xdrproc_t)xdr_remote_domain_create_xml_args,
   sizeof(remote_domain_create_xml_ret),
   (xdrproc_t)xdr_remote_domain_create_xml_ret,
   true,
   0
},
{ /* Method DomainDefineXML => 11 */
   remoteDispatchDomainDefineXMLHelper,
   sizeof(remote_domain_define_xml_args),
   (xdrproc_t)xdr_remote_domain_define_xml_args,
   sizeof(remote_domain_define_xml_ret),
   (xdrproc_t)xdr_remote_domain_define_xml_ret,
   true,
   1
},
{ /* Method DomainDestroy => 12 */
   remoteDispatchDomainDestroyHelper,
   sizeof(remote_domain_destroy_args),
   (xdrproc_t)xdr_remote_domain_destroy_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method DomainDetachDevice => 13 */
   remoteDispatchDomainDetachDeviceHelper,
   sizeof(remote_domain_detach_device_args),
   (xdrproc_t)xdr_remote_domain_detach_device_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetXMLDesc => 14 */
   remoteDispatchDomainGetXMLDescHelper,
   sizeof(remote_domain_get_xml_desc_args),
   (xdrproc_t)xdr_remote_domain_get_xml_desc_args,
   sizeof(remote_domain_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_domain_get_xml_desc_ret,
   true,
   0
},
{ /* Method DomainGetAutostart => 15 */
   remoteDispatchDomainGetAutostartHelper,
   sizeof(remote_domain_get_autostart_args),
   (xdrproc_t)xdr_remote_domain_get_autostart_args,
   sizeof(remote_domain_get_autostart_ret),
   (xdrproc_t)xdr_remote_domain_get_autostart_ret,
   true,
   1
},
{ /* Method DomainGetInfo => 16 */
   remoteDispatchDomainGetInfoHelper,
   sizeof(remote_domain_get_info_args),
   (xdrproc_t)xdr_remote_domain_get_info_args,
   sizeof(remote_domain_get_info_ret),
   (xdrproc_t)xdr_remote_domain_get_info_ret,
   true,
   0
},
{ /* Method DomainGetMaxMemory => 17 */
   remoteDispatchDomainGetMaxMemoryHelper,
   sizeof(remote_domain_get_max_memory_args),
   (xdrproc_t)xdr_remote_domain_get_max_memory_args,
   sizeof(remote_domain_get_max_memory_ret),
   (xdrproc_t)xdr_remote_domain_get_max_memory_ret,
   true,
   1
},
{ /* Method DomainGetMaxVcpus => 18 */
   remoteDispatchDomainGetMaxVcpusHelper,
   sizeof(remote_domain_get_max_vcpus_args),
   (xdrproc_t)xdr_remote_domain_get_max_vcpus_args,
   sizeof(remote_domain_get_max_vcpus_ret),
   (xdrproc_t)xdr_remote_domain_get_max_vcpus_ret,
   true,
   1
},
{ /* Method DomainGetOSType => 19 */
   remoteDispatchDomainGetOSTypeHelper,
   sizeof(remote_domain_get_os_type_args),
   (xdrproc_t)xdr_remote_domain_get_os_type_args,
   sizeof(remote_domain_get_os_type_ret),
   (xdrproc_t)xdr_remote_domain_get_os_type_ret,
   true,
   1
},
{ /* Method DomainGetVcpus => 20 */
   remoteDispatchDomainGetVcpusHelper,
   sizeof(remote_domain_get_vcpus_args),
   (xdrproc_t)xdr_remote_domain_get_vcpus_args,
   sizeof(remote_domain_get_vcpus_ret),
   (xdrproc_t)xdr_remote_domain_get_vcpus_ret,
   true,
   1
},
{ /* Method ConnectListDefinedDomains => 21 */
   remoteDispatchConnectListDefinedDomainsHelper,
   sizeof(remote_connect_list_defined_domains_args),
   (xdrproc_t)xdr_remote_connect_list_defined_domains_args,
   sizeof(remote_connect_list_defined_domains_ret),
   (xdrproc_t)xdr_remote_connect_list_defined_domains_ret,
   true,
   1
},
{ /* Method DomainLookupByID => 22 */
   remoteDispatchDomainLookupByIDHelper,
   sizeof(remote_domain_lookup_by_id_args),
   (xdrproc_t)xdr_remote_domain_lookup_by_id_args,
   sizeof(remote_domain_lookup_by_id_ret),
   (xdrproc_t)xdr_remote_domain_lookup_by_id_ret,
   true,
   1
},
{ /* Method DomainLookupByName => 23 */
   remoteDispatchDomainLookupByNameHelper,
   sizeof(remote_domain_lookup_by_name_args),
   (xdrproc_t)xdr_remote_domain_lookup_by_name_args,
   sizeof(remote_domain_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_domain_lookup_by_name_ret,
   true,
   1
},
{ /* Method DomainLookupByUUID => 24 */
   remoteDispatchDomainLookupByUUIDHelper,
   sizeof(remote_domain_lookup_by_uuid_args),
   (xdrproc_t)xdr_remote_domain_lookup_by_uuid_args,
   sizeof(remote_domain_lookup_by_uuid_ret),
   (xdrproc_t)xdr_remote_domain_lookup_by_uuid_ret,
   true,
   1
},
{ /* Method ConnectNumOfDefinedDomains => 25 */
   remoteDispatchConnectNumOfDefinedDomainsHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_defined_domains_ret),
   (xdrproc_t)xdr_remote_connect_num_of_defined_domains_ret,
   true,
   1
},
{ /* Method DomainPinVcpu => 26 */
   remoteDispatchDomainPinVcpuHelper,
   sizeof(remote_domain_pin_vcpu_args),
   (xdrproc_t)xdr_remote_domain_pin_vcpu_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainReboot => 27 */
   remoteDispatchDomainRebootHelper,
   sizeof(remote_domain_reboot_args),
   (xdrproc_t)xdr_remote_domain_reboot_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainResume => 28 */
   remoteDispatchDomainResumeHelper,
   sizeof(remote_domain_resume_args),
   (xdrproc_t)xdr_remote_domain_resume_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetAutostart => 29 */
   remoteDispatchDomainSetAutostartHelper,
   sizeof(remote_domain_set_autostart_args),
   (xdrproc_t)xdr_remote_domain_set_autostart_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method DomainSetMaxMemory => 30 */
   remoteDispatchDomainSetMaxMemoryHelper,
   sizeof(remote_domain_set_max_memory_args),
   (xdrproc_t)xdr_remote_domain_set_max_memory_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method DomainSetMemory => 31 */
   remoteDispatchDomainSetMemoryHelper,
   sizeof(remote_domain_set_memory_args),
   (xdrproc_t)xdr_remote_domain_set_memory_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetVcpus => 32 */
   remoteDispatchDomainSetVcpusHelper,
   sizeof(remote_domain_set_vcpus_args),
   (xdrproc_t)xdr_remote_domain_set_vcpus_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainShutdown => 33 */
   remoteDispatchDomainShutdownHelper,
   sizeof(remote_domain_shutdown_args),
   (xdrproc_t)xdr_remote_domain_shutdown_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSuspend => 34 */
   remoteDispatchDomainSuspendHelper,
   sizeof(remote_domain_suspend_args),
   (xdrproc_t)xdr_remote_domain_suspend_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainUndefine => 35 */
   remoteDispatchDomainUndefineHelper,
   sizeof(remote_domain_undefine_args),
   (xdrproc_t)xdr_remote_domain_undefine_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method ConnectListDefinedNetworks => 36 */
   remoteDispatchConnectListDefinedNetworksHelper,
   sizeof(remote_connect_list_defined_networks_args),
   (xdrproc_t)xdr_remote_connect_list_defined_networks_args,
   sizeof(remote_connect_list_defined_networks_ret),
   (xdrproc_t)xdr_remote_connect_list_defined_networks_ret,
   true,
   1
},
{ /* Method ConnectListDomains => 37 */
   remoteDispatchConnectListDomainsHelper,
   sizeof(remote_connect_list_domains_args),
   (xdrproc_t)xdr_remote_connect_list_domains_args,
   sizeof(remote_connect_list_domains_ret),
   (xdrproc_t)xdr_remote_connect_list_domains_ret,
   true,
   1
},
{ /* Method ConnectListNetworks => 38 */
   remoteDispatchConnectListNetworksHelper,
   sizeof(remote_connect_list_networks_args),
   (xdrproc_t)xdr_remote_connect_list_networks_args,
   sizeof(remote_connect_list_networks_ret),
   (xdrproc_t)xdr_remote_connect_list_networks_ret,
   true,
   1
},
{ /* Method NetworkCreate => 39 */
   remoteDispatchNetworkCreateHelper,
   sizeof(remote_network_create_args),
   (xdrproc_t)xdr_remote_network_create_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NetworkCreateXML => 40 */
   remoteDispatchNetworkCreateXMLHelper,
   sizeof(remote_network_create_xml_args),
   (xdrproc_t)xdr_remote_network_create_xml_args,
   sizeof(remote_network_create_xml_ret),
   (xdrproc_t)xdr_remote_network_create_xml_ret,
   true,
   0
},
{ /* Method NetworkDefineXML => 41 */
   remoteDispatchNetworkDefineXMLHelper,
   sizeof(remote_network_define_xml_args),
   (xdrproc_t)xdr_remote_network_define_xml_args,
   sizeof(remote_network_define_xml_ret),
   (xdrproc_t)xdr_remote_network_define_xml_ret,
   true,
   1
},
{ /* Method NetworkDestroy => 42 */
   remoteDispatchNetworkDestroyHelper,
   sizeof(remote_network_destroy_args),
   (xdrproc_t)xdr_remote_network_destroy_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method NetworkGetXMLDesc => 43 */
   remoteDispatchNetworkGetXMLDescHelper,
   sizeof(remote_network_get_xml_desc_args),
   (xdrproc_t)xdr_remote_network_get_xml_desc_args,
   sizeof(remote_network_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_network_get_xml_desc_ret,
   true,
   1
},
{ /* Method NetworkGetAutostart => 44 */
   remoteDispatchNetworkGetAutostartHelper,
   sizeof(remote_network_get_autostart_args),
   (xdrproc_t)xdr_remote_network_get_autostart_args,
   sizeof(remote_network_get_autostart_ret),
   (xdrproc_t)xdr_remote_network_get_autostart_ret,
   true,
   1
},
{ /* Method NetworkGetBridgeName => 45 */
   remoteDispatchNetworkGetBridgeNameHelper,
   sizeof(remote_network_get_bridge_name_args),
   (xdrproc_t)xdr_remote_network_get_bridge_name_args,
   sizeof(remote_network_get_bridge_name_ret),
   (xdrproc_t)xdr_remote_network_get_bridge_name_ret,
   true,
   1
},
{ /* Method NetworkLookupByName => 46 */
   remoteDispatchNetworkLookupByNameHelper,
   sizeof(remote_network_lookup_by_name_args),
   (xdrproc_t)xdr_remote_network_lookup_by_name_args,
   sizeof(remote_network_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_network_lookup_by_name_ret,
   true,
   1
},
{ /* Method NetworkLookupByUUID => 47 */
   remoteDispatchNetworkLookupByUUIDHelper,
   sizeof(remote_network_lookup_by_uuid_args),
   (xdrproc_t)xdr_remote_network_lookup_by_uuid_args,
   sizeof(remote_network_lookup_by_uuid_ret),
   (xdrproc_t)xdr_remote_network_lookup_by_uuid_ret,
   true,
   1
},
{ /* Method NetworkSetAutostart => 48 */
   remoteDispatchNetworkSetAutostartHelper,
   sizeof(remote_network_set_autostart_args),
   (xdrproc_t)xdr_remote_network_set_autostart_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method NetworkUndefine => 49 */
   remoteDispatchNetworkUndefineHelper,
   sizeof(remote_network_undefine_args),
   (xdrproc_t)xdr_remote_network_undefine_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method ConnectNumOfDefinedNetworks => 50 */
   remoteDispatchConnectNumOfDefinedNetworksHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_defined_networks_ret),
   (xdrproc_t)xdr_remote_connect_num_of_defined_networks_ret,
   true,
   1
},
{ /* Method ConnectNumOfDomains => 51 */
   remoteDispatchConnectNumOfDomainsHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_domains_ret),
   (xdrproc_t)xdr_remote_connect_num_of_domains_ret,
   true,
   1
},
{ /* Method ConnectNumOfNetworks => 52 */
   remoteDispatchConnectNumOfNetworksHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_networks_ret),
   (xdrproc_t)xdr_remote_connect_num_of_networks_ret,
   true,
   1
},
{ /* Method DomainCoreDump => 53 */
   remoteDispatchDomainCoreDumpHelper,
   sizeof(remote_domain_core_dump_args),
   (xdrproc_t)xdr_remote_domain_core_dump_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainRestore => 54 */
   remoteDispatchDomainRestoreHelper,
   sizeof(remote_domain_restore_args),
   (xdrproc_t)xdr_remote_domain_restore_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSave => 55 */
   remoteDispatchDomainSaveHelper,
   sizeof(remote_domain_save_args),
   (xdrproc_t)xdr_remote_domain_save_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetSchedulerType => 56 */
   remoteDispatchDomainGetSchedulerTypeHelper,
   sizeof(remote_domain_get_scheduler_type_args),
   (xdrproc_t)xdr_remote_domain_get_scheduler_type_args,
   sizeof(remote_domain_get_scheduler_type_ret),
   (xdrproc_t)xdr_remote_domain_get_scheduler_type_ret,
   true,
   0
},
{ /* Method DomainGetSchedulerParameters => 57 */
   remoteDispatchDomainGetSchedulerParametersHelper,
   sizeof(remote_domain_get_scheduler_parameters_args),
   (xdrproc_t)xdr_remote_domain_get_scheduler_parameters_args,
   sizeof(remote_domain_get_scheduler_parameters_ret),
   (xdrproc_t)xdr_remote_domain_get_scheduler_parameters_ret,
   true,
   0
},
{ /* Method DomainSetSchedulerParameters => 58 */
   remoteDispatchDomainSetSchedulerParametersHelper,
   sizeof(remote_domain_set_scheduler_parameters_args),
   (xdrproc_t)xdr_remote_domain_set_scheduler_parameters_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectGetHostname => 59 */
   remoteDispatchConnectGetHostnameHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_get_hostname_ret),
   (xdrproc_t)xdr_remote_connect_get_hostname_ret,
   true,
   1
},
{ /* Method ConnectSupportsFeature => 60 */
   remoteDispatchConnectSupportsFeatureHelper,
   sizeof(remote_connect_supports_feature_args),
   (xdrproc_t)xdr_remote_connect_supports_feature_args,
   sizeof(remote_connect_supports_feature_ret),
   (xdrproc_t)xdr_remote_connect_supports_feature_ret,
   true,
   1
},
{ /* Method DomainMigratePrepare => 61 */
   remoteDispatchDomainMigratePrepareHelper,
   sizeof(remote_domain_migrate_prepare_args),
   (xdrproc_t)xdr_remote_domain_migrate_prepare_args,
   sizeof(remote_domain_migrate_prepare_ret),
   (xdrproc_t)xdr_remote_domain_migrate_prepare_ret,
   true,
   0
},
{ /* Method DomainMigratePerform => 62 */
   remoteDispatchDomainMigratePerformHelper,
   sizeof(remote_domain_migrate_perform_args),
   (xdrproc_t)xdr_remote_domain_migrate_perform_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainMigrateFinish => 63 */
   remoteDispatchDomainMigrateFinishHelper,
   sizeof(remote_domain_migrate_finish_args),
   (xdrproc_t)xdr_remote_domain_migrate_finish_args,
   sizeof(remote_domain_migrate_finish_ret),
   (xdrproc_t)xdr_remote_domain_migrate_finish_ret,
   true,
   0
},
{ /* Method DomainBlockStats => 64 */
   remoteDispatchDomainBlockStatsHelper,
   sizeof(remote_domain_block_stats_args),
   (xdrproc_t)xdr_remote_domain_block_stats_args,
   sizeof(remote_domain_block_stats_ret),
   (xdrproc_t)xdr_remote_domain_block_stats_ret,
   true,
   0
},
{ /* Method DomainInterfaceStats => 65 */
   remoteDispatchDomainInterfaceStatsHelper,
   sizeof(remote_domain_interface_stats_args),
   (xdrproc_t)xdr_remote_domain_interface_stats_args,
   sizeof(remote_domain_interface_stats_ret),
   (xdrproc_t)xdr_remote_domain_interface_stats_ret,
   true,
   1
},
{ /* Method AuthList => 66 */
   remoteDispatchAuthListHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_auth_list_ret),
   (xdrproc_t)xdr_remote_auth_list_ret,
   true,
   1
},
{ /* Method AuthSaslInit => 67 */
   remoteDispatchAuthSaslInitHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_auth_sasl_init_ret),
   (xdrproc_t)xdr_remote_auth_sasl_init_ret,
   true,
   1
},
{ /* Method AuthSaslStart => 68 */
   remoteDispatchAuthSaslStartHelper,
   sizeof(remote_auth_sasl_start_args),
   (xdrproc_t)xdr_remote_auth_sasl_start_args,
   sizeof(remote_auth_sasl_start_ret),
   (xdrproc_t)xdr_remote_auth_sasl_start_ret,
   true,
   1
},
{ /* Method AuthSaslStep => 69 */
   remoteDispatchAuthSaslStepHelper,
   sizeof(remote_auth_sasl_step_args),
   (xdrproc_t)xdr_remote_auth_sasl_step_args,
   sizeof(remote_auth_sasl_step_ret),
   (xdrproc_t)xdr_remote_auth_sasl_step_ret,
   true,
   1
},
{ /* Method AuthPolkit => 70 */
   remoteDispatchAuthPolkitHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_auth_polkit_ret),
   (xdrproc_t)xdr_remote_auth_polkit_ret,
   true,
   1
},
{ /* Method ConnectNumOfStoragePools => 71 */
   remoteDispatchConnectNumOfStoragePoolsHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_storage_pools_ret),
   (xdrproc_t)xdr_remote_connect_num_of_storage_pools_ret,
   true,
   1
},
{ /* Method ConnectListStoragePools => 72 */
   remoteDispatchConnectListStoragePoolsHelper,
   sizeof(remote_connect_list_storage_pools_args),
   (xdrproc_t)xdr_remote_connect_list_storage_pools_args,
   sizeof(remote_connect_list_storage_pools_ret),
   (xdrproc_t)xdr_remote_connect_list_storage_pools_ret,
   true,
   1
},
{ /* Method ConnectNumOfDefinedStoragePools => 73 */
   remoteDispatchConnectNumOfDefinedStoragePoolsHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_defined_storage_pools_ret),
   (xdrproc_t)xdr_remote_connect_num_of_defined_storage_pools_ret,
   true,
   1
},
{ /* Method ConnectListDefinedStoragePools => 74 */
   remoteDispatchConnectListDefinedStoragePoolsHelper,
   sizeof(remote_connect_list_defined_storage_pools_args),
   (xdrproc_t)xdr_remote_connect_list_defined_storage_pools_args,
   sizeof(remote_connect_list_defined_storage_pools_ret),
   (xdrproc_t)xdr_remote_connect_list_defined_storage_pools_ret,
   true,
   1
},
{ /* Method ConnectFindStoragePoolSources => 75 */
   remoteDispatchConnectFindStoragePoolSourcesHelper,
   sizeof(remote_connect_find_storage_pool_sources_args),
   (xdrproc_t)xdr_remote_connect_find_storage_pool_sources_args,
   sizeof(remote_connect_find_storage_pool_sources_ret),
   (xdrproc_t)xdr_remote_connect_find_storage_pool_sources_ret,
   true,
   0
},
{ /* Method StoragePoolCreateXML => 76 */
   remoteDispatchStoragePoolCreateXMLHelper,
   sizeof(remote_storage_pool_create_xml_args),
   (xdrproc_t)xdr_remote_storage_pool_create_xml_args,
   sizeof(remote_storage_pool_create_xml_ret),
   (xdrproc_t)xdr_remote_storage_pool_create_xml_ret,
   true,
   0
},
{ /* Method StoragePoolDefineXML => 77 */
   remoteDispatchStoragePoolDefineXMLHelper,
   sizeof(remote_storage_pool_define_xml_args),
   (xdrproc_t)xdr_remote_storage_pool_define_xml_args,
   sizeof(remote_storage_pool_define_xml_ret),
   (xdrproc_t)xdr_remote_storage_pool_define_xml_ret,
   true,
   1
},
{ /* Method StoragePoolCreate => 78 */
   remoteDispatchStoragePoolCreateHelper,
   sizeof(remote_storage_pool_create_args),
   (xdrproc_t)xdr_remote_storage_pool_create_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StoragePoolBuild => 79 */
   remoteDispatchStoragePoolBuildHelper,
   sizeof(remote_storage_pool_build_args),
   (xdrproc_t)xdr_remote_storage_pool_build_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StoragePoolDestroy => 80 */
   remoteDispatchStoragePoolDestroyHelper,
   sizeof(remote_storage_pool_destroy_args),
   (xdrproc_t)xdr_remote_storage_pool_destroy_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method StoragePoolDelete => 81 */
   remoteDispatchStoragePoolDeleteHelper,
   sizeof(remote_storage_pool_delete_args),
   (xdrproc_t)xdr_remote_storage_pool_delete_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StoragePoolUndefine => 82 */
   remoteDispatchStoragePoolUndefineHelper,
   sizeof(remote_storage_pool_undefine_args),
   (xdrproc_t)xdr_remote_storage_pool_undefine_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method StoragePoolRefresh => 83 */
   remoteDispatchStoragePoolRefreshHelper,
   sizeof(remote_storage_pool_refresh_args),
   (xdrproc_t)xdr_remote_storage_pool_refresh_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StoragePoolLookupByName => 84 */
   remoteDispatchStoragePoolLookupByNameHelper,
   sizeof(remote_storage_pool_lookup_by_name_args),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_name_args,
   sizeof(remote_storage_pool_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_name_ret,
   true,
   1
},
{ /* Method StoragePoolLookupByUUID => 85 */
   remoteDispatchStoragePoolLookupByUUIDHelper,
   sizeof(remote_storage_pool_lookup_by_uuid_args),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_uuid_args,
   sizeof(remote_storage_pool_lookup_by_uuid_ret),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_uuid_ret,
   true,
   1
},
{ /* Method StoragePoolLookupByVolume => 86 */
   remoteDispatchStoragePoolLookupByVolumeHelper,
   sizeof(remote_storage_pool_lookup_by_volume_args),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_volume_args,
   sizeof(remote_storage_pool_lookup_by_volume_ret),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_volume_ret,
   true,
   1
},
{ /* Method StoragePoolGetInfo => 87 */
   remoteDispatchStoragePoolGetInfoHelper,
   sizeof(remote_storage_pool_get_info_args),
   (xdrproc_t)xdr_remote_storage_pool_get_info_args,
   sizeof(remote_storage_pool_get_info_ret),
   (xdrproc_t)xdr_remote_storage_pool_get_info_ret,
   true,
   1
},
{ /* Method StoragePoolGetXMLDesc => 88 */
   remoteDispatchStoragePoolGetXMLDescHelper,
   sizeof(remote_storage_pool_get_xml_desc_args),
   (xdrproc_t)xdr_remote_storage_pool_get_xml_desc_args,
   sizeof(remote_storage_pool_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_storage_pool_get_xml_desc_ret,
   true,
   1
},
{ /* Method StoragePoolGetAutostart => 89 */
   remoteDispatchStoragePoolGetAutostartHelper,
   sizeof(remote_storage_pool_get_autostart_args),
   (xdrproc_t)xdr_remote_storage_pool_get_autostart_args,
   sizeof(remote_storage_pool_get_autostart_ret),
   (xdrproc_t)xdr_remote_storage_pool_get_autostart_ret,
   true,
   1
},
{ /* Method StoragePoolSetAutostart => 90 */
   remoteDispatchStoragePoolSetAutostartHelper,
   sizeof(remote_storage_pool_set_autostart_args),
   (xdrproc_t)xdr_remote_storage_pool_set_autostart_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method StoragePoolNumOfVolumes => 91 */
   remoteDispatchStoragePoolNumOfVolumesHelper,
   sizeof(remote_storage_pool_num_of_volumes_args),
   (xdrproc_t)xdr_remote_storage_pool_num_of_volumes_args,
   sizeof(remote_storage_pool_num_of_volumes_ret),
   (xdrproc_t)xdr_remote_storage_pool_num_of_volumes_ret,
   true,
   1
},
{ /* Method StoragePoolListVolumes => 92 */
   remoteDispatchStoragePoolListVolumesHelper,
   sizeof(remote_storage_pool_list_volumes_args),
   (xdrproc_t)xdr_remote_storage_pool_list_volumes_args,
   sizeof(remote_storage_pool_list_volumes_ret),
   (xdrproc_t)xdr_remote_storage_pool_list_volumes_ret,
   true,
   1
},
{ /* Method StorageVolCreateXML => 93 */
   remoteDispatchStorageVolCreateXMLHelper,
   sizeof(remote_storage_vol_create_xml_args),
   (xdrproc_t)xdr_remote_storage_vol_create_xml_args,
   sizeof(remote_storage_vol_create_xml_ret),
   (xdrproc_t)xdr_remote_storage_vol_create_xml_ret,
   true,
   0
},
{ /* Method StorageVolDelete => 94 */
   remoteDispatchStorageVolDeleteHelper,
   sizeof(remote_storage_vol_delete_args),
   (xdrproc_t)xdr_remote_storage_vol_delete_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StorageVolLookupByName => 95 */
   remoteDispatchStorageVolLookupByNameHelper,
   sizeof(remote_storage_vol_lookup_by_name_args),
   (xdrproc_t)xdr_remote_storage_vol_lookup_by_name_args,
   sizeof(remote_storage_vol_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_storage_vol_lookup_by_name_ret,
   true,
   1
},
{ /* Method StorageVolLookupByKey => 96 */
   remoteDispatchStorageVolLookupByKeyHelper,
   sizeof(remote_storage_vol_lookup_by_key_args),
   (xdrproc_t)xdr_remote_storage_vol_lookup_by_key_args,
   sizeof(remote_storage_vol_lookup_by_key_ret),
   (xdrproc_t)xdr_remote_storage_vol_lookup_by_key_ret,
   true,
   1
},
{ /* Method StorageVolLookupByPath => 97 */
   remoteDispatchStorageVolLookupByPathHelper,
   sizeof(remote_storage_vol_lookup_by_path_args),
   (xdrproc_t)xdr_remote_storage_vol_lookup_by_path_args,
   sizeof(remote_storage_vol_lookup_by_path_ret),
   (xdrproc_t)xdr_remote_storage_vol_lookup_by_path_ret,
   true,
   1
},
{ /* Method StorageVolGetInfo => 98 */
   remoteDispatchStorageVolGetInfoHelper,
   sizeof(remote_storage_vol_get_info_args),
   (xdrproc_t)xdr_remote_storage_vol_get_info_args,
   sizeof(remote_storage_vol_get_info_ret),
   (xdrproc_t)xdr_remote_storage_vol_get_info_ret,
   true,
   1
},
{ /* Method StorageVolGetXMLDesc => 99 */
   remoteDispatchStorageVolGetXMLDescHelper,
   sizeof(remote_storage_vol_get_xml_desc_args),
   (xdrproc_t)xdr_remote_storage_vol_get_xml_desc_args,
   sizeof(remote_storage_vol_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_storage_vol_get_xml_desc_ret,
   true,
   1
},
{ /* Method StorageVolGetPath => 100 */
   remoteDispatchStorageVolGetPathHelper,
   sizeof(remote_storage_vol_get_path_args),
   (xdrproc_t)xdr_remote_storage_vol_get_path_args,
   sizeof(remote_storage_vol_get_path_ret),
   (xdrproc_t)xdr_remote_storage_vol_get_path_ret,
   true,
   1
},
{ /* Method NodeGetCellsFreeMemory => 101 */
   remoteDispatchNodeGetCellsFreeMemoryHelper,
   sizeof(remote_node_get_cells_free_memory_args),
   (xdrproc_t)xdr_remote_node_get_cells_free_memory_args,
   sizeof(remote_node_get_cells_free_memory_ret),
   (xdrproc_t)xdr_remote_node_get_cells_free_memory_ret,
   true,
   1
},
{ /* Method NodeGetFreeMemory => 102 */
   remoteDispatchNodeGetFreeMemoryHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_node_get_free_memory_ret),
   (xdrproc_t)xdr_remote_node_get_free_memory_ret,
   true,
   1
},
{ /* Method DomainBlockPeek => 103 */
   remoteDispatchDomainBlockPeekHelper,
   sizeof(remote_domain_block_peek_args),
   (xdrproc_t)xdr_remote_domain_block_peek_args,
   sizeof(remote_domain_block_peek_ret),
   (xdrproc_t)xdr_remote_domain_block_peek_ret,
   true,
   0
},
{ /* Method DomainMemoryPeek => 104 */
   remoteDispatchDomainMemoryPeekHelper,
   sizeof(remote_domain_memory_peek_args),
   (xdrproc_t)xdr_remote_domain_memory_peek_args,
   sizeof(remote_domain_memory_peek_ret),
   (xdrproc_t)xdr_remote_domain_memory_peek_ret,
   true,
   0
},
{ /* Method ConnectDomainEventRegister => 105 */
   remoteDispatchConnectDomainEventRegisterHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_domain_event_register_ret),
   (xdrproc_t)xdr_remote_connect_domain_event_register_ret,
   true,
   1
},
{ /* Method ConnectDomainEventDeregister => 106 */
   remoteDispatchConnectDomainEventDeregisterHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_domain_event_deregister_ret),
   (xdrproc_t)xdr_remote_connect_domain_event_deregister_ret,
   true,
   1
},
{ /* Async event DomainEventLifecycle => 107 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainMigratePrepare2 => 108 */
   remoteDispatchDomainMigratePrepare2Helper,
   sizeof(remote_domain_migrate_prepare2_args),
   (xdrproc_t)xdr_remote_domain_migrate_prepare2_args,
   sizeof(remote_domain_migrate_prepare2_ret),
   (xdrproc_t)xdr_remote_domain_migrate_prepare2_ret,
   true,
   0
},
{ /* Method DomainMigrateFinish2 => 109 */
   remoteDispatchDomainMigrateFinish2Helper,
   sizeof(remote_domain_migrate_finish2_args),
   (xdrproc_t)xdr_remote_domain_migrate_finish2_args,
   sizeof(remote_domain_migrate_finish2_ret),
   (xdrproc_t)xdr_remote_domain_migrate_finish2_ret,
   true,
   0
},
{ /* Method ConnectGetURI => 110 */
   remoteDispatchConnectGetURIHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_get_uri_ret),
   (xdrproc_t)xdr_remote_connect_get_uri_ret,
   true,
   1
},
{ /* Method NodeNumOfDevices => 111 */
   remoteDispatchNodeNumOfDevicesHelper,
   sizeof(remote_node_num_of_devices_args),
   (xdrproc_t)xdr_remote_node_num_of_devices_args,
   sizeof(remote_node_num_of_devices_ret),
   (xdrproc_t)xdr_remote_node_num_of_devices_ret,
   true,
   1
},
{ /* Method NodeListDevices => 112 */
   remoteDispatchNodeListDevicesHelper,
   sizeof(remote_node_list_devices_args),
   (xdrproc_t)xdr_remote_node_list_devices_args,
   sizeof(remote_node_list_devices_ret),
   (xdrproc_t)xdr_remote_node_list_devices_ret,
   true,
   1
},
{ /* Method NodeDeviceLookupByName => 113 */
   remoteDispatchNodeDeviceLookupByNameHelper,
   sizeof(remote_node_device_lookup_by_name_args),
   (xdrproc_t)xdr_remote_node_device_lookup_by_name_args,
   sizeof(remote_node_device_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_node_device_lookup_by_name_ret,
   true,
   1
},
{ /* Method NodeDeviceGetXMLDesc => 114 */
   remoteDispatchNodeDeviceGetXMLDescHelper,
   sizeof(remote_node_device_get_xml_desc_args),
   (xdrproc_t)xdr_remote_node_device_get_xml_desc_args,
   sizeof(remote_node_device_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_node_device_get_xml_desc_ret,
   true,
   0
},
{ /* Method NodeDeviceGetParent => 115 */
   remoteDispatchNodeDeviceGetParentHelper,
   sizeof(remote_node_device_get_parent_args),
   (xdrproc_t)xdr_remote_node_device_get_parent_args,
   sizeof(remote_node_device_get_parent_ret),
   (xdrproc_t)xdr_remote_node_device_get_parent_ret,
   true,
   1
},
{ /* Method NodeDeviceNumOfCaps => 116 */
   remoteDispatchNodeDeviceNumOfCapsHelper,
   sizeof(remote_node_device_num_of_caps_args),
   (xdrproc_t)xdr_remote_node_device_num_of_caps_args,
   sizeof(remote_node_device_num_of_caps_ret),
   (xdrproc_t)xdr_remote_node_device_num_of_caps_ret,
   true,
   1
},
{ /* Method NodeDeviceListCaps => 117 */
   remoteDispatchNodeDeviceListCapsHelper,
   sizeof(remote_node_device_list_caps_args),
   (xdrproc_t)xdr_remote_node_device_list_caps_args,
   sizeof(remote_node_device_list_caps_ret),
   (xdrproc_t)xdr_remote_node_device_list_caps_ret,
   true,
   1
},
{ /* Method NodeDeviceDettach => 118 */
   remoteDispatchNodeDeviceDettachHelper,
   sizeof(remote_node_device_dettach_args),
   (xdrproc_t)xdr_remote_node_device_dettach_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeDeviceReAttach => 119 */
   remoteDispatchNodeDeviceReAttachHelper,
   sizeof(remote_node_device_re_attach_args),
   (xdrproc_t)xdr_remote_node_device_re_attach_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeDeviceReset => 120 */
   remoteDispatchNodeDeviceResetHelper,
   sizeof(remote_node_device_reset_args),
   (xdrproc_t)xdr_remote_node_device_reset_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetSecurityLabel => 121 */
   remoteDispatchDomainGetSecurityLabelHelper,
   sizeof(remote_domain_get_security_label_args),
   (xdrproc_t)xdr_remote_domain_get_security_label_args,
   sizeof(remote_domain_get_security_label_ret),
   (xdrproc_t)xdr_remote_domain_get_security_label_ret,
   true,
   1
},
{ /* Method NodeGetSecurityModel => 122 */
   remoteDispatchNodeGetSecurityModelHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_node_get_security_model_ret),
   (xdrproc_t)xdr_remote_node_get_security_model_ret,
   true,
   1
},
{ /* Method NodeDeviceCreateXML => 123 */
   remoteDispatchNodeDeviceCreateXMLHelper,
   sizeof(remote_node_device_create_xml_args),
   (xdrproc_t)xdr_remote_node_device_create_xml_args,
   sizeof(remote_node_device_create_xml_ret),
   (xdrproc_t)xdr_remote_node_device_create_xml_ret,
   true,
   0
},
{ /* Method NodeDeviceDestroy => 124 */
   remoteDispatchNodeDeviceDestroyHelper,
   sizeof(remote_node_device_destroy_args),
   (xdrproc_t)xdr_remote_node_device_destroy_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method StorageVolCreateXMLFrom => 125 */
   remoteDispatchStorageVolCreateXMLFromHelper,
   sizeof(remote_storage_vol_create_xml_from_args),
   (xdrproc_t)xdr_remote_storage_vol_create_xml_from_args,
   sizeof(remote_storage_vol_create_xml_from_ret),
   (xdrproc_t)xdr_remote_storage_vol_create_xml_from_ret,
   true,
   0
},
{ /* Method ConnectNumOfInterfaces => 126 */
   remoteDispatchConnectNumOfInterfacesHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_interfaces_ret),
   (xdrproc_t)xdr_remote_connect_num_of_interfaces_ret,
   true,
   1
},
{ /* Method ConnectListInterfaces => 127 */
   remoteDispatchConnectListInterfacesHelper,
   sizeof(remote_connect_list_interfaces_args),
   (xdrproc_t)xdr_remote_connect_list_interfaces_args,
   sizeof(remote_connect_list_interfaces_ret),
   (xdrproc_t)xdr_remote_connect_list_interfaces_ret,
   true,
   1
},
{ /* Method InterfaceLookupByName => 128 */
   remoteDispatchInterfaceLookupByNameHelper,
   sizeof(remote_interface_lookup_by_name_args),
   (xdrproc_t)xdr_remote_interface_lookup_by_name_args,
   sizeof(remote_interface_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_interface_lookup_by_name_ret,
   true,
   1
},
{ /* Method InterfaceLookupByMACString => 129 */
   remoteDispatchInterfaceLookupByMACStringHelper,
   sizeof(remote_interface_lookup_by_mac_string_args),
   (xdrproc_t)xdr_remote_interface_lookup_by_mac_string_args,
   sizeof(remote_interface_lookup_by_mac_string_ret),
   (xdrproc_t)xdr_remote_interface_lookup_by_mac_string_ret,
   true,
   1
},
{ /* Method InterfaceGetXMLDesc => 130 */
   remoteDispatchInterfaceGetXMLDescHelper,
   sizeof(remote_interface_get_xml_desc_args),
   (xdrproc_t)xdr_remote_interface_get_xml_desc_args,
   sizeof(remote_interface_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_interface_get_xml_desc_ret,
   true,
   0
},
{ /* Method InterfaceDefineXML => 131 */
   remoteDispatchInterfaceDefineXMLHelper,
   sizeof(remote_interface_define_xml_args),
   (xdrproc_t)xdr_remote_interface_define_xml_args,
   sizeof(remote_interface_define_xml_ret),
   (xdrproc_t)xdr_remote_interface_define_xml_ret,
   true,
   1
},
{ /* Method InterfaceUndefine => 132 */
   remoteDispatchInterfaceUndefineHelper,
   sizeof(remote_interface_undefine_args),
   (xdrproc_t)xdr_remote_interface_undefine_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method InterfaceCreate => 133 */
   remoteDispatchInterfaceCreateHelper,
   sizeof(remote_interface_create_args),
   (xdrproc_t)xdr_remote_interface_create_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method InterfaceDestroy => 134 */
   remoteDispatchInterfaceDestroyHelper,
   sizeof(remote_interface_destroy_args),
   (xdrproc_t)xdr_remote_interface_destroy_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method ConnectDomainXMLFromNative => 135 */
   remoteDispatchConnectDomainXMLFromNativeHelper,
   sizeof(remote_connect_domain_xml_from_native_args),
   (xdrproc_t)xdr_remote_connect_domain_xml_from_native_args,
   sizeof(remote_connect_domain_xml_from_native_ret),
   (xdrproc_t)xdr_remote_connect_domain_xml_from_native_ret,
   true,
   0
},
{ /* Method ConnectDomainXMLToNative => 136 */
   remoteDispatchConnectDomainXMLToNativeHelper,
   sizeof(remote_connect_domain_xml_to_native_args),
   (xdrproc_t)xdr_remote_connect_domain_xml_to_native_args,
   sizeof(remote_connect_domain_xml_to_native_ret),
   (xdrproc_t)xdr_remote_connect_domain_xml_to_native_ret,
   true,
   0
},
{ /* Method ConnectNumOfDefinedInterfaces => 137 */
   remoteDispatchConnectNumOfDefinedInterfacesHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_defined_interfaces_ret),
   (xdrproc_t)xdr_remote_connect_num_of_defined_interfaces_ret,
   true,
   1
},
{ /* Method ConnectListDefinedInterfaces => 138 */
   remoteDispatchConnectListDefinedInterfacesHelper,
   sizeof(remote_connect_list_defined_interfaces_args),
   (xdrproc_t)xdr_remote_connect_list_defined_interfaces_args,
   sizeof(remote_connect_list_defined_interfaces_ret),
   (xdrproc_t)xdr_remote_connect_list_defined_interfaces_ret,
   true,
   1
},
{ /* Method ConnectNumOfSecrets => 139 */
   remoteDispatchConnectNumOfSecretsHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_secrets_ret),
   (xdrproc_t)xdr_remote_connect_num_of_secrets_ret,
   true,
   1
},
{ /* Method ConnectListSecrets => 140 */
   remoteDispatchConnectListSecretsHelper,
   sizeof(remote_connect_list_secrets_args),
   (xdrproc_t)xdr_remote_connect_list_secrets_args,
   sizeof(remote_connect_list_secrets_ret),
   (xdrproc_t)xdr_remote_connect_list_secrets_ret,
   true,
   1
},
{ /* Method SecretLookupByUUID => 141 */
   remoteDispatchSecretLookupByUUIDHelper,
   sizeof(remote_secret_lookup_by_uuid_args),
   (xdrproc_t)xdr_remote_secret_lookup_by_uuid_args,
   sizeof(remote_secret_lookup_by_uuid_ret),
   (xdrproc_t)xdr_remote_secret_lookup_by_uuid_ret,
   true,
   1
},
{ /* Method SecretDefineXML => 142 */
   remoteDispatchSecretDefineXMLHelper,
   sizeof(remote_secret_define_xml_args),
   (xdrproc_t)xdr_remote_secret_define_xml_args,
   sizeof(remote_secret_define_xml_ret),
   (xdrproc_t)xdr_remote_secret_define_xml_ret,
   true,
   1
},
{ /* Method SecretGetXMLDesc => 143 */
   remoteDispatchSecretGetXMLDescHelper,
   sizeof(remote_secret_get_xml_desc_args),
   (xdrproc_t)xdr_remote_secret_get_xml_desc_args,
   sizeof(remote_secret_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_secret_get_xml_desc_ret,
   true,
   1
},
{ /* Method SecretSetValue => 144 */
   remoteDispatchSecretSetValueHelper,
   sizeof(remote_secret_set_value_args),
   (xdrproc_t)xdr_remote_secret_set_value_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method SecretGetValue => 145 */
   remoteDispatchSecretGetValueHelper,
   sizeof(remote_secret_get_value_args),
   (xdrproc_t)xdr_remote_secret_get_value_args,
   sizeof(remote_secret_get_value_ret),
   (xdrproc_t)xdr_remote_secret_get_value_ret,
   true,
   1
},
{ /* Method SecretUndefine => 146 */
   remoteDispatchSecretUndefineHelper,
   sizeof(remote_secret_undefine_args),
   (xdrproc_t)xdr_remote_secret_undefine_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method SecretLookupByUsage => 147 */
   remoteDispatchSecretLookupByUsageHelper,
   sizeof(remote_secret_lookup_by_usage_args),
   (xdrproc_t)xdr_remote_secret_lookup_by_usage_args,
   sizeof(remote_secret_lookup_by_usage_ret),
   (xdrproc_t)xdr_remote_secret_lookup_by_usage_ret,
   true,
   1
},
{ /* Method DomainMigratePrepareTunnel => 148 */
   remoteDispatchDomainMigratePrepareTunnelHelper,
   sizeof(remote_domain_migrate_prepare_tunnel_args),
   (xdrproc_t)xdr_remote_domain_migrate_prepare_tunnel_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectIsSecure => 149 */
   remoteDispatchConnectIsSecureHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_is_secure_ret),
   (xdrproc_t)xdr_remote_connect_is_secure_ret,
   true,
   1
},
{ /* Method DomainIsActive => 150 */
   remoteDispatchDomainIsActiveHelper,
   sizeof(remote_domain_is_active_args),
   (xdrproc_t)xdr_remote_domain_is_active_args,
   sizeof(remote_domain_is_active_ret),
   (xdrproc_t)xdr_remote_domain_is_active_ret,
   true,
   1
},
{ /* Method DomainIsPersistent => 151 */
   remoteDispatchDomainIsPersistentHelper,
   sizeof(remote_domain_is_persistent_args),
   (xdrproc_t)xdr_remote_domain_is_persistent_args,
   sizeof(remote_domain_is_persistent_ret),
   (xdrproc_t)xdr_remote_domain_is_persistent_ret,
   true,
   1
},
{ /* Method NetworkIsActive => 152 */
   remoteDispatchNetworkIsActiveHelper,
   sizeof(remote_network_is_active_args),
   (xdrproc_t)xdr_remote_network_is_active_args,
   sizeof(remote_network_is_active_ret),
   (xdrproc_t)xdr_remote_network_is_active_ret,
   true,
   1
},
{ /* Method NetworkIsPersistent => 153 */
   remoteDispatchNetworkIsPersistentHelper,
   sizeof(remote_network_is_persistent_args),
   (xdrproc_t)xdr_remote_network_is_persistent_args,
   sizeof(remote_network_is_persistent_ret),
   (xdrproc_t)xdr_remote_network_is_persistent_ret,
   true,
   1
},
{ /* Method StoragePoolIsActive => 154 */
   remoteDispatchStoragePoolIsActiveHelper,
   sizeof(remote_storage_pool_is_active_args),
   (xdrproc_t)xdr_remote_storage_pool_is_active_args,
   sizeof(remote_storage_pool_is_active_ret),
   (xdrproc_t)xdr_remote_storage_pool_is_active_ret,
   true,
   1
},
{ /* Method StoragePoolIsPersistent => 155 */
   remoteDispatchStoragePoolIsPersistentHelper,
   sizeof(remote_storage_pool_is_persistent_args),
   (xdrproc_t)xdr_remote_storage_pool_is_persistent_args,
   sizeof(remote_storage_pool_is_persistent_ret),
   (xdrproc_t)xdr_remote_storage_pool_is_persistent_ret,
   true,
   1
},
{ /* Method InterfaceIsActive => 156 */
   remoteDispatchInterfaceIsActiveHelper,
   sizeof(remote_interface_is_active_args),
   (xdrproc_t)xdr_remote_interface_is_active_args,
   sizeof(remote_interface_is_active_ret),
   (xdrproc_t)xdr_remote_interface_is_active_ret,
   true,
   1
},
{ /* Method ConnectGetLibVersion => 157 */
   remoteDispatchConnectGetLibVersionHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_get_lib_version_ret),
   (xdrproc_t)xdr_remote_connect_get_lib_version_ret,
   true,
   1
},
{ /* Method ConnectCompareCPU => 158 */
   remoteDispatchConnectCompareCPUHelper,
   sizeof(remote_connect_compare_cpu_args),
   (xdrproc_t)xdr_remote_connect_compare_cpu_args,
   sizeof(remote_connect_compare_cpu_ret),
   (xdrproc_t)xdr_remote_connect_compare_cpu_ret,
   true,
   1
},
{ /* Method DomainMemoryStats => 159 */
   remoteDispatchDomainMemoryStatsHelper,
   sizeof(remote_domain_memory_stats_args),
   (xdrproc_t)xdr_remote_domain_memory_stats_args,
   sizeof(remote_domain_memory_stats_ret),
   (xdrproc_t)xdr_remote_domain_memory_stats_ret,
   true,
   0
},
{ /* Method DomainAttachDeviceFlags => 160 */
   remoteDispatchDomainAttachDeviceFlagsHelper,
   sizeof(remote_domain_attach_device_flags_args),
   (xdrproc_t)xdr_remote_domain_attach_device_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainDetachDeviceFlags => 161 */
   remoteDispatchDomainDetachDeviceFlagsHelper,
   sizeof(remote_domain_detach_device_flags_args),
   (xdrproc_t)xdr_remote_domain_detach_device_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectBaselineCPU => 162 */
   remoteDispatchConnectBaselineCPUHelper,
   sizeof(remote_connect_baseline_cpu_args),
   (xdrproc_t)xdr_remote_connect_baseline_cpu_args,
   sizeof(remote_connect_baseline_cpu_ret),
   (xdrproc_t)xdr_remote_connect_baseline_cpu_ret,
   true,
   0
},
{ /* Method DomainGetJobInfo => 163 */
   remoteDispatchDomainGetJobInfoHelper,
   sizeof(remote_domain_get_job_info_args),
   (xdrproc_t)xdr_remote_domain_get_job_info_args,
   sizeof(remote_domain_get_job_info_ret),
   (xdrproc_t)xdr_remote_domain_get_job_info_ret,
   true,
   0
},
{ /* Method DomainAbortJob => 164 */
   remoteDispatchDomainAbortJobHelper,
   sizeof(remote_domain_abort_job_args),
   (xdrproc_t)xdr_remote_domain_abort_job_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StorageVolWipe => 165 */
   remoteDispatchStorageVolWipeHelper,
   sizeof(remote_storage_vol_wipe_args),
   (xdrproc_t)xdr_remote_storage_vol_wipe_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainMigrateSetMaxDowntime => 166 */
   remoteDispatchDomainMigrateSetMaxDowntimeHelper,
   sizeof(remote_domain_migrate_set_max_downtime_args),
   (xdrproc_t)xdr_remote_domain_migrate_set_max_downtime_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectDomainEventRegisterAny => 167 */
   remoteDispatchConnectDomainEventRegisterAnyHelper,
   sizeof(remote_connect_domain_event_register_any_args),
   (xdrproc_t)xdr_remote_connect_domain_event_register_any_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method ConnectDomainEventDeregisterAny => 168 */
   remoteDispatchConnectDomainEventDeregisterAnyHelper,
   sizeof(remote_connect_domain_event_deregister_any_args),
   (xdrproc_t)xdr_remote_connect_domain_event_deregister_any_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Async event DomainEventReboot => 169 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventRtcChange => 170 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventWatchdog => 171 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventIoError => 172 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventGraphics => 173 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainUpdateDeviceFlags => 174 */
   remoteDispatchDomainUpdateDeviceFlagsHelper,
   sizeof(remote_domain_update_device_flags_args),
   (xdrproc_t)xdr_remote_domain_update_device_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NWFilterLookupByName => 175 */
   remoteDispatchNWFilterLookupByNameHelper,
   sizeof(remote_nwfilter_lookup_by_name_args),
   (xdrproc_t)xdr_remote_nwfilter_lookup_by_name_args,
   sizeof(remote_nwfilter_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_nwfilter_lookup_by_name_ret,
   true,
   1
},
{ /* Method NWFilterLookupByUUID => 176 */
   remoteDispatchNWFilterLookupByUUIDHelper,
   sizeof(remote_nwfilter_lookup_by_uuid_args),
   (xdrproc_t)xdr_remote_nwfilter_lookup_by_uuid_args,
   sizeof(remote_nwfilter_lookup_by_uuid_ret),
   (xdrproc_t)xdr_remote_nwfilter_lookup_by_uuid_ret,
   true,
   1
},
{ /* Method NWFilterGetXMLDesc => 177 */
   remoteDispatchNWFilterGetXMLDescHelper,
   sizeof(remote_nwfilter_get_xml_desc_args),
   (xdrproc_t)xdr_remote_nwfilter_get_xml_desc_args,
   sizeof(remote_nwfilter_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_nwfilter_get_xml_desc_ret,
   true,
   1
},
{ /* Method ConnectNumOfNWFilters => 178 */
   remoteDispatchConnectNumOfNWFiltersHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_connect_num_of_nwfilters_ret),
   (xdrproc_t)xdr_remote_connect_num_of_nwfilters_ret,
   true,
   1
},
{ /* Method ConnectListNWFilters => 179 */
   remoteDispatchConnectListNWFiltersHelper,
   sizeof(remote_connect_list_nwfilters_args),
   (xdrproc_t)xdr_remote_connect_list_nwfilters_args,
   sizeof(remote_connect_list_nwfilters_ret),
   (xdrproc_t)xdr_remote_connect_list_nwfilters_ret,
   true,
   1
},
{ /* Method NWFilterDefineXML => 180 */
   remoteDispatchNWFilterDefineXMLHelper,
   sizeof(remote_nwfilter_define_xml_args),
   (xdrproc_t)xdr_remote_nwfilter_define_xml_args,
   sizeof(remote_nwfilter_define_xml_ret),
   (xdrproc_t)xdr_remote_nwfilter_define_xml_ret,
   true,
   1
},
{ /* Method NWFilterUndefine => 181 */
   remoteDispatchNWFilterUndefineHelper,
   sizeof(remote_nwfilter_undefine_args),
   (xdrproc_t)xdr_remote_nwfilter_undefine_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method DomainManagedSave => 182 */
   remoteDispatchDomainManagedSaveHelper,
   sizeof(remote_domain_managed_save_args),
   (xdrproc_t)xdr_remote_domain_managed_save_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainHasManagedSaveImage => 183 */
   remoteDispatchDomainHasManagedSaveImageHelper,
   sizeof(remote_domain_has_managed_save_image_args),
   (xdrproc_t)xdr_remote_domain_has_managed_save_image_args,
   sizeof(remote_domain_has_managed_save_image_ret),
   (xdrproc_t)xdr_remote_domain_has_managed_save_image_ret,
   true,
   0
},
{ /* Method DomainManagedSaveRemove => 184 */
   remoteDispatchDomainManagedSaveRemoveHelper,
   sizeof(remote_domain_managed_save_remove_args),
   (xdrproc_t)xdr_remote_domain_managed_save_remove_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSnapshotCreateXML => 185 */
   remoteDispatchDomainSnapshotCreateXMLHelper,
   sizeof(remote_domain_snapshot_create_xml_args),
   (xdrproc_t)xdr_remote_domain_snapshot_create_xml_args,
   sizeof(remote_domain_snapshot_create_xml_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_create_xml_ret,
   true,
   0
},
{ /* Method DomainSnapshotGetXMLDesc => 186 */
   remoteDispatchDomainSnapshotGetXMLDescHelper,
   sizeof(remote_domain_snapshot_get_xml_desc_args),
   (xdrproc_t)xdr_remote_domain_snapshot_get_xml_desc_args,
   sizeof(remote_domain_snapshot_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_get_xml_desc_ret,
   true,
   1
},
{ /* Method DomainSnapshotNum => 187 */
   remoteDispatchDomainSnapshotNumHelper,
   sizeof(remote_domain_snapshot_num_args),
   (xdrproc_t)xdr_remote_domain_snapshot_num_args,
   sizeof(remote_domain_snapshot_num_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_num_ret,
   true,
   1
},
{ /* Method DomainSnapshotListNames => 188 */
   remoteDispatchDomainSnapshotListNamesHelper,
   sizeof(remote_domain_snapshot_list_names_args),
   (xdrproc_t)xdr_remote_domain_snapshot_list_names_args,
   sizeof(remote_domain_snapshot_list_names_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_list_names_ret,
   true,
   1
},
{ /* Method DomainSnapshotLookupByName => 189 */
   remoteDispatchDomainSnapshotLookupByNameHelper,
   sizeof(remote_domain_snapshot_lookup_by_name_args),
   (xdrproc_t)xdr_remote_domain_snapshot_lookup_by_name_args,
   sizeof(remote_domain_snapshot_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_lookup_by_name_ret,
   true,
   1
},
{ /* Method DomainHasCurrentSnapshot => 190 */
   remoteDispatchDomainHasCurrentSnapshotHelper,
   sizeof(remote_domain_has_current_snapshot_args),
   (xdrproc_t)xdr_remote_domain_has_current_snapshot_args,
   sizeof(remote_domain_has_current_snapshot_ret),
   (xdrproc_t)xdr_remote_domain_has_current_snapshot_ret,
   true,
   0
},
{ /* Method DomainSnapshotCurrent => 191 */
   remoteDispatchDomainSnapshotCurrentHelper,
   sizeof(remote_domain_snapshot_current_args),
   (xdrproc_t)xdr_remote_domain_snapshot_current_args,
   sizeof(remote_domain_snapshot_current_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_current_ret,
   true,
   0
},
{ /* Method DomainRevertToSnapshot => 192 */
   remoteDispatchDomainRevertToSnapshotHelper,
   sizeof(remote_domain_revert_to_snapshot_args),
   (xdrproc_t)xdr_remote_domain_revert_to_snapshot_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSnapshotDelete => 193 */
   remoteDispatchDomainSnapshotDeleteHelper,
   sizeof(remote_domain_snapshot_delete_args),
   (xdrproc_t)xdr_remote_domain_snapshot_delete_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetBlockInfo => 194 */
   remoteDispatchDomainGetBlockInfoHelper,
   sizeof(remote_domain_get_block_info_args),
   (xdrproc_t)xdr_remote_domain_get_block_info_args,
   sizeof(remote_domain_get_block_info_ret),
   (xdrproc_t)xdr_remote_domain_get_block_info_ret,
   true,
   0
},
{ /* Async event DomainEventIoErrorReason => 195 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainCreateWithFlags => 196 */
   remoteDispatchDomainCreateWithFlagsHelper,
   sizeof(remote_domain_create_with_flags_args),
   (xdrproc_t)xdr_remote_domain_create_with_flags_args,
   sizeof(remote_domain_create_with_flags_ret),
   (xdrproc_t)xdr_remote_domain_create_with_flags_ret,
   true,
   0
},
{ /* Method DomainSetMemoryParameters => 197 */
   remoteDispatchDomainSetMemoryParametersHelper,
   sizeof(remote_domain_set_memory_parameters_args),
   (xdrproc_t)xdr_remote_domain_set_memory_parameters_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetMemoryParameters => 198 */
   remoteDispatchDomainGetMemoryParametersHelper,
   sizeof(remote_domain_get_memory_parameters_args),
   (xdrproc_t)xdr_remote_domain_get_memory_parameters_args,
   sizeof(remote_domain_get_memory_parameters_ret),
   (xdrproc_t)xdr_remote_domain_get_memory_parameters_ret,
   true,
   0
},
{ /* Method DomainSetVcpusFlags => 199 */
   remoteDispatchDomainSetVcpusFlagsHelper,
   sizeof(remote_domain_set_vcpus_flags_args),
   (xdrproc_t)xdr_remote_domain_set_vcpus_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetVcpusFlags => 200 */
   remoteDispatchDomainGetVcpusFlagsHelper,
   sizeof(remote_domain_get_vcpus_flags_args),
   (xdrproc_t)xdr_remote_domain_get_vcpus_flags_args,
   sizeof(remote_domain_get_vcpus_flags_ret),
   (xdrproc_t)xdr_remote_domain_get_vcpus_flags_ret,
   true,
   0
},
{ /* Method DomainOpenConsole => 201 */
   remoteDispatchDomainOpenConsoleHelper,
   sizeof(remote_domain_open_console_args),
   (xdrproc_t)xdr_remote_domain_open_console_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainIsUpdated => 202 */
   remoteDispatchDomainIsUpdatedHelper,
   sizeof(remote_domain_is_updated_args),
   (xdrproc_t)xdr_remote_domain_is_updated_args,
   sizeof(remote_domain_is_updated_ret),
   (xdrproc_t)xdr_remote_domain_is_updated_ret,
   true,
   1
},
{ /* Method ConnectGetSysinfo => 203 */
   remoteDispatchConnectGetSysinfoHelper,
   sizeof(remote_connect_get_sysinfo_args),
   (xdrproc_t)xdr_remote_connect_get_sysinfo_args,
   sizeof(remote_connect_get_sysinfo_ret),
   (xdrproc_t)xdr_remote_connect_get_sysinfo_ret,
   true,
   1
},
{ /* Method DomainSetMemoryFlags => 204 */
   remoteDispatchDomainSetMemoryFlagsHelper,
   sizeof(remote_domain_set_memory_flags_args),
   (xdrproc_t)xdr_remote_domain_set_memory_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetBlkioParameters => 205 */
   remoteDispatchDomainSetBlkioParametersHelper,
   sizeof(remote_domain_set_blkio_parameters_args),
   (xdrproc_t)xdr_remote_domain_set_blkio_parameters_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetBlkioParameters => 206 */
   remoteDispatchDomainGetBlkioParametersHelper,
   sizeof(remote_domain_get_blkio_parameters_args),
   (xdrproc_t)xdr_remote_domain_get_blkio_parameters_args,
   sizeof(remote_domain_get_blkio_parameters_ret),
   (xdrproc_t)xdr_remote_domain_get_blkio_parameters_ret,
   true,
   0
},
{ /* Method DomainMigrateSetMaxSpeed => 207 */
   remoteDispatchDomainMigrateSetMaxSpeedHelper,
   sizeof(remote_domain_migrate_set_max_speed_args),
   (xdrproc_t)xdr_remote_domain_migrate_set_max_speed_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StorageVolUpload => 208 */
   remoteDispatchStorageVolUploadHelper,
   sizeof(remote_storage_vol_upload_args),
   (xdrproc_t)xdr_remote_storage_vol_upload_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StorageVolDownload => 209 */
   remoteDispatchStorageVolDownloadHelper,
   sizeof(remote_storage_vol_download_args),
   (xdrproc_t)xdr_remote_storage_vol_download_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainInjectNMI => 210 */
   remoteDispatchDomainInjectNMIHelper,
   sizeof(remote_domain_inject_nmi_args),
   (xdrproc_t)xdr_remote_domain_inject_nmi_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainScreenshot => 211 */
   remoteDispatchDomainScreenshotHelper,
   sizeof(remote_domain_screenshot_args),
   (xdrproc_t)xdr_remote_domain_screenshot_args,
   sizeof(remote_domain_screenshot_ret),
   (xdrproc_t)xdr_remote_domain_screenshot_ret,
   true,
   0
},
{ /* Method DomainGetState => 212 */
   remoteDispatchDomainGetStateHelper,
   sizeof(remote_domain_get_state_args),
   (xdrproc_t)xdr_remote_domain_get_state_args,
   sizeof(remote_domain_get_state_ret),
   (xdrproc_t)xdr_remote_domain_get_state_ret,
   true,
   1
},
{ /* Method DomainMigrateBegin3 => 213 */
   remoteDispatchDomainMigrateBegin3Helper,
   sizeof(remote_domain_migrate_begin3_args),
   (xdrproc_t)xdr_remote_domain_migrate_begin3_args,
   sizeof(remote_domain_migrate_begin3_ret),
   (xdrproc_t)xdr_remote_domain_migrate_begin3_ret,
   true,
   0
},
{ /* Method DomainMigratePrepare3 => 214 */
   remoteDispatchDomainMigratePrepare3Helper,
   sizeof(remote_domain_migrate_prepare3_args),
   (xdrproc_t)xdr_remote_domain_migrate_prepare3_args,
   sizeof(remote_domain_migrate_prepare3_ret),
   (xdrproc_t)xdr_remote_domain_migrate_prepare3_ret,
   true,
   0
},
{ /* Method DomainMigratePrepareTunnel3 => 215 */
   remoteDispatchDomainMigratePrepareTunnel3Helper,
   sizeof(remote_domain_migrate_prepare_tunnel3_args),
   (xdrproc_t)xdr_remote_domain_migrate_prepare_tunnel3_args,
   sizeof(remote_domain_migrate_prepare_tunnel3_ret),
   (xdrproc_t)xdr_remote_domain_migrate_prepare_tunnel3_ret,
   true,
   0
},
{ /* Method DomainMigratePerform3 => 216 */
   remoteDispatchDomainMigratePerform3Helper,
   sizeof(remote_domain_migrate_perform3_args),
   (xdrproc_t)xdr_remote_domain_migrate_perform3_args,
   sizeof(remote_domain_migrate_perform3_ret),
   (xdrproc_t)xdr_remote_domain_migrate_perform3_ret,
   true,
   0
},
{ /* Method DomainMigrateFinish3 => 217 */
   remoteDispatchDomainMigrateFinish3Helper,
   sizeof(remote_domain_migrate_finish3_args),
   (xdrproc_t)xdr_remote_domain_migrate_finish3_args,
   sizeof(remote_domain_migrate_finish3_ret),
   (xdrproc_t)xdr_remote_domain_migrate_finish3_ret,
   true,
   0
},
{ /* Method DomainMigrateConfirm3 => 218 */
   remoteDispatchDomainMigrateConfirm3Helper,
   sizeof(remote_domain_migrate_confirm3_args),
   (xdrproc_t)xdr_remote_domain_migrate_confirm3_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetSchedulerParametersFlags => 219 */
   remoteDispatchDomainSetSchedulerParametersFlagsHelper,
   sizeof(remote_domain_set_scheduler_parameters_flags_args),
   (xdrproc_t)xdr_remote_domain_set_scheduler_parameters_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method InterfaceChangeBegin => 220 */
   remoteDispatchInterfaceChangeBeginHelper,
   sizeof(remote_interface_change_begin_args),
   (xdrproc_t)xdr_remote_interface_change_begin_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method InterfaceChangeCommit => 221 */
   remoteDispatchInterfaceChangeCommitHelper,
   sizeof(remote_interface_change_commit_args),
   (xdrproc_t)xdr_remote_interface_change_commit_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method InterfaceChangeRollback => 222 */
   remoteDispatchInterfaceChangeRollbackHelper,
   sizeof(remote_interface_change_rollback_args),
   (xdrproc_t)xdr_remote_interface_change_rollback_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetSchedulerParametersFlags => 223 */
   remoteDispatchDomainGetSchedulerParametersFlagsHelper,
   sizeof(remote_domain_get_scheduler_parameters_flags_args),
   (xdrproc_t)xdr_remote_domain_get_scheduler_parameters_flags_args,
   sizeof(remote_domain_get_scheduler_parameters_flags_ret),
   (xdrproc_t)xdr_remote_domain_get_scheduler_parameters_flags_ret,
   true,
   0
},
{ /* Async event DomainEventControlError => 224 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainPinVcpuFlags => 225 */
   remoteDispatchDomainPinVcpuFlagsHelper,
   sizeof(remote_domain_pin_vcpu_flags_args),
   (xdrproc_t)xdr_remote_domain_pin_vcpu_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSendKey => 226 */
   remoteDispatchDomainSendKeyHelper,
   sizeof(remote_domain_send_key_args),
   (xdrproc_t)xdr_remote_domain_send_key_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeGetCPUStats => 227 */
   remoteDispatchNodeGetCPUStatsHelper,
   sizeof(remote_node_get_cpu_stats_args),
   (xdrproc_t)xdr_remote_node_get_cpu_stats_args,
   sizeof(remote_node_get_cpu_stats_ret),
   (xdrproc_t)xdr_remote_node_get_cpu_stats_ret,
   true,
   1
},
{ /* Method NodeGetMemoryStats => 228 */
   remoteDispatchNodeGetMemoryStatsHelper,
   sizeof(remote_node_get_memory_stats_args),
   (xdrproc_t)xdr_remote_node_get_memory_stats_args,
   sizeof(remote_node_get_memory_stats_ret),
   (xdrproc_t)xdr_remote_node_get_memory_stats_ret,
   true,
   1
},
{ /* Method DomainGetControlInfo => 229 */
   remoteDispatchDomainGetControlInfoHelper,
   sizeof(remote_domain_get_control_info_args),
   (xdrproc_t)xdr_remote_domain_get_control_info_args,
   sizeof(remote_domain_get_control_info_ret),
   (xdrproc_t)xdr_remote_domain_get_control_info_ret,
   true,
   1
},
{ /* Method DomainGetVcpuPinInfo => 230 */
   remoteDispatchDomainGetVcpuPinInfoHelper,
   sizeof(remote_domain_get_vcpu_pin_info_args),
   (xdrproc_t)xdr_remote_domain_get_vcpu_pin_info_args,
   sizeof(remote_domain_get_vcpu_pin_info_ret),
   (xdrproc_t)xdr_remote_domain_get_vcpu_pin_info_ret,
   true,
   0
},
{ /* Method DomainUndefineFlags => 231 */
   remoteDispatchDomainUndefineFlagsHelper,
   sizeof(remote_domain_undefine_flags_args),
   (xdrproc_t)xdr_remote_domain_undefine_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method DomainSaveFlags => 232 */
   remoteDispatchDomainSaveFlagsHelper,
   sizeof(remote_domain_save_flags_args),
   (xdrproc_t)xdr_remote_domain_save_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainRestoreFlags => 233 */
   remoteDispatchDomainRestoreFlagsHelper,
   sizeof(remote_domain_restore_flags_args),
   (xdrproc_t)xdr_remote_domain_restore_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainDestroyFlags => 234 */
   remoteDispatchDomainDestroyFlagsHelper,
   sizeof(remote_domain_destroy_flags_args),
   (xdrproc_t)xdr_remote_domain_destroy_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method DomainSaveImageGetXMLDesc => 235 */
   remoteDispatchDomainSaveImageGetXMLDescHelper,
   sizeof(remote_domain_save_image_get_xml_desc_args),
   (xdrproc_t)xdr_remote_domain_save_image_get_xml_desc_args,
   sizeof(remote_domain_save_image_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_domain_save_image_get_xml_desc_ret,
   true,
   1
},
{ /* Method DomainSaveImageDefineXML => 236 */
   remoteDispatchDomainSaveImageDefineXMLHelper,
   sizeof(remote_domain_save_image_define_xml_args),
   (xdrproc_t)xdr_remote_domain_save_image_define_xml_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Method DomainBlockJobAbort => 237 */
   remoteDispatchDomainBlockJobAbortHelper,
   sizeof(remote_domain_block_job_abort_args),
   (xdrproc_t)xdr_remote_domain_block_job_abort_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetBlockJobInfo => 238 */
   remoteDispatchDomainGetBlockJobInfoHelper,
   sizeof(remote_domain_get_block_job_info_args),
   (xdrproc_t)xdr_remote_domain_get_block_job_info_args,
   sizeof(remote_domain_get_block_job_info_ret),
   (xdrproc_t)xdr_remote_domain_get_block_job_info_ret,
   true,
   0
},
{ /* Method DomainBlockJobSetSpeed => 239 */
   remoteDispatchDomainBlockJobSetSpeedHelper,
   sizeof(remote_domain_block_job_set_speed_args),
   (xdrproc_t)xdr_remote_domain_block_job_set_speed_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainBlockPull => 240 */
   remoteDispatchDomainBlockPullHelper,
   sizeof(remote_domain_block_pull_args),
   (xdrproc_t)xdr_remote_domain_block_pull_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventBlockJob => 241 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainMigrateGetMaxSpeed => 242 */
   remoteDispatchDomainMigrateGetMaxSpeedHelper,
   sizeof(remote_domain_migrate_get_max_speed_args),
   (xdrproc_t)xdr_remote_domain_migrate_get_max_speed_args,
   sizeof(remote_domain_migrate_get_max_speed_ret),
   (xdrproc_t)xdr_remote_domain_migrate_get_max_speed_ret,
   true,
   0
},
{ /* Method DomainBlockStatsFlags => 243 */
   remoteDispatchDomainBlockStatsFlagsHelper,
   sizeof(remote_domain_block_stats_flags_args),
   (xdrproc_t)xdr_remote_domain_block_stats_flags_args,
   sizeof(remote_domain_block_stats_flags_ret),
   (xdrproc_t)xdr_remote_domain_block_stats_flags_ret,
   true,
   0
},
{ /* Method DomainSnapshotGetParent => 244 */
   remoteDispatchDomainSnapshotGetParentHelper,
   sizeof(remote_domain_snapshot_get_parent_args),
   (xdrproc_t)xdr_remote_domain_snapshot_get_parent_args,
   sizeof(remote_domain_snapshot_get_parent_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_get_parent_ret,
   true,
   1
},
{ /* Method DomainReset => 245 */
   remoteDispatchDomainResetHelper,
   sizeof(remote_domain_reset_args),
   (xdrproc_t)xdr_remote_domain_reset_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSnapshotNumChildren => 246 */
   remoteDispatchDomainSnapshotNumChildrenHelper,
   sizeof(remote_domain_snapshot_num_children_args),
   (xdrproc_t)xdr_remote_domain_snapshot_num_children_args,
   sizeof(remote_domain_snapshot_num_children_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_num_children_ret,
   true,
   1
},
{ /* Method DomainSnapshotListChildrenNames => 247 */
   remoteDispatchDomainSnapshotListChildrenNamesHelper,
   sizeof(remote_domain_snapshot_list_children_names_args),
   (xdrproc_t)xdr_remote_domain_snapshot_list_children_names_args,
   sizeof(remote_domain_snapshot_list_children_names_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_list_children_names_ret,
   true,
   1
},
{ /* Async event DomainEventDiskChange => 248 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainOpenGraphics => 249 */
   remoteDispatchDomainOpenGraphicsHelper,
   sizeof(remote_domain_open_graphics_args),
   (xdrproc_t)xdr_remote_domain_open_graphics_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeSuspendForDuration => 250 */
   remoteDispatchNodeSuspendForDurationHelper,
   sizeof(remote_node_suspend_for_duration_args),
   (xdrproc_t)xdr_remote_node_suspend_for_duration_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainBlockResize => 251 */
   remoteDispatchDomainBlockResizeHelper,
   sizeof(remote_domain_block_resize_args),
   (xdrproc_t)xdr_remote_domain_block_resize_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetBlockIoTune => 252 */
   remoteDispatchDomainSetBlockIoTuneHelper,
   sizeof(remote_domain_set_block_io_tune_args),
   (xdrproc_t)xdr_remote_domain_set_block_io_tune_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetBlockIoTune => 253 */
   remoteDispatchDomainGetBlockIoTuneHelper,
   sizeof(remote_domain_get_block_io_tune_args),
   (xdrproc_t)xdr_remote_domain_get_block_io_tune_args,
   sizeof(remote_domain_get_block_io_tune_ret),
   (xdrproc_t)xdr_remote_domain_get_block_io_tune_ret,
   true,
   0
},
{ /* Method DomainSetNumaParameters => 254 */
   remoteDispatchDomainSetNumaParametersHelper,
   sizeof(remote_domain_set_numa_parameters_args),
   (xdrproc_t)xdr_remote_domain_set_numa_parameters_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetNumaParameters => 255 */
   remoteDispatchDomainGetNumaParametersHelper,
   sizeof(remote_domain_get_numa_parameters_args),
   (xdrproc_t)xdr_remote_domain_get_numa_parameters_args,
   sizeof(remote_domain_get_numa_parameters_ret),
   (xdrproc_t)xdr_remote_domain_get_numa_parameters_ret,
   true,
   0
},
{ /* Method DomainSetInterfaceParameters => 256 */
   remoteDispatchDomainSetInterfaceParametersHelper,
   sizeof(remote_domain_set_interface_parameters_args),
   (xdrproc_t)xdr_remote_domain_set_interface_parameters_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetInterfaceParameters => 257 */
   remoteDispatchDomainGetInterfaceParametersHelper,
   sizeof(remote_domain_get_interface_parameters_args),
   (xdrproc_t)xdr_remote_domain_get_interface_parameters_args,
   sizeof(remote_domain_get_interface_parameters_ret),
   (xdrproc_t)xdr_remote_domain_get_interface_parameters_ret,
   true,
   0
},
{ /* Method DomainShutdownFlags => 258 */
   remoteDispatchDomainShutdownFlagsHelper,
   sizeof(remote_domain_shutdown_flags_args),
   (xdrproc_t)xdr_remote_domain_shutdown_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StorageVolWipePattern => 259 */
   remoteDispatchStorageVolWipePatternHelper,
   sizeof(remote_storage_vol_wipe_pattern_args),
   (xdrproc_t)xdr_remote_storage_vol_wipe_pattern_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StorageVolResize => 260 */
   remoteDispatchStorageVolResizeHelper,
   sizeof(remote_storage_vol_resize_args),
   (xdrproc_t)xdr_remote_storage_vol_resize_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainPMSuspendForDuration => 261 */
   remoteDispatchDomainPMSuspendForDurationHelper,
   sizeof(remote_domain_pm_suspend_for_duration_args),
   (xdrproc_t)xdr_remote_domain_pm_suspend_for_duration_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetCPUStats => 262 */
   remoteDispatchDomainGetCPUStatsHelper,
   sizeof(remote_domain_get_cpu_stats_args),
   (xdrproc_t)xdr_remote_domain_get_cpu_stats_args,
   sizeof(remote_domain_get_cpu_stats_ret),
   (xdrproc_t)xdr_remote_domain_get_cpu_stats_ret,
   true,
   0
},
{ /* Method DomainGetDiskErrors => 263 */
   remoteDispatchDomainGetDiskErrorsHelper,
   sizeof(remote_domain_get_disk_errors_args),
   (xdrproc_t)xdr_remote_domain_get_disk_errors_args,
   sizeof(remote_domain_get_disk_errors_ret),
   (xdrproc_t)xdr_remote_domain_get_disk_errors_ret,
   true,
   0
},
{ /* Method DomainSetMetadata => 264 */
   remoteDispatchDomainSetMetadataHelper,
   sizeof(remote_domain_set_metadata_args),
   (xdrproc_t)xdr_remote_domain_set_metadata_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetMetadata => 265 */
   remoteDispatchDomainGetMetadataHelper,
   sizeof(remote_domain_get_metadata_args),
   (xdrproc_t)xdr_remote_domain_get_metadata_args,
   sizeof(remote_domain_get_metadata_ret),
   (xdrproc_t)xdr_remote_domain_get_metadata_ret,
   true,
   0
},
{ /* Method DomainBlockRebase => 266 */
   remoteDispatchDomainBlockRebaseHelper,
   sizeof(remote_domain_block_rebase_args),
   (xdrproc_t)xdr_remote_domain_block_rebase_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainPMWakeup => 267 */
   remoteDispatchDomainPMWakeupHelper,
   sizeof(remote_domain_pm_wakeup_args),
   (xdrproc_t)xdr_remote_domain_pm_wakeup_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventTrayChange => 268 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventPMwakeup => 269 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventPMsuspend => 270 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSnapshotIsCurrent => 271 */
   remoteDispatchDomainSnapshotIsCurrentHelper,
   sizeof(remote_domain_snapshot_is_current_args),
   (xdrproc_t)xdr_remote_domain_snapshot_is_current_args,
   sizeof(remote_domain_snapshot_is_current_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_is_current_ret,
   true,
   0
},
{ /* Method DomainSnapshotHasMetadata => 272 */
   remoteDispatchDomainSnapshotHasMetadataHelper,
   sizeof(remote_domain_snapshot_has_metadata_args),
   (xdrproc_t)xdr_remote_domain_snapshot_has_metadata_args,
   sizeof(remote_domain_snapshot_has_metadata_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_has_metadata_ret,
   true,
   0
},
{ /* Method ConnectListAllDomains => 273 */
   remoteDispatchConnectListAllDomainsHelper,
   sizeof(remote_connect_list_all_domains_args),
   (xdrproc_t)xdr_remote_connect_list_all_domains_args,
   sizeof(remote_connect_list_all_domains_ret),
   (xdrproc_t)xdr_remote_connect_list_all_domains_ret,
   true,
   1
},
{ /* Method DomainListAllSnapshots => 274 */
   remoteDispatchDomainListAllSnapshotsHelper,
   sizeof(remote_domain_list_all_snapshots_args),
   (xdrproc_t)xdr_remote_domain_list_all_snapshots_args,
   sizeof(remote_domain_list_all_snapshots_ret),
   (xdrproc_t)xdr_remote_domain_list_all_snapshots_ret,
   true,
   1
},
{ /* Method DomainSnapshotListAllChildren => 275 */
   remoteDispatchDomainSnapshotListAllChildrenHelper,
   sizeof(remote_domain_snapshot_list_all_children_args),
   (xdrproc_t)xdr_remote_domain_snapshot_list_all_children_args,
   sizeof(remote_domain_snapshot_list_all_children_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_list_all_children_ret,
   true,
   1
},
{ /* Async event DomainEventBalloonChange => 276 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetHostname => 277 */
   remoteDispatchDomainGetHostnameHelper,
   sizeof(remote_domain_get_hostname_args),
   (xdrproc_t)xdr_remote_domain_get_hostname_args,
   sizeof(remote_domain_get_hostname_ret),
   (xdrproc_t)xdr_remote_domain_get_hostname_ret,
   true,
   0
},
{ /* Method DomainGetSecurityLabelList => 278 */
   remoteDispatchDomainGetSecurityLabelListHelper,
   sizeof(remote_domain_get_security_label_list_args),
   (xdrproc_t)xdr_remote_domain_get_security_label_list_args,
   sizeof(remote_domain_get_security_label_list_ret),
   (xdrproc_t)xdr_remote_domain_get_security_label_list_ret,
   true,
   1
},
{ /* Method DomainPinEmulator => 279 */
   remoteDispatchDomainPinEmulatorHelper,
   sizeof(remote_domain_pin_emulator_args),
   (xdrproc_t)xdr_remote_domain_pin_emulator_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetEmulatorPinInfo => 280 */
   remoteDispatchDomainGetEmulatorPinInfoHelper,
   sizeof(remote_domain_get_emulator_pin_info_args),
   (xdrproc_t)xdr_remote_domain_get_emulator_pin_info_args,
   sizeof(remote_domain_get_emulator_pin_info_ret),
   (xdrproc_t)xdr_remote_domain_get_emulator_pin_info_ret,
   true,
   0
},
{ /* Method ConnectListAllStoragePools => 281 */
   remoteDispatchConnectListAllStoragePoolsHelper,
   sizeof(remote_connect_list_all_storage_pools_args),
   (xdrproc_t)xdr_remote_connect_list_all_storage_pools_args,
   sizeof(remote_connect_list_all_storage_pools_ret),
   (xdrproc_t)xdr_remote_connect_list_all_storage_pools_ret,
   true,
   1
},
{ /* Method StoragePoolListAllVolumes => 282 */
   remoteDispatchStoragePoolListAllVolumesHelper,
   sizeof(remote_storage_pool_list_all_volumes_args),
   (xdrproc_t)xdr_remote_storage_pool_list_all_volumes_args,
   sizeof(remote_storage_pool_list_all_volumes_ret),
   (xdrproc_t)xdr_remote_storage_pool_list_all_volumes_ret,
   true,
   1
},
{ /* Method ConnectListAllNetworks => 283 */
   remoteDispatchConnectListAllNetworksHelper,
   sizeof(remote_connect_list_all_networks_args),
   (xdrproc_t)xdr_remote_connect_list_all_networks_args,
   sizeof(remote_connect_list_all_networks_ret),
   (xdrproc_t)xdr_remote_connect_list_all_networks_ret,
   true,
   1
},
{ /* Method ConnectListAllInterfaces => 284 */
   remoteDispatchConnectListAllInterfacesHelper,
   sizeof(remote_connect_list_all_interfaces_args),
   (xdrproc_t)xdr_remote_connect_list_all_interfaces_args,
   sizeof(remote_connect_list_all_interfaces_ret),
   (xdrproc_t)xdr_remote_connect_list_all_interfaces_ret,
   true,
   1
},
{ /* Method ConnectListAllNodeDevices => 285 */
   remoteDispatchConnectListAllNodeDevicesHelper,
   sizeof(remote_connect_list_all_node_devices_args),
   (xdrproc_t)xdr_remote_connect_list_all_node_devices_args,
   sizeof(remote_connect_list_all_node_devices_ret),
   (xdrproc_t)xdr_remote_connect_list_all_node_devices_ret,
   true,
   1
},
{ /* Method ConnectListAllNWFilters => 286 */
   remoteDispatchConnectListAllNWFiltersHelper,
   sizeof(remote_connect_list_all_nwfilters_args),
   (xdrproc_t)xdr_remote_connect_list_all_nwfilters_args,
   sizeof(remote_connect_list_all_nwfilters_ret),
   (xdrproc_t)xdr_remote_connect_list_all_nwfilters_ret,
   true,
   1
},
{ /* Method ConnectListAllSecrets => 287 */
   remoteDispatchConnectListAllSecretsHelper,
   sizeof(remote_connect_list_all_secrets_args),
   (xdrproc_t)xdr_remote_connect_list_all_secrets_args,
   sizeof(remote_connect_list_all_secrets_ret),
   (xdrproc_t)xdr_remote_connect_list_all_secrets_ret,
   true,
   1
},
{ /* Method NodeSetMemoryParameters => 288 */
   remoteDispatchNodeSetMemoryParametersHelper,
   sizeof(remote_node_set_memory_parameters_args),
   (xdrproc_t)xdr_remote_node_set_memory_parameters_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeGetMemoryParameters => 289 */
   remoteDispatchNodeGetMemoryParametersHelper,
   sizeof(remote_node_get_memory_parameters_args),
   (xdrproc_t)xdr_remote_node_get_memory_parameters_args,
   sizeof(remote_node_get_memory_parameters_ret),
   (xdrproc_t)xdr_remote_node_get_memory_parameters_ret,
   true,
   0
},
{ /* Method DomainBlockCommit => 290 */
   remoteDispatchDomainBlockCommitHelper,
   sizeof(remote_domain_block_commit_args),
   (xdrproc_t)xdr_remote_domain_block_commit_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NetworkUpdate => 291 */
   remoteDispatchNetworkUpdateHelper,
   sizeof(remote_network_update_args),
   (xdrproc_t)xdr_remote_network_update_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Async event DomainEventPMsuspendDisk => 292 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeGetCPUMap => 293 */
   remoteDispatchNodeGetCPUMapHelper,
   sizeof(remote_node_get_cpu_map_args),
   (xdrproc_t)xdr_remote_node_get_cpu_map_args,
   sizeof(remote_node_get_cpu_map_ret),
   (xdrproc_t)xdr_remote_node_get_cpu_map_ret,
   true,
   0
},
{ /* Method DomainFSTrim => 294 */
   remoteDispatchDomainFSTrimHelper,
   sizeof(remote_domain_fstrim_args),
   (xdrproc_t)xdr_remote_domain_fstrim_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSendProcessSignal => 295 */
   remoteDispatchDomainSendProcessSignalHelper,
   sizeof(remote_domain_send_process_signal_args),
   (xdrproc_t)xdr_remote_domain_send_process_signal_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainOpenChannel => 296 */
   remoteDispatchDomainOpenChannelHelper,
   sizeof(remote_domain_open_channel_args),
   (xdrproc_t)xdr_remote_domain_open_channel_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeDeviceLookupSCSIHostByWWN => 297 */
   remoteDispatchNodeDeviceLookupSCSIHostByWWNHelper,
   sizeof(remote_node_device_lookup_scsi_host_by_wwn_args),
   (xdrproc_t)xdr_remote_node_device_lookup_scsi_host_by_wwn_args,
   sizeof(remote_node_device_lookup_scsi_host_by_wwn_ret),
   (xdrproc_t)xdr_remote_node_device_lookup_scsi_host_by_wwn_ret,
   true,
   1
},
{ /* Method DomainGetJobStats => 298 */
   remoteDispatchDomainGetJobStatsHelper,
   sizeof(remote_domain_get_job_stats_args),
   (xdrproc_t)xdr_remote_domain_get_job_stats_args,
   sizeof(remote_domain_get_job_stats_ret),
   (xdrproc_t)xdr_remote_domain_get_job_stats_ret,
   true,
   0
},
{ /* Method DomainMigrateGetCompressionCache => 299 */
   remoteDispatchDomainMigrateGetCompressionCacheHelper,
   sizeof(remote_domain_migrate_get_compression_cache_args),
   (xdrproc_t)xdr_remote_domain_migrate_get_compression_cache_args,
   sizeof(remote_domain_migrate_get_compression_cache_ret),
   (xdrproc_t)xdr_remote_domain_migrate_get_compression_cache_ret,
   true,
   0
},
{ /* Method DomainMigrateSetCompressionCache => 300 */
   remoteDispatchDomainMigrateSetCompressionCacheHelper,
   sizeof(remote_domain_migrate_set_compression_cache_args),
   (xdrproc_t)xdr_remote_domain_migrate_set_compression_cache_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeDeviceDetachFlags => 301 */
   remoteDispatchNodeDeviceDetachFlagsHelper,
   sizeof(remote_node_device_detach_flags_args),
   (xdrproc_t)xdr_remote_node_device_detach_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainMigrateBegin3Params => 302 */
   remoteDispatchDomainMigrateBegin3ParamsHelper,
   sizeof(remote_domain_migrate_begin3_params_args),
   (xdrproc_t)xdr_remote_domain_migrate_begin3_params_args,
   sizeof(remote_domain_migrate_begin3_params_ret),
   (xdrproc_t)xdr_remote_domain_migrate_begin3_params_ret,
   true,
   0
},
{ /* Method DomainMigratePrepare3Params => 303 */
   remoteDispatchDomainMigratePrepare3ParamsHelper,
   sizeof(remote_domain_migrate_prepare3_params_args),
   (xdrproc_t)xdr_remote_domain_migrate_prepare3_params_args,
   sizeof(remote_domain_migrate_prepare3_params_ret),
   (xdrproc_t)xdr_remote_domain_migrate_prepare3_params_ret,
   true,
   0
},
{ /* Method DomainMigratePrepareTunnel3Params => 304 */
   remoteDispatchDomainMigratePrepareTunnel3ParamsHelper,
   sizeof(remote_domain_migrate_prepare_tunnel3_params_args),
   (xdrproc_t)xdr_remote_domain_migrate_prepare_tunnel3_params_args,
   sizeof(remote_domain_migrate_prepare_tunnel3_params_ret),
   (xdrproc_t)xdr_remote_domain_migrate_prepare_tunnel3_params_ret,
   true,
   0
},
{ /* Method DomainMigratePerform3Params => 305 */
   remoteDispatchDomainMigratePerform3ParamsHelper,
   sizeof(remote_domain_migrate_perform3_params_args),
   (xdrproc_t)xdr_remote_domain_migrate_perform3_params_args,
   sizeof(remote_domain_migrate_perform3_params_ret),
   (xdrproc_t)xdr_remote_domain_migrate_perform3_params_ret,
   true,
   0
},
{ /* Method DomainMigrateFinish3Params => 306 */
   remoteDispatchDomainMigrateFinish3ParamsHelper,
   sizeof(remote_domain_migrate_finish3_params_args),
   (xdrproc_t)xdr_remote_domain_migrate_finish3_params_args,
   sizeof(remote_domain_migrate_finish3_params_ret),
   (xdrproc_t)xdr_remote_domain_migrate_finish3_params_ret,
   true,
   0
},
{ /* Method DomainMigrateConfirm3Params => 307 */
   remoteDispatchDomainMigrateConfirm3ParamsHelper,
   sizeof(remote_domain_migrate_confirm3_params_args),
   (xdrproc_t)xdr_remote_domain_migrate_confirm3_params_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetMemoryStatsPeriod => 308 */
   remoteDispatchDomainSetMemoryStatsPeriodHelper,
   sizeof(remote_domain_set_memory_stats_period_args),
   (xdrproc_t)xdr_remote_domain_set_memory_stats_period_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainCreateXMLWithFiles => 309 */
   remoteDispatchDomainCreateXMLWithFilesHelper,
   sizeof(remote_domain_create_xml_with_files_args),
   (xdrproc_t)xdr_remote_domain_create_xml_with_files_args,
   sizeof(remote_domain_create_xml_with_files_ret),
   (xdrproc_t)xdr_remote_domain_create_xml_with_files_ret,
   true,
   0
},
{ /* Method DomainCreateWithFiles => 310 */
   remoteDispatchDomainCreateWithFilesHelper,
   sizeof(remote_domain_create_with_files_args),
   (xdrproc_t)xdr_remote_domain_create_with_files_args,
   sizeof(remote_domain_create_with_files_ret),
   (xdrproc_t)xdr_remote_domain_create_with_files_ret,
   true,
   0
},
{ /* Async event DomainEventDeviceRemoved => 311 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectGetCPUModelNames => 312 */
   remoteDispatchConnectGetCPUModelNamesHelper,
   sizeof(remote_connect_get_cpu_model_names_args),
   (xdrproc_t)xdr_remote_connect_get_cpu_model_names_args,
   sizeof(remote_connect_get_cpu_model_names_ret),
   (xdrproc_t)xdr_remote_connect_get_cpu_model_names_ret,
   true,
   0
},
{ /* Method ConnectNetworkEventRegisterAny => 313 */
   remoteDispatchConnectNetworkEventRegisterAnyHelper,
   sizeof(remote_connect_network_event_register_any_args),
   (xdrproc_t)xdr_remote_connect_network_event_register_any_args,
   sizeof(remote_connect_network_event_register_any_ret),
   (xdrproc_t)xdr_remote_connect_network_event_register_any_ret,
   true,
   1
},
{ /* Method ConnectNetworkEventDeregisterAny => 314 */
   remoteDispatchConnectNetworkEventDeregisterAnyHelper,
   sizeof(remote_connect_network_event_deregister_any_args),
   (xdrproc_t)xdr_remote_connect_network_event_deregister_any_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Async event NetworkEventLifecycle => 315 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectDomainEventCallbackRegisterAny => 316 */
   remoteDispatchConnectDomainEventCallbackRegisterAnyHelper,
   sizeof(remote_connect_domain_event_callback_register_any_args),
   (xdrproc_t)xdr_remote_connect_domain_event_callback_register_any_args,
   sizeof(remote_connect_domain_event_callback_register_any_ret),
   (xdrproc_t)xdr_remote_connect_domain_event_callback_register_any_ret,
   true,
   1
},
{ /* Method ConnectDomainEventCallbackDeregisterAny => 317 */
   remoteDispatchConnectDomainEventCallbackDeregisterAnyHelper,
   sizeof(remote_connect_domain_event_callback_deregister_any_args),
   (xdrproc_t)xdr_remote_connect_domain_event_callback_deregister_any_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Async event DomainEventCallbackLifecycle => 318 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackReboot => 319 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackRtcChange => 320 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackWatchdog => 321 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackIoError => 322 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackGraphics => 323 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackIoErrorReason => 324 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackControlError => 325 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackBlockJob => 326 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackDiskChange => 327 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackTrayChange => 328 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackPMwakeup => 329 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackPMsuspend => 330 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackBalloonChange => 331 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackPMsuspendDisk => 332 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackDeviceRemoved => 333 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainCoreDumpWithFormat => 334 */
   remoteDispatchDomainCoreDumpWithFormatHelper,
   sizeof(remote_domain_core_dump_with_format_args),
   (xdrproc_t)xdr_remote_domain_core_dump_with_format_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainFSFreeze => 335 */
   remoteDispatchDomainFSFreezeHelper,
   sizeof(remote_domain_fsfreeze_args),
   (xdrproc_t)xdr_remote_domain_fsfreeze_args,
   sizeof(remote_domain_fsfreeze_ret),
   (xdrproc_t)xdr_remote_domain_fsfreeze_ret,
   true,
   0
},
{ /* Method DomainFSThaw => 336 */
   remoteDispatchDomainFSThawHelper,
   sizeof(remote_domain_fsthaw_args),
   (xdrproc_t)xdr_remote_domain_fsthaw_args,
   sizeof(remote_domain_fsthaw_ret),
   (xdrproc_t)xdr_remote_domain_fsthaw_ret,
   true,
   0
},
{ /* Method DomainGetTime => 337 */
   remoteDispatchDomainGetTimeHelper,
   sizeof(remote_domain_get_time_args),
   (xdrproc_t)xdr_remote_domain_get_time_args,
   sizeof(remote_domain_get_time_ret),
   (xdrproc_t)xdr_remote_domain_get_time_ret,
   true,
   0
},
{ /* Method DomainSetTime => 338 */
   remoteDispatchDomainSetTimeHelper,
   sizeof(remote_domain_set_time_args),
   (xdrproc_t)xdr_remote_domain_set_time_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventBlockJob2 => 339 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeGetFreePages => 340 */
   remoteDispatchNodeGetFreePagesHelper,
   sizeof(remote_node_get_free_pages_args),
   (xdrproc_t)xdr_remote_node_get_free_pages_args,
   sizeof(remote_node_get_free_pages_ret),
   (xdrproc_t)xdr_remote_node_get_free_pages_ret,
   true,
   1
},
{ /* Method NetworkGetDHCPLeases => 341 */
   remoteDispatchNetworkGetDHCPLeasesHelper,
   sizeof(remote_network_get_dhcp_leases_args),
   (xdrproc_t)xdr_remote_network_get_dhcp_leases_args,
   sizeof(remote_network_get_dhcp_leases_ret),
   (xdrproc_t)xdr_remote_network_get_dhcp_leases_ret,
   true,
   0
},
{ /* Method ConnectGetDomainCapabilities => 342 */
   remoteDispatchConnectGetDomainCapabilitiesHelper,
   sizeof(remote_connect_get_domain_capabilities_args),
   (xdrproc_t)xdr_remote_connect_get_domain_capabilities_args,
   sizeof(remote_connect_get_domain_capabilities_ret),
   (xdrproc_t)xdr_remote_connect_get_domain_capabilities_ret,
   true,
   0
},
{ /* Method DomainOpenGraphicsFd => 343 */
   remoteDispatchDomainOpenGraphicsFdHelper,
   sizeof(remote_domain_open_graphics_fd_args),
   (xdrproc_t)xdr_remote_domain_open_graphics_fd_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectGetAllDomainStats => 344 */
   remoteDispatchConnectGetAllDomainStatsHelper,
   sizeof(remote_connect_get_all_domain_stats_args),
   (xdrproc_t)xdr_remote_connect_get_all_domain_stats_args,
   sizeof(remote_connect_get_all_domain_stats_ret),
   (xdrproc_t)xdr_remote_connect_get_all_domain_stats_ret,
   true,
   0
},
{ /* Method DomainBlockCopy => 345 */
   remoteDispatchDomainBlockCopyHelper,
   sizeof(remote_domain_block_copy_args),
   (xdrproc_t)xdr_remote_domain_block_copy_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackTunable => 346 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method NodeAllocPages => 347 */
   remoteDispatchNodeAllocPagesHelper,
   sizeof(remote_node_alloc_pages_args),
   (xdrproc_t)xdr_remote_node_alloc_pages_args,
   sizeof(remote_node_alloc_pages_ret),
   (xdrproc_t)xdr_remote_node_alloc_pages_ret,
   true,
   0
},
{ /* Async event DomainEventCallbackAgentLifecycle => 348 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetFSInfo => 349 */
   remoteDispatchDomainGetFSInfoHelper,
   sizeof(remote_domain_get_fsinfo_args),
   (xdrproc_t)xdr_remote_domain_get_fsinfo_args,
   sizeof(remote_domain_get_fsinfo_ret),
   (xdrproc_t)xdr_remote_domain_get_fsinfo_ret,
   true,
   0
},
{ /* Method DomainDefineXMLFlags => 350 */
   remoteDispatchDomainDefineXMLFlagsHelper,
   sizeof(remote_domain_define_xml_flags_args),
   (xdrproc_t)xdr_remote_domain_define_xml_flags_args,
   sizeof(remote_domain_define_xml_flags_ret),
   (xdrproc_t)xdr_remote_domain_define_xml_flags_ret,
   true,
   1
},
{ /* Method DomainGetIOThreadInfo => 351 */
   remoteDispatchDomainGetIOThreadInfoHelper,
   sizeof(remote_domain_get_iothread_info_args),
   (xdrproc_t)xdr_remote_domain_get_iothread_info_args,
   sizeof(remote_domain_get_iothread_info_ret),
   (xdrproc_t)xdr_remote_domain_get_iothread_info_ret,
   true,
   0
},
{ /* Method DomainPinIOThread => 352 */
   remoteDispatchDomainPinIOThreadHelper,
   sizeof(remote_domain_pin_iothread_args),
   (xdrproc_t)xdr_remote_domain_pin_iothread_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainInterfaceAddresses => 353 */
   remoteDispatchDomainInterfaceAddressesHelper,
   sizeof(remote_domain_interface_addresses_args),
   (xdrproc_t)xdr_remote_domain_interface_addresses_args,
   sizeof(remote_domain_interface_addresses_ret),
   (xdrproc_t)xdr_remote_domain_interface_addresses_ret,
   true,
   0
},
{ /* Async event DomainEventCallbackDeviceAdded => 354 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainAddIOThread => 355 */
   remoteDispatchDomainAddIOThreadHelper,
   sizeof(remote_domain_add_iothread_args),
   (xdrproc_t)xdr_remote_domain_add_iothread_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainDelIOThread => 356 */
   remoteDispatchDomainDelIOThreadHelper,
   sizeof(remote_domain_del_iothread_args),
   (xdrproc_t)xdr_remote_domain_del_iothread_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetUserPassword => 357 */
   remoteDispatchDomainSetUserPasswordHelper,
   sizeof(remote_domain_set_user_password_args),
   (xdrproc_t)xdr_remote_domain_set_user_password_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainRename => 358 */
   remoteDispatchDomainRenameHelper,
   sizeof(remote_domain_rename_args),
   (xdrproc_t)xdr_remote_domain_rename_args,
   sizeof(remote_domain_rename_ret),
   (xdrproc_t)xdr_remote_domain_rename_ret,
   true,
   0
},
{ /* Async event DomainEventCallbackMigrationIteration => 359 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectRegisterCloseCallback => 360 */
   remoteDispatchConnectRegisterCloseCallbackHelper,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectUnregisterCloseCallback => 361 */
   remoteDispatchConnectUnregisterCloseCallbackHelper,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event ConnectEventConnectionClosed => 362 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackJobCompleted => 363 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainMigrateStartPostCopy => 364 */
   remoteDispatchDomainMigrateStartPostCopyHelper,
   sizeof(remote_domain_migrate_start_post_copy_args),
   (xdrproc_t)xdr_remote_domain_migrate_start_post_copy_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetPerfEvents => 365 */
   remoteDispatchDomainGetPerfEventsHelper,
   sizeof(remote_domain_get_perf_events_args),
   (xdrproc_t)xdr_remote_domain_get_perf_events_args,
   sizeof(remote_domain_get_perf_events_ret),
   (xdrproc_t)xdr_remote_domain_get_perf_events_ret,
   true,
   0
},
{ /* Method DomainSetPerfEvents => 366 */
   remoteDispatchDomainSetPerfEventsHelper,
   sizeof(remote_domain_set_perf_events_args),
   (xdrproc_t)xdr_remote_domain_set_perf_events_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventCallbackDeviceRemovalFailed => 367 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectStoragePoolEventRegisterAny => 368 */
   remoteDispatchConnectStoragePoolEventRegisterAnyHelper,
   sizeof(remote_connect_storage_pool_event_register_any_args),
   (xdrproc_t)xdr_remote_connect_storage_pool_event_register_any_args,
   sizeof(remote_connect_storage_pool_event_register_any_ret),
   (xdrproc_t)xdr_remote_connect_storage_pool_event_register_any_ret,
   true,
   1
},
{ /* Method ConnectStoragePoolEventDeregisterAny => 369 */
   remoteDispatchConnectStoragePoolEventDeregisterAnyHelper,
   sizeof(remote_connect_storage_pool_event_deregister_any_args),
   (xdrproc_t)xdr_remote_connect_storage_pool_event_deregister_any_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Async event StoragePoolEventLifecycle => 370 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainGetGuestVcpus => 371 */
   remoteDispatchDomainGetGuestVcpusHelper,
   sizeof(remote_domain_get_guest_vcpus_args),
   (xdrproc_t)xdr_remote_domain_get_guest_vcpus_args,
   sizeof(remote_domain_get_guest_vcpus_ret),
   (xdrproc_t)xdr_remote_domain_get_guest_vcpus_ret,
   true,
   0
},
{ /* Method DomainSetGuestVcpus => 372 */
   remoteDispatchDomainSetGuestVcpusHelper,
   sizeof(remote_domain_set_guest_vcpus_args),
   (xdrproc_t)xdr_remote_domain_set_guest_vcpus_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event StoragePoolEventRefresh => 373 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectNodeDeviceEventRegisterAny => 374 */
   remoteDispatchConnectNodeDeviceEventRegisterAnyHelper,
   sizeof(remote_connect_node_device_event_register_any_args),
   (xdrproc_t)xdr_remote_connect_node_device_event_register_any_args,
   sizeof(remote_connect_node_device_event_register_any_ret),
   (xdrproc_t)xdr_remote_connect_node_device_event_register_any_ret,
   true,
   1
},
{ /* Method ConnectNodeDeviceEventDeregisterAny => 375 */
   remoteDispatchConnectNodeDeviceEventDeregisterAnyHelper,
   sizeof(remote_connect_node_device_event_deregister_any_args),
   (xdrproc_t)xdr_remote_connect_node_device_event_deregister_any_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Async event NodeDeviceEventLifecycle => 376 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event NodeDeviceEventUpdate => 377 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method StorageVolGetInfoFlags => 378 */
   remoteDispatchStorageVolGetInfoFlagsHelper,
   sizeof(remote_storage_vol_get_info_flags_args),
   (xdrproc_t)xdr_remote_storage_vol_get_info_flags_args,
   sizeof(remote_storage_vol_get_info_flags_ret),
   (xdrproc_t)xdr_remote_storage_vol_get_info_flags_ret,
   true,
   1
},
{ /* Async event DomainEventCallbackMetadataChange => 379 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method ConnectSecretEventRegisterAny => 380 */
   remoteDispatchConnectSecretEventRegisterAnyHelper,
   sizeof(remote_connect_secret_event_register_any_args),
   (xdrproc_t)xdr_remote_connect_secret_event_register_any_args,
   sizeof(remote_connect_secret_event_register_any_ret),
   (xdrproc_t)xdr_remote_connect_secret_event_register_any_ret,
   true,
   1
},
{ /* Method ConnectSecretEventDeregisterAny => 381 */
   remoteDispatchConnectSecretEventDeregisterAnyHelper,
   sizeof(remote_connect_secret_event_deregister_any_args),
   (xdrproc_t)xdr_remote_connect_secret_event_deregister_any_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   1
},
{ /* Async event SecretEventLifecycle => 382 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event SecretEventValueChanged => 383 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetVcpu => 384 */
   remoteDispatchDomainSetVcpuHelper,
   sizeof(remote_domain_set_vcpu_args),
   (xdrproc_t)xdr_remote_domain_set_vcpu_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Async event DomainEventBlockThreshold => 385 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainSetBlockThreshold => 386 */
   remoteDispatchDomainSetBlockThresholdHelper,
   sizeof(remote_domain_set_block_threshold_args),
   (xdrproc_t)xdr_remote_domain_set_block_threshold_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainMigrateGetMaxDowntime => 387 */
   remoteDispatchDomainMigrateGetMaxDowntimeHelper,
   sizeof(remote_domain_migrate_get_max_downtime_args),
   (xdrproc_t)xdr_remote_domain_migrate_get_max_downtime_args,
   sizeof(remote_domain_migrate_get_max_downtime_ret),
   (xdrproc_t)xdr_remote_domain_migrate_get_max_downtime_ret,
   true,
   0
},
{ /* Method DomainManagedSaveGetXMLDesc => 388 */
   remoteDispatchDomainManagedSaveGetXMLDescHelper,
   sizeof(remote_domain_managed_save_get_xml_desc_args),
   (xdrproc_t)xdr_remote_domain_managed_save_get_xml_desc_args,
   sizeof(remote_domain_managed_save_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_domain_managed_save_get_xml_desc_ret,
   true,
   0
},
{ /* Method DomainManagedSaveDefineXML => 389 */
   remoteDispatchDomainManagedSaveDefineXMLHelper,
   sizeof(remote_domain_managed_save_define_xml_args),
   (xdrproc_t)xdr_remote_domain_managed_save_define_xml_args,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
};
size_t remoteNProcs = ARRAY_CARDINALITY(remoteProcs);
