# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import gobject
from xml.dom import minidom
import urllib

from widget.htmlview import get_template

from plugins.lyrics import LyricsPlugin

LEOLYRICS_AUTH = "listen"

class LeoLyricsPlugin( LyricsPlugin):
    server_name="leoslyrics.com"
    PLUGIN_NAME = "leoslyrics.com"
    PLUGIN_DESC = _("Add support of leoslyrics.com website to provide lyrics")
    PLUGIN_VERSION = "0.1"
    PLUGIN_AUTHOR = "mehdi Abaakouk <theli@gmail.com>"
    PLUGIN_WEBSITE = "http://www.listen-project.org"

    def process_lyrics(self,modified_artist,modified_album,modified_title,song):
        url = "http://api.leoslyrics.com/api_search.php?auth=%s&artist=%s&songtitle=%s"%(
                LEOLYRICS_AUTH,
                urllib.quote(modified_artist.encode('utf-8')),
                urllib.quote(modified_title.encode('utf-8')))
        self.download_data(url,self.fetch_lyrics_leolyrics,song)

    def fetch_lyrics_leolyrics(self,html_buffer,song):
        # Leolyrics API reader grab on lyrics.py from quodlibet Copyright 2005 Eduardo Gonzalez, Joe Wreschnig
        self.songlist = []

        try:
            xml = minidom.parse(html_buffer)
            html_buffer.close()
        except Exception:
            self.logexception("Failed fetch_lyrics_part1 xml (traceback):")
            gobject.idle_add(self.render,get_template()%(_("Server did not respond.")))
            return
        
        xmldoc = xml.documentElement
        result_code = xmldoc.getElementsByTagName('response')[0].getAttribute('code')
        #print "Result code: ", result_code
        if result_code == '0': #success
            # This is 0 even if there are no matches.

            # We don't really need the top 100 matches, so I'm limiting it to ten
            matches = xmldoc.getElementsByTagName('result')[:10]
            songs = map(lambda x:
                        x.getElementsByTagName('name')[0].firstChild.nodeValue
                        + " - " +
                        x.getElementsByTagName('title')[0].firstChild.nodeValue,
                        matches)
            hids = map(lambda x: x.getAttribute('hid'), matches)
            exacts = map(lambda x: x.getAttribute('exactMatch'), matches)
            #print "->>"
            #print hids
            #print exacts
            if len(hids) == 0:
                #FIXME show other matches
                gobject.idle_add(self.render,get_template()%(_("Unable to find any matches for this song.")))
                return

            for i in range(len(hids)):
                self.songlist.append((songs[i], hids[i], exacts[i]))

            xmldoc.unlink()
            
            url =  "http://api.leoslyrics.com/api_lyrics.php?auth=%s&hid=%s"%(
                    LEOLYRICS_AUTH,
                    urllib.quote(self.songlist[0][1].encode('utf-8')))
                    
            self.download_data(url,self.fetch_lyrics_leolyrics_part2,song)
        else:
            gobject.idle_add(self.render,get_template()%(_("Unable to find any matches for this song.")))


    def fetch_lyrics_leolyrics_part2(self,html_buffer,song):
        try:
            xml = minidom.parse(html_buffer)
            html_buffer.close()
        except Exception:
            self.logexception("Failed fetch_lyrics_part2 xml (traceback):")
            self.render(_("Server did not respond."))
            return
        
        xmldoc = xml.documentElement
        """
        text = "<h1>"+self.decode(xmldoc.getElementsByTagName('title')[0].firstChild.nodeValue)
        text += ' - ' + self.decode(xmldoc.getElementsByTagName('artist')[0].getElementsByTagName('name')[0].firstChild.nodeValue) +"</h1>"
        text += "<p>&nbsp;</p><p>"+self.decode(xmldoc.getElementsByTagName('text')[0].firstChild.nodeValue).replace("\n","</p><p>")+"</p>"
        """
        text = xmldoc.getElementsByTagName('text')[0].firstChild.nodeValue
        
        self.render(text.replace("\n","<br />"),song,True)
        xmldoc.unlink()
            

